/**
 * Priyanshi Sharma
 */

Ext.define('Academia.view.transport.vehicle.VehiclePermitDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.vehiclepermitdetailwin',
	title: getTransportTranslation('VEHICEL_PERMIT_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
//	maxHeight: 600,
	height: '50%',
	width: '40%',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'vehiclepermitdetailwin',
	    plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		items: [{
            xtype: 'hidden',
            itemId: 'id',
            name: 'id'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'permitNumber',
				itemId:'permitNumber',
				fieldLabel: getTransportTranslation('PERMIT_NUMBER'),
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
			},{
				xtype: 'datefield',
				name:'issueDate',
				itemId:'issueDate',
				fieldLabel: getTransportTranslation('ISSUE_DATE'),
				vtype: 'daterange',
				maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name:'expirationDate',
				itemId:'expirationDate',
				fieldLabel: getTransportTranslation('EXPIRATION_DATE'),
				vtype: 'daterange',
				allowBlank: false,
				minValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'textfield',
				name:'issuedBy',
				itemId:'issuedBy',
				fieldLabel: getTransportTranslation('ISSUED_BY'),
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name:'vehiclePermitDocument',
				itemId:'vehiclePermitDocument',
				fieldLabel: getTransportTranslation('VEHICLE_PERMIT_DOCUMENT'),
				spinUpEnabled : false,
				spinDownEnabled : false,
				allowBlank: false,
				hideTrigger : true,
			},{
                xtype: 'filefield',
                itemId: 'vehiclePermitUploadFile',
                region: 'south',
                ui: 'CustomBtnSubmit',
                fieldLabel: getTransportTranslation('SELECT_FILE'),
                buttonText: getTransportTranslation('UPLOAD'),
                allowBlank: false,
                name: 'file'
            }]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getTransportTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnVehiclePermit',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnVehiclePermit',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});