(function(){
  var tms = {
    getVisitor: function(){
      var visitor = !!window.localStorage ? localStorage.getItem('tms_') : document.cookie.replace(/(?:(?:^|.*;\s*)tms_\s*\=\s*([^;]*).*$)|^.*$/, '$1');
      return visitor || this.setVisitor();
    },
    setVisitor: function(){
      var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c){
        var r = Math.random()*16|0,
              v = c == 'x' ? r : (r&0x3|0x8);
        return v.toString(16);
      });
      if(!!window.localStorage){
        localStorage.setItem('tms_', uuid);
      }
      document.cookie = 'tms_=' + uuid;
      return this.getVisitor();
    }
  };

  var params = [];

  params.push('source=Docs');
  params.push('visitor=' + tms.getVisitor());
  params.push('url=' + encodeURIComponent(location.href));
  params.push('referrer=' + encodeURIComponent(document.referrer));

  var stm = document.createElement('script');
  stm.type = 'text/javascript';
  stm.async = true;
  stm.src = 'http://tms.sencha.com/marketing.js?' + params.join('&');
  var s = document.getElementsByTagName('script')[0];
  s.parentNode.insertBefore(stm, s);
})();
