/**
 * ChartTitle - ExtJS mix-in to render a chart title on the top of a chart *
 */
Ext.define("Ext.chart.ChartTitle", {
    createTitleItem: function() {
        this.chartTitle = new Ext.draw.Sprite({
            type: "text",
            "text-anchor": "middle",
            fill: "black",
            "font-size": "12px",
            "font-weight": "bold",
            "font-family": "Arial",
            text: this.title
        });
     
        this.on("resize", function (cmp, width) {
            this.chartTitle.setAttributes({
                translate: {
                    x: (width/2),
                    y: 5
                }
            }, true);
        });
     
        this.items = this.items || [];
     
        this.items.push(this.chartTitle);
    },
    /*
     * use updateTitle method to dynamically change the title of chart
     * for eg: mychart.updateTitle('New title');
     */
    updateTitle: function(newTitle) {
        this.chartTitle.setAttributes({
            text: newTitle
        }, true);
        /*var me = this,
        titleCmp = me.titleCmp;

        me.title = title;
    	if (titleCmp.rendered) {
        	titleCmp.textEl.update(me.title || '&#160;');
        	titleCmp.updateLayout();
    	} else {
        	me.titleCmp.on({
            	render: function() {
                	me.setTitle(title);
            	},
            	single: true
        	});
    	}*/
    },
    initComponent: function () {
        this.createTitleItem();
    }
});
