/*
 * @author prathamesh.sheth
 * 
 * This class is used for to enable or disable links on applicant profile according to application and admission status.
 *    
 */
Ext.define('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration', {    
	
	extend: 'Ext.app.Controller',
	/*
     * This function is used for to enable or disable links on applicant profile according to its configuration  
     * 
     */
	enableDisableAccorianLinkPanel:function(applicantProfile,isApplicantCreated){
		var me=this;
		if(applicantProfile){
			var applicantPersonDetailsLinkPanel=applicantProfile.down('#applicantPersonDetailsLinkPanel');		
			if(applicantPersonDetailsLinkPanel){								
				if(!isApplicantCreated){										
					me.hideShowLinkPanel(applicantPersonDetailsLinkPanel,true);
					return 0;
				}else{
					me.hideShowLinkPanel(applicantPersonDetailsLinkPanel,false);
					var linkPanelSettingArray=me.checkApplicantProfileMode(applicantProfile);
					return linkPanelSettingArray;
				}				
			}			
		}
		
	},
	
	hideShowLinkPanel:function(applicantPersonDetailsLinkPanel,isDisabled){		
		Ext.each(applicantPersonDetailsLinkPanel.items.items, function(panel) {				
			panel.setDisabled(isDisabled);						        		           	 
		});
	},
	
	/*
     * This function is used for to check mode(edit,view or new application) of applicant profile   
     * 
     */
	checkApplicantProfileMode:function(applicantProfile){		
			var me=this;
			var linkPanelSettingArray=new Object();
			var applicationInfoObject=applicantProfile.getApplicationInfo();
			if(!isEmpty(applicationInfoObject) && (!isNullOrEmpty(applicationInfoObject.applicationStatus) || !isNullOrEmpty(applicationInfoObject.admissionStatus))){
				if(!isEmpty(applicationInfoObject) && applicationInfoObject.isEditMode==true){
					linkPanelSettingArray=me.getLinkPanelSettingObjectToApplicationStatusType(applicationInfoObject);
				}else if(!isEmpty(applicationInfoObject) && applicationInfoObject.isViewMode==true){
					linkPanelSettingArray=me.getLinkPanelSettingObjectToApplicationStatusType(applicationInfoObject);
				}else{
					linkPanelSettingArray=me.getLinkPanelSettingObjectToApplicationStatusType(applicationInfoObject);
				}	
			}else{
				linkPanelSettingArray=me.getLinkPanelSettingObjectToAdmissionType(applicationInfoObject);
			}
			return linkPanelSettingArray;			
	},
	
	/*
     * This function is used for to check admission type and get button panel settings to that admission type 
     * 
     */
	getLinkPanelSettingObjectToAdmissionType:function(applicationInfoObject){
		var me=this;
		var linkPanelSettingArray=new Array();
		if(applicationInfoObject.isDirectAdmission===true){
			linkPanelSettingArray=me.getDirectAdmissionLinkConfiguration();    		
		}else if(applicationInfoObject.isMidTermAdmission===true){
			linkPanelSettingArray=me.getMidTermAdmissionLinkConfiguration();
		}else if(applicationInfoObject.isNewApplication===true){
			linkPanelSettingArray=me.getNewApplicationLinkConfiguration();
		}else if(applicationInfoObject.isFormSoldApplication===true){
			linkPanelSettingArray=me.getFormSoldApplicationLinkConfiguration();
		}
		return linkPanelSettingArray;
	},
	
	
	/*
     * This function is used for to check application status type and get button panel settings to that application status type  
     * 
     */
	getLinkPanelSettingObjectToApplicationStatusType:function(applicationInfoObject){
		var me=this;				
		var linkPanelSettingArray=new Array();
		switch (applicationInfoObject.applicationStatus) {
 		
        case "APPLIED": 
        	linkPanelSettingArray=me.getAllAccessExceptMidTermAdmission_ServiceOPT_CommunitiesOPT_LinkConfiguration();
            break;
            
        case "SOLD":       	 
        	linkPanelSettingArray=me.getAllAccessExceptMidTermAdmission_ServiceOPT_CommunitiesOPT_LinkConfiguration();
            break;
            
        case "SUBMITTED":       	 
        	linkPanelSettingArray=me.getAllAccessExceptMidTermAdmission_ServiceOPT_CommunitiesOPT_LinkConfiguration();
            break;

        case "APPROVED":              
        	linkPanelSettingArray=me.getAllAccessExceptMidTermAdmissionLinkConfiguration();
            break;
            
        case "REJECTED":    
        	linkPanelSettingArray=me.getAllAccessLinkConfiguration();
            break;
            
        case "WITHDRAWED":  
        	linkPanelSettingArray=me.getAllAccessLinkConfiguration();
            break;
            
        case "CLOSED":     
        	linkPanelSettingArray=me.getAllAccessLinkConfiguration();
            break;
            
        case "DIRECT_ADMISSION":             
        	linkPanelSettingArray=me.getDirectAdmissionLinkConfiguration();
            break;
            
        case "MID_TERM_ADMISSION":               
        	linkPanelSettingArray=me.getMidTermAdmissionLinkConfiguration();
            break;
            
        case "DIRECT_SUBMISSION_TOKEN_GENERATED": 
        	linkPanelSettingArray=me.getAllAccessExceptMidTermAdmissionLinkConfiguration();
            break;
            
        case "FORM_SALE_TOKEN_GENERATED": 
        	linkPanelSettingArray=me.getAllAccessExceptMidTermAdmissionLinkConfiguration();
            break;
            
        case "NOT_SUBMITTED": 
        	linkPanelSettingArray=me.getAllAccessLinkConfiguration();
            break;
            
        case "ADMISSION_GRANTED":    
        	linkPanelSettingArray=me.getAllAccessLinkConfiguration();
            break;
            
        default:  
        	linkPanelSettingArray=me.getAllAccessLinkConfiguration();    
                                  
         }		 
		return linkPanelSettingArray;
	},
		
	getAllAccessExceptMidTermAdmissionLinkConfiguration: function() {
    	
    	var linkConfigurationArray = new Array({	        	
				linkXtype: 'personalinformationform',
				isAllowToOpenTab: true	                
            }, {
            	linkXtype: 'addressdetails',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'parentguardiangrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'feepayerdetailgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'siblingdetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'identitydetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'otherinformationdetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'studentconditionsforadmission',
				isAllowToOpenTab: true
            },{
                linkXtype: 'degreeauditreportprofileview',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationdetails',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'referencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'admissionprogramgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'midtermadmission',
				isAllowToOpenTab: false
            },{
              	linkXtype: 'changeprogramgrid',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'educationhistorygrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'workexperiencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'churchinformationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'nonacademicachievementsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'medicalgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'medicaldetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantdetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgridforapplicantfaculty',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'extracurriculargrid',
				isAllowToOpenTab: true
            },{ 
            	linkXtype: 'competitiveexamgrid',
				isAllowToOpenTab: true
            },{
              	linkXtype: 'applicationconditionsforadmission',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'eligibilitydetailsform',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'preadmissionpaymentsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionrefundsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionfeeplansgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'onlinepaymentapplicantstructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'documentsearchpanel',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'serviceoptgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'communityoptgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'cheklistitemgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'receiptgridforapplicant',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'sgapplicantappointmentdetailstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationfollowupstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'communicationhistorystructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'personhostelrequirementform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'socioeconomicinformationform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'postschoolstudiesgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationconditionsreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationdetailschecklistgrid',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationandadmissioncomments',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicantnsfabursarydetailstructure', 
    			isAllowToOpenTab: true  
            },{
            	linkXtype: 'adhocdocumentgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'studentpostinfogrid',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentjointdegreegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentthesistitlegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentjointdegreegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentmougrid',
            	isAllowToOpenTab: true          	
            },{
            	linkXtype: 'functionaryprogressreportgrid',
            	isAllowToOpenTab: true          	
            },{
            	linkXtype: 'studentethicsclearancelettergrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'functionarydetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'nominateexaminersgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'independentnonexaminingchairpersonreportgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'proofofactivitygrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantpassportgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantpermitgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'passportgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'visadetailgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantvisagrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'studenteducationhistorydetailgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicanteducationdetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantlanguageinformationgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantinsurancedetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'nationalservicegrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicanthealthinformationgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'salesforceadmissiondetailsgrid',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationacademictopicStructure',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'transfercreditsstructure',
    			isAllowToOpenTab: true            	
            });
        
        return linkConfigurationArray ;
    },
    
    getAllAccessExceptMidTermAdmission_ServiceOPT_CommunitiesOPT_LinkConfiguration: function() {
    	
    	var linkConfigurationArray = new Array({	        	
				linkXtype: 'personalinformationform',
				isAllowToOpenTab: true	                
            }, {
            	linkXtype: 'addressdetails',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'parentguardiangrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'feepayerdetailgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'siblingdetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'identitydetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'otherinformationdetailsform',
				isAllowToOpenTab: true
            },{
              	linkXtype: 'applicationconditionsforadmission',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'eligibilitydetailsform',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentconditionsforadmission',
				isAllowToOpenTab: true
            },{
                linkXtype: 'degreeauditreportprofileview',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationdetails',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'referencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'admissionprogramgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'midtermadmission',
				isAllowToOpenTab: false
            },{
              	linkXtype: 'changeprogramgrid',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'educationhistorygrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'workexperiencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'churchinformationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'nonacademicachievementsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'medicalgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'medicaldetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantdetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgridforapplicantfaculty',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'extracurriculargrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'competitiveexamgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionpaymentsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionrefundsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionfeeplansgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'onlinepaymentapplicantstructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'documentsearchpanel',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'serviceoptgrid',
				isAllowToOpenTab: false
            },{
            	linkXtype: 'communityoptgrid',
				isAllowToOpenTab: false
            },{
            	linkXtype: 'cheklistitemgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'receiptgridforapplicant',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'sgapplicantappointmentdetailstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationfollowupstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'communicationhistorystructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'personhostelrequirementform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'socioeconomicinformationform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'postschoolstudiesgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationconditionsreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationconditionsreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationandadmissioncomments',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationdetailschecklistgrid',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicantnsfabursarydetailstructure',  
    			isAllowToOpenTab: true  
            },{
            	linkXtype: 'adhocdocumentgrid',
				isAllowToOpenTab: true
            },{
        	linkXtype: 'studentpostinfogrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'studentjointdegreegrid',
        	isAllowToOpenTab: true            	
        },{
        	linkXtype: 'studentthesistitlegrid',
        	isAllowToOpenTab: true            	
        },{
        	linkXtype: 'studentmougrid',
        	isAllowToOpenTab: true          	
        },{
        	linkXtype: 'functionaryprogressreportgrid',
        	isAllowToOpenTab: true          	
        },{
        	linkXtype: 'studentethicsclearancelettergrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'functionarydetailsgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'nominateexaminersgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'independentnonexaminingchairpersonreportgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'proofofactivitygrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicantpassportgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicantpermitgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'passportgrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'visadetailgrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'applicantvisagrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'studenteducationhistorydetailgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicanteducationdetailsgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicantlanguageinformationgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicantinsurancedetailsgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'nationalservicegrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicanthealthinformationgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'salesforceadmissiondetailsgrid',
			isAllowToOpenTab: true            	
        },{
        	linkXtype: 'applicationacademictopicStructure',
			isAllowToOpenTab: true            	
        },{
        	linkXtype: 'transfercreditsstructure',
			isAllowToOpenTab: true            	
        });
        
        return linkConfigurationArray ;
    },
    
    getAllAccessLinkConfiguration: function() {
    	
    	var linkConfigurationArray = new Array({	        	
				linkXtype: 'personalinformationform',
				isAllowToOpenTab: true	                
            }, {
            	linkXtype: 'addressdetails',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'parentguardiangrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'feepayerdetailgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'siblingdetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'identitydetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'otherinformationdetailsform',
				isAllowToOpenTab: true
            },{
              	linkXtype: 'applicationconditionsforadmission',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'eligibilitydetailsform',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentconditionsforadmission',
				isAllowToOpenTab: true
            },{
                linkXtype: 'degreeauditreportprofileview',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationdetails',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'referencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'admissionprogramgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'midtermadmission',
				isAllowToOpenTab: true
            },{
              	linkXtype: 'changeprogramgrid',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'educationhistorygrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'workexperiencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'churchinformationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'nonacademicachievementsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'medicalgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'medicaldetailsform',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'applicantdetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgridforapplicantfaculty',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'extracurriculargrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'competitiveexamgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionpaymentsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionrefundsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionfeeplansgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'onlinepaymentapplicantstructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'documentsearchpanel',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'serviceoptgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'communityoptgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'cheklistitemgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'receiptgridforapplicant',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'sgapplicantappointmentdetailstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationfollowupstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'communicationhistorystructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'personhostelrequirementform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationfollowupstructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'socioeconomicinformationform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'postschoolstudiesgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationconditionsreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationdetailschecklistgrid',
    			isAllowToOpenTab: true     
            },{
            	linkXtype: 'applicationandadmissioncomments',
    			isAllowToOpenTab: true     
            },{
            	linkXtype: 'studentprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicantnsfabursarydetailstructure', 
    			isAllowToOpenTab: true 
            },{
            	linkXtype: 'adhocdocumentgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'studentpostinfogrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'studentjointdegreegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentthesistitlegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentmougrid',
            	isAllowToOpenTab: true          	
            },{
            	linkXtype: 'functionaryprogressreportgrid',
            	isAllowToOpenTab: true          	
            },{
            	linkXtype: 'studentethicsclearancelettergrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'functionarydetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'nominateexaminersgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'independentnonexaminingchairpersonreportgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'proofofactivitygrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantpassportgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantpermitgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'passportgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'visadetailgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantvisagrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'studenteducationhistorydetailgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicanteducationdetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantlanguageinformationgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantinsurancedetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'nationalservicegrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicanthealthinformationgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'salesforceadmissiondetailsgrid',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationacademictopicStructure',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'transfercreditsstructure',
    			isAllowToOpenTab: true            	
            });
        
        return linkConfigurationArray ;
    },
    
    getAllAccessExcept_MidTermAdmission_ApplicationDetails_LinkConfiguration: function() {
    	
    	var linkConfigurationArray = new Array({	        	
				linkXtype: 'personalinformationform',
				isAllowToOpenTab: true	                
            }, {
            	linkXtype: 'addressdetails',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'parentguardiangrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'feepayerdetailgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'siblingdetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'identitydetailsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'otherinformationdetailsform',
				isAllowToOpenTab: true
            },{
              	linkXtype: 'applicationconditionsforadmission',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'eligibilitydetailsform',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentconditionsforadmission',
				isAllowToOpenTab: true
            },{
                linkXtype: 'degreeauditreportprofileview',
    			isAllowToOpenTab: true
            },
            {
            	linkXtype: 'applicationdetails',
				isAllowToOpenTab: false
            },{
            	linkXtype: 'referencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'admissionprogramgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'midtermadmission',
				isAllowToOpenTab: false
            },{
              	linkXtype: 'changeprogramgrid',
    			isAllowToOpenTab: true
            },{
            	linkXtype: 'educationhistorygrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'workexperiencegrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'churchinformationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'nonacademicachievementsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'medicalgrid',
				isAllowToOpenTab: true
            }, {
            	linkXtype: 'medicaldetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantdetailsform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'vaccinationgridforapplicantfaculty',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'extracurriculargrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'competitiveexamgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionpaymentsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionrefundsgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'preadmissionfeeplansgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'onlinepaymentapplicantstructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'documentsearchpanel',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'serviceoptgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'communityoptgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'cheklistitemgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'receiptgridforapplicant',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'sgapplicantappointmentdetailstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationfollowupstructure',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'communicationhistorystructure',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'socioeconomicinformationform',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'postschoolstudiesgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicationconditionsreviewdetails',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationdetailschecklistgrid',
    			isAllowToOpenTab: true   
            },{
            	linkXtype: 'applicationandadmissioncomments',
    			isAllowToOpenTab: true   
            },{
            	linkXtype: 'studentprogramwiseconditionsforadmission',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicantnsfabursarydetailstructure', 
    			isAllowToOpenTab: true  
            },{
            	linkXtype: 'adhocdocumentgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'studentpostinfogrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'studentjointdegreegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentthesistitlegrid',
            	isAllowToOpenTab: true            	
            },{
            	linkXtype: 'studentmougrid',
            	isAllowToOpenTab: true          	
            },{
            	linkXtype: 'functionaryprogressreportgrid',
            	isAllowToOpenTab: true          	
            },{
            	linkXtype: 'studentethicsclearancelettergrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'functionarydetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'nominateexaminersgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'independentnonexaminingchairpersonreportgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'proofofactivitygrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantpassportgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantpermitgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'passportgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'visadetailgrid',
				isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantvisagrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'studenteducationhistorydetailgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicanteducationdetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantlanguageinformationgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicantinsurancedetailsgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'nationalservicegrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'applicanthealthinformationgrid',
            	isAllowToOpenTab: true
            },{
            	linkXtype: 'salesforceadmissiondetailsgrid',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'applicationacademictopicStructure',
    			isAllowToOpenTab: true            	
            },{
            	linkXtype: 'transfercreditsstructure',
    			isAllowToOpenTab: true            	
            });
        
        return linkConfigurationArray ;
    },
    
       getDirectAdmissionLinkConfiguration: function() {
	    	
	    	var linkConfigurationArray = new Array({	        	
					linkXtype: 'personalinformationform',
					isAllowToOpenTab: true	                
	            }, {
	            	linkXtype: 'addressdetails',
					isAllowToOpenTab: true
	            }, {
	            	linkXtype: 'parentguardiangrid',
					isAllowToOpenTab: true
	            }, {
	            	linkXtype: 'feepayerdetailgrid',
					isAllowToOpenTab: true
	            }, {
	            	linkXtype: 'siblingdetailsgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'identitydetailsgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'otherinformationdetailsform',
					isAllowToOpenTab: true
	            },{
	              	linkXtype: 'applicationconditionsforadmission',
	    			isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicationreviewdetails',
	    			isAllowToOpenTab: true            	
	            },{
            		linkXtype: 'eligibilitydetailsform',
    				isAllowToOpenTab: true            	
            	},{
	            	linkXtype: 'studentconditionsforadmission',
					isAllowToOpenTab: true
	            },{
	                linkXtype: 'degreeauditreportprofileview',
	    			isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicationdetails',
					isAllowToOpenTab: false
	            },{
	            	linkXtype: 'referencegrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'admissionprogramgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'midtermadmission',
					isAllowToOpenTab: false
	            },{
	              	linkXtype: 'changeprogramgrid',
	    			isAllowToOpenTab: true
	            },{
	            	linkXtype: 'educationhistorygrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'workexperiencegrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'churchinformationgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'nonacademicachievementsgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'medicalgrid',
					isAllowToOpenTab: true
	            }, {
	            	linkXtype: 'medicaldetailsform',
					isAllowToOpenTab: true
	            }, {
	            	linkXtype: 'applicantdetailsform',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'vaccinationgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'vaccinationgridforapplicantfaculty',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'extracurriculargrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'competitiveexamgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'preadmissionpaymentsgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'preadmissionrefundsgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'preadmissionfeeplansgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'onlinepaymentapplicantstructure',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'documentsearchpanel',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'serviceoptgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'communityoptgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'cheklistitemgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'receiptgridforapplicant',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'sgapplicantappointmentdetailstructure',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicationfollowupstructure',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'communicationhistorystructure',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'personhostelrequirementform',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'socioeconomicinformationform',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'postschoolstudiesgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicationconditionsreviewdetails',
	    			isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'applicationprogramwiseconditionsforadmission',
	    			isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'applicationdetailschecklistgrid',
	    			isAllowToOpenTab: true     
	            },{
	            	linkXtype: 'applicationandadmissioncomments',
	    			isAllowToOpenTab: true     
	            },{
	            	linkXtype: 'studentprogramwiseconditionsforadmission',
	    			isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'applicantnsfabursarydetailstructure',  
	    			isAllowToOpenTab: true  
	            },{
	            	linkXtype: 'adhocdocumentgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'studentpostinfogrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'studentjointdegreegrid',
	            	isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'studentthesistitlegrid',
	            	isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'studentmougrid',
	            	isAllowToOpenTab: true          	
	            },{
	            	linkXtype: 'functionaryprogressreportgrid',
	            	isAllowToOpenTab: true          	
	            },{
	            	linkXtype: 'studentethicsclearancelettergrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'functionarydetailsgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'nominateexaminersgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'independentnonexaminingchairpersonreportgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'proofofactivitygrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicantpassportgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicantpermitgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'passportgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'visadetailgrid',
					isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicantvisagrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'studenteducationhistorydetailgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicanteducationdetailsgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicantlanguageinformationgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicantinsurancedetailsgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'nationalservicegrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'applicanthealthinformationgrid',
	            	isAllowToOpenTab: true
	            },{
	            	linkXtype: 'salesforceadmissiondetailsgrid',
	    			isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'applicationacademictopicStructure',
	    			isAllowToOpenTab: true            	
	            },{
	            	linkXtype: 'transfercreditsstructure',
	    			isAllowToOpenTab: true            	
	            });
	        
	        return linkConfigurationArray ;
	    },

	 getMidTermAdmissionLinkConfiguration: function() {
		 
		 var linkConfigurationArray = new Array({	        	
				linkXtype: 'personalinformationform',
				isAllowToOpenTab: true	                
         }, {
         	linkXtype: 'addressdetails',
				isAllowToOpenTab: true
         }, {
         	linkXtype: 'parentguardiangrid',
				isAllowToOpenTab: true
         }, {
         	linkXtype: 'feepayerdetailgrid',
			isAllowToOpenTab: true
        }, {
         	linkXtype: 'siblingdetailsgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'applicationdetails',
				isAllowToOpenTab: false
         },{
         	linkXtype: 'referencegrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'admissionprogramgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'midtermadmission',
				isAllowToOpenTab: true
         },{
          	linkXtype: 'changeprogramgrid',
			isAllowToOpenTab: true
         },{
         	linkXtype: 'educationhistorygrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'workexperiencegrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'churchinformationgrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'nonacademicachievementsgrid',
			isAllowToOpenTab: true
        },{
         	linkXtype: 'medicalgrid',
				isAllowToOpenTab: true
         }, {
         	linkXtype: 'medicaldetailsform',
			isAllowToOpenTab: true
        },{
         	linkXtype: 'applicantdetailsform',
			isAllowToOpenTab: true
        },{
         	linkXtype: 'vaccinationgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'vaccinationgridforapplicantfaculty',
			isAllowToOpenTab: true
        },{
         	linkXtype: 'extracurriculargrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'competitiveexamgrid',
			isAllowToOpenTab: true
         },{
         	linkXtype: 'preadmissionpaymentsgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'preadmissionrefundsgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'preadmissionfeeplansgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'onlinepaymentapplicantstructure',
			isAllowToOpenTab: true
        },{
         	linkXtype: 'documentsearchpanel',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'serviceoptgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'communityoptgrid',
				isAllowToOpenTab: true
         },{
         	linkXtype: 'cheklistitemgrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'receiptgridforapplicant',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'sgapplicantappointmentdetailstructure',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicationfollowupstructure',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'communicationhistorystructure',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'personhostelrequirementform',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'socioeconomicinformationform',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'postschoolstudiesgrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'applicantnsfabursarydetailstructure',  
			isAllowToOpenTab: true  
        },{
        	linkXtype: 'adhocdocumentgrid',
			isAllowToOpenTab: true
        },{
        	linkXtype: 'applicanteducationdetailsgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'applicanthealthinformationgrid',
        	isAllowToOpenTab: true
        },{
        	linkXtype: 'salesforceadmissiondetailsgrid',
			isAllowToOpenTab: true            	
        },{
        	linkXtype: 'applicationacademictopicStructure',
			isAllowToOpenTab: true            	
        },{
        	linkXtype: 'transfercreditsstructure',
			isAllowToOpenTab: true            	
        });
     
     return linkConfigurationArray ;
    },
    
    getNewApplicationLinkConfiguration: function() {
    	
     var linkConfigurationArray = new Array({	        	
			linkXtype: 'personalinformationform',
			isAllowToOpenTab: true	                
     }, {
     	linkXtype: 'addressdetails',
			isAllowToOpenTab: true
     }, {
     	linkXtype: 'parentguardiangrid',
			isAllowToOpenTab: true
     }, {
     	linkXtype: 'feepayerdetailgrid',
		isAllowToOpenTab: true
    }, {
     	linkXtype: 'siblingdetailsgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'applicationdetails',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'referencegrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'admissionprogramgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'midtermadmission',
			isAllowToOpenTab: false
     },{
       	linkXtype: 'changeprogramgrid',
		isAllowToOpenTab: true
     },{
     	linkXtype: 'educationhistorygrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'workexperiencegrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'churchinformationgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'nonacademicachievementsgrid',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'medicalgrid',
			isAllowToOpenTab: true
     }, {
     	linkXtype: 'medicaldetailsform',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'applicantdetailsform',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'vaccinationgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'vaccinationgridforapplicantfaculty',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'extracurriculargrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'competitiveexamgrid',
		isAllowToOpenTab: true
     },{
     	linkXtype: 'preadmissionpaymentsgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'preadmissionrefundsgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'preadmissionfeeplansgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'onlinepaymentapplicantstructure',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'documentsearchpanel',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'serviceoptgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'communityoptgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'cheklistitemgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'receiptgridforapplicant',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'sgapplicantappointmentdetailstructure',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'applicationfollowupstructure',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'communicationhistorystructure',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'socioeconomicinformationform',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'postschoolstudiesgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'applicantnsfabursarydetailstructure', 
		isAllowToOpenTab: true   
    },{
    	linkXtype: 'adhocdocumentgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'applicanteducationdetailsgrid',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'applicanthealthinformationgrid',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'salesforceadmissiondetailsgrid',
		isAllowToOpenTab: true            	
    },{
    	linkXtype: 'applicationacademictopicStructure',
		isAllowToOpenTab: true            	
    },{
    	linkXtype: 'transfercreditsstructure',
		isAllowToOpenTab: true            	
    });
 
     return linkConfigurationArray ;
    },
    
   getFormSoldApplicationLinkConfiguration:function() {
    
    var linkConfigurationArray = new Array({	        	
			linkXtype: 'personalinformationform',
			isAllowToOpenTab: true	                
     }, {
     	linkXtype: 'addressdetails',
			isAllowToOpenTab: true
     }, {
     	linkXtype: 'parentguardiangrid',
			isAllowToOpenTab: true
     }, {
     	linkXtype: 'feepayerdetailgrid',
		isAllowToOpenTab: true
    }, {
     	linkXtype: 'siblingdetailsgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'applicationdetails',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'referencegrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'admissionprogramgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'midtermadmission',
			isAllowToOpenTab: false
     },{
       	linkXtype: 'changeprogramgrid',
		isAllowToOpenTab: true
     },{
     	linkXtype: 'educationhistorygrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'workexperiencegrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'churchinformationgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'nonacademicachievementsgrid',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'medicalgrid',
			isAllowToOpenTab: true
     }, {
     	linkXtype: 'medicaldetailsform',
		isAllowToOpenTab: true
    }, {
     	linkXtype: 'applicantdetailsform',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'vaccinationgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'vaccinationgridforapplicantfaculty',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'extracurriculargrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'competitiveexamgrid',
		isAllowToOpenTab: true
    },{
     	linkXtype: 'preadmissionpaymentsgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'preadmissionrefundsgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'preadmissionfeeplansgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'onlinepaymentapplicantstructure',
		isAllowToOpenTab: true
     },{
     	linkXtype: 'documentsearchpanel',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'serviceoptgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'communityoptgrid',
			isAllowToOpenTab: true
     },{
     	linkXtype: 'cheklistitemgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'receiptgridforapplicant',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'sgapplicantappointmentdetailstructure',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'applicationfollowupstructure',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'communicationhistorystructure',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'socioeconomicinformationform',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'facultynonacademicachievementsgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'postschoolstudiesgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'applicantnsfabursarydetailstructure',  
		isAllowToOpenTab: true    
    },{
    	linkXtype: 'adhocdocumentgrid',
		isAllowToOpenTab: true
    },{
    	linkXtype: 'applicanteducationdetailsgrid',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'applicanthealthinformationgrid',
    	isAllowToOpenTab: true
    },{
    	linkXtype: 'salesforceadmissiondetailsgrid',
		isAllowToOpenTab: true            	
    },{
    	linkXtype: 'applicationacademictopicStructure',
		isAllowToOpenTab: true            	
    },{
    	linkXtype: 'transfercreditsstructure',
		isAllowToOpenTab: true            	
    });
 
     return linkConfigurationArray ;       
    }
});