/**
 * 
 * This controller is used for applicant service details
 *  1.Communities Opt In/ Opt Out
 *  2.Service Opt In/ Opt Out
 *  
 */
Ext.define('Academia.controller.admission.applications.applicantService.ApplicantServiceController', {
	
    extend: 'Academia.controller.personinfo.common.PersonServiceController',

    alias: "widget.applicantservicecontroller",

    views : ['admission.applications.applicantservice.ChekListItemGrid','admission.applications.applicantservice.ApplicantCheckListItemWindow'],
    
    stores : ['admission.applications.applicantservice.ApplicantChekLists'],
    mixins: {
		ApplicationBaseController:'Academia.controller.admission.applications.applicationBase.ApplicationBaseController'
    },

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'serviceOptForm',
        selector: 'serviceoptform[itemId=applicantServiceOptForm]'

    }, {
        ref: 'communityOptForm',
        selector: 'communityoptform[itemId=applicantCommunityOptForm]'

    },{
    	ref :'applicantCheckListItemWindow',
    	selector : 'applicantchecklistitemwindow'
    }],
    config: {
    	APPLICATION_SERVICEOPTIN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_SERVICEOPTIN_PRIVILEGES'),
    	APPLICATION_COMMUNITIESOPTIN_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_COMMUNITIESOPTIN_PRIVILEGES'),
    	//APPLICATION_CHECKlISTITEMS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_CHECKlISTITEMS_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	        	
        	/**
        	 * Communities Opt In/ Opt Out Details
        	 */
            
            'communityoptgrid[itemId=applicantCommunityOptGrid]': {
                render: function(grid) {                	                	
            		this.loadGridStore('#applicantCommunityOptGrid', SERVERURL.APPLICANT_PERSON_COMMUNITY_OPT_GRIDDATA);
            		this.doAccessControlValidation(grid, this.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS());
            		this.showContainerInViewMode(grid);  
            		var applicantProfile = this.getContentPanelActiveTab();
            		if (applicantProfile) {
            			try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = this.getContentPanel().items.items[0];
                    	}
            			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if((applicantProfile.getApplicationInfo()['admissionStatus']=='ADMISSION_IN_PROGRESS') 
                    				&& (applicantProfile.getApplicationInfo()['programStatus'] == 'OFFER_LETTER_ACCEPTED')){
                    			this.doAccessControlValidation(grid, this.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS());
                    		}
                    		if((applicantProfile.getApplicationInfo()['applicationStatus'] == 'MID_TERM_ADMISSION') 
                    				|| (applicantProfile.getApplicationInfo()['applicationStatus'] == 'DIRECT_ADMISSION')){
                    			this.doAccessControlValidation(grid, this.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS());
                    		}
                    	}
                    }    
                }
            },
            'communityoptform[itemId=applicantCommunityOptForm]': {
                render: function(form) {                	                	
            		if(form){
            			var optOutRadioBtn=form.down("#optOutRadioBtn");
            			optOutRadioBtn.setDisabled(true);
            			var pbsId=[];
                    	
                    	var applicantProfile; 
            			//optOutRadioBtn.setVisible(false);
                    	var portalId = this.getCurrentLoggedPortalId();
                    	if(portalId==6)
                    		{
                    		applicantProfile = this.getContentPanel().items.items[0];
                    		} else
                    		{
                    		 applicantProfile = this.getContentPanelActiveTab(); 
                    		}
                        		
                    	var data=applicantProfile.applicationDataObject.applicationPrograms;
                    	for(i=0;i<data.length;i++)
                		{
                    		pbsId.push(data[i].progBatchSeatConfigId);
                    	}
                    	var communityStore = form.getForm().findField('community').getStore();
                    	communityStore.getProxy().extraParams = {
                    		pbsIds : pbsId.join(','),
						};
            		}
                }
            },
            'communityoptgrid[itemId=applicantCommunityOptGrid] button[itemId=btnAdd]': {
                click:function(){
                	this.showPersonCommonWindow('COMMUNITIES', 'applicantCommunityOptForm');
                }             	
            },
            'communityoptgrid[itemId=applicantCommunityOptGrid] button[itemId=btnEdit]': {
                click: function(){                	
                	this.editCommunityOptFormWindow('COMMUNITIES', 'applicantCommunityOptForm', '#applicantCommunityOptGrid',getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'));                	                	
                }
            },
            'communityoptgrid[itemId=applicantCommunityOptGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewCommunityOptFormWindow('COMMUNITIES', 'applicantCommunityOptForm', '#applicantCommunityOptGrid',getPersonModuleTranslation('COMMUNITY_OPT_IN_OUT'));
                }
            },
            'communityoptgrid[itemId=applicantCommunityOptGrid] button[itemId=btnDelete]': {
                click: function(){                	            		                 	 
                    this.deleteCommunityOptRecord('#applicantCommunityOptGrid', SERVERURL.APPLICANT_COMMUNITY_OPT_DELETE);
                } 
            },
            'communityoptform[itemId=applicantCommunityOptForm] button[itemId=submitButtonId]': {
                click:function(){
                	this.saveCommunityOpt('#applicantCommunityOptGrid', SERVERURL.APPLICANT_COMMUNITY_OPT_ADD, SERVERURL.APPLICANT_COMMUNITY_OPT_UPDATE);
                } 
            },
            'communityoptform[itemId=applicantCommunityOptForm] button[itemId=communityOptCancelButtonId]': {
                click: function(){
                	this.closePersonCommonWindow();
                } 
            },
            	
        	/**
             *  Service Opt In/ Opt Out
             */

            'serviceoptgrid[itemId=applicantServiceOptGrid]': {
                render: function(grid) {
                	this.loadGridStore('#applicantServiceOptGrid', SERVERURL.APPLICANT_PERSON_SERVICE_OPT_GRIDDATA);
                	this.doAccessControlValidation(grid, this.getAPPLICATION_SERVICEOPTIN_PERMISSIONS());
                	this.showContainerInViewMode(grid);
                	var applicantProfile = this.getContentPanelActiveTab();
            		if (applicantProfile) {
            			try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = this.getContentPanel().items.items[0];
                    	}
            			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if((applicantProfile.getApplicationInfo()['admissionStatus']=='ADMISSION_IN_PROGRESS') 
                    				&& (applicantProfile.getApplicationInfo()['programStatus'] == 'OFFER_LETTER_ACCEPTED')){
                    			this.doAccessControlValidation(grid, this.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS());
                    		}
                    		if((applicantProfile.getApplicationInfo()['applicationStatus'] == 'MID_TERM_ADMISSION') 
                    				|| (applicantProfile.getApplicationInfo()['applicationStatus'] == 'DIRECT_ADMISSION')){
                    			this.doAccessControlValidation(grid, this.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS());
                    		}
                    	}
                    }
                }
            },
            'serviceoptform[itemId=applicantServiceOptForm]': {
            	afterrender: function(form) {                	                	
            		if(form){
            			//var optOutRadioBtn=form.down("#optOutRadioBtn");
            			//optOutRadioBtn.setDisabled(true);
            			//optOutRadioBtn.setVisible(false);
            			/**
            			 * Type of service its is "APPLICANT".
            			 */
            			var billedUserTypeHiddenField=form.down("#billedUserTypeHiddenField");
            			billedUserTypeHiddenField.setValue("APPLICANT");
            			/**
            			 * Hide fields in the case of APPLICANT service opt in and opt out.
            			 */
            			form.down("#feePlanComboField").disable();
            			form.down("#feePlanComboField").setVisible(false);
            			form.down("#feePlanComboField").allowBlank=false;
            			
            			form.down("#feePlanRuleComboField").disable();
            			form.down("#feePlanRuleComboField").setVisible(false);
            			form.down("#feePlanRuleComboField").allowBlank=false;
            			
            			form.down("#feePlanRuleStageComboField").disable();
            			form.down("#feePlanRuleStageComboField").setVisible(false);
            			form.down("#feePlanRuleStageComboField").allowBlank=false;
            			
            			form.down("#amountPaidComboField").disable();
            			form.down("#amountPaidComboField").setVisible(false);
            			form.down("#amountPaidComboField").allowBlank=false;
            		}
                }
            },
            'serviceoptgrid[itemId=applicantServiceOptGrid] button[itemId=btnAdd]': {
                click:function(){
                	this.showPersonCommonWindow('SERVICES_OPT_IN_OUT', 'applicantServiceOptForm');
                }	
            },
            'serviceoptgrid[itemId=applicantServiceOptGrid] button[itemId=btnEdit]': {
                click: function(){
                	this.editServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'applicantServiceOptForm', '#applicantServiceOptGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));                	
                }
            },
            'serviceoptgrid[itemId=applicantServiceOptGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewServiceOptFormWindow('SERVICES_OPT_IN_OUT', 'applicantServiceOptForm', '#applicantServiceOptGrid',getPersonModuleTranslation('SERVICES_OPT_IN_OUT'));
                }
            },
            'serviceoptgrid[itemId=applicantServiceOptGrid] button[itemId=btnDelete]': {
            	click:function(){            		        		 
                    this.deleteServiceOptRecord('#applicantServiceOptGrid', SERVERURL.APPLICANT_SERVICE_OPT_DELETE);
                } 
            },
            /**
             * This functionality is not required.
             */
            /*'serviceoptform[itemId=applicantServiceOptForm] nestedJsonCombo[itemId=serviceNameComboField]': {
                change: function(combo, record, index){
                	this.getFeePlanForSelectedService(combo, SERVERURL.GET_FEE_PLAN_ON_SELECTION_SERVICE);
                } 
            },*/
            
            
            'serviceoptform[itemId=applicantServiceOptForm] nestedJsonCombo[itemId=serviceNameComboField]': {
                render: function(obj){
                	var applicantProfile = this.getContentPanelActiveTab();
            		if (applicantProfile) {
            			try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = this.getContentPanel().items.items[0];
                    	}
            		}
            		
            		if(!isNullOrEmpty(applicantProfile) && !isNullOrEmpty(applicantProfile.applicationDataObject)  && !isNullOrEmpty(applicantProfile.applicationDataObject.id)){
            		var submitUrl = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_TAB_GRID_DATA+"?applicationID="+applicantProfile.applicationDataObject.id;
            		var progBatchSeatTypeIds = [];
            		if (!isNullOrEmpty(submitUrl)) {
            			var progBatchSeatTypeIds = [];
            			if (!isNullOrEmpty(submitUrl)) {
            			  Ext.Ajax.request({
            				  type: 'rest',
            				  url: submitUrl,
            				  method: 'GET',
            					  success: function(success) {
            						var data = Ext.decode(success.responseText);
            						for(var i = 0; i<data.length;i++) {
            							progBatchSeatTypeIds.push(data[i].programBatchSeatConfigurationId);
            						}
            						obj.getStore().on('beforeload', function(store, operation){
                                		if(!isNullOrEmpty(progBatchSeatTypeIds)){
                                			store.proxy.extraParams = {
                                    				progBatchSeatTypeIds: progBatchSeatTypeIds.toString()
                                                };
                                		}
                                	});
            					  }
            				  });
            			  }
            		}  
                  }
                }
            },
            
            'serviceoptform[itemId=applicantServiceOptForm] button[itemId=submitButtonId]': {
            	click:function(){            		 
            		this.saveServiceOpt('#applicantServiceOptGrid', SERVERURL.APPLICANT_SERVICE_OPT_ADD, SERVERURL.APPLICANT_SERVICE_OPT_UPDATE);
                } 
            },
            'serviceoptform[itemId=applicantServiceOptForm] button[itemId=cancelButtonId]': {
            	click:function(){
            		this.closePersonCommonWindow();
                }
            },
            
            'cheklistitemgrid[itemId=applicantCheckListGrid]':{
            	render : function(grid){
            		var me = this;                                        
                    var applicantProfile = me.getContentPanelActiveTab();
                    try{
                		applicantProfile.getApplicationId();
                	} catch(e){
                		applicantProfile = this.getContentPanel().items.items[0];
                	}
                    if(!isNullOrEmpty(applicantProfile.getApplicationId())){
            			var paramObject = {
            				applicationID: applicantProfile.getApplicationId()
                        };
                        grid.getStore().load({
                        	params:paramObject
                        });               		                             
            	}
            }
            },
            
            'cheklistitemgrid[itemId=applicantCheckListGrid] button[itemId=btnApplication]' :{
            	click : this.showCheckListPopUp
            },
            
            'cheklistitemgrid[itemId=applicantCheckListGrid] button[itemId=btnAdmission]' :{
            	click : this.showCheckListPopUp
            }
        });
        this.callParent(arguments); 
    },
    
    /**
     *  To display container in view only mode
     */
    showContainerInViewMode: function(container) {
    	var me = this;
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e){
        		applicantProfile = this.getContentPanel().items.items[0];
        	}
        	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        		if(applicantProfile.getApplicationInfo()['isViewMode'] 
        		|| ((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                   (applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                   (applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                   (applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                   (applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION'))		
        		){
            		me.mixins.ApplicationBaseController.setContainerInViewMode(container);
            	}        		
        	}
        }    
   },
   
   /**
    * This is used to show checkList of application or admission
    */
   showCheckListPopUp : function(btn){
		var grid = btn.up('grid');
		var transactionTypeId = null;
    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
    	if(grid.getSelectionModel().getCount() > 0){
    		var programBatchSeatConfigurationId = selectedRecord.get('programBatchSeatConfigurationId');
    		var popup = Ext.widget('applicantchecklistitemwindow');
    		popup.show();
	    	
	    	if(btn.itemId === 'btnApplication'){
       			 transactionTypeId = 7 ;
       			 popup.setTitle(getCommonTranslation('APPLICATION_CHECKLIST'));
	    	}else{
       			 transactionTypeId = 6 ;
       			 popup.setTitle(getCommonTranslation('ADMISSION_CHECKLIST'));
	    	}
	    	
	    	popup.down('#academyId').setValue(selectedRecord.data.academy.value);
	    	popup.down('#locationId').setValue(selectedRecord.data.location.value);
	    	popup.down('#programId').setValue(selectedRecord.data.program.value);
	    	popup.down('#batchId').setValue(selectedRecord.data.batch.value);
	    	popup.down('#seatTypId').setValue(selectedRecord.data.seatType.value);
	    	
	    	templateContainer = popup.down('dataview#checklistTemplateId');
	    	var store = templateContainer.getStore();
	    	
	    	var url = store.getProxy().proxyConfig.api.read;
	    	url = url.concat('?progBatchConfigId='+programBatchSeatConfigurationId);
	    	url = url.concat('&transactionTypeId='+transactionTypeId);
	    	store.getProxy().api.read = url;
	    	store.load();  
	    	
	    	
    	    
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
   }
});
