/**
 * @author sachin.bangar
 * This controller is used for applicant personal information (Personal Details, Address, Parent-Guardians and Siblings )
 */
Ext.define('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController', {
    extend: 'Academia.controller.personinfo.common.PersonInfoController',
    
    mixins: { 		
    		ApplicationBaseController:'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
    		ButtonPanelConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration',
    		PersonDetailsLinkPanel:'Academia.view.personinfo.common.PersonDetailsLinkPanel',
    		LinkPanelConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
    		ApplicantPortalSetupController : 'Academia.controller.admission.applicantPortalSetup.ApplicantPortalSetupController'
    },
    stores:['servicerequest.servicerequestsettings.AssigneeApproverHostelLocationWiseStore'],
    models:['Academia.model.admission.applications.applicantinfo.ApplicationEntityDataModel'],
    
    alias: "widget.applicantpersonalcontroller",

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personalInformationForm',
        selector: 'personalinformationform[itemId=applicantPersonalInformationForm]'
    }, {
        ref: 'personAddressDetails',
        selector: 'addressdetails[itemId=applicantAddressDetails]'
    }, {
        ref: 'personAddressFormWindow',
        selector: 'addressformwindow'
    }, {
        ref: 'personAddressFieldsForm',
        selector: 'addressfieldsform[itemId=personAddressFieldsForm]'
    }, {
        ref: 'personParentGuardianForm',
        selector: 'parentguardianform[itemId=applicantParentGuardianForm]'
    }, {
        ref: 'personSiblingForm',
        selector: 'siblingform[itemId=applicantSiblingForm]'
    },{
    	ref:'photoUploadForm',
    	selector: 'personalinformationform[itemId=applicantPersonalInformationForm] photouploadform[itemId=applicantPhotoUploadForm]'
    },{
    	ref: 'userInfo',
        selector: 'userinfo'
    },{
        ref: 'personIdentityDetailsForm',
        selector: 'identitydetailsform[itemId=applicantIdentityDetailsForm]'
    },{
        ref: 'personOtherinformationdetailsform',
        selector: 'otherinformationdetailsform[itemId=applicantOtherinformationDetailsForm]'
    }, {
        ref: 'personFeePayerDetailForm',
        selector: 'feepayerdetailform[itemId=applicantfeepayerdetailformItemId]'
    }, {
        ref: 'applicantFeePayerDetailGrid',
        selector: 'feepayerdetailgrid[itemId=applicantFeePayerDetailGridItemId]'
    }, {
        ref: 'applicantfeepayerdetaildocumentwin',
        selector: 'feepayerdetaildocumentwin'
    }, {
        ref: 'applicantfeepayerdetaildocumentgrid',
        selector: 'feepayerdetaildocumentgrid'
    },{
 	   ref : 'applicantIdVerificationDetailWin',
 	   selector : 'idverificationdetailwin [itemId=applicantIdVerificationDetailWinItemId]'
    }, {
        ref: 'personhostelrequirementform',
        selector: 'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm]'
    },{
    	ref:'BursaryApplicationStatus',
    	selector:'bursaryapplicationstatus'
    },{
    	ref:'BursaryApplicationDetails',
    	selector:'bursaryapplicationdetails'
    },{
    	ref:'BursaryFunddingDetails',
    	selector:'bursaryfunddingdetails'
    },{
		ref: 'applicantpassportgrid',
    	selector: 'applicantpassportgrid[itemId=applicantpassportgridId]'
    }, {
		 ref: 'studentpassportdetailsform',
		 selector: 'studentpassportdetailsform[itemId=applicantPassportDetailsFormId]'
    }, {
		 ref: 'applicantpassportdocumentgrid',
		 selector: 'applicantpassportdocumentgrid'
	}, {
		 ref: 'applicantpassportdocumentlist',
		 selector: 'applicantpassportdocumentlist'
	}, {
		 ref: 'applicantpassportdocumentlistgrid',
		 selector: 'applicantpassportdocumentlistgrid'
	},{
		 ref: 'applicantpassporturlgrid',
		 selector: 'applicantpassporturlgrid'
	 },{
		 ref: 'applicantpassportdocurllist',
		 selector: 'applicantpassportdocurllist'
	 }, {
		 ref: 'applicantpassportdocurllistgrid',
		 selector: 'applicantpassportdocurllistgrid'
	 },{
	     ref: 'documentformwindow',
	     selector: 'documentformwindow'
	  },{
		 ref: 'applicantvisagrid',
		 selector: 'applicantvisagrid[itemId=applicantvisagridId]'
	},{
		 ref: 'visaform',
		 selector: 'visaform[itemId=applicantvisaformId]'
	},
	
	{
		 ref: 'insuranceform',
		 selector: 'insuranceform[itemId=applicantinsuranceformId]'
	},
	{
		 ref: 'applicantvisadocumentgrid',
		 selector: 'applicantvisadocumentgrid'
	},{
		 ref: 'applicantinsurancedocumentgrid',
		 selector: 'applicantinsurancedocumentgrid'
		
	},{
		 ref: 'applicantvisaurlgrid',
		 selector: 'applicantvisaurlgrid'
	 },{
		 ref: 'applicantinsuranceurlgrid',
		 selector: 'applicantinsuranceurlgrid'
	 },{
		 ref: 'applicantvisadocumentlist',
		 selector: 'applicantvisadocumentlist'
	 },{
		 ref: 'applicantvisadocumentlistgrid',
		 selector: 'applicantvisadocumentlistgrid'
	 },{
		 ref: 'applicantvisadocurllist',
		 selector: 'applicantvisadocurllist'
	 },{
		 ref: 'applicantvisadocurllistgrid',
		 selector: 'applicantvisadocurllistgrid'
	 },{
		 ref: 'applicantinsurancedetailsgrid',
		 selector: 'applicantinsurancedetailsgrid[itemId=applicantInsuranceDetailsGrid]'
	},{
		 ref: 'applicantinsurancedocumentlist',
		 selector: 'applicantinsurancedocumentlist'
	 }, {
		 ref: 'applicantinsurancedocumentlistgrid',
		 selector: 'applicantinsurancedocumentlistgrid'
	 }, {
		 ref: 'applicantinsurancedocurllist',
		 selector: 'applicantinsurancedocurllist'
	 }, {
		 ref: 'applicantinsurancedocurllistgrid',
		 selector: 'applicantinsurancedocurllistgrid'
	 },{
		 ref: 'applicantpermitgrid',
		 selector: 'applicantpermitgrid[itemId=applicantpermitgridId]'
	 },{
		 ref: 'permitdetailform',
		 selector: 'permitdetailform[itemId=applicantPermitDetailFormId]'
	 },{
		 ref: 'applicantpermitdocumentgrid',
		 selector: 'applicantpermitdocumentgrid'
	 },{
		 ref: 'applicantpermiturldocumentgrid',
		 selector: 'applicantpermiturldocumentgrid'
	 },{
		 ref: 'applicantpermitdocumentlist',
		 selector: 'applicantpermitdocumentlist'
	 },{
		 ref: 'applicantpermitdocumentlistgrid',
		 selector: 'applicantpermitdocumentlistgrid'
	 },{
		 ref: 'applicantpermiturldocumentlist',
		 selector: 'applicantpermiturldocumentlist'
	 },{
		 ref: 'applicantpermiturldocumentlistgrid',
		 selector: 'applicantpermiturldocumentlistgrid'
	 },{
		 ref:'feepayergoogleaddresswin',
		 selector:'feepayergoogleaddresswin[itemId=applicantFeepayergoogleaddresswin]'
	 },{
			ref: 'nationalservicegrid',
	    	selector: 'nationalservicegrid[itemId=nationalservicegridId]'
	    },{
			 ref: 'nationalServiceDetailForm',
			 selector: 'nationalServiceDetailForm[itemId=nationalServiceDetailFormId]'
		 },],
    config: {
    	APPLICANT_PARENTS_GUARDIANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PARENTS_GUARDIANS_PRIVILEGES'),
    	APPLICANT_SIBLINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_SIBLINGS_PRIVILEGES'),
    	APPLICANT_ADDRESS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_ADDRESS_PRIVILEGES'),
    	APPLICANT_PERSONAL_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PERSONAL_INFORMATION_PRIVILEGES'),
    	APPLICANT_IDENTITY_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_IDENTITY_DETAILS_PRIVILEGES'),
    	APPLICANT_OTHER_INFORMATION_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_OTHER_INFORMATION_PRIVILEGES'),
    	APPLICANT_FEE_PAYER_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_FEE_PAYER_DETAILS_PRIVILEGES'),
    	APPLICANT_PORTAL_PERSONAL_INFORMATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_PERSONAL_INFORMATION_PRIVILEGES'),
    	APPLICANT_HOSTEL_PERSONAL_REQUIREMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_HOSTEL_PERSONAL_PRIVILEGES'),
        APPLICATION_APPLICANT_ADDRESS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_APPLICANT_ADDRESS_PRIVILEGES'),
   	    APPLICANT_PORTAL_CONTACTDETAILS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_CONTACTDETAILS_ADDRESS_PRIVILEGES'),
   	    APPLICANT_NSFAS_STATUS_DATA_GRID_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NSFAS_STATUS_DATA_GRID_PRIVILEGES'),
   	    APPLICANT_NSFAS_FUNDDING_DATA_GRID_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NSFAS_APP_FUNDDING_DATA_GRID_PRIVILEGES'),
   	    APPLICANT_NSFAS_APPLICATION_DETAIL_DATA_GRID_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NSFAS_APPLICATION_DETAIL_DATA_GRID_PRIVILEGES'),
   	    APPLICANT_PASSPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PASSPORT_PRIVILEGES'),
   	    APPLICANT_NATIONAL_SERVICES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_NATIONAL_SERVICES'),
   	    APPLICANT_VISA_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_VISA_DETAIL_PRIVILEGES'),
   	    APPLICANT_INSURANCE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_INSURANCE_DETAILS_PRIVILEGES'),
   	    APPLICANT_PERMIT_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PERMIT_DETAIL_PRIVILEGES'),
   	    APPLICANT_PASSPORT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PASSPORT_DOCUMENT_PRIVILEGES'),
   	    APPLICANT_PASSPORT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PASSPORT_URL_PRIVILEGES'),
   	    APPLICANT_VISA_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_VISA_DOCUMENT_PRIVILEGES'),
	    APPLICANT_VISA_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_VISA_URL_PRIVILEGES'),
	    APPLICANT_PERMIT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PERMIT_DOCUMENT_PRIVILEGES'),
	    APPLICANT_PERMIT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PERMIT_URL_PRIVILEGES'),
	    APPLICANT_INSURANCE_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_INSURANCE_DOCUMENT_PRIVILEGES'),
	    APPLICANT_INSURANCE_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_INSURANCE_URL_PRIVILEGES'),
   	    

    },
    init: function(application) {
    	this.passportMode;
    	this.visaMode;
        this.isAdd=true;
        this.control({
        	'studentpassportdetailsform':{
    			afterrender: function(form) {	
    				if(this.isAdd){
    					form.up().setTitle(getCommonTranslation('ADD_PASSPORT'));
    				}else{
    					form.up().setTitle(getCommonTranslation('EDIT_PASSPORT'));
    				}
    			}
    		},
            /**
             * Personal Information
             * 
             */
            'applicantprofile [itemId=otherDetailsApplicantFieldSet]':{
            	expand:function(obj){
            		setTimeout(function(){
            			obj.doLayout();
            		},300)
            	}
            },
            'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm]': {
            	afterrender:function(obj){
            		// This changes did for DFR
            		var personProfile = this.getContentPanelActiveTab();
            		var form = personProfile.down('personalinformationform');
            		var $this = this;
            		var submitUrl = SERVERURL.PATH_CHECKBOX_SELECTED;
     				Ext.Ajax.request({
     	         		type : 'rest',
     	            	url : submitUrl,
     	            	method : 'GET',    
     	            success: function(obj, action) { 
     	            	var checkboxDropdown = form.down("#checkboxDropdown");
     	            	var comboFieldContainerStudentApplicant = form.down("#comboFieldContainerStudentApplicant");
 	            		var textFieldContainerStudentApplicant = form.down("#textFieldContainerStudentApplicant");
     	            	if(obj.responseText=='true'){
     	            		comboFieldContainerStudentApplicant.setVisible(true);
     	            		textFieldContainerStudentApplicant.setVisible(false);
     	            		checkboxDropdown.setValue(true);
     	            		$this.afterRenderApplicantPersonalInformationForm($this);
     	               }else{
   	            			comboFieldContainerStudentApplicant.setVisible(false);
   	            			textFieldContainerStudentApplicant.setVisible(true);
   	            			checkboxDropdown.setValue(false);
   	            			$this.afterRenderApplicantPersonalInformationForm($this);
     	               }
     	            }	  						
     	            });
     				
                	var personProfile = this.getContentPanelActiveTab();    	    
                	if(personProfile.getApplicationInfo()['isViewMode']){
                		this.onRenderApplicantPersonalInformationForm(this);                		
                	} else {
                		this.onRenderApplicantPersonalInformationForm(this,'',true);
                	}
                	
            		this.doAccessPersonalInfoSaveBtn(obj,this.getAPPLICANT_PERSONAL_INFORMATION_PERMISSIONS());
            		
            		if(portalId == 6){
            			var alId = localStorage.getItem('academylocationid');
            			var ALId = {};
            			ALId.academyLocationId = alId;
            			Academia.app.getController("Academia.controller.authentication.AuthenticationController").getDynamicForFormFieldsInfo(ALId);
            			}       
            		setTimeout(function(){
            			if(!obj.down('#stuIsWheelCharRequiredItemId').isVisible() && !obj.down('#stuPermanentResItemId').isVisible() &&
            					!obj.down('#stuAsylumSeekerItemId').isVisible() && !obj.down('#stuAreYouRefugeeItemId').isVisible()) {
            				obj.down('#stuIsWheelCharRequiredItemId').up('fieldcontainer').setVisible(false);
            			}
            			if(!obj.down('#stuIsStudyingInstitutionItemId').isVisible() && !obj.down('#isMilitarySponsoredItemId').isVisible() &&
            					!obj.down('#pHDSponsorItemId').isVisible() && !obj.down('#isBursaryRequirementsItemId').isVisible()) {
            				obj.down('#stuIsStudyingInstitutionItemId').up('fieldcontainer').setVisible(false);
            			}
            			var  beneficiaryNameOtherLanguage = obj.down('#beneficiaryNameOtherLanguageId');
            	        if (!isNullOrEmpty(beneficiaryNameOtherLanguage)) {
            	      		beneficiaryNameOtherLanguage.setVisible(false);
            	        	beneficiaryNameOtherLanguage.allowBlank = true;
            			}
            	        var  admissionDate = obj.down('#admissionDate');
            	        if (!isNullOrEmpty(admissionDate)) {
            	        	admissionDate.setVisible(false);
            	        	admissionDate.allowBlank = true;
            			}
            	        var studentDownloadURL = obj.down('#studentDownloadURL');
            	        studentDownloadURL.setValue(null);
            	        studentDownloadURL.setVisible(false);
            	        var verifyDetailButton = obj.down('#verifyDetail');
            	        verifyDetailButton.setVisible(false);
            	        form.down('#otherDetailsApplicantFieldSet').expand();
            	        Ext.defer(function(){
            	        	form.down('#otherDetailsApplicantFieldSet').collapse();
            	        },700)
                	},500);
            		/* Ext.defer(function() {
                     	
            			 obj.getForm().findField('advisorId').setVisible(false);
                    	            	
        	        }, 1000, this);*/
            	},
            },
            
            'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] nestedJsonCombo[itemId=bankNameValue]': {
 	           select: function(obj, newValue) {
                     var form = this.getPersonalInformationForm();
                     var ifscCodeValue = form.down('#ifscCodeValue');
                     ifscCodeValue.reset();      
                     var branchNameValue = form.down('#branchNameValue');
                     branchNameValue.reset();
                     branchNameValue.setDisabled(false);
                     ifscCodeValue.setDisabled(false);
                     var ifscCodeValue= form.down('#ifscCodeValue').getValue();
                     var bankValue=form.down('#bankNameValue').getValue();
                     var ifscCodeValue = form.down('#ifscCodeValue');
                     if(bankValue.length>0){
                    	 	ifscCodeValue.getStore().getProxy().extraParams = {
                        	 bankName:bankValue,
 							}
                    	 	ifscCodeValue.getStore().load();
                    	 	branchNameValue.getStore().getProxy().extraParams = {
                        	 bankName:bankValue,
                    	 	}
                    	 	branchNameValue.getStore().load();}
 	           		}    
             },
             
             'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] nestedJsonCombo[itemId=branchNameValue]': {
 	           select: function(obj, newValue) {
                     var form = this.getPersonalInformationForm();
                     form.down('#ifscCodeValue').setValue(newValue[0].get('code'));
 	           }  
             },
             
             'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] nestedJsonCombo[itemId=ifscCodeValue]': {
   	           select: function(obj, newValue) {
                       var form = this.getPersonalInformationForm();
                       form.down('#branchNameValue').setValue(newValue[0].get('value'));
   				}  
               },
           
            'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] photouploadform[itemId=applicantPhotoUploadForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	photoFileImage.setRawValue(newValue);
                	var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                    var specialCharsExist=false;
                         for(i = 0; i < specialChars.length;i++){
                           if(newValue.indexOf(specialChars[i]) > -1){
                               specialCharsExist= true;
                            }
                         }
                        if(specialCharsExist){
                        	photoFileImage.reset();
                            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                        }
                }
            },
            'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] numberfield[itemId=phoneNoField]': {
    			change: function(record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	
                	try{
                    	if((portalId == 3 || portalId == 7 || portalId == 2) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
                	
                	var form = personProfile.down('#applicantPersonalInformationForm');
                	var phoneNoField = form.down("#phoneNoField");
                	phoneNoField.isValid();
        			form.getForm().checkValidity();
                }
    		},
           
           'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
            	click: this.createUpdateApplicantPersonalInformation                
            },
            
             'personalinformationform[itemId=applicantPersonalInformationForm] button[itemId=stopBtn]': {
            	click: function(obj){
    				this.addMultipleLanguage(obj);
    			}          
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] button[itemId=languageDeleteButton1]':{
    			click : function(deleteButton) {
   				 	this.deleteLanguageCompentecny(deleteButton);
   			 	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] [itemId=employeeLanguage]': {
            	select: function(combo, record) {
                	var newValue = record[0].data.id;
                	var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
                    	this.onSelectionLanguage(combo, record,form);
            		}
            	}               
            },
            
            'personalinformationform[itemId=applicantPersonalInformationForm] [itemId=cellCountryCode]': {
            	select: function(rowModel,record){
//            		this.setMaximumMinimumDigitsForMobileNo(rowModel, record);
            		var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
	            		var countryCodeField = form.down("#cellCountryCode");
	                 	var mobileField = form.down("#mobileNumber");
	                 	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
            		}
            	}                  
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[itemId=birthDateId] ':
        	{
        	 change : function(obj,record)
        	 {
        		 var $this = this;
                 var form = obj.up('personalinformationform');
                 var ageData =form.down("#ageId");
                  var currentYear = new Date(record);
                 var todayDate = new Date();
                  var calculateAge =todayDate.getFullYear()-currentYear.getFullYear();
                  if (form.down("#birthDateId").isValid()){
                	  
                  }
                  else
                      {
                          calculateAge = 0;
                      }
                  ageData.setValue(calculateAge);
                  
                  ageData.setReadOnly(true);
        	 }
        	},
            'personalinformationform[itemId=applicantPersonalInformationForm] [itemId=mobileNumber]': {
            	change: function(record){
            		var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
	                 	var mobileField = form.down("#mobileNumber");
	                 	mobileField.isValid();
	        			form.getForm().checkValidity();
	        		}
            	}                  
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] [itemId=alternateCellCountryCode]': {
            	select: function(rowModel,record){
            		var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
	            		var countryCodeField = form.down("#alternateCellCountryCode");
	                 	var mobileField = form.down("#alternateMobileNumber");
	                 	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
            		}
            	}                  
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] [itemId=phoneCountryCode]': {
            	select: function(rowModel,record){
            		var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
	            		var countryCodeField = form.down("#phoneCountryCode");
	                 	var phoneNoField = form.down("#phoneNoField");
	                 	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,record);
            		}
            	}                  
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] [itemId=alternateMobileNumber]': {
            	change: function(record){
            		var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
	                 	var mobileField = form.down("#alternateMobileNumber");
	                 	mobileField.isValid();
	        			form.getForm().checkValidity();
	        		}
            	}                  
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[itemId=nationalIDItemId]': {
            	 blur : function(obj){
            		 this$ = this;
            		 var personProfile = this$.getContentPanelActiveTab();
            		 var personalInformationForm = personProfile.down('#applicantPersonalInformationForm');
            		 var newValue = personalInformationForm.down("#nationalIDItemId");
            		 if(!isNullOrEmpty(newValue.value))
            		 {
            			 personalInformationForm.down("#verifyDetail").setDisabled(false);
            		 }else{
            			 personalInformationForm.down("#verifyDetail").setDisabled(true);
            		 }
            		 
            	 }
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#applicantPersonRadioBtnRegisteredBeforeSA':{
            	 change: function (obj, newValue, oldValue) {
            		 var $this = this;
            		    var form = obj.up('personalinformationform');
            		    var allIntakeYear = form.down('#allIntakeYearItemId');
            		    var registeredBeforeSA = form.down('#registeredBeforeSA');
            		    if (newValue.areYouRegisteredAtOtherSAU==true) {
            		    	registeredBeforeSA.setVisible(true);
            		    	registeredBeforeSA.allowBlank = false;
							registeredBeforeSA.setDisabled(false);
            		    	$this.handleRegisteredBeforeSAChange(form, allIntakeYear, true);
            		    } else {
            		    	allIntakeYear.setVisible(false);
            		    	allIntakeYear.allowBlank=true;
            		    	allIntakeYear.setValue(null);
            		    	registeredBeforeSA.setVisible(false);
							registeredBeforeSA.setDisabled(true);
            		    	registeredBeforeSA.allowBlank=true;
            		    	registeredBeforeSA.setValue('');
                			form.isValid();	
            		    }
            		    
            	 }
            	},
             
            'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#applicantPersonRadioBtnUwcBefore':{
            	change:function(obj,newValue,oldValue){
            			var form = obj.up('personalinformationform');
                		var uwcBeforeItemId = form.down("#uwcBefore");
                		if (newValue.haveYouStudiedAtUWC==true) {
                			uwcBeforeItemId.setVisible(true);
                			uwcBeforeItemId.setFieldLabel('');
                			uwcBeforeItemId.labelSeparator = '';
                			uwcBeforeItemId.setFieldLabel(getEnquiryTranslation('STUDENT_ID_NUMBER')+ ':<span class="required" style="color:red"> *</span>');
                			uwcBeforeItemId.allowBlank = false;
                			form.isValid();
                		}
                		else
                		{
                			uwcBeforeItemId.setVisible(false);
                			uwcBeforeItemId.allowBlank=true;
                			uwcBeforeItemId.setValue('');
                			form.isValid();	
                		}		
            	}
            },

            'personalinformationform[itemId=applicantPersonalInformationForm]': {
                render: function(obj) {
                	var form = obj.getForm();
                   	var haveDisabilities = form.findField('haveDisabilities');
                	var haveDisabilitiesStore = haveDisabilities.getStore();
        			haveDisabilitiesStore.getProxy().extraParams={
        				type:'HaveDisabilities'
        			};
        			haveDisabilitiesStore.load({});
        			
        			var homeLanguageStore = form.findField('homeLanguage').getStore();
        			homeLanguageStore.getProxy().extraParams={
        				type:'HomeLanguage'
        			};
        			
        			var sadcCitizenshipStore = form.findField('sadcCitizenship').getStore();
        			sadcCitizenshipStore.getProxy().extraParams={
        				type:'SADCCitizenship'
        			};


        			var secondLanguageStore = form.findField('secondLanguage').getStore();
        			secondLanguageStore.getProxy().extraParams={
        				type:'SecondLanguage'
        			};
        			
        			var fieldOfInterestStore = form.findField('fieldOfInterest').getStore();
        			fieldOfInterestStore.getProxy().extraParams={
        				type:'fieldOfInterest'
        			};
        			
        			var areaOfResearchStore = form.findField('areaOfResearch').getStore();
        			areaOfResearchStore.getProxy().extraParams={
        				type:'areaOfResearch'
        			};
        			      			
        			
        			if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){}
        			var idtype = form.findField('idtype');
        			idtype.setVisible(true);
                },
                afterrender:function(obj){
                	if(portalId==6){
                		if(!isNullOrEmpty(obj.down('#identityExpiryDateItemId'))){
                			var identityExpiryDateItemId = obj.down('#identityExpiryDateItemId');
                			identityExpiryDateItemId.setMinValue(new Date());
                		}
                		this.setApplicantPersonalInforamtionFormValues(this);
                		this.doAccessPersonalInfoSaveBtn(obj,this.getAPPLICANT_PORTAL_PERSONAL_INFORMATION_PERMISSIONS());
                	}
                },
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
	        	click: function(obj){
	        		if(portalId==6){
	        			this.createUpdateApplicantPersonalInformation();
	        		}
	        	}                
	        },
	        'personalinformationform[itemId=applicantPersonalInformationForm] photouploadform[itemId=applicantPhotoUploadForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
                	if(portalId==6){
                		value = value.replace('C:\\fakepath\\', '');
                    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    	photoFileImage.setRawValue(newValue);
                    	 var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                         var specialCharsExist=false;
                              for(i = 0; i < specialChars.length;i++){
                                if(newValue.indexOf(specialChars[i]) > -1){
                                    specialCharsExist= true;
                                 }
                              }
                             if(specialCharsExist){
                            	 photoFileImage.reset();
                                 showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                             }
                	}
                }
            },
            
            'personalinformationform[itemId=applicantPersonalInformationForm] combo': {
                render: function(combo) {
                	if(combo.itemId!="applicantCampaignSchool"){
                    combo.getStore().load();
                	}
                }
            },
            
    		'personalinformationform[itemId=applicantPersonalInformationForm] button[itemId=verifyDetail]': {
    			click: function(obj) {
    				//personType = obj.up().up().up().personType;
    					var $this = this;
    					var personalInformationForm = this.getPersonalInformationForm();
    					if(personalInformationForm){
    						var data = personalInformationForm.getValues()
    					}
    					var nationalId = data.nationalID;
					var idTypeCodeValue = personalInformationForm.down('#idTypeCombo').getStore().findRecord('id', data.idtype);
					if (!isNullOrEmpty(data.nationality)) {
						var index = personalInformationForm.down('#nationalityCombo').getStore().findExact('id', data.nationality.id);
						if (index !== -1) {
							var nationalityCodeValue = personalInformationForm.down('#nationalityCombo').getStore().getAt(personalInformationForm.down('#nationalityCombo').getStore().findExact('id', data.nationality.id));
						}

					}
					var relavantType="APPLICATION";
					var applicantProfile = this$.getContentPanelActiveTab();
					if(applicantProfile.getApplicationInfo()['applicationStatus']=='DIRECT_ADMISSION')	{
							var relavantType="DIRECT_ADMISSION";
						}else{
						 relavantType="APPLICATION";
					}
					var uwcUrl = SERVERURL.PATH_GET_FIND_BY_RELEVANT_TO;
					Ext.Ajax.request({
						type: 'rest',
						url: uwcUrl + '?relavantToFormType=' + relavantType,
						method: 'GET',
						success: function(response, action) {
							Ext.getBody().unmask();
							if (!isNullOrEmpty(response.responseText) && (response.responseText) != "") {
								var responseData = Ext.JSON.decode(response.responseText);
								if (responseData != null) {
									$this.checkUwcNationalIdValidation(responseData, data, nationalityCodeValue, idTypeCodeValue);
								}
							}
                        else{
    					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    					var Url = SERVERURL.VERIFY_NATIONAL_ID;
    					if(!isNullOrEmpty(nationalId)){
    						Ext.Ajax.request({
    							type: 'rest',
    							url: Url+'?identityNumber='+nationalId,
    							method: 'GET',
    							success : function(response, action){
    								Ext.getBody().unmask();
    								var responseData = Ext.JSON.decode(response.responseText);
    								if(responseData.message!='Not Found' && responseData.citizenship!=null)
    								{
    								//var getIDWindow='';
    		    					//getIDWindow = $this.getApplicantIdVerificationDetailWin();
    		    					//if (!getIDWindow) {
    									var getIDWindow =Ext.widget('idverificationdetailwin',{
   										   itemId:'applicantIdVerificationDetailWinItemId'
   									   });
    		    						
    		    					//}
    		    					getIDWindow.show();
    		    					
    		    					//getFormWindow = formWindow.getForm();
    	    						getIDWindow.down('#userFirstName').setValue(data.firstName);
    	    						getIDWindow.down('#userLastName').setValue(data.lastName);
    	    						getIDWindow.down('#userGender').setValue(data.gender);
    	    						getIDWindow.down('#userDOB').setValue(dateRender(data.birthDate));
    								
    								var responseData = Ext.JSON.decode(response.responseText);
    								var nationalityCombo =  personalInformationForm.down("#nationalityCombo");
    								var matched = '<span style="color:green">Matched</span>';
    								var notMatched = '<span style="color:red">Not Matched</span>';
    								
    								if(!isNullOrEmpty(nationalityCombo.getRawValue())){
    									getIDWindow.down('#userCitizenship').setValue(nationalityCombo.getRawValue());
    								}
    								if(responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
    								{
    									getIDWindow.down('#citizenshipStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#citizenshipStatus').setValue(notMatched);
    								}
    								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase() && responseData.surname.toUpperCase() == data.lastName.toUpperCase() &&
    										responseData.gender.toUpperCase() == data.gender.toUpperCase() &&
    										dateRender(responseData.dateOfBirth) == data.birthDate && responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
    								{
    									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('VERIFIED_NOTE'));

    								}else
    								{
    									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('NOT_VERIFIED_NOTE'));
    								}

    								getIDWindow.down('#dbFirstName').setValue(responseData.firstNames);
    								getIDWindow.down('#dbLastName').setValue(responseData.surname);
    								getIDWindow.down('#dbGender').setValue(responseData.gender);
    								getIDWindow.down('#dbDOB').setValue(dateRender(responseData.dateOfBirth));
    								getIDWindow.down('#dbCitizenship').setValue(responseData.citizenship);
    								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase())
    								{
    									getIDWindow.down('#firstNameStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#firstNameStatus').setValue(notMatched);
    								}
    								if(responseData.surname.toUpperCase() == data.lastName.toUpperCase())
    								{
    									getIDWindow.down('#lastNameStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#lastNameStatus').setValue(notMatched);
    								}
    								if(responseData.gender.toUpperCase() == data.gender.toUpperCase())
    								{
    									getIDWindow.down('#genderStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#genderStatus').setValue(notMatched);
    								}
    								if(dateRender(responseData.dateOfBirth) == data.birthDate)
    								{
    									getIDWindow.down('#dobStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#dobStatus').setValue(notMatched);
    								}
    							}else{
    								showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('GET_RECORD_NOT_FOUND'));
    							}

    							}
    						});
    					}
						}
						}
						});
    			}		
    		},
    		 'idverificationdetailwin[itemId=applicantIdVerificationDetailWinItemId] button[itemId=okBtn]':{
            	click: function(obj) {
            		var applicantIdVerifiedForm = obj.up().up();
            		applicantIdVerifiedForm.close();
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] combo[itemId=countryCombo]': {
                render: function(combo) {
                  combo.getStore().load({
  					  callback: function(records, operation, success) {
  						  if (success) {
  							  for(i in records){
  								  if(records[i].data.whetherDefault || records[i].data.whetherDefault=="true"){
  									combo.setValue(records[i].data.id);  									  
  								  }
  							  }
  						  }
  					  }
  				  });
                }
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[name=firstName]': {
            	change: function(firstNameField){
            		var personProfile = this.getContentPanelActiveTab();
            		var applicationStatus ;
            		if(portalId==6){
            			applicationStatus=this.getContentPanel().items.items[0].getApplicationInfo()['applicationStatus'];	
            		}else{ 
            			//Applied undefined check V2D-53629
            			if(Ext.isDefined(personProfile) && Ext.isDefined(personProfile.getApplicationInfo)){
            	            applicationStatus=personProfile.getApplicationInfo()['applicationStatus'];
            	            }
            		}
            		this.shortNameOnchangeOfFirstName(firstNameField,'#applicantPersonalInformationForm',applicationStatus);
            		this.setPrintNameValue(firstNameField);
            		var form = personProfile.down('personalinformationform');
                    if(!isNullOrEmpty(form) && !isNullOrEmpty(form.getForm())){
                        var f = form.getForm();
                        var admDate = f.findField('admissionDate');
                        if(!admDate.allowBlank && ! admDate.isVisible()){
                            admDate.allowBlank = true;
                        }
                    }
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[name=middleName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[name=lastName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[name=firstNameOtherLanguage]': {
            	change: function(firstNameField){
            		var personProfile = this.getContentPanelActiveTab();
            		var applicationStatus ;
            		if(portalId==6){
            			applicationStatus=this.getContentPanel().items.items[0].getApplicationInfo()['applicationStatus'];	
            		}else{ 
            			if(Ext.isDefined(personProfile) && Ext.isDefined(personProfile.getApplicationInfo)){
            	            applicationStatus=personProfile.getApplicationInfo()['applicationStatus'];
            	            }
            		}
            		this.shortNameOtherLnguageOnchangeOfFirstName(firstNameField,'#applicantPersonalInformationForm',applicationStatus);
            		this.setPrintNameOtherLnguageValue(firstNameField);
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[name=middleNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] textfield[name=lastNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] combo[itemId=currentEducationalInterventionsItemId]': {
                select: function(combo, records, eOpts) {
                    var code = records[0].data.code;
                    var form = this.getPersonalInformationForm();
                    var specifyOtherItemId = form.down("#specifyOtherItemId");
                    if (code == 'OTHER') {
                        specifyOtherItemId.setVisible(true);
                        specifyOtherItemId.allowBlank = false;
                    } else {
                        specifyOtherItemId.setVisible(false);
                        specifyOtherItemId.allowBlank = true;
                    }
                    specifyOtherItemId.reset();
                    form.isValid();
                }
            },
           
           'personalinformationform[itemId=applicantPersonalInformationForm] combo[itemId=armsOfService]': {
           	 select:function(obj1,records) {
           	  var musteringComboBox = obj1.up('form').down('customcombobox#mustering');
              var armsOfServiceComboBox = obj1.up('form').down('customcombobox#armsOfService');
            	musteringComboBox.setDisabled(false);
            	musteringComboBox.reset();
              
              var armsOfServiceIdVal = records[0].get("id");
              //var countryIdVal = armsOfServiceComboBox.getValue();
              var musteringStore = musteringComboBox.getStore();
              musteringStore.getProxy().extraParams = {
            	  armsOfServiceId: armsOfServiceIdVal
              };
              musteringStore.reload();
           	 }
           },
                      /**
             * Applicant Address details
             * 
             */
            
            'addressdetails[itemId=applicantAddressDetails]': {
            	render: function(){
            		this.getPersonAddressDetailTemplateData('#applicantAddressDetails', 'SELF_ADDRESS', SERVERURL.APPLICANT_GET_PERSON_ADDRESS_DETAILS);
                }
            },
            
            "addressdetails[itemId=applicantAddressDetails] combo[itemId=addressCombo]": {
                select: function(){
                	this.onSelectionPersonAddressTypeCombo('#applicantAddressDetails', SERVERURL.APPLICANT_FIND_RELATED_PERSON_ID, SERVERURL.APPLICANT_GET_PERSON_ADDRESS_DETAILS);
                }
            },
            
            'addressformwindow[itemId=applicantAddressWindow]':{
            	render:function(form){
            		form.down('#otherAddressTypeItemId').show();
            		form.down('#parentCountryRegionId').setDisabled(true);
            		form.down('#cityId').setDisabled(true);
            		form.down('#pincodeNewId').setDisabled(true);
            		this.doAccessAddressSaveBtn(form, this.getAPPLICANT_ADDRESS_PERMISSIONS());
            		if(portalId == 6){
            			this.getCopyAddressPriviledge(form,this.getAPPLICANT_PORTAL_CONTACTDETAILS_PERMISSION());
            		}else{
            			this.getCopyAddressPriviledge(form,this.getAPPLICATION_APPLICANT_ADDRESS_PERMISSION());
            		}
            		var getPinCodeUrl = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            		Ext.Ajax.request({
                        type: 'rest',
                        url: getPinCodeUrl,
                        method: 'GET',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(res, action) {
                        	var data = res.responseText;
                        	if(!isNullOrEmpty(data)){
                        		form.down('#pincodeNewId').setVisible(true);
                        		form.down('#pincodeId').setVisible(false);
                        		if(form.down('#pincodeNewId').defaultVal){
                        			form.down('#pincodeNewId').setValue(form.down('#pincodeNewId').defaultVal);
                            	}
                        	}else{
                        		form.down('#pincodeNewId').setVisible(false);
                        		form.down('#pincodeId').setVisible(true);
                        		if(form.down('#pincodeId').defaultVal){
                        			form.down('#pincodeId').setValue(form.down('#pincodeId').defaultVal);
                            	}
                        	}
                        }
                    });
            	}
            },
            'addressformwindow': {
            	render: function( me, eOpts ){
            		if(portalId==6){
                		me.setHeight(window.innerHeight-60);            			
            		}
            	}
            },
            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#genericFieldId1': {
                select: function(combo, record) {
                    this.onSelectionGenericField(combo, record, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#countryId': {
                select: function(combo, record) {
                	var newValue=record[0].data.id;
                	this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');
                	regionComboBox.setDisabled(false);
                    this.onSelectionCountry(combo, record, this.getPersonAddressFieldsForm());
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	var phoneCountryCode = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	 setTimeout(function(){
                 		var pincodeId = form.down("#pincodeId");
                      	pincodeId.reset();
                      	pincodeId.setDisabled(true);
                      	var pincodeNewId = form.down("#pincodeNewId");
                      	pincodeNewId.clearValue();
                      	pincodeNewId.setDisabled(true);
                  	},100);
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);

                },

                change: function(combo, newValue) {
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');
                	if(!isNullOrEmpty(newValue)){
                		regionComboBox.setDisabled(false);	
                	}else{
                		regionComboBox.setDisabled(true);	
                	}
//                  this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#parentCountryRegionId': {
                select: function(obj1, record) {
                    var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                    cityComboBox.setDisabled(false);
                    cityComboBox.reset();
                    var form = this.getPersonAddressFieldsForm();
                	var phoneCountryCode = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	setTimeout(function(){
            			var pincodeId = form.down("#pincodeId");
            			pincodeId.reset();
            			pincodeId.setDisabled(true);
            			var pincodeNewId = form.down("#pincodeNewId");
            			pincodeNewId.clearValue();
            			pincodeNewId.setDisabled(true);
            		},100);
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                    var countryRegion1 = record[0].get("id");
                   	var store = cityComboBox.getStore();
                    store.getProxy().extraParams = {
                        id: countryRegion1
                    };
                    store.reload();
                },
                change: function(obj1, newValue) {
                	 var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                	 if(!isNullOrEmpty(newValue)){                	
                		 cityComboBox.setDisabled(false);
                	 }else{
                		 cityComboBox.setDisabled(true); 
                	 }
                }
            },
            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#cityId': {
            	select: function(obj1, record) {
            		var me = this;
            		var city = record[0].get("id");
            		var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            		Ext.Ajax.request({
            			type: 'rest',
            			url: getPinCodeUrl1,
            			method: 'GET',
            			headers: {
            				'Content-Type': 'application/json'
            			},
            			params: {
            				id: city
            			},
            			success: function(res, action) {
            				var data = res.responseText;
            				if(!isNullOrEmpty(data) && data !="[]"){
            					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
            					obj1.up('form').down('textfield#pincodeId').setVisible(false);
            					obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
            					setTimeout(function(){
                        			obj1.up('form').down('customcombobox#pincodeNewId').reset();
                            		obj1.up('form').down('customcombobox#pincodeNewId').clearValue();
                            	},100);
            					var form = me.getPersonAddressFieldsForm();
            					var phoneCountryCode = form.down("#phoneCountryCode");
            					var phoneNoField = form.down("#phoneNoField");
            					me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
            					var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
            					store.getProxy().extraParams = {
            						id: city
            					};
            					store.reload();
            				}else{
            					obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
            					obj1.up('form').down('textfield#pincodeId').setVisible(true);
            					obj1.up('form').down('textfield#pincodeId').setDisabled(false);
            					obj1.up('form').down('textfield#pincodeId').reset();
            					var form = me.getPersonAddressFieldsForm();
            					var phoneCountryCode = form.down("#phoneCountryCode");
            					var phoneNoField = form.down("#phoneNoField");
            					me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
            				}
            			}
            		});
            		/*var pincodeNewComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
            		pincodeNewComboBox.setDisabled(false);
            		pincodeNewComboBox.reset();
            		var form = this.getPersonAddressFieldsForm();
            		var phoneCountryCode = form.down("#phoneCountryCode");
            		var phoneNoField = form.down("#phoneNoField");
            		this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
            		var city = record[0].get("id");
            		var store = pincodeNewComboBox.getStore();
            		store.getProxy().extraParams = {
            			id: city
            		};
            		store.reload();*/
            	},
            change: function(obj1, newValue) {
             var cityPinCodeTextBox = obj1.up('form').down('textfield#pincodeId');
           	 var cityPinCodeComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
           	 if(!isNullOrEmpty(newValue)){                	
           		cityPinCodeComboBox.setDisabled(false);
           		cityPinCodeTextBox.setDisabled(false);
           	 }else{
           		cityPinCodeTextBox.setDisabled(true);
        		cityPinCodeTextBox.reset();
           		cityPinCodeComboBox.setDisabled(true);
           		cityPinCodeComboBox.clearValue();
           	 }
           	 
           	var me = this;
           	if(!isNullOrEmpty(newValue) && isNumberValidate(newValue)){
           		var city = newValue;
           	}else{
           		var city = '';
           	}
        	
        	var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
        	Ext.Ajax.request({
        		type: 'rest',
        		url: getPinCodeUrl1,
        		method: 'GET',
        		headers: {
        			'Content-Type': 'application/json'
        		},
        		params: {
        			id: city
        		},
        		success: function(res, action) {
        			var data = res.responseText;
        			if(!isNullOrEmpty(data) && data !="[]"){
        				obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
        				obj1.up('form').down('textfield#pincodeId').setVisible(false);
        				obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
        				var form = me.getPersonAddressFieldsForm();
        				var phoneCountryCode = form.down("#phoneCountryCode");
        				var phoneNoField = form.down("#phoneNoField");
        				me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
        				var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
        				store.getProxy().extraParams = {
        					id: city
        				};
        				store.reload();
        			}else{
        				obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
        				obj1.up('form').down('textfield#pincodeId').setVisible(true);
        				obj1.up('form').down('textfield#pincodeId').setDisabled(false);
        				var form = me.getPersonAddressFieldsForm();
        				var phoneCountryCode = form.down("#phoneCountryCode");
        				var phoneNoField = form.down("#phoneNoField");
        				me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
        			}
        		}
        	});
           }
            },
            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#cellCountryCode': {
                select: function(rowModel, record) {
                	var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
                }
            },
            '[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#phoneCountryCode': {
                select: function(rowModel, record) {
                	var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, record);
                }
            },
            
            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  numberfield#cellNo': {
                change: function(record) {
                	var form = this.getPersonAddressFieldsForm();
                	var mobileField = form.down("#cellNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            /*"addressdetails[itemId=applicantAddressDetails] button#printPersonalAddress1": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField1');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#printPersonalAddress2": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField2');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#printPersonalAddress3": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField3');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#printPersonalAddress4": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField4');
                    this.onPrintClick(addressDisplayField);
                }
            },*/
            "addressdetails[itemId=applicantAddressDetails] button#modifyPersonalAddress1": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField1", "#applicantAddressDetails", "applicantAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#modifyPersonalAddress2": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField2", "#applicantAddressDetails", "applicantAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#modifyPersonalAddress3": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField3", "#applicantAddressDetails", "applicantAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#modifyPersonalAddress4": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField4", "#applicantAddressDetails", "applicantAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                }
            },
            "addressdetails[itemId=applicantAddressDetails] button#modifyPersonalAddress5": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField5", "#applicantAddressDetails", "applicantAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                }
            },
            'addressformwindow[itemId=applicantAddressWindow] button[itemId=submitButtonId]': {
                click: this.saveApplciantAddressDetails
            },
            'addressformwindow[itemId=applicantAddressWindow] button[itemId=cancelButtonId]': {
                click: function() {
                	this.getPersonAddressFormWindow().close();
                }
            },
            
            
            /**
             * Parent Guardian Details
             * 
             */

            'parentguardiangrid[itemId=applicantParentGuardianGrid]': {
            	render: function(grid) {
            		grid.removeCls('exportBtnVisibleGrid');
            		this.doAccessControlValidation(grid, this.getAPPLICANT_PARENTS_GUARDIANS_PERMISSIONS());
            		var this$ = this;    	
                	var applicantProfile = this$.getContentPanelActiveTab();
                	if (applicantProfile) {
                	try{
                		applicantProfile.getApplicationId();
                	} catch(e){
                		applicantProfile = this$.getContentPanel().items.items[0];
                	}
                	
                	if(applicantProfile.getApplicationInfo()['isViewMode']
            		|| !isNullOrEmpty(applicantProfile.getApplicationDataObject()['existingStudentId'])
            		|| ((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
            		){    		
            			this$.mixins.ApplicationBaseController.setContainerInViewMode(grid);
            		}
                    this.loadGridStore('#applicantParentGuardianGrid', SERVERURL.APPLICANT_PARENT_AND_GUARDIAN_DETAILS);                    
                  }
            	},
        		afterrender : function(grid){
        		var pfdButton = grid.down('#btnExportToPDFJasper');
            	var excelButton = grid.down('#btnExportToExcelJasper');
            	var associatedAcadLocationIds = new Array();
            	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            	var viewParentAndGuardianDetails = this.getAPPLICANT_PARENTS_GUARDIANS_PERMISSIONS();
            	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewParentAndGuardianDetails);
            	Ext.each(permissionList, function(privilege) {
            		if (privilege === 'EXPORT') {
            			pfdButton.setVisible(true);
                    	excelButton.setVisible(true);
            		}
            	});
            	}
            },
            'parentguardiangrid[itemId=applicantParentGuardianGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		var formWindowSpecific = this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantParentGuardianForm');
            		if( formWindowSpecific != null ){
            			var form = formWindowSpecific.down('#applicantParentGuardianForm');
                		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#mobileCountryCode");
                        var mobileField = form.down("#cellNo");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                        var countryCodeField = form.down("#phoneCountryCode");
                        var phoneNoField = form.down("#phoneNoField");
                        this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,null);
                        countryCodeField = form.down("#alternateMobileCountryCode");
                        mobileField = form.down("#alternateMobileNo");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
            	}
            },
            'parentguardiangrid[itemId=applicantParentGuardianGrid] splitbutton[itemId=btnExportToPDFJasper] #exportPDFCurrentPage':{
            	click : function(grid) {
            		this.exportPDFParentGuardianReportForApplicant();
            	}
            },
            'parentguardiangrid[itemId=applicantParentGuardianGrid] splitbutton[itemId=btnExportToExcelJasper] #exportExcelCurrentPage':{
            	click : function() {
            		this.exportXLParentGuardianReportForApplicant();
            	}
            },

            'parentguardiangrid[itemId=applicantParentGuardianGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var formWindow = this.editPersonParentGuardianFormWindow('#applicantParentGuardianGrid', 'applicantParentGuardianForm', SERVERURL.APPLICANT_PERSON_RELATIONSHIP_FORM_DETAILS); 
            		if( formWindow != null ){
            			var form = formWindow.down('#applicantParentGuardianForm');
                		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		}
                }
            },
            'parentguardiangrid[itemId=applicantParentGuardianGrid] button[itemId=btnView]': {
                click: function(){
                	this.viewPersonParentGuardianFormWindow('#applicantParentGuardianGrid', 'applicantParentGuardianForm', SERVERURL.APPLICANT_PERSON_RELATIONSHIP_FORM_DETAILS); 
                }
            },
            'parentguardiangrid[itemId=applicantParentGuardianGrid] button[itemId=btnDelete]': {
            	click: function(){
                	this.deletePersonParentGuardianRecord('#applicantParentGuardianGrid', SERVERURL.APPLICANT_PERSON_RELATIONSHIP_DELETE); 
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] button[itemId=submitButtonId]': {
            	click: function(){
                	this.savePersonParentGuardian('APPLICANT', '#applicantParentGuardianGrid', SERVERURL.APPLICANT_PERSON_RELATIONSHIP_ADD, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_UPDATE); 
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] textfield[itemId=employeeIdField]': {
                change: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onChangeDisabledInnerParentGuardianForm(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] button[itemId=searchButtonId]': {
            	click: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.validateEmployeeOrgId(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] checkboxfield[itemId=isEmployeeOrganisation]': {
                change: function(employeeOrg, checkValue, oldValue, eOpts) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                    this.onChangeEmployeeOrgField(parentGuardianForm, checkValue);
                    parentGuardianForm.down('#searchButtonId').setDisabled(false)
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] filefield[itemId=photoFileImageParent]': {
            	change: function(fileField, value, eOpts){
            		var $this = this;
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	fileField.setRawValue(newValue);
                	var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                    var specialCharsExist=false;
                    var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
            		if (extension == "gif" || extension == "png" || extension == "bmp"
                        || extension == "jpeg" || extension == "jpg") {
                         for(i = 0; i < specialChars.length;i++){
                           if(newValue.indexOf(specialChars[i]) > -1){
                               specialCharsExist= true;
                            }
                         }
                        if(specialCharsExist){
                        	fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                        }
            		}else{
            			fileField.reset();
            			showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
            		}
                        
                        
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm]': {
            	render: function() {
            		var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onRenderHideInnerParentGuardianFormField(parentGuardianForm);
                	this.getPersonCommonWindow().doLayout();
                },
                afterrender: function() {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	var personType=this.getContentPanelActiveTab().personType;
                	if(personType=="APPLICANT"){
                		parentGuardianForm.down('#isMobUseForCommunicationField').setVisible(false);
                	}
                	if(parentGuardianForm.down('#applyUpdateToSiblings')!=undefined){
        				var applyUpdateToSiblings = parentGuardianForm.down('#applyUpdateToSiblings');
                		applyUpdateToSiblings.setVisible(false);	
        			}
                	if(parentGuardianForm.down('#isDeceasedField')!=undefined){
        				parentGuardianForm.down('#isDeceasedField').setVisible(false);	
        			}
                	var isAlumnusRadio=parentGuardianForm.down("#isAlumnusRadio").getValue();
                	var schoolAttendedField = parentGuardianForm.down('#schoolAttended');
                	if(isAlumnusRadio==true){
                		parentGuardianForm.down("#schoolAttended").setVisible(true);
                	}else{
                		schoolAttendedField.allowBlank = true;
                		parentGuardianForm.down("#schoolAttended").setVisible(false);
                	}
                	var firstNameOther = parentGuardianForm.down('#firstNameOtherLanguageId');
                	var middleNameOther = parentGuardianForm.down('#middleNameOtherLanguageId');
                	var lastNameOther = parentGuardianForm.down('#lastNameOtherLanguageId');
                	firstNameOther.setVisible(false);
                	middleNameOther.setVisible(false);
                	lastNameOther.setVisible(false);
                	firstNameOther.allowBlank = true;
                	middleNameOther.allowBlank = true;
                	lastNameOther.allowBlank = true;
                	var fieldInfoPersonal = Academia.model.authentication.FormPersonalInfoFieldInfoModel;
                	var formfieldInfoPersonal = fieldInfoPersonal.data.formPersonalInfoFieldsInfo;	
                	var fieldInfoMain = Academia.model.authentication.FormFieldInfoModel;
                	var formfieldInfoMain= fieldInfoMain.data.formFieldsInfo;
                	if(!isNullOrEmpty(formfieldInfoPersonal)){
                		var formfields = formfieldInfoPersonal['parentguardianform'];
                	}else{
                		Ext.Ajax.request({
                	   		type: 'rest',
                	   		async: false,
                	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
                	   		params: {
                	   			screenName: 'parentguardianform',
                	   			academyLocationId: this.getCurrentAcademyLocation(),
                	   			languageCode:'en'
                	   		},
                	   		method: 'GET',
                	   		success: function(res, action) {
                	   			
                	   		}
                	   		
                	   	});
                		var formfields = formfieldInfoMain['parentguardianform'];
                	}
                	if(formfields != undefined){
                		for(var i in formfields){
                			if(!isNullOrEmpty(formfieldInfoPersonal)){
                			var formFieldName = formfields[i].formFieldItemId;
                			}else{
                				var formFieldName = formfields[i].formFieldId;
                			}
                			var isVisible = formfields[i].isVisible;
                			var isMandatory = formfields[i].isMandatory;	
                			if(formFieldName == 'photoFileImage'){
                				parentGuardianForm.down('#parentImageInnerForm').setVisible(isVisible);
                				if(parentGuardianForm.down('button').itemId == 'photoFileImageParent'){
                					parentGuardianForm.down('button').setVisible(isVisible);
                				}
                				if( isMandatory == true ){
                					this.setAllowBlank(parentGuardianForm.down('#parentImageInnerForm'), false);
                				}
                			}
                			if(formFieldName == 'mobileCountryCode'){
                				parentGuardianForm.down('#mobileCountryCode').setVisible(isVisible);
                				if( isMandatory == true ){
                					this.setAllowBlank(parentGuardianForm.down('#mobileCountryCode'), false);
                					parentGuardianForm.down('#mobileCountryCode').setFieldLabel('');
                					parentGuardianForm.down('#parentGuardianMobileField').setFieldLabel(getCommonTranslation('ADDRESS_MOBILE_NO')+'<span style="color:red">*</span>');
                				}
                			}
                			if(formFieldName == 'cellNo'){
                				parentGuardianForm.down('#cellNo').setVisible(isVisible);
                				if( isMandatory == true ){
                					this.setAllowBlank(parentGuardianForm.down('#cellNo'), false);
                					parentGuardianForm.down('#cellNo').setFieldLabel('');
                				}
                			}
                		}
                	}
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] combo[itemId=relationShipField]': {
            	render:function(combo, eOpts){
            		if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
            			var relationship=combo.getStore();
            			relationship.load();
            			relationship.on('load', function(){
            				for(var i=0; i< relationship.data.items.length;i++){
            					if(relationship.data.items[i].data.name == 'LOCAL_GUARDIAN'){
            						relationship.removeAt(i);
            					} 
            				}
            			});
            		}
            	},
            	afterrender: function(combo, eOpts) {
                    this.onRenderParentGuardianRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	var firstNameOther = parentGuardianForm.down('#firstNameOtherLanguageId');
                	var middleNameOther = parentGuardianForm.down('#middleNameOtherLanguageId');
                	var lastNameOther = parentGuardianForm.down('#lastNameOtherLanguageId');
                	firstNameOther.setVisible(false);
                	middleNameOther.setVisible(false);
                	lastNameOther.setVisible(false);
                	firstNameOther.allowBlank = true;
                	middleNameOther.allowBlank = true;
                	lastNameOther.allowBlank = true;
                	this.onSelectRelationshipComboValue(combo, '#applicantParentGuardianGrid', parentGuardianForm);
                }
            },
            
            /**
             *  Sibling form details
             */
            
            'siblingdetailsgrid[itemId=applicantSiblingDetailsGrid]': {
            	render: function(grid) {
            		this.doAccessControlValidation(grid, this.getAPPLICANT_SIBLINGS_PERMISSIONS());
            		var this$ = this;    	
                	var applicantProfile = this$.getContentPanelActiveTab();
                	if (applicantProfile) {
                		try{
                			applicantProfile.getApplicationId();
                		} catch(e){
                			applicantProfile = this$.getContentPanel().items.items[0];
                		}
                	if(applicantProfile.getApplicationInfo()['isViewMode']
            		|| !isNullOrEmpty(applicantProfile.getApplicationDataObject()['existingStudentId'])
            		|| ((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
            		){    		            		
            			this$.mixins.ApplicationBaseController.setContainerInViewMode(grid);
            		}
                    this.loadGridStore('#applicantSiblingDetailsGrid', SERVERURL.APPLICANT_SIBLING_DETAILS);                    
                 }
              }
            },
            'siblingdetailsgrid[itemId=applicantSiblingDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
                    this.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantSiblingForm');
                }
            },
            'siblingdetailsgrid[itemId=applicantSiblingDetailsGrid] button[itemId=btnEdit]': {
            	click: function(){
                	this.editPersonSiblingFormWindow('#applicantSiblingDetailsGrid', 'applicantSiblingForm', SERVERURL.APPLICANT_EDIT_SIBLING_DETAILS); 
                }
            },
            'siblingdetailsgrid[itemId=applicantSiblingDetailsGrid] button[itemId=btnView]': {
            	click: function(){
                	this.viewPersonSiblingFormWindow('#applicantSiblingDetailsGrid', 'applicantSiblingForm', SERVERURL.APPLICANT_EDIT_SIBLING_DETAILS); 
                }
            },
            'siblingdetailsgrid[itemId=applicantSiblingDetailsGrid] button[itemId=btnDelete]': {
                click: function(){
                	this.deletePersonSiblingRecord('#applicantSiblingDetailsGrid', SERVERURL.APPLICANT_PERSON_RELATIONSHIP_DELETE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm]': {
                render: function(siblingForm) {
                	this.onRenderHideInnerSiblingFormField(siblingForm);
                	this.getPersonCommonWindow().doLayout();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm] combo[itemId=relationShipField]': {
                render: function(combo, eOpts) {
                    this.onRenderSiblingRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var siblingForm = this.getPersonSiblingForm();
                	this.onSelectSiblingRelationshipComboValue(combo, '#applicantSiblingForm', siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm] textfield[itemId=siblingStudentId]': {
            	change: function(field, newValue, oldValue, eOpts){
                	var siblingForm = this.getPersonSiblingForm();
                	this.onChangeResetInnerSiblingForm(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm] textfield[itemId=siblingStudentId]': {
            	render: function(combo, eOpts){
            		combo.getStore().getProxy().extraParams = { 
               		 isMultiAccessAllowForSibiling:true
   				  };
                	
                	
                }
            },
           
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm] button[itemId=searchButtonId]': {
                click: function(){
                	var siblingForm = this.getPersonSiblingForm();
                	this.validateSiblingStudentId(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm] button[itemId=submitButtonId]': {
                click: function(btn){
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                	 this.savePersonSibling('APPLICANT', '#applicantSiblingDetailsGrid', SERVERURL.APPLICANT_PERSON_RELATIONSHIP_ADD, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantSiblingForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            /**
             *  Identity Details
             */
            'identitydetailsgrid[itemId=applicantIdentityDetailsGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#applicantIdentityDetailsGrid', SERVERURL.APPLICANT_IDENTITY_DETAIL_GRID);
            		this.doAccessControlValidation(grid, this.getAPPLICANT_IDENTITY_DETAILS_PERMISSIONS());
            		this.addDataGridConfigButton(grid, this.getAPPLICANT_IDENTITY_DETAILS_PERMISSIONS());
            		var this$ = this;    	
                	var applicantProfile = this$.getContentPanelActiveTab();
                	try{
            			applicantProfile.getApplicationId();
            		} catch(e){
            			applicantProfile = this$.getContentPanel().items.items[0];
            		}
                	if(applicantProfile.getApplicationInfo()['isViewMode']
            		|| !isNullOrEmpty(applicantProfile.getApplicationDataObject()['existingStudentId'])
            		|| ((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
            		){    		            		
            			this$.mixins.ApplicationBaseController.setContainerInViewMode(grid);
            		}
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

            		var searchResultGrid =  grid.ownerCt;
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

            		if(columnName=='documents'){
            			if (e.target.tagName == 'A') {
            				var documentId = record.data.documents[0].id;
            				if (!isNullOrEmpty(documentId)) {
            					this.getDocumentController().downloadDocumentFile(documentId);
            				}
            			}
            		}
            	}
            },
            'identitydetailsgrid[itemId=applicantIdentityDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		this.showPersonCommonWindow(formWindow, 'IDENTITY_DETAILS', 'applicantIdentityDetailsForm', true);
            	}
            },
            'identitydetailsgrid[itemId=applicantIdentityDetailsGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editIdentityDetailFormWindow('IDENTITY_DETAILS', 'applicantIdentityDetailsForm', '#applicantIdentityDetailsGrid');
            	}
            },
            'identitydetailsgrid[itemId=applicantIdentityDetailsGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewIdentityDetailFormWindow('IDENTITY_DETAILS', 'applicantIdentityDetailsForm', '#applicantIdentityDetailsGrid');
            		var formWindow = this.getPersonCommonWindow();
                    var identitydetailsform = formWindow.down('identitydetailsform');
                    if(identitydetailsform != null && identitydetailsform != undefined){
                    	var identityDetailsDocId = identitydetailsform.down("#identityDetailsDocId");
                    	if(identityDetailsDocId != null && identityDetailsDocId != undefined){
                    		identityDetailsDocId.setVisible(false);
                    	}
                    }
            	}
            },
            'identitydetailsgrid[itemId=applicantIdentityDetailsGrid] button[itemId=btnDelete]': {
            	click: function(){
                 		//this.deleteIdentityDetailRecord('#applicantIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_DELETE,'APPLICANT'); 
            			this.deleteIdentityDetailOfApplicantAndStudentRecord('#applicantIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_DELETE,'APPLICANT');
       
            	}
            },
            
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.savePersonIdentity('#applicantIdentityDetailsGrid', SERVERURL.APPLICANT_IDENTITY_DETAIL_CREATE, SERVERURL.APPLICANT_IDENTITY_DETAIL_UPDATE);
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },

            
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm] filefield[itemId=identityDetailsDocId]': {
            	change: function(fileField, value, eOpts){
            		var $this = this;
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	fileField.setRawValue(newValue);
                	var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                    var specialCharsExist=false;
                         for(i = 0; i < specialChars.length;i++){
                           if(newValue.indexOf(specialChars[i]) > -1){
                               specialCharsExist= true;
                            }
                         }
                        if(specialCharsExist){
                        	fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                        }
                	if (!isNullOrEmpty(newValue)) {
                	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                	    if ($this.isValidFileExtension(extension)) {
                	        var file = fileField.fileInputEl.dom.files[0];
                	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                	            fileField.reset();
                	            showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_fOR_ADD_CAMPAIGN_DOCUMENT'));
                	        }
                	    } else {
                	        fileField.reset();
                	        showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                	    }
                	}
                }
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm]': {
                render: function(form){
                	if(portalId == 6){
                		if(!isNullOrEmpty(form.down('#validTillDate'))){
                			var ValidTill = form.down('#validTillDate');
          					ValidTill.setMinValue(new Date());
                		}
                	}
                }
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm] datefield#issuedDate':{
            	change:function(obj,newValue,oldValue){
            		if (newValue > new Date()) {
        	            obj.setValue(new Date());
        	        }
            		if(portalId == 6){
            			var form = this.getPersonIdentityDetailsForm();
            			var issuedDate=form.down("#issuedDate");
            			var tilldate=form.down("#validTillDate");
            			if (issuedDate.getValue() < new Date()) {
            				tilldate.setMinValue(new Date());
                        } else {
                        	tilldate.setMinValue(issuedDate.getValue());
                        }
            			 // Prevent future dates
            	        if (newValue > new Date()) {
            	            obj.setValue(new Date());
            	        }
            		}
            	}
    		},
    		'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm] datefield#validTillDate':{
            	change:function(obj,newValue,oldValue){
            		if(portalId == 6){
            			var form = this.getPersonIdentityDetailsForm();
            			var issuedDate=form.down("#issuedDate");
            			var tilldate=form.down("#validTillDate");
                        issuedDate.setMaxValue(newValue);
            		}
            	}
    		},
    		'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=applicantIdentityDetailsForm] datefield#actualFollowUpDate': {
    		    change: function(obj, newValue, oldValue) {
    		        // Prevent past dates
    		        if (newValue < new Date()) {
    		            obj.setValue(new Date());
    		        }
    		    }
    		},
    		
    		 /******************************** Applicant Passport Details***********************************/
    		
    		'applicantpassportgrid[itemId=applicantpassportgridId]': {
	            render: function(grid) {
	            	var this$ = this; 
	            	this$.loadGridStore('#applicantpassportgridId', SERVERURL.PATH_APPLICANT_PASSPORT_DETAIL_GRID_DATA);
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_PASSPORT_PERMISSIONS());
	            	var applicantProfilePanel = grid.up('applicantprofile');
             		var structure = applicantProfilePanel.down('[region=center]');
             		this$.getGridHeaderFreeze(grid,structure,true);
                	var applicantProfile = this$.getContentPanelActiveTab();
                	try{
            			applicantProfile.getApplicationId();
            		} catch(e){
            			applicantProfile = this$.getContentPanel().items.items[0];
            		}
	            },
	            selectionchange: function(column, selected,eOpts ){
            		var grid = column.view.up('grid');
                	if(selected.length > '1'){
            				grid.down('#btnAdd').setDisabled(true);
            				grid.down('#btnEdit').setDisabled(true);
            				grid.down('#btnView').setDisabled(true);
            				grid.down('#btnDelete').setDisabled(false);
            			}else{
            				grid.down('#btnAdd').setDisabled(false);
            				grid.down('#btnEdit').setDisabled(false);
            				grid.down('#btnView').setDisabled(false);
            				grid.down('#btnDelete').setDisabled(false);
            			}
                	},
	            cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if(columnName == "copyOfPassport"){
						if(e.target.tagName=='A'){
							if(record.data.copyOfPassports.length == 1){
								var whetherFile = false;
								var documentId= record.data.copyOfPassports["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}} else if(record.data.copyOfPassports.length > 1){
									var docWindow = this.getApplicantpassportdocumentlist();
									var ID = record.data.id;
									if (!docWindow) {
										docWindow = Ext.widget('applicantpassportdocumentlist',{
											itemId:'applicantpassportdocumentlist'
										});
									}
									docWindow.show();
									var applicantpassportdetaildocumentlistgrid = docWindow.down('#applicantpassportdocumentlistgridItemId');
									 var store = applicantpassportdetaildocumentlistgrid.getStore();
									  store.getProxy().extraParams = {
		         						  ID: record.data.id
		         					  };
		         					  store.load();
								}
						}
					}
					if(columnName == "copyOfPassportUrl"){
						if(e.target.tagName=='A'){
							if(record.data.copyOfPassportUrls.length == 1){
								
							} else if(record.data.copyOfPassportUrls.length > 1){    	
									var docWindow = this.getApplicantpassportdocurllist();
	             					  var ID = record.data.id;
	             					  if (!docWindow) {
	             						  docWindow = Ext.widget('applicantpassportdocurllist',{
	             							  itemId:'applicantpassportdocurllist'
	             						  });
	             					  }
	             					
									docWindow.show();
									var applicantpassportdetaildocumenturllistgrid = docWindow.down('#applicantpassportdocurllistgridItemId');
									 var store = applicantpassportdetaildocumenturllistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						  }
						}
				},
            	afterrender:function(grid){
				var me = this;
				setTimeout(function(){
					me.addDataGridConfigButton(grid,me.getAPPLICANT_PASSPORT_PERMISSIONS());
				},1000);
            	},
            }, 
            
    		'applicantpassportgrid[itemId=applicantpassportgridId] button[itemId=btnAdd]': {
    			click: function() {
                this.isAdd=true;
        		this.passportMode='ADD';
        		var formWindow = this.getPersonCommonWindow();
        		formWindow = this.showPersonCommonWindow(formWindow, 'PASSPORT_DETAILS', 'applicantPassportDetailsFormId', true);
        		  if( formWindow != null ){
        			  var form = formWindow.down('#applicantPassportDetailsFormId');
        			  var fileModifiedDate = form.down('#fileModifiedDate');
        			  fileModifiedDate.setReadOnly(true);
        		  }
    			}
            },
            'applicantpassportgrid[itemId=applicantpassportgridId] button[itemId=btnEdit]': {
            	click: function(){
            		var $this = this;
            		$this.isAdd=false;
            		$this.passportMode='EDIT';
            		$this.editApplicantPassportDetailFormWindow('PASSPORT_DETAILS', 'applicantPassportDetailsFormId', '#applicantpassportgridId', false);
            		$this.applicantDocPassportContainerWindow();
            		$this.applicantUrlPassportContainerWindow();
            	}
            },
            'applicantpassportgrid[itemId=applicantpassportgridId] button[itemId=btnView]': {
            	click: function(){
            		var $this = this;
            		$this.isAdd=false;
            		$this.passportMode='VIEW';
            		$this.viewApplicantPassportDetailFormWindow('PASSPORT_DETAILS', 'applicantPassportDetailsFormId', '#applicantpassportgridId');
            		$this.applicantDocPassportContainerWindow();
            		$this.applicantUrlPassportContainerWindow();
            		var form = this.getStudentpassportdetailsform();
                    form.isValid();
            	}
            },
            'applicantpassportgrid[itemId=applicantpassportgridId] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteApplicantPassportDetailRecord('#applicantpassportgridId', SERVERURL.PATH_APPLICANT_PASSPORT_DETAIL_DELETE);
            	}
            },
            'studentpassportdetailsform[itemId=applicantPassportDetailsFormId] button#submitButtonId' : {
	 			click : function() {
	               this.saveApplicantPassportDetail('#applicantpassportgridId', SERVERURL.PATH_APPLICANT_PASSPORT_DETAIL_ADD, SERVERURL.PATH_APPLICANT_PASSPORT_DETAIL_UPDATE);
	 			}
	 		},
	 		'studentpassportdetailsform[itemId=applicantPassportDetailsFormId] button#cancelButtonId' : {
	            	click: this.closePersonCommonWindow
	 		},
	 		'studentpassportdetailsform[itemId=applicantPassportDetailsFormId] checkboxfield#isPrimary' :{
	 			change:function(val)
	 			{
	 				var form= this.getStudentpassportdetailsform();
	 				var id = form.down("#Student_Passport_Details_hidden_field");
	 				var isPrimaryFiled=form.down('#isPrimary');
	 				var contentPanelTab = this.getContentPanelActiveTab();
	 				var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
					var gridStore  = personInfoPanel.down('applicantpassportgrid').getStore();
						if(this.passportMode=='ADD'){
							if(gridStore.data.items.length!=null){
                        	gridStore.data.items.forEach(function(itemObj){
  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
										isPrimaryFiled.setValue(false);
  								}
                        	 });
                        	}
						}else if(this.passportMode=='EDIT'){
							if(gridStore.data.items.length!=null){
	                        	gridStore.data.items.forEach(function(itemObj){
	  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
											isPrimaryFiled.setValue(false);
	  								}
	                        	 });
	                        	}
						}
                        
	 			}
	 		},
	 		'studentpassportdetailsform[itemId=applicantPassportDetailsFormId] button#uploadPassportDocItemId' : {
	 			click : function() {
	 				this.getDocumentController().showDocumentFormWindow('applicant_Passport_Details_hidden_field','DOCUMENT');
	 				setTimeout(function(){
			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
                    		},100);     
	 			}
	 		},
	 		'studentpassportdetailsform[itemId=applicantPassportDetailsFormId] button#uploadPassportUrlItemId' : {
	 			 			click : function() {
	 			 				this.getDocumentController().showDocumentFormWindow('applicant_Passport_Details_hidden_field','DOCUMENT_URL');
	 			 				var formWindow = this.getDocumentformwindow();
	 		 					if (!formWindow) {
	 		 						Ext.widget('documentformwindow');
	 		 						formWindow = this.getDocumentformwindow();
	 		 					}
	 		 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
	 			 			}
	 			 		},
	 		'documentformwindow[itemId=applicant_Passport_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	 			var isTransient = true;
	 			var module = 'applicantPassport';
	 			var entityId;
	 			var entityType = 'applicantDetailsDocument';

	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	 					function(success,response,isCallBackTransient) {
	 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','applicantPassport','serialNo']
	 						var documentModel = new Academia.model.personinfo.common.personalinfo.ApplicantPassportDocumentModel();
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("path",response.path);
	 						documentModel.set("type",response.type);
	 						documentModel.set("createdBy",$this.getIdValueJson(
	 										response.createdBy.id,response.createdBy.value));
	 						if(documentModel.data.path.length > 255){
	 							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
	 						}else{
	 							var applicantPassportDocGrid = $this.getApplicantpassportdocumentgrid();
		 						var store = applicantPassportDocGrid.getStore();
		 						store.add(documentModel);
		 						
		 						if (applicantPassportDocGrid.isHidden() && store.data.items.length > 0) {
		 							applicantPassportDocGrid.setVisible(true);
		 						}
		 						var form= $this.getStudentpassportdetailsform();
		 		 				if($this.passportMode=='ADD'){
		 		 					 var fileModifiedDate = form.down("#fileModifiedDate");
		 								 fileModifiedDate.setValue(dateRender(new Date()));
		 		 				}else{
		 		 					var fileModifiedDate = form.down("#fileModifiedDate");
		 							    fileModifiedDate.setValue(dateRender(new Date()));
		 		 				}
		 						$this.getDocumentController().closeDocumentFormWindow();
		 						   showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('PASSPORT_DOCUMENT_ADD_SUCCESSFULLY'));
	 						}
	 					}, isTransient);
	 		}
	 	},
	 	'documentformwindow[itemId=applicant_Passport_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
	 		click : function() {
	 			this.getDocumentController()
	 			.closeDocumentFormWindow();
	 		}
	 	},
	 	'documentformwindow[itemId=applicant_Passport_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
 	    	click : function() {
 			var $this = this;
            var form = Ext.ComponentQuery.query('simpleurlform')[0];
            var formPassport= Ext.ComponentQuery.query('studentpassportdetailsform')[0];
            var fileModifiedDate = formPassport.down("#fileModifiedDate");
	            form.down('#documentFormSubmitButtonId').setDisabled(true);

 				fields : ['id','documentId','documentName','path']
 						var documentModelUrl = new Academia.model.personinfo.common.personalinfo.ApplicantPassportUrlModel();
 			            var documentName=form.down('#documentNameField').getValue();
 			            var UrlName=form.down('#documentUrlField').getValue();

 			           documentModelUrl.set("documentName",documentName);
 			           documentModelUrl.set("path",UrlName);
 						var applicantPassportUrlGrid = Ext.ComponentQuery.query('applicantpassporturlgrid')[0];
 						var store2= applicantPassportUrlGrid.getStore();
 						store2.add(documentModelUrl);
 						if (applicantPassportUrlGrid.isHidden() && store2.data.items.length > 0) {
 							applicantPassportUrlGrid.setVisible(true);
	            				}
 		 				if($this.passportMode=='ADD'){
 								 fileModifiedDate.setValue(dateRender(new Date()));
 		 				}else{
 							    fileModifiedDate.setValue(dateRender(new Date()));
 		 				}
 						$this.getDocumentController().closeDocumentFormWindow();
 						   showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('PASSPORT_URL_ADD_SUCCESSFULLY'));
 					
 		}
 	},
 	'documentformwindow[itemId=applicant_Passport_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
 		click : function() {
 			this.getDocumentController()
 			.closeDocumentFormWindow();
 		}
 	},
		'applicantpassportdocumentgrid button#btnDelete' : {
			 click : function() {
				 var $this = this;
				 var grid=$this.getApplicantpassportdocumentgrid();
				var form = Ext.ComponentQuery.query('studentpassportdetailsform')[0];
				 if (grid.getSelectionModel().getCount() > 0) {
					 Ext.MessageBox
					 .confirm(
							 getCommonTranslation('APPLICANT_PASSPORT_DOCUMENT'),
							 getCommonTranslation('APPLICANT_PASSPORT_DELETE_CONFIRM_MESSAGE'),
							function(btn, text) {
								 if (btn == 'yes') {
									if(this.passportMode=='ADD'){
					 					 var fileModifiedDate = form.down("#fileModifiedDate");
											 fileModifiedDate.setValue(dateRender(new Date()));
					 				}else{
					 					var fileModifiedDate = form.down("#fileModifiedDate");
										    fileModifiedDate.setValue(dateRender(new Date()));
					 				}
									 var store = grid.getStore();
									 var record = grid.getSelectionModel().getSelection()[0];
									 var id = record.id;
									 if (isNullOrEmpty(id)) {
									 }else{
										 if (record) {
											 store.remove(record);
											 showSuccessMessage(
													 getCommonTranslation('APPLICANT_PASSPORT_DOCUMENT'),
													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
										 }
									 }

								 }
							 });
				 } else {
					 showWarningMessage(
							 getCommonTranslation('APPLICANT_PASSPORT_DOCUMENT'),
							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 }
			 }
		 },
		 'applicantpassporturlgrid button#btnDelete' : {
			 click : function() {
				 var $this = this;
				 var grid = Ext.ComponentQuery.query('applicantpassporturlgrid')[0];
				 var form = Ext.ComponentQuery.query('studentpassportdetailsform')[0];
				 if (grid.getSelectionModel().getCount() > 0) {
					 Ext.MessageBox
					 .confirm(
							 getCommonTranslation('APPLICANT_PASSPORT_URL'),
							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
							function(btn, text) {
								 if (btn == 'yes') {
									if(this.passportMode=='ADD'){
					 					 var fileModifiedDate = form.down("#fileModifiedDate");
											 fileModifiedDate.setValue(dateRender(new Date()));
					 				}else{
					 					var fileModifiedDate = form.down("#fileModifiedDate");
										    fileModifiedDate.setValue(dateRender(new Date()));
					 				}
									 var store = grid.getStore();
									 var record = grid.getSelectionModel().getSelection()[0];
									 var id = record.id;
									 if (isNullOrEmpty(id)) {
									 }else{
										 if (record) {
											 store.remove(record);
											 showSuccessMessage(
													 getCommonTranslation('APPLICANT_PASSPORT_URL'),
													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
										 }
									 }

								 }
							 });
				 } else {
					 showWarningMessage(
							 getCommonTranslation('APPLICANT_PASSPORT_URL'),
							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 }
			 }
		 },
		 'applicantpassportdocumentgrid' : {
			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				 var $this = this;
				 var documentGrid = $this.getApplicantpassportdocumentgrid();
				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
				 if (columnName == "documentName") {
					 if (e.target.tagName == 'A') {
						 var documentId = record
						 .get("documentId");
						 if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					 }

				 }
			 }
		 },
		 'applicantpassportdocumentlistgrid':{
				render: function(grid) {
					var this$ = this;
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_PASSPORT_DOCUMENT_PERMISSION());
	            	grid.down('#downloadDocumentItemId').setVisible(true);
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							var documentId=record.get('documentId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
											showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('DOWNLOAD_PASSPORT_DOCUMENT_ADD_SUCCESSFULLY'));
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
			},
			'applicantpassportdocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getApplicantpassportdocumentlist();
					var applicantPassportDetailActionGrid=form.down('#applicantpassportdocumentlistgridItemId');
					if (applicantPassportDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = applicantPassportDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Applicant Passport Detail Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('APPLICANT_PASSPORT_DETAIL_DOCUMENTS'),
									getCommonTranslation('APPLICANT_PASSPORT_DETAIL_DOCUMENTS_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('DOWNLOAD_PASSPORT_DOCUMENT_SUCCESSFULLY'));
								}
							});

							
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
      	 },
      	'applicantpassportdocgrid' : {
			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				 var $this = this;
				 var documentGrid = $this
				 .getApplicantpassportdocgrid();
				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
				 if (columnName == "documentName") {
					 if (e.target.tagName == 'A') {
						 var documentId = record.get("documentId");
						 if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					 }

				 }
			 }
		 },
		 'applicantpassportdocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this=this;
					var applicantPassportDetailgrid = $this.getApplicantpassportdocumentlistgrid();  
					var applicantPassportDetailList= $this.getApplicantpassportgrid();
					if (applicantPassportDetailgrid.getSelectionModel().getCount() > 0) {
						var records = applicantPassportDetailgrid.getSelectionModel().getSelection();
						var ids=[];
						Ext.Array.each(records,function(value){
							ids.push(value.data.id);
						});
							showConfirmMessage(getCommonTranslation('APPLICANT_PASSPORT'),getCommonTranslation('APPLICANT_PASSPORT_DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes'){
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method: "DELETE",
									type: 'rest',
									url : SERVERURL.PATH_APPLICANT_PASSPORT_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('APPLICANT_PASSPORT'),getCommonTranslation('APPLICANT_PASSPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
										applicantPassportDetailgrid.store.reload();
										applicantPassportDetailList.store.reload();
										applicantPassportDetailgrid.getSelectionModel().deselectAll(true);
									}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
		 },
		 'applicantpassportdocurllistgrid':{
			 render: function(grid) {
				 var this$ = this; 
				 this$.doAccessControlValidation(grid, this$.getAPPLICANT_PASSPORT_URL_PERMISSION());
			 }
		 },
		 'applicantpassportdocurllistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this=this;
					var form = $this.getApplicantpassportdocurllist();  
					var applicantPassportDetailList= $this.getApplicantpassportgrid();
					var applicantPassportUrlGrid = Ext.ComponentQuery.query('applicantpassporturlgrid')[0];
					var applicantPassportDetaillistgrid=form.down('#applicantpassportdocurllistgridItemId');
					if (applicantPassportDetaillistgrid.getSelectionModel().getCount() > 0) {
						var records = applicantPassportDetaillistgrid.getSelectionModel().getSelection();
						var ids=[];
						Ext.Array.each(records,function(value){
							ids.push(value.data.id);
						});
							showConfirmMessage(getCommonTranslation('APPLICANT_PASSPORT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
							if (btn == 'yes'){
								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
								Ext.Ajax.request({
									method: "DELETE",
									type: 'rest',
									url : SERVERURL.PATH_APPLICANT_PASSPORT_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

										Ext.getBody().unmask();
										showSuccessMessage(getCommonTranslation('APPLICANT_PASSPORT'),getCommonTranslation('APPLICANT_PASSPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
										applicantPassportDetaillistgrid.store.reload();
										applicantPassportDetailList.store.reload();
										applicantPassportDetaillistgrid.getSelectionModel().deselectAll(true);
									}
								});
							}
						});
					} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				}
		 },
		  		    
	 	   /*applicant visa */
	 	'applicantvisagrid[itemId=applicantvisagridId]': {
            render: function(grid) {
            	var this$ = this;    	
            	this$.loadGridStore('#applicantvisagridId', SERVERURL.PATH_APPLICANT_VISA_DETAIL_GRID_DATA);
            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_VISA_PERMISSIONS());
            	var applicantProfilePanel = grid.up('applicantprofile');
         		var structure = applicantProfilePanel.down('[region=center]');
         		this$.getGridHeaderFreeze(grid,structure,true);
            	var applicantProfile = this$.getContentPanelActiveTab();
            	try{
        			applicantProfile.getApplicationId();
        		} catch(e){
        			applicantProfile = this$.getContentPanel().items.items[0];
        		}
            },
            selectionchange: function(column, selected,eOpts ){
                var grid = column.view.up('grid');
                if(selected.length > '1'){
                        grid.down('#btnAdd').setDisabled(true);
                        grid.down('#btnEdit').setDisabled(true);
                        grid.down('#btnView').setDisabled(true);
                        grid.down('#btnDelete').setDisabled(false);
                    }else{
                        grid.down('#btnAdd').setDisabled(false);
                        grid.down('#btnEdit').setDisabled(false);
                        grid.down('#btnView').setDisabled(false);
                        grid.down('#btnDelete').setDisabled(false);
                    }
                },
			
        	afterrender:function(grid){
			var me = this;
			setTimeout(function(){
				me.addDataGridConfigButton(grid,me.getAPPLICANT_VISA_PERMISSIONS());
			},1000);
        	},
        	cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
				if(columnName == "visaUploadDocument"){
					if(e.target.tagName=='A'){
						if(record.data.studentVisaDocument.length == 1){
							var whetherFile = false;
							var documentId= record.data.studentVisaDocument["0"].id;
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}} else if(record.data.studentVisaDocument.length > 1){
								var docWindow = this.getApplicantvisadocumentlist();
								var ID = record.data.id;
								if (!docWindow) {
									docWindow = Ext.widget('applicantvisadocumentlist',{
										itemId:'applicantvisadocumentlist'
									});
								}
								docWindow.show();
								var appvisadetaildocumentlistgrid = docWindow.down('#applicantvisadocumentlistgridItemId');
								 var store = appvisadetaildocumentlistgrid.getStore();
								  store.getProxy().extraParams = {
             						  ID: record.data.id
             					  };
             					  store.load();
							}
					}
				}
				if(columnName == "visaUploadUrl"){
					if(e.target.tagName=='A'){
						if(record.data.studentVisaDocumentUrl.length == 1){
							
						} else if(record.data.studentVisaDocumentUrl.length > 1){    	
								var docWindow = this.getApplicantvisadocurllist();
             					  var ID = record.data.id;
             					  	             					  
             					 if (!docWindow) {
									docWindow = Ext.widget('applicantvisadocurllist',{
										itemId:'applicantvisadocurllist'
									});
             					 }
								docWindow.show();
								
								var appvisadetaildocumenturllistgrid = docWindow.down('#applicantvisadocurllistgridItemId');
								 var store = appvisadetaildocumenturllistgrid.getStore();
								  store.getProxy().extraParams = {
             						  ID: record.data.id
             					  };
             					  store.load();
							}
					  }
					}
			}
        }, 
        'visaform[itemId=applicantvisaformId]': {
        	afterrender: function(obj) {
            	var form = obj.getForm();
            	var visaTypeStore = form.findField('visaType').getStore();
            	visaTypeStore.getProxy().extraParams={
    				type:'Visa Type'
    			};
            	
            	var visaStatusStore = form.findField('visaStatus').getStore();
            	visaStatusStore.getProxy().extraParams={
    				type:'Visa Status'
    			};
            	
            	if(this.isAdd){
            		obj.up().setTitle(getCommonTranslation('ADD_VISA'));
				}else{
					obj.up().setTitle(getCommonTranslation('EDIT_VISA'));
				}
            }
        },
        'applicantvisagrid[itemId=applicantvisagridId] button[itemId=btnAdd]': {
        	click: function() {
        		this.isAdd=true;
        		this.visaMode = 'ADD';
        		var formWindow = this.getPersonCommonWindow();
        		this.showPersonCommonWindow(formWindow, 'VISA_FORM', 'applicantvisaformId', true);
        	}
        },
        	 	
        'applicantvisagrid[itemId=applicantvisagridId] button[itemId=btnEdit]': {
        	click: function(){
        		this.isAdd=false;
        		this.visaMode='EDIT';
        		this.editApplicantVisaDetailWindow('VISA_FORM', 'applicantvisaformId', '#applicantvisagridId', false);
             	this.applicantDocVisaContainerWindow();
        	    this.applicantUrlVisaContainerWindow();
        		
        	}
        },
        'applicantvisagrid[itemId=applicantvisagridId] button[itemId=btnView]': {
        	click: function(){
        		this.isAdd=false;
        		this.visaMode='VIEW';
        		this.viewApplicantVisaDetail('VISA_FORM', 'applicantvisaformId', '#applicantvisagridId', true);
        		this.applicantDocVisaContainerWindow();
        		this.applicantUrlVisaContainerWindow();
        		var form =  this.getVisaform();
        		form.isValid();
        	}
        },
        'applicantvisagrid[itemId=applicantvisagridId] button[itemId=btnDelete]': {
        	click: function(){
        		this.deleteApplicantVisaDetail('#applicantvisagridId', SERVERURL.PATH_APPLICANT_VISA_DETAIL_DELETE);
        	}
        },
        
        'visaform[itemId=applicantvisaformId] checkboxfield#visaIsPrimaryItemId' :{
            change:function(val)
            {
 				var form= this.getVisaform();
 				var id = form.down("#visa_detail_hidden_field");
 				var isPrimaryFiled=form.down('#visaIsPrimaryItemId');
				var portalId = this.getCurrentLoggedPortalId();
				if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
					var studentPortalGrid  = this.getApplicantvisagrid().getStore();
					if(this.visaMode=='ADD'){
						if(studentPortalGrid.data.items.length!=null){
							studentPortalGrid.data.items.forEach(function(itemObj){
								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
									isPrimaryFiled.setValue(false);
								}
                    	 });
                    	}
					}else if(this.visaMode=='EDIT'){
						if(studentPortalGrid.data.items.length!=null){
							studentPortalGrid.data.items.forEach(function(itemObj){
  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
										isPrimaryFiled.setValue(false);
  								}
                        	 });
                        	}
					}
					
				}else{
					var contentPanelTab = this.getContentPanelActiveTab();
	 				var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
					var gridStore  = personInfoPanel.down('applicantvisagrid').getStore();
					if(this.visaMode=='ADD'){
						if(gridStore.data.items.length!=null){
                    	gridStore.data.items.forEach(function(itemObj){
								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
									isPrimaryFiled.setValue(false);
								}
                    	 });
                    	}
					}else if(this.visaMode=='EDIT'){
						if(gridStore.data.items.length!=null){
                        	gridStore.data.items.forEach(function(itemObj){
  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
										isPrimaryFiled.setValue(false);
  								}
                        	 });
                        	}
					}
				}			   
 			}
        },
        
        'visaform[itemId=applicantvisaformId] button#submitButtonId' : {
 			click : function() {
               this.saveApplicantVisaDetail('#applicantvisagridId', SERVERURL.PATH_APPLICANT_VISA_DETAIL_ADD, SERVERURL.PATH_APPLICANT_VISA_DETAIL_UPDATE);
 			}
 		},
 		'visaform[itemId=applicantvisaformId] button#cancelButtonId' : {
            	click: this.closePersonCommonWindow
 		},
       'visaform[itemId=applicantvisaformId] button#visaUploadFileItemId' : {
 			click : function() {
 				this.getDocumentController().showDocumentFormWindow('applicant_visa_detail_hidden_field','DOCUMENT');
 				setTimeout(function(){
		            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
			            form.down('#documentNameField').allowBlank=true;
			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
                		},100);     
 			}
 		},
 		'visaform[itemId=applicantvisaformId] button#visaUploadURLItemId' : {
 			 			click : function() {
 			 				this.getDocumentController().showDocumentFormWindow('applicant_visa_detail_hidden_field','DOCUMENT_URL');
 			 				var formWindow = this.getDocumentformwindow();
 		 					if (!formWindow) {
 		 						Ext.widget('documentformwindow');
 		 						formWindow = this.getDocumentformwindow();
 		 					}
 		 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
 			 			}
 			 		},
 		'documentformwindow[itemId=applicant_visa_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
 	    	click : function() {
	 			var $this = this;
	 			var isTransient = true;
	 			var module = 'applicantVisa';
	 			var entityId;
	 			var entityType = 'applicantVisaDocument';
	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	 					function(success,response,isCallBackTransient) {
	 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
	 						var documentModel = new Academia.model.personinfo.common.personalinfo.ApplicantVisaDocumentGridModel();
	 						documentModel.set("name",response.name);
	 						documentModel.set("path",response.path);
	 						documentModel.set("type",response.type);
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
	 						if(documentModel.data.path.length > 255){
	                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
	                          }else {
			 						var StudentVisaDocGrid = $this.getApplicantvisadocumentgrid();
			 						var store = StudentVisaDocGrid.getStore();
			 						store.add(documentModel);
			 						if (StudentVisaDocGrid.isHidden() && store.data.items.length > 0) {
			 							StudentVisaDocGrid.setVisible(true);
			 						}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						showSuccessMessage(getCommonTranslation('APPLICANT_VISA'),getCommonTranslation('VISA_DOCUMENT_ADD_SUCCESSFULLY'));
	                          }
	 					}, isTransient);
		 		}
 	},
 	'documentformwindow[itemId=applicant_visa_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
 		click : function() {
 			this.getDocumentController()
 			.closeDocumentFormWindow();
 		}
 	},
 	'documentformwindow[itemId=applicant_visa_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
	    	click : function() {
	 			var $this = this;
	 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
	            form.down('#documentFormSubmitButtonId').setDisabled(true);
	 				fields : ['id','documentId','documentName','path','createdBy']
	 						var documentModelUrl = new Academia.model.personinfo.common.personalinfo.ApplicantVisaUrlModel();
				            var form = Ext.ComponentQuery.query('simpleurlform')[0];

	 			            var documentName=form.down('#documentNameField').getValue();
	 			            var UrlName=form.down('#documentUrlField').getValue();
	 			            documentModelUrl.set("documentName",documentName);
	 			            documentModelUrl.set("path",UrlName);
	 			            
	 			           documentModelUrl.set("type",'DOCUMENT');
	 			           var userId = this.getCurrentlyLoggedInUser()
	 			           documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
	 			           
                    	  var StudentVisaUrlGrid = Ext.ComponentQuery.query('applicantvisaurlgrid')[0];
                    	  var store2= StudentVisaUrlGrid.getStore();
                    	  store2.add(documentModelUrl);
                    	  if (StudentVisaUrlGrid.isHidden() && store2.data.items.length > 0) {
                    		  StudentVisaUrlGrid.setVisible(true);
                    	  }
                    	  $this.getDocumentController().closeDocumentFormWindow();
                    	  showSuccessMessage(getCommonTranslation('APPLICANT_VISA'),getCommonTranslation('VISA_URL_ADD_SUCCESSFULLY'));
	 						
	 		}
	},
	'documentformwindow[itemId=applicant_visa_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		click : function() {
			this.getDocumentController()
			.closeDocumentFormWindow();
		}
	},
		'applicantvisadocumentgrid button#btnDelete' : {
 			 click : function() {
 				 var $this = this;
 				 var grid=$this.getApplicantvisadocumentgrid();
 				 if (grid.getSelectionModel().getCount() > 0) {
 					 Ext.MessageBox.confirm(
 							getCommonTranslation('APPLICANT_VISA_DOCUMENT'),
 							 getCommonTranslation('APPLICANT_VISA_DELETE_CONFIRM_MESSAGE'),
 							function(btn, text) {
 								 if (btn == 'yes') {
 									 var store = grid.getStore();
 									 var record = grid.getSelectionModel().getSelection()[0];
 									 var id = record.id;
 									 if (isNullOrEmpty(id)) {
 									 }else{
 										 if (record) {
 											 store.remove(record);
 											 showSuccessMessage(getCommonTranslation('APPLICANT_VISA_DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 											 if(store.data.items.length == 0) {
 												grid.setVisible(false);
 					 						}
 										 }
 									 }

 								 }
 							 });
 				 } else {
 					 showWarningMessage(
 							 getPersonModuleTranslation('APPLICANT_VISA'),
 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
 				 }
 			 }
 		 },
 		 
 		'applicantvisaurlgrid button#btnDelete' : {
			 click : function() {
				 var $this = this;
				 var grid = Ext.ComponentQuery.query('applicantvisaurlgrid')[0];
				 if (grid.getSelectionModel().getCount() > 0) {
					 Ext.MessageBox.confirm(getPersonModuleTranslation('APPLICANT_VISA_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
							function(btn, text) {
								 if (btn == 'yes') {
									 var store = grid.getStore();
									 var record = grid.getSelectionModel().getSelection()[0];
									 var id = record.id;
									 if (isNullOrEmpty(id)) {
									 }else{
										 if (record) {
											 store.remove(record);
											 showSuccessMessage(
											 getPersonModuleTranslation('APPLICANT_VISA_URL'),
											 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
											 if(store.data.items.length == 0) {
												grid.setVisible(false);
					 						}
										 }
									 }
								 }
							 });
				 } else {
					 showWarningMessage(
							 getPersonModuleTranslation('APPLICANT_VISA'),
							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 }
			 }
		 },
	
		'applicantvisadocumentgrid' : {
			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				 var $this = this;
				 var documentGrid = $this.getApplicantvisadocumentgrid();
				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
				 if (columnName == "documentName") {
					 if (e.target.tagName == 'A') {
						 var documentId;
						 if(record!=null){
							 if(record.raw!=null)
							 documentId = record.raw.ecrptydocumentId;
						 }
						  if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					 }

				 }
			 }
		 },
	
			'applicantvisadocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getApplicantvisadocumentlist();
					var ApplicantVisaDetailActionGrid=obj.up('grid');
					if (ApplicantVisaDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = ApplicantVisaDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Applicant Visa Detail Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('APPLICANT_VISA_DETAIL_DOCUMENT'),
									getCommonTranslation('APPLICANT_VISA_DETAIL_DOCUMENTS_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
								}
							});
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
    	 },
    	 
    	'applicantvisadocumentlistgrid' : {
    			 render: function(grid) {
    				 var this$ = this;
    				 this$.doAccessControlValidation(grid, this$.getAPPLICANT_VISA_DOCUMENT_PERMISSION());
    				 grid.down('#downloadDocumentItemId').setVisible(true);
    			 },
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = grid.up('grid');
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') 
						 { 
							 var documentId;
						 if(record!=null){
							 if(record.raw!=null)
							 documentId = record.raw.ecrptydocumentId;
						 }
						  if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					}
					 }
				 }
			 },
			 'applicantvisadocurllist':{
				 render: function(grid) {
					 var this$ = this;
					 this$.doAccessControlValidation(grid, this$.getAPPLICANT_VISA_URL_PERMISSION());
				 }
			 },
			 'applicantvisadocurllist button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getApplicantvisadocurllist();  
	 					var applicantvisagrid= $this.getApplicantvisagrid();
	 					var applicantVisaUrlListgrid=form.down('#applicantvisadocurllistgridItemId');
	 					if (applicantVisaUrlListgrid.getSelectionModel().getCount() > 0) {
	 						var records = applicantVisaUrlListgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getPersonModuleTranslation('APPLICANT_VISA_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_APPLICANT_VISA_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getPersonModuleTranslation('APPLICANT_VISA_URL'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
	 										applicantVisaUrlListgrid.store.reload();
	 										applicantvisagrid.store.reload();
	 										applicantVisaUrlListgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	      
			 'applicantvisadocumentlistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getApplicantvisadocumentlist();  
	 					var applicantvisagrid= $this.getApplicantvisagrid();
	 					var applicantVisalistgrid=form.down('#applicantvisadocumentlistgridItemId');
	 					if (applicantVisalistgrid.getSelectionModel().getCount() > 0) {
	 						var records = applicantVisalistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('APPLICANT_VISA_DOCUMENT'),getCommonTranslation('APPLICANT_VISA_DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_APPLICANT_VISA_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('APPLICANT_VISA_DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
	 										applicantVisalistgrid.store.reload();
	 										applicantvisagrid.store.reload();
	 										applicantVisalistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
         
 		
            /******************************** Other Information***********************************/
            'otherinformationdetailsform[itemId=applicantOtherinformationDetailsForm]': {
                render: function(form){
                	var url = SERVERURL.FIND_BY_ID_APPLICANTOTHER_INFORMATION+'userId=';
                	this.onRenderOtherInformationForm(url, 'APPLICANT');
                	this.disableOtherInformaionFormPivileges(form,this.getAPPLICANT_OTHER_INFORMATION_DETAILS_PERMISSIONS());
                }
            },
            'otherinformationdetailsform[itemId=applicantOtherinformationDetailsForm] button[itemId=submitButtonId]': {
                click: function(){
                	var getUrl = SERVERURL.FIND_BY_ID_APPLICANTOTHER_INFORMATION+'userId=';
                	this.saveOtherInformation(SERVERURL.SAVE_APPLICANT_OTHER_INFORMATION, getUrl, 'APPLICANT');
                }
            },
            
            
            /**
	       	/**
	       	   *  Insurance Details
	        */
            'applicantinsurancedetailsgrid[itemId=applicantInsuranceDetailsGrid]': {           	
	           	render: function(grid) {
	            	var this$ = this; 
	            	var portalId = this$.getCurrentLoggedPortalId();
	            	this$.loadGridStore('#applicantInsuranceDetailsGrid', SERVERURL.PATH_APPLICANT_INSURANCE_DETAIL_GRID_DATA);
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_INSURANCE_DETAILS_PERMISSIONS());
	            	var applicantProfilePanel = grid.up('applicantprofile');
             		var structure = applicantProfilePanel.down('[region=center]');
             		if(portalId == 1) {
                        var  store = grid.getStore();
                        store.load({
                              callback:function() {
                                  if(store.getCount()>5) {
                                	  this$.getGridHeaderFreeze(grid,structure,true);
                                  }            
                              }
                          });
                    }else {
                    	this$.getGridHeaderFreeze(grid,structure,true);
                    }
                	var applicantProfile = this$.getContentPanelActiveTab();
                	try{
            			applicantProfile.getApplicationId();
            		} catch(e){
            			applicantProfile = this$.getContentPanel().items.items[0];
            		}
	            },
	           	afterrender:function(grid){
	   				var me = this;
	   				setTimeout(function(){
	   					me.addDataGridConfigButton(grid,me.getAPPLICANT_INSURANCE_DETAILS_PERMISSIONS());
	   				},1000);
	   			},
	   			
	   			selectionchange: function(column, selected,eOpts ){
	                   var grid = column.view.up('grid');
		                if(selected.length > '1'){
	                       grid.down('#btnAdd').setDisabled(true);
	                       grid.down('#btnEdit').setDisabled(true);
	                       grid.down('#btnView').setDisabled(true);
	                       grid.down('#btnDelete').setDisabled(false);
	                   }else{
	                       grid.down('#btnAdd').setDisabled(false);
	                       grid.down('#btnEdit').setDisabled(false);
	                       grid.down('#btnView').setDisabled(false);
	                       grid.down('#btnDelete').setDisabled(false);
	                   }
	               },
	               
	               cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
						var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
						if(columnName == "applicantInsuranceDocuments"){
							if(e.target.tagName=='A'){
								if(record.data.applicantInsuranceDocuments.length == 1){
									var whetherFile = false;
									var documentId= record.data.applicantInsuranceDocuments["0"].id;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}} else if(record.data.applicantInsuranceDocuments.length > 1){
										var docWindow = this.getApplicantinsurancedocumentlist();
										var ID = record.data.id;
										if (!docWindow) {
											docWindow = Ext.widget('applicantinsurancedocumentlist',{
												itemId:'applicantinsurancedocumentlist'
											});
										}
										docWindow.show();
										var applicantinsurancedetaildocumentlistgrid = docWindow.down('#applicantinsurancedocumentlistgridItemId');
										 var store = applicantinsurancedetaildocumentlistgrid.getStore();
										  store.getProxy().extraParams = {
		             						  ID: record.data.id
		             					  };
		             					  store.load();
									}
							}
						}
						if(columnName == "applicantInsuranceDocumentUrls"){
							if(e.target.tagName=='A'){
								if(record.data.applicantInsuranceDocumentUrls.length == 1){
									
								} else if(record.data.applicantInsuranceDocumentUrls.length > 1){    	
										var docWindow = this.getApplicantinsurancedocurllist();
		             					  var ID = record.data.id;
		             					  if (!docWindow) {
		             						  docWindow = Ext.widget('applicantinsurancedocurllist',{
		             							  itemId:'applicantinsurancedocurllist'
		             						  });
		             					  }
		             					
										docWindow.show();
										var applicantinsurancedocurllistgrid = docWindow.down('#applicantinsurancedocurllistgridItemId');
										 var store = applicantinsurancedocurllistgrid.getStore();
										  store.getProxy().extraParams = {
		             						  ID: record.data.id
		             					  };
		             					  store.load();
									}
							  }
							}
					}
            },
            
            'applicantinsurancedocumentlistgrid':{
            	render: function(grid) {
					var this$ = this;
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_INSURANCE_DOCUMENT_PERMISSION());
	            	grid.down('#downloadDocumentItemId').setVisible(true);
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							var documentId=record.get('documentId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
											showSuccessMessage(getCommonTranslation('INSURANCE'),getCommonTranslation('DOWNLOAD_INSURANCE_DOCUMENT_SUCCESSFULLY'));
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
			},
			
			'applicantinsurancedocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var ApplicantInsuranceActionGrid=obj.up('grid');
					if (ApplicantInsuranceActionGrid.getSelectionModel().getCount() > 0) {
						var records = ApplicantInsuranceActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Applicant Insurance Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('APPLICANT_INSURANCE_DETAILS_DOCUMENTS'),
									getCommonTranslation('APPLICANT_INSURANCE_DETAILS_DOCUMENTS_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									showSuccessMessage(getCommonTranslation('INSURANCE'),getCommonTranslation('DOWNLOAD_INSURANCE_DOCUMENT_SUCCESSFULLY'));
								}
							});
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
      	 },
      	'applicantinsurancedocumentgrid' : {
			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				 var $this = this;
				 var documentGrid = grid.up('grid');
				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
				 if (columnName == "documentName") {
					 if (e.target.tagName == 'A') {
						 var documentId = record.get("documentId");
						 if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					 }
				 }
			 }
		 },
      	 
      	 
      	 
      	 /*Insurance*/
		 'applicantinsurancedetailsgrid[itemId=applicantInsuranceDetailsGrid] button[itemId=btnAdd]': {
			    click: function() {
			        this.isAdd = true;
			        this.visaMode = 'ADD';
			        var formWindow = this.getPersonCommonWindow();
			        this.showPersonCommonWindow(formWindow, 'INSURANCE_FORM', 'applicantinsuranceformId', true);
			        var form = this.getInsuranceform();
			        var schoolInsuranceTypeField = form.getForm().findField('schoolInsuranceType');

			        if (!schoolInsuranceTypeField || schoolInsuranceTypeField.getValue() === null) {
			            form.getForm().findField('validFrom').setVisible(false);
			            form.getForm().findField('validTo').setVisible(false);
			            form.getForm().findField('nameOfInsuranceCompany').setVisible(false);
			            form.getForm().findField('policyNumber').setVisible(false);
			            form.getForm().findField('schoolInsuranceCardReceived').setVisible(false);
			            form.getForm().findField('receivedDate').setVisible(false);
			            form.getForm().findField('validFrom').allowBlank = true;
			            form.getForm().findField('validTo').allowBlank = true;
			            form.getForm().findField('nameOfInsuranceCompany').allowBlank = true;
			            form.getForm().findField('policyNumber').allowBlank = true;
			            form.getForm().findField('schoolInsuranceCardReceived').allowBlank = true;
			            form.getForm().findField('receivedDate').allowBlank = true;
			            if(form.isValid()){
			            	form.down('#submitButtonId').setDisabled(false);
			            }else{
			            	form.down('#submitButtonId').setDisabled(true);
			            }
			        }
			    }
			},

         'applicantinsurancedetailsgrid[itemId=applicantInsuranceDetailsGrid] button[itemId=btnEdit]': {
         	click: function(){
         		this.isAdd=false;
         		this.visaMode='EDIT';
         		this.editApplicantInsuranceDetailWindow('INSURANCE_FORM', 'applicantinsuranceformId', '#applicantInsuranceDetailsGrid', false);
              	this.applicantDocInsuranceContainerWindow();
         	    this.applicantUrlInsuranceContainerWindow();
         		
         	}
         },
          'applicantinsurancedetailsgrid[itemId=applicantInsuranceDetailsGrid] button[itemId=btnView]': {
         	click: function(){
         		this.isAdd=false;
         		this.visaMode='VIEW';
         		this.viewApplicantInsuranceDetail('INSURANCE_FORM', 'applicantinsuranceformId', '#applicantInsuranceDetailsGrid', true);
         		this.applicantDocInsuranceContainerWindow();
         		this.applicantUrlInsuranceContainerWindow();
         		var form = this.getInsuranceform();
         		form.isValid();
         	}
         },
         'applicantinsurancedetailsgrid[itemId=applicantInsuranceDetailsGrid] button[itemId=btnDelete]': {
         	click: function(){
         		this.deleteApplicantInsuranceDetail('#applicantInsuranceDetailsGrid', SERVERURL.PATH_APPLICANT_INSURANCE_DETAIL_DELETE);
         	}
         },
         'insuranceform[itemId=applicantinsuranceformId] nestedJsonCombo#schoolInsuranceTypeItemId':{
        	 select: function(combo, record) {
        		var form = combo.up('insuranceform');
        		var schoolInsuranceType = form.down('#schoolInsuranceTypeItemId');
        		var validFrom = form.down('#validFrom');
 				var validTo = form.down('#validTo');
 				var nameOfInsuranceCompany = form.down('#nameOfInsuranceCompany');
 				var policyNumber = form.down('#policyNumber');
 				var schoolInsuranceCardReceived = form.down('#schoolInsuranceCardReceived');
 				var receivedDate = form.down('#receivedDate');
 				var newValue = record[0].data.value;
 				if(newValue=='Private Health Insurance'){
 					this.loadDFRForSchoolInsuranceType(schoolInsuranceType);
 					if(form.isValid()){
 						form.down('#submitButtonId').setDisabled(false);
 					}else{
 						form.down('#submitButtonId').setDisabled(true);
 					}
 				}else{
 					validFrom.setVisible(false);
 					validTo.setVisible(false);
 					nameOfInsuranceCompany.setVisible(false);
 					policyNumber.setVisible(false);
 					schoolInsuranceCardReceived.setVisible(false);
 					receivedDate.setVisible(false);
 					validFrom.allowBlank = true;
 					validTo.allowBlank = true;
 					nameOfInsuranceCompany.allowBlank = true;
 					policyNumber.allowBlank = true;
 					schoolInsuranceCardReceived.allowBlank = true;
 					receivedDate.allowBlank = true;
 					validFrom.reset();
 					validTo.reset();
 					nameOfInsuranceCompany.reset();
 					policyNumber.reset();
 					schoolInsuranceCardReceived.setValue(false);
 					receivedDate.reset();
 				}
 			 }
 		 },
         'insuranceform[itemId=applicantinsuranceformId] radiogroup#schoolInsuranceCardReceived':{
 			 change:function(obj,newValue,oldValue){
 				var form = this.getInsuranceform();
 				var schoolInsuranceCardReceived = form.down('#schoolInsuranceCardReceived');
 				var receivedDate = form.down('#receivedDate');
 				 var value = newValue.schoolInsuranceCardReceived;
 				 if(value==true){
 					this.loadDFRForSchoolInsuranceCardReceived(schoolInsuranceCardReceived);
 					if(form.isValid()){
 						form.down('#submitButtonId').setDisabled(false);
 					}else{
 						form.down('#submitButtonId').setDisabled(true);
 					}
 				 }else{
 					receivedDate.allowBlank = true;
 					receivedDate.setVisible(false);
 					receivedDate.reset();
 					if(form.isValid()){
 						form.down('#submitButtonId').setDisabled(false);
 					}
 				 }
 			 }
 		 },
      	 
         'insuranceform[itemId=applicantinsuranceformId] button#insuranceUploadFileItemId' : {
  			click : function() {
  				this.getDocumentController().showDocumentFormWindow('applicant_insurance_detail_hidden_field','DOCUMENT');
  				setTimeout(function(){
 		            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
                 		},100);     
  			}
  		},
  		'insuranceform[itemId=applicantinsuranceformId] button#insuranceUploadURLItemId' : {
  			 			click : function() {
  			 				this.getDocumentController().showDocumentFormWindow('applicant_insurance_detail_hidden_field','DOCUMENT_URL');
  			 				var formWindow = this.getDocumentformwindow();
  		 					if (!formWindow) {
  		 						Ext.widget('documentformwindow');
  		 						formWindow = this.getDocumentformwindow();
  		 					}
  		 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
  			 			}
  			 		},
      	 
            
  		'documentformwindow[itemId=applicant_insurance_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
  			 	    	click : function() {
  				 			var $this = this;
  				 			var isTransient = true;
  				 			var module = 'applicantInsurance';
  				 			var entityId;
  				 			var entityType = 'applicantInsuranceDocument';
  				 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
  				 					function(success,response,isCallBackTransient) {
  				 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
  				 						var documentModel = new Academia.model.personinfo.common.personalinfo.ApplicantInsuranceDocumentGridModel();
  				 						documentModel.set("name",response.name);
  				 						documentModel.set("path",response.path);
  				 						documentModel.set("type",response.type);
  				 						documentModel.set("documentName",response.name);
  				 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
  				 						if(documentModel.data.path.length > 255){
  				                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
  				                          }else {
  				                        	  	var applicantInsuranceDocGrid =	Ext.ComponentQuery.query('applicantinsurancedocumentgrid')[0];
  						 						var store = applicantInsuranceDocGrid.getStore();
  						 						store.add(documentModel);
  						 						if (applicantInsuranceDocGrid.isHidden() && store.data.items.length > 0) {
  						 							applicantInsuranceDocGrid.setVisible(true);
  						 						}
  						 						$this.getDocumentController().closeDocumentFormWindow();
  						 						showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'),getCommonTranslation('INSURANCE_DOCUMENT_ADD_SUCCESSFULLY'));
  				                          }
  				 					}, isTransient);
  					 		}
  			 	},
  			 	'documentformwindow[itemId=applicant_insurance_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
  			 		click : function() {
  			 			this.getDocumentController()
  			 			.closeDocumentFormWindow();
  			 		}
  			 	},		
  			 		
  			 		
  			 	'documentformwindow[itemId=applicant_insurance_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
  			    	click : function() {
  			 			var $this = this;
  			 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
  			            form.down('#documentFormSubmitButtonId').setDisabled(true);
  			 				fields : ['id','documentId','documentName','path','createdBy']
  			 						var documentModelUrl = new Academia.model.personinfo.common.personalinfo.ApplicantInsuranceUrlModel();
  						            var form = Ext.ComponentQuery.query('simpleurlform')[0];

  			 			            var documentName=form.down('#documentNameField').getValue();
  			 			            var UrlName=form.down('#documentUrlField').getValue();
  			 			            documentModelUrl.set("documentName",documentName);
  			 			            documentModelUrl.set("path",UrlName);
  			 			            
  			 			           documentModelUrl.set("type",'DOCUMENT');
  			 			           var userId = this.getCurrentlyLoggedInUser()
  			 			           documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
  			 			           
  		                    	  var applicantInsuranceUrlGrid = Ext.ComponentQuery.query('applicantinsuranceurlgrid')[0];
  		                    	  var store2= applicantInsuranceUrlGrid.getStore();
  		                    	  store2.add(documentModelUrl);
  		                    	  if (applicantInsuranceUrlGrid.isHidden() && store2.data.items.length > 0) {
  		                    		applicantInsuranceUrlGrid.setVisible(true);
  		                    	  }
  		                    	  $this.getDocumentController().closeDocumentFormWindow();
  		                    	  showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'),getCommonTranslation('APPLICANT_INSURANCE_URL_ADD_SUCCESSFULLY'));
  			 						
  			 		}
  			},
  			'documentformwindow[itemId=applicant_insurance_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
  				click : function() {
  					this.getDocumentController()
  					.closeDocumentFormWindow();
  				}
  			},	
  			 
  			
  	        'insuranceform[itemId=applicantinsuranceformId] button#submitButtonId' : {
  	 			click : function() {
  	               this.saveApplicantInsuranceDetail('#applicantInsuranceDetailsGrid', SERVERURL.PATH_APPLICANT_INSURANCE_DETAIL_ADD, SERVERURL.PATH_APPLICANT_INSURANCE_DETAIL_UPDATE);
  	 			}
  	 		},
  	 		'insuranceform[itemId=applicantinsuranceformId] button#cancelButtonId' : {
  	            	click: this.closePersonCommonWindow
  	 		},
  			 	
  	 		
  	 		
  	 		'applicantinsurancedocumentgrid button#btnDelete' : {
  	 			 click : function() {
  	 				 var $this = this;
  	 				 var grid=$this.getApplicantinsurancedocumentgrid();
  	 				 if (grid.getSelectionModel().getCount() > 0) {
  	 					 Ext.MessageBox.confirm(
  	 							 getCommonTranslation('ALERT'),
  	 							 getCommonTranslation('APPLICANT_INSURANCE_DELETE_CONFIRM_MESSAGE'),
  	 							function(btn, text) {
  	 								 if (btn == 'yes') {
  	 									 var store = grid.getStore();
  	 									 var record = grid.getSelectionModel().getSelection()[0];
  	 									 var id = record.id;
  	 									 if (isNullOrEmpty(id)) {
  	 									 }else{
  	 										 if (record) {
  	 											 store.remove(record);
  	 											 showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
  	 											 if(store.data.items.length == 0) {
  	 												grid.setVisible(false);
  	 					 						}
  	 										 }
  	 									 }

  	 								 }
  	 							 });
  	 				 } else {
  	 					 showWarningMessage(
  	 							getCommonTranslation('ALERT'),
  	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
  	 				 }
  	 			 }
  	 		 },
  	 		 
  	 		'applicantinsuranceurlgrid button#btnDelete' : {
  				 click : function() {
  					 var $this = this;
  					 var grid = Ext.ComponentQuery.query('applicantinsuranceurlgrid')[0];
  					 if (grid.getSelectionModel().getCount() > 0) {
  						 Ext.MessageBox.confirm(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
  								function(btn, text) {
  									 if (btn == 'yes') {
  										 var store = grid.getStore();
  										 var record = grid.getSelectionModel().getSelection()[0];
  										 var id = record.id;
  										 if (isNullOrEmpty(id)) {
  										 }else{
  											 if (record) {
  												 store.remove(record);
  												 showSuccessMessage(
  												 getCommonTranslation('APPLICANT_INSURANCE'),
  												 getCommonTranslation('URL_SUCCESS_MSG'));
  												 if(store.data.items.length == 0) {
  													grid.setVisible(false);
  						 						}
  											 }
  										 }
  									 }
  								 });
  					 } else {
  						 showWarningMessage(
  								 getCommonTranslation('ALERT'),
  								 getCommonTranslation('PLEASE_SELECT_RECORD')); 
  					 }
  				 }
  			 },
  			'applicantinsurancedocurllistgrid':{
            	render: function(grid) {
					var this$ = this;
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_INSURANCE_URL_PERMISSION());
				}
  			},
  			'applicantinsurancedocurllistgrid button[itemId=btnDelete]':{
 				click:function(obj){
 					var $this=this;
 					var form = $this.getApplicantinsurancedocurllist();  
 					var applicantInsuranceGrid= $this.getApplicantinsurancedetailsgrid();
 					var applicantInsuranceUrlListgrid=form.down('#applicantinsurancedocurllistgridItemId');
 					if (applicantInsuranceUrlListgrid.getSelectionModel().getCount() > 0) {
 						var records = applicantInsuranceUrlListgrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 							showConfirmMessage(getPersonModuleTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_APPLICANT_INSURANCE_URL_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {

 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'),getCommonTranslation('URL_SUCCESS_MSG'));	 
 										applicantInsuranceUrlListgrid.store.reload();
 										applicantInsuranceGrid.store.reload();
 										applicantInsuranceUrlListgrid.getSelectionModel().deselectAll(true);
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
 				}
       	 },
      
		 'applicantinsurancedocumentlistgrid button[itemId=btnDelete]':{
 				click:function(obj){
 					var $this=this;
 					var form = this.getApplicantinsurancedocumentlist();
					var applicantInsurancelistgrid=obj.up('grid');
 					var applicantInsuranceGrid= $this.getApplicantinsurancedetailsgrid();
 					if (applicantInsurancelistgrid.getSelectionModel().getCount() > 0) {
 						var records = applicantInsurancelistgrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 							showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('APPLICANT_INSURANCE_DELETE_CONFIRM_MESSAGE'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_APPLICANT_INSURANCE_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {

 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('APPLICANT_INSURANCE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
 										applicantInsurancelistgrid.store.reload();
 										applicantInsuranceGrid.store.reload();
 										applicantInsurancelistgrid.getSelectionModel().deselectAll(true);
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
 				}
       	 },
       	'applicantinsurancedocumentgrid' : {
			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				 var $this = this;
				 var documentGrid = grid.up('grid');
				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
				 if (columnName == "documentName") {
					 if (e.target.tagName == 'A') {
						 var documentId = record.get("documentId");
						 if (!isNullOrEmpty(documentId)) {
							 $this.getDocumentController().downloadDocumentFile(documentId);
						 }
					 }
				 }
			 }
		 },
  	 		
  	 		
  	 		
  			 		
            /**
             *  Fee Payer Detail
             */
            'feepayerdetailgrid[itemId=applicantFeePayerDetailGridItemId]': {
                render: function(grid) {
                	var b=grid.down("#btnAdd");
                	                    var d=grid.down("#btnDelete");
                	                    var g=this.getCurrentLoggedPortalId();
                	                    setTimeout(function()
                	                    {
                	                        if(g==6)
                	                        {
                	                            b.setVisible(false);
                	                            d.setVisible(false);
                	                            }
                	                        },100);
                    this.loadGridStore('#applicantFeePayerDetailGridItemId', SERVERURL.FPD_APPLICANT_FEE_PAYER_DETAIL_GRID);
                    this.doAccessControlValidation(grid, this.getAPPLICANT_FEE_PAYER_DETAILS_PERMISSIONS());
                    /*var this$ = this;    	
                           	var applicantProfile = this$.getContentPanelActiveTab();
                       		if(applicantProfile.getApplicationInfo()['isViewMode']
                       		|| !isNullOrEmpty(applicantProfile.getApplicationDataObject()['existingStudentId'])
                       		|| ((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                               	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                               	(applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                               	(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                               	(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
                       		){    		            		
                       			this$.mixins.ApplicationBaseController.setContainerInViewMode(grid);
                       		}*/
                },
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        if (columnName == 'documentCount') {
                        	 var $this = this;
                             var grid = $this.getApplicantFeePayerDetailGrid();

                             var formWindow = $this.getApplicantfeepayerdetaildocumentwin();
                             if (!formWindow) {
                             	Ext.widget('feepayerdetaildocumentwin');
                             	formWindow = $this.getApplicantfeepayerdetaildocumentwin();
                             }
                             formWindow.show();
                             var documentGrid = $this.getApplicantfeepayerdetaildocumentgrid();
                             documentGrid.getStore().getProxy().extraParams = {
                             	feePayerDetailId: record.data.id
                             };
                            // documentGrid.down('#btnDelete').setVisible(false);
                             documentGrid.getStore().load();
                        }
                    }
                }
            },
            'feepayerdetaildocumentgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getApplicantfeepayerdetaildocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'feepayerdetailgrid[itemId=applicantFeePayerDetailGridItemId] button[itemId=btnAdd]': {
                click: function() {
                	var this$ = this;
                   // var formWindow = this.getPersonCommonWindow();
                    localStorage.setItem('isEditFeePayer', false);
                    var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController'),
                	personType='APPLICANT',
        		    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
        	    	tabPanelItemId= 'applicantfeepayerdetailform',
        	    	tabPanelItemXtype = 'feepayerdetailform',
        	    	xtypeItemId = 'applicantfeepayerdetailformItemId',
        	    	defaultPanel= true,
        	    	menuColorCls =CONSTANTS.MENU_COLOR_ONE;
                	
                    personComContlr.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,'',menuColorCls);
        	    	
                    var formWindowSpecific = this.getPersonFeePayerDetailForm();
                   // var formWindowSpecific = this.showPersonCommonWindow(formWindow, 'FEE_PAYER_DETAILS', 'applicantfeepayerdetailformItemId', true);
                    //this.setDefaultCountryCodeApplicant();
                    var formScroll = formWindowSpecific.up('form');
        			if(!isNullOrEmpty(formScroll.getEl()))
        			{
        				var getElValue=formScroll.getEl();
        				var getFirstChild = getElValue.first();
        				getFirstChild.dom.style.overflowY="scroll";
        			}  
                    if( formWindowSpecific != null ){
            			var form = formWindowSpecific;
            			var isPrimaryCheckBox = form.down('#primaryFeePayerId');
                    	var personProfile = this$.getContentPanelActiveTab();
                    	var personId;
                    	try{
                    		personId = personProfile.getPersonId();
                    	}catch(e){
                    		personId = this$.getContentPanel().items.items[0].getPersonId();
                    	}
            			
            			Ext.Ajax.request({
                 			type: 'rest',
                 			url: SERVERURL.PATH_FIND_APPLICANT_FEE_PAYER_EXISTS,
                 			method: 'GET',
                 			params: {
                 				applicantPersonId: personId
                             },
                 			success: function(res, action) {
                 				var response = Ext.decode(res.responseText);
                 				if(!isNullOrEmpty(isPrimaryCheckBox)){
                 					if(response != true && response != 'true'){
                 						isPrimaryCheckBox.setValue(true);
                 						isPrimaryCheckBox.setReadOnly(true);
                 					} 
                 				}
                 			}
                        });
                		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var homeCountryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                    	var homeMobileField = form.down("#homeTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,homeCountryCodeField,homeMobileField,null);
                    	if(!homeMobileField.allowBlank){
                    		var homeTelephoneContainerItemId = form.down("#homeTelephoneContainerItemId");
                    		homeTelephoneContainerItemId.labelSeparator = '';
                    		homeTelephoneContainerItemId.setFieldLabel(getPersonModuleTranslation('FPD_HOME_TELEPHONE')+ ':<span class="required" style="color:red"> *</span>');
                    	}
                    	var workCountryCodeField = form.down("#workTelephoneCountryCodeItemId");
                    	var workMobileField = form.down("#workTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,workCountryCodeField,workMobileField,null);
                    	var countryCodeField = form.down("#countryCodeItemId");
                    	var mobileField = form.down("#mobileNumberItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	this.setDfrOnFeePayerDetailsForm(formWindowSpecific);
                    	var sponsorItemId = form.down("#sponsorItemId");
                        var corporateId = form.down("#corporateId");
                        var payerTypeItemId= form.down('#payerTypeItemId');
                        var companySponLetterUrlFiled= form.down('#companySponsorLetterItemId');
                        if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
                         corporateId.allowBlank=true;
                         corporateId.setVisible(false);
                         setTimeout(function(){
                             companySponLetterUrlFiled.setVisible(false);
                             sponsorItemId.setVisible(false);
                             sponsorItemId.allowBlank=true;
                     		},300)                         
                        }
            		}
                }
            },
            'feepayerdetailgrid[itemId=applicantFeePayerDetailGridItemId] button[itemId=btnEdit]': {
                click: function() {
                	localStorage.setItem('isEditFeePayer', true);
                	var personType='APPLICANT',
        		    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
        	    	tabPanelItemId= 'applicantfeepayerdetailform',
        	    	tabPanelItemXtype = 'feepayerdetailform',
        	    	xtypeItemId = 'applicantfeepayerdetailformItemId',
        	    	defaultPanel= true,
        	    	gridItemId ='#applicantFeePayerDetailGridItemId',
        	    	menuColorCls =CONSTANTS.MENU_COLOR_ONE;
                	
                    
                    var form = this.editFeePayerDetailFormWindow(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,'',menuColorCls);
                    //this.setDefaultCountryCodeApplicant();
                    if( form != null ){
                    	var isPrimaryCheckBox = form.down('#primaryFeePayerId');
                    	if(!isNullOrEmpty(isPrimaryCheckBox.getValue()) && (isPrimaryCheckBox.getValue()==true || isPrimaryCheckBox.getValue()=='true')) {
                    		isPrimaryCheckBox.setReadOnly(true);
                    	} else {
                    		isPrimaryCheckBox.setReadOnly(false);
                    	}
                		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var homeCountryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                    	var homeMobileField = form.down("#homeTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,homeCountryCodeField,homeMobileField,null);
                    	if(!homeMobileField.allowBlank){
                    		var homeTelephoneContainerItemId = form.down("#homeTelephoneContainerItemId");
                    		homeTelephoneContainerItemId.labelSeparator = '';
                    		homeTelephoneContainerItemId.setFieldLabel(getPersonModuleTranslation('FPD_HOME_TELEPHONE')+ ':<span class="required" style="color:red"> *</span>');
                    	}
                    	var workCountryCodeField = form.down("#workTelephoneCountryCodeItemId");
                    	var workMobileField = form.down("#workTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,workCountryCodeField,workMobileField,null);
                    	var countryCodeField = form.down("#countryCodeItemId");
                    	var mobileField = form.down("#mobileNumberItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	var corporateId = form.down("#corporateId");
                        var payerTypeItemId= form.down('#payerTypeItemId');
                        var feePayerIDItemId = form.down('#feePayerIDItemId');
                        var companySponLetterUrlFiled= form.down('#companySponsorLetterItemId');
                        feePayerIDItemId.allowBlank=true;
                        if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON" 
                        	|| payerTypeItemId.originalValue.payerType=="STUDENT" || payerTypeItemId.lastValue.payerType=="STUDENT"){
                         corporateId.allowBlank=true;
                         corporateId.setVisible(false);
                        }
                        if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON" ){
                        	 setTimeout(function(){
                                 companySponLetterUrlFiled.setVisible(false);
                         		},300)                          }
            		}
                }
            },
            'feepayerdetailgrid[itemId=applicantFeePayerDetailGridItemId] button[itemId=btnView]': {
                click: function() {
                	var personType='APPLICANT',
        		    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
        	    	tabPanelItemId= 'applicantfeepayerdetailform',
        	    	tabPanelItemXtype = 'feepayerdetailform',
        	    	xtypeItemId = 'applicantfeepayerdetailformItemId',
        	    	defaultPanel= true,
        	    	gridItemId ='#applicantFeePayerDetailGridItemId',        	    	
        	    	menuColorCls =CONSTANTS.MENU_COLOR_ONE;
                	
                    this.viewFeePayerDetailFormWindow(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,'',menuColorCls);
                   // var formWindow = this.getPersonCommonWindow();
                    var feepayerdetailform = this.getPersonFeePayerDetailForm();
                    var payerTypeItemId= feepayerdetailform.down('#payerTypeItemId');

                      if(feepayerdetailform != null && feepayerdetailform != undefined){
                    	var feePayerIDItemId = feepayerdetailform.down("#feePayerIDItemId");
                    	if(feePayerIDItemId != null && feePayerIDItemId != undefined){
                    		feePayerIDItemId.setDisabled(true);
                    	}
                    	var feePayerLatestPayslipItemId = feepayerdetailform.down("#feePayerLatestPayslipItemId");
                    	if(feePayerLatestPayslipItemId != null && feePayerLatestPayslipItemId != undefined){
                    		feePayerLatestPayslipItemId.setDisabled(true);
                    	}
                    	var feePayerProofOfAccountItemId = feepayerdetailform.down("#feePayerProofOfAccountItemId");
                    	if(feePayerProofOfAccountItemId != null && feePayerProofOfAccountItemId != undefined){
                    		feePayerProofOfAccountItemId.setDisabled(true);
                    	}
                    	var companySponsorLetterItemId = feepayerdetailform.down("#companySponsorLetterItemId");
                    	if(companySponsorLetterItemId != null && companySponsorLetterItemId != undefined){
                    		companySponsorLetterItemId.setDisabled(true);
                    	}
                    	   if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON" ){
                    		   setTimeout(function(){
                    			   companySponsorLetterItemId.setVisible(false);
                           		},300)         
                           	}
                    }
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId]': {
                render: function(formObj) {
                	formObj.down('#debitOrderContainerItemId').setVisible(false);
                	formObj.down('#paymentModeContainerItemId').setVisible(false);
                	formObj.down('#paymentOptionDetailsLabelItemId').setVisible(false);
                	formObj.down('#parentCountryRegionId').setDisabled(true);
                	formObj.down('#cityId').setDisabled(true);                	
                	
                	var $this = this;
                	var debitFieldsArr = ['#debitOrderDateItemId', '#accountNameItemId', '#accountTypeItemId', 
                		'#bankItemId', '#accountNumberItemId', '#branchCodeItemId','#debitOrderStartDate','#debitOrderEndDate'];
                	
                	var task = new Ext.util.DelayedTask(function(){
                		for(i in debitFieldsArr){
                    		var field = formObj.down(debitFieldsArr[i]);
                    		$this.setAllowBlank(field, true);
                    	}
                		var workTelephoneItemId = formObj.down('#workTelephoneItemId');
                		var workTelephoneContainerItemId = formObj.down('#workTelephoneContainerItemId');
                		if(workTelephoneItemId.allowBlank == false){
                			workTelephoneContainerItemId.labelSeparator = '';
                			workTelephoneContainerItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE')+ ':<span class="required" style="color:red"> *</span>');
                		}
                		var mobileNumberItemId = formObj.down('#mobileNumberItemId');
                		var mobileNoFldItemId = formObj.down('#mobileNoFldItemId');
                		if(mobileNumberItemId.allowBlank == false){
                			mobileNoFldItemId.labelSeparator = '';
                			mobileNoFldItemId.setFieldLabel(getPersonModuleTranslation('MOBILE_NUMBER')+ ':<span class="required" style="color:red"> *</span>');
                		}
                	});
                	task.delay(1000);
                },
                afterrender: function(obj) {
                	var companyNameItemId = obj.down("#companyNameItemId");
                	var contactPersonItemId = obj.down("#contactPersonItemId");
                	var surNameItemId = obj.down("#surnameItemId");
                	var employeeIdItemId = obj.down("#employeeIdItemId");
                	
                	companyNameItemId.setVisible(false);
                	contactPersonItemId.setVisible(false);
                	surNameItemId.setVisible(false);
                	companyNameItemId.allowBlank = true;
                	contactPersonItemId.allowBlank = true;
                	surNameItemId.allowBlank = true;
                	employeeIdItemId.setVisible(false);
                	employeeIdItemId.allowBlank = true;
                	this.addApplicantGoogleAddressBtn(obj);
                }
            },
            'feepayerdetailgrid[itemId=applicantFeePayerDetailGridItemId] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteFeePayerDetailRecord('#applicantFeePayerDetailGridItemId', SERVERURL.FPD_FEE_PAYER_DETAIL_DELETE);
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] button[itemId=submitButtonId]': {
                click: function() {
                    this.savePersonFeePayerDetail('#applicantFeePayerDetailGridItemId', SERVERURL.FPD_APPLICANT_FEE_PAYER_DETAIL_CREATE, SERVERURL.FPD_APPLICANT_FEE_PAYER_DETAIL_UPDATE);
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] radiogroup[itemId=empOfTheOrgItemId]': {
            	afterrender: function(radio) {
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
                	if(checkEmployeeIdDfr==false) {
                		if(status==true) {
                			employeeId.setVisible(true);
                		}
                		else {
                			employeeId.reset();
                			employeeId.setVisible(false);
                		}
                	}
                	form.getForm().checkValidity();
                },
                change: function(radio, newValue, oldVaue) { 
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
                	if(checkEmployeeIdDfr==false) {
                		if(status==true) {
                			employeeId.setVisible(true);
                		}
                		else {
                			employeeId.reset();
                			employeeId.setVisible(false);
                		}
                	}
                	form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] filefield[itemId=feePayerIDItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_ID_UPLOAD_VALID_FILE'));
                        }
                    } 
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] filefield[itemId=feePayerLatestPayslipItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] filefield[itemId=companySponsorLetterItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                    var specialCharsExist=false;
                         for(i = 0; i < specialChars.length;i++){
                           if(newValue.indexOf(specialChars[i]) > -1){
                               specialCharsExist= true;
                            }
                         }
                        if(specialCharsExist){
                        	fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                        }
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] radiogroup[itemId=paymentModeItemId]': {
                afterrender: function(radio){
                	
                	var academyLocationId = this.getCurrentAcademyLocation();
                	
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	
                	var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
                	
                	var debitFieldsArr = ['#debitOrderDateItemId', '#accountNameItemId', '#accountTypeItemId', 
                		'#bankItemId', '#accountNumberItemId', '#branchCodeItemId','#debitOrderStartDate','#debitOrderEndDate'];
                	
                	var task = new Ext.util.DelayedTask(function(){
                		for(i in debitFieldsArr){
                    		var field = form.down(debitFieldsArr[i]);
                    		$this.setAllowBlank(field, true);
                    	}
                	});
                	task.delay(1000);
                }
             },
             'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] customcombobox[itemId=sponsorItemId]':{
            	 select: function(combo){
            		 var me = this;
            		 var form = combo.up('feepayerdetailform');
            		 
            		 //var feePayerField = form.down('#');
            		 var nameOfContactPersonField = form.down('#contactPersonItemId'); //
            		 var nameOfCompanyField = form.down('#companyNameItemId'); //
            		 var addressField = form.down('#addressTextArea'); // 
            		 var countryField = form.down('#countryId'); // 
            		 var regionField = form.down('#parentCountryRegionId'); //
            		 var cityFieldField = form.down('#cityId'); //
            		 var pinCodeField = form.down('#pincodeId'); //
            		 var phoneCountryCode = form.down('#workTelephoneCountryCodeItemId');
            		 var mobileCountryCode = form.down('#countryCodeItemId');
            		 var phoneNumberField = form.down('#workTelephoneItemId');
            		 var mobileNumberField = form.down('#mobileNumberItemId');
            		 var workEmailField = form.down('#emailWorkItemId'); //
            		 
            		 Ext.Ajax.request({
            			 type: 'rest',
            			 url: SERVERURL.FIND_CONTACT_BY_SPONSORID,
            			 params: {
            				 sponsorId: combo.getValue()
            			 },
            			 method: 'GET',
            			 success: function(res, action) {
							 if(res.responseText) {
	            				 var response = Ext.decode(res.responseText);
	            				 if(response){ 
	            					 addressField.setValue(response.addressTextArea);
	            					 nameOfContactPersonField.setValue(response.contactName);
									 nameOfCompanyField.setValue(response.sponsorName);
	            					 workEmailField.setValue(response.emailWork);
	            					 pinCodeField.setValue(response.pincode);
	            					 
	            					 phoneCountryCode.getStore().load({
	            						 callback: function(){
	            							 phoneCountryCode.setValue(response.phoneCountryCode);
	            						 }
	            					 });
	            					 
	            					 mobileCountryCode.getStore().load({
	            						 callback: function(){
	            							 mobileCountryCode.setValue(response.countryCode);
	            						 }
	            					 });
	            					 
	            					 phoneNumberField.setValue(response.phoneNo);
	            					 mobileNumberField.setValue(response.mobileNumber);
	            					 
	            					 countryField.getStore().load({
	            						 callback: function(){
	            							 countryField.setValue(response.countryId);
	            							 regionField.getStore().getProxy().extraParams = {
	            								 cid: response.countryId
	            							 };
	            							 regionField.getStore().load({
	            								 callback: function(){
	            									 regionField.setDisabled(false);
	            									 regionField.setValue(response.parentCountryRegionId);
	            								 }
	            							 });
	    									 
	    									 cityFieldField.getStore().getProxy().extraParams = {
	    										 countryId: response.countryId
	            							 };
	    									 cityFieldField.getStore().load({
	            								 callback: function(){
	            									 cityFieldField.setDisabled(false);
	            									 cityFieldField.setValue(response.cityId);
	            								 }
	            							 });
	            						 }
	            					 });
	            				 }else{
	                					addressField.reset();
	                 					nameOfContactPersonField.reset();
	                 					nameOfCompanyField.reset();
	                 					workEmailField.reset();
	                 					pinCodeField.reset();
	                 					phoneCountryCode.reset();
	                 					mobileCountryCode.reset();
	                 					phoneNumberField.reset();
	                  					mobileNumberField.reset();
	                  					countryField.reset();
	                  					regionField.reset();
	                  				 	cityFieldField.reset();
	                  				 }
  							}else{
            					addressField.reset();
             					nameOfContactPersonField.reset();
             					nameOfCompanyField.reset();
             					workEmailField.reset();
             					pinCodeField.reset();
             					phoneCountryCode.reset();
             					mobileCountryCode.reset();
             					phoneNumberField.reset();
              					mobileNumberField.reset();
              					countryField.reset();
              					regionField.reset();
              				    cityFieldField.reset();
								if(combo.lastSelection && combo.lastSelection.length > 0){
									sponsorName = combo.lastSelection[0].data.sponsorName;
									nameOfCompanyField.setValue(sponsorName);
								}
              				 }
            			 }
            		 });
            	 }
             },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] radiogroup[itemId=payerTypeItemId]': {
                change: function(cb, nv, ov) {
                	var $this = this;
                	var form = cb.up('feepayerdetailform');
                	var salutationItemId = form.down("#salutationItemId");
                	var firstNameItemId = form.down("#firstNameItemId");
                	var middleNameItemId = form.down("#middleNameItemId");
                	var lastNameItemId = form.down("#lastNameItemId");
                	var companyNameItemId = form.down("#companyNameItemId");
                	var contactPersonItemId = form.down("#contactPersonItemId");
                	var doesFeePayerConsentToCreditCheckLabelItemId = form.down("#doesFeePayerConsentToCreditCheckLabelItemId");
                	var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
                	var homeTelephoneCountryCodeItemId = form.down("#homeTelephoneCountryCodeItemId");
                	var homeTelephoneItemId = form.down("#homeTelephoneItemId");
                	var workTelephoneCountryCodeItemId = form.down("#workTelephoneCountryCodeItemId");
                	var workTelephoneItemId = form.down("#workTelephoneItemId");
                	var countryCodeItemId = form.down("#countryCodeItemId");
                	var mobileNumberItemId = form.down("#mobileNumberItemId");

                	var emailHomeItemId = form.down("#emailHomeItemId");
                	var emailWorkItemId = form.down("#emailWorkItemId");
                	var emailHomeUseForCommunicationItemId = form.down("#emailHomeUseForCommunicationItemId");
                	var emailWorkUseForCommunicationItemId = form.down("#emailWorkUseForCommunicationItemId");
                	var feePayerIDItemId = form.down("#feePayerIDItemId");
                	var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
                	
                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                	var companyAddressContainerItemId = form.down("#companyAddressContainerItemId");
                	var empOfTheOrgContainerItemId = form.down("#empOfTheOrgContainerItemId");
                	var surnameItemId = form.down("#surnameItemId");
                	
                	var employeeIdItemId = form.down("#employeeIdItemId");
                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                	var nationalAlternateIdContainer = form.down("#nationalAlternateIdContainer");
                	var homeTelephoneContainerItemId = form.down("#homeTelephoneContainerItemId");
                	var corporateId = form.down("#corporateId");                	
                	var emailHomeContainerItemId = form.down("#emailHomeContainerItemId");
                	var occupationItemId = form.down("#occupationItemId");
                	var employerCompanyNameItemId = form.down("#employerCompanyNameItemId");
                	var employerEmailItemId = form.down("#employerEmailItemId");
                	var companySponcerLetter = form.down("#companySponsorLetterItemId");
                	var sponsorItemId = form.down("#sponsorItemId");
                		if (nv.payerType == 'PERSON') {
                		companySponcerLetter.setVisible(false);	
                		sponsorItemId.allowBlank = true;
                		sponsorItemId.setVisible(false);
                	}else if(nv.payerType == 'CORPORATE'){
                		companySponcerLetter.setVisible(true);	
                		sponsorItemId.setVisible(true);
                		sponsorItemId.allowBlank = true;
                	}
                	occupationItemId.setVisible(false);
                	employerCompanyNameItemId.setVisible(false); 
                	employerEmailItemId.setVisible(false); 

                	if (nv.payerType == 'PERSON' || nv.payerType == 'STUDENT') {
                	    salutationItemId.setVisible(true);
                	    firstNameItemId.setVisible(true);
                	    middleNameItemId.setVisible(true);
                	    lastNameItemId.setVisible(true);
                	    companyNameItemId.setVisible(false);
                	    contactPersonItemId.setVisible(false);
                	    corporateId.allowBlank=true;
                	    corporateId.setVisible(false);
                	    //  doesFeePayerConsentToCreditCheckLabelItemId.setVisible(true);
                	  //  doesFeePayerConsentToCreditCheckItemId.setVisible(true);
                	    
                	    //homeTelephoneCountryCodeItemId.setVisible(true);
                	    //homeTelephoneItemId.setVisible(true);
                	    homeTelephoneContainerItemId.setVisible(true);
                	    
                	   // countryCodeItemId.setVisible(true);
                	   // mobileNumberItemId.setVisible(true);
                	    
                	   // emailHomeItemId.setVisible(true);
                	   // emailHomeUseForCommunicationItemId.setVisible(true);
                	    emailHomeContainerItemId.setVisible(true);
                	   
                	    
                	    emailWorkUseForCommunicationItemId.setVisible(true);
                	    feePayerIDItemId.setVisible(true);
                	    feePayerLatestPayslipItemId.setVisible(true);
                	    
                	    empOfTheOrgContainerItemId.setVisible(true);
                	    surnameItemId.setVisible(false);
                	    //nationalAlternateIdItemId.setVisible(true);
                	    nationalAlternateIdContainer.setVisible(true);
                	    companyAddressContainerItemId.setVisible(false);

                	    salutationItemId.allowBlank = false;
                	    firstNameItemId.allowBlank = false;
                	    lastNameItemId.allowBlank = false;
                	    middleNameItemId.allowBlank = false;
                	    companyNameItemId.allowBlank = true;
                	    contactPersonItemId.allowBlank = true;
                	    doesFeePayerConsentToCreditCheckItemId.allowBlank = false;
                	    feePayerIDItemId.allowBlank = false;
//                	    feePayerLatestPayslipItemId.allowBlank = false;

                	  //  homeTelephoneCountryCodeItemId.allowBlank = false;
                	  //  homeTelephoneItemId.allowBlank = false;
                	  //  countryCodeItemId.allowBlank = false;
                	  //  mobileNumberItemId.allowBlank = false;
                	    emailHomeItemId.allowBlank = false;
                	 //   workTelephoneCountryCodeItemId.allowBlank = true;
                	 //   workTelephoneItemId.allowBlank = true;
                	    companyNameItemId.allowBlank = true;
                	    emailWorkItemId.allowBlank = true;

                	    salutationItemId.reset();
                	    firstNameItemId.reset();
                	    middleNameItemId.reset();
                	    lastNameItemId.reset();
                	    companyNameItemId.reset();
                	    contactPersonItemId.reset();
                	    doesFeePayerConsentToCreditCheckItemId.reset();
                	    homeTelephoneCountryCodeItemId.reset();
                	    homeTelephoneItemId.reset();
                	    countryCodeItemId.reset();
                	    mobileNumberItemId.reset();
                	    emailHomeItemId.reset();
                	    emailHomeUseForCommunicationItemId.reset();
                	    emailWorkUseForCommunicationItemId.reset();
                	    workTelephoneCountryCodeItemId.reset();
                	    workTelephoneItemId.reset();
                	    feePayerIDItemId.reset();
                	    feePayerLatestPayslipItemId.reset();

                	    workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));
                	    
                	    var academyLocationId = this.getCurrentAcademyLocation();
                    	var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
                    	var mandatoryFields = ['employeeIdItemId', 'nationalAlternateIdItemId'];
                	    
                	    Ext.Ajax.request({
	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                		method: 'GET',
	                		async: false,
	                		params: {
	                			screenName: 'feepayerdetailform',
	                			academyLocationId: this.getCurrentAcademyLocation(),
	                			languageCode:'en'
	                		},
	                		success: function(response) {
	                			//debitOrderContainerItemId.setVisible(false);
	                			var json = JSON.parse(response.responseText);
	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                			fieldInfo.set("formFieldsInfo", json);
	                			//console.log(json);
	                			if( !isNullOrEmpty(json) ){
	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
	                					for( i in feePayerDetailDFRConfig){
	                						var fieldConfig = feePayerDetailDFRConfig[i];
	                						//console.log(fieldConfig);
	                						if( mandatoryFields.includes(fieldConfig.formFieldId) ){
	                							if( fieldConfig.isMandatory ){
	                								var currentField = form.down("#"+fieldConfig.formFieldId);
	                								$this.setAllowBlank(currentField, false);
	                								var currentFieldLabel = fieldConfig.formFieldLabel;
	                								currentField.setFieldLabel(currentFieldLabel);
	                							}
	                						}
	                						if (nv.payerType == 'PERSON') {
	                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='occupationItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='employerCompanyNameItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='employerEmailItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                						}
											}
	                					}
	                				}else{
	                					if (nv.payerType == 'PERSON') {
	                						occupationItemId.setVisible(true);
		                                	employerCompanyNameItemId.setVisible(true); 
		                                	employerEmailItemId.setVisible(true); 
	                					}
	                				}
	                			}
	                		}
	                	});
                	    var isFieldReadOnly = false;
                	    if (nv.payerType == 'STUDENT') {
                	    	isFieldReadOnly = true;
						}
                	    $this.setStudentDetails(form, isFieldReadOnly, nv.payerType);
                	} else {
                		
                	    salutationItemId.setVisible(false);
                	    firstNameItemId.setVisible(false);
                	    middleNameItemId.setVisible(false);
                	    lastNameItemId.setVisible(false);
                	    companyNameItemId.setVisible(true);
                	    contactPersonItemId.setVisible(true);
                	    corporateId.setVisible(false);
                	    corporateId.allowBlank = true;
                	    occupationItemId.allowBlank = true;
                    	employerCompanyNameItemId.allowBlank = true;
                    	middleNameItemId.allowBlank = true;
                    	employerEmailItemId.allowBlank = true;
                	    
                	 //   doesFeePayerConsentToCreditCheckLabelItemId.setVisible(false);
                	 //   doesFeePayerConsentToCreditCheckItemId.setVisible(false);
                	    
                	    //homeTelephoneCountryCodeItemId.setVisible(false);
                	    //homeTelephoneItemId.setVisible(false);
                	    
                	    homeTelephoneContainerItemId.setVisible(false);
                	    homeTelephoneContainerItemId.allowBlank = true;
                	    //countryCodeItemId.setVisible(false);
                	    //mobileNumberItemId.setVisible(false);
                	    
                	    
                	  //  emailHomeItemId.setVisible(false);
                	  //  emailHomeUseForCommunicationItemId.setVisible(false);
                	    emailHomeContainerItemId.setVisible(false);
                	    
                	    emailWorkUseForCommunicationItemId.setVisible(false);
                	    feePayerIDItemId.setVisible(false);
                	    feePayerLatestPayslipItemId.setVisible(false);
                	    
                	    empOfTheOrgContainerItemId.setVisible(false);
                	    surnameItemId.setVisible(true);
                	    //nationalAlternateIdItemId.setVisible(false);
                	    nationalAlternateIdContainer.setVisible(false);
                	    companyAddressContainerItemId.setVisible(true);
                    	
                	    salutationItemId.allowBlank = true;
                	    firstNameItemId.allowBlank = true;
                	    lastNameItemId.allowBlank = true;
                	    companyNameItemId.allowBlank = true;
                	    contactPersonItemId.allowBlank = true;
                	    doesFeePayerConsentToCreditCheckItemId.allowBlank = true;
                	    feePayerIDItemId.allowBlank = true;
                	    feePayerLatestPayslipItemId.allowBlank = true;

                	  //  homeTelephoneCountryCodeItemId.allowBlank = true;                	      
                	  //  countryCodeItemId.allowBlank = true;
                 	    homeTelephoneCountryCodeItemId.allowBlank = true;
                	    homeTelephoneItemId.allowBlank = true;
                	    mobileNumberItemId.allowBlank = true;
                	    emailHomeItemId.allowBlank = true;
                	    
                	    //$this.setAllowBlank(workTelephoneCountryCodeItemId,false);
                	    //workTelephoneCountryCodeItemId.allowBlank = false;
                	    //$this.setAllowBlank(workTelephoneItemId,false);
                	    //workTelephoneItemId.allowBlank = false;
                	    
                	   // $this.setAllowBlank(companyNameItemId,false);
                	    //companyNameItemId.allowBlank = false;
                	    $this.setAllowBlank(emailWorkItemId,false);
                	    //emailWorkItemId.allowBlank = false;
                	    
                	    $this.setAllowBlank(employeeIdItemId,true);
                	    $this.setAllowBlank(nationalAlternateIdItemId,true);

                	    salutationItemId.reset();
                	    firstNameItemId.reset();
                	    middleNameItemId.reset();
                	    lastNameItemId.reset();
                	    companyNameItemId.reset();
                	    contactPersonItemId.reset();
                	    doesFeePayerConsentToCreditCheckItemId.reset();
                	    homeTelephoneCountryCodeItemId.reset();
                	    homeTelephoneItemId.reset();
                	    countryCodeItemId.reset();
                	    mobileNumberItemId.reset();
                	    emailHomeItemId.reset();
                	    emailHomeUseForCommunicationItemId.reset();
                	    emailWorkUseForCommunicationItemId.reset();
                	    workTelephoneCountryCodeItemId.reset();
                	    workTelephoneItemId.reset();
                	    feePayerIDItemId.reset();
                	    feePayerLatestPayslipItemId.reset();

                	    workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));
                	    var sponsorItemId = form.down("#sponsorItemId");
                	    $this.setDFRForCorporateType(corporateId,companySponcerLetter,sponsorItemId);
                	    $this.setDFRForCompanyNameContactPerson(companyNameItemId,contactPersonItemId,sponsorItemId);
                	}
                	//this.setDefaultCountryCodeApplicant();
                	if( form != null ){
                		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#homeTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                    	mobileField = form.down("#workTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	countryCodeField = form.down("#countryCodeItemId");
                    	mobileField = form.down("#mobileNumberItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] customcombobox[itemId=homeTelephoneCountryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getPersonFeePayerDetailForm();
            		var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                	var mobileField = form.down("#homeTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] numberfield[itemId=homeTelephoneItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var mobileField = form.down("#homeTelephoneItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] customcombobox[itemId=workTelephoneCountryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getPersonFeePayerDetailForm();
                	var countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                	var mobileField = form.down("#workTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] numberfield[itemId=workTelephoneItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var mobileField = form.down("#workTelephoneItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] customcombobox[itemId=countryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getPersonFeePayerDetailForm();
                	var countryCodeField = form.down("#countryCodeItemId");
                	var mobileField = form.down("#mobileNumberItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);                
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] numberfield[itemId=mobileNumberItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var mobileField = form.down("#mobileNumberItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] combo#countryId': {
                select: function(combo, record) {
                	var newValue=record[0].data.id;
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');                	
                	var cityComboBox = combo.up('form').down('customcombobox#cityId');
                	cityComboBox.reset();
                    regionComboBox.reset();
                    cityComboBox.setDisabled(true);
                    regionComboBox.setDisabled(false);
                    this.onCountryChange(combo, record, this.getPersonFeePayerDetailForm());
                    combo.up('form').getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] customcombobox#parentCountryRegionId': {
            	 select: function(obj1, record) {
                     var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                     var countryComboBox = obj1.up('form').down('customcombobox#countryId');
                     cityComboBox.setDisabled(false);
                     cityComboBox.reset();
                     
                     var countryRegionIdVal = record[0].get("id");
                     var countryIdVal = countryComboBox.getValue();
                     var cityStore = cityComboBox.getStore();
                     cityStore.getProxy().extraParams = {
                    	 countryId: countryIdVal,
                    	 countryRegionId: countryRegionIdVal
                     };
                     cityStore.reload();
                     obj1.up('form').getForm().checkValidity();
                 }
            },
            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] checkboxfield#isSameAsCurrentAddress': {
            	   change: function(obj,newValue,oldValue) {
             		   var form = obj.up('form');
             	             		   
             		   if(newValue || newValue == true){             			   
             			  this.getPersonCurrentAddressDetail(form,SERVERURL.APPLICANT_GET_CURRENT_ADDRESS,true);          			  
             		   } 
             		   else{
             			  this.getPersonCurrentAddressDetail(form,SERVERURL.APPLICANT_GET_CURRENT_ADDRESS,false);               			 
             		   }
                    }
            	
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] combo[itemId=mobileCountryCode]': {
            	select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#mobileCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] combo[itemId=phoneCountryCode]': {
            	select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] numberfield[itemId=cellNo]': {
            	change: function(record){
                	var form = this.getPersonParentGuardianForm();
                	var mobileField = form.down("#cellNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] combo[itemId=alternateMobileCountryCode]': {
                select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#alternateMobileCountryCode");
                	var mobileField = form.down("#alternateMobileNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] numberfield[itemId=alternateMobileNo]': {
                change: function(record){
                	var form = this.getPersonParentGuardianForm();
                	var mobileField = form.down("#alternateMobileNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm]': {
                afterrender: function(obj) {
                	
                	var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var personId;
                	var applicationId;
                	var applicationCode;
                	try{
                		personId = personProfile.getPersonId();
                		applicationId = personProfile.applicationId;
                		applicationCode= personProfile.title
                	}catch(e){
                		personId = this$.getContentPanel().items.items[0].getPersonId();
                		applicationId = this$.getContentPanel().items.items[0].applicationId;
                		applicationCode= this$.getContentPanel().items.items[0].applicationCode;
                	}
                	
                	var params = {
                			//applicationId : applicationId
                			applicantPersonId: personId,
                			applicationCode:applicationCode
                			
                	};
                	var submitUrl = SERVERURL.PATH_GET_APPLICANT_HOSTEL_PERSONAL_INFO_BY_APPLICANT_PERSON_ID;
                	var hostelUrl = SERVERURL.PATH_IS_ADMIN_APPLY_FOR_GENERAL_LIST;
                	var hostelApplicantWaitingUrl = SERVERURL.PATH_IS_ADMIN_APPLY_FOR_WAITING_LIST;
                	var applicantSetupUrl = SERVERURL.PATH_FIND_HOSTEL_APP_SETUP_APPLICANT_FOR_ADMIN;
                	var applicantsavebtnenbUrl = SERVERURL.PATH_IS_SAVE_BTN_ENABLE_APP_GENERAL_LIST_FOR_ADMIN;
                	// Hide Hostel Fields
                   	var hostelFieldsContainer1 = obj.down('#hostelFieldsContainer1');
             		var hostelFieldsContainer2 = obj.down('#hostelFieldsContainer2');
             		var hostelFieldsContainer3 = obj.down('#hostelFieldsContainer3');
             		var hostelPreferencePanel = obj.down('#hostelPreferencePanel');
             		var isHostelRequired=obj.down('#isHostelRequired');
             		var whetherApplicantWaiting=obj.down('#whetherApplicantWaiting');
             		whetherApplicantWaiting.setDisabled(true);
             		var waitingListSetupCombo=obj.down('#waitingListSetupCombo');
             		waitingListSetupCombo.setVisible(false);
             		var saveBtnHostel=obj.down('#submitButtonId');
             		var tempAccommondationId = obj.down('#tempAccommondationId');
             		var tempAccommondationValue = null;
             		try {
             			tempAccommondationValue = tempAccommondationId.getValue().tempAccommondationType;
             		}
             		catch(e) {
             			tempAccommondationValue = false;
             		}
             		var applyForWaitingListTypeId = obj.down('#applyForWaitingListTypeId');
             		var applyForWaitingListTypeValue = null;
             		try {
             			applyForWaitingListTypeValue = applyForWaitingListTypeId.getValue().tempAccommondationType;
             		}
             		catch(e) {
             			applyForWaitingListTypeValue = false;
             		}
             		applyForWaitingListTypeId.setValue({applyForWaitingList: applyForWaitingListTypeValue});
     		   		hostelFieldsContainer1.setVisible(false);
     		   		hostelFieldsContainer2.setVisible(false);
     		   		hostelFieldsContainer3.setVisible(false);
     		   		hostelPreferencePanel.setVisible(false);

     		   		// Hide Custom Fields
           			this$.showHideApplicantHostelCustomFieldData(obj,false);
           			this$.sendGetAjaxRequest(hostelUrl, 'GET', params, function(option, success, response) {
                    	if(success){
    
                    		//hostelRequiredDetails.setDisabled(true);
							if(response.responseText == "true") {
								isHostelRequired.setDisabled(false);
								whetherApplicantWaiting.setDisabled(true);
								this$.sendGetAjaxRequest(applicantSetupUrl, 'GET', params, function(option, success, response) {
									if(success){
										var data = Ext.decode(response.responseText);
										if(data.length){
											personProfile.year=data[0].year.code;
										}
										

									}
	                            });
								this$.sendGetAjaxRequest(applicantsavebtnenbUrl, 'GET', params, function(option, success, response) {
									if(success){
										if(isHostelRequired.getValue() && response.responseText == "false") {
											saveBtnHostel.setDisabled(false);
										}else{
											saveBtnHostel.setDisabled(true);
										}
									}
								});
								
							} else {
								isHostelRequired.setDisabled(true);
								saveBtnHostel.setDisabled(true);
								this$.sendGetAjaxRequest(hostelApplicantWaitingUrl, 'GET', params, function(option, success, response) {
									if (success) {
										if (response.responseText == "true") {
											whetherApplicantWaiting.setDisabled(false);
											
										}
									}
								})
	
							}
   
                 	}
                    });
           			//applicantSetup  url
           			/*this$.sendGetAjaxRequest(applicantSetupUrl, 'GET', params, function(option, success, response) {
                    	if(success){
                    		//hostelRequiredDetails.setDisabled(true);
							
                    		 
                    	}
                    });*/
                	this$.sendGetAjaxRequest(submitUrl, 'GET', params, function(option, success, response) {
                    	if(success){
                    		if(!isNullOrEmpty(response.responseText)){
                    			var data = Ext.decode(response.responseText);
                    			var personInfo = personProfile.personInfo;
                            	var applicationDataObject = personProfile.applicationDataObject;
                            	
                            	/*var formObj = obj.up('form');
                            	var form = formObj.getForm();
                            	form.loadRecord(data);*/
                            	
                            	var formObj = obj.up('form');
                            	if(!isNullOrEmpty(data)){
                            		if(portalId == 6){
                            			var form = personProfile.getForm();
                            		}else{
                            			var form = formObj.getForm();
                            		}
                            		
                            		var jData=Ext.JSON.decode(response.responseText);
	   	                			form.setValues(jData);
	   	                			//form.findField('id').setValue(jData.id);
	   	                			if(!isNullOrEmpty(jData.tempAccommondationType)) {
	   	                				tempAccommondationId.setValue({tempAccommondationType: jData.tempAccommondationType});
	   	                			}
	   	                			else {
	   	                				tempAccommondationId.setValue({tempAccommondationType: tempAccommondationValue});
	   	                			}
	   	                			this$.loadApplicantCustomFieldData(form,jData);
	   	                			if(!isNullOrEmpty(jData.applyForWaitingList)) {
	   	                				applyForWaitingListTypeId.setValue({applyForWaitingList: jData.applyForWaitingList});
	   	                			} else {
	   	                				applyForWaitingListTypeId.setValue({applyForWaitingList: applyForWaitingListTypeValue});
	   	                			}
	   	                			
	   	                			// Show Hide Hostel Fields
	   	                			if( !isNullOrEmpty(jData.whetherHostelApplicable) ){
		   	              		   		hostelFieldsContainer1.setVisible(jData.whetherHostelApplicable);
		   	              		   		hostelFieldsContainer2.setVisible(jData.whetherHostelApplicable);
		   	              		   		if(!isNullOrEmpty(jData.applicantHostelDetails)) {
		   	              		   			this$.setApplicantHostelDetails(obj,jData);
		   	              		   		}
		   	              		   	} else{
		   	              		   		hostelFieldsContainer1.setVisible(false);
		   	              		   		hostelFieldsContainer2.setVisible(false);
		   	              		   		hostelFieldsContainer3.setVisible(false);
		   	              		   	}
	   	                			if(!isNullOrEmpty(jData.waitingListType) && !isNullOrEmpty(jData.waitingListType.id)){
	   	                				this$.setWaitingListTypeToHostel(obj,jData);
	   	                			}
	   	                			
	   	                			// Show Hide Custom Fields
	   	                			if( !isNullOrEmpty(jData.whetherHostelApplicable) ){
	   	                				this$.showHideApplicantHostelCustomFieldData(obj,jData.whetherHostelApplicable);
	   	                			} else{
	   	                				this$.showHideApplicantHostelCustomFieldData(obj,false);
									}
									var whetherWaiting=obj.down('#whetherApplicantWaiting');
									if (!isNullOrEmpty(data.isApplyForWaitingList) && data.isApplyForWaitingList) {
										whetherWaiting.setValue(true);
										whetherWaiting.setDisabled(false);
										whetherWaiting.setReadOnly(true)
										var waitingListCombo=obj.down('#waitingListSetupCombo');
					  					waitingListCombo.setVisible(true);
					  					var comboStore = waitingListCombo.getStore();
					  					comboStore.removeAll();
										comboStore.getProxy().extraParams = {};
										comboStore.load({
											callback: function(records, operation, success) {
												for (var i in records) {
													if (records[i].data.id == data.wsHostelApplicationSetup.id) {
														waitingListCombo.setValue(records[i].data.id);
														obj.down('#submitButtonId').setDisabled(true);
													}
												}
											}
										});
										//whetherWaiting.setDisabled(true);
										waitingListCombo.setReadOnly(true)
										obj.down('#submitButtonId').setDisabled(true);

									}else{
										whetherWaiting.setDisabled(true);
										obj.down('#submitButtonId').setDisabled(true);
									}
								}
                            }
                    	}
                    });
                //	this$.checkApplicantHostelRequirementDfr(obj);
                	obj.getForm().checkValidity();
                	setTimeout(function(){
                		this$.afterHostelFormRender(obj);
                		},300)
                }
            },
			'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm] checkboxfield[itemId=whetherApplicantWaiting]': {
				change: function(obj, newValue, oldValue) {
					var form = obj.up('form');
					var waitingListSetupCombo=form.down('#waitingListSetupCombo');
					var whetherWaiting=form.down('#whetherApplicantWaiting');
					var saveBtnHostel = form.down('#submitButtonId');
    				
					var personProfile = this.getContentPanelActiveTab();
					var applicationCode;
					try {
						personId = personProfile.getPersonId();
						applicationCode = personProfile.title
					} catch (e) {
						personId = this.getContentPanel().items.items[0].getPersonId();
						applicationCode = this.getContentPanel().items.items[0].applicationCode;
					}
    				var store = waitingListSetupCombo.getStore();
					store.getProxy().extraParams = {
						applicationCode: applicationCode
					};
					if(whetherWaiting.getValue()){
						waitingListSetupCombo.setVisible(true);
						store.load({
						callback: function(records, operation, success) {
							if (success && records && records.length === 1) {
								waitingListSetupCombo.setValue(records[0].data.id);
								 saveBtnHostel.setDisabled(false);
							}
						}
					});
					}else{
						waitingListSetupCombo.setVisible(false);
						saveBtnHostel.setDisabled(true);
					}
					
				}
			},
			'personhostelrequirementform customcombobox#waitingListSetupCombo': {
    			select: function(obj, record){
					var form = obj.up('form');
					var saveBtnHostel = form.down('#submitButtonId');
    				 saveBtnHostel.setDisabled(false);
    			}
    		},
            
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm] button[itemId=submitButtonId]': {
				click: function(obj) {
					var form = obj.up('form');
					if (form.down('#whetherApplicantWaiting').getValue() && !form.down('#isHostelRequired').getValue()) {
						var saveBtnHostel = form.down('#submitButtonId');
    					 saveBtnHostel.setDisabled(true);
						this.saveApplicantWaitingListDetails(obj);
					}else{
						this.saveApplicantHostelPersonalRequirmentDetails(obj);
					}
				}
            },
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm]  customcombobox[name=academyLocationCombo]':{
            	afterrender: function(obj){
            		var me = this;
            		var localtionFieldStore = obj.store;
            		
            		localtionFieldStore.on('beforeload', function(){
            			var profile = me.getContentPanelActiveTab();
            			localtionFieldStore.getProxy().extraParams = {
            				applicationID: profile.applicationId
            			};
            		});
            		
            		obj.listConfig.listeners.beforeshow = function(picker){
            			if(picker.up){
                			var locationField = picker.up('combobox');
                			picker.minWidth = locationField.getSize().width;
                    		var localtionFieldStore = locationField.store;
                			var allLocationFields = Ext.ComponentQuery.query('[name=academyLocationCombo]');
                			var allLocationArray = [];
                			Ext.each(allLocationFields, function(currentLocationField){
                				var currentVal = currentLocationField.getValue();
                				if(!isNullOrEmpty(currentVal) && locationField.itemId != currentLocationField.itemId){
                					allLocationArray.push(currentVal);
                				}
                			});
            				localtionFieldStore.clearFilter();
            				if(allLocationArray.length){
            					localtionFieldStore.filterBy(function(record, id){
                					return !Ext.Array.contains(allLocationArray, record.get('id'));
                				});
            				}
            			}
            		}
            		
            		localtionFieldStore.on('load', function(){
            			var allLocationFields = Ext.ComponentQuery.query('[name=academyLocationCombo]');
            			var allLocationArray = [];
            			Ext.each(allLocationFields, function(currentLocationField){
            				var currentVal = currentLocationField.getValue();
            				if(!isNullOrEmpty(currentVal) && obj.itemId != currentLocationField.itemId){
            					allLocationArray.push(currentVal);
            				}
            			});
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('id'));
            				});
        				}
            		});
            	},
            	select: function(obj, value){
            		var this$ = this,gender,todayAge,dateString;
            		var personProfile = this$.getContentPanelActiveTab();
            		if(personProfile.personInfo && personProfile.personInfo.genderCSM && personProfile.personInfo.genderCSM.value){
            			gender=personProfile.personInfo.genderCSM.code
            		}
            		if(personProfile.personInfo && personProfile.personInfo.birthDate){
            			dateString=personProfile.personInfo.birthDate
            		}
            		
            		var today = parseInt(personProfile.year);
            	    var birthDate = new Date(dateString);
            	    var age = today - birthDate.getFullYear();
            	    var m = 12 - birthDate.getMonth();
            	    if (m < 0 || (m === 0 && 31 < birthDate.getDate())) {
            	        age--;
            	    }
            	     todayAge= age;
            	     if(isNullOrEmpty(personProfile.year)) {
            	    	 todayAge=null;
            	     }
            		var locationId = value[0].data.id;
            		var firstPreference = obj.nextSibling();
            		var secondPreference = firstPreference.nextSibling();
            		var thirdPreference = secondPreference.nextSibling();
            		firstPreference.getStore().getProxy().extraParams = {};
            		firstPreference.getStore().getProxy().extraParams = {
            			locationId: locationId,
            			age:todayAge,
            			gender :gender
            		};
            		firstPreference.getStore().load(function(records){
            			firstPreference.reset();
            			if(records.length && records[0].data.hostelLevel == "Senior"){
            				this$.setAllowBlank(firstPreference,false);
            				secondPreference.setDisabled(true);
            				thirdPreference.setDisabled(true);
            				if(records.length ==1 ){
            					firstPreference.setValue(records[0].data.hostelId);
            				}
            			}else{
            				this$.setAllowBlank(firstPreference,true);
            				secondPreference.setDisabled(false);
            				thirdPreference.setDisabled(false);
            			}
            			
            		});
            		
            		if (!isNullOrEmpty(firstPreference)) {
            			
            			secondPreference.getStore().getProxy().extraParams = {};
            			secondPreference.getStore().getProxy().extraParams = {
            				locationId: locationId,
                			age:todayAge,
                			gender :gender
                		};
            			secondPreference.getStore().load();
            		}
            		if (!isNullOrEmpty(secondPreference)) {
            			thirdPreference.getStore().getProxy().extraParams = {};
            			thirdPreference.getStore().getProxy().extraParams = {
            				locationId: locationId,
                			age:todayAge,
                			gender :gender
                		};
            			thirdPreference.getStore().load();
            		}

            	}
            } ,
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm] [name=applicantHostelDetails1]':{
            	afterrender: function(obj){
            		var localtionFieldStore = obj.store;
            		var me = this;
            		
            		/*localtionFieldStore.on('beforeload', function(){
            			var alId = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0].up('fieldcontainer').down('[name=academyLocationCombo]').getValue();
            			localtionFieldStore.getProxy().extraParams = {
            				locationId: alId
            			};
            		});*/
            		
            		obj.listConfig.listeners.beforeshow = function(picker){
            			if(picker.up){
                			var currentField = picker.up('combobox');
                			picker.minWidth = currentField.getSize().width;
                    		var currentFieldStore = currentField.store;
                    		var sform = me.getPersonhostelrequirementform();
                			
                    		var combo1 = currentField;
                			var combo2 = combo1.nextSibling();
                			var combo3 = combo2.nextSibling();

                			var allLocationArray = [];
                			if(!isNullOrEmpty(combo2.getValue())){
                				allLocationArray.push(combo2.getValue());
                			}
                			if(!isNullOrEmpty(combo3.getValue())){
                				allLocationArray.push(combo3.getValue());
                			}
                			
                			currentFieldStore.clearFilter();
            				if(allLocationArray.length){
            					currentFieldStore.filterBy(function(record, id){
                					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
                				});
            				}
            			}
            		}
            		
            		localtionFieldStore.on('load', function(){
            			var combo1 = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0];
            			var combo2 = combo1.nextSibling();
            			var combo3 = combo2.nextSibling();
            			var allLocationArray = [];
            			if(!isNullOrEmpty(combo2.getValue())){
            				allLocationArray.push(combo2.getValue());
            			}
            			if(!isNullOrEmpty(combo3.getValue())){
            				allLocationArray.push(combo3.getValue());
            			}
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
            				});
        				}
            		});
            	}
            },
            
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm]  [name=applicantHostelDetails2]':{
            	afterrender: function(obj){
            		var localtionFieldStore = obj.store;
            		var me = this;

            		/*localtionFieldStore.on('beforeload', function(){
            			var alId = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0].up('fieldcontainer').down('[name=academyLocationCombo]').getValue();
            			localtionFieldStore.getProxy().extraParams = {
            				locationId: alId
            			};
            		});*/
            		
            		obj.listConfig.listeners.beforeshow = function(picker){
            			if(picker.up){
                			var currentField = picker.up('combobox');
                			picker.minWidth = currentField.getSize().width;
                    		var currentFieldStore = currentField.store;
                    		var sform = me.getPersonhostelrequirementform();
                			
                    		var combo2 = currentField;
                    		var combo1 = combo2.previousSibling();
                			var combo3 = combo2.nextSibling();

                			var allLocationArray = [];
                			if(!isNullOrEmpty(combo1.getValue())){
                				allLocationArray.push(combo1.getValue());
                			}
                			if(!isNullOrEmpty(combo3.getValue())){
                				allLocationArray.push(combo3.getValue());
                			}
                			
                			currentFieldStore.clearFilter();
            				if(allLocationArray.length){
            					currentFieldStore.filterBy(function(record, id){
                					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
                				});
            				}
            			}
            		}
            		
            		localtionFieldStore.on('load', function(){
            			var combo2 = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0];
            			var combo1 = combo2.previousSibling();
            			var combo3 = combo2.nextSibling();
            			var allLocationArray = [];
            			if(!isNullOrEmpty(combo1.getValue())){
            				allLocationArray.push(combo1.getValue());
            			}
            			if(!isNullOrEmpty(combo3.getValue())){
            				allLocationArray.push(combo3.getValue());
            			}
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
            				});
        				}
            		});
            	}
            },
            
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm]  [name=applicantHostelDetails3]':{
            	afterrender: function(obj){
            		var localtionFieldStore = obj.store;
            		var me = this;

            		/*localtionFieldStore.on('beforeload', function(){
            			var alId = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0].up('fieldcontainer').down('[name=academyLocationCombo]').getValue();
            			localtionFieldStore.getProxy().extraParams = {
            				locationId: alId
            			};
            		});*/
            		
            		obj.listConfig.listeners.beforeshow = function(picker){
            			if(picker.up){
                			var currentField = picker.up('combobox');
                			picker.minWidth = currentField.getSize().width;
                    		var currentFieldStore = currentField.store;
                    		var sform = me.getPersonhostelrequirementform();
                    		var combo3 = currentField
                			var combo2 = combo3.previousSibling();
                			var combo1 = combo2.previousSibling();

                			var allLocationArray = [];
                			if(!isNullOrEmpty(combo1.getValue())){
                				allLocationArray.push(combo1.getValue());
                			}
                			if(!isNullOrEmpty(combo2.getValue())){
                				allLocationArray.push(combo2.getValue());
                			}
                			
                			currentFieldStore.clearFilter();
            				if(allLocationArray.length){
            					currentFieldStore.filterBy(function(record, id){
                					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
                				});
            				}
            			}
            		}
            		
            		localtionFieldStore.on('load', function(){
            			var combo3 = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0];
            			var combo2 = combo3.previousSibling();
            			var combo1 = combo2.previousSibling();
            			var allLocationArray = [];
            			if(!isNullOrEmpty(combo2.getValue())){
            				allLocationArray.push(combo2.getValue());
            			}
            			if(!isNullOrEmpty(combo1.getValue())){
            				allLocationArray.push(combo1.getValue());
            			}
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
            				});
        				}
            		});
            	}
            },

            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm] checkboxfield[itemId=isHostelRequired]': {
         	   change: function(obj,newValue,oldValue) {
         		   var form = obj.up('form');
         		   var hostelFieldsContainer1 = form.down('#hostelFieldsContainer1');
         		   var hostelFieldsContainer2 = form.down('#hostelFieldsContainer2');
         		   var hostelFieldsContainer3 = form.down('#hostelFieldsContainer3');
         		   var hostelPreferencePanel = form.down('#hostelPreferencePanel');
         		   var locationDropdown = form.down('#academyLocationCombo');
         		   var saveBtnHostel=form.down('#submitButtonId');
         		   var personProfile = this.getContentPanelActiveTab();
         		   var personId;
         		   var applicationCode;
         		   var applicantsavebtnenbUrl = SERVERURL.PATH_IS_SAVE_BTN_ENABLE_APP_GENERAL_LIST_FOR_ADMIN;
         		   try{
         			   personId = personProfile.getPersonId();
         			   applicationCode= personProfile.title
         		   }catch(e){
         			   personId = this.getContentPanel().items.items[0].getPersonId();
         			   applicationCode= this.getContentPanel().items.items[0].applicationCode;
         		   }

         		   var params = {
         				   applicantPersonId: personId,
         				   applicationCode:applicationCode
         		   };
         		   if( newValue ){
         			   hostelFieldsContainer1.setVisible(true);
         			   hostelFieldsContainer2.setVisible(true);
         			   hostelFieldsContainer3.setVisible(true);
         			   hostelPreferencePanel.setVisible(true);
         			   
         			   // Show Custom Fields
         			   this.showHideApplicantHostelCustomFieldData(form,true);
         			   this.loadProgramLocationDropDown(locationDropdown,form );
         			   
         			  Ext.Ajax.request({
							type: 'rest',
							url: applicantsavebtnenbUrl,
							method: 'GET',
							params:params,
							callback : function(opt, success, response){

								if(newValue && response.responseText == "false") {
									saveBtnHostel.setDisabled(false);
								}else{
									saveBtnHostel.setDisabled(true);
								}
							
							}
						});
         		   } else{
         			   hostelFieldsContainer1.setVisible(false);
         			   hostelFieldsContainer2.setVisible(false);
         			   hostelFieldsContainer3.setVisible(false);
         			   hostelPreferencePanel.setVisible(false);
         			   // Hide Custom Fields
         			   this.showHideApplicantHostelCustomFieldData(form,false);
         			   
         			  Ext.Ajax.request({
							type: 'rest',
							url: applicantsavebtnenbUrl,
							method: 'GET',
							params:params,
							callback : function(opt, success, response){

								if(newValue && response.responseText == "false") {
									saveBtnHostel.setDisabled(false);
								}else{
									saveBtnHostel.setDisabled(true);
								}
							
							}
						});
         		   }
         		 // this.checkApplicantHostelRequirementDfr(form);
         		   form.getForm().checkValidity();
                }
            },
            
            'personhostelrequirementform[itemId=applicantPersonHostelRequirementForm] radiogroup[itemId=applyForWaitingListTypeId]': {
          	   change: function(obj,newValue,oldValue) {
          		   var form = obj.up('form');
          		   var waitingListTypeId = form.down('#waitingListTypeId');
          		   if(newValue.applyForWaitingList=='true' || newValue.applyForWaitingList==true){
          			 waitingListTypeId.setDisabled(false);
          		   } else{
          			 waitingListTypeId.reset();
          			 waitingListTypeId.setDisabled(true);
          		   }
          		   form.getForm().checkValidity();
                 }
             },
           
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantParentGuardianForm] radiogroup#isAlumnusRadio':{
            	change: function(obj){
            		var form = obj.up('parentguardianform');
            		this.onChangeIsAlumnus(form);
            	}
            },
            'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] customcombobox#applicantCampaign': {
    			render: function(obj){
    				var campaignNewStore = obj.getStore();
    				campaignNewStore.getProxy().extraParams = {
    					academyLocationIds: this.getCurrentAcademyLocation()
    				};
    				campaignNewStore.load();
    			},
    			select: function(obj, record){
    				var campaignId = record[0].get("id");    				
    				var form = this.getPersonalInformationForm();
    				var schoolPriorityField = form.down("#applicantSchoolPriority");
    				var newSchoolPriorityField = form.down("#schoolPriorityNew");
    				schoolPriorityField.reset();
    				newSchoolPriorityField.reset();
    				schoolPriorityField.setVisible(true);
    				newSchoolPriorityField.setVisible(false);
    				this.loadDFRForSchoolPriority(schoolPriorityField);    				
    				this.selectApplicantNewCampaignField(obj, campaignId);
    			}
    		},
    		'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] customcombobox#applicantCampaignSchool': {
    			select: function(obj, record){
    				var form = this.getPersonalInformationForm();
    				var campaignNewId = record[0].get("campaignId");
    				var campaignSchoolId = record[0].get("schoolId");
    				var newSchoolPriorityField = form.down("#schoolPriorityNew");
    				newSchoolPriorityField.setDisabled(false);
    				this.selectApplicantCampaignSchoolField(obj, campaignNewId, campaignSchoolId);
    			}
    		},
    		'applicantprofile personalinformationform[itemId=applicantPersonalInformationForm] profiledocuploadform[itemId=applicantDocUploadForm] filefield[itemId=documentFileUpload]': {
                change: function(fileField, value, eOpts) {
                    if (!isNullOrEmpty(value)) {
                        var $this = this;
                        value = value.replace('C:\\fakepath\\', '');
                        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                        fileField.setRawValue(newValue);
                        var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                              var specialCharsExist=false;
                              for(i = 0; i < specialChars.length;i++){
                              if(newValue.indexOf(specialChars[i]) > -1){
                                   specialCharsExist= true;
                               }
                               }
                              if(specialCharsExist){
                        		fileField.reset();
                                 showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                              }
                        var file = fileField.fileInputEl.dom.files[0];
                        var form = fileField.up().up();
                        var fileInfoContainer = form.down('#fileInfoContainer');
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        var docDetails = form.down('#docDetails');
                        var docType = form.down('#documentTypeCombo');
                            if ($this.isValidFileExtension(extension)) {
                                if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                    fileInfoContainer.setVisible(false);
                                    fileField.reset();
                                    showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                                }
                            } else {
                                fileInfoContainer.setVisible(false);
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                            }
                    }
                }
            } ,
	        'personalinformationform[itemId=applicantPersonalInformationForm] profiledocuploadform[itemId=applicantDocUploadForm] filefield[itemId=documentFileUpload]': {
                change: function(fileField, value, eOpts) {
                	if(portalId==6){
                		if (!isNullOrEmpty(value)) {
                        var $this = this;
                        value = value.replace('C:\\fakepath\\', '');
                        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                        fileField.setRawValue(newValue);
                        var specialChars = "<>@!#$%^&*()+[]{}?:;|'\"\\,/~`=";
                              var specialCharsExist=false;
                              for(i = 0; i < specialChars.length;i++){
                              if(newValue.indexOf(specialChars[i]) > -1){
                                   specialCharsExist= true;
                               }
                               }
                              if(specialCharsExist){
                        		fileField.reset();
                                 showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('SPECIAL_CHAR_NOT_ALLOWED'));
                              }
                        var file = fileField.fileInputEl.dom.files[0];
                        var form = fileField.up().up();
                        var fileInfoContainer = form.down('#fileInfoContainer');
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        var docDetails = form.down('#docDetails');
                        var docType = form.down('#documentTypeCombo');
                            if ($this.isValidFileExtension(extension)) {
                                if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                    fileInfoContainer.setVisible(false);
                                    fileField.reset();
                                    showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                                }
                            } else {
                                fileInfoContainer.setVisible(false);
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                            }
                    }}
                }
            },
            'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#stuPermanentResItemId':{
           	 change:function(obj,newValue,oldValue){
           		 var  $this = this;
           		 var form = obj.up('personalinformationform');
           		 var value = newValue.isPermanentResident;
           		 $this.SAValueValidationOnPersonalForm(form,value);
           		 
            }
     		 },
            'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#stuAsylumSeekerItemId':{
    			 change:function(obj,newValue,oldValue){
     				var form = obj.up('personalinformationform');
     				 var value = newValue.isAsylumSeeker;
     				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
     				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
     				var diplomaticStatusId = form.down("#diplomaticStatusId");
     				var temporaryStudyId = form.down("#temporaryStudyId");
     				var workCriticalSkillsId = form.down("#workCriticalSkillsId");
     				var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
     				 if(!isNullOrEmpty(value)){
     				 if(value==true){
     					stuAreYouRefugeeItemId.items.items[0].setValue(false);
     					stuAreYouRefugeeItemId.items.items[1].setValue(true);
     					stuAreYouRefugeeItemId.setDisabled(true);
     					
     					stuPermanentResItemId.items.items[0].setValue(false);
     					stuPermanentResItemId.items.items[1].setValue(true);
     					stuPermanentResItemId.setDisabled(true);
     		
     					diplomaticStatusId.setDisabled(true);
     					temporaryStudyId.setDisabled(true);
     					workCriticalSkillsId.setDisabled(true);
     					postgraduateNonResidentialStudentId.setDisabled(true);
     				 }else{
     					stuAreYouRefugeeItemId.setDisabled(false);
     					stuPermanentResItemId.setDisabled(false);
     					diplomaticStatusId.setDisabled(false);
     					temporaryStudyId.setDisabled(false);
     					workCriticalSkillsId.setDisabled(false);
     					postgraduateNonResidentialStudentId.setDisabled(false);
     				 }
     				 }
     			 }
     		 },
            'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#stuAreYouRefugeeItemId':{
    			 change:function(obj,newValue,oldValue){    
    				 var form = obj.up('personalinformationform');
     				 var value = newValue.areYouRefugee;
     				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
     				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
     				var diplomaticStatusId = form.down("#diplomaticStatusId");
     				var temporaryStudyId = form.down("#temporaryStudyId");
     				var workCriticalSkillsId = form.down("#workCriticalSkillsId");
     				var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
     				 if(!isNullOrEmpty(value)){
     				 if(value==true){
     					stuAsylumSeekerItemId.items.items[0].setValue(false);
     					stuAsylumSeekerItemId.items.items[1].setValue(true);
     					stuAsylumSeekerItemId.setDisabled(true);
     					
     					stuPermanentResItemId.items.items[0].setValue(false);
     					stuPermanentResItemId.items.items[1].setValue(true);
     					stuPermanentResItemId.setDisabled(true);
     					
     					diplomaticStatusId.setDisabled(true);
     					temporaryStudyId.setDisabled(true);
     					workCriticalSkillsId.setDisabled(true);
     					postgraduateNonResidentialStudentId.setDisabled(true);
     				 }else{
     					stuAsylumSeekerItemId.setDisabled(false);
     					stuPermanentResItemId.setDisabled(false);
     					diplomaticStatusId.setDisabled(false);
     					temporaryStudyId.setDisabled(false);
     					workCriticalSkillsId.setDisabled(false);
     					postgraduateNonResidentialStudentId.setDisabled(false);
     				 }
     				 }
     			 }
     		 },
     		'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#diplomaticStatusId':{
   			 change:function(obj,newValue,oldValue){    
   				 var form = obj.up('personalinformationform');
    				 var value = newValue.diplomaticStatus;
    				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
    				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
    				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
    				var temporaryStudyId = form.down("#temporaryStudyId");
    				var workCriticalSkillsId = form.down("#workCriticalSkillsId");
    				var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
    				 if(!isNullOrEmpty(value)){
    				 if(value==true){
    					stuAsylumSeekerItemId.items.items[0].setValue(false);
    					stuAsylumSeekerItemId.items.items[1].setValue(true);
    					stuAsylumSeekerItemId.setDisabled(true);
    					
    					stuPermanentResItemId.items.items[0].setValue(false);
    					stuPermanentResItemId.items.items[1].setValue(true);
    					stuPermanentResItemId.setDisabled(true);
    					
    					stuAreYouRefugeeItemId.items.items[0].setValue(false);
    					stuAreYouRefugeeItemId.items.items[1].setValue(true);
    					stuAreYouRefugeeItemId.setDisabled(true);
    					
    					temporaryStudyId.setDisabled(true);
    					workCriticalSkillsId.setDisabled(true);
    					postgraduateNonResidentialStudentId.setDisabled(true);
    				 }else{
    					stuAsylumSeekerItemId.setDisabled(false);
    					stuPermanentResItemId.setDisabled(false);
    					stuAreYouRefugeeItemId.setDisabled(false);
    					temporaryStudyId.setDisabled(false);
    					workCriticalSkillsId.setDisabled(false);
    					postgraduateNonResidentialStudentId.setDisabled(false);
    				 }
    				 }
    			 }
    		 },
    		 'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#temporaryStudyId':{
       			 change:function(obj,newValue,oldValue){    
       				 var form = obj.up('personalinformationform');
        				 var value = newValue.temporaryStudy;
        				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
        				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
        				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
        				 var diplomaticStatusId = form.down("#diplomaticStatusId");
        				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
        				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
        				 if(!isNullOrEmpty(value)){
        				 if(value==true){
        					stuAsylumSeekerItemId.items.items[0].setValue(false);
        					stuAsylumSeekerItemId.items.items[1].setValue(true);
        					stuAsylumSeekerItemId.setDisabled(true);
        					
        					stuPermanentResItemId.items.items[0].setValue(false);
        					stuPermanentResItemId.items.items[1].setValue(true);
        					stuPermanentResItemId.setDisabled(true);
        					
        					stuAreYouRefugeeItemId.items.items[0].setValue(false);
        					stuAreYouRefugeeItemId.items.items[1].setValue(true);
        					stuAreYouRefugeeItemId.setDisabled(true);
        					
        					diplomaticStatusId.setDisabled(true);
        					workCriticalSkillsId.setDisabled(true);
        					postgraduateNonResidentialStudentId.setDisabled(true);
        				 }else{
        					stuAsylumSeekerItemId.setDisabled(false);
        					stuPermanentResItemId.setDisabled(false);
        					stuAreYouRefugeeItemId.setDisabled(false);
        					diplomaticStatusId.setDisabled(false);
        					workCriticalSkillsId.setDisabled(false);
        					postgraduateNonResidentialStudentId.setDisabled(false);
        				 }
        				 }
        			 }
        		 },
        		 'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#workCriticalSkillsId':{
           			 change:function(obj,newValue,oldValue){    
           				 var form = obj.up('personalinformationform');
            				 var value = newValue.workCriticalSkills;
            				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
            				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
            				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
            				 var diplomaticStatusId = form.down("#diplomaticStatusId");
            				 var temporaryStudyId = form.down("#temporaryStudyId");
            				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
            				 if(!isNullOrEmpty(value)){
            				 if(value==true){
            					 stuAsylumSeekerItemId.items.items[0].setValue(false);
            					stuAsylumSeekerItemId.items.items[1].setValue(true);
            					stuAsylumSeekerItemId.setDisabled(true);
            					
            					stuPermanentResItemId.items.items[0].setValue(false);
            					stuPermanentResItemId.items.items[1].setValue(true);
            					stuPermanentResItemId.setDisabled(true);
            					
            					stuAreYouRefugeeItemId.items.items[0].setValue(false);
            					stuAreYouRefugeeItemId.items.items[1].setValue(true);
            					stuAreYouRefugeeItemId.setDisabled(true);
            					
            					diplomaticStatusId.setDisabled(true);
            					temporaryStudyId.setDisabled(true);
            					postgraduateNonResidentialStudentId.setDisabled(true);
            				 }else{
            					stuAsylumSeekerItemId.setDisabled(false);
            					stuPermanentResItemId.setDisabled(false);
            					stuAreYouRefugeeItemId.setDisabled(false);
            					diplomaticStatusId.setDisabled(false);
            					temporaryStudyId.setDisabled(false);
            					postgraduateNonResidentialStudentId.setDisabled(false);
            				 }
            				 }
            			 }
            		 },
            		 'personalinformationform[itemId=applicantPersonalInformationForm] radiogroup#postgraduateNonResidentialStudentId':{
               			 change:function(obj,newValue,oldValue){    
               				 var form = obj.up('personalinformationform');
                				 var value = newValue.postgraduateNonResidentialStudent;
                				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
                				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
                				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
                				 var diplomaticStatusId = form.down("#diplomaticStatusId");
                				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
                				 var temporaryStudyId = form.down("#temporaryStudyId");
                				 if(!isNullOrEmpty(value)){
                				 if(value==true){
                					stuAsylumSeekerItemId.items.items[0].setValue(false);
                					stuAsylumSeekerItemId.items.items[1].setValue(true);
                					stuAsylumSeekerItemId.setDisabled(true);
                					
                					stuPermanentResItemId.items.items[0].setValue(false);
                					stuPermanentResItemId.items.items[1].setValue(true);
                					stuPermanentResItemId.setDisabled(true);
                					
                					stuAreYouRefugeeItemId.items.items[0].setValue(false);
                					stuAreYouRefugeeItemId.items.items[1].setValue(true);
                					stuAreYouRefugeeItemId.setDisabled(true);
                					
                					diplomaticStatusId.setDisabled(true);
                					workCriticalSkillsId.setDisabled(true);
                					temporaryStudyId.setDisabled(true);
                				 }else{
                					stuAsylumSeekerItemId.setDisabled(false);
                					stuPermanentResItemId.setDisabled(false);
                					stuAreYouRefugeeItemId.setDisabled(false);
                					diplomaticStatusId.setDisabled(false);
                					workCriticalSkillsId.setDisabled(false);
                					temporaryStudyId.setDisabled(false);
                				 }
                				 }
                			 }
                		 },
            'personalinformationform[itemId=applicantPersonalInformationForm] nestedJsonCombo#nationalityCombo':{
           	 select: function(combo, record) {
           		 var form = combo.up('personalinformationform');
           		 var newValue = record[0].data.code;
           		 var stuSecondaryCitizenshipCombo = form.down("#stuSecondaryCitizenshipItemId");
           		 var stuSecondaryCitizenshipComboCode = stuSecondaryCitizenshipCombo.getStore().findRecord('value',stuSecondaryCitizenshipCombo.getRawValue());
           		 var stuSecondaryCitizenshipValue=null;
           		 if(!isNullOrEmpty(stuSecondaryCitizenshipComboCode)){
           			 stuSecondaryCitizenshipValue = stuSecondaryCitizenshipComboCode.data.code; 
           		 }
           		 var idTypeCombo = form.down("#idTypeCombo");
           		 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
           		 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
           		 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
           		 if(newValue=='South African' || stuSecondaryCitizenshipValue =='South African'){
           			 stuPermanentResItemId.items.items[0].setValue(false);
           			 stuPermanentResItemId.items.items[1].setValue(false);
           			 stuPermanentResItemId.setDisabled(true);
           			 stuAsylumSeekerItemId.items.items[0].setValue(false);
           			 stuAsylumSeekerItemId.items.items[1].setValue(false);
           			 stuAsylumSeekerItemId.setDisabled(true);
           			 stuAreYouRefugeeItemId.items.items[0].setValue(false);
           			 stuAreYouRefugeeItemId.items.items[1].setValue(false);
           			 stuAreYouRefugeeItemId.setDisabled(true);
           			 idTypeCombo.getStore().load({
           				 callback: function(records, operation, success) {
     						   for(var i in records){
     							   if(!isNullOrEmpty(records[i].data.idTypeCode)){
     								   if(records[i].data.idTypeCode=='NATIONAL_ID'){
     									 idTypeCombo.setValue(records[i].data.id);
     									   idTypeCombo.setReadOnly(true);
     									   return false;
     								   }else{
     									 idTypeCombo.setReadOnly(false); 
     									idTypeCombo.reset();
     								   } 
     							   }
     						   }
     					   }
           			 })
           		 }else{
           			 stuPermanentResItemId.setDisabled(false);
           			 stuAsylumSeekerItemId.setDisabled(false);
           			 stuAreYouRefugeeItemId.setDisabled(false);
           			 idTypeCombo.setReadOnly(false); 
   					 idTypeCombo.reset();
           		 }
           	 }
     		 } ,
            'personalinformationform[itemId=applicantPersonalInformationForm] nestedJsonCombo#stuSecondaryCitizenshipItemId':{
           	 select: function(combo, record) {
           		 var form = combo.up('personalinformationform');
           		 var newValue = record[0].data.code;
           		 var nationalityCombo = form.down("#nationalityCombo");
           		 var nationalityComboCode = nationalityCombo.getStore().findRecord('value',nationalityCombo.getRawValue());
           		 var nationalityValue=null;
           		 if(!isNullOrEmpty(nationalityComboCode)){
           			  nationalityValue = nationalityComboCode.data.code; 
           		 }
           		 var idTypeCombo = form.down("#idTypeCombo");
           		 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
           		 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
           		 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
           		 if(newValue=='South African' || nationalityValue == 'South African'){
           			 stuPermanentResItemId.items.items[0].setValue(false);
           			 stuPermanentResItemId.items.items[1].setValue(false);
           			 stuPermanentResItemId.setDisabled(true);
           			 stuAsylumSeekerItemId.items.items[0].setValue(false);
           			 stuAsylumSeekerItemId.items.items[1].setValue(false);
           			 stuAsylumSeekerItemId.setDisabled(true);
           			 stuAreYouRefugeeItemId.items.items[0].setValue(false);
           			 stuAreYouRefugeeItemId.items.items[1].setValue(false);
           			 stuAreYouRefugeeItemId.setDisabled(true);
           			 idTypeCombo.getStore().load({
           				 callback: function(records, operation, success) {
     						   for(var i in records){
     							   if(!isNullOrEmpty(records[i].data.idTypeCode)){
     								   if(records[i].data.idTypeCode=='NATIONAL_ID'){
     									 idTypeCombo.setValue(records[i].data.id);
     									   idTypeCombo.setReadOnly(true);
     									   return false;
     								   }else{
     									 idTypeCombo.setReadOnly(false); 
     									idTypeCombo.reset();
     								   } 
     							   }
     						   }
     					   }
           			 })
           		 }else{
           			 stuPermanentResItemId.setDisabled(false);
           			 stuAsylumSeekerItemId.setDisabled(false);
           			 stuAreYouRefugeeItemId.setDisabled(false);
           			 idTypeCombo.setReadOnly(false); 
   					 idTypeCombo.reset();
           		 }
           	 }
     		 },
			'personalinformationform[itemId=applicantPersonalInformationForm] customcombobox#idTypeCombo':{
           	 	select: function(combo, record) {
					var personProfile = this.getContentPanelActiveTab(); 
        			var personalInformationForm = personProfile.down('personalinformationform');      
            		var identityExpiryDateItemId = personalInformationForm.down("#identityExpiryDateItemId");
            		var idNumberSecond = personalInformationForm.down("#idNumberSecond");
            		if (!isNullOrEmpty(record[0].data.idTypeCode) && record[0].data.idTypeCode == 'NATIONAL_ID') {
						identityExpiryDateItemId.setVisible(false);
						identityExpiryDateItemId.allowBlank = true;
						idNumberSecond.setVisible(false);
						idNumberSecond.reset();
						idNumberSecond.allowBlank = true;
					} else {
						idNumberSecond.setVisible(true);
						this.checkDFRForIdNumberSecond(personalInformationForm);
						var isIdentityExpiryDateVisible = localStorage.getItem('identityExpiryDateIsVisible');
						var identityExpiryDateIsMendatory = localStorage.getItem('identityExpiryDateIsMendatory');
						 if(!isNullOrEmpty(isIdentityExpiryDateVisible) && isIdentityExpiryDateVisible){
							personalInformationForm.down("#identityExpiryDateItemId").setVisible(isIdentityExpiryDateVisible);
							if (!isNullOrEmpty(identityExpiryDateIsMendatory) && identityExpiryDateIsMendatory) {
								identityExpiryDateItemId.allowBlank = false;
							}else{
								identityExpiryDateItemId.allowBlank = true;
							}
							personalInformationForm.isValid();
						 }
					}
					personalInformationForm.isValid();
					identityExpiryDateItemId.reset();
					idNumberSecond.reset();
				}
			},
			'personalinformationform[itemId=applicantPersonalInformationForm] button[itemId=validateID]': {
				click: function(obj) {
					var $this = this;
					var personalInformationForm = obj.up('personalinformationform');
					if(personalInformationForm){
						var data = personalInformationForm.getValues()
					}
					var idTypeCodeValue = personalInformationForm.down('#idTypeCombo').getStore().findRecord('id',data.idtype);
					if(!isNullOrEmpty(data.nationality)){
						 var index = personalInformationForm.down('#nationalityCombo').getStore().findExact('id',data.nationality.id);
						  if(index !== -1){
							   var nationalityCodeValue = personalInformationForm.down('#nationalityCombo').getStore().getAt(personalInformationForm.down('#nationalityCombo').getStore().findExact('id',data.nationality.id));
						  } 
						
					}
					if(!isNullOrEmpty(data.secondaryCitizenship)){
						 var index = personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().findExact('id',data.secondaryCitizenship.id);
						  if(index !== -1){
							   var secondaryCitizenshipValue = personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().getAt(personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().findExact('id',data.secondaryCitizenship.id));
						  } 
					}
					var uwcUrl=SERVERURL.PATH_GET_FIND_BY_RELEVANT_TO;
					Ext.Ajax.request({
						type: 'rest',
						url: uwcUrl + '?relavantToFormType=' + "APPLICATION",
						method: 'GET',
						success: function(response, action) {
							Ext.getBody().unmask();
							if(!isNullOrEmpty(response.responseText) && (response.responseText)!=""){
							var responseData = Ext.JSON.decode(response.responseText);
								if (responseData != null) {
									$this.checkUwcNationalIdValidation(responseData, data, nationalityCodeValue, idTypeCodeValue);
								    } 
								} 
								else {
									if (!isNullOrEmpty(idTypeCodeValue) && idTypeCodeValue.data.idTypeCode == 'NATIONAL_ID') {
										var nationalId = data.nationalID;
										var birthDate = data.birthDate;
										var gender = data.genderCSM;
										var message = '';
										if (!isNullOrEmpty(nationalId)) {
											if (nationalId.length > 13 || nationalId.length < 13) {
												message = message + getCommonTranslation('NATIONALID_SHOULDBE_13DIGITS') + '<br>';
											}
											if (!isNumberValidate(nationalId)) {
												message = message + getCommonTranslation('NATIONALID_CANBE_ONLYDIGITS') + '<br>';
											}
											if (nationalId.length > 5 && !isNullOrEmpty(birthDate)) {
												var splitDOB = birthDate.split('-');
												var dobYear = splitDOB[0].substr(-2);
												var dobMonth = splitDOB[1];
												var dobDay = splitDOB[2];
												var dateOfBirth = dobYear + dobMonth + dobDay;
												var firstSixDigit = nationalId.substr(0, 6);
												if (firstSixDigit != dateOfBirth) {
													message = message + getCommonTranslation('INVALID_DOB_ID_NUMBER_PROVIDED') + '<br>';
												}
											}
											if (nationalId.length > 9 && !isNullOrEmpty(gender)) {
												var sevenToTenDigit = nationalId.substr(6, 4);
												if ((gender.id == 2 && (sevenToTenDigit >= 0 && sevenToTenDigit <= 4999)) || (gender.id == 1 && (sevenToTenDigit >= 5000 && sevenToTenDigit <= 9999))) {

												} else {
													message = message + getCommonTranslation('INVALID_GENDER_IDNUMBER_PROVIDED') + '<br>';
												}
											}
											var eleventhDigit = nationalId.substr(10, 1);
											if (nationalId.length > 10 && eleventhDigit == 0 && ((isNullOrEmpty(nationalityCodeValue) && secondaryCitizenshipValue.data.code != 'South African') || (isNullOrEmpty(secondaryCitizenshipValue) && nationalityCodeValue.data.code != 'South African') || ((!isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code != 'South African') && (!isNullOrEmpty(secondaryCitizenshipValue) && secondaryCitizenshipValue.data.code != 'South African')))) {
												message = message + getCommonTranslation('INVALID_CITIZENSHIP_IDNUMBER_PROVIDED') + '<br>';
											} else if (nationalId.length > 10 && eleventhDigit == 1 && data.isPermanentResident != true) {
												message = message + getCommonTranslation('INVALID_PERMANENT_RESIDENT_DETAILS') + '<br>';
											} else if (nationalId.length > 10 && eleventhDigit > 1) {
												message = message + getCommonTranslation('INVALID_DETAILS_ID_NUMBER_PROVIDED') + '<br>';
											}
											if (message != '') {
												showNotificationMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), message);
											} else {
												showOkWithSuccessMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), getCommonTranslation('NATIONALID_IS_VALID'));
											}
										}
									}
								}
						}
					});
					
				}		
			},
			'personinfopanel' : {
				tabchange : function(tabPanel, newCard, oldCard, eOpts ){
					var $this = this;
					var contentPanelTab = this.getContentPanelActiveTab();
					var structure = contentPanelTab.down('[region=center]');
					structure.scrollBy(0,1);
					structure.scrollBy(0,-1);
				}
			},
			'applicantpermitgrid[itemId=applicantpermitgridId]': {
            	render: function(grid) {
            		var $this = this;
            		$this.loadGridStore('#applicantpermitgridId', SERVERURL.PATH_APPLICANT_PERMIT_DETAIL_GRID_DATA);
            		$this.doAccessControlValidation(grid, $this.getAPPLICANT_PERMIT_DETAIL_PERMISSION());
                	var applicantProfilePanel = grid.up('applicantprofile');
             		var structure = applicantProfilePanel.down('[region=center]');
             		this$.getGridHeaderFreezeStudentProfile(grid,structure,true);
            	},
            	afterrender:function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getAPPLICANT_PERMIT_DETAIL_PERMISSION());
    			},
    			selectionchange: function(column, selected,eOpts ){
            		var grid = column.view.up('grid');
                	if(selected.length > 1){
                		grid.down('#btnAdd').setDisabled(true);
                		grid.down('#btnEdit').setDisabled(true);
                		grid.down('#btnView').setDisabled(true);
                	}else if(selected.length==1){
                		grid.down('#btnAdd').setDisabled(true);
                		grid.down('#btnEdit').setDisabled(false);
                		grid.down('#btnView').setDisabled(false);
                	}else{
                		grid.down('#btnAdd').setDisabled(false);
                		grid.down('#btnEdit').setDisabled(false);
                		grid.down('#btnView').setDisabled(false);
                	}
    			},
    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	 				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	 				if(columnName == "permitDetailDocuments"){
	 					if(e.target.tagName=='A'){
	 						if(record.data.permitDetailDocuments.length == 1){
	 							var whetherFile = false;
								var documentId= record.data.permitDetailDocuments["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}
	 						}
	 						else if(record.data.permitDetailDocuments.length > 1){
	 							var docWindow = this.getApplicantpermitdocumentlist();
	 							var ID = record.data.id;
	 							if (!docWindow) {
	 								docWindow = Ext.widget('applicantpermitdocumentlist',{
	 									itemId:'applicantpermitdocumentlist'
	 								});
	 							}
	 							docWindow.show();
	 							var permitdocumentlistgrid = docWindow.down('#applicantpermitdocumentlistgridItemId');
	 							var store = permitdocumentlistgrid.getStore();
	 							store.getProxy().extraParams = {
	 								ID: record.data.id
	 							};
	 							store.load();
	 						}
	 					}
	 				}
	 				if(columnName == "permitDetailUrlDocuments"){
	 					if(e.target.tagName=='A'){
	 						if(record.data.permitDetailUrlDocuments.length > 1){    	
	 							var docWindow = this.getApplicantpermiturldocumentlist();
	 							var ID = record.data.id;
	 							if (!docWindow) {
	 								docWindow = Ext.widget('applicantpermiturldocumentlist',{
	 									itemId:'applicantpermiturldocumentlist'
	 								});
	 							}
	 							docWindow.show();
	 							var permiturldocumentlistgrid = docWindow.down('#applicantpermiturldocumentlistgridItemId');
	 							var store = permiturldocumentlistgrid.getStore();
	 							store.getProxy().extraParams = {
	 								ID: record.data.id
	 							};
	 							store.load();
	 						}
	 					}
	 				}
	 			}
            },
            'applicantpermitgrid[itemId=applicantpermitgridId] button[itemId=btnAdd]': {
            	click: function() {
            		var $this = this;
            		var formWindow = $this.getPersonCommonWindow();
            		$this.showPersonCommonWindow(formWindow, 'PERMIT_DETAILS', 'applicantPermitDetailFormId', true);
            	}
            },
            'applicantpermitgrid[itemId=applicantpermitgridId] button[itemId=btnEdit]': {
            	click: function() {
            		var $this = this;
            		$this.editPermitDetail('PERMIT_DETAILS', 'applicantPermitDetailFormId', '#applicantpermitgridId', false);
            		$this.loadApplicantPermitDocumentWindow();
            		$this.loadApplicantPermitDocumentUrlWindow();
            	}
            },
            'applicantpermitgrid[itemId=applicantpermitgridId] button[itemId=btnView]': {
            	click: function() {
            		var $this = this;
            		$this.viewPermitDetail('PERMIT_DETAILS', 'applicantPermitDetailFormId', '#applicantpermitgridId');
            		$this.loadApplicantPermitDocumentWindow();
            		$this.loadApplicantPermitDocumentUrlWindow();
            		var form = $this.getPermitdetailform();
            		form.isValid();
            	}
            },
            'applicantpermitgrid[itemId=applicantpermitgridId] button[itemId=btnDelete]': {
            	click: function() {
            		var $this = this;
            		$this.deletePermitDetail('#applicantpermitgridId', SERVERURL.PATH_APPLICANT_PERMIT_DETAIL_DELETE, 'APPLICANT_PERMIT_DETAIL_DELETE_SUCCESSFULLY');
            	}
            },
            'permitdetailform[itemId=applicantPermitDetailFormId] checkboxfield[itemId=isPrimaryItemId]' : {
                change:function(val) {
                    var form= this.getPermitdetailform();
                    var id = form.down("#permit_detail_hidden_field");
                    var isPrimaryFiled=form.down('#isPrimaryItemId');
   	 				var gridStore  = this.getApplicantpermitgrid().getStore();
   	 				if(isNullOrEmpty(id)){
   	 					if(gridStore.data.items.length!=null){
   	 						gridStore.data.items.forEach(function(itemObj){
   	 							if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
   	 								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
   	 								isPrimaryFiled.setValue(false);
   	 							}
   	 						});
   	 					}
   	 				}else{
   	 					if(gridStore.data.items.length!=null){
   	 						gridStore.data.items.forEach(function(itemObj){
   	 							if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
   	 								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
   	 								isPrimaryFiled.setValue(false);
   	 							}
   	 						});
   	 					}
   	 				}
                }
            },
            'permitdetailform[itemId=applicantPermitDetailFormId] button[itemId=uploadPermitDocItemId]': {
            	click : function() {
	 				this.getDocumentController().showDocumentFormWindow('applicant_permit_detail_hidden_field','DOCUMENT');
	 				setTimeout(function(){
			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getCommonTranslation('DOCUMENT_NAME'));
            		},100); 
	 			}
            },
            'permitdetailform[itemId=applicantPermitDetailFormId] button[itemId=uploadPermitUrlItemId]': {
            	click : function() {
	 				this.getDocumentController().showDocumentFormWindow('applicant_permit_detail_hidden_field','DOCUMENT_URL');
	 				var formWindow = this.getDocumentformwindow();
 					if (!formWindow) {
 						Ext.widget('documentformwindow');
 						formWindow = this.getDocumentformwindow();
 					}
 					formWindow.setTitle(getCommonTranslation('URL_DETAILS'));
	 			}
            },
            'documentformwindow[itemId=applicant_permit_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	 			var isTransient = true;
	 			var module = 'applicantPermit';
	 			var entityId;
	 			var entityType = 'applicantPermitDocument';
	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	 					function(success,response,isCallBackTransient) {
	 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
	 						var documentModel = new Academia.model.personinfo.common.personalinfo.PermitDocumentGridModel();
	 						documentModel.set("name",response.name);
	 						documentModel.set("path",response.path);
	 						documentModel.set("type",response.type);
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
	 						if(documentModel.data.path.length > 255){
	                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
	                          }else {
			 						var applicantPermitDocGrid = $this.getApplicantpermitdocumentgrid();
			 						var store = applicantPermitDocGrid.getStore();
			 						store.add(documentModel);
			 						if (applicantPermitDocGrid.isHidden() && store.data.items.length > 0) {
			 							applicantPermitDocGrid.setVisible(true);
			 						}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						showSuccessMessage(getCommonTranslation('APPLICANT_PERMIT_DOCUMENT'),getCommonTranslation('APPLICANT_PERMIT_DOCUMENT_ADD_SUCCESSFULLY'));
	                          }
	 					}, isTransient);
	 	    	}
		 	},
		 	
		 	'documentformwindow[itemId=applicant_permit_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController().closeDocumentFormWindow();
		 		}
		 	},
		 	'documentformwindow[itemId=applicant_permit_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
		 			var $this = this;
		 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
		            form.down('#documentFormSubmitButtonId').setDisabled(true);
		            fields : ['id','documentId','documentName','path','createdBy']
		            var documentModelUrl = new Academia.model.personinfo.common.personalinfo.PermitUrlDocumentGridModel();
	
		            var documentName=form.down('#documentNameField').getValue();
		            var UrlName=form.down('#documentUrlField').getValue();
		            documentModelUrl.set("documentName",documentName);
		            documentModelUrl.set("path",UrlName);
		            
		            documentModelUrl.set("type",'DOCUMENT');
		            var userId = this.getCurrentlyLoggedInUser()
		            documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
		            
		            var applicantPermitUrlGrid = $this.getApplicantpermiturldocumentgrid();
		            var store2= applicantPermitUrlGrid.getStore();
		            store2.add(documentModelUrl);
		            if (applicantPermitUrlGrid.isHidden() && store2.data.items.length > 0) {
		            	applicantPermitUrlGrid.setVisible(true);
		            }
		            $this.getDocumentController().closeDocumentFormWindow();
		            showSuccessMessage(getCommonTranslation('APPLICANT_PERMIT_URL'),getCommonTranslation('APPLICANT_PERMIT_URL_ADD_SUCCESSFULLY'));
	 	    	}
		 	},
            
		 	'documentformwindow[itemId=applicant_permit_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController().closeDocumentFormWindow();
		 		}
		 	},
		 	'permitdetailform[itemId=applicantPermitDetailFormId] button[itemId=submitButtonId]' : {
	 			click : function() {
	               this.savePermitDetail('#applicantpermitgridId', SERVERURL.PATH_APPLICANT_PERMIT_DETAIL_ADD, SERVERURL.PATH_APPLICANT_PERMIT_DETAIL_UPDATE,'APPLICANT');
	 			}
	 		},
	 		'permitdetailform[itemId=applicantPermitDetailFormId] button[itemId=cancelButtonId]' : {
	 			click: this.closePersonCommonWindow
 			},
 			'applicantpermitdocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this.getApplicantpermitdocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }
					 }
				 }
			 },
 			'applicantpermitdocumentgrid button[itemId=btnDelete]' : {
 	 			 click : function() {
 	 				 var $this = this;
 	 				 var grid=$this.getApplicantpermitdocumentgrid();
 	 				 if (grid.getSelectionModel().getCount() > 0) {
 	 					 Ext.MessageBox.confirm(getCommonTranslation('APPLICANT_PERMIT_DOCUMENT'),getCommonTranslation('PERMIT_DETAIL_DELETE_CONFIRM_MSG'),
 	 							 function(btn, text) {
 	 						 		if (btn == 'yes') {
 	 						 			var store = grid.getStore();
 	 						 			var record = grid.getSelectionModel().getSelection()[0];
 	 						 			var id = record.id;
 	 						 			if (isNullOrEmpty(id)) {
 	 						 			}else if(record) {
 	 						 				store.remove(record);
 	 						 				showSuccessMessage(getCommonTranslation('APPLICANT_PERMIT_DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 	 						 				if(store.data.items.length == 0) {
 	 						 					grid.setVisible(false);
 	 						 				}	
 	 						 			}
 	 						 		}
 	 					 });
 	 				 } else {
 	 					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 	 				 }
 	 			 }
 			},
 	 		'applicantpermiturldocumentgrid button[itemId=btnDelete]' : {
	 			 click : function() {
	 				 var $this = this;
					 var grid = Ext.ComponentQuery.query('applicantpermiturldocumentgrid')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox.confirm(getCommonTranslation('APPLICANT_PERMIT_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							 function(btn, text) {
	 						 		if (btn == 'yes') {
	 						 			var store = grid.getStore();
	 						 			var record = grid.getSelectionModel().getSelection()[0];
	 						 			var id = record.id;
	 						 			if (isNullOrEmpty(id)) {
	 						 			}else if(record) {
	 						 				store.remove(record);
	 						 				showSuccessMessage(getCommonTranslation('APPLICANT_PERMIT_URL'),getCommonTranslation('URL_SUCCESS_MSG'));
	 						 				if(store.data.items.length == 0) {
	 						 					grid.setVisible(false);
	 						 				}
	 						 			}
	 						 		}
	 					 });
	 				 } else {
	 					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
 	 		},
	 		'applicantpermitdocumentlistgrid':{
	 			render: function(grid) {
					var this$ = this;
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_PERMIT_DOCUMENT_PERMISSION());
	            	grid.down('#downloadDocumentItemId').setVisible(true);
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							var documentId=record.get('documentId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
			},
			'applicantpermitdocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getApplicantpermitdocumentlist();
					var permitDetailActionGrid=form.down('#applicantpermitdocumentlistgridItemId');
					if (permitDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = permitDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Applicant Permit Detail Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('APPLICANT_PERMIT_DOCUMENT'),
									getCommonTranslation('APPLICANT_PERMIT_DETAIL_DOCUMENT_DOWNLOAD_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
								}
							});
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'applicantpermiturldocumentlistgrid':{
	 			render: function(grid) {
					var this$ = this;
	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_PERMIT_URL_PERMISSION());
				}
			},
			'applicantpermiturldocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this = this;
 					var form = $this.getApplicantpermiturldocumentlist();  
 					var permitDetailGrid = $this.getApplicantpermitgrid();
 					var permitUrlDocumentListGrid = form.down('#applicantpermiturldocumentlistgridItemId');
 					if (permitUrlDocumentListGrid.getSelectionModel().getCount() > 0) {
 						var records = permitUrlDocumentListGrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 						showConfirmMessage(getCommonTranslation('APPLICANT_PERMIT_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_APPLICANT_PERMIT_DETAIL_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {
 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('APPLICANT_PERMIT_URL'),getCommonTranslation('URL_SUCCESS_MSG'));
 										permitUrlDocumentListGrid.getSelectionModel().deselectAll(true);
 										permitUrlDocumentListGrid.store.reload();
 										permitDetailGrid.store.reload();
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
				}
			},
			'applicantpermitdocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this = this;
 					var form = $this.getApplicantpermitdocumentlist();  
 					var permitDetailGrid = $this.getApplicantpermitgrid();
 					var permitDocumentListGrid = form.down('#applicantpermitdocumentlistgridItemId');
 					if (permitDocumentListGrid.getSelectionModel().getCount() > 0) {
 						var records = permitDocumentListGrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 						showConfirmMessage(getCommonTranslation('APPLICANT_PERMIT_DOCUMENT'),getCommonTranslation('PERMIT_DETAIL_DELETE_CONFIRM_MSG'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_APPLICANT_PERMIT_DETAIL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {
 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('APPLICANT_PERMIT_DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 										permitDocumentListGrid.getSelectionModel().deselectAll(true);
 										permitDocumentListGrid.store.reload();
 										permitDetailGrid.store.reload();
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
				}
			},
			'bursaryapplicationstatus[itemId=applicantbursaryapplicationstatusItemId] button[itemId=checkStatus]':{
	 			  click: function(obj) { 
	 				 var grid = obj.up('grid');
	 				 var url = SERVERURL.PATH_NSFAS_GET_PERSON_STATUS_CHECK_INFO;
	 				 this.loadBursaryapplicationstatusGrid(grid, url,false);
	 			  }
	 		   },
	 		  'bursaryapplicationdetails[itemId=applicantbursaryapplicationdetailsItemId] button[itemId=checkStatus]':{
	 			  click: function(obj) { 
	 				 var grid = obj.up('grid');
	 				 var url =SERVERURL.PATH_NSFAS_GET_APPLICATION_DATA;
	 				this.loadBursaryapplicationstatusGrid(grid, url,false);
	 			  }
	 		   },
	 		  'bursaryfunddingdetails[itemId=applicantbursaryfunddingdetailsItemId] button[itemId=checkStatus]':{
	 			  click: function(obj) { 
	 				 var grid = obj.up('bursaryfunddingdetails');
	 				 var url = SERVERURL.PATH_SAVE_PROVISIOANAL_FUND_NSFAS;
	 				 this.loadBursaryapplicationstatusGrid(grid, url,false);
	 			  }
	 		   },
	 		  'bursaryfunddingdetails[itemId=applicantbursaryfunddingdetailsItemId]':{
	 			 render: function(grid){
	 				 var url = SERVERURL.PATH_GET_PROVISIONAL_FUND_DATA;
	 				this.disableCheckStatusButtonByPrivilege(grid,this.getAPPLICANT_NSFAS_FUNDDING_DATA_GRID_PERMISSION());
	 				var personProfile = this.getContentPanelActiveTab();
	 		    	if(!isNullOrEmpty(personProfile)){
	 		    		var person = personProfile.applicationDataObject.person;
	 		    		var nationalId = person.nationalID;
	 		    		if(!isNullOrEmpty(nationalId)){
	 		    			this.loadBursaryapplicationstatusGrid(grid,url,true);
	 		    		}
	 		    	}
	 			  },
	 			 afterrender:function(grid){
						var me = this;
						setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getAPPLICANT_NSFAS_FUNDDING_DATA_GRID_PERMISSION());
												},1500);
	    			 }
	 		   },
	 		  'bursaryapplicationstatus[itemId=applicantbursaryapplicationstatusItemId]':{
	 			 afterrender:function(grid){
						var me = this;
						 var url = SERVERURL.PATH_NSFAS_GET_PERSON_STATUS_CHECK_INFO;
		 				 this.disableCheckStatusButtonByPrivilege(grid,me.getAPPLICANT_NSFAS_STATUS_DATA_GRID_PERMISSION());
		 				 
		 				var personProfile = me.getContentPanelActiveTab();
		 		    	if(!isNullOrEmpty(personProfile)){
		 		    		var person = personProfile.applicationDataObject.person;
		 		    		var nationalId = person.nationalID;
		 		    		if(!isNullOrEmpty(nationalId)){
		 		    			this.loadBursaryapplicationstatusGrid(grid,url,true);
		 		    		}else{
		 		    			setTimeout(function(){
		 		    				showWarningMessage(getPersonModuleTranslation('BURSARY_DETAILS'), getPersonModuleTranslation("PROVIDE_NATIONAL_ID"));
		 													},300);
		 		    		}
		 		    	}
						setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getAPPLICANT_NSFAS_STATUS_DATA_GRID_PERMISSION());
												},1500);
	    			 }
	 		   },
	 		  'bursaryapplicationdetails[itemId=applicantbursaryapplicationdetailsItemId]':{
	 			 render: function(grid){
	 				 var url =SERVERURL.PATH_NSFAS_GET_APPLICATION_DATA;
	 				 this.disableCheckStatusButtonByPrivilege(grid,this.getAPPLICANT_NSFAS_APPLICATION_DETAIL_DATA_GRID_PERMISSION());
	 				var personProfile = this.getContentPanelActiveTab();
	 		    	if(!isNullOrEmpty(personProfile)){
	 		    		var person = personProfile.applicationDataObject.person;
	 		    		var nationalId = person.nationalID;
	 		    		if(!isNullOrEmpty(nationalId)){
	 		    			this.loadBursaryapplicationstatusGrid(grid,url,true);
	 		    		}
	 		    	}
	 			  },
	 			 afterrender:function(grid){
						var me = this;
						setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getAPPLICANT_NSFAS_APPLICATION_DETAIL_DATA_GRID_PERMISSION());
												},1500);
	    			 }
	 		   },
	            'personalinformationform[itemId=applicantPersonalInformationForm] nestedJsonCombo#currentActivity': {
	            	change: function(obj, record){
	            		if(!isNullOrEmpty(record)){
	            			setTimeout(function(){
	            				var form = obj.up('personalinformationform'); 
			            		var stuIsStudyingInstitution = form.down("#stuIsStudyingInstitutionItemId");
			            		var objValue =obj.getStore().getAt(obj.getStore().findExact('id',record)).data.value;
				            	if(objValue=='College' || objValue=='Nursing College' || objValue=='Technical Institute' || objValue=='Univ of Technology' || objValue=='University'){
				            		stuIsStudyingInstitution.items.items[0].setValue(true);
				            		stuIsStudyingInstitution.items.items[1].setValue(false);
				            		stuIsStudyingInstitution.setDisabled(true);
				            	}else{
				            		stuIsStudyingInstitution.setDisabled(false);
				            	}
							 },300);
	            		}
	            	}
	            },
	            'addressformwindow[itemId=applicantAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]' :{
	            	afterrender:function(obj) {
	            		var _self = this
	            		var phoneCountryCode = obj.down('#phoneCountryCode');
	            		var cellCountryCode = obj.down('#cellCountryCode');
	            		setTimeout(function(){
	            			_self.loadDFRForAddressFieldForm(phoneCountryCode, cellCountryCode);
	            		}, 100)
	            	}
	            },
	            'feepayerdetailform[itemId=applicantfeepayerdetailformItemId] button[itemId=googleAddressBtnId]':{
         			click:function(){
         				this.openApplicantGoogleAddressWin();
         			}
         		},
         		'feepayergoogleaddresswin[itemId=applicantFeepayergoogleaddresswin]':{
         			afterrender:function(form){
                        this.applyDFROnApplicantFeePayerGoogleAddressForm(form);
         			}
         		},
         		'feepayergoogleaddresswin[itemId=applicantFeepayergoogleaddresswin] button[itemId=googleAddressBtnSave]':{
         			click:function(){
         				var win = this.getFeepayergoogleaddresswin(),
         				feePayerForm = this.getContentPanelActiveTab().down('feepayerdetailform'),
         				form = win.down('form'),
         				formValues = form.getValues();
         				feePayerForm.down('#googleAddressId').setValue(formValues.googleAddress);
         				feePayerForm.down('#googleAddressCountryId').setValue(formValues.googleAddressCountry);
         				feePayerForm.down('#googleAddressCountryRegionId').setValue(formValues.googleAddressCountryRegion);
         				feePayerForm.down('#googleAddressCityId').setValue(formValues.googleAddressCity);
         				feePayerForm.down('#googleAddressPincodeId').setValue(formValues.googlePincode);
         				showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('GOOGLE_ADDRESS_SAVED_TEMPORARILY'));
         				win.close();
         			}
         		},
         		'feepayergoogleaddresswin[itemId=applicantFeepayergoogleaddresswin] button[itemId=googleAddressBtnCancel]':{
         			click:function(){
         				var win = this.getFeepayergoogleaddresswin();
         				win.close();
         			}
         		},
         		'feepayergoogleaddresswin[itemId=applicantFeepayergoogleaddresswin] checkboxfield[itemId=isSameAsApplicantGoogleAddressId]':{
         			change:function(obj,newValue,oldValue){
         				var personId =this.getContentPanelActiveTab().personId,
         				jsonData = {},
         				win = this.getFeepayergoogleaddresswin();
         				if(newValue){
         					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         					Ext.Ajax.request({
         						url: SERVERURL.PATH_APPLICANT_OR_STUDENT_CURRENT_GOOGLE_ADDRESS,
         						method: 'GET',
         						params:{
         							applicantPersonId : personId
         						},
         						success: function (response, action) {
         							var data = response.responseText && Ext.decode(response.responseText);
         							win.down('#googleAddressId').setValue(data.addressText);
         							win.down('#googleAddressCountryId').setValue(data.countryText);
         							win.down('#googleAddressCountryRegionId').setValue(data.provinceText);
         							win.down('#googleAddressCityId').setValue(data.cityText);
         							win.down('#googlePincodeId').setValue(data.postalCodeText);
         							Ext.getBody().unmask();
         						},
         						failure: function () {
         							Ext.getBody().unmask();
         						}
         					});
         				}
         			}
         		},
         		'nationalservicegrid[itemId=nationalservicegridId]': {
    	            render: function(grid) {
    	            	var this$ = this; 
    	            	//this$.loadGridStore('#nationalservicegridId', SERVERURL.PATH_APPLICANT_PASSPORT_DETAIL_GRID_DATA);
    	            	this$.doAccessControlValidation(grid, this$.getAPPLICANT_NATIONAL_SERVICES_PERMISSIONS());
    	            	var applicantProfilePanel = grid.up('applicantprofile');
                 		var structure = applicantProfilePanel.down('[region=center]');
                 		this$.getGridHeaderFreeze(grid,structure,true);
                    	var applicantProfile = this$.getContentPanelActiveTab();
                    	try{
                			applicantProfile.getApplicationId();
                		} catch(e){
                			applicantProfile = this$.getContentPanel().items.items[0];
                		}
                		var personId =this$.getContentPanelActiveTab().personId;
                		var gridStore = grid.getStore();
                		gridStore.getProxy().extraParams = {					  
                			applicantPersonId :personId
                    		
            			  };
            			
                		gridStore.load();
    	            },
    	            selectionchange: function(column, selected,eOpts ){
                		var grid = column.view.up('grid');
                    	if(selected.length > '1'){
                				grid.down('#btnAdd').setDisabled(true);
                				grid.down('#btnEdit').setDisabled(true);
                				grid.down('#btnView').setDisabled(true);
                				grid.down('#btnDelete').setDisabled(false);
                			}else{
                				grid.down('#btnAdd').setDisabled(false);
                				grid.down('#btnEdit').setDisabled(false);
                				grid.down('#btnView').setDisabled(false);
                				grid.down('#btnDelete').setDisabled(false);
                			}
                    	},
    	            cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
    					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
    					if(columnName == "documentName"){
    						if(e.target.tagName=='A'){
    							if(!isNullOrEmpty(record.data.documentName)){
    								var whetherFile = false;
    								var documentId= record.data.docId;
    								if(!isNullOrEmpty(documentId)){
    									Ext.Ajax.request({
    							            type: 'rest',
    							            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
    							            method: 'GET',
    							            callback : function(opt, success, response){
    							            	if(response.responseText == 'true') {
    							            		var csvForm = Ext.create('Ext.form.Panel'); 
    							        	    	csvForm.getForm().submit({
    							        		    	target: '_blank',
    							        		    	method:'GET',
    							        		    	params :{
    							        		    		access_token : Ext.Ajax.defaultHeaders.access_token
    							        		    	},
    							        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    							        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
    							        		    	standardSubmit :true
    							        	    	});
    							            	} else {
    							            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
    							            	}
    							            }
    							         });
    								}} 
    						}
    					}
    					
    				},
                	afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    				},1000);
                	},
                },
                'nationalservicegrid[itemId=nationalservicegridId] button[itemId=btnAdd]': {
                	click: function() {
                		var $this = this;
                		var formWindow = $this.getPersonCommonWindow();
                		$this.showPersonCommonWindow(formWindow, 'NATIONAL_SERVICE', 'nationalServiceDetailFormId', true);
                	}
                },
                'nationalservicegrid[itemId=nationalservicegridId] button[itemId=btnEdit]': {
                	click: function() {
                		var $this = this;
                		$this.editNationalserviceDetail('NATIONAL_SERVICE', 'nationalServiceDetailFormId', '#nationalservicegridId', false);
                	}
                },
                'nationalservicegrid[itemId=nationalservicegridId] button[itemId=btnView]': {
                	click: function() {
                		var $this = this;
                		$this.viewNationalserviceDetail('NATIONAL_SERVICE', 'nationalServiceDetailFormId', '#nationalservicegridId');
                		var form = $this.getNationalServiceDetailForm();
                		form.isValid();
                	}
                },
                'nationalservicegrid[itemId=nationalservicegridId] button[itemId=btnDelete]': {
                	click: function() {
                		var $this = this;
                		$this.deleteNationalserviceDetail('#nationalservicegridId', SERVERURL.NATIONAL_SERVICE_DETAIL_DELETE, 'NATIONAL_SERVICE_DETAIL_DELETE_SUCCESSFULLY');
                	}
                },
                
                'personcommonwindow[itemId=personCommonWindow] nationalServiceDetailForm[itemId=nationalServiceDetailFormId] button[itemId=submitButtonId]': {
                	click: function(){
                		var $this = this;
                		$this.saveNationalServiceData('#nationalservicegridId', SERVERURL.SAVE_NATIONAL_SERVICE_DETAILS);
                	}
                },
                'personcommonwindow[itemId=personCommonWindow] nationalServiceDetailForm[itemId=nationalServiceDetailFormId] button[itemId=cancelButtonId]' : {
    	 			click: this.closePersonCommonWindow
     			},
                
        });
       this.callParent(arguments); 
    },
    
    applicantDocPassportContainerWindow: function(){
    	var applicantDocGrid = Ext.ComponentQuery.query('applicantpassportdocumentgrid');
        
        var $this = this;
        var store = applicantDocGrid[0].store;
         	
        var contentPanelTab = this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a  = personInfoPanel.down('applicantpassportgrid');
		var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
        	var applicantDocPassportGrid = this.getApplicantpassportdocumentgrid();
			store.load({
				callback:function(){
					if(store.getCount()) {
						if (applicantDocPassportGrid.isHidden()) {
							applicantDocPassportGrid.setVisible(true);
						}	  					
						
					}
				}
			});
    },	
    
    applicantUrlPassportContainerWindow: function(){
    	var applicantUrlGrid = Ext.ComponentQuery.query('applicantpassporturlgrid');
        
        var $this = this;
        var store = applicantUrlGrid[0].store;
         	
        var contentPanelTab = this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a  = personInfoPanel.down('applicantpassportgrid'); 	
        var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
        	var applicantUrlPassportGrid = this.getApplicantpassporturlgrid();
			store.load({
				callback:function(){
					if(store.getCount()) {
						if (applicantUrlPassportGrid.isHidden()) {
							applicantUrlPassportGrid.setVisible(true);
						}	  					
					}
				}
			});
    },
    
    /* visa */
    
    applicantDocVisaContainerWindow: function(){
    	var StudentDocGrid = Ext.ComponentQuery.query('applicantvisadocumentgrid');
        
        var store = StudentDocGrid[0].store;
     	
        var contentPanelTab = this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a = personInfoPanel.down('applicantvisagrid');
		var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
	  					
			var studentDocVisaGrid = this.getApplicantvisadocumentgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentDocVisaGrid.isHidden()) {
    						studentDocVisaGrid.setVisible(true);
    					}	
    				}
    			}
    		});
    
    },	
    
    applicantUrlVisaContainerWindow: function(){
    	var StudentUrlGrid = Ext.ComponentQuery.query('applicantvisaurlgrid');
        
        var store = StudentUrlGrid[0].store;

        var contentPanelTab = this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a  = personInfoPanel.down('applicantvisagrid'); 	
        var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
        	var studentUrlVisaGrid = this.getApplicantvisaurlgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentUrlVisaGrid.isHidden()) {
    						studentUrlVisaGrid.setVisible(true);
    					}
    				}
    			}
    		});
				  					
    },
    
    /*Insurance doc and URl*/
    
    applicantDocInsuranceContainerWindow: function(){
    	var applicantDocGrid = Ext.ComponentQuery.query('applicantinsurancedocumentgrid');
        
        var store = applicantDocGrid[0].store;
     	
        var contentPanelTab = this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a = personInfoPanel.down('applicantinsurancedetailsgrid');
		var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
	  					
			var applicantDocVisaGrid = this.getApplicantinsurancedocumentgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (applicantDocVisaGrid.isHidden()) {
    						applicantDocVisaGrid.setVisible(true);
    					}	
    				}
    			}
    		});
    
    },	
    
    applicantUrlInsuranceContainerWindow: function(){
    	var applicantUrlGrid = Ext.ComponentQuery.query('applicantinsuranceurlgrid');
        
        var store = applicantUrlGrid[0].store;

        var contentPanelTab = this.getContentPanelActiveTab();
		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
		var a  = personInfoPanel.down('applicantinsurancedetailsgrid'); 	
        var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
        	var applicantUrlInsuranceGrid = this.getApplicantinsuranceurlgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (applicantUrlInsuranceGrid.isHidden()) {
    						applicantUrlInsuranceGrid.setVisible(true);
    					}
    				}
    			}
    		});
				  					
    },
  
    

    loadBursaryapplicationstatusGrid : function(grid, url,modeOfEvent) {
    	var this$ = this;
    	var nationalId = null;
    	var personId = null;
    	var isApplicant = true;
    	var personProfile = this$.getContentPanelActiveTab();
    	
    	if(!isNullOrEmpty(personProfile)){
    		var person = personProfile.applicationDataObject.person;
    		var personId = person.id;
    		var nationalId = person.nationalID;
    	}
    	if (grid.xtype == 'bursaryfunddingdetails') {
    		grid.bindStore(Ext.create('Academia.store.personinfo.common.NSFAS.BursaryFunddingDetailStore'));
		}
    	if (grid.xtype == 'bursaryapplicationdetails') {
    		//grid.bindStore(Ext.create('Academia.store.personinfo.common.NSFAS.BursaryApplicationDetailStore'));
		}
    	if (grid.xtype == 'bursaryapplicationstatus') {
    		//grid.bindStore(Ext.create('Academia.store.personinfo.common.NSFAS.BursaryApplicationStatusStore'));
		}
    	if(!isNullOrEmpty(nationalId)){
    		var store = grid.getStore();
    		if(grid.xtype == "bursaryapplicationdetails" || grid.xtype == "bursaryapplicationstatus"){
    			store.getProxy().extraParams = {					  
        			userPersonId :personId,
            		nationalId : nationalId,
            		isApplicant :isApplicant,
            		limit:5,
            		isRender:modeOfEvent
    			  };
    			this$.resetPageSetting(store);
    			store.load();
    		}else{
    			store.getProxy().extraParams = {					  
        			userPersonId :personId,
            		nationalId : nationalId,
            		isApplicant :isApplicant,
            		limit:5,
            		isRender:modeOfEvent
    			  };
    			if(!modeOfEvent) {
    				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            		store.load({
            			callback:function(rec,val,success){
            				if(success){
            					Ext.getBody().unmask();
            				}
            			}
            		});
    			}else{
    				
            		store.load();
    			}
    		
    		}  
    		if (modeOfEvent == false) {
    			store.getProxy().extraParams = {					  
        			userPersonId :personId,
            		nationalId : nationalId,
            		isApplicant :isApplicant,
            		limit:5,
            		isRender:true
    			  };
			}
    	}else{
    		showWarningMessage(getPersonModuleTranslation('BURSARY_DETAILS'), getPersonModuleTranslation("PROVIDE_NATIONAL_ID"));
    	}
	},
	disableCheckStatusButtonByPrivilege:function(grid,permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    
		var checkStatusBtn =grid.down('#checkStatus');
		checkStatusBtn.setVisible(false);
		 Ext.each(permissionList,function(privilege){
			 if(privilege == "CHECK_STATUS"){
				 if(checkStatusBtn){
					 checkStatusBtn.setVisible(true);
				 }
			 }
		 });
	},
	showHideApplicantHostelCustomFieldData: function(form, isVisible){
		if( !isNullOrEmpty(form.customFieldNameData) && isArray(form.customFieldNameData) ){
			if( form.customFieldNameData.length > 0 ){
				for( index in form.customFieldNameData ){
					var fieldName = form.customFieldNameData[index];
					if( !isNullOrEmpty(form.getForm().findField(fieldName)) )
						if(fieldName=="cf11") 
						{
							form.getForm().findField(fieldName).setVisible(true);
						}
						else
						{
							form.getForm().findField(fieldName).setVisible(isVisible);
						}

				}
			}
		}
	},
    
    loadApplicantCustomFieldData: function(form, jData){
    	if(!isNullOrEmpty(jData.customData)){
			if(!isNullOrEmpty(jData.customData[0])){
				var customDataItem = jData.customData[0];
				if(!isNullOrEmpty(customDataItem)){
					for (var property in customDataItem) {
			    		if(property.startsWith("C") || property.startsWith("c") ){
			    			if(!isNullOrEmpty(form.findField(property)) ){
			    				if( form.findField(property).xtype == 'datefield' ){
			    					form.findField(property).setValue(dateRender(customDataItem[property]));
			    				} else {
			    					form.findField(property).setValue(customDataItem[property]);
			    				}
			    			}
			    		}
			    		if(property.startsWith("id") || property.startsWith("version") ){
			    			if(property.startsWith("id")){
			    				form.findField('customHiddenId').setValue(customDataItem[property]);
			    			}
			    			if(property.startsWith("version")){
			    				form.findField('customHiddenVersion').setValue(customDataItem[property]);
			    			}
			    		}
					}
				}
			}
		}
    },
    
    getAddressController: function() {
        return Academia.app.getController('Academia.controller.organization.AddressController');
    },    
    
    /**
     * On render applicant personal information form
     * call to personal information
     */
    onRenderApplicantPersonalInformationForm : function(this$,photoUrl,showEditApplicantAlert){    	
    	var applicant_Personal_Information_Url = null;
    	var personProfile = this$.getContentPanelActiveTab();   
    	
    	if(!isNullOrEmpty(photoUrl)){
    		personProfile.personInfo.photoUrl=photoUrl;
    		}
        if(personProfile){
        	personProfile.isApplicantPortalSetup = false;
        	var personalInformationForm = personProfile.down('personalinformationform');
        	var advisorId = personalInformationForm.down('#advisorItemId');
        	//var schoolAttended = personalInformationForm.down('#schoolAttended');
        	//schoolAttended.setVisible(true);
    		var advisorIdStore=advisorId.getStore();
    		advisorId.setVisible(false);
            var applicationId=personProfile.getApplicationId();       
            var idTypeField = personalInformationForm.down("#idTypeCombo");
            personalInformationForm.down('#academicBankCredits').setVisible(false);
            personalInformationForm.down('#coaStudent').setVisible(false);
        	personalInformationForm.down('#naadStudent').setVisible(false);
            personalInformationForm.down('#studentDocUploadForm').setVisible(false);
            personalInformationForm.down('#examCenterVenue').setVisible(false);
        	personalInformationForm.down('#studentDownloadURL').setVisible(false);
        	var uploadDocField =  personalInformationForm.down('#applicantDocUploadForm');
        	var uploadDocURL = personalInformationForm.down('#applicantDownloadURL');
            this.loadDFRForIDTypeVisibility(idTypeField, uploadDocField, uploadDocURL);
            if(!isNullOrEmpty(applicationId)){ //Edit Application Case 
            	applicant_Personal_Information_Url = SERVERURL.APPLICANT_PERSONAL_INFORMATION_BY_ID;  //URL-:rest/applicantPerson/findApplicationWithPersonDetail        	           	
               	applicant_Personal_Information_Url=applicant_Personal_Information_Url.concat("?id="+applicationId);           	
            	this$.sendGetAjaxRequest(applicant_Personal_Information_Url, 'GET', null, function(option, success, response) {
            		if(success){	
            			var data = Ext.decode(response.responseText);
            			/*if(!isNullOrEmpty(data.applicationPrograms) && !isNullOrEmpty(data.applicationPrograms[0])){
            				var PbstId = data.applicationPrograms[0].progBatchSeatConfigId;
            				this$.mixins.ApplicantPortalSetupController.getAppSetupDynamicForFormFieldsInfo(PbstId,personalInformationForm,'personalinformationform'); 
            			}*/
            			// check if current active tab is person details tab
            			var studentProfile = this$.getContentPanelActiveTab();
	                    var portalId = this$.getCurrentLoggedPortalId();
	                    if( portalId == 6 ){
	                    	
	                    	if( !isNullOrEmpty(showEditApplicantAlert) && showEditApplicantAlert == true ){
	            				if( data.editApplicationAlertMessage != "NA" ){
	                				showWarningMessage(getCommonTranslation('ALERT'),data.editApplicationAlertMessage);
	                			}
	            			}
	                    }
	                    if( portalId == 1 ){
	                    	if( !isNullOrEmpty(personProfile.down('personinfopanel')) ){
	                    		var personInfoPanel = personProfile.down('personinfopanel');
	                    		if( personInfoPanel.getActiveTab().itemId == 'applicantPersonalDetails' ){
	                    			if( personInfoPanel.getActiveTab().items.items[0].approveAdmissionButton != 'Approve_Admission_Button' ){
	                    				if( !isNullOrEmpty(showEditApplicantAlert) && showEditApplicantAlert == true ){
		                    				if( data.editApplicationAlertMessage != "NA" ){
		                        				showWarningMessage(getCommonTranslation('ALERT'),data.editApplicationAlertMessage);
		                        			}
		                    			}
	                    			}
	                    		}
	                    	}
	                    }
            			
                        if(!isEmpty(data)){
                        	this$.checkFieldValidity(personalInformationForm,true,data);
                          	if(!isNullOrEmpty(data.person.birthDate))
                            data.person.birthDate = new Date(data.person.birthDate);
                            personProfile.setApplicationDataObject(data);                        	
                        	personProfile.setPersonInfo(data.person);
                        	personProfile.setPersonId(data.person.id);
                        	if(!isNullOrEmpty(data.code)){
                        		personProfile.setTitle(data.code);
                        	}
                        	personProfile.getApplicationInfo()['applicationStatus']=data.currentStatus;
                        	personData = this$.getApplicantPersonalInfoFormValue(data.person);
                            personalInformationForm.getForm().setValues(personData);
                            if(personData.supportDocument){
                            	personalInformationForm.down('#applicantDownloadURL').setValue(personData.supportDocument);
    			    		}else{
    			    			personalInformationForm.down('#applicantDownloadURL').setVisible(false);
    			    		}

                            var areaOfReasearch = personalInformationForm.getForm().findField("areaOfResearch");
                        	areaOfReasearch.getStore().load({
            					callback: function(records, operation, success) {
            						for(var i in records){
            							if(personData.areaOfResearch!==null){
            								if(records[i].data.id==personData.areaOfResearch.id){
            									areaOfReasearch.setValue(records[i].data.id);
            								}
            							}
            						}
            					}
            				});
                            
                            personalInformationForm.down('#whetherRPLApplicant').setValue(personData.whetherRPLApplicant);
                                                        
                        // Check SA Validations
                            var applicantPersonRadioBtnRegisteredBeforeSA = personalInformationForm.down('#applicantPersonRadioBtnRegisteredBeforeSA');
                            var allIntakeYear = personalInformationForm.down('#allIntakeYearItemId');
                        	var registeredBeforeSA = personalInformationForm.down('#registeredBeforeSA');
                            if(personData && personData.areYouRegisteredAtOtherSAU) {
                            	applicantPersonRadioBtnRegisteredBeforeSA.setValue({ areYouRegisteredAtOtherSAU: true });
                            	registeredBeforeSA.setVisible(true);
                            	registeredBeforeSA.allowBlank = false;
                            	this$.handleRegisteredBeforeSAChange(personalInformationForm, allIntakeYear, true);
                            	allIntakeYear.getStore().load({
                					callback: function(records, operation, success) {
                						for(var i in records){
                							if(personData.allIntakeYear !== null){
                								if(records[i].data.id==personData.allIntakeYear.id){
                									allIntakeYear.setValue(records[i].data.id);
                								}
                							}
                						}
                					}
                				});
                            	
                            	registeredBeforeSA.setValue(personData.studentNoAtOtherSAU);                            	
                            } else {
                            	allIntakeYear.setVisible(false);
                            	registeredBeforeSA.setVisible(false);
                            	allIntakeYear.allowBlank = true;
                            	registeredBeforeSA.allowBlank = true;
                            	allIntakeYear.setValue(null);
                            	registeredBeforeSA.setValue("");
                            }
                            
                        	personalInformationForm.down('#stuPermanentResItemId').items.items[0].setValue(false);
                        	personalInformationForm.down('#stuPermanentResItemId').items.items[1].setValue(false);
                    		
                        	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[0].setValue(false);
                        	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[1].setValue(false);
                    		
                        	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[0].setValue(false);
                        	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[1].setValue(false);
                        	
                        	if(!isNullOrEmpty(data.linkStudentId) && !isNullOrEmpty(data.linkStudentId.code)){
                        		personalInformationForm.down('#refStudentIdField').setValue(data.linkStudentId.code);
                        		personalInformationForm.down('#refStudentIdField').setVisible(true);
                        	}
                        	
                        	 var idNumberSecond = personalInformationForm.down('#idNumberSecond');
                        	 if(!isNullOrEmpty(personData.idtype) && personData.idtype.idTypeCode!='NATIONAL_ID'){
                        		 idNumberSecond.setVisible(true);
                        		 this$.checkDFRForIdNumberSecond(personalInformationForm);
                        	 }else{
                        		 idNumberSecond.setVisible(false);
                        		 idNumberSecond.allowBlank = true;
                        	 }
                        	 
                        	 if(!isNullOrEmpty(personData.nationality)){
                         		if(personData.nationality.code == 'South African'){
                         			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
                         			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
                         			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);
                         		}
                         	}
                         	
                         	if(!isNullOrEmpty(personData.secondaryCitizenship)){
                         		if(personData.secondaryCitizenship.code == 'South African'){
                         			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
                         			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
                         			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);	
                         		}
                         	}
                            
                           if(personData.isWheelChairRequired == true){
                            	 personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
                            	 personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
 	                	   }else
 	                	   {
 	                		  personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
                         	  personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
 	                	   }
                           
                           if(personData.areYouRefugee == true){
                          	 personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
                          	 personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
                          	 personalInformationForm.down("#stuAsylumSeekerItemId").setDisabled(true);
	                	   }else if (personData.areYouRefugee == false){
	                		  personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
                       	     personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
		        			}else{
		        				personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
		        				personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
	                	    }
                           
                           if(personData.isAsylumSeeker == true){
                          	 personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
                          	 personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
                          	personalInformationForm.down("#stuAreYouRefugeeItemId").setDisabled(true);
	                	   }else if(personData.isAsylumSeeker == false){
	                		  personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
                       	      personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
	        			}else{
	        				personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
	        				personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
	                	   }
                           
                           if(personData.isPermanentResident == true){
                          	 personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
                          	 personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
	                	   }else if(personData.isPermanentResident == false){
	                		  personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
                       	      personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
		        			}else{
		        				personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
		        				personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
	                	   }
                           
                           if(personData.isTertiaryInstitution == true){
                            	 personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
                            	 personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
  	                	   }else
  	                	   {
  	                		  personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
                         	  personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
  	                	   }
                           
                           if(personData.isEnrolledTertiaryInstitute == true){
                          	 personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(true);
                          	 personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(false);
	                	   }else
	                	   {
	                		  personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(false);
	                		  personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(true);
	                	   }
                           
                            if(personData.isMilitarySponsored == true){
	   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
	   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
	   						}
                            if(personData.isMilitarySponsored == false){
	   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
	   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
	   						}
	   						
	   						if(personData.isBursaryRequirements == true){
	   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
	   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
	   						}
	   						if(personData.isBursaryRequirements == false){
	   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
	   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
	   						}
	   						
	   						if(personData.diplomaticStatus == true){
								personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(true);
								personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(false);
							}else
							{
								personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(false);
								personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(true);
							}

							if(personData.temporaryStudy == true){
								personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(true);
								personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(false);
							}else
							{
								personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(false);
								personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(true);
							}
							
							if(personData.workCriticalSkills == true){
								personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
								personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
							}else
							{
								personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
								personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
							}
							
							if(personData.postgraduateNonResidentialStudent == true){
								personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
								personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
							}else
							{
								personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
								personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
							}
							
	   						if(personData.pHDSponsor == 'DOD'){
	   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
	   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
	   			           }
	   			           if(personData.pHDSponsor == 'MYSELF'){
	   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
	   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
	   			           }
                           
                            personalInformationForm.down("#birthDateId").setValue(personData.dobString);
                            personalInformationForm.down("#validTill").setValue(dateRender(personData.validTill));
                            if(!isNullOrEmpty(personData.genderCSM) && !isNullOrEmpty(personData.genderCSM.id)) 
                        	{
                            	 personalInformationForm.down("#genderCSM").setValue(personData.genderCSM.id);
                        	}
                            
                            if(personData.isAdult == true){
                           	 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(true);
                           	 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(false);
	                	   }else if(personData.isAdult == false)
	                	   {
	                		  personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(false);
                        	  personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(true);
	                	   }
                          
                            if(personData.whetherRPLApplicant == true){
                              	 personalInformationForm.down("#whetherRPLApplicant").items.items[0].setValue(true);
                              	 personalInformationForm.down("#whetherRPLApplicant").items.items[1].setValue(false);
   	                	   }else if(personData.whetherRPLApplicant == false)
   	                	   {
   	                		  personalInformationForm.down("#whetherRPLApplicant").items.items[0].setValue(false);
                           	  personalInformationForm.down("#whetherRPLApplicant").items.items[1].setValue(true);
   	                	   }
                            setTimeout(function(){
                            	 if(personData.isAutomateExchange == true){
                                   	 personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(true);
                                   	 personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(false);
         	                	 }else{
         	                		  personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(false);
                                	  personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(true);
         	                	 }
                        	},10); 
                         /*   if(!isNullOrEmpty(personData.schoolAttended)) 
                        	{
                            	 personalInformationForm.down("#schoolAttended").setValue(personData.schoolAttended);
                        	}
                            */
                            
	                     	personalInformationForm.down("#maritalStatusId").reset();
                           
                            if(!isNullOrEmpty(personData.maritalStatusId) && !isNullOrEmpty(personData.maritalStatusId.id)){
                            	personalInformationForm.down("#maritalStatusId").setValue(personData.maritalStatusId.id);
    						}
                            if(!isNullOrEmpty(personData.idtype) && !isNullOrEmpty(personData.idtype.id)) 
                        	{
                            	 personalInformationForm.down("#idTypeCombo").setValue(personData.idtype.id);
                            	 if (personData.idtype.idTypeCode == 'NATIONAL_ID') {
										personalInformationForm.down("#identityExpiryDateItemId").setVisible(false);
										personalInformationForm.down("#identityExpiryDateItemId").allowBlank = true;
									} else {
										var isIdentityExpiryDateVisible = localStorage.getItem('identityExpiryDateIsVisible');
										var identityExpiryDateIsMendatory = localStorage.getItem('identityExpiryDateIsMendatory');
										 if(!isNullOrEmpty(isIdentityExpiryDateVisible) && isIdentityExpiryDateVisible){
											personalInformationForm.down("#identityExpiryDateItemId").setVisible(isIdentityExpiryDateVisible);
											if (!isNullOrEmpty(identityExpiryDateIsMendatory) && identityExpiryDateIsMendatory) {
												personalInformationForm.down("#identityExpiryDateItemId").allowBlank = false;
											}else{
												personalInformationForm.down("#identityExpiryDateItemId").allowBlank = true;
											}
										 }
									}
                        	}

							if(!isNullOrEmpty(personData.identityExpiryDate)){
								personalInformationForm.down("#identityExpiryDateItemId").setValue(dateRender(personData.identityExpiryDate));
							} 

                            if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.currentEducationalInterventions) &&
                            		!isNullOrEmpty(data.person.currentEducationalInterventions.code) &&
                            		data.person.currentEducationalInterventions.code == 'OTHER') {
                            	var specifyOtherItemId = personalInformationForm.down("#specifyOtherItemId");
                            	specifyOtherItemId.setVisible(true);
                            	specifyOtherItemId.allowBlank = false;
                            	personalInformationForm.isValid();
                            }
                            if(!isNullOrEmpty(data.person.nationalID))
                        	{
                        		personalInformationForm.down("#verifyDetail").setDisabled(false);
                        	}else
                        	{
                        		personalInformationForm.down("#verifyDetail").setDisabled(true);

                        	}	
                            // V2D-146115 : Removed 
                            /*var isRegistrationContractItemId = personalInformationForm.down("#isRegistrationContractItemId");
                            var isRegistrationContractContainerItemId = personalInformationForm.down("#isRegistrationContractContainerItemId");
                            if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.isRegistrationContract) && data.person.isRegistrationContract) {
                            	isRegistrationContractItemId.setVisible(true);
                            	isRegistrationContractContainerItemId.setVisible(true);
                            } else {
                            	isRegistrationContractItemId.setVisible(false);
                            	isRegistrationContractContainerItemId.setVisible(false);
                            }
                            var isRegistrationContractConditionItemId = personalInformationForm.down("#isRegistrationContractConditionItemId");
                            var isRegistrationContractConditionContainerItemId = personalInformationForm.down("#isRegistrationContractConditionContainerItemId");
                            if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.isRegistrationContractCondition) && data.person.isRegistrationContractCondition) {
                            	isRegistrationContractConditionItemId.setVisible(true);
                            	isRegistrationContractConditionContainerItemId.setVisible(true);
                            } else {
                            	isRegistrationContractConditionItemId.setVisible(false);
                            	isRegistrationContractConditionContainerItemId.setVisible(false);
                            }*/
                            var haveDisabilities = personalInformationForm.getForm().findField('haveDisabilities');
                        	var haveDisabilitiesStore = haveDisabilities.getStore();
                			haveDisabilitiesStore.getProxy().extraParams={
                				type:'HaveDisabilities'
                			};
                			if(personData.applicantPersonDisability != null) {
	                			haveDisabilitiesStore.load({
	                				callback: function(records, operation, success) {
	                					if (success) {
	                						var haveDisabilitiesArray= [];
	                						if(records.length > 0){
	                							if(!isNullOrEmpty(personData.applicantPersonDisability) && personData.applicantPersonDisability.length > 0){
	                								personData.applicantPersonDisability.forEach(function(disabilityObj){
		                								var result = records.filter(function (obj) {
		                									  return obj.data.id === disabilityObj.haveDisabilities.id;
		                									})[0];
		                								haveDisabilitiesArray.push(result);
		                							});
	                								haveDisabilities.setValue(haveDisabilitiesArray);
	                							}else{
	                								this$.loadDefaultHaveDisabilitiesDFRValue(personalInformationForm,'personalinformationform');
	                								
	                							}
	                						}
	                					}
	                				}
	                	        });
                			}
                			
                			var consentedCommunicationChannel = personalInformationForm.getForm().findField('consentedCommunicationChannel');
                         	var consentedCommunicationChannelStore = consentedCommunicationChannel.getStore();
                         	consentedCommunicationChannelStore.getProxy().extraParams={
                 				type:'Communication Channel'
                 			};
                 			if(personData.consentedCommunicationChannel != null) {
                 				consentedCommunicationChannelStore.load({
 	                				callback: function(records, operation, success) {
 	                					if (success) {
 	                						var consentedCommunicationChannelArray= [];
 	                						if(records.length > 0){
 	                							if(!isNullOrEmpty(personData.consentedCommunicationChannel) && personData.consentedCommunicationChannel.length > 0){
 	                								personData.consentedCommunicationChannel.forEach(function(consentedCommunicationChannelObj){
 		                								var result = records.filter(function (obj) {
 		                									  return obj.data.id === consentedCommunicationChannelObj.communicationChannel.id;
 		                									})[0];
 		                								consentedCommunicationChannelArray.push(result);
 		                							});
 	                								consentedCommunicationChannel.setValue(consentedCommunicationChannelArray);
 	                							}
 	                						}
 	                					}
 	                				}
 	                	        });
                 			}
                 			
                 			if(!isNullOrEmpty(personData.consentStatementAccepted)){
                        		personalInformationForm.down("#consentStatementAccepted").setValue(personData.consentStatementAccepted);
                        	}
                        	
                 			personalInformationForm.down('#imageMarketingCheckbox').setValue(personData.imageMarketingCheckbox);
                 			if(!isNullOrEmpty(personData.imageMarketingCheckbox)){
                 			if(personData.imageMarketingCheckbox == true){
                              	 personalInformationForm.down("#imageMarketingCheckbox").items.items[0].setValue(true);
                              	 personalInformationForm.down("#imageMarketingCheckbox").items.items[1].setValue(false);
   	                	   	}else if(personData.imageMarketingCheckbox == false){
   	                		  personalInformationForm.down("#imageMarketingCheckbox").items.items[0].setValue(false);
                           	  personalInformationForm.down("#imageMarketingCheckbox").items.items[1].setValue(true);
   	                	   	}
                 			}
                			
                			var currentEducationalInterventions = personalInformationForm.getForm().findField('currentEducationalInterventions');                			
                			var educationalInterventionsStore = currentEducationalInterventions.getStore();
                			
                			if(personData.applicantPersonEducationInterventions != null){
                				
                				educationalInterventionsStore.load({
                					callback: function(records, operation, success) {
                						if (success) {
	                						var educationalInterventionsArray= [];
	                						if(records.length > 0){
	                							personData.applicantPersonEducationInterventions.forEach(function(eduInterventionObj){
	                								var result = records.filter(function (obj) {
	                									  return obj.data.id === eduInterventionObj.educationInterventions.id;
	                									})[0];
	                								educationalInterventionsArray.push(result);
	                							});
	                							currentEducationalInterventions.setValue(educationalInterventionsArray);
	                						}
	                					}
                					}
                				});
                			}
                			
                			if(personData.applicantPersonEducationInterventions.length == 0 && personData.currentEducationalInterventions!=null){
                				
                				educationalInterventionsStore.load({
                					callback: function(records, operation, success) {
                						if (success) {
	                						var educationalInterventionsArray= [];
	                						if(records.length > 0){
	                								var result = records.filter(function (obj) {
	                							    return obj.data.id === personData.currentEducationalInterventions.id;
	                								})[0];
	                								educationalInterventionsArray.push(result);
	                							currentEducationalInterventions.setValue(educationalInterventionsArray);
	                						}
	                					}
                					}
                				});
                			}
                			
                			var applicantModeOfEnquiryField = personalInformationForm.getForm().findField("applicantModeOfEnquiry");
            				if(data.applicationEnquiryMultipleMode.length>0){
            					applicantModeOfEnquiryField.getStore().load({
                    				callback: function(records, operation, success) {
                    					if (success) {
                    						var applicantModeOfEnquiryArray= [];
                    						if(records.length > 0){
                    							data.applicationEnquiryMultipleMode.forEach(function(modeOfObj){
                    								var result = records.filter(function (obj) {
                    									  return obj.data.id === modeOfObj.enquiryMode.id;
                    									})[0];
                    								applicantModeOfEnquiryArray.push(result);
                    							});
                    							applicantModeOfEnquiryField.setValue(applicantModeOfEnquiryArray);
                    						}
                    					}
                    				}
                    	        });
            				}	
            				
            				var applicationOwnerField = personalInformationForm.getForm().findField("applicationOwner");
            				applicationOwnerField.getStore().load({
            					callback: function(records, operation, success) {
            						for(var i in records){
            							if(data.applicationOwner!==null){
            								if(records[i].data.id==data.applicationOwner.id){
            									applicationOwnerField.setValue(records[i].data.id);
            								}
            							}
            						}
            					}
            				});
            				
            				 if(!isNullOrEmpty(personData.enquirySource) && !isNullOrEmpty(personData.enquirySource.id)) 
            				 {
            					 if(!isNullOrEmpty(personalInformationForm.down("#enquirySource"))){

            						 var enquirySourceField = personalInformationForm.down("#enquirySource");
            						 enquirySourceField.getStore().load({
            							 callback: function(records, operation, success) {
            								 for(var i in records){
            									 if(personData.enquirySource!==null){
            										 if(records[i].data.id==personData.enquirySource.id){
            											 enquirySourceField.setValue(records[i].data.id);
            										 }
            									 }
            								 }
            							 }
            						 });

            					 }
            				 }
            				
            				
            					 if(!isNullOrEmpty(personalInformationForm.down("#applicantCampaign"))){

            						 var applicantCampaignField = personalInformationForm.down("#applicantCampaign");
            						 
            						 var campaignNewStore=applicantCampaignField.getStore();
                                     	campaignNewStore.getProxy().extraParams = {
                                     	academyLocationIds: this$.getCurrentAcademyLocation(),
                                     	isActive: true
                                     };
                                     
                                     if( !isNullOrEmpty(personData.campaignNew) && !isNullOrEmpty(personData.campaignNew.id) ){
                                     	campaignNewStore.getProxy().extraParams.oldCampaignId = personData.campaignNew.id;
                                     }
                                     
                                     Ext.defer(function() {
                                     	campaignNewStore.load({
                                     		scope:this,
                                     		callback: function(records, operation, success) {

                                     			if(!isNullOrEmpty(personData.campaignNew)){
                                     				applicantCampaignField.setVisible(true);
                                     				applicantCampaignField.setValue(personData.campaignNew.id);
                                     				if( !isNullOrEmpty(personData.campaignSchool) ){
                                     					this$.selectApplicantNewCampaignField(applicantCampaignField, personData.campaignNew.id, personData.campaignSchool.id);
                                     				} else {
                                     					this$.selectApplicantNewCampaignField(applicantCampaignField, personData.campaignNew.id, null);
                                     				}
                                     			}else if(isNullOrEmpty(personData.campaignNew) && !isNullOrEmpty(personData.campaignSchool)){
                                     				//this$.selectApplicantNewCampaignField(applicantCampaignField, null, personData.campaignSchool.id);
                                    				
                                    				var schoolPriorityField = personalInformationForm.down("#applicantSchoolPriority");
                                    				var schoolPriorityNewField = personalInformationForm.down("#schoolPriorityNew");
                                    				schoolPriorityField.setVisible(false);
                                    				this$.loadDFRForSchoolPriority(schoolPriorityNewField);   
                                    				schoolPriorityNewField.setDisabled(false);
                                    				schoolPriorityNewField.getStore().load({
                   	        						  callback: function(record, operation, success) {
                   	        							  if (success) {
                   	        								  for(var i in record) {
                   	        									  if(personData.applicantSchoolPriority!=null) {
                   	        			    					  	if(record[i].data.id ==personData.applicantSchoolPriority) {
                   	        			    					  	schoolPriorityNewField.setValue(record[i].data.id);
                   	        			    					 	}
                   	        		    					 	 }
                   	        									  else {
                   	        										schoolPriorityNewField.setValue(null);
                   	        									  }
                   	        								  }
                   	        							  }
                   	        						  }
                   	        					  });
                                    				
                                    				  var campaignSchoolCombo = personalInformationForm.down("#applicantCampaignSchool");
                                    				  var academyLocUrl = '';
                                    				  academyLocUrl = this$.getCurrentAcademyLocation();
                                    				  
                                    				  var campaignSchoolStore = campaignSchoolCombo.getStore();
                                    				  campaignSchoolStore.getProxy().extraParams = {					  
                                    					campaigId:null,
                                    					academyLocationIds:academyLocUrl,
                                    					schoolId:personData.campaignSchool.id
                                    				  };
                                    				  campaignSchoolStore.removeAll();
                                                      campaignSchoolCombo.reset();
                                                      campaignSchoolStore.load({
                                    					  params: {
                                  							schoolId: personData.campaignSchool.id,
                                  							limit: 25
                                  				   		},
                                    					  callback: function(records, operation, success) {
                                    						  for(var i in records){	
                                    							  if(records[i].data.schoolId == personData.campaignSchool.id){
                                    							  campaignSchoolCombo.setValue(records[i].data.schoolId);
                                    							  }
                                    						   }                                						                               					
                                    					  }  
                                    				  });
                                    			
                                     				
                                     			}
                                     			else if(isNullOrEmpty(personData.campaignNew) && isNullOrEmpty(personData.campaignSchool)){
                                     				var schoolPriorityField = personalInformationForm.down("#applicantSchoolPriority");
                                    				var schoolPriorityNewField = personalInformationForm.down("#schoolPriorityNew");
                                    				schoolPriorityField.setVisible(false);
                                    				this$.loadDFRForSchoolPriority(schoolPriorityNewField);   
                                    			}
                                     		}	
                                     	});
                                     });

            					 }
            				 
            				 if(!isNullOrEmpty(personData.campaignSchool) && !isNullOrEmpty(personData.campaignSchool.id)) 
            				 {
            					 if(!isNullOrEmpty(personalInformationForm.down("#applicantCampaignSchool"))){

            						 var applicantCampaignSchoolField = personalInformationForm.down("#applicantCampaignSchool");
            						 applicantCampaignSchoolField.getStore().load({
            							 params: {
                   							schoolId: personData.campaignSchool.id,
                   							limit: 25
                   				   		},
            							 callback: function(records, operation, success) {
            								 for(var i in records){
            									 if(personData.campaignSchool!==null){
            										 if(records[i].data.schoolId==personData.campaignSchool.id){
            											 applicantCampaignSchoolField.setValue(records[i].data.schoolId);
            										 }
            									 }
            								 }
            							 }
            						 });

            					 }
            				 }
            				 if(isNullOrEmpty(personData.nationality)){
				        		 if(!isNullOrEmpty(personalInformationForm.down("#nationalityCombo"))){
				        			 var nationalityField = personalInformationForm.down("#nationalityCombo");
					        		 nationalityField.getStore().load({
					  					  callback: function(records, operation, success) {
					  						  if (success) {
					  							  for(i in records){
					  								  if(records[i].data.whetherDefault || records[i].data.whetherDefault=="true"){
					  									nationalityField.setValue(records[i].data.id);  									  
					  								  }
					  							  }
					  						  }
					  					  }
					  				  });
				        		 }
				        	 }
            				 if(!isNullOrEmpty(personData.unconditionalOfferSentDate)){
 								personalInformationForm.down("#unconditionalOfferSentDate").setValue(dateRender(personData.unconditionalOfferSentDate));
 							  }
            				
                            this$.setUploadedPhotoToPersonProfile(SERVERURL.APPLICANT_IMAGE_DOWNLOAD);
                        }
                        if(!isNullOrEmpty(personalInformationForm)){
                    		var countryCodeFieldItemIDArray = ["#phoneCountryCode","#cellCountryCode","#alternateCellCountryCode"];
                    		 this$.setDefaultCountryCode(personalInformationForm, countryCodeFieldItemIDArray,Ext.getBody());
                		}
                        if( !isNullOrEmpty(showEditApplicantAlert) && showEditApplicantAlert == true ){
                			var countryCodeField = personalInformationForm.down("#cellCountryCode");
                         	var mobileField = personalInformationForm.down("#mobileNumber");
                         	this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
                         	var countryCodeField = personalInformationForm.down("#alternateCellCountryCode");
                         	var mobileField = personalInformationForm.down("#alternateMobileNumber");
                         	this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
                         	var countryCodeField = personalInformationForm.down("#phoneCountryCode");
                            var phoneNoField = personalInformationForm.down("#phoneNoField");
                            this$.setMaximumMinimumDigitsForPhoneNoValidation(personalInformationForm,countryCodeField,phoneNoField,null);
               		 	}

                        var studentStatusCombo = personalInformationForm.getForm().findField('studentStatus');
                        if( !isNullOrEmpty(studentStatusCombo) ) {
                        	studentStatusCombo.allowBlank = true;
                        	studentStatusCombo.setVisible(false);
                	    }

                        var advisorNameCombo = personalInformationForm.getForm().findField('advisorId');
                        if( !isNullOrEmpty(advisorNameCombo) ) {
                        	advisorNameCombo.allowBlank = true;
                        	advisorNameCombo.setVisible(false);
                	    }
                        
                        this$.isRadioButtonTrue(data.person);
                        
                        var emplang = this$.getEmployeeLanguageValue(personData);
                        
                        if(!isNullOrEmpty(personalInformationForm.down("#armsOfService"))){
                        	var armsOfService = personalInformationForm.down("#armsOfService");
                        	armsOfService.getStore().load({
                        		callback: function(records, operation, success) {
                        			if (success) {
                        				for(i in records){
                        					if(personData.armsOfService!==null){
                        						if(records[i].data.id==personData.armsOfService.id){
                        							var armsOfServiceId =  armsOfService.setValue(records[i].data.id);
                        							var mustering = personalInformationForm.getForm().findField('mustering');
                        							mustering.setDisabled(false);
                        							var musteringStore = mustering.getStore();
                        							musteringStore.getProxy().extraParams={
                        								armsOfServiceId:records[i].data.id
                        							};
                        							musteringStore.load({
                        								callback: function(records, operation, success) {
                        									for(i in records){
                        										if(personData.mustering!==null){
                        											if(records[i].data.id==personData.mustering.id){
                        												mustering.setValue(records[i].data.id);
                        											}
                        										}
                        									}

                        								}

                        							})
                        						}
                        					}
                        				}

                        			}
                        		}

                        	})
                        }  
                        
                        var currentOrLastSchoolAttended = personalInformationForm.getForm().findField('currentOrLastSchoolAttended');                			
            				  if(!isNullOrEmpty(currentOrLastSchoolAttended)){
                              	currentOrLastSchoolAttended.getStore().load({
            					callback: function(records, operation, success) {
            						if (success) {
                              				for(i in records){
                              					if(personData.currentOrLastSchoolAttended!==null){
                              						if(records[i].data.schoolId==personData.currentOrLastSchoolAttended.id){
                                						  currentOrLastSchoolAttended.setValue(records[i].data.schoolId);
                								}
                							}
                						}
            						}
            					}

                              	})
            			}
            			/*if(!isNullOrEmpty(data.person.photoUrl)){
            				 setTimeout(function(){
            					 personalInformationForm.down("#photoFileImage").allowBlank=true;
							 },600);
            			} */
            			if(personProfile.getApplicationInfo()['isViewMode']){
            	        	
            	        	personalInformationForm.down('#stopBtn').setDisabled(true);
            	        	personalInformationForm.down('#employeeLanguage').setReadOnly(true);
            	        	personalInformationForm.down('#readItemId').setReadOnly(true);
            	        	personalInformationForm.down('#writeItemId').setReadOnly(true);
            	        	personalInformationForm.down('#speakItemId').setReadOnly(true);
            	    		}
            		}  
            		var mustering = personalInformationForm.getForm().findField('mustering');
            	//	this$.loadDFRForMusteringDFR(mustering);
            		this$.loadDefaultHomeLanguageDFRValue(personalInformationForm,'personalinformationform');
            		var studentDownloadURL = personalInformationForm.down('#studentDownloadURL');
            		var verifyDetailButton = personalInformationForm.down('#verifyDetail');
            		setTimeout(function(){
            			studentDownloadURL.setValue(null);
            			studentDownloadURL.setVisible(false);
            			verifyDetailButton.setVisible(false);
            		},600);
            	});
            }else{  //New Application Case      	
            	this$.checkFieldValidity(personalInformationForm,false);
            	if( personalInformationForm != null ){
            		personalInformationForm.down('#imageMarketingCheckbox').setVisible(false);
					personalInformationForm.down('#consentedCommunicationChannel').setVisible(false);
					personalInformationForm.down('#consentStatementAccepted').setVisible(false);
					personalInformationForm.down('#idNumberSecond').setVisible(false);
            		var countryCodeFieldItemIDArray = ["#phoneCountryCode","#cellCountryCode","#alternateCellCountryCode"];
            		this$.setDefaultCountryCode(personalInformationForm, countryCodeFieldItemIDArray);
            		var countryCodeField = personalInformationForm.down("#cellCountryCode");
                 	var mobileField = personalInformationForm.down("#mobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
                 	var countryCodeField = personalInformationForm.down("#alternateCellCountryCode");
                 	var mobileField = personalInformationForm.down("#alternateMobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
            		var getApplicantvalueObj = personProfile.getApplicationDataObject();
            		var applicantModeOfEnquiryField = personalInformationForm.getForm().findField("applicantModeOfEnquiry");
            		var applicanthaveDisabilitiesField = personalInformationForm.getForm().findField("haveDisabilities");
            		var applicantCurrentEducationalInterventionsField = personalInformationForm.getForm().findField("currentEducationalInterventions");
            		var applicationOwnerField = personalInformationForm.getForm().findField("applicationOwner");
            		var identityExpiryDate = personalInformationForm.getForm().findField("identityExpiryDate");
            		applicationOwnerField.getStore().load({
            			callback: function(records, operation, success) {
            				for(var i in records){
            					if(getApplicantvalueObj.enquiryOwnerId!==null){
            						if(records[i].data.id==getApplicantvalueObj.enquiryOwnerId){
            							applicationOwnerField.setValue(records[i].data.id);
            						}
            					}
            				}
            		    }
            		});
            		
            		if(!isNullOrEmpty(personalInformationForm.down("#nationalityCombo"))){
		        		 var nationalityField = personalInformationForm.down("#nationalityCombo");
			        	 nationalityField.getStore().load({
			  				  callback: function(records, operation, success) {
			  					  if (success) {
			  						  for(i in records){
			  							  if(records[i].data.whetherDefault || records[i].data.whetherDefault=="true"){
			  								nationalityField.setValue(records[i].data.id);  									  
			  							  }
			  						  }
			  					  }
			  				  }
			        	 });
		        	}
            		
            	   /* var schoolAttended = personalInformationForm.getForm().findField('schoolAttended');                			
          			var schoolAttendedStore = schoolAttended.getStore();
          			if(personData.schoolAttended != null){
          				schoolAttendedStore.load({
          					callback: function(records, operation, success) {
          						if (success) {
          							for(var i in records){
              							if(personData.schoolAttended!=null){
              								if(records[i].data.schoolId){
              									schoolAttended.setValue(records[i].data.schoolId);
              								}
              							}
              						}
          						}
          					}
          				});
          			}*/
            		
            		if(!isNullOrEmpty(personalInformationForm.down("#schoolAttended"))){
            		  var schoolAttendedCombo = personalInformationForm.down("#schoolAttended");
    				  var academyLocUrl = '';
    				  academyLocUrl = this$.getCurrentAcademyLocation();
    				  
    				  var schoolAttendedComboStore = schoolAttendedCombo.getStore();
    				  schoolAttendedComboStore.getProxy().extraParams = {					  
    					campaigId:null,
    					academyLocationIds:academyLocUrl,
    					schoolId:getApplicantvalueObj.campaignSchool
    				  };
    				  schoolAttendedComboStore.removeAll();
    				  schoolAttendedCombo.reset();
    				  
    				  schoolAttendedComboStore.load({
    					  callback: function(records, operation, success) {
    						  for(var i in records){	
    							  if(records[i].data.schoolId == getApplicantvalueObj.schoolAttended){
    								  schoolAttendedCombo.setValue(records[i].data.schoolId);
    							  }
    						   }                                						                               					
    					  }  
    				  });
            		}
            		
            		 if(!isNullOrEmpty(personalInformationForm.down("#applicantCampaign"))){

						 var applicantCampaignField = personalInformationForm.down("#applicantCampaign");
						 
						 var campaignNewStore=applicantCampaignField.getStore();
                         	campaignNewStore.getProxy().extraParams = {
                         	academyLocationIds: this$.getCurrentAcademyLocation(),
                         	isActive: true
                         };
                         
                         if( !isNullOrEmpty(getApplicantvalueObj.campaignNew) ){
                         	campaignNewStore.getProxy().extraParams.oldCampaignId = getApplicantvalueObj.campaignNew;
                         }
                         
                         Ext.defer(function() {
                         	campaignNewStore.load({
                         		scope:this,
                         		callback: function(records, operation, success) {

                         			if(!isNullOrEmpty(getApplicantvalueObj.campaignNew)){
                         				applicantCampaignField.setVisible(true);
                         				applicantCampaignField.setValue(getApplicantvalueObj.campaignNew);
                         				if( !isNullOrEmpty(personData.campaignSchool) ){
                         					this$.selectApplicantNewCampaignField(applicantCampaignField, getApplicantvalueObj.campaignNew, getApplicantvalueObj.campaignSchool);
                         				} else {
                         					this$.selectApplicantNewCampaignField(applicantCampaignField, getApplicantvalueObj.campaignNew, null);
                         				}
                         			}else if(isNullOrEmpty(getApplicantvalueObj.applicantCampaignField) && !isNullOrEmpty(getApplicantvalueObj.campaignSchool)){
                         				
                        				var schoolPriorityField = personalInformationForm.down("#applicantSchoolPriority");
                        				var schoolPriorityNewField = personalInformationForm.down("#schoolPriorityNew");
                        				schoolPriorityField.setVisible(false);
                        				this$.loadDFRForSchoolPriority(schoolPriorityNewField);   
                        				schoolPriorityNewField.setDisabled(false);
                        				schoolPriorityNewField.getStore().load({
       	        						  callback: function(record, operation, success) {
       	        							  if (success) {
       	        								  for(var i in record) {
       	        									  if(getApplicantvalueObj.applicantSchoolPriority!=null) {
       	        			    					  	if(record[i].data.id ==getApplicantvalueObj.applicantSchoolPriority) {
       	        			    					  	schoolPriorityNewField.setValue(record[i].data.id);
       	        			    					 	}
       	        		    					 	 }
       	        									  else {
       	        										schoolPriorityNewField.setValue(null);
       	        									  }
       	        								  }
       	        							  }
       	        						  }
       	        					  });
                        				
                        				  var campaignSchoolCombo = personalInformationForm.down("#applicantCampaignSchool");
                        				  var academyLocUrl = '';
                        				  academyLocUrl = this$.getCurrentAcademyLocation();
                        				  
                        				  var campaignSchoolStore = campaignSchoolCombo.getStore();
                        				  campaignSchoolStore.getProxy().extraParams = {					  
                        					campaigId:null,
                        					academyLocationIds:academyLocUrl,
                        					schoolId:getApplicantvalueObj.campaignSchool
                        				  };
                        				  campaignSchoolStore.removeAll();
                                          campaignSchoolCombo.reset();
                        				  
                        				  campaignSchoolStore.load({
                        					  callback: function(records, operation, success) {
                        						  for(var i in records){	
                        							  if(records[i].data.schoolId == getApplicantvalueObj.campaignSchool){
                        							  campaignSchoolCombo.setValue(records[i].data.schoolId);
                        							  }
                        						   }                                						                               					
                        					  }  
                        				  });
                         				
                         			}
                         			else if(isNullOrEmpty(getApplicantvalueObj.campaignNew) && isNullOrEmpty(getApplicantvalueObj.campaignSchool)){
                         				var schoolPriorityField = personalInformationForm.down("#applicantSchoolPriority");
                        				var schoolPriorityNewField = personalInformationForm.down("#schoolPriorityNew");
                        				schoolPriorityField.setVisible(false);
                        				this$.loadDFRForSchoolPriority(schoolPriorityNewField);  
                        			}
                         		}	
                         	});
                         });

					 }
            		 if(!isNullOrEmpty(getApplicantvalueObj.armsOfService)){
            			 personalInformationForm.down('#mustering').setDisabled(false);
            		 }
            		 
                     // Check SA Validations
                    	personalInformationForm.down('#stuPermanentResItemId').items.items[0].setValue(false);
                    	personalInformationForm.down('#stuPermanentResItemId').items.items[1].setValue(false);
                		
                    	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[0].setValue(false);
                    	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[1].setValue(false);
                		
                    	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[0].setValue(false);
                    	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[1].setValue(false);
                    	
                    	if(!isNullOrEmpty(getApplicantvalueObj.linkStudentId) && !isNullOrEmpty(getApplicantvalueObj.linkStudentId.code)){
                    		personalInformationForm.down('#refStudentIdField').setValue(getApplicantvalueObj.linkStudentId.code);
                    		personalInformationForm.down('#refStudentIdField').setVisible(true);
                    	}
                    	
                    	 if(!isNullOrEmpty(getApplicantvalueObj.nationality)){
                     		if(getApplicantvalueObj.nationality.code == 'South African'){
                     			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
                     			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
                     			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);
                     		}
                     	}
                     	
                     	if(!isNullOrEmpty(getApplicantvalueObj.secondaryCitizenship)){
                     		if(getApplicantvalueObj.secondaryCitizenship.code == 'South African'){
                     			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
                     			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
                     			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);	
                     		}
                     	}
                        
                       if(getApplicantvalueObj.isWheelChairRequired == true){
                        	 personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
                        	 personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
	                	   }else
	                	   {
	                		  personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
                     	  personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
	                	   }
                       
                       if(getApplicantvalueObj.areYouRefugee == true){
                      	 personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
                      	 personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
                      	 personalInformationForm.down("#stuAsylumSeekerItemId").setDisabled(true);
                	   }else if (getApplicantvalueObj.areYouRefugee == false){
                		  personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
                   	     personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
	        			}else{
	        				personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
	        				personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
                	    }
                       
                       if(getApplicantvalueObj.isAsylumSeeker == true){
                      	 personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
                      	 personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
                      	personalInformationForm.down("#stuAreYouRefugeeItemId").setDisabled(true);
                	   }else if(getApplicantvalueObj.isAsylumSeeker == false){
                		  personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
                   	      personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
        			}else{
        				personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
        				personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
                	   }
                       
                       if(getApplicantvalueObj.isPermanentResident == true){
                      	 personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
                      	 personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
                	   }else if(getApplicantvalueObj.isPermanentResident == false){
                		  personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
                   	      personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
	        			}else{
	        				personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
	        				personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
                	   }
                       
                       if(getApplicantvalueObj.isTertiaryInstitution == true){
                        	 personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
                        	 personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
	                	   }else
	                	   {
	                		  personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
                     	  personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
	                	   }
                       
                        if(getApplicantvalueObj.isMilitarySponsored == true){
   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
   						}
                        if(getApplicantvalueObj.isMilitarySponsored == false){
   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
   							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
   						}
   						
   						if(getApplicantvalueObj.isBursaryRequirements == true){
   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
   						}
   						if(getApplicantvalueObj.isBursaryRequirements == false){
   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
   							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
   						}
   						
   						if(getApplicantvalueObj.diplomaticStatus == true){
							personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(true);
							personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(false);
							personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(true);
						}

						if(getApplicantvalueObj.temporaryStudy == true){
							personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(true);
							personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(false);
							personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(true);
						}
						
						if(getApplicantvalueObj.workCriticalSkills == true){
							personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
							personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
							personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
						}
						
						if(getApplicantvalueObj.postgraduateNonResidentialStudent == true){
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
						}
						if(getApplicantvalueObj.isAutomateExchange == true){
                          	 personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(true);
                          	 personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(false);
	                	}else{
	                		 personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(false);
                       	     personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(true);
	                	}
						
   						if(getApplicantvalueObj.pHDSponsor == 'DOD'){
   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
   			           }
   			           if(getApplicantvalueObj.pHDSponsor == 'MYSELF'){
   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
   			        	   personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
   			           } 
            		 
            		if(!isNullOrEmpty(getApplicantvalueObj.wsenquiryMultipleMode)){
            			if(getApplicantvalueObj.wsenquiryMultipleMode.length>0){
        					applicantModeOfEnquiryField.getStore().load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var applicantModeOfEnquiryArray= [];
                						if(records.length > 0){
                							getApplicantvalueObj.wsenquiryMultipleMode.forEach(function(modeOfObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === modeOfObj.enquiryMode.id;
                									})[0];
                								applicantModeOfEnquiryArray.push(result);
                							});
                							applicantModeOfEnquiryField.setValue(applicantModeOfEnquiryArray);
                						}
                					}
                				}
                	        });
        				}
            		}
            		
            		if(!isNullOrEmpty(getApplicantvalueObj.applicantPersonDisability)){
            			if(getApplicantvalueObj.applicantPersonDisability.length>0){
            				applicanthaveDisabilitiesField.getStore().load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var applicanthaveDisabilitiesArray= [];
                						if(records.length > 0){
                							getApplicantvalueObj.applicantPersonDisability.forEach(function(modeOfObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === modeOfObj.haveDisabilities.id;
                									})[0];
                								applicanthaveDisabilitiesArray.push(result);
                							});
                							applicanthaveDisabilitiesField.setValue(applicanthaveDisabilitiesArray);
                						}
                					}
                				}
                	        });
        				}
            		}
            		
            		if(!isNullOrEmpty(getApplicantvalueObj.applicantPersonEducationInterventions)){
            			if(getApplicantvalueObj.applicantPersonEducationInterventions.length>0){
            				applicantCurrentEducationalInterventionsField.getStore().load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var applicantCurrentEducationalInterventionsArray= [];
                						if(records.length > 0){
                							getApplicantvalueObj.applicantPersonEducationInterventions.forEach(function(modeOfObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === modeOfObj.educationInterventions.id;
                									})[0];
                								applicantCurrentEducationalInterventionsArray.push(result);
                							});
                							applicantCurrentEducationalInterventionsField.setValue(applicantCurrentEducationalInterventionsArray);
                						}
                					}
                				}
                	        });
        				}
            		}
            		
   		        		var mustering = personalInformationForm.getForm().findField('mustering');
   	            		//this$.loadDFRForMusteringDFR(mustering);
   		        		
   		        		if(!isNullOrEmpty(getApplicantvalueObj.identityExpiryDate)) {
   		        			setTimeout(function(){
   		        				identityExpiryDate.setValue(new Date(getApplicantvalueObj.identityExpiryDate));
   		            		},300)
   	            		}
   		        	
   		        		this$.isRadioButtonTrue(data.person);
        		}
            }
       	/* advisorIdStore.load({
 	    	callback: function(records, operation, success) {
  			   for(var i=0; i< advisorIdStore.data.items.length;i++){
  				   var data;
  				   if(data!=undefined){
  					 if(advisorIdStore.data.items[i].data.id == data.advisorId.id){
    					   advisorId.setValue(advisorIdStore.data.items[i].data.id);
    					   break;
    				   }  
  				   }
  			   }
 			}
      });*/
            var studentStatusCombo = personalInformationForm.getForm().findField('studentStatus');
            if( !isNullOrEmpty(studentStatusCombo) ) {
            	studentStatusCombo.allowBlank = true;
            	studentStatusCombo.setVisible(false);
    	    }
            
            var advisorIdCombo = personalInformationForm.getForm().findField('advisorId');
            if( !isNullOrEmpty(advisorIdCombo) ) {
                 advisorIdCombo.allowBlank = true;
            	advisorIdCombo.setVisible(false);
    	    }
            
        }
        
        
    },
    /**
     * save applicant photo upload
     */
/*  V2D-479891  
 *  saveApplicantPersonPhotoUpload : function(photoFileImage){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var applicantPhotoUploadForm = personProfile.down('#applicantPhotoUploadForm');
    	this$.savePersonPhotoUpload(applicantPhotoUploadForm, personProfile.getPersonId(), SERVERURL.APPLICANT_IMAGE_UPLOAD, SERVERURL.APPLICANT_IMAGE_DOWNLOAD, function(success,photoUrl){
    		if(success){
    			//this$.onRenderApplicantPersonalInformationForm(this$,photoUrl);
    		}
    	});
    },*/
    
    /**
     * To hide show some fields in some cases
     * 
     */
    checkFieldValidity:function(personalInformationForm,isEditMode,data){
    	if(personalInformationForm){
    		var applicationIdField= personalInformationForm.down('#personCodeField');
            var midtermJoineeField= personalInformationForm.down('#isMidtermJoineeField');
            var academicDetailsFieldSet= personalInformationForm.down('#academicDetails');            
            if(isEditMode){
            	if(applicationIdField && !isNullOrEmpty(data['code'])){
            		applicationIdField.setVisible(true);
            		applicationIdField.setDisabled(false);
            		applicationIdField.setValue(data['code']);
            	}                    	
            	if(academicDetailsFieldSet){
            		academicDetailsFieldSet.setVisible(true);
            		academicDetailsFieldSet.setDisabled(false);
            	}
            }else{
            	/*if(applicationIdField){
            		applicationIdField.setVisible(false);
            		applicationIdField.setDisabled(true);
            	}
            	if(midtermJoineeField){
            		midtermJoineeField.setVisible(false);
            		midtermJoineeField.setDisabled(true);
            	}*/
            	if(academicDetailsFieldSet){
            		academicDetailsFieldSet.setVisible(false);
            		academicDetailsFieldSet.setDisabled(true);
            	}
            }
            if(!isNullOrEmpty(data))
            if(data.currentStatus == 'MID_TERM_ADMISSION'){
            	midtermJoineeField.setValue(true);
            }
    	}    	
    },
    
    isRadioButtonTrue: function(personData){
        var form = this.getPersonalInformationForm();
       var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
  	   var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
  	   var diplomaticStatusId = form.down("#diplomaticStatusId");
  	   var temporaryStudyId = form.down("#temporaryStudyId");
  	   var workCriticalSkillsId = form.down("#workCriticalSkillsId");
  	   var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
	   var stuPermanentResItemId = form.down("#stuPermanentResItemId");
 
	   if(!isEmpty(personData)){
    	if(personData.isPermanentResident == true)		
    		{
    		    stuAsylumSeekerItemId.setDisabled(true);
    		    stuAreYouRefugeeItemId.setDisabled(true);
				diplomaticStatusId.setDisabled(true);
				temporaryStudyId.setDisabled(true);
				workCriticalSkillsId.setDisabled(true);
				postgraduateNonResidentialStudentId.setDisabled(true);
    		}
    	if(personData.isAsylumSeeker == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.areYouRefugee == true)		
		{
		    stuAsylumSeekerItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.diplomaticStatus == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.temporaryStudy == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
		    diplomaticStatusId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.workCriticalSkills == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.postgraduateNonResidentialStudent == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
		}
	   }
    },
    
    /**
     * After rendering Personal Information Form to load data in form 
     * 
     */
    afterRenderApplicantPersonalInformationForm : function(form){
    	var this$ = this;    	    	
    	var personProfile = this$.getContentPanelActiveTab();    	    
    	if(personProfile.getApplicationInfo()['isViewMode']    		
    		|| ((personProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
            	(personProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
            	(personProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                (personProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                (personProfile.getApplicationInfo()['applicationStatus']!=='APPROVED') &&
                (personProfile.getApplicationInfo()['applicationStatus']!=='ADMISSION_GRANTED') &&
                (personProfile.getApplicationInfo()['applicationStatus']!=='REJECTED') &&
                (personProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')&&
                (personProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_SUBMISSION_TOKEN_GENERATED')&&
                (personProfile.getApplicationInfo()['applicationStatus']!=='FORM_SALE_TOKEN_GENERATED')&&
                   	!isNullOrEmpty(personProfile.getApplicationInfo()['applicationStatus'])) 
           ){    		
    		this$.mixins.ApplicationBaseController.setContainerInViewMode(personProfile.down('personalinformationform'),"personalinformationform[itemId=applicantPersonalInformationForm]>button",personProfile);
    	}
        var personalInformationForm = personProfile.down('personalinformationform');
        personalInformationForm.getForm().findField('admissionDate').setVisible(false);
        personalInformationForm.getForm().findField('validTill').setVisible(false);
        /*if((personProfile.getApplicationInfo()['applicationStatus'] =='APPROVED') || 
    			(personProfile.getApplicationInfo()['applicationStatus'] =='REJECTED') || 
    			(personProfile.getApplicationInfo()['applicationStatus'] =='ADMISSION_GRANTED')){
        	
        	var uploadButton = personalInformationForm.down('#photoFileImage');
        	uploadButton.setDisabled(true);
    	}*/
        if((personProfile.getApplicationInfo()['applicationStatus'] =='APPROVED') || 
    			(personProfile.getApplicationInfo()['applicationStatus'] =='REJECTED') || 
    			(personProfile.getApplicationInfo()['applicationStatus'] =='ADMISSION_GRANTED') ||
    			(personProfile.getApplicationInfo()['applicationStatus']=='SUBMITTED') ||
    			(personProfile.getApplicationInfo()['applicationStatus']=='APPLIED') ||
    			(personProfile.getApplicationInfo()['applicationStatus']=='SOLD') ||
    			(personProfile.getApplicationInfo()['applicationStatus']=='DIRECT_ADMISSION') ||
    			(personProfile.getApplicationInfo()['applicationStatus']=='NOT_SUBMITTED')){
        	
        	var midtermJoineeField= personalInformationForm.down('#isMidtermJoineeField');
        	midtermJoineeField.setDisabled(true);
        }
        if(Ext.app.checkVelocity || Ext.app.checkVelocity=="true"){
        //V2D-76270:As per the discussion with Product team	
        }else{
        	 Ext.Ajax.request({
     			type: 'rest',
     			url: SERVERURL.PATH_FIND_WHETHER_EDITABLE,
     			params: {
     				tableName: 'application',
     				columnName: 'code'
                 },
     			method: 'GET',
     			success: function(res, action) {
     				var response = Ext.decode(res.responseText);
     				if(!isNullOrEmpty(personalInformationForm)){
     					if(response == true || response == 'true'){
     						personalInformationForm.down('#personCodeField').setReadOnly(false);
     					} else {
     						personalInformationForm.down('#personCodeField').setReadOnly(true);
     					}
     				}
     			}
             });
        }
		var applicationDataObject=personProfile.getApplicationDataObject();
		personData = this$.getApplicantPersonalInfoFormValue(applicationDataObject);
    	if(!isEmpty(applicationDataObject)){    		
    		if(!isNullOrEmpty(personData.genderCSM) && !isNullOrEmpty(personData.genderCSM.id)){
    			personData.genderCSM = personData.genderCSM.id;
			}
    		
    		/*if(!isNullOrEmpty(personData.schoolAttended)){
    			personData.schoolAttended = personData.schoolAttended;
			}*/
    		if(!isNullOrEmpty(personData.maritalStatusId) && !isNullOrEmpty(personData.maritalStatusId.id)){
				personData.maritalStatus = personData.maritalStatusId.id;
			}
    		if(!isNullOrEmpty(personData.idtype) && !isNullOrEmpty(personData.idtype.id)){
    			personData.idtype = personData.idtype.id;
			}
    		
            personalInformationForm.getForm().setValues(personData);
            personalInformationForm.getForm().findField('advisorId').setVisible(false);
            
            /***********Code applied for auto select nationality and country if applicant is enquired earilier************************/
            Ext.defer(function() {
            	if(!isNullOrEmpty(personData.nationality)){
            		personalInformationForm.getForm().findField('nationality').setValue(personData.nationality);
            	}
            	if(!isNullOrEmpty(personData.country)){
            		personalInformationForm.getForm().findField('country').setValue(personData.country);
            	}
            	            	
	        }, 500, this);
            
            var checkboxDropdownId = personProfile.down('#checkboxDropdown').getValue();
        	if(!isNullOrEmpty(checkboxDropdownId) && checkboxDropdownId){
            Ext.defer(function() {
            	if(!isNullOrEmpty(personData) && !isNullOrEmpty(personData.bankDetail) && !isNullOrEmpty(personData.bankDetail.bankName)){
            		personProfile.down('#bankNameValue').getStore().load(function(records, operation, success){
            			if(success){
            				for(i in records){
            					if(records[i].data.value==personData.bankDetail.bankName){
            						personProfile.down('#bankNameValue').setValue(personData.bankDetail.bankName);
            						personProfile.down('#branchNameValue').setDisabled(false);
            		        		personProfile.down('#ifscCodeValue').setDisabled(false);
            		        		personProfile.down('#branchNameValue').getStore().getProxy().extraParams = {
                                   	 bankName:personData.bankDetail.bankName
         							}
            		        		personProfile.down('#branchNameValue').getStore().load(function(records, operation, success){
            		        			if(success && !isNullOrEmpty(personData.bankDetail.branchName)){
            		        				for(i in records){
            		        					if(records[i].data.value==personData.bankDetail.branchName){
            		        						personProfile.down('#branchNameValue').setValue(personData.bankDetail.branchName);
            		        					}
            		        				}
            		        			}
        	            				personProfile.down('#ifscCodeValue').getStore().getProxy().extraParams = {
        	                            bankName:personData.bankDetail.bankName
        	     						}
        				            	personProfile.down('#ifscCodeValue').getStore().load(function(records, operation, success){
        				            		if(success && !isNullOrEmpty(personData.bankDetail.ifsCode)){
        			        		        	for(i in records){
        			        		        		if(records[i].data.code==personData.bankDetail.ifsCode){
        				            					personProfile.down('#ifscCodeValue').setValue(personData.bankDetail.ifsCode);
        			        		        					}
        			        		        					}
        			        		        				}
        				            				});
        	            			});
            					}
            				}
            			}
            		});
            	}
            }, 2000);
    	}
    	}else{
    		var checkboxDropdownId = personProfile.down('#checkboxDropdown').getValue();
        	if(!isNullOrEmpty(checkboxDropdownId) && checkboxDropdownId){
    		Ext.defer(function() {
            	if(!isNullOrEmpty(personData) && !isNullOrEmpty(personData.bankDetail) && !isNullOrEmpty(personData.bankDetail.bankName)){
            		personProfile.down('#bankNameValue').getStore().load(function(records, operation, success){
            			if(success){
            				for(i in records){
            					if(records[i].data.value==personData.bankDetail.bankName){
            						personProfile.down('#bankNameValue').setValue(personData.bankDetail.bankName);
            						personProfile.down('#branchNameValue').setDisabled(false);
            		        		personProfile.down('#ifscCodeValue').setDisabled(false);
            		        		personProfile.down('#branchNameValue').getStore().getProxy().extraParams = {
                                   	 bankName:personData.bankDetail.bankName
         							}
            		        		personProfile.down('#branchNameValue').getStore().load(function(records, operation, success){
            		        			if(success && !isNullOrEmpty(personData.bankDetail.branchName)){
            		        				for(i in records){
            		        					if(records[i].data.value==personData.bankDetail.branchName){
            		        						personProfile.down('#branchNameValue').setValue(personData.bankDetail.branchName);
            		        					}
            		        				}
            		        			}
        	            				personProfile.down('#ifscCodeValue').getStore().getProxy().extraParams = {
        	                            bankName:personData.bankDetail.bankName
        	     						}
        				            	personProfile.down('#ifscCodeValue').getStore().load(function(records, operation, success){
        				            		if(success && !isNullOrEmpty(personData.bankDetail.ifsCode)){
        			        		        	for(i in records){
        			        		        		if(records[i].data.code==personData.bankDetail.ifsCode){
        				            					personProfile.down('#ifscCodeValue').setValue(personData.bankDetail.ifsCode);
        			        		        					}
        			        		        					}
        			        		        				}
        				            				});
        	            			});
            					}
            				}
            			}
            		});
            	}
            }, 2000);
    	}
    	}   
    },
    
    
    /**
     *  Create or update Applicant personal information
     */
    createUpdateApplicantPersonalInformation: function() {
        var this$ = this;
        var personProfile; 
        var applicationId;
        var personalInformationForm;
        var applicantPhotoUploadForm;
        var schoolPriorityVal=null;
        if(portalId==6){
            personProfile = this$.getContentPanel().items.items[0];
            applicationId  = personProfile.getApplicationId();
            //-- code changed for multiple tabs functionality for applicant portal
            if(Ext.isDefined(Ext.ComponentQuery.query('applicantpersonalinformationformstructure')))
            {
            	var personInfoStructure = Ext.ComponentQuery.query('applicantpersonalinformationformstructure')[0];
            }
            else
            {
            	var personInfoStructure=this$.getContentPanel().items.items[1];
            }	
            //var personInfoStructure=this$.getContentPanel().items.items[1];
        	personalInformationForm = personInfoStructure.down('personalinformationform');
        	applicantPhotoUploadForm = personalInformationForm.down('#applicantPhotoUploadForm');
        	applicantAppDocUploadForm = personalInformationForm.down('#applicantDocUploadForm');
        	}else{
        	personProfile  = this$.getContentPanelActiveTab();
        	applicationId = personProfile.getApplicationId();
        	personalInformationForm = personProfile.down('personalinformationform');
        	applicantPhotoUploadForm = personProfile.down('#applicantPhotoUploadForm');
        }
    	
        var personInfo = personProfile.getPersonInfo();        
        personInfo.personType = 'APPLICANT';
        personInfo.status = 'ACTIVE';
        
        var jsonFormatFormData = personalInformationForm.getValues();
        
        if(!jsonFormatFormData.areYouRegisteredAtOtherSAU) {
        	if(isNullOrEmpty(jsonFormatFormData.studentNoAtOtherSAU)) {
        		var registeredBeforeSAItemId = personalInformationForm.down("#registeredBeforeSA");
        		registeredBeforeSAItemId.allowBlank = true;
        		delete jsonFormatFormData.studentNoAtOtherSAU;
        	}
        	if(isNullOrEmpty(jsonFormatFormData.allIntakeYear)) {
        		var allInatkeYear = personalInformationForm.down("#allIntakeYearItemId");
        		allInatkeYear.allowBlank = true;
        		delete jsonFormatFormData.allIntakeYear;
        	}
        } else {
        	if(!isNullOrEmpty(jsonFormatFormData.allIntakeYear)) {
        		var allIntakeYearItem = personalInformationForm.down('#allIntakeYearItemId');
        		if(allIntakeYearItem) {
        			jsonFormatFormData.allIntakeYear = {
            				'id': allIntakeYearItem.getValue()
            		}
        		}
        	}
        }
        
        if(isNullOrEmpty(jsonFormatFormData.allIntakeYear)) {
        	var allInatkeYear = personalInformationForm.down("#allIntakeYearItemId");
    		allInatkeYear.allowBlank = true;
    		delete jsonFormatFormData.allIntakeYear;
    	}
        
        if(isNullOrEmpty(jsonFormatFormData.studentNoAtOtherSAU)) {
        	var registeredBeforeSAItemId = personalInformationForm.down("#registeredBeforeSA");
    		registeredBeforeSAItemId.allowBlank = true;
    		delete jsonFormatFormData.studentNoAtOtherSAU;
    	}
        
        if(!jsonFormatFormData.studentNoAtOtherSAU && !jsonFormatFormData.allIntakeYear) {
        	var applicantPersonRadioBtnRegisteredBeforeSA = personalInformationForm.down("#applicantPersonRadioBtnRegisteredBeforeSA");
        	 if (applicantPersonRadioBtnRegisteredBeforeSA) {
        	        var items = applicantPersonRadioBtnRegisteredBeforeSA.items.items;

        	        Ext.each(items, function(item) {
        	            if (item.inputValue == false) {
        	                item.setValue(true);
        	            }
        	        });
        	    }
        }

        if(isNullOrEmpty(jsonFormatFormData.studentStatus)){
        	delete jsonFormatFormData.studentStatus;
        }
        if(isNullOrEmpty(jsonFormatFormData.examCenterVenue)){
        	delete jsonFormatFormData.examCenterVenue;
        }
        
      /*  if(isNullOrEmpty(jsonFormatFormData.schoolAttended)){
        	delete jsonFormatFormData.schoolAttended;
        }else{
    		jsonFormatFormData.schoolAttended=jsonFormatFormData.schoolAttended.id;
        }*/
        
        if(isNullOrEmpty(jsonFormatFormData.advisorId)){
        	delete jsonFormatFormData.advisorId;
        }
        if(Ext.isDefined(jsonFormatFormData.salutation)){
        	if(isNullOrEmpty(jsonFormatFormData.salutation.id)){
        		delete jsonFormatFormData.salutation;
        	}
        }
        if(Ext.isDefined(jsonFormatFormData.secondaryCitizenship)){
        	if(isNullOrEmpty(jsonFormatFormData.secondaryCitizenship.id)){
        		delete jsonFormatFormData.secondaryCitizenship;
        	}
        }
        if(Ext.isDefined(jsonFormatFormData.homeLanguage)){
        	if(isNullOrEmpty(jsonFormatFormData.homeLanguage.id)){
        		delete jsonFormatFormData.homeLanguage;
        	}
        }
    
        if(isNullOrEmpty(jsonFormatFormData.armsOfService) ){
        		delete jsonFormatFormData.armsOfService;
        	}else{
        		jsonFormatFormData.armsOfService=this.getIdValueJson(jsonFormatFormData.armsOfService);
        	}
        
       if(!isNullOrEmpty(jsonFormatFormData.currentOrLastSchoolAttended) && !isNullOrEmpty(jsonFormatFormData.currentOrLastSchoolAttended.id)){
    		jsonFormatFormData.currentOrLastSchoolAttended=jsonFormatFormData.currentOrLastSchoolAttended;
    	}else{
    		delete jsonFormatFormData.currentOrLastSchoolAttended;
    	}
    
        if(isNullOrEmpty(jsonFormatFormData.mustering) ){
        		delete jsonFormatFormData.mustering;
        	}else{
        		jsonFormatFormData.mustering=this.getIdValueJson(jsonFormatFormData.mustering);
        	}
                
        jsonFormatFormData.applicationOwner=this.getIdValueJson(jsonFormatFormData.applicationOwner);
        delete jsonFormatFormData.admissionDate;
        delete jsonFormatFormData.studentAttendanceGroup;
        delete jsonFormatFormData.studentStatus;
        delete jsonFormatFormData.advisorId;
        delete jsonFormatFormData.age;
        jsonFormatFormData.campaignNew = this.getIdValueJson(jsonFormatFormData.campaignNew);
        jsonFormatFormData.campaignSchool = this.getIdValueJson(jsonFormatFormData.campaignSchool);
        jsonFormatFormData.enquirySource = this.getIdValueJson(jsonFormatFormData.enquirySource);
        delete jsonFormatFormData.applicantCampaignType;
        delete jsonFormatFormData.applicantPresentationType;
        
        if(isNullOrEmpty(jsonFormatFormData.campaignNew) && !isNullOrEmpty(jsonFormatFormData.campaignSchool)){
   		 schoolPriorityVal = jsonFormatFormData.schoolPriorityNew
  	  	 }
        jsonFormatFormData.applicantSchoolPriority = schoolPriorityVal;
        delete jsonFormatFormData.schoolPriorityNew;
        
        var disabilityJsonArry = [];
        var eduInterventionsJsonArry = [];
        if(isNullOrEmpty(jsonFormatFormData.genderCSM)){
        	jsonFormatFormData.genderCSM = null;
        }
        else {
        	jsonFormatFormData.genderCSM = jsonFormatFormData.genderCSM;
        }
        var maritalStatusCSM = null;
        if(!isNullOrEmpty(jsonFormatFormData.maritalStatus)){
        	jsonFormatFormData.maritalStatusId = this.getIdValueJson(jsonFormatFormData.maritalStatus);
        }
        jsonFormatFormData.maritalStatus = null;
        var idTypeId=null;
        if (!isNullOrEmpty(jsonFormatFormData.idtype)) {        	
        	idTypeId = {
                id: jsonFormatFormData.idtype
            };
        }
        jsonFormatFormData.idtype = idTypeId;
        
        var checkboxDropdownId = personalInformationForm.down('#checkboxDropdown').getValue();
    	if(!isNullOrEmpty(checkboxDropdownId) && checkboxDropdownId==="true"){
    		
        	jsonFormatFormData.bankName = personProfile.down("#bankNameValue").getValue();
        	jsonFormatFormData.branchName = personProfile.down("#branchNameValue").getValue();
        	jsonFormatFormData.ifsCode = personProfile.down("#ifscCodeValue").getValue();
    	}
    	delete jsonFormatFormData.bankNameValue;
		delete jsonFormatFormData.branchNameValue;
		delete jsonFormatFormData.ifscCodeValue;
		delete jsonFormatFormData.checkboxDropdown;
      /*  if(!isNullOrEmpty(jsonFormatFormData.whetherRPLApplicant)){
        	jsonFormatFormData.whetherRPLApplicant = this.getIdValueJson(jsonFormatFormData.whetherRPLApplicant);
        }
        */
    	if(!isNullOrEmpty(jsonFormatFormData.haveDisabilities)){
    		if(typeof jsonFormatFormData.haveDisabilities == "object"){
        		Ext.each(jsonFormatFormData.haveDisabilities, function(currentDisability){
                	var haveDisabilities = '';
                	var applicantPerson = '';
                	var mainObj = '';
                    if(!isNullOrEmpty(currentDisability)){
                	mainObj = {
                			"haveDisabilities" : {
                					"id" : currentDisability.data.id
                			},
                			"applicantPerson" : {
                					"id": personProfile.getPersonInfo().id
                			}		
                	}
                	disabilityJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
    			var haveDisabilities = '';
            	var applicantPerson = '';
            	var mainObj = '';
            	mainObj = {
            			"haveDisabilities" : {
            					"id" : jsonFormatFormData.haveDisabilities
            			},
            			"applicantPerson" : {
            					"id": personProfile.getPersonInfo().id
            			}		
            	}
            	disabilityJsonArry.push(mainObj);
    		}
    	}
        
    	 var consentedCommunicationChannelJsonArry = [];
        	if(!isNullOrEmpty(jsonFormatFormData.consentedCommunicationChannel)){
     		if(typeof jsonFormatFormData.consentedCommunicationChannel == "object"){
         		Ext.each(jsonFormatFormData.consentedCommunicationChannel, function(currentConsentedCommunicationChannel){
                 	var mainObj = '';
                     if(!isNullOrEmpty(currentConsentedCommunicationChannel && !isNullOrEmpty(currentConsentedCommunicationChannel.data))){
                     		mainObj = {
                         			"communicationChannel" : {
                         					"id" : currentConsentedCommunicationChannel.data.id
                         			},
                        			"applicantPerson" : {
                    					"id": personProfile.getPersonInfo().id
                    			}			
                         	}
                     		consentedCommunicationChannelJsonArry.push(mainObj);
                     	}
                 });
     		}else{
             	var mainObj = '';
             	mainObj = {
             			"communicationChannel" : {
             					"id" : jsonFormatFormData.consentedCommunicationChannel
             			},
            			"applicantPerson" : {
        					"id": personProfile.getPersonInfo().id
        			}	
             	}
             	consentedCommunicationChannelJsonArry.push(mainObj);
     		}
     	}
        jsonFormatFormData.consentedCommunicationChannel = consentedCommunicationChannelJsonArry;
    	
        	
       	var consentStatementAcceptedCheckbox = personProfile.down("#consentStatementAccepted");
    	if(!isNullOrEmpty(consentStatementAcceptedCheckbox))
    	{
    		jsonFormatFormData.consentStatementAccepted=consentStatementAcceptedCheckbox.getValue()
    	}
    	
    	if(!isNullOrEmpty(personInfo.isCurrentStudent))
    	{
    		jsonFormatFormData.isCurrentStudent=personInfo.isCurrentStudent
    	}
    	
    	if(!isNullOrEmpty(personInfo.isPreviousStudent))
    	{
    		jsonFormatFormData.isPreviousStudent=personInfo.isPreviousStudent
    	}
    	
    	if(!isNullOrEmpty(personInfo.isDiscontinuedStudies))
    	{
    		jsonFormatFormData.isDiscontinuedStudies=personInfo.isDiscontinuedStudies
    	}
    	
    	if(!isNullOrEmpty(personInfo.isReadmissionStatus))
    	{
    		jsonFormatFormData.isReadmissionStatus=personInfo.isReadmissionStatus
    	}
    	
    	/*if(!isNullOrEmpty(personalInformationForm.isAdult))
    	{   
    		jsonFormatFormData.isAdult=personalInformationForm.isAdult
    	}*/
    	
        jsonFormatFormData.applicantPersonDisability = disabilityJsonArry;
        
        if(!isNullOrEmpty(jsonFormatFormData.currentEducationalInterventions)){
    		if(typeof jsonFormatFormData.currentEducationalInterventions == "object"){
        		Ext.each(jsonFormatFormData.currentEducationalInterventions, function(currentEduInterventions){
                	var educationInterventions = '';
                	var applicantPerson = '';
                	var mainObj = '';
                    if(!isNullOrEmpty(currentEduInterventions)){
                	mainObj = {
                			"educationInterventions" : {
                					"id" : currentEduInterventions.data.id
                			},
                			"applicantPerson" : {
                					"id": personProfile.getPersonInfo().id
                			}		
                	}
                	eduInterventionsJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
    			var educationInterventions = '';
            	var applicantPerson = '';
            	var mainObj = '';
            	mainObj = {
            			"educationInterventions" : {
            					"id" : jsonFormatFormData.currentEducationalInterventions
            			},
            			"applicantPerson" : {
            					"id": personProfile.getPersonInfo().id
            			}		
            	}
            	eduInterventionsJsonArry.push(mainObj);
    		}
    	}
        
        jsonFormatFormData.applicantPersonEducationInterventions = eduInterventionsJsonArry;
        
        var modeOfEnquiryJsonArry = [];
        
    	if(!isNullOrEmpty(jsonFormatFormData.applicantModeOfEnquiry)){
    		if(typeof jsonFormatFormData.applicantModeOfEnquiry == "object"){
        		Ext.each(jsonFormatFormData.applicantModeOfEnquiry, function(currentModeOfEnquiry){
                	var applicantModeOfEnquiry = '';
                	var mainObj = '';
                    if(!isNullOrEmpty(currentModeOfEnquiry)){
                	mainObj = {
                			"enquiryMode" : {
                					"id" : currentModeOfEnquiry.data.id
                			}	
                	}
                	modeOfEnquiryJsonArry.push(mainObj);
                    }
                });
    		}
    		else{
    			var applicantModeOfEnquiry = '';
            	var mainObj = '';
            	mainObj = {
            			"enquiryMode" : {
            					"id" : jsonFormatFormData.applicantModeOfEnquiry
            			}		
            	}
            	modeOfEnquiryJsonArry.push(mainObj);
    		}
    	}
        jsonFormatFormData.applicationEnquiryMultipleMode = modeOfEnquiryJsonArry;
        
        delete jsonFormatFormData.advisorId;
        delete jsonFormatFormData.photo_url; 
  if(Ext.app.checkVelocity || Ext.app.checkVelocity=="true"){
        	if(isNullOrEmpty(jsonFormatFormData.mobileNumber)){
        		jsonFormatFormData.mobileCountryCode="";
        	}
        	if(isNullOrEmpty(jsonFormatFormData.phoneNo)){
        		jsonFormatFormData.phoneCountryCode="";
        	}
        }
		
		var successMsg = true;
		if (personalInformationForm) {
			var data = personalInformationForm.getValues()
		}
		var idTypeCodeValue = personalInformationForm.down('#idTypeCombo').getStore().findRecord('id', data.idtype);
		if (!isNullOrEmpty(data.nationality)) {
			var index = personalInformationForm.down('#nationalityCombo').getStore().findExact('id', data.nationality.id);
			if (index !== -1) {
				var nationalityCodeValue = personalInformationForm.down('#nationalityCombo').getStore().getAt(personalInformationForm.down('#nationalityCombo').getStore().findExact('id', data.nationality.id));
			}

		}
		var relavantType="APPLICATION";
							var applicantProfile = this$.getContentPanelActiveTab();
							if(applicantProfile.getApplicationInfo()['applicationStatus']=='DIRECT_ADMISSION')	{
									 relavantType="DIRECT_ADMISSION";
								}else{
								 relavantType="APPLICATION";
							}
		var uwcUrl = SERVERURL.PATH_GET_FIND_BY_RELEVANT_TO;
		Ext.Ajax.request({
			type: 'rest',
			url: uwcUrl + '?relavantToFormType=' + relavantType,
			method: 'GET',
			success: function(response, action) {
				Ext.getBody().unmask();
				if (!isNullOrEmpty(response.responseText) && (response.responseText) != "") {
					var responseData = Ext.JSON.decode(response.responseText);
					if (responseData != null) {
						successMsg = this$.checkUwcNationalIdValidation(responseData, data, nationalityCodeValue, idTypeCodeValue);
						if (successMsg) {
							if (this$.validatePhone(jsonFormatFormData)) {
								var photoUrl = personInfo.photoUrl;
								if (portalId == 6) {
									this$.savePersonInfo(jsonFormatFormData, photoUrl, applicationId, personProfile, personInfo, applicantAppDocUploadForm);
								} else {
									this$.savePersonInfo(jsonFormatFormData, photoUrl, applicationId, personProfile, personInfo);
								}
							}
							personalInformationForm.down('#otherDetailsApplicantFieldSet').expand();
							Ext.defer(function() {
								personalInformationForm.down('#otherDetailsApplicantFieldSet').collapse();
							}, 5000)
						}
					}
				}
				else {
					if (this$.validatePhone(jsonFormatFormData)) {
						var photoUrl = personInfo.photoUrl;
						if (portalId == 6) {
							this$.savePersonInfo(jsonFormatFormData, photoUrl, applicationId, personProfile, personInfo, applicantAppDocUploadForm);
						} else {
							this$.savePersonInfo(jsonFormatFormData, photoUrl, applicationId, personProfile, personInfo);
						}
					}
					personalInformationForm.down('#otherDetailsApplicantFieldSet').expand();
					Ext.defer(function() {
						personalInformationForm.down('#otherDetailsApplicantFieldSet').collapse();
					}, 5000)
				}
			}
		});
    },
    
    
 savePersonInfo: function(jsonFormatFormData, photoUrl,applicationId,personProfile,personInfo,applicantAppDocUploadForm){
    	
       // var photoUrl = personInfo.photoUrl;
        var submitUrl = '', methodType = '';
        var isUpdate = false;
        var this$ = this;
        
        if(isNullOrEmpty(applicationId)){        	        	 
        	submitUrl = SERVERURL.APPLICANT_PERSON_WITH_APPLICATION_CREATE; //URL-:rest/application/saveAndGenerateApplicationId
        	//submitUrl = SERVERURL.APPLICATION_FORM_SALE_APPLICANT_CREATE; //URL-:rest/application/create
        	methodType = 'POST';
        	isUpdate=false;
        }else{
        	submitUrl = SERVERURL.APPLICATION_FORM_SALE_APPLICANT_UPDATE; //URL-:rest/application/update
        	methodType = 'PUT';
        	isUpdate=true;
        }
    
  
      //  jsonFormatFormData.photoUrl = photoUrl;
        jsonFormatFormData = this$.createApplicantJsonformatData(jsonFormatFormData, personInfo, isUpdate,personProfile);
        
        jsonFormatFormData = Ext.encode(jsonFormatFormData);        

        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
     
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: methodType,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(response, action) {
            	Ext.getBody().unmask();
            	var title;
            	
            	
            	var applicantDocUploadForm = personProfile.down('#applicantDocUploadForm');
            	var documentFileUpload = applicantDocUploadForm.down('#documentFileUpload');
            	var docFileUploadPath = documentFileUpload.getValue();
            	if(!isNullOrEmpty(docFileUploadPath)){
            	
            		this$.saveStudentProfileDocumentUploadForm(applicantDocUploadForm, personProfile.getPersonId(), SERVERURL.PATH_UPLOAD_APPLICANT_PERSON_DOC, SERVERURL.PATH_DOWNLOAD_APPLICANT_PERSON_DOC, function(success,documentUrl,version){
            		if(success){
            			personProfile.down('#applicantDownloadURL').setValue(documentUrl);	
            		}
            	});
            	}
            	
            	if(portalId==6){
                	var documentFileUploadApp = applicantAppDocUploadForm.down('#documentFileUpload');
                	var docFileUploadPathApp = documentFileUploadApp.getValue();
                	if(!isNullOrEmpty(docFileUploadPathApp)){
                	
                		this$.saveStudentProfileDocumentUploadForm(applicantAppDocUploadForm, personProfile.getPersonId(), SERVERURL.PATH_UPLOAD_APPLICANT_PERSON_DOC, SERVERURL.PATH_DOWNLOAD_APPLICANT_PERSON_DOC, function(success,documentUrl,version){
                		if(success){
                			var personAppProfile = applicantAppDocUploadForm.up('personalinformationform');
                			personAppProfile.down('#applicantDownloadURL').setValue(documentUrl);	
                		}
                	});
                	}
            		title=getPersonModuleTranslation('PERSONAL_DETAILS');	
            	}else{
            		title=getPersonModuleTranslation('STUDENT_PERSONAL_DETAILS');
            	}
            	
            	if(isUpdate){
            		showSuccessMessage(title, getPersonModuleTranslation('APPLICANT_PERSONAL_UPDATE_SUCCESS')); 
            		setTimeout(function(){
            			//personProfile.down('#photoFileImage').allowBlank=true;
            			personProfile.down('form').isValid();
            		},1500);
            	}else{
            		showSuccessMessage(title, getPersonModuleTranslation('APPLICANT_PERSONAL_SUBMIT_SUCCESS'));
            	}      
            	if(portalId==6)
            	{
            		this$.setApplicantPersonalInforamtionFormValues(this$,photoUrl);
            		this$.getApplicantProfileInformation(personProfile);
            	}
            	else
            	{
            		if(isNullOrEmpty(personProfile.getApplicationId())){
            			var applicationId = Ext.decode(response.responseText);
            			personProfile.setApplicationId(applicationId);
            			this$.loadApplicantProfileView(this$,personProfile,applicationId);
            		}                 
            		this$.mixins.ApplicationBaseController.gettingDataInSummaryGrid(personProfile);                 
            		var applicantLinkPanelObject=this$.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
            		if(!isEmpty(applicantLinkPanelObject)){
            			if(Ext.app.TEMP_ADMISSIONTYPE == 'DIRECT_ADMISSION'){
            				Academia.app.getController('Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController');
            				var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
            				this$.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);
            			}else{
            				Academia.app.getController('Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController');
            				if(Ext.app.TEMP_ADMISSIONTYPE == 'NEW_APPLICATION'){
            					var applicantDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[0];    				
            					this$.addPersonTabPanel('APPLICANT', applicantDetailObject.tabPanelItemId, applicantDetailObject.tabPanelTitle, applicantDetailObject.tabPanelItemXtype, applicantDetailObject.xtypeItemId,applicantDetailObject.defaultPanel);
            				}else{
            					var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
            					this$.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);
            				}
            			}

            			var personInfoPanel=personProfile.down("#personInfoPanel");
            			if(personInfoPanel){
            				var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
            				if(applicantPersonalDetails){
            					personInfoPanel.setActiveTab(applicantPersonalDetails);
            				}        						
            			}
            		}               
            		this$.onRenderApplicantPersonalInformationForm(this$);
            	}
            }
        });
    },
    
    
    
    
    /**
     *  load Applicant Data and applicant permissions after Application successfully created
     */
    loadApplicantProfileView:function(this$,personProfile,applicationId){     	     	
         if (personProfile) {
        	this$.mixins.ApplicationBaseController.loadApplications(applicationId); 
         	this$.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(personProfile,true);
         	this$.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(personProfile,true);
         	//this$.mixins.ApplicationBaseController.getApplicantProfileInformation(personProfile);         	         	
         }
    },
    
    /*
     *  create applicant json data format for create and update Applicant   
     *  
     */
    createApplicantJsonformatData: function(jsonObj, personInfo, isUpdate,personProfile) {
    	
    	var personJsonObjectData=new Object();
    	personJsonObjectData.id="";
    	personJsonObjectData.version="";
    	
    	var this$ = this;
        jsonObj.status = personInfo["status"];
        jsonObj.isActivated = personInfo["isActivated"];        
        if (isNullOrEmpty(jsonObj.maritalStatus)) {
            jsonObj.maritalStatus = null;
        }
        if (isNullOrEmpty(jsonObj.bloodGroup)) {
            jsonObj.bloodGroup = null;
        }
        if (!isEmpty(jsonObj.religion) && isNullOrEmpty(jsonObj.religion.id)) {
            jsonObj.religion = null;
        }
        if (!isEmpty(jsonObj.nationality) && isNullOrEmpty(jsonObj.nationality.id)) {
            jsonObj.nationality = null;
        }
        
       /* if (!isEmpty(jsonObj.schoolAttended) && isNullOrEmpty(jsonObj.schoolAttended.schoolId)) {
            jsonObj.schoolAttended = null;
        }*/
        if (!isEmpty(jsonObj.country) && isNullOrEmpty(jsonObj.country.id)) {
            jsonObj.country = null;
        }
        if (!isEmpty(jsonObj.domicile) && isNullOrEmpty(jsonObj.domicile.id)) {
            jsonObj.domicile = null;
        }
        if (!isEmpty(jsonObj.castCategory) && isNullOrEmpty(jsonObj.castCategory.id)) {
            jsonObj.casteCategory = null;
        }else{            
            jsonObj.casteCategory = jsonObj.castCategory;            
        }
        if (!isEmpty(jsonObj.idtype) && isNullOrEmpty(jsonObj.idtype.id)) {
            jsonObj.idtype = null;
        }
        if (!isEmpty(jsonObj.sadcCitizenship) && isNullOrEmpty(jsonObj.sadcCitizenship.id)) {
            jsonObj.sadcCitizenship = null;
        }
      /*  if (isNullOrEmpty(jsonObj.mustering)) {
            jsonObj.mustering = null;
        }*/
        delete jsonObj.hiddenImage;
        var wsBankDetail = new Object();
        this$.setJsonfield(jsonObj, wsBankDetail, "id", "bankDetailsId");
        this$.setJsonfield(jsonObj, wsBankDetail, "version", "bankDetailsVersion");
        this$.setJsonfield(jsonObj, wsBankDetail, "bankName", "bankName");
        this$.setJsonfield(jsonObj, wsBankDetail, "accountNumber", "accountNumber");
        this$.setJsonfield(jsonObj, wsBankDetail, "branchName", "branchName");
        this$.setJsonfield(jsonObj, wsBankDetail, "ifsCode", "ifsCode");
        this$.setJsonfield(jsonObj, wsBankDetail, "beneficiaryName", "beneficiaryName");
        this$.setJsonfield(jsonObj, wsBankDetail, "beneficiaryNameOtherLanguage", "beneficiaryNameOtherLanguage");
        this$.setJsonfield(jsonObj, wsBankDetail, "accountTypeId", "accountTypeId");
        
        if(isNullOrEmpty(wsBankDetail.id) && isNullOrEmpty(wsBankDetail.version) && isNullOrEmpty(wsBankDetail.bankName) 
        		&& isNullOrEmpty(wsBankDetail.branchName) && isNullOrEmpty(wsBankDetail.accountNumber) && isNullOrEmpty(wsBankDetail.ifsCode)
        		&& isNullOrEmpty(wsBankDetail.beneficiaryName) && isNullOrEmpty(wsBankDetail.accountType) && isNullOrEmpty(wsBankDetail.beneficiaryNameOtherLanguage)){
        	jsonObj["bankDetail"] = null;
        }else{
        	jsonObj["bankDetail"] = wsBankDetail;
        }
        
        var wsApplPhyChars = new Object();
        this$.setJsonfield(jsonObj, wsApplPhyChars, "id", "phyId");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "version", "phyVersion");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "height", "height");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "weight", "weight");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "hairColor", "hairColor");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "eyeColor", "eyeColor");                
        if(isNullOrEmpty(wsApplPhyChars.id) && isNullOrEmpty(wsApplPhyChars.version) && isNullOrEmpty(wsApplPhyChars.height) 
        		&& isNullOrEmpty(wsApplPhyChars.weight) && isNullOrEmpty(wsApplPhyChars.hairColor) && isNullOrEmpty(wsApplPhyChars.eyeColor)){
        	jsonObj["applicantPhysicalCharacteristics"] = null;
        }else{
        	jsonObj["applicantPhysicalCharacteristics"] = wsApplPhyChars;
        }
        
        var appId = null;
        if(portalId==6){
        	var personProfile = this$.getContentPanel().items.items[0];
        	//-- code changed for multiple tabs functionality for applicant portal
        	//var personInfoStructure=this$.getContentPanel().items.items[1];
        	if(Ext.isDefined(Ext.ComponentQuery.query('applicantpersonalinformationformstructure')))
        	{
        		var personInfoStructure = Ext.ComponentQuery.query('applicantpersonalinformationformstructure')[0];
        	}
        	else
        	{
        		var personInfoStructure=this$.getContentPanel().items.items[1];
        	}	
        	var form = personInfoStructure.down('personalinformationform').getForm();
        }
        else
        {
        	var personProfile = this.getContentPanelActiveTab();
        	var form = personProfile.down('personalinformationform').getForm();
        }
        if(isUpdate){
        	personJsonObjectData.id=personProfile.getApplicationId();
        	
           //var appId = personalInformationForm.down('#applicantId').getValue();
       	 appId = form.findField('applicantId').getValue();
        	
        	personJsonObjectData.version=personProfile.getApplicationDataObject().version;
        	jsonObj.id= personProfile.getPersonId();
//        	if(!isEmpty(personProfile.getPersonInfo())){
//        		jsonObj.version = personProfile.getPersonInfo().version;
//        	}
        	if(!isEmpty(personProfile.getApplicationDataObject().person.bankDetail)) {        	            	
            	jsonObj.bankDetail.version= personProfile.getApplicationDataObject().person.bankDetail.version;
            }
        }              
        
//        jsonObj.version = jsonObj.personVersion
        jsonObj.version=jsonObj.version;
        
        jsonObj["isEmployeeOfOrganization"] = false;        
        delete jsonObj["isMidtermJoinee"];
        delete jsonObj["personId"];
        delete jsonObj["personVersion"];
        delete jsonObj["castCategory"];
        delete jsonObj["personVersion"];
        delete jsonObj["validTill"];
        delete jsonObj["haveDisabilities"];
        delete jsonObj["applicantModeOfEnquiry"];
        delete jsonObj["currentEducationalInterventions"];
        delete jsonObj["refApplicationId"];
        
        personJsonObjectData["person"]=jsonObj;     
        if(!isUpdate && !isNullOrEmpty(personJsonObjectData.person) && !isNullOrEmpty(personJsonObjectData.person.applicationOwner)){
    		personJsonObjectData.applicationOwner=personJsonObjectData.person.applicationOwner;	
    	}
        
        var applicationEntityDataModel=new Academia.model.admission.applications.applicantinfo.ApplicationEntityDataModel(personProfile.getApplicationDataObject());   
        applicationEntityDataModel.set('applicationEnquiryMultipleMode',jsonObj.applicationEnquiryMultipleMode);
        this$.setApplicantCode(personJsonObjectData,jsonObj,'applicantId','code');        
        if(!isNullOrEmpty(personProfile.getApplicationInfo().applicationStatus)) {
        	applicationEntityDataModel.set('currentStatus',personProfile.getApplicationInfo().applicationStatus);
        }
        if(isNullOrEmpty(applicationEntityDataModel.get('currentStatus'))) {
        	applicationEntityDataModel.set('currentStatus','APPLIED');
        }
        
        applicationEntityDataModel.set('code',appId);
        
        var getApplicationObject=personProfile.getApplicationDataObject();
        if (!isNullOrEmpty(getApplicationObject["saleRefType"]) && getApplicationObject["saleRefType"] === 'APPLIED_EARLIER') {
        	personJsonObjectData.refApplicationId=getApplicationObject["refApplicationId"];
        }
        if(!isNullOrEmpty(getApplicationObject["saleRefPrimaryId"]) && !isNullOrEmpty(getApplicationObject["saleRefType"])){
        	var selectedApplicationType=getApplicationObject["saleRefType"];
        	if (selectedApplicationType === 'ENQUIRED_EARLIER') {
        		applicationEntityDataModel.set('enquiryStudentDetailId',getApplicationObject["saleRefPrimaryId"]); 
	        }  else if (selectedApplicationType === 'EXISTING_STUDENT') {
	        	applicationEntityDataModel.set('existingStudentId',getApplicationObject["saleRefPrimaryId"]);
	        }
        }
        //V2D-98413 Remove Form Sold Case.
       
        personJsonObjectData=this$.setPersonObjectWithApplicationEntityDataModel(applicationEntityDataModel,personJsonObjectData);
        if(isNullOrEmpty(personJsonObjectData['reservationCategory'])){
        	personJsonObjectData['reservationCategory']=null;    		
    	}
        delete personJsonObjectData["person"].applicationEnquiryMultipleMode;
        
//        personJsonObjectData.cellNo = jsonObj['mobileNumber'] ;
//        personJsonObjectData.primaryEmailId = jsonObj['emailId'] ;
//        delete personJsonObjectData.person["mobileNumber"];
//        delete personJsonObjectData.person["emailId"];
		delete personJsonObjectData.person["refStudentId"];
		delete personJsonObjectData.person["refApplicationId"];
        personJsonObjectData.person.version = personJsonObjectData.person.version;
        
        var departmentArray = [];
     	var duplicateIdMap = new Ext.util.HashMap();
     	var currentTab;
     	try {
        	currentTab = this$.getContentPanelActiveTab();
        	currentTab.getPersonId();
     	}catch(e) {
     		currentTab = this$.getContentPanel().items.items[0];
     	}
     	
     	var formWindow = currentTab.down('personalinformationform');
     	if (!isNullOrEmpty(formWindow.down('#serviceStopPanelId').items.items)
    			&& formWindow.down('#serviceStopPanelId').items.items.length > 1) {
        	var courseDepartmentCombo = this.getIdValueJson(jsonObj.employeeLanguage[0], jsonObj.employeeLanguage[0]);
        	

        	for (var i = 0; i < formWindow.down('#serviceStopPanelId').items.items.length; i++) {
        		var newData = {
    					"multiLanguage" : this.getIdValueJson(jsonObj.employeeLanguage[i],jsonObj.employeeLanguage[i]),
    					"read" :  this.getIdValueJson(jsonObj.read[i],jsonObj.read[i]),
    					"speak" : this.getIdValueJson(jsonObj.speak[i],jsonObj.speak[i]),
    					"write" :this.getIdValueJson(jsonObj.write[i],jsonObj.write[i]),
    					"person":this.getIdValueJson(jsonObj.id,jsonObj.id),
    					"id":jsonObj.langId[i]
    			};
        		if(!isNullOrEmpty(newData.multiLanguage)){
        			delete newData.multiLanguage.value
        		}
        		if(duplicateIdMap.containsKey(jsonObj.employeeLanguage[i])){
        			duplicateIdFlag=true;
        			break;
        		}
        		duplicateIdMap.add(jsonObj.employeeLanguage[i], i);
        		departmentArray.push(newData);
        	}
    		
        }else if(!isNullOrEmpty(formWindow.down('#serviceStopPanelId').items.items)
    			&& formWindow.down('#serviceStopPanelId').items.items.length == 1){
        	if(jsonObj.employeeLanguage.length>1) {
        		var courseDepartmentCombo = this.getIdValueJson(jsonObj.employeeLanguage[0], jsonObj.employeeLanguage[0]);
        		for (var i = 0; i < jsonObj.employeeLanguage.length; i++) {
            		var newData = {
        					"multiLanguage" : this.getIdValueJson(jsonObj.employeeLanguage[i],jsonObj.employeeLanguage[i]),
        					"read" :  this.getIdValueJson(jsonObj.read[i],jsonObj.read[i]),
        					"speak" : this.getIdValueJson(jsonObj.speak[i],jsonObj.speak[i]),
        					"write" :this.getIdValueJson(jsonObj.write[i],jsonObj.write[i]),
        					"person":this.getIdValueJson(jsonObj.id,jsonObj.id),
        					"id":jsonObj.langId[i]
        			};
            		if(!isNullOrEmpty(newData.multiLanguage)){
            			delete newData.multiLanguage.value
            		}
            		if(duplicateIdMap.containsKey(jsonObj.employeeLanguage[i])){
            			duplicateIdFlag=true;
            			break;
            		}
            		duplicateIdMap.add(jsonObj.employeeLanguage[i], i);
            		departmentArray.push(newData);
            	}
        	}else {
	        	var courseDepartmentCombo = this.getIdValueJson(jsonObj.employeeLanguage, jsonObj.employeeLanguage);
	
	        	var newData = {
	        			"multiLanguage" : this.getIdValueJson(jsonObj.employeeLanguage,jsonObj.employeeLanguage),
						"read" :  this.getIdValueJson(jsonObj.read,jsonObj.read),
						"speak" : this.getIdValueJson(jsonObj.speak,jsonObj.speak),
						"write" :this.getIdValueJson(jsonObj.write,jsonObj.write),
						"person":this.getIdValueJson(jsonObj.id,jsonObj.id),
						"id":jsonObj.langId,
						
				};
	        	if(!isNullOrEmpty(newData.multiLanguage)){
	        		delete newData.multiLanguage.value
	        	}
	        	departmentArray.push(newData);
        	}
        }
     	personJsonObjectData.person.languageCompetency = departmentArray;
     	
     	delete personJsonObjectData.person.langId;
     	delete personJsonObjectData.person.read;
     	delete personJsonObjectData.person.write;
     	delete personJsonObjectData.person.speak; 
     	delete personJsonObjectData.person.employeeLanguage;
     	
        return personJsonObjectData;
    },       
    
    /**
     *  Put all Application Data in final Object(personJsonObjectData)
     */
    setPersonObjectWithApplicationEntityDataModel:function(applicationEntityDataModel,personJsonObjectData){
    	for (var key in applicationEntityDataModel.data) {
            if(isNullOrEmpty(applicationEntityDataModel.data[key])){            	
            	personJsonObjectData[key]="";            	               
            }else{
                personJsonObjectData[key]=applicationEntityDataModel.data[key];   
            }    		
        }
    	return personJsonObjectData;
    },
    
    
    setApplicantCode: function(data,personData,applicantIdValue,codeField) {    	
    	if(!isNullOrEmpty(personData[applicantIdValue])){
    		var applicantId=personData[applicantIdValue];
    		delete personData[applicantIdValue];
    		data[codeField]=applicantId;
    	}else{
    		data[codeField]="";
    	}
    	return data;
   },
    
    /*
     *  Need to set value in form
     */
    getApplicantPersonalInfoFormValue: function(data) {
        var this$ = this;
        
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'id', 'bankDetailsId');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'version', 'bankDetailsVersion');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'bankName', 'bankName');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'accountNumber', 'accountNumber');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'branchName', 'branchName');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'ifsCode', 'ifsCode');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'beneficiaryName', 'beneficiaryName');
        this$.getApplicantPersonalInfoJsonValue(data, 'bankDetail', 'accountTypeId', 'accountTypeId');
        this$.getApplicantPersonalInfoJsonObject(data, 'casteCategory', 'castCategory');
        
        this$.getApplicantPersonalInfoJsonValue(data, 'applicantPhysicalCharacteristics', 'id', 'phyId');
        this$.getApplicantPersonalInfoJsonValue(data, 'applicantPhysicalCharacteristics', 'version', 'phyVersion');
        this$.getApplicantPersonalInfoJsonValue(data, 'applicantPhysicalCharacteristics', 'height', 'height');
        this$.getApplicantPersonalInfoJsonValue(data, 'applicantPhysicalCharacteristics', 'weight', 'weight');
        this$.getApplicantPersonalInfoJsonValue(data, 'applicantPhysicalCharacteristics', 'hairColor', 'hairColor');
        this$.getApplicantPersonalInfoJsonValue(data, 'applicantPhysicalCharacteristics', 'eyeColor', 'eyeColor');        
        
        
        return data;
    },

    /**
     * set applicant data in to json data format
     */
    
    getApplicantPersonalInfoJsonValue: function(data, obj, datafield, formField) {
        if (data[obj] != null && data[obj].hasOwnProperty(datafield)) {
            var dataObj = data[obj];
            data[formField] = dataObj[datafield];
        }
        return data;
    },
    
    /**
     * set applicant data in to json data format
     */
    
    getApplicantPersonalInfoJsonObject: function(data, obj, formField) {
        if (data[obj] != null) {
            var dataObj = data[obj];
            delete data[obj];
            data[formField] = dataObj;
        }
        return data;
    },

     /**
     * get applicant address template data
     */

    
    /*
     *  save the address details
     */
    saveApplciantAddressDetails: function() {
        var this$ = this;
        var applicantProfile = this$.getContentPanelActiveTab();
        var formAddressData = this.getPersonAddressFormWindow().getFormAddressData();
        var addRefWin=this.getPersonAddressFormWindow();
        var saveBtn = addRefWin.down('#submitButtonId');
        saveBtn.setDisabled(true);
        var addressCombo = applicantProfile.down('#addressCombo');
        var type = addressCombo.getValue();
        var form = this.getPersonAddressFieldsForm().getForm();
        var ad = form.findField('addressText').getValue();
    	var address=ad.trim();
    	form.findField('addressText').setValue(address);
    	if(address == '')
    		{
    		showWarningMessage(getCommonTranslation('ALERT'),getAdmissionTranslation('ENTER_VALID_ADDRESS'));
    		}else{
    			form.findField('addressText').setValue(address);
    		}
        if (form.isValid()) {
            var values = form.getValues();
            	var addressDetails = applicantProfile.down('#applicantAddressDetails');
            	if(isNullOrEmpty(addressDetails) && portalId==6){
            		var addressDetails = Ext.ComponentQuery.query('#applicantAddressDetails')[0];
            	}
            	var personId;
                if(addressDetails != null){
                	personId = addressDetails.getAddressPersonId();
            	} else {
            		personId = this$.getContentPanel().items.items[0].getPersonInfo().id;
            	}
                if(!isNullOrEmpty(personId)){
                	var address = new Academia.model.organization.Address();
                    var submitUrl, methodType;
                    var successMessage;
                    var id = form.findField('id').getSubmitValue();
                    form.updateRecord(address);
                    var jsonObj = new Object();
                    address.set('country', this$.getAddressController().getIdValueJson(values.country));
                    address.set('parentCountryRegion', this$.getAddressController().getIdValueJson(values.parentCountryRegion));
                    address.set('countryRegion', this$.getAddressController().getIdValueJson(values.countryRegion));
                    address.set('city', this$.getAddressController().getIdValueJson(values.city));
                    address.set('addressType', this$.getAddressController().getIdValueJson(values.addressType));
                    address.set('pincodeNew', this$.getAddressController().getIdValueJson(values.pincodeNew));
                    if(!isNullOrEmpty(values.parentCountryRegionIdText)){
                    	address.set('parentCountryRegionIdText', values.parentCountryRegionIdText);
                        address.set('countryIdText', values.countryIdText);
                        address.set('cityIdText', values.cityIdText);
                        delete address.data.country;
                        delete address.data.countryRegion;
                        delete address.data.city;
                    }
                    if(form.findField('pincodeNew').isHidden()){
                    	delete address.data.pincodeNew;
                    }else if(form.findField('pincode').isHidden()){
                    	address.data.pincode = '';
                    }
                    jsonObj.address = address.data;

                    jsonObj.id = formAddressData["id"];
                    jsonObj.version = formAddressData["version"];
                    jsonObj.applicantPersonId = personId;
                    jsonObj.isDeleted = false;
                    //jsonObj.addressType = this$.getAddressController().getIdValueJson(values.addressType);
                    jsonObj.isPrimary = values.isPrimary;
                    jsonObj.type = type;
                    jsonObj.customData = values.customData;

                    var formData = Ext.encode(jsonObj);
                    if (isNullOrEmpty(id)) {
                    	methodType = 'POST';
                        submitUrl = SERVERURL.APPLICANT_PERSON_ADDRESS_ADD;
                        successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
                    } else {
                    	methodType = 'PUT';
                        submitUrl = SERVERURL.APPLICANT_PERSON_ADDRESS_UPDATE;
                        successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
                    }
                    
                    var otherAddressTypeIds=[];
                    var otherAddressVals = form.findField('otherAddressTypeId').getValue();
    				if(otherAddressVals != undefined && otherAddressVals.length > 0){
    					if(!isNaN(otherAddressVals[0])){
    						if(otherAddressVals[0] !=""){
    							otherAddressTypeIds.push(otherAddressVals[0].data.id);	
    						}
    					}
    					else{
    						for(var i in otherAddressVals){
    							otherAddressTypeIds.push(otherAddressVals[i].data.id);
    						}
    					}
    				}
    				
                    submitUrl = submitUrl+'?otherAddressTypes='+otherAddressTypeIds.join();
                    this$.applyWindowMask(); 
                    
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.APPLICANT_PERSON_IS_ADDRESS_EXIST + '?applicantPersonId=' +personId +'&otherAddressTypes='+ otherAddressTypeIds.join() ,
                        method: 'GET',
                        success: function(form, action) {
                        	var response = Ext.decode(form.responseText);
                        	if(response.length>0){
                        		this$.hideWindowMask();
                        		var message = getCommonTranslation('COPY_ADDRESS_CNFRM_MSG');
                        		showConfirmMessage(getCommonTranslation('WARNING'),message, function(btn, text) {
        	                        if (btn == 'yes') {
        	                        	this$.applyWindowMask();
        	                        	Ext.Ajax.request({
        	                                type: 'rest',
        	                                url: submitUrl,
        	                                jsonData: formData,
        	                                method: methodType,
        	                                success: function(form, action) {
        	                                	this$.hideWindowMask();
        	                                    showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
        	                                    this$.getPersonAddressFormWindow().close();
        	                                    this$.onSelectionPersonAddressTypeCombo('#applicantAddressDetails', SERVERURL.APPLICANT_FIND_RELATED_PERSON_ID, SERVERURL.APPLICANT_GET_PERSON_ADDRESS_DETAILS);
        	                                }
        	                            });
        	                        } else {
        	                        	saveBtn.setDisabled(false);
        	                        }
                        		});
                        	
                        	} else {
                        		Ext.Ajax.request({
                                    type: 'rest',
                                    url: submitUrl,
                                    jsonData: formData,
                                    method: methodType,
                                    success: function(form, action) {
                                    	this$.hideWindowMask();
                                        showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
                                        this$.getPersonAddressFormWindow().close();
                                        this$.onSelectionPersonAddressTypeCombo('#applicantAddressDetails', SERVERURL.APPLICANT_FIND_RELATED_PERSON_ID, SERVERURL.APPLICANT_GET_PERSON_ADDRESS_DETAILS);
                                    }
                                });
                        	}
                        }
                    });
               
                    /*Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        jsonData: formData,
                        method: methodType,
                        success: function(form, action) {
                        	this$.hideWindowMask();
                            showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
                            this$.getPersonAddressFormWindow().close();
                            this$.onSelectionPersonAddressTypeCombo('#applicantAddressDetails', SERVERURL.APPLICANT_FIND_RELATED_PERSON_ID, SERVERURL.APPLICANT_GET_PERSON_ADDRESS_DETAILS);
                        }
                    });*/
                }
                
        }
    },
    /**
	 * SET the print name value when user entered first, middle and lastname.
	 */
    setPrintNameValue:function(textfield){
    	var this$ = this;
    	var form = textfield.up('form');
    	var getForm=form.getForm();
    	var firstName = getForm.findField('firstName').getValue();
    	var middleName = getForm.findField('middleName').getValue();
    	var lastName = getForm.findField('lastName').getValue();
    	
    	if(portalId==6){
    		var personProfile =applicationStatus=this$.getContentPanel().items.items[0];	
		}else{
			var personProfile = this$.getContentPanelActiveTab();	
		}
    	if(Ext.isDefined(personProfile.getApplicationDataObject)){
    	var data =  personProfile.getApplicationDataObject();
    	} 
    	var printName=null;
    	if(isNullOrEmpty(middleName)){
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+lastName;
    		}else{
    			printName =firstName;
    		}
    	}else{
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+middleName+" "+lastName ;
    		}else{
    			printName =firstName+" "+middleName;
    		}
    	}
    	printName=printName.trim();
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.FILE_PRIORITY,
    		params: {
    			type:'ShortName'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if(response.length == 0){
    				if(Ext.isDefined(data) && !isNullOrEmpty(data)){
    					if(!isNullOrEmpty(data.printName) && !isNullOrEmpty(data.shortName)){
    						getForm.findField('printName').setValue(data.printName.replace(/ +/g, " "));
    						getForm.findField('shortName').setValue(data.firstName.replace(/ +/g, " "));
    					}else{
    						getForm.findField('printName').setValue(printName);
    						getForm.findField('shortName').setValue(firstName);
    					}
    				}else{
    					getForm.findField('printName').setValue(printName);
    					getForm.findField('shortName').setValue(firstName);
    				}
    			}else{
    				if(Ext.isDefined(data) && !isNullOrEmpty(data)){
    					if(!isNullOrEmpty(data.printName)){
    						getForm.findField('printName').setValue(data.printName.replace(/ +/g, " "));
    					}else{
    						getForm.findField('printName').setValue(printName);
    					}
    				}else{
    					getForm.findField('printName').setValue(printName);
    				}
    			}
    		}
    	});
    },
    
    doAccessAddressSaveBtn: function(form, privilegesMap) {
    	
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
    	var saveBtn = form.down('#submitButtonId');
    	saveBtn.setVisible(false);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege == 'SAVE') {
    			saveBtn.setVisible(true); 
        	}
    	});
    },
    getCopyAddressPriviledge: function(form, privilegesMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
		setTimeout(function(){
		var copyStore = form.down('#otherAddressTypeItemId').getStore();
		//copyStore.load();
			copyStore.on('load', function(){
				for(var i=0; i<= copyStore.data.items.length;i++){
					if(!isNullOrEmpty(copyStore.data.items[i])){
						if(!permissionList.includes(copyStore.data.items[i].data.permissionKey) ){
							copyStore.removeAt(i);
							i--;
						}
					}
				}
			});
		},300)
    },
    
    doAccessPersonalInfoSaveBtn: function(form, privilegesMap) {
    	
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
    	
    	var saveBtn = form.down('#personalInfoSaveButtonId');
    	saveBtn.setVisible(false);
    	
    	var verifyDetailsBtn = form.down('#verifyDetail');
    	verifyDetailsBtn.setVisible(false);
    	
    	var validateIDBtn = form.down('#validateID');
    	validateIDBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege == 'SAVE') {
    			saveBtn.setVisible(true); 
        	}
    		if (privilege === 'VALIDATE_ID_BUTTON') {
    			if(!isNullOrEmpty(validateIDBtn)){
    				validateIDBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'VERIFY_DETAILS_BUTTON') {
    			if(!isNullOrEmpty(verifyDetailsBtn)){
    				//V2D-149774
    				//verifyDetailsBtn.setVisible(true);
    			}        		
    		}
    	});
    },
    
    disableOtherInformaionFormPivileges: function(formReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	//associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var saveBtn = formReference.down('#submitButtonId');
    	saveBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVE') {
    			if(!isNullOrEmpty(saveBtn)){
    				saveBtn.setVisible(true);
    			}        		
    		}
    		
    	});
    },
    
    getAllPermissions: function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	
    	$$this = Academia.app.getController('Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController');
    	$$$this = Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
    	$this$ = Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
    	$this$$ = Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');
    	$this$$$ = Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
    	$this$$$$ = Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
    	
    	var returnJson = new Ext.util.HashMap();
    	
    	var viewAddressDetails = this.getAPPLICANT_ADDRESS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewAddressDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isAddress", true);
    		}
    	});
    	var viewFeePayerDetail=this.getAPPLICANT_FEE_PAYER_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewFeePayerDetail);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isFeePayerDetail", true);
    		}
    	});
    	var viewParentAndGuardianDetails = this.getAPPLICANT_PARENTS_GUARDIANS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewParentAndGuardianDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isParentAndGuardian", true);
    		}
    	});
    	var viewSiblingDetails = this.getAPPLICANT_SIBLINGS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewSiblingDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isSiblingDetails", true);
    		}
    	});
    	
    	var viewIdentityPermission = this.getAPPLICANT_IDENTITY_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewIdentityPermission);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isIdentity", true);
    			return;
    		}
    	});
    	
    /*	var viewPNCs = $this$$.getAPPLICATIONS_MIDTERM_ADMISSION_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPNCs);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isPNC", true);
    		}
    		
    	});*/
    	
    	var viewEducationDetails = $$this.getAPPLICANT_EDUCATION_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewEducationDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isEducation", true);
    		}
    	});
    	
    	var viewCompetitiveDetails = $$this.getAPPLICANT_COMPETITIVE_EXAM_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewCompetitiveDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isCompetitive", true);
    		}
    	});
    	
    	var viewWorkExperienceDetails = $$this.getAPPLICANT_WORK_EXPERIENCE_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewWorkExperienceDetails);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isWorkExp", true);
    		}
    	});
    	
    	var viewReceiptPaymentPermission = $this$.getAPPLICATION_RECEIPT_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewReceiptPaymentPermission);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isReceiptPayment", true);
    		}
    	});
    	
    	var viewDocumentPermission = $$$this.getAPPLICANT_DOCUMENTS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewDocumentPermission);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isDocument", true);
    		}
    	});

    	var viewExtracurricularActivity = $$this.getAPPLICANT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewExtracurricularActivity);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isExtracurricularActivity", true);
    		}
    	});

    	var viewVaccination = $$this.getAPPLICANT_VACCINATION_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewVaccination);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isVaccination", true);
    		}
    	});

    	var viewMedical = $$this.getAPPLICANT_MEDICAL_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewMedical);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isMedical", true);
    		}
    	});
    	
    	var viewApplicantionDetail = $this$$$.getAPPLICANT_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewApplicantionDetail);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isApplicationDetail", true);
    		}
    	});
    	
     	var viewApplicationReference = $this$$$.getAPPLICANT_REFERENCES_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewApplicationReference);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW') {
    			returnJson.add("isApplicationRef", true);
    		}
    	});
    	
    	/*var viewMidTermAdmission = $this$$.getAPPLICATIONS_MIDTERM_ADMISSION_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewMidTermAdmission);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isMidTermAdmission", true);
    		}
    	});*/
    	
    	var viewAdmission = $this$$.getAPPLICATIONS_ADMISSION_DETAILS_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewAdmission);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isAdmissionDetails", true);
    		}
    	});
    	
    	
    	var viewFeePlan=$this$.getAPPLICANT_FEEPLAN_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewFeePlan);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isFeePlan", true);
    		}
    	});
    	var viewServiceOptIn=$this$$$$.getAPPLICATION_SERVICEOPTIN_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewServiceOptIn);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isServiceOptIn", true);
    		}
    	});
    	
    	
    	var viewCommunityOptIn=$this$$$$.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewCommunityOptIn);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isCommunityOptIn", true);
    		}
    	});
    	
    	/*var viewNSFAS = $this$$$$.getAPPLICATIONS_NSFAS_PRIVILEGES();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewNSFAS);
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEW'){
    			returnJson.add("isNSFAS", true);
    		}
    	});*/
    	
	return returnJson;
},
setMaximumMinimumDigitsForMobileNo:function(rowModel, record){
	var this$=this;
	var personProfile = this$.getContentPanelActiveTab();
	if(personProfile){
		var personalInformationForm = personProfile.down('personalinformationform');
		var mobileField=personalInformationForm.down('#mobileNumber');
		var countryInfo=record[0].data;
		mobileField.maxLength=  (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
		mobileField.minLength=  (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
	}
},



/*setDefaultCountryCodeApplicant:function(){
	if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
		var feePayer = this.getPersonFeePayerDetailForm();
		var homeTelephoneCountryCode=feePayer.down('#homeTelephoneCountryCodeItemId');
		homeTelephoneCountryCode.getStore().load({
			callback: function(records, operation, success) {
				if (success) {
					for(i in records){
						if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
							homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
						}
					}
				}
			}
		});
		var workTelephoneCountryCode=feePayer.down('#workTelephoneCountryCodeItemId');
		workTelephoneCountryCode.getStore().load({
			callback: function(records, operation, success) {
				if (success) {
					for(i in records){
						if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
							workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
						}
					}
				}
			}
		});
		var countryCode=feePayer.down('#countryCodeItemId');
		countryCode.getStore().load({
			callback: function(records, operation, success) {
				if (success) {
					for(i in records){
						if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
							countryCode.setValue(records[i].data.isdCode);  									  
						}
					}
				}
			}
		});
	}
},*/

setDefaultCountryCodeApplicant:function(){
	var form = this.getPersonFeePayerDetailForm();
	Ext.Ajax.request({
		type: 'rest',
		url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
		method: 'GET',
		success: function(response, action) {
			var MSSG = response.responseText;
			var jdata = Ext.decode(response.responseText);
			var defaultCountryId = -1;
			if(!isNullOrEmpty(jdata.id)){
				defaultCountryId = jdata.id; 
			}
			var homeTelephoneCountryCode=form.down('#homeTelephoneCountryCodeItemId');
			if(isNullOrEmpty(homeTelephoneCountryCode.getValue())){
				homeTelephoneCountryCode.getStore().load({
					callback: function(records, operation, success) {
						if (success) {
							for(i in records){
								if(defaultCountryId == -1){
									if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
										homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
									} 
								}else{
									if(records[i].data.id == defaultCountryId){
										homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
									}
								}
							}
						}
					}
				});
			}

			var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
			if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
				workTelephoneCountryCode.getStore().load({
					callback: function(records, operation, success) {
						if (success) {
							for(i in records){
								if(defaultCountryId == -1){
									if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
										workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
									} 
								}else{
									if(records[i].data.id == defaultCountryId){
										workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
									}
								}
							}
						}
					}
				});
			}

			var countryCode=form.down('#countryCodeItemId');
			if(isNullOrEmpty(countryCode.getValue())){
				countryCode.getStore().load({
					callback: function(records, operation, success) {
						if (success) {
							for(i in records){
								if(defaultCountryId == -1){
									if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
										countryCode.setValue(records[i].data.isdCode);  									  
									} 
								}else{
									if(records[i].data.id == defaultCountryId){
										countryCode.setValue(records[i].data.isdCode);  									  
									}
								}
							}
						}
					}
				});
			}
		}
	});
},

/**
 * @author Swapnil Patil
 */
setApplicantPersonalInforamtionFormValues:function(this$,photoUrl){
	var applicant_Personal_Information_Url = null;
	var personProfile = this$.getContentPanel().items.items[0];
	//-- code changed for multiple tabs functionality for applicant portal
	//var personInfoStructure=this$.getContentPanel().items.items[1];
	if(Ext.isDefined(Ext.ComponentQuery.query('applicantpersonalinformationformstructure')))
	{
		var personInfoStructure = Ext.ComponentQuery.query('applicantpersonalinformationformstructure')[0];
	}
	else
	{
		var personInfoStructure=this$.getContentPanel().items.items[1];
	}	
	if(!isNullOrEmpty(photoUrl)){
		personProfile.personInfo.photoUrl=photoUrl;
	}
	if(personProfile && personInfoStructure){        	
		var personalInformationForm = personInfoStructure.down('personalinformationform');
		// DFR New Setup
		/*var selectionGrid = personProfile.down('selectionsnapshotgrid');
		if(!isNullOrEmpty(selectionGrid.getStore().data)){
			if(selectionGrid.getStore().data.items.length>0){
				var ProgramBatchtId = selectionGrid.getStore().data.items[0].data.programBatchSeatConfigurationId;
				this$.mixins.ApplicantPortalSetupController.getAppSetupDynamicForFormFieldsInfo(ProgramBatchtId,personalInformationForm,'personalinformationform');	
			}
		}*/
	//----------------------------------	
		personalInformationForm.down('#isAutomateExchange').setVisible(false);
		personalInformationForm.down('#academicBankCredits').setVisible(false);
        personalInformationForm.down('#coaStudent').setVisible(false);
    	personalInformationForm.down('#naadStudent').setVisible(false);
		personalInformationForm.getForm().findField('validTill').setVisible(false);
		personalInformationForm.down("#isMidtermJoineeField").setVisible(false);
        personalInformationForm.getForm().findField('admissionDate').setVisible(false);
        personalInformationForm.down('#studentDocUploadForm').setVisible(false);
    	personalInformationForm.down('#studentDownloadURL').setVisible(false);
    	personalInformationForm.down('#applicantDocUploadForm').setVisible(false);
    	personalInformationForm.down('#applicantDownloadURL').setVisible(false);
    	personalInformationForm.down('#commentsItemId').setVisible(false);
    	personalInformationForm.down('#externalSysRefOne').setVisible(false);
    	personalInformationForm.down('#externalSysRefTwo').setVisible(false);
    	personalInformationForm.down('#externalSysRefThree').setVisible(false);
        
    	var nationalityField = personalInformationForm.down("#nationalityCombo");
        var idTypeField = personalInformationForm.down("#idTypeCombo");
        var uploadDocField =  personalInformationForm.down('#applicantDocUploadForm');
    	var uploadDocURL = personalInformationForm.down('#applicantDownloadURL');
    	
     	var mustering = personalInformationForm.down("#mustering");
        this.loadDFRForIDTypeVisibility(idTypeField, uploadDocField, uploadDocURL);
		var applicationId=personProfile.getApplicationId();
		if(!isNullOrEmpty(applicationId)){ //Edit Application Case 
			applicant_Personal_Information_Url = SERVERURL.APPLICANT_PERSONAL_INFORMATION_BY_ID;       	           	
			applicant_Personal_Information_Url=applicant_Personal_Information_Url.concat("?id="+applicationId);           	
			this$.sendGetAjaxRequest(applicant_Personal_Information_Url, 'GET', null, function(option, success, response) {
				if(success){	
					var data = Ext.decode(response.responseText);
					if(!isEmpty(data)){
						this$.checkFieldValidity(personalInformationForm,true,data);
						var applicationIdField= personalInformationForm.down('#personCodeField');
						if(applicationIdField && !isNullOrEmpty(data['code'])){
		            		applicationIdField.setValue(data['code']);
		            		applicationIdField.setReadOnly(true);
		            	}  
						
						if(!isNullOrEmpty(data.person.birthDate))
							data.person.birthDate = new Date(data.person.birthDate);
						personProfile.setApplicationDataObject(data);                        	
						personProfile.setPersonInfo(data.person);
						personProfile.setPersonId(data.person.id);
						if(!isNullOrEmpty(data.code)){
							personProfile.setTitle(data.code);
						}
						personProfile.getApplicationInfo()['applicationStatus']=data.currentStatus;
						personData = this$.getApplicantPersonalInfoFormValue(data.person);
						if(!isNullOrEmpty(personData.genderCSM) && !isNullOrEmpty(personData.genderCSM.id)){
							personData.genderCSM = personData.genderCSM.id;
						}
						if(!isNullOrEmpty(personData.currentOrLastSchoolAttended)){
							personData.currentOrLastSchoolAttended = personData.currentOrLastSchoolAttended;
						}
						if(!isNullOrEmpty(personData.idtype) && !isNullOrEmpty(personData.idtype.id)){
							personData.idtype = personData.idtype.id;
							if (personData.idtype.idTypeCode == 'NATIONAL_ID') {
								personalInformationForm.down("#identityExpiryDateItemId").setVisible(false);
								personalInformationForm.down("#identityExpiryDateItemId").allowBlank = true;
							} else {
								var isIdentityExpiryDateVisible = localStorage.getItem('identityExpiryDateIsVisible');
								var identityExpiryDateIsMendatory = localStorage.getItem('identityExpiryDateIsMendatory');
								 if(!isNullOrEmpty(isIdentityExpiryDateVisible) && isIdentityExpiryDateVisible){
									personalInformationForm.down("#identityExpiryDateItemId").setVisible(isIdentityExpiryDateVisible);
									if (!isNullOrEmpty(identityExpiryDateIsMendatory) && identityExpiryDateIsMendatory) {
										personalInformationForm.down("#identityExpiryDateItemId").allowBlank = false;
									}else{
										personalInformationForm.down("#identityExpiryDateItemId").allowBlank = true;
									}
								 }
							}
						}
						if(!isNullOrEmpty(personData.maritalStatusId) && !isNullOrEmpty(personData.maritalStatusId.id)){
							personData.maritalStatus = personData.maritalStatusId.id;
						}
						var advisorId = personalInformationForm.down('#advisorItemId');
			    		advisorId.setVisible(false);
			    		
			    		var advisorId = personalInformationForm.down('#advisorItemId');
			    		advisorId.setVisible(false);
			    		if(personData.supportDocument){
			    			personalInformationForm.down('#applicantDownloadURL').setValue(personData.supportDocument);
			    		}else{
			    			personalInformationForm.down('#applicantDownloadURL').setVisible(false);
			    		}
						 
						 
						// Check SA Validations
				        	personalInformationForm.down('#stuPermanentResItemId').items.items[0].setValue(false);
				        	personalInformationForm.down('#stuPermanentResItemId').items.items[1].setValue(false);
				    		
				        	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[0].setValue(false);
				        	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[1].setValue(false);
				    		
				        	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[0].setValue(false);
				        	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[1].setValue(false);
				        	
				        	 if(!isNullOrEmpty(personData.nationality)){
	                        		if(personData.nationality.code == 'South African'){
	                        			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
	                        			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
	                        			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);	
	                        		}
	                        	}
				        	 else{
				        		 nationalityField.getStore().load({
				  					  callback: function(records, operation, success) {
				  						  if (success) {
				  							  for(i in records){
				  								  if(records[i].data.whetherDefault || records[i].data.whetherDefault=="true"){
				  									nationalityField.setValue(records[i].data.id);  									  
				  								  }
				  							  }
				  						  }
				  					  }
				  				  });
				        	 }
	                        	
	                        	if(!isNullOrEmpty(personData.secondaryCitizenship)){
	                        		if(personData.secondaryCitizenship.code == 'South African'){
	                        			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
	                        			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
	                        			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);	
	                        		}
	                        	}
				        	
						if(personData.isWheelChairRequired == true){
							personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
							personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
						}

						if(personData.areYouRefugee == true){
							personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
							personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
						}else if (personData.areYouRefugee == false){
							personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
						}else{
							personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
						}

						if(personData.isAsylumSeeker == true){
							personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
							personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
						}else if(personData.isAsylumSeeker == false){
							personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
						}else{
							personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
						}

						if(personData.isPermanentResident == true){
							personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
							personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
						}else if(personData.isPermanentResident == false){
							personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
						}else{
							personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
						}

						if(personData.isTertiaryInstitution == true){
							personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
							personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
							personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
						}
						if(personData.isEnrolledTertiaryInstitute == true){
                         	 personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(true);
                         	 personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(false);
	                	 }else
	                	   {
	                		  personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(false);
	                		  personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(true);
	                	   }
						if(personData.isMilitarySponsored == true){
							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
						}
						if(personData.isMilitarySponsored == false){
							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
							personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
						}
						
						if(personData.isBursaryRequirements == true){
							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
						}
						if(personData.isBursaryRequirements == false){
							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
							personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
						}
						
						if(personData.diplomaticStatus == true){
							personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(true);
							personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(false);
							personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(true);
						}

						if(personData.temporaryStudy == true){
							personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(true);
							personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(false);
							personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(true);
						}
						
						if(personData.workCriticalSkills == true){
							personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
							personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
							personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
						}
						
						if(personData.postgraduateNonResidentialStudent == true){
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
						}else
						{
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
							personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
						}
						
						if(personData.pHDSponsor == 'DOD'){
							personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
							personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
						}
						if(personData.pHDSponsor == 'MYSELF'){
							personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
							personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
						}
						 if(personData.isAdult == true){
	                           	 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(true);
	                           	 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(false);
		                	   }else if(personData.isAdult == false)
		                	   {
		                		  personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(false);
	                        	  personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(true);
		                	   }
						 if(personData.isAutomateExchange == true){
                           	 personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(true);
                           	 personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(false);
 	                	   }else
 	                	   {
 	                		  personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(false);
                        	  personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(true);
 	                	   }
						 if(portalId==6)
							 {
							 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").setReadOnly(true);
							 }
						
						personalInformationForm.getForm().setValues(personData);
						if(!isNullOrEmpty(personData.identityExpiryDate)){
							personalInformationForm.down("#identityExpiryDateItemId").setValue(dateRender(personData.identityExpiryDate));
						} 
						personalInformationForm.down("#birthDateId").setValue(dateRender(personData.birthDate));
						personalInformationForm.down("#validTill").setValue(dateRender(personData.validTill));
						if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.currentEducationalInterventions) &&
								!isNullOrEmpty(data.person.currentEducationalInterventions.code) &&
								data.person.currentEducationalInterventions.code == 'OTHER') {
							var specifyOtherItemId = personalInformationForm.down("#specifyOtherItemId");
							specifyOtherItemId.setVisible(true);
							specifyOtherItemId.allowBlank = false;
							personalInformationForm.isValid();
						}
						if(!isNullOrEmpty(data.person.nationalID))
						{
							personalInformationForm.down("#verifyDetail").setDisabled(false);
						}else
						{
							personalInformationForm.down("#verifyDetail").setDisabled(true);

						}	
						  // V2D-146115 : removed 
						/*var isRegistrationContractItemId = personalInformationForm.down("#isRegistrationContractItemId");
						var isRegistrationContractContainerItemId = personalInformationForm.down("#isRegistrationContractContainerItemId");
						if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.isRegistrationContract) && data.person.isRegistrationContract) {
							isRegistrationContractItemId.setVisible(true);
							isRegistrationContractContainerItemId.setVisible(true);
						} else {
							isRegistrationContractItemId.setVisible(false);
							isRegistrationContractContainerItemId.setVisible(false);
						}
						var isRegistrationContractConditionItemId = personalInformationForm.down("#isRegistrationContractConditionItemId");
						var isRegistrationContractConditionContainerItemId = personalInformationForm.down("#isRegistrationContractConditionContainerItemId");
                        if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.isRegistrationContractCondition) && data.person.isRegistrationContractCondition) {
                        	isRegistrationContractConditionItemId.setVisible(true);
                        	isRegistrationContractConditionContainerItemId.setVisible(true);
                        } else {
                        	isRegistrationContractConditionItemId.setVisible(false);
                        	isRegistrationContractConditionContainerItemId.setVisible(false);
                        }*/
						
						var haveDisabilities = personalInformationForm.getForm().findField('haveDisabilities');
						var haveDisabilitiesStore = haveDisabilities.getStore();
						haveDisabilitiesStore.getProxy().extraParams={
							type:'HaveDisabilities'
						};
						if(personData.haveDisabilities == null) {
                			haveDisabilitiesStore.load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var haveDisabilitiesArray= [];
                						if(records.length > 0){
                							if(!isNullOrEmpty(personData.applicantPersonDisability) && personData.applicantPersonDisability.length > 0){
                							personData.applicantPersonDisability.forEach(function(disabilityObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === disabilityObj.haveDisabilities.id;
                									})[0];
                								haveDisabilitiesArray.push(result);
                							});
                							haveDisabilities.setValue(haveDisabilitiesArray);
                							}else{
                								this$.loadDefaultHaveDisabilitiesDFRValue(personalInformationForm,'personalinformationform')
                							}
                						}
                					}
                				}
                	        });
            			}
						
					/*	var schoolAttended = personalInformationForm.getForm().findField('currentOrLastSchoolAttended');                			
            			var schoolAttendedStore = schoolAttended.getStore();
            			if(personData.currentOrLastSchoolAttended == null){
            				schoolAttendedStore.load({
            					callback: function(records, operation, success) {
            						if (success) {
            							for(var i in records){
                							if(data.currentOrLastSchoolAttended!==null){
                								if(records[i].data.id==data.currentOrLastSchoolAttended.id){
                									currentOrLastSchoolAttended.setValue(records[i].data.id);
                								}
                							}
                						}
            						}
            					}
            				});
            			}*/
						
						
						var currentEducationalInterventions = personalInformationForm.getForm().findField('currentEducationalInterventions');                			
            			var educationalInterventionsStore = currentEducationalInterventions.getStore();
            			
            			if(!isNullOrEmpty(personData.applicantPersonEducationInterventions) && personData.applicantPersonEducationInterventions.length>=1){
            				
            				educationalInterventionsStore.load({
            					callback: function(records, operation, success) {
            						if (success) {
                						var educationalInterventionsArray= [];
                						if(records.length > 0){
                							personData.applicantPersonEducationInterventions.forEach(function(eduInterventionObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === eduInterventionObj.educationInterventions.id;
                									})[0];
                								educationalInterventionsArray.push(result);
                							});
                							currentEducationalInterventions.setValue(educationalInterventionsArray);
                						}
                					}
            					}
            				});
            			}
            			
            			if(personData.applicantPersonEducationInterventions.length == 0 && !isNullOrEmpty(personData.currentEducationalInterventions) && !isNullOrEmpty(personData.currentEducationalInterventions.id)){
            				
            				educationalInterventionsStore.load({
            					callback: function(records, operation, success) {
            						if (success) {
                						var educationalInterventionsArray= [];
                						if(records.length > 0){
                								var result = records.filter(function (obj) {
                							    return obj.data.id === personData.currentEducationalInterventions.id;
                								})[0];
                								educationalInterventionsArray.push(result);
                							currentEducationalInterventions.setValue(educationalInterventionsArray);
                						}
                					}
            					}
            				});
            			}
            			
            			if(!isNullOrEmpty(data.applicationOwner) && !isNullOrEmpty(data.applicationOwner.id)) 
           				{
            				var applicationOwnerField = personalInformationForm.getForm().findField("applicationOwner");
            				applicationOwnerField.getStore().load({
            					callback: function(records, operation, success) {
            						for(var i in records){
            							if(data.applicationOwner!==null){
            								if(records[i].data.id==data.applicationOwner.id){
            									applicationOwnerField.setValue(records[i].data.id);
            								}
            							}
            						}
            					}
            				});
           				}
						
						if(!isNullOrEmpty(personData.enquirySource) && !isNullOrEmpty(personData.enquirySource.id)) 
       				 {
       					 if(!isNullOrEmpty(personalInformationForm.down("#enquirySource"))){

       						 var enquirySourceField = personalInformationForm.down("#enquirySource");
       						 enquirySourceField.getStore().load({
       							 callback: function(records, operation, success) {
       								 for(var i in records){
       									 if(personData.enquirySource!==null){
       										 if(records[i].data.id==personData.enquirySource.id){
       											 enquirySourceField.setValue(records[i].data.id);
       										 }
       									 }
       								 }
       							 }
       						 });

       					 }
       				 }
						
						var applicantModeOfEnquiryField = personalInformationForm.getForm().findField("applicantModeOfEnquiry");
        				if(data.applicationEnquiryMultipleMode.length>0){
        					applicantModeOfEnquiryField.getStore().load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var applicantModeOfEnquiryArray= [];
                						if(records.length > 0){
                							data.applicationEnquiryMultipleMode.forEach(function(modeOfObj){
                								var result = records.filter(function (obj) {
                									  return obj.data.id === modeOfObj.enquiryMode.id;
                									})[0];
                								applicantModeOfEnquiryArray.push(result);
                							});
                							applicantModeOfEnquiryField.setValue(applicantModeOfEnquiryArray);
                						}
                					}
                				}
                	        });
        				}
            			
            			 if(!isNullOrEmpty(personalInformationForm.down("#applicantCampaign"))){

    						 var applicantCampaignField = personalInformationForm.down("#applicantCampaign");
    						 
    						 var campaignNewStore=applicantCampaignField.getStore();
                             	campaignNewStore.getProxy().extraParams = {
                             	academyLocationIds: this$.getCurrentAcademyLocation(),
                             	isActive: true
                             };
                             
                             if( !isNullOrEmpty(personData.campaignNew) && !isNullOrEmpty(personData.campaignNew.id) ){
                             	campaignNewStore.getProxy().extraParams.oldCampaignId = personData.campaignNew.id;
                             }
                             
                             Ext.defer(function() {
                             	campaignNewStore.load({
                             		scope:this,
                             		callback: function(records, operation, success) {

                             			if(!isNullOrEmpty(personData.campaignNew)){
                             				applicantCampaignField.setVisible(true);
                             				applicantCampaignField.setValue(personData.campaignNew.id);
                             				if( !isNullOrEmpty(personData.campaignSchool) ){
                             					this$.selectApplicantNewCampaignField(applicantCampaignField, personData.campaignNew.id, personData.campaignSchool.id);
                             				} else {
                             					this$.selectApplicantNewCampaignField(applicantCampaignField, personData.campaignNew.id, null);
                             				}
                             			}else if(isNullOrEmpty(personData.campaignNew) && !isNullOrEmpty(personData.campaignSchool)){
                             				//this$.selectApplicantNewCampaignField(applicantCampaignField, null, personData.campaignSchool.id);
                            				
                            				var schoolPriorityField = personalInformationForm.down("#applicantSchoolPriority");
                            				var schoolPriorityNewField = personalInformationForm.down("#schoolPriorityNew");
                            				schoolPriorityField.setVisible(false);
                            				this$.loadDFRForSchoolPriority(schoolPriorityNewField);   
                            				schoolPriorityNewField.setDisabled(false);
                            				schoolPriorityNewField.getStore().load({
           	        						  callback: function(record, operation, success) {
           	        							  if (success) {
           	        								  for(var i in record) {
           	        									  if(personData.applicantSchoolPriority!=null) {
           	        			    					  	if(record[i].data.id ==personData.applicantSchoolPriority) {
           	        			    					  	schoolPriorityNewField.setValue(record[i].data.id);
           	        			    					 	}
           	        		    					 	 }
           	        									  else {
           	        										schoolPriorityNewField.setValue(null);
           	        									  }
           	        								  }
           	        							  }
           	        						  }
           	        					  });
                            				
                            				  var campaignSchoolCombo = personalInformationForm.down("#applicantCampaignSchool");
                            				  var academyLocUrl = '';
                            				  academyLocUrl = this$.getCurrentAcademyLocation();
                            				  
                            				  var campaignSchoolStore = campaignSchoolCombo.getStore();
                            				  campaignSchoolStore.getProxy().extraParams = {					  
                            					campaigId:null,
                            					academyLocationIds:academyLocUrl,
                            					schoolId:personData.campaignSchool.id
                            				  };
                            				  campaignSchoolStore.removeAll();
                                              campaignSchoolCombo.reset();
                            				  
                            				  campaignSchoolStore.load({
                            					  callback: function(records, operation, success) {
                            						  for(var i in records){	
                            							  if(records[i].data.schoolId == personData.campaignSchool.id){
                            							  campaignSchoolCombo.setValue(records[i].data.schoolId);
                            							  }
                            						   }                                						                               					
                            					  }  
                            				  });
                            			
                             				
                             			}
                             			else if(isNullOrEmpty(personData.campaignNew) && isNullOrEmpty(personData.campaignSchool)){
                             				var schoolPriorityField = personalInformationForm.down("#applicantSchoolPriority");
                            				var schoolPriorityNewField = personalInformationForm.down("#schoolPriorityNew");
                            				schoolPriorityField.setVisible(false);
                            				this$.loadDFRForSchoolPriority(schoolPriorityNewField);   
                            			}
                             		}	
                             	});
                             });

    					 }
    				 
                         if(!isNullOrEmpty(personalInformationForm.down("#armsOfService"))){
                         	var armsOfService = personalInformationForm.down("#armsOfService");
                         	armsOfService.getStore().load({
                         		callback: function(records, operation, success) {
                         			if (success) {
                         				for(i in records){
                         					if(personData.armsOfService!==null){
                         						if(records[i].data.id==personData.armsOfService.id){
                         							var armsOfServiceId =  armsOfService.setValue(records[i].data.id);
                         							var mustering = personalInformationForm.getForm().findField('mustering');
                         							mustering.setDisabled(false);
                         							var musteringStore = mustering.getStore();
                         							musteringStore.getProxy().extraParams={
                         								armsOfServiceId:records[i].data.id
                         							};
                         							musteringStore.load({
                         								callback: function(records, operation, success) {
                         									for(i in records){
                         										if(personData.mustering!==null){
                         											if(records[i].data.id==personData.mustering.id){
                         												mustering.setValue(records[i].data.id);
                         											}
                         										}
                         									}

                         								}

                         							})
                         						}
                         					}
                         				}

                         			}
                         		}

                         	})
                         } 
                     	var mustering = personalInformationForm.getForm().findField('mustering');
                		this$.loadDFRForMusteringDFR(mustering);
            			 
	    				 if(!isNullOrEmpty(personData.campaignSchool) && !isNullOrEmpty(personData.campaignSchool.id)) 
	    				 {
	    					 if(!isNullOrEmpty(personalInformationForm.down("#applicantCampaignSchool"))){
	
	    						 var applicantCampaignSchoolField = personalInformationForm.down("#applicantCampaignSchool");
	    						 applicantCampaignSchoolField.getStore().load({
	    							 callback: function(records, operation, success) {
	    								 for(var i in records){
	    									 if(personData.campaignSchool!==null){
	    										 if(records[i].data.schoolId==personData.campaignSchool.id){
	    											 applicantCampaignSchoolField.setValue(records[i].data.schoolId);
	    										 }
	    									 }
	    								 }
	    							 }
	    						 });
	
	    					 }
	    				 }
	    				 var currentOrLastSchoolAttended = personalInformationForm.getForm().findField('currentOrLastSchoolAttended');  
	    				 if(!isNullOrEmpty(currentOrLastSchoolAttended)){
	                         	currentOrLastSchoolAttended.getStore().load({
	    							 callback: function(records, operation, success) {
	                         			if (success) {
	                         				for(i in records){
	                         					if(personData.currentOrLastSchoolAttended!==null){
	                         						if(records[i].data.id==personData.currentOrLastSchoolAttended.id){
	                         							currentOrLastSchoolAttended.setValue(records[i].data.schoolId);
	                         						}
	    										 }
	    									 }
	    								 }
	    							 }
	
	                         	})
	    					 }
	    					var consentedCommunicationChannel = personalInformationForm.getForm().findField('consentedCommunicationChannel');
                         	var consentedCommunicationChannelStore = consentedCommunicationChannel.getStore();
                         	consentedCommunicationChannelStore.getProxy().extraParams={
                 				type:'Communication Channel'
                 			};
                 			if(personData.consentedCommunicationChannel != null) {
                 				consentedCommunicationChannelStore.load({
 	                				callback: function(records, operation, success) {
 	                					if (success) {
 	                						var consentedCommunicationChannelArray= [];
 	                						if(records.length > 0){
 	                							if(!isNullOrEmpty(personData.consentedCommunicationChannel) && personData.consentedCommunicationChannel.length > 0){
 	                								personData.consentedCommunicationChannel.forEach(function(consentedCommunicationChannelObj){
 		                								var result = records.filter(function (obj) {
 		                									  return obj.data.id === consentedCommunicationChannelObj.communicationChannel.id;
 		                									})[0];
 		                								consentedCommunicationChannelArray.push(result);
 		                							});
 	                								consentedCommunicationChannel.setValue(consentedCommunicationChannelArray);
 	                							}
 	                						}
 	                					}
 	                				}
 	                	        });
                 			}
                 			
                 			if(!isNullOrEmpty(personData.consentStatementAccepted)){
                        		personalInformationForm.down("#consentStatementAccepted").setValue(personData.consentStatementAccepted);
                        	}
                        	
                 			personalInformationForm.down('#imageMarketingCheckbox').setValue(personData.imageMarketingCheckbox);
                 			if(!isNullOrEmpty(personData.imageMarketingCheckbox)){
                 			if(personData.imageMarketingCheckbox == true){
                              	 personalInformationForm.down("#imageMarketingCheckbox").items.items[0].setValue(true);
                              	 personalInformationForm.down("#imageMarketingCheckbox").items.items[1].setValue(false);
   	                	   	}else if(personData.imageMarketingCheckbox == false){
   	                		  personalInformationForm.down("#imageMarketingCheckbox").items.items[0].setValue(false);
                           	  personalInformationForm.down("#imageMarketingCheckbox").items.items[1].setValue(true);
   	                	   	}
                 			}
	    				 
	    				 }
					var emplang = this$.getEmployeeLanguageValue(personData);
					if( personalInformationForm != null ){
                		var countryCodeFieldItemIDArray = ["#phoneCountryCode","#cellCountryCode","#alternateCellCountryCode"];
                		this$.setDefaultCountryCode(personalInformationForm, countryCodeFieldItemIDArray);
                		var countryCodeField = personalInformationForm.down("#cellCountryCode");
                     	var mobileField = personalInformationForm.down("#mobileNumber");
                     	this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
                     	var countryCodeField = personalInformationForm.down("#alternateCellCountryCode");
                     	var mobileField = personalInformationForm.down("#alternateMobileNumber");
                     	this$.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
					}
					this$.loadDefaultHomeLanguageDFRValue(personalInformationForm,'personalinformationform');
				
				}        		
			});
		}
	} 
	
	
},


/**
 * @author Swapnil Patil
 */
setApplicantUploadedPhoto:function(downloadUrl){
	var this$ = this;
	var personProfile  = this$.getContentPanel().items.items[0];
	var personId = this$.getContentPanel().items.items[0].getPersonId();

	if(!isNullOrEmpty(personId)){
		Ext.Ajax.request({
			type: 'rest',
			binary: true,
			url: downloadUrl+'?personId='+personId,
			method: 'GET',
			success : function(response){
				if(response.responseBytes.length>0){
					var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
					var url = window.URL.createObjectURL(blob);
					
					// set summary screen photo
					var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
					var a=personProfile.down("#profile_image");
					a.getEl().dom.src=url;
					a.setVisible(true);

					// set Applicant user info icon
					var authController=Academia.app.getController('Academia.controller.authentication.AuthenticationController');
					var userInfo=authController.getUserInfo();
					var fimg = userInfo.down('#userInfoButton');
					fimg.setIcon(url);
					fimg.setVisible(true);
				}
			}

		});
	}
},
exportPDFParentGuardianReportForApplicant : function(){
  	var this$ = this;
  	var personProfile = this$.getContentPanelActiveTab();
  	var personId;
  	var applicationId;
  	var portalId = this$.getCurrentLoggedPortalId();
  	try{
  		personId = personProfile.getPersonId();
  		applicationId = personProfile.applicationId;
  	}catch(e){
  		personId = this$.getContentPanel().items.items[0].getPersonId();
  		applicationId = this$.getContentPanel().items.items[0].applicationId;
  	}
	var code = 'PARENT_GUARDIAN_REPORT_PDF';
	var reportParams =new Object();
	reportParams.personId = personId;
	reportParams.headerName = 'Parent Guardian  Report';
	var reportTitle="Parent Guardian  Report";
	if(portalId==6 || portalId==1){
		this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_PDF_REPORT_APPLICANT);
	}else{
		this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_PDF_REPORT);
	}
	
	
},
exportXLParentGuardianReportForApplicant : function(){
	var this$ = this;
	var personProfile = this$.getContentPanelActiveTab();
	var personId;
	var applicationId;
	var portalId = this$.getCurrentLoggedPortalId();
	try{
		personId = personProfile.getPersonId();
		applicationId = personProfile.applicationId;
	}catch(e){
		personId = this$.getContentPanel().items.items[0].getPersonId();
		applicationId = this$.getContentPanel().items.items[0].applicationId;
	}
	var code = 'PARENT_GUARDIAN_REPORT_EXCEL';
	var reportParams =new Object();
	reportParams.personId = personId;
	reportParams.headerName = 'Parent Guardian  Report';
	var reportTitle="Parent Guardian  Report";
	if(portalId==6 || portalId==1){
		this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_EXCEL_REPORT_APPLICANT);
	}else{
		this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_EXCEL_REPORT);
	}

},
onChangeIsAlumnus : function(parentGuardianForm){
	var $this = this;
	var getForm =   parentGuardianForm.getForm();
	var isAlumnusValue = getForm.findField('isAlumnus').getValue();
	var schoolAttendedField = parentGuardianForm.down('#schoolAttended');
	if(isAlumnusValue){
		$this.loadDFRForParentGuardianOnChange(schoolAttendedField);
	}
	else{
		schoolAttendedField.setVisible(false);
		schoolAttendedField.allowBlank = true;
		parentGuardianForm.down('#submitButtonId').setDisabled(false);
	}
},
selectApplicantNewCampaignField: function(obj, campaignNewId, campaignSchoolId){
	  var form = obj.up('form');
	  var campaignSchoolCombo = form.down("#applicantCampaignSchool");
	  var campaignTypeField = form.down("#applicantCampaignType");
	  var presentationTypeField = form.down("#applicantPresentationType");
	  var schoolPriorityField = form.down("#applicantSchoolPriority");
	  schoolPriorityField.reset();
	  var $this = this;
	  var campSchoolId = campaignSchoolId;
	  var schoolPriority = '';
	  var academyLocUrl = '';
	  academyLocUrl = this.getCurrentAcademyLocation();
	  
	  if(!isNullOrEmpty(campaignNewId)){
		  campSchoolId = null;
	  }
	  
	  if(campaignNewId!=null){
	  var url = SERVERURL.PATH_CAMPAIGN_DEATIL_BY_ID +"?campaignId="+campaignNewId;
	  Ext.Ajax.request({
		  type: 'rest',
		  url: url,
		  method: 'GET',
		  success: function(response) {
			  if(response.responseText != null && response.responseText != ""){
				  var responseData = Ext.JSON.decode(response.responseText);
				  if( !isNullOrEmpty(campaignTypeField) && !isNullOrEmpty(responseData.campaignType) ){
					  campaignTypeField.setValue(responseData.campaignType);
				  }
				  if( !isNullOrEmpty(presentationTypeField) && !isNullOrEmpty(responseData.presentationType) ){
					  presentationTypeField.setValue(responseData.presentationType);
				  }
		  		}
		     }
	  });
	 }
	  var campaignSchoolStore = campaignSchoolCombo.getStore();
	  campaignSchoolStore.getProxy().extraParams = {					  
		campaigId:campaignNewId,
		academyLocationIds:academyLocUrl,
		schoolId:campSchoolId
	  };
	  campaignSchoolStore.removeAll();
      campaignSchoolCombo.reset();
	  
	  campaignSchoolStore.load({
		  callback: function(records, operation, success) {
			  for(var i in records){							  
				  campaignSchoolCombo.setValue(records[i].data.schoolId);
				  if(campaignSchoolId == records[i].data.schoolId && !isNullOrEmpty(records[i].data.schoolPriority))
					  schoolPriority = records[i].data.schoolPriority.value;
			  }
			
			  if(records.length!=0){
				 
				  if( records.length!=1 ){
					  $this.setAllowBlank(campaignSchoolCombo,false);
					  campaignSchoolCombo.select(campaignSchoolId);
					  schoolPriorityField.setValue(schoolPriority);
				  }
			  }
			  if( !isNullOrEmpty(records) && records.length == 1 ){
				  campaignSchoolCombo.select(records[0].data.schoolId);
				  if(!isNullOrEmpty(records[0].data.schoolPriority)){
				  schoolPriorityField.setValue(records[0].data.schoolPriority.value);
				  }
			  }
		  }  
	  });
},
selectApplicantCampaignSchoolField: function(obj, campaignNewId, campaignSchoolId, enquiryId, enquiryAcademyLocationId){
	var form = obj.up('form');
	var schoolPriorityField = form.down("#applicantSchoolPriority");
	var url='';	        	
	if(campaignNewId==null){
		url = SERVERURL.CAMPAIGN_NEW_DETAILS + "?schoolId="+campaignSchoolId+"&limit="+25;
	}else{
		url = SERVERURL.CAMPAIGN_NEW_DETAILS + "?campaigId="+campaignNewId+"&schoolId="+campaignSchoolId;
		if( !isNullOrEmpty(enquiryId) && enquiryId > 0 ){
			url = url+"&academyLocationIds="+this.getCurrentAcademyLocation()+","+enquiryAcademyLocationId;
		}
	}
	Ext.Ajax.request({
		type: 'rest',
		url: url,
		method: 'GET',
		success: function(response) {
			var data = Ext.decode(response.responseText);
			if( !isNullOrEmpty(data) && data.length!=0 ){
				if( !isNullOrEmpty(data[0].schoolPriority) ){
					var schoolPriority = data[0].schoolPriority.value;
					schoolPriorityField.setValue(schoolPriority);
				}
			}
		}
	});
},
loadDFRForIDTypeVisibility: function(idTypeField, uploadDocField, uploadDocURL){
	var $this = this;
	Ext.Ajax.request({
		type: 'rest',
		async: false,
		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		params: {
			screenName: 'personalinformationform',
			academyLocationId: this.getCurrentAcademyLocation(),
			languageCode:'en'
		},
		method: 'GET',
		success: function(res, action) {
			var response = Ext.decode(res.responseText);
			if( Object.keys(response).length > 0 ){
				var records=response.personalinformationform;
				for(i in records){    					
					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='idTypeCombo' && records[i].isVisible==true){
						idTypeField.setVisible(true);
					}
					if(records[i].formFieldInputType=='filefield' && records[i].formFieldId=='documentFileUpload' && records[i].isVisible==true){
						uploadDocField.setVisible(true);
					}
					if(records[i].formFieldInputType=='displayfield' && records[i].formFieldId=='applicantDownloadURL' && records[i].isVisible==true){
						uploadDocURL.setVisible(true);
					}
				}
			}else{
				if(idTypeField!=null){
					idTypeField.setVisible(true);
				}
				if(uploadDocURL!=null){
					uploadDocURL.setVisible(true);
				}
				if(uploadDocField!=null){
					uploadDocField.setVisible(true);
				}
			}
		}
		
	});
	
},
checkEmployeeIdDfr: function(empOfTheOrg,employeeId){
  	var $this = this;
  	var result = false;
  	var status = 0;
  	var radioGroupStatus = empOfTheOrg.getValue().employeeOfOrganization;
	Ext.Ajax.request({
		type: 'rest',
		async: false,
		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		params: {
			screenName: 'feepayerdetailform',
			academyLocationId: this.getCurrentAcademyLocation(),
			languageCode:'en'
		},
		method: 'GET',
		success: function(res, action) {
			var response = Ext.decode(res.responseText);
			if( Object.keys(response).length > 0 ){
				var records=response.feepayerdetailform;
				for(i in records){
					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isMandatory==true){
						employeeId.allowBlank = false;
						status = 1;
						result = true;
					}else{
						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isMandatory==false){
							employeeId.allowBlank = true;
							result = true;
						}
					}
					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isVisible==true){
						employeeId.setVisible(true);
						result = true;
						if(radioGroupStatus==true) {
							employeeId.setVisible(true);
						}
						else {
							employeeId.reset();
							employeeId.setVisible(false);
							if(status==1) {
								employeeId.allowBlank = true;
							}
						}
					}else{
						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isVisible==false){
							employeeId.reset();
							employeeId.allowBlank = true;
							employeeId.setVisible(false);
							result = true;
						}
					}
				}
			}else{
				return result;
			}
		}
		
	});
	return result;
},
checkApplicantHostelRequirementDfr: function(form){
  	var $this = this;
  	var isHostelRequired = form.down('#isHostelRequired');
  	var dietaryRequirementsItemId = form.down('#dietaryRequirementsItemId');
  	var foodAllergiesItemId = form.down('#foodAllergiesItemId');
  	var sleepingDisorderItemId = form.down('#sleepingDisorderItemId');
  	var anyMedicalNeedsOrSomethingItemId = form.down('#anyMedicalNeedsOrSomethingItemId');
  	var applicantHostelDetailsId = form.down('#applicantHostelDetailsId');
  	var applicantHostelDetailsId1 = form.down('#applicantHostelDetailsId1');
  	var applicantHostelDetailsId2 = form.down('#applicantHostelDetailsId2');
  	var applicantHostelDetailsId3 = form.down('#applicantHostelDetailsId3');
  	applicantHostelDetailsId1.setVisible(false);
  	applicantHostelDetailsId2.setVisible(false);
  	applicantHostelDetailsId3.setVisible(false);
  	
  	var hostelStatus = isHostelRequired.getValue();
	Ext.Ajax.request({
		type: 'rest',
		async: false,
		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		params: {
			screenName: 'personhostelrequirementform',
			academyLocationId: this.getCurrentAcademyLocation(),
			languageCode:'en'
		},
		method: 'GET',
		success: function(res, action) {
			var response = Ext.decode(res.responseText);
			if( Object.keys(response).length > 0 ){
				var records=response.personhostelrequirementform;
				for(i in records){
					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='dietaryRequirementsItemId' && records[i].isMandatory==true && records[i].isVisible==true){
						if(hostelStatus) {
							dietaryRequirementsItemId.allowBlank = false;
						}
						else {
							dietaryRequirementsItemId.allowBlank = true;
						}
					}else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='foodAllergiesItemId' && records[i].isMandatory==true && records[i].isVisible==true){
						if(hostelStatus) {
							foodAllergiesItemId.allowBlank = false;
						}
						else {
							foodAllergiesItemId.allowBlank = true;
						}
					}else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='sleepingDisorderItemId' && records[i].isMandatory==true && records[i].isVisible==true){
						if(hostelStatus) {
							sleepingDisorderItemId.allowBlank = false;
						}
						else {
							sleepingDisorderItemId.allowBlank = true;
						}
					}else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='anyMedicalNeedsOrSomethingItemId' && records[i].isMandatory==true && records[i].isVisible==true){
						if(hostelStatus) {
							anyMedicalNeedsOrSomethingItemId.allowBlank = false;
						}
						else {
							anyMedicalNeedsOrSomethingItemId.allowBlank = true;
						}
					}else if(records[i].formFieldInputType=='multiselectcombofield' && records[i].formFieldId=='applicantHostelDetailsId' && records[i].isMandatory==true && records[i].isVisible==true){
						if(hostelStatus) {
							applicantHostelDetailsId.allowBlank = false;
						}
						else {
							applicantHostelDetailsId.allowBlank = true;
						}
					}else if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='applicantHostelDetailsId1' && records[i].isVisible==true){
						if(hostelStatus) {
							applicantHostelDetailsId1.setVisible(true);
						}
						else {
							applicantHostelDetailsId1.setVisible(false);
						}
					}else if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='applicantHostelDetailsId2' &&  records[i].isVisible==true){
						if(hostelStatus) {
							applicantHostelDetailsId2.setVisible(true);
						}
						else {
							applicantHostelDetailsId2.setVisible(false);
						}
					}else if(records[i].formFieldInputType=='nestedJsonCombo' && records[i].formFieldId=='applicantHostelDetailsId3' &&  records[i].isVisible==true){
						if(hostelStatus) {
							applicantHostelDetailsId3.setVisible(true);
						}
						else {
							applicantHostelDetailsId3.setVisible(false);
						}
					}else{
						
					}
				}
			}else {
				applicantHostelDetailsId1.setVisible(true);
				applicantHostelDetailsId2.setVisible(true);
				applicantHostelDetailsId3.setVisible(true);
			}
		}
	});},

/**
 *  Get person current address detail data
 *  @param url,form,isCurrent
 */
getPersonCurrentAddressDetail : function(form,url,isCurrent) {
    var this$ = this;   
    var form$ = form;
	var addressText = form.down('#addressTextArea');
	var addressTextInOrderLang = form.down('#addressTextAreaOtherLangId');
	var country = form.down('#countryId');
	var countryRegion = form.down('#parentCountryRegionId');
	var city = form.down('#cityId');
	var pincode = form.down('#pincodeId');
	
	if(isCurrent || isCurrent == true){
	 var personObj = this$.getPersonObj();
	 var personId = personObj["id"];
  	 var params = {
			personId : personId
			}; 
	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
    	if(success){
    		Ext.getBody().unmask();
    		result = Ext.decode(response.responseText);  
    		
    		if(result.address!=null){
    		addressText.setValue(result.address.addressText);	
    		
    		if(result.address.addressTextOtherLanguage!=null){
    			addressTextInOrderLang.setValue(result.address.addressTextOtherLanguage);	
    		}
    		
			if(result.address.country!=null){
			country.setValue(result.address.country.id);
			countryRegion.setDisabled(false);
    		var countryRegionStore = countryRegion.getStore();
            countryRegionStore.getProxy().extraParams = {
                cid: result.address.country.id
            };
            countryRegionStore.load();
			}
			
			if(result.address.parentCountryRegion!=null){
            countryRegion.setValue(result.address.parentCountryRegion.id);
            city.setDisabled(false);
            
            var cityStore = city.getStore();
            cityStore.getProxy().extraParams = {
                id: result.address.parentCountryRegion.id
            };
            cityStore.load();
			}
			
			if(result.address.city!=null){
            city.setValue(result.address.city.id);
			}else{
				  addressText.reset();
				  country.reset();
				  countryRegion.reset();
				  city.reset();
				  pincode.reset();
			}
            
			pincode.setValue(result.address.pincode);			
			
    		}
    		Ext.defer(function(){
    		  form$.getForm().checkValidity();
    		},2500)
    	}    	
	});
	}
},
			setDfrOnFeePayerDetailsForm : function(obj){
				var $this = this,form=obj;
				var result = false;
				Ext.Ajax.request({
					type: 'rest',
					async: false,
					url: SERVERURL.COMMON_FORM_FIELD_INFO,
					params: {
						screenName: 'feepayerdetailform',
						academyLocationId: this.getCurrentAcademyLocation(),
						languageCode:'en'
					},
					method: 'GET',
					success: function(res, action) {
						var response = Ext.decode(res.responseText);
						if( Object.keys(response).length > 0 ){
							var records=response.feepayerdetailform;
							for(i in records){
								if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='payerTypeItemId'){
									if(records[i].defaultValue!=null){
										var defaultValue = records[i].defaultValue.toUpperCase();
										if(defaultValue=='CORPORATE'){
											result=true;
										}
									}
								}
								if(records[i].formFieldInputType=='filefield' && records[i].formFieldId=='feePayerIDItemId' && records[i].isVisible==false){
									var fieldCmp = form.down('#'+records[i].formFieldId);
									$this.setAllowBlank(fieldCmp,true); 
								}
							}
						}
					}
				});
				if(result==true){
					$this.setDfrValueOfPersonalDetailsForm(obj);
				}
			},
			
			setDfrValueOfPersonalDetailsForm : function(obj){
				var this$ = this;
				obj.down('#payerTypeItemId').setValue({payerType:'CORPORATE'});
 },
 loadDFRForSchoolPriority: function(schoolPriorityField){
   	var $this = this;
   	Ext.Ajax.request({
   		type: 'rest',
   		async: false,
   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
   		params: {
   			screenName: 'personalinformationform',
   			academyLocationId: this.getCurrentAcademyLocation(),
   			languageCode:'en'
   		},
   		method: 'GET',
   		success: function(res, action) {
   			var response = Ext.decode(res.responseText);
   			if( Object.keys(response).length > 0 ){
   				var records=response.personalinformationform;
   				for(i in records){
   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='applicantSchoolPriority' && records[i].isVisible==false){
   						schoolPriorityField.setVisible(false);
   					}
   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='schoolPriorityNew' && records[i].isVisible==true){
   						schoolPriorityField.setVisible(true);
   					}
   				}
   			}else{
   				schoolPriorityField.setVisible(true);
   			}
   		}
   		
   	});
   	
 },
 loadDFRForMusteringDFR: function(mustering){
	   	var $this = this;
	   	Ext.Ajax.request({
	   		type: 'rest',
	   		async: false,
	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	   		params: {
	   			screenName: 'personalinformationform',
	   			academyLocationId: this.getCurrentAcademyLocation(),
	   			languageCode:'en'
	   		},
	   		method: 'GET',
	   		success: function(res, action) {
	   			var response = Ext.decode(res.responseText);
	   			if( Object.keys(response).length > 0 ){
	   				var records=response.personalinformationform;
	   				for(i in records){
	   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='armsOfService' && records[i].isVisible==false){
	   						mustering.setVisible(false);
	   						mustering.allowBlank= true;
	   					}
	   					
	   				}
	   			}
	   		}
	   		
	   	});
	   	
	 },
 SAValueValidationOnPersonalForm:function(form,value){
	   var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
	   var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
	   var diplomaticStatusId = form.down("#diplomaticStatusId");
	   var temporaryStudyId = form.down("#temporaryStudyId");
	   var workCriticalSkillsId = form.down("#workCriticalSkillsId");
	   var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
	   if(!isNullOrEmpty(value)){
  			 if(value==true){
      			 stuAsylumSeekerItemId.items.items[0].setValue(false);
      			 stuAsylumSeekerItemId.items.items[1].setValue(true);
      			 stuAreYouRefugeeItemId.items.items[0].setValue(false);
      			 stuAreYouRefugeeItemId.items.items[1].setValue(true);
      			 stuAsylumSeekerItemId.setDisabled(true);
     			 stuAreYouRefugeeItemId.setDisabled(true);
     			 
     			diplomaticStatusId.setDisabled(true);
     			temporaryStudyId.setDisabled(true);
     			workCriticalSkillsId.setDisabled(true);
     			postgraduateNonResidentialStudentId.setDisabled(true);
      		 }
  			 else{
  					stuAsylumSeekerItemId.setDisabled(false);
	      			stuAreYouRefugeeItemId.setDisabled(false);
	      			
	      			diplomaticStatusId.setDisabled(false);
	      			temporaryStudyId.setDisabled(false);
	      			workCriticalSkillsId.setDisabled(false);
	      			postgraduateNonResidentialStudentId.setDisabled(false);
      		 }
	   }
   },
   
   loadDefaultHaveDisabilitiesDFRValue : function(form, formAlias){
	   var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	   var	formFieldsInfo = fieldInfo.get("formFieldsInfo");	
	   var formfields = formFieldsInfo[formAlias];
	   if(formfields != undefined){
		   for(var i in formfields){
			   if(formfields[i].formAliasName == formAlias){
				   var formFieldName = formfields[i].formFieldName;
				   var formFieldVisiable = formfields[i].isVisible;
				   var formAliasName = formfields[i].formAliasName;
				   if(formAliasName==formAlias && formFieldName =="haveDisabilities" && !isNullOrEmpty(formfields[i].defaultValue)){
					   form.down('#haveDisabilities').setValue(parseInt(formfields[i].defaultValue));
				   }
			   }
		   }
	   }
   },
   loadDefaultHomeLanguageDFRValue : function(form, formAlias){
	   var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	   var	formFieldsInfo = fieldInfo.get("formFieldsInfo");	
	   var formfields = formFieldsInfo[formAlias];
	   if(formfields != undefined){
		   for(var i in formfields){
			   if(formfields[i].formAliasName == formAlias){
				   var formFieldName = formfields[i].formFieldName;
				   var formFieldVisiable = formfields[i].isVisible;
				   var formAliasName = formfields[i].formAliasName;
				   if(formAliasName==formAlias && formFieldName =="homeLanguage" && !isNullOrEmpty(formfields[i].defaultValue)){
					   form.down('#homeLanguage').setValue(parseInt(formfields[i].defaultValue));
				   }
			   }
		   }
	   }
   },
   loadDefaultHaveDisabilitiesDFRValue : function(form, formAlias){
	   var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	   var	formFieldsInfo = fieldInfo.get("formFieldsInfo");	
	   var formfields = formFieldsInfo[formAlias];
	   if(formfields != undefined){
		   for(var i in formfields){
			   if(formfields[i].formAliasName == formAlias){
				   var formFieldName = formfields[i].formFieldName;
				   var formFieldVisiable = formfields[i].isVisible;
				   var formAliasName = formfields[i].formAliasName;
				   if(formAliasName==formAlias && formFieldName =="haveDisabilities" && !isNullOrEmpty(formfields[i].defaultValue)){
					   form.down('#haveDisabilities').setValue(parseInt(formfields[i].defaultValue));
				   }
			   }
		   }
	   }
   },
   
  
   getApplicantAddressPrivilege : function() {
	   var addressDetails = this.getPersonAddressDetails();
	   if(portalId == 6){
		   var permissionList = this.getAPPLICANT_PORTAL_CONTACTDETAILS_PERMISSION();
	   }else{
		   var permissionList = this.getAPPLICATION_APPLICANT_ADDRESS_PERMISSION();
	   }
	   this.disableApplicantDisplyAddressPrivilege(addressDetails, permissionList);
   },
   getLocationDetailsByProgram : function() {
	   var lacationArray = new Array();
	   var items = this$.getContentPanelActiveTab().down('#selectionSnapShotGrid').getStore().data.items;
	   Ext.each(items, function(item) {
		   lacationArray.push(item.data.location.id);
	   });
	   return lacationArray;
   },
   setPrintNameOtherLnguageValue:function(textfield){
	var this$ = this;
   	var form = textfield.up('form');
   	var getForm=form.getForm();
   	var firstName = getForm.findField('firstNameOtherLanguage').getValue();
   	var middleName = getForm.findField('middleNameOtherLanguage').getValue();
   	var lastName = getForm.findField('lastNameOtherLanguage').getValue();
   	
   	if(portalId==6){
		var personProfile =applicationStatus=this$.getContentPanel().items.items[0];	
	}else{
		var personProfile = this$.getContentPanelActiveTab();	
	}
	if(Ext.isDefined(personProfile.getApplicationDataObject)){
	var data =  personProfile.getApplicationDataObject();
	} 
	var printName=null;
	if(isNullOrEmpty(middleName)){
		if(!isNullOrEmpty(lastName)){
			printName =firstName+" "+lastName;
		}else{
			printName =firstName;
		}
	}else{
		if(!isNullOrEmpty(lastName)){
			printName =firstName+" "+middleName+" "+lastName ;
		}else{
			printName =firstName+" "+middleName;
		}
	}
	printName=printName.trim();
	
		if(Ext.isDefined(data) && !isNullOrEmpty(data)){
			if(!isNullOrEmpty(data.printNameOtherLanguage) && !isNullOrEmpty(data.shortNameOtherLanguage)){
				getForm.findField('printNameOtherLanguage').setValue(data.printNameOtherLanguage.replace(/ +/g, " "));
        		getForm.findField('shortNameOtherLanguage').setValue(data.firstNameOtherLanguage.replace(/ +/g, " "));
			}else{
    			getForm.findField('printNameOtherLanguage').setValue(printName);
    			getForm.findField('shortNameOtherLanguage').setValue(firstName);
    		}
		}else{
			getForm.findField('printNameOtherLanguage').setValue(printName);
			getForm.findField('shortNameOtherLanguage').setValue(firstName);
		}
   },
   setDFRForCorporateType: function(corporateId,companySponcerLetter,sponsorItemId) {
	   Ext.Ajax.request({
		   url: SERVERURL.COMMON_FORM_FIELD_INFO,
		   method: 'GET',
		   async: false,
		   params: {
			   screenName: 'feepayerdetailform',
			   academyLocationId: this.getCurrentAcademyLocation(),
			   languageCode:'en'
		   },
		   success: function(res) {
			   var response = Ext.decode(res.responseText);
			   if( Object.keys(response).length > 0 ){
				   var records=response.feepayerdetailform;
				   for(i in records){    					
					   if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='corporateId' && records[i].isVisible==true){
						   corporateId.setVisible(true);
					   }
					   if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='corporateId' && records[i].isMandatory==true){
						   corporateId.allowBlank = false;
					   }
					   if(records[i].formFieldId=='companySponsorLetterItemId' && records[i].isVisible==false){
						   companySponcerLetter.setVisible(false);
					   }
					   if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='sponsorItemId' && records[i].isVisible==true){
						   sponsorItemId.setVisible(true);
					   }
					   if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='sponsorItemId' && records[i].isMandatory==true){
						   sponsorItemId.allowBlank = false;
					   }
				   }
			   }else{
				   if(corporateId!=null){
					   corporateId.setVisible(true);
					   corporateId.allowBlank = true;
				   }
			   }
		   }
	   });

   },
   setDFRForCompanyNameContactPerson: function(companyNameItemId,contactPersonItemId,sponsorItemId) {
	   Ext.Ajax.request({
		   url: SERVERURL.COMMON_FORM_FIELD_INFO,
		   method: 'GET',
		   async: false,
		   params: {
			   screenName: 'feepayerdetailform',
			   academyLocationId: this.getCurrentAcademyLocation(),
			   languageCode:'en'
		   },
		   success: function(res) {
			   var response = Ext.decode(res.responseText);
			   if( Object.keys(response).length > 0 ){
				   var records=response.feepayerdetailform;
				   for(i in records){    					
					   if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='companyNameItemId' && records[i].isVisible==true){
						   companyNameItemId.setVisible(true);
					   }
					   if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='companyNameItemId' && records[i].isMandatory==true){
						   companyNameItemId.allowBlank = false;
					   }
					   if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='contactPersonItemId' && records[i].isVisible==true){
						   contactPersonItemId.setVisible(true);
					   }
					   if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='contactPersonItemId' && records[i].isMandatory==true){
						   contactPersonItemId.allowBlank = false;
					   }
					   if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='sponsorItemId' && records[i].isVisible==true){
						   sponsorItemId.setVisible(true);
					   }
					   if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='sponsorItemId' && records[i].isMandatory==true){
						   sponsorItemId.allowBlank = false;
					   }
				   }
			   }else{
				   if(companyNameItemId!=null){
					   companyNameItemId.setVisible(true);
					   companyNameItemId.allowBlank = true;
				   }
				   if(contactPersonItemId!=null){
					   contactPersonItemId.setVisible(true);
					   contactPersonItemId.allowBlank = true;
				   }
			   }
		   }
	   });

   },
   loadProgramLocationDropDown: function(locationDropDown, form) {
	   var this$ = this;
	   var addButton =  form.down('#btnAddHostelPreference0');
		var profile = this$.getContentPanelActiveTab();
		var programData = profile.applicationDataObject.applicationPrograms;
		 var batchIds=[];
		 Ext.each(programData, function(program) {
			 batchIds.push(program.batch.id);
     	});
		locationDropDown.getStore().load({
			params: {
				applicationID: profile.applicationId,
				batchIds: batchIds.join()
	   		},
			 callback: function(records, operation, success) {
				  if (records.length > 1) {
					addButton.setVisible(true);
			}
			   }
		 })
   },
   setWaitingListTypeToHostel : function(form, modeOfObj){
	   var waitingListTypeCombo = form.getForm().findField('waitingListType');
	   waitingListTypeCombo.getStore().load({
		   callback: function(records, operation, success) {
			   if (success) {
				   for(i in records){
					   if(records[i].data.id == modeOfObj.waitingListType.id){
						   waitingListTypeCombo.setValue(records[i].data.id);  									  
					   }
				   }
			   }
		   }
	   });
   },
   getEmployeeLanguageValue: function(personData) {
       var this$ = this;
       var personProfile = this$.getContentPanelActiveTab();
   	var createcourseform = personProfile.down('#applicantPersonalInformationForm');
       
      
		var panelContiner = createcourseform.down('#serviceStopPanelId');
		var indx = 0;
		if(personData.languageCompetency.length>0){
			panelContiner.removeAll();
			var record=personData.languageCompetency;
			personData.languageCompetency.forEach(function(obj){
				var panelItem = new Array();
				var departmentId =obj.multiLanguage.employeeLanguage;
				var multiLanguage =obj.multiLanguage.id;
				var read =	obj.read.id;
				var speak =obj.speak.id;
				var write =	obj.write.id;
				var langId=obj.id
				var weightage = obj.weightage;
				if(panelContiner.items.length == 0){
					panelItem.push({
						plugins: "formlabelrequired",
						xtype : 'fieldcontainer',
						layout : 'hbox',
						width: '100%',
						scope: this$,
						defaults : {
							labelAlign : 'top',
							//width: '100%'
						},
						items:[{
							xtype: 'hidden',
							itemId:'langItemId',
							name: 'langId',
							value: langId
					},{
							xtype: 'customcombobox',
							width: 226,
							name: 'employeeLanguage',
							itemId : 'employeeLanguage',
							fieldLabel:getCommonTranslation('LANGUAGE'),
							store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
							valueField: 'id',
							displayField: 'value',
							editable: false,
							typeAhead: false,
							//queryParam:'qry',
							rowIndx:indx,
							forceSelection:true,
							//allowBlank:false,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								}
								
							},
							listeners:{
								render: function(combo){
									var cDepartmentStore= combo.getStore();
									cDepartmentStore.getProxy().extraParams = {
										limit:-1
									};
									cDepartmentStore.load({
										callback:function(record, operation, success){
											combo.setValue(multiLanguage);
										}
									});
								},
								select:function(obj,rec,value){
									var departmentId=rec[0].get('id');
									var flag = true;
									var pnlMain = obj.up("#serviceStopPanelId");
									var rowIndx = obj.rowIndx;
									if(!isNullOrEmpty(pnlMain)){
										pnlMain.items.each(function(item, index, items) {
											var deptNameVal = item.down("[name=employeeLanguage]").getValue();
											if(departmentId == deptNameVal && rowIndx != index){
												flag = false;
					        					return false;
											}
										});
										
										if(flag){
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											if (departmentId > 0) {
												var writeStore=write.getStore();
												var speakStore=speak.getStore();
												
												var store=nextSiblingField.getStore();
												store.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												store.load();
												writeStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												writeStore.load();
												speakStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												speakStore.load();
											}
										}
										else{
											obj.reset();
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
											return false;
										}
									}
								}
								
							}
						},
						{
							xtype: 'customcombobox',
							name: 'read',
							itemId : 'readItemId',
							editable: false,
							valueField: 'id',
							displayField: 'value',
							fieldLabel:getCommonTranslation('READ'),
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							width: 226,
							autoloadStore: false,
							//allowBlank:false,
							listeners: {
								render: function(combo) {
									var subDepartmentStore= combo.getStore();
									subDepartmentStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									subDepartmentStore.load({
										callback:function(record, operation, success){
											combo.setValue(read);
											
											
										}
									});
								}
							}
						},{    
							xtype: 'customcombobox',
							name: 'write',
							itemId : 'writeItemId',
							fieldLabel: getCommonTranslation('WRITE'),
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							valueField: 'id',
							displayField: 'value',
							width: 226,
							autoloadStore: false,
							//allowBlank:false,
					         listeners: {
								render: function(combo) {
									var writeStore= combo.getStore();
									writeStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									writeStore.load({
										callback:function(record, operation, success){
											combo.setValue(write);
											
											
										}
									});
								}
							}
							
						},{    
							xtype: 'customcombobox',
							name: 'speak',
						    itemId : 'speakItemId',
							valueField: 'id',
							displayField: 'value',
							fieldLabel: getCommonTranslation('SPEAK'),
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							width: 191,
							autoloadStore: false,
							//allowBlank:false,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(speak);
											
											
										}
									});
								}
							}
							
						},{
							xtype: 'button',
							itemId: 'stopBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'30px'
							}
						}]
					
					});
				}else{
					panelItem.push({
						xtype : 'fieldcontainer',
						layout : 'hbox',
						width: '100%',
						scope: this$,
						defaults : {
							labelAlign : 'top',
							//width:'100%'
						},
						layout : {
							type : 'hbox'
						},
						items:[{
							xtype: 'hidden',
							itemId:'langItemId',
							name: 'langId',
							value: langId
					},{
							xtype: 'customcombobox',
							width: 226,
							name: 'employeeLanguage',
							store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
							valueField: 'id',
							displayField: 'value',
							editable: false,
							typeAhead: false,
							rowIndx:indx,
							forceSelection:true,
							//allowBlank:false,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								}
								
							},
							listeners:{
								render: function(combo){
									var cDepartmentStore= combo.getStore();
									cDepartmentStore.getProxy().extraParams = {
										limit:-1
									};
									cDepartmentStore.load({
										callback:function(record, operation, success){
											combo.setValue(multiLanguage);
											
										}
									});
								},
								select:function(obj,rec,value){
									var departmentId=rec[0].get('id');
									var flag = true;
									var pnlMain = obj.up("#serviceStopPanelId");
									var rowIndx = obj.rowIndx;
									if(!isNullOrEmpty(pnlMain)){
										pnlMain.items.each(function(item, index, items) {
											var deptNameVal = item.down("[name=employeeLanguage]").getValue();
											if(departmentId == deptNameVal && rowIndx != index){
												flag = false;
					        					return false;
											}
										});
										
										if(flag){
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											if (departmentId > 0) {
												var writeStore=write.getStore();
												var speakStore=speak.getStore();
												
												var store=nextSiblingField.getStore();
												store.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												store.load();
												writeStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												writeStore.load();
												speakStore.getProxy().extraParams = {
													limit:-1,
													employeeLanguage : departmentId
												};
												speakStore.load();
											}
										}
										else{
											obj.reset();
											var nextSiblingField = obj.nextSibling();
											var write = obj.nextSibling().nextSibling();
											var speak = obj.nextSibling().nextSibling().nextSibling();
											nextSiblingField.reset();
											write.reset();
											speak.reset();
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('LANGUAGE_ALREADY_SELECTED_MSG'));
											return false;
										}
									}
								}
								
							}
						},{    
							xtype: 'customcombobox',
							name: 'read',
							width: 226,
							valueField: 'id',
							displayField: 'value',
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							autoloadStore: false,
						//	allowBlank:false,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(read);
											
											
										}
									});
								}
							}
							
						},
						{    
							xtype: 'customcombobox',
							name: 'write',
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							editable: false,
							width: 226,
							valueField: 'id',
							displayField: 'value',
							autoloadStore: false,
						//	allowBlank:false,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(write);
											
											
										}
									});
								}
							}
							
						},{    
							xtype: 'customcombobox',
							name: 'speak',
							store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
							width: 191,
							valueField: 'id',
							displayField: 'value',
							editable: false,
							autoloadStore: false,
						//	allowBlank:false,
							listeners: {
								render: function(combo) {
									var speakStore= combo.getStore();
									speakStore.getProxy().extraParams = {
										limit:-1,
										employeeLanguage : departmentId
									};
									speakStore.load({
										callback:function(record, operation, success){
											combo.setValue(speak);
											
											
										}
									});
								}
							}
						},{
							xtype: 'button',
							glyph: ICONGLYPH.DELETEGLYPH,
							itemId: 'languageDeleteButton1',
							width: 'auto',
							cls: 'CustomBodyBtnReject',
							tooltip: getCommonTranslation('DELETETOOLTIP'),
							width:40,
							style:{
								marginTop:'2px'
							},
							listeners:{ listeners:{
								click:function(obj){
									var container = obj.up('fieldcontainer');
								}
							}}
						}]

					});
				}

				panelContiner.add(panelItem);
				indx = indx + 1; 
				panelContiner.doLayout();
			});
		
		}
   
	    var employeeLanguageField = createcourseform.down("#employeeLanguage");
	    var writeField = createcourseform.down("#writeItemId");
	    var readField = createcourseform.down("#readItemId");
	    var speakField = createcourseform.down("#speakItemId");
	    this$.loadDFRForLanuageCompentcy(employeeLanguageField,writeField,readField,speakField);

	    return personData;
   },
	loadDFRForLanuageCompentcy: function(employeeLanguageField,writeField,readField,speakField){
   	var $this = this;
   	Ext.Ajax.request({
   		type: 'rest',
   		async: false,
   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
   		params: {
   			screenName: 'personalinformationform',
   			academyLocationId: this.getCurrentAcademyLocation(),
   			languageCode:'en'
   		},
   		method: 'GET',
   		success: function(res, action) {
   			var response = Ext.decode(res.responseText);
   			if( Object.keys(response).length > 0 ){
   				var records=response.personalinformationform;
   				for(i in records){
   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='employeeLanguage' && records[i].isMandatory == true){
   						employeeLanguageField.setFieldLabel('');
						employeeLanguageField.labelSeparator = '';
						employeeLanguageField.setFieldLabel(getCommonTranslation('LANGUAGE') + ':<span class="required" style="color:red"> *</span>');
   					}
   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='readItemId' && records[i].isMandatory == true){
   						readField.setFieldLabel('');
						readField.labelSeparator = '';
						readField.setFieldLabel(getCommonTranslation('READ') + ':<span class="required" style="color:red"> *</span>');
   						
   					}
   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='writeItemId' && records[i].isMandatory == true){
   						writeField.setFieldLabel('');
						writeField.labelSeparator = '';
						writeField.setFieldLabel(getCommonTranslation('WRITE') + ':<span class="required" style="color:red"> *</span>');
   					}
   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='speakItemId' && records[i].isMandatory == true){
   						speakField.setFieldLabel('');
						speakField.labelSeparator = '';
						speakField.setFieldLabel(getCommonTranslation('SPEAK') + ':<span class="required" style="color:red"> *</span>');	
   					}
   				}
   			}
   		}
   		
   	});
   	
	},
	deleteLanguageCompentecny: function(deleteButton) {
	   	 var this$ = this;
	   	var personProfile = this$.getContentPanelActiveTab();
	    var form = personProfile.down('#applicantPersonalInformationForm');
	    var departmentPanel = form.down('#serviceStopPanelId');
	   	var container = deleteButton.up('fieldcontainer');
	 	var langId= container.down('#langItemId').getValue();
	   if (container != null && departmentPanel != null) {
	   		 if (departmentPanel.items.length > 1) {
	   			 departmentPanel.remove(container);
	   		 }
	   	 }
	   if(langId!=null){
		   deleteUrl = SERVERURL.PATH_DELETE_APPLICANT_LANAGUAGE_COMPETENCY+'?id='+ langId,
	       Ext.Ajax.request({
	           type: 'rest',
	           url: deleteUrl,
	           method: 'GET',
	           headers: {
	               'Content-Type': 'application/json'
	           },
	           success: function(form, action) {
	           }
	       });
	   	}
	   	 form.getForm().checkValidity();
   },
   loadDFRForAddressFieldForm: function(phoneCountryCode, cellCountryCode) {
	   Ext.Ajax.request({
	        type: 'rest',
	        async: false,
	        url: SERVERURL.COMMON_FORM_FIELD_INFO,
	        params: {
	            screenName: 'addressformwindow',
	            academyLocationId: this.getCurrentAcademyLocation(),
	            languageCode:'en'
	        },
	        method: 'GET',
	        success: function(res, action) {
	            var response = Ext.decode(res.responseText);
	            if( Object.keys(response).length > 0 ){
	                var records=response.addressformwindow;
	                for(i in records){                        
	                    if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='phoneCountryCode' && !isNullOrEmpty(records[i].formFieldLabel)){
	                    	phoneCountryCode.setFieldLabel('');
	                    }
	                    
	                    if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='cellCountryCode' && !isNullOrEmpty(records[i].formFieldLabel)){
	                    	cellCountryCode.setFieldLabel('');
	                    }
	                    
	                }
	            }
	        }
	        
	    });
   },
   loadApplicantPermitDocumentWindow: function(){
	   var $this = this;
	   var permitDocGrid = $this.getApplicantpermitdocumentgrid();
	   var store = permitDocGrid.getStore();
       var contentPanelTab = this.getContentPanelActiveTab();
       var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
       var grid = personInfoPanel.down('applicantpermitgrid');
       var selectedRec = grid.getSelectionModel();
       store.getProxy().extraParams = {
    	   ID: selectedRec.getSelection()[0].data.id
       };
       store.load({
    	   callback:function() {
    		   if(store.getCount()) {
    			   if (permitDocGrid.isHidden()) {
    				   permitDocGrid.setVisible(true);
    			   }
    		   }					
    	   }
       });
   },	
   loadApplicantPermitDocumentUrlWindow: function(){
	   var $this = this;
	   var permitDocUrlGrid = this.getApplicantpermiturldocumentgrid();
       var store = permitDocUrlGrid.getStore();
       var contentPanelTab = this.getContentPanelActiveTab();
       var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
       var grid = personInfoPanel.down('applicantpermitgrid'); 	
       var selectedRec = grid.getSelectionModel();
       store.getProxy().extraParams = {
    	   ID: selectedRec.getSelection()[0].data.id
       };
       store.load({
    	   callback:function() {
    		   if(store.getCount()) {
    			   if (permitDocUrlGrid.isHidden()) {
    				   permitDocUrlGrid.setVisible(true);
    			   }	  											
    		   }
    	   }
       });	
   },
   
   handleRegisteredBeforeSAChange: function(form, allIntakeYear, areYouRegisteredAtOtherSAU) {

   	Ext.Ajax.request({
	        type: 'rest',
	        async: false,
	        url: SERVERURL.COMMON_FORM_FIELD_INFO,
	        params: {
	            screenName: 'personalinformationform',
	            academyLocationId: this.getCurrentAcademyLocation(),
	            languageCode: 'en'
	        },
	        method: 'GET',
	        success: function(res) {
	            var response = Ext.decode(res.responseText);
	            if (response && response.personalinformationform) {
	                var records = response.personalinformationform;

	                for (var i = 0; i < records.length; i++) {
	                    var record = records[i];

	                    if (record.formFieldId === 'allIntakeYearItemId') {
	                        if (record.isMandatory) {
	                            allIntakeYear.allowBlank = false;
	                            allIntakeYear.setFieldLabel(
	                                    getEnquiryTranslation('ALL_INTAKE_YEAR') + ':<span class="required" style="color:red"> *</span>'
	                                );
	                        } else {
	                            allIntakeYear.allowBlank = true;
	                        }

	                        if (record.isVisible) {
	                            allIntakeYear.setVisible(true);
	                        } else {
	                            allIntakeYear.setVisible(false);
	                            allIntakeYear.setValue(null);
	                        }
	                    }

	                    
	                }
	            } else {
	                allIntakeYear.setVisible(true);
	               
	            }

	            form.isValid(); 
	        }
	    });
   
	},
	saveApplicantWaitingListDetails: function(obj) {
		var form = obj.up('form');
		var this$ = this;
		var personProfile = this$.getContentPanelActiveTab();
		var personId;
		var setupId = form.down('#waitingListSetupCombo').getValue()
		try {
			personId = personProfile.getPersonId();
		} catch (e) {
			personId = this$.getContentPanel().items.items[0].getPersonId();
		}

		var submitJson = {
			"id": "",
			"version": "0",
			"person": {
				"id": personId
			},
			"isApplyForWaitingList": true,
			"applicationStatus": "SUBMITTED",
			"wsHostelApplicationSetup": {
				"id": setupId
			},
			"tempAccommondationType": true,
			"weatherActive": true,
			// "customData": ""
			
			"customData": form.getForm().getValues().customData,
			
		}
		
		var form = obj.up('form');
		var jsonFormatFormData = form.getForm().getValues();
		if (isNullOrEmpty(jsonFormatFormData.id)) {
			this$.sendSaveAjaxRequest(SERVERURL.PATH_SAVE_APPLICANT_HOSTEL_PERSONAL_INFO, 'POST', submitJson, function(option, success, response) {
				if (success, form) {
					var data = Ext.decode(response.responseText);
					if (response.responseText == 0) {
						form.down('#idItemId').setValue(null);
					}
					else if (response.responseText > 0) {
						form.down('#idItemId').setValue(response.responseText);
						var whetherWaiting = form.down('#whetherApplicantWaiting');
						var waitingListCombo = form.down('#waitingListSetupCombo');
						whetherWaiting.setValue(true);
						whetherWaiting.setDisabled(false);
						whetherWaiting.setReadOnly(true)
						waitingListCombo.setReadOnly(true)
						form.down('#submitButtonId').setDisabled(true);
					}
					showSuccessMessage('Hostel Personal Requirements', 'Hostel personal requirements updated successfully');
				}
			});

		}else if(!isNullOrEmpty(jsonFormatFormData.id)){
			showWarningMessage(getCommonTranslation('ALERT'), getPersonModuleTranslation('Hostel Application Already Exist'));
		}
	},
	addApplicantGoogleAddressBtn:function(form){
 	   var activeTab = this.getContentPanelActiveTab();  
 	   if(activeTab && activeTab.xtype=='applicantprofile'){
 		   var googleAddressBtn = form.down('#googleAddressBtnId');
 		   var associatedAcadLocationIds = new Array();
 		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
 		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICANT_FEE_PAYER_DETAILS_PERMISSIONS());

 		   Ext.each(permissionList, function(privilege) {
 			   if (privilege === 'GOOGLE_ADDRESS') {
 				   if(!isNullOrEmpty(googleAddressBtn)){
 					   googleAddressBtn.setVisible(true);
 				   }        		
 			   }
 		   });
 	   }
	},
	openApplicantGoogleAddressWin:function(){
		var feePayerGoogleAddressWin = this.getFeepayergoogleaddresswin(),
		feePayerForm = this.getContentPanelActiveTab().down('feepayerdetailform'),
		formValues = feePayerForm.getValues();
		if (!feePayerGoogleAddressWin) {
			Ext.widget('feepayergoogleaddresswin',{
				itemId: 'applicantFeepayergoogleaddresswin'
			});
			feePayerGoogleAddressWin = this.getFeepayergoogleaddresswin();
		}
		feePayerGoogleAddressWin.show();  

		Ext.defer(function(){
			feePayerGoogleAddressWin.down('#googleAddressId').setValue(formValues.addressText);
			feePayerGoogleAddressWin.down('#googleAddressCountryId').setValue(formValues.countryText);
			feePayerGoogleAddressWin.down('#googleAddressCountryRegionId').setValue(formValues.provinceText);
			feePayerGoogleAddressWin.down('#googleAddressCityId').setValue(formValues.cityText);
			feePayerGoogleAddressWin.down('#googlePincodeId').setValue(formValues.postalCodeText);
		},200)
	},
	applyDFROnApplicantFeePayerGoogleAddressForm:function(form){
		var $form = form,me = this, fieldCmp,formFields = form.down('form').getForm(),activeTab = this.getContentPanelActiveTab(); 
		Ext.Ajax.request({
			type: 'rest',
			async: false,
			url: SERVERURL.COMMON_FORM_FIELD_INFO,
			params: {
				screenName: 'feepayergoogleaddresswin',
				academyLocationId: this.getCurrentAcademyLocation(),
				languageCode:'en'
			},
			method: 'GET',
			success: function(res, action) {
				var response = Ext.decode(res.responseText);
				if(Object.keys(response).length > 0 ){
					response.feepayergoogleaddresswin.forEach(function(rec){
						fieldCmp = form.down('#'+rec.formFieldId);
						if(!fieldCmp){
							fieldCmp = formFields.findField(rec.formFieldName);
						}
						if(fieldCmp){
							if(rec.isVisible){
								me.setAllowBlank(fieldCmp, !rec.isMandatory);
							}else{
								me.setAllowBlank(fieldCmp, true);
							}
							fieldCmp.setVisible(rec.isVisible);
							if(rec.formFieldInputType=='checkboxfield'){
								fieldCmp.setBoxLabel(rec.formFieldLabel);
							}else{
								fieldCmp.setFieldLabel(rec.formFieldLabel);
							}
							if(activeTab && activeTab.xtype=='applicantprofile'){
								$form.down('#isSameAsStudentGoogleAddressId').setVisible(false);   
							}
						}
					});
				}else{
					$form.down('#isSameAsApplicantGoogleAddressId').setVisible(true);
				}
			}
		});
	},
   checkUwcNationalIdValidation: function(responseData, data, nationalityCodeValue ,idTypeCodeValue){
            var $this = this;
			if(!isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code == "SA" || !isNullOrEmpty(idTypeCodeValue) && idTypeCodeValue.data.idTypeCode == 'NATIONAL_ID'){
			var nationalId = data.nationalID;
			var birthDate = data.birthDate;
			var gender = data.genderCSM;
			var permanentResidancial= data.isPermanentResident;
			var isrefugee= data.areYouRefugee;
			var message = '';
			//if(!isNullOrEmpty(nationalId)){
				if(nationalId.length > 13 || nationalId.length<13){
					message = message+getCommonTranslation('NATIONALID_SHOULDBE_13DIGITS')+'<br>';
				}
				if(!isNumberValidate(nationalId)){
					message = message+getCommonTranslation('NATIONALID_CANBE_ONLYDIGITS')+'<br>';
				}
				if(responseData.dateOfBirth==true){
				if(nationalId.length > 5 && !isNullOrEmpty(birthDate)){
					var splitDOB = birthDate.split('-');
					var dobYear = splitDOB[0].substr(-2);
					var dobMonth = splitDOB[1];
					var dobDay = splitDOB[2];
					var dateOfBirth = dobYear+dobMonth+dobDay;
					var firstSixDigit = nationalId.substr(0,6);
					if(firstSixDigit != dateOfBirth){
						message = message+getCommonTranslation('INVALID_DOB_ID_NUMBER_PROVIDED')+'<br>';
					}
				}
			 }
			 
			   if(responseData.gender==true){
				if(nationalId.length > 9 && !isNullOrEmpty(gender)){
					var sevenToTenDigit = nationalId.substr(6,4);
					if((gender.id == 2 && (sevenToTenDigit>=0 && sevenToTenDigit<=4999)) || (gender.id == 1 && (sevenToTenDigit>=5000 && sevenToTenDigit<=9999))){
					
					}else{
						message = message+getCommonTranslation('INVALID_GENDER_IDNUMBER_PROVIDED')+'<br>';
					}
				}
			 }
			 

			 if (responseData.citizenship == true) {
			 	var eleventhDigit = nationalId.substr(10, 1);
			 	if (nationalId.length > 10 && eleventhDigit != 0 && !isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code == "SA") {
			 		message = message + getCommonTranslation('INVALID_CITIZENSHIP_IDNUMBER_PROVIDED') + '<br>';
			 	} else if (nationalId.length > 10 && eleventhDigit == 0 && !isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code != "SA") {
			 		message = message + getCommonTranslation('INVALID_CITIZENSHIP_IDNUMBER_PROVIDED') + '<br>';
			 	} else if (nationalId.length > 10 && eleventhDigit == 1 && data.isPermanentResident != true) {
			 		message = message + getCommonTranslation('INVALID_PERMANENT_RESIDENT_DETAILS') + '<br>';
			 	} else if (nationalId.length > 10 && eleventhDigit == 2 && data.areYouRefugee != true) {
			 		message = message + getCommonTranslation('INVALID_REFUGEE_ID_NUMBER_PROVIDED') + '<br>';
			 	} else if (nationalId.length > 10 && eleventhDigit != 0 && eleventhDigit != 1 && eleventhDigit != 2) {
			 		message = message + getCommonTranslation('INVALID_DETAILS_ID_NUMBER_PROVIDED') + '<br>';
			 	}
			 }


			 if (responseData.race == true) {
			 	var twelveDigit = nationalId.substr(11, 1);
			 	if (nationalId.length > 11 && twelveDigit == 6 && !isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code == "SA") {
			 		message = message + getCommonTranslation('INVALID_RACE_REFUGEE_ID_NUMBER_PROVIDED') + '<br>';
			 	} else if (nationalId.length > 11 && twelveDigit == 6 && data.areYouRefugee != true && !isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code != "SA") {
			 		message = message + getCommonTranslation('INVALID_RACE_REFUGEE_ID_NUMBER_PROVIDED') + '<br>';
			 	} else if (nationalId.length > 11 && twelveDigit != 6 && data.areYouRefugee == true && !isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code != "SA") {
			 		message = message + getCommonTranslation('INVALID_RACE_ID_NUMBER_PROVIDED') + '<br>';
			 	} else if (nationalId.length > 11 && (twelveDigit != 8 && twelveDigit != 9 && twelveDigit != 6)) {
			 		message = message + getCommonTranslation('INVALID_RACE_ID_NUMBER_PROVIDED') + '<br>';
			 	}
			 }

			
			   if(responseData.checksum == true){
				var sum = 0;
				for (var i = 1; i <= nationalId.length-1; i += 2) {
				    if (i === nationalId.length) {
				        continue;
				    }
					    sum += parseInt(nationalId[i-1]);
				}
                var A=sum;
				 
				var result = "";

				    for (var pos = 2; pos <= nationalId.length; pos += 2) {
				        result += nationalId.charAt(pos - 1); 
				    }

				    var B= result;
					
					var sumOfEvenNumberDoubleValue=String(B*2);
					
				var sumOfEvenDigit =0;
				   
				     for(var j=0; j<sumOfEvenNumberDoubleValue.length; j++){
						sumOfEvenDigit += parseInt(sumOfEvenNumberDoubleValue.charAt(j));
					 }
					 
					 var C=parseInt(sumOfEvenDigit);
					 
					 var D = A+C;
					 
					 var Z = 10 - (D % 10) % 10;

					 var thirteenDigit = nationalId.substr(12, 1);
				   if (nationalId.length > 12 && thirteenDigit != Z ) {
					   message = message + getCommonTranslation('INVALID_CHECKSUM_DETAILS') + '<br>';
				   } 

			   }
				
				if(message !='')
				{
					showNotificationMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), message);
					return false;
				}else{
					showOkWithSuccessMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), getCommonTranslation('NATIONALID_IS_VALID'));
				    return true;
				}
			//}	
		}else{
			return true;
		}
   },
   
   saveNationalServiceData:function(gridItemId, saveUrl){
		var $this = this;
		var form = $this.getNationalServiceDetailForm();
		$this.saveNationalService(gridItemId, saveUrl,form, function(success){
			if(success){
				console.log('SUCCESS');
			}
		});
	},
	
	saveNationalService : function(gridItemId, saveUrl,form, callback){
		var this$ = this;
		var nationalServiceDetails = form.down('#nationalServiceDocId');
		var nationalServiceDetailsPath = nationalServiceDetails.getValue();
		form.down('#submitButtonId').setDisabled(true);
		if( !isNullOrEmpty(nationalServiceDetailsPath)){
			form.getForm().submit({
				method : 'POST',
				url : SERVERURL.NATIONAL_SERVICE_UPLOAD_DOC,
				success : function(form1, action){
					callback(true);
					var responseData = Ext.decode(action.response.responseText);
					var id = responseData.id;
					form.getForm().findField('nationalServiceUploadDoc').setValue(id);
					this$.saveNationalServiceReocrd(gridItemId, saveUrl);
				},
				failure: function(form, action) {
			            var  msg = getCommonTranslation('UPLOAD_FILE_TYPE_IS_INVALID');
                       showWarningMessage(getCommonTranslation('ALERT'), msg);
				        
				    }
			});
			
	    
		}else{
			this$.saveNationalServiceReocrd(gridItemId, saveUrl);
		}
	},
	
	saveNationalServiceReocrd: function(gridItemId, saveUrl) {
		var this$ = this;
		var form = this$.getNationalServiceDetailForm();
		var personProfile = this$.getContentPanelActiveTab();
		var grid = personProfile.down(gridItemId);
		form.down('#submitButtonId').setDisabled(true);
		var submitUrl, isUpdate = false;
		var id = form.down('#national_Service_hidden_field');

		//var path = form.getForm().findField('nationalServiceUploadPath').getValue();

		var jsonFormatFormData = this$.getJsonNationalServiceSubmitData(form);

		this$.applyWindowMask(); 

		this$.sendSaveAjaxRequest(saveUrl, 'POST', jsonFormatFormData, function(option, success, response) {
			this$.hideWindowMask();
			if(success,form){
				var data = Ext.decode(response.responseText);
				if(isArray(data)){
					form.down('#submitButtonId').setDisabled(false);
					if(data[0].key == 'ID_TYPE_ALREADY_EXISTS'){
						return false;
					}
				}

				var personId =this$.getContentPanelActiveTab().personId;
        		var gridStore = grid.getStore();
        		gridStore.getProxy().extraParams = {					  
        			applicantPersonId :personId
            		
    			  };
    			
        		gridStore.load();
				grid.getSelectionModel().deselectAll();
				if(form.itemId == 'nationalServiceDetailForm') {
					form.up().close();
				} else {
					this$.closePersonCommonWindow();
				}
					showSuccessMessage(getPersonModuleTranslation('NATIONAL_SERVICE'), getPersonModuleTranslation('NATIONAL_SERVICE_ADD_SUCCESS'));
			}else{
				this$.closePersonCommonWindow();
				var personId =this$.getContentPanelActiveTab().personId;
        		var gridStore = grid.getStore();
        		gridStore.getProxy().extraParams = {					  
        			applicantPersonId :personId
            		
    			  };
    			
        		gridStore.load();
				form.down('#submitButtonId').setDisabled(false);
			}
		});
	},
	
	getJsonNationalServiceSubmitData: function(form) {
   	var this$ = this;
       var jsonFormFieldData = new Object();
       var formData = form.getValues();
       if (!isEmpty(formData)) {
       	var personObj = this$.getPersonObj();
           formData.applicantPersonId = personObj.id;
       }
     
       if(isNullOrEmpty(formData.status) && formData.status.length == 0){
			formData.status = null;
		}
       formData.docId=formData.nationalServiceUploadDoc;
       formData.fromDate = formData.nationalServiceFormDateId;
	   formData.toDate = formData.nationalServiceToDateId;
	   formData.statusId = formData.status;
	   delete formData.nationalServiceUploadDoc;
	   delete formData.editDoc;
	   delete formData.status;
	   delete formData.nationalServiceFormDateId;
	   delete formData.nationalServiceToDateId;
       delete formData.customData;
       delete formData.nationalServiceUploadPath;
       delete formData.nationalServiceUploadDocId;
       jsonFormFieldData = Ext.encode(formData);
       return jsonFormFieldData;
   },
   
   editNationalserviceDetail: function(informationType, formItemId, gridItemId, isViewMode) {
       var this$ = this;
       var personProfile = this$.getContentPanelActiveTab();
       var grid = personProfile.down(gridItemId);

       if (grid.getSelectionModel().getCount() > 0) {
       	this$.showPersonCommonWindow(undefined, informationType, formItemId, null);
       	var formWindow = this$.getPersonCommonWindow();
       	if(!isNullOrEmpty(isViewMode) && (isViewMode==true || isViewMode=='true')) {
       		formWindow.setTitle(getCommonTranslation('VIEW_NATIONAL_SERVICE'));
       	}else{
       		formWindow.setTitle(getCommonTranslation('EDIT_NATIONAL_SERVICE'));
       	}
       	var form = this$.getNationalServiceDetailForm();
           var records = grid.getSelectionModel().getSelection()[0];
           
           var nationalServiceUploadDocField = form.down('#nationalServiceUploadDocId');
           nationalServiceUploadDocField.setValue(records.data.documentName);
           var editDocField = form.down('#editDocId');
           editDocField.setValue(records.data.docId);
           var nationalServiceDownloadDocIdField = form.down('#nationalServiceDownloadDocId');
           nationalServiceDownloadDocIdField.setValue(records.data.documentName);
           if (!isEmpty(records)) {
	          	form.down('#national_Service_hidden_field').setValue(records.data.id);
	          	var nationalServiceNameField = form.down('#nationalServiceNameId')
	          	if (!isNullOrEmpty(records.data.nationalServicesId)) {		            	
	          		nationalServiceNameField.getStore().load({ 
	          			callback: function(recordss, operation, success) {
	          				if (success) {
	          					for(i in recordss){
	          						if(recordss[i].data.id == records.data.nationalServicesId)
	          							nationalServiceNameField.setValue(recordss[i].data.id);  	
	          					}
	          				}
	          			}
	          		});
	          	}
	          	var nationalServiceStatusField = form.down('#nationalServiceStatusId')
	          	if (!isNullOrEmpty(records.data.status)) {		            	
	          		nationalServiceStatusField.getStore().load({ 
	          			callback: function(recordss, operation, success) {
	          				if (success) {
	          					for(i in recordss){
	          						if(recordss[i].data.id == records.data.statusId)
	          							nationalServiceStatusField.setValue(recordss[i].data.id);  	
	          					}
	          				}
	          			}
	          		});
	          	}
	          	var nationalServiceField = form.down('#nationalServiceId');
	          	var nationalServiceFormDateField = form.down('#nationalServiceFormDateId');
	          	var nationalServiceToDateField = form.down('#nationalServiceToDateId');
	          	nationalServiceField.setValue(records.data.nationalServiceId);
	          	nationalServiceFormDateField.setValue(records.data.fromDate);
	          	nationalServiceToDateField.setValue(records.data.toDate);
	          	form.loadRecord(records);
           }
       } else {
       	showWarningMessage(getCommonTranslation('EDIT_NATIONAL_SERVICE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
       }
  	},
  	viewNationalserviceDetail: function(informationType, formItemId, gridItemId) {
   		var this$ = this;
   		var personProfile = this$.getContentPanelActiveTab();
   		var grid = personProfile.down(gridItemId);
  	  	if (grid.getSelectionModel().getCount() > 0) {
  	  		this$.editNationalserviceDetail(informationType, formItemId, gridItemId, true);
  	  		var form = this$.getNationalServiceDetailForm();
  	  		this$.viewPersonCommonWindow(form);
  	  	} else {
  	  		showWarningMessage(getCommonTranslation('VIEW_NATIONAL_SERVICE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
  	  	}
   	},
   	
   	deleteNationalserviceDetail:function(gridItemId, deleteUrl, successMsg) {
   		var this$ = this;
   		var personProfile = this$.getContentPanelActiveTab();
   		var personId =this$.getContentPanelActiveTab().personId;
   		var grid = personProfile.down(gridItemId);
   		if (grid.getSelectionModel().getCount() > 0) {
   			showConfirmMessage(getCommonTranslation('DELETE_NATIONAL_SERVICE'), getCommonTranslation('PERMIT_DETAIL_DELETE_CONFIRM_MSG'), function(btn, text) {
   				if (btn == 'yes') {
   					if (grid.getSelectionModel().getCount() > 0) {
   						var records = grid.getSelectionModel().getSelection();
   						var id = records[0].data.id;
                        Ext.Ajax.request({
                        	type: 'rest',
                        	url: deleteUrl+'?id='+id,
                        	async:false,
                        	method: 'DELETE',
                        	headers: {
                        		'Content-Type': 'application/json'
                        	},                        	
                        	success: function(form, action) {
                        		grid.getSelectionModel().deselectAll();
                        		var gridStore = grid.getStore();
                        		gridStore.getProxy().extraParams = {					  
                        			applicantPersonId :personId
                            		
                    			  };
                    			
                        		gridStore.load();
                        		
                        		//grid.getStore().reload();
                        		showSuccessMessage(getCommonTranslation('DELETE_NATIONAL_SERVICE'), getCommonTranslation(successMsg));
                        	}
                        })
   					}
   				}
   			});
   		} else {
   			showWarningMessage(getCommonTranslation('DELETE_NATIONAL_SERVICE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
   		}
   	},
   
});

