/**
 * This controller is used for Selection Stage from the admissions module.
 * @author Rupesh.Agrawal
 */
Ext.define('Academia.controller.admission.selectionStage.SelectionStageController', {
    // extend: 'Academia.controller.base.BaseController',
    //extend: 'Academia.controller.personinfo.common.PersonCommonController',
    extend: 'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',

    views: ['admission.selectionStage.ApplicationStageStructure', 'admission.selectionStage.SelectionStageStructure',
            'Academia.view.common.NestedForm', 'Academia.view.admission.selectionStage.EnterMarksPoppupWindow', 
            'admission.selectionStage.ChangeStatusPoppupWindow', 'admission.selectionStage.StageCriteriaPoppupWindow',
            'admission.selectionStage.CloseStagePopupWindow', 'admission.selectionStage.StageDocumentPopupWindow',
            'Academia.view.admission.selectionStage.SelectionStageTabStructure', 'Academia.view.common.NestedTextField', 
            'Academia.view.admission.selectionStage.ApplicationStageBasicSearch','Academia.view.criteriabuilder.grid.SearchResultGrid', 
            'Academia.view.admission.selectionStage.StageStatasticsGrid', 'Academia.view.admission.selectionStage.TransferSeatsGrid',
            'Academia.view.admission.selectionStage.TransferSeatsWindow', 'Academia.view.admission.selectionStage.OverrideQuotaLimits',
            'Academia.view.admission.selectionStage.SelectionStageSearchStructure','admission.selectionStage.SelectionStageSearchFilter',
            'admission.selectionStage.StageDetailsStructure','admission.selectionStage.StageDetailsTabStructure',
            'admission.selectionStage.StageAttributeStructure','admission.selectionProcess.DocumentsGrid',
            'admission.selectionStage.SelectionStageAcadProgBatchSeatType',
            'admission.selectionStage.StageStatasticsGridStructure',
            'admission.selectionStage.TransferSeatsGridStructure',
            'admission.selectionStage.UploadSelectionTransferForm','admission.selectionStage.DownloadSelectionTransferForm',
            'admission.selectionStage.SelectionStageTransferUploadDownloadStructure','admission.selectionStage.ImportUtilitySelectionTransferList',
            'admission.selectionStage.StageFeeStatasticsGridStructure','admission.selectionStage.StageFeeStatasticsGrid',
            'admission.selectionStage.SelectionStageConditionsDocumentList',
            'admission.selectionStage.SelectionStageConditionsAdmission','admission.selectionStage.StageMarksListReportWin',
            'admission.selectionStage.EffectiveMarksListReportWin',
            'UploadOptionRadioGroup','admission.selectionStage.SelectionStageStatusTransferUploadDownloadStructure',
            'admission.selectionStage.UploadSelectionStatusForm','admission.selectionStage.DownloadSelectionStatusForm',
            'admission.selectionStage.ImportUtilitySelectionStatusList'
            ],
    stores: ['admission.selectionStage.ApplicationProgramStageStatusStore','admission.selectionProcess.QuotaTypesByProgramBatchSeatConfigId',
             'Academia.store.admission.selectionStage.SelectionStageFromSeatType',  'Academia.store.admission.selectionStage.Documents', 
             'Academia.store.admission.admissionCycle.QuotaTypePickList', 'Academia.store.admission.selectionStage.SeatTypePickListFromTo',
             'Academia.store.admission.selectionStage.StageStatistics', 'Academia.store.admission.selectionStage.TransferSeats', 
             'Academia.store.admission.selectionStage.MandatoryQuotas', 'Academia.store.admission.selectionStage.SeatTypePickList',
             'Academia.store.admission.quotas.QuotaPickList','enquiry.ProgramForEnquiryStore',
             'enquiry.BatchForEnquiryStore','user.UserAcademyLocationStore',
             'feeandpayment.managebill.Applicant','feeandpayment.managebill.Applicant','admission.selectionStage.SelectionStageTreeStore',
             'admission.selectionProcess.DocumentGridRecords','admission.selectionStage.SelectionStageClosedTreeStore',
//             'attendance.attendancereport.AcadmyByAdmission',
             'common.ProgramByAcademyLocationStore','common.BatchesByProgramId','common.SeatTypesByBatchId','importutility.ModuleName',
             'importutility.ImportListByModule','admission.selectionStage.StageMarksRecordGridStore',
             'admission.selectionStage.EffectiveMarksRecordGridStore','Academia.store.admission.selectionStage.GradesByGradeTypeIdStore',
             'admission.selectionStage.UnsuccessfulReasonStore','Academia.store.program.ProgramByALAndIntakeYearIdStore',
             'Academia.store.enquiry.AcademicBatchOnALIntakePeriodsStores','importutility.ImportSelectionStageStatusStore',
             'admission.selectionStage.AllSelectionStageStore','admission.applications.applicationBase.ApplicationSelectionStageStatusStore'
//             'enquiry.AcademicBatchStore',
//             enquiry.SeatTypeForEnquiryStore
             ],

    models: ['admission.selectionStage.StageStatistic'],

    /*mixins: {
		PersonCommonController: 'Academia.controller.personinfo.common.PersonCommonController'
 		//use this.mixins.PersonCommonController.addContentPanelTab(tabTitle, contentXtype, userId, personId,applicationId,admissionId) 
		//to open the applicant profile
	},*/

    refs: [{
        ref: 'selectionStageStructure',
        selector: 'selectionstagestructure'
    }, {
        ref: 'enterMarksPopupWindow',
        selector: 'enterMarksPopupWindow'
    }, {
        ref: 'enterMarksPopupForm',
        selector: 'enterMarksPopupWindow nestedForm#enterMarksPopupForm'
    }, {
        ref: 'changeStatusPoppupWindow',
        selector: 'changeStatusPoppupWindow'
    }, {
        ref: 'applicationProgramStageStatusForm',
        selector: 'changeStatusPoppupWindow form'
    }, {
        ref: 'stageCriteriaPoppupWindow',
        selector: 'stagecriteriapoppupwindow'
    }, {
        ref: 'stageCriteriaForm',
        selector: 'stagecriteriapoppupwindow form'
    }, {
        ref: 'applicationStageBasicSearch',
        selector: 'applicationstagebasicsearch'
    }, {
        ref: 'selectionStageTabStructure',
        selector: 'selectionstagetabstructure'
    }, {
        ref: 'transferSeatsWindow',
        selector: 'transferseatswindow'
    }, {
        ref: 'transferSeatsGrid',
        selector: 'transferseatsgrid[itemId=transferseatsgrid]'
    }, {
        ref: 'stageStatasticsgrid',
        selector: 'stagestatasticsgrid[itemId=stagestatasticsgrid]'
    },{
        ref: 'applicationStageBasicSearchGrid',
        selector: 'searchresultgrid[itemId=applicationStageBasicSearchGrid]'
    }, {
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'stagedetailsstructure',
        selector: 'stagedetailsstructure'
    },{
        ref: 'stagedetailstabstructure',
        selector: 'stagedetailstabstructure'
    },{
        ref: 'stageattributestructure',
        selector: 'stageattributestructure'
    },{
        ref: 'selectionstagesearchfilter',
        selector: 'selectionstagesearchfilter'
    },{
        ref: 'overridequotalimits',
        selector: 'overridequotalimits'
    },{
        ref: 'selectionstagesearchstructure',
        selector: 'selectionstagesearchstructure'
    },{
    	ref: 'downloadselectiontransferform',
        selector: 'downloadselectiontransferform'
    },{
    	ref: 'selectionstagetransferuploaddownloadstructure',
        selector: 'selectionstagetransferuploaddownloadstructure'
    	
    },{
    	ref: 'importutilityselectiontransferlist',
        selector: 'importutilityselectiontransferlist'
    	
    },{
    	ref: 'uploadselectiontransferform',
        selector: 'uploadselectiontransferform'
    }, {
        ref: 'stageFeeStatasticsgrid',
        selector: 'stagefeestatasticsgrid[itemId=stagefeestatasticsgrid]'
    }, {
        ref: 'selectionstageconditionsdocumentlist',
        selector: 'selectionstageconditionsdocumentlist'
    }, {
        ref: 'selectionstageconditionsadmission',
        selector: 'selectionstageconditionsadmission'
    }, {
        ref: 'stagemarkslistreportwin',
        selector: 'stagemarkslistreportwin'
    }, {
        ref: 'effectivemarkslistreportwin',
        selector: 'effectivemarkslistreportwin'
    },{
    	ref : 'uploadoptionradiogroup',
    	selector : 'uploadoptionradiogroup[itemId=selectiontransferUploadOptionRadioGroupItemId]'
    },{
    	ref : 'selectionstagestatustransferuploaddownloadstructure',
    	selector : 'selectionstagestatustransferuploaddownloadstructure'
    },{
    	ref : 'uploadselectionstatusform',
    	selector : 'uploadselectionstatusform'
    },{
    	ref : 'downloadselectionstatusform',
    	selector : 'downloadselectionstatusform'
    },{
    	ref : 'importutilityselectionstatuslist',
    	selector : 'importutilityselectionstatuslist'
    },{
    	ref : 'statusUploadOptionRadioGroup',
    	selector : 'uploadoptionradiogroup[itemId=selectionstatusUploadOptionRadioGroupItemId]'
    }],


    config: {
        /**
         * @cfg {Integer} transferId (required)
         * This Id will be used while add column functionality.
         * @accessor  ADMISSION_SELECTION_STAGE_PRIVILEGES
         */
        SELECTIONSTAGE_APPLICANTINSTAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SELECTIONSTAGE_APPLICANTINSTAGE_PRIVILEGES'),
        SELECTIONSTAGE_STAGESTATISTICS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SELECTIONSTAGE_STAGESTATISTICS_PRIVILEGES'),
        SELECTIONSTAGE_TRANSFERSEATS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SELECTIONSTAGE_TRANSFERSEATS_PRIVILEGES'),
        
        ADMISSION_SELECTION_STAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_SELECTION_STAGE_PRIVILEGES'),
        ADMISSION_SELECTION_STAGE_BOTTOM_PANEL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_SELECTION_STAGE_BOTTOM_PANEL_PRIVILEGES'),
   	    CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
        STAGE_ATTRIBUTE_TREELINKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STAGE_ATTRIBUTE_TREELINKS_PRIVILEGES'),
        STAGE_STATISTICS_TREELINKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STAGE_STATISTICS_TREELINKS_PRIVILEGES'),
        TRANSFER_SEATS_TREELINKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSFER_SEATS_TREELINKS_PRIVILEGES'),
        OVERRIDE_QUOTA_LIMITS_TREELINKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('OVERRIDE_QUOTA_LIMITS_TREELINKS_PRIVILEGES'),
        STAGE_FEE_STATISTICS_TREELINKS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STAGE_FEE_STATISTICS_TREELINKS_PRIVILEGES'),

        transferId: 0,
        programSelectionProcessStageId: null,
        seatTransferList: null,
        progBatchSeatConfig:null
    },

    init: function() {
        this.control({
        	 'selectionstagestructure ': {
        	   render:function(structure){
        		   this.disableSelectionStageStructure(structure, this.getSELECTIONSTAGE_APPLICANTINSTAGE_PERMISSIONS());
        	   },
               afterrender: function(obj) {
                     this.disableSelectionstagePrivileges(obj,this.getADMISSION_SELECTION_STAGE_PERMISSIONS());
                     var grid = this.getApplicationStageBasicSearchGrid();
             		this.gridRenderFunction(grid);
                 }
             },
            /******** stage operation button functionality start **************/
             //selectionstagestructure
             'selectionstagesearchstructure fieldcontainer button#calculateFinalResult': {
                 click: function(button) {
                     this.calculateFinalResult(button);
                 }
             },
        	'selectionstagesearchstructure fieldcontainer button#calculateRank': {
                click: function() {
                    this.calculateRank();
                }
            },
            'selectionstagesearchstructure fieldcontainer button#generatePrecloserList': {
                click: function(button) {
                    this.generatePrecloserList(button);
                }
            },
            'selectionstagesearchstructure fieldcontainer button#evaluateApplicant': {
                click: function() {
                    this.evaluateApplicant();
                }
            },
            'selectionstagesearchstructure fieldcontainer button#promoteApplicantToNextStage': {
                click: function() {
                    this.promoteApplicantToNextStage();
                }
            },
            'stagefeestatasticsgrid  button[itemId=stagefeestatussearch]': {
            	click : this.stageFeeStatistics
            },
            /***** close stage pop up start *****/
            'selectionstagesearchstructure fieldcontainer button#closeStage': {
                click: function() {
                    this.showWindow('closestagepopupwindow');
                }
            },
            /***** close stage pop up start *****/
            'selectionstagesearchstructure fieldcontainer button#promoteWithConditions': {
                click: function() {
                    this.showConditionsForAdmissionWindow();
                }
            },
            'closestagepopupwindow form button[action=Submit]': {
                click: function(btn) {
                	btn.setDisabled(true);
                    this.closeStage(btn);
                    btn.setDisabled(false);
                },
                render: function(button) {
                    this.loadCloseStageForm(button);
                }
            },
            'closestagepopupwindow form button[action=Cancel]': {
                click: function(btn) {
                    this.closeFormWindow(btn.up('window'));
                }
            },
            /***** close stage pop up End *****/

            /***** Rule criteria pop up start *****/
            /*'selectionstagestructure fieldcontainer button#ruleCriteria': {
                click: function() {
                    this.showRuleCriteriaPopup();
                }
            },*/
            'stagecriteriapoppupwindow form button#cancelBtn': {
                click: function(btn) {
                    this.closeFormWindow(btn.up('window'));
                }
            },
            /***** Rule criteria pop up End *****/

            /***** stage document pop up start *****/
            'selectionstagestructure fieldcontainer button#stageDocument': {
                click: function() {
                    var window = this.showWindow('stagedocumentpopupwindow');
                    var stageId = this.getSelectionProcessStageId();
                    //Loading Documents Grid
                    var documentGrid = window.down('#selectionStageDocuments');
                    documentGrid.down('toolbar[dock=top]').hide();
                    this.loadComponentStore(documentGrid, 'selectionProcessStageId', stageId);
                }
            },
            'stageattributestructure documentsgrid#selectionStageDocuments': {
                render: function(obj) {
//                    var stageId = this.getSelectionProcessStageId();
                    var documentGrid = obj.up('form').down('#selectionStageDocuments');
                    documentGrid.down('toolbar[dock=top]').hide();
//                    this.loadComponentStore(documentGrid, 'selectionProcessStageId', stageId);
                }
            },
            'stagedocumentpopupwindow button[action=Cancel]': {
                click: function(btn) {
                    this.closeFormWindow(btn.up('window'));
                }
            },
            /***** close stage pop up End *****/

            /******** stage operation button functionality start **************/

            /******** Enter mark functionality start **************/
            /**
             * On enter mark button click open form.
             */
//            'selectionstagesearchstructure fieldcontainer button#calculateRank': {
            'selectionstagesearchstructure searchresultgrid#applicationStageBasicSearchGrid button#enterMark': {
                click: function(button) {
                    var grid = button.up('grid');
                    if(this.checkGridRecordSelection(grid)) {
                    	var count = grid.getSelectionModel().getCount();
                    	if(count == 1) {
                    		this.showEnterMarkFormWindow(grid.getSelectionModel().getSelection()[0]);
                    	} else {
                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
                    	}
                    }
                }
            },
            
            'selectionstagesearchstructure searchresultgrid#applicationStageBasicSearchGrid': {
            	selectionchange: function() {
            		this.enableDisabelIndivisualModeButtonOnMultiSelect("");
                },
                afterrender:function(grid){
                	var me = this;
                	 me.addDataGridConfigButton(grid,me.getADMISSION_SELECTION_STAGE_PERMISSIONS());
                }
            },
            
            /**
             * On render of form load form structure.
             */
            'enterMarksPopupWindow nestedForm#enterMarksPopupForm': {
                render: function() {
                    this.loadEnterMarkForm();
                }
            },
            /**
             * On close button click close the pop up. 
             */
            'enterMarksPopupWindow nestedForm#enterMarksPopupForm button[action=Cancel]': {
                click: function(btn) {
                    this.closeEnterMarksPopupWindow();
                }
            },
            /**
             * On Submit button click submit form data. 
             */
            'enterMarksPopupWindow nestedForm#enterMarksPopupForm button[action=Submit]': {
                click: function(btn) {
                    this.saveApplicationProgramMarks();
                    btn.setDisabled(true);
                }
            },
            /******** Enter mark functionality End **************/

            /******** Change Status functionality start **************/
//            'applicationstagebasicsearch searchresultgrid#applicationStageBasicSearchGrid button#changeStatus': {
            'selectionstagesearchstructure searchresultgrid#applicationStageBasicSearchGrid button#changeStatus': {
                click: function(button) {
                    var grid = button.up('grid');
                    if (this.checkGridRecordSelection(grid)) {
                    	var count = grid.getSelectionModel().getCount();
                    	this.showChangeStatusFormWindow();
                    	                    }
                }
            },
            'changeStatusPoppupWindow form': {
                render: function(form) {
                    this.loadApplicationStageStatus(form);
                }
            },
            'changeStatusPoppupWindow form button[action=Submit]': {
                click: function(button) {
                    this.saveApplicationProgramStageStatus(button.up('window'),false);
                }
            },
            'changeStatusPoppupWindow form button[action=Cancel]': {
            	click: function(button) {

            		this.closeChangeStatusFormWindow(button.up('window'));
            	}
            },
            'changeStatusPoppupWindow form customcombobox[itemId=status]': {
              	 select:function(obj1,records) {
              	 var modifyStatusComboBox = obj1.up('form').down('#status');
                 var unsuccessfulReasonComboBox = obj1.up('form').down('#unsuccessfulReason');
                 if(modifyStatusComboBox.getValue() === "REJECTED"){
                	 unsuccessfulReasonComboBox.setVisible(true);
                	 unsuccessfulReasonComboBox.reset();
                 }else{
                	 unsuccessfulReasonComboBox.setVisible(false);
                 }
              	 }
              },
              'changeStatusPoppupWindow form nestedJsonCombo[itemId=unsuccessfulReason]': {
            	  render: function(combo) {
                     	var store = combo.getStore();
                     	store.getProxy().extraParams={
          				type:'Unsuccessful Reason'
          				};
                     	store.load();
                  },
              	
               	 select:function(obj,records) {
                  var unsuccessfulReasonComboBox = obj.up('form').down('#unsuccessfulReason');
                  unsuccessfulReasonComboBox.getStore().getProxy().extraParams={
       				type:'Unsuccessful Reason'
               		};
                  unsuccessfulReasonComboBox.getStore().load();
               	 }
               },
               
            'uploadselectiontransferform button[itemId=resetBtn]':{
            	click:function(obj){
            		var $this=this;
            		var uploadAttendanceForm = $this.getUploadselectiontransferform().getForm();
            		uploadAttendanceForm.findField('file').reset();
            		var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
            		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            			isUploadAll: false
            		});
            		uploadAttendanceForm.isValid();
            	},
            	/*render :function(obj){
            		var $this = this;
            		var form =$this.getUploadselectiontransferform().getForm();
            		var combo = form.findField('importUtilityMasterId');
            		combo.getStore().load({
            			c            		var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
            		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            			isUploadAll: false
            		});
            		uploadAttendanceForm.isValid();
allback: function(records, operation, success) {
            				for(var i in records){
            					if(records[i].data.value=='Bulk Selection Stage Marks'){
            						combo.setValue(records[i].data.id);
            						combo.setReadOnly(true);
            					}
            				}
  		   					}	   
  		   				});
  		   			}*/
  		   		},
  		   		
  		   		'uploadselectiontransferform':{
			        		render:function(obj){
			        			var $this=this;
			    	        	var importWin=$this.getUploadselectiontransferform()
			    	        	var moduleName = importWin.down('#moduleName');
			    	        	moduleName.getStore().load({
			    	        		callback: function(records, operation, success) {
			    	        			for(var i in records){
				    	        			if(records[i].data.value=="Bulk Selection Stage Marks"){
				    	        				moduleName.setValue(records[i].data.id);
				    	        				moduleName.setReadOnly(true)
				    	        			}
			    	        			}
			            		   }	
			    	        	});
			        		}  
					 },
					 'uploadselectiontransferform uploadoptionradiogroup[itemId=selectiontransferUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
						 change: function( radioGroup, newValue, oldValue, eOpts){
							 var grid =this.getImportutilityselectiontransferlist();
							 var form =this.getUploadoptionradiogroup();
							 var isUploadAll = newValue.isUploadAll;
							 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_SELECTION_STAGE_MARKS');
						 }   
					 },
					 
					 'uploadselectiontransferform button[itemId=programBatchUpload]':{
			        		click:function(obj){
			        			var $this=this;
			    	        	var importWin=$this.getUploadselectiontransferform()
			    	        	var grdStore;
			    	        	var form=$this.getUploadselectiontransferform();
			    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			    	        	$this.getHashOfFile(form);
					        	setTimeout(function() {
				    	        	form.getForm().submit({
				    	        		method : 'POST',
				    	        		url : submitUrl,
				    	        		success : function(form, action){
				    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
				    	    	        },
				    	        		failure: function(form, action) {
			   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				    	    	        }
				    	        	});
					        	},1000);

			        			 Ext.defer(function() {
			        				 var grid = $this.getImportutilityselectiontransferlist();
			        				 var form = $this.getUploadoptionradiogroup();
			        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
			        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_SELECTION_STAGE_MARKS');
			         	        }, 2000, this);
			        		}  
		    		 },
					 
	   		   		/*'uploadselectiontransferform button[itemId=programBatchUpload]':{
	   		   			click:function(obj){
	   		   				var $this=this;
	   		   				var importWin=$this.getUploadselectiontransferform();
	   		   				var grdStore;
	   		   				var form=$this.getUploadselectiontransferform();
	   		   				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	   		   				form.getForm().submit({
	   		   					method : 'POST',
	   		   					url : submitUrl,
	   		   					success : function(form, action){
	   		   						if(action.response.responseText == "SUCCESS") {
	   		   							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
	   		   							var grid = $this.getImportutilityselectiontransferlist();
	   		   							grid.getStore(			        				 var form = $this.getUploadoptionradiogroup();
			        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
			        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_SELECTION_STAGE_MARKS');
 						}
	   		   					},
	   		   					failure: function(form, action) {
	   		   						if(action.response.responseText == "SUCCESS") {
	   		   							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	   		   							var grid = $this.getImportutilityselectiontransferlist();
	   		   							grid.getStore().getProxy().extraParams = {
	   		   								moduleName:getCommonTranslation('IMPORT_BULK_SELECTION_STAGE_MARKS')
	   		   							};
	   		   							grid.getStore().load();
	   		   						}
	   		   					}
	   		   				});
	   		   			}
	   		   		},*/
	   		   
	   		   	'importutilityselectiontransferlist':{
	   		   			render:function(obj){
	   		   				var $this = this;
	   		   				var grid = $this.getImportutilityselectiontransferlist();
	   		   				var form = $this.getUploadoptionradiogroup();
	   		   				var isUploadAll = form.items.items[0].getValue().isUploadAll;
	   		   				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_SELECTION_STAGE_MARKS');
	   		   			},
	   		   			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   		   				if (e.target.tagName == 'A') {
	   		   					var fileType=null;
	   		   					if(cellIndex==1){
	   		   						fileType='successFile';
	   		   					}else if(cellIndex==6){
	   		   						fileType='errorFile';
	   		   					}else if(cellIndex==7){
	   		   						fileType='logFile';
	   		   					}
	   		   					var documentId = record.get("id");
	   		   					if (!isNullOrEmpty(documentId)) {
	   		   						this.getDownloadFile(documentId,fileType);
	   		   					}
	   		   				}
	   		   			}
	   		   		},

	   		   		'importutilityselectiontransferlist button[itemId=btnForce]':{
	   		   			click: function(obj) {
	   		   				var grid = this.getImportutilityselectiontransferlist();
	   		   				if (grid.getSelectionModel().getCount() > 0) {
	   		   					if(grid.getSelectionModel().getCount() > 1){
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	   		   					}else{
	   		   						var id = grid.getSelectionModel().selectionStart.data.id;
	   		   						var urlAppend="?jobName="+id;
	   		   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	   		   						Ext.Ajax.request({
	   		   							url: submitURL,
	   		   							method: 'GET',
	   		   							success: function(response) {
	   		   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	   		   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	   		   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	   		   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	   		   								}else if(response.responseText==="SUCCESS"){
	   		   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	   		   								}
	   		   							}
	   		   						});
	   		   					}
	   		   				} else {
	   		   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	   		   				}  
	   		   			}
	   		   		},
            /**
             * listener of the generic component of the acad loc dropdowns, listens to all the combos 
             * for resetting the "select stage" and disabling the tabStructure.
             * @author akshay.kalbhor
             */
            'selectionstagestructure selectionstageacadprogbatchseattype combo': {
                select: function(combo) {
                	 var $this = this;
                    /*
                     * code to reset the selection stage dropdown and disable the tabs
                     */
                	if(combo.itemId === 'seatTypeCombo') {
//                		this.loadSelectionStageCombo(combo, combo.getValue());
                        
//                		acadLocProgComponent = seatTypeCombo.up('selectionstageacadprogbatchseattype');
                		var form = combo.up('form');
                        
                        var dependentCombo = form.down('#selectionStageCombo');
                        var searchFilter = this.getSelectionstagesearchfilter();
               //         var quotaTypeCombo = searchFilter.down('#quotaTypeCombo');
              //          quotaTypeCombo.setDisabled(false);
                        /*
                         * Code to reset the value of the SelectionStage dropdown based on the selection of the seatype combo.
                         */
//                        this.resetSelectionStageCombo(seatTypeCombo);

                        var store = dependentCombo.getStore();
          //              var quotaTypeStore = quotaTypeCombo.getStore();
                        var url = store.getProxy().proxyConfig.api.read;
                        
                        //var quotaTypeUrl = quotaTypeStore.getProxy().proxyConfig.api.read;
                        
                        this.progBatchSeatConfig=combo.progBatchSeatConfigId;
                        url = url.concat('?programBatchSeatConfigId=' + combo.progBatchSeatConfigId);
                        store.getProxy().api.read = url;
                        store.reload();
                        
                       
                        
            /*            quotaTypeStore.getProxy().extraParams = {
                        	programBatchSeatConfigId: $this.getProgBatchSeatConfigId()
   					 };
                        quotaTypeStore.load();  */
                       
                    
                	}else if(combo.itemId === 'academyCombo') {
                		var form = combo.up('form');
                		var program = form.down('#programId');
                		var academyLocationId = combo.getValue();
                		var store = program.getStore();
                		store.getProxy().extraParams = {
                			academyLocationId: academyLocationId,
 					   };
 					   store.load();
                	}else if (combo.itemId == 'programId') {
                		var form = combo.up('form');
                		var seatTypeCombo=form.down('#seatTypeCombo');
                		seatTypeCombo.reset();
                		seatTypeCombo.store.removeAll()
                		var selectionStageCombo=form.down('#selectionStageCombo');
                		selectionStageCombo.reset();
                		selectionStageCombo.store.removeAll()
                	}else{
                        this.resetSelectionStageCombo(combo);
                	}
                    //this.enableDisableTabs(true);
                }
            },
            
            'selectionstageacadprogbatchseattype customcombobox[itemId=academyCombo]': {
            	select: function(obj, record) {
    				var academyLocationId = record[0].get("id");
    				var searchForm = this.getSelectionstagesearchfilter();
                	var form = searchForm.down('selectionstageacadprogbatchseattype');
                	var programGroupField=form.down('#programGroup');
                	var programGroupStore = programGroupField.getStore();
                	programGroupField.reset();
           
                	if(!isNullOrEmpty(academyLocationId)){
                		academyLocationIds=academyLocationId;
                	}else{
                		academyLocationIds = this.getCurrentAcademyLocation();	
                	}
                	programGroupStore.getProxy().extraParams = {
    					academyLocationId: academyLocationIds
    				};
                	programGroupStore.load();
    			}
            },
            'selectionstageacadprogbatchseattype customcombobox[itemId=programGroup]': {
            	render : function(combo){
    				var me = this;
    				var searchForm = this.getSelectionstagesearchfilter();
                	var form = searchForm.down('selectionstageacadprogbatchseattype');
    				var academyLocationId=form.down('#academyCombo').getValue();
    				var store = combo.getStore();
    				if(!isNullOrEmpty(academyLocationId)){
                		academyLocationIds=academyLocationId;
                	}else{
                		academyLocationIds = this.getCurrentAcademyLocation();	
                	}
    				store.getProxy().extraParams = {
    						academyLocationId : academyLocationIds
    				};
    				store.load();
    			},
    			
    			select: function(obj, record) {
    				var programGroupId = record[0].get("id");
    				var searchForm = this.getSelectionstagesearchfilter();
                	var form = searchForm.down('selectionstageacadprogbatchseattype');
                	var programField=form.down('#programId');
                	var programStore = programField.getStore();
                	programField.reset();
                	
                	var batchCombo=form.down('#batchCombo');
                	batchCombo.reset();
                	batchCombo.store.removeAll()
                	
                	var seatTypeCombo=form.down('#seatTypeCombo');
                	seatTypeCombo.reset();
                	seatTypeCombo.store.removeAll()
                	
                	var selectionStageCombo=form.down('#selectionStageCombo');
                	selectionStageCombo.reset();
                	selectionStageCombo.store.removeAll()
                	
                	var academyLocationId=form.down('#academyCombo').getValue();
                	if(!isNullOrEmpty(academyLocationId)){
                		academyLocationIds=academyLocationId;
                	}else{
                		academyLocationIds = this.getCurrentAcademyLocation();	
                	}
                	programStore.getProxy().extraParams = {
    					programGroupId: programGroupId,
    					academyLocationId: academyLocationIds
    				};
                	programStore.load();
    			}
    		},
    		'selectionstageacadprogbatchseattype customcombobox[itemId=programId]':{
        		select:function(obj,rec){
        			var data=rec[0].data.id;  
        			var filterForm=obj.up('form');
        			var batchField=filterForm.down('#batchCombo');
        			batchField.setDisabled(false);
        			batchField.reset();
        			/*batchField.getStore().getProxy().extraParams={
        				id:data
        			};*/
        			batchField.getStore().load();
        		}
            	},
            	
            	'selectionstageacadprogbatchseattype customcombobox[itemId=batchCombo]':{
            		select:function(obj,rec){
            			var data=rec[0].data.id;  
            			var filterForm=obj.up('form');
            			var seatTypeField=filterForm.down('#seatTypeCombo');
            			seatTypeField.setDisabled(false);
            			seatTypeField.reset();
            			seatTypeField.getStore().getProxy().extraParams={
            				id:data
            			};
            			seatTypeField.getStore().load();
            		}
                	},
            	
            	
            'selectionstagestructure selectionstagetransferuploaddownloadstructure downloadselectiontransferform combo': {
                select: function(combo,records) {
                	 var $this = this;
                    /*
                     * code to reset the selection stage dropdown and disable the tabs
                     */
                	if(combo.itemId === 'seatTypeCombo') {
                        
                		var form = combo.up('form');
                        
                        var dependentCombo = form.down('#selectionStageCombo');
                        var searchFilter = this.getSelectionstagesearchfilter();
                      //  var quotaTypeCombo = searchFilter.down('#quotaTypeCombo');
                       // quotaTypeCombo.setDisabled(false);

                        var store = dependentCombo.getStore();
                        //var quotaTypeStore = quotaTypeCombo.getStore();
                        var url = store.getProxy().proxyConfig.api.read;
                        
                        
                        url = url.concat('?programBatchSeatConfigId=' + records[0].get('id'));
                        store.getProxy().api.read = url;
                        store.reload();
                        
                       
                        
                       /* quotaTypeStore.getProxy().extraParams = {
                        	programBatchSeatConfigId: $this.getProgBatchSeatConfigId()
                        };
                        quotaTypeStore.load();*/ 
                       
                    
                	}else if(combo.itemId === 'academyCombo') {
                		var form = combo.up('form');
                		var program = form.down('#programId');
                		var academyLocationId = combo.getValue();
                		var store = program.getStore();
                		store.getProxy().extraParams = {
                			academyLocationId: academyLocationId,
                		};
                		store.load();
                		form.down('#batchCombo').reset();
                	    form.down('#seatTypeCombo').reset();
                	    form.down('#batchCombo').setDisabled(true);
                	    form.down('#seatTypeCombo').setDisabled(true);
                	}else{
                		this.resetSelectionImportStageCombo(combo);
                	}
                	//this.enableDisableTabs(true);
                }
            },

            'downloadselectiontransferform button#programBatchDownoladBtnId': {
            	click: function() {
            		var $this = this;
            		var form = this.getDownloadselectiontransferform().getForm();

            		var values = form.getValues();
            		var programId = values.PROGRAM_ID;
            		var academyLocationId = values.ACADEMY_LOCATION_ID;
            		var batchId = values.BATCH_ID;
            		var seatTypeId = values.SEAT_TYPE;
            		var selectionProcessStageId = values.PROGRAM_SELECTION_PROCESS_STAGE_ID;

            		var csvForm = Ext.create('Ext.form.Panel'); 
            		csvForm.getForm().submit({
            			target: '_blank',
            			method:'POST',
            			params :{
            				access_token : Ext.Ajax.defaultHeaders.access_token,
            				programId:programId,
            				academyLocationId:academyLocationId,
            				batchId:batchId,
            				seatTypeId:seatTypeId,
            				programProcessStageId:selectionProcessStageId
            			},
            			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            			url: SERVERURL.DOWNLOADTEMPSSMARK,
            			standardSubmit :true
            		});
            	}},
            	'selectionstagetransferuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
            		change: this.downloadUploadFormSelectionChange
            	},
            	'downloadselectiontransferform customcombobox[itemId=programId]':{
            		select:function(obj,rec){
            			var data=rec[0].data.id;  
            			var filterForm=obj.up('form');
            			var batchField=filterForm.down('#batchCombo');
            			var periodField=filterForm.down('#seatTypeCombo');
            			batchField.setDisabled(false);
            			batchField.reset();
            			periodField.setDisabled(true);
            			periodField.reset();
            			batchField.getStore().getProxy().extraParams={
            				id:data
            			};
            			batchField.getStore().load();
            		}

                	},
            	'downloadselectiontransferform customcombobox[itemId=batchCombo]':{
            		select:function(obj,rec){
            			var data=rec[0].data.id;  
            			var filterForm=obj.up('form');
            			var periodField=filterForm.down('#seatTypeCombo');
            			periodField.setDisabled(false);
            			periodField.reset();
            			periodField.getStore().getProxy().extraParams={
            				batchId:data
            			};
            			periodField.getStore().load();
            		}
            	},
            	/*  'downloadselectiontransferform customcombobox[itemId=seatTypeCombo]':{
			   select:function(obj,rec){
				   var data=rec[0].data.id;  
				   var filterForm=obj.up('form');
				   var periodField=filterForm.down('#selectionStageCombo');
				   periodField.setDisabled(false);

				   periodField.reset();
				   periodField.getStore().getProxy().extraParams={
					   programBatchSeatConfigId:data
				   };
				   periodField.getStore().load();
			   }
		   },*/
            'selectionstagestructure button[itemId=resetBtn]': {
            	click : function(btn){
            		var stageCombo = btn.up('form').down('#selectionStageCombo');
            		btn.up('form').down('selectionstageacadprogbatchseattype').reset();
            		//this.enableDisableTabs(true);
            		this.resetCombo(stageCombo);
            	}
            },
            'downloadselectiontransferform button[itemId=downloadResetBtn]': {
            	click : function(btn){
            		this.getDownloadselectiontransferform().getForm().reset();
            	}
            },
            
            /**/
            'uploadselectionstatusform':{
        		render:function(obj){
        			var $this=this;
    	        	var importWin=$this.getUploadselectionstatusform()
    	        	var moduleName = importWin.down('#moduleNameDSSF');
    	        	moduleName.getStore().load({
    	        		callback: function(records, operation, success) {
    	        			for(var i in records){
	    	        			if(records[i].data.value=="Bulk Individual Selection Stage Status"){
	    	        				moduleName.setValue(records[i].data.id);
	    	        				moduleName.setReadOnly(true)
	    	        			}
    	        			}
            		   }	
    	        	});
        		}  
            },
            'selectionstagestatustransferuploaddownloadstructure radiogroup[itemId=importDownloadgroupIdDSSR]':{
        		change: this.downloadUploadFormSelectionStatusChange
        	},
        	'downloadselectionstatusform customcombobox[itemId=academyComboDSSF]': {
        		change: function() {
        			 var $this = this;
        		        var form = $this.getDownloadselectionstatusform();

        		        var academicYear = form.down('#academyComboDSSF').getValue();
        		        var intakeYear = form.down('#intakeYearDSSF').getValue();
        		        var program = form.down('#programIdDSSF');

        		        program.reset();

        		        if (academicYear && intakeYear) {
        		            program.setDisabled(false);
        		            program.getStore().getProxy().extraParams = {
        		                academyLocationId: academicYear,
        		                intakeYearId: intakeYear
        		            };
        		            program.getStore().load();
        		            program.setValue(null);
        		        } else {
        		            program.setDisabled(true);
        		            program.setValue(null);
        		            program.getStore().removeAll();
        		        }
        		}
        	},
        	'downloadselectionstatusform customcombobox[itemId=intakeYearDSSF]':{
        		change: function(obj, rec) {
        			var $this = this;
        	        var form = $this.getDownloadselectionstatusform();

        	        var academicYear = form.down('#academyComboDSSF').getValue();
        	        var intakeYear = rec; 
        	        var program = form.down('#programIdDSSF');

        	        program.reset();

        	        if (intakeYear && academicYear) {
        	            program.setDisabled(false);
        	            program.getStore().getProxy().extraParams = {
        	                academyLocationId: academicYear,
        	                intakeYearId: intakeYear
        	            };
        	            program.getStore().load();
        	            program.setValue(null);
        	        } else {
        	            program.setDisabled(true);
        	            program.setValue(null);
        	            program.getStore().removeAll();
        	        }
        		}
        	},
        	'downloadselectionstatusform multiselectcombofield[itemId=programIdDSSF]': {
        	    change: function(combo, newValue, oldValue) {
        	        var $this = this;
        	        var form = $this.getDownloadselectionstatusform();

        	        var academicLocationId = form.down('#academyComboDSSF').getValue();
        	        var intakeYear = form.down('#intakeYearDSSF').getValue();
        	        var batch = form.down('#batchDSSF');
        	        batch.reset();

        	        if (Ext.isArray(newValue) && newValue.length > 0) {
        	            var programs = newValue.join(',');

        	            batch.setDisabled(false);
        	            batch.getStore().getProxy().extraParams = {
        	                programIds: programs,
        	                isActive: true,
        	                intakeYearId: intakeYear,
        	                academyLocationId: academicLocationId
        	            };
        	            batch.getStore().load();
        	            batch.setValue(null);
        	        } else {
        	            batch.setDisabled(true);
        	            batch.setValue(null);
        	            batch.getStore().removeAll();
        	        }
        	    }
        	},
        	'downloadselectionstatusform multiselectcombofield[itemId=batchDSSF]': {
        	    change: function(combo, newValue, oldValue) {
        	        var $this = this;
        	        var form = $this.getDownloadselectionstatusform();
        	        var seatType = form.down('#seatTypeDSSF');

        	        seatType.reset();

        	        if (Ext.isArray(newValue) && newValue.length > 0) {
        	            var batchs = newValue.join(',');

        	            seatType.setDisabled(false);
        	            seatType.getStore().getProxy().extraParams = {
        	            	batchIds: batchs
        	            };
        	            seatType.getStore().load();
        	            seatType.setValue(null);
        	        } else {
        	            seatType.setDisabled(true);
        	            seatType.setValue(null);
        	            seatType.getStore().removeAll();
        	        }
        	    }
        	},
        	'downloadselectionstatusform multiselectcombofield[itemId=seatTypeDSSF]': {
        	    change: function(combo, newValue, oldValue) {
        	        var $this = this;
        	        var form = $this.getDownloadselectionstatusform();
        	        var selectionStage = form.down('#selectionStageComboDSSF');

        	        selectionStage.reset();

        	        if (Ext.isArray(newValue) && newValue.length > 0) {
        	            var seatType = newValue.join(',');

        	            selectionStage.setDisabled(false);
        	            selectionStage.getStore().getProxy().extraParams = {
        	            	seatTypeIds: seatType
        	            };
        	            selectionStage.getStore().load();
        	            selectionStage.setValue(null);
        	        } else {
        	        	selectionStage.setDisabled(true);
        	        	selectionStage.setValue(null);
        	        	selectionStage.getStore().removeAll();
        	        }
        	    }
        	},
        	'downloadselectionstatusform button#programBatchDownoladBtnIdDSSF': {
            	click: function() {
            		var $this = this;
            		var form = this.getDownloadselectionstatusform().getForm();

            		var values = form.getValues();
            		var programIds = [];
            		var academyLocationId = values.ACADEMY_LOCATION_ID;
            		var batchIds = [];
            		var seatTypeIds = [];
            		var selectionProcessStageIds = [];
            		var intakeYearId = values.intakeYear;
            		var stageStatuses = [];
            		
            		for(var i=0; i<values.programId.length; ++i) {
            			programIds.push(values.programId[i].data.id);
            		}
            		programIds = programIds.join(',')
            		for(var i=0; i<values.batchId.length; ++i) {
            			batchIds.push(values.batchId[i].data.id);
            		}
            		batchIds = batchIds.join(',')
            		for(var i=0; i<values.seatTypeId.length; ++i) {
            			seatTypeIds.push(values.seatTypeId[i].data.id);
            		}
            		seatTypeIds = seatTypeIds.join(',')
            		
            		if(isNullOrEmpty(values.PROGRAM_SELECTION_PROCESS_STAGE_ID) || (values.PROGRAM_SELECTION_PROCESS_STAGE_ID && values.PROGRAM_SELECTION_PROCESS_STAGE_ID.length==1 && values.PROGRAM_SELECTION_PROCESS_STAGE_ID[0]=='')){
            			selectionProcessStageIds = '';
            		} else {
            			for(var i=0; i<values.PROGRAM_SELECTION_PROCESS_STAGE_ID.length; ++i) {
                			selectionProcessStageIds.push(values.PROGRAM_SELECTION_PROCESS_STAGE_ID[i].data.id);
                		}
            			selectionProcessStageIds = selectionProcessStageIds.join(',');
            		}
            		
            		if(isNullOrEmpty(values.STAGE_STATUS) || (values.STAGE_STATUS && values.STAGE_STATUS.length==1 && values.STAGE_STATUS[0]=='')) {
            			stageStatuses = '';
            		}else {
            			for(var i=0; i<values.STAGE_STATUS.length; ++i) {
                			stageStatuses.push(values.STAGE_STATUS[i].data.name);
                		}
                		stageStatuses = stageStatuses.join(',');
            		}
            		

            		var csvForm = Ext.create('Ext.form.Panel'); 
            		csvForm.getForm().submit({
            			target: '_blank',
            			method:'POST',
            			params :{
            				access_token : Ext.Ajax.defaultHeaders.access_token,
            				academyLocationId:academyLocationId,
            				intakeYearId:intakeYearId,
            				programIds:programIds,
            				batchIds:batchIds,
            				seatTypeIds:seatTypeIds,
            				programProcessStageIds:selectionProcessStageIds,
            				stageStatuses: stageStatuses
            			},
            			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            			url: SERVERURL.PATH_DOWNLOAD_SELECTION_STAGE_STATUS_UPDATE,
            			standardSubmit :true
            		});
            	}
        	},
        	'downloadselectionstatusform button[itemId=downloadResetBtnDSSF]': {
            	click : function(btn){
            		this.getDownloadselectionstatusform().getForm().reset();
            	}
            },
            'uploadselectionstatusform button[itemId=programBatchUploadDSSF]':{
        		click:function(obj){
        			var $this=this;
    	        	var importWin=$this.getUploadselectionstatusform()
    	        	var grdStore;
    	        	var form=$this.getUploadselectionstatusform();
    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
	    	        	form.getForm().submit({
	    	        		method : 'POST',
	    	        		url : submitUrl,
	    	        		success : function(form, action){
	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
	    	    	        },
	    	        		failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	    	    	        }
	    	        	});
		        	},1000);

        			 Ext.defer(function() {
        				 var grid = $this.getImportutilityselectionstatuslist();
        				 var form = $this.getStatusUploadOptionRadioGroup();
        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_INDIVIDUAL_SELECTION_STAGE_STATUS'); //IMPORT_BULK_SELECTION_STAGE_STATUS
         	        }, 2000, this);
        		}  
            },
            'uploadselectionstatusform button[itemId=resetBtnDSSF]':{
	        	click:function(obj){
	        		var $this=this;
	        		var uploadSelectionStatusForm = $this.getUploadselectionstatusform().getForm();
	        		uploadSelectionStatusForm.findField('file').reset();
	        		var uploadoptionradiogroupform  = $this.getStatusUploadOptionRadioGroup();
	        		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	        			isUploadAll: false
	        		});
	        		uploadSelectionStatusForm.isValid();
	        	}
            },
            'uploadselectionstatusform uploadoptionradiogroup[itemId=selectionstatusUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
				 change: function( radioGroup, newValue, oldValue, eOpts){
					 var grid =this.getImportutilityselectionstatuslist();
					 var form =this.getStatusUploadOptionRadioGroup();
					 var isUploadAll = newValue.isUploadAll;
					 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_SELECTION_STAGE_STATUS');
				 }   
			 },
			 'importutilityselectionstatuslist':{
		   			render:function(obj){
		   				var $this = this;
		   				var grid = $this.getImportutilityselectionstatuslist();
		   				var form = $this.getStatusUploadOptionRadioGroup();
		   				var isUploadAll = form.items.items[0].getValue().isUploadAll;
		   				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_SELECTION_STAGE_STATUS');
		   			},
		   			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		   				if (e.target.tagName == 'A') {
		   					var fileType=null;
		   					if(cellIndex==1){
		   						fileType='successFile';
		   					}else if(cellIndex==6){
		   						fileType='errorFile';
		   					}else if(cellIndex==7){
		   						fileType='logFile';
		   					}
		   					var documentId = record.get("id");
		   					if (!isNullOrEmpty(documentId)) {
		   						this.getDownloadFile(documentId,fileType);
		   					}
		   				}
		   			}
		   		},
		   		'importutilityselectionstatuslist button[itemId=btnRefreshDSSF]': {
	            	click: function(){
	            		 var $this = this;
	            	        var grid = $this.getImportutilityselectionstatuslist();

	            	        var store = grid.getStore();
	            	        if (!store) {
	            	            return;
	            	        }

	            	        store.getProxy().extraParams = {
	            	            moduleName: 'IMPORT_BULK_INDIVIDUAL_SELECTION_STAGE_STATUS'
	            	        };

	            	        store.load({
	            	            callback: function (records, operation, success) {
	            	                if (success) {
//	            	                   
	            	                } else {
//	            	                
	            	                }
	            	            },
	            	            scope: this
	            	        });

	            	        var form = $this.getStatusUploadOptionRadioGroup();
	            	        var isUploadAll = form.items.items[0].getValue().isUploadAll;
	            	        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_INDIVIDUAL_SELECTION_STAGE_STATUS');
	            	}
	            },
		   		'importutilityselectionstatuslist button[itemId=btnForceDSSF]':{
   		   			click: function(obj) {
   		   				var grid = this.getImportutilityselectionstatuslist();
   		   				if (grid.getSelectionModel().getCount() > 0) {
   		   					if(grid.getSelectionModel().getCount() > 1){
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
   		   					}else{
   		   						var id = grid.getSelectionModel().selectionStart.data.id;
   		   						var urlAppend="?jobName="+id;
   		   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
   		   						Ext.Ajax.request({
   		   							url: submitURL,
   		   							method: 'GET',
   		   							success: function(response) {
   		   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
   		   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
   		   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
   		   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
   		   								}else if(response.responseText==="SUCCESS"){
   		   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
   		   								}
   		   							}
   		   						});
   		   					}
   		   				} else {
   		   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
   		   				}  
   		   			}
   		   		},
            /**/

            /**
             * Listener of the basic search of application stage tab for the access control wise validations for hiding/showing the
             * buttons of the grid.
             * @author akshay.kalbhor
             */
            /*'selectionstagetabstructure applicationstagebasicsearch searchresultgrid[itemId=applicationStageBasicSearchGrid]': {
            	render: function(grid) {
	    			this.disableMoreActionPivileges(grid, this.getSELECTIONSTAGE_APPLICANTINSTAGE_PERMISSIONS(), '#applicationStageBasicSearchGrid');		
            	}
            },*/
            'applicationstagebasicsearch searchresultgrid[itemId=applicationStageBasicSearchGrid]': {
            	render: function(grid) {
            		var me = this;
            		var grid = me.getApplicationStageBasicSearchGrid();
            		me.gridRenderFunction(grid);
            	}
            },
//            'stagestatasticsgrid[itemId=stagestatasticsgrid]': {
//                afterrender: function(grid) {
//                	this.doAccessControlValidation(grid, this.getSELECTIONSTAGE_STAGESTATISTICS_PERMISSIONS());
//                    this.disableMoreActionPivileges(grid, this.getSELECTIONSTAGE_STAGESTATISTICS_PERMISSIONS(), '#stagestatasticsgrid');

                        /*var qtCombo = grid.down('combo#quotaTypesCombo');
                        
                         * call to load the Quota Type combo.
                         
                        this.loadComponentStore(qtCombo, 'programSelectionProcessId', this.getProgramSelectionProcessId());
                        
                         * call to load the stage statistics grid.
                         
                        //this.loadComponentStore(grid, 'programSelectionProcessStageId', this.getProgramSelectionProcessStageId());
                        this.loadGrids(grid, 'stagestatasticsgrid');*/
                
//                }
//            },
            'transferseatsgrid[itemId=transferseatsgrid]': {
                afterrender: function(grid) {
                	this.doAccessControlValidation(grid, this.getSELECTIONSTAGE_STAGESTATISTICS_PERMISSIONS());
                    this.disableMoreActionPivileges(grid, this.getSELECTIONSTAGE_TRANSFERSEATS_PERMISSIONS(), '#transferseatsgrid');

                	/*this.reconfigureTransferSeatsGrid(grid);
                	var stCombo = grid.down('combo#seatTypesCombo');
                	
                	 *  call to load the Seat Type combo.
                	 
                	this.loadSeatTypeCombo(stCombo);*/
                
                },
                /*activate: function( grid, eOpts ){
                	this.reconfigureTransferSeatsGrid(grid);
                	var stCombo = grid.down('combo#seatTypesCombo');
                	
                	 *  call to load the Seat Type combo.
                	 
                	this.loadSeatTypeCombo(stCombo);
                }*/
            },
           /* 'overridequotalimits': {
                render: function() {
                	var valid = this.getSelectionstagesearchfilter().isValid();
            		if(valid){
            			this.getSelectionstagesearchfilter().down('#searchButtonId').setDisabled(false);	
            		}
                }
            },*/
            /**
             * listener of the selection stage combo which is loaded according to the academyLocationDropdown component,
             * calls made are to "loadStage" which fetches the data according to the selected stage.
             * calls the "enableDisableTabs" which enables/disables the tabs after the selection of the selection stage combo.
             * Calls the "setProgramSelectionProcessStageId" which sets the program Selection Process Stage Id in the configs.
             * calls the "setSearchConfigs" which sets the selection process stage Id in the hidden field which is present in the basic search criteria fields.
             *   
             * @author akshay.kalbhor
             */
            'selectionstagestructure button#searchButtonId': {
            	click: function(btn) {

            		var tabpanels = this.getStagedetailstabstructure().items.items;
            		var tabLength = tabpanels.length;
            		if(tabLength > 0){
            			for(var i=tabLength-1; i >= 0; i--){
            				if(tabpanels[i].title === 'Stage Statistics' || tabpanels[i].title === 'Transfer Seats'||
									tabpanels[i].title === 'Override Quota Limits' || tabpanels[i].title === 'Stage Attribute'){
								tabpanels[i].destroy();
							}	
            			}
            			this.getStagedetailstabstructure().setActiveTab(tabpanels[0]);
            		}

            		var selectionStageCombo = btn.up('form').down('#selectionStageCombo');

            		this.loadStage(selectionStageCombo);
            		this.enableDisableTabs(false);
            		this.setProgramSelectionProcessStageId(selectionStageCombo.getValue());
            		this.setSearchConfigs(selectionStageCombo);

            		var grid = this.getApplicationStageBasicSearchGrid();
            		/*
            		 * Call to the gridRenderFunction as the grid should be loaded on the selection of the selection stage combo.
            		 * call to loadApplicantsInStage for loading the data in the search Criteria Grid. 
            		 */

//          		this.gridRenderFunction(grid);
            		var searchForm = this.getSelectionstagesearchfilter();
            		
            		// fetch stage type whether it is GRADE or MARK type            		
            		this.loadApplicantsInStage(searchForm,grid);
            		
            		var stageId = this.getSelectionProcessStageId();

            		this.doAccessControlValidation(grid, this.getSELECTIONSTAGE_STAGESTATISTICS_PERMISSIONS());
            		this.disableMoreActionPivileges(grid, this.getSELECTIONSTAGE_APPLICANTINSTAGE_PERMISSIONS(), '#applicationStageBasicSearchGrid');
            		this.disableSelectionstageBottomPanelPrivileges(this.getSelectionStageStructure(),this.getADMISSION_SELECTION_STAGE_BOTTOM_PANEL_PERMISSIONS());
            	}
            },
            'selectionstagesearchfilter button#resetButtonId': {
                click: function(btn) {
                	var form = this.getSelectionstagesearchfilter();
                	
                	var programGroupField = form.down('#programGroup');
                	var programField  =  form.down('#programId');
                	var batchField  = form.down('#batchCombo');
                	var seatTypeField  = form.down('#seatTypeCombo');
                	var stageField  =  form.down('#selectionStageCombo');
                	
                	batchField.setDisabled(true);
                	seatTypeField.setDisabled(true);
                	
                	var programGroupStore = programGroupField.getStore();
                	var programStore = programField.getStore();
                	var batchStore =  batchField.getStore();
                	var seatTypeStore = seatTypeField.getStore();
                	var stageStore = stageField.getStore();
                	
                	stageStore.loadData([]);
                	stageStore.loadRawData([]);
                	seatTypeStore.loadData([]);
                	seatTypeStore.loadRawData([]);
                	
                	var batchUrl = batchStore.proxy.api.read;
                	
                	if(batchUrl.includes('?')) {
                		var parts1 = [];
                		 parts1 = batchUrl.split("?", 2);
                		 batchUrl = parts1[0].trim();
                		 batchStore.proxy.api.read = batchUrl;
                	}
                	else {
                		batchStore.proxy.api.read = batchUrl;
            		}
                	
                	btn.up('form').getForm().reset();
                	
                	var academyLocationId = form.down('#academyCombo').getValue();
                	if(!isNullOrEmpty(academyLocationId)){
                		academyLocationIds=academyLocationId;
                	}else{
                		academyLocationIds = this.getCurrentAcademyLocation();	
                	}
                	
                	programGroupStore.getProxy().extraParams = {
    					academyLocationId: academyLocationIds
    				};
                	programStore.getProxy().extraParams = {};
                 	batchStore.getProxy().extraParams = {};
                	
                	programGroupStore.load();
                	programStore.load();
                	batchStore.load();
                }
            },
            'stagedetailstabstructure' : {
            	tabchange : function(tabPanel, newCard, oldCard, eOpts ){
            		var title = tabPanel.activeTab.title;
            		switch(title){
            		case 'Stage​ ​Fee ​Statistics': {
            				this.stageFeeStatistics();
            			break;
            		}
            		case 'Stage Statistics': {
            			var grid = this.getStageStatasticsgrid();
            			var qtCombo = grid.down('combo#quotaTypesCombo');
            			if(!isNullOrEmpty(this.getProgramSelectionProcessId())){
            				this.loadComponentStore(qtCombo, 'programSelectionProcessId', this.getProgramSelectionProcessId());
            				this.loadGrids(grid, 'stagestatasticsgrid');
            			}
            			break;
            		}
            		case 'Transfer Seats' :{
            			var grid = this.getTransferSeatsGrid(); 	
            			this.reconfigureTransferSeatsGrid(grid);
            			var stCombo = grid.down('combo#seatTypesCombo');
            			
            			if(!isNullOrEmpty(this.getSelectionProcessStageId() &&this.getProgramSelectionProcessId())){
            				this.loadSeatTypeCombo(stCombo);	
            			}
            			break;

            		}
            		case 'Override Quota Limits' :{
            			var valid = this.getSelectionstagesearchfilter().isValid();
            			if(valid){
            				this.getSelectionstagesearchfilter().down('#searchButtonId').setDisabled(false);
            			}
            			break;

            		}
            		}
            	}
            },
            
            /**
             * 
             */
            'transferseatsgrid multiselectcombofield#seatTypesCombo': {
                change: function(combo) {
                    var grid = combo.up('grid');
                    if (combo.getValue().length > 0) {
                        this.loadGrids(grid, 'transferseatsgrid');
                    } else {
                        grid.getStore().removeAll();
                    }
                }
            },

            /**
             * Listener of the quota combo from the Override Quota Limits tab.
             * @author Akshay.Kalbhor
             */
            'overridequotalimits': {
                activate: function(form) {
                    var combo = form.down('#quotaCombo');
                    form.getForm().reset();
                    if(!isNullOrEmpty(this.getProgramSelectionProcessStageId())){
                    this.loadComponentStore(combo, 'programSelectionProcessStageId', this.getProgramSelectionProcessStageId());
                    }
                }

            },
            'overridequotalimits combo#quotaCombo': {
                select: function(combo, records) {
                    this.setApproverName(combo);
                    this.setDependentValues(combo, records[0]);
                }
            },

            /**
             * listener for the save button of the Override quota limits page,
             * listens the click event of the button and performs the form save of the overrideQuotaLimits form.
             * @author Akshay.Kalbhor
             */
            'overridequotalimits button#saveSelectionSetting': {
                click: function(button) {
                    this.saveSelectionSetting(button);
                }
            },

            /**
             * listeners of the add column button of the transfer seats grid.
             */
            'transferseatsgrid button': {
                click: function(button) {
                    if (button.itemId === 'addColumn') {
                        this.validateAndShowAddColumnWindow(button);
                    } else if (button.itemId === 'previewChange') {
                        this.previwChanges(button);
                    } else if (button.itemId === 'applySeatTransfers') {
                        this.applySeatTransfers(button);
                    }
                }
            },

            /**
             * listener of the multi select combo field from the stage statistics grid,
             * Listens the change event.
             */
            'stagestatasticsgrid multiselectcombofield': {
                change: function(combo, newValue, oldValue, eOpts) {
                    var grid = combo.up('grid');
                    var store = grid.getStore();
                    store.filterGrid(newValue);
                }
            },
            'transferseatsgrid multiselectcombofield': {
                change: function(combo, newValue, oldValue, eOpts) {
                    var grid = combo.up('grid');
                    var store = grid.getStore();
                    store.filterGrid(newValue);
                }
            },

            /**
             * listener of the addColumn button from the transfer seats window which calls the code to add it in the model.
             * @author Akshay.Kalbhor
             */
            'transferseatswindow button#windowAddColumn': {
                click: function(button) {
                    this.addQuotaColumn(button);
                }
            },

            'applicationstagebasicsearch': {
                activate: function(form) {
                	var quotaTypeComboField= form.down('combo#quotaTypeCombo'),id=this.getProgBatchSeatConfigId();
	                this.loadComponentStore( quotaTypeComboField, 'programBatchSeatConfigId', id);
                }
            },
            /** 
             * listener for the click button of the applicant in stage basic search.
             * @author Akshay.Kalbhor
             */
            'applicationstagebasicsearch button[itemId=applicationStageBasicSearch]': {
                click: function(button) {
                    this.loadApplicantsInStage(button);
                }
            },

            'applicationstagebasicsearch combo[itemId=quotaTypeCombo]': {
                select: function(combo) {
                    this.loadQuotaCombo(combo);
                }
            },
            
            'searchresultgrid[itemId=applicationStageBasicSearchGrid]': {
                cellclick: function(gridView, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var searchResultGrid = gridView.up('grid');
                    // enable disable buttons by status in indivisual mode
                    
                    var status= this.getProgramSelectionProcessStageObject().currentStatus;
                    this.enableDisabelIndivisualModeButton(status);
                    
                    //on  cell click events for hyperlinked buttons
                    var columnName = searchResultGrid.columnManager.columns[cellIndex].dataIndex;
                    
                    var evaluationType = this.getProgramSelectionProcessStageObject().selectionProcessStage.evaluationType;
                    
                    if(evaluationType == "MARK"){
                    this.handleSearchResultCellClick(searchResultGrid, td, cellIndex, columnName, tr, rowIndex, e, eOpts,record);
                    }
                    if(record){
                    	if (e.target.tagName == 'A') {
                    		var applicationId = record.get("APPLICATION_PRIMERY_ID");
                    		if (columnName === "APPLICATION_ID" && !isNullOrEmpty(applicationId)) {
                    			this.openApplicantProfile(applicationId, false, grid);
                    		}
                    	}
                    }
                },
                render:function(grid){
                	this.disableMoreActionPivileges(grid, this.getSELECTIONSTAGE_APPLICANTINSTAGE_PERMISSIONS(), '#applicationStageBasicSearchGrid');
                }
                /*selectionchange: function(column, selected,eOpts ){
                	this.disableExtraButton(column,selected);                	
                }*/
            },
          /*  'stagestatasticsgrid button': {
            	click: function(button) {
            		var tabStructure = this.getSelectionStageTabStructure();
                    if (button.itemId === 'transferSeatBtn') {
                        tabStructure.setActiveTab(2);
                    } else if(button.itemId === 'overrideQuotaLimits') {
                    	tabStructure.setActiveTab(3);
                    } 
                }
            },*/
            
            /*** Export Button for Application Stage
             * @author Pravin.Surve
             */
            'searchresultgrid[itemId=applicationStageBasicSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
                click: function() {
                    this.exportApplicationStage(SERVERURL.PDFEXPORT, 'pdf', false);
                }
            },
            'searchresultgrid[itemId=applicationStageBasicSearchGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
                click: function() {
                    this.exportApplicationStage(SERVERURL.PDFEXPORT, 'pdf', true);
                }
            },
            'searchresultgrid[itemId=applicationStageBasicSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
                click: function() {
                    this.exportApplicationStage(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', false);
                }
            },
            'searchresultgrid[itemId=applicationStageBasicSearchGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
                click: function() {
                    this.exportApplicationStage(SERVERURL.EXCELEXPORT, 'vnd.ms-excel', true);
                }
            },
            'stagedetailsstructure treepanel[itemId=selectionstagetree]' : {
            	select : function(f, record, index, eOpts) {
            		var $this = this;
            		var tabDetail = record.data;
            		var id = tabDetail.id;
            		var childItem = tabDetail.qtitle;
            		var tabName = tabDetail.text;
            		var contentPanel = $this.getStagedetailstabstructure();
//            		/*var valid = this.getSelectionstagesearchfilter().isValid();
//            		if(valid){*/
            			var newTab = contentPanel.items.findBy(function(tab) {
            				return tab.title === tabName;
            			});
            			if(tabName !="Applicants in Stage")
						 {
            			/*if(!isNullOrEmpty(newTab) && newTab.isHidden()){
            				newTab = null;
            			}*/
            			contentPanel.remove(newTab,true);
            			//if (!newTab) {
            				contentPanel.add({
            					title: tabName,
            					closable : true,
            					autoScroll:false,
            					id : id,
            					xtype : childItem,
//          					layout : 'fit'

            				}).show();
            			//}
						 }
            			contentPanel.setActiveTab(newTab);
            			contentPanel.doLayout();
            			
            			var treePanel = this.getStagedetailsstructure().down('#selectionstagetree');
            			treePanel.getSelectionModel().deselectAll(true);
//          			}
            		/*} else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_BATCH'));

            		}*/
                      if(childItem == 'stageattributestructure'){
                          var selectionStageCombo = $this.getSelectionStageStructure().down('combo#selectionStageCombo');
                          var url = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
                          var selectionStageId = selectionStageCombo.getValue();
                          if(!isNullOrEmpty(selectionStageId)){
                        	  url = url.concat('/' + selectionStageId);
                              this.sendGetAjaxRequest(url, 'GET', '', function(opt, success, response) {
                                  if (success) {
                                      var data = Ext.decode(response.responseText);
                                      setTimeout(function() {
                                      var form = $this.getSelectionStageStructure().down().getForm();
                                     var formAtt = Ext.ComponentQuery.query('stageattributestructure')[0].getForm();
                                      form.setValues({
                                          'stageObject': response.responseText
                                      });
                                      form.setValues(data);
                                      var selectionProcessStage = $this.getProgramSelectionProcessStageObject().selectionProcessStage;
                                      formAtt.findField('selectionStage').setValue(selectionProcessStage.value);
                                      formAtt.findField('entryRule').setValue($this.getProgramSelectionProcessStageObject().entryRule);
                                      formAtt.findField('exitRule').setValue($this.getProgramSelectionProcessStageObject().exitRule);
                                      formAtt.findField('entryRuleDescription').setValue($this.getProgramSelectionProcessStageObject().entryRuleDescription);
                                      formAtt.findField('exitRuleDescription').setValue($this.getProgramSelectionProcessStageObject().exitRuleDescription);
                                      var whetherSelectionInBatches = $this.getProgramSelectionProcessStageObject().selectionProcessStage.whetherSelectionInBatches;
                                      if(whetherSelectionInBatches == true || whetherSelectionInBatches == 'true'){
                                      	formAtt.findField('selectionType').setValue('Batch');
                                      	formAtt.findField('startDate').setVisible(true);
                                      	formAtt.findField('startDate').setValue(dateRender(data.startDate) + ' To ' + dateRender(data.endDate));
                                      	
                                      	
                                      }else{
                                      	formAtt.findField('selectionType').setValue('Individual');
                                      	formAtt.findField('startDate').setVisible(false);
                                      }
                                      var tValue = getAdmissionTranslation(data.currentStatus);
                                      formAtt.findField('currentStatus').setValue(tValue);
                                      var stageId = $this.getSelectionProcessStageId();
                              		//Loading Documents Grid
                              		var documentGrid = $this.getStageattributestructure().down('#selectionStageDocuments');
                              		documentGrid.down('toolbar[dock=top]').hide();
                              		
                              		if(!isNullOrEmpty(stageId)){
                              			$this.loadComponentStore(documentGrid, 'selectionProcessStageId', stageId);
                              		}
                                      },10);
                                  }
                              });  
                          }
                      }
                    
            			
            		f.clearSelections();
            		
            		  Ext.defer(function() {
            			  var valid = this.getSelectionstagesearchfilter().isValid();
              			if(valid){
              				this.getSelectionstagesearchfilter().down('#searchButtonId').setDisabled(false);
              			}else{
              				this.getSelectionstagesearchfilter().down('#searchButtonId').setDisabled(true);
              			}
          	        }, 100, this);
            	},
            	render: function(structure) {
	                   this.doAccessSelectionStagePermissionTreePanel(structure);
	               }
            },
            'selectionstagesearchfilter combo[itemId=selectionStageCombo]':{
            	select : function(obj,record){
            		var programSelectionProcessStageId = record[0].get("id");
//          		var searchForm = obj.up('form');
            		var searchForm = this.getSelectionstagesearchfilter();

            		if(!isNullOrEmpty(this.getOverridequotalimits())){
            			var form = this.getOverridequotalimits();
            			var combo = form.down('#quotaCombo');
            			form.getForm().reset();
            			if(!isNullOrEmpty(programSelectionProcessStageId)){
            				this.loadComponentStore(combo, 'programSelectionProcessStageId', programSelectionProcessStageId);
            			}
            		}

            		var stageStatusCombo = searchForm.down('#stageStatus');
            		Ext.Ajax.request({
            			type : 'rest',
            			url : SERVERURL.FIND_STAGE_STATUS_BY_PROCESS_STAGE_ID,
            			params : {
            				selectionProcessId : programSelectionProcessStageId,
            			},
            			method : 'GET',
            			success : function(form, action) {
            				stageStatusCombo.setValue(form.responseText);
            			}
            		});
            		this.showFeeByPassMsg(programSelectionProcessStageId);
            	}
            },
            'selectionstagesearchfilter combo[itemId=academyCombo]':{
				render:function(combo){
					var $this=this;
					var store = combo.getStore();
					store.getProxy().extraParams = {
						id: this.getCurrentlyLoggedInUser().id
					};
					store.load({
						callback:function(records, operation, success){
							if (success) {
								if(records.length == 1){
									combo.setValue(records[0].get("id"));		
									var programStore=$this.getSelectionstagesearchfilter().down('#programId').getStore();
									programStore.getProxy().extraParams = {
											academyLocationId: records[0].get("id")
									};
									programStore.load();
								}
							}
						}
					});
				}
			},
            'downloadselectiontransferform combo[itemId=academyCombo]':{
				render:function(combo){
					var store = combo.getStore();
					store.getProxy().extraParams = {
						id: this.getCurrentlyLoggedInUser().id
					};
					store.load({
						callback:function(records, operation, success){
							if (success) {
								if(records.length == 1){
									combo.setValue(records[0].get("id"));									
								}
							}
						}
					});

				}
			},
			'selectionstageconditionsadmission checkboxfield[itemId=whetherDocumentApplicable]':{
  		    	change:function(value,newValue,oldValue){
  		    		var form = this.getSelectionstageconditionsadmission();
  		    		var selectionstageconditionsdocumentlist = form.down('#selectionstageconditionsdocumentlistId');
  		    		if(newValue){
  		    			selectionstageconditionsdocumentlist.setVisible(true);
  		    		}else{
  		    			selectionstageconditionsdocumentlist.setVisible(false);
  		    			var grid = this.getSelectionstageconditionsdocumentlist();
  		    			grid.getSelectionModel().deselectAll();	    			
  		    		}
  		    	}
            },
            'selectionstageconditionsadmission fieldcontainer button#btnSave': {
                click: function() {
                    this.saveConditionsForAdmissionWindow();
                }
            }
            
        });
    },
    
    
    /**
     * This grid is used to create grid by default columns. <br>
     * columns added for transfer seats must be removed.
     * @author Rupesh.Agrawal 
     */
    reconfigureTransferSeatsGrid:function(grid){
    	
    	var this$=this,columns= [];
    	columns.push({
    		hidden: true,
    		dataIndex: 'quotaTypeId'
    	});
    	columns.push(this$.getCoumnHeader('seatTypeName','SEAT_TYPE',false));
    	columns.push(this$.getCoumnHeader('quotaTypeName','QUOTA_TYPE',false));
    	columns.push(this$.getCoumnHeader('quota','QUOTA',false));
    	columns.push(this$.getCoumnHeader('overriddenMinSeat','MIN_SEAT',true, function(value, metaData , record ) {
			if(isNullOrEmpty(value))
				value=record.get('minSeat');
			return value;
			}));
    	columns.push(this$.getCoumnHeader('overriddenMaxSeat','MAX_SEAT',true,function(value, metaData , record ) {
			if(isNullOrEmpty(value))
				value=record.get('maxSeat');
			return value;
		}));
    	columns.push(this$.getCoumnHeader('numberOfApplication','TOTAL_STUDENTS',true));
    	columns.push(this$.getCoumnHeader('numberOfSelectedStudents','SELECTED',true));
    	columns.push(this$.getCoumnHeader('violation','QUOTA_VIOLATION',false));
  	
        Ext.suspendLayouts();
        grid.reconfigure(null, columns);
        Ext.resumeLayouts(true);
        
        // reset counter and list
        this$.transferId=0;
        this$.seatTransferList=null;
    },

    /**
     * This method is used to create header object for grid columns
     * @author Rupesh.Agrawal
     */
    getCoumnHeader: function(dataIndex, text,sort,renderFunction) {
        var field = {
    		text: getAdmissionTranslation(text),
    		dataIndex: dataIndex,
    		flex: 1,
    		sortable : sort,
    		renderer:renderFunction
        };
        return field;
    },
    
    loadCloseStageForm: function(button) {
        var this$ = this;
        var form = button.up('form');
        var approvedByCombo = form.down('#approvedBy');
        var approvedDateCombo = form.down('#approvedDate');
        var whetherApproverRequired = this$.getProgramSelectionProcessStageObject().selectionProcessStage.whetherApproverRequired;
        if (!isNullOrEmpty(approvedByCombo) || !isNullOrEmpty(approvedDateCombo)) {
            if (whetherApproverRequired == true) {
                approvedByCombo.allowBlank = false;
                approvedDateCombo.allowBlank = false;
            } else if (whetherApproverRequired == false) {
                approvedByCombo.allowBlank = true;
                approvedDateCombo.allowBlank = false;
            }
            approvedByCombo.validate();
            approvedDateCombo.validate();
        }
    },

    /***
     * This function is to export pdf and xcel
     * @author Pravin.Surve
     */
    exportApplicationStage: function(exportUrl, filetype, whetherAll) {
    	var stageObject=this.getProgramSelectionProcessStageObject();
        var searchResultGrid = this.getApplicationStageBasicSearchGrid();
//        var quickSearchForm = searchResultGrid.up('panel[xtype=applicationstagebasicsearch]').down('form#applicationstagebasicsearchform');
        var quickSearchForm = this.getSelectionstagesearchfilter();
        var pagingtoolbaroptions = this.getApplicationStageBasicSearchGrid().down('pagingtoolbar').getStore().lastOptions;
        var searchCriteriaString = this.createSearchCriteriaString(quickSearchForm);
        var jsonFormatFormData = this.createJsonFormat(quickSearchForm);
        
        // add code for check stage fee paid or unpaid
        if(Ext.isDefined(stageObject) && ((stageObject.whetherFeePlanApplicable || stageObject.whetherFeePlanApplicable==true) && stageObject.whetherFeePlanActive==true)){
    		if(!stageObject.whetherFeePlanByPass || stageObject.whetherFeePlanByPass==false){
    			jsonFormatFormData.searchCriterias.push({paramCode:'STAGE_FEE_STATUS', paramValues:["SETTLED"]});
    		}
    	}
        
        var visibleColumns = this.getVisibleColumns(searchResultGrid);
       //var reportTitle=TRANSLATIONS["SELECTION_STAGE_APPLICANTSINSTAGE"];
       var reportTitle=getCommonTranslation("SELECTION_STAGE_APPLICANTSINSTAGE");
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		 searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle);
    },
    createSearchCriteriaString: function(searchForm) {
        var me = this;
        var formValues = new Array();
        formValues = searchForm.getValues();
        var searchCriteriaString = "";
        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = me.getJsonObject(key, value);
                searchCriteriaString = searchCriteriaString + keyValueJsonObject.paramCode + "  : " + searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString = searchCriteriaString.substring(0, searchCriteriaString.length - 1);
        return searchCriteriaString;
    },

    loadQuotaCombo: function(combo) {
        var quotaCombo = combo.up('fieldcontainer').down('combo#quotaCombo');
        this.loadComponentStore(quotaCombo, 'quotaTypeId', combo.getValue());
    },

    /**
     * method to set the search config parameters on the selection of the selection stage dropdown.
     * @param {Object} the reference of the selectionstage combo
     * @author Akshay.Kalbhor
     */
    setSearchConfigs: function(combo) {
//        var basicSearchForm = this.getApplicationStageBasicSearch();
    	var basicSearchForm = this.getSelectionstagesearchstructure();
        var selectionStageId = combo.getValue();
        basicSearchForm.down('hidden#hiddenSearchFieldStageId').setValue(selectionStageId);
    },

    loadStageFunction: function() {
        var selectionStageCombo = this.getSelectionStageStructure().down('combo#selectionStageCombo');
        this.loadStage(selectionStageCombo);
        var grid = this.getApplicationStageBasicSearchGrid();
        this.loadApplicantsInStage(grid);
    },

    /** 
     * Server call for calculating rank. For NO_EVALUATION call rank by Date of birth.
     * @author Rupesh.Agrawal
     */
    calculateRank: function() {
        var this$ = this;
        var applicantSearchResultGrid = this.getApplicationStageBasicSearchGrid();
//        var applicantSearchResultGrid = component.up('panel[xtype=applicationstagebasicsearch]').down('searchresultgrid#applicationStageBasicSearchGrid');
        if (applicantSearchResultGrid.getStore().getCount() > 0) {

            var evaluationType = this$.getProgramSelectionProcessStageObject().selectionProcessStage.evaluationType;
            var url = SERVERURL.CALCULATE_RANK;
            if (evaluationType == 'NO_EVALUATION') 
            	url = SERVERURL.CALCULATE_RANK_BY_DOB;
            Ext.getBody().mask(getAdmissionTranslation('CALCULATING_RANK'), 'x-mask-loading');

            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND + "/" + this$.getProgramSelectionProcessStageId() + "/" + url,
                method: 'PUT',
                success: function(form, action) {
                    this$.loadStageFunction();
                    Ext.getBody().unmask();
                    showSuccessMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('CALCULATE_RANK_SUCCESS'));
                }
            });
        } else {
            showWarningMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('EMPTY_GRID_MESSAGE'));
        }
    },

    /**
     * Server call for generating closure list.
     * @author Rupesh.Agrawal
     *  
     */
    generatePrecloserList: function(button) {
        var this$ = this;
        var applicantSearchResultGrid = button.up('panel[xtype=selectionstagestructure]').down('searchresultgrid#applicationStageBasicSearchGrid');
        if (applicantSearchResultGrid.getStore().getCount() > 0) {
        	
	        showConfirmMessage(getAdmissionTranslation('GENERATE_PRECLOSER_LIST'), getAdmissionTranslation('GENERATE_PRECLOSER_LIST_CONFIRM_MESSAGE'),
	
	        function(btn, text) {
	            if (btn == 'yes') {
	                Ext.getBody().mask(getAdmissionTranslation('GENERATING_PRECLOSER_LIST'), 'x-mask-loading');
	                Ext.Ajax.request({
	                    type: 'rest',
	                    url: SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND + "/" + this$.getProgramSelectionProcessStageId() + "/" + SERVERURL.GENERATE_PRE_CLOSURELIST,
	                    method: 'PUT',
	                    success: function(form, action) {
	                        this$.loadStageFunction();
	                        Ext.getBody().unmask();
	                        showSuccessMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('GENERATE_PRECLOSER_LIST_SUCCESS'));
	                    }
	                });
	            }
	        });
        } else {
            showWarningMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('EMPTY_GRID_MESSAGE'));
        }
    },
    
    /**
     * This methid is used to evaluate applicant for current stage.
     * @author Rupesh.Agrawal
     */
	evaluateApplicant: function() {
        var this$ = this;
        
        var grid = this$.getApplicationStageBasicSearchGrid();
        var count = grid.getSelectionModel().getCount();
        if(count>0) {
        	var applicationStageIds = [];
        	for(var i=0;i<count;i++) {
        		var selectedRecord = grid.getSelectionModel().getSelection()[i];
        		applicationStageIds.push(selectedRecord.get('ID'));
        	}
        	applicationStageIds = applicationStageIds.join();
        	var applicationStageId = this$.getApplicationProgramStageId();
        	if (applicationStageIds.length>0) {
        		showConfirmMessage(getAdmissionTranslation('EVALUATE_APPLICANT'), getAdmissionTranslation('EVALUATE_APPLICANT_CONFIRM_MESSAGE'),
        				function(btn, text) {
        			if (btn == 'yes') {
        				var url = SERVERURL.APPLICATION_PROGRAM_STAGE + SERVERURL.EVALUATE_STAGE +"?applicationProgramStageIds="+applicationStageIds;
        				Ext.getBody().mask(getAdmissionTranslation('EVALUATING_APPLICANT'), 'x-mask-loading');
        				this$.sendSaveAjaxRequest(url, 'GET', null, function(opt, success, response) {
        					if (success) {
        						Ext.getBody().unmask();
        						this$.loadStageFunction();
        						showSuccessMessage(getAdmissionTranslation('EVALUATE_APPLICANT'), getAdmissionTranslation('APPLICANT_EVALUATED_SUCCESS'));
        					}
        				});
        			}
        		});
        	}
        	}
	},
	 
    /**
     * This methid is used to promote applicant to next stage.
     * @author Rupesh.Agrawal
     */
	promoteApplicantToNextStage: function() {
        var this$ = this;
        
        var grid = this$.getApplicationStageBasicSearchGrid();
        var count = grid.getSelectionModel().getCount();
        if(count>0) {
        	var promoteApplicantModels = [];
        	for(var i=0;i<count;i++) {
        		var selectedRecord = grid.getSelectionModel().getSelection()[i];
        		var promoteApplicantModel=new Object();
        		promoteApplicantModel.applicationProgramStageId=selectedRecord.get('ID');
        		promoteApplicantModel.programSelectionProcessStageId = this$.getProgramSelectionProcessStageId();
        		promoteApplicantModel.applicationId = selectedRecord.get('APPLICATION_PRIMERY_ID');
        		promoteApplicantModel.forceToPromote=false;
        		promoteApplicantModels.push(promoteApplicantModel);
        	}

        	var applicationStageId = this$.getApplicationProgramStageId();
        	if (promoteApplicantModels.length>0) {
        		showConfirmMessage(getAdmissionTranslation('PROMOTE_APPLICANT_TO_NEXT_STAGE'), getAdmissionTranslation('PROMOTE_APPLICANT_TO_NEXT_STAGE_CONFIRM_MESSAGE'),
        				function(btn, text) {
        			if (btn == 'yes') {
        				/*var promoteApplicantModel=new Object();
        				promoteApplicantModel.applicationProgramStageId=applicationStageId;
        				promoteApplicantModel.programSelectionProcessStageId = this$.getProgramSelectionProcessStageId();
        				promoteApplicantModel.applicationId = this$.getApplicationId();
        				promoteApplicantModel.forceToPromote=false;*/
        				this$.sendPromoteApplicantRequest(promoteApplicantModels,true);
        			}
        		});
        	}
       }
	}, /** Download upload form change **/

		downloadUploadFormSelectionChange : function(cb, nv, ov){
			var $this = this;
			var mainStruct = this.getSelectionstagetransferuploaddownloadstructure();
			var importGrid = $this.getImportutilityselectiontransferlist();
			var downloadTemplateForm = $this.getDownloadselectiontransferform();
			var uploadTemplateForm = $this.getUploadselectiontransferform();

			if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
				uploadTemplateForm.hide();
				downloadTemplateForm.show();
				importGrid.setVisible(false);
				downloadTemplateForm.getForm().reset();

			}else{
				$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
				downloadTemplateForm.hide();
				uploadTemplateForm.show();
				importGrid.setVisible(true);
			}
		},

		sendPromoteApplicantRequest:function(promoteApplicantModel,nested){
			var this$ = this;
			var url = SERVERURL.APPLICATION_PROGRAM_STAGE + SERVERURL.PROMOTE_TO_NEXT_STAGE;
			Ext.getBody().mask(getAdmissionTranslation('PROMOTING_APPLICANT'), 'x-mask-loading');
			this$.sendSaveAjaxRequest(url, 'POST', promoteApplicantModel, function(opt, success, response) {
				if (success) {
					Ext.getBody().unmask();
					this$.loadStageFunction();
					showSuccessMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('APPLICANT_PROMOTED_TO_NEXT_STAGE_SUCCESS'));
				}else{
					if(Ext.decode(response.responseText)[0] && Ext.decode(response.responseText)[0].key == 'cant_send_offer_letter_document_not_mapped'){
						/*showWarningMessage(getAdmissionTranslation('WARNING'), getErrorTranslation('cant_send_offer_letter_document_not_mapped'));*/
					}else if(Ext.decode(response.responseText)[0]&& Ext.decode(response.responseText)[0].key == "CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED"){
						showWarningMessage(getCommonTranslation('WARNING'),getErrorTranslation('CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED'));
					}else if(Ext.decode(response.responseText)[0]&& Ext.decode(response.responseText)[0].key == "ADMISSION_OFFER_PROCESS_NOT_OPENED"){
						showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_OFFER_PROCESS_NOT_OPENED'));
					}else if(Ext.decode(response.responseText)[0]&& Ext.decode(response.responseText)[0].key == "PROVISIONAL_OFFER_PROCESS_NOT_OPENED"){
						showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('PROVISIONAL_OFFER_PROCESS_NOT_OPENED'));
					} else if(this$.checkVioletionErrorMessage(response)  && nested){
	                showConfirmMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('VOILATION_EXCEPTION_CONFIRM_MESSAGE'),
	            		function(btn, text) {
	                        if (btn == 'yes') {
	                        	promoteApplicantModel.forceToPromote=true;
	                        	this$.sendPromoteApplicantRequest(promoteApplicantModel);
	                        }
	                });
            	}
            }
        });
	},
	
	/**/
	downloadUploadFormSelectionStatusChange : function(cb, nv, ov){
		var $this = this;
		var mainStruct = this.getSelectionstagestatustransferuploaddownloadstructure();
		var importGrid = $this.getImportutilityselectionstatuslist();
		var downloadTemplateForm = $this.getDownloadselectionstatusform();
		var uploadTemplateForm = $this.getUploadselectionstatusform();

		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			uploadTemplateForm.hide();
			downloadTemplateForm.show();
			importGrid.setVisible(false);
			downloadTemplateForm.getForm().reset();

		}else{
			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
        		isUploadAll: false
        	});
			downloadTemplateForm.hide();
			uploadTemplateForm.show();
			importGrid.setVisible(true);
			var store = importGrid.getStore();
	        if (!store) {
	            return;
	        }
	        store.getProxy().extraParams = {
	            moduleName: 'IMPORT_BULK_INDIVIDUAL_SELECTION_STAGE_STATUS' 
	        };
	        store.load({
	            callback: function (records, operation, success) {
	                if (success) {
	                } else {
	                }
	            },
	            scope: this
	        });

	        var form = $this.getStatusUploadOptionRadioGroup();
	        var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        $this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'IMPORT_BULK_INDIVIDUAL_SELECTION_STAGE_STATUS');
		}
	},
	/**/
	//TOD: [RAL] check for proper exeption handlings
	/*
	 * In indivisual selection need to check violation for confiramtion.
	 */
	checkVioletionErrorMessage : function (response) {
		var flag=false;
		var responseStatus = response.responseText;
		var errorMessages = "";
		if (response.status == 412 || response.status == 500) {
			if (responseStatus.constructor === String)
				responseStatus = Ext.decode(responseStatus);

			if (responseStatus.constructor === Array) {
				Ext.each(responseStatus, function(error) {
					var errorMsg = ERRORMESSAGE[error];
					
					if(error== 'VIOLATION_EXCEPTION'){
						flag= true;
						errorMsg=  getAdmissionTranslation('VIOLATION_EXCEPTION_CONFIRM_MESSAGE');
					}
					if (!errorMsg)
						errorMsg = error;
					errorMessages += errorMsg + " <br> ";
				});
			} else {
				var errorMsg = ERRORMESSAGE[responseStatus];
				if (!errorMsg)
					errorMsg = responseStatus;
				errorMessages = errorMsg;
			}
		}
		if(!flag)
			showErrorMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'),errorMessages);
		return flag;
	},		
	
    closeStage: function(button) {
        var this$ = this;
        var formWindow = button.up('window');
        var formValues = formWindow.down('form').getValues();
        formValues.programSelectionProcessStageId = this$.getProgramSelectionProcessStageId();
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PSP_STAGE_CLOSE_STAGE,
            method: 'POST',
            jsonData: formValues,
            success: function(form, action) {
                this$.loadStageFunction();
                Ext.getBody().unmask();
                this$.closeFormWindow(formWindow);
                showSuccessMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('CLOSE_STAGE_SUCCESS'));
            },
            failure: function(form, action) {
            	if(Ext.decode(form.responseText)[0].key == "ADMISSION_OFFER_PROCESS_NOT_OPENED") {
            		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_OFFER_PROCESS_NOT_OPENED'));
            	}else if(Ext.decode(form.responseText)[0].key == "PROVISIONAL_OFFER_PROCESS_NOT_OPENED") {
            		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('PROVISIONAL_OFFER_PROCESS_NOT_OPENED'));
            	}
	        }
        });
    },

    /*showRuleCriteriaPopup: function() {
        var this$ = this;
        var formWindow = this.getStageCriteriaPoppupWindow();
        if (!formWindow) {
            Ext.widget('stagecriteriapoppupwindow');
            formWindow = this.getStageCriteriaPoppupWindow();
        }

        this.getStageCriteriaForm().getForm().setValues(this$.getProgramSelectionProcessStageObject());
        formWindow.show();
    },*/

    saveApplicationProgramMarks: function() {
        var formValues = this.getEnterMarksPopupForm().getValues();
        var this$ = this;
        var searchForm = this$.getSelectionstagesearchfilter();
        var grid = this$.getApplicationStageBasicSearchGrid();
        this.removeMaxMark(formValues);
        var remarks = formValues[formValues.length-1].remarks;
        formValues.pop();
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

        var url = SERVERURL.APPLICATION_PROGRAM_STAGE_MARK_UPDATE_ALL;
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            jsonData: {
                selectionProcessStageId: this$.getSelectionProcessStageId(),
                remarks: remarks,
                applicationProgramStageMarks: formValues
            },
            method: 'PUT',
            success: function(form, action) {
                Ext.getBody().unmask();
                this$.closeEnterMarksPopupWindow();
                showSuccessMessage(getAdmissionTranslation('APPICATION_PROGRAM_STAGE_MARKS_MSG'), getAdmissionTranslation('APPICATION_PROGRAM_STAGE_MARKS_UPDATE_MSG'));
                this$.loadApplicantsInStage(searchForm,grid);
            }
        });

    },
    
    removeMaxMark: function(formValues) {
        Ext.each(formValues, function(obj) {
            delete obj.maxMarks;
        });
    },
    
    /**
     * This method shows the enter mark form window.
     */
    showEnterMarkFormWindow: function(selectedRecord) {
        var formWindow = this.getEnterMarksPopupWindow();
        if (!formWindow) {
            Ext.widget('enterMarksPopupWindow');
            formWindow = this.getEnterMarksPopupWindow();
        }
        formWindow.show();
        this.editEnterMarks(selectedRecord);
        this.loadConditionalMarks(selectedRecord);
    },

    closeEnterMarksPopupWindow: function() {
        this.getEnterMarksPopupWindow().close();
    },


    showChangeStatusFormWindow: function() {
        var formWindow = this.getChangeStatusPoppupWindow();
        if (!formWindow) {
            Ext.widget('changeStatusPoppupWindow');
            formWindow = this.getChangeStatusPoppupWindow();
        }
        formWindow.show();

        var form = formWindow.down('form').getForm();
        form.setValues('applicationProgramStageId', this.getApplicationProgramStageId());
        formWindow.down('form').down('nestedTextField#approvedByNestedTextField').setValue(this.getCurrentlyLoggedInUser());
    },

    closeChangeStatusFormWindow: function(window) {
        window.close();
    },

    loadApplicationStageStatus: function(form) {
        var url = this.concateUrl(SERVERURL.APPLICATION_PROGRAM_STAGE_STATUS, 'applicationProgramStageId', this.getApplicationProgramStageId());
        this.sendGetAjaxRequest(url, 'GET', '', function(opt, success, response) {
            if (success) {
                var data = response.responseText;
                var unsuccessfulReasonComboBox = form.down('#unsuccessfulReason');
                var status = form.down('#status');
                if (data) {
                    var data = Ext.decode(response.responseText);
                    if(data.status == 'REJECTED'){
                		unsuccessfulReasonComboBox.setVisible(true);
                    }
                    delete data.approvedBy;
                    form.getForm().setValues(data);
                }

            }
        });
    },

    saveApplicationProgramStageStatus: function(window,flag) {
        var formValues = this.getApplicationProgramStageStatusForm().getValues();
        var this$ = this;
        formValues = this$.getMultipleApplicationProgramStageId(flag);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

        Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.APPLICATION_PROGRAM_STAGE + SERVERURL.CHANGE_STATUS,
            jsonData: formValues,
            method: 'POST',
            success: function(form, action) {
                var grid = this$.getApplicationStageBasicSearchGrid();
                this$.loadApplicantsInStage(grid);
                this$.closeChangeStatusFormWindow(window);
                Ext.getBody().unmask();
                showSuccessMessage(getAdmissionTranslation('CHANGE_STATUS'), getAdmissionTranslation('APPICATION_PROGRAM_STAGE_STATUS_UPDATE'));
            },failure: function(form, action) {
            	 Ext.getBody().unmask();
				 var data = Ext.decode(form.responseText);
				if(data[0].key == 'cant_send_offer_letter_document_not_mapped'){
					showWarningMessage(getAdmissionTranslation('WARNING'), getErrorTranslation('cant_send_offer_letter_document_not_mapped'));
				}else if(data[0].key == "CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED"){
					showWarningMessage(getCommonTranslation('WARNING'),getErrorTranslation('CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED'));
				}else if(data[0].key == "ADMISSION_OFFER_PROCESS_NOT_OPENED"){
					showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_OFFER_PROCESS_NOT_OPENED'));
				}else if(data[0].key == "PROVISIONAL_OFFER_PROCESS_NOT_OPENED"){
					showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('PROVISIONAL_OFFER_PROCESS_NOT_OPENED'));
				} else if(data[0].key == "VIOLATION_EXCEPTION" && !flag){
                showConfirmMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('VOILATION_EXCEPTION_CONFIRM_MESSAGE'),
            		function(btn, text) {
                        if (btn == 'yes') {
                        	this$.saveApplicationProgramStageStatus(window,true);
                        }
                });
        	}
        }
        });
    },

    loadStage: function(selectionStageCombo) {
        var this$ = this;
        /*
         * adding the value to the url and passing the url for loading the stage on basis of the record
         * selected in the selection stage combo.
         * @author akshay.kalbhor
         */
        var url = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
        var selectionStageId = selectionStageCombo.getValue();
        url = url.concat('/' + selectionStageId);
        this.sendGetAjaxRequest(url, 'GET', '', function(opt, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                var form = this$.getSelectionStageStructure().down().getForm();
               //var form = this$.getStageattributestructure().getForm();
                form.setValues({
                    'stageObject': response.responseText
                });
                form.setValues(data);
                var selectionProcessStage = this$.getProgramSelectionProcessStageObject().selectionProcessStage;
                var whetherSelectionInBatches = this$.getProgramSelectionProcessStageObject().selectionProcessStage.whetherSelectionInBatches;
                var grid = this$.getApplicationStageBasicSearchGrid();
        		
                if(grid != undefined && grid !=null) {
                
                	var selectionStageSearchGridPnl = Ext.ComponentQuery.query('#selectionStageSearchGridPnl')[0];
            		if(whetherSelectionInBatches == true || whetherSelectionInBatches == 'true'){
                    	grid.whetherSelectionInBatches = whetherSelectionInBatches;
                    	selectionStageSearchGridPnl.down('searchresultgrid').destroy();
                    	selectionStageSearchGridPnl.add({
                    		xtype: 'searchresultgrid',
                    		itemId: 'applicationStageBasicSearchGrid',
                    		isGridConfigurable: true,
            				enableColumnHide: false,
            				cbViewCode: CONSTANTS.CB.ADMISSION_SELECTION_STAGE_CONFIGCODE,
                    		listeners:{
                    			render: function(grid) {
                    				this$.gridRenderFunction(grid);
                    				var searchForm = this$.getSelectionstagesearchfilter();
                    				this$.loadApplicantsInStage(searchForm,grid);
                            	}
                    		}
                    	});
                    	selectionStageSearchGridPnl.doLayout();
            		} else{
            			grid.whetherSelectionInBatches = whetherSelectionInBatches;
            			
            			selectionStageSearchGridPnl.down('#applicationStageBasicSearchGrid').destroy();
                    	selectionStageSearchGridPnl.add({
                    		xtype: 'searchresultgrid',
                    		itemId: 'applicationStageBasicSearchGrid',
                    		selType :'checkboxmodel',
                    		isGridConfigurable: true,
            				enableColumnHide: false,
            				cbViewCode: CONSTANTS.CB.ADMISSION_SELECTION_STAGE_CONFIGCODE,
            				multiSelect :true,
            				selModel: {
            					checkOnly: true,
            	                allowDeselect: false
            				},
            				listeners:{
                    			afterrender: function(grid) {
                    				this$.gridRenderFunction(grid);
                    				var searchForm = this$.getSelectionstagesearchfilter();
                    				this$.loadApplicantsInStage(searchForm,grid);
                    				
                            	}
                    		}
                    	});
                    	selectionStageSearchGridPnl.doLayout();
            			
            		}
            		grid.doComponentLayout();
                }
                this$.enableDisableStageLavelButtons(data.currentStatus, data.selectionProcessStage.code,selectionStageCombo);
                /*
                 * Calling the Eval ParamWeightage to generate the form in the background.
                 */
                this$.getEvalParamWeightage();
            }
        });
    },

    /**
     * This method is called when we select any stage from selection stage screen.<br>
     * Hide or show the stage level buttons, and enable disabel the applicant level buttion.
     * @author rupesh.agrawal
     * @param  {String} status of the stage [ 'INPROGRESS', 'EXIT_CRITERIA_CHECKED',etc]
     * @param  {String} selection Mode of the stage ['MANUAL','AUTOMATIC']
     */
    enableDisableStageLavelButtons: function(stageSatus, selectionMode,selectionStageCombo) {
        var this$ = this;

        // mark level buttons enable disable by NO_EVALUATION value
        this$.enableDisableApplicantMarkLavelButtons(true);

        //Hide show button on selecton mode
        this$.hideShowSelectonModeButton();

        this$.disableSeatTransferTabs(false);
        
        this$.disableApplicantLavelButtons(true,selectionMode);
        var calculateRankButton = this.getSelectionStageStructure().down('button#calculateRank');
        var generatePrecloserListButton = this.getSelectionStageStructure().down('button#generatePrecloserList');
        var calculateFinalResultButton = this.getSelectionStageStructure().down('button#calculateFinalResult');
        var closeStageButton = this.getSelectionStageStructure().down('button#closeStage');

		var evaluateApplicant = this.getSelectionStageStructure().down('button#evaluateApplicant');
		var promoteApplicantToNextStage = this.getSelectionStageStructure().down('button#promoteApplicantToNextStage');
		
		var promoteWithConditions = this.getSelectionStageStructure().down('button#promoteWithConditions');
         
		evaluateApplicant.setDisabled(true);
		promoteApplicantToNextStage.setDisabled(true);
        
        calculateRankButton.setDisabled(true);
        generatePrecloserListButton.setDisabled(true);
        calculateFinalResultButton.setDisabled(true);
        
        promoteWithConditions.setDisabled(true);

        var whetherSelectionInBatches = this.getProgramSelectionProcessStageObject().selectionProcessStage.whetherSelectionInBatches;

        if (whetherSelectionInBatches == true || whetherSelectionInBatches == 'true') {
        	closeStageButton.setDisabled(true);
        	
        	/*var treePanel = this.getStagedetailsstructure().down('#selectionstagetree');
       	    var bindingStore = this.getStore('admission.selectionStage.SelectionStageTreeStore');
       	treePanel.bindStore(bindingStore);*/
        }else{
        	 closeStageButton.setDisabled(false);
        	 this$.disableSeatTransferTabs(true);
        	
        }
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getADMISSION_SELECTION_STAGE_BOTTOM_PANEL_PERMISSIONS());
        
        Ext.each(permissionList, function(privilege) {

        	if (privilege === 'PROMOTEWITHCONDITIONS') {
        		if(!isNullOrEmpty(promoteWithConditions)){
        			
        			var comboStageStore = selectionStageCombo.getStore();
        			var comboStageStoreCount = comboStageStore.totalCount;
        			if(comboStageStore.find('id',selectionStageCombo.getValue()) != -1){
        				comboSequenceValue = comboStageStore.data.items[comboStageStore.find('id',selectionStageCombo.getValue())].data.sequence;
        			}
        			if((whetherSelectionInBatches == true || whetherSelectionInBatches == 'true')){
        					promoteWithConditions.setVisible(false);
        			}else{
        				if (comboStageStoreCount != comboSequenceValue) {
        					promoteWithConditions.setVisible(false);
        				}else
        				{
        					promoteWithConditions.setVisible(true);
        				}
        				
        			}
        			
        		}   
       
        	}

        });
        
        // Disable change status button for automatic mode
            this$.disableApplicantChangeStatusButtons(true,selectionMode);

        if (stageSatus == 'INPROGRESS'){
        	 calculateRankButton.setDisabled(false);
        	 this$.disableApplicantLavelButtons(false,selectionMode);
        	 generatePrecloserListButton.setDisabled(false);
        	 calculateFinalResultButton.setDisabled(false);
       } else if(stageSatus == 'EXIT_CRITERIA_CHECKED' || stageSatus == 'READY_TO_GENERATE_CLOSURELIST') {
           generatePrecloserListButton.setDisabled(false);
           calculateFinalResultButton.setDisabled(false);
        } else if (stageSatus == 'PRE_CLOSURELIST_GENERATED') {
            generatePrecloserListButton.setDisabled(false);
            calculateFinalResultButton.setDisabled(false);
        } else if (stageSatus == 'READY_TO_CLOSE') {
            closeStageButton.setDisabled(false);
        } else if (stageSatus == 'CLOSED') {
        	 this$.disableApplicantChangeStatusButtons(true,selectionMode);
        	 closeStageButton.setDisabled(true);
        	 this$.disableSeatTransferTabs(true);
        } else{
        	 this$.disableApplicantChangeStatusButtons(true,selectionMode);
        }

        if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
        	closeStageButton.setVisible(false);
        }
        /*if (stageSatus !== 'CLOSED'){
        	var treePanel = this.getStagedetailsstructure().down('#selectionstagetree');
        	 var bindingStore = this.getStore('admission.selectionStage.SelectionStageTreeStore');
        	treePanel.bindStore(bindingStore);
        }*/
    },

    enableDisableApplicantMarkLavelButtons: function(disabled) {
        var evaluationType = this.getProgramSelectionProcessStageObject().selectionProcessStage.evaluationType;

        if (evaluationType == 'NO_EVALUATION' || disabled == true ) {
            this.disableApplicantMarkLavelButtons(true);
        } else this.disableApplicantMarkLavelButtons(false);
    },

    disableApplicantLavelButtons: function(disabled,selectionMode) {
        this.disableApplicantChangeStatusButtons(disabled,selectionMode);
        this.enableDisableApplicantMarkLavelButtons(disabled);
    },
    disableApplicantChangeStatusButtons: function(disabled,selectionMode) {
    	
    	var whetherSelectionInBatches = this.whetherSelectionInBatches();
    	  
//        var grid = this.getSelectionStageStructure().down('grid');
    	  var grid = this.getApplicationStageBasicSearchGrid();
        var changeStatusButton = grid.down('#changeStatus');
        if((selectionMode == 'MANUAL' || whetherSelectionInBatches==false) && disabled==false){
        	 disabled=false;
        }else{
        	disabled=true;
        }
        
        if (!isNullOrEmpty(changeStatusButton)) {
        	changeStatusButton.setDisabled(disabled);	
        }
    },
    disableApplicantMarkLavelButtons: function(disabled) {
        var grid = this.getSelectionStageStructure().down('grid');
        var enterMarkButton = grid.down('#enterMark');
        var importMarkButton = grid.down('#importMark');

        if (!isNullOrEmpty(enterMarkButton) && !isNullOrEmpty(importMarkButton)) {
        	enterMarkButton.setDisabled(disabled);
            importMarkButton.setDisabled(disabled);	
        }
    },

    whetherSelectionInBatches: function() {
    	  var whetherSelectionInBatches = this.getProgramSelectionProcessStageObject().selectionProcessStage.whetherSelectionInBatches;

          if (whetherSelectionInBatches == true || whetherSelectionInBatches == 'true') {
              whetherSelectionInBatches = true;
          } else {
              whetherSelectionInBatches = false;
          }
          return whetherSelectionInBatches;
    },
    
    hideShowSelectonModeButton: function() {
        var whetherSelectionInBatches = this.whetherSelectionInBatches();
        this.showBatchesModebutton(whetherSelectionInBatches);
        this.showIndivisualModeButton(!whetherSelectionInBatches);
    },

    showBatchesModebutton: function(visible) {
        var calculateRankButton = this.getSelectionStageStructure().down('button#calculateRank');
        var generatePrecloserListButton = this.getSelectionStageStructure().down('button#generatePrecloserList');
        var calculateFinalResultButton = this.getSelectionStageStructure().down('button#calculateFinalResult');

        calculateRankButton.setVisible(visible);
        generatePrecloserListButton.setVisible(visible);
        calculateFinalResultButton.setVisible(visible);

    },
    showIndivisualModeButton: function(visible) {
        var evaluateApplicant = this.getSelectionStageStructure().down('button#evaluateApplicant');
        var promoteApplicantToNextStage = this.getSelectionStageStructure().down('button#promoteApplicantToNextStage');
        //var promoteWithConditions = this.getSelectionStageStructure().down('button#promoteWithConditions');

        evaluateApplicant.setVisible(visible);
        promoteApplicantToNextStage.setVisible(visible);
        //promoteWithConditions.setVisible(visible);
    },
    /**
     * This method is used to enable or disable the indivisual Mode Button by status.
     */
    enableDisabelIndivisualModeButton: function(status) {
    	
        if(this.getProgramSelectionProcessStageObject().selectionProcessStage.whetherSelectionInBatches){
        	var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	var evaluateApplicant = this.getSelectionStageStructure().down('button#evaluateApplicant');
			var promoteApplicantToNextStage = this.getSelectionStageStructure().down('button#promoteApplicantToNextStage');
        	if(!isNullOrEmpty(selectedRecord)){
    			var applcantStatus=selectedRecord.get('APPLICANT_STATUS');
    	         
    	      	if(applcantStatus=='INPROGRESS'){
    	      			evaluateApplicant.setDisabled(false);
    	      	}else{
    	      		evaluateApplicant.setDisabled(true);
    	      	}
    	      	
    	      	if(applcantStatus=='READY_TO_PROMOTED'){
    	      		promoteApplicantToNextStage.setDisabled(false);
    	      	}else{
    	      		promoteApplicantToNextStage.setDisabled(true);
    	      	}
        	}
        	if(status == 'CLOSED'){
				evaluateApplicant.setDisabled(true);
				promoteApplicantToNextStage.setDisabled(true);
			}
      }  
        
    },
    /**
     * This enables the tabs after the selection of any value in the Selection Stage combo.
     * @param {boolean} enableDisableFlag specifies if the tabs should be enabled or disabled.
     * true specifies should be disabled,
     * false sepecifies should not be disabled.
     * @author Akshay.Kalbhor
     */
    enableDisableTabs: function(enableDisableFlag) {
//        var tabStructure = this.getSelectionStageTabStructure();
    	var tabStructure = this.getSelectionStageStructure();
        var stageButtonContainer=  tabStructure.down('#stageButtonContainer');
//        var stageDetailContainer=  tabStructure.up().down('#stageDetailContainer');
        
        tabStructure.setVisible(!enableDisableFlag);
        stageButtonContainer.setVisible(!enableDisableFlag);
//        stageDetailContainer.setVisible(!enableDisableFlag);
    },

    disableSeatTransferTabs: function(disableFlag) {
//  	var tabStructure = this.getSelectionStageTabStructure();
    	var treePanel = this.getStagedetailsstructure().down('#selectionstagetree');
    	/*console.log('treeStore',treePanel.getStore());
    	var treeStore = treePanel.getStore();
    	var rec4 = treeStore.getNodeById(4);
    	var rec5 = treeStore.getNodeById(5);
    	
    	console.log('rec4',rec4);
    	if (!isNullOrEmpty(rec4)) {
    		rec4.destroy();	
    	}
    	if (!isNullOrEmpty(rec5)) {
    		rec5.destroy();	
    	}*/
    	
    	
   	 /*var bindingStore = this.getStore('admission.selectionStage.SelectionStageClosedTreeStore');
   	 treePanel.bindStore(bindingStore);*/

    	//tabStructure.down('transferseatsgrid').setDisabled(disableFlag);
    	//tabStructure.down('overridequotalimits').setDisabled(disableFlag);
    },

    /*
     * This method is used to load evaluation parameters for selection process stage.
     */
    getEvalParamWeightage: function() {
        var this$ = this;
        var enterMarkBtn=grid.down('#enterMark');
        var selectionProcessStageId = this$.getSelectionProcessStageId();
        Ext.Ajax.request({
            type: 'rest',
            url: this$.concateUrl(SERVERURL.SP_STAGE_EVALPARAM_WEIGHTAGE, 'selectionProcessStageId', selectionProcessStageId),
            method: 'GET',
            success: function(response, action) {
                var form = this$.getSelectionStageStructure().down().getForm();
                form.setValues({
                    'stageEvalParamsObject': response.responseText
                });
                if(!isNullOrEmpty(enterMarkBtn)){
                	var evaluationData = Ext.decode(response.responseText);
                	if(!isNullOrEmpty(evaluationData) && evaluationData.length >= 1 ){
                	enterMarkBtn.setDisabled(false);
                	}else{
                		enterMarkBtn.setDisabled(true);	
                	}
                }
            }
        });

    },
    //Load enter mark form on grid render by PATH_FIND_BY_SELECTION_PROCESS_STAGE
    loadEnterMarkForm: function() {
        var this$ = this;
        var selectionStageStructureForm = this$.getSelectionStageStructure().down().getForm();
        var stageEvalParams = selectionStageStructureForm.findField('stageEvalParamsObject').getSubmitValue();
        var selectionProcessStageObj = this$.getProgramSelectionProcessStageObject();
        var evaluationTypeValue = selectionProcessStageObj.selectionProcessStage.evaluationType;
        var form = this$.getEnterMarksPopupForm();

        var stageEvalParamsObject = Ext.decode(stageEvalParams);
        var formItems = [];
/*        var msgfield = {
            xtype: 'label',
            text: (evaluationTypeValue == 'MARK') ? getAdmissionTranslation('MARKS_MESSAGE') : getAdmissionTranslation('GRADE_MESSAGE')
        };*/

        var markTypeFieldName = (evaluationTypeValue == 'MARK') ? 'marksObtained' : 'obtainedGrade';

//        formItems.push(msgfield);

        if(evaluationTypeValue == 'MARK'){
        	Ext.each(stageEvalParamsObject, function(obj) {

                // Add the records to the formItems array.
        		var field = {
        				
        				xtype: 'form',
                        layout: 'hbox',
                        name: obj.id + "_" + obj.evaluationParameter,
                        cls: 'panelNoSpace',
                        defaults: {
                            labelAlign: 'top',
                            width: 250,
                            //padding: '10'
                        },
                        items: [{
                            xtype: 'hidden',
                            name: 'id'
                        }, {
                            xtype: 'hidden',
                            name: 'version'
                        }, {
                            xtype: 'hidden',
                            name: 'applicationProgramStageId',
                            value: this$.getApplicationProgramStageId()
                        }, {
                            xtype: 'hidden',
                            name: 'evaluationType',
                            value: evaluationTypeValue
                        },{
                            xtype: 'nestedTextField',
                            hidden: true,
                            readOnly: true,
                            name: 'selectionStageEvalParamWeightage',
                            value: obj.id
                        }, {
                            xtype: 'numberfield',
                            fieldLabel: obj.evaluationParameter,
                            name: markTypeFieldName,
                            validateOnBlur: true,
                            maxValue:obj.maxMarks,
                            minValue:0,
                            //style :{marginLeft: '-8px !important'},
                        }, {
                            xtype: 'textfield',
                            fieldLabel: getAdmissionTranslation('MAXIMUM_MARKS'),
                            name: 'maxMarks',
                            readOnly: true,
                            value: obj.maxMarks,
                            style :{marginLeft: '15px !important'},
                        }]};
                formItems.push(field);
            });

        	var field1 = "";
        	Ext.each(stageEvalParamsObject, function(obj) {
        	field1 = {
             			 xtype: 'form',
                         layout: 'hbox',
                         cls: 'panelNoSpace',
                         style :{marginLeft: '-8px !important'},
                         defaults: {
                             labelAlign: 'top',
                             padding: '10',
                             width: 515
                         },
            	            items: [{
            	            	xtype: 'textareafield',
            	            	name: 'remarks',
            	            	maxLength : 255,
            	            	value: obj.remarks,
            	            	fieldLabel: getCommonTranslation('Remarks')
            	            }]
            	 }});
            formItems.push(field1);
            
        } else {
        	Ext.each(stageEvalParamsObject, function(obj) {

                // Add the records to the formItems array.
                var field = {
                    xtype: 'form',
                    layout: 'hbox',
                    name: obj.id + "_" + obj.evaluationParameter,
                    cls: 'panelNoSpace',
                    defaults: {
                        labelAlign: 'top',
                        width: 226,
                        padding: '10'
                    },
                    items: [{
                        xtype: 'hidden',
                        name: 'id'
                    }, {
                        xtype: 'hidden',
                        name: 'version'
                    }, {
                        xtype: 'hidden',
                        name: 'applicationProgramStageId',
                        value: this$.getApplicationProgramStageId()
                    }, {
                        xtype: 'hidden',
                        name: 'evaluationType',
                        value: evaluationTypeValue
                    },{
                        xtype: 'hidden',
                        name: 'gradeTypeId'
                    }, {
                        xtype: 'nestedTextField',
                        hidden: true,
                        readOnly: true,
                        name: 'selectionStageEvalParamWeightage',
                        value: obj.id
                    }, {
                        xtype: 'customcombobox',
                        fieldLabel: obj.evaluationParameter,
                        name: 'gradeId',
                        itemId: 'gradeNames',
                        store: 'Academia.store.admission.selectionStage.GradesByGradeTypeIdStore',
                        displayField: 'value',
                        valueField: 'id',
                        allowBlank: false,
                        editable: false
                        }]
                };

                formItems.push(field);
            });
        	
        	
        	var field1 = "";
        	Ext.each(stageEvalParamsObject, function(obj) {
        	field1 = {
             			 xtype: 'form',
                         layout: 'hbox',
                         cls: 'panelNoSpace',
                         style :{marginLeft: '-8px !important'},
                         defaults: {
                             labelAlign: 'top',
                             padding: '10',
                             width: 515
                         },
            	            items: [{
            	            	xtype: 'textareafield',
            	            	name: 'remarks',
            	            	maxLength : 255,
            	            	value: obj.remarks,
            	            	fieldLabel: getCommonTranslation('Remarks')
            	            }]
            	 }});
            formItems.push(field1);
        	
        }

        var formField = {
            xtype: 'form',
            submitValue: false,
            cls: 'panelNoSpace',
            layout: 'hbox',
            name: 'conditionalMarkForm',
            itemId: 'conditionalMarkForm',
            layout: {
                type: 'table',
                columns: 2
            },
            defaults: {
                xtype: 'textfield',
                labelAlign: 'top',
                width: 226,
                tdAttrs: {
                    style: 'padding: 5px;'
                },
                enforceMaxLength: true,
                readOnly: true,
                submitValue: false
            },
            items: [{
                xtype: 'label',
                text: getAdmissionTranslation('CONDITIONAL_MARKS')
            },{           
                xtype: 'label',
                text: ''
            }]
        };

        formItems.push(formField);
        
        var buttonField = {
            xtype: 'fieldcontainer',
            width: '100%',
            style:{'padding-bottom':'10px'},
            items: [{
                xtype: 'button',
                action: 'Submit',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                disabled: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        };
        formItems.push(buttonField);
        Ext.suspendLayouts();
        form.removeAll();
        form.add(formItems);
        Ext.resumeLayouts(true);
    },

    editEnterMarks: function(selectedRecord) {
        var applicationProgramStageId = selectedRecord.get('ID');
        var SelectionProcessStageId = this.getProgramSelectionProcessStageId();
        var this$ = this;
        var url = SERVERURL.APSM_FIND_BY_PROGRAM_STAGE_ID;
        url = url.concat('=' + applicationProgramStageId);
        Ext.Ajax.request({
            type: 'rest',
            url: url,
            method: 'GET',
            success: function(response, action) {
                var data = Ext.decode(response.responseText);
                var form = this$.getEnterMarksPopupForm();
                var gradeTypeId;
                Ext.each(data, function(obj) {
                    var selectionStageEvalParamWeightage = obj.selectionStageEvalParamWeightage;

                    obj.searchParam = selectionStageEvalParamWeightage.id + "_" + selectionStageEvalParamWeightage.evaluationParameter;
                });

                form.setValues(data);
                if( !isNullOrEmpty(data[0]) && !isNullOrEmpty(data[0].remarks) ){
                	Ext.ComponentQuery.query('[name=remarks]')[0].setValue(data[0].remarks);
                }
                if( !isNullOrEmpty(data[0]) && !isNullOrEmpty(data[0].gradeTypeId) ){
                	gradeTypeId = data[0].gradeTypeId;
                	Ext.ComponentQuery.query('[name=gradeTypeId]')[0].setValue(gradeTypeId);
                }
                else{
                	
                	Ext.Ajax.request({
            			type : 'rest',
            			url : SERVERURL.FIND_GRADE_TYPE_BY_PROCESS_STAGE_ID,
            			params : {
            				selectionProcessId : SelectionProcessStageId,
            			},
            			method : 'GET',
            			async: false,
            			success : function(form, action) {
            				gradeTypeId = form.responseText;
            			}
            		}); 
                	Ext.ComponentQuery.query('[name=gradeTypeId]')[0].setValue(gradeTypeId);
                }
                var gradeStore = form.down("#gradeNames").getStore();
                gradeStore.getProxy().extraParams = {
                	gradeTypeId: gradeTypeId
      		  };
                gradeStore.load();
            }
        });
    },
    loadConditionalMarks: function(selectedRecord) {
        var applicationProgramStageId = selectedRecord.get('ID');
        var this$ = this;
        var url = SERVERURL.ASCM_FIND_BY_PROGRAM_STAGE_ID;
        url = url.concat('?applicationProgramStageId=' + applicationProgramStageId);
        url = url.concat('&applicantId=' + selectedRecord.get('PERSON_ID'));
        url = url.concat('&selectionProcessStageId=' + this$.getSelectionProcessStageId());
        
        var form = this$.getEnterMarksPopupForm();
        var conditionalMarkForm = form.down('#conditionalMarkForm');
        conditionalMarkForm.setVisible(false);

        Ext.Ajax.request({
            type: 'rest',
            url: url,
            method: 'GET',
            success: function(response, action) {
              var data = Ext.decode(response.responseText);
                if(!data || data.length<1){
                	//conditionalMarkForm.setVisible(false);
                }else{
                	conditionalMarkForm.setVisible(true);
                      Ext.each(data, function(obj) {
                          var field = {
                              xtype: 'textfield',
                              fieldLabel: obj.selectionStageConditionalMark.value,
                              value: obj.marksObtained
                          };
                          conditionalMarkForm.insert(field);
                      });
                }
            }
        });
    },

    /**
     * Setter of the program Selection Process Stage Id at the selection of the Selection Stage Dropdown
     * @param {Number} the id of the selected PSPSId.
     * @author Akshay.Kalbhor
     */
    setProgramSelectionProcessStageId: function(id) {
        this.programSelectionProcessStageId = id;
    },

    getProgramSelectionProcessStageObject: function() {
        var selectionStageStructureForm = this.getSelectionStageStructure().down().getForm();
        var stageObjectData = selectionStageStructureForm.findField('stageObject').getSubmitValue();
        if(!isNullOrEmpty(stageObjectData)){
        	return Ext.decode(stageObjectData);	
        }
    },
    getSelectionProcessStageId: function() {
    	if (!isNullOrEmpty(this.getProgramSelectionProcessStageObject())) {
    		return this.getProgramSelectionProcessStageObject().selectionProcessStage.id;
    	}
    },

    getProgramSelectionProcessId: function() {
    	if (!isNullOrEmpty(this.getProgramSelectionProcessStageObject())) {
    		return this.getProgramSelectionProcessStageObject().programSelectionProcessId;
    	}
    },
    getProgBatchSeatConfigId : function() {
        return this.progBatchSeatConfig;
    },

    getApplicationProgramStageId: function() {
        var grid = this.getApplicationStageBasicSearchGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            var selectedRecord = grid.getSelectionModel().getSelection()[0];
            return selectedRecord.get('ID');
        } else {
            showWarningMessage(getAdmissionTranslation('SELECTION_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    getMultipleApplicationProgramStageId: function(flag) {
    	var formValues = this.getApplicationProgramStageStatusForm().getValues();
    	 if(flag){
         	formValues.forceToPromote=true;
         }
         else {
         	formValues.forceToPromote=false;
         }
        var grid = this.getApplicationStageBasicSearchGrid();
        var idsArray=[];
        var ids;
        var selectedRecord = grid.getSelectionModel().getSelection();
        if (grid.getSelectionModel().getCount() > 0) {
        	
        	for(var i=0;i<grid.getSelectionModel().getCount();i++){
        		
        		{

        			idsArray.push({
        				"applicationProgramStageId":selectedRecord[i].data.ID,
        				"status": formValues.status,
        				"remark":formValues.remark,
        				"approvedDate":formValues.approvedDate,
        				"approvedBy":formValues.approvedBy,
        				"forceToPromote":formValues.forceToPromote,
        				"unsuccessfulReason":formValues.unsuccessfulReason
        			});
        		
        		}}
            return idsArray;
        } else {
            showWarningMessage(getAdmissionTranslation('SELECTION_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    getApplicationId: function() {
        var grid = this.getApplicationStageBasicSearchGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            var selectedRecord = grid.getSelectionModel().getSelection()[0];
            return selectedRecord.get('APPLICATION_PRIMERY_ID');
        } else {
            showWarningMessage(getAdmissionTranslation('SELECTION_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    concateUrl: function(url, parameter, id) {
        url = url.concat('?' + parameter + '=' + id);
        return url;
    },
    
    /**
     * code to load the selection stage combo from the filter.
     * @param {Object} the reference of the seatTypeCombo, based on which the selection stage combo should be loaded.
     * @param {Number} the value of the programBatchSeatConfigId which has to be passed in the url.
     * @author akshay.kalbhor
     */
    loadSelectionStageCombo: function(seatTypeCombo, value) {
        acadLocProgComponent = seatTypeCombo.up('selectionstageacadprogbatchseattype');
        var dependentCombo = acadLocProgComponent.nextSibling();
        /*
         * Code to reset the value of the SelectionStage dropdown based on the selection of the seatype combo.
         */
        this.resetSelectionStageCombo(seatTypeCombo);

        var store = dependentCombo.getStore();
        var url = store.getProxy().proxyConfig.api.read;
        this.progBatchSeatConfig=seatTypeCombo.progBatchSeatConfigId
        url = url.concat('?programBatchSeatConfigId=' + seatTypeCombo.progBatchSeatConfigId);
        store.getProxy().api.read = url;
        store.reload();
    },
    
    /**
     * code to reset the values of the selection stage combo on selection of academy loc prog batch seatType dropdowns.
     * @author Akshay.Kalbhor
     */
    resetSelectionStageCombo: function(combo) {
        var stageCombo = combo.up('selectionstageacadprogbatchseattype').nextSibling();
        //this.resetCombo(stageCombo);
    },
    resetSelectionImportStageCombo: function(combo) {
        var stageCombo = combo.up('downloadselectiontransferform').nextSibling();
        //this.resetCombo(stageCombo);
    }, 
    resetCombo: function(stageCombo) {
        stageCombo.clearValue();
        stageCombo.store.removeAll();
    },

    /**
     * method to add the custom buttons in the grid.
     * should be handled accordingly as per the user access rights.
     * @param {Object} the reference of the grid.
     * @author akshay.kalbhor
     */
    gridRenderFunction: function(grid) {
        /*
         * by default the docked items will have 4 items so checked with 4,
         * this adds the below buttons only for the first time
         * next time user selects the selection stage dropdown and after this function gets called then the length
         * of the docked items becomes 7 , and prevents from adding the toolbar again.
         */
        if (grid.dockedItems.length < 4) {
            grid.addDocked({
                xtype: 'toolbar',
                dock: 'top',
                items: [{
                    xtype: 'button',
                    itemId: 'enterMark',
                    text: getAdmissionTranslation('ENTER_MARKS_GRID')
                }, /* ImportMark's Button not required.
                	{
                    xtype: 'button',
                    itemId: 'importMark',
                    text: getAdmissionTranslation('IMPORT_MARK')
                },*/ {
                    xtype: 'button',
                    itemId: 'changeStatus',
                    text: getAdmissionTranslation('CHANGE_STATUS')
                }, '->', {
                    xtype: 'splitbutton',
                    itemId: 'exportToPdfBtn',
                    cls: 'CustomToolbarBtnExport export-cls',
                    iconCls: 'export-pdf-icon',
                    //text: 'Export To Pdf',      
                    menu: [{
                        text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
                        itemId: 'exportCurrentPage'
                    }, {
                        text: getCommonTranslation('EXPORT_ALL_COMMON'),
                        itemId: 'exportAll'
                    }],
                    listeners: {
                        click: function() {
                            this.showMenu();
                        }
                    }
                }, {
                    xtype: 'splitbutton',
                    itemId: 'exportToXcelBtn',
                    cls: 'CustomToolbarBtnExport export-cls',
                    iconCls: 'export-excel-icon',
                    //text: 'Export To Xcel',      
                    menu: [{
                        text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
                        itemId: 'exportCurrentPage'
                    }, {
                        text: getCommonTranslation('EXPORT_ALL_COMMON'),
                        itemId: 'exportAll'
                    }],
                    listeners: {
                        click: function() {
                            this.showMenu();
                        }
                    }
                }]
            });
        }
    },

    //TODO: remove
    /**
	 * code to show the transfer seats window on click of the add column button.
	 * @param {Object} the reference of the button which is clicked.
	 * @author akshay.kalbhor
	
	showTransferSeatsWindow: function(button) {
		var formWindow = this.getTransferSeatsWindow();
        if (!formWindow) {
            Ext.widget('transferseatswindow');
            formWindow = this.getTransferSeatsWindow();
        }
        formWindow.show();
	},
	 */

    /**
     * code to set the value of the logged in user in the approver field of the "Override quota limits" tab.
     * @param {Object} the reference of the combo which is selected.
     */
    setApproverName: function(combo) {
        var approverField = combo.up('form').down('textfield#approverAuthority');
        var approver = this.getCurrentlyLoggedInUser();
        approverField.setValue(approver);
    },

    /**
     * code to set the values of the dependent fields viz:minSeats and MaxSeats from the selected record of the combobox.
     */
    setDependentValues: function(combo, records) {
        var minSeats = combo.up('form').down('textfield#quotaMinSeats');
        var maxSeats = combo.up('form').down('textfield#quotaMaxSeats');
        var overMinSeats = combo.up('form').down('numberfield#overriddenMinSeat');
        var overMaxSeats = combo.up('form').down('numberfield#overriddenMaxSeat');
        var selectedCandidates = combo.up('form').down('textfield#selectedCandidates');

        this.checkkAndResetField(overMinSeats);
        this.checkkAndResetField(overMaxSeats);
        this.setMinMaxSeatValue(combo, minSeats, maxSeats, selectedCandidates);

    },
    /**
     * This method is used to set min max and selectedCandidates field values if present.
     */
    setMinMaxSeatValue: function(combo, minSeats, maxSeats, selectedCandidates) {
        var this$ = this;
        this.checkkAndResetField(minSeats);
        this.checkkAndResetField(maxSeats);
        this.checkkAndResetField(selectedCandidates);

        var params = new Object();
        params.stageQuotaId = combo.getValue();

        /*
         * code to fire an ajax call to bring the selected candidates from PSSSR
         */
        this.sendGetAjaxRequest(SERVERURL.STAGE_STATISTICS_BY_STAGEQUOTAID, 'GET', params, function(opt, success, response) {
            if (success) {
                var responseObj = Ext.decode(response.responseText);
                if (responseObj) {
                    this$.nullCheckAndSetvalue(selectedCandidates, responseObj.numberOfSelectedStudents);

                    if (isNullOrEmpty(responseObj.programSelectionProcesStageQuota.overriddenMinSeat)) {
                        this$.nullCheckAndSetvalue(minSeats, responseObj.programSelectionProcesStageQuota.minSeat);
                    } else {
                        this$.nullCheckAndSetvalue(minSeats, responseObj.programSelectionProcesStageQuota.overriddenMinSeat);
                    }

                    if (isNullOrEmpty(responseObj.programSelectionProcesStageQuota.overriddenMaxSeat)) {
                        this$.nullCheckAndSetvalue(maxSeats, responseObj.programSelectionProcesStageQuota.maxSeat);
                    } else {
                        this$.nullCheckAndSetvalue(maxSeats, responseObj.programSelectionProcesStageQuota.overriddenMaxSeat);
                    }
                }
            }
        });

    },

    /**
     * This method is checks or field and setValue function in field.
     * if filed and setValue function is present value is set to the field.
     * @author Rupesh.Agrawal
     * @param {Object} : field where value to be set.
     * @param {Object} : value to be set.
     */
    nullCheckAndSetvalue: function(field, value) {
        if (field) {
            if (typeof field.setValue != "undefined") {
                field.setValue(value);
            }
        }
    },

    /**
     * method to save the selection setting from the selection setting tab.
     * @param {Object} the reference of the clicked button
     */
    saveSelectionSetting: function(button) {
        var this$ = this,
            form = button.up('form');
        var formValues = button.up('form').getValues();
        delete formValues.programSelectionProcesStageQuotaId;
        formValues.programSelectionProcesStageQuotaId = form.down('combo').getValue();
        var submitData = Ext.encode(formValues);
        this.sendSaveAjaxRequest(SERVERURL.SELECTION_STAGE_OVERRIDE_QUOTA_ADD, 'POST', submitData, function(opt, success, response) {
            if (success) {
//                var tabStructure = this$.getSelectionStageTabStructure();
//                tabStructure.setActiveTab(1);
                showSuccessMessage(getAdmissionTranslation('OVERRIDE_QUOTA_LIMITS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
                form.getForm().reset();
            }
        });
    },

    /**
     * method to add the quota transfer column into the transfer quotas screen.
     * @param {Object} the reference of the clicked button
     * @author Akshay.Kalbhor
     */
    addQuotaColumn: function(button) {
        var this$ = this;
        var window = button.up('window');
        var addColumnForm = button.up('form');
        var formValues = addColumnForm.getValues();
        
        if(formValues.fromQuotaCombo==formValues.toQuotaCombo){
        	showErrorMessage(getAdmissionTranslation('TRANSFER_SEATS'), getAdmissionTranslation('TRANSFER_SEATS_SAME_QUOTA_ERROR'));
        }else{
	        var grid = this.getTransferSeatsGrid();
	        var store = grid.getStore();
	
	        this.transferId++;
	        
	        var column1 = Ext.create('Ext.grid.column.Column', {
	            text: getAdmissionTranslation('TRANSFER_SEATS') + this$.transferId,
	            dataIndex: 'transfer' + this.getTransferId()
	        });
	
	        var newField = new Ext.data.Field({
	            name: 'transferSeats' + this$.transferId,
	            type: 'int'
	        });
	        var fromRecord=null,toRecord=null,newMaxSeat=null, error=false;
	        
	        store.each(function(record) {
	            record.fields.add(newField);
	            if (record.raw.programSelectionProcessStageId == formValues.fromSeatTypeCombo && record.raw.programSelectionProcesStageQuota.id == formValues.fromQuotaCombo) {
	            	var maxSeat=this$.getMaxSeat(record);
            		var minSeat=this$.getMinSeat(record);
            		newMaxSeat=this$.getNewMaxSeat(record,maxSeat);
		           
		       		newMaxSeat=newMaxSeat-formValues.noOfSeatTransferred;
		       		if(newMaxSeat<minSeat){
		       			error=true;
		       			return false;
		       		}	
		       		else
		       			fromRecord=record;
	            }
	            if (record.raw.programSelectionProcessStageId == formValues.toSeatTypeCombo && record.raw.programSelectionProcesStageQuota.id == formValues.toQuotaCombo) {
	            	toRecord=record;
	            }
	        });
	
	        if(error){
	        	showErrorMessage(getAdmissionTranslation('TRANSFER_SEATS'), getAdmissionTranslation('TRANSFER_SEATS_MIN_MAX_ERROR'));
	        }else{
	        	fromRecord.set('transfer' + this$.transferId, '-' + formValues.noOfSeatTransferred);
	        	fromRecord.set('newMaxSeat', newMaxSeat);
	        	toRecord.set('transfer' + this$.transferId, '+' + formValues.noOfSeatTransferred);
	        	
        	   if (isNullOrEmpty(this$.seatTransferList)) {
	   	            this$.seatTransferList = new Array();
	   	        }
	   	
	   	        var seatTransferObject = new Object();
	   	        seatTransferObject.fromProgramSelectionStageQuotaId = formValues.fromQuotaCombo;
	   	        seatTransferObject.toProgramSelectionStageQuotaId = formValues.toQuotaCombo;
	   	        seatTransferObject.numberOfSeat = formValues.noOfSeatTransferred;
	   	
	   	
	   	        this$.seatTransferList.push(seatTransferObject);
	   	        grid.headerCt.insert(grid.columns.length, column1);
	   	        grid.getView().refresh();
	   	        grid.down('#applySeatTransfers').setDisabled(false);
	   	        this.closeFormWindow(window);
            }
        }
    },

    getMaxSeat:function(record){
		  var maxSeat=record.get('overriddenMaxSeat');
		  if(isNullOrEmpty(maxSeat))
			  maxSeat= record.get('maxSeat');
		  return maxSeat;
    },

    getMinSeat:function(record){
    	  var minSeat=record.get('overriddenMinSeat');
		  if(isNullOrEmpty(minSeat))
			  minSeat= record.get('minSeat');
		  return minSeat;
    },
    
    getNewMaxSeat:function(record,maxSeat){
    	var newMaxSeat=record.get('newMaxSeat');
		if (isNullOrEmpty(newMaxSeat)) {
	   		 newMaxSeat =maxSeat;
		 }
		 return newMaxSeat;
    },
    
    previwChanges: function(button) {
        var this$ = this;
        var grid = button.up('transferseatsgrid');

        var store = grid.getStore();

        store.each(function(record) {
            var maxSeat =this$.getMaxSeat(record);
            for (var i = 1; i <= this$.transferId; i++) {
                var val = parseInt(record.get('transfer' + i));
                record.set('transfer' + i, 0);
                if (Ext.isNumber(val)) {
                    maxSeat = maxSeat + val;
                }
            }
            record.set('overriddenMaxSeat', maxSeat);
        });

    },
    applySeatTransfers: function(button) {
        var this$ = this;
        this.sendSaveAjaxRequest(SERVERURL.SELECTION_STAGE_TRANSFER_SEAT_SAVE_ALL, 'POST', this$.seatTransferList, function(opt, success, response) {
            if (success) {
               /* var tabStructure = this$.getSelectionStageTabStructure();
                tabStructure.setActiveTab(1);*/
            	var grid = this$.getTransferSeatsGrid();
            	grid.getStore().reload();
            	button.setDisabled(true);
                showSuccessMessage(getAdmissionTranslation('TRANSFER_SEATS'), getCommonTranslation('SUCCESS'));
            }
        });
    },

    /**
     * This method is used to load basic search grid for the applicants in stage.
     * @param component is the reference of the component which can be a grid or a button as per the event called. 
     * @return request according to search criteria
     * @author Akshay.Kalbhor
     */
    loadApplicantsInStage: function(SearchForm,applicantSearchResultGrid) {
//        var SearchForm = component.up('panel[xtype=applicationstagebasicsearch]').down('form#applicationstagebasicsearchform');
    	 var stageObject=this.getProgramSelectionProcessStageObject();
    	
    	 var SearchForm = this.getSelectionstagesearchfilter().getForm();
         var applicantSearchResultGrid = this.getApplicationStageBasicSearchGrid();
         var jsonFormatFormData = this.createJsonFormat(SearchForm);
        
        // add code for check stage fee paid or unpaid
        if(Ext.isDefined(stageObject) && ((stageObject.whetherFeePlanApplicable || stageObject.whetherFeePlanApplicable==true) && stageObject.whetherFeePlanActive==true)){
    		if(!stageObject.whetherFeePlanByPass || stageObject.whetherFeePlanByPass==false){
    			jsonFormatFormData.searchCriterias.push({paramCode:'STAGE_FEE_STATUS', paramValues:["SETTLED"]});
    		}
    	}
        
//        var applicantSearchResultGrid = component.up('panel[xtype=applicationstagebasicsearch]').down('searchresultgrid#applicationStageBasicSearchGrid');
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.ADMISSION_SELECTION_STAGE_VIEWCODE);
        applicantSearchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
        
        var SelectionProcessStageId = this.getProgramSelectionProcessStageId();
        var stageType='';
        
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.FIND_STAGE_TYPE_BY_PROCESS_STAGE_ID,
			params : {
				selectionProcessId : SelectionProcessStageId,
			},
			method : 'GET',
			async: false,
			success : function(form, action) {
				stageType = form.responseText;
			}
		}); 
		
		if(stageType=="GRADE"){
		setTimeout(function() {
			 Ext.each(applicantSearchResultGrid.columnManager.columns,function(currentColumn){
			 if(currentColumn.dataIndex=="RANK"){
					 currentColumn.setVisible(false);
			 }
			 });
			},500); } 
    	    
    },

    /**
     * This method is used to create JSON format of form values
     * @param SearchForm	
     * @return formated JSON of form Values
     */
    createJsonFormat: function(searchForm) {
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.ADMISSION_SELECTION_STAGE_CONFIGCODE;

        formValues = searchForm.getValues();

        for (var key in formValues) {
            var value = formValues[key];
            if (!isNullOrEmpty(value) && value !== 'All' && key !== 'selectedNameField') {
                var keyValueJsonObject = this.getJsonObject(key, value);
                this.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
            }
        }

        values.searchCriterias = searchcriteria;
        return values;
    },

    /**
     * FIXME: [AKR] add it in the base controller as a generic method.
     * This method is used to crate JSON object
     * @param key is the text that should be added to the paramCode
     * @param value is the value which should be added in the parmaValues
     * @param additional value is the value which should be added in the parmaValues
     * @return JSON object
     * @author Akshay.Kalbhor
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },

    /**
     * FIXME: [AKR] add it in the base controller as a generic method.
     * This method is used to push JSON object into array & create Object array
     * @param JSON object
     * @param array
     * @return JSON object Array
     * @author Akshay.Kalbhor
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },

    /**
     * Method to check if any record of the criteria builder grid is selected or no.
     * @param {Object} the reference of the grid in which the selection check should be done.
     * @returns {Boolean} boolean value which indicates true if any record is selected else false.
     * @author Akshay.Kalbhor
     */
    checkGridRecordSelection: function(grid) {
        if (grid.getSelectionModel().getCount() > 0) {
            return true;
        } else {
            showWarningMessage(grid.header.title, getCommonTranslation('PLEASE_SELECT_RECORD'));
            return false;
        }
    },

    /**
     * code to handle the cell click of the criteria builder grid.
     * checks the column on which the click has taken place and processes accordingly.
     * @param {Object} the reference of the grid on which the click has been done.
     * @param {String} the html for the clicked component.
     * @param {Number} the index of the clicked cell.
     * @param {String} the name of the column whose cell has been clicked.
     * @author akshay.kalbhor
     */
    handleSearchResultCellClick: function(grid, td, cellIndex, columnName, tr, rowIndex, e, eOpts, record) {
       // var selectedRecord = grid.getSelectionModel().getSelection()[0];
        if(record){
        	if (e.target.tagName == 'A') {
        		var applicationId = record.get('APPLICATION_PRIMERY_ID');
        		var searchForm = this.getSelectionstagesearchfilter();
            	var getStageStatusform = searchForm.down('selectionstageacadprogbatchseattype');
            	var getStageStatusCombo = getStageStatusform.down('#selectionStageCombo');
        		if (columnName === "STAGE_MARKS_GRID" && !isNullOrEmpty(applicationId)) {
        			var contentPanel = this.getContentPanel();
        			var formWindow = this.getStagemarkslistreportwin();
        			if (!formWindow) {
        				Ext.widget('stagemarkslistreportwin');
        				formWindow = this.getStagemarkslistreportwin();
        			}
        			formWindow.show();
        			formWindow.down('#applicationID').setValue(record.data.APPLICATION_ID);
        			formWindow.down('#applicantName').setValue(record.data.STUDENT_NAME);
        			formWindow.down('#stageName').setValue(getStageStatusCombo.getDisplayValue());
        			var gridFetch = formWindow.down('grid');
        			gridFetch.getStore().getProxy().extraParams={
        				applicationProgramStageId : record.data.ID
        			};
        			gridFetch.getStore().load({ callback: function(record, operation, success) {
        				if (record.length > 0) {
        					this$.toggleGridSummaryRow(gridFetch,true);
        				}else{
        					this$.toggleGridSummaryRow(gridFetch,false);
        				}
        			}
        			});

        		}else if (columnName === "EFFECTIVE_MARKS_GRID" && !isNullOrEmpty(applicationId)) {
        			var contentPanel = this.getContentPanel();
        			var formWindow = this.getEffectivemarkslistreportwin();
        			if (!formWindow) {
        				Ext.widget('effectivemarkslistreportwin');
        				formWindow = this.getEffectivemarkslistreportwin();
        			}
        			formWindow.show();
        			formWindow.down('#applicationID').setValue(record.data.APPLICATION_ID);
        			formWindow.down('#applicantName').setValue(record.data.STUDENT_NAME);
        			var comboStageStore = getStageStatusCombo.getStore();
        			var comboSequenceValue = comboStageStore.data.items[comboStageStore.find('id',getStageStatusCombo.getValue())].data.sequence;
        			var gridFetch = formWindow.down('grid');
        			gridFetch.getStore().getProxy().extraParams={
        				applicationProgramStageId : record.data.ID,
        				stageOrder:comboSequenceValue,
        				includePrevsStagePerformance:record.data.INCLUDE_PREVIOUS_STAGE_PERFORMANCE
        			};
        			gridFetch.getStore().load({ callback: function(record, operation, success) {
        				if (record.length > 0) {
        					this$.toggleGridSummaryRow(gridFetch,true);
        				}else{
        					this$.toggleGridSummaryRow(gridFetch,false);
        				}
        			}
        			});

        		} else if (columnName === 'DOCUMENT_STATUS' && !isNullOrEmpty(applicationId)) {
        			if(record.data.DOCUMENT_STATUS === 'PENDING' || record.data.DOCUMENT_STATUS === 'Pending' ){
        				var window = this.showWindow('stagedocumentpopupwindow');
        				var documentGrid = window.down('#selectionStageDocuments');
        				var store = this.getStore('Academia.store.admission.selectionStage.Documents');
        				documentGrid.reconfigure(store);
        				documentGrid.down('toolbar[dock=top]').hide();
        				documentGrid.down('custompagingtoolbar').bindStore(store);
        				this.loadDocumentsGrid(documentGrid, applicationId);
        			}else{
        				showErrorMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'),getAdmissionTranslation('NO_PENDING_DOC'));
        			}
        		}
        	}
        }else{
        	 showWarningMessage(getAdmissionTranslation('SELECTION_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));        	
        	
        }
    },

    /**
     * Code to load the post grids of the transferSEats and the ...
     * @param {Object} the reference of the grid.
     * @param {String} the name of the grid.
     * @author akshay.kalbhor
     */
    loadGrids: function(grid, gridName) {
        var criteria = new Object();
        var programSelectionProcessStageIds = new Array();
        if (gridName === 'transferseatsgrid') {
        	criteria.whetherLatest = true;
            criteria.checkMandatoryQuotaType = true;
            var combo = grid.down('multiselectcombofield#seatTypesCombo');
            Ext.each(combo.getValue(), function(value) {
                programSelectionProcessStageIds.push(value);
            });

        } else if (gridName === 'stagestatasticsgrid') {
            criteria.whetherLatest = true;
            programSelectionProcessStageIds.push(this.getProgramSelectionProcessStageId());
        }
        criteria.programSelectionProcessStageId = programSelectionProcessStageIds;
        var store = grid.getStore();
    	store.getProxy().extraParams=criteria;
    	store.load();
    },

    /**
     * Code to load the seatType combo, parameters to be sent are selectionProcessStageId and programSelectionProcessId
     * @param {Object} the reference of the grid
     * @param {Number} the applicationId whose documents are to be shown.
     * @author akshay.kalbhor
     */
    loadDocumentsGrid: function(grid, applicationId) {
        var criteria = new Object();

        criteria.applicationId = applicationId;
        if (!isNullOrEmpty(this.getSelectionProcessStageId())) {
            criteria.selectionProcessStageId = this.getSelectionProcessStageId();
        }
        //Enums reqired on the server side.
        criteria.applicableAt = 'SELECTIONSTAGE';
        criteria.status = 'PENDING';

        var store = grid.getStore();
    	store.getProxy().extraParams = {
            status : 'PENDING',
            applicableAt : 'SELECTIONSTAGE',
            selectionProcessStageId :criteria.selectionProcessStageId,
            applicationId:criteria.applicationId
    	   };

        store.load();
    },

    /**
     * Code to load the seatType combo, parameters to be sent are selectionProcessStageId and programSelectionProcessId
     * @param {Object} the reference of the combo
     * @author akshay.kalbhor
     */
    loadSeatTypeCombo: function(combo) {
    	var store=combo.getStore();
    	combo.clearValue();
        store.removeAll();
        
    	var url = this.getUrlOfStore(store);
        url = url.concat('?selectionProcessStageId=' + this.getSelectionProcessStageId());
        url = url.concat('&programSelectionProcessId=' + this.getProgramSelectionProcessId());
        store.getProxy().api.read = url;
    	
		store.load({
			scope: this,
			  callback: function(records, operation, success) {
				  if(records){
					  var data =[];
					  data.push(store.getAt(0));
					  combo.setValue(data);
				  }
			  }
		});
		
    },

    /**
     * code to validate the selection of the seat type from the seattype combo and open the transferSeats window.
     * @param {Object} the reference of the clicked button.
     * @author akshay.kalbhor
     */
    validateAndShowAddColumnWindow: function(button) {
        var multiselectCombo = button.up('grid').down('multiselectcombofield#seatTypesCombo');
        if (multiselectCombo.getValue() != undefined && multiselectCombo.getValue() != "" && multiselectCombo.getValue().length > 0) {
            var selectedValues = multiselectCombo.getValue();
            var windowRef = this.getTransferSeatsWindow();
            if (!windowRef) {
                windowRef = Ext.widget('transferseatswindow');
            }
            var form = windowRef.down('form');
            var fromSeatTypeCombo = form.down('combo#fromSeatTypeCombo');
            var fromSeatTypeStore = fromSeatTypeCombo.getStore();
            fromSeatTypeStore.loadRecords(selectedValues);

            fromSeatTypeCombo.bindStore(fromSeatTypeStore);
            windowRef.show();
        } else {
            showWarningMessage(getAdmissionTranslation('TRANSFER_SEATS'), getErrorTranslation('SEAT_TYPE_NOT_NULL'));
        }
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference, permissionsMap, itemId) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var grid = this.getContentPanel().down(itemId);

//        var enterMarksButton = grid.down("#enterMark"); //itemId of split button
//        var importMarksButton = grid.down('#importMark');
//        var changeStatusButton = grid.down('#changeStatus');

//        var overRideQuotaButton = grid.down('#overrideQuotaLimits');
//        var transferSeatButton = grid.down('#transferSeatBtn');

//        var previewChangeButton = grid.down('#previewChange');
//        var applySeatTransferButton = grid.down('#applySeatTransfers');
//        var addColumnButton = grid.down('#addColumn');
        
//        var exportToPdfBtn = grid.down('#exportToPdfBtn');
//        var exportToXcelBtn = grid.down('#exportToXcelBtn');
        
        if (itemId == '#applicationStageBasicSearchGrid') {

        	enterMarksButton = grid.down("#enterMark"); //itemId of split button
            importMarksButton = grid.down('#importMark');
            changeStatusButton = grid.down('#changeStatus');
        	
        	if (!isNullOrEmpty(enterMarksButton)) {
        		enterMarksButton.setVisible(false);
        	}
        	if (!isNullOrEmpty(importMarksButton)) {
        		importMarksButton.setVisible(false);
        	}
        	if (!isNullOrEmpty(changeStatusButton)) {
        		changeStatusButton.setVisible(false);
        	}
            
            
        }
//        if (itemId == '#stagestatasticsgrid') {
        	
//        	overRideQuotaButton = grid.down('#overrideQuotaLimits');
//            transferSeatButton = grid.down('#transferSeatBtn');
            
//            overRideQuotaButton.setVisible(false);
//            transferSeatButton.setVisible(false);
//        }
        if (itemId == '#transferseatsgrid') {
        	
        	 previewChangeButton = gridReference.down('#previewChange');
             applySeatTransferButton = gridReference.down('#applySeatTransfers');
             addColumnButton = gridReference.down('#addColumn');
        	
            previewChangeButton.setVisible(false);
            applySeatTransferButton.setVisible(false);
            addColumnButton.setVisible(false);
        }

        Ext.each(permissionList, function(privilege) {
            if (privilege === 'ENTERMARKS') {
                if (!isNullOrEmpty(enterMarksButton)) {
                    enterMarksButton.setVisible(true); //enable more action button
                }
            } if (privilege === 'IMPORTMARKS') {
                if (!isNullOrEmpty(importMarksButton)) {
                    importMarksButton.setVisible(true);
                }
            } if (privilege === 'CHANGESTATUS') {
                if (!isNullOrEmpty(changeStatusButton)) {
                    changeStatusButton.setVisible(true);
                }
            } if (privilege === 'OVERRIDEQUOTALIMIT') {
                if (!isNullOrEmpty(overRideQuotaButton)) {
                    overRideQuotaButton.setVisible(true);
                }
            } if (privilege === 'TRANSFERSEATS') {
                if (!isNullOrEmpty(transferSeatButton)) {
                	transferSeatButton.setVisible(true);
                }
            } if (privilege === 'PREVIEWCHANGE') {
                if (!isNullOrEmpty(previewChangeButton)) {
                    previewChangeButton.setVisible(true);
                }
            }  if (privilege === 'APPLYSEATTRANSFER') {
                if (!isNullOrEmpty(applySeatTransferButton)) {
                    applySeatTransferButton.setVisible(true);
                }
            }  if (privilege === 'ADDCOLUMN') {
                if (!isNullOrEmpty(addColumnButton)) {
                    addColumnButton.setVisible(true);
                }
            } if (privilege === 'EXPORT') {
            	var exportToPdfBtn = grid.down('#exportToPdfBtn');
                if (!isNullOrEmpty(exportToPdfBtn)) {
                	exportToPdfBtn.setVisible(true);
                }
            }if (privilege === 'EXPORT') {
                var exportToXcelBtn = grid.down('#exportToXcelBtn');
                if (!isNullOrEmpty(exportToXcelBtn)) {
                	exportToXcelBtn.setVisible(true);
                }
            }
        });
    },
    //******************disable Selection stage Buttons***********************************************************
    disableSelectionstagePrivileges:function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	//buttonsToolBar = gridReference.query('toolbar')[0];
    
    	var ruleCriteria = gridReference.down('#ruleCriteria');
    	if(!isNullOrEmpty(ruleCriteria)){
    	 ruleCriteria.setVisible(false);
    	}
    	var stageDocument = gridReference.down('#stageDocument');
    	if(!isNullOrEmpty(stageDocument)){
    	 stageDocument.setVisible(false);
    	}
    	 var calculateRank = gridReference.down('#calculateRank');
    	 if(!isNullOrEmpty(calculateRank)){
    	 calculateRank.setVisible(false);
    	 }
    	 var evaluateApplicant = gridReference.down('#evaluateApplicant');
    	 if(!isNullOrEmpty(evaluateApplicant)){
    	 evaluateApplicant.setVisible(false);
    	 }
    	 var generatePrecloserList = gridReference.down('#generatePrecloserList');
    	 if(!isNullOrEmpty(generatePrecloserList)){
    	 generatePrecloserList.setVisible(false);
    	 }
    	 var promoteApplicantToNextStage = gridReference.down('#promoteApplicantToNextStage');
    	 if(!isNullOrEmpty(promoteApplicantToNextStage)){
    	 promoteApplicantToNextStage.setVisible(false);
    	 }
    	 var promoteWithConditionsBtn = gridReference.down('#promoteWithConditions');
    	 if(!isNullOrEmpty(promoteWithConditionsBtn)){
    		 promoteWithConditionsBtn.setVisible(false);
    	 }
    	 
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'VIEWRULECRITERIA') {
    			if(!isNullOrEmpty(ruleCriteria)){
    				ruleCriteria.setVisible(true);
    			}        		
    		}
    		if (privilege === 'STAGEDOCUMENTS') {
    			if(!isNullOrEmpty(stageDocument)){
    				stageDocument.setVisible(true);
    			}        		
    		}
    		/*if (privilege === 'EVALUATEAPPLICANT') {
    			if(!isNullOrEmpty(evaluateApplicant)){
    				evaluateApplicant.setVisible(true);
    			}        		
    		}
    		if (privilege === 'PROMOTETONEXTSTAGE') {
    			if(!isNullOrEmpty(promoteApplicantToNextStage)){
    				promoteApplicantToNextStage.setVisible(true);
    			}        		
    		}
    		if (privilege === 'CALCULATERANK') {
    			if(!isNullOrEmpty(calculateRank)){
    				calculateRank.setVisible(true);
    			}        		
    		}
    		if (privilege === 'GENERATEPRECLOSURELIST') {
    			if(!isNullOrEmpty(generatePrecloserList)){
    				generatePrecloserList.setVisible(true);
    			}        		
    		}*/
    		
    	});
    },
    
  //******************disable Selection stage Bottom Panel Buttons***********************************************************
    disableSelectionstageBottomPanelPrivileges:function(gridReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	 var calculateRank = gridReference.down('#calculateRank');
    	 calculateRank.setVisible(false);
    	 var evaluateApplicant = gridReference.down('#evaluateApplicant');
    	 evaluateApplicant.setVisible(false);
    	 var generatePrecloserList = gridReference.down('#generatePrecloserList');
    	 generatePrecloserList.setVisible(false);
    	 var promoteApplicantToNextStage = gridReference.down('#promoteApplicantToNextStage');
    	 promoteApplicantToNextStage.setVisible(false);
    	 var promoteWithConditionsBtn = gridReference.down('#promoteWithConditions');
    	 promoteWithConditionsBtn.setVisible(false);
    	 var closeStage = gridReference.down('#closeStage');
    	 closeStage.setVisible(false);
    	 
    	Ext.each(permissionList, function(privilege) {
    		
    		if (privilege === 'EVALUATEAPPLICANT') {
    			if(!isNullOrEmpty(evaluateApplicant)){
    				evaluateApplicant.setVisible(true);
    			}        		
    		}
    		if (privilege === 'PROMOTETONEXTSTAGE') {
    			if(!isNullOrEmpty(promoteApplicantToNextStage)){
    				promoteApplicantToNextStage.setVisible(true);
    			}        		
    		}
    		if (privilege === 'CALCULATERANK') {
    			if(!isNullOrEmpty(calculateRank)){
    				calculateRank.setVisible(true);
    			}        		
    		}
    		if (privilege === 'GENERATEPRECLOSURELIST') {
    			if(!isNullOrEmpty(generatePrecloserList)){
    				generatePrecloserList.setVisible(true);
    			}        		
    		}
    		if (privilege === 'CLOSESTAGE') {
    			if(!isNullOrEmpty(closeStage)){
    				closeStage.setVisible(true);
    			}        		
    		}
    		if (privilege === 'PROMOTEWITHCONDITIONS') {
    			if(!isNullOrEmpty(promoteWithConditionsBtn)){
    				promoteWithConditionsBtn.setVisible(true);
    			}        		
    		}
    		
    	});
    	 if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
    		 closeStage.setVisible(false);
         }
    },

    getDownloadFile : function(documentId,fileType){

    	if(!isNullOrEmpty(documentId)){
    		var csvForm = Ext.create('Ext.form.Panel'); 
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'POST',
    			params :{
    				access_token : Ext.Ajax.defaultHeaders.access_token
    			},
    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
    			standardSubmit :true
    		});
    	}
    },
    
    disableSelectionStageStructure: function(structure, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var admissionSelectionStageImportTab = false;
        var admissionSelectionStageImportStatusTab = false;
       
        for (var i = 0; i < permissionList.length; i++) {
            if (permissionList[i] === "IMPORT_BULK_SELECTION_STAGE_MARK") {
                admissionSelectionStageImportTab = true;
            }
            if (permissionList[i] === "IMPORT_BULK_SELECTION_STAGE_STATUS") {
            	admissionSelectionStageImportStatusTab = true;
            }
        }

        this.showSelectionStageTab(admissionSelectionStageImportTab, admissionSelectionStageImportStatusTab, structure);
    },

    showSelectionStageTab: function(admissionSelectionStageImportTab, admissionSelectionStageImportStatusTab, structure) {
        var panelItem = [];
        var newcont = structure.items.items.length;
        var insertPosition = newcont + 1;

        var tabPanelItems = [{
            title: getCommonTranslation('SEARCH'),
            xtype: 'panel',
            items: [{
                xtype: 'selectionstagesearchfilter'
            }, {
                xtype: 'stagedetailsstructure'
            }]
        }];

        // Add IMPORT_BULK_SELECTION_STAGE_MARK tab if permission exists
        if (admissionSelectionStageImportTab) {
            tabPanelItems.push({
                xtype: 'selectionstagetransferuploaddownloadstructure',
                itemId: 'selectionstagetransferuploaddownloadstructure'
            });
        }

        // Add IMPORT_BULK_SELECTION_STAGE_STATUS tab if permission exists
        if (admissionSelectionStageImportStatusTab) {
            tabPanelItems.push({
                xtype: 'selectionstagestatustransferuploaddownloadstructure',
                itemId: 'selectionstagestatustransferuploaddownloadstructure'
            });
        }

        panelItem.push({
            xtype: 'form',
            plain: true,
            style: {
                overflow: 'hidden !important',
                margin: '0!important'
            },
            bodyStyle: {
                margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
            },
            frame: false,
            border: false,
            items: [{
                xtype: 'hidden',
                itemId: 'stageObject',
                name: 'stageObject'
            }, {
                xtype: 'hidden',
                itemId: 'stageEvalParamsObject',
                name: 'stageEvalParamsObject'
            }, {
                xtype: 'tabpanel',
                plain: true,
                style: {
                    overflow: 'hidden !important',
                    margin: '0!important'
                },
                bodyStyle: {
                    margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
                },
                frame: false,
                border: false,
                items: tabPanelItems
            }, {
                xtype: 'fieldcontainer',
                itemId: 'stageButtonContainer',
                hidden: true,
                layout: 'hbox',
                margin: 13,
                defaults: {
                    xtype: 'button',
                    ui: 'CustomBtnThird',
                    scale: CONSTANTS.BUTTONSIZE
                },
                items: [{
                    text: getAdmissionTranslation('CALCULATE_RANK'),
                    disabled: true,
                    itemId: 'calculateRank'
                }, {
                    text: getAdmissionTranslation('EVALUATE_APPLICANT'),
                    disabled: true,
                    itemId: 'evaluateApplicant'
                }, {
                    text: getAdmissionTranslation('GENERATE_PRECLOSER_LIST'),
                    disabled: true,
                    itemId: 'generatePrecloserList'
                }, {
                    text: getAdmissionTranslation('PROMOTE_APPLICANT_TO_NEXT_STAGE'),
                    disabled: true,
                    itemId: 'promoteApplicantToNextStage'
                }, {
                    text: getAdmissionTranslation('PROMOTE_WITH_CONDITIONS'),
                    disabled: true,
                    itemId: 'promoteWithConditions'
                }, {
                    text: getAdmissionTranslation('CLOSE_STAGE'),
                    disabled: true,
                    itemId: 'closeStage'
                }]
            }]
        });

        structure.insert(insertPosition, panelItem);
    },
    
    enableDisabelIndivisualModeButtonOnMultiSelect: function(status) {
    	
        if(!this.getProgramSelectionProcessStageObject().selectionProcessStage.whetherSelectionInBatches){
        	var grid = this.getApplicationStageBasicSearchGrid();
        	var evaluateApplicantFlag = true;
        	var promoteApplicantToNextStageFlag = true;
        	var promoteWithConditionsFlag = true;
        	
        	var evaluateApplicant = this.getSelectionStageStructure().down('button#evaluateApplicant');
    		var promoteApplicantToNextStage = this.getSelectionStageStructure().down('button#promoteApplicantToNextStage');
    		var promoteWithConditions = this.getSelectionStageStructure().down('button#promoteWithConditions');
    		
        	var count = grid.getSelectionModel().getCount();
        	if(count>0) {
        	for(var i=0;i<count;i++) {
        		
        		var selectedRecord = grid.getSelectionModel().getSelection()[i];

        		var applcantStatus=selectedRecord.get('APPLICANT_STATUS');
        		
        		if((applcantStatus =='INPROGRESS' || applcantStatus =='SELECTED' || applcantStatus =='REJECTED'  || applcantStatus =='NOT_APPLICABLE') && promoteApplicantToNextStageFlag){
        			promoteApplicantToNextStageFlag = false;
        			promoteWithConditionsFlag = false;
        		}
        		
        		if((applcantStatus =='READY_TO_PROMOTED' || applcantStatus =='SELECTED' || applcantStatus =='REJECTED' || applcantStatus =='NOT_APPLICABLE') && evaluateApplicantFlag){
        			evaluateApplicantFlag = false;  
        			
        		}

        		if(status == 'CLOSED'){
        			evaluateApplicant.setDisabled(true);
        			promoteApplicantToNextStage.setDisabled(true);
        			promoteWithConditions.setDisabled(true);
        		}
         }
        	if(!promoteApplicantToNextStageFlag) {
        		promoteApplicantToNextStage.setDisabled(true);
        	} else {
        		promoteApplicantToNextStage.setDisabled(false);
        	} 
        	if(!evaluateApplicantFlag) {
        		evaluateApplicant.setDisabled(true);
        	} else {
        		evaluateApplicant.setDisabled(false);
        	}
        	if(!promoteWithConditionsFlag) {
        		promoteWithConditions.setDisabled(true);
        	} else {
        		promoteWithConditions.setDisabled(false);
        	} 
        	if(!evaluateApplicantFlag && !promoteApplicantToNextStageFlag) {
        		evaluateApplicant.setDisabled(true);
        		promoteApplicantToNextStage.setDisabled(true);
        		promoteWithConditions.setDisabled(true);
        	}
        } else {
    	   promoteApplicantToNextStage.setDisabled(true);
    	   evaluateApplicant.setDisabled(true);
    	   promoteWithConditions.setDisabled(true);
       }	
       } else {
    	   this.enableDisabelIndivisualModeButton("");
       }
    },
    stageFeeStatistics:function(){
    	var $this=this;
    	var searchForm = this.getSelectionstagesearchfilter().getForm();
        var grid = this.getStageFeeStatasticsgrid();
        var statusCombo = grid.down('combo#stagefeestatuscombo');
        var formValues = new Array();
        formValues = searchForm.getValues();
    	var statusValue=null;
    	if(!isNullOrEmpty(statusCombo.getValue())){
    		if(statusCombo.getValue()!="" && statusCombo.getValue().length==1){
    			var statusValue=statusCombo.getValue()[0].data.id;
    		}else{
    			if(statusCombo.getValue()!="" && statusCombo.getValue().length==2){
    				statusValue='NA';
    			}
    		}
    	}
        var store=grid.getStore();
        if(!isNullOrEmpty(formValues.PROGRAM_SELECTION_PROCESS_STAGE_ID)){
        	/*var stageObject=$this.getProgramSelectionProcessStageObject();
        	var msgByPass = grid.down('#msgByPass');
        	if(!isNullOrEmpty(stageObject) &&  (stageObject.whetherFeePlanByPass || stageObject.whetherFeePlanByPass==true)){
        		msgByPass.setVisible(true);
        	}else{
        		if(!isNullOrEmpty(stageObject) &&  (!stageObject.whetherFeePlanByPass || stageObject.whetherFeePlanByPass==false)){
        			msgByPass.setVisible(false);	
        		}else{
        			
        		}
        	}*/
        	this.showFeeByPassMsg(formValues.PROGRAM_SELECTION_PROCESS_STAGE_ID);
        	store.getProxy().extraParams = {
       		  programSelectionPrcessStageId:formValues.PROGRAM_SELECTION_PROCESS_STAGE_ID,
       		  applicantName:formValues.APPLICANT_NAME,
       		  applicantId:formValues.APPLICATION_ID,
       		  applicantCurrentStatus:formValues.CURRENT_STATUS,
       		  billStatus:statusValue
       	   };
       	   //$this.resetPageSetting(store);
       	   store.load();
        }
 	   
    },
    
    
  
    showFeeByPassMsg:function(programSelectionProcessStageId){
    	var grid = this.getStageFeeStatasticsgrid();
		if(!isNullOrEmpty(grid)){
			var msgByPass = grid.down('#msgByPass');
			var url = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
			url = url.concat('/' + programSelectionProcessStageId);
			this.sendGetAjaxRequest(url, 'GET', '', function(opt, success, response) {
				if (success) {
					var data = Ext.decode(response.responseText);
					if(!isNullOrEmpty(data) &&  (data.whetherFeePlanByPass || data.whetherFeePlanByPass==true)){
						msgByPass.setVisible(true);
					}else{
						if(!isNullOrEmpty(data) &&  (!data.whetherFeePlanByPass || data.whetherFeePlanByPass==false)){
							msgByPass.setVisible(false);	
						}
					}
				}});
		}
    },
    showConditionsForAdmissionWindow:function() {
    	$this = this;
    	 var gridWindow = $this.getSelectionstageconditionsadmission();
		  if (!gridWindow) {
			  Ext.widget('selectionstageconditionsadmission');
			   gridWindow = $this.getSelectionstageconditionsadmission();
		  }
		  gridWindow.show();
		  var records=this.getApplicationStageBasicSearchGrid().getSelectionModel().getSelection()[0];
		  var grid = $this.getSelectionstageconditionsdocumentlist();
		  var store = grid.getStore();
		  store.getProxy().extraParams = {
			  applicationId: records.data.APPLICATION_PRIMERY_ID
		  };
		  store.load();
    },
    saveConditionsForAdmissionWindow:function() {
    	var this$ = this;
    	var formWindow = this$.getSelectionstageconditionsadmission();
    	var form = formWindow.down('#selectionstageconditionsadmissionFormId').getForm().getValues();
    	var applicationStageRecords=this$.getApplicationStageBasicSearchGrid().getSelectionModel().getSelection()[0];
    	var grid = this$.getSelectionstageconditionsdocumentlist();
    	var records = grid.getSelectionModel().getSelection(); 
    	if(records.length>0 || form.conditionApplicable !="")
    		{
    	var docArray = new Array();
    	for(var j=0; j<records.length; j++){
    		var pbpsPanelContainer=records[j].data.id;
    		docArray.push({
    			id:pbpsPanelContainer,
    		});
    	}
    	jsonData= [{
			"applicationProgramStageId": applicationStageRecords.get('ID'),
			"programSelectionProcessStageId": this$.getProgramSelectionProcessStageId(),
			"applicationId": applicationStageRecords.get('APPLICATION_PRIMERY_ID'),
			"forceToPromote": false,
			"promoteWithCondition": true,
			"condition": form.conditionApplicable,
			requiredDocuments:docArray

		}]
    	var documentsArr = Ext.encode(jsonData);
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var url = SERVERURL.APPLICATION_PROGRAM_STAGE_PROMOTETONEXTSTAGE;
    	Ext.Ajax.request({
    		type: 'rest',
    		url: url,
    		jsonData: documentsArr,
    		method: 'POST',
    		success: function(form, action) {
    			Ext.getBody().unmask();
    			this$.getSelectionstageconditionsadmission().close();
    			this$.getApplicationStageBasicSearchGrid().getStore().reload();
    			showSuccessMessage(getAdmissionTranslation('CONDITIONS_FOR_ADMISSION'), getAdmissionTranslation('APPLICANT_PROMOTED_SUCCESSFULLY'));
    		}
    	});
    		}else
    			{
    			showWarningMessage(getCommonTranslation('ALERT'),getAdmissionTranslation('EITHER_SELECT_DOCUMENT_OR_FILL_CONDITION'));
    			}
    },
    doAccessSelectionStagePermissionTreePanel: function(structure) {
    	var treePanel = structure;
    	var treePnlRootNode = treePanel.getRootNode();
    	this.checkPermissionAndRemoveStageSelectionTreePnl(treePnlRootNode,this.getSTAGE_ATTRIBUTE_TREELINKS_PERMISSIONS(), "STAGE_ATTRIBUTE"); 
    	this.checkPermissionAndRemoveStageSelectionTreePnl(treePnlRootNode,this.getSTAGE_STATISTICS_TREELINKS_PERMISSIONS(), "STAGE_STATISTICS");
    	this.checkPermissionAndRemoveStageSelectionTreePnl(treePnlRootNode,this.getTRANSFER_SEATS_TREELINKS_PERMISSIONS(), "TRANSFER_SEATS");
    	this.checkPermissionAndRemoveStageSelectionTreePnl(treePnlRootNode,this.getOVERRIDE_QUOTA_LIMITS_TREELINKS_PERMISSIONS(), "OVERRIDE_QUOTA_LIMITS");
    	this.checkPermissionAndRemoveStageSelectionTreePnl(treePnlRootNode,this.getSTAGE_FEE_STATISTICS_TREELINKS_PERMISSIONS(), "STAGE_FEE_STATISTICS");
    },
    checkPermissionAndRemoveStageSelectionTreePnl: function(treePnlRootNode, permissionMap, permissionKey){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
    	var constView = 'VIEW';
    	if(!isNullOrEmpty(permissionList)){
    		if(!Ext.Array.contains(permissionList, constView)) {							
    			var vacantNode = treePnlRootNode.findChild("permissionKey",permissionKey,true);
    			if(!isNullOrEmpty(vacantNode)){
    				vacantNode.remove(); 
    			}
    		} 
    	}
    },
    calculateFinalResult : function(button) {
    	 var this$ = this;
         var applicantSearchResultGrid = button.up('panel[xtype=selectionstagestructure]').down('searchresultgrid#applicationStageBasicSearchGrid');
         if (applicantSearchResultGrid.getStore().getCount() > 0) {
         	
 	        showConfirmMessage(getAdmissionTranslation('CALCULATING_FINAL_RESULT_LIST'), getAdmissionTranslation('CALCULATING_FINAL_RESULT_CONFIRM_MESSAGE'),
 	
 	        function(btn, text) {
 	            if (btn == 'yes') {
 	                Ext.getBody().mask(getAdmissionTranslation('CALCULATING_FINAL_RESULT_LIST'), 'x-mask-loading');
 	                Ext.Ajax.request({
 	                    type: 'rest',
 	                    url: SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND + "/" + this$.getProgramSelectionProcessStageId() + "/" + SERVERURL.PATH_CALCULATE_FINAL_RESULT,
 	                    method: 'PUT',
 	                    success: function(form, action) {
 	                        this$.loadStageFunction();
 	                        Ext.getBody().unmask();
 	                        showSuccessMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('CALCULATING_FINAL_RESULT_LIST_SUCCESS'));
 	                    }
 	                });
 	            }
 	        });
         } else {
             showWarningMessage(getAdmissionTranslation('PROGRAM_SELECTION_STAGE'), getAdmissionTranslation('EMPTY_GRID_MESSAGE'));
         }
	}
}); 