/**
 * Niklesh Tiwane
 */
Ext.define('Academia.controller.alumniManagementSystem.AlumniManagementController', {
	extend: 'Academia.controller.base.BaseController',
	mixins: { 		
		PersonCommonController : 'Academia.controller.personinfo.common.PersonCommonController'
    },
	models:['alumni.alumniList.AlumniListModel','alumni.signUpRequest.SignUpRequestModel'],
	stores: [
		'alumni.alumniList.AlumniListStore','alumni.signUpRequest.SignUpRequestStore','alumni.alumniList.AlumniALStore',
		'alumni.alumniList.AlumniBatchStore','alumni.alumniList.AlumniEmailIdStore','alumni.alumniList.AlumniIDStore',
		'alumni.alumniList.AlumniMobileNoStore','alumni.alumniList.AlumniNameStore','alumni.alumniList.AlumniProgramStore',
		'alumni.alumniList.AlumniStudentIDStore','alumni.alumniList.AlumniALStore','alumni.signUpRequest.AlumniSignUpRequestIDStore',
		'alumni.signUpRequest.SignUpNameStore','alumni.signUpRequest.SignUpEmailStore','alumni.signUpRequest.SignUpMobileNoStore','common.SalutationStore','common.GenderTypeStore','common.CountryStore','alumni.alumniList.AlumniProfileDataStore',
		'organization.AddressTypeStore','common.CountryStore','organization.CountryRegionStore','organization.CityByCountryRegion','importutility.ImportApplicantStore','importutility.ModuleName','alumni.alumniList.AlumniStatusStore',
		'Academia.store.common.ProgramStore','alumni.alumniList.AlumniOccupationStore','alumni.alumniList.AlumniIDNameStore','alumni.alumniList.AlumniEmailIdStore','alumni.alumniList.AlumniNotificationStore',
    	'alumni.alumniCommunicationHistory.AlumniCommunicationHistoryGridStore'
	],
	views: [
		'alumniSystem.alumniList.alumniListStructure','alumniSystem.alumniList.AlumniListFilter','alumniSystem.alumniList.alumniListGrid',
		'alumniSystem.signUpRequest.SignUpRequestStructure','alumniSystem.signUpRequest.SignUpRequestFilter',
		'alumniSystem.signUpRequest.SignUpRequestGrid','alumniSystem.signUpRequest.SignUpRequestDetails','alumniSystem.alumniCommon.widget.AlumniRequestRejectWindow',
		'alumniSystem.alumniCommon.widget.RejectedRecordMsg', 'alumniSystem.alumniCommon.widget.AlumniResetPassword','alumniSystem.alumniList.AlumniDetailsLinkPanel',
		'alumniSystem.alumniList.AlumniProfile','alumniSystem.alumniList.AlumniPersonalInformationForm','personinfo.common.PersonInfoPanel','alumniSystem.alumniList.PhotoUploadForm',
		'alumniSystem.alumniList.AlumniAddressDetailsForm','alumniSystem.alumniList.AlumniEducationHistoryForm','alumniSystem.alumniList.AlumniAddressDisplayPanel',
		'alumniSystem.alumniCommon.widget.AlumniAddressFormWindow','alumniSystem.alumniCommon.widget.AlumniAddressFormWindow',
		'alumniSystem.alumniList.AlumniProfessionalDetailForm','alumniSystem.alumniList.AlumniAddressForm','alumniSystem.alumniList.AddAlumniAddressWin',
		'common.DynamicFieldFormWin','common.IdGeneratorCustomForm','alumniSystem.alumniUploadDownloadStructure.AlumniUploadDownloadStructure',
		'alumniSystem.alumniUploadDownloadStructure.AlumniDownloadForm','alumniSystem.alumniUploadDownloadStructure.AlumniUploadForm','importutility.ImportByModule.ImportListAlumni',
		'Academia.view.personinfo.student.StudentUploadPhotoWindow','alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryStructure',
    	'alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryFilter',
    	'alumniSystem.alumniCommunicationHistory.AlumniCommunicationHistoryGrid'
	],
	config: {
		ALUMNI_MANAGEMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ALUMNI_MANAGEMENT_PRIVILEGES'),
		ALUMNI_SIGNUP_REQUEST_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ALUMNI_SIGNUP_REQUEST_PRIVILEGES'),
	},
	refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    	},{
			ref:'alumniListStructure',
			selector:'alumniListStructure'		
		},{
			ref:'alumniListFilter',
			selector:'alumniListFilter'
		},{
			ref:'alumniListGrid',
			selector:'alumniListGrid'
		},{
			ref:'signUpRequestStructure',
			selector:'signUpRequestStructure'
		},{
			ref:'signUpRequestFilter',
			selector:'signUpRequestFilter'
		},{
			ref:'signUpRequestGrid',
			selector:'signUpRequestGrid'
		},{
			ref:'signUpRequestDetails',
			selector:'signUpRequestDetails'
		},{
			ref:'alumniRequestRejectWindow',
			selector:'alumniRequestRejectWindow'
		},{
			ref:'rejectedRecordMsg',
			selector:'rejectedRecordMsg'
		},{
			ref:"alumniresetpassword",
			selector:"alumniresetpassword[itemId=alumniresetpasswordItemid]"
		},{
			ref:"alumnipersonalinformationform",
			selector:"alumnipersonalinformationform"
		},{
			ref:"alumniprofile",
			selector:"alumniprofile"
		},{
			ref:"alumnidetailslinkpanel",
			selector: 'alumnidetailslinkpanel[itemId=alumniPersonDetailsLinkPanel]'
		},{
			ref:"personinfopanel",
			selector: 'personinfopanel'
		},{
			ref:"alumnieducationhistoryform",
			selector: 'alumnieducationhistoryform'			
		},{
			ref:"alumniprofessionaldetailform",
			selector: 'alumniprofessionaldetailform'
		},{
			ref:'alumniaddressdisplaypanel',
			selector:'alumniaddressdisplaypanel'
		},{
			ref:'alumniAddressForm',
			selector:'alumniAddressForm'
		},{
			ref:'alumnidownloadform',
			selector:'alumnidownloadform'			
		},{
			ref:'alumniUploadForm',
			selector:'alumniuploadform'			
		},{
			ref:'importlistalumni',
			selector:'importlistalumni'
		},{
			ref:'studentuploadphotowindow',
			selector:'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId]'
		},{
	        ref: 'alumnicommunicationhistoryfilter',
	        selector: 'alumnicommunicationhistoryfilter'
	    },{
	        ref: 'alumnicommunicationhistorygrid',
	        selector: 'alumnicommunicationhistorygrid'
	    },{
	    	ref: 'alumnicommunicationhistorystructure',
	    	selector: 'alumnicommunicationhistorystructure'
	    }],
	init: function(application) {
		this.suspendNumFieldChange=false;
		this.control({
			'alumniListStructure':{ 				
				render:function(tab){
					var me = this;
					me.disableAlumniImportTab(tab, me.getALUMNI_MANAGEMENT_PRIVILEGES())
				}
			},
			
		'alumniListGrid':{
			 cellclick: this.cellClickAlumniResultGrid,
        	 afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getALUMNI_MANAGEMENT_PRIVILEGES());
    					me.doAccessControlValidation(grid, me.getALUMNI_MANAGEMENT_PRIVILEGES());
    				},100);
    			},
			selectionchange: function(column, selected,eOpts ){
                    var grid = column.view.up('grid');
                    if(selected.length > 0){
                            grid.down('#resetPasswordId').setDisabled(false);
                            grid.down('#btnDelete').setDisabled(false);
                        }else{
                            grid.down('#resetPasswordId').setDisabled(true);
                            grid.down('#btnDelete').setDisabled(true);
                        }
                    },
			},
		'alumniListGrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var this$ = this;						
					    var grid = this.getAlumniListGrid();
						if(grid.getSelectionModel().getCount()>0){
						     var selectionModel = grid.getSelectionModel().getSelection();
							var idsArr = [];
							selectionModel.forEach(function(obj){
								idsArr.push(obj.get('alumniUserId'));
							});
							var ids =  idsArr.join();
							showConfirmMessage(getAlumni('ALUMNI_LIST'),getAlumni('DO_YOU_WANT_TO_DELETE?'),function(btn,text){
								if (btn == 'yes'){
									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_DELETE_ALUMNI,
										params: {
											alumniUserIds: ids,
										},
										method: 'POST',
										success: function(form, action) {
											Ext.getBody().unmask();
											showSuccessMessage(getCommonTranslation('SUCCESS'),getAlumni('DELETE_SUCCESS'));
											grid.getStore().load();
											grid.getSelectionModel().deselectAll();
										},
										failure:function(){
											Ext.getBody().unmask();
										}
									});
										
								}
							})
						}else{
								showWarningMessage(getAlumni('PLEASE_SELECT_RECORD'),getAlumni('PLEASE_SELECT_RECORD'));//Please select a record
						}
							
	 				}
	       	 },
		'alumniListGrid button[itemId=resetPasswordId]':{
				click: function(obj) {
					var grid = this.getAlumniListGrid();
					if (grid.getSelectionModel().getCount() > 0) {
	        			this.openResetPasswordWindow();
        		} else {
					showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
				}  
				}
			},
		'signUpRequestGrid':{			
			afterrender:function(grid){
				var me = this;
				me.doAccessControlValidation(grid, me.getALUMNI_SIGNUP_REQUEST_PRIVILEGES());
				me.addDataGridConfigButton(grid,me.getALUMNI_SIGNUP_REQUEST_PRIVILEGES());
			},
			selectionchange: function(column, selected, eOpts ){ 
            	var $this = this            	
            	var grid = $this.getSignUpRequestGrid();
            	var gridSeletion = grid.getSelectionModel().getCount();
            	if(grid.getSelectionModel().getCount()==1) { 
					grid.down('#btnView').setDisabled(false)
	            	grid.down('#btnManageRequest').setDisabled(false)	            	            	
            }
            	else{
            		grid.down('#btnView').setDisabled(true)
                	grid.down('#btnManageRequest').setDisabled(true)                	
            	}
            	if(grid.getSelectionModel().getCount()==1 && selected[0].data.alumniStatus=='APPROVED') {                
                    grid.down('#btnManageRequest').setDisabled(true)                                    
                }
            	if(selected.length>0){
            		var statusArr = [];
            		var isApproved = false;
	            	for(var i in selected){
	            		var item = selected[i].data.alumniStatus;
	            		statusArr.push(item);
	            		if(item == "APPROVED"){
	            			isApproved = true;
	            		}
	            	}	            	
	            	if(isApproved){
            			grid.down('#btnAutoApprove').setDisabled(true);
            		}else{
            			grid.down('#btnAutoApprove').setDisabled(false);
            		}
            	}
            	else{
					 grid.down('#btnAutoApprove').setDisabled(true) 
				  }
            },
            cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
            	var gridSignUpBtn = this.getSignUpRequestGrid().down('#btnManageRequest')
                var gridSignUpBtn = this.getSignUpRequestGrid().down('#btnManageRequest')
                var checkAlumniStatus = record.data.alumniStatus;
                var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
                if(columnName == "signupCode" && 'APPROVED' !== checkAlumniStatus){
                    if(e.target.tagName=='A'){
                        this.viewSignUpRequestStructure("",gridSignUpBtn);
                    }
                }
				if(columnName == "documentURL") {
					if(e.target.tagName=='A'){
							if(record.data.documentURL){
								var documentURL= record.data.documentURL;
								var csvForm = Ext.create('Ext.form.Panel'); 
									csvForm.getForm().submit({
										target: '_blank',
										method:'GET',
										params :{
											access_token : Ext.Ajax.defaultHeaders.access_token,
											documentUrlPath:documentURL
										},
										headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
										url: SERVERURL.PATH_ALUMNI_DOCUMENT_DOWNLOAD,
										standardSubmit :true
									});
								}
						}
				}
               }
            },
         'alumniListFilter button[itemId=submitBtn]': {
                click: function(cmp){
                	var me = this,
                	form = me.getAlumniListFilter(),
                	grid = me.getAlumniListGrid(),
                	formVal = form.getForm().getValues();                	
                	grid.getStore().getProxy().extraParams = {
                		alumniCode:formVal.alumniId,
                		studentCode:formVal.studentId,
                		alumniName:formVal.alumniName,
                		emailId:formVal.alumniEmail,
                		mobileNumber:formVal.alumniMobile,
                		academyLocationId:formVal.alumniALName,
                		program:formVal.alumniProgram,
                		batch:formVal.alumniBatch,
                		status: formVal.alumniStatus ? formVal.alumniStatus : 'Active'
					}
                	grid.getStore().load();
                	
                }
            },
            'alumniListFilter button[itemId=resetBtn]': {
            	click: function(cmp){
            		var me = this
            		form = me.getAlumniListFilter()
            		form.getForm().reset();
            		form.down('#alumniProgramItemId').setDisabled(true)
            		form.down('#alumniBatchItemId').setDisabled(true)
            	}
            },
            'alumniListFilter customcombobox[itemId=alumniALItemId]': {
            	select: function(cmp, record){
            		var me = this
            		form = me.getAlumniListFilter()
            		var alProgram = form.down('#alumniProgramItemId')
            		var alBatch = form.down('#alumniBatchItemId')
            		alBatch.reset()
            		alBatch.setDisabled(true)
            		alProgram.reset()
            		alProgram.setDisabled(false)
            		var store = alProgram.getStore()
            		store.getProxy().extraParams = {
            			academyLocationIds: cmp.getValue(),
   				 };
   				 store.load();
            	}	
            },
            'alumniListFilter customcombobox[itemId=alumniProgramItemId]': {
            	select: function(cmp){
            		var me = this
            		form = me.getAlumniListFilter()
            		var alProgram = form.down('#alumniProgramItemId')
            		var alBatch = form.down('#alumniBatchItemId')
            		alBatch.reset()
            		alBatch.setDisabled(false)
            		var store = alBatch.getStore()
	   				 store.load({
	   					 callback:function(records, success){
	   						if (success) {
	   							if (records.length > 0) { 	   								
	   								alBatch.getStore().getProxy().extraParams = {
	   								  programIds: cmp.getValue(),
	   							};
	   								alBatch.getStore().load()
	   							}
	   							
	   						}
	   					 }
	   				 });
	            	}
            },
            'signUpRequestFilter customcombobox[itemId=alumniProgramItemId]':{ 
            	select: function(cmp){
            		var me = this
            		form = me.getSignUpRequestFilter();
            		var alProgram = form.down('#alumniProgramItemId')
            		var alBatch = form.down('#alumniBatchItemId')
            		alBatch.reset()
            		alBatch.setDisabled(false)
            		var store = alBatch.getStore()
	   				 store.load({
	   					 callback:function(records, success){
	   						if (success) {
	   							if (records.length > 0) { 	   								
	   								alBatch.getStore().getProxy().extraParams = {
	   								  programIds: cmp.getValue(),
	   							};
	   								alBatch.getStore().load()
	   							}
	   							
	   						}
	   					 }
	   				 });
	            	}
            }, 
            'signUpRequestFilter button[itemId=searchBtn]': {
                click: function(cmp){
                	var me = this, 
                	form = me.getSignUpRequestFilter(),
                	grid = me.getSignUpRequestGrid(),
                	formVal = form.getForm().getValues();  
                	
                	if(!isNullOrEmpty(formVal.alumniStatus)){                		
                		if(formVal.alumniStatus == "Approved"){
                			formVal.alumniStatus = "APPROVED"
                		}
                		else if(formVal.alumniStatus == "Pending"){
                			formVal.alumniStatus = "PENDING"
                		}
                		else{
                			formVal.alumniStatus = "REJECTED"
                		}
                	}
                
                	grid.getStore().getProxy().extraParams = {
                		requestId:formVal.requestId,
                		alumniName:formVal.requestName,
                		mobileNumber:formVal.requestMobileNumber,
                		alumniStatus:formVal.alumniStatus,
                		emailId:formVal.requestEmailId,
                		program:formVal.alumniProgram,
                		batch:formVal.alumniBatch
					}
                	grid.down('pagingtoolbar').moveFirst();
                    grid.config.searchFilterForm = me.getSignUpRequestFilter();
                }
            },
            'signUpRequestFilter button[itemId=resetBtn]': {
	            	click: function(cmp){
	            		var me = this
	            		form = me.getSignUpRequestFilter()
	            		form.getForm().reset();
	            		form.down('#alumniBatchItemId').setDisabled(true)
	            		
		            	 }
		            },
            'signUpRequestGrid button[itemId=btnView]': {
                click: function(btn){
                	this.viewSignUpRequestStructure("VIEW",btn)
                }
            },
            'signUpRequestGrid button[itemId=btnManageRequest]': { 
				click:function(btn){
					this.viewSignUpRequestStructure("MANAGEREQUEST",btn)
				}
            },
            'signUpRequestGrid button[itemId=btnAutoApprove]': { 
				click:function(btn){
						this.alumniAutoApprove(btn)
					}            
	            },
            'signUpRequestDetails button[itemId=btnApprove]': { 
    			click:function(btn){
    					this.saveAlumniRequest(btn)
    				}            
                },
            'signUpRequestDetails button[itemId=btnReject]': { 
    			click:function(btn){
    				Ext.widget('alumniRequestRejectWindow').show();
    				}            
                },
            'alumniRequestRejectWindow button[itemId=btnSaveReject]': { 
    			click:function(btn){
    				this.saveAlumniRejectReason(btn)
    				}            
                },
            'alumniRequestRejectWindow button[itemId=btnCancleReject]': { 
			click:function(btn){
				Ext.widget('alumniRequestRejectWindow').hide();
				}            
            },
            'alumniresetpassword button[itemId=submitBtn]': { 
    			click:function(btn){
    				this.changePasswordFun(btn)
    				}            
                },
            'signUpRequestDetails customcombobox[itemId=requestProgramItemId]':{                 
                    select: function(cmp){
                        var me = this
                        form = me.getSignUpRequestDetails();
                        var alProgram = form.down('#requestProgramItemId')
                        var alOtherProgram = form.down('#requestOtherProgramItemID')
                        var alBatch = form.down('#requestBatchItemId')                        
                        alOtherProgram.reset();
                        alBatch.reset()
                        alBatch.setDisabled(false)
                        alBatch.getStore().getProxy().extraParams = {
                             programIds: cmp.getValue(),
                        };
                        var store = alBatch.getStore()
                            store.load({
                                callback:function(records, success){
                                   if (success) {
                                       if (records.length > 0) {                                        
                                    	   alBatch.getStore().load()  
                                       }
                                   }
                                }
                            });
                        }
               },
            'signUpRequestDetails customcombobox[itemId=requestBatchItemId]':{
            	select: function(cmp){
            		 var me = this
                     form = me.getSignUpRequestDetails();
                     var alOtherBatch = form.down('#requestOtherBatchItemID')
                     alOtherBatch.reset();                       
                     alOtherBatch.setDisabled(false)
                    
            	}
               },
        	'alumniprofile': {
                render: function(){
                	this.getActiveAlumniProfile();
                },
                afterrender: function(){
                	var associatedAcadLocationIds = new Array();
                    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getALUMNI_MANAGEMENT_PRIVILEGES());
                    var form = this.getContentPanelActiveTab()
					var alumniProfileImageIcon = form.down('#alumni_profile_image_icon');
                    alumniProfileImageIcon.setVisible(false)
                    permissionList.forEach(function(btnName){
                        if(btnName == 'ALUMNI_PROFILE_IMAGE_ICON'){
                             alumniProfileImageIcon.setVisible(true);
                        }
                    });
                }
            },
            "alumniprofile panel[itemId=alumniProfileEastPanel]": {
            	afterrender: function(sidePanel){
            		var me = this,
            			storeRecords = [],
            			sidePanelSearchCombo = sidePanel.down('#personalDetailLinkSearchComboBox'),
            			sidePanelSearchStore = sidePanelSearchCombo.getStore(),
            			sidePanelItems,
            			upperTabTitle,
            			currentDataView,
            			currentItemIndex;

            		sidePanel.up('alumniprofile').on('activate', function(){
            			setTimeout(function(){
                			sidePanelItems = sidePanel.down('alumnidetailslinkpanel').items.items,
                    		Ext.each(sidePanelItems, function(sidePanelItem){
                    			upperTabTitle = sidePanelItem.title;
                    			currentDataView = sidePanelItem.down('dataview');
                    			currentItemIndex = 0;
                    			                    			
                    			Ext.each(currentDataView.store.data.items, function(currentElement){
                    				storeRecords.push({
                    					displayPath: upperTabTitle,
                    					title: getPersonModuleTranslation(currentElement.get('tabPanelTitle')),
                    					parentPanelSelector: currentDataView.el.id,
                    					currentElementSelector: currentDataView.itemSelector,
                    					currentItemIndex: currentItemIndex,
                    					searchText: getPersonModuleTranslation(currentElement.get('tabPanelTitle')),
                    					tabPanelItemXtype: currentElement.data.tabPanelItemXtype
                    				});
                    				currentItemIndex = currentItemIndex + 1;
                    			});
                    		});
                    		
                    		sidePanelSearchStore.removeAll();
                    		sidePanelSearchStore.add(storeRecords);
                    		sidePanel.up('alumniprofile').un('activate');
            			},100);
            		},this);
            	},
            	beforecollapse:function(obj, direction, animate, eOpts){
        			try{
            			if(event.target.classList.contains('x-form-text')){
            				return false;
            			}
        			}
        			catch(e){
        				if(Ext.ComponentQuery.query('#personalDetailLinkSearchComboBox')[0].hasFocus && Ext.ComponentQuery.query('#personalDetailLinkSearchComboBox')[0].allowCollapse==false){
        					return false;
        				}
        			}
            	}
            },
            "alumnidetailslinkpanel[itemId=alumniPersonDetailsLinkPanel] dataview": {
                itemclick: function(view, record) {
                    var tabPanelTitle = record.get('tabPanelTitle');
                    var tabPanelItemId = record.get('tabPanelItemId');
                    var tabPanelItemXtype = record.get('tabPanelItemXtype');
                    var xtypeItemId = record.get('xtypeItemId');
                    var defaultPanel = record.get('defaultPanel');
                    var renderPanel= record.get('render');
                	
                    if (!isNullOrEmpty(renderPanel) && renderPanel) {
                    	this.addPersonTabPanel('ALUMNI', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
                    }
                }
            },
            'alumnieducationhistoryform' :{
            	render:function(form){ 
            		this.getEducationHistory(form)
            	}
            },
            'alumnipersonalinformationform button[itemId=submitButtonId]':{
            	click:this.saveAlumniPersonalInfo
            },
            'alumniprofessionaldetailform':{
            	render: function(form){
                	this.getProfessionalDetail(form)
            	}
            },
            'alumniprofessionaldetailform button[itemId=submitButtonId]':{
            	click: function(btn){
                	this.saveProfessionalDetail(btn)
            	}
            },
            'alumnipersonalinformationform':{
            	afterrender:this.getAlumniPersonData
            },
            'photouploadform filefield[itemId=photoFileImage]':{
            	change:this.checkFileExtentionandSize
            },
            'alumniaddressdisplaypanel button[itemId=modifyPersonalAddress1]':{
            	click:this.addAlumniPersonalAddress
            },
            'addAlumniAddressWin  button[itemId=cancelButtonId]':{
            	click:function(btn){
            		btn.up('window').close()
            		
            	}
            },
            'addAlumniAddressWin  button[itemId=submitButtonId]':{
            	click:this.saveAlumniAddress
            },
            'alumniaddressdisplaypanel':{
            	afterrender:this.getAlumniPersonAddress
            },
            'alumniaddressdisplaypanel button[itemId=modifyPersonalAddress2]':{
            	click:this.addAlumniPersonalAddress
            },
            'alumniaddressdisplaypanel button[itemId=modifyPersonalAddress3]':{
            	click:this.addAlumniPersonalAddress
            },
            'alumnipersonalinformationform  textfield[itemId=firstName]':{
            	change:function(inputType){
            		this.updateName(inputType)
            	}
            },
            'alumnipersonalinformationform  textfield[itemId=middleName]':{
            	change:function(inputType){
            		this.updateName(inputType)
            	}
            },
            'alumnipersonalinformationform  textfield[itemId=lastName]':{
            	change:function(inputType){
            		this.updateName(inputType)
            	}
            },
            'alumniAddressForm customcombobox[itemId=country]':{
            	select:function(item,records){
            		var form = this.getAlumniAddressForm();
            		var country = form.down('#country')
            		var cityId = form.down('#cityId')
            		var parentCountryRegion = form.down('#parentCountryRegion')
            		var countryRegionStore = parentCountryRegion.getStore(); 
            		cityId.reset();
            		cityId.setDisabled(true) 
            		parentCountryRegion.reset()
            		parentCountryRegion.setDisabled(false)            	
            	       
            		 if (records) {
                         if (records.length > 0) {                                        
                      	   parentCountryRegion.getStore().getProxy().extraParams = {
                      		   cid: item.getValue(),
                         };
                      	   parentCountryRegion.getStore().load()
                         }   
                     }          		
            	}
            },    	
            'alumniAddressForm customcombobox[itemId=parentCountryRegion]':{
            	select:function(item,records){
            		var form = this.getAlumniAddressForm();
            		var cityId = form.down('#cityId')
            		cityId.reset();
            		cityId.setDisabled(false)
            		var cityIdStore = cityId.getStore(); 
            		 if (records) {
                         if (records.length > 0) {                                        
                      	   cityId.getStore().getProxy().extraParams = {
                      		   id: item.getValue(),
                         };
                      	   cityIdStore.load()
                         }
                         
                     }
            	}
            },
            'alumniuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	        	change: this.alumniDownloadUploadFormChange
	        },
	        'alumnidownloadform customcombobox[itemId=academyLocationCombo]': { 
	        	select: function(obj, record) {
    	 			var $this = this;
    	 			var form = this.getAlumnidownloadform();

    	 			//var academyLocationComboField = form.down('#academyLocationComboField');
    	 			form.down('#downoladBtnId').setDisabled(false);
    	 		}
	        },
	        'alumnidownloadform button[itemId=downoladBtnId]':{        	
	   			click: function(obj) {
//	   					/var $this = this;
	   					var form = this.getAlumnidownloadform();
	   		   			var alId= form.down().down().getValue();
	   		   			//var alId= form.down('#academyLocationCombo').getValue();
	   					var csvForm = Ext.create('Ext.form.Panel',{
	   						items:[{
                                xtype : 'textfield',
                                maxLength : 20480,
                                itemId : 'alId',
                                name : 'alName',
                                vtype : 'spaceAsInput'
                            }]
	   		   			});	   					
	   					csvForm.down('#alId').setValue(alId);
	   		   			csvForm.getForm().submit({
	  	        		  target: '_blank',
	  	        		  method:'POST',
//	  	        		 url : submitUrl+"?requestId="+signUpReCode,
	  	        		  params :{
	  	        			  access_token : Ext.Ajax.defaultHeaders.access_token, 
	  	        			  academyLocationId : alId
	  	        			  },
	  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	  	        		  url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_IMPORT_BULK_ALUMNI,
	  	        		  standardSubmit :true,
	  	        		  success : function(form, action){
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	          },
	        		  failure: function(form, action) {
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	          }
	  	        	  });
	   			}
	        },
	        'alumniuploadform button[itemId=uploadId]':{
				 click:function(obj){
					 var $this=this;
					 //var importWin=$this.getAlumniUploadForm()
					 var form=$this.getAlumniUploadForm();					 
					 submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
					 $this.getHashOfFile(form);
					 setTimeout(function() {
						 form.getForm().submit({
							 method : 'POST',
							 url : submitUrl,
							 success : function(form, action){
								 showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
							 },
							 failure: function(form, action) {
								 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
							 }
						 });
					 },1000);
					 Ext.defer(function() {
						 var grid = $this.getImportlistalumni();
						 //var form = $this.getAlumniUploadForm();
						 //var isUploadAll = form.items.items[0].getValue().isUploadAll;
						 $this.onChangeUploadOptionRadioGroup(null, grid,'Import Bulk Alumni');
					 }, 2000, this);
				 }  
			 },
			 'alumniuploadform':{
	        		afterrender:function(obj){
	        			var $this=this;
	    	        	var importWin=$this.getAlumniUploadForm()
	    	        	var moduleName = importWin.down('#moduleName');
	    	        	moduleName.getStore().load({
	    	        		callback: function(records, operation, success) {
	    	        			for(var i in records){
		    	        			if(records[i].data.value=="Import Bulk Alumni"){
		    	        				moduleName.setValue(records[i].data.id);
		    	        				moduleName.setReadOnly(true)
		    	        			}
	    	        			}
	            		   }	
	    	        	});
	        		}  
 		 },
 		'importlistalumni button[itemId=btnForce]':{
			click: function(obj) {
	            	var grid = this.getImportlistalumni();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		if(grid.getSelectionModel().getCount() > 1){
		        			showWarningMessage(getCommonTranslation('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
		        		}else{
		        			var this$ = this;
	                	var id = grid.getSelectionModel().selectionStart.data.id;
	                	var urlAppend="?jobName="+id;
	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	    	        	Ext.Ajax.request({
	    	        		url: submitURL,
	    	        		method: 'GET',
	    	        		success: function(response) {
	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	    	        			}else if(response.responseText==="SUCCESS"){
    	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	        			}
	    	        		}
	    	        	});
		        		}
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }
 		},
 		'importlistalumni':{
//		     render : function(obj){
//				var $this = this;
//				var grid = $this.getImportlistalumni();
//				var form =this.getImportintellimaliuploadoptionradiogroup();
//				var isUploadAll = form.items.items[0].getValue().isUploadAll;
//				   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_INTELLIMALI');	
//			  },
			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 				if (e.target.tagName == 'A') {
 					var fileType=null;
 					if(cellIndex==1){
 						fileType='successFile';
 					}else if(cellIndex==6){
 						fileType='errorFile';
 					}else if(cellIndex==7){
 						fileType='logFile';
 					}
 					var documentId = record.get("id");
 					if (!isNullOrEmpty(documentId)) {
 						this.getDownloadFile(documentId,fileType);
 					}
 				}
 			}
		},
		'alumniprofile container[itemId=alumni_profile_image_icon]': {
			  afterrender: function(container) {
			        container.getEl().on('click', this.openAlumniPhotoUploadPopup, this);
			    }
		   },
		   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[name=btnEdit]': {
				   click: function(button) {
					   	var window = this.getStudentuploadphotowindow();
				        var btnEdit = window.down('button[name=btnEdit]');
				        var btnRemove = window.down('button[name=btnRemove]');
				        var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
				        var btnTakePhoto = window.down('button[name=btnTakePhoto]');
				        var btnCancel = window.down('button[name=btnCancel]');
				        var btnBack = window.down('button[name=btnBack]');
				        var btnSave = window.down('button[name=btnSave]');
				        
				        // Hide Edit and Remove buttons
				        btnEdit.setVisible(false);
				        btnRemove.setVisible(false);
				        btnCancel.setVisible(false);
				        
				        // Show Upload Photo and Take a Photo buttons
				        btnUploadPhoto.setVisible(true);
				        btnTakePhoto.setVisible(true);
				        btnBack.setVisible(true);
//				        btnSave.setDisabled(false);
				   }
			   },
			   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[name=btnBack]': {
				   click: function(button) {
					   var window = this.getStudentuploadphotowindow();
					   window.down('#profile_image_containerBox').destroy();
					   	window.down('#profileRoatateImageIconId').hide();
					   	window.down('#profileImageFormItemId').insert(0,{
					   		// Profile Image Container
					   		xtype: 'container',
					   		width: 320,
					   		height: 280,
					   		layout: {
					   			type: 'vbox',
					   			align: 'center',
					   			style: {
					   				position: 'relative',
					   			}
					   		},
					   		itemId: 'profile_image_containerBox',
					   		items: [{
					   			xtype: 'image',
					   			itemId: 'profile_image',
					   			border: 1,
					   			style: {
					   				borderColor: '#e0e0e0',
					   				borderStyle: 'solid',
					   				borderRadius: '50%',
					   				marginTop:'67px !important'
					   			},
					   			width: 210,
					   			height: 210,
					   			src: 'resources/images/default-profile.png',
//					   			margin: '0 0 3 0', // Adds spacing around the image
					   		},{
					   			xtype: 'hidden',
					   			name: 'isImageRemoved',
					   			itemId: 'isImageRemovedItemId'
					   		}]
					   	},
					   	{
					   		id:'capture_panel',
					   		itemId:'capturePanelId',
					   		hidden:true,
					   		listeners:{
					   			show:function(obj){
					   				Webcam.set({
					   					width: 320,
					   					height: 240,
					   					crop_width: 320,
					   					crop_height: 240,
					   					flip_horiz: true,
					   					image_format: 'jpeg', // image format (may be jpeg or png)
					   					jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
					   				});
					   				Webcam.attach('#capture_panel-innerCt');
					   			},
					   			hide: function () {
					   				Webcam.reset();
					   			}
					   		}
					   	},{
					   		xtype:'panel',
					   		itemId:'previewPanelId',
					   		hidden:true
					   	},{
					   		xtype:'panel',
					   		hidden:true,
					   		html: "<canvas  id='canvas' width='310' height='272'></canvas>"
					   	},
					   	// Button Container for Profile Actions
					   	{
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			align: 'middle',
					   			//pack: 'center',
					   		},
					   		margin: '20 0 0 0', // Adds spacing above the buttons
					   		/*defaults: {
					labelAlign: 'top',
					margin: '0 5', // Adds spacing between buttons
				},*/
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('EDIT'),
					   			name: 'btnEdit',
					   			itemId: 'btnEditItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			style: {
					   				width: "60px !important",
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('REMOVE'),
					   			name: 'btnRemove',
					   			itemId: 'btnRemoveItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		},{
					   			xtype: 'filefield',
					   			buttonText: getCommonTranslation('UPLOAD_PHOTO'),
					   			name: 'file',
					   			itemId: 'btnUploadPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			buttonOnly: true
					   		}, {
					   			xtype: 'hidden',
					   			name: 'name',
					   			itemId: 'fileName'
					   		}, {
					   			xtype: 'hidden',
					   			name: 'personId',
					   			itemId: 'personId'
					   		}, {
					   			xtype: 'button',
					   			text: getCommonTranslation('TAKE_A_PHOTO'),
					   			name: 'btnTakePhoto',
					   			itemId: 'btnTakePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('CAPTURE'),
					   			name: 'capturePhoto',
					   			itemId: 'capturePhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('RESET'),
					   			name: 'resetPhoto',
					   			itemId: 'resetPhotoItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   			style:{
					   				marginTop:'6px !important'
					   			}
					   		}]
					   	},
					   	{
					   		xtype: 'button',
					   		cls: 'profileRoatateImageIcon',	
					   		itemId: 'profileRoatateImageIconId',
					   		hidden: true,
					   		rotate: 0.1
					   	},{
					   		// Footer Button Container
					   		xtype: 'container',
					   		layout: {
					   			type: 'hbox',
					   			pack: 'space-between',
					   			//align: 'middle'
					   		},
					   		margin: '60 0 0 0', // Adds spacing above the footer buttons
					   		width: '100%',
					   		defaults: {
					   			//flex: 1,
					   			//margin: '0 100',
					   		},
					   		items: [{
					   			xtype: 'button',
					   			text: getCommonTranslation('CANCEL'),
					   			name: 'btnCancel',
					   			itemId: 'btnCancelItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,	
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('BACK'),
					   			name: 'btnBack',
					   			itemId: 'btnBackItemId',
					   			ui: 'CustomBtnCancel',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			hidden: true,
					   		},{
					   			xtype: 'component', 
					   			flex: 2
					   		},{
					   			xtype: 'button',
					   			text: getCommonTranslation('SAVE'),
					   			name: 'btnSave',
					   			itemId: 'btnSaveItemId',
					   			ui: 'CustomBtnSubmit',
					   			scale: CONSTANTS.BUTTONSIZE,
					   			disabled: true
					   		}]
					   	});
                       var btnEdit = window.down('button[name=btnEdit]');
                       var btnRemove = window.down('button[name=btnRemove]');
                       var btnUploadPhoto = window.down('filefield[itemId=btnUploadPhotoItemId]');
                       var btnTakePhoto = window.down('button[name=btnTakePhoto]');
                       var btnCancel = window.down('button[name=btnCancel]');
                       var btnBack = window.down('button[name=btnBack]');
                       var capturePhoto = window.down('#capturePhotoItemId');
                       var resetPhoto = window.down('#resetPhotoItemId');
                       var profileImage = window.down('#profile_image');
                       var capturePanel = window.down('#capturePanelId');
                       var previewPanelId = window.down('#previewPanelId');
                       var btnSave = window.down('button[name=btnSave]');
                       
                       if (window.lastSavedImageUrl) {
                           profileImage.setSrc(window.lastSavedImageUrl);
                       } else {
                    	   var newImgUrl = generateInitialsImage(
          						 alumniProfile.alumniRec.firstName, 
          						 alumniProfile.alumniRec.middleName, 
          						 alumniProfile.alumniRec.lastName
          						);
                           profileImage.setSrc(newImgUrl);
                       }

                       // Restore the previous image if available
                       if (window.previousProfileImage) {
                           profileImage.setSrc(window.previousProfileImage);
                           profileImage.setVisible(true);
                       }
                       
                       // Reset the file field so it detects the same image when uploaded again
                       btnUploadPhoto.reset();

                       btnEdit.setVisible(true);
                       btnRemove.setVisible(true);
                       btnCancel.setVisible(true);
                       btnSave.setDisabled(true);

                       btnUploadPhoto.setVisible(false);
                       btnTakePhoto.setVisible(false);
                       btnBack.setVisible(false);
                       capturePhoto.setVisible(false);
                       resetPhoto.setVisible(false);
                       capturePanel.setVisible(false);
                       previewPanelId.setVisible(false);
                       
                       // Re-enable capture/reset buttons for future actions
                       capturePhoto.setDisabled(false);
                       resetPhoto.setDisabled(true);
                       window.down('#btnUploadPhotoItemId').reset();
 					    
				   }
			   },
			   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[name=btnCancel]': {
				   click: function(button) {
					   var window = this.getStudentuploadphotowindow();
					   window.close();
				   }
			   },
			   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[itemId=btnTakePhotoItemId]': {
				   click: function(button) {
					   this.openAlumniCapturePhoto();
				   }
			   },
			   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId]' : {
					close : function(obj){
						Webcam.userMedia=true;
						Webcam.reset();
					}
				},
				'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[itemId=capturePhotoItemId]': {
 				   click: function(button) {
 					   this.captureAlumniUserPhoto(button);
 				   }
 			   },
 			  'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[itemId=resetPhotoItemId]': {
                  click: function(button) {
                      var window = this.getStudentuploadphotowindow();
                      window.down('#capturePanelId').setVisible(true);
                      window.down('#previewPanelId').setVisible(false);
                      window.down('#previewPanelId').update('');
                      window.down('#capturePhotoItemId').setDisabled(false);
                      window.down('#resetPhotoItemId').setDisabled(true);
                      window.down('#btnSaveItemId').setDisabled(true);
                      window.cropData = null;
                      window.component = null;
                  }
              },
              'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] filefield[itemId=btnUploadPhotoItemId]': {
				   change: this.uploadAlumniProfilePhoto
			   },
			   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[name=btnSave]': {
				   click: this.uploadAlumniCapturedImage
			   },
			   'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[itemId=btnRemoveItemId]': {
				   click:function(){
					   var window = this.getStudentuploadphotowindow();
					   var profileImage = window.down('#profile_image');
					   var alumniProfile = this.getContentPanelActiveTab();
					   var isImageRemoved = window.down('#isImageRemovedItemId');
					   var btnSave = window.down('button[name=btnSave]');
					   var btnRemove = window.down('button[itemId=btnRemoveItemId]');
					   var newImgUrl = generateInitialsImage(
      						 alumniProfile.alumniRec.firstName, 
      						 alumniProfile.alumniRec.middleName, 
      						 alumniProfile.alumniRec.lastName
      						);
					   profileImage.setSrc(newImgUrl);	
					   isImageRemoved.setValue(true);
					   btnSave.setDisabled(false);
					   btnRemove.setDisabled(true);
				   }
			   },
               'studentuploadphotowindow[itemId=alumniToUploadPhotowindowItemId] button[itemId=profileRoatateImageIconId]': {
				   click: function(button) {
					   var formPanel = this.getStudentuploadphotowindow();
					   var imageContainerBoxId = formPanel.down('#profile_image_containerBox').id;
					   var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
					   imageInnerContainerBox.crop.rotate(button.rotate + .40);
					   button.rotate = parseFloat(button.rotate) + .50;
				   }
			   },
			   'alumnicommunicationhistoryfilter button[name=resetBtn]': {
	            	click: function(cmp){
	                    var me = this;
	                    form = me.getAlumnicommunicationhistoryfilter();
	                    form.getForm().reset();   
	                    form.getForm().clearInvalid(); 
	                }
	            },
	            'alumnicommunicationhistoryfilter button[name=submitBtn]': {
	            	click: this.showCommunicationHistoryData
	            },
				'alumnicommunicationhistorygrid':{
	            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							this.openAlumniMessageReportLink(record);	
						}
	            }
			   
		});
	},
	
	 getDownloadFile : function(documentId,fileType){
		   	if(!isNullOrEmpty(documentId)){
		   		var csvForm = Ext.create('Ext.form.Panel'); 
		   		csvForm.getForm().submit({
		   			target: '_blank',
		   			method:'POST',
		   			params :{
		   				access_token : Ext.Ajax.defaultHeaders.access_token
		   			},
		   			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		   			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
		   			standardSubmit :true
		   		});
		   	}
		   },
	disableAlumniImportTab:function(structure,permissionsMap){
	   	 var associatedAcadLocationIds = new Array();
	   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   	 var ImportAlumniTab=false;
	   	 
	   	 for (var i = 0; i < permissionList.length; i++) {
	   		 if (permissionList[i] === "IMPORT_ALUMNI") {
	   			ImportAlumniTab=true;
	   		 }
	   	 }
	   	 this.showmImportAlumniTab(ImportAlumniTab, structure);
	    
   },
   showmImportAlumniTab: function(ImportAlumniTab,structure){

   	 var panelItem = new Array();
   	 var $this = this;
   	 var newcont=structure.items.items.length;
   	 var insertPosition=newcont+1;
   	 if(ImportAlumniTab==true) {
   		 panelItem.push({
   			xtype:'tabpanel',
  			 plain: true,
  			 style:{overflow:'hidden !important',margin:'0!important'},
  			 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
  			 frame: false,
  			 border:false,
   				items : [{
   					title: getCommonTranslation('SEARCH'),
   					layout:'vbox',
   					defaults: {
   						width:'100%'
   					},
   					items:[{
   						xtype:'alumniListFilter'
   					},{
   						xtype:'alumniListGrid'
   					}]			
   				},{
		   				 xtype:'panel',
		   				 title :getAlumni('IMPORT_ALUMNI'),
		   				 cls:'panelNoSpace',
		   				 items:[{
		   					 xtype: 'alumniuploaddownloadstructure',
		   					 itemId: 'alumniimportmanageId'
		   				 }]
		   			 }]
   		 });
   	 }else{
   		 panelItem.push({
   			 xtype:'tabpanel',
   			 plain: true,
   			 style:{overflow:'hidden !important',margin:'0!important'},
   			 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
   			 frame: false,
   			 border:false,
   			 items:[{
   				title: getCommonTranslation('SEARCH'),
   				layout:'vbox',
   				defaults: {
   					width:'100%'
   				},
   				items:[{
   					xtype:'alumniListFilter'
   				},{
   					xtype:'alumniListGrid'
   				}]			
   			}]
   		 });
   	 }
   	 structure.insert(insertPosition,panelItem);
  },
//	 disableImportAlumniTabPivileges: function(tabReference, permissionsMap) {
//		 var me=this;
//		 var associatedAcadLocationIds = new Array();
//     	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
// 		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getALUMNI_MANAGEMENT_PRIVILEGES());
//     	Ext.each(permissionList, function(privilege) {
//     		if (privilege === 'IMPORT_ALUMNI') {
//         		var button = buttonsToolBar.query('#alumniImportItemId')[0];
//         		if(!isNullOrEmpty(button)){
//         			button.setVisible(true);
//         		}  
//         	}
//     	});
//	 },
	alumniDownloadUploadFormChange: function(cb, nv, ov){
		 var $this = this;
    	 var structure = cb.up('alumniuploaddownloadstructure');
    	 var downloadTemplateForm = structure.down('alumnidownloadform');
    	 var uploadTemplateForm = structure.down('alumniuploadform ');
    	 var grid = $this.getImportlistalumni();
    	 if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    		 uploadTemplateForm.hide();
    		 downloadTemplateForm.show();
    		 grid.setVisible(false);
    	 }else{
    		 downloadTemplateForm.hide();
    		 uploadTemplateForm.show();
    		 grid.setVisible(true);
    	 }
		
	},
	updateName:function(inputType){
		var $this = this;
		var form = $this.getAlumnipersonalinformationform();
		var firstName = form.down('#firstName')
		var middleName = form.down('#middleName')		
		var lastName = form.down('#lastName')
		var printName = form.down('#printName')		
		if(!isNullOrEmpty(firstName && lastName)){
			printName.setValue(firstName.getValue() + " " + middleName.getValue() + " " + lastName.getValue())
		}
		
	},
	saveProfessionalDetail:function(btn){
		var $this = this;
//		var contentPanel = $this.getContentPanel();
//		var profileDetail = $this.getAlumniprofile();
//		var alumniPersonId = profileDetail.alumniPersonId;
		var json;
		var submitUrl;
		var successMsg;  
		var form = this.getAlumniprofessionaldetailform();
		var grid = $this.getAlumniListGrid;
		var formData;		
		var alumniProfessionalId = form.getForm().findField('alumniPerson').getValue()
		if(!isNullOrEmpty(alumniProfessionalId)) { 			
			json = $this.createJsonForAddProfessionalDetail(form); 
				submitUrl = SERVERURL.PATH_ALUMNI_PROFESSIONAL_INFORMATION_UPDATE;
				successMsg = getAlumni('DETAIL_UPDATE_SUCCESSFULLY');
				$this.getAlumniprofessionaldetailform().close();				
				formData = json;
		}
		else{
			json = $this.createJsonForAddProfessionalDetail(form); 
				submitUrl = SERVERURL.PATH_ALUMNI_PROFESSIONAL_INFORMATION_CREATE;
				successMsg = getAlumni('DETAIL_SAVED_SUCCESSFULLY');	
				$this.getAlumniprofessionaldetailform().close();				
				formData = json;
		}
			
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : formData,
				method : 'POST',
				headers : {
					 'Content-Type' : 'application/json'
				 },
				success : function(frm, action) {
					Ext.getBody().unmask(); 
					showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
					//grid.getStore().load();
				}				 
			});	
		
	},
//	add/uppdate professional detail
	createJsonForAddProfessionalDetail:function(form){
		var $this = this
		var profileDetail  = $this.getContentPanelActiveTab();
	    var alumniId = profileDetail.alumniPersonId;
	      
	    var form = profileDetail.down('alumniprofessionaldetailform');
//		var form = this.getAlumniprofessionaldetailform();
    	var formDatas = form.getValues();
    	if(formDatas.alumniPerson){ 
    		json = {
    				'id':formDatas.alumniPerson || null,
    				"occupation":formDatas.occupation || null,
        			"organization":formDatas.organization || null,
        			"designation": formDatas.designation || null, 
        			"officialEmailId": formDatas.email || null,
        			"phoneCountryCode":formDatas.phoneCountryCode || null,
        			"officialContactNumber": formDatas.contactNo || null,
        		    "officialWebsiteLink": formDatas.website || null,
        		    "linkedInLink": formDatas.linkedIn || null,
        		    "twitterLink": formDatas.twitter || null,
        		    "about": formDatas.about || null,
        		    "alumniPerson":{
        		    		"id":alumniId || null
        		    }
        	}
    	}
    	else{
    		json = {
    				"occupation":formDatas.occupation || null,
        			"organization":formDatas.organization || null,
        			"designation": formDatas.designation || null, 
        			"officialEmailId": formDatas.email || null,
        			"phoneCountryCode":formDatas.phoneCountryCode || null,
        			"officialContactNumber": formDatas.contactNo || null,
        		    "officialWebsiteLink": formDatas.website || null,
        		    "linkedInLink": formDatas.linkedIn || null,
        		    "twitterLink": formDatas.twitter || null,
        		    "about": formDatas.about || null,
        		    "alumniPerson":{
        		    		"id":alumniId || null
        		    }
        	}
    	}
    	
    	return json;
	},
	getProfessionalDetail:function(form){
      var $this = this;
      
      var profileDetail  = $this.getContentPanelActiveTab();
      var alumniPersonId = profileDetail.alumniPersonId;
      
      var form = profileDetail.down('alumniprofessionaldetailform');
      
//      form = $this.getAlumniprofessionaldetailform()                 
      //formVal = form.getForm().getValues(); 
//      var profileDetail = $this.getAlumniprofile();
	  var alumniPersonId = profileDetail.alumniPersonId;
	  var submitUrl = SERVERURL.PATH_ALUMNI_FIND_PROFESSIONAL_DETAILS_BY_PERSON_ID;   	 
      Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      var tabName;
      Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			params: {
              "alumniPersonId": alumniPersonId,
          },
			method : 'GET',
			success : function(resp, action) {
				Ext.getBody().unmask();
				var data
				if(!isNullOrEmpty(resp.responseText)){					
					data = Ext.decode(resp.responseText);
					
				var id = form.down('#alumniPersonItemId');
				id.setValue(data.id);
				
				var occupation = form.down('#occupationIteamId');
				occupation.setValue(data.occupation);
				
				var organization = form.down('#organizationItemId');
				organization.setValue(data.organization);
				
				var designation = form.down('#designationItemId');
				designation.setValue(data.designation);				
				
				var email = form.down('#emailItemId');
				email.setValue(data.officialEmailId);
				
				var phoneCountryCode = form.down('#phoneCountryCode');
				
		    	phoneCountryCode.setValue(data.phoneCountryCode);
				
				var contactNo = form.down('#contactNoItemId');
				contactNo.setValue(data.officialContactNumber);
				
				var website = form.down('#websiteItemId');
				website.setValue(data.officialWebsiteLink);
				
				var linkedIn = form.down('#linkedInItemId');
				linkedIn.setValue(data.linkedInLink);
				
				var twitter = form.down('#twitterItemId');
				twitter.setValue(data.twitterLink);
				
				var about = form.down('#aboutItemId');
				about.setValue(data.about);
				}
			}
		});	
	},
	getEducationHistory: function(from){
		var $this = this;
		
		var profileDetail  = $this.getContentPanelActiveTab();
        var alumniPersonId = profileDetail.alumniPersonId;
        
        var form = profileDetail.down('alumnieducationhistoryform');

        var submitUrl = SERVERURL.PATH_ALUMNI_FIND_EDUCATIONAL_DETAILS_BY_PERSON_ID;   	
		 var tabName;	
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			params: {
                "alumniPersonId": alumniPersonId,
            },
			method : 'GET',
			success : function(resp, action) {
				Ext.getBody().unmask(); 
				var data = Ext.decode(resp.responseText);
				
				var alNew = form.down('#academyLocationItemId');
				alNew.setValue(data.academyLocationName);
				alNew.setReadOnly(true)
				
				var program = form.down('#programItemId');
				program.setValue(data.programName);
				program.setReadOnly(true)
				
				var batch = form.down('#batchItemId');
				batch.setValue(data.batchName);
				batch.setReadOnly(true)
				
				var passoutYear = form.down('#passoutYearItemId');
				passoutYear.setValue(data.passOutYear);
				passoutYear.setReadOnly(true)
			}
		});	
	},
	saveAlumniRejectReason:function(btn){
		var me = this;
		var contentPanel = me.getContentPanel();
		var grid = me.getSignUpRequestGrid();
		var rejectForm = me.getAlumniRequestRejectWindow();
		var reqVal = rejectForm.down('#reasonToRejectItemId').getValue()
		var signForm = me.getSignUpRequestDetails().getValues();
		var reqHideVal = signForm.requestHiddenID
		var submitUrl = SERVERURL.PATH_REJECT_ALUMNI;   	
		 var tabName;	  
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			params: {
                "id": reqHideVal,
                "reason": reqVal
            },
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask(); 
				showSuccessMessage(getCommonTranslation('SUCCESS'), getAlumni('ALUMNI_REJECTED_REASON_SUCCESSFULLY'));
				var getcontroller=me.getController('menu.CoreERPNavigationController');
				rejectForm.hide()
			   grid.getSelectionModel().deselectAll();
			   grid.getStore().load();
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
			}
		});	
	},
	//Save Alumni Request function
	saveAlumniRequest: function(btn){
		var $this = this;
		var contentPanel = $this.getContentPanel();
		showConfirmMessage(getAlumni('ALUMNI_APPROVE_REQUEST'),getAlumni('ARE_YOU_SURE_TO_APPROVE_RECORD?'),function(btn,text){ 
			if (btn == 'yes') { 
		var detailForm = $this.getSignUpRequestDetails();
		var json;
		var submitUrl;
		var isView = '';
		var grid = $this.getSignUpRequestGrid();
		json = $this.createJsonForAddAlumni(detailForm);
		submitUrl = SERVERURL.PATH_APPROVE_ALUMNI;
		var successMsg;    	
		 var tabName;
		var formData = json;
		successMsg = getAlumni('ALUMNI_CREATED_SUCCESSFULLY');	  
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');		
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(response, action) {
				if(response.responseText == "Success"){ 
				Ext.getBody().unmask(); 
				showSuccessMessage(getAlumni('SUCCESS'), successMsg);
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
			   grid.getSelectionModel().deselectAll();
			   grid.getStore().load();
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
			}
			if(response.responseText == "Failed"){ 
				showWarningMessage(getAlumni('INVALID_RECORDS'),getAlumni('PLEASE_ENTER_PROGRAM_AND_BATCH'))
				Ext.getBody().unmask();
				grid.getStore().load();
			}
			}
		});	
			}
		})
	},
	//Add Alumni json
    createJsonForAddAlumni:function(form){
    	var $this = this
    	var detailForm = $this.getSignUpRequestDetails();
    	var formDatas = detailForm.getValues();    	
    
		json = {
			"requestID"	: formDatas.requestID,
			"firstName"	: formDatas.requestFirstName,
			"middleName": formDatas.requestMidName,
			"lastName": formDatas.requestLastName,
			"mobileNumber": formDatas.requestMobileNumber,
			"emailId": formDatas.requestEmailId,
			"dateOfBirth": formDatas.requestDOBId,
			"gender": formDatas.requestGender,
			"academyLocation": formDatas.requestAL,
//			"programName": formDatas.requestProgram,
			"otherProgramName": formDatas.requestOtherProgram,
//			"batchName": formDatas.requestBatch,
			"otherBatchName": formDatas.requestOtherBatch,
			"passout": formDatas.requestPassoutYear,
			"studentCode": formDatas.requestStudentId,
			"admissionCode": formDatas.requestAdmisssionId,
			"createdDate": formDatas.createdDate,
			"programId": formDatas.requestProgram?formDatas.requestProgram:null,
			"batchId": formDatas.requestBatch?formDatas.requestBatch:null,			
    	}
		if(json.programId!=null)
			{
			  json.otherProgramName ="";
			}
		if(json.batchId!=null)
		{
		  json.otherBatchName ="";
		}
    	return json;
    },
	viewSignUpRequestStructure: function(isView, btn){
		var $this = this;
		var contentpanel = this.getContentPanel();

		var isView = isView;
		var grid = btn.up('#signUpRequestGridItemId')

		var selectedRaw = grid.getSelectionModel()
		var signUpReCode = grid.getSelectionModel().getSelection()[0].data.signupCode
		var signUpReqVal = selectedRaw.selected.items[0].data
		var submitUrl = SERVERURL.PATH_FIND_ALL_ALUMNI_RECORD
		var signUpRequestDetails = Ext.widget('signUpRequestDetails'); 
      	var tabName = getAlumni('SIGN_UP_REQUEST_DETAILS');
      	var getcontroller=this.getController('menu.CoreERPNavigationController');
      	var getSignUpReqDetailTab=getcontroller.getTab(getAlumni('SIGN_UP_REQUEST_DETAILS'));
      	if(getSignUpReqDetailTab!=null){
      		contentpanel.remove(getSignUpReqDetailTab, true);
      	}
      	openTab(contentpanel, tabName, signUpRequestDetails, CONSTANTS.MENU_COLOR_FIVE); 
      	var detailForm = $this.getSignUpRequestDetails().getForm()

        Ext.Ajax.request({
            type : 'rest',
            url : submitUrl+"?requestId="+signUpReCode,
            method : 'GET',
            success : function(resp, action) {
            Ext.getBody().unmask();
            var data = Ext.decode(resp.responseText);
            
      	var requestHiddenID = detailForm.findField('requestHiddenID');
      	requestHiddenID.setValue(data.requestId)
      	requestHiddenID.setReadOnly(true)
      	
      	var requestId = detailForm.findField('requestID');
      	requestId.setValue(data.signupCode)
      	requestId.setReadOnly(true)
      	
      	var requestFirstName = detailForm.findField('requestFirstName');
      	requestFirstName.setValue(data.firstName)
      	requestFirstName.setReadOnly(true)
      	
      	var requestMidName = detailForm.findField('requestMidName');
      	requestMidName.setValue(data.middleName)
      	requestMidName.setReadOnly(true)
      	
      	var requestLastName = detailForm.findField('requestLastName');
      	requestLastName.setValue(data.lastName)
      	requestLastName.setReadOnly(true)
      	
      	var requestMobileNumber = detailForm.findField('requestMobileNumber');
      	requestMobileNumber.setValue(data.mobileNumber)
      	requestMobileNumber.setReadOnly(true)

      	var requestEmailId = detailForm.findField('requestEmailId');
      	requestEmailId.setValue(data.emailId)
      	requestEmailId.setReadOnly(true)
      	
      	var requestDOBId = detailForm.findField('requestDOBId');
      	requestDOBId.setValue(data.alumniDateOfBirth)
      	requestDOBId.setReadOnly(true)
      	
      	var requestGender = detailForm.findField('requestGender');
      	requestGender.setValue(data.gender ? data.gender.charAt(0).toUpperCase() + data.gender.slice(1).toLowerCase() : null)
      	requestGender.setReadOnly(true)
      	
      	var requestAL = detailForm.findField('requestAL');
      	requestAL.setValue(data.academyLocationName)
      	requestAL.setReadOnly(true)
      	
      	var requestProgram = detailForm.findField('requestProgram');
      	requestProgram.getStore().getProxy().extraParams = {
      		academyLocationIds: data.academyLocation
	    };
      	var requestBatch = detailForm.findField('requestBatch');
      	var programId;
      	requestProgram.getStore().load({
	        callback: function (records, operation, success) {
	            if (success) {
	                if (records.length > 0) {
	                	for(count = 0 ;count<records.length;count++){
							if(records[count].get('value') == data.programName){
								programId = records[count].get('id')
								requestProgram.setValue(records[count].get('id'));
							}							
						}	                	
	                  	requestBatch.getStore().getProxy().extraParams = {
	                  		programIds: programId,
	            	    };
	                  	requestBatch.getStore().load({
	            	        callback: function (rec, op, scs) {
	            	            if (scs) {
	            	                if (rec.length > 0) {
	            	                	for(i = 0 ;i<rec.length;i++){
	            							if(rec[i].get('code') == data.batchName){
	            								requestBatch.setValue(rec[i].get('id'))
	            							}
	            							
	            						}
	            	                }
	            	            }
	            	        }
	            	    });
	                }
	            }
	        }
	    });  
      	
      	var requestOtherProgram = detailForm.findField('requestOtherProgram');
      	requestOtherProgram.setValue(data.otherProgramName)
      	requestOtherProgram.setReadOnly(true)     	
      	
      	var requestOtherBatch = detailForm.findField('requestOtherBatch');
      	requestOtherBatch.setValue(data.otherBatchName)
      	requestOtherBatch.setReadOnly(true)
      	
      	var requestPassoutYear = detailForm.findField('requestPassoutYear');
      	requestPassoutYear.setValue(data.passOutYear)
      	requestPassoutYear.setReadOnly(true)
      	
      	var requestStudentId = detailForm.findField('requestStudentId');
      	requestStudentId.setValue(data.studentCode)
      	requestStudentId.setReadOnly(true)
      	
      	var requestAdmisssionId = detailForm.findField('requestAdmisssionId');
      	requestAdmisssionId.setValue(data.admissionCode)
      	requestAdmisssionId.setReadOnly(true)
           	
      	if(isView == 'VIEW'){
      		signUpRequestDetails.down('#btnApprove').setVisible(false)
      		signUpRequestDetails.down('#btnReject').setVisible(false) 
      		requestProgram.setReadOnly(true)
      		requestBatch.setReadOnly(true)
      	}
            }}
        )
	},
	
	alumniAutoApprove: function(btn){
		var this$ = this;
		var grid = this.getSignUpRequestGrid();
		showConfirmMessage(getAlumni('ALUMNI_APPROVE_REQUEST'),getAlumni('ARE_YOU_SURE_TO_APPROVE_RECORD?'),function(btn,text){ 
			if (btn == 'yes') { 
     	var selectionModel = grid.getSelectionModel().getSelection();
		var idsArr = [];
		var reasonArr = [];
		selectionModel.forEach(function(obj){
			idsArr.push(obj.get('signupCode'));
			if(obj.raw.reason){
				reasonArr.push(obj.raw.reason)	
			}
		});
		var signupCode =  idsArr.join();
		var reasonReject =  reasonArr.join();
		if(grid.getSelectionModel().getCount()>0){
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_AUTO_APPROVE_ALUMNI_REQUESTS,
				params: {
					signUpIds: signupCode,
				},
				method: 'POST',
				success: function(response,form, action) {
					if(response.responseText == "InProgress"){ 
						Ext.getBody().unmask();
						showSuccessMessage(getAlumni('INPROGRESS'),getAlumni('ALUMNI_APPROVED_SUCCESSFULLY'));
						grid.getSelectionModel().getCount();									
						grid.getStore().load();
						grid.getSelectionModel().deselectAll();
					}
					if(response.responseText == "Failed"){ 
							showWarningMessage(getAlumni('INVAILD_RECORDS'),getAlumni('SOME_RECORDS_ARE_INVAILD'))
							Ext.getBody().unmask();
							grid.getStore().load();
					}
				},
				failure:function(){
					Ext.getBody().unmask();					
				}
			});
		}else{
			showWarningMessage(getAlumni('PLEASE_SELECT_RECORD'),getAlumni('PLEASE_SELECT_RECORD'));//Please select a record
		}
			}
		})		
	},
	
	openResetPasswordWindow:function(){
 	    var resetPswrdWindowItemId ="alumniresetpasswordItemid";
        var resetPswrdFormWindow = Ext.widget('alumniresetpassword', {
             itemId: resetPswrdWindowItemId
         });
        resetPswrdFormWindow.show();
 	    
    },
    
    changePasswordFun:function(button){
    	var $this = this;
    	var grid = this.getAlumniListGrid();
    	var gridRec=grid.getSelectionModel().getSelection();
    	var window=button.up('window');
    	var form=button.up('form').getForm();
		var formValues=form.getValues();
		var userIds = [];
		var userIdsWithComma = null;
		Ext.each(gridRec, function(currentRecord){
			userIds.push(currentRecord.get('alumniUserId'));
			userIdsWithComma = userIds.join(',');
		});
		var data={
			  "userIds":userIdsWithComma,
			  "newPassword":$this.encryptPassword(formValues.confirmedPassword),
//			  "isResetPassword":true,
			};
		
		showConfirmMessage(getAlumni('ALERT'),getAlumni('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
				function(btn, text) {
			if (btn == 'yes'){
				var pswrdurl = SERVERURL.PATH_ALUMNI_RESET_PASSWORD;
				$this.applyWindowMask(); 

				Ext.Ajax.request({
					method: "POST",
					type: 'rest',
					url:pswrdurl,
					jsonData:data,
					success: function(response) {
						$this.hideWindowMask();
						var mssg = response.responseText;
						if (mssg == "true") {
							window.close();
							showSuccessMessage(getAlumni('RESET_PASSWORD'),getAlumni('ADMIN_PASSWORD_CHANGE_MSG'));
						}else if(mssg == "USER_LOCKED"){
							showWarningMessage(getAlumni('ALERT'),getAlumni('USER_LOCKED_MSG'));
						}else if(mssg.includes("PASSWORD_IN_USE")){
							showWarningMessage(getAlumni('ALERT'),getAlumni('PASSWORD_IN_USE'));
						}else{
							showWarningMessage(getAlumni('ALERT'),getAlumni('USER_NOT_FOUND_MSG'));
						}
					}
				});
			}
		});
					
    },
    /**
     * Get Alumni Profile Information
     * */
    getAlumniProfileInformation: function() {
    	var this$ = this;
    	var alumniProfile = this$.getContentPanelActiveTab();
    	var alumniProfileView = alumniProfile.down('#alumniProfileView');
    	if(!isNullOrEmpty(alumniProfileView)){
    		alumniProfileView.refresh();
    	}
    	var userId = alumniProfile.getUserId();
    	var admissionId = alumniProfile.getAdmissionId();
    	if (!isNullOrEmpty(userId)) {
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		var studentProfileUrl = SERVERURL.PATH_FIND_STUDENT_DETAILS_BY_STUDENT_ID_AND_ADMISSION_ID ;
    		Ext.Ajax.request({
    			type: 'rest',
    			params :{
    			id : userId,
    			admissionId : admissionId
    			},
    			url: studentProfileUrl,
    			method: 'GET',
    			success: function(res, action) {
    				var data = Ext.decode(res.responseText);
    				if(!isEmpty(data)){
    					this$.studentData = data;
    					//var tpl = studentProfileView.tpl;
    					var studentStatus = data.status ;
    					var isTemporaryInactive = data.temporaryInActive;
    					if(isTemporaryInactive){
    						isTemporaryInactive = getAlumni('TEMPORARY_INACTIVE');
    					}else{
    						if(studentStatus === true){
    							studentStatus = getAlumni('ACTIVE');
    						}else{
    							studentStatus = getAlumni('INACTIVE');
    						}
    					}
    					data.person.status = studentStatus;
    					data.person.personId = data.code;
    					data.person.isInvalidDocument = data.isInvalidDocument;
    					data.person.isTemporaryInactive = isTemporaryInactive;
    					studentProfile.setPersonInfo(data.person);
    					if(this$.getCurrentLoggedPortalId() != 3 && this$.getCurrentLoggedPortalId() != 7){
    						var store = studentProfileView.getStore();
    						if(!isNullOrEmpty(store)){
    							var templateDataArray=new Array();
        						templateDataArray.push(data.person);
        						store.loadData(templateDataArray);
    						}
    						//tpl.overwrite(studentProfileView.el.dom, data.person);
    					}
    				}
    			},
                failure: function(res, action) {
                	Ext.getBody().unmask();
                }
            });
    		var portalId = this$.getCurrentLoggedPortalId();
            this$.setUploadedPhotoToAlumniProfile(SERVERURL.PERSON_IMAGE_DOWNLOAD,"STUDENT");

        }
    },
    /**
     * Set photo to Alumni profile image 
     * @param  form
     * @param personId
     * @param personId
     */
    setUploadedPhotoToAlumniProfile : function(downloadUrl,userType){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var personId = personProfile.alumniRec.id;
    	
    	var portalId = this$.getCurrentLoggedPortalId();
    	var finalDownloadUrl = downloadUrl+'?alumniPersonId='+personId+'&portalId='+portalId;
    	if( !isNullOrEmpty(userType) ){
    		finalDownloadUrl = downloadUrl+'?alumniPersonId='+personId+'&userType='+userType+'&portalId='+portalId;
    	}
    	if(!personProfile.alumniRec.imageURL) {
    		Ext.defer(function () {
    			var a=personProfile.down("#profile_image");
				 var newImgUrl = generateInitialsImage(
						    personProfile.alumniRec.firstName, 
						    personProfile.alumniRec.middleName, 
						    personProfile.alumniRec.lastName
						);

				a.setVisible(true);
			    if (a.rendered && a.getEl()) { 
			        a.getEl().dom.src = newImgUrl;
			    }
			}, 3000);
    	}else if(!isNullOrEmpty(personId)){
    		Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: finalDownloadUrl,
                method: 'GET',
                success : function(response){
                	if(response.responseBytes.length>0){
    					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					 var url = window.URL.createObjectURL(blob);
    					 var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
    					 if(personController.isProfilePicSaved && (portalId==2 || portalId==3 || portalId==7)) {
    						 var fimg = this$.getUserinfo().down('#userInfoButton');
    						 fimg.setIcon(url);
    						 fimg.setVisible(true);
    					 } else {
    						 var a=personProfile.down("#profile_image");
    						 if(!isNullOrEmpty(a)){
    						 if(Ext.isChrome==false){
        						 a.setVisible(true);
    							 setTimeout(function(){
        							 a.el.dom.src = url;
    							 },1000);
    						 }
    						 else{
                                 a.getEl().dom.src=url;
                                 a.setVisible(true);
                             }
    						 } 
    					 }         	    		
    					 /**
    					  * @Author Surendra Jha
    					  * Show user image for applicant portal user
    					  */
    					 if(portalId==6) {
    						 if(!isNullOrEmpty(this$.getUserInfo()))
    						 {
    							 var fimg = this$.getUserInfo().down('#userInfoButton');
    							 fimg.setIcon(url);
    							 fimg.setVisible(true);
    						 }
    					 }
    					 
    				}else{
                      
                			Ext.defer(function () {
                				var a=personProfile.down("#profile_image");
                				 var newImgUrl = generateInitialsImage(
                						 personProfile.alumniRec.firstName, 
                						 personProfile.alumniRec.middleName, 
                						 personProfile.alumniRec.lastName
                						);

                				a.setVisible(true);
                				if (a.rendered && a.getEl()) { 
                					a.getEl().dom.src = newImgUrl;
                				}
                			}, 3000);
    				}
               }

            });
    	}
    },
    /**
     * Active Alumni Profile tab for student 
     * @author Amit G
     */
    getActiveAlumniProfile : function(){
    	var this$ = this;
    	/*if (!isNullOrEmpty(dashboardList) && dashboardList.length > 0) {
			var alumniProfile = this$.getContentPanelActiveTab();
	    	var personInfoPanel = alumniProfile.down('personinfopanel');
	    	var tabName = getCommonTranslation('MY_DASHBOARD');
	    	var contentXtype ='alumnipersonalinformationform';

	    	var	newTab = personInfoPanel.add({
	    		xtype: contentXtype,
	    		closable: false,
	    		title: tabName
	    	});
	    	personInfoPanel.setActiveTab(newTab);
	    	Ext.getBody().unmask();
		} else {*/
			var tabPanelTitle = 'PERSONAL_DETAILS';
	        var tabPanelItemId = 'alumniPersonalDetails';
	        var tabPanelItemXtype = 'alumnipersonalinformationform';
	        var xtypeItemId = 'alumniPersonalInformationForm';
	        var defaultPanel = true;
	        var renderPanel= true;
	    	
	        if (!isNullOrEmpty(renderPanel) && renderPanel) {
	        	this$.addPersonTabPanel('ALUMNI', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
	        }
		//}
    },
    cellClickAlumniResultGrid: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    	var this$ = this;
    	var alumniPersonId = record.data.alumniPersonId;
    	var academyLocationId = this$.getCurrentAcademyLocation();
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        studentDetails=record;
        var grid = this.getAlumniListGrid();
        if (columnName == "alumniCode") {
            var tabTitle = record.get('alumniCode');
            var alumniPersonId = record.get('alumniPersonId');
            var userId = record.get('ID');
            var admissionId = record.get('ADMISSION_ID');
            var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
            var submitUrl =SERVERURL.BATCH_ID_BY_STUDENT_ID;
            if(!isNullOrEmpty(tabTitle)){
            	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        		Ext.Ajax.request({
        		type: 'rest',
        		url: SERVERURL.PATH_ALUMNI_DETAILS,
        		method : 'GET',
        		params:{
        			alumniPersonId:alumniPersonId ,
        		},
        		success: function(f, action) {
        			if(f.responseText){
        				var data = Ext.decode(f.responseText);
        						this$.addContentPanelTab(tabTitle, 'alumniprofile', userId, alumniPersonId, null, admissionId, programBatchSeatTypeConfigId,null,null,null,alumniPersonId);
        				this$.setPersonalDetailsData(data);
        				this$.setUploadedPhotoToAlumniProfile(SERVERURL.ALUMNI_PERSON_IMAGE_DOWNLOAD,"ALUMNI",data);
        				Ext.getBody().unmask();
        			}
        			
        		}
        	});
            }
        }
    },
    setPersonalDetailsData:function(data){
    	var me = this,
    	activePanel =me.getContentPanelActiveTab(),
    	personalForm = activePanel.down('alumnipersonalinformationform'),
    	alumniprofile=activePanel,
    	alumniId= personalForm.down('#alumniCode')
    	studentId =personalForm.down('#studentId'),
    	admissionId=personalForm.down('#admissionId')
    	salutation =personalForm.down('#salutation'),
    	gender =personalForm.down('#gender'),
    	birthDate =personalForm.down('#birthDate'),
    	phoneCountryCode =personalForm.down('#phoneCountryCode'),
    	mobileNumber = personalForm.down('#mobileNumber')
    	whetherActive=personalForm.down('#statusAlumniId'),
    	profileView=alumniprofile.down('#alumniProfileView');
    	salutation.getStore().load();
    	gender.getStore().load();
    	phoneCountryCode.getStore().load()
    	personalForm.getForm().setValues(data);
    	mobileNumber.setValue(data.mobileNumber)
    	profileView.getStore().add(data);
    	alumniId.setValue(data.alumniUser.alumniCode)
    	salutation.setValue(data.salutation.id)
    	whetherActive.setValue(data.whetherActive)
    	if(data.studentCode){
    		studentId.setValue(data.studentCode);
    	}
    	if(data.admissionCode){
    		admissionId.setValue(data.admissionCode);
    	}
//    	if(data.imageURL) {
//    		var imagePathArray = data.imageURL.split('/');
//            var imageName = imagePathArray[imagePathArray.length-1]
//    	}
//    	data.imageURL && alumniPhotoUploadForm.down('#photoFileImage').setRawValue(imageName);
    	birthDate.setValue(dateRender(data.birthDate));
    	alumniprofile.alumniRec=data;
    },
    saveAlumniPersonalInfo:function(btn){
    	var me  = this,
    	activePanel =me.getContentPanelActiveTab(),
    	form =btn.up('form'),
    	alumniprofile=activePanel,
    	profileView=alumniprofile.down('#alumniProfileView'),
    	dataRec=profileView.getStore().data.items[0],
    	fileField = form.down('#alumniPhotoUploadForm'),
    	fieldsVal = form.getValues();
    	dataRec.set('admissionCode',fieldsVal.admissionId);
    	dataRec.set('studentCode',fieldsVal.studentId);
    	dataRec.set('firstName',fieldsVal.firstName);
    	dataRec.set('lastName',fieldsVal.lastName);
    	dataRec.set('middleName',fieldsVal.middleName);
    	dataRec.set('mobileNumber',fieldsVal.mobileNumber);
    	dataRec.set('phoneCountryCode',fieldsVal.phoneCountryCode);
    	dataRec.set('printName',fieldsVal.printName);
    	dataRec.set('emailId',fieldsVal.emailId);
    	dataRec.set('birthDate',fieldsVal.birthDate);
    	dataRec.set('whetherActive',fieldsVal.statusALumni);
    	var val=dataRec.data;
    	val.salutation={
    			id:fieldsVal.salutation.id
    	};
    	val.gender=fieldsVal.gender.id;
    	val.alumniUser={
    			id:val.alumniUser.id
    	}
    	me.uploadAluminiProfileImage(val,fileField); 
    },
    uploadAluminiProfileImage:function(val,fileField){
    	this.savePersonalInfOfAlumni(val);
    },
    //Saving Alumni PersonInfo form data
    savePersonalInfOfAlumni:function(val){
    	var me =this;
    	var grid = this.getAlumniListGrid();
    	var activePanel =me.getContentPanelActiveTab();
    	var alumniPersonId = grid.getSelectionModel().getSelection()[0].data.alumniPersonId;
    	var formData = Ext.encode(val);
    	Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_ALUMNI_PROFILE_UPDATE,
			method : 'POST',
			jsonData : formData,
			success: function(f, action) {
				showSuccessMessage(getAdmissionTranslation('PERSONAL_DETAILS'), getCommonTranslation('SUCCESS'));
				
					// reCalling find api to refresh header Form			
					Ext.Ajax.request({
		        		type: 'rest',
		        		url: SERVERURL.PATH_ALUMNI_DETAILS,
		        		method : 'GET',
		        		params:{
		        			alumniPersonId:activePanel.alumniPersonId ,
		        		},
		        		success: function(f, action) {
		        			if(f.responseText){
		        				var data = Ext.decode(f.responseText);
		        				me.setPersonalDetailsData(data);
		        				me.setUploadedPhotoToAlumniProfile(SERVERURL.ALUMNI_PERSON_IMAGE_DOWNLOAD,"ALUMNI",data);
		        				Ext.getBody().unmask();
		        			}
		        			
		        		}
		        	});
				
				Ext.getBody().unmask();
			}
		});
    },
    getAlumniPersonData:function(){
    	var me =this,
    	activePanel =me.getContentPanelActiveTab();
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		Ext.Ajax.request({
		type: 'rest',
		url: SERVERURL.PATH_ALUMNI_DETAILS,
		method : 'GET',
		params:{
			alumniPersonId:activePanel.alumniRec.id
		},
		success: function(f, action) {	
			if(f.responseText){
				var data = Ext.decode(f.responseText);
				me.setPersonalDetailsData(data);
				me.setUploadedPhotoToAlumniProfile(SERVERURL.ALUMNI_PERSON_IMAGE_DOWNLOAD,"ALUMNI");
				Ext.getBody().unmask();
			}
			
		}
	});
    },
	checkFileExtentionandSize:function(fileField){
		var me = this;
    	value = fileField.getValue().replace('C:\\fakepath\\', '');
    	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    	fileField.setRawValue(newValue);
    	if (!isNullOrEmpty(newValue)) {
    	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    	    if (me.isValidProfileImageExtension(extension)) {
    	        var file = fileField.fileInputEl.dom.files[0];
    	        if (file.size / 1048576 > 5) {
//    	        	if (file.size / 5242880 > 2) {
    	            fileField.reset();
    	             showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_FIVE_MB')); //FILE_SIZE_ERROR_MSG //FILE_SIZE_ERROR_MSG_fOR_ADD_CAMPAIGN_DOCUMENT
    	        }
    	    } else {
    	    	fileField.reset();
    	        showWarningMessage(getPersonModuleTranslation('ALERT'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
    	    }
    	}
	},
	addAlumniPersonalAddress:function(btn){
		var me = this;
		var isCheckedCommunicationAddress = false;
		var form = Ext.widget('addAlumniAddressWin');		
		activePanel =me.getContentPanelActiveTab();
		addressPanel= me.getContentPanelActiveTab()
		personAddressDisplayField1 = addressPanel.down('#personAddressDisplayField1'),
		personAddressDisplayField2 = addressPanel.down('#personAddressDisplayField2'),
		personAddressDisplayField3 = addressPanel.down('#personAddressDisplayField3'),
		activePanel =me.getContentPanelActiveTab();
		this.isCommunicationAddress = false;
		var addressForm = me.getAlumniAddressForm();
		var comAddField =addressForm.down('#communicationAddressItemId')
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		if(form){
			form.show();
			form.addressType=btn.addresType
//			Start: To hide CommunicationAddress checkbox
			var addressForm = me.getAlumniAddressForm();
			var comAddField =addressForm.down('#communicationAddressItemId')
			Ext.Ajax.request({
				type: 'rest',
				url: SERVERURL.PATH_ALUMNI_FIND_ADDRESS,
				method : 'GET',
				params:{
					alumniPersonId:activePanel.alumniRec.id
				},
				success: function(f, action) {
					Ext.getBody().unmask();
					if(f.responseText){
						var data = Ext.decode(f.responseText);
						if(data.length > 0){
						   var AddressTpl = Ext.create('Ext.XTemplate', '<p><B>{addressLine1}</B></p>', '<tpl if=\'city.cityName != null\'>', '{city.cityName}, </tpl>', '<tpl if=\'city.cityName != null\'>', '{city.countryRegion.value},<br></tpl>',
								   '<tpl if=\'city.cityName != null\'>','{city.country.value}<br></tpl>','<tpl if=\'!isNullOrEmpty(postalCode)\'>','{postalCode}<br></tpl>');

						   var isCheckedCommunicationAddress = false;
						   var communicationAddressCount = Ext.Array.filter(data, function(currentData) {
							    if (!isNullOrEmpty(currentData.isCommunicationAddress) && currentData.isCommunicationAddress) {
							        if (form.addressType == currentData['addressType']) {
							            isCheckedCommunicationAddress = true;
							        }
							        return true;
							    }
							    return false;
							}).length;
//						   var communicationAddressCount = Ext.Array.filter(data, function(currentData) {
//							    return !isNullOrEmpty(currentData.isCommunicationAddress) && currentData.isCommunicationAddress;
//							}).length;
							if(isCheckedCommunicationAddress){
							   comAddField.setVisible(true);
							} else {
								if(communicationAddressCount>0) {									
									comAddField.setVisible(false);
								}else {
									comAddField.setVisible(true);
								}
							}
//							End: To hide CommunicationAddress checkbox
						   Ext.each(data, function(obj) {							   
				            	     if (obj['addressType'] == 'PERSONAL') {
				                        currentAddress = true;
				                        personAddressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
				                        personAddressDisplayField1.setModel(obj);
				                        addressPanel.down('#modifyPersonalAddress1').setText(getCommonTranslation('MODIFY'))
				                        //personAddressDisplayField1.up().setTitle(crntHeaderTitle);
									
				                        
				                    } else if (obj['addressType'] == 'PROFESSIONAL') {
				                        correspondanceAddress = true;
				                        personAddressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
				                        personAddressDisplayField2.setModel(obj);
				                        addressPanel.down('#modifyPersonalAddress2').setText(getCommonTranslation('MODIFY'))
						
				                        //personAddressDisplayField2.up().setTitle(crspndcHeaderTitle);

				                    } else if (obj['addressType'] == 'OTHER') {
				                        permanentAddress = true;
				                        personAddressDisplayField3.setValue(AddressTpl.applyTemplate(obj));
				                        personAddressDisplayField3.setModel(obj);
				                        addressPanel.down('#modifyPersonalAddress3').setText(getCommonTranslation('MODIFY'))
									
				                    }
				            });
						   
						}
					}
				}
			});
			if(btn.text==getAlumni('MODIFY')){
				var alumniaddressdisplaypanel =btn.up('alumniaddressdisplaypanel');
				me.setAdressFormValue(alumniaddressdisplaypanel,btn.addresType,form);
			}
		}
	},
	saveAlumniAddress:function(btn){
		var me =this,
		formWin = btn.up('window'),
		form = btn.up('form'),
		fromVal = form.getValues(),
    	activePanel =me.getContentPanelActiveTab();
    	var param= {
    			isCommunicationAddress:fromVal.isPrimary?fromVal.isPrimary:false,
    			isLegalAddress:fromVal.isLegalAddress?fromVal.isLegalAddress:null,
    			addressLine1:fromVal.addressLine1?fromVal.addressLine1:null,
    			addressLine2:fromVal.addressLine2?fromVal.addressLine2:null,
    			addressType:formWin.addressType?formWin.addressType:null,
    			/*country:fromVal.country,
    			countryRegion:fromVal.parentCountryRegion,*/
    			latitude:fromVal.latitude||null,
    			longitude:fromVal.longitude|| null,
    			postalCode:fromVal.pincode?fromVal.pincode:null,
    			alumniPerson:{
    				id:activePanel.alumniRec.id?activePanel.alumniRec.id:null,
    			},
    			isPrimary:true,
    	    
    	}
    	if(fromVal.city){
    		param.city={
    				id:fromVal.city
    			}
    	}else{
    		param.city=null
    	}
    	var urlPath =SERVERURL.PATH_ALUMNI_ADDRESS_CREATE;
    	if(formWin.recordId){
    		urlPath =SERVERURL.PATH_ALUMNI_ADDRESS_UPDATE;
    		param.id=formWin.recordId;
    	}
    	
    	var formData = Ext.encode(param);
    	me.applyWindowMask();
    	Ext.Ajax.request({
    		type: 'rest',
    		url: urlPath,
    		method : 'POST',
			jsonData : formData,
    		success: function(f, action) {
    			me.hideWindowMask();
    			formWin.close()
    			showSuccessMessage(getAdmissionTranslation('ADDRESS'), getCommonTranslation('SUCCESS'));
    			me.getAlumniPersonAddress();
    		}
    	});
		
	},
	getAlumniPersonAddress:function(){
		var me=this,
		//addressPanel= me.getAlumniaddressdisplaypanel(),
		addressPanel= me.getContentPanelActiveTab()
		personAddressDisplayField1 = addressPanel.down('#personAddressDisplayField1'),
		personAddressDisplayField2 = addressPanel.down('#personAddressDisplayField2'),
		personAddressDisplayField3 = addressPanel.down('#personAddressDisplayField3'),
		activePanel =me.getContentPanelActiveTab();
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	Ext.Ajax.request({
		type: 'rest',
		url: SERVERURL.PATH_ALUMNI_FIND_ADDRESS,
		method : 'GET',
		params:{
			alumniPersonId:activePanel.alumniRec.id
		},
		success: function(f, action) {
			Ext.getBody().unmask();
			if(f.responseText){
				var data = Ext.decode(f.responseText);
				if(data){
				   var AddressTpl = Ext.create('Ext.XTemplate', '<p><B>{addressLine1}</B></p>', '<tpl if=\'city.cityName != null\'>', '{city.cityName}, </tpl>', '<tpl if=\'city.cityName != null\'>', '{city.countryRegion.value},<br></tpl>',
						   '<tpl if=\'city.cityName != null\'>','{city.country.value}<br></tpl>','<tpl if=\'!isNullOrEmpty(postalCode)\'>','{postalCode}<br></tpl>');
				   Ext.each(data, function(obj) {
							/*if(obj.isCommunicationAddress) {
									this.isCommunicationAddress = true;
							 }*/
		            	     if (obj['addressType'] == 'PERSONAL') {
		                        currentAddress = true;
		                        personAddressDisplayField1.setValue(AddressTpl.applyTemplate(obj));
		                        personAddressDisplayField1.setModel(obj);
		                        addressPanel.down('#modifyPersonalAddress1').setText(getCommonTranslation('MODIFY'))
		                        //personAddressDisplayField1.up().setTitle(crntHeaderTitle);
		                        
		                    } else if (obj['addressType'] == 'PROFESSIONAL') {
		                        correspondanceAddress = true;
		                        personAddressDisplayField2.setValue(AddressTpl.applyTemplate(obj));
		                        personAddressDisplayField2.setModel(obj);
		                        addressPanel.down('#modifyPersonalAddress2').setText(getCommonTranslation('MODIFY'))
		                        //personAddressDisplayField2.up().setTitle(crspndcHeaderTitle);

		                    } else if (obj['addressType'] == 'OTHER') {
		                        permanentAddress = true;
		                        personAddressDisplayField3.setValue(AddressTpl.applyTemplate(obj));
		                        personAddressDisplayField3.setModel(obj);
		                        addressPanel.down('#modifyPersonalAddress3').setText(getCommonTranslation('MODIFY'))
		                      //  personAddressDisplayField3.up().setTitle(prmntHeaderTitle);

		                    }
		            	
		            });
				}
			}
			
		}
	});
	},
	setAdressFormValue: function(form2, addresstype, addresswin) {
	    var $this = this;
	    var addressDetail = $this.getContentPanelActiveTab();
	    var form = addressDetail.down('tabpanel').getActiveTab();

	    // Get the correct form field based on `addresstype`
	    if (addresstype === 'PERSONAL') {
	        var personAddressDisplayField1 = form.down('#personAddressDisplayField1');
	        var formval = personAddressDisplayField1.getModel();
	    } else if (addresstype === 'PROFESSIONAL') {
	        var personAddressDisplayField2 = form.down('#personAddressDisplayField2');
	        var formval = personAddressDisplayField2.getModel();
	    } else if (addresstype === 'OTHER') {
	        var personAddressDisplayField3 = form.down('#personAddressDisplayField3');
	        var formval = personAddressDisplayField3.getModel();
	    }

//	    // Guard against missing formval or properties
//	    if (!formval) {
//	        console.warn('Form value is undefined for the given address type.');
//	        return;
//	    }

	    // Map form fields
	    var communicationAddressItemId = addresswin.down('#communicationAddressItemId'),
	        legalAddressItemId = addresswin.down('#legalAddressItemId'),
	        addressLine1 = addresswin.down('#addressLine1'),
	        addressLine2 = addresswin.down('#addressLine2'),
	        cityId = addresswin.down('#cityId'),
	        parentCountryRegion = addresswin.down('#parentCountryRegion'),
	        country = addresswin.down('#country'),
	        pincodeId = addresswin.down('#pincodeId'),
	        latitudeItemId = addresswin.down('#latitudeItemId'),
	        longitude = addresswin.down('#longitude');

	    // Set simple field values
	    communicationAddressItemId.setValue(formval.isCommunicationAddress);
	    legalAddressItemId.setValue(formval.isLegalAddress);
	    addressLine1.setValue(formval.addressLine1);
	    addressLine2.setValue(formval.addressLine2);
	    pincodeId.setValue(formval.postalCode);
	    latitudeItemId.setValue(formval.latitude);
	    longitude.setValue(formval.longitude);

	    // Load city store and set value
	   if (formval.city.country.id && country) {
	        country.getStore().load({
	            callback: function(records, success) {
	                if (success) {
	                    country.setValue(formval.city.country.id);
	                    
	                    // Load parent country region store once country store is loaded successfully
	                    if (formval.city.countryRegion.id && parentCountryRegion) {
	                        parentCountryRegion.getStore().getProxy().extraParams = {
	                            cid: formval.city.country.id,
	                         };
	                        parentCountryRegion.getStore().load({
	                            callback: function(records, success) {
	                                if (success) {
	                                    parentCountryRegion.setValue(formval.city.countryRegion.id);
	                                    parentCountryRegion.setDisabled(false);
	                                    if (formval.city.id) {
	                                        cityId.getStore().getProxy().extraParams = {
	                                            id: formval.city.countryRegion.id,
	                                         };
	                                        cityId.getStore().load({
	                                            callback: function(records, success) {
	                                                if (success) {
	                                                    cityId.setValue(formval.city.id);
	                                                    cityId.setDisabled(false);
	                                                }
	                                            }
	                                        })
	                                    }
	                                }
	                            }
	                        });
	                    }
	                }
	            }
	        });
	    }




	    // Set the record ID for the address window
	    addresswin.recordId = formval.id;
	},
	openAlumniPhotoUploadPopup: function() {
    	var profileUploadWindow = this.getStudentuploadphotowindow();
    	
        if (!profileUploadWindow) {
        	profileUploadWindow = Ext.widget('studentuploadphotowindow', {
        		itemId: 'alumniToUploadPhotowindowItemId'
        	}); 
        }
        
        if (!profileUploadWindow.hasAfterRenderHandler) {
        	profileUploadWindow.on('afterrender', function () {
                var alumniProfile = this.getContentPanelActiveTab();
                var alumniPersonId = Number(alumniProfile.alumniRec.id);
                var portalId = Number(this.getCurrentLoggedPortalId());
                var userType = "ALUMNI";
                if (!isNullOrEmpty(alumniPersonId)) {
                    Ext.Ajax.request({
                        url: SERVERURL.ALUMNI_PERSON_IMAGE_DOWNLOAD+'?alumniPersonId='+alumniPersonId+'&userType='+userType+'&portalId='+portalId,
                        method: 'GET',
                        binary: true,
                        success: function (response) {
                        	var profileImage = profileUploadWindow.down("#profile_image");
                            if (response.responseBytes.length > 0) {
                                var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
                                var url = window.URL.createObjectURL(blob);
                                
                                profileImage.setVisible(true);
                                if(alumniProfile.alumniRec.imageURL){
                                	profileImage.getEl().dom.src = url;
                                    profileUploadWindow.lastSavedImageUrl = url;
                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(false);
                                }else{
                                	var newImgUrl = generateInitialsImage(
                   						 alumniProfile.alumniRec.firstName, 
                   						 alumniProfile.alumniRec.middleName, 
                   						 alumniProfile.alumniRec.lastName
                   						);
                                	profileImage.getEl().dom.src = newImgUrl;
                                    profileUploadWindow.lastSavedImageUrl = newImgUrl;
                                	profileUploadWindow.down('#btnRemoveItemId').setDisabled(true);
                                }
                            } else {
                            	var newImgUrl = generateInitialsImage(
                  						 alumniProfile.alumniRec.firstName, 
                  						 alumniProfile.alumniRec.middleName, 
                  						 alumniProfile.alumniRec.lastName
                  						);
                            	profileImage.setVisible(true);
                               	profileImage.getEl().dom.src = newImgUrl;
                                profileUploadWindow.lastSavedImageUrl = newImgUrl;
                               	profileUploadWindow.down('#btnRemoveItemId').setDisabled(true);
                            }
                        },
                    });
                }
            }, this);
            
            // Mark handler as attached to avoid duplicate bindings
        	profileUploadWindow.hasAfterRenderHandler = true;
        }
        
        profileUploadWindow.show();
     },
	
     openAlumniCapturePhoto:function(){
   		var window = this.getStudentuploadphotowindow(),
   		profileImage = window.down('#profile_image'),
   		capturePanelId = window.down('#capturePanelId'),
   		btnUploadPhoto = window.down('#btnUploadPhotoItemId'),
   		btnTakePhoto = window.down('#btnTakePhotoItemId'),
   		capturePhoto = window.down('#capturePhotoItemId'),
   		resetPhoto = window.down('#resetPhotoItemId'),
   		btnBack = window.down('#btnBackItemId'),
   		btnSave = window.down('#btnSaveItemId');
   		window.down('#profile_image_containerBox').hide();
   		window.down('#profileRoatateImageIconId').hide();   		
   		window.previousProfileImage = profileImage.el.dom.src;   		
   		btnUploadPhoto.reset();
   		btnUploadPhoto.setVisible(false);
   		btnTakePhoto.setVisible(false);
   		profileImage.setSrc('');
   		profileImage.setVisible(false);
   		capturePanelId.setVisible(true);
   		capturePhoto.setVisible(true);
   		resetPhoto.setVisible(true);
   		resetPhoto.setDisabled(true);
   		btnBack.setVisible(true);
   		btnSave.setVisible(true);
   		
   	},
   	
   	captureAlumniUserPhoto: function(btn){
		var $this = btn.up('window');
		var form = btn.up('window').down('form');
		var imageUrl;
		Webcam.snap( function(data_uri) {
			imageUrl = data_uri;
		});
        Ext.defer(function() {
        	var imgLoad = new Image();
    		imgLoad.onload = (function(){
    			var crop = new Academia.utilities.ImageCrop({
    				id:'testing',
    				width: 310,
    				height: 272,
    				src:imageUrl
    			});
    			crop.on('changeCrop', function(component,region) {
    				$this.cropData = region;
    				$this.component = component;
    			});
    			var PREVIEW_TEST = form.down('#previewPanelId');
    			PREVIEW_TEST.add(crop);
    			$this.down('#capturePanelId').setVisible(false);
    			$this.down('#previewPanelId').setVisible(true);
    			btn.setDisabled(true);
    			$this.down('#resetPhotoItemId').setDisabled(false);
    			$this.down('#btnSaveItemId').setDisabled(false);
    			
    			var canvas = document.getElementById('canvas');
				var ctx = canvas.getContext("2d");
				var region = $this.cropData; 
				var component = $this.component;
				var sw = region.width - region.x;
				var sh = region.height - region.y;

				var imgWidth = component.width;
				var imgHeight = component.height;

				var img = new Image();
				img.src = component.src;

				ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
    			$this.captureImageaUrl = canvas.toDataURL("image/png");
    		}).bind($this);
    		imgLoad.src = imageUrl;
    		$this.imagesUrl = imageUrl;
  	  }, 500, $this);
   	},
   	
   	uploadAlumniProfilePhoto: function(cmp, value) {
    	var window = this.getStudentuploadphotowindow();
        var form = window.down('form');
        var image = form.down('#profile_image');
        var imageContainerBoxId = form.down('#profile_image_containerBox').id;
	    var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        var btnSave = window.down('button[name=btnSave]');
        var file = cmp.el.down('input[type=file]').dom.files[0];
        var isImageRemoved = window.down('#isImageRemovedItemId');

        // File extension validation
        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
        if (!isNullOrEmpty(value)) {
            if (extension === "png" || extension === "jpeg" || extension === "jpg") {
                // File size validation
            	if (file) {
            		if (file.size < 100 * 1024 || file.size > 2 * 1024 * 1024){      // file size should be less than 100 kb & greater than 2MB                       
              			 cmp.reset();
                           showWarningMessage(
                               getPersonModuleTranslation('PHOTO_UPLOAD'),
                               getCommonTranslation('FILE_SIZE_BETWEEN_RANGE')
                           );
                           return;
                       }else {
                           isImageRemoved.setValue(false);
                       }
            	}
            } else {
                cmp.reset();
                showWarningMessage(
                    getPersonModuleTranslation('PHOTO_UPLOAD'),
                    getPersonModuleTranslation('UPLOAD_VALID_FILE')
                );
                return;
            }
        } else {
            showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('NO_FILE_SELECTED'));
            return;
        }

        // Process the valid file
        if (file) {
            form.down('#fileName').setValue(file.name);
            var personProfile = this.getContentPanelActiveTab();
            var alumniPersonId = Number(personProfile.alumniRec.id);
            form.down('#personId').setValue(alumniPersonId);

            var reader = new FileReader();
            reader.onload = function(e) {
            	var crop;
	        	var imageSrc;
	        	var canvasDiv ;
                image.setSrc(e.target.result);
                Ext.defer(function(){
	            	imageSrc = imageInnerContainerBox.children[0].src;
			        image.setVisible(false);
			        window.down('#profileRoatateImageIconId').show();
	            	 crop = cropper(imageInnerContainerBox, {
    				    area: [ 210, 210 ],
    				    crop: [ 115, 115],
    				    value: imageSrc,
    				    allowResize: true,
    		            allowZoom: true,
    		            allowRotation: true,         		            
    				})
    				var jcropArea = imageInnerContainerBox.querySelector('.jcrop-area');
	            	 if (jcropArea) {
	            		    var innerJcropDiv1 = document.createElement('div');
	            		    innerJcropDiv1.className = 'border-left';

	            		    var innerJcropDiv2 = document.createElement('div');
	            		    innerJcropDiv2.className = 'border-right';

	            		    jcropArea.appendChild(innerJcropDiv1);
	            		    jcropArea.appendChild(innerJcropDiv2);
	            		}
    				canvasDiv = jcropArea.nextSibling;

    				if(!isNullOrEmpty(canvasDiv)){
    					var mouseEventOccurred = false;
    				if (canvasDiv) {
    				    // Listen for mouse events and set the flag to true when one occurs
    					canvasDiv.addEventListener('mousemove', function () {
    						mouseEventOccurred = true;
				            if (mouseEventOccurred) {    				                
				                var croppedImage = crop.getCroppedImage().src;
    				            image.setSrc(croppedImage);
    				            image.setVisible(true);
				            }    				            
				        })
				        if(mouseEventOccurred == false) {
    				    image.setSrc(imageSrc);
    				    image.setVisible(true);
    				}
    				} 
    			} 
				else {
				    image.setSrc(imageSrc);
				    image.setVisible(true);
				}
	            },500)
                btnSave.setDisabled(false);
            };
            reader.readAsDataURL(file);
        }
    },
    
    uploadAlumniCapturedImage: function() {
    	var me = this;
    	var personProfile = me.getContentPanelActiveTab();
    	var alumniPersonId = Number(personProfile.alumniRec.id);
        var formPanel = me.getStudentuploadphotowindow();
        var form = formPanel.down('form');        
        var imageContainerBoxId = form.down('#profile_image_containerBox').id;
        var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        var finalImageBase64;
	   	 var imageBlob;
	   	 if(!isNullOrEmpty(imageInnerContainerBox.crop)){        		 
	   		 finalImageBase64 = imageInnerContainerBox.crop.getCroppedImage().src;
	   		 imageBlob = base64ToBlob(finalImageBase64, 'image/png'); // Adjust type if needed
	   	 }
	        
        if(form.down('#profile_image_containerBox').isVisible()) {
       	 var imageContainerBoxId = form.down('#profile_image_containerBox').id;
       	 var imageInnerContainerBox = Ext.query('#'+imageContainerBoxId+"-targetEl")[0];
        }
        
        var formValues = form.getValues();
//        var formValues = formPanel.getValues();
        
        // Check if there's an image to upload
        var imageField = formPanel.down('#profileImageFormItemId');
        var imageVal = formPanel.down('#btnUploadPhotoItemId');
        var profile_image = formPanel.down('#profile_image');
        var isImageRemoved = formPanel.down('#isImageRemovedItemId');
        /*if(profile_image.src == "resources/images/default-profile.png"){
        	me.saveuploadAlumniCapturedImage('');
        	return;
        }*/
        if(isImageRemoved.value == "true"){
        	me.saveuploadAlumniCapturedImage('');
        	return;
        }
        
        me.applyWindowMask();
        if (profile_image.isVisible()) {
            // If there's an image, upload it first
        	var formData = new FormData();
       	 for (var key in formValues) {
       	     if (formValues.hasOwnProperty(key)) {
       	         formData.append(key, formValues[key]);
       	     }
       	 }
       	 formData.append('file', imageBlob, 'profile.png');
       	 
       	 var userInfo = Academia.model.authentication.UserInfoModel;
       	 var access_token = userInfo.get("accessToken");
       	 
       	 var url = SERVERURL.PATH_ALUMNI_PERSON_FILE_UPLOAD+'?access_token='+access_token;
       	 
       	 var xhr = new XMLHttpRequest();
       	 xhr.open('POST', url);
       	 xhr.onload = function () {
       	     if (xhr.status >= 200 && xhr.status < 300) {
       	         var response = JSON.parse(xhr.responseText);
       	         var path = response.path;
       	         var updatedPath = path.replace(/^\/+/, "");
       	         me.saveuploadAlumniCapturedImage(path);
       	     }
       	 };
       	 xhr.send(formData);
        	/*form.getForm().submit({
                method: 'POST',
                url: SERVERURL.PATH_ALUMNI_PERSON_FILE_UPLOAD,
                success: function(form, action) {
                    var responseData = Ext.decode(action.response.responseText);
                    var path = responseData.path;
                    var updatedPath = path.replace(/^\/+/, "");
                    me.saveuploadAlumniCapturedImage(path); 
                },
                failure: function(response){
                	me.hideWindowMask();
                }
            });*/
        }else{
        	var userInfo = Academia.model.authentication.UserInfoModel;
			var access_token = userInfo.get("accessToken");
        	var canvas = document.getElementById('canvas');
			var ctx = canvas.getContext("2d");
			var region = formPanel.cropData; 
			var component = formPanel.component;
			var sw = region.width - region.x;
			var sh = region.height - region.y;
			var imgWidth = component.width;
			var imgHeight = component.height;
			var img = new Image();
			img.src = component.src;
			ctx.drawImage(img, region.x, region.y , region.width,region.height,0,0,component.width,component.height);
			var dataUrl = canvas.toDataURL("image/png");
			
			var url = 'rest/signup/uploadeB64ImageAlumni?access_token='+access_token;
			var form = new FormData();
			form.append('file', dataUrl);
			form.append('fileName', '1.png');
			form.append('alumniPersonId', alumniPersonId);
			var xhr = new XMLHttpRequest();
			xhr.open('POST', url, true);

			xhr.onreadystatechange = function () {
				if (xhr.readyState == 4 && xhr.status == 200) {
					if (xhr.responseText != "") {
						var data = Ext.decode(xhr.responseText);
						var personinfo = personProfile.alumniRec;
						personinfo.imageURL = data.path;
						showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
						var updatedPath = data.path.replace(/^\/+/, "");
						//me.saveuploadCapturedImage(updatedPath);
						me.getUploadCaptureToAlumniProfile();
					}
				}
				formPanel.close();	
				//me.hideWindowMask();
			};
			xhr.send(form);
        } 
    },
    
    saveuploadAlumniCapturedImage: function(imageUrl){
    	var me = this;
    	var win = me.getStudentuploadphotowindow();
    	var personProfile = me.getContentPanelActiveTab();
    	var personId = Number(personProfile.alumniRec.id);
    	personProfile.alumniRec.imageURL=imageUrl;
    	var payload = {
    			personId: personId,
    			path: imageUrl
    	};
    	
    	var submitUrl = SERVERURL.PATH_UPLOAD_ALUMNI_PROFILE_PHOTOS;
    	
    	var data = Ext.encode(payload);
    	
    	Ext.Ajax.request({
    		url: submitUrl,
    		method: 'POST',
    		jsonData:data,
            success: function(response){
            	var responseData = response.responseText;
            	if (responseData=='fail') {
            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('File Not Found'));
            	}else{
            		if(imageUrl==''){
            			 var profileImage=personProfile.down("#profile_image");
	       				 var newImgUrl = generateInitialsImage(
	       						 personProfile.alumniRec.firstName, 
	       						 personProfile.alumniRec.middleName, 
	       						 personProfile.alumniRec.lastName
	       						);
	
	       				 profileImage.setVisible(true);
	       				
	       				profileImage.getEl().dom.src = newImgUrl;
       				
                        showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PERSON_PROFILE_PHOTO_REMOVE_SUCCESS'));
            		}
            		else {
            			me.getUploadCaptureToAlumniProfile();
                		showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('PHOTO_UPLOAD'));
            		}
            	}
            	win.close();
            	me.hideWindowMask();
            },
            failure: function(response){
            	me.hideWindowMask();
            }
    	})
    },
    
    getUploadCaptureToAlumniProfile : function(){
        var this$ = this;
        var alumniProfile = this$.getContentPanelActiveTab();
        var alumniPersonId = Number(alumniProfile.alumniRec.id);
        var portalId = Number(this$.getCurrentLoggedPortalId());
        var userType = "ALUMNI";
        if(!isNullOrEmpty(alumniPersonId)){
            Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: SERVERURL.ALUMNI_PERSON_IMAGE_DOWNLOAD+'?alumniPersonId='+alumniPersonId+'&userType='+userType+'&portalId='+portalId,
                method: 'GET',
                success : function(response){
                    if(response.responseBytes.length>0){
                        var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
                        var url = window.URL.createObjectURL(blob);
                        var a=alumniProfile.down("#profile_image");
                        a.getEl().dom.src=url;
                        a.setVisible(true);
                    }
                }
            });
        }
    },
    showCommunicationHistoryData: function() {
    	var me = this;
    	var form = me.getAlumnicommunicationhistoryfilter();
    	var grid = me.getAlumnicommunicationhistorygrid(); 
    	var formVal = form.getForm().getValues();    

    	grid.getStore().getProxy().extraParams = {
    		alumniCodeName: formVal.alumniIdName,                   
    		emailId: formVal.alumniEmail,                     
    		notificationType: formVal.notificationType,             
    		startDate: formVal.startDate,  
    		endDate: formVal.endDate, 
    	};
    	grid.down('pagingtoolbar').moveFirst();
    	grid.config.searchFilterForm = me.getAlumnicommunicationhistoryfilter();
    },
	openAlumniMessageReportLink: function(record){
	    		var id = record.get('id');
	    		if(!isNullOrEmpty(id)){
	    			Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.PATH_NOTIFICATION_DETAILS,													 
	    				method: 'GET',
	    				async: false,
	    				headers: {
	    					'Content-Type': 'application/json'
	    				},
	    				params: {
	    					id: id
	    				},
	    				success: function(response, form, action) {
	    					responseObject = eval("(" + response.responseText + ")"); //make object of response text
	    					var msgContent = responseObject.description;

	    					var win = new Ext.Window({
	    						title: getMessagingModuleTranslation('MESSAGE_CONTENT'),
	    						frame: true,
	    						height : 500,
	    						minWidth:200,
	    						autoScroll:true,
	    						modal:true,
	    						html: msgContent,
	    					});
	    					win.show();

	    				},
	    				failure: function(form, action) {
	    					//showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
	    				}
	    			});
	    		}
	    	},

});