/**
 * @author Amit.g
 * 
 */
Ext.define('Academia.controller.attendance.attendancecheck.AttendanceCheckController', {
	//extend : 'Ext.app.Controller',
	extend: 'Academia.controller.base.BaseController',
	stores : ['attendance.attendancecheck.AttendanceCheckGrid'],
	views : ['attendance.attendancecheck.AttendanceCheckStructure',
	         'attendance.attendancecheck.AttendanceCheckView','attendance.attendancecheck.AttendanceCheckGrid',
	         'attendance.attendancecheck.AttendanceView'
	         ],	           
	         refs : [{
	        	 ref : 'attendancecheckstructure',
	        	 selector : 'attendancecheckstructure'
	         },{
	        	 ref : 'attendancecheckview',
	        	 selector : 'attendancecheckview'
	         },{
	        	 ref : 'attendancecheckgrid',
	        	 selector : 'attendancecheckgrid'
	         }],
	         init : function() {
	        	 this.control({
	        		 'attendancecheckstructure button[itemId=searchBtn]' : {
	        			 click : this.loadAttendanceData
	        		 },
	        		 'attendanceview textfield[itemId=scanIdNo]' : {
	        			 change : function(obj){
	        				 if(!isNullOrEmpty(obj.getValue()))
	        					 this.loadAttendanceData();
	        			 }
	        		 }
	        	 });
	         },
	         loadAttendanceData:function(){
	        	 var $this = this;
	        	 var store = $this.getAttendancecheckgrid().getStore();
	        	 var form = $this.getAttendancecheckview().getForm();

	        	 var idField = $this.getAttendancecheckstructure().getForm().findField('idNo');
	        	 var scanIdNo = $this.getAttendancecheckstructure().getForm().findField('scanIdNo');
	        	 
	        	 var clientUserId;
	        	 
	        	 if(idField.getValue()){
	        		 clientUserId = idField.getValue(); 
	        	 }else{
	        		 clientUserId = scanIdNo.getValue(); 
	        	 }
	        	 
	        	 var greenCircle = $this.getAttendancecheckstructure().down('#greeId');
	        	 var redCircle = $this.getAttendancecheckstructure().down('#redId');
	        	 var yellowCircle = $this.getAttendancecheckstructure().down('#yellowId');

	        	 var panel = $this.getAttendancecheckstructure().down('#panelId');

	        	 /**
	        	  * Set form parameter which are coming through studentId  
	        	  */
	        	 Ext.Ajax.request({
	        		 type : 'rest',
	        		 url : SERVERURL.ATTENDANCE_MACHINE,
	        		 params : {
	        			 clientUserId:clientUserId,
	        			 machineId:1
	        		 },
	        		 method : 'GET',
	        		 success : function(form1, action) {
	        			 var resData = Ext.JSON.decode(form1.responseText);
	        			 form.findField('idNo').setValue(resData.idNumber);
	        			 form.findField('rollNo').setValue(resData.studentId);
	        			 var date = new Date();
	        			 form.findField('dateTime').setValue(dateRender(date)+" "+timeRender(date));
	        			 form.findField('name').setValue(resData.name);
	        			 form.findField('branch').setValue(resData.academyLocation);
	        			 form.findField('course').setValue(resData.program);
	        			 form.findField('batch').setValue(resData.batch);
	        			 $this.getAttendancecheckstructure().getForm().findField('date').setValue(dateRender(date));
	        			 var personId = resData.personId;

	        			 var type = resData.type;
	        			 
	        			 panel.setVisible(false);
	        			 greenCircle.setVisible(false);
	        			 redCircle.setVisible(false);
	        			 yellowCircle.setVisible(false);
	        			 
	        			 if(type!=null){
	        				 panel.setVisible(true);
	        				 if(type=='GREEN'){
	        					 form.findField('type').setValue('Doubt Clearing Session');
	        					 greenCircle.setVisible(true);
	        				 }else if(type=='RED'){
	        					 form.findField('type').setValue('Fee Due');
	        					 redCircle.setVisible(true);
	        				 }else if(type=='YELLOW'){
	        					 form.findField('type').setValue('Inactive');
	        					 yellowCircle.setVisible(true);
	        				 }
	        			 }
	        			 
	        			 
	        			 /**
	        			  *  load grid store Data
	        			  */
	        			 store.getProxy().extraParams = {
	        				 clientUserId:clientUserId,
	        				 machineId:1
	        			 };
	        			 store.load();

	        			 /**
	        			  * Images uploaded by personId
	        			  */
	        			 Ext.Ajax.request({
	        				 type: 'rest',
	        				 binary: true,
	        				 url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId=' +personId,
	        				 method: 'GET',
	        				 success : function(response){
	        					 if(response.responseBytes.length>0){
	        						 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
	        						 var url = window.URL.createObjectURL(blob);
	        						 var image = $this.getAttendancecheckstructure().down("#profile_image");
	        						 image.getEl().dom.src=url;
	        					 }
	        				 }
	        			 });
	        			 idField.reset();
	        			 scanIdNo.reset();
	        		 }
	        	 });

	         }
});
