var logoutCount = 0;
var changePwdCount = 0;
Ext.define('Academia.controller.authentication.AuthenticationController', {
	extend: 'Academia.controller.base.BaseController',
	mixins: {
		StudentPortalController: 'Academia.controller.portal.StudentPortalController',
		FacultyPortalController: 'Academia.controller.portal.FacultyPortalController',
		ApplicantPortalController: 'Academia.controller.portal.ApplicantPortalController',
		ParentPortalController: 'Academia.controller.portal.ParentPortalController',
		StudentCourseController: 'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseMasterController'
	},
	requires: ['Academia.utilities.ux.Notification'],
	views: [
		'baselayout.header.NotificationSection',
		'baselayout.header.UserInfo',
		'login.ResetPasswordForm',
		'login.ChangePasswordWindow',
		'login.SelectPortalWindow',
		'login.ChangePortalWindow',
		'login.SocialMappingForm',
		'login.SocialMappingWindow',
		/***************START: Alerts and Notification**************************/
		'baselayout.header.ActivityFeeds',
		'baselayout.header.ActivityFeedTypeGrid',
		'baselayout.header.NotificationAlertWindow',
		'baselayout.header.NotificationAlertTemplate',
		'baselayout.header.ActivityFeedTypePanel',
		'baselayout.header.ActivityFeedDisplayTemplate',
		'baselayout.header.Logo',
		'baselayout.header.AcademyLocationChangeWindow',
		'baselayout.header.DownloadAttachment',
		'baselayout.footer.FooterSection',
		'dashboard.dashlets.NotificationsCountDashlet',
		'dashboard.dashlets.AlertCountDashlet',
		'baselayout.header.ActivityFeedTypeGridForApplicant',
		'login.ParentPortalRegistrationFormWin',
		'personinfo.common.personalinfo.FeePayerDetailGrid',
		/***************END: Alerts and Notification**************************/
		'login.ChangeLanguageWindow',
		'common.NotificationActivityGridExtendedDateFilter',
		'login.ParentPortalRegistrationWarningFormWin',
		'baselayout.contentarea.ContentPanel',
		'baselayout.header.PortalDetails',
		'baselayout.header.NotificationSearchForm',
		'baselayout.header.NotificationDetailsWindow',
		'baselayout.header.NotificationAlertForRecentVisitedUsers',
		'baselayout.header.NotificationAlertForRecentVisitedActivity',
		'baselayout.header.NotificationAlertForRecentVisitedStudents',
		'baselayout.header.NotificationAlertToRecentActivityWindow',
		'dashboard.GoogleTranslationWindow',
		'login.TermsAndConditionsFormWin',
		'dashboard.GeneralSurveyHomePageScreen'
	],
	models: [
		'authentication.UserInfoModel',
		'authentication.FormFieldInfoModel',
		'authentication.FormPersonalInfoFieldInfoModel',
		'authentication.PortalInfoModel',
		'authentication.SocialIdModel',
		'authentication.ALInfoModel',
		'authentication.StudentERPInfoModel',
		'customfields.CustomFieldDataModel',
		'Academia.model.authentication.AttendanceSettingModel'
	],
	config: {
		USER_MANAGEMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_MANAGEMENT'),
	},

	refs: [{
		ref: 'notificationSection',
		selector: 'notificationsection'
	}, {
		ref: 'verticalNavigationMenu',
		selector: 'verticalNavigationMenu'
	}, {
		ref: 'resetPasswordForm',
		selector: 'resetpasswordform'
	}, {
		ref: 'changePasswordWindow',
		selector: 'changepasswordwindow'
	}, {
		ref: 'logoSection',
		selector: 'logosection'
	}, {
		ref: 'userInfo',
		selector: 'userinfo'
	}, {
		ref: 'downloadAttachment',
		selector: 'downloadattachment[itemId=downloadAttachment]'
	}, {
		ref: 'footersection',
		selector: 'footersection'
	}, {
		ref: 'socialMappingWindow',
		selector: 'socialmappingwindow'
	}, {
		ref: 'notificationscountdashlet',
		selector: 'notificationscountdashlet'
	}, {
		ref: 'alertcountdashlet',
		selector: 'alertcountdashlet'
	}, {
		ref: 'selectportalwindow',
		selector: 'selectportalwindow'
	}, {
		ref: 'parentportalregistrationformwin',
		selector: 'parentportalregistrationformwin'
	}, {
		ref: 'parentportalregistrationwarningformwin',
		selector: 'parentportalregistrationwarningformwin'
	}, {
		ref: 'contentpanel',
		selector: 'contentpanel'
	}, {
		ref: 'portaldetails',
		selector: 'portaldetails'
	}, {
		ref: 'notificationSearchForm',
		selector: 'notificationSearchForm'
	}, {
		ref: 'notificationalertforrecentvisitedusers',
		selector: 'notificationalertforrecentvisitedusers'
	}, {
		ref: 'notificationalertforrecentvisitedactivity',
		selector: 'notificationalertforrecentvisitedactivity'
	}, {
		ref: "notificationalertforrecentvisitedstudents",
		selector: "notificationalertforrecentvisitedstudents"
	}, {
		ref: 'notificationalerttorecentactivitywindow',
		selector: 'notificationalerttorecentactivitywindow'
	}, {
		ref: 'googletranslationwindow',
		selector: 'googletranslationwindow'
	}, {
		ref: 'termsandconditionsformwin',
		selector: 'termsandconditionsformwin'
	}, {
		ref: 'generalsurveyhomepagescreen',
		selector: 'generalsurveyhomepagescreen'
	}, {
		ref: 'notificationDetailsWindow',
		selector: 'notificationDetailsWindow'
	}],
	stores: [
		'authentication.PortalStore',
		'scholarships.LogedInUserAcademyLocationStore',
		'datasetting.IdTableMappingStore',
		'authentication.ActivityFeedType',
		'authentication.ActivityFeedList',
		'authentication.NotificationAlertList',
		'common.SocialMappingStore',
		'common.ChangeLanguageStore',
		'authentication.NotificationAlertForApplicantPortalList',
		'authentication.AllNotificationForApplicantStore',
		'userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedUsersStore',
		'userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedActivityStore',
		'userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedStudentsStore'
	],
	init: function(application) {
		this.activityFeedTypeRecordIndex;
		this.applicationResponce;
		this.summeryResponce;
		this.flag = true;
		this.control({
			//@ Rajkumar.patidar
			//@ when login from portal , header color will change of form and window also.
			'window': {
				beforeshow: function(obj) {
					var userInfo = Academia.model.authentication.UserInfoModel;
					if (userInfo.get("portalId") == 3 || userInfo.get("portalId") == 2) {
						obj.cls = 'winHeaderClass';
					}
				}
			},
			'vp2': {
				afterrender: function(vp) {
					this.loadContollers('contentpanel');
					this.getController('menu.CoreERPNavigationController');
					this.setPortalDetails(vp);
				},
				beforerender: function(obj) {
					var userInfo = Academia.model.authentication.UserInfoModel;
					if (userInfo.get("portalId") == 3 || userInfo.get("portalId") == 2) {
						obj.items.items[0].ui = 'acad-headerportal';
						obj.items.items[1].ui = 'acad-footerportal';
					}
					var me = this;
					this.loadBuildInfoXML(me);
				}
			},
			'changepasswordwindow ': {
				beforerender: function(formWindow) {
					var form = formWindow.down('#changePasswordForm');
					this.getPasswordPolicy(form);
				}
			},
			'academylocationchangewindow button#btnSaveALChangeWindow': {
				click: function(button, e, eOpt) {
					//@ravi.patidar changes for tranlation issue
					var this$ = this;
					var win = button.up('window');
					if (win) {

						var combo = win.down('customcombobox');
						var selectedAlId = combo.getValue();
						var userId = this.getCurrentlyLoggedInUser().id;
						var submitUrl = SERVERURL.IS_NOT_VALID_IP_ADDRESS + '?userId=' + userId + '&academyLocationId=' + selectedAlId;
						Ext.Ajax.request({
							type: 'rest',
							url: submitUrl,
							method: 'GET',
							success: function(response, action) {
								var responseData = Ext.decode(response.responseText);
								if (!responseData) {
									try {
										Ext.ComponentQuery.query('#searchComboBox')[0].getStore().clearFilter();
										Ext.ComponentQuery.query('#searchComboBox')[0].getStore().removeAll();
									}
									catch (e) {

									}
									var currentAlId = win.down('#academyLocationId').getValue();

									var alinfomodelold = Academia.model.authentication.ALInfoModel;
									var whetherSchoolOldAl = alinfomodelold.get('wheatherSchool');
									this$.loadMultipleLangFilePerAL(selectedAlId);
									var alinfomodelnew = Academia.model.authentication.ALInfoModel;
									localStorage.setItem('wheatherSchool', alinfomodelnew.get('wheatherSchool'));
									localStorage.setItem('academylocationid', selectedAlId);
									localStorage.setItem('tokenApiResponse', Ext.encode(Ext.Ajax.defaultHeaders));
            		        			/*if(whetherSchoolOldAl != alinfomodelnew.get('wheatherSchool')){
            		                		win.destroy();
            		                		localStorage.setItem('loadingMessage','Please wait while the system is initializing...');
            		                		window.location.reload();
            		        			} else*/ if (currentAlId != selectedAlId) {
										this$.loadMenuByAcademyLocation(selectedAlId);
										//Call to fetch the academyLocationLogo
										var displayName = this$.getAcademyLocationDisplayName(selectedAlId);
										this$.getAcademyLocationLogo(selectedAlId, displayName);
										//Call to bring the User Image and set it in the Header
										var userObj = this$.getCurrentlyLoggedInUserWithPersonId();
										this$.getUserImage(userObj.personId, userObj.value);
										win.destroy();
										//If in left bar there is no link then hide left bar 
										if (this$.getVerticalNavigationMenu().items.length > 0) {
											this$.getVerticalNavigationMenu().setVisible(true);
										} else {
											this$.getVerticalNavigationMenu().setVisible(false);
										}

										if (this$.getCurrentLoggedPortalId() == 2) {
											var facultyPortalController = this$.getController('Academia.controller.portal.FacultyPortalController');
											facultyPortalController.getloggedInFacultyDetails();
										}
										this$.loadDashbordScreen();

										this$.getMessageCount(this$);
										this$.setSMSCharacterLimit(this$, selectedAlId);
										this$.getDefaultCountryCode();
									} else {
										win.destroy();
									}
								} else {
									showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NOT_ABLE_TO_LOGIN_DUE_TO_RESTRICTED_IP_ADDRESS'));
								}
							}
						});
					}
					e.stopEvent();
					e.stopPropagation();
				}
			},

			'resetpasswordform button': {
				click: function(button) {
					var $this = this;
					if (Ext.isDefined(button.firstTimeFired) && button.firstTimeFired == true) {
						button.firstTimeFired = false;
					}
					else {
						button.firstTimeFired = true;
						if (button.itemId === 'submitBtn') {
							showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
								function(btn, text) {
									if (btn == 'yes') {
										$this.resetOrChangePassword('RESET');
									}
								});

						} else if (button.itemId === 'cancelBtn') {
							this.returnLoginPage();
						}
					}
				}
			},
			'resetpasswordform #newPassword': {
				blur: this.checkPasswordValidity
			},
			'resetpasswordform ': {
				beforerender: function(form) {
					this.getPasswordPolicy(form);
				}
			},
			'changeportalwindow button#cancelBtn': {
				click: function(button) {
					var changeportalwindow = button.up('changeportalwindow');
					if (Ext.isDefined(changeportalwindow)) {
						changeportalwindow.close();
					}
				}
			},
			'selectportalwindow customcombobox#portalComboId': {
				select: function(combo, records) {
					var selectportalwindow = combo.up('selectportalwindow');
					var portalId = combo.getValue();
					this.getFeaturePrivileges(this, portalId, false, selectportalwindow);
				}
			},

			'changeportalwindow button#submitBtn': {
				click: function(button) {
					try {
						Ext.ComponentQuery.query('#searchComboBox')[0].getStore().clearFilter();
						Ext.ComponentQuery.query('#searchComboBox')[0].getStore().removeAll();
					}
					catch (e) {

					}
					var changeportalwindow = button.up('form');
					var combo = changeportalwindow.down('customcombobox#portalComboId');
					var portalId = combo.getValue();
					this.getFeaturePrivileges(this, portalId, true, changeportalwindow);
					button.up('window').close();
				}
			},
			//generic listener of the user info dialogue box
			//@author Akshay.Kalbhor
			'userinfo button#userInfoButton menuitem': {
				click: function(item, e, eOpt) {
					if (item.itemId === 'changePasswordLink') {
						this.changePassword();
					} else if (item.itemId === 'logoutButton') {
						if (logoutCount == 0) {
							this.logOutUser();
							return;
						} else {
							logoutCount = 0;
						}
					} else if (item.itemId === 'changeAcademyLocOption') {
						this.showChangeALWindow(item);
					} else if (item.itemId === 'changePortal') {
						this.showChangePortalWindow(item);
					} else if (item.itemId === 'myDashboard') {
						this.loadDashbordScreen(item);
					} else if (item.itemId === 'socialMapping') {
						this.showChangeSocialMappingWindow(item);
					} else if (item.itemId === 'changeLanguage') {
						this.openLanguageWindow(item);
					} else if (item.itemId === 'changeStudentLink') {
						this.changeStudent();
					} else if (item.itemId === 'translateWithGoogle') {
						this.translateWithGoogle();
					}

					e.stopEvent();
					e.stopPropagation();
				}
			},
			'userinfo': {
				afterrender: function(userinfo) {
					var accessiblePortals = Academia.model.authentication.UserInfoModel.get("accessiblePortals");
					var visible = (accessiblePortals && accessiblePortals.length > 1);
					userinfo.down('#userInfoButton').down('#changePortal').setVisible(visible);
					var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
					if (academyLocationList.length == 1) {
						userinfo.down('#userInfoButton').down('#changeAcademyLocOption').setVisible(false);
					}

				}
			},
			//listener of the save password button/submit button of the change password screen.
			//@author Akshay.Kalbhor
			'changepasswordwindow button': {
				click: function(button) {
					if (!button.isDisabled()) {
						button.setDisabled(true);
						if (button.itemId === 'btnSavePassword') {
							if (changePwdCount == 0) {
								var $this = this;
								showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
									function(btn, text) {
										if (btn == 'yes') {
											var myMask = new Ext.LoadMask(Ext.getBody(), { msg: getCommonTranslation('PLEASE_WAIT_WHILE_SYSTEM_IS_INITIALIZING'), msgCls: 'msgClsCustomLoadMask' });
											$this.customMasking(myMask);
											changePwdCount = 1;
											$this.resetOrChangePassword('CHANGE');
											Ext.getBody().unmask();
											return;
										}
									});

							} else {
								changePwdCount = 0;
							}
						} else if (button.itemId === 'cancelSavePassword') {
							button.up('window').close();
						}
						if (button) {
							button.setDisabled(false);
						}

					}
				}
			},

			'changepasswordwindow #newPassword': {
				blur: this.checkPasswordValidity
			},
			/***************START: Alerts and Notification**************************/
			'notificationsection #searchCombobox': {
				render: function(component) {
					var me = this;
					var user = me.getCurrentlyLoggedInUser();
					var formFilter = me.getNotificationSection();
					formFilter.down('#userNameItemId').setText(user.value);
					Ext.create('Ext.tip.ToolTip', {
						target: component.getEl(),
						html: getCommonTranslation('SEARCH')
					});

					component.getEl().on('click', function(e) {
						var searchwindow = null;
						var isExist = false;
						Ext.getBody().on('click', function(e, t) {
							if (!isEmpty(searchwindow) && !isNullOrEmpty(searchwindow.getEl()) && isExist) {
								var el = searchwindow.getEl();
								if (!(el.dom === t || el.contains(t))) {
									searchwindow.close();
								}
							} else {
								isExist = true;
							}
						});

						var searchwindow = me.showWindow('notificationalertwindow');
						var notification = searchwindow.down('#notificationId');
						var alert = searchwindow.down('#alertId');
						var searchEngine = searchwindow.down('#searchId');
						notification.setVisible(false);
						alert.setVisible(false);
						searchEngine.setVisible(true);

					});
				}
			},
			'notificationsection #academiaAILogoId': {
				afterrender: function(component) {
				var portalId = this.getCurrentLoggedPortalId();
				var userNameLabel = component.up().down('#userNameItemId');
					if (portalId == 1) {
						var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
						var CORE_ERP_AI_CHATBOT_PRIVILEGES = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_AI_CHATBOT_PRIVILEGES');
						var permissionListToUserProfile = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, CORE_ERP_AI_CHATBOT_PRIVILEGES);
						var isAILinkVisible = false;
						Ext.each(permissionListToUserProfile, function(privilege) {
							if (privilege === 'AI_CHATBOT_ICON') {
								isAILinkVisible = true;
							}
						});

						if (isAILinkVisible) {
							component.show();
							userNameLabel.getEl().setStyle('margin-right', '10px');
						}
						else {
							component.hide();
							userNameLabel.getEl().setStyle('margin-right', '55px');
							return;
						}
					}
					else {
						component.hide();
						userNameLabel.getEl().setStyle('margin-right', '55px');
						return;
					}
					component.getEl().on('click', this.onClickAcademiaAILogo, this);
				}
			},
			'notificationsection #notificationRecentActivityAlertBox': {
				render: function(component) {
					var me = this;
					var user = me.getCurrentlyLoggedInUser();
					var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
					component.getEl().on('click', function(e) {
						var notificationalerttorecentactivitywindow = null;
						var isExist = false;
						Ext.getBody().on('click', function(e, t) {
							if (!isEmpty(notificationalerttorecentactivitywindow) && !isNullOrEmpty(notificationalerttorecentactivitywindow.getEl()) && isExist) {
								var el = notificationalerttorecentactivitywindow.getEl();
								if (!(el.dom === t || el.contains(t))) {
									notificationalerttorecentactivitywindow.close();
								}
							} else {
								isExist = true;
							}
						});
						if (!isExist) {
							if (Ext.getCmp("NotificationAlertToRecentActivityWindowItemId")) {
								Ext.getCmp("NotificationAlertToRecentActivityWindowItemId").close();
							}
							notificationalerttorecentactivitywindow = me.showWindow('notificationalerttorecentactivitywindow');
							if (notificationalerttorecentactivitywindow) {
								var visitedUser = notificationalerttorecentactivitywindow.down('#notificationAlertForRecentVisitedUsersItemId');
								var visitedStudent = notificationalerttorecentactivitywindow.down('#notificationalertforrecentvisitedstudentsItemId');
								var visitedUserActivity = notificationalerttorecentactivitywindow.down('#NotificationAlertForRecentVisitedActivityItemId');
								Ext.defer(function() {
									if (portalId == 1) {
										var userStore = Ext.getStore('userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedUsersStore');
										var studentStore = Ext.getStore('userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedStudentsStore');
										var activityStore = Ext.getStore('userProfileLastActivity.notificationAlertForRecentVisitedUsers.NotificationAlertForRecentVisitedActivityStore');
										var CORE_ERP_USER_PROFILE_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_PROFILE_PERMISSION');
										var permissionListToUserProfile = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, CORE_ERP_USER_PROFILE_PERMISSION);
										var isUserProfileLink = false;
										var CORE_ERP_STUDENT_PROFILE_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROFILE_PERMISSION');
										var permissionListToStudentProfile = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, CORE_ERP_STUDENT_PROFILE_PERMISSION);
										var isStudentProfileLink = false;

										Ext.each(permissionListToUserProfile, function(privilege) {
											if (privilege === 'VIEW') {
												isUserProfileLink = true;
											}
										});
										Ext.each(permissionListToStudentProfile, function(privilege) {
											if (privilege === 'VIEW') {
												isStudentProfileLink = true;
											}
										});
										if (userStore && visitedUser && visitedUser.down('dataview')) {
											var userDataView = visitedUser.down('dataview');
											userDataView.bindStore(userStore);
											userStore.load({
												callback: function() {
													if (!isUserProfileLink && userDataView) {
														var dataViewToUser = userDataView.getEl().dom.querySelector('#redirectToProfilePageId')
														if (!isNullOrEmpty(dataViewToUser)) {
															dataViewToUser.style.display = 'none'
														}
													}
												}
											});
										}

										if (studentStore && visitedStudent && visitedStudent.down('dataview')) {
											var studentDataView = visitedStudent.down('dataview');
											studentDataView.bindStore(studentStore);
											studentStore.load({
												callback: function() {
													if (!isStudentProfileLink && studentDataView) {
														var dataViewToStd = studentDataView.getEl().dom.querySelector('#redirectToStdProfilePageId')
														if (!isNullOrEmpty(dataViewToStd)) {
															dataViewToStd.style.display = 'none'
														}
													}
												}
											})
										}

										if (activityStore && visitedUserActivity && visitedUserActivity.down('dataview')) {
											var activityDataView = visitedUserActivity.down('dataview');
											activityDataView.bindStore(activityStore);
											activityStore.getProxy().extraParams = {
												portalId: portalId
											};
											activityStore.load({
												callback: function(records) {
													Ext.each(records, function(record) {
														var index = activityStore.indexOf(record);
														var activityBox = activityDataView.getNode(index);

														if (activityBox) {
															var pinIcon = Ext.fly(activityBox).down('.pin-toggle-icon');

															if (pinIcon) {
																var isPinned = record.get('itemPinStatus') === true || record.get('itemPinStatus') === "true";
																var iconSrc = isPinned ? "resources/images/pined.svg" : "resources/images/unpin.svg";

																pinIcon.set({ src: iconSrc });

															}
														}
													});
												}

											});
										}
									}
								}, 200);
							}
						}
					});
				},
				afterrender: function(component) {
					var me = this;
					var user = me.getCurrentlyLoggedInUser();
					var isNotificationHistoryIcon = false;
					var portalId = this.getCurrentLoggedPortalId();
					var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
					var permissionList = '';
					if (portalId == 1) {
						var CORE_ERP_NOTIFICATION_HISTORY_ICON_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_NOTIFICATION_HISTORY_ICON_PRIVILEGES');
						permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, CORE_ERP_NOTIFICATION_HISTORY_ICON_PERMISSION);
					}
					Ext.each(permissionList, function(privilege) {
						if (privilege === 'VIEW') {
							isNotificationHistoryIcon = true;
						}
					});
					if (!isNotificationHistoryIcon) {
						setTimeout(function() {
							var notificationEl = component.el.dom;
							notificationEl.style.visibility = "hidden";
							component.setWidth(0);
						}, 500);
					}
				},
			},
			'notificationalerttorecentactivitywindow': {
				afterrender: function(view) {
					var userCmp = view.down('#notificationAlertForRecentVisitedUsersItemId');
					var dataview = userCmp.down('dataview');
					var userStore = dataview.getStore();
					var userStoreLength = userStore.getCount();
					var studentCmp = view.down('#notificationalertforrecentvisitedstudentsItemId');
					var dataviewStudent = studentCmp.down('dataview');
					var studentStore = dataviewStudent.getStore();
					var studentStoreLength = studentStore.getCount();
					var activityCmp = view.down('#NotificationAlertForRecentVisitedActivityItemId');
					var activityCmp = activityCmp.down('dataview');
					var activityStore = activityCmp.getStore();
					var activityStoreLength = activityStore.getCount();

					view.el.on('click', function(event, target) {
						var clickedElement = Ext.get(target);

						if (clickedElement.hasCls('unpin-icon') || clickedElement.hasCls('pined-icon')) {
							var activityBox = clickedElement.up('.activity-box');
							var index = parseInt(activityBox.getAttribute('data-index'));

							// Toggle the pinned status
							var isPinned = clickedElement.hasCls('pined-icon');

							// Update the class to reflect the new state
							if (isPinned) {
								clickedElement.removeCls('pined-icon');
								clickedElement.addCls('unpin-icon');
								clickedElement.set({ src: 'resources/images/unpin.svg' }); // Change icon to unpin
							} else {
								clickedElement.removeCls('unpin-icon');
								clickedElement.addCls('pined-icon');
								clickedElement.set({ src: 'resources/images/pined.svg' }); // Change icon to pinned
							}

						}
					});

				},
				show: function(win) {
					var header = this.getNotificationSection();
					header.down('#anotherNotificationIcon').el.dom.style.zIndex = '1';
				},
				hide: function(win) {
					var header = this.getNotificationSection();
					header.down('#anotherNotificationIcon').el.dom.style.zIndex = '-1';
				}
			},
			'notificationsection #notificationDiv': {
				render: function(component) {
					var me = this;
					var user = me.getCurrentlyLoggedInUser();
					var formFilter = me.getNotificationSection();
					formFilter.down('#userNameItemId').setText(user.value);
					Ext.create('Ext.tip.ToolTip', {
						target: component.getEl(),
						html: getCommonTranslation('NOTIFICATION_TITLE')
					});
					component.getEl().on('click', function(e) {
						var notificationalertwindow = null;
						var isExist = false;
						Ext.getBody().on('click', function(e, t) {
							if (!isEmpty(notificationalertwindow) && !isNullOrEmpty(notificationalertwindow.getEl()) && isExist) {
								var el = notificationalertwindow.getEl();
								if (!(el.dom === t || el.contains(t))) {
									notificationalertwindow.close();
								}
							} else {
								isExist = true;
							}
						});
						if (!isExist) {
							if (Ext.getCmp("NotificationAlertWindow")) {
								Ext.getCmp("NotificationAlertWindow").close();
							}
							notificationalertwindow = me.showWindow('notificationalertwindow');
							if (notificationalertwindow) {
								var NotificationAlertTemplate = notificationalertwindow.down('#NotificationAlertTemplateView');

								if (component) {
									var headerRegionDiv = notificationalertwindow.down('#headerRegion');
									if (headerRegionDiv) {
										if (!isEmpty(component.renderData)) {
											if (!isNullOrEmpty(component.renderData.unreadCount) && component.renderData.unreadCount != 0) {
												headerRegionDiv.spanEl2.setHTML('(' + component.renderData.unreadCount + ')')

											}
											headerRegionDiv.config.type = component.renderData.type;
											if (component.renderData.type == "Notifications") {
												headerRegionDiv.spanEl1.setHTML(getCommonTranslation('NOTIFICATION_TITLE'));
											}
										} else {
											headerRegionDiv.spanEl2.setHTML(getCommonTranslation('NOTIFICATION_TITLE'));
										}
									}
								}

								if (NotificationAlertTemplate) {
									if (portalId == 6) {
										var applicationId = me.loadApplicantProfile();
										var newStore = Ext.getStore('authentication.NotificationAlertForApplicantPortalList');
										NotificationAlertTemplate.bindStore(newStore);
										var user = me.getCurrentlyLoggedInUser();
										if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
											NotificationAlertTemplate.getStore().getProxy().extraParams = {
												userId: applicationId.id,
												messageType: CONSTANTS.NOTIFICATIONS,
												userType: "APPLICANT"
											};
											NotificationAlertTemplate.getStore().load();
										}
									} else {
										var newStore = Ext.getStore('authentication.NotificationAlertList');
										NotificationAlertTemplate.bindStore(newStore);
										var parentId = null;
										var personIdNew = null;
										if (portalId == 7) {
											var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
											var user = portalInfo.student;


											Ext.Ajax.request({
												type: 'rest',
												url: SERVERURL.FIND_PARENT_PERSON_ID + '?userId=' + localStorage.getItem('parentUserId'),
												method: 'GET',
												async: false,
												success: function(res, action) {
													personIdNew = Ext.decode(res.responseText);
												}
											});

											parentId = localStorage.getItem('loggedInParentPersonId');
										} else {
											var user = me.getCurrentlyLoggedInUser();
										}
										if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
											NotificationAlertTemplate.getStore().getProxy().extraParams = {
												userId: user.id,
												messageType: CONSTANTS.NOTIFICATIONS,
												parentUserId: personIdNew
											};
											NotificationAlertTemplate.getStore().load();
										}
									}
								}
							}
						}
					});
				},
				afterrender: function(component) {
					var me = this;
					var user = me.getCurrentlyLoggedInUser();
					var isNotificationBellIcon = false;
					var formFilter = me.getNotificationSection();
					var portalId = this.getCurrentLoggedPortalId();
					var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
					var permissionList = '';
					if (portalId == 1) {
						var CORE_ERP_NOTIFICATION_BELL_ICON_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_NOTIFICATION_BELL_ICON_PRIVILEGES');
						permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, CORE_ERP_NOTIFICATION_BELL_ICON_PERMISSION);
					}
					else if (portalId == 2) {
						var FACULTY_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES');
						permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, FACULTY_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION);
					}
					else if (portalId == 3) {
						var STUDENT_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES');
						permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, STUDENT_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION);
					}
					else if (portalId == 7) {
						var PARENT_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES');
						permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, PARENT_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION);
					}
					else if (portalId == 6) {
						var APPLICANT_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES');
						permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, APPLICANT_PORTAL_NOTIFICATION_BELL_ICON_PERMISSION);
					}
					Ext.each(permissionList, function(privilege) {
						if (privilege === 'VIEW') {
							isNotificationBellIcon = true;
						}
					});
					if (!isNotificationBellIcon) {
						setTimeout(function() {
							var widthVal = formFilter.down('#userNameItemId').getWidth();
							var notificationEl = component.el.dom;
							notificationEl.style.visibility = "hidden";
							component.setWidth(0);
							formFilter.down('#userNameItemId').el.dom.style.width = (widthVal + 40) + "px";
						}, 500);
					}
				}
			},
			'notificationsection #alertDiv': {
				render: function(component) {
					var me = this;
					Ext.create('Ext.tip.ToolTip', {
						target: component.getEl(),
						html: getCommonTranslation('ALERT')
					});
					component.getEl().on('click', function(e) {
						var notificationalertwindow = null;
						var isExist = false;
						Ext.getBody().on('click', function(e, t) {
							if (!isEmpty(notificationalertwindow) && !isNullOrEmpty(notificationalertwindow.getEl()) && isExist) {
								var el = notificationalertwindow.getEl();
								if (!(el.dom === t || el.contains(t))) {
									notificationalertwindow.close();
								}
							} else {
								isExist = true;
							}
						});
						if (!isExist) {
							if (Ext.getCmp("NotificationAlertWindow")) {
								Ext.getCmp("NotificationAlertWindow").close();
							}
							notificationalertwindow = me.showWindow('notificationalertwindow');
							if (notificationalertwindow) {
								var NotificationAlertTemplate = notificationalertwindow.down('#NotificationAlertTemplateView');

								if (component) {
									var headerRegionDiv = notificationalertwindow.down('#headerRegion');
									if (headerRegionDiv) {
										if (!isEmpty(component.renderData)) {
											if (!isNullOrEmpty(component.renderData.unreadCount) && component.renderData.unreadCount != 0) {
												headerRegionDiv.spanEl1.setHTML(component.renderData.unreadCount);
											}
											headerRegionDiv.spanEl2.setHTML(component.renderData.type);
											headerRegionDiv.config.type = component.renderData.type;
										}
									}
								}

								if (NotificationAlertTemplate) {
									var user = me.getCurrentlyLoggedInUser();
									if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
										NotificationAlertTemplate.getStore().getProxy().extraParams = {
											userId: user.id,
											messageType: CONSTANTS.ALERTS
										};
										me.resetPageSetting(NotificationAlertTemplate.getStore());
										NotificationAlertTemplate.getStore().load();
									}
								}
							}
						}
					});
				}
			},

			'notificationalertwindow #viewAllSection': {
				render: function(component) {
					var me = this;
					if (portalId == 6) {
						component.getEl().on('click', function(e) {
							me.openActivityTabForApplicant(true);
						});
					} else {
						component.getEl().on('click', function(e) {
							me.openActivityTab(true);
						});
					}

				}
			},

			'notificationalertwindow dataview': {
				itemclick: function(dataView, record, item, index, e, eOpts) {
					if (e.target.tagName != 'A') {
						if (portalId == 6) {
							this.openActivityTabForApplicant(false, record);
						} else {
							this.openActivityTab(false, record);
						}
					}
				}
			},
			'activityfeedtypegrid #apply': {
				click: function(button) {
					var me = this;
					var grid = Ext.ComponentQuery.query('activityfeedtypegrid')[0];
					if (portalId == 7) {
						var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
						var user = portalInfo.student;
						var parentId = localStorage.getItem('personId');
						if (isNullOrEmpty(parentId)) {
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.FIND_PARENT_PERSON_ID + '?userId=' + localStorage.getItem('parentUserId'),
								method: 'GET',
								async: false,
								success: function(res, action) {
									parentId = Ext.decode(res.responseText);
								}
							});
						}
					} else {
						var user = me.getCurrentlyLoggedInUser();
					}
					var datePicker = grid.down('#dateRangePicker');
					var startDate = null;
					var endDate = null;
					if (datePicker.getText() != "Select Date") {
						startDate = Ext.Date.format(datePicker.startDate, 'Y-m-d');
						endDate = Ext.Date.format(datePicker.endDate, 'Y-m-d');
					}
					grid.getStore().getProxy().extraParams = {
						userId: user.id,
						messageType: CONSTANTS.NOTIFICATIONS,
						parentUserId: parentId,
						fromDate: startDate,
						toDate: endDate
					};
					me.resetPageSetting(grid.getStore());
					grid.getStore().load();
				}
			},
			'activityfeedtypegrid[itemId=activityFeedTypeGrid]': {
				cellclick: this.activityfeedGridCellClick,
				selectionchange: function(cmp, selected) {
					var grid = Ext.ComponentQuery.query('activityfeedtypegrid')[0];
					if (selected.length == 1) {
						grid.down('#btnView').setDisabled(false);
						grid.down('#btnDelete').setDisabled(false);
					} else if (selected.length > 1) {
						grid.down('#btnView').setDisabled(true);
						grid.down('#btnDelete').setDisabled(false);
					} else {
						grid.down('#btnView').setDisabled(true);
						grid.down('#btnDelete').setDisabled(true);
					}

				}
			},
			'activityfeedtypegrid button[itemId=btnView]': {
				click: function() {
					var grid = Ext.ComponentQuery.query('activityfeedtypegrid')[0];
					var record = grid.getSelectionModel().selected.items[0];
					this.activityfeedGridCellClick(grid, '', 1, record);
				}

			},

			'activityfeedtypegridforapplicant[itemId=activityFeedTypeGridForApplicant]': {
				cellclick: this.activityfeedGridForApplicantCellClick
			},

			'activityfeeds radiogroup#isOriginalRadio': {
				change: function(radio, newValue, oldValue) {
					if (portalId == 6) {
						this.selectActivityFeedTypeGridForApplicantRecord(radio, newValue);
					} else {
						this.selectActivityFeedTypeGridRecord(radio, newValue);
					}

				}
			},

			'activityfeedtypegrid button[itemId=btnDelete]': {
				click: function(button) {
					this.deleteMessages(button);
				}
			},
			'activityfeedtypegridforapplicant button[itemId=btnDelete]': {
				click: function(button) {
					this.deleteMessagesforapplicant(button);
				}
			},

			'activityfeeddisplaytemplate button[itemId=btnDelete]': {
				click: function(button) {
					this.deleteSingleMessage(button);
				}
			},

			'activityfeeddisplaytemplate button[itemId=btnNext]': {
				click: function(button) {
					button.firstTimeFired = true;
					this.nextPreviousButtonClick(button, 0);
				}
			},

			'activityfeeddisplaytemplate button[itemId=btnPrevious]': {
				click: function(button) {
					button.firstTimeFired = true;
					this.nextPreviousButtonClick(button, 1);
				}
			},

			'notificationDetailsWindow': {
				show: function(win) {
					var tempPanel = win.down('#activityFeedDisplayTemplate');
					this.addApplicantLinkClickHandler(tempPanel);
				}
			},

			'downloadattachment[itemId=downloadAttachment] dataview': {
				itemclick: function(view, record) {
					this.downloadAlertNotificationAttachment(record);
				}
			},
			/***************END: Alerts and Notification**************************/

			/****************START: social mapping *********************/
			'socialmappingform button[itemId=socialLoginBtn]': {
				click: this.socialLoginBtn
			},
			'socialmappingform textfield#password': {
				specialkey: this.getLoginBySocialWinKey
			},
			'socialmappingwindow grid[itemId=socialmappingGrid]': {
				afterrender: function(grid) {
					var userId = this.getCurrentlyLoggedInUser().id;
					grid.getStore().load({
						params: { userId: userId }
					});
				}
			},
			'socialmappingwindow grid[itemId=socialmappingGrid] button[itemId=btnDelete]': {
				click: this.deleteSocialMappingDetail
			},
			'parentportalregistrationformwin button#cancelBtn': {
				click: function(button) {
					var parentRegistrationWin = button.up('parentportalregistrationformwin');
					if (Ext.isDefined(parentRegistrationWin)) {
						parentRegistrationWin.close();
					}
					var parentRegistrationWarningWin = this.getParentportalregistrationwarningformwin();
					if (!parentRegistrationWarningWin) {
						Ext.widget('parentportalregistrationwarningformwin');
						parentRegistrationWarningWin = this$.getParentportalregistrationwarningformwin();
					}
					parentRegistrationWarningWin.show();
				}
			},
			'parentportalregistrationwarningformwin button#completeRegistrationLater': {
				click: function(button) {
					var parentRegistrationWin = this.getParentportalregistrationwarningformwin();
					if (Ext.isDefined(parentRegistrationWin)) {
						parentRegistrationWin.close();
					}
				}
			},
			'parentportalregistrationwarningformwin button#submitBtn': {
				click: function(button) {
					var parentRegistrationWin = button.up('parentportalregistrationwarningformwin');
					this.completeTheRegistrationProcess(button, parentRegistrationWin);
				}
			},
			'parentportalregistrationformwin button#submitBtn': {
				click: function(button) {
					var parentRegistrationWin = button.up('parentportalregistrationformwin');
					this.completeTheRegistrationProcess(button, parentRegistrationWin);
				}
			},
			'parentportalregistrationformwin': {
				afterrender: function(form) {
					var $this = this;
					var permissionMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REREGISTRATION_POPUP_PRIVILEGES');
					var btn = form.down('#cancelBtn');
					var associatedAcadLocationIds = new Array();
					associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
					btn.setVisible(false);
					Ext.each(permissionList, function(privilege) {
						if (privilege === 'COMPLETE_REGISTRATION_LATER') {
							if (!isNullOrEmpty(btn)) {
								btn.setVisible(true);
							}
						}
					});
					var getStudentInfo = this.getCurrentlyLoggedInUserInfoForPortal();
					if (!isNullOrEmpty(getStudentInfo.student.id)) {
						var getURL = SERVERURL.PATH_FINDLAYOUT_CURRENTANDNEXT_PAYMENTTERM;
						Ext.Ajax.request({
							type: 'rest',
							async: false,
							method: 'GET',
							url: getURL,
							params: {
								studentId: getStudentInfo.student.id
							},
							success: function(response, action) {
								getResponseList = Ext.decode(response.responseText);
							},
							failure: function(form, action) {
								getResponseList = null;
							}
						});
					}
					/*this api is fetching data of registration setup labels*/
					Ext.Ajax.request({
						type: 'rest',
						async: false,
						method: 'GET',
						url: SERVERURL.PATH_FIND_STUDENT_FEE_REGISTRATION_NEW_SETUP,
						params: {
							academyLocationId: $this.getCurrentAcademyLocation()
						},
						success: function(response, action) {
							var data = Ext.decode(response.responseText);
							if (data && data.length > 0 && data[0].registrationPopUpContent) {
								form.down('#PPRegWinFirstMsgId').getEl().setHTML('<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:5px 3px;\'>' + data[0].registrationPopUpContent + '</p>');
								form.down('#PPRegWinSecondMsgId').setVisible(false);
								form.down('#PPRegWinThirdMsgId').setVisible(false);
							}
						}
					});
				}
			},
			'parentportalregistrationwarningformwin': {
				afterrender: function(form) {
					var warningMsgId = form.down('#warningMsgId');
					var expireCurrentYearDate;
					if (!isNullOrEmpty(getResponseList)) {
						Ext.each(getResponseList, function(record) {
							if (record.paymentTermName == 'CURRENT_PAYMENT_TERM' && record.registrationStatus == "InCompleted") {
								expireCurrentYearDate = record.newRegisteredStudentEndDate;
								return false;
							} else if (record.paymentTermName == 'NEXT_PAYMENT_TERM' && record.registrationStatus == "InCompleted") {
								expireCurrentYearDate = record.newPaymentTermEndDate;
								return false;
							}
						});

						/*code start for V2D-465876*/
						Ext.each(getResponseList, function(record) {
							if (!isNullOrEmpty(record.endRegistrationDate) && (record.paymentTermName == 'CURRENT_PAYMENT_TERM' && record.registrationStatus == "InCompleted") && (dateRender(record.endRegistrationDate) >= dateRender(new Date()))) {
								expireCurrentYearDate = record.endRegistrationDate;
								return false;
							}
							if (!isNullOrEmpty(record.endRegistrationDate) && (record.paymentTermName == 'NEXT_PAYMENT_TERM' && record.registrationStatus == "InCompleted") && (dateRender(record.endRegistrationDate) >= dateRender(new Date()))) {
								expireCurrentYearDate = record.endRegistrationDate;
								return false;
							}
						});
						/*code End for V2D-465876*/
					}
					warningMsgId.setValue('<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:5px 0px;color:black;font-weight:600\'>' + getFeeAndPaymentCommonTranslation('YOU_HAVE_TO_COMPLETE_THE_REGISTRATION_BEFORE') + '  ' + dateRender(expireCurrentYearDate) + '</p>');
				}
			},
			'notificationSearchForm radiogroup[itemId=dateRangeDetails]': {
				change: function(cmp) {
					var val = cmp.getValue(),
						formView = this.getNotificationSearchForm(),
						startField = formView.down('#startDate'),
						endField = formView.down('#endDate');

					if (val.dateRange == 'TODAY') {
						startField.setValue(dateRender(new Date()));
						endField.setValue(dateRender(new Date()));
					} else if (val.dateRange == 'LAST_WEEK') {
						startField.setValue(dateRender(Ext.Date.add(new Date(), Ext.Date.DAY, - 7)));
						endField.setValue(dateRender(new Date()));
					} else if (val.dateRange == 'LAST_MONTH') {
						startField.setValue(dateRender(Ext.Date.add(new Date(), Ext.Date.DAY, - 30)));
						endField.setValue(dateRender(new Date()));
					}
				}
			},
			'notificationSearchForm button[itemId=resetBtn]': {
				click: function() {
					var formView = this.getNotificationSearchForm(),
						dateRangeRadio = formView.down('#dateRangeDetails'),
						startDate = formView.down('#startDate'),
						endDate = formView.down('#endDate');
					dateRangeRadio.reset();
					startDate.reset();
					endDate.reset();
				}
			},
			'notificationSearchForm button[itemId=searchBtn]': {
				click: function(btn) {
					var me = this;
					var formView = this.getNotificationSearchForm();
					var grid = Ext.ComponentQuery.query('activityfeedtypegrid')[0];
					if (portalId == 6) {
						grid = Ext.ComponentQuery.query('activityfeedtypegridforapplicant')[0];
					}
					if (portalId == 7) {
						var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
						var user = portalInfo.student;
						var parentId = localStorage.getItem('personId');
						if (isNullOrEmpty(parentId)) {
							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.FIND_PARENT_PERSON_ID + '?userId=' + localStorage.getItem('parentUserId'),
								method: 'GET',
								async: false,
								success: function(res, action) {
									parentId = Ext.decode(res.responseText);
								}
							});
						}
					} else {
						var user = me.getCurrentlyLoggedInUser();
					}
					var userType = '';
					if (portalId == 6) {
						var user = me.loadApplicantProfile();
						user.id = user.id;
						var userType = "APPLICANT"
					}
					var startDate = formView.down('#startDate').getValue();
					var endDate = formView.down('#endDate').getValue();
					startDate = Ext.Date.format(startDate, 'Y-m-d');
					endDate = Ext.Date.format(endDate, 'Y-m-d');
					grid.getStore().getProxy().extraParams = {
						userId: user.id,
						messageType: CONSTANTS.NOTIFICATIONS,
						parentUserId: parentId,
						fromDate: startDate,
						toDate: endDate,
						userType: userType
					};
					me.resetPageSetting(grid.getStore());
					grid.getStore().removeAll();
					grid.getStore().load();
				}
			},
			/*******************END : social mapping ********************/
			/*Notification For Recent Visited Users: Start - 27-02-2025*/
			'notificationsection': {
				afterrender: function(view) {
					setTimeout(function() {
						var recentActivityBox = view.down('#notificationRecentActivityAlertBox')
						if (portalId == 1) {
							recentActivityBox.setVisible(true)
						}
					}, 100)
				}
			},
			'notificationalertforrecentvisitedstudents': {
				afterrender: function(view) {
					var $this = this;
					var contentpanel = $this.getContentpanel();
					var tabName = getMegaMenuTranslation('STD_STUDENTS_STUDENT_PROFILE');
					var studentprofileviewstructure = Ext.widget('studentprofileviewstructure');
					var getcontroller = $this.getController('menu.CoreERPNavigationController');
					var getStudentProfileTab = getcontroller.getTab(getMegaMenuTranslation('STD_STUDENTS_STUDENT_PROFILE'));
					var notifyRecentVisitedUsers = $this.getNotificationalertforrecentvisitedstudents();
					var el = view.getEl();

					if (el) {
						el.on('click', function(event, target) {
							if (target.id === 'redirectToStdProfilePageId') {
								try {
									Ext.ComponentQuery.query('notificationalerttorecentactivitywindow')[0].close();
									setTimeout(function() {
										var linkName = getMegaMenuTranslation('STD_STUDENTS_STUDENT_PROFILE_TO_VISITED_RECORD');
										var spanElement = Ext.DomQuery.selectNode('span.x-btn-inner.x-btn-inner-left:contains(' + linkName + ')');
										if (spanElement) {
											Ext.fly(spanElement).dom.click();
										}
									}, 300);
								}
								catch (e) {
								}
							}
						});
					}
				}
			},
			'notificationalertforrecentvisitedusers': {
				afterrender: function(view) {
					var $this = this;
					var notifyRecentVisitedUsers = $this.getNotificationalertforrecentvisitedusers();
					var el = view.getEl();
					if (el) {
						el.on('click', function(event, target) {
							if (target.id === 'redirectToProfilePageId') {
								try {
									Ext.ComponentQuery.query('notificationalerttorecentactivitywindow')[0].close();
									setTimeout(function() {
										var linkName = getMegaMenuTranslation('SYSADMIN_USER_MANAGEMENT_USER_PROFILE_TO_VISITED_RECORD');
										var spanElement = Ext.DomQuery.selectNode('span.x-btn-inner.x-btn-inner-left:contains(' + linkName + ')');
										if (spanElement) {
											Ext.fly(spanElement).dom.click();
										}
									}, 300);
								}
								catch (e) {
								}
							}
						});
					}
				}
			},
			'notificationalertforrecentvisitedactivity': {
				afterrender: function(view) {
					var store = view.down('dataview').getStore();
					var getURL = SERVERURL.FIND_ALL_USER_ACTIVITIES;
				},
			},
			/*Notification For Recent Visited Users: End - 27-02-2025*/
			'googletranslationwindow container[itemId=googleTranslateContainer]': {
				afterrender: function(view) {
					// Check if the Google Translate script is already loaded
					//if (typeof google === 'undefined' || typeof google.translate === 'undefined') {
					// Dynamically load the Google Translate script if not already loaded
					var script = document.createElement('script');
					script.src = 'https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
					document.body.appendChild(script);
					Ext.Ajax.request({
						type: 'rest',
						async: false,
						url: SERVERURL.FILE_PRIORITY,
						params: {
							type: 'googleTranslateTo'
						},
						method: 'GET',
						success: function(res, action) {
							var response = Ext.decode(res.responseText);
							if (response.length == 0) {
								// Define the translation function if the script is loaded
								window.googleTranslateElementInit = function() {
									// Clean up any previous translations before adding a new one
									var translateElement = document.getElementById('google_translate_element');
									if (translateElement) {
										translateElement.innerHTML = ''; // Clear previous translation element
									}
									// Initialize the Google Translate widget
									new google.translate.TranslateElement({
										pageLanguage: 'en', // Your page's default language
										//includedLanguages: 'af,sq,am,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,zh-CN,zh-TW,hr,cs,da,nl,en,eo,et,tl,fi,fr,gl,ka,de,el,gu,ht,ha,haw,he,hi,hmn,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,ku,ky,lo,la,lv,lt,mk,ms,ml,mr,mn,my,ne,no,ps,fa,pl,pt,pa,ro,ru,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tl,ta,te,th,tr,uk,ur,uz,vi,cy,xh,yi,yo,zu',
										includedLanguages: 'en',
										layout: google.translate.TranslateElement.InlineLayout.SIMPLE
									}, 'google_translate_element');
								};
							} else {
								var arr = [];
								response.forEach(function(item) {
									arr.push(item.value);
								});
								var codes = arr.join(',');
								// Define the translation function if the script is loaded
								window.googleTranslateElementInit = function() {
									// Clean up any previous translations before adding a new one
									var translateElement = document.getElementById('google_translate_element');
									if (translateElement) {
										translateElement.innerHTML = ''; // Clear previous translation element
									}

									// Initialize the Google Translate widget
									new google.translate.TranslateElement({
										pageLanguage: 'en', // Your page's default language
										includedLanguages: codes,
										layout: google.translate.TranslateElement.InlineLayout.SIMPLE
									}, 'google_translate_element');
								};
								// Resize dropdown after rendering
								/*setTimeout(function(){
									const dropdown = document.querySelector('.goog-te-gadget-simple');
									if (dropdown) {
										dropdown.style.width = '250px';      // Adjust width
										dropdown.style.height = '36px';      // Adjust height
										dropdown.style.fontSize = '14px';    // Adjust font
										dropdown.style.padding = '6px 8px';  // Optional
									}
								}, 300);*/
							}
						}
					});
					/*} else {
						// If script is already loaded, initialize the Google Translate element
						googleTranslateElementInit();
				    
					Ext.Ajax.request({
						type: 'rest',
						async: false,
						url: SERVERURL.FILE_PRIORITY,
						params: {
							type:'GoogleTranslation'
						},
						method: 'GET',
						success: function(res, action) {
							var response = Ext.decode(res.responseText);
							if(response.length == 0){
								// Define the translation function if the script is loaded
								window.googleTranslateElementInit = function() {
									// Clean up any previous translations before adding a new one
									var translateElement = document.getElementById('google_translate_element');
									if (translateElement) {
										translateElement.innerHTML = ''; // Clear previous translation element
									}
									// Initialize the Google Translate widget
									new google.translate.TranslateElement({
										pageLanguage: 'en', // Your page's default language
										//includedLanguages: 'af,sq,am,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,zh-CN,zh-TW,hr,cs,da,nl,en,eo,et,tl,fi,fr,gl,ka,de,el,gu,ht,ha,haw,he,hi,hmn,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,ku,ky,lo,la,lv,lt,mk,ms,ml,mr,mn,my,ne,no,ps,fa,pl,pt,pa,ro,ru,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tl,ta,te,th,tr,uk,ur,uz,vi,cy,xh,yi,yo,zu',
										includedLanguages: 'en',
										layout: google.translate.TranslateElement.InlineLayout.SIMPLE
									}, 'google_translate_element');
								};
							}else{
								var arr=[];
								 response.forEach(function(item){
									 arr=item.value+','; // or item.displayOtherLanguage
								 });
								 
								// Define the translation function if the script is loaded
								window.googleTranslateElementInit = function() {
									// Clean up any previous translations before adding a new one
									var translateElement = document.getElementById('google_translate_element');
									if (translateElement) {
										translateElement.innerHTML = ''; // Clear previous translation element
									}

									// Initialize the Google Translate widget
									new google.translate.TranslateElement({
										pageLanguage: 'en', // Your page's default language
										includedLanguages: arr,
										layout: google.translate.TranslateElement.InlineLayout.SIMPLE
									}, 'google_translate_element');
								};
							}
						}
					});
					}*/
				}
			},
			'termsandconditionsformwin': {
				afterrender: function(win) {
					var finalHtml, introText = getCommonTranslation('T&C_INTRODUCTORY_TEXT'),
						bulletText = getCommonTranslation('BULLETED_LIST_OF_TERMS'),
						termsArray = bulletText.split('&&&'),
						htmlList = '<ul style="margin-left:0; padding-left:20px;color:black;">';

					Ext.Array.forEach(termsArray, function(term) {
						htmlList += '<li>' + term + '</li>';
					});
					htmlList += '</ul>';

					finalHtml = '<p style="margin:0; color:black; text-align:justify;">'
						+ introText + '</p>'
						+ htmlList;

					win.down('#introText_bulletPointsText').setValue(finalHtml);
				}
			},
			'termsandconditionsformwin button#DoNotAcceptBtn': {
				click: function(btn) {
					if (typeof btn.lastExecutionTime === 'undefined') {
						btn.lastExecutionTime = 0;
					}
					var currentTime = new Date().getTime();

					// Prevent function execution if called within the last 5+ seconds
					if (currentTime - btn.lastExecutionTime < 5000) {
						return false;
					}
					// Update last execution time
					btn.lastExecutionTime = currentTime;
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					this.logOutUser();
				}
			},
			'termsandconditionsformwin button#acceptBtn': {
				click: function(btn) {
					if (typeof btn.lastExecutionTime === 'undefined') {
						btn.lastExecutionTime = 0;
					}
					var currentTime = new Date().getTime();

					// Prevent function execution if called within the last 5+ seconds
					if (currentTime - btn.lastExecutionTime < 5000) {
						return false;
					}
					// Update last execution time
					btn.lastExecutionTime = currentTime;
					var currentAL = this.getCurrentAcademyLocation();

					var $this = this, submitUrl,
						currentLoggedInUser = this.getCurrentlyLoggedInUser().id;
					if (portalId == 7) {
						var userInfo = Academia.model.authentication.UserInfoModel;
						currentLoggedInUser = userInfo.get("parentUserId");
					}

					if (portalId == 6) {
						var userInfo = Academia.model.authentication.UserInfoModel;
						currentLoggedInUser = userInfo.get("externalUserId");
						submitUrl = SERVERURL.PATH_ACCEPT_TERMS_AND_CONDITIONS + '?externalUserId=' + currentLoggedInUser + '&portalId=' + portalId + '&academyLocationId=' + currentAL;
					} else {
						submitUrl = SERVERURL.PATH_ACCEPT_TERMS_AND_CONDITIONS + '?userId=' + currentLoggedInUser + '&portalId=' + portalId + '&academyLocationId=' + currentAL;
					}
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						url: submitUrl,
						method: 'POST',
						success: function(response) {
							Ext.getBody().unmask();
							var termsAndConditionsFormWin = btn.up('termsandconditionsformwin');
							if (termsAndConditionsFormWin) {
								termsAndConditionsFormWin.close();
							}
							$this.generalSurveyWindow();
						},
						failure: function(response) {
							Ext.getBody().unmask();
						}
					});
				}
			},
			'generalsurveyhomepagescreen component[itemId=quickPollComponent]': {
				afterrender: function(component) {
					var this$ = this;
					var IsChangeStudent = Ext.decode(localStorage.getItem('IsChangeStudent'));
					var userInfo = Academia.model.authentication.UserInfoModel;
					portalId = userInfo.get("portalId");
					Ext.Ajax.request({
						type: 'rest',
						async: false,
						url: SERVERURL.PATH_GENERAL_SURVEY_FIND_ALL,
						params: {
							academyLocationId: this$.getCurrentAcademyLocation(),
							portal: portalId,
						},
						method: 'GET',
						success: function(res, action) {
							if (res.responseText) {
								var response = Ext.decode(res.responseText);
								var isApplicant = false;
								var userTypeExternalId = null;
								if ((response.isAdmin == true && portalId == 1) || (response.isFaculty == true && portalId == 2) || (response.isParent == true && portalId == 7 && isNullOrEmpty(IsChangeStudent)) || (response.isStudent == true && portalId == 3) || (response.isApplicant == true && portalId == 6)) {
									if (response.isParent == true && portalId == 7) {
										var userTypeId = userInfo.get("parentUserId");
									} else if (response.isApplicant == true && portalId == 6) {
										userTypeExternalId = userInfo.get("externalUserId");
										isApplicant = true;
									} else {
										var userTypeId = userInfo.get("userId");
									}
									if (isNullOrEmpty(userTypeId)) {
										var userOrExternalUserId = userTypeExternalId;
									} else {
										userOrExternalUserId = userTypeId;
									}
									Ext.Ajax.request({
										type: 'rest',
										async: false,
										url: SERVERURL.PATH_FIND_SURVEY_SUBMISSION_DETAILS_BY_USER_ID_AND_SURVEY,
										params: {
											userId: userOrExternalUserId,
											isApplicant: isApplicant,
											surveyToken: response.surveyToken
										},
										method: 'GET',
										success: function(res, action) {
											if (!res.responseText) {
												Ext.Ajax.request({
													type: 'rest',
													async: false,
													url: SERVERURL.PATH_GET_USER_CONTACT_BY_USER_ID_OR_PERSON_ID,
													params: {
														portalId: portalId,
														userId: userOrExternalUserId,
													},
													method: 'GET',
													success: function(userData, action) {
														if (userData.responseText) {
															var userDataResponse = Ext.decode(userData.responseText);

															var submitData = {
																"surveyToken": response.surveyToken,
																"user": { "id": userTypeId },
																"externalUser": { "id": userTypeExternalId },
																"isSubmitted": true
															}
															window.addEventListener('message', function(event) {
																if (event.data.type === "surveyCompleted") {
																	Ext.Ajax.request({
																		type: 'rest',
																		url: SERVERURL.PATH_SAVE_SURVEY_SUBMISSION_DETAILS,
																		jsonData: submitData,
																		method: 'POST',
																		success: function(response, action) {

																		}
																	});
																}
															});

															var ALName = this$.getAcademyLocationDisplayName(this$.getCurrentAcademyLocation());
															var ALNameResult = ALName.replace(/&/g, '-');

															// Remove old ss-widget if exists
															var oldWidget = document.getElementById('ss-widget');
															if (oldWidget) {
																oldWidget.parentNode.removeChild(oldWidget);
															}

															// Remove old SS_SCRIPT if exists
															var oldScript = document.getElementById('SS_SCRIPT');
															if (oldScript) {
																oldScript.parentNode.removeChild(oldScript);
															}
															var tokenApiResponse = Ext.decode(localStorage.getItem('tokenApiResponse'));
															// Create and inject the sparrowLaunch function
															var inlineScript = document.createElement('script');
															inlineScript.id = 'SS_SCRIPT';
															inlineScript.type = 'text/javascript';
															inlineScript.text =
																"function sparrowLaunch(opts){" +
																"var e='ss-widget',t='script',a=document,r=window,l=localStorage;" +
																"var s,n,c,rm=a.getElementById('SS_SCRIPT');" +
																"r.SS_WIDGET_TOKEN='" + response.surveyToken + "';" +
																"r.SS_ACCOUNT='" + response.surveyUrl + "';" +
																"r.SS_SURVEY_NAME='" + response.surveyName + "';" +
																"if(!a.getElementById(e) && !l.getItem('removed-ss-widget-" + response.surveyToken + "')){" +
																"var S=function(){S.update(arguments)};" +
																"S.args=[];" +
																"S.update=function(e){S.args.push(e)};" +
																"r.SparrowLauncher=S;" +
																"s=a.getElementsByTagName(t);" +
																"c=s[s.length-1];" +
																"n=a.createElement(t);" +
																"n.type='text/javascript';" +
																"n.async=true;" +
																"n.id=e;" +
																"n.src='https://' + r.SS_ACCOUNT + '/widget/' + r.SS_WIDGET_TOKEN + '?customParams=' + encodeURIComponent(JSON.stringify(opts));" +
																"c.parentNode.insertBefore(n,c);" +
																"r.SS_VARIABLES=opts;" +
																"if (rm) rm.parentNode.removeChild(rm);" +

																// --- Add Don't Ask Me Again button observer ---
																"var observer=new MutationObserver(function(muts){" +
																"muts.forEach(function(m){" +
																"m.addedNodes.forEach(function(node){" +
																"if(node.id==='ss_survey_widget'){" +
																"var btn=a.createElement('button');" +
																"btn.innerText='Don\\'t ask me again';" +
																"btn.style.position='absolute';" +
																"btn.style.zIndex='111111111111';" +
																"btn.style.background='#f44336';" +
																"btn.style.color='#fff';" +
																"btn.style.border='none';" +
																"btn.style.padding='8px 12px';" +
																"btn.style.borderRadius='5px';" +
																"btn.style.cursor='pointer';" +
																"btn.style.bottom='20px';" +

																"var rect=node.getBoundingClientRect();" +
																"btn.style.left=rect.left+(rect.width/2)-70+'px';" +
																"btn.style.bottom=rect.top-20+'px';" +

																"btn.onclick=function(){" +
																"l.setItem('removed-ss-widget-" + response.surveyToken + "','true');" +
																"Ext.Ajax.request({" +
																"url: '" + SERVERURL.PATH_SAVE_SURVEY_SUBMISSION_DETAILS + "'," +
																"method: 'POST'," +
																"headers: {" +
																"'Authorization': 'Bearer " + tokenApiResponse.access_token + "'" +
																"}," +
																"jsonData: {" +
																"surveyToken: '" + response.surveyToken + "'," +
																"user: { id: '" + userTypeId + "' }," +
																"isSubmitted: false," +
																"isSkipped: true" +
																"}," +
																"success: function(response) {" +

																"}" +
																"});" +

																"var iframe = a.getElementById('ss_survey_widget');" +
																"if(iframe) iframe.remove();" +
																"btn.remove();" +
																"};" +

																"a.body.appendChild(btn);" +

																// Remove button when iframe is closed, removed, or hidden
																"(function(){" +
																"function removeBtn(){ if(btn && btn.parentNode){ btn.remove(); }}" +

																// Case 1: user interacts with iframe (focus event like Continue click)
																"window.addEventListener('blur',function(){ " +
																"setTimeout(function(){ " +
																"if(document.activeElement && (document.activeElement.id==='ss_widget_frame'||document.activeElement.id==='ss_survey_widget')){ removeBtn(); }" +
																"},50);" +
																"});" +

																// Case 2: fallback polling (detect hidden or removed)
																"var poll=setInterval(function(){ " +
																"var iframe=a.getElementById('ss_widget_frame')||a.getElementById('ss_survey_widget'); " +
																"if(!iframe || iframe.style.display==='none' || iframe.style.visibility==='hidden' || iframe.offsetParent===null){" +
																"removeBtn();" +
																"clearInterval(poll);" +
																"}" +
																"},100);" +
																"})();" +

																"r.addEventListener('resize',function(){" +
																"if(!a.body.contains(node)||!a.body.contains(btn))return;" +
																"var rect=node.getBoundingClientRect();" +
																"btn.style.left=rect.left+(rect.width/2)-70+'px';" +
																"btn.style.bottom=rect.top-20+'px';" +
																"});" +

																"r.addEventListener('scroll',function(){" +
																"if(!a.body.contains(node)||!a.body.contains(btn))return;" +
																"var rect=node.getBoundingClientRect();" +
																"btn.style.left=rect.left+(rect.width/2)-70+'px';" +
																"btn.style.bottom=rect.top-20+'px';" +
																"});" +

																// --- Watch for removal of popup ---
																"var closeObserver=new MutationObserver(function(changes){" +
																"changes.forEach(function(ch){" +
																"ch.removedNodes.forEach(function(rmNode){" +
																"if(rmNode.id==='ss_survey_widget' && a.body.contains(btn)){" +
																"btn.remove();" +  // remove button if popup closed
																"}" +
																"});" +
																"});" +
																"});" +
																"closeObserver.observe(a.body,{childList:true,subtree:true});" +
																"}" +
																"});" +
																"});" +
																"});" +
																"observer.observe(a.body,{childList:true,subtree:true});" +
																"}" +
																"};" +

																"sparrowLaunch({" +
																"user_id: '" + userTypeId + "'," +
																"email_id: '" + userDataResponse.emailId + "'," +
																"user_name: '" + userInfo.get('userName') + "'," +
																"phone_number: '" + userDataResponse.mobileNumber + "'," +
																"academy_location: '" + ALNameResult + "'," +
																"launchNow: true" +
																"});" +
																"window.sparrowConfig = {forceTrigger: true};";

															document.body.appendChild(inlineScript);
														}
													}
												});
											}
										}
									});
								}
							}
						}
					});
				}
			}
		});
	},
	getPasswordPolicy: function(form) {
		Ext.Ajax.request({
			url: 'rest/userPasswordPolicy',
			method: 'GET',
			success: function(response) {
				var responseData = Ext.decode(response.responseText);
				var frm = form.down("#newPassword");
				var frmConfirm = form.down("#confirmedPassword");
				var maxLengthForPassword = responseData.maxLength;
				if (frm) {
					frm.inputEl.dom.maxLength = maxLengthForPassword
				}
				if (frmConfirm) {
					frmConfirm.inputEl.dom.maxLength = maxLengthForPassword
				}
				if (!isEmpty(responseData)) {
					if (!isNullOrEmpty(responseData.id)) {
						var template = new Ext.XTemplate('<tpl><div><table  cellspacing="0" cellpadding="0" >',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.minLength != null && responseData.minLength >= 0 ? (getCommonTranslation('MIN_LENGTH_PASSWORD') + " : ") : '') + ' ' + (responseData.minLength != null ? responseData.minLength : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.maxLength != null && responseData.maxLength >= 0 ? (getCommonTranslation('MAX_LENGTH_PASSWORD') + " : ") : '') + ' ' + (responseData.maxLength != null ? responseData.maxLength : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.minSpecialCharacter != null && responseData.minSpecialCharacter >= 0 ? (getCommonTranslation('MIN_SPECIAL_CHARACTER') + " : ") : '') + ' ' + (responseData.minSpecialCharacter != null ? responseData.minSpecialCharacter : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.minDigits != null && responseData.minDigits >= 0 ? (getCommonTranslation('MIN_DIGITS') + " : ") : '') + ' ' + (responseData.minDigits != null ? responseData.minDigits : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.whetherReusePassword != false && responseData.whetherReusePassword != null ? (getCommonTranslation('REUSE_PASSWORD') + " : ") : '') + ' ' + (responseData.whetherReusePassword ? 'Yes' : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.whetherReuseUsername != false && responseData.whetherReuseUsername != null ? (getCommonTranslation('REUSE_USERNAME_SHORT') + " : ") : '') + ' ' + (responseData.whetherReuseUsername ? 'Yes' : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.minCapitalLetter != null && responseData.minCapitalLetter >= 0 ? (getCommonTranslation('MIN_CAPITAL_LETTERS') + " : ") : '') + ' ' + (responseData.minCapitalLetter != null ? responseData.minCapitalLetter : '') + '</td>',
							'</tr>',
							'<tr>',
							'<td style="word-break: break-word;">' + (responseData.allowableSpecialCharacters != null && responseData.allowableSpecialCharacters != '' ? (getCommonTranslation('ALLOWABLE_SPECIAL_LETTERS') + " : ") : '') + ' ' + (responseData.allowableSpecialCharacters != null ? responseData.allowableSpecialCharacters : '') + '</td>',
							'</tr>',
							'</table></div>',
							'</tpl>');
						var passwordPolicyTemplate = form.down('#passwordPolicyTemplate');
						passwordPolicyTemplate.refresh();
						passwordPolicyTemplate.tpl = template;
						passwordPolicyTemplate.tpl.overwrite(passwordPolicyTemplate.el.dom, responseData);
						form.doLayout();
					}
				}
			},
			fail: function(response) {
				status = false;
			}
		});
	},
	//@ravi.patidar login and reload for translation issue
	loginAccessLoadMainPanel: function() {
		this$ = this;
		//DEFER FUNCTION USER FOR DELAY A SECOND FOR MASKING IN CHROME
		// Load store for id generator
		// @author : Rupesh Agrawal
		Ext.defer(function() {
			/*var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');
			if(idTableMappingStore && idTableMappingStore.data.length==0){
				idTableMappingStore.load();
			}*/
			var orgModel = Academia.model.common.OrgSettingDateTimeModel;
			if (isNullOrEmpty(orgModel.get('dateFormat'))) {
				this$.getOrgSettingOnLogin();
			}
			this$.getFeaturePrivileges(this$, null, false, null);
			$('#progress').hide();
			$('.preloader-wrap').hide();
			$('#loadingImage').hide();
			localStorage.setItem('loadingMessage', 'Please wait while the system is initializing...');
		}, 1000);
	},
	//@ravi.patidar access privileges for login user
	getFeaturePrivilegesLoginAccess: function(me, portalId, whetherChangePortal, removeform) {
		var resetPassword = false;
		var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
		Ext.Ajax.request({
			url: 'rest/authentication/features',
			method: 'GET',
			async: false,
			params: {
				portalId: portalId,
				academyLocationId: academyLocationId
			},
			success: function(response) {
				var responseData = Ext.decode(response.responseText);
				var userInfo = Academia.model.authentication.UserInfoModel;
				if ((!isNullOrEmpty(responseData.portalId)) && responseData.portalId.length >= 1) {
					$('.preloader-wrap').hide();
					$('#progress').hide();
					$('#loadingImage').hide();
					//me.showSelectPortalForm(responseData.portalId,removeform);
					if (responseData.portalId.length > 1) {
						me.getStore('authentication.PortalStore').loadData(responseData.portalId);
					}
					userInfo.set("accessiblePortals", responseData.portalId);
					if (Ext.isDefined(Ext.ComponentQuery.query('#organizationLogoLeft')[0])) {
						Ext.ComponentQuery.query('#organizationLogoLeft')[0].setVisible(false);
					}
					//}else{
					portalId = (!isNullOrEmpty(localStorage.getItem("portalId"))) ? localStorage.getItem("portalId") : responseData.portalId[0].id;
					/**
					 * @author Akshay.Kalbhor
					 * Code to set the feature privileges into the AccessControlManager class.
					 * passing the ALPrivelages into the constructor of the class.
					 */
					Academia.utilities.accessControl.AccessControlManager.academyLocationPrivileges = responseData.academyLocationPrivileges;
					if (responseData.academyLocationPrivileges.length > 0) {
						var selectedAcademyLocationId;
						var isAdmin = false;
						Ext.Array.each(Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges(), function(acadLocPrvlgs, index) {
							// for sysadmin user
							if (acadLocPrvlgs.accessibleAcademyLocation.whetherPrimary == null && !isAdmin) {
								selectedAcademyLocationId = acadLocPrvlgs.accessibleAcademyLocation.academyLocationId;
								isAdmin = true;
							}
							// for other user, to get the primary academy locationId 
							if (acadLocPrvlgs.accessibleAcademyLocation.whetherPrimary == true) {
								selectedAcademyLocationId = acadLocPrvlgs.accessibleAcademyLocation.academyLocationId;
							}
						});

						localStorage.setItem('academylocationid', selectedAcademyLocationId);
						//me.loadMultipleLangFilePerAL(selectedAcademyLocationId);
					}
					/******* For to check reset password Flag *******/
					if (responseData.user && responseData.user.whetherPasswordReset) {
						resetPassword = true;
						me.loadPortal(me, resetPassword, whetherChangePortal, removeform, responseData);
					}
					else if (responseData.user && !responseData.user.whetherPasswordReset) {
						me.directLoginWithoutReload();
					}
					else {
						window.location.reload();
					}
				}
			},
			fail: function(response) {
			}
		});
	},
	directLoginWithoutReload: function() {
		var tokenApiResponse = Ext.decode(localStorage.getItem('tokenApiResponse'));
		var academylocationid = Ext.decode(localStorage.getItem('academylocationid'));
		var wheatherSchool = Ext.decode(localStorage.getItem('wheatherSchool'));
		var nonce = localStorage.getItem('nonsec');

		if (isNullOrEmpty(tokenApiResponse) || isNullOrEmpty(tokenApiResponse.Authorization) || isNullOrEmpty(academylocationid)) {
			Ext.create('Academia.view.Viewport').show();
			$('.preloader-wrap').fadeOut(100);
			$('#loadingImage').hide();
		}
		else {
			Ext.Ajax.defaultHeaders = {
				Authorization: "Bearer " + tokenApiResponse.access_token,
				expires_in: tokenApiResponse.expires_in,
				access_token: tokenApiResponse.access_token,
				refresh_token: tokenApiResponse.refresh_token,
				nonce: nonce
			};
			var userInfo = Academia.model.authentication.UserInfoModel;

			userInfo.set("accessToken", tokenApiResponse.access_token);
			userInfo.set("refreshToken", tokenApiResponse.refresh_token);
			userInfo.set("expiryTimeForAccessToken", tokenApiResponse.expires_in);
			var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
			var options = {
				"async": false,
				"url": "rest/authentication/features",
				"method": "GET",
				"params": {
					"academyLocationId": academyLocationId
				},
				"type": "rest"
			};

			secMe(Ext.Ajax.defaultHeaders, options)
			$.ajax({
				type: "GET",
				headers: {
					"Authorization": "Bearer " + tokenApiResponse.access_token,
					"expires_in": tokenApiResponse.expires_in,
					"access_token": tokenApiResponse.access_token,
					"refresh_token": tokenApiResponse.refresh_token,
					"nonce": Ext.Ajax.defaultHeaders.nonce
				},
				url: 'rest/authentication/features',
				async: false,
				data: {
					academyLocationId: academyLocationId
				}
			}).done(function() {
				Academia.app.getController('Academia.controller.authentication.AuthenticationController').loginAccessLoadMainPanel();
			})
				.fail(function() {
					$('.preloader-wrap').fadeOut(100);
					$('#loadingImage').hide();
					var vp = Ext.ComponentQuery.query('vp')[0];
					var wheatherSchool = localStorage.getItem('wheatherSchool');
					if (vp)
						vp.destroy();
					localStorage.clear();
					try {
						localStorage.setItem('wheatherSchool', wheatherSchool);
					}
					catch (e) {
						localStorage.setItem('wheatherSchool', true);
					}
					Ext.create('Academia.view.Viewport').show();
				});
		}
	},
	/**
	 * end new change
	 */

	createCORSRequest: function(method, url) {
		var xhr = new XMLHttpRequest();
		if ("withCredentials" in xhr) {

			// Check if the XMLHttpRequest object has a "withCredentials" property.
			// "withCredentials" only exists on XMLHTTPRequest2 objects.
			xhr.open(method, url, true);

		} else if (typeof XDomainRequest != "undefined") {

			// Otherwise, check if XDomainRequest.
			// XDomainRequest only exists in IE, and is IE's way of making CORS requests.
			xhr = new XDomainRequest();
			xhr.open(method, url);

		} else {

			// Otherwise, CORS is not supported by the browser.
			xhr = null;

		}
		return xhr;


	},



	initializeAcademyLocationAndOrganization: function() {
		/*
		 * Call to initialize the academy location combo.
		 */
		//this.initializeAcademyLocationCombo();

		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.ORGANIZATION_FINDID,
			success: function(response, action) {
				var organization = Academia.model.singleton.Organization;
				if (response.responseText) {
					organization.id = response.responseText;
				}
				Academia.utilities.plugins.SessionMonitor.start();
			}
		});
	},

	getAccessTokenAfterExpiry: function(response) {
		Ext.Ajax.request({
			url: 'http://localhost:8080/serosoft-academia-web/oauth/token',
			method: 'POST',
			async: false,
			params: {
				grant_type: 'refresh_token',
				refresh_token: Ext.Ajax.defaultHeaders['refresh_token'], // Consumer
				// Key
				client_id: 'admin', // Consumer Secret
				client_secret: 'pass' // UserName
			},
			success: function(response) {
				var json = JSON.parse(response.responseText);

				Ext.Ajax.defaultHeaders = {
					Authorization: "Bearer " + json.access_token,
					expires_in: json.expires_in,
					access_token: json.access_token,
					refresh_token: json.refresh_token
				};
			},
			fail: function(response) {
				status = false;
			}
		});
	},

	getFeaturePrivileges: function(me, portalId, whetherChangePortal, removeform) {
		var resetPassword = false;
		var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');

		var alreadySelectedPortalId = null;
		if (isNullOrEmpty(portalId)) {
			var alreadySelectedPortalId = (localStorage.getItem('portalId') == null) ? null : localStorage.getItem('portalId');
		}

		Ext.Ajax.request({
			url: 'rest/authentication/features',
			method: 'GET',
			async: false,
			params: {
				portalId: portalId,
				academyLocationId: academyLocationId
			},
			success: function(response) {
				var responseData = Ext.decode(response.responseText);
				var userInfo = Academia.model.authentication.UserInfoModel;
				var currentPortalData = [];

				//--checking and setting already selected portal for reload condition
				if ((!isNullOrEmpty(responseData.portalId)) && responseData.portalId.length > 1) {
					if (!isNullOrEmpty(alreadySelectedPortalId)) {
						Ext.each(responseData.portalId, function(portalData) {
							if (portalData.id == alreadySelectedPortalId) {
								currentPortalData.push(portalData);
								return;
							}
						});
					}
				}

				if ((!isNullOrEmpty(responseData.portalId)) && responseData.portalId.length > 1) {
					//show select portal window
					$('.preloader-wrap').hide();
					$('#progress').hide();
					$('#loadingImage').hide();
					//me.showSelectPortalForm(responseData.portalId,removeform);
					if (responseData.portalId.length > 1) {
						me.getStore('authentication.PortalStore').loadData(responseData.portalId);
					}
					if (!userInfo.get("accessiblePortals"))
						userInfo.set("accessiblePortals", responseData.portalId);

					portalId = (!isNullOrEmpty(localStorage.getItem("portalId"))) ? localStorage.getItem("portalId") : responseData.portalId[0].id;
					if (currentPortalData.length == 1) {
						me.getFeaturePrivileges(me, currentPortalData[0].id, whetherChangePortal, removeform);
					}
				} else {
					portalId = (!isNullOrEmpty(localStorage.getItem("portalId"))) ? localStorage.getItem("portalId") : responseData.portalId[0].id;
					/**
					 * @author Akshay.Kalbhor
					 * Code to set the feature privileges into the AccessControlManager class.
					 * passing the ALPrivelages into the constructor of the class.
					 */
					Academia.utilities.accessControl.AccessControlManager.academyLocationPrivileges = responseData.academyLocationPrivileges;
					if (responseData.academyLocationDetailsModel != null || responseData.academyLocationDetailsModel != undefined) {
						Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations
							= responseData.academyLocationDetailsModel.academyLocations;

						Academia.utilities.accessControl.AccessControlManager.allocatedAcademies
							= responseData.academyLocationDetailsModel.academies;

						Academia.utilities.accessControl.AccessControlManager.allocatedLocations
							= responseData.academyLocationDetailsModel.locations;

						Academia.utilities.accessControl.AccessControlManager.loggedInUserId
							= responseData.user.id;
						var userName = '';
						if (!isNullOrEmpty(responseData.user.firstName) && !isNullOrEmpty(responseData.user.middleName) && !isNullOrEmpty(responseData.user.lastName)) {
							userName = responseData.user.firstName + ' ' + responseData.user.middleName + ' ' + responseData.user.lastName;
						} else {
							if (!isNullOrEmpty(responseData.user.firstName) && !isNullOrEmpty(responseData.user.middleName)) {
								userName = responseData.user.firstName + ' ' + responseData.user.middleName;
							} else {
								if (!isNullOrEmpty(responseData.user.firstName) && !isNullOrEmpty(responseData.user.lastName)) {
									userName = responseData.user.firstName + ' ' + responseData.user.lastName;
								} else {
									userName = responseData.user.firstName;
								}
							}
						}
						if (userName.length > 56) {
							userName = userName.substring(0, 56);
							userName = userName.trim() + '...';
						}
						userInfo.set("userName", userName);
						userInfo.set("userId", responseData.user.id);
						userInfo.set("parentUserId", responseData.user.id); //after login student was being set in userId
						userInfo.set("code", responseData.user.code);
						userInfo.set("personId", responseData.personId);
						userInfo.set("emailId", responseData.user.emailId);
						userInfo.set("portalId", portalId);
						if (!userInfo.get("accessiblePortals")) {
							userInfo.set("accessiblePortals", portalId);
						}
						userInfo.set("externalUserId", responseData.user.externalUserId);
					}

					if (responseData.academyLocationPrivileges.length > 0) {
						var selectedAcademyLocationId;
						var isAdmin = false;
						Ext.Array.each(Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges(), function(acadLocPrvlgs, index) {
							// for sysadmin user
							if (acadLocPrvlgs.accessibleAcademyLocation.whetherPrimary == null && !isAdmin) {
								selectedAcademyLocationId = acadLocPrvlgs.accessibleAcademyLocation.academyLocationId;
								isAdmin = true;
							}
							// for other user, to get the primary academy locationId 
							if (acadLocPrvlgs.accessibleAcademyLocation.whetherPrimary == true) {
								selectedAcademyLocationId = acadLocPrvlgs.accessibleAcademyLocation.academyLocationId;
							}
						});
						if (localStorage.getItem('academylocationid'))
							selectedAcademyLocationId = parseInt(localStorage.getItem('academylocationid'));

						if (Ext.isDefined(selectedAcademyLocationId) && !isNullOrEmpty(selectedAcademyLocationId)) {
							localStorage.setItem('academylocationid', selectedAcademyLocationId);
							localStorage.setItem('portalId', portalId);
						}
						//me.loadMultipleLangFilePerAL(selectedAcademyLocationId);
						if (portalId == 6) {
							me.filterSystemMenuWithAcademyLocationFeaturePrivilagesForApplicantForm(responseData.systemMenuHierachyModels, selectedAcademyLocationId);
						} else {
							me.filterSystemMenuWithAcademyLocationFeaturePrivilages(responseData.systemMenuHierachyModels, selectedAcademyLocationId);
						}
					}

					/*
					 * Call to initialize the menu.
					 */
					if (responseData.academyLocationPrivileges.length > 0) {
						me.loadSystemMenu(responseData.academyLocationPrivileges);
					} else {
						var MegaMenuModel = Academia.model.menu.MegaMenuDataModel;
						MegaMenuModel.menuData = responseData.systemMenuHierachyModels;
					}
					/******* For to check reset password Flag *******/
					try {
						if (responseData.user.whetherPasswordReset && parseInt(localStorage.getItem('isPasswordResetSuccessfully')) != 1) {
							//                			resetPassword=true;
							/*** V2D-324840 Password Policy - Option of Force update password on first login Start ***/
							if (responseData.wsUserPasswordPolicy != null) {
								if (responseData.wsUserPasswordPolicy.whetherUserForceToUpdatePassword) {
									resetPassword = true;
								}
							}
							/*** V2D-324840 Password Policy - Option of Force update password on first login Start ***/
						}
					}
					catch (e) {

					}
					/*var param = {};
					param.academyLocationId = selectedAcademyLocationId;
					me.getDynamicForFormFieldsInfo(param);*/

					me.loadPortal(me, resetPassword, whetherChangePortal, removeform, responseData, true);
				}
			},
			fail: function(response) {
				status = false;
				$('.preloader-wrap').fadeOut(100);
				$('#loadingImage').hide();
				var vp = Ext.ComponentQuery.query('vp')[0]
				if (vp) {
					vp.destroy();
				}
				localStorage.clear();
				Ext.create('Academia.view.Viewport').show();
			}
		});
		return resetPassword;
	},

	filterSystemMenuWithAcademyLocationFeaturePrivilages: function(responseSystemMenuHierachyModels, selectedAcademyLocationId) {

		Ext.Array.each(Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges(), function(academyLocationPrivileges, index) {

			if (academyLocationPrivileges.accessibleAcademyLocation.academyLocationId == selectedAcademyLocationId) {

				var featurePrivilege = academyLocationPrivileges.featurePrivileges;

				//Level 0
				var level_0_systemMenuObj = [];
				Ext.Array.each(responseSystemMenuHierachyModels, function(level_0_systemMenuHierachyModels, index) {

					//Level 1
					var level_1_systemMenuObj = [];
					Ext.Array.each(level_0_systemMenuHierachyModels.systemMenuHierachyModel, function(level_1_systemMenuHierachyModel, index) {

						//Level 2
						var exist = false;
						var level_2_systemMenuObj = [];
						Ext.Array.each(level_1_systemMenuHierachyModel.systemMenuHierachyModel, function(level_2_systemMenuHierachyModel, index) {
							exist = Ext.Array.contains(featurePrivilege, level_2_systemMenuHierachyModel.featurePrivilegeId);
							if (exist) {
								level_2_systemMenuObj.push(level_2_systemMenuHierachyModel);
							}
						});
						if (level_2_systemMenuObj.length > 0) {
							var systemMenuHierachyModel = level_1_systemMenuHierachyModel;
							systemMenuHierachyModel.systemMenuHierachyModel = level_2_systemMenuObj;
							level_1_systemMenuObj.push(systemMenuHierachyModel);
						}
					});
					if (level_1_systemMenuObj.length > 0) {
						var systemMenuHierachyModels = level_0_systemMenuHierachyModels;
						systemMenuHierachyModels.systemMenuHierachyModel = level_1_systemMenuObj;
						level_0_systemMenuObj.push(systemMenuHierachyModels);
					}

				});
				academyLocationPrivileges.systemMenuHierachyModels = level_0_systemMenuObj;
			}
		});
	},/*
    showSelectPortalForm:function(data,removeform){
    	me = this;
    	var viewport = Ext.ComponentQuery.query('vp')[0];
    	if(!Ext.isDefined(viewport)){
    		var viewport = Ext.create('Academia.view.Viewport');
    	}
    	if(removeform){
    		viewport.remove(removeform);
    	}
    	viewport.add({
    		region: 'center', // center region is required, no width/height specified
    		style: {
    			background: '#f0f0f0'
    		},
    		align: 'stretch',
    		xtype: 'selectportalwindow',        
    		itemId:'selectportalwindow',                            
    		autoScroll: true
    	});
    	selectLogoPanel = viewport.down('#selectLogoPanel');
    	selectLogoPanel.add({
    		xtype: 'panel',
    		itemId:'selectLogoTablePanel',
    		layout: {
    			type: 'table',
    			columns: data.length
    		},
    		items: []
    	});
    	var i = 0;
    	data.forEach(function(obj){
    		var marginPanel = '0 0 0 5'; 
    		if(i == 0){
    			marginPanel = '0 0 0 0'; 
    		}
    		selectLogoTablePanel = Ext.ComponentQuery.query('#selectLogoTablePanel')[0];
    		var imgSrcCss = "defaultPortalCss";
    		if(obj.portalName == "Employee" || obj.portalName == "Faculty"){
    			imgSrcCss = "employeeImgCss";
    		} else if(obj.portalName == "Core ERP"){
    			imgSrcCss = "coreErpImgCss";
    		} else if(obj.portalName == "Student"){
    			imgSrcCss  = "studentImgCss";
    		}
    		selectLogoTablePanel.add({
    			xtype: 'panel',
    			layout : {
    				align : 'center',
    				pack : 'start', 
    				type : 'column'
    			},
    			margin: marginPanel,
    			width: 100,
    			height:100,
    			items:[{
    				xtype: 'button',
    				iconCls: imgSrcCss,
    				flex: 1,
    				portalName: obj.portalName,
    				portalId: obj.id,
    				itemId:'portlLoginIcon',
    				height: 'auto',
    				minHeight: 65,
    				scale : 'huge',
    				listeners: {
    					focus: function(field) {

    						field.el.addCls("portalIconBackgroundChangeonTab");
    					},
    					blur: function(field){
    						field.el.removeCls("portalIconBackgroundChangeonTab");
    					}
    				},
    				handler: function(btn){
    					portalId = btn.portalId;
    					selectportalwindow = btn.up('selectportalwindow');
    					me.getFeaturePrivileges(me,portalId,false,selectportalwindow);
                        me.getDefaultCountryCode();
    				}
    			},{
    				xtype: 'label',
    				text: obj.portalName,
    				style: {width: '100%', 'text-align': 'center','margin-top':'5px'}
    			}]
    		});
    		i = i+1;
    	});
    	this.getStore('authentication.PortalStore').loadData(data);
    	viewport.doLayout();
    },*/


	loadPortal: function(this$, resetPassword, whetherChangePortal, removeform, userDetails, dynamicFormFieldLoaded) {
		var pageName, userId, applicant, currentLoggedInUser = this.getCurrentlyLoggedInUser().id;
		if (this.getCurrentLoggedPortalId() != 1) {
			setTimeout(function() {
				var component = $('[data-id="global_knowledge_base"]');
				if (component.length) {
					component[0].style.display = "none";
				}
			}, 1000);
		}

		if (Ext.isGecko) {
			$('.preloader-wrap').hide();
			$('#progress').hide();
			$('#loadingImage').hide();
		}
		var viewport = Ext.ComponentQuery.query('vp')[0];
		if (resetPassword) {
			if (removeform) {
				viewport.remove(removeform);
			}
			if (viewport) {
				viewport.destroy();
			}
			if (Ext.isDefined(Ext.ComponentQuery.query('vp2')[0])) {
				Ext.ComponentQuery.query('vp2')[0].destroy();
			}
			Ext.create('Academia.view.Viewport');
			var viewport = Ext.ComponentQuery.query('vp')[0];
			viewport.add({
				region: 'center', // center region is required, no width/height specified
				style: {
					background: '#f0f0f0'
				},
				align: 'stretch',
				xtype: 'resetpasswordform',
				cls: 'resetPasswordFormfieldsetMainForm',
				itemId: 'resetpasswordform',
				autoScroll: true
			});
			viewport.doLayout();
			var resetForm = viewport.down("#resetpasswordform");
			var user = userDetails.user;
			var academyLocationId;
			var accesibleALs = userDetails.academyLocationPrivileges;
			for (var i = 0; i < accesibleALs.length; i++) {
				if (accesibleALs[i].accessibleAcademyLocation.whetherPrimary) {
					academyLocationId = accesibleALs[i].accessibleAcademyLocation.academyLocationId;
				}
			}
			resetForm.down("#userCode").setValue(user.code);
			resetForm.down("#userName").setValue(user.firstName + " " + user.lastName);
			resetForm.down("#userEmailId").setValue(user.emailId);
			this$.getAcademyLocationLogoForRestPasswordForm(academyLocationId);
			$('#progress').hide();
		} else {
			if (whetherChangePortal) {
				viewport = Ext.ComponentQuery.query('vp2')[0];
			}
			if (viewport) {
				viewport.destroy();
			}
			if (Ext.isDefined(Ext.ComponentQuery.query('vp2')[0])) {
				Ext.ComponentQuery.query('vp2')[0].destroy();
			}
			Ext.create('Academia.view.Viewport2');

			var userInfo = Academia.model.authentication.UserInfoModel;
			portalId = userInfo.get("portalId");
			if (portalId == 2) {
				var facultyPortalController = this$.getController('Academia.controller.portal.FacultyPortalController');
				facultyPortalController.getloggedInFacultyDetails();
				var userinfo = this.getUserInfo();
				userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(false);
			}
			else if (portalId == 3) {
				var controller = this$.getController('Academia.controller.portal.StudentPortalController');
				//controller.getloggedInStudentDetails();	//commented by Raghavendra.Soni, direct writing code in getLoadStudentDetailForSP
				controller.getLoadStudentDetailForSP();		//renamed by Raghavendra.Soni, Same name used in faculty and parent controller
				var userinfo = this.getUserInfo();
				userinfo.down('#userInfoButton').down('#changeAcademyLocOption').setVisible(false);
				userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(false);
				userinfo.down('#userInfoButton').down('#changePortal').setVisible(false);
				userinfo.down('#userInfoButton').down('#releaseNote').setVisible(false);
				userinfo.down('#userInfoButton').down('#bottomLineFirstId').setVisible(false);
				controller.loadPreRegistrationWin();
			}
			else if (portalId == 7) {
				var controller = this$.getController('Academia.controller.portal.ParentPortalController');
				controller.getLoadStudentDetail();
				controller.getloggedInStudentDetails();
				var user = this$.getCurrentlyLoggedInUser();
				var formFilter = this$.getNotificationSection();
				var studentDetails = this$.getCurrentlyLoggedInUserInfoForPortal();
				if (!isNullOrEmpty(studentDetails.student)) {
					var studentName = studentDetails.student.printName;
					var studentId = studentDetails.student.id;
					localStorage.setItem('studentNameWithParentName', studentName);
					localStorage.setItem('parentStudentId', studentId);
					var setHeaderParentAndStudentName = user.value + " - " + studentName;
					formFilter.down('#userNameItemId').setText(setHeaderParentAndStudentName);
				} else {
					if (!isNullOrEmpty(localStorage.getItem('studentNameWithParentName'))) {
						studentName = localStorage.getItem('studentNameWithParentName');
						var setHeaderParentAndStudentName = user.value + " - " + studentName;
						formFilter.down('#userNameItemId').setText(setHeaderParentAndStudentName);
					} else {
						formFilter.down('#userNameItemId').setText(user.value);
					}
				}
				var userinfo = this.getUserInfo();
				userinfo.down('#userInfoButton').down('#changeAcademyLocOption').setVisible(false);
				userinfo.down('#userInfoButton').down('#changePortal').setVisible(false);
				userinfo.down('#userInfoButton').down('#releaseNote').setVisible(false);
				userinfo.down('#userInfoButton').down('#bottomLineFirstId').setVisible(false);
				var userInfo = Academia.model.authentication.UserInfoModel;
				var getStudentFirstSiblingPersonId = localStorage.getItem('studentFirstSiblingPersonId');

				var loggedInParentPersonId = localStorage.getItem('loggedInParentPersonId');

				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_FIND_ASSOCITED_SIBLING_DETAILS,
					params: {
						parentPersonId: loggedInParentPersonId,
						parentUserId: userInfo.get("userId"),
						studentPersonId: getStudentFirstSiblingPersonId
					},
					method: 'GET',
					async: false,
					success: function(res, action) {
						var data = Ext.decode(res.responseText);
						if (data.length > 1) {
							userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(true);
						} else {
							userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(false);
						}
					}
				});
				//----------------------------------------V2D-63048 -----------------------------------
				// For Velocity : parentportalregistrationformwin should not be visible on Parent portal
				//-------------------------------------------------------------------------------------
				Ext.Ajax.request({
					url: SERVERURL.PATH_WHETHER_NEXTPAYMENT_SELECTION + '?studentId=' + userInfo.get("userId"),
					method: 'GET',
					success: function(res, action) {
						var data = Ext.decode(res.responseText);
						if (data != false) {
							var pWindowRef = Ext.ComponentQuery.query('parentportalregistrationformwin')[0];
							if (!pWindowRef) {
								pWindowRef = this$.showWindow('parentportalregistrationformwin');
							}
							pWindowRef.show();
							var verticalNavigationMenu = this$.getVerticalNavigationMenu();
							verticalNavigationMenu.collapse();
						}
					}
				});


			} else if (portalId == 1) {
				var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
				var isChatBotVisible = false;
				var CORE_ERP_AI_CHATBOT_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_AI_CHATBOT_PRIVILEGES');
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(academyLocationId, CORE_ERP_AI_CHATBOT_PERMISSION);

				Ext.each(permissionList, function(privilege) {
					if (privilege === 'VIEW') {
						isChatBotVisible = true;
					}
				});
				var userinfo = this.getUserInfo();
				var loggedInUser = this.getCurrentlyLoggedInUser();
				userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(false);

				window.chatbotUserContext = {
					loggedInUser: loggedInUser
				};
				if (isChatBotVisible) {
					Ext.Ajax.request({
						url: 'resources/chatbot/chatbot.html',
						success: function(response) {
							var tempDiv = document.createElement('div');
							tempDiv.innerHTML = response.responseText;

							// Append all children inside chatbot.html
							while (tempDiv.firstChild) {
								document.body.appendChild(tempDiv.firstChild);
							}

							// Dynamically load chatbot JS
							var script = document.createElement('script');
							script.src = 'resources/chatbot/chatbot.js';
							script.type = 'text/javascript';
							script.onload = function() {
								console.log('Chatbot JS loaded with user:', window.chatbotUserContext.loggedInUser);
							};
							document.body.appendChild(script);
						},
						failure: function() {
							console.error("Failed to load chatbot UI.");
						}
					});
				}
			} else if (portalId == 6 || portalId == 7) {
				var userinfo = this.getUserInfo();
				userinfo.down('#userInfoButton').down('#releaseNote').setVisible(false);
				userinfo.down('#userInfoButton').down('#bottomLineFirstId').setVisible(false);
			}

			if (isNullOrEmpty(dynamicFormFieldLoaded)) {
				var prams = null;
				this$.getDynamicForFormFieldsInfo(prams);
			}

			/*var userinfo = this.getUserInfo();
			this$.socialIntegrationCheckForMenu(userinfo);*/
			//this$.initializeAcademyLocationAndOrganization();
			this$.initializeAcademyLocationCombo();
			//If in left bar there is no link then hide left bar 
			if (this$.getVerticalNavigationMenu().items.length > 0) {
				this$.getVerticalNavigationMenu().setVisible(true);
			} else {
				this$.getVerticalNavigationMenu().setVisible(false);
			}

			if (portalId == 6) {
				var userinfo = this.getUserInfo()
				userinfo.down('#userInfoButton').down('#changeAcademyLocOption').setVisible(false);
				userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(false);
				this$.loadApplicantPortal();
				this$.findAllCustomTableConfiguration();
			}
			if (portalId == 1) {
				pageName = 'adminPortal';
            	if (typeof handleUIChoice === "function") {
                    handleUIChoice();
                }
			} else if (portalId == 2) {
				pageName = 'teacherPortal';
			} if (portalId == 3) {
				pageName = 'studentPortal';
			} if (portalId == 6) {
				pageName = 'applicantPortal';
			} if (portalId == 7) {
				pageName = 'parentPortal';
			}

			if (portalId == 6) {
				applicant = currentLoggedInUser;
				userId = null;
			} else {
				userId = currentLoggedInUser;
				applicant = null;
			}
			Ext.Ajax.request({
				url: SERVERURL.PATH_FIND_ACCEPT_TERMS_AND_CONDITIONS,
				method: 'GET',
				params: {
					pageName: pageName,
					userId: userId,
					externalUserId: applicant
				},
				success: function(res, action) {
					var data = res.responseText;
					if (data == 'true') {
						var termsandconditionsformwin = Ext.ComponentQuery.query('termsandconditionsformwin')[0];
						if (!termsandconditionsformwin) {
							termsandconditionsformwin = this$.showWindow('termsandconditionsformwin');
						}
					} else if (data == 'CSM_DROPDOWN_IS_NOT_DEFINED') {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CSM_DROPDOWN_IS_NOT_DEFINED'));
						this$.generalSurveyWindow();
					} else {
						this$.generalSurveyWindow();
					}
				}
			});
		}
		if (!resetPassword) {
			setTimeout(function() {
				this$.loadDashbordScreen();
				if (portalId == 3 || portalId == 7) {
					this$.loadCourseRegistrationScreen();
					try {
						var allBtns = Ext.Array.pluck(Ext.Array.pluck(Ext.ComponentQuery.query('#searchComboBox')[0].store.data.items, 'data'), 'menuId');
						Ext.each(allBtns, function(currentBtn) {
							try {
								var currentBtnComponent = Ext.getCmp(currentBtn.replace('-btnInnerEl', ''));
								if (currentBtnComponent.dataObj.launchView == "stcpncstudentregistration") {
									try {
										currentBtnComponent.fireEvent('click', currentBtnComponent);
									}
									catch (e) {
										$("#" + currentBtn)[0].click();
									}
								}
								return;
							}
							catch (e) {
								//--
							}
						});
					}
					catch (e) {
						//--
					}
				}
			}, 500);

		}
	},

	loadDashbordScreen: function() {
		if (portalId == 3) {
			var MY_DASHBOARD_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_MY_DASHBOARD_PRIVILEGES');
		} else if (portalId == 7) {
			var MY_DASHBOARD_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_MY_DASHBOARD_PRIVILEGES');
		} else if (portalId == 2) {
			var MY_DASHBOARD_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_MY_DASHBOARD_PRIVILEGES');
		} else {
			var MY_DASHBOARD_PERMISSION = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MY_DASHBOARD_PRIVILEGES');
		}
		var associatedAcadLocationIds = new Array(), userinfo = this.getUserInfo(), showMyDashbod = false, this$ = this, showChangePassword = false, showGoogleTranslation = false;
		var permission = this.getCurrentAcademyLocation();
		if (!permission) {
			return;
		}
		associatedAcadLocationIds.push(permission);
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, MY_DASHBOARD_PERMISSION);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				this$.openTab(getCommonTranslation('MY_DASHBOARD'), 'dashboardhomepage', CONSTANTS.MENU_COLOR_TWO, null, null, true);
				showMyDashbod = true;
			} else if (privilege === 'CHANGE_PASSWORD') {
				showChangePassword = true;
			} else if (privilege === 'GOOGLE_TRANSLATION') {
				showGoogleTranslation = true;
			}
		});
		userinfo.down('#userInfoButton').down('#myDashboard').setVisible(showMyDashbod);
		userinfo.down('#userInfoButton').down('#changePasswordLink').setVisible(showChangePassword);
		userinfo.down('#userInfoButton').down('#translateWithGoogle').setVisible(showGoogleTranslation);
	},
	findAllCustomTableConfiguration: function() {
		setTimeout(function() {
			Ext.Ajax.request({
				url: SERVERURL.FIND_ALL_CUSTOM_TABLE_CONFIGURATION,
				method: 'GET',
				async: false, // here async is false because of applicant portal is not reflecting with custom data when first time applicant log-in 
				success: function(response) {
					var responseData = Ext.decode(response.responseText);
					var customFieldDataModel = Academia.model.customfields.CustomFieldDataModel;
					customFieldDataModel.customFieldData = responseData;
				},
				failure: function(response) {
					status = false;
				}
			});
		}, 500);
	},

	/**
	 * Method for Loading Academy Locations in Academy Location Combo(In Notification Panel)
	 * @author akshay.kalbhor
	 */
	initializeAcademyLocationCombo: function() {
		var me = this;
		me.loadUserLanguages();
		me.getMessageCount(me);
		if (this.getNotificationSection()) {
			var cmbGlobalAcademyLocation = this.getNotificationSection().down('#cmbGlobalAcademyLocation');
			if (cmbGlobalAcademyLocation) {
				var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
				var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();
				var whetherPrimaryFlag = false;
				var primaryAcadLoc = null;
				var loadedAcademiLocIdLogo = 0;
				/*
				 * iterate on the academy location privilege list for each academyLocationPrivilege
				 * check if it is primary or no
				 * get the academy location id if it is primary
				 */

				Ext.each(academyLocationPrivilegeList, function(acadLocPrivileg) {
					if (!isNullOrEmpty(acadLocPrivileg.accessibleAcademyLocation.whetherPrimary)) {
						if (acadLocPrivileg.accessibleAcademyLocation.whetherPrimary) {
							primaryAcadLoc = acadLocPrivileg.accessibleAcademyLocation.academyLocationId;
							whetherPrimaryFlag = true;
							var param = new Object();
							param.academyLocationId = primaryAcadLoc;
							/*
							 * Call to fetch the logo of the selected academy location
							 */
							if (localStorage.getItem('academylocationid')) {
								selectedAcademyLocationId = parseInt(localStorage.getItem('academylocationid'));
								param.academyLocationId = selectedAcademyLocationId;
							}
							else {
								selectedAcademyLocationId = param.academyLocationId;
							}
							if (loadedAcademiLocIdLogo != param.academyLocationId) {
								loadedAcademiLocIdLogo = param.academyLocationId;
								if (portalId == 7 && !isNullOrEmpty(localStorage.getItem('studentAL'))) {
									var displayName = me.getAcademyLocationDisplayName(localStorage.getItem('studentAL'));
									me.getAcademyLocationLogo(localStorage.getItem('studentAL'), displayName);
									Ext.getBody().unmask();
								} else {
									var displayName = me.getAcademyLocationDisplayName(selectedAcademyLocationId);
									me.getAcademyLocationLogo(param.academyLocationId, displayName);
								}
								me.updateAcademyLocationId(param);
							}
						}
					}
				});

				/*
				 * if none of the academylocation is primary then take the academyLocationId of the zeroth record.
				 * set it as the selected record of the academy location combo.
				 */
				var displayName = '';
				if (!whetherPrimaryFlag) {
					if (academyLocationPrivilegeList.length > 0) {
						primaryAcadLoc = academyLocationPrivilegeList[0].accessibleAcademyLocation.academyLocationId;
						var param = new Object();
						param.academyLocationId = primaryAcadLoc;
						/*
						 * Call to fetch the logo of the selected academy location
						 */
						if (localStorage.getItem('academylocationid')) {
							selectedAcademyLocationId = parseInt(localStorage.getItem('academylocationid'));
							param.academyLocationId = selectedAcademyLocationId;
						}
						else {
							selectedAcademyLocationId = param.academyLocationId;
						}
						if (loadedAcademiLocIdLogo != param.academyLocationId) {
							loadedAcademiLocIdLogo = param.academyLocationId;
							if (portalId == 7 && !isNullOrEmpty(localStorage.getItem('studentAL'))) {
								var displayName = me.getAcademyLocationDisplayName(localStorage.getItem('studentAL'));
								me.getAcademyLocationLogo(localStorage.getItem('studentAL'), displayName);
								Ext.getBody().unmask();
							} else {
								var displayName = this.getAcademyLocationDisplayName(selectedAcademyLocationId);
								me.getAcademyLocationLogo(param.academyLocationId, displayName);
							}
							me.updateAcademyLocationId(param);
						}
					}
				}

				/**
				 * @translation changes
				 */
				Ext.each(academyLocationPrivilegeList, function(acadLocPrivileg) {
					if (acadLocPrivileg.accessibleAcademyLocation.academyLocationId == parseInt(localStorage.getItem('academylocationid'))) {
						primaryAcadLoc = acadLocPrivileg.accessibleAcademyLocation.academyLocationId;
						var param = new Object();
						param.academyLocationId = primaryAcadLoc;
						/*
						 * Call to fetch the logo of the selected academy location
						 */
						if (localStorage.getItem('academylocationid')) {
							selectedAcademyLocationId = parseInt(localStorage.getItem('academylocationid'));
							param.academyLocationId = selectedAcademyLocationId;
						}
						else {
							selectedAcademyLocationId = param.academyLocationId;
						}
						if (isNullOrEmpty(displayName)) {
							if (loadedAcademiLocIdLogo != param.academyLocationId) {
								loadedAcademiLocIdLogo = param.academyLocationId;
								if (portalId == 7 && !isNullOrEmpty(localStorage.getItem('studentAL'))) {
									var displayName = me.getAcademyLocationDisplayName(localStorage.getItem('studentAL'));
									me.getAcademyLocationLogo(localStorage.getItem('studentAL'), displayName);
									Ext.getBody().unmask();
								} else {
									var displayName = me.getAcademyLocationDisplayName(selectedAcademyLocationId);
									me.getAcademyLocationLogo(param.academyLocationId, displayName);
								}
								me.updateAcademyLocationId(param);
							}
						}

					}
				});
				if (!isNullOrEmpty(academyLocationList)) {
					cmbGlobalAcademyLocation.getStore().loadData(academyLocationList);
				}
				if (!isNullOrEmpty(primaryAcadLoc)) {
					cmbGlobalAcademyLocation.setValue(primaryAcadLoc);
				}
			}
			/*
			 * Call to bring the User Image and set it in the Header 
			 */
			var userObj = this.getCurrentlyLoggedInUserWithPersonId();
			if (portalId == 7) {
				var personIdForHDIMGLocalStorage = localStorage.getItem('personIdForHDIMG');
				if (isNullOrEmpty(personIdForHDIMGLocalStorage) || (userObj.personId != personIdForHDIMGLocalStorage)) {
					localStorage.setItem('personIdForHDIMG', userObj.personId);
				}
				var getpersonIdForHDIMGLocalStorage = localStorage.getItem('personIdForHDIMG');
				this.getUserImage(getpersonIdForHDIMGLocalStorage, userObj.value);
			} else {
				this.getUserImage(userObj.personId, userObj.value);
			}
			var userInfo = Academia.model.authentication.UserInfoModel;
			portalId = userInfo.get("portalId");
			if (portalId == 1) {
				var validityType = new Array();
				var message = '';
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_GET_NOOFDAYS_FOREXPIRY,
					method: 'GET',
					async: false,
					success: function(response) {
						var responseResult = Ext.decode(response.responseText);
						/*if(responseResult[0].HOSTING_VALIDITY <= 30){
								message = message+getCommonTranslation('HOSTING_VALIDITY_MESSAGE')+' '+responseResult[0].HOSTING_VALIDITY+' days. <br>';
							}
							if(responseResult[1].AMC_VALIDITY<=30){
								if(responseResult[1].AMC_VALIDITY<=0)
									message = message+getCommonTranslation('AMC_EXPIRE_MESSAGE')+'<br>';
								else
									message = message+getCommonTranslation('AMC_MESSAGE')+' '+responseResult[1].AMC_VALIDITY+' days. <br>';

							}
							if(responseResult[2].APP_VALIDITY <=30){
								message = message+getCommonTranslation('APPLICATION_VALIDITY_MESSAGE')+' '+responseResult[2].APP_VALIDITY+' days. <br>';
							}*/
						if (responseResult[0].HOSTING_VALIDITY == "Hosting validity about to expire") {
							//message = getCommonTranslation('CONTACT_ADMIN_MESSAGE');
							message = getCommonTranslation('HOSTING_VALIDITY_ABOUT_TO_EXPIRE');
							showWarningMessage(getCommonTranslation('ATTENTION'), message);
						}
						if (responseResult[0].HOSTING_VALIDITY == "Hosting validity expired") {
							message = getCommonTranslation('HOSTING_VALIDITY_ALREADY_EXPIRED');
							showWarningMessage(getCommonTranslation('ATTENTION'), message);
						}

						if (responseResult[1].AMC_VALIDITY == "AMC validity about to expire") {
							message = getCommonTranslation('AMC_VALIDITY_ABOUT_TO_EXPIRE');
							showWarningMessage(getCommonTranslation('ATTENTION'), message);
						}
						if (responseResult[1].AMC_VALIDITY == "AMC validity expired") {
							message = getCommonTranslation('AMC_VALIDITY_ALREADY_EXPIIRED');
							showWarningMessage(getCommonTranslation('ATTENTION'), message);
						}

						if (responseResult[2].APP_VALIDITY == "Application validity about to expire") {
							message = getCommonTranslation('APPLICATION_VALIDITY_ABOUT_TO_EXPIRED');
							showWarningMessage(getCommonTranslation('ATTENTION'), message);
						}
						if (responseResult[2].APP_VALIDITY == "Application validity expired") {
							message = getCommonTranslation('APPLICATION_VALIDITY_ALREADY_EXPIRED');
							showWarningMessage(getCommonTranslation('ATTENTION'), message);
						}
					}
				});
			}

		}
	},
	setDefaultHeaders: function(response) {
		var json = JSON.parse(response.responseText);
		if (Ext.Ajax.defaultHeaders && (json.access_token == Ext.Ajax.defaultHeaders.access_token)) {
			localStorage.setItem('loadingMessage', 'Please wait while the system is initializing...');
		} else {
			localStorage.setItem('loadingMessage', 'Login successful! Please wait while the system is initializing...');
		}
		Ext.Ajax.defaultHeaders = {
			Authorization: "Bearer " + json.access_token,
			expires_in: json.expires_in,
			access_token: json.access_token,
			refresh_token: json.refresh_token
		};
		var userInfo = Academia.model.authentication.UserInfoModel;

		userInfo.set("accessToken", json.access_token);
		userInfo.set("refreshToken", json.refresh_token);
		userInfo.set("expiryTimeForAccessToken", json.expires_in);

		localStorage.setItem('tokenApiResponse', Ext.encode(Ext.Ajax.defaultHeaders));
	},

	/**
	 * Method to process the form field information.
	 * This function will call at login time and AL combo change. 
	 * @author Rajkumar.patidar
	 */
	getDynamicForFormFieldsInfo: function(params) {

		var academyLocationId = 0;
		if (isNullOrEmpty(params)) {
			var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();
			academyLocationId = academyLocationPrivilegeList[0].accessibleAcademyLocation.academyLocationId;
		} else {
			academyLocationId = params.academyLocationId;
		}
		if (portalId == 6) {
			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
			if (isNullOrEmpty(fieldInfo.data.formFieldsInfo)) {
				Ext.Ajax.request({
					url: SERVERURL.COMMON_FORM_FIELD_INFO,
					method: 'GET',
					async: false,
					params: {
						academyLocationId: academyLocationId,
						languageCode: 'en'
					},
					success: function(response) {
						var json = JSON.parse(response.responseText);
						fieldInfo.set("formFieldsInfo", json);
					}
				});
			}
		} else {
			Ext.Ajax.request({
				url: SERVERURL.COMMON_FORM_FIELD_INFO,
				method: 'GET',
				async: false,
				params: {
					academyLocationId: academyLocationId,
					languageCode: 'en'
				},
				success: function(response) {
					var json = JSON.parse(response.responseText);
					var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
					fieldInfo.set("formFieldsInfo", json);
				}
			});
		}
	},

	/**
	   * Method to load the menu by academyLocation.
	   * get the value of the selected academy location and calls the loadSystemMenu.
	   * @author akshay.kalbhor
	   */
	loadMenuByAcademyLocation: function(selectedAcademyLocation) {
		var me = this;
		if (!isNullOrEmpty(selectedAcademyLocation)) {
			var param = new Object();
			param.academyLocationId = selectedAcademyLocation;

			var academyLocationPrivilegesArray = Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges();
			me.onChangeAcademyLocationByCombo(selectedAcademyLocation);
			var returnVal = this.updateAcademyLocationId(param);
			if (returnVal) {
				me.loadSystemMenu(academyLocationPrivilegesArray, selectedAcademyLocation);
			}
			this.getDynamicForFormFieldsInfo(param);

			var userinfo = this.getUserInfo();
			if (portalId == 7) {
				userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(true);
			} else {
				userinfo.down('#userInfoButton').down('#changeStudentLink').setVisible(false);
			}

			this.socialIntegrationCheckForMenu(userinfo);
		}
	},

	updateAcademyLocationId: function(academyLocation) {
		var me = this;
		var isSuccess = false;
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.UPDATE_CURRENT_ACADEMY_LOCATION,
			method: 'GET',
			async: false,
			params: academyLocation,
			success: function(response, form, action) {
				var data = Ext.decode(response.responseText);
				if (data) {
					isSuccess = true;
					me.setUnloadMessage();
				} else {
					me.logOutUser();
				}
			},
			failure: function(response, form, action) {
				if (response.status != 401) {
					me.logOutUser();
				}
			}
		});
		return isSuccess;
	},

	setUnloadMessage: function() {
		var this$ = this;
		Ext.Ajax.request({
			method: 'GET',
			corsSupport: true,
			url: SERVERURL.ORGINFOLOADREQUEST,
			success: function(response) {
				if (response.responseText != null && response.responseText != "") {
					var data = JSON.parse(response.responseText);
					if (data.onUnloadMsgRequired) {
						window.onbeforeunload = function() {
							return "Are you sure you want to leave this page?";
						};
					}
				}
			}
		});
	},

	/**
  * method to load the systems menu according to the primary academy location id, 
  * and as per the academy location change in the headers academylocationDropdown.
  * @author akshay.kalbhor
  */
	loadSystemMenu: function(academyLocationPrivilegesArray, selectedAcademyLocation) {
		var MegaMenuModel = Academia.model.menu.MegaMenuDataModel;
		var whetherPrimaryFlag = false;
		var this$ = this;
		/*
		 * when the call is after the selection of the AcademyLocation combo then the selectedAcademyLocation is present
		 * else null.
		 */
		if (!isNullOrEmpty(selectedAcademyLocation)) {
			Ext.each(academyLocationPrivilegesArray, function(acadLocationPrivilege) {
				if (acadLocationPrivilege.accessibleAcademyLocation.academyLocationId != null) {
					if (acadLocationPrivilege.accessibleAcademyLocation.academyLocationId === selectedAcademyLocation) {
						MegaMenuModel.menuData = acadLocationPrivilege.systemMenuHierachyModels;

						var viewport = Ext.ComponentQuery.query('vp2')[0];
						if (viewport) {
							viewport.destroy();
							Ext.create('Academia.view.Viewport2');
						}
						var combo = this$.getNotificationSection().down('customcombobox#cmbGlobalAcademyLocation');
						combo.setValue(selectedAcademyLocation);
					}
				}
			});
		} else {

			Ext.each(academyLocationPrivilegesArray, function(acadLocationPrivilege) {
				if (acadLocationPrivilege.accessibleAcademyLocation.whetherPrimary != null) {
					if (acadLocationPrivilege.accessibleAcademyLocation.whetherPrimary) {
						MegaMenuModel.menuData = acadLocationPrivilege.systemMenuHierachyModels;
						whetherPrimaryFlag = true;
					}
				} else {
					whetherPrimaryFlag = false;
				}
			});

			if (!whetherPrimaryFlag) {
				if (academyLocationPrivilegesArray.length > 0) {
					MegaMenuModel.menuData = academyLocationPrivilegesArray[0].systemMenuHierachyModels;
				}
			}

			/**
			 * @ravi.patidar
			 */

			Ext.each(academyLocationPrivilegesArray, function(acadLocationPrivilege) {
				if (acadLocationPrivilege.accessibleAcademyLocation.academyLocationId == parseInt(localStorage.getItem('academylocationid'))) {
					MegaMenuModel.menuData = acadLocationPrivilege.systemMenuHierachyModels;
				}
			});
		}
	},

	/**
	 * Method to send an AJAX request for changing/resetting the password on click of the SUBMIT button.
	 * @param {String} A value to identify the calling functionality, 'CHANGE' in case of a call from the change password
	 * functionality, else can be null 'RESET'.
	 */
	resetOrChangePassword: function(resetOrChangeFlag) {
		var passwordForm = null;
		var resetPasswordFormValues = null;
		var changePasswordWindow = null;
		var me = this;
		me.isRequestSent = false;
		if (resetOrChangeFlag === 'CHANGE') {
			changePasswordWindow = this.getChangePasswordWindow(); this.getChangePasswordWindow();
			passwordForm = changePasswordWindow.down('form');
			resetPasswordFormValues = passwordForm.getValues();
		} else {
			passwordForm = this.getResetPasswordForm();
			resetPasswordFormValues = passwordForm.getForm().getValues();
		}

		var serverUrl = SERVERURL.RESET_PASSWORD;

		resetPasswordFormValues.currentPassword = me.encryptPassword(resetPasswordFormValues.currentPassword);
		resetPasswordFormValues.newPassword = me.encryptPassword(resetPasswordFormValues.newPassword);
		resetPasswordFormValues.confirmedPassword = me.encryptPassword(resetPasswordFormValues.confirmedPassword);

		// check for applicant portal user
		var userInfo = Academia.model.authentication.UserInfoModel;
		portalId = userInfo.get("portalId");
		if (portalId == 6) {
			userId = userInfo.get("externalUserId");
			resetPasswordFormValues.id = userId;
			serverUrl = SERVERURL.RESET_PASSWORD_EXTERNAL_USER;
		}
		// End

		if (passwordForm) {
			if (!isEmpty(resetPasswordFormValues)) {
				var jsonFormatFormData = Ext.encode(resetPasswordFormValues);

				this.sendSaveAjaxRequest(serverUrl, 'POST', jsonFormatFormData, function(opt, success, response) {
					if (success) {
						localStorage.setItem('isPasswordResetSuccessfully', 1);
						if (resetOrChangeFlag === 'CHANGE') {
							changePasswordWindow.close();

							Ext.MessageBox.show({
								title: getCommonTranslation('SUCCESS'),
								msg: getCommonTranslation('CHANGE_PASSWORD_SUCCESS'),
								buttons: Ext.MessageBox.OK,
								icon: Ext.Msg.INFO,
								closable: false,
								cls: 'successMessageBox successIconSetting commonMsgBoxCls',
								fn: function(btn, text) {
									if (btn == 'ok') {
										/*
										 * call to force logout the user.
										 */
										me.logOutUser();
									}
								}
							});
							//showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('CHANGE_PASSWORD_SUCCESS'));

						} else {
							var data = Ext.decode(response.responseText);
							if (data == true) {
								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RESET_PASSWORD_SUCCESS'));

								/*me.loadPortal(me);
								me.initializeAcademyLocationAndOrganization();*/
								window.location.reload();
							}
						}
					} else {
						var res = Ext.decode(response.responseText)
						if (res[0].key.includes("PASSWORD_IN_USE")) {
							//showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation(res[0].key)); V2D-329391 ALert message handled from backend(Translation will be managed from ERRORMESSAGE Object)
						} else if (res[0].key.includes("current_password_not_matching")) {
							//showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation(res[0].key));
						}
					}
					if (me.getChangePasswordWindow() && me.getChangePasswordWindow().down('#btnSavePassword'))
						me.getChangePasswordWindow().down('#btnSavePassword').setDisabled(false);

					if (me.getResetPasswordForm() && me.getResetPasswordForm().down('#btnSavePassword'))
						me.getResetPasswordForm().down('#submitBtn').setDisabled(false);
				});
			}
		}
	},
	returnLoginPage: function() {
		localStorage.clear();
		window.location.reload();
	},
	/**
	 * method to show the change password window on selection of the change password.
	 * @author Akshay.Kalbhor
	 */
	changePassword: function() {
		if (!Ext.ComponentQuery.query('changepasswordwindow')[0]) {
			this.showWindow('changepasswordwindow');
		} else {
			Ext.ComponentQuery.query('changepasswordwindow')[0].show();
		}
		var userInfo = Academia.model.authentication.UserInfoModel;
		portalId = userInfo.get("portalId");

		//if(portalId!=6){ // commented for V2D-344906
		var verticalNavigationMenu = this.getVerticalNavigationMenu();
		verticalNavigationMenu.collapse();
		//}
	},

	/**
	 * code to logout a user.
	 * @author Akshay.Kalbhor
	 */
	logOutUser: function() {
		var me = this;
		logoutCount = 1;
		this.sendGetAjaxRequest(SERVERURL.LOGOUT, 'GET', null, function(opt, success, response) {
			Ext.defer(function() {
				var SocialIdModel = Academia.model.authentication.SocialIdModel;
				var social = SocialIdModel.get('socialValue');
				var viewport = Ext.ComponentQuery.query('vp2')[0];
				var wheatherSchool = localStorage.getItem('wheatherSchool');
				var isLoginByGoogle = localStorage.getItem('isLoginByGoogle');
				var isLoginByAzureAD = localStorage.getItem('isLoginByAzureAD');
				if (Ext.isDefined(viewport)) {
					viewport.removeAll();
				}
				var token = localStorage.getItem('google_token');
				var google_access_token = localStorage.getItem('google_access_token');
				var redirectUrl = localStorage.getItem('redirectUrl');

				localStorage.clear();
				try {
					localStorage.setItem('wheatherSchool', wheatherSchool);
				}
				catch (e) {
					localStorage.setItem('wheatherSchool', true);
				}
				if (success) {
					if (social == 'FB') {
						FB.getLoginStatus(function(response) {
							if (response.status === 'connected') {
								FB.logout(function(response) { });
							}
						});
						var vp1 = Ext.create('Academia.view.Viewport');
						Ext.resumeLayouts(true);
					} else if (isLoginByGoogle) {
						/*If user login by Google SignIn Button then logout code added*/
						localStorage.setItem('isLoginByGoogle', false);
						var url = "https://oauth2.googleapis.com/revoke?token=" + google_access_token;
						$.ajax({
							type: 'POST',
							url: url,
							async: false,
							//contentType: "application/x-www-form-urlencoded",
							success: function(response) {
								console.log(response);
								window.location = redirectUrl;
								//window.location.reload();
							},
							error: function(e) {
								console.log(e);
								window.location = redirectUrl;
								//window.location.reload();
							}
						});
						//var url = "https://accounts.google.com/o/oauth2/revoke?token="+token;
						//window.location="https://www.google.com/accounts/Logout?continue=https://appengine.google.com/_ah/logout?continue=" + redirectUrl;
					} else if (isLoginByAzureAD) {
						/*If user login by Google SignIn Button then logout code added*/
						localStorage.setItem('isLoginByAzureAD', false);
						window.location.reload();
					} else {
						window.location.reload();
					}
				}
				else {
					window.location.reload();
				}
			}, 1550, this);
		});
	},

	/**
	 * @author Akshay.Kalbhor
	 */
	checkPasswordValidity: function(textfield) {
		var text = textfield.getValue();
		var encrypt = new JSEncrypt();
		//		var rawPassword = $('#password')[0].value;
		encrypt.setPublicKey(CONST.PUBLIC_KEY_FOR_AUTENTICATION);
		var encrypted = encrypt.encrypt(text);
		params = {
			password: encrypted
		};
		this.sendGetAjaxRequest(SERVERURL.CHECK_PASSWORD_VALIDITY, 'GET', params, function(opt, success, response) {
			if (success) {
				var value = Ext.decode(response.responseText);
				if (value === false) {
					var passwordpolicy = getCommonTranslation('PASSWORD_DOES_NOT_MATCHED');
					textfield.markInvalid(passwordpolicy);
					textfield.nextSibling().reset();
				}
				textfield.nextSibling().reset();
			}
		});
	},

	/***************START: Alerts and Notification**************************/

	nextPreviousButtonClick: function(button, action) {

		var me = this;
		var activityfeedTab = button.up('activityfeeds');
		if (portalId == 6) {
			var activityFeedListGrid = activityfeedTab.down("#activityFeedTypeGridForApplicant");
		} else {
			var activityFeedListGrid = activityfeedTab.down("#activityFeedTypeGrid");
		}

		var activityFeedDisplayTemplate = activityfeedTab.down("#activityFeedDisplayTemplate");

		if (activityFeedListGrid && activityFeedDisplayTemplate) {


			var store = activityFeedListGrid.getStore();
			var selectedRecord = activityFeedListGrid.getSelectionModel().getSelection()[0];
			var activityFeedTemplateFormPanel = activityFeedDisplayTemplate.down("#activityFeedTemplateButtonPanel");
			var activityFeedDisplayView = activityFeedDisplayTemplate.down("#activityFeedDisplayView");
			//var btnPrevious=activityFeedDisplayTemplate.down("#btnPrevious");
			//var btnNext=activityFeedDisplayTemplate.down("#btnNext");    		

			if (store && !isEmpty(selectedRecord)) {
				var selectedRecordIndex = store.indexOf(selectedRecord);
				//var selectedRecordIndex=selectedRecord.index;
				var newRecord = null;
				var isDisplayNewRecord = false;
				if (action == 0) {											 // 0 means NEXT Button Clicked
					var newRecordIndex = selectedRecordIndex + 1;
					if (newRecordIndex == store.getCount()) {
						//	btnPrevious.setDisabled(false);
						//btnNext.setDisabled(true);
					} else {
						newRecord = store.getAt(newRecordIndex);
						isDisplayNewRecord = true;
						//btnPrevious.setDisabled(false);
						if (newRecordIndex == (store.getCount() - 1)) {
							//		btnNext.setDisabled(true);
						}
					}
				} else if (action == 1) { 									// 1 means PREVIOUS Button Clicked
					var newRecordIndex = selectedRecordIndex - 1;
					if (newRecordIndex == -1) {
						//	btnPrevious.setDisabled(true);
						//btnNext.setDisabled(false);
					} else {
						newRecord = store.getAt(newRecordIndex);
						isDisplayNewRecord = true;
						//btnNext.setDisabled(false);
						if (newRecordIndex == 0) {
							//btnPrevious.setDisabled(true);
						}
					}
				}

				if (isDisplayNewRecord && !isEmpty(newRecord)) {

					if (!isEmpty(newRecord.data) && !newRecord.get("whetherRead")) {
						var messageId = newRecord.get("messageId");
						if (!isNullOrEmpty(messageId)) {
							var submitUrl = SERVERURL.CHANGE_ALERT_NOTIFICATION_STATUS;
							submitUrl = submitUrl.concat("?messageId=" + messageId);
							Ext.Ajax.request({
								type: 'rest',
								url: submitUrl,
								method: 'PUT',
								success: function(response, form, action) {
									me.getMessageCount(me);
								}
							});
						}
					}

					var templateDataArray = new Array();
					templateDataArray.push(newRecord.data);
					activityFeedDisplayView.getStore().loadData(templateDataArray);
					activityFeedListGrid.getSelectionModel().select(newRecord);
					var downloadAttachment = me.getDownloadAttachment();
					var displayField = downloadAttachment.down('#attachmentId');
					if (newRecord.data) {
						var whetherAttachement = newRecord.data.whetherAttachement;
						if (whetherAttachement) {
							me.showFileNameForAlertNotification(downloadAttachment, newRecord, displayField);
						} else {
							downloadAttachment.setVisible(false);
						}
					}
					if (activityFeedTemplateFormPanel && !isNullOrEmpty(newRecord.get('messageId'))) {
						activityFeedTemplateFormPanel.down("#messageId").setValue(newRecord.get('messageId'));
					}
				}

			}
		}
	},

	nextPreviousEnableDisable: function(activityfeedPanel, selectedRecord) {

		var activityfeedTab = activityfeedPanel.up('activityfeeds');
		if (portalId == 6) {
			var activityFeedListGrid = activityfeedTab.down("#activityFeedTypeGridForApplicant");
		} else {
			var activityFeedListGrid = activityfeedTab.down("#activityFeedTypeGrid");
		}
		var activityFeedDisplayTemplate = activityfeedTab.down("#activityFeedDisplayTemplate");

		if (activityFeedListGrid && activityFeedDisplayTemplate) {

			var btnPrevious = activityFeedDisplayTemplate.down("#btnPrevious");
			var btnNext = activityFeedDisplayTemplate.down("#btnNext");
			var store = activityFeedListGrid.getStore();

			if (store && !isEmpty(selectedRecord)) {
				activityFeedListGrid.getSelectionModel().select(selectedRecord);
				if ((selectedRecord.index == 0) && (store.getCount() == 1)) {
					btnPrevious.setDisabled(true);
					btnNext.setDisabled(true);
				} else if ((selectedRecord.index == 0) && (store.getCount() > 1)) {
					btnPrevious.setDisabled(true);
					btnNext.setDisabled(false);
				} else if ((selectedRecord.index == (store.getCount() - 1)) && (store.getCount() > 1)) {
					btnPrevious.setDisabled(false);
					btnNext.setDisabled(true);
				} else {
					btnPrevious.setDisabled(false);
					btnNext.setDisabled(false);
				}
			}
		}
	},
	openActivityTab: function(whetherClickOnViewAll, selectedRecord) {
		var me = this;
		var notificationalertwindow = Ext.getCmp("NotificationAlertWindow");
		if (notificationalertwindow) {
			var headerRegionDiv = notificationalertwindow.down('#headerRegion');
			if (headerRegionDiv) {
				var type = headerRegionDiv.config.type;
				if (!isNullOrEmpty(type)) {
					var activityfeedTab = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));
					if (activityfeedTab) {
						me.closeTab(activityfeedTab);
					}
					activityfeedTab = me.openTab(getCommonTranslation('ACTIVITY_FEEDS'), 'activityfeeds');
					var activityStore = activityfeedTab.down('grid').getStore();
					var fromAlertWin = true;
					var parent = null
					var personIdNew = null;
					if (activityStore.getCount() == 0) {
						if (portalId == 7) {

							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.FIND_PARENT_PERSON_ID + '?userId=' + localStorage.getItem('parentUserId'),
								method: 'GET',
								async: false,
								success: function(res, action) {
									personIdNew = Ext.decode(res.responseText);
								}
							});

							var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
							var user = portalInfo.student;
							var parentId = localStorage.getItem('loggedInParentPersonId');
						} else {
							var user = me.getCurrentlyLoggedInUser();
						}
						if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
							activityStore.getProxy().extraParams = {
								userId: user.id,
								messageType: CONSTANTS.NOTIFICATIONS,
								parentUserId: personIdNew
							};
							activityStore.load({
								callback: function() {
									if (activityfeedTab) {
										var radioForm = activityfeedTab.down("#radioFormId");
										//me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
										if (whetherClickOnViewAll === false) {
											me.showMessageDetailPanel(radioForm, selectedRecord, fromAlertWin);
										}
										notificationalertwindow.close();
									}
								}
							})
						}
					} else {

						if (portalId == 7) {

							Ext.Ajax.request({
								type: 'rest',
								url: SERVERURL.FIND_PARENT_PERSON_ID + '?userId=' + localStorage.getItem('parentUserId'),
								method: 'GET',
								async: false,
								success: function(res, action) {
									personIdNew = Ext.decode(res.responseText);
								}
							});

							var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
							var user = portalInfo.student;
							var parentId = localStorage.getItem('loggedInParentPersonId');


							if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
								activityStore.getProxy().extraParams = {
									userId: user.id,
									messageType: CONSTANTS.NOTIFICATIONS,
									parentUserId: personIdNew
								};
								activityStore.load({
									callback: function() {
										if (activityfeedTab) {
											var radioForm = activityfeedTab.down("#radioFormId");
											//me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
											if (whetherClickOnViewAll === false) {
												me.showMessageDetailPanel(radioForm, selectedRecord, fromAlertWin);
											}
											notificationalertwindow.close();
											var downloadAttachment = activityfeedTab.down('downloadAttachment');
											var displayField = downloadAttachment.down('#attachmentId');
											if (selectedRecord) {
												var whetherAttachement = selectedRecord.get('whetherAttachement');
												if (whetherAttachement) {
													me.showFileNameForAlertNotification(downloadAttachment, selectedRecord, displayField);
												} else {
													downloadAttachment.setVisible(false);
												}
											}
										}
									}
								})
							}
						}
						else {
							if (activityfeedTab) {
								var radioForm = activityfeedTab.down("#radioFormId");
								//me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
								if (whetherClickOnViewAll === false) {
									me.showMessageDetailPanel(radioForm, selectedRecord, fromAlertWin);
								}
								notificationalertwindow.close();
								var downloadAttachment = activityfeedTab.down('downloadAttachment');
								var displayField = downloadAttachment.down('#attachmentId');
								if (selectedRecord) {
									var whetherAttachement = selectedRecord.get('whetherAttachement');
									if (whetherAttachement) {
										me.showFileNameForAlertNotification(downloadAttachment, selectedRecord, displayField);
									} else {
										downloadAttachment.setVisible(false);
									}
								}
							}
						}
					}
				}
			}
		}
	},

	openActivityTabForApplicant: function(whetherClickOnViewAll, selectedRecord) {
		var me = this;
		var notificationalertwindow = Ext.getCmp("NotificationAlertWindow");
		if (notificationalertwindow) {
			var headerRegionDiv = notificationalertwindow.down('#headerRegion');
			if (headerRegionDiv) {
				var type = headerRegionDiv.config.type;
				if (!isNullOrEmpty(type)) {
					var activityfeedTab = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));
					if (activityfeedTab) {
						me.closeTab(activityfeedTab);
					}
					var activityfeedTab = me.openTab(getCommonTranslation('ACTIVITY_FEEDS'), 'activityfeeds');
					var activityfeedtypegrid = activityfeedTab.down('#activityFeedTypeGrid');
					activityfeedtypegrid.setVisible(false);
					var activityFeedTypeGridForApplicant = activityfeedTab.down('#activityFeedTypeGridForApplicant');
					activityFeedTypeGridForApplicant.setVisible(true);
					var activityStore = activityFeedTypeGridForApplicant.getStore();
					var fromAlertWin = true;
					if (activityStore.getCount() == 0) {
						var user = me.getCurrentlyLoggedInUser();
						var applicationId = me.loadApplicantProfile();
						if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
							activityStore.getProxy().extraParams = {
								userId: applicationId.id,
								messageType: CONSTANTS.NOTIFICATIONS,
								userType: "APPLICANT"
							};
							activityStore.load({
								callback: function() {
									if (activityfeedTab) {
										var radioForm = activityfeedTab.down("#radioFormId");
										//					                 	me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
										if (whetherClickOnViewAll === false) {
											me.showMessageDetailPanelForApplicant(radioForm, selectedRecord, fromAlertWin);
											activityFeedTypeGridForApplicant.setVisible(true);
										}
										notificationalertwindow.close();
										var downloadAttachment = activityfeedTab.down('downloadAttachment');
										var displayField = downloadAttachment.down('#attachmentId');
										if (selectedRecord) {
											var whetherAttachement = selectedRecord.get('whetherAttachement');
											if (whetherAttachement) {
												me.showFileNameForAlertNotification(downloadAttachment, selectedRecord, displayField);
											} else {
												downloadAttachment.setVisible(false);
											}
										}
									}
								}
							})
						}
					} else {
						if (activityfeedTab) {
							var radioForm = activityfeedTab.down("#radioFormId");
							//me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
							if (whetherClickOnViewAll === false) {
								me.showMessageDetailPanelForApplicant(radioForm, selectedRecord, fromAlertWin);
								activityFeedTypeGridForApplicant.setVisible(true);
							}
							//	                	me.loadActivityFeedTypeGrid(activityFeedTypeGrid,type,whetherClickOnViewAll,selectedRecord);	                	  
							notificationalertwindow.close();
							var downloadAttachment = activityfeedTab.down('downloadAttachment');
							var displayField = downloadAttachment.down('#attachmentId');
							if (selectedRecord) {
								var whetherAttachement = selectedRecord.get('whetherAttachement');
								if (whetherAttachement) {
									me.showFileNameForAlertNotification(downloadAttachment, selectedRecord, displayField);
								} else {
									downloadAttachment.setVisible(false);
								}
							}
						}
					}
				}
			}
		}
	},
	tabDashletForNotification: function(whetherClickOnViewAll, selectedRecord, type) {
		var me = this;
		var notificationscountdashlet = Ext.widget("notificationscountdashlet");
		if (notificationscountdashlet) {
			if (!isNullOrEmpty(type)) {
				var activityfeedTab = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));
				if (activityfeedTab) {
					me.closeTab(activityfeedTab);
				}
				activityfeedTab = me.openTab(getCommonTranslation('ACTIVITY_FEEDS'), 'activityfeeds');
				if (activityfeedTab) {
					var radioForm = activityfeedTab.down("#radioFormId");
					//    				me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
					if (whetherClickOnViewAll === false) {
						me.showMessageDetailPanel(radioForm, selectedRecord);
					}
					var downloadAttachment = activityfeedTab.down('downloadAttachment');
					var displayField = downloadAttachment.down('#attachmentId');
					if (selectedRecord) {
						var whetherAttachement = selectedRecord.get('whetherAttachement');
						if (whetherAttachement) {
							me.showFileNameForAlertNotification(downloadAttachment, selectedRecord, displayField);
						} else {
							downloadAttachment.setVisible(false);
						}
					}
					var grid = activityfeedTab.down("activityfeedtypegrid");
					var applyButton = grid.down('#apply');
					if (applyButton) {
						applyButton.fireEvent('click')
					}
				}
			}
		}
	},
	tabDashletForAlert: function(whetherClickOnViewAll, selectedRecord, type) {
		var me = this;
		var alertscountdashlet = Ext.widget("alertcountdashlet");
		if (alertscountdashlet) {
			if (!isNullOrEmpty(type)) {
				var activityfeedTab = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));
				if (activityfeedTab) {
					me.closeTab(activityfeedTab);
				}
				activityfeedTab = me.openTab(getCommonTranslation('ACTIVITY_FEEDS'), 'activityfeeds');
				if (activityfeedTab) {
					var radioForm = activityfeedTab.down("#radioFormId");
					//    				me.loadActivityFeedTypeRadioPanel(radioForm,whetherClickOnViewAll,selectedRecord,type);
					if (whetherClickOnViewAll === false) {
						me.showMessageDetailPanel(radioForm, selectedRecord);
					}
					var downloadAttachment = activityfeedTab.down('downloadAttachment');
					var displayField = downloadAttachment.down('#attachmentId');
					if (selectedRecord) {
						var whetherAttachement = selectedRecord.get('whetherAttachement');
						if (whetherAttachement) {
							me.showFileNameForAlertNotification(downloadAttachment, selectedRecord, displayField);
						} else {
							downloadAttachment.setVisible(false);
						}
					}
				}
			}
		}
	},
	activityfeedGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		var me = this;
		var notificationDetailsWindow = Ext.widget("notificationDetailsWindow");
		me.activityFeedTypeRecordIndex = record;
		if (grid && cellIndex != 0) {
			notificationDetailsWindow.show();
			me.showMessageDetailPanel(notificationDetailsWindow, record);
			//grid.addRowCls(rowIndex, 'notificationReadCls');
			var acticityPanel = grid.up('activityfeeds');
			var messageTemplate = notificationDetailsWindow.down('activityfeeddisplaytemplate');
			var notificationEmptyMsgField = messageTemplate.down('#notificationEmptyMessageId');
			//    		messageTemplate.down('#btnPrevious').setVisible(true);
			//	messageTemplate.down('#btnNext').setVisible(true);
			notificationEmptyMsgField.setVisible(false);
			var downloadAttachment = notificationDetailsWindow.down('#downloadAttachment');
			var displayField = downloadAttachment.down('#attachmentId');
			var whetherAttachement = record.get('whetherAttachement');
			if (whetherAttachement) {
				this.showFileNameForAlertNotification(downloadAttachment, record, displayField);
			} else {
				downloadAttachment.setVisible(false);
			}
		}

	},
	activityfeedGridForApplicantCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
		var me = this;
		if (grid && (td.childElementCount > 0) && (td.children[0].childElementCount > 0) && (td.children[0].children[0].tagName === "A")) {
			me.showMessageDetailPanelForApplicant(grid, record);
			var downloadAttachment = this.getDownloadAttachment();
			var displayField = downloadAttachment.down('#attachmentId');
			var whetherAttachement = record.get('whetherAttachement');
			if (whetherAttachement) {
				this.showFileNameForAlertNotificationForApplicant(downloadAttachment, record, displayField);
			} else {
				downloadAttachment.setVisible(false);
			}
		}
	},

	/**
	 * To show file names
	 */
	showFileNameForAlertNotification: function(downloadAttachment, selectedRecord, displayField) {


		downloadAttachment.setVisible(true);
		var filePath = '';
		var fileName = '';
		var value = selectedRecord.get('msgDocuments');
		if (!isNullOrEmpty(value) && value.length > 0) {
			var attachmentContainer = downloadAttachment.down('#downloadAttachmentId');
			var obj = attachmentContainer.items.items;
			var length = obj.length;
			for (var i = 1; i < length; i++) {
				obj[obj.length - 1].destroy();
			}
			var marginTop = 0;
			var docCount = 1;
			Ext.each(value, function(values) {
				var name = values.documentName;
				if (name.length > 30) {
					name = name.substring(0, 50) + "...";
				} else {
					fileName = name;
				}
				filePath = '<tpl><div style="cursor: pointer;" class="thumb-wrap-alert"><a style="color: #000ded;" href="#" title="' + fileName + '">' + docCount + '. ' + name + '</a></div></tpl>';
				docCount++;
				var docRecord = {
					id: values.id,
					documentName: name
				};
				var store = Ext.create('Ext.data.Store', {
					extend: 'Ext.data.Store',
					fields: ['id', 'documentName'],
					data: docRecord
				});
				var personDetailsLink = Ext.create('Ext.view.View', {
					store: store,
					tpl: new Ext.XTemplate(filePath),
					itemSelector: 'div.thumb-wrap-alert',
					width: '100%',
					cls: 'personDetailViewAttachCls'
				});

				attachmentContainer.remove(displayField);
				personDetailsLink.setMargin(marginTop, 0, 0, 0);
				attachmentContainer.add(personDetailsLink);
				marginTop = marginTop + 15;
			});
		} else {
			filePath = '';
			docCount = 1;
		}
	},
	showFileNameForAlertNotificationForApplicant: function(downloadAttachment, selectedRecord, displayField) {
		downloadAttachment.setVisible(true);
		var filePath = '';
		var fileName = '';
		var value = selectedRecord.get('msgDocuments');
		if (!isNullOrEmpty(value) && value.length > 0) {
			var attachmentContainer = downloadAttachment.down('#downloadAttachmentId');
			var obj = attachmentContainer.items.items;
			var length = obj.length;
			for (var i = 1; i < length; i++) {
				obj[obj.length - 1].destroy();
			}
			var marginTop = 0;
			var docCount = 1;
			Ext.each(value, function(values) {
				var name = values.documentName;
				if (name.length > 30) {
					name = name.substring(0, 50) + "...";
				} else {
					fileName = name;
				}
				filePath = '<tpl><div style="cursor: pointer;" class="thumb-wrap-alert"><a href="#" title="' + fileName + '">' + docCount + '. ' + name + '</a></div></tpl>';
				docCount++;
				var docRecord = {
					id: values.id,
					documentName: name
				};
				var store = Ext.create('Ext.data.Store', {
					extend: 'Ext.data.Store',
					fields: ['id', 'documentName'],
					data: docRecord
				});
				var personDetailsLink = Ext.create('Ext.view.View', {
					store: store,
					tpl: new Ext.XTemplate(filePath),
					itemSelector: 'div.thumb-wrap-alert',
					width: '100%',
					cls: 'personDetailViewAttachCls'
				});

				attachmentContainer.remove(displayField);
				personDetailsLink.setMargin(marginTop, 0, 0, 0);
				attachmentContainer.add(personDetailsLink);
				marginTop = marginTop + 15;
			});
		} else {
			filePath = '';
			docCount = 1;
		}

	},

	/**
	 *This function is to download the attachment in notification  
	 */
	downloadAlertNotificationAttachment: function(record) {
		var id = record.get('id');
		var form = Ext.create('Ext.form.Panel');
		form.getForm().submit({
			target: 'download_frame',
			method: 'GET',
			params: {
				access_token: Ext.Ajax.defaultHeaders.access_token
			},
			headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
			url: SERVERURL.MESSAGING_DOWNLOAD_ATTACHMENT + id,
			standardSubmit: true
		});
	},

	showMessageDetailPanel: function(grid, record, fromAlertWin) {
		var me = this;
		var activityFeedLayOut = grid;
		if (activityFeedLayOut) {
			var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
			var activityFeedTypeGrid = grid = Ext.ComponentQuery.query('activityfeedtypegrid')[0];

			if (activityFeedDisplayTemplate) {
				//activityFeedTypeGrid.setVisible(false); 
				if (!isNullOrEmpty(fromAlertWin) && fromAlertWin)
					activityFeedDisplayTemplate.setVisible(true);
				else
					activityFeedDisplayTemplate.setVisible(true);

				var activityFeedTemplateFormPanel = activityFeedDisplayTemplate.down("#activityFeedTemplateButtonPanel");
				var activityFeedDisplayView = activityFeedDisplayTemplate.down("#activityFeedDisplayView");
				if (record !== null) {
					var notificationEmptyMsgField = activityFeedDisplayTemplate.down('#notificationEmptyMessageId');
					notificationEmptyMsgField.setVisible(false);
					//activityFeedDisplayTemplate.down('#btnPrevious').setVisible(false);
					//		    		activityFeedDisplayTemplate.down('#btnNext').setVisible(false);
					if (activityFeedDisplayView && !isEmpty(record.data)) {
						//me.nextPreviousEnableDisable(activityFeedDisplayTemplate,record);

						if (!isEmpty(record.data) && !record.get("whetherRead")) {
							var messageId = record.get("messageId");
							if (!isNullOrEmpty(messageId)) {
								var submitUrl = SERVERURL.CHANGE_ALERT_NOTIFICATION_STATUS;
								submitUrl = submitUrl.concat("?messageId=" + messageId);
								Ext.Ajax.request({
									type: 'rest',
									url: submitUrl,
									method: 'PUT',
									success: function(response, form, action) {
										me.getMessageCount(me);
										activityFeedTypeGrid.getStore().reload();
									}
								});
							}
						}

						var templateDataArray = new Array();
						templateDataArray.push(record.data);
						activityFeedDisplayView.getStore().loadData(templateDataArray);
						if (activityFeedTemplateFormPanel && !isNullOrEmpty(record.get('messageId'))) {
							activityFeedTemplateFormPanel.down("#messageId").setValue(record.get('messageId'));
						}
					}

				}
			}
		}
	},
	showMessageDetailPanelForApplicant: function(grid, record, fromAlertWin) {
		var me = this;
		var activityFeedLayOut = grid.up('activityfeeds');
		if (activityFeedLayOut) {
			var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
			var activityFeedTypeGrid = activityFeedLayOut.down("#activityFeedTypeGridForApplicant");

			if (activityFeedDisplayTemplate) {
				activityFeedTypeGrid.setVisible(false);
				if (!isNullOrEmpty(fromAlertWin) && fromAlertWin)
					activityFeedDisplayTemplate.setVisible(true);
				else
					activityFeedDisplayTemplate.setVisible(true);

				var activityFeedTemplateFormPanel = activityFeedDisplayTemplate.down("#activityFeedTemplateButtonPanel");
				var activityFeedDisplayView = activityFeedDisplayTemplate.down("#activityFeedDisplayView");
				if (record !== null) {
					if (activityFeedDisplayView && !isEmpty(record.data)) {
						//	me.nextPreviousEnableDisable(activityFeedDisplayTemplate,record);

						if (!isEmpty(record.data) && !record.get("whetherRead")) {
							var messageId = record.get("messageId");
							if (!isNullOrEmpty(messageId)) {
								var submitUrl = SERVERURL.CHANGE_ALERT_NOTIFICATION_STATUS;
								submitUrl = submitUrl.concat("?messageId=" + messageId);
								Ext.Ajax.request({
									type: 'rest',
									url: submitUrl,
									method: 'PUT',
									success: function(response, form, action) {
										me.getMessageCount(me);
									}
								});
							}
						}

						var templateDataArray = new Array();
						templateDataArray.push(record.data);
						activityFeedDisplayView.getStore().loadData(templateDataArray);
						if (activityFeedTemplateFormPanel && !isNullOrEmpty(record.get('messageId'))) {
							activityFeedTemplateFormPanel.down("#messageId").setValue(record.get('messageId'));
						}
					}

				}
			}
		}
	},

	loadActivityFeedTypeGrid: function(activityFeedTypeGrid, type, whetherClickOnViewAll, selectedRecord) {
		var me = this;
		if (activityFeedTypeGrid) {
			if (portalId == 7) {
				var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
				var user = portalInfo.student;
			} else {
				var user = me.getCurrentlyLoggedInUser();
			}
			if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
				activityFeedTypeGrid.getStore().load({
					params: {
						userId: user.id
					},
					callback: function(records, operation, success) {
						if (records.length > 0) {
							if (type == CONSTANTS.NOTIFICATIONS) {
								activityFeedTypeGrid.fireEvent('select', null, records[1], 0, null, whetherClickOnViewAll, selectedRecord);
							} else if (type == CONSTANTS.ALERTS) {
								activityFeedTypeGrid.fireEvent('select', null, records[0], 0, null, whetherClickOnViewAll, selectedRecord);
							}
						}
					}
				});
			}
		}
	},

	loadActivityFeedTypeRadioPanel: function(radioForm, whetherClickOnViewAll, selectedRecord, type) {
		var me = this;
		if (radioForm) {
			if (portalId == 6) {
				var applicationId = me.loadApplicantProfile();
				param = {
					userId: applicationId.id,
					userType: "APPLICANT"
				};
				var URL = SERVERURL.PATH_FIND_UNREADMESSAGECOUNT_FORAPPLICANT;
			} else {
				if (portalId == 7) {
					var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
					var user = portalInfo.student;
				} else {
					var user = me.getCurrentlyLoggedInUser();
				}
				param = {
					userId: user.id
				};
				var URL = SERVERURL.FIND_UNREAD_MESSAGE_COUNT;
			}
			this.sendGetAjaxRequest(URL, 'GET', param, function(opt, success, response) {
				if (success) {
					var data = Ext.decode(response.responseText);
					if (!isNullOrEmpty(data)) {
						me.addRadioItems(data, radioForm, whetherClickOnViewAll, selectedRecord, type);

					}
				}
			});
		}
	},

	/**
	 * this is used to add radion buttons 
	 */
	addRadioItems: function(data, form, whetherClickOnViewAll, record, type) {
		var radio;
		var itemsArray = [];
		var formItems = [];
		var me = this;
		Ext.each(data, function(obj) {
			radio = me.getRadioField(obj)
			itemsArray.push(radio);
		});

		if (itemsArray.length > 0) {
			var fieldcontainer = me.createFieldcontainer(itemsArray);
			itemsArray = [];
			formItems.push(fieldcontainer);
		}
		formItems.push({
			xtype: 'hidden',
			name: 'whetherClickOnViewAll',
			itemId: 'whetherClickOnViewAllId',
			value: whetherClickOnViewAll
		}, {
			xtype: 'hidden',
			name: 'record',
			itemId: 'recordId',
			value: record
		});
		form.removeAll();
		form.add(formItems);

		if (type === CONSTANTS.ALERTS) {
			form.down('#Alerts').setValue(CONSTANTS.ALERTS);
		} else if (type === CONSTANTS.NOTIFICATIONS) {
			//form.down('#Notifications').setValue(CONSTANTS.NOTIFICATIONS);
		}

	},
	createFieldcontainer: function(itemArray) {
		field = {
			xtype: 'fieldcontainer',
			width: '100%',
			itemId: 'radioButtonsPanel',
			items: [{
				xtype: 'radiogroup',
				itemId: 'isOriginalRadio',
				allowBlank: false,
				items: itemArray
			}]
		};
		return field;
	},

	getRadioField: function(obj) {
		var me = this;
		var field = me.getfield('radiogroup', obj);
		return field;
	},

	getfield: function(xtype, obj) {
		var field = {
			boxLabel: obj.type,
			name: 'radioInput',
			itemId: obj.type,
			inputValue: obj.type,
			style: {
				marginRight: '40px'
			}
		};
		return field;
	},

	selectActivityFeedTypeGridRecord: function(radio) {
		var me = this;
		//        var whetherClickOnViewAll = radio.up('form').down('#whetherClickOnViewAllId');
		var radioValue = radio.up('form').down('#radioButtonsPanel').down('#isOriginalRadio').getValue();
		var record = radio.up('form').down('#reordId');
		var activityFeedLayOut = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));

		if (activityFeedLayOut) {
			var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
			var activityFeedTypeGrid = activityFeedLayOut.down("#activityFeedTypeGrid");
			//			if(whetherClickOnViewAll.getValue()=='false'){
			me.showMessageDetailPanel(activityFeedTypeGrid, record);
			//				whetherClickOnViewAll.setValue('true');
			//			}	else{

			if (activityFeedTypeGrid && activityFeedDisplayTemplate) {
				//activityFeedDisplayTemplate.setVisible(true);
				var parentId = null;
				if (portalId == 7) {
					var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
					var user = portalInfo.student;
					var parentId = localStorage.getItem('loggedInParentPersonId');
				} else {
					var user = me.getCurrentlyLoggedInUser();
				}
				var showMessage = activityFeedLayOut.down("#displayfieldMessageId");
				if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
					var type = radioValue.radioInput;
					if (type === CONSTANTS.ALERTS) {
						activityFeedTypeGrid.getStore().removeAll();
					}
					activityFeedTypeGrid.getStore().getProxy().extraParams = {
						userId: user.id,
						messageType: type,
						parentUserId: parentId
					};
					me.resetPageSetting(activityFeedTypeGrid.getStore());
					activityFeedTypeGrid.getStore().load({
						callback: function(records) {
							if (records == null || records.length == 0) {
								activityFeedTypeGrid.setVisible(false);
								showMessage.setVisible(true);
								if (type == 'Alerts') {
									showMessage.setValue(getCommonTranslation('EMPTY_ALERTS_MESSAGE'));
								} else {
									showMessage.setValue(getCommonTranslation('EMPTY_NOTIFICATION_MESSAGE'));
								}
							} else {
								activityFeedTypeGrid.setVisible(true);
								showMessage.setVisible(false);
							}

						}
					});
				}
			}
			//			}	
		}
	},
	selectActivityFeedTypeGridForApplicantRecord: function(radio) {
		var me = this;
		//        var whetherClickOnViewAll = radio.up('form').down('#whetherClickOnViewAllId');
		var radioValue = radio.up('form').down('#radioButtonsPanel').down('#isOriginalRadio').getValue();
		var record = radio.up('form').down('#reordId');
		var activityFeedLayOut = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));

		if (activityFeedLayOut) {
			var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
			var activityFeedTypeGrid = activityFeedLayOut.down("#activityFeedTypeGridForApplicant");
			//			if(whetherClickOnViewAll.getValue()=='false'){
			me.showMessageDetailPanel(activityFeedTypeGrid, record);
			//				whetherClickOnViewAll.setValue('true');
			//			}	else{

			if (activityFeedTypeGrid && activityFeedDisplayTemplate) {
				//activityFeedDisplayTemplate.setVisible(true);
				var user = me.getCurrentlyLoggedInUser();
				var applicationId = me.loadApplicantProfile();
				var showMessage = activityFeedLayOut.down("#displayfieldMessageId");
				if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
					var type = radioValue.radioInput;
					if (type === CONSTANTS.ALERTS) {
						activityFeedTypeGrid.getStore().removeAll();
					}
					activityFeedTypeGrid.getStore().getProxy().extraParams = {
						userId: applicationId.id,
						messageType: type
					};
					me.resetPageSetting(activityFeedTypeGrid.getStore());
					activityFeedTypeGrid.getStore().load();
				}
			}
			//			}	
		}
	},

	deleteMessages: function(button) {
		var me = this;
		var grid = button.up('grid');

		if (grid) {
			if (grid.getSelectionModel().getCount() > 0) {
				showConfirmMessage(getCommonTranslation('DELETE_MESSAGE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
					if (btn == 'yes') {
						var params = new Object();
						var selectedMessageIds = new Array();
						var records = grid.getSelectionModel().getSelection();
						for (var count = 0; count < records.length; count++) {
							if (!isEmpty(records[count].data) && !isNullOrEmpty(records[count].get("messageId"))) {
								selectedMessageIds.push(records[count].get("messageId"));
							}
						}
						if (selectedMessageIds.length > 0) {
							params.messageIds = selectedMessageIds;
							me.deleteNotificationAlert(params, true, grid.getStore(), null, null);
							var activityFeedLayOut = grid.up('activityfeeds');
							var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
							var activityFeedTemplateFormPanel = activityFeedDisplayTemplate.down("#activityFeedTemplateButtonPanel");
							var activityFeedDisplayView = activityFeedDisplayTemplate.down("#activityFeedDisplayView");
							var downloadAttachment = activityFeedDisplayTemplate.down("#downloadAttachment");
							var notificationEmptyMsgField = activityFeedDisplayTemplate.down('#notificationEmptyMessageId');
							//activityFeedDisplayTemplate.down('#btnPrevious').setVisible(false);
							//	activityFeedDisplayTemplate.down('#btnNext').setVisible(false);
							notificationEmptyMsgField.setVisible(true);
							downloadAttachment.setVisible(false);
							activityFeedDisplayView.getStore().removeAll();
						}
					}
				});
			} else {
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
			}
		}
	},
	deleteMessagesforapplicant: function(button) {
		var me = this;
		var grid = button.up('grid');
		if (grid) {
			if (grid.getSelectionModel().getCount() > 0) {
				showConfirmMessage(getCommonTranslation('DELETE_MESSAGE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
					if (btn == 'yes') {
						var params = new Object();
						var selectedMessageIds = new Array();
						var records = grid.getSelectionModel().getSelection();
						for (var count = 0; count < records.length; count++) {
							if (!isEmpty(records[count].data) && !isNullOrEmpty(records[count].get("messageId"))) {
								selectedMessageIds.push(records[count].get("messageId"));
							}
						}
						if (selectedMessageIds.length > 0) {
							params.messageIds = selectedMessageIds;
							me.deleteNotificationAlert(params, true, grid.getStore(), null, null);
							var activityFeedLayOut = grid.up('activityfeeds');
							var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
							var activityFeedTemplateFormPanel = activityFeedDisplayTemplate.down("#activityFeedTemplateButtonPanel");
							var activityFeedDisplayView = activityFeedDisplayTemplate.down("#activityFeedDisplayView");
							var downloadAttachment = activityFeedDisplayTemplate.down("#downloadAttachment");
							var notificationEmptyMsgField = activityFeedDisplayTemplate.down('#notificationEmptyMessageId');
							//	activityFeedDisplayTemplate.down('#btnPrevious').setVisible(false);
							//	activityFeedDisplayTemplate.down('#btnNext').setVisible(false);
							notificationEmptyMsgField.setVisible(true);
							downloadAttachment.setVisible(false);
							activityFeedDisplayView.getStore().removeAll();

						}
					}
				});
			} else {
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
			}
		}
	},

	deleteSingleMessage: function(button) {
		var me = this;
		var formPanel = button.up('form');
		if (formPanel) {
			showConfirmMessage(getCommonTranslation('DELETE_MESSAGE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var formValues = formPanel.getForm().getValues();
					if (!isEmpty(formValues) && !isNullOrEmpty(formValues.messageId)) {
						var params = new Object();
						var selectedMessageIds = new Array();
						selectedMessageIds.push(formValues.messageId);
						params.messageIds = selectedMessageIds;
						var activityFeedLayOut = formPanel.up('activityfeeds');
						if (activityFeedLayOut) {
							var activityFeedDisplayTemplate = activityFeedLayOut.down("#activityFeedDisplayTemplate");
							var activityFeedTypeGrid = activityFeedLayOut.down("#activityFeedTypeGrid");
							me.deleteNotificationAlert(params, false, null, activityFeedTypeGrid, activityFeedDisplayTemplate);
						}
					}
				}
			});
		}
	},

	/**
	 * This method is used for to delete notification/alert  
	 * @param button - button reference   
	 * 
	 */
	deleteNotificationAlert: function(selectedMessageIds, isDeleteFromGrid, grdStore, activityFeedTypeGrid, activityFeedDisplayTemplate) {
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.DELETE_ALL_ALERT_NOTIFICATION,
			method: 'DELETE',
			headers: {
				'Content-Type': 'application/json'
			},
			params: selectedMessageIds,
			success: function(form, action) {
				if (isDeleteFromGrid) {
					grdStore.reload();
				} else {
					activityFeedTypeGrid.getStore().reload();
					activityFeedTypeGrid.setVisible(true);
					//activityFeedDisplayTemplate.setVisible(false);
				}
				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_MESSAGE_MSG')); //Message deleted successfully.
			}
		});
	},


	getMessageCount: function(this$) {
		var me = this$;
		try {
			portalId = localStorage.getItem('portalId');
		}
		catch (eee) {
		}
		if (portalId == 6) {
			var applicationId = me.loadApplicantProfile();
			if (!isEmpty(applicationId) && !isNullOrEmpty(applicationId.id)) {
				var params = {
					userId: applicationId.id,
					userType: "APPLICANT"
				};
				var URL = SERVERURL.PATH_FIND_UNREADMESSAGECOUNT_FORAPPLICANT;
			}
		} else {
			if (portalId == 7) {
				var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
				var user = portalInfo.student;
			} else {
				var user = me.getCurrentlyLoggedInUser();
			}
			if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
				var params = {
					userId: user.id
				};
				var URL = SERVERURL.FIND_UNREAD_MESSAGE_COUNT;
			}
		}
		me.sendGetAjaxRequest(URL, 'GET', params, function(opt, success, response) {
			if (success) {
				var value = response.responseText;
				if (!isNullOrEmpty(value)) {
					var data = Ext.decode(response.responseText);
					var notificationPanel = Ext.ComponentQuery.query('#notificationSectionPanel')[0];
					if (notificationPanel) {

						/* Notification Div Panel */
						var notificationDiv = notificationPanel.down('#notificationDiv');
						if (notificationDiv) {
							var noticeNew = Ext.get('notice-new');
							if (noticeNew) {
								if (!isEmpty(data[1]) && !isNullOrEmpty(data[1].unreadCount) && data[1].unreadCount != 0) {
									if (isNullOrEmpty(noticeNew.className)) {
										noticeNew.el.dom.className = "notice-new";
									}
									noticeNew.setHTML(data[1].unreadCount);
								} else {
									noticeNew.setHTML("");
									noticeNew.el.dom.className = "";
								}
							}
							notificationDiv.renderData = data[1];
							if (data[1].unreadCount > 0) {
								notificationDiv.el.dom.querySelector('.dropdown-toggle').className += ' notification-icon';
							}
						}

						/* Alert Div Panel */
						var alertDiv = notificationPanel.down('#alertDiv');
						if (alertDiv) {
							if (alertDiv.spanEl) {
								if (!isEmpty(data[0]) && !isNullOrEmpty(data[0].unreadCount) && data[0].unreadCount != 0) {
									if (isNullOrEmpty(alertDiv.spanEl.className)) {
										alertDiv.spanEl.el.dom.className = "notice-alert";
									}
									alertDiv.spanEl.setHTML(data[0].unreadCount);
								} else {
									alertDiv.spanEl.setHTML("");
									alertDiv.spanEl.el.dom.className = "";
								}
							}
							alertDiv.renderData = data[0];
						}

						/* Reload Activity Feed Grid For Updated Count */

						var activityfeedTab = me.getTabReferenceByTabTitle(getCommonTranslation('ACTIVITY_FEEDS'));
						if (activityfeedTab) {
							var activityFeedTypeGrid = activityfeedTab.down("#activityFeedTypePanel");
							if (activityFeedTypeGrid) {
								if (portalId == 7) {
									var portalInfo = me.getCurrentlyLoggedInUserInfoForPortal();
									var user = portalInfo.student;
								} else {
									var user = me.getCurrentlyLoggedInUser();
								}
								if (!isEmpty(user) && !isNullOrEmpty(user.id)) {
									activityFeedTypeGrid.getStore().load({
										params: {
											userId: user.id
										}
									});
								}
							}
						}
					}
				}

			}
		});
	},

	/**
	 *  Call to fetch the logo of the selected academy location to be displayed in the header.
	 *  Displays the default academia logo if there is no logo set up for the particular Academy-Location
	 *  @author Akshay.Kalbhor
	 */
	getAcademyLocationLogo: function(academyLocationId, academyLocationDisplayName) {
		var this$ = this;
		var downloadUrl = SERVERURL.ACADEMY_LOCATION_LOGO_DOWNLOAD;
		var logoSection = this.getLogoSection();
		var logoContainer = logoSection.down("image#organizationLogo");
		var orgNameField = logoSection.down("component#organizationName");

		//--Start Here--setting loading logo
		logoContainer.getEl().dom.src = 'resources/images/headerLogo/loading-logo.gif';
		logoContainer.setWidth('auto');
		setTimeout(function() {
			Ext.ComponentQuery.query('logosection')[0].doLayout();
		}, 100);
		//--End Here--setting loading logo


		if (!isNullOrEmpty(academyLocationId) && academyLocationId > 0) {
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: downloadUrl,
				params: {
					'academyLocationId': academyLocationId
				},
				method: 'GET',
				scope: this,
				success: function(response) {
					if (response.responseBytes.length > 0) {
						var logoSection = this$.getLogoSection();
						var logoContainer = logoSection.down("image#organizationLogo");
						var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
						var url = window.URL.createObjectURL(blob);

						if (!isNullOrEmpty(url)) {
							logoContainer.getEl().dom.src = url;
						}
						var image = new Image();
						image.src = url;
						image.onload = function() {
							var ratio = this.width / this.height;
							width = 55 * ratio;
							logoSection.down('#organizationLogo').setWidth(width);
							logoSection.doLayout();
							orgNameField.getEl().dom.innerHTML = academyLocationDisplayName;
						};
					} else {
						if (isNullOrEmpty(logoContainer)) {
							var logoSection = this.getLogoSection();
							var logoContainer = logoSection.down("image#organizationLogo");
						}
						logoContainer.getEl().dom.src = 'resources/images/headerLogo/academiaLogo.png';
						orgNameField.getEl().dom.innerHTML = academyLocationDisplayName; //getCommonTranslation('ACADEMIA_ERP_DEFAULT_TEXT');
					}
					logoContainer.setWidth('auto');
					setTimeout(function() {
						Ext.ComponentQuery.query('logosection')[0].doLayout();
					}, 100);
					checkAndAddDemoHeader();
				},
				failure: function(response) {
					logoContainer.getEl().dom.src = 'resources/images/headerLogo/academiaLogo.png';
					logoContainer.setWidth('auto');
					orgNameField.getEl().dom.innerHTML = academyLocationDisplayName;
					setTimeout(function() {
						Ext.ComponentQuery.query('logosection')[0].doLayout();
					}, 100);
					checkAndAddDemoHeader();
				}
			});
			setTimeout(function() {
				try {
					if (isNullOrEmpty(orgNameField.getEl().dom.innerHTML)) {
						logoContainer.getEl().dom.src = 'resources/images/headerLogo/academiaLogo.png';
						logoContainer.setWidth('auto');
						orgNameField.getEl().dom.innerHTML = academyLocationDisplayName;
						setTimeout(function() {
							Ext.ComponentQuery.query('logosection')[0].doLayout();
						}, 100);
						checkAndAddDemoHeader();
					}
				}
				catch (e) { }
			}, 30000);
		} else {
			//In case of blank db, the academyLocation Id is set to 0, In this case returning the Default Academia Logo
			logoContainer.getEl().dom.src = 'resources/images/headerLogo/academiaLogo.png';
			orgNameField.getEl().dom.innerHTML = getCommonTranslation('ACADEMIA_ERP_DEFAULT_TEXT');
			setTimeout(function() {
				Ext.ComponentQuery.query('logosection')[0].doLayout();
			}, 100);
			checkAndAddDemoHeader();
		}
	},

	/**
	 * Method to get the user profile picture, for displaying in the header.
	 * @param {Integer} personId : The id of the Person logged in
	 * @param {String} displayName: The name of the person which will be shown as the tooltip on
	 * mouse hover.
	 * @author Akshay.Kalbhor
	 */
	getUserImage: function(personId, displayName) {
		var downloadUrl = SERVERURL.PERSON_IMAGE_DOWNLOAD;
		var personLogoContainer = this.getUserInfo();
		var personLogoButton = personLogoContainer.down("button#userInfoButton");

		/**
		 * @Author Surendra Jha
		 * Show user image for applicant portal user
		 */
		var portalId = this.getCurrentLoggedPortalId();
		var param = {
			'personId': personId,
			'portalId': portalId
		};
		if (portalId == 6) {
			downloadUrl = SERVERURL.APPLICANT_IMAGE_DOWNLOAD;
			param = {
				'personId': personId
			};
		}
		// End
		if (!isNullOrEmpty(personId)) {
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: downloadUrl + '?isDefaultImageRequired=false',
				params: param,
				method: 'GET',
				success: function(response) {
					if (response.responseBytes.length > 0) {
						var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
						var url = window.URL.createObjectURL(blob);
						if (!isNullOrEmpty(url)) {
							personLogoButton.setIcon(url);
						}
					} else {
						if (portalId == 1) {
							//personLogoButton.setIcon('resources/images/default_ERP.png');    						
							Ext.defer(function() {
								var fullName = splitFullName(displayName);
								var newImgUrl = generateInitialsImage(
									fullName.firstName,
									fullName.middleName,
									fullName.lastName
								);

								personLogoButton.setVisible(true);
								personLogoButton.addCls('transparentUserBGHeader');

								if (personLogoButton.rendered && personLogoButton.getEl()) {
									var imgContainer = personLogoButton.getEl().dom;
									var avatarSpan = imgContainer.querySelector("span.x-btn-icon-el.profile-avatar");

									if (avatarSpan) {
										avatarSpan.style.backgroundImage = "url('" + newImgUrl + "')";
									}
								} else {
									personLogoButton.setIcon(newImgUrl);
								}
							}, 3000);
						} else if (portalId == 2) {
							Ext.defer(function() {
								var fullName = splitFullName(displayName);
								var newImgUrl = generateInitialsImage(
									fullName.firstName,
									fullName.middleName,
									fullName.lastName
								);

								personLogoButton.setVisible(true);
								personLogoButton.addCls('transparentUserBGHeader');

								if (personLogoButton.rendered && personLogoButton.getEl()) {
									var imgContainer = personLogoButton.getEl().dom;
									var avatarSpan = imgContainer.querySelector("span.x-btn-icon-el.profile-avatar");

									if (avatarSpan) {
										avatarSpan.style.backgroundImage = "url('" + newImgUrl + "')";
									}
								} else {
									personLogoButton.setIcon(newImgUrl);
								}
							}, 3000);
						} else if (portalId == 3 || portalId == 7) {
							Ext.defer(function() {
								var fullName = splitFullName(displayName);
								var newImgUrl = generateInitialsImage(
									fullName.firstName,
									fullName.middleName,
									fullName.lastName
								);

								personLogoButton.setVisible(true);
								personLogoButton.addCls('transparentUserBGHeader');

								if (personLogoButton.rendered && personLogoButton.getEl()) {
									var imgContainer = personLogoButton.getEl().dom;
									var avatarSpan = imgContainer.querySelector("span.x-btn-icon-el.profile-avatar");

									if (avatarSpan) {
										avatarSpan.style.backgroundImage = "url('" + newImgUrl + "')";
									}
								} else {
									personLogoButton.setIcon(newImgUrl);
								}
							}, 3000);
						} else {
							//personLogoButton.setIcon('resources/images/profile_admin.png');
							Ext.defer(function() {
								var fullName = splitFullName(displayName);
								var newImgUrl = generateInitialsImage(
									fullName.firstName,
									fullName.middleName,
									fullName.lastName
								);

								personLogoButton.setVisible(true);
								personLogoButton.addCls('transparentUserBGHeader');

								if (personLogoButton.rendered && personLogoButton.getEl()) {
									var imgContainer = personLogoButton.getEl().dom;
									var avatarSpan = imgContainer.querySelector("span.x-btn-icon-el.profile-avatar");

									if (avatarSpan) {
										avatarSpan.style.backgroundImage = "url('" + newImgUrl + "')";
									}
								} else {
									personLogoButton.setIcon(newImgUrl);
								}
							}, 3000);
						}

					}
					personLogoButton.setTooltip(displayName);
				}
			});
		} else {
			personLogoButton.setIcon('resources/images/profile_admin.png');
			personLogoButton.setTooltip(displayName);
		}
	},

	/**
	 * method to show the change academylocation screen in which the user will select the academy location
	 * @author Akshay.Kalbhor
	 * param {Object} the reference of the clicked button
	 */
	showChangeALWindow: function(btn) {
		var verticalNavigationMenu = this.getVerticalNavigationMenu();
		verticalNavigationMenu.collapse();
		var windowRef = Ext.ComponentQuery.query('academylocationchangewindow')[0];
		if (!windowRef) {
			windowRef = this.showWindow('academylocationchangewindow');
		}
		windowRef.show();
		var cmbGlobalAcademyLocation = this.getNotificationSection().down('#cmbGlobalAcademyLocation');
		windowRef.down('displayfield').setValue(cmbGlobalAcademyLocation.getRawValue());
		windowRef.down('#academyLocationId').setValue(cmbGlobalAcademyLocation.getValue());
	},

	/**
	 * method to show change poratl window in which user will select portal 
	 * @author pritam.patil
	 * @param {Object} the reference of the clicked button
	 */
	showChangePortalWindow: function() {
		me = this;
		var chagnePortalWin = this.showWindow('changeportalwindow');
		var data = this.getStore('authentication.PortalStore').data.items;
		selectLogoPanel = chagnePortalWin.down('#selectLogoPanel');
		selectLogoPanel.add({
			xtype: 'panel',
			itemId: 'selectLogoTablePanel',
			layout: {
				type: 'table',
				columns: data.length
			},
			items: []
		});

		data.forEach(function(obj) {
			selectLogoTablePanel = Ext.ComponentQuery.query('#selectLogoTablePanel')[0];

			var imgSrcCss = "defaultPortalCss";
			if (obj.get('portalName') == "Employee" || obj.get('portalName') == "Faculty") {
				imgSrcCss = "employeeImgCss";
			} else if (obj.get('portalName') == "Core ERP") {
				imgSrcCss = "coreErpImgCss";
			} else if (obj.get('portalName') == "Student") {
				imgSrcCss = "studentImgCss";
			}
			selectLogoTablePanel.add({
				xtype: 'panel',
				layout: {
					align: 'center',
					pack: 'start',
					type: 'column'
				},
				margin: '0 0 0 5',
				width: 100,
				height: 100,
				items: [{
					xtype: 'button',
					iconCls: imgSrcCss,
					flex: 1,
					portalName: obj.get('portalName'),
					portalId: obj.get('id'),
					itemId: 'portlLoginIcon',
					height: 'auto',
					minHeight: 70,
					scale: 'huge',
					handler: function(btn) {
						try {
							Ext.ComponentQuery.query('#searchComboBox')[0].getStore().clearFilter();
							Ext.ComponentQuery.query('#searchComboBox')[0].getStore().removeAll();
						}
						catch (e) {

						}
						portalId = btn.portalId;
						changeportalwindow = btn.up('changeportalwindow');
						//me.getFeaturePrivileges(me,portalId,true,changeportalwindow);
						changeportalwindow.close();
						localStorage.setItem('portalId', portalId);
						window.location.reload();
					}
				}, {
					xtype: 'label',
					text: obj.get('portalName') == 'Core ERP' ? getCommonTranslation('SWITCH_CORE_ERP') : obj.get('portalName') == 'Employee' ? getCommonTranslation('SWITCH_EMPLOYEE_PORTAL') : getCommonTranslation(obj.get('portalName')),
					style: { width: '100%', 'text-align': 'center' }
				}]
			});
		});
		chagnePortalWin.center();
		var verticalNavigationMenu = this.getVerticalNavigationMenu();
		verticalNavigationMenu.collapse();
	},

	getOrgSettingOnLogin: function() {
		var this$ = this;
		var url = SERVERURL.ORGINFOLOADREQUEST;
		/**
		 * @author Ravi Choudhary
		 * changes this from sendGetAjaxRequest for synchronization
		 */
		this.orgSettingOnLoginAjaxRequest(url, 'GET', null, function(opt, success, response) {
			if (success) {
				if (response.responseText != null && response.responseText != "") {
					var data = JSON.parse(response.responseText);
					var orgSettings = data.organizationSettings;
					if (data.organizationSettings.length > 0) {
						var dateFormat = this$.findSettingValueForOrganization('DF', orgSettings);
						var timeFormat = this$.findSettingValueForOrganization('TF', orgSettings);
						var currencyFormat = data.currency.code;
						var orgModel = Academia.model.common.OrgSettingDateTimeModel;
						orgModel.set('dateFormat', dateFormat);
						orgModel.set('currencyFormat', currencyFormat);
						orgModel.set('timeFormat', timeFormat);
						orgModel.set('applicationPageSize', data.pageSize);
						CONSTANTS.DEFAULT_PAGESIZE = data.pageSize;
						CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE = data.pageSize;
					}
				}
			}
		});
	},
	/**
	 * @author Ravi Choudhary
	 */
	orgSettingOnLoginAjaxRequest: function(url, requestMethod, params, callback) {
		Ext.Ajax.request({
			type: 'rest',
			async: false,
			method: requestMethod,
			url: url,
			params: params,
			callback: callback
		});
	},

	findSettingValueForOrganization: function(key, orgSettings) {
		var retvalue = null;
		Ext.each(orgSettings, function(rec) {
			if (rec.setting.fieldCode.toLowerCase() === key.toLowerCase()) {
				retvalue = rec.value;
			}
		});
		return retvalue;
	},

	loadCurrencyMasterData: function() {
		if (isNullOrEmpty(Academia.utilities.currency.CurrencyManager.currencyMasterData)) {
			var url = SERVERURL.BASECURRENCYSTOREURL;
			this.sendGetAjaxRequest(url, 'GET', null, function(opt, success, response) {
				if (success) {
					var currencyData = Ext.decode(response.responseText);
					Academia.utilities.currency.CurrencyManager.currencyMasterData = currencyData;
				}
			});
		}
	},
	/**
	 * @author Rajkumar.Patidar
	 */
	customMasking: function(myMask) {
		myMask.show();
		var dom = Ext.dom.Query.select('.x-mask');
		var el = Ext.get(dom[0]);
		el.addCls('customMask');
	},
	/**
	 * @author Rajkumar Patidar
	 */
	setSocialMappingForm: function(removeform) {
		var viewport = Ext.ComponentQuery.query('vp')[0];
		if (removeform) {
			viewport.remove(removeform);
			viewport.add({
				region: 'center',
				style: {
					background: '#f0f0f0'
				},
				align: 'stretch',
				xtype: 'socialmappingform',
				itemId: 'socailmappingform',
				autoScroll: true
			});

			var form = viewport.down('socialmappingform');
			var template = new Ext.XTemplate('<tpl><div style="border: solid; border-color: red;border-width: 1px;"><table>',
				'<tr>',
				'<td>' + getErrorTranslation('no_social_mapping_found') + '</td>',
				'</tr>',
				'</table></div>',
				'</tpl>');
			var passwordPolicyTemplate = form.down('#passwordPolicyTemplate');
			passwordPolicyTemplate.refresh();
			passwordPolicyTemplate.tpl = template;
			form.doLayout();
		}
	},
	getURLstatus: function(socialId, userId, socialLoginId, socialEmail) {
		/*var this$ = this;
		Ext.Ajax.request({
			url: 'oauth/token',
			method: 'POST',
			async: false,
			params: {
				portal_code : 'SSO',
				grant_type: 'password',
				client_id:'ssoclient', // Consumer Key
				client_secret: '$edu#app@24', // Consumer Secret
				username: 'SSO_USER', // UserName
				password: 'password' // Password (if your IP address,

			},
			success: function(response) {
				this$.setDefaultHeaders(response);
				Ext.Ajax.request({
					type: 'rest',
					async: false,
					url: SERVERURL.SAVE_USER_SOCIAL_INFO+'?socialId='+socialId+'&userId='+userId+'&socialLoginId='+socialLoginId+'&socialEmail='+socialEmail,
					method: 'GET',
					success: function(res, action) {
						var jsonData = Ext.decode(res.responseText);
					}
				});
			},
			failure: function(response) {
				Ext.Ajax.request({
					type: 'rest',
					async: false,
					url: SERVERURL.SAVE_USER_SOCIAL_INFO+'?socialId='+socialId+'&userId='+userId+'&socialLoginId='+socialLoginId+'&socialEmail='+socialEmail,
					method: 'GET',
					params: {
						portal_code : 'SSO',
						grant_type: 'password',
						client_id:'ssoclient', // Consumer Key
						client_secret: '$edu#app@24', // Consumer Secret
						username: 'SSO_USER', // UserName
						password: 'password' // Password (if your IP address,
					},
					success: function(res, action) {
						var jsonData = Ext.decode(res.responseText);
					}
				});
			}
		});*/
	},
	socialLoginBtn: function(button) {
		var this$ = this;
		var socialmappingform = button.up('socialmappingform');
		var formValues = socialmappingform.getForm().getValues();

		var myMask = new Ext.LoadMask(Ext.getBody(), { msg: getCommonTranslation('PLEASE_WAIT_WHILE_SYSTEM_IS_INITIALIZING'), msgCls: 'msgClsCustomLoadMask' });
		Ext.Ajax.request({
			url: 'oauth/token',
			method: 'POST',
			async: false,
			params: {
				grant_type: 'password',
				client_id: 'erpclient', // Consumer Key
				client_secret: '#edu$erp#2016$', // Consumer Secret
				username: formValues.username, // UserName
				password: formValues.password // Password (if your IP address,

			},
			success: function(response) {
				this$.setDefaultHeaders(response);
				var UserInfoModel = Academia.model.authentication.UserInfoModel;
				this$.customMasking(myMask);
				/*var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');
				if(idTableMappingStore){
					idTableMappingStore.load();
				}*/
				this$.getOrgSettingOnLogin();
				this$.loadCurrencyMasterData();
				this$.findAllCustomTableConfiguration();
				this$.getFeaturePrivileges(this$, null, false, socialmappingform);
				var SocialIdModel = Academia.model.authentication.SocialIdModel;
				var socialId = SocialIdModel.get('socialId');
				var userId = UserInfoModel.get("userId");
				var socialLoginId = SocialIdModel.get('socialValue');
				var socialEmail = SocialIdModel.get('socialEmail');

				//this$.getURLstatus(socialId,userId,socialLoginId,socialEmail);
				myMask.hide();
			}
		});
	},
	getLoginBySocialWinKey: function(obj, e) {
		var form = obj.up('form');
		if (form.isValid()) {
			if (e.getKey() == e.ENTER) {
				this.socialLoginBtn(obj);
			}
		}
	},
	loadBuildInfoXML: function(me) {

		var buildInfo = "";
		var buildName = "";
		var buildDate = "";
		var buildVersion = "";
		var buildReleaseNoteUrl = "";
		var isShow = "";

		var XMLHttpRequestObject = false;
		if (window.XMLHttpRequest) {
			XMLHttpRequestObject = new XMLHttpRequest();
			XMLHttpRequestObject.overrideMimeType("text/xml");
		}
		else if (window.ActiveXObject) {
			XMLHttpRequestObject = new
				ActiveXObject("Microsoft.XMLHTTP");
		}
		if (XMLHttpRequestObject) {
			XMLHttpRequestObject.open("GET", "buildInfo.xml?v=" + currentVersion, true);
			XMLHttpRequestObject.onreadystatechange = function() {
				if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {
					var xmlDocument = XMLHttpRequestObject.responseXML;
					buildInfo = xmlDocument.getElementsByTagName("buildInfo")[0];
					buildName = buildInfo.getElementsByTagName("buildName")[0].childNodes[0].nodeValue;
					buildDate = buildInfo.getElementsByTagName("buildDate")[0].childNodes[0].nodeValue;
					buildVersion = buildInfo.getElementsByTagName("buildVersion")[0].childNodes[0].nodeValue;
					buildReleaseNoteUrl = buildInfo.getElementsByTagName("buildReleaseNoteUrl")[0].childNodes[0].nodeValue;
					isShow = buildInfo.getElementsByTagName("show")[0].childNodes[0].nodeValue;

					var footerView = me.getFootersection();
					if (isShow == 'true') {
						footerView.down('#buildName').setText(getCommonTranslation('BUILD_NAME') + buildName);
						footerView.down('#buildDate').setText(getCommonTranslation('BUILD_DATE') + buildDate);
						footerView.down('#buildVersion').setText(getCommonTranslation('VERSION') + buildVersion);
					}
				}
			}
			XMLHttpRequestObject.send(null);
		}
	},

	onChangeAcademyLocationByCombo: function(selectedAcademyLocationId) {
		var me = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		portalId = userInfo.get("portalId");
		var academyLocationId = (localStorage.getItem('academylocationid') == null) ? 0 : localStorage.getItem('academylocationid');
		Ext.Ajax.request({
			url: 'rest/authentication/features',
			method: 'GET',
			async: false,
			params: {
				portalId: portalId,
				academyLocationId: academyLocationId
			},
			success: function(response) {
				var responseData = Ext.decode(response.responseText);
				if (responseData.academyLocationPrivileges.length > 0) {
					me.filterSystemMenuWithAcademyLocationFeaturePrivilages(responseData.systemMenuHierachyModels, selectedAcademyLocationId);
				}
			}
		});
	},

	loadApplicantPortal: function() {
		var this$ = this;
		var VerticalNavigationMenu = this$.getVerticalNavigationMenu()
		VerticalNavigationMenu.setVisible(false);

		this$.loadContollers('applications');

		var applicantPortalController = this$.getController('Academia.controller.portal.ApplicantPortalController');
		var applicationBaseController = this$.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController')
		var data = applicantPortalController.loadApplicantProfile();
		var applicationId = data.id;
		var personId = data.person.id;
		var title = data.code;

		applicationBaseController.addContentPanelTab(title, 'applicantprofile', null, personId, applicationId, null, null, false);
		var applicantProfile = this$.getTabReferenceByTabTitle(title);
		if (applicantProfile) {
			applicationBaseController.setParameterForApplicantProfile(applicantProfile, null, '', false);
			applicationBaseController.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile, true);
			applicationBaseController.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile, true);
			var applicantLinkPanelObject = applicationBaseController.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
			applicationBaseController.gettingDataInSummaryGrid(applicantProfile);
			applicantProfile.down('#actionButtonPanel').down('#approveApplicationBtn').setVisible(false);
			applicantProfile.down('#actionButtonPanel').down('#rejectApplicationBtn').setVisible(false);
			applicantProfile.down('#actionButtonPanel').down('#withdrawApplicationBtn').setVisible(false);
			applicantProfile.down('#actionButtonPanel').down('#withdrawAdmissionBtn').setVisible(false);
			applicantProfile.down('#actionButtonPanel').down('#rejectAdmissionBtn').setVisible(false);
			applicantProfile.down('#actionButtonPanel').down('#approveAdmissionBtn').setVisible(false);
			if (!isEmpty(applicantLinkPanelObject)) {
				var personalDetailObject = applicantLinkPanelObject.PERSONAL_INFORMATION[0];
				applicationBaseController.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId, personalDetailObject.defaultPanel);
				var documentsObject = applicantLinkPanelObject.GENERAL[0];
				applicationBaseController.addPersonTabPanel('APPLICANT', documentsObject.tabPanelItemId, documentsObject.tabPanelTitle, documentsObject.tabPanelItemXtype, documentsObject.xtypeItemId, documentsObject.defaultPanel);
				var personInfoPanel = applicantProfile.down("#personInfoPanel");
				if (personInfoPanel) {
					var applicantPersonalDetails = personInfoPanel.down("#applicantPersonalDetails");
					var applicantDocumentDetails = personInfoPanel.down("#applicantDocumentDetails");
					if (applicantDocumentDetails) {
						personInfoPanel.setActiveTab(applicantDocumentDetails);
					}
					applicantPersonalDetails.down('#personCodeField').setReadOnly(true);
				}
				var persondetailslinkpanel = applicantProfile.down('persondetailslinkpanel');
				var APPLICATION_AND_ADMISSION = persondetailslinkpanel.down('#PERSONAL_INFORMATION');
				var store = APPLICATION_AND_ADMISSION.items.items[0].getStore();
				persondetailslinkpanel.setVisible(false);

				/*** right panel link show.hide functionality by permission management **/

				applicantPortalController.loadPanellinkForApplicant(applicantProfile, applicantLinkPanelObject);
				VerticalNavigationMenu.setVisible(true);
			}
		}
		if (Ext.isDefined(personInfoPanel)) {
			personInfoPanel.getEl().dom.style.opacity = 0;
			personInfoPanel.getEl().dom.style.display = 'none';
		}
		if (isNullOrEmpty(title)) {
			Ext.defer(function() {
				title = "Your Application";
				applicantProfile.setTitle(title);
			}, 1000, this);
		}
	},
	openLanguageWindow: function() {
		var changelanguagewindow = this.showWindow('changelanguagewindow');
		changelanguagewindow.down('#changeLanguage').getStore().load();
		var verticalNavigationMenu = this.getVerticalNavigationMenu();
		verticalNavigationMenu.collapse();
	},
	showChangeSocialMappingWindow: function() {
		this.showWindow('socialmappingwindow');
		var verticalNavigationMenu = this.getVerticalNavigationMenu();
		verticalNavigationMenu.collapse();
	},
	deleteSocialMappingDetail: function() {
		var win = this.getSocialMappingWindow();
		var grid = win.down('grid');
		var grdStore = grid.getStore();

		if (grid.getSelectionModel().getCount() > 0) {
			showConfirmMessage(getCommonTranslation('SOCIAL_MAPPING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records = grid.getSelectionModel().getSelection();
					var id = records[0].get("id");
					var code = records[0].get("code");
					var message;
					if (code === '1') {
						message = getCommonTranslation('FACEBOOK');
					}
					else {
						message = getCommonTranslation('G_MAIL');
					}
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.DELETE_SOCIAL_MAPPING + '?id=' + id,
						headers: {
							'Content-Type': 'application/json'
						},
						success: function(form, action) {
							grdStore.reload();
							showSuccessMessage(getCommonTranslation('SOCIAL_MAPPING'), message + ' ' + getCommonTranslation('UNMAPPED_SUCESS_MESSAGE'));
						}
					});
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('SOCIAL_MAPPING'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
		}
	},
	loadMultipleLangFilePerAL: function(alId, terminologyCheck) {
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var attendanceSettingModel = Academia.model.authentication.AttendanceSettingModel;
		var checkAgain = false;
		if (!Ext.isDefined(alinfomodel.get('alId'))) {
			checkAgain = true;
		}
		else if (alinfomodel.get('alId') != alId) {
			checkAgain = true;
		}
		if (checkAgain) {
			Ext.Ajax.request({
				url: SERVERURL.ACADEMY_LOCATION_ATTENDANCE_SETTINGS,
				method: 'GET',
				async: false,
				params: {
					academyLocationId: alId
				},
				success: function(response) {
					var responseData = Ext.decode(response.responseText);
					if (!isNullOrEmpty(responseData.wheatherSchool)) {
						var wheatherSchool;
						if (responseData.wheatherSchool.alTerminology == 'SCHOOL') {
							wheatherSchool = true;
						} else if (responseData.wheatherSchool.alTerminology == 'COLLEGE') {
							wheatherSchool = false;
						}
						alinfomodel.set('wheatherSchool', wheatherSchool);
						alinfomodel.set('alId', alId);
						localStorage.setItem('wheatherSchool', wheatherSchool);
					} else {
						if (!isNullOrEmpty(responseData.COMPLETE_DAY)) {
							attendanceSettingModel.set('COMPLETE_DAY', responseData.COMPLETE_DAY);
							if (isNullOrEmpty(terminologyCheck) || !terminologyCheck) {
								var wheatherSchool;
								if (responseData.COMPLETE_DAY.alTerminology == 'SCHOOL') {
									wheatherSchool = true;
								} else if (responseData.COMPLETE_DAY.alTerminology == 'COLLEGE') {
									wheatherSchool = false;
								}
							}
						} else {
							delete attendanceSettingModel.data.COMPLETE_DAY
						}
						if (!isNullOrEmpty(responseData.MULTIPLE_SESSION)) {
							attendanceSettingModel.set('MULTIPLE_SESSION', responseData.MULTIPLE_SESSION);
							if (isNullOrEmpty(terminologyCheck) || !terminologyCheck) {
								var wheatherSchool;
								if (responseData.MULTIPLE_SESSION.alTerminology == 'SCHOOL') {
									wheatherSchool = true;
								} else if (responseData.MULTIPLE_SESSION.alTerminology == 'COLLEGE') {
									wheatherSchool = false;
								}
							}
						} else {
							delete attendanceSettingModel.data.MULTIPLE_SESSION
						}
						if (!isNullOrEmpty(responseData.COURSE_LEVEL)) {
							attendanceSettingModel.set('COURSE_LEVEL', responseData.COURSE_LEVEL);
							if (isNullOrEmpty(terminologyCheck) || !terminologyCheck) {
								var wheatherSchool;
								if (responseData.COURSE_LEVEL.alTerminology == 'SCHOOL') {
									wheatherSchool = true;
								} else if (responseData.COURSE_LEVEL.alTerminology == 'COLLEGE') {
									wheatherSchool = false;
								}
							}
						} else {
							delete attendanceSettingModel.data.COURSE_LEVEL
						}
						try {
							if (!isNullOrEmpty(responseData.SERVICE_LEVEL)) {
								attendanceSettingModel.set('SERVICE_LEVEL', responseData.SERVICE_LEVEL);
								if (isNullOrEmpty(terminologyCheck) || !terminologyCheck) {
									var wheatherSchool;
									if (responseData.SERVICE_LEVEL.alTerminology == 'SCHOOL') {
										wheatherSchool = true;
									} else if (responseData.SERVICE_LEVEL.alTerminology == 'COLLEGE') {
										wheatherSchool = false;
									}
								}
							} else {
								delete attendanceSettingModel.data.SERVICE_LEVEL
							}
						}
						catch (e) {
							//--
						}
						alinfomodel.set('alId', alId);
						if (isNullOrEmpty(terminologyCheck) || !terminologyCheck) {
							alinfomodel.set('wheatherSchool', wheatherSchool);
							localStorage.setItem('wheatherSchool', wheatherSchool);
						}
					}
				}
			});
		}
	},

	/**
	 * @author Deepak Nigam
	 */
	socialIntegrationCheckForMenu: function(menuItem) {
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.SOCIAL_INTEGRATION_LIST_COUNT,
			method: 'GET',
			success: function(res) {
				var socialloginMenu = menuItem.down("#socialMapping");
				var responseObj = Ext.decode(res.responseText);
				if (socialloginMenu) {
					if (responseObj.length == 0) {
						socialloginMenu.setVisible(false);
					}
					else {
						//socialloginMenu.setVisible(true);
					}
				}
			}
		});
	},
	loadCourseRegistrationScreen: function() {
		var COURSE_REGISTRATION_DASHBOARD_PRIVILEGES = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_COURSE_REGISTRATION_DASHBOARD_PRIVILEGES');
		var alIds = new Array(), this$ = this;
		this$.getController('Academia.controller.coursetransaction.studentperiodenrollment.StudentPeriodRegistrationController');
		var permission = this.getCurrentAcademyLocation();
		if (!permission) {
			return;
		}
		alIds.push(permission);
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(alIds, COURSE_REGISTRATION_DASHBOARD_PRIVILEGES);
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'VIEW') {
				this$.openTab(getMegaMenuTranslation('SP_PNC_REGISTRATION'), 'stcpncstudentregistration', CONSTANTS.MENU_COLOR_ONE, null, 'SP_COURSE_EXECUTION_MAIN');
				a = Ext.ComponentQuery.query('contentPanel');
				a[0].setActiveTab(0);
				return true;
			}
		});
	},
	getCheckVelocity: function() {
		if (!Ext.isDefined(Ext.app.checkVelocity)) {
			Ext.Ajax.request({
				type: 'rest',
				async: false,
				url: SERVERURL.PATH_CHECK_RELATIONSHIP,
				method: 'GET',
				headers: {
					'Content-Type': 'application/json'
				},
				success: function(response, action) {
					Ext.app.checkVelocity = Ext.decode(response.responseText);
				}
			});
		}
	},
	//===========Default Country Code===============//
	getDefaultCountryCode: function() {
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
			method: 'GET',
			success: function(response, action) {
				var MSSG = response.responseText;
				var jdata = Ext.decode(response.responseText);
				Ext.app.defaultCountryCode = jdata.isdCode;
			}
		});
	},
	linkCheck: function(url) {
		var http = new XMLHttpRequest();
		http.open('HEAD', url, false);
		http.send();
		return http.status != 404;
	},
	getAcademyLocationLogoForRestPasswordForm: function(academyLocationId, academyLocationDisplayName) {
		var this$ = this;
		var downloadUrl = SERVERURL.ACADEMY_LOCATION_LOGO_DOWNLOAD;
		var resetpasswordform = this$.getResetPasswordForm();
		var logoImgContainer = resetpasswordform.down("image#clientLogo");
		if (!isNullOrEmpty(academyLocationId) && academyLocationId > 0) {
			Ext.Ajax.request({
				type: 'rest',
				binary: true,
				url: downloadUrl,
				params: {
					'academyLocationId': academyLocationId
				},
				method: 'GET',
				scope: this,
				success: function(response) {
					if (response.responseBytes.length > 0) {
						var resetpasswordform = this$.getResetPasswordForm();
						var logoImgContainer = resetpasswordform.down("image#clientLogo");
						var blob = new Blob([response.responseBytes], { type: 'image/jpg' });
						var url = window.URL.createObjectURL(blob);
						if (!isNullOrEmpty(url)) {
							var domElm = logoImgContainer.getEl().dom;
							domElm.style.background = 'url(' + url + ')';
							domElm.style.width = '92%';
							domElm.style.backgroundSize = 'contain';
							domElm.style.backgroundRepeat = "no-repeat";
							domElm.style.backgroundPosition = "center";
							logoImgContainer.setSrc(null);
						}
						var image = new Image();
						image.src = url;
						image.onload = function() {
							var ratio = this.width / this.height;
							width = '50%'; //55*ratio;
							resetpasswordform.down('image#clientLogo').setWidth(width);
							resetpasswordform.doLayout();
						};
					}
					logoImgContainer.setWidth('auto');
					setTimeout(function() {
						Ext.ComponentQuery.query('resetpasswordform')[0].doLayout();
					}, 100);
				}
			});
			logoImgContainer.getEl().dom.src = 'resources/images/headerLogo/academiaLogo.png';
			logoImgContainer.setWidth('auto');
			setTimeout(function() {
				Ext.ComponentQuery.query('resetpasswordform')[0].doLayout();
			}, 100);
		} else {
			//In case of blank db, the academyLocation Id is set to 0, In this case returning the Default Academia Logo
			logoImgContainer.getEl().dom.src = 'resources/images/headerLogo/academiaLogo.png';
			setTimeout(function() {
				Ext.ComponentQuery.query('resetpasswordform')[0].doLayout();
			}, 100);
		}
	},

	filterSystemMenuWithAcademyLocationFeaturePrivilagesForApplicantForm: function(responseSystemMenuHierachyModels, selectedAcademyLocationId) {

		Ext.Array.each(Academia.utilities.accessControl.AccessControlManager.getAcademyLocationPrivileges(), function(academyLocationPrivileges, index) {

			if (academyLocationPrivileges.accessibleAcademyLocation.academyLocationId == selectedAcademyLocationId) {

				var level_0_systemMenuObj = [];
				Ext.Array.each(responseSystemMenuHierachyModels, function(level_0_systemMenuHierachyModels, index) {

					var featurePrivilege = academyLocationPrivileges.featurePrivileges;
					//Level 1
					var level_1_systemMenuObj = [];
					//Level 2
					var exist = false;
					var level_2_systemMenuObj = [];
					exist = Ext.Array.contains(featurePrivilege, level_0_systemMenuHierachyModels.featurePrivilegeId);
					if (exist) {
						level_0_systemMenuObj.push(level_0_systemMenuHierachyModels);
					}
				});
				academyLocationPrivileges.systemMenuHierachyModels = level_0_systemMenuObj;
			}
		});
	},

	/*set SMS char Limit for sent sms to recipient*/
	setSMSCharacterLimit: function(me, academyLocationId) {
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FIND_SMS_GATEWAY_CONFIGURATION_BY_ACADEMYLOCID,
			params: {
				academyLocationId: academyLocationId
			},
			method: 'GET',
			async: false,
			success: function(form, action) {
				if (!isNullOrEmpty(form.responseText)) {
					var formData = Ext.decode(form.responseText);
					if (formData[0] != undefined) {
						var charLimit = formData[0].charLimit;
						if (!isNullOrEmpty(charLimit)) {
							localStorage.setItem('maxLength', charLimit);
						} else {
							localStorage.setItem('maxLength', 160);
						}
					}

				} else {
					localStorage.setItem('maxLength', 160);
				}
			}
		});
	},
	loginUsingADFS: function(userHash) {
		/*var $this = this;
		var client_id;
		var clientSecret;
		var redirectUrl;
		var SocialIdModel = Academia.model.authentication.SocialIdModel;
		Ext.Ajax.request({
			url: 'oauth/token',
			method: 'POST',
			async: false,
			params: {
				portal_code : 'SSO',
				grant_type: 'password',
				client_id:'ssoclient', // Consumer Key
				client_secret: '$edu#app@24', // Consumer Secret
				username: 'SSO_USER',
				password: 'password' 
			},
			success: function(response) {
				$this.setDefaultHeaders(response);
				$this.loginUsingADFSResponse(false,true,userHash,'3',userHash);
			},
			failure: function(response) {
				console.log("internal server error....ADFS Login");
			}
		});	*/

	},
	loginUsingADFSResponse: function(button, isSocial, socialId, socialValue, userHash) {
		var this$ = this;
		var username;
		var password;
		var authFrom;
		if (button) {
			authFrom = button.up('form')
		} else {
			authFrom = this.getAuthForm();
		}
		authFrom.hide();
		username = socialId;
		password = ''
		var myMask = new Ext.LoadMask(Ext.getBody(), { msg: getCommonTranslation('PLEASE_WAIT_WHILE_SYSTEM_IS_INITIALIZING'), msgCls: 'msgClsCustomLoadMask' });
		Ext.Ajax.request({
			url: 'oauth/token',
			method: 'POST',
			async: false,
			params: {
				portal_code: 'SSO_ADFS',
				grant_type: 'password',
				client_id: 'erpclient', // Consumer Key
				client_secret: '#edu$erp#2016$', // Consumer Secret
				username: username,
				password: password
			},
			success: function(response) {
				this$.loadApplication(response, myMask, authFrom);
			},
			failure: function(response) { }
		});
	},
	loadApplication: function(response, myMask, authFrom) {
		var this$ = this;

		this$.customMasking(myMask);
		Ext.defer(function() {
			this$.setDefaultHeaders(response);
			/*var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');
			if(idTableMappingStore){
				idTableMappingStore.load();
			}*/
			this$.getOrgSettingOnLogin();
			this$.loadCurrencyMasterData();
			this$.findAllCustomTableConfiguration();
			this$.getCheckVelocity();
			this$.getFeaturePrivileges(this$, null, false, authFrom);
			//this$.getDefaultCountryCode();
			//        		this$.getFeaturePrivilegesLoginAccess(this$, null, false, authform);
			try {
				if (Ext.isDefined(Ext.ComponentQuery.query("#organizationLogoLeft")[0])) {
					Ext.ComponentQuery.query("#organizationLogoLeft")[0].setVisible(false)
				}
			}
			catch (eeee) {
			}
			myMask.hide();
		}, 1, this$);
	},
	changeStudent: function() {
		if (!Ext.ComponentQuery.query('changestudentwindow')[0]) {
			this.showWindow('changestudentwindow');
		} else {
			Ext.ComponentQuery.query('changestudentwindow')[0].show();
		}
		var userInfo = Academia.model.authentication.UserInfoModel;
		portalId = userInfo.get("portalId");

		if (portalId != 6) {
			var verticalNavigationMenu = this.getVerticalNavigationMenu();
			verticalNavigationMenu.collapse();
		}
	},
	translateWithGoogle: function() {
		if (!Ext.ComponentQuery.query('googletranslationwindow')[0]) {
			this.showWindow('googletranslationwindow');
		} else {
			Ext.ComponentQuery.query('googletranslationwindow')[0].show();
		}
	},
	loadIdConfiguredTableData: function() {
		var idTableMappingStore = Ext.data.StoreManager.lookup('datasetting.IdTableMappingStore');
		if (idTableMappingStore) {
			idTableMappingStore.load();
		}
	},
	/*loadCurrencyRegionCodeStore: function(){
		Ext.data.StoreManager.lookup('othermasters.currencymaster.CurrencyRegionCodeStore').autoLoad = true;
		Ext.data.StoreManager.lookup('othermasters.currencymaster.CurrencyRegionCodeStore').load();
	},*/
	loadDataAfterLogin: function() {
		var me = this;
		if (environment == "Production") {
			var newJSArray = [
				'resources/js/ckeditor/ckeditor.js',
				 'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js',
			     'https://cdnjs.cloudflare.com/ajax/libs/moment-timezone/0.5.45/moment-timezone.min.js',
				'resources/jsPDF/jspdf.min.js',
				'resources/jsPDF/jspdf.plugin.table.js',
				'resources/jsSvgToPng/canvg.js',
				'resources/js/html2canvas.min.js',
				'constants.js',
				'webcam/webcam.js'
			];
			loadAsync(newJSArray, 0);
		}
		if (portalId == 7 || portalId == 3) {
			me.getCheckStudentHostelTransportLink();
		}
		var alId = localStorage.getItem('academylocationid');
		var p = {};
		var ui = me.getUserInfo();
		p.academyLocationId = alId;
		me.socialIntegrationCheckForMenu(ui);
		me.setSMSCharacterLimit();
		me.getCheckVelocity();
		me.findAllCustomTableConfiguration();
		me.loadCurrencyMasterData();
		me.loadIdConfiguredTableData();
		me.initializeAcademyLocationAndOrganization();
		me.loadMultipleLangFilePerAL(alId);
		if (portalId != 6) {
			me.getDynamicForFormFieldsInfo(p);
		}
		me.updateAcademyLocationId(p);
		//    	me.getMessageCount(me);
		me.getDefaultCountryCode();
		//me.loadCurrencyRegionCodeStore();

		setTimeout(function() {
			var orgModel = Academia.model.common.OrgSettingDateTimeModel;
			if (orgModel.get('applicationPageSize') && !isNullOrEmpty(orgModel.get('applicationPageSize'))) {
				CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE = orgModel.get('applicationPageSize');
				CONSTANTS.DEFAULT_PAGESIZE = orgModel.get('applicationPageSize');
			}
		}, 1000);
		setTimeout(function() {
			var orgModel = Academia.model.common.OrgSettingDateTimeModel;
			if (orgModel.get('applicationPageSize') && !isNullOrEmpty(orgModel.get('applicationPageSize'))) {
				CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE = orgModel.get('applicationPageSize');
				CONSTANTS.DEFAULT_PAGESIZE = orgModel.get('applicationPageSize');
			}
		}, 3000);
		setTimeout(function() {
			var orgModel = Academia.model.common.OrgSettingDateTimeModel;
			if (orgModel.get('applicationPageSize') && !isNullOrEmpty(orgModel.get('applicationPageSize'))) {
				CONSTANTS.DEFAULT_TAB_GRID_PAGESIZE = orgModel.get('applicationPageSize');
				CONSTANTS.DEFAULT_PAGESIZE = orgModel.get('applicationPageSize');
			}
		}, 5000);
	},
	loadUserLanguages: function() {
		var me = this;
		var languageStore = Ext.getStore('common.ChangeLanguageStore');
		languageStore.removeAll();
		languageStore.load({
			callback: function() {
				var defaultLanguageRecord = {
					id: null,
					code: "default",
					visibility: true,
					itemValue: "English"
				};
				languageStore.add(defaultLanguageRecord);
				languageStore.filter('visibility', true);
			}
		});
	},
	addFeePayerDetailParentPortalTab: function(tabTitle, contentXtype, menuColorcls) {
		var contentPanel = Ext.ComponentQuery.query('contentPanel')[0];
		this.loadContollers('contentPanel');
		var newTab = contentPanel.items.findBy(function(tab) {
			return tab.title === tabTitle;
		});
		if (!newTab) {
			newTab = contentPanel.add({
				xtype: 'personinfostudentportal',
				closable: true,
				menuColorCls: menuColorcls,
				title: tabTitle,
				contentXtype: 'feepayerdetailgrid',
				contentXtypeItemId: 'parentFeePayerDetailGridItemId',
				items: []
			});
			newTab.add({
				xtype: 'feepayerdetailcardlayoutview'
			});
		}
		contentPanel.setActiveTab(newTab);
		$('#innerSpinner').hide();
		Ext.getBody().unmask();
		return newTab;
	},
	getCheckStudentHostelTransportLink: function() {
		var userInfo = Academia.model.authentication.UserInfoModel;
		var academyLocationPrivilegeList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
		academyLocationId = academyLocationPrivilegeList[0].id;
		var getViewUrl = SERVERURL.PATH_FIND_SERVICES_BYACADEMYLOCATIONID_FOR_PERMISSION;
		Ext.Ajax.request({
			type: 'rest',
			url: getViewUrl + '?academyLocationId=' + academyLocationId,
			method: 'GET',
			headers: {
				'Content-Type': 'application/json'
			},
			success: function(response) {
				var data = Ext.decode(response.responseText);
				if (data.isHostelService) {
					// parent portal Links
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_HOSTEL_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_HOSTEL_DETAILS') + ']'), function(btn) {
							btn.show();
						});
					}
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'), function(btn) {
							btn.show();
						});
					}
					//Student Portal Links
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_DETAILS') + ']'), function(btn) {
							btn.show();
						});
					}
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'), function(btn) {
							btn.show();
						});
					}
				} else {
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_HOSTEL_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_HOSTEL_DETAILS') + ']'), function(btn) {
							btn.hide();
						});
					}
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'), function(btn) {
							btn.hide();
						});
					}
					//Student Portal Links
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_DETAILS') + ']'), function(btn) {
							btn.hide();
						});
					}
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_HOSTEL_PERSONAL_REQUIREMENTS') + ']'), function(btn) {
							btn.hide();
						});
					}
				}
				if (data.isTransportService) {
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_TRANSPORT_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_TRANSPORT_DETAILS') + ']'), function(btn) {
							btn.show();
						});
					}
					//Student Portal Links
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_TRANSPORT_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_TRANSPORT_DETAILS') + ']'), function(btn) {
							btn.show();
						});
					}

				} else {
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_TRANSPORT_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('PP_STUDENT_TRANSPORT_DETAILS') + ']'), function(btn) {
							btn.hide();
						});
					}
					//Student Portal Links
					if (Ext.isDefined(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_TRANSPORT_DETAILS') + ']'))) {
						Ext.each(Ext.ComponentQuery.query('button[text=' + getMegaMenuTranslation('SP_TRANSPORT_DETAILS') + ']'), function(btn) {
							btn.hide();
						});
					}
				}
			}
		});
	},
	completeTheRegistrationProcess: function(button, win) {
		var $this = this;
		/*var feePayerDetailTab=$this.getTabReferenceByTabTitle(getMegaMenuTranslation('PP_FEE_PAYER_DETAILS'));                    
		if(feePayerDetailTab) {
			$this.closeTab(feePayerDetailTab);
		}
		$this.addFeePayerDetailParentPortalTab(getMegaMenuTranslation('PP_FEE_PAYER_DETAILS'), 'feepayerdetailgrid', CONSTANTS.MENU_COLOR_FIVE);*/
		Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
		var contentpanel = $this.getContentpanel();
		var studentRegistrationStructure = Ext.widget("studentregistrationtabstructure", {
			isRegisterBtn: null
		});

		Ext.each(getResponseList, function(record) {
			if (record.paymentTermName == 'CURRENT_PAYMENT_TERM' && record.registrationStatus == "InCompleted") {
				studentRegistrationStructure.isRegisterBtn = true;
				return false;
			}
		});
		/*code start here for mentioned scenario V2D-460381*/
		Ext.each(getResponseList, function(record) {
			if ((!isNullOrEmpty(record.endRegistrationDate)) && (record.paymentTermName == 'CURRENT_PAYMENT_TERM') && (record.registrationStatus == "InCompleted") && (dateRender(record.endRegistrationDate) >= dateRender(new Date()))) {
				studentRegistrationStructure.isRegisterBtn = true;
				return false;
			} else if ((!isNullOrEmpty(record.endRegistrationDate)) && (record.paymentTermName == 'NEXT_PAYMENT_TERM') && (dateRender(record.endRegistrationDate) >= dateRender(new Date()))) {
				studentRegistrationStructure.isRegisterBtn = false;
			}
		});
		/*code end here for mentioned scenario V2D-461356*/

		var tabName = getFeeAndPaymentCommonTranslation('REGISTRATION_DETAILS');
		var newTab = this.getTabReferenceByTabTitle(tabName);
		var getcontroller = $this.getController('menu.CoreERPNavigationController');
		var getTab = getcontroller.getTab(tabName);
		if (getTab != null) {
			contentpanel.remove(getTab, true);
		}
		openTab(contentPanel, tabName, studentRegistrationStructure, CONSTANTS.MENU_COLOR_TWO);
		contentPanel.setActiveTab(newTab);

		if (Ext.isDefined(win)) {
			win.close();
		}
	},

	setPortalDetails: function(view) {
		var portalName;
		var portalIcon;
		var portalId = this.getCurrentLoggedPortalId();
		switch (portalId) {
			case '1':
			case 1:
				portalName = getCommonTranslation('PN_ADMIN');
				portalIcon = 'build/testing/Academia/resources/images/portal-identifier/portal_identifier_admin.svg';
				break;

			case '6':
			case 6:
				portalName = getCommonTranslation('PN_APPLICANT');
				portalIcon = 'build/testing/Academia/resources/images/portal-identifier/portal_identifier_applicant.svg';
				view.down('#portalNameItemId').addCls('portal-name-position');
				break;

			case '3':
			case 3:
				portalName = getCommonTranslation('PN_STUDENT');
				portalIcon = 'build/testing/Academia/resources/images/portal-identifier/portal_identifier_student.svg';
				break;

			case '7':
			case 7:
				portalName = getCommonTranslation('PN_PARENT');
				portalIcon = 'build/testing/Academia/resources/images/portal-identifier/portal_identifier_parent.svg';
				view.down('#portalNameItemId').addCls('portal-name-position');
				break;

			case '2':
			case 2:
				portalName = getCommonTranslation('PN_TEACHER');
				portalIcon = 'build/testing/Academia/resources/images/portal-identifier/portal_identifier_teacher.svg';
				view.down('#portalNameItemId').addCls('portal-name-position');
				break;
		}
		view.down('#portalNameItemId').setText(portalName);
		view.down('#portalIconItemId').setSrc(portalIcon);
	},
	generalSurveyWindow: function(view) {
		var window = this.getGeneralsurveyhomepagescreen();
		if (!window) {
			window = Ext.widget('generalsurveyhomepagescreen', {
				hidden: true,
				listeners: {
					afterrender: function(cmp) {
						cmp.getEl().setStyle('opacity', '0');
						cmp.show(); // call show after opacity is set
					}
				}
			});
		}
		window.show();
		window.close();
	},

	addApplicantLinkClickHandler: function(view) {
		this.applyWindowMask();

		var me = this, html;

		var code = ""
		var el = view.getEl();
		//var activityFeedTypeGrid = Ext.ComponentQuery.query('activityfeedtypegrid')[0];
		if (me.activityFeedTypeRecordIndex && me.activityFeedTypeRecordIndex.data) {
			html = me.activityFeedTypeRecordIndex.data.msgContent;
		}
		var div = document.createElement('div');
		div.innerHTML = html;

		var link = div.getElementsByClassName('application-code-link')[0];
		if (link) {
			code = link.textContent.trim();
		}
		if (code) {
			var submitUrl = SERVERURL.APPLICANT_SMART_SEARCH;
			Ext.Ajax.request({
				type: 'rest',
				async: false,
				url: submitUrl + '?codeOrName=' + code,
				method: 'GET',
				success: function(res, action) {
					if (res.responseText) {
						var response = Ext.decode(res.responseText);
						if (response) {
							view.applicationResponce = {};
							view.applicationResponce.data = response[0];
							if (response[0]) {
								view.flag = true;
								var submitUrl = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
								submitUrl = submitUrl.concat("?id=" + response[0].id);
								Ext.Ajax.request({
									type: 'rest',
									async: false,
									url: submitUrl,
									method: 'GET',
									success: function(res, action) {
										if (res.responseText) {
											var resp = Ext.decode(res.responseText);
											if (resp) {
												view.summeryResponce = {};
												view.summeryResponce.data = resp;
												me.hideWindowMask();
											}
										}
									}
								});
							} else {
								view.flag = false;
							}
						}
					}
					me.hideWindowMask();
				}
			});

			if (el) {
				el.on('click', function(event, target) {
					event = event || window.event;
					target = target || event.target;

					if (event.stopPropagation) {
						event.stopPropagation();
					} else {
						event.cancelBubble = true;
					}

					var targetEl = Ext.fly(target);

					if (event.target.tagName == 'A' && view.flag) {
						Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
						Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
						Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
						Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
						Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
						Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
						Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
						Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
						Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
						Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
						Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
						Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
						Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
						Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
						Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
						Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
						Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
						Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');

						var record = view.applicationResponce;
						var tabTitle = null;
						var personId = null;
						var applicationId = null;
						var admissionId = null;
						tabTitle = record.data.code;
						personId = record.data.personId;
						applicationId = record.data.id;
						admissionId = record.data.code;


						var newRec = view.summeryResponce;

						record.data.admissionID = '';
						record.data.admissionStatus = '';
						record.data.applicationID = applicationId;
						record.data.APPLICATION_STATUS = newRec.data.currentStatus;
						record.data.isDirectAdmission = false;
						record.data.isEditMode = true;
						record.data.isFormSoldApplication = false;
						record.data.isMidTermAdmission = false;
						record.data.isNewApplication = false;
						record.data.isViewMode = false;
						record.data.programStatus = '';
						record.data.stageStatus = "";

						var applicationBaseController = Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
						var me = applicationBaseController;
						var applicantProfile = me.getTabReferenceByTabTitle(tabTitle);
						if (applicantProfile) {
							me.getContentPanel().setActiveTab(applicantProfile);
							me.gettingDataInSummaryGrid(applicantProfile);
							view.up('window').close();
						} else {
							me.addContentPanelTab(tabTitle, 'applicantprofile', null, personId, applicationId, null);
							var applicantProfile = me.getTabReferenceByTabTitle(tabTitle);
							if (applicantProfile) {
								me.setParameterForApplicantProfile(applicantProfile, record, '', false);
								me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile, true);
								me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile, true);
								var applicantLinkPanelObject = me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
								me.gettingDataInSummaryGrid(applicantProfile);
								view.up('window').close();
								if (!isEmpty(applicantLinkPanelObject)) {
									var personalDetailObject = applicantLinkPanelObject.PERSONAL_INFORMATION[0];
									me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId, personalDetailObject.defaultPanel);

									var admissionDetailObject = applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];
									me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId, admissionDetailObject.defaultPanel);

									var personInfoPanel = applicantProfile.down("#personInfoPanel");
									if (personInfoPanel) {
										var applicantPersonalDetails = personInfoPanel.down("#applicantPersonalDetails");
										if (applicantPersonalDetails) {
											personInfoPanel.setActiveTab(applicantPersonalDetails);
										}
									}

								}

							}
						}
					}
					else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DO_NOT_HAVE_ACCESS_TO_APPLICANT_PROFILE.'));
					}
				}, me, { delegate: 'a' });
			}
		} else {
			me.hideWindowMask();
		}
	},
	onClickAcademiaAILogo: function() {
		var url = window.location.href;
		var data = null;
		Ext.Ajax.request({
			url: 'rest/academiaChatBotLoginResource/loginToAcademiaAIChatbot',
			method: 'GET',
			params: { clientCode: this.getSubdomain(url) },
			success: function(response) {
				try {
					data = Ext.decode(response.responseText);
				} catch (e) {
					console.warn('Invalid JSON from server:', e);
					return;
				}
				// Show warning if Token is null
				if (!data || !data.body || isNullOrEmpty(data.body.token)) {
					if (data.statusCode == 'BAD_REQUEST') {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BAD_REQUEST'));
					} else if (data.statusCode == 'ACCESS_UNAVAILABLE') {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ACCESS_UNAVAILABLE'));
					} else if (data.statusCode == 'CONFIGURATION_IS_MISSING') {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CONFIGURATION_IS_MISSING'));
					}
					return;
				}
				// Get user info
				var userInfo = data.body;
				var token = userInfo.token;
				var chatBotRedirectURL = userInfo.chatBotRedirectURL || '';

				// Build final redirect URL with params
				var redirectUrl = chatBotRedirectURL
					+ '?token=' + token;

				// Open the URL with headers/payload-like data embedded
				//console.log(redirectUrl);
				window.open(redirectUrl, '_blank');
			},
			failure: function(response) {
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SERVER_ERROR_MSG_IVR'));
			}
		});
		/*var redirectUrl = 'https://ai-preprod-chatbot.academiaerp.com/chatbot/?clientCode=HANDSONACADEMIAERPCOM&userCode=EMP196&token=eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJFTVAxOTYiLCJhaVVzZXJJZCI6MjAyLCJyb2xlcyI6WyJBZG1pbiJdLCJDTElFTlRfQ09ERSI6IkhBTkRTT05BQ0FERU1JQUVSUENPTSIsImlhdCI6MTc2MTY0ODE3OCwiZXhwIjoxNzYxNjUxNzc4fQ.5pwpuQtiGKMf82_5kqqRvWqqN2AEx4vcMKmrhM06ywrJA_pcncZhBAM2yegf35e15X_aQtxLXc2Bh70cPkxWOw';
		console.log(redirectUrl);
		window.open(redirectUrl, '_blank');*/
	},

	getSubdomain: function(url) {
		var remainingUrl, startIndex, endIndex, fullDomain;
		//url = 'https://handson.academiaerp.com/'

		// 1. Remove the protocol (up to //)
		startIndex = url.indexOf('//');
		if (startIndex !== -1) {
			remainingUrl = url.substring(startIndex + 2); // Start after '//'
		} else {
			remainingUrl = url; // No protocol found, use the whole string
		}

		// 2. Find the end of the domain (first '/')
		endIndex = remainingUrl.indexOf('/');
		if (endIndex !== -1) {
			fullDomain = remainingUrl.substring(0, endIndex); // Get only the domain part
		} else {
			fullDomain = remainingUrl; // No path found, use the rest of the string
		}

		// Handle case where the URL might end with '#'
		endIndex = fullDomain.indexOf('#');
		if (endIndex !== -1) {
			fullDomain = fullDomain.substring(0, endIndex);
		}

		// 3. Replace all dots (.) and hyphens (-)
		// Use the RegExp constructor for compatibility, although a simple global replace should work too.
		var processedString = fullDomain.replace(/\./g, '');
		processedString = processedString.replace(/-/g, '');
		// 4. Convert to uppercase
		return processedString.toUpperCase();
	}
});


