/**
 * @author Rohit Thadani
 */
Ext.define('Academia.controller.committee.committee.StudentCommitteeController', {
	extend: 'Academia.controller.base.BaseController',
	// un-comment the model code if required.
	//models : [''],
	
	models: ['facilitiesresources.resourcebooking.StudentResourceBookingOverViewModel', 'facilitiesresources.resourcebooking.FacilityTreeModel'],
	
	stores : ['committee.committee.StudentCommitteeGridStore','committee.committee.StudentCommitteeStore','hostel.roomallocation.UserSmartSearchByUserType', 'attendance.UserGroup','messaging.MessagingTemplatesStore',
	          'common.AcademyLocationNameSeparated','transport.serviceRoute.InternalUser','common.StatusComboStore','committee.committee.CommitteeParticipantGridStore',
	          'committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore','user.UserAcademyLocationStore',
	          'facilitiesresources.resourcebooking.ResourceBookingPurposeStore',
	          'facilitiesresources.resourcebooking.EventResourceGroupStore',
	          'facilitiesresources.resourcebooking.AdhocStatusStore',
	          'facilitiesresources.resourcebooking.ResourceTypeStore',
	          'facilitiesresources.resourcebooking.InternalFacilityResourceListStore',
	          'facilitiesresources.resourcebooking.IndependentEquipmentResourceListStore',
	          'facilitiesresources.resourcebooking.ExternalFacilityEquipmentListStore',
	          'facilitiesresources.resourcebooking.ListOfWhetherFacultyStore',
	          'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
	          'facilitiesresources.resourcebooking.CourseVariantsListStore',
	          'servicerequest.eventcalendar.EventCalendarName',
	          'facilitiesresources.resourcebooking.StudentResourceBookingStore',
	          'course.QuestionPaperBankDocument',
	          'transport.serviceRoute.WeekDays',
	          'facilitiesresources.resourcebooking.employeePortal.EmployeeEventNameStore','common.ApplyForCommitteeStatusComboStore',
	          'committee.committee.StudentApplyForCommitteeStore','committee.committee.MembershipTypeByCommitteeStore',
	          'committee.committee.CommitteeRequestIdStore','committee.committee.StudentApplyForCommitteeGridStore','committee.committee.CommitteeMemberShipTypeStore',
	          'committee.committee.CommitteeMemberShipTypeByCommitteeIdStore'
	          ],
	views : ['committee.committee.StudentCommitteeTabStructure','committee.committee.StudentCommitteeStructure','committee.committee.StudentCommitteeFilter','committee.committee.StudentCommitteeALWindow',
	         'committee.committee.StudentCommitteeGrid','committee.committee.StudentCommitteeForm','committee.committee.CommitteeALGrid', 'committee.committee.StudentParticipantGrid',
	         'committee.committee.StudentAddCommitteeParticipant','committee.committee.CommitteeSendMessage','messaging.StaticDocumentAttachmentGrid',
	         'facilitiesresources.resourcebooking.StudentResourceBookingFormLayout', 'facilitiesresources.resourcebooking.ResourceBookingFormAcademyLocationGrid',
	         'facilitiesresources.resourcebooking.ResourceBookingFormUserGrid',
	         'facilitiesresources.resourcebooking.StudentResourceBooking',
	         'facilitiesresources.resourcebooking.StudentResourceBookingListSearchForm',
	         'facilitiesresources.resourcebooking.StudentResourceBookingGrid',
	         'examinationcenters.questionPaperBank.MeetingDocumentGrid',
	         'committee.committee.StudentApplyForCommitteeStructure','committee.committee.StudentApplyForCommitteeTabStructure',
	         'committee.committee.StudentApplyForCommitteeFilter','committee.committee.StudentApplyForCommitteeGrid',
	         'committee.committee.StudentCommitteeRequestTabStructure','committee.committee.StudentCommitteeRequestStructure','committee.committee.StudentCommitteeRequestPanel',
	         'committee.committee.StudentCommitteeRequesterDetailsPanel','committee.committee.StudentCommitteeRequestBasicDetails'
	         ],
	refs : [{
    	ref : 'studentcommitteestructure',
    	selector : 'studentcommitteestructure'
    },{
    	ref : 'studentcommitteefilter',
    	selector : 'studentcommitteefilter'
    },{
    	ref: 'studentcommitteegrid',
    	selector: 'studentcommitteegrid'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref: 'studentcommitteeform',
    	selector: 'studentcommitteeform'
    },{
    	ref: 'studentcommitteealwindow',
    	selector: 'studentcommitteealwindow'
    },{
    	ref: 'studentaddcommitteeparticipant',
    	selector: 'studentaddcommitteeparticipant'
    },{
    	ref: 'studentparticipantgrid',
    	selector: 'studentparticipantgrid'
    },{
    	ref :'committeesendmessage',
    	selector : 'committeesendmessage'
    },{
    	ref :'staticDocumentAttachmentGrid',
    	selector : 'staticdocumentattachmentgrid[itemId =staticDocumentAttachmentGridMessage]'
    },{
    	ref :'studentresourcebookingformlayout',
    	selector : 'studentresourcebookingformlayout'
    },{
    	ref :'resourcebookingacadlocgrid',
    	selector : 'resourcebookingacadlocgrid'
    },{
    	ref :'resourcebookingusergrid',
    	selector : 'resourcebookingusergrid'
    },{
        ref: 'studentresourcebookinglistsearchform',
        selector: 'studentresourcebookinglistsearchform[itemId=studentresourcebookinglistsearchform]'
    },{
        ref: 'studentresourcebookinggrid',
        selector: 'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid]'
    },{
    	ref :'meetingdocumentgrid',
    	selector : 'meetingdocumentgrid'
    },{
    	ref : 'studentapplyforcommitteestructure',
    	selector : 'studentapplyforcommitteestructure'
    },{
    	ref : 'studentapplyforcommitteefilter',
    	selector : 'studentapplyforcommitteefilter'
    },{
    	ref: 'studentapplyforcommitteegrid',
    	selector: 'studentapplyforcommitteegrid'
    },{
    	ref: 'studentcommitteerequesterdetailspanel',
    	selector: 'studentcommitteerequesterdetailspanel'
    },{
    	ref: 'studentcommitteerequestbasicdetails',
    	selector: 'studentcommitteerequestbasicdetails'
    },{
    	ref: 'studentcommitteerequestpanel',
    	selector: 'studentcommitteerequestpanel'
    	
    }],
    config:{
		STUDENT_COMMITTEE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_COMMITTEE_PRIVILEGES'),
		STUDENT_COMMITTEE_SCHEDULE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_COMMITTEE_SCHEULE_PRIVILEGES'),
		PARENT_COMMITTEE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_COMMITTEE_PRIVILEGES'),
		PARENT_COMMITTEE_SCHEDULE_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_COMMITTEE_SCHEULE_PRIVILEGES'),
		FACULTY_PROFILE_MY_COMMITTEES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_MY_COMMITTEES_PRIVILEGES'),
		STUDENT_APPLY_FOR_COMMITTEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_APPLY_FOR_COMMITTEE_PRIVILEGES'),

		//TNS_MANAGE_COMMITTEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_COMMITTEE_PRIVILEGES'),
    	//COMMITTEE_PARTICIPANT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMMITTEE_PARTICIPANT_PRIVILEGES')
	},
    init : function() {
    	this.control({
    		'studentcommitteefilter button[itemId=searchBtn]': {
    			click: this.loadCommitteeGrid
    		},
    		'studentcommitteefilter button[itemId=resetBtn]': {
    			click: this.resetCommitteeFilter
    		},
    		'studentcommitteegrid button[itemId=btnDelete]':{
    			//click: this.deleteCommitteeRecord
    		},
    		'studentcommitteegrid button[itemId=btnAdd]':{
    			//click: this.addCommitteeRecord
    		},
    		'studentcommitteegrid button[itemId=btnView]':{
    			click: this.viewCommitteeRecord
    		},
    		'studentcommitteegrid button[itemId=btnEdit]':{
    			//click: this.editCommitteeRecord
    		},
    		'studentcommitteeform button[itemId=submitBtn]':{
    			//click: this.saveCommitteeRecord
    		},
    		
    		'studentcommitteegrid button[itemId=addMeetingBtn]':{
    			//click: this.openAddMeetingTab
    		},
    		
    		'studentcommitteegrid button[itemId=sendMessageBtn]':{
    			//click: this.openCommitteeSendMessage
    		},
    		'studentapplyforcommitteefilter button[itemId=searchBtn]': {
    			click: this.loadApplyForCommitteeGrid
    		},
    		'committeesendmessage radiogroup[itemId=messageType]':{
    			change : function(val,nV,oV){
    				this.selectSectionMessageType(val,nV,oV);
    			}
    		},
    		'committeesendmessage customcombobox[itemId=msgTempletId]':{
    			select : function(obj,rec){
    				this.selectMessageTemp(obj,rec);
    			}
    		},
    		/*V2D-13247*/
    		'committeesendmessage textarea[itemId=smsDiscription]':{
    			change : function(val,nV,oV){
    				var committeeSendMessage = this.getCommitteesendmessage();
    				var smsTextField = committeeSendMessage.down('#smsDiscription');
    				var smsTextFieldDiscription = committeeSendMessage.down('#smsDiscriptionNotice');
    				var maxLength = localStorage.getItem('maxLength');
    				var newValue = maxLength - smsTextField.getValue().length;
    				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
    			}
    		},
    		'studentcommitteeform':{
    			render:function(){
    				var $this = this;
    				var form = $this.getStudentcommitteeform().getForm();
    				var alFilter = form.findField('multiselectAcademyLocation').getStore();
    				alFilter.getProxy().extraParams={
    					id:$this.getCurrentlyLoggedInUser().id
    				};
    				alFilter.load();
    			}
    		},
    		
    		'studentcommitteegrid':{
    			render: function(grid){
    				var $this = this;
    				var portalId = this.getCurrentLoggedPortalId();
    				if (portalId == 3){
    					this.doAccessControlValidation(grid, this.getSTUDENT_COMMITTEE_DETAILS_PERMISSIONS());
    				}else if (portalId == 7){
    					this.doAccessControlValidation(grid, this.getPARENT_COMMITTEE_DETAILS_PERMISSIONS());
    				} else if (portalId == 2){
    					this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_MY_COMMITTEES_PERMISSIONS());
    				}
    				
    				grid.getStore().removeAll();
    				grid.getStore().loadData([]);
    			},
    			cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					if (e.target.tagName == 'A') {
						var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
						var portalId = this.getCurrentLoggedPortalId();
						var academyLocationId = this.getCurrentAcademyLocation();
		 				var associatedAcadLocationIds = new Array();
		 				associatedAcadLocationIds.push(academyLocationId);
						var $this = this;
						var doOpenTab = false;
						if(dataIndex == 'noOfParticipants'){
							if(portalId == 3){
				 				  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getSTUDENT_COMMITTEE_DETAILS_PERMISSIONS());
				 				 Ext.each(permissionList, function(privilege) {
				 					  if (privilege === 'PARTICIPANT_HYPERLINK') {
				 						 doOpenTab = true;
				 					  } 
				 				  });
				 				  if(doOpenTab){
				 					 $this.openAddParticipantDetails(dataIndex, record);
				 				  }else{
				 						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PERMISSSION_HAS_NOT_BEEN_GRANTED'));  
				 				  }
							}else if(portalId == 7){
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getPARENT_COMMITTEE_DETAILS_PERMISSIONS());
								Ext.each(permissionList, function(privilege) {
				 					  if (privilege === 'PARTICIPANT_HYPERLINK') {
				 						 doOpenTab = true;
				 					  } 
				 				  });
				 				  if(doOpenTab){
				 					 $this.openAddParticipantDetails(dataIndex, record);
				 				  }else{
				 						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PERMISSSION_HAS_NOT_BEEN_GRANTED'));  
				 				  }
							}else if(portalId == 2){
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getFACULTY_PROFILE_MY_COMMITTEES_PERMISSIONS());
								Ext.each(permissionList, function(privilege) {
				 					  if (privilege === 'PARTICIPANT_HYPERLINK') {
				 						 doOpenTab = true;
				 					  } 
				 				  });
				 				  if(doOpenTab){
				 					 $this.openAddParticipantDetails(dataIndex, record);
				 				  }else{
				 						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PERMISSSION_HAS_NOT_BEEN_GRANTED'));  
				 				  }
							}
						
						} else {
							var formWindow = $this.getStudentcommitteealwindow();
							if (!formWindow) {
								Ext.widget('studentcommitteealwindow');
								formWindow = $this.getStudentcommitteealwindow();
								formWindow.setHeight(300);
								formWindow.setWidth(600);
							}
							$this.fillALRelatedGrid(formWindow, dataIndex, record);
						}
					}
    			},
    			select:function(obj, record,rowIndex, e){
    				var $this = this;
    				var grid = $this.getStudentcommitteegrid();
    				/*if(obj.selected.items.length==1){
    					grid.down('#addMeetingBtn').setDisabled(false);
    				} else {
    					grid.down('#addMeetingBtn').setDisabled(true);
    				}*/
    			},
    			deselect:function(obj, record, rowIndex, e){
    				var $this = this;
    				var grid = $this.getStudentcommitteegrid();
    				/*if(obj.selected.items.length==1){
    					grid.down('#addMeetingBtn').setDisabled(false);
    				} else {
    					grid.down('#addMeetingBtn').setDisabled(true);
    				}*/
    			}
    		},
    		
    		'studentparticipantgrid button[itemId=btnSaveItemId]':{
    			//click: this.updateCommitteeParticipantRecord
    		},
    		
    		'studentparticipantgrid button[itemId=btnAdd]':{
    			click: function(){
    				//this.openCommitteeParticipant();
    			}
    		},
    		'studentcommitteealwindow customcombobox[itemId=userType]':{
    			select:function(obj,rec){
    				var $this = this;
    				var form = $this.getStudentcommitteealwindow();
    				form.down('#assignedUser').setDisabled(false);
    				var assignedUserStore = form.down('#assignedUser').getStore();
    				
    				var store = $this.getStore('user.UserAcademyLocationStore');
    	        	var alids=[];
    	        	store.getProxy().extraparams={
    	        		id:$this.getCurrentlyLoggedInUser().id
    	        	}
    	        	store.load({
    	        		callback:function(record) {
    	        			for (var i in record) {
    	        				alids.push(record[i].data.id);
    	        			}
    	        			assignedUserStore.getProxy().extraParams = {
	        					userType:rec[0].data.id,
	        					academyLocationIds:alids.join()
	        				};
	        				assignedUserStore.load();
    	        		}
    	        	});
    			}
    		},
    		
    		'studentcommitteealwindow button[itemId=submitCommitteeParticipantBtn]':{
    			click:function(obj,rec){
    				var $this = this;
    				var form = $this.getStudentcommitteealwindow();
    				$this.saveParticipantDetails(form);
    			}
    		},
    		
    		'studentparticipantgrid button[itemId=btnDelete]':{
    			click: this.deleteCommitteeParticipant
    		},
    		
    		'committeesendmessage button[itemId=adhocMsgSubmitBtn]':{
    			click: function(obj) {
    				var grid = this.getStudentcommitteegrid();
    				var committeesendmessage = this.getCommitteesendmessage();
    				committeesendmessage.sendMessage(obj,grid);
    			}
    		},
    		
    		'committeesendmessage customcombobox[itemId=selectTemplate]':{
    			select: function(obj, record) {
    				//var form = obj.up('window');
    				var form = this.getCommitteesendmessage();
    				form.down('#msgCategoryId').setValue(record[0].data.msgCategoryId);
    				form.down('#msgSubCategoryId').setValue(record[0].data.msgSubCategoryId);
    			}
    		},
    		'studentparticipantgrid':{
    			render: function(grid){
    				//this.doAccessControlValidation(grid, this.getCOMMITTEE_PARTICIPANT_PERMISSIONS());
    				//this.disableManageCommOtherPivileges(grid,this.getCOMMITTEE_PARTICIPANT_PERMISSIONS());
    			}/*,
    			 select:function(obj, record,rowIndex, e){
    				 console.log("-",obj);
    				 console.log("-",record);
    				 console.log("-",rowIndex);
    				 console.log("-",e);
    			 }*/
    		},
    		'committeesendmessage  filefield[itemId=staticUploadFileField]': {
	            change: function(fileField, value, eOpts){
	            	var this$ = this;
	            	this$.uploadStaticDocumentFileMessage(fileField, value, eOpts);
	            }
            },
            'staticdocumentattachmentgrid[itemId=staticDocumentAttachmentGridMessage] actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		//this.deleteStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },
    		'committeesendmessage': {
    			render: function(grid){
	            	var this$ = this;
	            	var docGrid = grid.down('#staticDocumentAttachmentGridMessage');
	            	docGrid.getStore().removeAll();
	            	docGrid.getStore().sync();
	            }
            },
            'committeesendmessage radiogroup#sendingPriority': {
        		change: function( radio, newValue, oldValue, eOpts) {
        	      this.loadCommitteeScheduleField(radio, newValue, oldValue);
        		}
        	},
        	'studentcommitteeform textfield#committeeCodeItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                        var form = this.getStudentcommitteeform();
                        var grid = this.getStudentcommitteegrid();
                        var idItemId = form.down("#idItemId");
                        var submitUrl = SERVERURL.CM_COMMITTEE_UNIQUE_COMMITTEE_CODE + '?committeeCode=' + data;
                        
                        if (!isNullOrEmpty(idItemId.getValue())) {
                        	submitUrl = submitUrl +  '&id=' + idItemId.getValue();
                        }	
                        Ext.Ajax.request({
                            type: 'rest',
                            url: submitUrl,
                            method: 'GET',
                            success: function(response, action) {
                                var responseData = Ext.decode(response.responseText);
                                if (responseData.code == 'EXIST') {
                                	showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('CM_DUPLICATE_COMMITTEE_CODE'));
                                    form.down("#committeeCodeItemId").reset();
                                    /*if (grid.getSelectionModel().getCount() > 0) {
                                        if (grid.getSelectionModel().getSelection()[0].data.committeeCode != data) {
                                            showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('CM_DUPLICATE_COMMITTEE_CODE'));
                                            form.down("#committeeCodeItemId").setValue(grid.getSelectionModel().getSelection()[0].data.committeeCode);
                                        }
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('CM_DUPLICATE_COMMITTEE_CODE'));
                                        form.down("#committeeCodeItemId").reset();
                                    }*/
                                }
                            }
                        });
                    }
                }
            },
            'studentcommitteeform button[itemId=resetBtn]': {
                click: this.resetCommitteeForm
            },
            'studentresourcebookinglistsearchform[itemId=studentresourcebookinglistsearchform] combo[itemId=resourceGroupCombo]': {
                select: function(combo, records, eOpts){
                	this.showHideComboOnGroupSelection(combo, records, eOpts);
                }
            },
            'studentresourcebookinglistsearchform[itemId=studentresourcebookinglistsearchform] combo[itemId=resourceTypeCombo]': {
                select: function(combo, records, eOpts){
                	this.showHideComboOnTypeSelection(combo, records, eOpts);
                }
            },
            /*'resourcebookinglistsearchform[itemId=resourceBookingListSearchForm] multiselectcombofield[itemId=multiselectAcademyLocationId]': {
                change: function(field, newValue, oldValue, eOpts){
                	console.log(newValue)
                	this.setParamsToComboField(field, newValue, oldValue, eOpts);
                }
            },*/
        	'studentresourcebookinglistsearchform[itemId=studentresourcebookinglistsearchform] button[itemId=searchButtonId]': {
                click: function(){
                	this.loadBookingSearchResultGrid();
                }
            },
            'studentresourcebookinglistsearchform[itemId=studentresourcebookinglistsearchform] button[itemId=resetButtonId]': {
                click: function(){
                	var this$ = this;
                	var form = this$.getStudentresourcebookinglistsearchform();
                	form.getForm().reset();
                	//this$.onResetComboFieldContainer();
                }
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.PDFEXPORT,'pdf',false);
 	            }
 	        },
 	        'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.PDFEXPORT,'pdf',true);
 	            }
 	        },
 	        'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
 	            }
 	        },
 	        'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 	            click: function() {
 	                this.exportResourceBookingList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
 	            }
 	        },
        	'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid]': {
        		render: function(grid) {
        			var portalId = this.getCurrentLoggedPortalId();
    				if (portalId == 3){
    					this.doAccessControlValidation(grid, this.getSTUDENT_COMMITTEE_SCHEDULE_DETAILS_PERMISSIONS());
    				}else if (portalId == 7){
    					this.doAccessControlValidation(grid, this.getPARENT_COMMITTEE_SCHEDULE_DETAILS_PERMISSIONS());
    				}
                },
                select:function(rowModel, record, index, eOpts ){
                	var me=this;
                	var grid=me.getStudentresourcebookinggrid();
                	if(!isEmpty(record)){                		            	        
            	        var eventDate = record.get('EVENT_DATE');
            	        var editButton=grid.down('#searchResultGridBtnEdit');
            	        var viewButton=grid.down('#searchResultGridBtnView');
            	        var splitButton=grid.down('#spBtnResourceBookingMoreActions');
            	        //var resourceADhocConfirmMenu = splitButton.down('#resourceADhocConfirmMenu');          	        
                	}                	
                }
        	},
        	/*'studentresourcebookinggrid': {
                render: function(component, eOpts) {
                    component.getStore().load();
                },
                
            },  */          
        	'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] button[itemId=searchResultGridBtnAdd]': {
                click: function(btn){
                	this.addResourceBooking(getCommonTranslation('EVENT_DETAILS'), false, true);
                }
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] button[itemId=searchResultGridBtnEdit]': {
                click: function(btn){
                	if(Ext.isDefined(btn.firstTimeFired) && btn.firstTimeFired==true){
                		btn.firstTimeFired = false;
                	}
                	else{
                		btn.firstTimeFired = true;
                    	this.editResourceBooking(false);
                	}
                }
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] button[itemId=btnView]': {
            	click: function(btn){
                	//this.editResourceBooking(true);
            		this.openAddMeetingTab();
                }
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] button[itemId=searchResultGridBtnDelete]': {
                click: this.deleteResourceBooking
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] splitbutton[itemId=spBtnResourceBookingMoreActions]': {
            	menushow:function(cmb,menu,eOpts){
            		var me = this;
            		var confirmAdhocMenuItem=cmb.down('#resourceADhocConfirmMenu');
                    var grid = me.getStudentresourcebookinggrid();
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        if (!isEmpty(records)) {
                        	var status=records[0].data.adhocStatus;
                        	if(!isNullOrEmpty(status)){
                        		if (status === getCommonTranslation('CONFIRMED')) {
                        			confirmAdhocMenuItem.setVisible(true);
                                } else if(status === getCommonTranslation('PENDING')) {
                                	confirmAdhocMenuItem.setVisible(true);
                                }else if(status === getCommonTranslation('UNAVAILABLE')) {
                                	confirmAdhocMenuItem.setVisible(false);
                                }else{
                                	confirmAdhocMenuItem.setVisible(false);
                                }
                        	}
                        }
                    } else {
                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                    }
            	}
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] #spBtnResourceBookingMoreActions menuitem[itemId=resourceFeedbackMenu]': {
                click: this.resourceFeedbackMenuClicked
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] #spBtnResourceBookingMoreActions menuitem[itemId=resourceADhocConfirmMenu]': {
                click: this.resourceADhocConfirmMenuClicked
            },
            'studentresourcebooking studentresourcebookinggrid[itemId=studentresourcebookinggrid] #spBtnResourceBookingMoreActions menuitem[itemId=assignCalender]': {
                click: this.resourceAssignCalendarClicked
            },
            'studentresourcebooking':{
	        	afterrender : function(structure){
	        		var panel = structure.items.items[0];
	        		var grid = panel.down('#studentresourcebookinggrid');
	        	    this.getCBGridHeaderFreeze(grid,panel);
	        	}
    		},
    		'meetingdocumentgrid[itemId=documentsGrid]' : {
    			cellclick : function(grid, td,
    					cellIndex, record, tr,
    					rowIndex, e, eOpts) {
    				var $this = this;
    				var documentGrid = $this.getMeetingdocumentgrid();
    				var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

    				if (columnName == "documentName") {
    					if (e.target.tagName == 'A') {
    						var documentId = record
    						.get("documentId");
    						if (!isNullOrEmpty(documentId)) {
    							$this
    							.getDocumentController()
    							.downloadDocumentFile(
    									documentId);
    						}
    					}
    				}
    			}
    		},
    		'studentresourcebookinglistsearchform combo#eventIdItemId': {
				render: function(obj) {
					var store = obj.getStore();
                    var userId = this.getCurrentlyLoggedInUser().id;
                    var portalId = this.getCurrentLoggedPortalId();
                    var programId;
                	if (portalId == 3 || portalId == 7) {
                		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
                		userId = studentPortalInfo.student.id;
                		programId = studentPortalInfo.programBatchDetails.programId;
                	}
					store.getProxy().extraParams = {
						portalId: portalId,
						userId: userId,
						programId: programId
					};
					store.load();
				}
			},
			'studentcommitteefilter combo#committeeItemId': {
			    render: function(obj) {
			        $this = this;
			        var store = obj.getStore();
			        var userId = this.getCurrentlyLoggedInUser().id;
			        store.getProxy().extraParams = {
			            participantId: userId
			        };
			        store.load();
			    }
			},
		    /**Student portal Apply for committee code**/
			'studentapplyforcommitteefilter':{
    			render:function(){
    				var $this = this;
    				var form = this.getStudentapplyforcommitteefilter();
			        var store = form.down("#committeeItemId").getStore();
			        var requestStore = form.down("#requestId").getStore();
					var academyLocationId=this.getCurrentAcademyLocation();
			        var userId = this.getCurrentlyLoggedInUser().id;
					store.getProxy().extraParams = {
						academyLocationId: academyLocationId,
			            studentId:userId,
			        };
			        store.load();
			        requestStore.getProxy().extraParams = {
			            studentId:userId,
			        };
			        requestStore.load();
			        var committeeRequestgrid = $this.getStudentapplyforcommitteegrid();
			    	var committeeRequestgridStore = committeeRequestgrid.getStore();
			    	committeeRequestgridStore.getProxy().extraParams = {
			            studentId:userId,
			        };
    			}
    		},
    		
			'studentapplyforcommitteegrid':{
    			render: function(grid){
    				var $this = this;
    				var portalId = this.getCurrentLoggedPortalId();
    				if (portalId == 3){
    					this.doAccessControlValidation(grid, this.getSTUDENT_APPLY_FOR_COMMITTEE_PERMISSIONS());
                        this.disableCancelBtnPivileges(grid, this.getSTUDENT_APPLY_FOR_COMMITTEE_PERMISSIONS());

    				}
    			},
    			select:function(rowModel, record, index, eOpts ){
    				  var $this=this;
    				   var cancelButton= $this.getStudentapplyforcommitteegrid().down("#cancelRequest");
    				   if(!isNullOrEmpty(record.data.approvalStatus)&& record.data.approvalStatus == "PENDING"){
    				   cancelButton.setDisabled(false);
    				    }else{
    				   cancelButton.setDisabled(true);
    				}
    			},
    			cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					if (e.target.tagName == 'A') {
						var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
						var $this = this;
						if(dataIndex == 'id'){
							var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
							var structure = Ext.widget('studentcommitteerequesttabstructure');
							//var tabName = getCommonTranslation('ADD_COMMITTEE');
							var tabName = getCommonTranslation('APPLY_FOR_COMMITTEE');
							/**
							 * This is to remove tab from content panel and open same tab again
							 */
							var getcontroller=this.getController('menu.CoreERPNavigationController');
							var getTab=getcontroller.getTab(tabName);
							if(getTab!=null){
								contentPanel.remove(getTab, true);
							}
							openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_NINE);
							Ext.apply(structure,{
								code:null,
								setCode : function(code){
									structure.code = code;
								},
								getCode:function(){
									return structure.code;
								}
							});
							structure.setCode(true);
							this.setCommitteRequesterDetailsViewMode(record);
						
						}
    			}
    			}
			},
			'studentapplyforcommitteegrid button[itemId=raiseRequest]':{
				click: function(grid){
					var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					var structure = Ext.widget('studentcommitteerequesttabstructure');
					//var tabName = getCommonTranslation('ADD_COMMITTEE');
					var tabName = getCommonTranslation('RAISE_REQUEST_FOR_COMMITTEE');
					/**
					 * This is to remove tab from content panel and open same tab again
					 */
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_NINE);
					Ext.apply(structure,{
						code:null,
						setCode : function(code){
							structure.code = code;
						},
						getCode:function(){
							return structure.code;
						}
					});
					structure.setCode(true);
					this.setCommitteRequesterDetails();
				}
			},
		    'studentapplyforcommitteefilter customcombobox[itemId=committeeItemId]':{
				select: function(obj, record) {
					var form = this.getStudentapplyforcommitteefilter();
					form.down('#membershipTypeId').setDisabled(false);
					var committeeId=form.down('#committeeItemId').getValue();
			        var store = form.down('#membershipTypeId').getStore();
					store.getProxy().extraParams = {
						committeeId: committeeId,
			        };
			        store.load();
				}
		    },
			
			'studentapplyforcommitteefilter datefield[itemId=startDate]':{
				select: function(obj, record) {
					var form = this.getStudentapplyforcommitteefilter();
					form.down('#endDate').allowBlank=false;
					form.isValid();
				}
		    },
		    
		    'studentapplyforcommitteefilter datefield[itemId=endDate]':{
				select: function(obj, record) {
					var form = this.getStudentapplyforcommitteefilter();
					form.down('#startDate').allowBlank=false;
					form.isValid();
				}
		    },
		    
            'studentapplyforcommitteefilter button[itemId=resetBtn]': {
                click: this.resetApplyForCommitteeForm
            },
            'studentcommitteerequestbasicdetails': {
            	render: function(obj) {
            		 $this = this;
            		var form = $this.getStudentcommitteerequestbasicdetails();
            		var committeeNameItemId = form.down('#committeeNameItemId');
            		var userId = $this.getCurrentlyLoggedInUser().id;
            		var academyLocationId=$this.getCurrentAcademyLocation();
            		committeeNameItemId.getStore().getProxy().extraParams = {
            			studentId: userId,
            			academyLocationId:academyLocationId
            		};
            		committeeNameItemId.getStore().load();
            	}
            },
            'studentcommitteerequestbasicdetails customcombobox#committeeNameItemId': {
			    select: function(obj) {
			        $this = this;
			        var store = obj.getStore();
			        var form = $this.getStudentcommitteerequestbasicdetails();
			        var membershipTypeItemId = form.down('#membershipTypeItemId');
			        var membershipAmountItemId = form.down('#membershipAmountItemId');
			        membershipTypeItemId.setValue(null);
			        membershipAmountItemId.setValue(null);
			        membershipTypeItemId.setDisabled(false);
			        membershipTypeItemId.getStore().getProxy().extraParams = {
			        	committeeId:obj.getValue()
			        };
			        membershipTypeItemId.getStore().load();
			    }
			},
			'studentcommitteerequestbasicdetails customcombobox#membershipTypeItemId': {
				select: function(obj) {
					$this = this;
					var form = $this.getStudentcommitteerequestbasicdetails();
					var membershipAmount = form.down('#membershipAmountItemId');
					membershipAmount.setDisabled(false);
					var committeeId = form.down("#committeeNameItemId").getValue();
					var requestAssignedTo = form.down('#assignedTo');
					var requestAssignedToId = form.down('#requestAssignedToItemId');
					var requestAssignedToUserId = form.down('#requestAssignedToUserItemId');
					var submitUrl = SERVERURL.PATH_FIND_AMOUNTBY_MEMBERSHIPTYPE;
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_COMMITTEE_REQUEST_ISAUTO_APPROVE+"?membershipTypeId="+obj.getValue()+"&committeeId="+committeeId,
						method : 'GET',
						success : function(resp, action) {
							var data = Ext.decode(resp.responseText);
							if(data.value == "true"){
								requestAssignedToId.setValue(data.value);
								requestAssignedTo.setValue('Auto');
							}else if(data.value == "false"){
								requestAssignedTo.setValue(data.code);
								requestAssignedToUserId.setValue(data.id);
							}
						}
					});
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl+"?membershipTypeId="+obj.getValue()+"&committeeId="+committeeId,
						method : 'GET',
						success : function(resp, action) {
							Ext.getBody().unmask();
							var d = resp.responseText;							
							if(!isNullOrEmpty(d)){
							var data = Ext.decode(resp.responseText);
							membershipAmount.setValue(data);
							}else{
								membershipAmount.setValue(null);
							}
						}
					});

				}
			},
			'studentcommitteerequestpanel button[itemId=submitBtn]':{
				click: function(obj) {
					var $this = this;
					var form = $this.getStudentcommitteerequestbasicdetails();
    				$this.saveCommitteeRequestDetails(form);
    			}
    		},
    		'studentapplyforcommitteegrid button[itemId=cancelRequest]':{
				click: function(btn){
					var grid = btn.up('studentapplyforcommitteegrid');
					var record = grid.getSelectionModel().getSelection()[0];
					var submitUrl = SERVERURL.PATH_APPROVE_COMMITTEE_REQUEST;
					var status = "CANCELLED";
					var json={
							'id':record.data.id,
							'code':status
					}
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData:json,
						headers : {
							'Content-Type' : 'application/json'
						},
						method : 'POST',
						success : function(resp, action) {
							Ext.getBody().unmask();
							grid.getStore().load();
							var data = Ext.decode(resp.responseText);
							showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('REQUEST_CALCELLED_SUCCESSFULLY'));
						}
					});
					
				}
			}
    	});
    },
    
    /**
     * This method is to enable schedule field
     */
    
    disableCancelBtnPivileges: function(gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        buttonsToolBar = gridReference.query('toolbar')[0];
        var raisedRequestId = gridReference.down('#raiseRequest');
        var cancelButtonItemId = gridReference.down('#cancelRequest');
        cancelButtonItemId.setVisible(false);
        Ext.each(permissionList, function(privilege) {
            if (privilege === 'CANCELREQUEST') {
                if (!isNullOrEmpty(cancelButtonItemId)) {
                    cancelButtonItemId.setVisible(true);
                }
            }
            if (privilege === 'RAISEREQUEST') {
                if (!isNullOrEmpty(raisedRequestId)) {
                	raisedRequestId.setVisible(true);
                }
            }
        });
    },
    
    loadCommitteeScheduleField : function(radio,newValue, oldValue){
    	var adhocMessageForm = radio.up('form');
    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
    	var radioValue = radio.getValue().sendingPriority;
    	
    	if(radioValue=='IMMEDIATE'){
    		scheduleDateField.setVisible(false);
    		scheduleDateField.setDisabled(true);
    		scheduleTimeField.setVisible(false);
    		scheduleTimeField.setDisabled(true);    		
    	}
    	else if(radioValue=='SCHEDULE'){
    		scheduleDateField.setVisible(true);
    		scheduleDateField.setDisabled(false);
    		scheduleTimeField.setVisible(true);
    		scheduleTimeField.setDisabled(false);
    	}
    },
    openCommitteeParticipant:function(obj){
    	var $this=this;
    	var grid = $this.getStudentcommitteegrid();
    	var formWindow = $this.getStudentcommitteealwindow();
		if (!formWindow) {
			Ext.widget('studentcommitteealwindow');
			formWindow = $this.getStudentcommitteealwindow();
		}
		formWindow.show();
		var record = grid.getSelectionModel().getSelection()[0];
		var fromDate = formWindow.down('#fromDateItemId');
		var tillDate = formWindow.down('#toDateItemId');
		fromDate.setMinValue(dateRender(record.data.validFromDate));
		fromDate.setMaxValue(dateRender(record.data.validTillDate));
		tillDate.setMinValue(dateRender(record.data.validFromDate));
		tillDate.setMaxValue(dateRender(record.data.validTillDate));
		formWindow.setTitle(getCommonTranslation('COMMITTEE_PARTICIPANT_DETAIL'));
		formWindow.down('#mapCommitteeParticipantWindowId').show();
    },
    selectMessageTemp: function(obj,rec){
    	var $this =  this;
    	 var formWin = $this.getCommitteesendmessage();
    	 if(rec[0].data.value == "SMS")
    	 {
    		 formWin.down("#subject").allowBlank=true;
    		 formWin.down("#subject").hide();
    		 formWin.down("#staticUploadFileField").hide();
    		 formWin.down("#staticDocumentMessageAttachmentGrid").hide();
    		 formWin.down('#discriptionId').reset();
    		 formWin.down('#discriptionId').hide();	       		 
    		 formWin.down('#subject').reset();
    		 formWin.down('#smsDiscription').show();
    		 formWin.down('#smsDiscriptionNotice').show();
    	 }else
    	 {
    		 formWin.down('#discriptionId').reset();
    		 formWin.down('#smsDiscription').reset();
    		 formWin.down('#smsDiscription').hide();
    		 formWin.down('#smsDiscriptionNotice').hide();
    		 formWin.down("#staticUploadFileField").show();
    		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
    		 formWin.down("#staticDocumentMessageAttachmentGrid").show()
    		 formWin.down("#subject").show();
    		 formWin.down("#subject").allowBlank=false;
    		 formWin.down('#discriptionId').show();    		
    	 }
    },
    selectSectionMessageType : function(val,nV,oV){

   	 var $this =  this;
   	 var formWin = $this.getCommitteesendmessage();

   	 //var value = nV.1;
   	 if(nV.messageType==2){
   		 formWin.down("#messageId").hide();
   		 formWin.down("#selectTemplate").allowBlank=true;
   		 formWin.down("#selectTemplate").setVisible(false);     		 
   		 formWin.down("#messageName").allowBlank=true;   
   		 formWin.down("#messageName").setVisible(false);
   		 formWin.down("#msgTempletId").setVisible(true);
   		 formWin.down("#msgTempletId").allowBlank=false;
   		 formWin.down("#msgTempletId").reset();
   		 formWin.down("#subject").setVisible(true);
   		 formWin.down("#subject").allowBlank=false;
   		 formWin.down("#subject").reset();
   		 formWin.down("#discriptionId").setVisible(true);
   		 formWin.down("#discriptionId").reset();
   		 formWin.down('#smsDiscription').reset();
   		 formWin.down('#smsDiscription').hide();
   		 formWin.down('#smsDiscriptionNotice').hide();
   	 }else{
   		 formWin.down("#msgTempletId").allowBlank=true;
   		 formWin.down("#msgTempletId").setVisible(false);     		
   		 formWin.down("#messageId").setVisible(true);
   		 formWin.down("#selectTemplate").setVisible(true);     		
   		 formWin.down("#messageName").setVisible(true);
   		 formWin.down("#messageName").reset();
   		 formWin.down("#subject").allowBlank=true;
   		 formWin.down("#subject").setVisible(false);
   		 formWin.down("#discriptionId").setVisible(false);
   		 formWin.down("#messageName").allowBlank=false;  
   		 formWin.down("#selectTemplate").allowBlank=false;
   		 formWin.down("#selectTemplate").reset();
   		 formWin.down("#staticDocumentMessageAttachmentGrid").setVisible(false);
   		 formWin.down("#staticUploadFileField").setVisible(false);
   		 formWin.down('#smsDiscription').reset();
   		 formWin.down('#smsDiscription').hide();
   		 formWin.down('#smsDiscriptionNotice').hide();
   		 var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
   		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
   		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
   	 }


   	
   	/* form.down("#coursesectiongrid").hide();
   	 form.down("#coursesectionstudentstructure").hide();

   	 form.down("#programbatchsectionsearch").hide();
   	 form.down("#programbatchsectiongrid").hide();
   	 form.down("#programbatchsectionstudentstructure").hide();

   	 form.down("#coursesectiongroupstructure").hide();

   	 if(value==false){
   		 form.down("#coursesectionsearch").show();
   	 }else if(value==true){
   		 form.down("#programbatchsectionsearch").show();
   	 }else if(value==='section_group'){
   		 form.down("#coursesectiongroupstructure").show();
   	 }*/

    },
    deleteCommitteeParticipant:function(grid){
    	var $this=this;
    	var grid = grid.up().up();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes') {
    				var records = grid.getSelectionModel().getSelection();
    				var ids=[];
    				for(var i in records) {
    					ids.push(records[i].data.id);
    				}
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.COMMITTEE_PARTICIPANT_DELERE_ALL_DATA+ '?ids='+ ids,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params : {
    						ids : ids
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('SUCCESS'));
    						grid.getStore().reload();
//    						$this.getStudentcommitteegrid().getSelectionModel().deselectAll();
    						$this.getStudentcommitteegrid().getStore().reload();
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    fillALRelatedGrid:function(formWindow, dataIndex, record){
    	var $this = this; 
		var form = $this.getStudentcommitteealwindow();
		var alGrid = form.down('#academyLocationGridItemId');
		var gridStore = alGrid.getStore();
		gridStore.removeAll();
		var grid = $this.getStudentcommitteegrid();
		var arr= [];
		for (var i =0; i<record.data.committeeAcademyLocations.length;i++) {
			arr.push({"value":record.data.committeeAcademyLocations[i].academyLocation.value});
		}
		gridStore.loadRawData(arr, true);
    	formWindow.down('#committeeNameAL').setValue(record.data.committeeCode);
    	formWindow.down('#committeeNameDesc').setValue(record.data.committeeCode);
    	formWindow.down('#description').setValue(record.data.description);
		if(dataIndex == 'committeeAcademyLocations'){
			formWindow.down('#descriptionForm').hide();
			formWindow.down('#academyLocationForm').show();
			formWindow.setTitle(getCommonTranslation('COMMITTEE_ACADEMY_LOCATION'));
		}
		if(dataIndex == 'description'){
			formWindow.setTitle(getExaminationTranslation('Description'));
			formWindow.down('#descriptionForm').show();
			$this.toggleReadOnlyFormItems(formWindow.down('#descriptionForm').getForm(),true);
			formWindow.down('#academyLocationForm').hide();
		}
		formWindow.show();
    },
    
    
    openAddParticipantDetails:function(dataIndex, record){
    	var $this = this; 
    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var structure = Ext.widget('studentaddcommitteeparticipant');
    	var tabName = getCommonTranslation('COMMITTEE_PARTICIPANT_DETAIL');
    	/**
    	 * This is to remove tab from content panel and open same tab again
    	 */
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);

    	var grid = structure.down('#participantgridItemId');
    	structure.down('#committeeItemId').setValue(record.data.id)
    	structure.down('#committeeName').setValue(record.data.committeeName);
    	structure.down('#committeeCode').setValue(record.data.committeeCode);
    	structure.down('#committeeFromDate').setValue(dateRender(record.data.validFromDate));
    	structure.down('#committeeToDate').setValue(dateRender(record.data.validTillDate));
    	grid.getStore().getProxy().extraParams={
    		committeeId:record.data.id
    	};
    	grid.getStore().load();
    },
    
    loadCommitteeGrid:function(){
    	
    	var $this=this;
    	var studentId = $this.getCurrentlyLoggedInUser().id;
    	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
    		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    		studentId = studentPortalInfo.student.id;
    	}
    	
    	var form = $this.getStudentcommitteefilter().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getStudentcommitteegrid();
    	var isActive;
    	if(formValue.status!= "INACTIVE") {
    		isActive=true;
    	} else {
    		isActive=false;
    	}
		grid.getStore().getProxy().extraParams= {
    		committeeId:formValue.committee,
    		participantId: studentId,
    		isActive:isActive
    	};
    	grid.getSelectionModel().deselectAll();
    	$this.resetGridSetting(grid);
    	$this.resetPageSetting(grid.getStore());
    	grid.getStore().load();
    	
    }, 
    
    loadApplyForCommitteeGrid:function(){
    	
    	var $this=this;
    	var studentId = $this.getCurrentlyLoggedInUser().id;
    	
    	var form = $this.getStudentapplyforcommitteefilter().getForm();
    	var formValue = form.getValues();
    	var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		studentId = studentPortalInfo.student.id;
    	var grid = $this.getStudentapplyforcommitteegrid();
		grid.getStore().getProxy().extraParams= {
			studentId:studentId,
    		id:formValue.request,
    		committeeId:formValue.committee,
    		membershipTypeId:formValue.membershipType,
    		approvalStatus:formValue.requestStatus,
    		startDate:formValue.startDate,
    		endDate:formValue.endDate
    	};
    		grid.getStore().load();
    	
    },
    resetCommitteeFilter: function() {
        var $this = this;
        var filter = $this.getStudentcommitteefilter().getForm();
        filter.reset();
    },
    
    
addCommitteeRecord:function(){
	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		var structure = Ext.widget('studentcommitteeform');
        //var tabName = getCommonTranslation('ADD_COMMITTEE');
		var tabName = getCommonTranslation('COMMITTEE_DETAILS');
       /**
        * This is to remove tab from content panel and open same tab again
        */
       var getcontroller=this.getController('menu.CoreERPNavigationController');
       var getTab=getcontroller.getTab(tabName);
       if(getTab!=null){
       	contentPanel.remove(getTab, true);
       }
       openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_ONE);
       Ext.apply(structure,{
    	   code:null,
    	   setCode : function(code){
    		   structure.code = code;
    	   },
    	   getCode:function(){
    		   return structure.code;
    	   }
       });
       structure.setCode(true);
},
viewCommitteeRecord:function(){
	var $this = this;
	var grid = $this.getStudentcommitteegrid();
	if(grid.getSelectionModel().getCount()>0) {
		$this.addCommitteeRecord('VIEW');
		var committeeform = $this.getStudentcommitteeform().getForm();
		$this.populateCommitteeRecord(grid, committeeform, false);
	} else {
		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
},

populateCommitteeRecord:function(grid, committeeform, isEditable){
	var $this = this;
	var record = grid.getSelectionModel().getSelection()[0];
	
	var submitUrl = SERVERURL.COMMITTEE_FIND_BY_ID;
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl+"?id="+record.data.id,
		method : 'GET',
		success : function(resp, action) {
			Ext.getBody().unmask();
			var data = Ext.decode(resp.responseText);
			var committeeCode = committeeform.findField('committeeCode');
			committeeCode.setValue(data.committeeCode);
			var committeeName = committeeform.findField('committeeName');
			committeeName.setValue(data.committeeName);
			var multiselectAcademyLocation = committeeform.findField('multiselectAcademyLocation');
			var alArray= [];
			if(!isNullOrEmpty(data.committeeAcademyLocations)) {
				for(var i in data.committeeAcademyLocations){
					alArray.push(data.committeeAcademyLocations[i].academyLocation.id);
				}
			}
			multiselectAcademyLocation.getStore().getProxy().extraParams={
				id:$this.getCurrentlyLoggedInUser().id
			};
			multiselectAcademyLocation.getStore().load({
				callback:function(record) {
					if(alArray && alArray.length){
					    multiselectAcademyLocation.setValue(alArray);
					}else{
						multiselectAcademyLocation.setValue($this.getCurrentAcademyLocation());
					}
				}
			});
			var user = committeeform.findField('user');
			user.setDisabled(false);
			user.getStore().getProxy().extraParams={
				academyLocationIds:alArray.join()
			};
			user.getStore().load({
				callback:function(record) {
					user.setValue(data.committeeCoordinatorId);
				}
			});
			var fromDate = committeeform.findField('fromDate');
			fromDate.setValue(dateRender(data.validFromDate));
			var toDate = committeeform.findField('toDate');
			toDate.setValue(dateRender(data.validTillDate));
			var status = committeeform.findField('status');
			status.getStore().load({
				callback:function(record) {
					if(data.status) {
						status.setValue(record[0].data.id);
					} else {
						status.setValue(record[1].data.id);
					}
				}
			});
			var description = committeeform.findField('description');
			description.setValue(data.description);
			
			var id = committeeform.findField('id');
			id.setValue(data.id);
			
			if(!isEditable) {
				multiselectAcademyLocation.setEditable(false);
				$this.getStudentcommitteeform().down('#submitBtn').setVisible(false);
				$this.getStudentcommitteeform().down('#resetBtn').setVisible(false);
				$this.toggleReadOnlyFormItems(committeeform, true);
			}
		}
	});
},

saveParticipantDetails: function(form){
	var $this = this;
	form.down('#submitCommitteeParticipantBtn').setDisabled(true);
	var participantgrid = $this.getStudentparticipantgrid();
	var json = $this.createSaveParticipantJson(form);
	var submitUrl= SERVERURL.COMMITTEE_PARTICIPANT_CREATE;
	var formData = Ext.encode(json);
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl,
		jsonData : json,
		method : 'POST',
		success : function(frm, action) {
			Ext.getBody().unmask();
			participantgrid.getStore().reload();
			participantgrid.getSelectionModel().deselectAll();
			showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_PARTICIPANTS_CREATED_UPDATED_SUCCESSFULLY'));
//			$this.getStudentcommitteegrid().getSelectionModel().deselectAll();
			$this.getStudentcommitteegrid().getStore().reload();
			form.close();
		}
	});
},

createSaveParticipantJson: function(form){
	var $this = this;
	var formValues = form.down('#mapCommitteeParticipantWindowId').getForm().getValues();
	var committeeId = $this.getStudentaddcommitteeparticipant().down('#committeeItemId').getValue();
	var arr=[];
		var arryRecordToSave ={
			"participant":{
				"id":form.down('#assignedUser').getValue()
			},
			"committee":{
				"id":committeeId
			},
			"designation":form.down('#designationNameItemId').getValue(),
			"responsibility":form.down('#responsabilityItemId').getValue(),
			"fromDate":formValues.fromDate,
			"toDate" :formValues.toDate
		};
		arr.push(arryRecordToSave);
	return arr;
},

createSaveJson: function($this){
	var formValue = $this.getStudentcommitteeform().getValues();
	var json= new Object;
	var coordinator={
		"id":	formValue.user
	};
	var ALIds=[];
	for (var i=0; i<formValue.multiselectAcademyLocation.length; i++) {
		var alids ={
				"id":(formValue.multiselectAcademyLocation[i].data!=undefined)?formValue.multiselectAcademyLocation[i].data.id:formValue.multiselectAcademyLocation
		}
		academyLocation={
				"academyLocation":alids
		}
		ALIds.push(academyLocation)
	}
	var isStatus;
	if(formValue.status == "ACTIVE") {
		isStatus=true;
	} else {
		isStatus=false;
	}
	json = {
			"committeeCode": formValue.committeeCode,
			"committeeName": formValue.committeeName,
			"committeeCoordinator":coordinator,
			"validFromDate":formValue.fromDate,
			"validTillDate":formValue.toDate,
			"status":isStatus,
			"description":formValue.description,
			"committeeAcademyLocations":ALIds
	};
	return json;	
},

createUpdateJson: function($this, grid){
	var formValue = $this.getStudentcommitteeform().getValues();
	var json= new Object;
	var coordinator={
		"id":	formValue.user
	};
	var ALIds=[];
	for (var i=0; i<formValue.multiselectAcademyLocation.length; i++) {
		academyLocation={
				"academyLocation":{
					"id":(formValue.multiselectAcademyLocation[i].data!=undefined)?formValue.multiselectAcademyLocation[i].data.id:formValue.multiselectAcademyLocation[i]
				}
		}	
		ALIds.push(academyLocation)
	}
	var isStatus;
	if(formValue.status == "ACTIVE") {
		isStatus=true;
	} else {
		isStatus=false;
	}
	json = {
			"id":formValue.id,
			"committeeCode": formValue.committeeCode,
			"committeeName": formValue.committeeName,
			"committeeCoordinator":coordinator,
			"validFromDate":formValue.fromDate,
			"validTillDate":formValue.toDate,
			"status":isStatus,
			"description":formValue.description,
			"committeeAcademyLocations":ALIds
	};
	return json;	
},

/**
 * Add value to grid
 */
loadGridWithFileNameMessage:function(grid,value,store){
	grid.bindStore(store);
},

//Disable other Privileges button 
disableManageCommOtherPivileges: function(gridReference,permissionsMap) {
	var associatedAcadLocationIds = new Array();
	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	var buttonsToolBar = gridReference.query('toolbar')[0];
	buttonsToolBar.setVisible(false);
	var sendMessageBtn=buttonsToolBar.query('#sendMessageBtn')[0];
	var saveBtn = buttonsToolBar.query('#btnSaveItemId')[0];
	var addMeetingBtn = buttonsToolBar.query('#addMeetingBtn')[0];
	Ext.each(permissionList, function(privilege) {
		console.log(privilege);
		if (privilege === 'SENDMESSAGE') {
//			var button = buttonsToolBar.query('#SENDMESSAGE')[0];
			if(!isNullOrEmpty(sendMessageBtn)){
				sendMessageBtn.setVisible(true);
			}        		
		}
		if (privilege === 'SAVE') {
//			var button = buttonsToolBar.query('#SAVE')[0];
			if(!isNullOrEmpty(saveBtn)){
				saveBtn.setVisible(true);
			}        		
		}
		if (privilege === 'ADD_MEETING') {
			if(!isNullOrEmpty(addMeetingBtn)){
				addMeetingBtn.setVisible(true);
			}        		
		}
	});
	buttonsToolBar.setVisible(true);
},
resetCommitteeForm: function() {
    var $this = this;
    var form = $this.getStudentcommitteeform().getForm();
    form.reset();
    var fromDateItemId = $this.getStudentcommitteeform().down("#fromDateItemId");
    fromDateItemId.setValue(new Date());
    var userItemId = $this.getStudentcommitteeform().down("#userItemId");
    userItemId.setDisabled(true);
    userItemId.reset();
},

resetApplyForCommitteeForm: function() {
    var $this = this;
    var form = $this.getStudentapplyforcommitteefilter().getForm();
    form.reset();
    $this.getStudentapplyforcommitteefilter().down("#membershipTypeId").setDisabled(true);
    var fromDate = $this.getStudentapplyforcommitteefilter().down("#startDate");
    var toDate = $this.getStudentapplyforcommitteefilter().down("#endDate");
    fromDate.allowBlank=true;
    toDate.allowBlank=true;
    fromDate.setMaxValue(false);
	fromDate.setMinValue(false);
	toDate.setMaxValue(false);
	toDate.setMinValue(false);
	fromDate.reset();
	toDate.reset();
	form.isValid();
},
/**
 * Add dynamic reset buttons in booking listing.
 */
gridRenderFunctionForBooking:function(grid){
	grid.addButtonToolbar();
	var butonstoolbar=grid.down('#functionButtonsToolbar');
	 butonstoolbar.insert(4,{
	        xtype: 'splitbutton',
	        itemId: 'spBtnResourceBookingMoreActions',
	        text: getCommonTranslation('MOREACTIONS'), 
	        tooltip: getCommonTranslation('MOREACTIONS'), 
	        menu: [{
	            text: getCommonTranslation('FEEDBACK'), 
	            itemId: 'resourceFeedbackMenu',
	            tooltip: getCommonTranslation('FEEDBACK_QTIP') 
	        }, {
	            text: getCommonTranslation('CONFIRM_ADHOC_RESOURCE'), 
	            itemId: 'resourceADhocConfirmMenu',
	            tooltip: getCommonTranslation('ADHOC_RESOURCE_QTIP')  
	        },{
	            text: getCommonTranslation('ASSIGN_CALENDER'), 
	            itemId: 'assignCalender',
	            tooltip: getCommonTranslation('ASSIGN_CALENDER')  
	        } , {
	            text: getServiceRequestTranslation('EMM_MANAGE_MINUTES'),
	            itemId: 'manageMinutesButtonItemId',
	            tooltip: getServiceRequestTranslation('EMM_MANAGE_MINUTES'),
	        }, {
	            text: getServiceRequestTranslation('EMM_PRINT_ATTENDANCE_SHEET'),
	            itemId: 'printAttendanceSheetItemId',
	            tooltip: getServiceRequestTranslation('EMM_PRINT_ATTENDANCE_SHEET'),
	        }],
	        listeners: { click: function() { this.showMenu(); } }
	    });
},
/**
 * load booking search result grid
 */
loadBookingSearchResultGrid: function() {
	var $this=this;
	var studentId = $this.getCurrentlyLoggedInUser().id;
	var programId;
	if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
		var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
		studentId = studentPortalInfo.student.id;
		programId = studentPortalInfo.programBatchDetails.programId;
	}
	
	
	var form = $this.getStudentresourcebookinglistsearchform();
	var formValue = form.getValues();
	var grid = $this.getStudentresourcebookinggrid();
	
	grid.getStore().getProxy().extraParams= {
		committeeId:formValue.committee,
		studentId:studentId,
		eventId:formValue.eventId,
		fromDate:formValue.eventDate,
		toDate:formValue.toDate,
		programId: programId
	};
	
	grid.getSelectionModel().deselectAll();
	$this.resetGridSetting(grid);
	$this.resetPageSetting(grid.getStore());
	grid.getStore().load();
},
openAddMeetingTab:function(){
	var $this=this;
	var grid = $this.getStudentresourcebookinggrid();
	var gridData = grid.getSelectionModel().getSelection()[0];
	if (grid.getSelectionModel().getCount() > 0) {
//		Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
		var contentpanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		var tabName = getCommonTranslation('EVENT_DETAILS');
		/**
		 * This is to remove tab from content panel and open same tab again 
		 */
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
		//$this.getController('facilitiesresources.resourcebooking.ResourceBookingController').addResourceBooking(getCommonTranslation('EVENT_DETAILS'),false, false);
		$this.viewCommitteeEventDetails(getCommonTranslation('EVENT_DETAILS'),true, false,gridData.data.id);
	}else {
		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
},
viewCommitteeEventDetails: function(tabTitle, isEdit, setDefaultLoggedUser, committeeEventId) {
    var $this = this;
	var contentpanel = this.getContentPanel();
    var resourceBookingFormLayout = Ext.widget('studentresourcebookingformlayout',{
    	title: (isEdit)?getCommonTranslation('EVENT_DETAILS'):getCommonTranslation('ADD_NEW_EVENT_DETAILS')
    });
    var tabName = "";
   /* if (isNullOrEmpty(tabTitle)) {
        tabName = getCommonTranslation('EVENT_DETAILS');
    } else {
        tabName = tabTitle;
    }*/
    /*if(Ext.isDefined(Ext.ComponentQuery.query('resourcebookingformlayout')[0])){
    	if(Ext.ComponentQuery.query('resourcebookingformlayout')[0].title == getCommonTranslation('EVENT_DETAILS')){
        	Ext.ComponentQuery.query('resourcebookingformlayout')[0].up().destroy();
    	}
    }*/
    var responseObject = new Object();
    Ext.Ajax.request({
        type: 'rest',
        url: SERVERURL.RESOURCE_BOOKING_FINDBYIDFORPORTAL, //URL-rest/resourceBookingResource/findById													 
        method: 'GET',
        async: false,
        headers: {
            'Content-Type': 'application/json'
        },
        params: {
            id: committeeEventId
        },
        success: function(response, form, action) {
            responseObject = eval("(" + response.responseText + ")"); //make object of response text
            
            var tabName = responseObject.eventName + " " +getCommonTranslation('EVENT_DETAILS');
            
            var getcontroller=$this.getController('menu.CoreERPNavigationController');
			var getTab=getcontroller.getTab(tabName);
			if(getTab!=null){
				contentpanel.remove(getTab, true);
			}
			
            openTab(contentpanel, tabName, resourceBookingFormLayout, CONSTANTS.MENU_COLOR_NINE);
            //resourceBookingFormLayout.down('#resourceCategoryCode').setValue(responseObject.resourceCategoryCode);
            resourceBookingFormLayout.getForm().setValues(responseObject);
            resourceBookingFormLayout.down('#cmbBookingPurpose').setValue(responseObject.bookingPurpose.value);
            resourceBookingFormLayout.down('#cmbBookedBy').setValue(responseObject.bookedBy.value);
            resourceBookingFormLayout.down('#eventDate').setValue(dateRender(responseObject.eventDate));
            resourceBookingFormLayout.down('#toDate').setValue(dateRender(responseObject.toDate));
            resourceBookingFormLayout.down('#timeFrom').setValue(timeRender(responseObject.timeFrom));
            resourceBookingFormLayout.down('#timeTo').setValue(timeRender(responseObject.timeTo));
            
            var documentGrid = resourceBookingFormLayout.down('#documentsGrid');
	        documentGrid.getStore().getProxy().api.read = SERVERURL.FIND_ALL_RESOURCE_BOOKING_DOCS;
	        documentGrid.getStore().getProxy().extraParams={
	        	resourceBookingId:committeeEventId
	        };
			documentGrid.down('#btnDelete').setVisible(false);
			documentGrid.getStore().load();
            
			var eventDesc   = resourceBookingFormLayout.down('[name=eventDesc]');
			var purposeDesc = resourceBookingFormLayout.down('[name=purposeDesc]');
			
            if (!isNullOrEmpty(responseObject.committee)) {
            	if (!isNullOrEmpty(responseObject.committee.code) && !isNullOrEmpty(responseObject.committee.value)) {
            		var committeeCode = responseObject.committee.code;
            		var committeeValue = responseObject.committee.value;
            		resourceBookingFormLayout.down('#committeeItemId').setValue(committeeCode + " / " + committeeValue);
            	}
            }
            if(!isNullOrEmpty(responseObject.repeatOn)) {
            	var repeatOnFld = resourceBookingFormLayout.down('#repeatOnItemId');
            	repeatOnFld.setVisible(true);
            	var repeatOnStore = repeatOnFld.getStore();
            	var repeatOnIds=[];
            	repeatOnStore.load({
            		callback: function(records, operation, success) {
            			var repeatOnVals = responseObject.repeatOn.split(',');
            			for (var i in repeatOnVals) {
            				repeatOnIds.push(repeatOnVals[i]);
            			}
            			repeatOnFld.setValue(repeatOnIds);
            		}
            	});
            }
            if(responseObject.bookingPurpose.code === "MEETING"){
				eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA'));
				purposeDesc.setVisible(false);
				eventDesc.setWidth(510);
			}
			else{
				eventDesc.setFieldLabel(getCommonTranslation('EVENT_DESC'));
				purposeDesc.setVisible(true);
				eventDesc.setWidth(226);
			}
            
            $this.displayEventBannerImage(resourceBookingFormLayout,responseObject.id);
            resourceBookingFormLayout.down('#eventBannerItemId').setDisabled(true);
            resourceBookingFormLayout.getForm().getFields().each (function (field) {
                field.setReadOnly (true);
              });
        },
        failure: function(form, action) {
        	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
        }
    });
	
    /*var docGrid = resourceBookingFormLayout.down('#documentsGrid');
    var docStore = docGrid.getStore();
    if (docStore)
    	docStore.removeAll();*/
},
/*
 * This function is used for to get Resource Booking Form Data
 */
getResourceBookingFormData: function(id) {
    var responseObject = new Object();
    Ext.Ajax.request({
        type: 'rest',
        url: SERVERURL.RESOURCE_BOOKING_FINDBYID, //URL-rest/resourceBookingResource/findById													 
        method: 'GET',
        async: false,
        headers: {
            'Content-Type': 'application/json'
        },
        params: {
            id: id
        },
        success: function(response, form, action) {
            responseObject = eval("(" + response.responseText + ")"); //make object of response text
        },
        failure: function(form, action) {
        	showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
        }
    });
    return responseObject;
},
getDocumentController : function() {
	var this$ = this;
	return this$
	.getController('Academia.controller.document.DocumentController');
},
displayEventBannerImage:function(resourceBookingFormLayout,eventId) {
	   var this$ = this;
	   //var form = this$.getStudentresourcebookingformlayout();
	   var form = resourceBookingFormLayout;
	   Ext.Ajax.request({
		   type: 'rest',
		   binary: true,
		   url: SERVERURL.RESOURCE_BOOKING_DOWNLOAD_EVENT_BANNER,
		   method: 'GET',
		   params:{
			   eventId : eventId
		   },
		   success: function(res, action) {
			   Ext.suspendLayouts();
			   if(res.status == 200){
				   var blob = new Blob([res.responseBytes], {type: 'image/jpg'});
				   var url = window.URL.createObjectURL(blob);
				   form.down('#eventBannerBgImage').getEl().dom.src=url;
			   }
			   Ext.resumeLayouts();
		   }
	   });
},
setCommitteRequesterDetails:function(){
	var me = this;
	var userId = me.getCurrentlyLoggedInUser().id;
	var submitUrl = SERVERURL.PATH_FIND_STUDENT_REQUESTER_DETAILSFOR_COMMITTEE;
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl+"?id="+userId,
		method : 'GET',
		success : function(resp, action) {
			Ext.getBody().unmask();
			var data = Ext.decode(resp.responseText);
			var basicDetails = me.getStudentcommitteerequestbasicdetails();
			var requesterPanel = me.getStudentcommitteerequesterdetailspanel();
	    	 var name = requesterPanel.down('#name');
	    	 var batchName = requesterPanel.down('#batch');
	    	 var programName = requesterPanel.down('#program');
	    	 var seatType = requesterPanel.down('#seatType');
	    	 var email = requesterPanel.down('#email');
	    	 var mobile = requesterPanel.down('#mobile');
	    	 var enteredBy = basicDetails.down('#enteredBy');
	    	 
	    	 var batchNameField = requesterPanel.down('#batchItemId');
	    	 var programNameField = requesterPanel.down('#programItemId');
	    	 var seatTypeField = requesterPanel.down('#seatTypeItemId');
	    	 var emailField = requesterPanel.down('#emailItemId');
	    	 var mobileField = requesterPanel.down('#mobileNoItemId');
	    	 var nameValue = requesterPanel.down('#studentNameItemId');
	    	 
	    	 var msg = getServiceRequestTranslation('N_A');
	    	 
	    	 if(isNullOrEmpty(data.printName))
		     {
	    		 name.setValue(msg);
		     }else{
		    	 name.setValue(data.printName);
		    	 nameValue.setValue(data.printName);
		     }
	    	 
	    	 if(isNullOrEmpty(data.printName))
		     {
	    		 enteredBy.setValue(msg);
		     }else{
		    	 enteredBy.setValue(data.printName);
		     }
	    	 
	    	 if(isNullOrEmpty(data.emailId))
		     {
	    		 email.setValue(msg);
		     }else{
		    	 email.setValue(data.emailId);
		    	 emailField.setValue(data.emailId);
		     }
		    
	    	 if(isNullOrEmpty(data.mobileNumber))
		     {
	    		 mobile.setValue(msg);
		     }else{
		    	 mobile.setValue(data.mobileNumber);
		    	 mobileField.setValue(data.mobileNumber);
		     }
	    	 
	    	 if(isNullOrEmpty(data.programList))
		     {
	    		 programName.setValue(msg);
		     }else{
		    	 programName.setValue(data.programList);
		    	 programNameField.setValue(data.programList);
		     }
	    	 
	    	 if(isNullOrEmpty(data.batchList))
		     {
	    		 batchName.setValue(msg);
		     }else{
		    	 batchName.setValue(data.batchList);
		    	 batchNameField.setValue(data.batchList);
		     }
	    	 
	    	 
	    	 if(isNullOrEmpty(data.seatTypeList))
		     {
	    		 seatType.setValue(msg);
		     }else{
		    	 seatType.setValue(data.seatTypeList);
		    	 seatTypeField.setValue(data.seatTypeList);
		     }
			
		}
	});
},

setCommitteRequesterDetailsViewMode:function(record){
	var me = this;
	if(!isNullOrEmpty(record)){
	var basicDetails = me.getStudentcommitteerequestbasicdetails();
	var panel = me.getStudentcommitteerequestpanel();
	var submitButton = panel.down('#submitBtn').setVisible(false);
	var requestDate = basicDetails.down('#requestDate');
    var committee = basicDetails.down('#committeeNameItemId');
    var membership = basicDetails.down('#membershipTypeItemId');
    var membershipAmount = basicDetails.down('#membershipAmountItemId');
    var requestReason = basicDetails.down('#requestReason');
    var assignTo = basicDetails.down('#assignedTo');
    if(!isNullOrEmpty(record.data.requestDate)){
    requestDate.setValue(dateRender(record.data.requestDate));
    }
    if(!isNullOrEmpty(record.data.membershipAmount))
    	{
    membershipAmount.setValue(record.data.membershipAmount);
    membershipAmount.setDisabled(false)
    membershipAmount.setReadOnly(true);
    	}else
    		{
    		membershipAmount.setDisabled(false)
    	    membershipAmount.setReadOnly(true);
    		}
    if(!isNullOrEmpty(record.data.description)){
    requestReason.setValue(record.data.description);
    requestReason.setReadOnly(true);
    }
    committee.getStore().load({
		  callback: function(recordss, operation, success) {
			  for(var i in recordss){
				  if( !isNullOrEmpty(record.data.committeeId) ){
					  if(recordss[i].data.id==record.data.committeeId.id){
						  committee.setValue(recordss[i].data.id);
						  committee.setReadOnly(true);
					  }
				  }
			  }
		  }	   
	  
	});
    membership.getStore().load({
		  callback: function(recordss, operation, success) {
			  for(var i in recordss){
				  if( !isNullOrEmpty(record.data.membershipTypeId) ){
					  if(recordss[i].data.id==record.data.membershipTypeId.id){
						  membership.setValue(recordss[i].data.id);
						  membership.setDisabled(false);
						  membership.setReadOnly(true);
					  }
				  }
			  }
		  }	   
	  
	});
    if(!isNullOrEmpty(record.data.requestAssignTo)){
    assignTo.setValue(record.data.requestAssignTo.value);
    assignTo.setReadOnly(true);
    }
    else{
    	assignTo.setValue("Auto");
        assignTo.setReadOnly(true);
    	}
	}
	var userId = me.getCurrentlyLoggedInUser().id;
	var submitUrl = SERVERURL.PATH_FIND_STUDENT_REQUESTER_DETAILSFOR_COMMITTEE;
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl+"?id="+userId,
		method : 'GET',
		success : function(resp, action) {
			Ext.getBody().unmask();
			var data = Ext.decode(resp.responseText);
			var basicDetails = me.getStudentcommitteerequestbasicdetails();
			var requesterPanel = me.getStudentcommitteerequesterdetailspanel();
	    	 var name = requesterPanel.down('#name');
	    	 var batchName = requesterPanel.down('#batch');
	    	 var programName = requesterPanel.down('#program');
	    	 var seatType = requesterPanel.down('#seatType');
	    	 var email = requesterPanel.down('#email');
	    	 var mobile = requesterPanel.down('#mobile');
	    	 var enteredBy = basicDetails.down('#enteredBy');
	    	 
	    	 var batchNameField = requesterPanel.down('#batchItemId');
	    	 var programNameField = requesterPanel.down('#programItemId');
	    	 var seatTypeField = requesterPanel.down('#seatTypeItemId');
	    	 var emailField = requesterPanel.down('#emailItemId');
	    	 var mobileField = requesterPanel.down('#mobileNoItemId');
	    	 var nameValue = requesterPanel.down('#studentNameItemId');
	    	 
	    	 var msg = getServiceRequestTranslation('N_A');
	    	 
	    	 if(isNullOrEmpty(data.printName))
		     {
	    		 name.setValue(msg);
		     }else{
		    	 name.setValue(data.printName);
		    	 nameValue.setValue(data.printName);
		     }
	    	 
	    	 if(isNullOrEmpty(data.printName))
		     {
	    		 enteredBy.setValue(msg);
		     }else{
		    	 enteredBy.setValue(data.printName);
		     }
	    	 
	    	 if(isNullOrEmpty(data.emailId))
		     {
	    		 email.setValue(msg);
		     }else{
		    	 email.setValue(data.emailId);
		    	 emailField.setValue(data.emailId);
		     }
		    
	    	 if(isNullOrEmpty(data.mobileNumber))
		     {
	    		 mobile.setValue(msg);
		     }else{
		    	 mobile.setValue(data.mobileNumber);
		    	 mobileField.setValue(data.mobileNumber);
		     }
	    	 
	    	 if(isNullOrEmpty(data.programList))
		     {
	    		 programName.setValue(msg);
		     }else{
		    	 programName.setValue(data.programList);
		    	 programNameField.setValue(data.programList);
		     }
	    	 
	    	 if(isNullOrEmpty(data.batchList))
		     {
	    		 batchName.setValue(msg);
		     }else{
		    	 batchName.setValue(data.batchList);
		    	 batchNameField.setValue(data.batchList);
		     }
	    	 
	    	 
	    	 if(isNullOrEmpty(data.seatTypeList))
		     {
	    		 seatType.setValue(msg);
		     }else{
		    	 seatType.setValue(data.seatTypeList);
		    	 seatTypeField.setValue(data.seatTypeList);
		     }
	 		}
	});
},

saveCommitteeRequestDetails: function(form){
	var $this = this;
	var committeeRequestgrid = $this.getStudentapplyforcommitteegrid();	
	var filterForm = $this.getStudentapplyforcommitteefilter();
	var committeeRequestDetailForm = $this.getStudentcommitteerequesterdetailspanel();
	var membershipType = form.down('#membershipTypeItemId');
	var membershipDesc = null;
	var records = null;
	var store=membershipType.getStore();
	if( !isNullOrEmpty(membershipType.getStore())){
	if( !isNullOrEmpty(membershipType.getStore().data)){
	if( !isNullOrEmpty(membershipType.getStore().data.items)){
	var length = membershipType.getStore().data.items.length;	
	for(i=0; i < length; i++){	  
    if(membershipType.getStore().data.items[i].data.id == membershipType.getValue()){
    	 membershipDesc = membershipType.getStore().data.items[i].data.value;
                  }
              }   
		}
	}
	}    
	var json = $this.createSaveCommitteeRequestJson(form,committeeRequestDetailForm);	
	var submitUrl= SERVERURL.PATH_COMMITTEE_REQUEST_CREATE;
	var formData = Ext.encode(json);
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl,
		jsonData : json,
		method : 'POST',
		success : function(frm, action) {
			Ext.getBody().unmask();
			var responseData = Ext.decode(frm.responseText);
			if(!isNullOrEmpty(committeeRequestgrid)){
				var committeeRequestgridStore = committeeRequestgrid.getStore();
				committeeRequestgridStore.load();
				committeeRequestgrid.getSelectionModel().deselectAll();
				}
			if(!isNullOrEmpty(filterForm)){
				filterForm.down('#requestId').getStore().reload();
			}
			var tabName = getCommonTranslation('RAISE_REQUEST_FOR_COMMITTEE');
			var getcontroller=$this.getController('menu.CoreERPNavigationController');
			var getTab=getcontroller.getTab(tabName);
			if(getTab!=null){
				contentPanel.remove(getTab, true);
			}
			if(responseData == '-1'){
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('COMMITTEE_REQUEST_ALREADY_CREATED') + " " +membershipDesc);
			}else if (responseData == '-2'){
				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ALREADY_PART_OF_MEMBERSHIP_TYPE')+ " "+membershipDesc);
			}else {
				showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_REQUEST_CREATED_SUCCESSFULLY'));
			}
			}
	});
},
createSaveCommitteeRequestJson: function(form,committeeRequestDetailForm){
	var $this = this;
	var formValues = form.getForm().getValues();
	var requestDetailForm = committeeRequestDetailForm.getForm().getValues();
	var arr=[];
	var requestAssignedValue;
	var approvalStatus;
	if(formValues.requestAssignedToId == "true"){
		requestAssignedValue=null;
		approvalStatus = 'APPROVED';
	}else{
		requestAssignedValue = {
			     "id": formValues.requestAssignedToUserId
			 }
		approvalStatus = 'PENDING';
	}
	var arryRecordToSave={
			    "id": "",   
			    "studentId":{
				        "id": $this.getCurrentlyLoggedInUser().id
				},
				    "requesterName":requestDetailForm.studentNameValue,
				    "intakeList":requestDetailForm.batchName,
				    "programList":requestDetailForm.programName,
				    "seatTypeList":requestDetailForm.seatTypeName,
				    "email":requestDetailForm.emailID,
				    "mobileNo":requestDetailForm.mobileNo,
				    "enteredBy":{
					        "id": $this.getCurrentlyLoggedInUser().id
					    },
					 "requestAssignTo":requestAssignedValue,
					"requestDate":formValues.requestDate,
					"committeeId":{
						        "id": formValues.committeeId
						    },
					"membershipTypeId":{
						        "id": formValues.membershipType
					 },
					 "membershipAmount":formValues.membershipAmount,
					 "description":formValues.remarks,
					 "approvalStatus":approvalStatus     
	}
	return arryRecordToSave;
},
});
