Ext.define('Academia.controller.course.requisite.CourseRequisiteController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['course.AccessibleCourseDepartmentStore','course.AccessibleChildCourseStore',
		'course.requisite.CourseConditionParameterStore','course.requisite.CourseStatusStore',
		'course.requisite.CourseCGPAConditionStore','common.ExamPassedStore','course.requisite.CourseEducationExamStatusStore',
		'course.requisite.CourseScoreMethodStore','admission.applications.history.ResultStatus','common.EducationHistorySubjectStore','common.SubjectTypeStore'],
	views : ['course.requisite.CourseRequisiteStructure','course.requisite.CourseRequisiteFilter',
		'course.requisite.CourseRequisiteForm','course.requisite.CoursePreRequisiteCriteriaForm',
		'course.requisite.BatchCourseRequisiteStructure'],	           
	refs : [{
    	ref : 'contentPanel',
    	selector : 'contentPanel' 
    },{
		ref: 'courserequisitestructure',
		selector: 'courserequisitestructure'
	},{
		ref: 'courserequisitefilter',
		selector: 'courserequisitefilter[itemId=courserequisitefilterItemId]'
	},{
		ref: 'batchcourserequisitefilter',
		selector: 'courserequisitefilter[itemId=batchcourserequisitefilterItemId]'
	},{
		ref: 'courserequisiteform',
		selector: 'courserequisiteform[itemId=courserequisiteformItemId]'
	},{
		ref: 'batchcourserequisiteform',
		selector: 'courserequisiteform[itemId=batchcourserequisiteformItemId]'
	},{
		ref: 'courseprerequisitecriteriaform',
		selector: 'courseprerequisitecriteriaform'
	},{
		ref: 'batchcourserequisitestructure',
		selector: 'batchcourserequisitestructure'
	}],
	config:{},
	init : function() {
		this.control({
			'courserequisitestructure ' : {
				render : function(){
					var $this = this;
					var form = $this.getCourserequisitefilter();
					var departmentId = form.down('#courseDepartmentId').getValue();
					var courseStore = form.down('#courseId').getStore();
					courseStore.getProxy().extraParams = {
						departmentId: null
					};
					courseStore.load();
				}
			},
			'batchcourserequisitestructure ' : {
				render : function(){
					var $this = this;
					var form = $this.getBatchcourserequisitefilter();
					var departmentId = form.down('#courseDepartmentId').getValue();
					var courseStore = form.down('#courseId').getStore();
					courseStore.getProxy().extraParams = {
						departmentId: null
					};
					courseStore.load();
				}
			},
			'courserequisitefilter [itemId=courseDepartmentId]' : {
				select : function(){
					var $this = this;
					var activeContentPanel = this.getActiveTabfromContentPanel();
					var form = activeContentPanel.down('courserequisitefilter');
					var departmentId = form.down('#courseDepartmentId').getValue();
					var courseStore = form.down('#courseId').getStore();
					courseStore.getProxy().extraParams = {
						departmentId: departmentId
					};
					courseStore.load();
					
					$this.resetCourseRequisiteForm();
					var courseForm = activeContentPanel.down('courserequisiteform');
					courseForm.setVisible(false);
				}
			},
			'courserequisitefilter [itemId=courseId]' : {
				select : function(record){
					var $this = this;
					var activeContentPanel = this.getActiveTabfromContentPanel();
					var form = activeContentPanel.down('courserequisitefilter');
				//	form.down('#searchBtn').setDisabled(false);
					
					$this.resetCourseRequisiteForm();
					var courseForm = activeContentPanel.down('courserequisiteform');
					courseForm.setVisible(false);
				}
			},
			'courserequisitefilter button[itemId=resetBtn]' : {
				click : function(){
					var $this = this;
					var activeContentPanel = this.getActiveTabfromContentPanel();
					var form = activeContentPanel.down('courserequisitefilter');
			//		form.down('#searchBtn').setDisabled(true);
					var tabStcrFrm = activeContentPanel.down('courserequisitefilter');
					var departmentCombo = tabStcrFrm.down('#courseDepartmentId');
					var courseCombo = tabStcrFrm.down('#courseId');
					departmentCombo.reset();
					courseCombo.reset();

					var departmentId = departmentCombo.getValue();
					var courseStore = courseCombo.getStore()
					courseStore.getProxy().extraParams = {
						departmentId: departmentId
					};
					courseStore.load();
					
					var courseForm = activeContentPanel.down('courserequisiteform');
					courseForm.setVisible(false);
					
					$this.resetCourseRequisiteForm();
				}				
			},
			'courserequisitefilter button[itemId=searchBtn]' : {
				click : function(){
					var $this = this;
					
					var filterForm = this.getCourserequisitefilter();
					var courseIdFilter = filterForm.down('#courseId');
					var courseIdVal = courseIdFilter.getValue();
					/*
					var courseId = form.down('#courseId');
					var courseMutuallyId = form.down('#courseMutuallyId');
					var courseReqStore = courseId.getStore();
					var courseMutuallyStore = courseMutuallyId.getStore();
					courseReqStore.getProxy().extraParams = {
						courseId: courseIdVal
					};
					courseReqStore.load();
					
					courseMutuallyStore.getProxy().extraParams = {
						courseId: courseIdVal
					};
					courseMutuallyStore.load();*/
					
					$this.checkRequisiteFormData(courseIdVal,null);
				}				
			},
			'courseprerequisitecriteriaform button[itemId=lineButtonPre]' : {
				click : function(btn){
					this.addLineItemsComponent(btn);
				}
			},
			'courseprerequisitecriteriaform button[itemId=groupButtonPreReq]' : {
				click:function(btn){
					var $this = this; 
					var form = btn.up('courseprerequisitecriteriaform');
					var andOrComponent = form.down('button#andOrComponent');
					var logicalOperator;
					if(andOrComponent.text === 'All') {
		        		logicalOperator = 'AND';	
		        	} else if (andOrComponent.text === 'Any' || andOrComponent.text === 'ANY'){
		        		logicalOperator = 'OR';
		        	} else {
		        		logicalOperator = 'AND';
		        	}
					var activeContentPanel = this.getActiveTabfromContentPanel();
					var courseForm = activeContentPanel.down('courserequisiteform');
					var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
					/*if(!isNullOrEmpty(batchcourserequisiteform)){
						courseForm = this.getBatchcourserequisiteform();
					}*/
					
					var coursePreChildGroupItemId = courseForm.down('#coursePreChildGroupItemId');
					coursePreChildGroupItemId.add({
						xtype:'form',
						//itemId:"coursePreChildGroupItemId",
						cls: 'panelNoSpace cbCustomPanel',
					    paddingLeft:  '0',
					    marginLeft: '0',
					    padding: '1 1 1 1',
					    layout: {
					        type: 'hbox'
					    },
					    style :{
							marginBottom:'0px'
						},
					    cls: 'tbarWithnoSpacing',
					    ui: 'tbarWithnoSpacing',
					    tbar: [{
							xtype: 'text',
							itemId: 'andOrComponentText',
							minWidth: '27px',
							text:logicalOperator,
							margin: '7 0 0 0'
						},{
					    	xtype: 'button',
					    	itemId: 'andOrComponent',
					    	text: 'All',
					    	cls: 'CustomBodyBtnSettings',
					    	enableToggle: true,
					    	pressedText: getCommonTranslation('COURSE_PRE_ANY_TEXT'),
					    	depressedText: getCommonTranslation('ALL'),
					    	toggleHandler: function () {
					    		if(this.pressed) {
					    			this.setText(this.pressedText);
					    			this.up('form').andOrComponentValue = 'OR'; 
					    		} else {
					    			this.setText(this.depressedText);
					    			this.up('form').andOrComponentValue = 'AND';
					    		}
					    		$this.changeLogicalOperandCoursePre(this.up('form'), this.up('form').andOrComponentValue);
					    	}
					    }, {
					    	xtype: 'label',
					    	text: getCommonTranslation('PROGRAMCOURSEPREREQUISITEDEFAULTTEXTHALF'),
					    	style :{
					    		color:'#000'
					    	}
					    },
					    '->',
					    {
					    	xtype: 'button',
					    	itemId: 'lineButtonPre',
					    	cls: 'CustomBodyBtnSettings',
					    	text: getCommonTranslation('ADDBUTTONTEXT'),
					    	tooltip: getCommonTranslation('ADD'),
					    	width: 24,
					    	handler: function(btn) {
					    		$this.addLineItemsComponent(btn);
					    	}

					    },{
					    	xtype: 'button',
					    	itemId: 'groupDeleteButton',
					    	glyph: ICONGLYPH.DELETEGLYPH,
					    	cls: 'CustomBodyBtnReject',
					    	tooltip: getCommonTranslation('DELETETOOLTIP'),
					    	handler: function() {
					    		var groupContainerPanel= this.up('panel');
					    		var formPnl = groupContainerPanel.up('courserequisiteform').getForm();
					    		groupContainerPanel.close();
					    		formPnl.checkValidity();
					    	}
					    }],
					    items: [{
					    	xtype: 'text',
					    	itemId: 'andOrComponentText',
					    	minWidth: '27px',
					    	padding: '9 0 0 0'
					    },{
					    	xtype: 'form',
					    	autoScroll: true,
					    	itemId: 'verticalPanel',
					    	cls: 'noBorderPane',
					    	margin: '0 0 0 0',
					    	padding: '0 0 0 0',
					    	flex: 1,
					    	layout: {
					    		type: 'vbox',
					    		align: 'stretch'
					    	}
					    }]
					});
				}
			},
			'courserequisiteform button[itemId=courseRequisiteSaveButtonId]' : {
				click:function(){
					this.saveCourseRequisiteFormData();
				}
			},
			'courserequisiteform button[itemId=resetCourseRequisiteButton]' : {
				click:function(){
					this.resetCourseRequisiteForm();
				}
			},
			'courserequisiteform[itemId=batchcourserequisiteformItemId] multiselectcombofield[itemId=courseId]' : {
				change: function(field, newValue, oldValue, eOpts){
					var $this = this;

			    	var activeContentPanel = this.getActiveTabfromContentPanel();
					var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
					
					var hidTxtFld = batchcourserequisiteform.down('#hiddenTextFieldForDisableSaveBtnItemId');
					
					var courseMutuallyId = batchcourserequisiteform.down('#courseMutuallyId').getValue();
					
					$this.setAllowBlank(hidTxtFld,true);
					var isDataInCourseReq = false;
					var isDataInMutuallyReq = false;
					var isDataInPreReq= false;
					
					if(!isNullOrEmpty(newValue)){
	    				if(newValue.length > 0 && !isNullOrEmpty(newValue[0])){
	    					isDataInCourseReq = true;
	    				}
	    			}
					if(!isNullOrEmpty(courseMutuallyId)){
	    				if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
	    					isDataInMutuallyReq = true;
	    				}
	    			}
					var coursePreGroupItemId = batchcourserequisiteform.down('#coursePreGroupItemId');
					var coursePreChildGroupItemId = batchcourserequisiteform.down('#coursePreChildGroupItemId');
					
					if(!isNullOrEmpty(coursePreChildGroupItemId)){
						var arryItems = coursePreChildGroupItemId.items.items;
						if(arryItems.length>0){
							isDataInPreReq = true;
						}
					}
					
					if(!isNullOrEmpty(coursePreGroupItemId)){
						var verticalPanel = coursePreGroupItemId.down('panel#verticalPanel');
						if(verticalPanel.items.length > 0){
							isDataInPreReq = true;
			    		}
					}
					if(isDataInCourseReq || isDataInMutuallyReq || isDataInPreReq){
						$this.setAllowBlank(hidTxtFld,true);
					}else{
						$this.setAllowBlank(hidTxtFld,false);
					}
					batchcourserequisiteform.getForm().checkValidity();
					
					var diffVal;
					var flag = true;
					if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
						diffVal = Ext.Array.difference(newValue,oldValue);
					}
					else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
						diffVal = newValue;
					}
					
					if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
						if(!isNullOrEmpty(courseMutuallyId)){
							if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
								courseMutuallyId.forEach(function(obj){
									if(!isNullOrEmpty(obj)){
										if(isNaN(obj)){
											if(obj.data.id  == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
										else{
											if(obj == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
						}
						var courseCombos = field.up('form').down('#courseChildId');
						if(!isNullOrEmpty(courseCombos) && courseCombos.length>0){
							courseCombos.forEach(function(obj){
								if(obj.id != field.id){
									var valueModels = obj.valueModels;
									if(!isNullOrEmpty(valueModels)){
										var indx = valueModels.filter(function (obj) {
											  return obj.data.id === diffVal[0];
											})[0];
										
										if(!isNullOrEmpty(indx)){
				    						flag = false;
				    						return false;
				    					}
									}
								}
							});
						}
	    				
	    				if(!flag){
	    					field.reset();
	    					field.clearAllDataFn();
	    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
	    						field.setValue(oldValue);
	    					}
	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
	    					return false;
	    				}
					}
				}
			},
			'courserequisiteform[itemId=batchcourserequisiteformItemId] multiselectcombofield[itemId=courseMutuallyId]' : {
				change: function(field, newValue, oldValue, eOpts){
					var $this = this;

			    	var activeContentPanel = this.getActiveTabfromContentPanel();
					var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
					var hidTxtFld = batchcourserequisiteform.down('#hiddenTextFieldForDisableSaveBtnItemId');
					
					var courseId = batchcourserequisiteform.down('#courseId').getValue();
					
					$this.setAllowBlank(hidTxtFld,true);
					
					var isDataInCourseReq = false;
					var isDataInMutuallyReq = false;
					var isDataInPreReq= false;
					
					if(!isNullOrEmpty(newValue)){
	    				if(newValue.length > 0 && !isNullOrEmpty(newValue[0])){
	    					isDataInMutuallyReq = true;
	    				}
	    			}
					if(!isNullOrEmpty(courseId)){
	    				if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
	    					isDataInCourseReq = true;
	    				}
	    			}
					
					var coursePreGroupItemId = batchcourserequisiteform.down('#coursePreGroupItemId');
					var coursePreChildGroupItemId = batchcourserequisiteform.down('#coursePreChildGroupItemId');
					
					if(!isNullOrEmpty(coursePreChildGroupItemId)){
						var arryItems = coursePreChildGroupItemId.items.items;
						if(arryItems.length>0){
							isDataInPreReq= true;
						}
					}
					
					if(!isNullOrEmpty(coursePreGroupItemId)){
						var verticalPanel = coursePreGroupItemId.down('panel#verticalPanel');
						if(verticalPanel.items.length > 0){
							isDataInPreReq= true;
			    		}
					}
					
					if(isDataInCourseReq || isDataInMutuallyReq || isDataInPreReq){
						$this.setAllowBlank(hidTxtFld,true);
					}else{
						$this.setAllowBlank(hidTxtFld,false);
					}
					
					batchcourserequisiteform.getForm().checkValidity();
					
					var diffVal;
					var flag = true;
					if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
						diffVal = Ext.Array.difference(newValue,oldValue);
					}
					else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
						diffVal = newValue;
					}
					
					if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
						if(!isNullOrEmpty(courseId)){
							if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
								courseId.forEach(function(obj){
									if(!isNullOrEmpty(obj)){
										if(isNaN(obj)){
											if(obj.data.id  == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
										else{
											if(obj == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
						}
						var courseCombos = field.up('form').down('#courseChildId');
						if(!isNullOrEmpty(courseCombos) && courseCombos.length>0){
							courseCombos.forEach(function(obj){
								if(obj.id != field.id){
									var valueModels = obj.valueModels;
									if(!isNullOrEmpty(valueModels)){
										var indx = valueModels.filter(function (obj) {
											  return obj.data.id === diffVal[0];
											})[0];
										
										if(!isNullOrEmpty(indx)){
				    						flag = false;
				    						return false;
				    					}
									}
								}
							});
						}
	    				
	    				if(!flag){
	    					field.reset();
	    					field.clearAllDataFn();
	    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
	    						field.setValue(oldValue);
	    					}
	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
	    					return false;
	    				}
					}
				}
			},
			'courserequisiteform[itemId=courserequisiteformItemId] multiselectcombofield[itemId=courseId]' : {
				change: function(field, newValue, oldValue, eOpts){
					var $this = this;

			    	var activeContentPanel = this.getActiveTabfromContentPanel();
					var courserequisiteform = activeContentPanel.down('#courserequisiteformItemId');
					
					var courseMutuallyId = courserequisiteform.down('#courseMutuallyId').getValue();
					
					
					var diffVal;
					var flag = true;
					if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
						diffVal = Ext.Array.difference(newValue,oldValue);
					}
					else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
						diffVal = newValue;
					}
					
					if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
						if(!isNullOrEmpty(courseMutuallyId)){
							if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
								courseMutuallyId.forEach(function(obj){
									if(!isNullOrEmpty(obj)){
										if(isNaN(obj)){
											if(obj.data.id  == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
										else{
											if(obj == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
						}
						var courseCombos = field.up('form').down('#courseChildId');
						if(!isNullOrEmpty(courseCombos) && courseCombos.length>0){
							courseCombos.forEach(function(obj){
								if(obj.id != field.id){
									var valueModels = obj.valueModels;
									if(!isNullOrEmpty(valueModels)){
										var indx = valueModels.filter(function (obj) {
											  return obj.data.id === diffVal[0];
											})[0];
										
										if(!isNullOrEmpty(indx)){
				    						flag = false;
				    						return false;
				    					}
									}
								}
							});
						}
	    				
	    				if(!flag){
	    					field.reset();
	    					field.clearAllDataFn();
	    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
	    						field.setValue(oldValue);
	    					}
	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
	    					return false;
	    				}
					}
				}
			},
			'courserequisiteform[itemId=courserequisiteformItemId] multiselectcombofield[itemId=courseMutuallyId]' : {
				change: function(field, newValue, oldValue, eOpts){
					var $this = this;
			    	var activeContentPanel = this.getActiveTabfromContentPanel();
					var courserequisiteform = activeContentPanel.down('#courserequisiteformItemId');
					var courseId = courserequisiteform.down('#courseId').getValue();
					var diffVal;
					var flag = true;
					if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
						diffVal = Ext.Array.difference(newValue,oldValue);
					}
					else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
						diffVal = newValue;
					}
					
					if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
						if(!isNullOrEmpty(courseId)){
							if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
								courseId.forEach(function(obj){
									if(!isNullOrEmpty(obj)){
										if(isNaN(obj)){
											if(obj.data.id  == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
										else{
											if(obj == diffVal[0]){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
						}
						var courseCombos = field.up('form').down('#courseChildId');
						if(!isNullOrEmpty(courseCombos) && courseCombos.length>0){
							courseCombos.forEach(function(obj){
								if(obj.id != field.id){
									var valueModels = obj.valueModels;
									if(!isNullOrEmpty(valueModels)){
										var indx = valueModels.filter(function (obj) {
											  return obj.data.id === diffVal[0];
											})[0];
										
										if(!isNullOrEmpty(indx)){
				    						flag = false;
				    						return false;
				    					}
									}
								}
							});
						}
	    				
	    				if(!flag){
	    					field.reset();
	    					field.clearAllDataFn();
	    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
	    						field.setValue(oldValue);
	    					}
	    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
	    					return false;
	    				}
					}
				}
			},
			'courserequisitestructure': {
    			render: function(structure){
    				var $this = this;
    				structure.body.on('click', function() {
    	    			var filter = structure.down('#courserequisitefilterItemId');
    	    			$this.hideInvalidIconFromField(filter);
    	    	       });
    			}
    		}
		});
	},
	addLineItemsComponent: function(btn){
		var $this = this;
		var form = btn.up('form');
		//var form = this.getCourseprerequisitecriteriaform();
		var verticalPanel = form.down('panel#verticalPanel');
		var courserequisiteform = form.up('courserequisiteform');
		var andOrComponent = form.down('button#andOrComponent');
		var logicalOperator;
		if(andOrComponent.text === 'All') {
    		logicalOperator = 'AND';	
    	} else if (andOrComponent.text === 'Any' || andOrComponent.text === 'ANY'){
    		logicalOperator = 'OR';
    	} else {
    		logicalOperator = 'AND';
    	}
		
		verticalPanel.add({
			xtype:'panel',
			layout : 'hbox',
			margin: '10 10 10 10',
			padding: '0 1 0 1',
			items:[{
				xtype: 'text',
				itemId: 'andOrComponentText',
				minWidth: '27px',
				text:logicalOperator,
				margin: '7 0 0 0'
			},{
				xtype: 'button',
			    itemId: 'lineDeleteButton',
			    cls: 'CustomBodyBtnReject',
			    glyph: ICONGLYPH.DELETEGLYPH,
			    tooltip:'Delete',
			    handler: function() {
			    	$this.deleteLineItemsComponent(this);
			    }
			},{
				xtype: 'customcombobox',
				name:'conditionParam',
				width:165,
				itemId: 'conditionParamId',
				store:Ext.create('Academia.store.course.requisite.CourseConditionParameterStore'),
				displayField: 'name',
				valueField: 'value',
				editable:false,
				forceSelection:true,
				allowBlank:false,
				typeAhead:false,
				listeners:{
					select:function(combo,record){
						$this.addConditionParamComponents(combo,record);
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype:'panel',
				itemId:'pnlAddChildComponents',
				hidden:true,
				layout : 'hbox',
				margin: '0 10 0 10',
				plugins : "formlabelrequired",
				items:[]
			}]
		});
		var hidTxtFld = courserequisiteform.down('#hiddenTextFieldForDisableSaveBtnItemId');
		$this.setAllowBlank(hidTxtFld,true);
	},
	addConditionParamComponents:function(combo,record){
		var $this = this;
		var pnl = combo.up('panel');
		var pnlAddChildComponents = pnl.down('#pnlAddChildComponents');
		pnlAddChildComponents.removeAll();
		var courserequisiteform = this.getCourserequisiteform();
		
		var activeContentPanel = this.getActiveTabfromContentPanel();
		var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
		if(!isNullOrEmpty(batchcourserequisiteform)){
			courserequisiteform = activeContentPanel.down('courserequisiteform');
		}
		var batchId = courserequisiteform.config.batchId;
		var academyLocationId = this.getCurrentAcademyLocation();
		if(record[0].data.value=="COURSE"){
			pnlAddChildComponents.add({
				xtype: 'customcombobox',
				name:'courseStatus',
				width:165,
				itemId: 'courseStatusId',
				store:Ext.create('Academia.store.course.requisite.CourseStatusStore'),
				displayField: 'name',
				valueField: 'value',
				forceSelection:true,
				allowBlank:false,
				typeAhead:false,
				editable:false,
				/*listeners:{
					select:function(combo,record){
						$this.addConditionParamComponents(combo,record);
					}
				},*/
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				listeners: {
					select:function(combo,record){
						var pnlAddChildComponents = this.up('#pnlAddChildComponents');
						var courseChildId = pnlAddChildComponents.down('#courseChildId');
						var courseMarksGradesReq = pnlAddChildComponents.down('#courseMarksGradesReq');
						var gradeMarkCourseChild = pnlAddChildComponents.down('#gradeMarkCourseChild');
						
						var minPassingMarks = pnlAddChildComponents.down('#minPassingMarks');
						var gradeType = pnlAddChildComponents.down('#gradeType');
						var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
						
						minPassingMarks.setVisible(false);
						gradeType.setVisible(false);
						minimumPassingGrade.setVisible(false);
						
						var filterForm = $this.getCourserequisitefilter();
						if(isNullOrEmpty(filterForm)){
							filterForm = $this.getBatchcourserequisitefilter()
						}
						var courseIdFilter = filterForm.down('#courseId');
						var courseIdVal = courseIdFilter.getValue();
						
						if(combo.getValue() == "QUALIFYING_MARKS_GRADE"){
							courseMarksGradesReq.setVisible(true);
							gradeMarkCourseChild.setVisible(true);
							courseChildId.setVisible(false);
							
							courseMarksGradesReq.reset();
							gradeMarkCourseChild.reset();
							courseChildId.reset();
							
							courseChildId.clearAllDataFn();
							$this.setAllowBlank(courseChildId,true);
							$this.setAllowBlank(gradeMarkCourseChild,false);
							
							courseMarksGradesReq.store.load({
								callback: function(){
									courseMarksGradesReq.reset();
									courseMarksGradesReq.setValue('GRADE');
								}
							});
						}
						else{
							courseMarksGradesReq.setVisible(false);
							gradeMarkCourseChild.setVisible(false);
							courseChildId.setVisible(true);
							
							courseMarksGradesReq.reset();
							gradeMarkCourseChild.reset();
							courseChildId.reset();
							
							courseChildId.clearAllDataFn();
							$this.setAllowBlank(courseChildId,false);
							$this.setAllowBlank(gradeMarkCourseChild,true);
							
							var courseChildIdStore = courseChildId.getStore();
							courseChildIdStore.getProxy().extraParams = {
								courseId: courseIdVal
							};
							if(!isNullOrEmpty(batchId)){
								courseChildIdStore.getProxy().extraParams = {
									courseId: courseIdVal,
									academyLocationId:academyLocationId
								};
							}
							courseChildIdStore.load();
							pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
						}
					}
				}
			},{
				xtype : 'customcombobox',
				name : 'courseMarkGradeReq',
				itemId:'courseMarksGradesReq',
				fieldLabel : false,	
				store:Ext.create('Academia.store.course.CourseMarkGradeStore'),
				valueField : 'id',
				displayField : 'value',
				triggerAction : 'all',
				editable : false,
				allowBlank : true,
				hidden: true,
				margin: '0 0 0 10',
				width: 100,
				listeners:{
					change: function(combo){
						
						var pnlAddChildComponents = this.up('#pnlAddChildComponents');
						var gradeMarkCourseChild = pnlAddChildComponents.down('#gradeMarkCourseChild');
						var minPassingMarks = pnlAddChildComponents.down('#minPassingMarks');
						var gradeType = pnlAddChildComponents.down('#gradeType');
						var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');

						var filterForm = $this.getCourserequisitefilter();
						if(isNullOrEmpty(filterForm)){
							filterForm = $this.getBatchcourserequisitefilter()
						}
						var courseIdFilter = filterForm.down('#courseId');
						var courseIdVal = courseIdFilter.getValue();

						var markGrade = combo.getValue();
						
						if(markGrade == "MARK"){
							minPassingMarks.setVisible(true);
							minPassingMarks.reset();
							$this.setAllowBlank(minPassingMarks,false);
							
							gradeType.setVisible(false);
							gradeType.reset();
							gradeType.getStore().removeAll();
							$this.setAllowBlank(gradeType,true);
							
							minimumPassingGrade.setVisible(false);
							minimumPassingGrade.reset();
							minimumPassingGrade.getStore().removeAll();
							$this.setAllowBlank(minimumPassingGrade,true);
							var markGradVal = "M";
						}
						else if(markGrade == "GRADE"){
							minPassingMarks.setVisible(false);
							minPassingMarks.reset();
							$this.setAllowBlank(minPassingMarks,true);
							
							gradeType.setVisible(true);
							gradeType.reset();
							gradeType.getStore().removeAll();
							$this.setAllowBlank(gradeType,false);
							
							minimumPassingGrade.setVisible(true);
							minimumPassingGrade.reset();
							minimumPassingGrade.getStore().removeAll();
							$this.setAllowBlank(minimumPassingGrade,false);
							var markGradVal = "G";
						}
						
						var departmentFilter = filterForm.down('#courseDepartmentId');
						var departmentIdVal = departmentFilter.getValue();
						//courseName
						
						gradeMarkCourseChild.reset();
						var courseChildIdStore = gradeMarkCourseChild.getStore();
						courseChildIdStore.getProxy().extraParams = {
							courseId: courseIdVal,
							courseMarksGrades: markGradVal,
							departmentId: departmentIdVal
						};
						if(!isNullOrEmpty(batchId)){
							courseChildIdStore.getProxy().extraParams = {
								courseId: courseIdVal,
								academyLocationId:academyLocationId,
								courseMarksGrades: markGradVal,
								departmentId: departmentIdVal
							};
						}
						courseChildIdStore.load();
						pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
					}
				}
			},{
				xtype : 'customcombobox',
				name : 'gradeMarkCourseChild',
				itemId:'gradeMarkCourseChild',
				fieldLabel : false,	
				store:Ext.create('Academia.store.course.ALMarkGradeChildCourseStore'),
				displayField : 'valueCode',
				valueField : 'id',
				triggerAction : 'all',
				editable : false,
				allowBlank : true,
				hidden: true,
				margin: '0 0 0 10',
				width: 460,
				listeners: {
					change: function(field){
						/*var courseForm = $this.getCourserequisiteform();
						
						if(!isNullOrEmpty(batchId)){
							courseForm = $this.getBatchcourserequisiteform();
						}*/
						var courseForm = field.up('courserequisiteform');
						var courseId = courseForm.down('#courseId').getValue();
						var coursePreGroupItemId = courseForm.down('#coursePreGroupItemId');
						var coursePreChildGroupItemId = courseForm.down('#coursePreChildGroupItemId');
						var courseMutuallyId = courseForm.down('#courseMutuallyId').getValue();
						var pnlAddChildComponents = this.up('#pnlAddChildComponents');
						var gradeType = pnlAddChildComponents.down('#gradeType');
						
						var diffVal;
						var flag = true;
						
						var oldValue = [];
						if(!isNullOrEmpty(field.getValue())){
							var newValue = [field.getValue()];
						}
						else{
							var newValue = [];
						}
						
						if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
							diffVal = Ext.Array.difference(newValue,oldValue);
						}
						else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
							diffVal = newValue;
						}
						
						if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
							if(!isNullOrEmpty(courseId)){
								if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
									courseId.forEach(function(obj){
										if(!isNullOrEmpty(obj)){
											if(isNaN(obj)){
												if(obj.data.id  == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
											else{
												if(obj == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
										}
									});
								}
							}
							if(!isNullOrEmpty(courseMutuallyId)){
								if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
									courseMutuallyId.forEach(function(obj){
										if(!isNullOrEmpty(obj)){
											if(isNaN(obj)){
												if(obj.data.id  == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
											else{
												if(obj == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
										}
									});
								}
							}
							var courseCombos = field.up('form').down('#courseChildId');
							if(courseCombos.length>0){
								courseCombos.forEach(function(obj){
									if(obj.id != field.id){
										var valueModels = obj.valueModels;
										if(!isNullOrEmpty(valueModels)){
											var indx = valueModels.filter(function (obj) {
												  return obj.data.id === diffVal[0];
												})[0];
											
											if(!isNullOrEmpty(indx)){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
							
							var courseNewCombos = field.up('form').down('#gradeMarkCourseChild');
							if(courseNewCombos.length>0){
								courseNewCombos.forEach(function(obj){
									if(obj.id != field.id){
										var valueModels = obj.valueModels;
										if(!isNullOrEmpty(valueModels)){
											var indx = valueModels.filter(function (obj) {
												  return obj.data.id === diffVal[0];
												})[0];
											
											if(!isNullOrEmpty(indx)){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
		    				
		    				if(!flag){
		    					field.reset();
		    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
		    						field.setValue(oldValue);
		    					}
		    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
		    					return false;
		    				}
		    				else{
		    					var courseGradeType = field.findRecord(field.valueField,field.getValue()).raw.courseGradeType;
		    					
		    					gradeType.getStore().loadData([{
		    						gradeType: courseGradeType
		    					}]);
		    					setTimeout(function(){
			    					gradeType.setValue(courseGradeType);
			    					
			    					var gradeTypeVal = gradeType.getValue();
									var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
									
									minimumPassingGrade.reset();
									minimumPassingGrade.store.removeAll();
									
									if(!isNullOrEmpty(gradeTypeVal)){
										Ext.Ajax.request({
									 		   type : 'rest',
									 		   async: false,
									 		   url : SERVERURL.EVALUATION_FORM_ONE_GRADES_COMBO_URL,
									 		   params : {
									 			  gradeType: gradeTypeVal
									 		   },
									 		   method : 'GET',
									 		   success : function(f, action) {
									 			  if(!isNullOrEmpty(f.responseText)){
									 				 var res = Ext.JSON.decode(f.responseText);  
									 				 if(res.length>0){
									 					 minimumPassingGrade.store.add(res);
									 				 }
									 			  }
									 		   }
										});
									}
		    					},300);
		    				}
						}
						
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'courseChild',
				itemId: 'courseChildId',
				autoloadStore: false,
				width: 460,
				store:Ext.create('Academia.store.course.UserAccessibleALChildCourseStore'),
				displayField : 'valueCode',
				valueField : 'id',
				queryParam:'courseName',
				margin: '0 0 0 10',
				minChars:3,
				hidden:true,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				queryMode:'remote',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listeners: {
					change: function(field, newValue, oldValue, eOpts){
						var $this = this;
						var courserequisiteform = field.up('courserequisiteform');
						var courseId = courserequisiteform.down('#courseId').getValue();
						var coursePreGroupItemId = courserequisiteform.down('#coursePreGroupItemId');
						var coursePreChildGroupItemId = courserequisiteform.down('#coursePreChildGroupItemId');
						
						var courseId = courserequisiteform.down('#courseId').getValue();
						var courseMutuallyId = courserequisiteform.down('#courseMutuallyId').getValue();
						var diffVal;
						var flag = true;
						if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
							diffVal = Ext.Array.difference(newValue,oldValue);
						}
						else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
							diffVal = newValue;
						}
						
						if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
							if(!isNullOrEmpty(courseId)){
								if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
									courseId.forEach(function(obj){
										if(!isNullOrEmpty(obj)){
											if(isNaN(obj)){
												if(obj.data.id  == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
											else{
												if(obj == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
										}
									});
								}
							}
							if(!isNullOrEmpty(courseMutuallyId)){
								if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
									courseMutuallyId.forEach(function(obj){
										if(!isNullOrEmpty(obj)){
											if(isNaN(obj)){
												if(obj.data.id  == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
											else{
												if(obj == diffVal[0]){
						    						flag = false;
						    						return false;
						    					}
											}
										}
									});
								}
							}
							var courseCombos = this.up('form').down('#courseChildId');
							if(courseCombos.length>0){
								courseCombos.forEach(function(obj){
									if(obj.id != field.id){
										var valueModels = obj.valueModels;
										if(!isNullOrEmpty(valueModels)){
											var indx = valueModels.filter(function (obj) {
												  return obj.data.id === diffVal[0];
												})[0];
											
											if(!isNullOrEmpty(indx)){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
							
							var courseNewCombos = this.up('form').down('#gradeMarkCourseChild');
							if(courseNewCombos.length>0){
								courseNewCombos.forEach(function(obj){
									if(obj.id != field.id){
										var valueModels = obj.valueModels;
										if(!isNullOrEmpty(valueModels)){
											var indx = valueModels.filter(function (obj) {
												  return obj.data.id === diffVal[0];
												})[0];
											
											if(!isNullOrEmpty(indx)){
					    						flag = false;
					    						return false;
					    					}
										}
									}
								});
							}
							
		    				if(!flag){
		    					field.reset();
		    					field.clearAllDataFn();
		    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
		    						field.setValue(oldValue);
		    					}
		    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
		    					return false;
		    				}
						}
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{
				xtype: 'numberfield',
				name: 'minPassingMarks',
				itemId: 'minPassingMarks',
				fieldLabel : false,
				hideTrigger: true,
				mouseWheelEnabled:false,
				maxLength: 6,
				minValue:1,
				maxValue:100,
				width:100,
				keyNavEnabled: false,
				allowExponential:false,
				allowDecimals: false,
				margin: '0 0 0 10',
				hidden: true
			},{
				xtype : 'customcombobox',
				name : 'gradeType',
				itemId:'gradeType',
				fieldLabel : false,	
				readOnly: true,
				store:Ext.create('Ext.data.Store', {
				    fields:['gradeType'],
				    data:[]
				}),
				valueField : 'gradeType',
				displayField : 'gradeType',
				triggerAction : 'all',
				editable : false,
				allowBlank : true,
				hidden: true,
				margin: '0 0 0 10',
				width: 100,
				queryMode: 'local',
				listeners:{
					change: function(combo){
						var gradeTypeVal = combo.getValue();
						
						var pnlAddChildComponents = this.up('#pnlAddChildComponents');
						var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
						
						minimumPassingGrade.reset();
						minimumPassingGrade.store.removeAll();
						
						if(!isNullOrEmpty(gradeTypeVal)){
							
							Ext.Ajax.request({
						 		   type : 'rest',
						 		   async: false,
						 		   url : SERVERURL.EVALUATION_FORM_ONE_GRADES_COMBO_URL,
						 		   params : {
						 			  gradeType: gradeTypeVal
						 		   },
						 		   method : 'GET',
						 		   success : function(f, action) {
						 			  if(!isNullOrEmpty(f.responseText)){
						 				 var res = Ext.JSON.decode(f.responseText);  
						 				 if(res.length>0){
						 					 minimumPassingGrade.store.add(res);
						 				 }
						 			  }
						 		   }
							});
						}
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'minimumPassingGrade',
				itemId: 'minimumPassingGrade',
				autoloadStore: false,
				store:Ext.create('Ext.data.Store', {
				    fields:['id','gradeName','gradePoint','gradeRangeFrom','gradeRangeTo','gradeStatus','gradeType','isContributeInTheSgpaCgpa','isContributeInTheTotalCredits'],
				    data:[]
				}),
				displayField : 'gradeName',
				valueField : 'gradeName',
				margin: '0 0 0 10',
				typeAhead:false,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				hidden: true,
				queryMode: 'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
				width: 100
			});
			
		} else if(record[0].data.value=="CGPA"){
			pnlAddChildComponents.add({
				xtype: 'customcombobox',
				name:'courseCGPACondition',
				width:165,
				itemId: 'courseCGPAConditionId',
				store:Ext.create('Academia.store.course.requisite.CourseCGPAConditionStore'),
				displayField: 'name',
				valueField: 'value',
				forceSelection:true,
				editable:false,
				typeAhead:false,
				allowBlank:false,
				listeners: {
					select:function(combo,record){
						var pnlAddChildComponents = this.up('#pnlAddChildComponents');
						var numberOfCGPAId = pnlAddChildComponents.down('#numberOfCGPAId');
						numberOfCGPAId.setVisible(true);
						numberOfCGPAId.reset();
						$this.setAllowBlank(numberOfCGPAId,false);
						pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'numberfield',
				name: 'numberOfCGPA',
				itemId: 'numberOfCGPAId',
				hidden:true,
				margin: '0 0 0 10',
				hideTrigger: true,
				mouseWheelEnabled:false,
				maxLength: 5,
				//enforceMaxLength : true,
				minValue:1,
				width:165,
				maxValue:10,
				keyNavEnabled: false,
				allowDecimals: true,
				allowExponential:false,
				decimalPrecision:2
			});
			
		} else if(record[0].data.value=="CREDITS"){
			pnlAddChildComponents.add({
				xtype: 'customcombobox',
				name:'courseCumulativeCreditsCondition',
				width:165,
				itemId: 'courseCumulativeCreditsConditionId',
				store:Ext.create('Academia.store.course.requisite.CourseCGPAConditionStore'),
				displayField: 'name',
				valueField: 'value',
				forceSelection:true,
				editable:false,
				typeAhead:false,
				allowBlank:false,
				listeners: {
					select:function(combo,record){
						var pnlAddChildComponents = this.up('#pnlAddChildComponents');
						var numberOfCGPAId = pnlAddChildComponents.down('#numberOfCumulativeCreditsId');
						numberOfCGPAId.setVisible(true);
						numberOfCGPAId.reset();
						$this.setAllowBlank(numberOfCGPAId,false);
						pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'numberfield',
				name: 'numberOfCumulativeCredits',
				itemId: 'numberOfCumulativeCreditsId',
				hidden:true,
				margin: '0 0 0 10',
				hideTrigger: true,
				mouseWheelEnabled:false,
				maxLength: 6,
				//enforceMaxLength : true,
				minValue:1,
				maxValue:999,
				keyNavEnabled: false,
				width:165,
				allowExponential:false,
				allowDecimals: true,
				decimalPrecision:2,
				allowBlank:false
			});
			
		} else if(record[0].data.value=="EDUCATION"){
			pnlAddChildComponents.add({
				xtype:'panel',
				layout : 'vbox',
				itemId:'educationPanel',
				margin: '0 0 0 0',
				padding: '0 0 0 0',
				items:[{
					xtype:'fieldcontainer',
					layout : 'hbox',
					items:[{
						xtype: 'nestedJsonCombo',
						itemId: 'examPassed',
						store: 'common.ExamPassedStore',
						valueField: 'id',
						displayField: 'value',
						name: 'examPassed',
						editable : false,
						allowBlank:false,
						hideTrigger:false,
						triggerAction: 'all',
						width:165,
						forceSelection:true,
						listeners: {
							select:function(combo,record){
								var pnlAddChildComponents = this.up('#pnlAddChildComponents');
								var educationExamPassedStatusId = pnlAddChildComponents.down('#educationExamPassedStatusId');
								educationExamPassedStatusId.setVisible(true);
								educationExamPassedStatusId.reset();
								$this.setAllowBlank(educationExamPassedStatusId,false);

								//var scoreMethodId = pnlAddChildComponents.down('#scoreMethodId');
								var educationOperatorConditionId = pnlAddChildComponents.down('#educationOperatorConditionId');
								var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
								var subjectMappedId = pnlAddChildComponents.down('#subjectMappedId');
								var resultStatusMappedId = pnlAddChildComponents.down('#resultStatusMappedId');

								resultStatusMappedId.setVisible(false);
								$this.setAllowBlank(resultStatusMappedId,true);
								//scoreMethodId.setVisible(false);
								educationOperatorConditionId.setVisible(false);
								$this.setAllowBlank(educationOperatorConditionId,true);
								numberOfOperatorConditionId.setVisible(false);
								$this.setAllowBlank(numberOfOperatorConditionId,true);
								subjectMappedId.setVisible(false);
								$this.setAllowBlank(subjectMappedId,true);
								//$this.setAllowBlank(scoreMethodId,true);

								//scoreMethodId.reset();
								educationOperatorConditionId.reset();
								numberOfOperatorConditionId.reset();
								subjectMappedId.reset();
								resultStatusMappedId.reset();

								pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
							}
						}
					},{
						xtype: 'customcombobox',
						name:'educationExamPassedStatus',
						width:165,
						hidden:true,
						itemId: 'educationExamPassedStatusId',
						store:Ext.create('Academia.store.course.requisite.CourseEducationExamStatusStore'),
						displayField: 'translatedValue',
						valueField: 'value',
						forceSelection:true,
						//margin: '0 0 0 10',
						typeAhead:false,
						editable:false,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						},
						listeners: {
							select:function(combo,record1){
								var pnlAddChildComponents = this.up('#pnlAddChildComponents');
								//var scoreMethodId = pnlAddChildComponents.down('#scoreMethodId');
								var educationOperatorConditionId = pnlAddChildComponents.down('#educationOperatorConditionId');
								var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
								var subjectMappedId = pnlAddChildComponents.down('#subjectMappedId');
								var resultStatusMappedId = pnlAddChildComponents.down('#resultStatusMappedId');
								if(record1[0].data.value=="MARKS_OBTAINED" || record1[0].data.value=="SUBJECT_SCORE" || record1[0].data.value=="GPAPERCENTAGE" ||
										record1[0].data.value=="EQUIVALENT_MARKS_GRADE" || record1[0].data.value=="ASSESSMENT_LEVEL" ||
										record1[0].data.value=="OBTAIN" || record1[0].data.value=="NOT_OBTAIN"){
									//scoreMethodId.setVisible(true);
									//$this.setAllowBlank(scoreMethodId,false);
									resultStatusMappedId.setVisible(false);
									$this.setAllowBlank(resultStatusMappedId,true);
									if(record1[0].data.value!="SUBJECT_SCORE" && record1[0].data.value!="OBTAIN" && record1[0].data.value!="NOT_OBTAIN" &&
											record1[0].data.value!="EQUIVALENT_MARKS_GRADE" && record1[0].data.value!="ASSESSMENT_LEVEL"){
										educationOperatorConditionId.setVisible(true);
										$this.setAllowBlank(educationOperatorConditionId,false);
										subjectMappedId.setVisible(false);
										$this.setAllowBlank(subjectMappedId,true);
										numberOfOperatorConditionId.setVisible(false);
										$this.setAllowBlank(numberOfOperatorConditionId,true);
									}
									else{
										educationOperatorConditionId.setVisible(false);
										$this.setAllowBlank(educationOperatorConditionId,true);
										subjectMappedId.setVisible(true);
										/*subjectMappedId.getStore().getProxy().extraParams = {
											examBoardOther: false,
											id:1
										};
										subjectMappedId.getStore().load();*/
										$this.setAllowBlank(subjectMappedId,false);
										numberOfOperatorConditionId.setVisible(false);
										$this.setAllowBlank(numberOfOperatorConditionId,true);
									}
								}
								else{
									resultStatusMappedId.setVisible(true);
									$this.setAllowBlank(resultStatusMappedId,false);
									//scoreMethodId.setVisible(false);
									educationOperatorConditionId.setVisible(false);
									$this.setAllowBlank(educationOperatorConditionId,true);
									numberOfOperatorConditionId.setVisible(false);
									$this.setAllowBlank(numberOfOperatorConditionId,true);
									subjectMappedId.setVisible(false);
									$this.setAllowBlank(subjectMappedId,true);
									//$this.setAllowBlank(scoreMethodId,true);
								}
								//scoreMethodId.reset();
								educationOperatorConditionId.reset();
								numberOfOperatorConditionId.reset();
								subjectMappedId.reset();
								resultStatusMappedId.reset();

								pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
							}
						}
					},{
						xtype: 'nestedJsonCombo',
						itemId: 'subjectMappedId',
						store: Ext.create('Academia.store.common.SubjectTypeStore'),
						valueField: 'id',
						displayField: 'value',
						hidden:true,
						name: 'subjectMapped',
						editable : false,
						//allowBlank:false,
						hideTrigger:false,
						triggerAction: 'all',
						width:165,
						forceSelection:true,
						listeners: {
							select:function(combo,record){
								var pnlAddChildComponents = this.up('#pnlAddChildComponents');
								var educationOperatorConditionId = pnlAddChildComponents.down('#educationOperatorConditionId');
								educationOperatorConditionId.setVisible(true);
								$this.setAllowBlank(educationOperatorConditionId,false);
								educationOperatorConditionId.reset();
								educationOperatorConditionId.clearValue();
								educationOperatorConditionId.clearInvalid();

								var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
								numberOfOperatorConditionId.setVisible(false);
								numberOfOperatorConditionId.reset();

								pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();

								var currentEducationPnl = combo.up('#educationPanel');
								var educationPanel = this.up('form').down('#educationPanel');
								var flag = true;
								if(educationPanel.length>0){
									educationPanel.forEach(function(obj){
										if(obj.id != currentEducationPnl.id){
											var examPassedVal = obj.down('#examPassed').getValue();
											var subjectVal = obj.down('#subjectMappedId').getValue();
											var currentExamPassedVal = currentEducationPnl.down('#examPassed').getValue();
											var currentSubjectVal = currentEducationPnl.down('#subjectMappedId').getValue();

											if(examPassedVal == currentExamPassedVal && subjectVal == currentSubjectVal){
												flag = false;
												return false;
											}
										}
									});
								}

								if(!flag){
									combo.reset();
									combo.clearInvalid();
									educationOperatorConditionId.setVisible(false);
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SUBJECT_ALREADY_SELECTED_MSG'));
									return false;
								}
							}
						}
					},{
						xtype: 'nestedJsonCombo',
						itemId: 'resultStatusMappedId',
						store:Ext.create('Academia.store.admission.applications.history.ResultStatus'),
						valueField: 'id',
						displayField: 'value',
						hidden:true,
						name: 'resultStatusMapped',
						editable : false,
						hideTrigger:false,
						triggerAction: 'all',
						width:165,
						forceSelection:true
					},{
						xtype: 'customcombobox',
						name:'educationOperatorCondition',
						width:165,
						itemId: 'educationOperatorConditionId',
						store:Ext.create('Academia.store.course.requisite.CourseCGPAConditionStore'),
						displayField: 'name',
						valueField: 'value',
						forceSelection:true,
						//margin: '0 0 0 10',
						hidden:true,
						editable:false,
						typeAhead:false,
						listeners: {
							select:function(combo,record){
								var pnlAddChildComponents = this.up('#pnlAddChildComponents');
								var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
								numberOfOperatorConditionId.setVisible(true);
								$this.setAllowBlank(numberOfOperatorConditionId,false);
								numberOfOperatorConditionId.reset();
								numberOfOperatorConditionId.setValue(null);
								numberOfOperatorConditionId.clearInvalid();
								pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
							}
						},
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype: 'numberfield',
						name: 'numberOfOperatorCondition',
						itemId: 'numberOfOperatorConditionId',
						hidden:true,
						//margin: '0 0 0 10',
						hideTrigger: true,
						width:165,
						mouseWheelEnabled:false,
						maxLength: 6,
						//enforceMaxLength : true,
						minValue:1,
						maxValue:999,
						keyNavEnabled: false,
						allowExponential:false,
						allowDecimals: true,
						decimalPrecision:2,
						//allowBlank:false
					}]
				},{
					xtype:'fieldcontainer',
					layout : 'hbox',
					itemId:'fldMonthValidAndMethod',
					items:[{
						xtype: 'numberfield',
						name: 'monthValid',
						itemId: 'monthValidId',
						//margin: '0 0 0 10',
						fieldLabel : getProgramandcourseTranslation('MONTH_VALID'),
						labelAlign:'top',
						hideTrigger: true,
						mouseWheelEnabled:false,
						maxLength: 6,
						//enforceMaxLength : true,
						minValue:1,
						maxValue:99,
						width:165,
						keyNavEnabled: false,
						allowExponential:false,
						allowDecimals: false,
						//decimalPrecision:2,
						allowBlank:true
					}/*,{
						xtype: 'customcombobox',
						name:'scoreMethod',
						width:165,
						hidden:true,
						itemId: 'scoreMethodId',
						fieldLabel : getProgramandcourseTranslation('SCORE_METHOD'),
						labelAlign:'top',
						store:Ext.create('Academia.store.course.requisite.CourseScoreMethodStore'),
						displayField: 'name',
						valueField: 'value',
						forceSelection:true,
						//margin: '0 0 0 10',
						//allowBlank:false,
						typeAhead:false,
						editable:false,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						},
						listeners: {
							select:function(combo,record){
								var pnlAddChildComponents = this.up('#pnlAddChildComponents');
											var courseChildId = pnlAddChildComponents.down('#courseChildId');
											courseChildId.setVisible(true);
							}
						}
					}*/]
				}]

			});
			var monthValidId = pnlAddChildComponents.down('#monthValidId');
			$this.setAllowBlank(monthValidId,true);
		}
		pnlAddChildComponents.setVisible(true);
	},
	
	checkMandatoryJsonKeysForAdditionalCriteria: function(jsonString){
		var me = this;
		var jsonObj = JSON.parse(jsonString);
		
		var moduleRequisite = jsonObj["MODULE REQUISITE"];
		var moduleCode = jsonObj["MODULE CODE"];
		var modules = jsonObj["MODULES"];
		
		var errorMsg = false;
		
		if(isNullOrEmpty(moduleRequisite)){
			errorMsg = true;
		}
		else if(isNullOrEmpty(moduleCode)){
			errorMsg = true;
		}
		else if(isNullOrEmpty(modules)){
			errorMsg = true;
		}
		else{
			if(modules.length){
				if(!this.validateInnerJson(modules, 0)){
					errorMsg = true;
				}
			}
			else{
				errorMsg = true;
			}
		}
		
		if(errorMsg){
			return false;
		}
		else{
			return true;
		}
	},
	
	validateInnerJson: function(jsonObj, currentLevel) {
		if (Array.isArray(jsonObj)) {
			// Recursively validate each element inside the array
			for (var i = 0; i < jsonObj.length; i += 2) {
				if (!this.validateInnerJson(jsonObj[i], currentLevel + 1)) {
					return false;
				}
			}

			// Check if odd indexes contain "AND" or "OR"
			for (var i = 1; i < jsonObj.length; i += 2) {
				if (i >= jsonObj.length || (jsonObj[i] !== "AND" && jsonObj[i] !== "OR")) {
					return false;
				}
			}
			
			return true;
		} else if (typeof jsonObj === "object") {
			// Check if there is a "MODULE CODE" in the object
			if (!jsonObj.hasOwnProperty("MODULE CODE")) {
				return false;
			}

			// Recursively validate the object's properties
			for (var key in jsonObj) {
				if (!this.validateInnerJson(jsonObj[key], currentLevel + 1)) {
					return false;
				}
			}

			return true;
		}

		return true;
	},
	
	saveCourseRequisiteFormData: function(){
		var $this = this;
		var activeContentPanel = this.getActiveTabfromContentPanel();
		var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
		var courserequisitestructure = this.getCourserequisitestructure();
		var courserequisitefilter = this.getCourserequisitefilter();
		var courserequisiteform = this.getCourserequisiteform();
		
		if(!isNullOrEmpty(batchcourserequisiteform)){
			courserequisitestructure = this.getBatchcourserequisitestructure();
			courserequisitefilter = this.getBatchcourserequisitefilter();
			courserequisiteform = this.getBatchcourserequisiteform();
		}
		var verticalPanel = courserequisiteform.down('panel#verticalPanel');
		var batchId = courserequisiteform.config.batchId;
		var courseIdValue = courserequisitefilter.down("#courseId").getValue();
		var formValues = courserequisiteform.getForm().getValues();
		var additionalCriteriaPreReq=formValues.additionalCriteriaPre;
		var  additionalCriteriaCoReq=formValues.additionalCriteriaCo;
		var preRequisiteId = courserequisiteform.down('#preRequisiteId');
		var mainArry = [];
		
		
		if(!isNullOrEmpty(additionalCriteriaPreReq)){
			if(isValidJson(additionalCriteriaPreReq)){
				//-- Checking Mandatory JSON Keys
				if(!$this.checkMandatoryJsonKeysForAdditionalCriteria(additionalCriteriaPreReq)){
					showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('INVALID_JSON_PRE_REQ'));
					return false;
				}
			}
			else{
				showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('INVALID_JSON_PRE_REQ'));
	            return false;
			}
			
		}
		
		if(!isNullOrEmpty(additionalCriteriaCoReq)){
			if(isValidJson(additionalCriteriaCoReq)){
				//-- Checking Mandatory JSON Keys
				if(!$this.checkMandatoryJsonKeysForAdditionalCriteria(additionalCriteriaCoReq)){
					showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('INVALID_JSON_CO_REQ'));
					return false;
				}
			}
			else{
				showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('INVALID_JSON_CO_REQ'));
	            return false;
			}
		}
		
		//var courseRe = formValues.course;
		//var courseMutually = formValues.courseMutually;
		var courseRe = courserequisiteform.down('#courseId').valueModels;
		var courseMutually = courserequisiteform.down('#courseMutuallyId').valueModels;
		var courseRequisiteId = formValues.courseRequisiteId;
		var courseMutuallyExclusiveId = formValues.courseMutuallyExclusiveId;
		if(!isNullOrEmpty(courseRe)){
			if(courseRe.length > 0 && !isNullOrEmpty(courseRe[0])){
				if(isNullOrEmpty(courseRequisiteId)){
					var courseReArry = [];
					courseRe.forEach(function(obj){
						if(!isNullOrEmpty(obj)){
							if(isNaN(obj)){
								var obj1 = {
										"course" : {
											"id":obj.data.id
										},
								"additionalCriteriaCoReq":additionalCriteriaCoReq
								}
								courseReArry.push(obj1);
							}
							else{
								var obj1 = {
										"course" : {
											"id":obj
										},
									"additionalCriteriaCoReq":additionalCriteriaCoReq
								}
								courseReArry.push(obj1);
							}
						}
					});
					
					if(isNullOrEmpty(batchId)){
						var mainObj = {
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"CO_REQUISITE",
								"courseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
					else{
						var mainObj = {
								"batchId":batchId,
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"CO_REQUISITE",
								"batchCourseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
				}
				else{
					var courseReArry = [];
					courseRe.forEach(function(obj){
						if(!isNullOrEmpty(obj)){
							if(isNaN(obj)){
								var obj1 = {
										"course" : {
											"id":obj.data.id
										},
									"additionalCriteriaCoReq":additionalCriteriaCoReq
								}
								courseReArry.push(obj1);
								
							}else{
								var obj1 = {
										"course" : {
											"id":obj
										}
								}
								courseReArry.push(obj1);
							}
						}
					});
					
					if(isNullOrEmpty(batchId)){
						var mainObj = {
								"id": courseRequisiteId,
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"CO_REQUISITE",
								"courseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
					else{
						var mainObj = {
								"id": courseRequisiteId,
								"batchId":batchId,
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"CO_REQUISITE",
								"batchCourseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
				}
			}
			else if(courseRe.length==0&&!isNullOrEmpty(additionalCriteriaCoReq)&&verticalPanel.items.length==0&&!isNullOrEmpty(additionalCriteriaPreReq))
            {
            showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PLEASE_SELECT_ANY_OF_THE_REQUISITES'));
            return false;
            }
			 else if(verticalPanel.items.length==0&&!isNullOrEmpty(additionalCriteriaPreReq))
            {
            showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PLEASE_SELECT_PRE_REQUISITES'));
            return false;
            }
			 else if(courseRe.length==0&&!isNullOrEmpty(additionalCriteriaCoReq))
            {
            showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PLEASE_SELECT_CO_REQUISITES'));
            return false;
            }
			else if(courseRe.length==0&&verticalPanel.items.length==0&&courseMutually.length==0)
     		{
				showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PLEASE_SELECT_ANY_OF_THE_REQUISITES'));
                return false;
	     	}
			
			else if(courseRe.length==0&&!isNullOrEmpty(additionalCriteriaCoReq))
            {
            showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PLEASE_SELECT_CO_REQUISITES'));
            return false;
            }   
			else if(!isNullOrEmpty(courseRequisiteId)){
				if(isNullOrEmpty(batchId)){
					var mainObj = {
							"id": courseRequisiteId,
							"course" : {
								"id":courseIdValue
							},
							"courseRelation":"CO_REQUISITE",
							"courseRequisiteCriterias":[]
					}
					mainArry.push(mainObj);
				}
				else{
					var mainObj = {
							"id": courseRequisiteId,
							"batchId":batchId,
							"course" : {
								"id":courseIdValue
							},
							"courseRelation":"CO_REQUISITE",
							"batchCourseRequisiteCriterias":[]
					}
					mainArry.push(mainObj);
				}
			}
		}
	
		if(!isNullOrEmpty(courseMutually)){
			if(courseMutually.length > 0 && !isNullOrEmpty(courseMutually[0])){
				if(isNullOrEmpty(courseMutuallyExclusiveId)){

					var courseReArry = [];
					courseMutually.forEach(function(obj){
						if(!isNullOrEmpty(obj)){
							if(isNaN(obj)){
								var obj1 = {
										"course" : {
											"id":obj.data.id
										}
								}
								courseReArry.push(obj1);
							}
							else{
								var obj1 = {
										"course" : {
											"id":obj
										}
								}
								courseReArry.push(obj1);
							}
						}
					});

					if(isNullOrEmpty(batchId)){
						var mainObj = {
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"MUTUALLY_EXCLUSIVE",
								"courseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
					else{
						var mainObj = {
								"batchId":batchId,
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"MUTUALLY_EXCLUSIVE",
								"batchCourseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
				}
				else{
					var courseReArry = [];
					var duplicateCourseCheckArr = [];
					courseMutually.forEach(function(obj){
						var flag1 = true;
						if(!isNullOrEmpty(obj)){
							if(isNaN(obj)){
								duplicateCourseCheckArr.forEach(function(duplicateVal){
									if(duplicateVal==obj.data.id){
										flag1 = false;
									}
								});
								if(flag1==true){
									var obj1 = {
											"course" : {
												"id":obj.data.id
											}
									}
									courseReArry.push(obj1);
									duplicateCourseCheckArr.push(obj.data.id);
								}

							}else{
								duplicateCourseCheckArr.forEach(function(duplicateVal){
									if(duplicateVal==obj){
										flag1 = false;
									}
								});
								if(flag1==true){
									var obj1 = {
											"course" : {
												"id":obj
											}
									}
									courseReArry.push(obj1);
									duplicateCourseCheckArr.push(obj);
								}
							}
						}
					});

					if(isNullOrEmpty(batchId)){
						var mainObj = {
								"id": courseMutuallyExclusiveId,
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"MUTUALLY_EXCLUSIVE",
								"courseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
					else{
						var mainObj = {
								"id": courseMutuallyExclusiveId,
								"batchId":batchId,
								"course" : {
									"id":courseIdValue
								},
								"courseRelation":"MUTUALLY_EXCLUSIVE",
								"batchCourseRequisiteCriterias":courseReArry
						}
						mainArry.push(mainObj);
					}
				}
			}
			else if(!isNullOrEmpty(courseMutuallyExclusiveId)){
				if(isNullOrEmpty(batchId)){
					var mainObj = {
							"id": courseMutuallyExclusiveId,
							"course" : {
								"id":courseIdValue
							},
							"courseRelation":"MUTUALLY_EXCLUSIVE",
							"courseRequisiteCriterias":[]
					}
					mainArry.push(mainObj);
				}
				else{
					var mainObj = {
							"id": courseMutuallyExclusiveId,
							"batchId":batchId,
							"course" : {
								"id":courseIdValue
							},
							"courseRelation":"MUTUALLY_EXCLUSIVE",
							"batchCourseRequisiteCriterias":[]
					}
					mainArry.push(mainObj);
				}
			}
		}
		
	//	var verticalPanel = courserequisiteform.down('panel#verticalPanel');
		var courseRequisiteCriterias = [];
		var commonArry = [];
		var coursePreChildGroup = courserequisiteform.down('#coursePreChildGroupItemId');
		var logicalOperator = '';
		if(verticalPanel.items.length>0){
			logicalOperator = verticalPanel.down("#andOrComponentText").text;
			verticalPanel.items.each(function(item) {
				var childItem = item;
				logicalOperator = childItem.down("#andOrComponentText").text;
				var courseRelationType = childItem.down("#conditionParamId").getValue();
				var courseRelationOperand;
				if(courseRelationType == "COURSE"){
					var courseRelationOperand = childItem.down("#courseStatusId").getValue();
					//var course = childItem.down("#courseChildId").getValue();
					var course = childItem.down("#courseChildId").valueModels;
					if(course.length == 0){
						var course = childItem.down("#gradeMarkCourseChild").valueModels;
					}
					
					if(course.length == 0){
						var course = [childItem.down("#gradeMarkCourseChild").store.getAt(childItem.down("#gradeMarkCourseChild").store.findExact(childItem.down("#gradeMarkCourseChild").displayField,childItem.down("#gradeMarkCourseChild").rawValue))];
					}
					
					if(!isNullOrEmpty(course)){
						if(course.length > 0 && !isNullOrEmpty(course[0])){
							course.forEach(function(obj){
								if(!isNullOrEmpty(obj)){
									if(isNaN(obj)){
										
										try{
											var courseMarksGradesReq = childItem.down('#courseMarksGradesReq').getValue();
											if(courseMarksGradesReq == "MARK"){
												var courseMarksGrades = "M";
											}
											else if(courseMarksGradesReq == "GRADE"){
												var courseMarksGrades = "G";
											}
											else{
												
											}
										}
										catch(e){
											var courseMarksGrades = "";
										}
										
										try{
											var courseGradeType = (!isNullOrEmpty(obj.raw.courseGradeType) ? obj.raw.courseGradeType : "");
										}
										catch(e){
											var courseGradeType = "";
										}
										
										try{
											if(courseMarksGrades == "G"){
												var minimumPassingGradeFieldVal = childItem.down('#minimumPassingGrade').getValue();
												var courseCutOff = '';
												if(minimumPassingGradeFieldVal.length){
													if(typeof minimumPassingGradeFieldVal[0] != "string"){
														var courseCutOff = Ext.Array.pluck(Ext.Array.pluck(minimumPassingGradeFieldVal,'data'),'gradeName').join();
													}
													else{
														var courseCutOff = minimumPassingGradeFieldVal.join();
													}
												}
											}
											else if(courseMarksGrades == "M"){
												var courseCutOff = childItem.down('#minPassingMarks').getValue();
											}
											else{
												var courseCutOff = "";
											}
										}
										catch(e){
											var courseCutOff = "";
										}
										var obj1 = {
												"criteriaType":"SQL",
												"courseRelationType": courseRelationType,
												"courseRelationOperand": courseRelationOperand,
												"courseMarksGrades": courseMarksGrades,
												"courseGradeType": courseGradeType,
												"courseCutOff": courseCutOff,
												"course" : {
													"id":obj.data.id
												}
										}
										commonArry.push(obj1);
									}
									else{
										var obj1 = {
												"criteriaType":"SQL",
												"courseRelationType": courseRelationType,
												"courseRelationOperand": courseRelationOperand,
												"courseMarksGrades": "",
												"courseGradeType": "",
												"courseCutOff": "",
												"course" : {
													"id":obj
												}
										}
										commonArry.push(obj1);
									}
								}
							});
						}
					}
				}
				else if(courseRelationType == "CGPA"){
					var courseRelationOperand = childItem.down("#courseCGPAConditionId").getValue();
					var numberOfCGPAId = childItem.down("#numberOfCGPAId").getValue();
					var obj1 = {
							"criteriaType":"SQL",
							"courseRelationType": courseRelationType,
							"courseRelationOperand": courseRelationOperand,
							"restrictionValue": numberOfCGPAId
					}
					commonArry.push(obj1);
				}
				else if(courseRelationType == "CREDITS"){
					var courseRelationOperand = childItem.down("#courseCumulativeCreditsConditionId").getValue();
					var numberOfCumulativeCreditsId = childItem.down("#numberOfCumulativeCreditsId").getValue();
					var obj1 = {
							"criteriaType":"SQL",
							"courseRelationType": courseRelationType,
							"courseRelationOperand": courseRelationOperand,
							"restrictionValue": numberOfCumulativeCreditsId
					}
					commonArry.push(obj1);
				}
				else if(courseRelationType == "EDUCATION"){
					var examPassed = childItem.down("#examPassed").getValue();
					var educationExamPassedStatusId = childItem.down("#educationExamPassedStatusId").getValue();
					var monthValidId = childItem.down("#monthValidId").getValue();
					var educationOperatorConditionId = childItem.down("#educationOperatorConditionId").getValue();
					//var scoreMethodId = childItem.down("#scoreMethodId").getValue();
					var numberOfOperatorConditionId = childItem.down("#numberOfOperatorConditionId").getValue();
					var subjectMappedId = childItem.down("#subjectMappedId").getValue();
					var resultStatusMappedId = childItem.down("#resultStatusMappedId").getValue();
				
					if(educationExamPassedStatusId == "MARKS_OBTAINED" || educationExamPassedStatusId == "GPAPERCENTAGE"){
						var obj1 = {
								"criteriaType":"SQL",
								"courseRelationType": courseRelationType,
								"examPassed":{
									"id":examPassed
								},
								"educationFields":educationExamPassedStatusId,
								"courseRelationOperand": educationOperatorConditionId,
								"restrictionValue": numberOfOperatorConditionId,
								"monthValid": monthValidId
								//"scoreMethod":scoreMethodId
						}
						commonArry.push(obj1);   
						
					} else if(educationExamPassedStatusId == "SUBJECT_SCORE" || educationExamPassedStatusId == "OBTAIN" || educationExamPassedStatusId == "NOT_OBTAIN" || 
							  educationExamPassedStatusId == "EQUIVALENT_MARKS_GRADE" || educationExamPassedStatusId == "ASSESSMENT_LEVEL"){
						var obj1 = {
								"criteriaType":"SQL",
								"courseRelationType": courseRelationType,
								"examPassed":{
									"id":examPassed
								},
								"educationFields":educationExamPassedStatusId,
								"subject":{
									"id":subjectMappedId
								},
								"courseRelationOperand": educationOperatorConditionId,
								"restrictionValue": numberOfOperatorConditionId,
								"monthValid": monthValidId
								//"scoreMethod":scoreMethodId
						}
						commonArry.push(obj1);
					}
					
					else if(educationExamPassedStatusId == "RESULT_STATUS"){
						var obj1 = {
								"criteriaType":"SQL",
								"courseRelationType": courseRelationType,
								"examPassed":{
									"id":examPassed
								},
								"educationFields":educationExamPassedStatusId,
								"monthValid": monthValidId,
								"resultStatus":{
									"id":resultStatusMappedId
								}
						}

						commonArry.push(obj1);

					}
				}
			});
		}
		
		if(verticalPanel.items.length==0&& !isNullOrEmpty(additionalCriteriaPreReq))
		{
			 showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PLEASE_SELECT_PRE_REQUISITES'));
                return false;
		}
		if(coursePreChildGroup.items.length>0){
			
			coursePreChildGroup.items.each(function(objChild) {
				var verticalPanel = objChild.down('panel#verticalPanel');
				
				var commonArry1 = [];
				if(verticalPanel.items.length>0){
					var logicalOperator1 = verticalPanel.down("#andOrComponentText").text;
					
					if(isNullOrEmpty(logicalOperator)){
						logicalOperator = verticalPanel.up('form').down('#andOrComponentText').text;
					}
					
					verticalPanel.items.each(function(item) {
						var childItem = item;
						logicalOperator1 = childItem.down("#andOrComponentText").text;
						var courseRelationType = childItem.down("#conditionParamId").getValue();
						var courseRelationOperand;
						if(courseRelationType == "COURSE"){
							var courseRelationOperand = childItem.down("#courseStatusId").getValue();
							//var course = childItem.down("#courseChildId").getValue();
							var course = childItem.down("#courseChildId").valueModels;
							if(!isNullOrEmpty(course)){
								
								if(course.length > 0 && !isNullOrEmpty(course[0])){
									course.forEach(function(obj){
										if(!isNullOrEmpty(obj)){
											if(isNaN(obj)){
												var obj1 = {
														"criteriaType":"SQL",
														"courseRelationType": courseRelationType,
														"courseRelationOperand": courseRelationOperand,
														"course" : {
															"id":obj.data.id
														}
												}
												commonArry1.push(obj1);
											}else{
												var obj1 = {
														"criteriaType":"SQL",
														"courseRelationType": courseRelationType,
														"courseRelationOperand": courseRelationOperand,
														"course" : {
															"id":obj
														}
												}
												commonArry1.push(obj1);
											}
										}
									});
								}
							}
						}
						else if(courseRelationType == "CGPA"){
							var courseRelationOperand = childItem.down("#courseCGPAConditionId").getValue();
							var numberOfCGPAId = childItem.down("#numberOfCGPAId").getValue();
							var obj1 = {
									"criteriaType":"SQL",
									"courseRelationType": courseRelationType,
									"courseRelationOperand": courseRelationOperand,
									"restrictionValue": numberOfCGPAId
							}
							commonArry1.push(obj1);
						}
						else if(courseRelationType == "CREDITS"){
							var courseRelationOperand = childItem.down("#courseCumulativeCreditsConditionId").getValue();
							var numberOfCumulativeCreditsId = childItem.down("#numberOfCumulativeCreditsId").getValue();
							var obj1 = {
									"criteriaType":"SQL",
									"courseRelationType": courseRelationType,
									"courseRelationOperand": courseRelationOperand,
									"restrictionValue": numberOfCumulativeCreditsId
							}
							commonArry1.push(obj1);
						}
						else if(courseRelationType == "EDUCATION"){
							var examPassed = childItem.down("#examPassed").getValue();
							var educationExamPassedStatusId = childItem.down("#educationExamPassedStatusId").getValue();
							var monthValidId = childItem.down("#monthValidId").getValue();
							var educationOperatorConditionId = childItem.down("#educationOperatorConditionId").getValue();
							//var scoreMethodId = childItem.down("#scoreMethodId").getValue();
							var numberOfOperatorConditionId = childItem.down("#numberOfOperatorConditionId").getValue();
							var subjectMappedId = childItem.down("#subjectMappedId").getValue();
							var resultStatusMappedId = childItem.down("#resultStatusMappedId").getValue();
						
							if(educationExamPassedStatusId == "MARKS_OBTAINED" || educationExamPassedStatusId == "GPAPERCENTAGE"){
								var obj1 = {
										"criteriaType":"SQL",
										"courseRelationType": courseRelationType,
										"examPassed":{
											"id":examPassed
										},
										"educationFields":educationExamPassedStatusId,
										"courseRelationOperand": educationOperatorConditionId,
										"restrictionValue": numberOfOperatorConditionId,
										"monthValid": monthValidId
										//"scoreMethod":scoreMethodId
								}
								commonArry1.push(obj1);
								
							} else if(educationExamPassedStatusId == "SUBJECT_SCORE" || educationExamPassedStatusId == "OBTAIN" || educationExamPassedStatusId == "NOT_OBTAIN" || 
									  educationExamPassedStatusId == "EQUIVALENT_MARKS_GRADE" || educationExamPassedStatusId == "ASSESSMENT_LEVEL"){
								var obj1 = {
										"criteriaType":"SQL",
										"courseRelationType": courseRelationType,
										"examPassed":{
											"id":examPassed
										},
										"educationFields":educationExamPassedStatusId,
										"subject":{
											"id":subjectMappedId
										},
										"courseRelationOperand": educationOperatorConditionId,
										"restrictionValue": numberOfOperatorConditionId,
										"monthValid": monthValidId
										//"scoreMethod":scoreMethodId
								}
								commonArry1.push(obj1);
							}
							
							else if(educationExamPassedStatusId == "RESULT_STATUS"){
								var obj1 = {
										"criteriaType":"SQL",
										"courseRelationType": courseRelationType,
										"examPassed":{
											"id":examPassed
										},
										"educationFields":educationExamPassedStatusId,
										"monthValid": monthValidId,
										"resultStatus":{
											"id":resultStatusMappedId
										}
								}

								commonArry1.push(obj1);

							}
						}
					});
					
					if(isNullOrEmpty(batchId)){
						var mainObj1 = {
								"criteriaType": "LOGICAL",
								"logicalOperator": logicalOperator1,
								"courseRequisiteCriterias": commonArry1
								
						}
						commonArry.push(mainObj1);
					}
					else{
						var mainObj1 = {
								"criteriaType": "LOGICAL",
								"logicalOperator": logicalOperator1,
								"batchCourseRequisiteCriterias": commonArry1
								
						}
						commonArry.push(mainObj1);
					}
				}
			});
		}
		
		if(commonArry.length>0){
			
			if(isNullOrEmpty(batchId)){
				var mainObj = {
						"criteriaType": "LOGICAL",
						"logicalOperator": logicalOperator,
						"additionalCriteriaPreReq":additionalCriteriaPreReq,
						"courseRequisiteCriterias": commonArry
				}
				courseRequisiteCriterias.push(mainObj);
				
				var finalArryObj = {
						"course": {
							"id": courseIdValue
						},
						"courseRelation": "PRE_REQUISITE",
						"courseRequisiteCriterias":courseRequisiteCriterias
				}
				
				if(!isNullOrEmpty(preRequisiteId)){
					finalArryObj = {
							"id":preRequisiteId.getValue(),
							"course": {
								"id": courseIdValue
								
							},
							"courseRelation": "PRE_REQUISITE",
							"courseRequisiteCriterias":courseRequisiteCriterias
							
					}
				}
				mainArry.push(finalArryObj);
			} else{
				var mainObj = {
						"criteriaType": "LOGICAL",
						"logicalOperator": logicalOperator,
						"additionalCriteriaPreReq":additionalCriteriaPreReq,
						"batchCourseRequisiteCriterias": commonArry
				}
				courseRequisiteCriterias.push(mainObj);
				
				var finalArryObj = {
						"batchId":batchId,
						"course": {
							"id": courseIdValue
						},
						"courseRelation": "PRE_REQUISITE",
						"batchCourseRequisiteCriterias":courseRequisiteCriterias
				}
				
				if(!isNullOrEmpty(preRequisiteId)){
					finalArryObj = {
							"batchId":batchId,
							"id":preRequisiteId.getValue(),
							"course": {
								"id": courseIdValue
							},
							"courseRelation": "PRE_REQUISITE",
							"batchCourseRequisiteCriterias":courseRequisiteCriterias
					}
				}
				mainArry.push(finalArryObj);
			}
			
		}
		else if(!isNullOrEmpty(preRequisiteId.getValue())){
			var finalArryObj = {
					"id":preRequisiteId.getValue(),
					"course": {
						"id": courseIdValue
					},
					"courseRelation": "PRE_REQUISITE",
					"courseRequisiteCriterias":[]
			}
			if(!isNullOrEmpty(batchId)){
				finalArryObj = {
						"id":preRequisiteId.getValue(),
						"batchId":batchId,
						"course": {
							"id": courseIdValue
						},
						"courseRelation": "PRE_REQUISITE",
						"batchCourseRequisiteCriterias":[]
				}
			}
			mainArry.push(finalArryObj);
		}
		
		if(mainArry.length>0){
			var formData = Ext.encode(mainArry);
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			var submitUrl = SERVERURL.COURSE_PREREQUISITE_CREATE_URL;
			if(!isNullOrEmpty(batchId)){
				submitUrl = SERVERURL.PATH_GET_BATCH_COURSE_REQUISITES_SAVEALL;
			}
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: formData,
				method: 'POST',
				success: function(form, action) {
					var resp = form.responseText;
					Ext.getBody().unmask();
					showSuccessMessage(getMegaMenuTranslation('MANAGE_COURSE_REQUISITES'), getCommonTranslation('SUCCESS'));
					if(!isNullOrEmpty(batchId)){
						$this.checkRequisiteFormData(courseIdValue,batchId);
					}else{
						$this.checkRequisiteFormData(courseIdValue,null);
					}
					/*var contentpanel = $this.getContentPanel();
					var tabName = getMegaMenuTranslation('MANAGE_COURSE_REQUISITES');
					var getcontroller = $this.getController('menu.CoreERPNavigationController');
					var getTab = getcontroller.getTab(tabName);
					if (getTab != null) {
						contentPanel.remove(getTab, true);
					}*/
				},
				failure: function(form, action) {
					Ext.getBody().unmask();
					showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
				}
			});
		}
		else{
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ANY_OF_THE_REQUISITES'));
			/*var contentpanel = $this.getContentPanel();
			var tabName = getMegaMenuTranslation('MANAGE_COURSE_REQUISITES');
			var getcontroller = $this.getController('menu.CoreERPNavigationController');
			var getTab = getcontroller.getTab(tabName);
			if (getTab != null) {
				contentPanel.remove(getTab, true);
			}*/
		}
	},
	resetCourseRequisiteForm: function(){
		var $this = this;
		var courserequisiteform = this.getCourserequisiteform();
		var activeContentPanel = this.getActiveTabfromContentPanel();
		var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
		if(!isNullOrEmpty(batchcourserequisiteform)){
			courserequisiteform = this.getBatchcourserequisiteform();
		}
		var verticalPanel = courserequisiteform.down('panel#verticalPanel');
		var coursePreChildGroup = courserequisiteform.down('#coursePreChildGroupItemId');
		//courserequisiteform.getForm().reset();
		var courseRequisiteItemId = courserequisiteform.down('#courseRequisiteItemId');
		var courseMutuallyExclusiveItemId = courserequisiteform.down('#courseMutuallyExclusiveItemId');
		courseRequisiteItemId.setExpanded(false);
		
		courseMutuallyExclusiveItemId.setExpanded(false);
		verticalPanel.items.each(function(obj) {
			if(obj != undefined) {
    			obj.close();	
    		}
		});
		if(coursePreChildGroup.items.length>0){
			coursePreChildGroup.items.each(function(obj) {
				if(obj != undefined) {
	    			obj.close();	
	    		}
			});
		}
		courseMutuallyExclusiveItemId.down('#courseMutuallyId').clearAllDataFn();
		courseRequisiteItemId.down('#courseId').clearAllDataFn();
		
		if(!isNullOrEmpty(courserequisiteform.config.batchId)){
			var hidTxtFld = courserequisiteform.down('#hiddenTextFieldForDisableSaveBtnItemId');
			$this.setAllowBlank(hidTxtFld,false);
			courserequisiteform.getForm().checkValidity();
		}
		var additionalCriteriaPre=courserequisiteform.down('#additionalCriteriaPre');
		var additionalCriteriaCo=courserequisiteform.down('#additionalCriteriaCo');
		additionalCriteriaPre.reset();
		additionalCriteriaCo.reset();
		
	},
	changeLogicalOperandCoursePre: function(formPnl, andOrComponentText) {
    	var $this = this;
    	var searchCriteriaItemContainer = formPnl.down('panel#verticalPanel');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;
    	
    	Ext.each(searchCriteriaItems, function(childItem) {
    		$this.changeLogicalComponentTextCoursePre(andOrComponentText,childItem);
    	});
    	
    },
    
    changeLogicalComponentTextCoursePre: function(logicalOperandText,childItem) {
    	this.andOrComponentValue=logicalOperandText;
    	childItem.down('#andOrComponentText').setText(logicalOperandText);
    },
    checkRequisiteFormData: function(courseIdVal,batchId){
		var $this = this;
		/*var courseForm = this.getCourserequisiteform();
		if(!isNullOrEmpty(batchId)){
			courseForm = this.getBatchcourserequisiteform();
		}*/
		var activeContentPanel = this.getActiveTabfromContentPanel();
		var courseForm = activeContentPanel.down('courserequisiteform');

		var hidTxtFld = courseForm.down('#hiddenTextFieldForDisableSaveBtnItemId');
		$this.setAllowBlank(hidTxtFld,true);
		courseForm.setVisible(true);
		courseForm.config.batchId=batchId;
		var coursePreRequisiteItemId = courseForm.down('#coursePreRequisiteItemId');
		coursePreRequisiteItemId.setExpanded(true);
		var courseMutuallyExclusiveItemId = courseForm.down('#courseMutuallyExclusiveItemId');
		courseMutuallyExclusiveItemId.setExpanded(false);
		var courseRequisiteItemId = courseForm.down('#courseRequisiteItemId');
		courseRequisiteItemId.setExpanded(false);
		var academyLocationId = this.getCurrentAcademyLocation();
		var andOrComponent = courseForm.down('#andOrComponent');
		var courseRequisiteId = courseForm.down('#courseRequisiteId');
		var courseMutuallyExclusiveId = courseForm.down('#courseMutuallyExclusiveId');
		var preRequisiteId = courseForm.down('#preRequisiteId');
	    var additionalCriteriaPreReq=courseForm.down('#additionalCriteriaPre');
		var	additionalCriteriaCoReq=courseForm.down('#additionalCriteriaCo');
		additionalCriteriaPreReq.reset();
		additionalCriteriaCoReq.reset();
		courseRequisiteId.setValue(null);
		courseMutuallyExclusiveId.setValue(null);
		preRequisiteId.setValue(null);
		andOrComponent.setText('All');
		var courseId = courseForm.down('#courseId');
		courseId.lastQuery=null;
		courseId.reset();
		courseId.clearAllDataFn();
		var courseMutuallyId = courseForm.down('#courseMutuallyId');
		courseMutuallyId.lastQuery=null;
		courseMutuallyId.reset();
		courseMutuallyId.clearAllDataFn();
		var courseReqStore = courseId.getStore();
		var courseMutuallyStore = courseMutuallyId.getStore();
		courseReqStore.getProxy().extraParams = {
			courseId: courseIdVal
		};
		courseMutuallyStore.getProxy().extraParams = {
			courseId: courseIdVal
		};
		  
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		var url = SERVERURL.PATH_GET_COURSE_REQUISITE_CRITERIA;
		var param = {
				courseId : courseIdVal
		};
		if(!isNullOrEmpty(batchId)){
			url = SERVERURL.PATH_GET_BATCH_COURSE_REQUISITES_COURSEID; //when user will come from Edit program->batchDetails->related course link
			param = {
					courseId : courseIdVal,
					batchId:batchId
			};
			
			courseReqStore.getProxy().extraParams = {
				courseId: courseIdVal,
				academyLocationId:academyLocationId
			};
			courseMutuallyStore.getProxy().extraParams = {
				courseId: courseIdVal,
				academyLocationId:academyLocationId
			};
		}
    	Ext.Ajax.request({
 		   type : 'rest',
 		   async: false,
 		   url : url,
 		   params : param,
 		   method : 'GET',
 		   success : function(f, action) {
 			   
 			  if(!isNullOrEmpty(f.responseText)){
 				 var res = Ext.JSON.decode(f.responseText);  
 				 if(res.length>0){
 					Ext.each(res, function(data) {
 						var courseRelation = data.courseRelation;
 						if(courseRelation == "CO_REQUISITE"){
 							courseRequisiteId.setValue(data.id);
 							if(!isNullOrEmpty(data.courseRequisiteCriterias) && data.courseRequisiteCriterias.length>0){
 								additionalCriteriaCoReq.setValue(data.courseRequisiteCriterias[0].additionalCriteriaCoReq);
 	 							//var courseIds = data.courseRequisiteCriterias[0].courseIds;
 								var courseIdsArray = [];
 								Ext.each(data.courseRequisiteCriterias, function(courseRequisiteCriteria){
 									courseIdsArray.push(courseRequisiteCriteria.courseIds);
 								});
 	 							var courseIds = courseIdsArray;
 	 				            var courseReqStore = courseId.getStore();
 	 							courseReqStore.getProxy().extraParams = {
 	 								courseId: courseIdVal
 	 							};
 	 							if(!isNullOrEmpty(batchId)){
 	 								courseReqStore.getProxy().extraParams = {
 	 									courseId: courseIdVal,
 	 									academyLocationId:academyLocationId
 	 								};
 	 							}
 	 							courseReqStore.load({
 	 								callback: function(record, operation, success) {
 	 									Ext.getBody().unmask();
 	 									if (success) {
 	 										//courseId.setValue(courseIds);
 	 										if(courseIds.length){
 	 											var courseRecordsArray = [];
 	 											if(courseIds.length == 1){
 	 												var courseIdAr = courseIds[0];
 	 											}
 	 											else if(courseIds.length > 1){
 	 												var courseIdAr = courseIds;
 	 											}
 	 											Ext.each(courseIdAr, function(currentCourseId){
 	 												if(typeof currentCourseId == "object"){
 	 	 												var stRecord = courseReqStore.findExact('id',currentCourseId[0]);
 	 												}
 	 												else{
 	 	 												var stRecord = courseReqStore.findExact('id',currentCourseId);
 	 													
 	 												}
 	 												if(stRecord != -1){
 	 													courseRecordsArray.push(courseReqStore.getAt(stRecord));
 	 												}
 	 											});
 	 											courseId.setValue(courseRecordsArray);
 	 											courseId.setValue(courseRecordsArray);
 	 										}
 	 										courseRequisiteItemId.setExpanded(true);
 	 									}
 	 								}
 	 							});
 	 						}
 						}
 						if(courseRelation == "MUTUALLY_EXCLUSIVE"){
 							courseMutuallyExclusiveId.setValue(data.id);
 							if(!isNullOrEmpty(data.courseRequisiteCriterias) && data.courseRequisiteCriterias.length>0){
 							//	var courseIds = data.courseRequisiteCriterias[0].courseIds;
 								var courseIdsArray = [];
 								Ext.each(data.courseRequisiteCriterias, function(courseRequisiteCriteria){
 									courseIdsArray.push(courseRequisiteCriteria.courseIds);
 								});
 	 							var courseIds = courseIdsArray;
 								var courseMutuallyStore = courseMutuallyId.getStore();
 	 							courseMutuallyStore.getProxy().extraParams = {
 	 								courseId: courseIdVal
 	 							};
 	 							if(!isNullOrEmpty(batchId)){
 	 								courseMutuallyStore.getProxy().extraParams = {
 	 									courseId: courseIdVal,
 	 									academyLocationId:academyLocationId
 	 								};
 	 							}
 	 							courseMutuallyStore.load({
 	 								callback: function(record, operation, success) {
 	 									Ext.getBody().unmask();
 	 									if (success) {
 	 										//courseMutuallyId.setValue(courseIds);
 	 										if(courseIds.length){
 	 											var courseRecordsArray = [];
 	 											if(courseIds.length == 1){
 	 												var courseIdAr = courseIds[0];
 	 											}
 	 											else if(courseIds.length > 1){
 	 												var courseIdAr = courseIds;
 	 											}
 	 											Ext.each(courseIdAr, function(currentCourseId){
 	 												if(typeof currentCourseId == "object"){
 	 	 												var stRecord = courseMutuallyStore.findExact('id',currentCourseId[0]);
 	 												}
 	 												else{
 	 	 												var stRecord = courseMutuallyStore.findExact('id',currentCourseId);
 	 													
 	 												}
 	 												if(stRecord != -1){
 	 													courseRecordsArray.push(courseMutuallyStore.getAt(stRecord));
 	 												}
 	 											});
 	 											courseMutuallyId.setValue(courseRecordsArray);
 	 										}
 	 										courseMutuallyExclusiveItemId.setExpanded(true);
 	 									}
 	 								}
 	 							});
 							}
 						}
 						if(courseRelation == "PRE_REQUISITE"){
 							
 							if(data.courseRequisiteCriterias.length>0){
 								var courseRequisiteCriteriasObj = data.courseRequisiteCriterias[0];
 								var form = courseForm.down('#coursePreGroupItemId');
 								//var form = $this.getCourseprerequisitecriteriaform();
 								var andOrComponentBtn = form.down('button#andOrComponent');
 								var verticalPanel = form.down('panel#verticalPanel');
 								var coursePreChildGroupItemId = courseForm.down('#coursePreChildGroupItemId');
 								verticalPanel.removeAll();
 								coursePreChildGroupItemId.removeAll();
 								if(courseRequisiteCriteriasObj.courseRequisiteCriterias.length>0){
 									preRequisiteId.setValue(data.id);
								    additionalCriteriaPreReq.setValue(courseRequisiteCriteriasObj.additionalCriteriaPreReq);
 									form.config.logicalOperator = courseRequisiteCriteriasObj.logicalOperator;
 									if(form.config.logicalOperator ==  "OR"){
 										andOrComponentBtn.setText(getCommonTranslation('COURSE_PRE_ANY_TEXT'));
 									}
 									
 									Ext.each(courseRequisiteCriteriasObj.courseRequisiteCriterias, function(courseReqData) {
 										if(courseReqData.criteriaType == "LOGICAL"){
 											var logicalOperator = courseReqData.logicalOperator;
 											var courseRequisiteCriterias = courseReqData.courseRequisiteCriterias;
 											var andOrComponentBtnText = getCommonTranslation('ALL');
 											if(logicalOperator == "OR"){
 												andOrComponentBtnText = getCommonTranslation('COURSE_PRE_ANY_TEXT');
 											}
 											
 											coursePreChildGroupItemId.add({
 												xtype:'form',
 												//itemId:"coursePreChildGroupItemId",
 												cls: 'panelNoSpace cbCustomPanel',
 											    paddingLeft:  '0',
 											    marginLeft: '0',
 											    padding: '1 1 1 1',
 											    layout: {
 											        type: 'hbox'
 											    },
 											    style :{
 													marginBottom:'0px'
 												},
 											    cls: 'tbarWithnoSpacing',
 											    ui: 'tbarWithnoSpacing',
 											    tbar: [{
 													xtype: 'text',
 													itemId: 'andOrComponentText',
 													minWidth: '27px',
 													text:form.config.logicalOperator,
 													margin: '7 0 0 0'
 												},{
 											    	xtype: 'button',
 											    	itemId: 'andOrComponent',
 											    	text: andOrComponentBtnText,
 											    	cls: 'CustomBodyBtnSettings',
 											    	enableToggle: true,
 											    	//pressedText: getCommonTranslation('COURSE_PRE_ANY_TEXT'),
 											    	//depressedText: getCommonTranslation('ALL'),
 											    	toggleHandler: function (btn, state) {
 											    		var btnText = this.getText();
 											    		if(btnText == getCommonTranslation('COURSE_PRE_ANY_TEXT')){
 											    			this.setText(getCommonTranslation('ALL'));
 											    			this.up('form').andOrComponentValue = 'AND';
 											    		}else{
 											    			this.setText(getCommonTranslation('COURSE_PRE_ANY_TEXT'));
 											    			this.up('form').andOrComponentValue = 'OR';
 											    		}
 											    		/*if(this.pressed) {
 											    			this.setText(this.pressedText);
 											    			this.up('form').andOrComponentValue = 'OR'; 
 											    		} else {
 											    			this.setText(this.depressedText);
 											    			this.up('form').andOrComponentValue = 'AND';
 											    		}*/
 											    		$this.changeLogicalOperandCoursePre(this.up('form'), this.up('form').andOrComponentValue);
 											    	}
 											    }, {
 											    	xtype: 'label',
 											    	text: getCommonTranslation('PROGRAMCOURSEPREREQUISITEDEFAULTTEXTHALF'),
 											    	style :{
 											    		color:'#000'
 											    	}
 											    },
 											    '->',
 											    {
 											    	xtype: 'button',
 											    	itemId: 'lineButtonPre',
 											    	cls: 'CustomBodyBtnSettings',
 											    	text: getCommonTranslation('ADDBUTTONTEXT'),
 											    	tooltip: getCommonTranslation('ADD'),
 											    	width: 24,
 											    	handler: function(btn) {
 											    		$this.addLineItemsComponent(btn);
 											    	}

 											    },{
 											    	xtype: 'button',
 											    	itemId: 'groupDeleteButton',
 											    	glyph: ICONGLYPH.DELETEGLYPH,
 											    	cls: 'CustomBodyBtnReject',
 											    	tooltip: getCommonTranslation('DELETETOOLTIP'),
 											    	handler: function() {
 											    		var groupContainerPanel= this.up('panel');
 											    		var formPnl = groupContainerPanel.up('courserequisiteform').getForm();
 											    		groupContainerPanel.close();
 											    		formPnl.checkValidity();
 											    	}
 											    }],
 											    items: [{
 											    	xtype: 'text',
 											    	itemId: 'andOrComponentText',
 											    	minWidth: '27px',
 											    	padding: '9 0 0 0'
 											    },{
 											    	xtype: 'form',
 											    	autoScroll: true,
 											    	itemId: 'verticalPanel',
 											    	cls: 'noBorderPane',
 											    	margin: '0 0 0 0',
 											    	padding: '0 0 0 0',
 											    	flex: 1,
 											    	layout: {
 											    		type: 'vbox',
 											    		align: 'stretch'
 											    	}
 											    }]
 											});
 											
 											if(courseRequisiteCriterias.length>0){
 												var verticalPanel = coursePreChildGroupItemId.down('#verticalPanel');
 												var arryItems = coursePreChildGroupItemId.items.items;
 												if(arryItems.length>1){
 													var formPnl = arryItems[arryItems.length-1];
 													verticalPanel = formPnl.down('#verticalPanel')
 												}
 												Ext.each(courseRequisiteCriterias, function(courseReqData) {
 													if(courseReqData.criteriaType == "SQL"){
 														$this.setCommonConditionOnEdit(courseReqData,form,logicalOperator,courseForm,verticalPanel,courseIdVal,batchId);
 													}
 												});
 											}
 										}
 										else if(courseReqData.criteriaType == "SQL"){
 											var courseRelationType = courseReqData.courseRelationType;
 											var verticalPanel = form.down('panel#verticalPanel');
 											var logicalOperator = form.config.logicalOperator;
 											
 											$this.setCommonConditionOnEdit(courseReqData,form,logicalOperator,courseForm,verticalPanel,courseIdVal,batchId);
 										}
 									});
 									Ext.getBody().unmask();
 									courseForm.getForm().checkValidity();
 								}else{
 									Ext.getBody().unmask();
 								}
 							}else{
 								Ext.getBody().unmask();
 							}
 						}
           			 });
 				 }
 				 else{
 					 Ext.getBody().unmask();
 					 courseReqStore.load();
 					 courseMutuallyStore.load();
 				 }
 			  }
 			  else{
 				  Ext.getBody().unmask();
 				  courseReqStore.load();
 				  courseMutuallyStore.load();
 			  }
 		   }
 	   });
    },
    deleteLineItemsComponent: function(me){
    	var $this = this;
    	var pnl = me.up('panel');
    	var parentPnl = pnl.up();
    	var coursePreChildGroupItemId = pnl.up('#coursePreChildGroupItemId');
    	var form = pnl.up('courserequisiteform').getForm();
    	
    	var activeContentPanel = this.getActiveTabfromContentPanel();
		var batchcourserequisiteform = activeContentPanel.down('#batchcourserequisiteformItemId');
		
		var hidTxtFld = form.findField('hiddenTextFieldForDisableSaveBtn');
		$this.setAllowBlank(hidTxtFld,true);
		
    	pnl.close();
    	if(!isNullOrEmpty(coursePreChildGroupItemId)){
    		var verticalPanel = coursePreChildGroupItemId.down('#verticalPanel');
    		if(verticalPanel.items.length == 0){
    			var formPnl = coursePreChildGroupItemId.down('form');
    			formPnl.close();
    		}
    	}
    	var isDisabled = false;
    	if(!isNullOrEmpty(parentPnl) && parentPnl.items.items.length == 0){
    		
    		var hidTxtFld = form.findField('hiddenTextFieldForDisableSaveBtn');
    		if(!isNullOrEmpty(batchcourserequisiteform)){
    			isDisabled = true;
    			var courseId = batchcourserequisiteform.down('#courseId').getValue();
    			var courseMutuallyId = batchcourserequisiteform.down('#courseMutuallyId').getValue();
    			
    			if(!isNullOrEmpty(courseId)){
    				if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
    					isDisabled = false;
    				}else{
    					isDisabled = true;
    				}
    			}
    			if(!isNullOrEmpty(courseMutuallyId)){
    				if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
    					isDisabled = false;
    				}else{
    					isDisabled = true;
    				}
    			}
    			if(isDisabled){
    				$this.setAllowBlank(hidTxtFld,false);
    			}
    		}
    	}
    	form.checkValidity();
    
    },
    setCommonConditionOnEdit: function(courseReqData,form,logicalOperator,courseForm,verticalPanel,courseIdVal,batchId){
    		var $this = this;
			var courseRelationType = courseReqData.courseRelationType;
			if(courseRelationType == "CGPA"){
				verticalPanel.add({
					xtype:'panel',
					layout : 'hbox',
					margin: '10 10 10 10',
					padding: '0 1 0 1',
					items:[{
						xtype: 'text',
						itemId: 'andOrComponentText',
						minWidth: '27px',
						text:logicalOperator,
						margin: '7 0 0 0'
					},{
						xtype: 'button',
						itemId: 'lineDeleteButton',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip:'Delete',
						handler: function() {
							$this.deleteLineItemsComponent(this);
					    	/*var pnl = this.up('panel');
					    	var coursePreChildGroupItemId = pnl.up('#coursePreChildGroupItemId');
					    	var form = pnl.up('courserequisiteform').getForm();
					    	pnl.close();
					    	if(!isNullOrEmpty(coursePreChildGroupItemId)){
					    		var verticalPanel = coursePreChildGroupItemId.down('#verticalPanel');
					    		if(verticalPanel.items.length == 0){
					    			var formPnl = coursePreChildGroupItemId.down('form');
					    			formPnl.close();
					    		}
					    	}
					    	form.checkValidity();*/
					    }
					},{
						xtype: 'customcombobox',
						name:'conditionParam',
						width:165,
						itemId: 'conditionParamId',
						store:Ext.create('Academia.store.course.requisite.CourseConditionParameterStore'),
						displayField: 'name',
						valueField: 'value',
						editable:false,
						value:courseReqData.courseRelationType,
						forceSelection:true,
						allowBlank:false,
						typeAhead:false,
						listeners:{
							select:function(combo,record){
								$this.addConditionParamComponents(combo,record);
							}
						},
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype:'panel',
						itemId:'pnlAddChildComponents',
						layout : 'hbox',
						margin: '0 10 0 10',
						plugins : "formlabelrequired",
						items:[{
							xtype: 'customcombobox',
							name:'courseCGPACondition',
							width:165,
							itemId: 'courseCGPAConditionId',
							store:Ext.create('Academia.store.course.requisite.CourseCGPAConditionStore'),
							displayField: 'name',
							valueField: 'value',
							forceSelection:true,
							editable:false,
							value:courseReqData.courseRelationOperand,
							typeAhead:false,
							allowBlank:false,
							listeners: {
								select:function(combo,record){
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var numberOfCGPAId = pnlAddChildComponents.down('#numberOfCGPAId');
									numberOfCGPAId.setVisible(true);
									numberOfCGPAId.reset();
									$this.setAllowBlank(numberOfCGPAId,false);
									pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
								}
							},
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
							}
						},{
							xtype: 'numberfield',
							name: 'numberOfCGPA',
							itemId: 'numberOfCGPAId',
							margin: '0 0 0 10',
							hideTrigger: true,
							value:courseReqData.restrictionValue,
							mouseWheelEnabled:false,
							maxLength: 5,
							//enforceMaxLength : true,
							minValue:1,
							width:165,
							maxValue:10,
							keyNavEnabled: false,
							allowDecimals: true,
							allowExponential:false,
							allowBlank:false,
							decimalPrecision:2
						}]
					}]
				});
			}
			else if(courseRelationType == "CREDITS"){
				verticalPanel.add({
					xtype:'panel',
					layout : 'hbox',
					margin: '10 10 10 10',
					padding: '0 1 0 1',
					items:[{
						xtype: 'text',
						itemId: 'andOrComponentText',
						minWidth: '27px',
						text:logicalOperator,
						margin: '7 0 0 0'
					},{
						xtype: 'button',
						itemId: 'lineDeleteButton',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip:'Delete',
						handler: function() {
							$this.deleteLineItemsComponent(this);
					    	/*var pnl = this.up('panel');
					    	var coursePreChildGroupItemId = pnl.up('#coursePreChildGroupItemId');
					    	var form = pnl.up('courserequisiteform').getForm();
					    	pnl.close();
					    	if(!isNullOrEmpty(coursePreChildGroupItemId)){
					    		var verticalPanel = coursePreChildGroupItemId.down('#verticalPanel');
					    		if(verticalPanel.items.length == 0){
					    			var formPnl = coursePreChildGroupItemId.down('form');
					    			formPnl.close();
					    		}
					    	}
					    	form.checkValidity();*/
					    }
					},{
						xtype: 'customcombobox',
						name:'conditionParam',
						width:165,
						itemId: 'conditionParamId',
						store:Ext.create('Academia.store.course.requisite.CourseConditionParameterStore'),
						displayField: 'name',
						valueField: 'value',
						editable:false,
						value:courseReqData.courseRelationType,
						forceSelection:true,
						allowBlank:false,
						typeAhead:false,
						listeners:{
							select:function(combo,record){
								$this.addConditionParamComponents(combo,record);
							}
						},
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype:'panel',
						itemId:'pnlAddChildComponents',
						layout : 'hbox',
						margin: '0 10 0 10',
						plugins : "formlabelrequired",
						items:[{
							xtype: 'customcombobox',
							name:'courseCumulativeCreditsCondition',
							width:165,
							itemId: 'courseCumulativeCreditsConditionId',
							store:Ext.create('Academia.store.course.requisite.CourseCGPAConditionStore'),
							displayField: 'name',
							valueField: 'value',
							forceSelection:true,
							value:courseReqData.courseRelationOperand,
							editable:false,
							typeAhead:false,
							allowBlank:false,
							listeners: {
								select:function(combo,record){
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var numberOfCGPAId = pnlAddChildComponents.down('#numberOfCumulativeCreditsId');
									numberOfCGPAId.setVisible(true);
									numberOfCGPAId.reset();
									$this.setAllowBlank(numberOfCGPAId,false);
									pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
								}
							},
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
							}
						},{
							xtype: 'numberfield',
							name: 'numberOfCumulativeCredits',
							itemId: 'numberOfCumulativeCreditsId',
							margin: '0 0 0 10',
							hideTrigger: true,
							mouseWheelEnabled:false,
							maxLength: 6,
							//enforceMaxLength : true,
							minValue:1,
							value:courseReqData.restrictionValue,
							maxValue:999,
							keyNavEnabled: false,
							width:165,
							allowExponential:false,
							allowDecimals: true,
							decimalPrecision:2,
							allowBlank:false
						}]
					}]
				});
			}
			else if(courseRelationType == "COURSE"){
				verticalPanel.add({
					xtype:'panel',
					layout : 'hbox',
					margin: '10 10 10 10',
					padding: '0 1 0 1',
					items:[{
						xtype: 'text',
						itemId: 'andOrComponentText',
						minWidth: '27px',
						text:logicalOperator,
						margin: '7 0 0 0'
					},{
						xtype: 'button',
						itemId: 'lineDeleteButton',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip:'Delete',
						handler: function() {
							$this.deleteLineItemsComponent(this);
					    	/*var pnl = this.up('panel');
					    	var coursePreChildGroupItemId = pnl.up('#coursePreChildGroupItemId');
					    	var form = pnl.up('courserequisiteform').getForm();
					    	pnl.close();
					    	if(!isNullOrEmpty(coursePreChildGroupItemId)){
					    		var verticalPanel = coursePreChildGroupItemId.down('#verticalPanel');
					    		if(verticalPanel.items.length == 0){
					    			var formPnl = coursePreChildGroupItemId.down('form');
					    			formPnl.close();
					    		}
					    	}
					    	form.checkValidity();*/
					    }
					},{
						xtype: 'customcombobox',
						name:'conditionParam',
						width:165,
						itemId: 'conditionParamId',
						store:Ext.create('Academia.store.course.requisite.CourseConditionParameterStore'),
						displayField: 'name',
						valueField: 'value',
						editable:false,
						value:courseReqData.courseRelationType,
						forceSelection:true,
						allowBlank:false,
						typeAhead:false,
						listeners:{
							select:function(combo,record){
								$this.addConditionParamComponents(combo,record);
							}
						},
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype:'panel',
						itemId:'pnlAddChildComponents',
						layout : 'hbox',
						margin: '0 10 0 10',
						plugins : "formlabelrequired",
						items:[{
							xtype: 'customcombobox',
							name:'courseStatus',
							width:165,
							itemId: 'courseStatusId',
							store:Ext.create('Academia.store.course.requisite.CourseStatusStore'),
							displayField: 'name',
							valueField: 'value',
							value:courseReqData.courseRelationOperand,
							forceSelection:true,
							allowBlank:false,
							typeAhead:false,
							editable:false,
							/*listeners:{
								select:function(combo,record){
									$this.addConditionParamComponents(combo,record);
								}
							},*/
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
							},
							listeners: {
								select:function(combo,record){
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var courseChildId = pnlAddChildComponents.down('#courseChildId');
									var courseMarksGradesReq = pnlAddChildComponents.down('#courseMarksGradesReq');
									var gradeMarkCourseChild = pnlAddChildComponents.down('#gradeMarkCourseChild');
									
									var minPassingMarks = pnlAddChildComponents.down('#minPassingMarks');
									var gradeType = pnlAddChildComponents.down('#gradeType');
									var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
									
									minPassingMarks.setVisible(false);
									gradeType.setVisible(false);
									minimumPassingGrade.setVisible(false);
									
									var filterForm = $this.getCourserequisitefilter();
									if(isNullOrEmpty(filterForm)){
										filterForm = $this.getBatchcourserequisitefilter()
									}
									var courseIdFilter = filterForm.down('#courseId');
									var courseIdVal = courseIdFilter.getValue();
									
									if(combo.getValue() == "QUALIFYING_MARKS_GRADE"){
										courseMarksGradesReq.setVisible(true);
										gradeMarkCourseChild.setVisible(true);
										courseChildId.setVisible(false);
										
										courseMarksGradesReq.reset();
										gradeMarkCourseChild.reset();
										courseChildId.reset();
										
										courseChildId.clearAllDataFn();
										$this.setAllowBlank(courseChildId,true);
										$this.setAllowBlank(gradeMarkCourseChild,false);
										courseMarksGradesReq.store.load({
											callback: function(){
												courseMarksGradesReq.reset();
												courseMarksGradesReq.setValue('GRADE');
											}
										});
									}
									else{
										courseMarksGradesReq.setVisible(false);
										gradeMarkCourseChild.setVisible(false);
										courseChildId.setVisible(true);
										
										courseMarksGradesReq.reset();
										gradeMarkCourseChild.reset();
										courseChildId.reset();
										
										courseChildId.clearAllDataFn();
										$this.setAllowBlank(courseChildId,false);
										$this.setAllowBlank(gradeMarkCourseChild,true);
										
										var courseChildIdStore = courseChildId.getStore();
										courseChildIdStore.getProxy().extraParams = {
											courseId: courseIdVal
										};
										if(!isNullOrEmpty(batchId)){
											courseChildIdStore.getProxy().extraParams = {
												courseId: courseIdVal,
												academyLocationId:academyLocationId
											};
										}
										courseChildIdStore.load();
										pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
									}
								},
								afterrender: function(combo){
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var courseChildId = pnlAddChildComponents.down('#courseChildId');
									var courseMarksGradesReq = pnlAddChildComponents.down('#courseMarksGradesReq');
									var gradeMarkCourseChild = pnlAddChildComponents.down('#gradeMarkCourseChild');
									
									var minPassingMarks = pnlAddChildComponents.down('#minPassingMarks');
									var gradeType = pnlAddChildComponents.down('#gradeType');
									var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
									
									minPassingMarks.setVisible(false);
									gradeType.setVisible(false);
									minimumPassingGrade.setVisible(false);
									
									var filterForm = $this.getCourserequisitefilter();
									if(isNullOrEmpty(filterForm)){
										filterForm = $this.getBatchcourserequisitefilter()
									}
									var courseIdFilter = filterForm.down('#courseId');
									var courseIdVal = courseIdFilter.getValue();
									
									if(combo.getValue() == "QUALIFYING_MARKS_GRADE"){
										courseMarksGradesReq.setVisible(true);
										gradeMarkCourseChild.setVisible(true);
										courseChildId.setVisible(false);
										
										$this.setAllowBlank(gradeMarkCourseChild,false);
										$this.setAllowBlank(courseChildId,true);
									}
									else{
										courseMarksGradesReq.setVisible(false);
										gradeMarkCourseChild.setVisible(false);
										courseChildId.setVisible(true);
										
										$this.setAllowBlank(gradeMarkCourseChild,true);
										$this.setAllowBlank(courseChildId,false);
									}
								}
							}
						},{
							xtype : 'customcombobox',
							name : 'courseMarkGradeReq',
							itemId:'courseMarksGradesReq',
							fieldLabel : false,	
							store:Ext.create('Academia.store.course.CourseMarkGradeStore'),
							valueField : 'id',
							displayField : 'value',
							triggerAction : 'all',
							editable : false,
							allowBlank : true,
							hidden: true,
							margin: '0 0 0 10',
							width: 100,
							listeners:{
								change: function(combo){
									
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var gradeMarkCourseChild = pnlAddChildComponents.down('#gradeMarkCourseChild');
									var minPassingMarks = pnlAddChildComponents.down('#minPassingMarks');
									var gradeType = pnlAddChildComponents.down('#gradeType');
									var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');

									var filterForm = $this.getCourserequisitefilter();
									if(isNullOrEmpty(filterForm)){
										filterForm = $this.getBatchcourserequisitefilter()
									}
									var courseIdFilter = filterForm.down('#courseId');
									var courseIdVal = courseIdFilter.getValue();
									
									var markGrade = combo.getValue();
									
									if(markGrade == "MARK"){
										minPassingMarks.setVisible(true);
										minPassingMarks.reset();
										$this.setAllowBlank(minPassingMarks,false);
										
										gradeType.setVisible(false);
										gradeType.reset();
										gradeType.getStore().removeAll();
										$this.setAllowBlank(gradeType,true);
										
										minimumPassingGrade.setVisible(false);
										minimumPassingGrade.reset();
										minimumPassingGrade.getStore().removeAll();
										$this.setAllowBlank(minimumPassingGrade,true);
										var markGradVal = "M";
									}
									else if(markGrade == "GRADE"){
										minPassingMarks.setVisible(false);
										minPassingMarks.reset();
										$this.setAllowBlank(minPassingMarks,true);
										
										gradeType.setVisible(true);
										gradeType.reset();
										gradeType.getStore().removeAll();
										$this.setAllowBlank(gradeType,false);
										
										minimumPassingGrade.setVisible(true);
										minimumPassingGrade.reset();
										minimumPassingGrade.getStore().removeAll();
										$this.setAllowBlank(minimumPassingGrade,false);
										var markGradVal = "G";
									}
									
									var departmentFilter = filterForm.down('#courseDepartmentId');
									var departmentIdVal = departmentFilter.getValue();
									//courseName
									
									gradeMarkCourseChild.reset();
									var courseChildIdStore = gradeMarkCourseChild.getStore();
									courseChildIdStore.getProxy().extraParams = {
										courseId: courseIdVal,
										courseMarksGrades: markGradVal,
										departmentId: departmentIdVal
									};
									if(!isNullOrEmpty(batchId)){
										courseChildIdStore.getProxy().extraParams = {
											courseId: courseIdVal,
											academyLocationId:academyLocationId,
											courseMarksGrades: markGradVal,
											departmentId: departmentIdVal
										};
									}
									courseChildIdStore.load({
										callback: function(){
											if(courseReqData && !isNullOrEmpty(courseReqData.courseMarksGrades)){
												if(courseReqData.courseMarksGrades == "G"){
													gradeMarkCourseChild.setValue(courseReqData.courseIds[0]);
												}
												else{
													gradeMarkCourseChild.setValue(courseReqData.courseIds[0]);
												}
												courseForm.getForm().checkValidity();
											}
										}
									});
									pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
								},
								afterrender: function(combo){
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var gradeMarkCourseChild = pnlAddChildComponents.down('#gradeMarkCourseChild');
									var courseChild = pnlAddChildComponents.down('#courseChildId');
									
									if(courseReqData && !isNullOrEmpty(courseReqData.courseMarksGrades)){
										combo.getStore().load({
											callback: function(){
												if(courseReqData.courseMarksGrades == "G"){
													combo.setValue("GRADE");
												}
												else{
													combo.setValue("MARK");
												}

												//setTimeout(function(){
														
													courseChild.setVisible(false);
													courseChild.reset();
													courseChild.clearAllDataFn();
												//},500);
											}
										});
									}
									else{
										courseChild.setVisible(true);
										gradeMarkCourseChild.setVisible(false);
										gradeMarkCourseChild.reset();
									}
								}
							}
						},{
							xtype : 'customcombobox',
							name : 'gradeMarkCourseChild',
							itemId:'gradeMarkCourseChild',
							fieldLabel : false,	
							store:Ext.create('Academia.store.course.ALMarkGradeChildCourseStore'),
							displayField : 'valueCode',
							valueField : 'id',
							triggerAction : 'all',
							editable : false,
							allowBlank : true,
							hidden: true,
							margin: '0 0 0 10',
							width: 460,
							listeners: {
								change: function(field){
									var courseId = courseForm.down('#courseId').getValue();
									var coursePreGroupItemId = courseForm.down('#coursePreGroupItemId');
									var coursePreChildGroupItemId = courseForm.down('#coursePreChildGroupItemId');
									var courseMutuallyId = courseForm.down('#courseMutuallyId').getValue();
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var gradeType = pnlAddChildComponents.down('#gradeType');
									
									var diffVal;
									var flag = true;
									
									var oldValue = [];
									if(!isNullOrEmpty(field.getValue())){
										var newValue = [field.getValue()];
									}
									else{
										var newValue = [];
									}
									
									if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
										diffVal = Ext.Array.difference(newValue,oldValue);
									}
									else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
										diffVal = newValue;
									}
									
									if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
										if(!isNullOrEmpty(courseId)){
											if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
												courseId.forEach(function(obj){
													if(!isNullOrEmpty(obj)){
														if(isNaN(obj)){
															if(obj.data.id  == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
														else{
															if(obj == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
													}
												});
											}
										}
										if(!isNullOrEmpty(courseMutuallyId)){
											if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
												courseMutuallyId.forEach(function(obj){
													if(!isNullOrEmpty(obj)){
														if(isNaN(obj)){
															if(obj.data.id  == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
														else{
															if(obj == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
													}
												});
											}
										}
										var courseCombos = this.up('form').down('#courseChildId');
										if(courseCombos.length>0){
											courseCombos.forEach(function(obj){
												if(obj.id != field.id){
													var valueModels = obj.valueModels;
													if(!isNullOrEmpty(valueModels)){
														var indx = valueModels.filter(function (obj) {
															  return obj.data.id === diffVal[0];
															})[0];
														
														if(!isNullOrEmpty(indx)){
								    						flag = false;
								    						return false;
								    					}
													}
												}
											});
										}
										
										var courseNewCombos = this.up('form').down('#gradeMarkCourseChild');
										if(courseNewCombos.length>0){
											courseNewCombos.forEach(function(obj){
												if(obj.id != field.id){
													var valueModels = obj.valueModels;
													if(!isNullOrEmpty(valueModels)){
														var indx = valueModels.filter(function (obj) {
															  return obj.data.id === diffVal[0];
															})[0];
														
														if(!isNullOrEmpty(indx)){
								    						flag = false;
								    						return false;
								    					}
													}
												}
											});
										}
					    				
					    				if(!flag){
					    					field.reset();
					    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
					    						field.setValue(oldValue);
					    					}
					    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
					    					return false;
					    				}
					    				else{
					    					var courseGradeType = field.findRecord(field.valueField,field.getValue()).raw.courseGradeType;
					    					
					    					gradeType.getStore().loadData([{
					    						gradeType: courseGradeType
					    					}]);
					    					setTimeout(function(){
						    					gradeType.setValue(courseGradeType);
						    					
						    					var gradeTypeVal = gradeType.getValue();
												var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
												var minPassingMarks = pnlAddChildComponents.down('#minPassingMarks');
												
												minPassingMarks.reset();
												minimumPassingGrade.reset();
												
												if(!isNullOrEmpty(gradeTypeVal)){
													Ext.Ajax.request({
												 		   type : 'rest',
												 		   async: false,
												 		   url : SERVERURL.EVALUATION_FORM_ONE_GRADES_COMBO_URL,
												 		   params : {
												 			  gradeType: gradeTypeVal
												 		   },
												 		   method : 'GET',
												 		   success : function(f, action) {
												 			  if(!isNullOrEmpty(f.responseText)){
												 				 var res = Ext.JSON.decode(f.responseText);  
												 				 if(res.length>0){
												 					 minimumPassingGrade.store.loadData(res);
												 					 
												 					if(courseReqData && !isNullOrEmpty(courseReqData.courseMarksGrades) && !isNullOrEmpty(courseReqData.courseCutOff)){
												 						if(courseReqData.courseMarksGrades == "M"){
												 							minPassingMarks.setValue(courseReqData.courseCutOff);
												 						}
												 						else{
												 							minimumPassingGrade.setValue(courseReqData.courseCutOff.split(","));
												 						}
												 						
												 					}
												 				 }
												 			  }
												 		   }
													});
												}
												else{
													try{
														if(courseReqData && !isNullOrEmpty(courseReqData.courseMarksGrades) && !isNullOrEmpty(courseReqData.courseCutOff)){
									 						if(courseReqData.courseMarksGrades == "M"){
									 							minPassingMarks.setValue(courseReqData.courseCutOff);
									 						}
														}
													}
													catch(e){
														
													}
												}
						    					
					    					},300);
					    				}
									}
									
								}
							}
						},{
							xtype: 'multiselectcombofield',
							name: 'courseChild',
							itemId: 'courseChildId',
							autoloadStore: false,
							width: 460,
							store:Ext.create('Academia.store.course.UserAccessibleALChildCourseStore'),
							displayField : 'valueCode',
							valueField : 'id',
							queryParam:'courseName',
							margin: '0 0 0 10',
							minChars:3,
							typeAhead:true,
							triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
							queryMode:'remote',
							enableKeyEvents  : 'true',
							hideTrigger:false,
							forceSelection:true,
							allowBlank:false,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
										picker.width = picker.up('combobox').getSize().width;
									},
									afterRender: function(combo){
										combo.getStore().on("load", function(store, items){
											if(items.length==0)
												Ext.select('.x-boundlist-item').elements[0].hidden = true;
											else
												Ext.select('.x-boundlist-item').elements[0].hidden = false;
										});
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}' +
									'</div>';
								}
							},
							listeners: {
								render: function(combo){
									combo.getStore().getProxy().setExtraParam('courseId', courseIdVal);
									if(!isNullOrEmpty(batchId)){
										combo.getStore().getProxy().setExtraParam('courseId', courseIdVal);
										combo.getStore().getProxy().setExtraParam('academyLocationId', academyLocationId);
									}
									combo.getStore().load({
										callback: function(record, operation, success) {
											if (success) {
												if(!isNullOrEmpty(courseReqData) && !isNullOrEmpty(courseReqData.courseIds) && !isNullOrEmpty(courseReqData.courseRelationOperand) && courseReqData.courseRelationOperand != "QUALIFYING_MARKS_GRADE"){
													combo.setValue(courseReqData.courseIds);
													courseForm.getForm().checkValidity();
												}
											}
										}
									});
								},
								change: function(field, newValue, oldValue, eOpts){
									var $this = this;
									var courseId = courseForm.down('#courseId').getValue();
									var coursePreGroupItemId = courseForm.down('#coursePreGroupItemId');
									var coursePreChildGroupItemId = courseForm.down('#coursePreChildGroupItemId');
									
									var courseId = courseForm.down('#courseId').getValue();
									var courseMutuallyId = courseForm.down('#courseMutuallyId').getValue();
									var diffVal;
									var flag = true;
									if(!isNullOrEmpty(oldValue) && !isNullOrEmpty(newValue) && newValue.length>0 && oldValue.length>0){
										diffVal = Ext.Array.difference(newValue,oldValue);
									}
									else if(!isNullOrEmpty(newValue) && newValue.length>0 && (isNullOrEmpty(oldValue) || oldValue.length==0) ){
										diffVal = newValue;
									}
									
									if(!isNullOrEmpty(diffVal) && diffVal.length > 0 && !isNullOrEmpty(diffVal[0])){
										if(!isNullOrEmpty(courseId)){
											if(courseId.length > 0 && !isNullOrEmpty(courseId[0])){
												courseId.forEach(function(obj){
													if(!isNullOrEmpty(obj)){
														if(isNaN(obj)){
															if(obj.data.id  == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
														else{
															if(obj == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
													}
												});
											}
										}
										if(!isNullOrEmpty(courseMutuallyId)){
											if(courseMutuallyId.length > 0 && !isNullOrEmpty(courseMutuallyId[0])){
												courseMutuallyId.forEach(function(obj){
													if(!isNullOrEmpty(obj)){
														if(isNaN(obj)){
															if(obj.data.id  == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
														else{
															if(obj == diffVal[0]){
									    						flag = false;
									    						return false;
									    					}
														}
													}
												});
											}
										}
										var courseCombos = this.up('form').down('#courseChildId');
										if(courseCombos.length>0){
											courseCombos.forEach(function(obj){
												if(obj.id != field.id){
													var valueModels = obj.valueModels;
													if(!isNullOrEmpty(valueModels)){
														var indx = valueModels.filter(function (obj) {
															  return obj.data.id === diffVal[0];
															})[0];
														
														if(!isNullOrEmpty(indx)){
								    						flag = false;
								    						return false;
								    					}
													}
												}
											});
										}
										
										var courseNewCombos = this.up('form').down('#gradeMarkCourseChild');
										if(courseNewCombos.length>0){
											courseNewCombos.forEach(function(obj){
												if(obj.id != field.id){
													var valueModels = obj.valueModels;
													if(!isNullOrEmpty(valueModels)){
														var indx = valueModels.filter(function (obj) {
															  return obj.data.id === diffVal[0];
															})[0];
														
														if(!isNullOrEmpty(indx)){
								    						flag = false;
								    						return false;
								    					}
													}
												}
											});
										}
					    				
					    				if(!flag){
					    					field.reset();
					    					field.clearAllDataFn();
					    					if(!isNullOrEmpty(oldValue) && oldValue.length>0){
					    						field.setValue(oldValue);
					    					}
					    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
					    					return false;
					    				}
									}
								}
							}
						},{
							xtype: 'numberfield',
							name: 'minPassingMarks',
							itemId: 'minPassingMarks',
							fieldLabel : false,
							hideTrigger: true,
							mouseWheelEnabled:false,
							maxLength: 6,
							minValue:1,
							maxValue:100,
							width:100,
							keyNavEnabled: false,
							allowExponential:false,
							allowDecimals: false,
							margin: '0 0 0 10',
							hidden: true
						},{
							xtype : 'customcombobox',
							name : 'gradeType',
							itemId:'gradeType',
							fieldLabel : false,	
							readOnly: true,
							store:Ext.create('Ext.data.Store', {
							    fields:['gradeType'],
							    data:[]
							}),
							valueField : 'gradeType',
							displayField : 'gradeType',
							triggerAction : 'all',
							editable : false,
							allowBlank : true,
							hidden: true,
							margin: '0 0 0 10',
							width: 100,
							queryMode: 'local',
							listeners:{
								change: function(combo){
									var gradeTypeVal = combo.getValue();
									
									var pnlAddChildComponents = this.up('#pnlAddChildComponents');
									var minimumPassingGrade = pnlAddChildComponents.down('#minimumPassingGrade');
									
									minimumPassingGrade.reset();
									
									if(!isNullOrEmpty(gradeTypeVal)){
										
										Ext.Ajax.request({
									 		   type : 'rest',
									 		   async: false,
									 		   url : SERVERURL.EVALUATION_FORM_ONE_GRADES_COMBO_URL,
									 		   params : {
									 			  gradeType: gradeTypeVal
									 		   },
									 		   method : 'GET',
									 		   success : function(f, action) {
									 			  if(!isNullOrEmpty(f.responseText)){
									 				 var res = Ext.JSON.decode(f.responseText);  
									 				 if(res.length>0){
									 					 minimumPassingGrade.store.loadData(res);
									 				 }
									 			  }
									 		   }
										});
									}
								}
							}
						},{
							xtype: 'multiselectcombofield',
							name: 'minimumPassingGrade',
							itemId: 'minimumPassingGrade',
							autoloadStore: false,
							store:Ext.create('Ext.data.Store', {
							    fields:['id','gradeName','gradePoint','gradeRangeFrom','gradeRangeTo','gradeStatus','gradeType','isContributeInTheSgpaCgpa','isContributeInTheTotalCredits'],
							    data:[]
							}),
							displayField : 'gradeName',
							valueField : 'gradeName',
							margin: '0 0 0 10',
							typeAhead:false,
							enableKeyEvents  : 'true',
							hideTrigger:false,
							forceSelection:true,
							hidden: true,
							queryMode: 'local',
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
										picker.width = picker.up('combobox').getSize().width;
									},
									afterRender: function(combo){
										combo.getStore().on("load", function(store, items){
											if(items.length==0)
												Ext.select('.x-boundlist-item').elements[0].hidden = true;
											else
												Ext.select('.x-boundlist-item').elements[0].hidden = false;
										});
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}' +
									'</div>';
								}
							},
							width: 100
						}]
					}]
				});
			}
			else if(courseRelationType == "EDUCATION"){
				verticalPanel.add({
					xtype:'panel',
					layout : 'hbox',
					margin: '10 10 10 10',
					padding: '0 1 0 1',
					items:[{
						xtype: 'text',
						itemId: 'andOrComponentText',
						minWidth: '27px',
						text:logicalOperator,
						margin: '7 0 0 0'
					},{
						xtype: 'button',
						itemId: 'lineDeleteButton',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip:'Delete',
						handler: function() {
							$this.deleteLineItemsComponent(this);
					    	/*var pnl = this.up('panel');
					    	var coursePreChildGroupItemId = pnl.up('#coursePreChildGroupItemId');
					    	var form = pnl.up('courserequisiteform').getForm();
					    	pnl.close();
					    	if(!isNullOrEmpty(coursePreChildGroupItemId)){
					    		var verticalPanel = coursePreChildGroupItemId.down('#verticalPanel');
					    		if(verticalPanel.items.length == 0){
					    			var formPnl = coursePreChildGroupItemId.down('form');
					    			formPnl.close();
					    		}
					    	}
					    	form.checkValidity();*/
					    }
					},{
						xtype: 'customcombobox',
						name:'conditionParam',
						width:165,
						itemId: 'conditionParamId',
						store:Ext.create('Academia.store.course.requisite.CourseConditionParameterStore'),
						displayField: 'name',
						valueField: 'value',
						editable:false,
						value:courseReqData.courseRelationType,
						forceSelection:true,
						allowBlank:false,
						typeAhead:false,
						listeners:{
							select:function(combo,record){
								$this.addConditionParamComponents(combo,record);
							}
						},
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype:'panel',
						itemId:'pnlAddChildComponents',
						layout : 'hbox',
						margin: '0 10 0 10',
						plugins : "formlabelrequired",
						items:[{
							xtype:'panel',
							layout : 'vbox',
							itemId:'educationPanel',
							margin: '0 0 0 0',
							padding: '0 0 0 0',
							items:[{
								xtype:'fieldcontainer',
								layout : 'hbox',
								items:[{
									xtype: 'nestedJsonCombo',
									itemId: 'examPassed',
									store: 'common.ExamPassedStore',
									valueField: 'id',
									displayField: 'value',
									name: 'examPassed',
									editable : false,
									allowBlank:false,
									hideTrigger:false,
									triggerAction: 'all',
									width:165,
									forceSelection:true,
									listeners: {
										render: function(combo){
											combo.getStore().load({
												callback: function(record, operation, success) {
													if (success) {
														if(!isNullOrEmpty(courseReqData.examPassed)){
															combo.setValue(courseReqData.examPassed.id);
														}
													}
												}
											});
										},
										select:function(combo,record){
											var pnlAddChildComponents = this.up('#pnlAddChildComponents');
											var educationExamPassedStatusId = pnlAddChildComponents.down('#educationExamPassedStatusId');
											educationExamPassedStatusId.setVisible(true);
											educationExamPassedStatusId.reset();
											$this.setAllowBlank(educationExamPassedStatusId,false);
											
											educationExamPassedStatusId.clearValue();
											educationExamPassedStatusId.clearInvalid();
											
											//var scoreMethodId = pnlAddChildComponents.down('#scoreMethodId');
											var educationOperatorConditionId = pnlAddChildComponents.down('#educationOperatorConditionId');
											var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
											var subjectMappedId = pnlAddChildComponents.down('#subjectMappedId');
											var resultStatusMappedId = pnlAddChildComponents.down('#resultStatusMappedId');
											
											resultStatusMappedId.setVisible(false);
											$this.setAllowBlank(resultStatusMappedId,true);
											//scoreMethodId.setVisible(false);
											educationOperatorConditionId.setVisible(false);
											$this.setAllowBlank(educationOperatorConditionId,true);
											numberOfOperatorConditionId.setVisible(false);
											$this.setAllowBlank(numberOfOperatorConditionId,true);
											subjectMappedId.setVisible(false);
											$this.setAllowBlank(subjectMappedId,true);
											//$this.setAllowBlank(scoreMethodId,true);
											
											//scoreMethodId.reset();
											educationOperatorConditionId.reset();
											numberOfOperatorConditionId.reset();
											subjectMappedId.reset();
											resultStatusMappedId.reset();
											
											pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
										}
									}
								},{
									xtype: 'customcombobox',
									name:'educationExamPassedStatus',
									width:165,
									itemId: 'educationExamPassedStatusId',
									store:Ext.create('Academia.store.course.requisite.CourseEducationExamStatusStore'),
									displayField: 'translatedValue',
									valueField: 'value',
									forceSelection:true,
									value:courseReqData.educationFields,
									typeAhead:false,
									editable:false,
									listConfig: {
										listeners: {
											beforeshow: function(picker) {
												picker.minWidth = picker.up('combobox').getSize().width;
											}
										},
										loadingText: getCommonTranslation('SEARCHING'),
										emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
										getInnerTpl: function() {
											return '<div class="search-item">' +
											'{value}' +
											'</div>';
										}
									},
									listeners: {
										select:function(combo,record1){
											var pnlAddChildComponents = this.up('#pnlAddChildComponents');
											//var scoreMethodId = pnlAddChildComponents.down('#scoreMethodId');
											var educationOperatorConditionId = pnlAddChildComponents.down('#educationOperatorConditionId');
											var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
											var subjectMappedId = pnlAddChildComponents.down('#subjectMappedId');
											var resultStatusMappedId = pnlAddChildComponents.down('#resultStatusMappedId');
											if(record1[0].data.value=="MARKS_OBTAINED" || record1[0].data.value=="SUBJECT_SCORE" || record1[0].data.value=="GPAPERCENTAGE" ||
											   record1[0].data.value=="EQUIVALENT_MARKS_GRADE" || record1[0].data.value=="ASSESSMENT_LEVEL" ||
											   record1[0].data.value=="OBTAIN" || record1[0].data.value=="NOT_OBTAIN"){
												
												//scoreMethodId.setVisible(true);
												//$this.setAllowBlank(scoreMethodId,false);
												resultStatusMappedId.setVisible(false);
												$this.setAllowBlank(resultStatusMappedId,true);
												if(record1[0].data.value!="SUBJECT_SCORE" &&  record1[0].data.value!="OBTAIN" && record1[0].data.value!="NOT_OBTAIN" &&
												   record1[0].data.value!="EQUIVALENT_MARKS_GRADE" && record1[0].data.value!="ASSESSMENT_LEVEL"){
													educationOperatorConditionId.setVisible(true);
													$this.setAllowBlank(educationOperatorConditionId,false);
													subjectMappedId.setVisible(false);
													$this.setAllowBlank(subjectMappedId,true);
													numberOfOperatorConditionId.setVisible(false);
													$this.setAllowBlank(numberOfOperatorConditionId,true);
												}
												else{
													educationOperatorConditionId.setVisible(false);
													$this.setAllowBlank(educationOperatorConditionId,true);
													subjectMappedId.setVisible(true);
													/*subjectMappedId.getStore().getProxy().extraParams = {
														examBoardOther: false,
														id:1
													};
													subjectMappedId.getStore().load();*/
													$this.setAllowBlank(subjectMappedId,false);
													numberOfOperatorConditionId.setVisible(false);
													$this.setAllowBlank(numberOfOperatorConditionId,true);
												}
											}
											else{
												resultStatusMappedId.setVisible(true);
												$this.setAllowBlank(resultStatusMappedId,false);
												//scoreMethodId.setVisible(false);
												educationOperatorConditionId.setVisible(false);
												$this.setAllowBlank(educationOperatorConditionId,true);
												numberOfOperatorConditionId.setVisible(false);
												$this.setAllowBlank(numberOfOperatorConditionId,true);
												subjectMappedId.setVisible(false);
												$this.setAllowBlank(subjectMappedId,true);
												//$this.setAllowBlank(scoreMethodId,true);
											}
											//scoreMethodId.reset();
											educationOperatorConditionId.reset();
											numberOfOperatorConditionId.reset();
											subjectMappedId.reset();
											resultStatusMappedId.reset();
											
											pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
										}
									}
								},{
									xtype: 'nestedJsonCombo',
									itemId: 'subjectMappedId',
									store: Ext.create('Academia.store.common.SubjectTypeStore'),
									valueField: 'id',
									displayField: 'value',
									hidden:((courseReqData.educationFields=="SUBJECT_SCORE" || courseReqData.educationFields=="NOT_OBTAIN" || courseReqData.educationFields=="OBTAIN"
											|| courseReqData.educationFields=="EQUIVALENT_MARKS_GRADE" || courseReqData.educationFields=="ASSESSMENT_LEVEL") ? false : true),
									name: 'subjectMapped',
									editable : false,
									//allowBlank:false,
									hideTrigger:false,
									triggerAction: 'all',
									width:165,
									forceSelection:true,
									listeners: {
										render: function(combo){
											combo.getStore().load({
												callback: function(record, operation, success) {
													if (success) {
														if(!isNullOrEmpty(courseReqData.subject)){
															combo.setValue(courseReqData.subject.id);
														}
													}
												}
											});
										},
										select:function(combo,record){
											var pnlAddChildComponents = this.up('#pnlAddChildComponents');
											var educationOperatorConditionId = pnlAddChildComponents.down('#educationOperatorConditionId');
											educationOperatorConditionId.setVisible(true);
											$this.setAllowBlank(educationOperatorConditionId,false);
											educationOperatorConditionId.reset();
											educationOperatorConditionId.clearValue();
											educationOperatorConditionId.clearInvalid();
											
											var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
											numberOfOperatorConditionId.setVisible(false);
											numberOfOperatorConditionId.reset();
											
											pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
											
											var currentEducationPnl = combo.up('#educationPanel');
											var educationPanel = this.up('form').down('#educationPanel');
											var flag = true;
											if(educationPanel.length>0){
												educationPanel.forEach(function(obj){
													if(obj.id != currentEducationPnl.id){
														var examPassedVal = obj.down('#examPassed').getValue();
														var subjectVal = obj.down('#subjectMappedId').getValue();
														var currentExamPassedVal = currentEducationPnl.down('#examPassed').getValue();
														var currentSubjectVal = currentEducationPnl.down('#subjectMappedId').getValue();
														
														if(examPassedVal == currentExamPassedVal && subjectVal == currentSubjectVal){
															flag = false;
								    						return false;
														}
													}
												});
											}

											if(!flag){
												combo.reset();
												combo.clearInvalid();
												educationOperatorConditionId.setVisible(false);
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SUBJECT_ALREADY_SELECTED_MSG'));
												return false;
											}
										}
									}
								},{
									xtype: 'nestedJsonCombo',
									itemId: 'resultStatusMappedId',
									store:Ext.create('Academia.store.admission.applications.history.ResultStatus'),
									valueField: 'id',
									displayField: 'value',
									hidden:(courseReqData.educationFields=="RESULT_STATUS" ? false : true),
									name: 'resultStatusMapped',
									editable : false,
									hideTrigger:false,
									triggerAction: 'all',
									width:165,
									forceSelection:true,
									listeners: {
										render: function(combo){
											combo.getStore().load({
												callback: function(record, operation, success) {
													if (success) {
														if(!isNullOrEmpty(courseReqData.resultStatus)){
															combo.setValue(courseReqData.resultStatus.id);
														}
													}
												}
											});
										}
									}
								},{
									xtype: 'customcombobox',
									name:'educationOperatorCondition',
									width:165,
									itemId: 'educationOperatorConditionId',
									store:Ext.create('Academia.store.course.requisite.CourseCGPAConditionStore'),
									displayField: 'name',
									valueField: 'value',
									forceSelection:true,
									//margin: '0 0 0 10',
									value:courseReqData.courseRelationOperand,
									hidden:(courseReqData.educationFields=="RESULT_STATUS" ? true : false),
									editable:false,
									typeAhead:false,
									listeners: {
										select:function(combo,record){
											var pnlAddChildComponents = this.up('#pnlAddChildComponents');
											var numberOfOperatorConditionId = pnlAddChildComponents.down('#numberOfOperatorConditionId');
											numberOfOperatorConditionId.setVisible(true);
											$this.setAllowBlank(numberOfOperatorConditionId,false);
											numberOfOperatorConditionId.reset();
											numberOfOperatorConditionId.setValue(null);
											numberOfOperatorConditionId.clearInvalid();
											pnlAddChildComponents.up('courserequisiteform').getForm().checkValidity();
										}
									},
									listConfig: {
										listeners: {
											beforeshow: function(picker) {
												picker.minWidth = picker.up('combobox').getSize().width;
											}
										},
										loadingText: getCommonTranslation('SEARCHING'),
										emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
										getInnerTpl: function() {
											return '<div class="search-item">' +
											'{value}' +
											'</div>';
										}
									}
								},{
									xtype: 'numberfield',
									name: 'numberOfOperatorCondition',
									itemId: 'numberOfOperatorConditionId',
									hidden:(courseReqData.educationFields=="RESULT_STATUS" ? true : false),
									//margin: '0 0 0 10',
									hideTrigger: true,
									width:165,
									mouseWheelEnabled:false,
									maxLength: 6,
									//enforceMaxLength : true,
									minValue:1,
									maxValue:999,
									keyNavEnabled: false,
									allowExponential:false,
									allowDecimals: true,
									decimalPrecision:2,
									value:courseReqData.restrictionValue
									//allowBlank:false
								}]
							},{
								xtype:'fieldcontainer',
								layout : 'hbox',
								itemId:'fldMonthValidAndMethod',
								items:[{
									xtype: 'numberfield',
									name: 'monthValid',
									itemId: 'monthValidId',
									//margin: '0 0 0 10',
									fieldLabel : getProgramandcourseTranslation('MONTH_VALID'),
									labelAlign:'top',
									hideTrigger: true,
									mouseWheelEnabled:false,
									maxLength: 6,
									//enforceMaxLength : true,
									minValue:1,
									maxValue:99,
									width:165,
									value:courseReqData.monthValid,
									keyNavEnabled: false,
									allowExponential:false,
									allowDecimals: false,
									//decimalPrecision:2,
									allowBlank:true
								}/*,{
									xtype: 'customcombobox',
									name:'scoreMethod',
									width:165,
									hidden:(courseReqData.educationFields=="RESULT_STATUS" ? true : false),
									itemId: 'scoreMethodId',
									fieldLabel : getProgramandcourseTranslation('SCORE_METHOD'),
									labelAlign:'top',
									store:Ext.create('Academia.store.course.requisite.CourseScoreMethodStore'),
									displayField: 'name',
									valueField: 'value',
									forceSelection:true,
									//margin: '0 0 0 10',
									//allowBlank:false,
									typeAhead:false,
									editable:false,
									value:courseReqData.scoreMethod,
									listConfig: {
										listeners: {
											beforeshow: function(picker) {
												picker.minWidth = picker.up('combobox').getSize().width;
											}
										},
										loadingText: getCommonTranslation('SEARCHING'),
										emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
										getInnerTpl: function() {
											return '<div class="search-item">' +
											'{value}' +
											'</div>';
										}
									},
									listeners: {
										select:function(combo,record){
											var pnlAddChildComponents = this.up('#pnlAddChildComponents');
														var courseChildId = pnlAddChildComponents.down('#courseChildId');
														courseChildId.setVisible(true);
										}
									}
								}*/]
							}]

						}]
					}]
				});
			}
			courseForm.getForm().checkValidity();
    },
	getIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
	}
});
