Ext.define('Academia.controller.course.topic.TopicController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['common.IdValueCodeDataModel','course.coursetopic.CourseTopicModel'],
	stores : ['course.coursetopic.TopicDepthStore','course.coursetopic.CourseComponentStore','course.coursetopic.CourseTopicStore',
		'course.coursetopic.CourseTopicDocument','course.AccessibleCourseDepartmentStore','course.AccessibleChildCourseStore','importutility.ModuleName','importutility.ImportCourseTopicStore'],
		views : ['course.topic.TopicForm','course.topic.TopicGrid',
			'course.topic.CourseTopicDocumentGrid','course.CourseTabStructure','course.topic.ManageCourseTopicStructure',
			'course.topic.ManageCourseTopicView','course.topic.ManageCourseTopicSearchStructure','course.uploaddownload.CourseTopicUploadDownloadStructure','course.uploaddownload.CourseTopicDownloadForm','course.uploaddownload.CourseTopicUploadForm','importutility.ImportByModule.ImportListCourseTopic'],	           

			refs : [{
				ref : 'topicgrid',
				selector : 'topicgrid'
			},{
				ref :'topicform',
				selector :'topicform'	
			},{
				ref :'topicForm',
				selector :'topicform form'
			},{
				ref : 'coursetabstructure',
				selector : 'coursetabstructure'		  
			},{
				ref : 'coursetopicdocumentgrid',
				selector : 'coursetopicdocumentgrid'		  
			},{
				ref : 'simpledocumentform',
				selector : 'simpledocumentform'
			},{
				ref: 'coursetopicDocumentGrid',
				selector: 'coursetopicdocumentgrid[itemId=courseTopicDownloadId]'
			},{
				ref: 'coursetabstructure',
				selector: 'coursetabstructure'
			},{
				ref: 'managecoursetopicstructure',
				selector: 'managecoursetopicstructure'
			},{
				ref: 'managecoursetopicview',
				selector: 'managecoursetopicview'
			},{
				ref: 'coursetopicuploaddownloadstructure',
				selector: 'coursetopicuploaddownloadstructure'
			},{
				ref: 'coursetopicuploadform',
				selector: 'coursetopicuploadform'
			},{
				ref: 'coursetopicdownloadform',
				selector: 'coursetopicdownloadform'
			},{
           	 ref:'importlistcoursetopic',
        	 selector:'importlistcoursetopic'
         },{
				ref: 'managecoursetopicsearchstructure',
				selector: 'managecoursetopicsearchstructure'
			},{
           		 ref : 'uploadoptionradiogroup',
        		 selector : 'uploadoptionradiogroup[itemId=coursetopicUploadOptionRadioGroupItemId]'
         }],
			config:{

				/*
				 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
				 */
				/**
				 * @cfg {Array} COURSETOPIC_PERMISSIONS array (required)
				 * The array of permissions to use for Access control wise enabling and disabling buttons.
				 * @accessor
				 */
				COURSETOPIC_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSETOPIC_PRIVILEGES'),
				COURSETOPICDOC_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSETOPICDOC_PRIVILEGES')

			},
			init : function() {
				this.control({
					'managecoursetopicstructure ' : {
						render : function(){
							var grid = this.getTopicgrid();
							this.doAccessControlValidation(grid, this.getCOURSETOPIC_PERMISSIONS());
							this.disableCourseTopicMoreActionPivileges(grid,this.getCOURSETOPIC_PERMISSIONS());
							grid.getStore().removeAll();
						}
					},					
					'topicform button[itemId=topicSaveBtnId]' : {
						click : this.SaveTopicFormWindow
					},
					'topicform button[itemId=topicCancelBtnId]' : {
						click : this.closeFormWindow
					},
					'topicgrid button[itemId=btnAdd]' : {
						click : this.showFormWindow
					},
					'topicgrid button[itemId=btnEdit]' : {
						click:  this.editFormWindow
					},
					'topicgrid button[itemId=btnDelete]' : {
						click : this.deleteFormWindow
					},
					'topicgrid button[itemId=btnView]' : {
						click : this.viewFormWindow
					},
					'topicgrid button[itemId=topicUploadDocument]': {
						click: function() {
							this.topicDocumentUpload();
						}
					}, 
					'topicform textfield[itemId=topicName]':{
						blur : function(response){
							this.UniquenessCheck(response);
						}
					},
					'topicform textfield[itemId=topicSequence]':{
						blur : function(response){
//							this.UniquenessCheck(response);
						}
					},
					'topicform textfield[itemId=topicCode]':{
						blur : function(response){
							this.UniquenessCheck(response);
						}
					},
					'topicform numberfield[itemId=noOfSessionsId]':{
						blur : function(response){
							this.topicCountCheckInEdit();
						}
					},

					'documentformwindow[itemId=courseTopicDocItemId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
						click: function(){
							this.getUploadDocument();
						}
					}
					
					,
			        'coursetopicuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
			 			   change: this.courseTopicDownloadUploadFormChange
			 		},
			 		'coursetopicdownloadform button[itemId=topicDownloadResetBtn]':{
			 			click:function(obj){
			 				var $this = this;
			 				var form =obj.up('coursetopicdownloadform').getForm();
			 				obj.up('coursetopicdownloadform').down('#courseDepartmentId').reset();
			 				obj.up('coursetopicdownloadform').down('#downoladBtnId').setDisabled(true);
			 			}  
			 		},
			 		'coursetopicdownloadform button[itemId=downoladBtnId]':{
			 			click:function(obj){
			 				var $this = this;
			 				var form =obj.up('coursetopicdownloadform').getForm();

			 				var csvForm = Ext.create('Ext.form.Panel'); 
			 				csvForm.getForm().submit({
			 					target: '_blank',
			 					method:'GET',
			 					params :{
			 						access_token : Ext.Ajax.defaultHeaders.access_token
			 					},
			 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			 					url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_COURSE_TOPIC_CREATION,
			 					standardSubmit :true
			 				});
			 			}  
			 		},
			 		'coursetopicuploadform button[itemId=uploadId]':{
			 			click:function(obj){
			 				var $this=this;
			 				var form=obj.up('coursetopicuploadform');
			 				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		    	        	$this.getHashOfFile(form);
				        	setTimeout(function() {
				 				form.getForm().submit({
				 					method : 'POST',
				 					url : submitUrl,
				 					success : function(form, action){
				 						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
				 					},
				 					failure: function(form, action) {
		   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				 					}
				 				});
				        	},1000);

			 				Ext.defer(function() {
			 					var grid = $this.getImportlistcoursetopic();
			 					var form = $this.getUploadoptionradiogroup();
			 					var isUploadAll = true;
			 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_COURSE_TOPIC');
			 				}, 2000, this);
			 			}  
			 		},/*
			 		
			 		,'coursetopicuploadform button[itemId=uploadId]':{
        	 			click:function(obj){
        	 				var $this=this;
        	 				var form=obj.up('coursetopicuploadform');
        	 				//var templateName = form.getValues().uploadType;
                            var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
                            var moduleName = 'Bulk Course Topic';
                            	
		    	        	$this.getHashOfFile(form);
				        	setTimeout(function() {
            	 				form.getForm().submit({
            	 					method : 'POST',
            	 					url : submitUrl,
            	 					success : function(form, action){
            	 						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
            	 					},
            	 					failure: function(form, action) {
           		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
            	 					}
            	 				});
				        	},1000);
        	 				Ext.defer(function() {
        	 					var grid = $this.getImportlistcoursetopic();
        	 					var form = $this.getCoursetopicuploadoptionradiogroup();
        	 					var isUploadAll = form.items.items[0].getValue().isUploadAll;
        	 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
        	 				}, 2000, this);
        	 			}  
        	 		},*/
			 		'coursetopicuploadform button[itemId=resetBtn]':{
			 			click:function(obj){
			 				var $this = this;
			 				var form =obj.up('coursetopicuploadform').getForm();
			 				form.findField('file').reset();
			 				form.isValid();
			 			}/*,
			 			render :function(obj){
			 				var $this = this;
			 				var form =obj.up('coursetopicuploadform').getForm();
			 			}  
			 		},*/		
			 		
			 		,
		 			render :function(obj){
		 				var $this = this;
		 				var form =obj.up('coursetopicuploadform').getForm();
		 				var combo = form.findField('importUtilityMasterId');
		 				combo.getStore().load({
		 					callback: function(records, operation, success) {
		 						for(var i in records){
		 							if(records[i].data.value=='Bulk Course Topic'){
		 								combo.setValue(records[i].data.id);
		 								combo.setReadOnly(true);
		 							}
		 						}
		 					}	   
		 				});
		 			}  
		 		},
		  		   'coursetopicuploadform uploadoptionradiogroup[itemId=coursetopicUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
		 			   change: function( radioGroup, newValue, oldValue, eOpts){
		 				   var grid =this.getImportlistcoursetopic();
		 				   var form =this.getUploadoptionradiogroup();
		 				   var isUploadAll = true;
		 				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_COURSE_TOPIC');
		 			   }   
		 		   },
			 		'importlistcoursetopic':{
			 			render:function(obj){
			 				var $this = this;
			 				var grid = $this.getImportlistcoursetopic();
			 				var form = $this.getUploadoptionradiogroup();
		 					var isUploadAll = true;
		 					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'BULK_COURSE_TOPIC');
			 			},
			 			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			 				if (e.target.tagName == 'A') {
			 					var fileType=null;
			 					if(cellIndex==1){
			 						fileType='successFile';
			 					}else if(cellIndex==6){
			 						fileType='errorFile';
			 					}else if(cellIndex==7){
			 						fileType='logFile';
			 					}
			 					var documentId = record.get("id");
			 					if (!isNullOrEmpty(documentId)) {
			 						this.getCourseTopicDownloadFile(documentId,fileType);
			 					}
			 				}
			 			}
			 		},
			 		'importlistcoursetopic button[itemId=btnForce]':{
			 			click: function(obj) {
			 				var grid = this.getImportlistcoursetopic();
			 				if (grid.getSelectionModel().getCount() > 0) {
			 					if(grid.getSelectionModel().getCount() > 1){
			 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			 					}else{
			 						var this$ = this;
			 						var id = grid.getSelectionModel().selectionStart.data.id;
			 						console.log(id);
			 						var urlAppend="?jobName="+id;
			 						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
			 						Ext.Ajax.request({
			 							url: submitURL,
			 							method: 'GET',
			 							success: function(response) {
			 								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
			 									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
			 								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
			 									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
			 								}else if(response.responseText==="SUCCESS"){
			 									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			 									grid.getStore().reload();
			 								}
			 							}
			 						});
			 					}
			 				} else {
			 					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			 				}  
			 			}
			 		},
      		 		 'coursetopicdownloadform customcombobox[itemId=courseDepartmentId]': {
 			 			select : function(obj) {
 			 				var $this = this;
  		 				var form =obj.up('coursetopicdownloadform').getForm();
  		 				var $this = this;
 			 			var form =$this.getCoursetopicdownloadform();
  		 				obj.up('coursetopicdownloadform').down('#downoladBtnId').setDisabled(false);
 			 		}
 			 	},
	
					'topicgrid' : { 
						cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							var $this=this;
							var searchResultGrid = $this.getTopicgrid();
							var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
							if(columnName=='noOfDocuments' &&  record.data.noOfDocuments > 0){ // checked

								var store=$this.getStore('course.coursetopic.CourseTopicDocument');
								store.getProxy().extraParams = {
									courseTopicId: record.data.id
								};
								store.load();

								var formWindow = $this.getCoursetopicdocumentgrid();
								if (!formWindow) {
									Ext.widget('coursetopicdocumentgrid');
									formWindow = $this.getCoursetopicdocumentgrid();
								}
								formWindow.show();

							}  
						}
					},
					'coursetopicdocumentgrid':{
						render:function(grid){
							var $this = this;
							$this.doAccessControlValidation(grid, $this.getCOURSETOPICDOC_PERMISSIONS());
							$this.disableCourseTopicDownloadPivileges(grid, $this.getCOURSETOPICDOC_PERMISSIONS());
						}
					},

					'coursetopicdocumentgrid grid[itemId=courseTopicDownloadId]' : {
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							var documentGrid=Ext.ComponentQuery.query('grid#courseTopicDownloadId')[0];
							var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

							if (columnName == "documentName") {
								if (e.target.tagName == 'A') {
									var documentId = record.get("documentId");
									if (!isNullOrEmpty(documentId)) {
										$this.getDocumentController().downloadDocumentFile(documentId);
									}
								}
							}
						}
					},
					'coursetopicdocumentgrid grid[itemId=courseTopicDownloadId] button[itemId=btnDelete]' : {
						click : function() {
							var $this = this;
							var grid=Ext.ComponentQuery.query('grid#courseTopicDownloadId')[0];
							if (grid.getSelectionModel().getCount() > 0) {
								showConfirmMessage(getCommonTranslation('COURSE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
										function(btn,text) {
									if (btn == 'yes') {
										var records = grid.getSelectionModel().getSelection();
										var id = records[0].get("id");
										if(!isNullOrEmpty(records[0].data.courseTopic)){
											var courseTopicId=records[0].data.courseTopic.id;
										}
										var ids=[];
										for(var i in records) {
											if(!isNullOrEmpty(records[i].get("id"))) {
												ids.push(records[i].get("id"));
											}
										}
										Ext.Ajax.request({
											method : "DELETE",
											type : 'rest',
											url : SERVERURL.COURSE_TOPIC_DOCUMENT_DELETE+ '?ids='+ ids+'&courseTopicId='+courseTopicId,
											headers : {
												'Content-Type' : 'application/json'
											},
											success : function(form,action) {
												var totalSize = form.responseText;
												grid.getStore().reload();
												showSuccessMessage(getCommonTranslation('COURSE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
												$this.getStore('course.coursetopic.CourseTopicStore').load();
												$this.getTopicgrid().getStore().reload();
												if(totalSize==0){
													var formWindow = $this.getCoursetopicdocumentgrid();
													formWindow.close();
												}

											}
										});
									}
								});
							} else {
								showWarningMessage(getCommonTranslation('COURSE'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
							}
						}
					},
					'coursetopicdocumentgrid grid[itemId=courseTopicDownloadId] button[itemId=downloadBtn]' : {
						click : function() {
							var $this = this;
							var grid=Ext.ComponentQuery.query('grid#courseTopicDownloadId')[0];
							if (grid.getSelectionModel().getCount() > 0) {
								var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
								var zipFileName = 'courseTopicDocument';
								var records = grid.getSelectionModel().getSelection();
								var saveModel=[];
								for(var i in records) {
									if(!isNullOrEmpty(records[i].data.path)) {
										saveModel.push(records[i].data.path);
									}
								}
								$this.getDocumentController().downloadMultipleDocumentFile(saveModel, zipFileName, directoryType);
							} else {
								showWarningMessage(getCommonTranslation('COURSE'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
							}
						}
					},
					'managecoursetopicview [itemId=courseDepartmentId]' : {
						select : function(){
							var $this = this;
							var form = $this.getManagecoursetopicview();
							var departmentId = form.down('#courseDepartmentId').getValue();
							var courseStore = form.down('#courseId').getStore();
							courseStore.getProxy().extraParams = {
								departmentId: departmentId
							};
							courseStore.load();
						}
					},
					'managecoursetopicview [itemId=courseId]' : {
						select : function(record){
							var form = this.getManagecoursetopicview();
							form.down('#searchBtn').setDisabled(false);
							var grid = this.getTopicgrid();
							grid.getStore().removeAll();
							var buttonsToolBar = grid.query('toolbar')[0];
							var gridAddBtn= buttonsToolBar.query('#btnAdd')[0];
							gridAddBtn.setDisabled(true);
							grid.down('#custompagingtoolbarId').setVisible(false);
						}
					},
					'managecoursetopicview button[itemId=searchBtn]' : {
						click : function(){
							var form=this.getManagecoursetopicview();
							this.searchTopicsforCourse();
							var grid = this.getTopicgrid();
							var buttonsToolBar = grid.query('toolbar')[0];
							var gridAddBtn= buttonsToolBar.query('#btnAdd')[0];
							gridAddBtn.setDisabled(false);
							grid.config.searchFilterForm = form;
						}
					},
					'managecoursetopicview button[itemId=resetBtn]' : {
						click : function(){
							var $this = this;
							var form = this.getManagecoursetopicview();
							form.down('#searchBtn').setDisabled(true);
							var grid = this.getTopicgrid();
							var tabStcrFrm = $this.getManagecoursetopicview();
							var departmentCombo = tabStcrFrm.down('#courseDepartmentId');
							var courseCombo = tabStcrFrm.down('#courseId');
							departmentCombo.reset();
							courseCombo.reset();
							var departmentId = departmentCombo.getValue();
							var courseStore = courseCombo.getStore()
							courseStore.getProxy().extraParams = {
								departmentId: departmentId
							};
							courseStore.load();
							grid.getStore().removeAll();
							grid.down('#custompagingtoolbarId').setVisible(false);
							var buttonsToolBar = grid.query('toolbar')[0];
							var gridAddBtn= buttonsToolBar.query('#btnAdd')[0];
							gridAddBtn.setDisabled(true);
						}				
    	 		},
    	 		'managecoursetopicview': {
        			render: function(window){
        				var $this = this;
        				window.body.on('click', function() {
        	    			$this.hideInvalidIconFromField($this.getManagecoursetopicview());
        	    	       });
        			}
        		},
        		'topicform': {
        			render: function(window){
        				var $this = this;
        				window.body.on('click', function() {
        					var filter = window.down('dynamicfieldformwin');
        	    			$this.hideInvalidIconFromField(filter);
        	    	       });
        			}
        		},
        		'coursetopicuploaddownloadstructure': {
        			render: function(structure){
        				var $this = this;
        				structure.body.on('click', function() {
        					var filter = structure.down('form');
        	    			$this.hideInvalidIconFromField(filter);
        	    	       });
        			}
        		},
				});
			},
			UniquenessCheck : function(response){

				var $this = this;
				var grid = $this.getTopicgrid();
				var store=$this.getStore('course.coursetopic.CourseTopicStore');
				var selectedRecord = grid.getSelectionModel().getSelection()[0];
				var row = store.indexOf(selectedRecord);
				var records=selectedRecord;
				
				
				var tabStcrFrm = $this.getManagecoursetopicview();
				var cId = tabStcrFrm.down("#courseId").getValue();

				var tpcFrm =  $this.getTopicForm().getForm();
				var courseTopicId = tpcFrm.findField("id").getValue();

				if(!courseTopicId){
					courseTopicId = 0;
				}
				var fieldToBeChecked = response.initialConfig.name;
				var value = response.getValue();
				var courseId = cId;

				if((isNullOrEmpty(records) && !isNullOrEmpty(value)) || (!isNullOrEmpty(records) && records.data.topicName!=tpcFrm.findField('topicName').getValue())){
					Ext.Ajax.request({
						method: "POST",
						type: 'rest',
						url: SERVERURL.COURSE_TOPIC_CHECK_UNIQUENESS+'?courseId='+courseId+'&fieldToBeChecked='+fieldToBeChecked+'&courseTopicId='+courseTopicId+'&value='+value,
						headers: {
							'Content-Type': 'application/json'
						},
						success:function(form, action){
							var mssg = form.responseText;

							if(mssg=="Topic name not available"){
								tpcFrm.findField("topicName").setValue(null);
								tpcFrm.findField("topicNameMssg").show();
								tpcFrm.findField("topicNameMssg").setValue(getErrorTranslation('courseTopicName_not_available'));
							}else if(mssg=="Topic Sequence is not available"){
								tpcFrm.findField("topicSequence").setValue(null);
								tpcFrm.findField("topicSequenceMssg").show();
								tpcFrm.findField("topicSequenceMssg").setValue(getErrorTranslation('coursetopicSequence_not_available'));
							}else if(mssg=="Topic code is not available"){
								tpcFrm.findField("topicCode").setValue(null);
								tpcFrm.findField("topicCodeMssg").show();
								showWarningMessage(getCommonTranslation('COURSE'),getCommonTranslation('TOPIC_CODE_MSG'));
							}
							else if(mssg=="true"){
								tpcFrm.findField("topicNameMssg").hide();
								tpcFrm.findField("topicSequenceMssg").hide();
								tpcFrm.findField("topicCodeMssg").hide();
							}
						}
					});
				}
			},
			closeFormWindow : function() {
				this.getTopicform().close();
			},
			SaveTopicFormWindow : function(){

				var $this = this;

				var store = $this.getTopicgrid();
				var grdStore = store.getStore();

				var tabStcrFrm = $this.getManagecoursetopicview();
				var courseCombo = tabStcrFrm.down("#courseId");
				var courseId = tabStcrFrm.down("#courseId").getValue();
				$this.getTopicForm().down('#topicSaveBtnId').setDisabled(true);
				var courseComponentId = courseCombo.valueModels[0].data.secondId;
				if(courseComponentId!=null){
					var frmWin = $this.getTopicForm().getForm();
					var value = frmWin.getValues();
					var topicModel = new Academia.model.course.coursetopic.CourseTopicModel();

					topicModel.set("courseComponent",$this.getIdValueJson(courseComponentId));
					topicModel.set("topicSequence",value.topicSequence);
					topicModel.set("topicCode",value.topicCode);
					topicModel.set("topicName",value.topicName);
					topicModel.set("topicDescription",value.topicDescription);
					topicModel.set("topicMinutes",value.topicMinutes);
					topicModel.set("topicDepth",$this.getIdValueJson(value.topicDepth));
					topicModel.set("whetherCompulsory",value.whetherCompulsory);
					topicModel.set("noOfSessions",value.noOfSessions);
					topicModel.set("customData",value.customData);
					topicModel.set("version",value.version);
					if (value.id == null ||value.id == "") {
						submitUrl = SERVERURL.COURSE_TOPIC_CREATE;
					} else {
						topicModel.set("id",value.id);
						submitUrl = SERVERURL.COURSE_TOPIC_UPDATE;
					}

					var submitData = Ext.encode(topicModel.data);

					Ext.Ajax.request({
						url: submitUrl,
						jsonData: submitData,
						method: 'POST',
						success: function(response) {
							grdStore.reload();
							$this.closeFormWindow();
							showSuccessMessage(getCommonTranslation('TOPIC'),getCommonTranslation('SUCCESS'));
						}
					});

				}else{
					var store = this.getStore('course.coursetopic.CourseComponentStore');
					store.getProxy().extraParams = {
						id: courseId
					};
					store.load({
						callback: function(record, operation, success) {
							if (success) {
								courseComponentId = record[0].get('id');
								var frmWin = $this.getTopicForm().getForm();
								var value = frmWin.getValues();
//								var tempIgnoreTopic = frmWin.findField('whetherTemporaryIgnoreTopic').getValue();
								var topicModel = new Academia.model.course.coursetopic.CourseTopicModel();


								//topicModel.set("courseId",courseId);
								topicModel.set("courseComponent",$this.getIdValueJson(courseComponentId));
								topicModel.set("topicSequence",value.topicSequence);
								topicModel.set("topicCode",value.topicCode);
								topicModel.set("topicName",value.topicName);
								topicModel.set("topicDescription",value.topicDescription);
								topicModel.set("topicMinutes",value.topicMinutes);
								topicModel.set("topicDepth",$this.getIdValueJson(value.topicDepth));
								topicModel.set("whetherCompulsory",value.whetherCompulsory);
								topicModel.set("noOfSessions",value.noOfSessions);
//								topicModel.set("whetherTemporaryIgnoreTopic",tempIgnoreTopic);
								//topicModel.set("topicPlanDocumentPath","/home/file/Course - Inserts.pdf");
								topicModel.set("customData",value.customData);
								topicModel.set("version",value.version);
								if (value.id == null ||value.id == "") {
									submitUrl = SERVERURL.COURSE_TOPIC_CREATE;
								} else {
									topicModel.set("id",value.id);
									submitUrl = SERVERURL.COURSE_TOPIC_UPDATE;
								}

								var submitData = Ext.encode(topicModel.data);

								Ext.Ajax.request({
									url: submitUrl,
									jsonData: submitData,
									method: 'POST',
									success: function(response) {
										grdStore.reload();
										$this.closeFormWindow();
										showSuccessMessage(getCommonTranslation('TOPIC'),getCommonTranslation('SUCCESS'));
									}
								});
							}
						}
					});
				}

				
			},

			showFormWindow : function() {
				var $this=this;
				var formWindow = this.getTopicform();
				if (!formWindow) {
					Ext.widget('topicform');
					formWindow = this.getTopicform();
				}
				formWindow.show();
				/*var tabStcrFrm = $this.getCoursetabstructure().getForm();
				var cId = tabStcrFrm.findField("ids").getValue();
				var store = this.getStore('course.coursetopic.CourseComponentStore');
				store.getProxy().extraParams = {
					id: cId
				};
				store.load(); */       

			},
			editFormWindow: function() {
				var $this =this;
				var grid = $this.getTopicgrid();

				if (grid.getSelectionModel().getCount() > 0) {
					this.showFormWindow();
					var form = $this.getTopicForm();

					var store=$this.getStore('course.coursetopic.CourseTopicStore');
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					var row = store.indexOf(selectedRecord);
					var records=selectedRecord;

					if (records != undefined && records != "" && records != null) {
						form.loadRecord(records);

						var topicId = records.data.id;


						if(records.data.topicName == "Default"){
							form.down('#topicName').setReadOnly(true);
						}


						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.COURSE_TOPIC_FINDALLBy_ID,
							params : {
								id : topicId
							},
							method : 'GET',
							success : function(response) {
								var data = Ext.decode(response.responseText);
								var topicData = new Academia.model.course.coursetopic.CourseTopicModel(data);
								form.loadRecord(topicData);

								var WCRadio = form.down('#whetherCompulsoryId');
//								var WTITRadio = form.down('#whetherTemporaryIgnoreTopicId');

								var whetherCompulsry = data.whetherCompulsory;
//								var whetherTempIgnor = data.whetherTemporaryIgnoreTopic;


								if(!whetherCompulsry){
									WCRadio.items.items[1].setValue(true);
								}
								/*if(!whetherTempIgnor){
									WTITRadio.items.items[1].setValue(true);
								}*/
								if(data.topicDepth!=null && data.topicDepth.id!=null){
									var topicDepthId = data.topicDepth.id;
									var topicStore = $this.getStore('course.coursetopic.TopicDepthStore');
									form.down('#topicDepth').reset();
									topicStore.load({
										callback: function(record, operation, success) {
											if (success) {
												form.down('#topicDepth').setValue(topicDepthId);
											}}
									});
								}
								
								/*var courseComponentId = data.courseComponent.id;
								var courseComponentStore = $this.getStore('course.coursetopic.CourseComponentStore');
								courseComponentStore.load({
									callback: function(record, operation, success) {
										if (success) {
											form.down('#courseComponent').setValue(courseComponentId);
										}}
								});*/



								var frm = $this.getTopicForm();
								var topicId = records.data.id;
								/*Ext.Ajax.request({
									method: "GET",
									type: 'rest',
									url: SERVERURL.COURSE_TOPIC_IGNORE,
									headers: {
										'Content-Type': 'application/json'
									},
									params:{
										topicId:topicId
									},
									success:function(res, action){
										var TIID = res.responseText;
										if(TIID>0){
											frm.down('#whetherTemporaryIgnoreTopicId').setDisabled(true);
										}
									}
								});*/

								Ext.Ajax.request({
									method: "GET",
									type: 'rest',
									url: SERVERURL.COUNT_OF_TOPIC,
									headers: {	
										'Content-Type': 'application/json'
									},
									params:{
										topicId:topicId
									},
									success:function(res, action){
										var topicCount = res.responseText;
										form.down('#topicCount').setValue(topicCount);
									}
								});

							}
						}); 

					}
				} else {
					showWarningMessage(getCommonTranslation('TOPIC'), getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			},
			viewFormWindow : function(){

				this.editFormWindow();
				var form =this.getTopicForm();
				if (form) {
					form.down('#topicSaveBtnId').setVisible(false);
					form.down('#topicName').setReadOnly(true);
					form = form.getForm();
					toggleReadOnlyFormItems(form, true); 
				}
			},
			deleteFormWindow: function() {

				var grid = this.getTopicgrid();
				var grdStore = grid.getStore();
				if(grid.getSelectionModel().getCount()>0){
					showConfirmMessage(getCommonTranslation('TOPIC'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
						if (btn == 'yes') {
							var records=grid.getSelectionModel().getSelection();						        
							var id=records[0].get("id");
							Ext.Ajax.request({
								method: "DELETE",
								type: 'rest',
								url: SERVERURL.COURSE_TOPIC_DELETE,
								headers: {
									'Content-Type': 'application/json'
								},
								params:{
									id:id
								},
								success:function(form, action){
									grdStore.reload();
									showSuccessMessage(getCommonTranslation('TOPIC'),getCommonTranslation('SUCCESS'));
								}
							});
						}
					});
				}else{
					showWarningMessage(getCommonTranslation('TOPIC'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
				}

			},

			/*
			 * @method
			 * method to load the store manually after the rendering of the grid.
			 */
			searchTopicsforCourse : function(grid){
				var $this = this;
				var tabStcrFrm = $this.getManagecoursetopicview();
				tabStcrFrm.down('#searchBtn').setDisabled(true);
				var courseCombo = tabStcrFrm.down('#courseId');
				var courseId = tabStcrFrm.down('#courseId').getValue();
				var courseComponentId = courseCombo.valueModels[0].data.secondId;
				var store = this.getTopicgrid().getStore();
				store.getProxy().extraParams = {
					courseId:courseId,
					courseComponentId:courseComponentId
				};
				$this.resetPageSetting(store);
				 store.load({
					   callback: function(records, operation, success) {
						   tabStcrFrm.down('#searchBtn').setDisabled(false);
					   }
			    });
			},
			getIdValueJson: function(id, value) {
				if (id) return {
					id: id,
					value: value
				};
			},
			//************ disableMoreActionPivileges****************  
			disableCourseTopicMoreActionPivileges: function(gridReference,permissionsMap) {

				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				buttonsToolBar = gridReference.query('toolbar')[0];
				Ext.each(permissionList, function(privilege) {
					if (privilege === 'UPLOADFILE') {
						var button = buttonsToolBar.query('#topicUploadDocument')[0];
						if(!isNullOrEmpty(button)){
							button.setVisible(true);
						}        		
					}

				});
			},

			//************ disableCourseTopicDownloadPivileges ****************//  
			disableCourseTopicDownloadPivileges: function(gridReference, permissionsMap) {
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				var downloadButton = gridReference.down('#downloadBtn');
				downloadButton.setVisible(false);

				Ext.each(permissionList, function(privilege) {
					if (privilege === 'DOWNLOAD') {
						var button = gridReference.down('#downloadBtn');
						if(!isNullOrEmpty(button)){
							button.setVisible(true);
						}        		
					}
				});
			},
			//***********************************************************************************

			topicDocumentUpload:function(){
				var grid = this.getTopicgrid();  
				if(grid.getSelectionModel().getCount()>0){
					this.getDocumentController().showDocumentFormWindow('courseTopicDocItemId', 'DOCUMENT');
				}else{
					showWarningMessage(getCommonTranslation('TOPIC'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
				}
			},
			getDocumentController : function() {
				var this$ = this;
				return this$.getController('Academia.controller.document.DocumentController');
			},
			/**
			 *  for upload document
			 */
			getUploadDocument : function(){

				var $this=this;
				var grid = this.getTopicgrid();
				var isTransient = true;
				var module = 'courseTopic';
				var entityId ;
				var entityType = 'courseTopic';

				$this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){

					if (grid.getSelectionModel().getCount() > 0) {
						var record = grid.getSelectionModel().getSelection()[0];
						var id = record.get("id");
						var data = {
								"id": id,
								"documents": [
									{
										"createdBy": $this.getIdValueJson(response.createdBy.id),
										"name": response.name,
										"path": response.path,
										"type": response.type
									}
									]
						};


						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.COURSE_TOPIC_UPLOAD,
							jsonData : data,
							method : 'POST',
							success : function(response, action) {
								showSuccessMessage(getCommonTranslation('TOPIC'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
								
								$this.getStore('course.coursetopic.CourseTopicStore').load();
								$this.getTopicgrid().getStore().reload();
								
							}
						});	

						
					}
				
					$this.getDocumentController().closeDocumentFormWindow();
				}, isTransient);
				
			},
			topicCountCheckInEdit:function(){
				var $this = this;
				var form =  $this.getTopicForm().getForm();
				var id = form.findField('id').getValue();
				var topicCount = form.findField('topicCount').getValue();
				var noOfSessions = form.findField('noOfSessions').getValue();
				if (!isNullOrEmpty(id)){
					if(topicCount > noOfSessions){
						form.findField("noOfSessions").reset();
						form.findField("sessionMssg").setVisible(true);
						form.findField("sessionMssg").setValue(topicCount + getProgramandcourseTranslation('TOPIC_COUNT') + topicCount);
					}else{
						form.findField("sessionMssg").setVisible(false);
					}
				} 
			},
			downloadButtonClick:function(){
				var $this = this;
				
			},
				courseTopicDownloadUploadFormChange : function(cb, nv, ov){
			    	var $this = this;
			    	var structure = cb.up('coursetopicuploaddownloadstructure');
			    	var downloadTemplateForm = structure.down('coursetopicdownloadform');
			    	var uploadTemplateForm = structure.down('coursetopicuploadform');
			    	var grid = $this.getImportlistcoursetopic();
			    	if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
			    		uploadTemplateForm.hide();
			    		downloadTemplateForm.show();
			    		grid.setVisible(false);
			    	}else{
			    		//$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
			        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
			        	
			    		downloadTemplateForm.hide();
			    		uploadTemplateForm.show();
			    		grid.setVisible(true);
			    		uploadTemplateForm.down("#uploadFileField").reset();
			    	}
			    },
			    getCourseTopicDownloadFile : function(documentId,fileType){
			   	   if(!isNullOrEmpty(documentId)){
			   		   var csvForm = Ext.create('Ext.form.Panel'); 
			   		   csvForm.getForm().submit({
			   			   target: '_blank',
			   			   method:'POST',
			   			   params :{
			   				   access_token : Ext.Ajax.defaultHeaders.access_token
			   			   },
			   			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			   			   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
			   			   standardSubmit :true
			   		   });
			   	   }
			      }
});
