Ext.define('Academia.controller.coursetracker.CourseTrackerController', {
	extend : 'Academia.controller.base.BaseController',
    
    models:['coursetracker.CourseTrackerChart'],
    stores: ['coursetracker.CourseTrackerChart','coursetracker.ActulalPlanned','coursetracker.PlannedStore','attendance.StudentCourses',
             'common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
             'course.coursetopic.CourseComponentStore','attendance.SectionByCourseNComponent','attendance.SectionByCourseNComponent',
             'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore','course.coursetopic.CourseComponentStore',
             'attendance.SectionAndFacultyByPeriodID','attendance.SectionAndFacultyByPeriodID','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
             'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic'
             ],
    
    views: ['coursetracker.CourseTrackerStructure','coursetracker.CourseTrackerSearch',
            'coursetracker.CourseTrackerChart','coursetracker.CourseTrackerChartGridTab',
            'coursetracker.CourseTrackerGrid','coursetracker.CourseChartNDisplayStructure','coursetracker.ActulaPlannedView'],
            config: {
	              
    	        COURSE_TRACKER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSE_TRACKER_PRIVILEGES')
    	   },              
    refs: [{
    	ref: 'coursetrackersearch',
    	selector: 'coursetrackersearch'
    },{
    	ref: 'coursechartndisplaystructure',
    	selector: 'coursechartndisplaystructure'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref: 'coursetrackergrid',
    	selector: 'coursetrackergrid'
    },{
    	ref: 'actulaplannedview',
    	selector: 'actulaplannedview'
    }],
    
    init: function() {
        this.control({
        	 'coursetrackersearch radiogroup[itemId=courseSectionTypeRadio]' :{
    			 change : function() {
    				 this.changeSectionType();
    			 }
    		 },
    		 'coursetrackersearch combobox[itemId=selectionGroupId]' :{
    			 change : function(cb) {
    				 this.multiselectFields(cb);
    			 }
    		 },
        	 'coursetrackersearch' : {
    			 render:function(){
    				 var $this = this;
    				 var academyLocationId = this.getCurrentAcademyLocation();
    				 var courseCombo = this.getCoursetrackersearch().down('customcombobox#courseId');
    				 var courseStore = courseCombo.getStore();
    				 courseStore.getProxy().extraParams = {
    					 sectionType : 'CourseSection',
    					 academyLocationId : academyLocationId
    				 };
    				 courseStore.load();
    				 
    				 $this.changeSectionType();
    			 }
    		 },'coursetrackersearch customcombobox#courseId' : {
    			 select : function(obj, record) {
    				 var courseId = record[0].get("courseId");
    				 
    				 var courseComponentBox = this.getCoursetrackersearch().down('customcombobox#componentSectionId');
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id');
    				 courseComponentBox.clearValue();
    				 sectionBox.clearValue();
    				 var multipleCourseSectionBox=this.getCoursetrackersearch().down('#multipleCourseSection_Id');
    				 multipleCourseSectionBox.clearValue();
    				 
    				/* if(record[0].get("sectionAtComponentLevel")){
    					 courseComponentBox.show();
    					 var store = courseComponentBox.getStore();
    					 store.getProxy().extraParams = {
    						 id: courseId
    					 };
    					 store.load();
    				 }
    				 else{*/
    					 var courseComboBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id');
    					 courseComboBox.clearValue();
    					 courseComponentBox.hide();
    					 sectionBox.setDisabled(false);
    					 var courseStore = courseComboBox.getStore();
    					 courseStore.getProxy().extraParams = {
    						 parentCourseId: courseId
    					 };
    					 courseStore.load();
    					 this.getCoursetrackersearch().down('#multipleCourseSection_Id').setDisabled(false);
//    				 }
    				 
    				 var topicsBox = this.getCoursetrackersearch().down('customcombobox#topicsId');
    				 var multipleTopicsBox = this.getCoursetrackersearch().down('#multipleTopicsId');
    				 topicsBox.clearValue();
    				 topicsBox.setDisabled(false);
    				 multipleTopicsBox.setDisabled(false);
					 var topicStore = topicsBox.getStore();
					 topicStore.getProxy().extraParams = {
						 courseId: courseId
					 };
					 //topicStore.load();
    				 
    			 }
    		 },	 
    		 'coursetrackersearch customcombobox#componentSectionId' : {
    			 select : function(obj, record) {
    				 var componentId = record[0].get("id");
    				 var courseId = this.getCoursetrackersearch().getForm().findField('course').getValue();
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id');
    				 sectionBox.setDisabled(false);
    				 sectionBox.clearValue();
    				 var store = sectionBox.getStore();
    				 store.getProxy().extraParams = {
    					 componentId : componentId,
    					 parentCourseId : courseId
    				 };
    				 store.load();
    			 }
    		 },
    		 'coursetrackersearch customcombobox#programId' : {
    			 select : function(obj, record) {
    				 this$=this;
    				 var programId = record[0].get("id");
    				 var batchComboBox = this$.getCoursetrackersearch().down('customcombobox#batchId');
    				 batchComboBox.clearValue();
    				 batchComboBox.setDisabled(false);
    				 var batchStore = batchComboBox.getStore();
    				 var form = this$.getCoursetrackersearch();
    				 batchStore.getProxy().extraParams = {
    					 id: programId
    				 };
    				 batchStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==0){
									   form.down("#multipleCourseSection_Id").setDisabled(true);
									   form.down("#multipleCourseSection_Id").clearValue();
								   }
								   if(records.length==1){
									   form.down("#batchId").setValue(records[0].get('id'));
									   form.down("#periodId").setDisabled(false);
									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
									   store.getProxy().extraParams = {
										   id: records[0].get('id'),
										   isCurrentPeriod:true
									   };
									   store.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==0){
													   if(wheatherSchool) {
														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

													   } 
												   }
												   else if(records.length==1){
													   form.down("#periodId").setValue(records[0].get('id'));
													     var periodId = records[0].get("id");
									    				 var programCourseComboBox = form.down('customcombobox#courseId_1');
									    				 var multiselectCourseComboBox = form.down('#multiselectCourseId');
									    				 programCourseComboBox.clearValue();
									    				 programCourseComboBox.setDisabled(false);
									    				 multiselectCourseComboBox.setDisabled(false);
									    				 var programBatchStore =programCourseComboBox.getStore(); 
									    				 programBatchStore.getProxy().extraParams = {	
									    					 periodId: periodId,
									    					 sectionType : 'ProgramBatchSection'
									    				 };
									    				 programBatchStore.load();
									    				 var courseComponentBox = form.down('customcombobox#componentSectionId_1');
									    				 var sectionBox = form.down('customcombobox#courseSection_Id_1');
									    				 courseComponentBox.clearValue();
									    				 sectionBox.clearValue();
									    				 courseComponentBox.setDisabled(true);
									    				 sectionBox.setDisabled(true);
									    				 
									    				 form.down('customcombobox#courseSection_Id_1').setDisabled(false);
									    				 form.down('#multiselectSection_Id_1').setDisabled(false);
									    				 
									    				 var sectionStore = this$.getStore('attendance.SectionAndFacultyByPeriodID');
									    				 sectionStore.getProxy().extraParams = {
									    					 periodId:periodId
									    				 };
									    				 sectionStore.load();

									    				 /*
													   form.down("#courseId").setDisabled(false);
													   var store = this$.getStore('attendance.SectionByCourseNComponent');
													   store.getProxy().extraParams = {
														   parentCourseId: records[0].get('id')
													   };
													   store.load({
														   callback: function(records, operation, success) {
															   if (success) {
																   if(records.length==1){
																	   form.down("#courseSection_Id").setValue(records[0].data.id);
																   }
															   }
														   }
													   });

												 */  }else{
													   form.down('#periodId').setVisible(true); 
												   }
											   }
										   }
									   });
								   }
							   }
						   }
					   });

    				 var courseBox = this.getCoursetrackersearch().down('customcombobox#courseId_1');
    				 var courseComponentBox = this.getCoursetrackersearch().down('customcombobox#componentSectionId_1');
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1');
    				 var periodBox = this.getCoursetrackersearch().down('customcombobox#periodId');
    				 courseBox.clearValue();
    				 courseComponentBox.clearValue();
    				 sectionBox.clearValue();
    				 periodBox.clearValue();
    				 courseBox.setDisabled(true);
    				 courseComponentBox.setDisabled(true);
    				 sectionBox.setDisabled(true);
    				 periodBox.setDisabled(true);
    			 }
    		 }, 'coursetrackersearch customcombobox#batchId' : {
    			 select : function(obj, record) {
    				 this$=this;
    				 var batch_Id = record[0].get("id");
    				 var form = this.getCoursetrackersearch();
    				 var periodComboBox = this.getCoursetrackersearch().down('customcombobox#periodId');
    				 periodComboBox.clearValue();
    				 periodComboBox.setDisabled(false);
    				 var periodStore = periodComboBox.getStore();
    				 periodStore.getProxy().extraParams = {
    					 id: batch_Id
    				 };
    				 periodStore.load({

						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==0){
									   if(wheatherSchool) {
										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

									   } 
								   }
								   else if(records.length==1){
									     form.down("#periodId").setValue(records[0].get('id'));
									     var periodId = records[0].get("id");
					    				 var programCourseComboBox = form.down('customcombobox#courseId_1');
					    				 var multiselectCourseComboBox = form.down('#multiselectCourseId');
					    				 programCourseComboBox.clearValue();
					    				 programCourseComboBox.setDisabled(false);
					    				 multiselectCourseComboBox.setDisabled(false);
					    				 var programBatchStore =programCourseComboBox.getStore(); 
					    				 programBatchStore.getProxy().extraParams = {	
					    					 periodId: periodId,
					    					 sectionType : 'ProgramBatchSection'
					    				 };
					    				 programBatchStore.load();
					    				 var courseComponentBox = form.down('customcombobox#componentSectionId_1');
					    				 var sectionBox = form.down('customcombobox#courseSection_Id_1');
					    				 courseComponentBox.clearValue();
					    				 sectionBox.clearValue();
					    				 courseComponentBox.setDisabled(true);
					    				 sectionBox.setDisabled(true);
					    				 
					    				 form.down('customcombobox#courseSection_Id_1').setDisabled(false);
					    				 form.down('#multiselectSection_Id_1').setDisabled(false);
					    				 
					    				 var sectionStore = this$.getStore('attendance.SectionAndFacultyByPeriodID');
					    				 sectionStore.getProxy().extraParams = {
					    					 periodId:periodId
					    				 };
					    				 sectionStore.load();

					    				 /*
									   form.down("#courseId").setDisabled(false);
									   var store = this$.getStore('attendance.SectionByCourseNComponent');
									   store.getProxy().extraParams = {
										   parentCourseId: records[0].get('id')
									   };
									   store.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==1){
													   form.down("#courseSection_Id").setValue(records[0].data.id);
												   }
											   }
										   }
									   });

								 */  }else{
									   form.down('#periodId').setVisible(true); 
								   }
							   }
						   }
					   
    				 });
    				 var courseBox = this.getCoursetrackersearch().down('customcombobox#courseId_1');
    				 var courseComponentBox = this.getCoursetrackersearch().down('customcombobox#componentSectionId_1');
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1');
    				 courseBox.clearValue();
    				 courseComponentBox.clearValue();
    				 sectionBox.clearValue();
    				 courseBox.setDisabled(true);
    				 courseComponentBox.setDisabled(true);
    				 sectionBox.setDisabled(true);
    			 }
    		 },
    		 'coursetrackersearch customcombobox#periodId' : {
    			 select : function(obj, record) {
    				 var period_Id = record[0].get("id");
    				 var programCourseComboBox = this.getCoursetrackersearch().down('customcombobox#courseId_1');
    				 var multiselectCourseComboBox = this.getCoursetrackersearch().down('#multiselectCourseId');
    				 programCourseComboBox.clearValue();
    				 programCourseComboBox.setDisabled(false);
    				 multiselectCourseComboBox.setDisabled(false);
    				 var programBatchStore =programCourseComboBox.getStore(); 
    				 programBatchStore.getProxy().extraParams = {	
    					 periodId: period_Id,
    					 sectionType : 'ProgramBatchSection'
    				 };
    				 programBatchStore.load();
    				 var courseComponentBox = this.getCoursetrackersearch().down('customcombobox#componentSectionId_1');
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1');
    				 courseComponentBox.clearValue();
    				 sectionBox.clearValue();
    				 courseComponentBox.setDisabled(true);
    				 sectionBox.setDisabled(true);
    				 
    				 this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1').setDisabled(false);
    				 this.getCoursetrackersearch().down('#multiselectSection_Id_1').setDisabled(false);
    				 
    				 var sectionStore = this.getStore('attendance.SectionAndFacultyByPeriodID');
    				 sectionStore.getProxy().extraParams = {
    					 periodId:period_Id
    				 };
    				 sectionStore.load();
    			 }
    		 },
    		 'coursetrackersearch customcombobox#courseId_1' : {
    			 select : function(obj, record) {
    				 var courseId = record[0].get("id");
    				 var courseComponentBox = this.getCoursetrackersearch().down('customcombobox#componentSectionId_1');
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1');
    				 courseComponentBox.clearValue();
    				 sectionBox.clearValue();
    				 
    				/* if(record[0].get("sectionAtComponentLevel")){
    					 courseComponentBox.show();
    					 courseComponentBox.setDisabled(false);
    					 sectionBox.setDisabled(true);
    					 var store = courseComponentBox.getStore();
    					 store.getProxy().extraParams = {
    						 id: courseId
    					 };
    					 store.load();
    				 }
    				 else{
    					 var courseComboBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1');
    					 var multipleSectionComboBoxPBS = this.getCoursetrackersearch().down('customcombobox#multiselectSection_Id_1');
    					 courseComboBox.clearValue();
    					 courseComponentBox.hide();
    					 sectionBox.setDisabled(false);
    					 multipleSectionComboBoxPBS.setDisabled(false);
    					 var courseStore = courseComboBox.getStore();
    					 var periodId = this.getCoursetrackersearch().getForm().findField('period').getValue();
    					 courseStore.getProxy().extraParams = {
    						 courseId: courseId,
    						 periodId : periodId
    					 };
    					 courseStore.load();
    				 }*/
    				 
    				 var topicsBox = this.getCoursetrackersearch().down('customcombobox#topicsId');
    				 var multipleTopicsComboBox = this.getCoursetrackersearch().down('#multipleTopicsId');
    				 topicsBox.clearValue();
    				 topicsBox.setDisabled(false);
    				 multipleTopicsComboBox.setDisabled(false);
					 var topicStore = topicsBox.getStore();
					 topicStore.getProxy().extraParams = {
						 courseId: courseId
					 };
					 topicStore.load();
    				 
    			 }
    		 },
    		 'coursetrackersearch customcombobox#componentSectionId_1' : {
    			 select : function(obj, record) {
    				 var componentId = record[0].get("id");
    				 var periodId = this.getCoursetrackersearch().getForm().findField('period').getValue();
    				 var courseId = this.getCoursetrackersearch().getForm().findField('course_1').getValue();
    				 var sectionBox = this.getCoursetrackersearch().down('customcombobox#courseSection_Id_1');
    				 sectionBox.setDisabled(false);
    				 sectionBox.clearValue();
    				 var sectionStore = sectionBox.getStore();
    				 sectionStore.getProxy().extraParams = {
    					 courseId: courseId,
    					 periodId : periodId,
    					 componentId : componentId
    				 };
    				 sectionStore.load();
    			 }
    		 },
    		 'coursetrackersearch button[itemId=resetBtn]' : {
    			 click : function(){
    				 this.resetCourseTracker();
    			 }
    		 },
    		 'coursetrackersearch button[itemId=quickSearchId]' : {
    			 click : function(){
    				 this.searchCourseTracker();
    			 }
    		 },
    		 'coursetrackergrid':{
    			 render:function(grid){	
   				  this.doAccessControlValidation(grid, this.getCOURSE_TRACKER_PERMISSIONS());
   			  },
    			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				 var searchResultGrid = this.getCoursetrackergrid();
    				 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
    				 if(columnName=='name'){
    				 if (e.target.tagName == 'A') {
    				 	this.showActualPlannedData(grid,td, cellIndex, record, tr, rowIndex, e, eOpts );
    				 }
//    				 this.showActualPlannedWindow();
    				 }
    			 }
    		 }
        });
    },
changeSectionType : function(){
	var $this = this;
	var form = $this.getCoursetrackersearch();
	
	 var programBatchPeriodContainer = form.down('fieldcontainer#programBatchPeriodContainer');
	 var courseComponentSectionContainerPBS = form.down('fieldcontainer#courseComponentSectionContainer_1');
	 var courseComponentSectionContainerCBS = form.down('fieldcontainer#courseComponentSectionContainer');

	 var programComboBox = form.down('customcombobox#programId');
	 var batchComboBox = form.down('customcombobox#batchId');
	 var periodComboBox = form.down('customcombobox#periodId');

	 var courseComboBoxCBS = form.down('customcombobox#courseId');
	 var componentComboBoxCBS = form.down('customcombobox#componentSectionId');
	 var sectionComboBoxCBS = form.down('customcombobox#courseSection_Id');
	 var multipleSectionComboBoxCBS = form.down('#multipleCourseSection_Id');

	 var courseComboBoxPBS = form.down('customcombobox#courseId_1');
	 var componentComboBoxPBS = form.down('customcombobox#componentSectionId_1');
	 var sectionComboBoxPBS = form.down('customcombobox#courseSection_Id_1');
	 var multipleCourseComboBoxPBS = form.down('#multiselectCourseId');
	 var multipleSectionComboBoxPBS = form.down('#multiselectSection_Id_1');
	 
	 var topicComboBox = form.down('customcombobox#topicsId');
	 
	 var fromDateField = form.down('datefield#fromDate_Id');
	 var toDateField =  form.down('datefield#toDate_Id');
	 
	 var multiselectRadioFields = form.down('combobox#selectionGroupId');
	 
	 var multipleTopicsComboBox = form.down('#multipleTopicsId');
	 
	 var chartStore = $this.getStore('coursetracker.CourseTrackerChart');
	 
		var strucutureForm = this.getCoursechartndisplaystructure();
		var display  = strucutureForm.down('#dynamicDisplayFieldId');
	 
		var sectionType = form.getForm().findField('sectionType').getValue();
		
	 if(!sectionType){
		 chartStore.removeAll();
		 display.setValue('');
		// multiselectRadioFields.reset();
		// multiselectRadioFields.items.items[0].setVisible(false);
		 programBatchPeriodContainer.hide();
		 courseComponentSectionContainerPBS.hide();
		 courseComponentSectionContainerCBS.show();

		 programComboBox.clearValue();
		 programComboBox.allowBlank=true;
		 batchComboBox.clearValue();
		 batchComboBox.allowBlank=true;
		 periodComboBox.clearValue();
		 periodComboBox.allowBlank=true;
		 courseComboBoxPBS.clearValue();
		 courseComboBoxPBS.allowBlank=true;
		 componentComboBoxPBS.clearValue();
		 sectionComboBoxPBS.clearValue();
		 courseComboBoxCBS.allowBlank=false;
		 multipleSectionComboBoxCBS.clearValue();
		 multipleSectionComboBoxCBS.setVisible(false);
		 sectionComboBoxCBS.setVisible(true);
		 
		 topicComboBox.clearValue();
		 topicComboBox.setVisible(true);
		 multipleTopicsComboBox.setVisible(false);
		 multipleTopicsComboBox.clearValue();
		 
		 
		 fromDateField.reset();
		 toDateField.reset();

		 componentComboBoxCBS.hide();
		 topicComboBox.setDisabled(true);
		 sectionComboBoxCBS.setDisabled(true);
	 }
	 else{
		 display.setValue('');
		 chartStore.removeAll();
		// multiselectRadioFields.reset();
		 //multiselectRadioFields.items.items[0].setVisible(true);
		 programBatchPeriodContainer.show();
		 courseComponentSectionContainerPBS.show();
		 courseComponentSectionContainerCBS.hide();

		 courseComboBoxCBS.clearValue();
		 componentComboBoxCBS.clearValue();
		 sectionComboBoxCBS.clearValue();
		 componentComboBoxPBS.hide();
		 
		 topicComboBox.clearValue();
		 multipleTopicsComboBox.clearValue();
		 
		 fromDateField.reset();
		 toDateField.reset();
		 
		 topicComboBox.setDisabled(true);
		 batchComboBox.setDisabled(true);
		 periodComboBox.setDisabled(true);
		 courseComboBoxPBS.setDisabled(true);
		 componentComboBoxPBS.setDisabled(true);
		 sectionComboBoxPBS.setDisabled(true);
		 courseComboBoxCBS.allowBlank=true;
		 var alinfomodel = Academia.model.authentication.ALInfoModel;
		 var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				periodComboBox.hide();
			}
		 periodComboBox
		 courseComboBoxPBS.setVisible(true);
		 courseComboBoxPBS.clearValue();
		 multipleCourseComboBoxPBS.setVisible(false);
		 multipleCourseComboBoxPBS.clearValue();
		 
		 sectionComboBoxPBS.setVisible(true);
		 sectionComboBoxPBS.clearValue();
		 multipleSectionComboBoxPBS.setVisible(false);
		 multipleSectionComboBoxPBS.clearValue();
	     multipleCourseComboBoxPBS.allowBlank=true;
		 
		 
		 programComboBox.allowBlank=false;
		 programComboBox.setFieldLabel(getCommonTranslation('PROGRAM')+'<span class="required" style="color:red"> *</span>');	
		 
		 batchComboBox.allowBlank=false;
		 batchComboBox.setFieldLabel(getCommonTranslation('BATCH')+'<span class="required" style="color:red"> *</span>');
		 
		 periodComboBox.allowBlank=false;
		 periodComboBox.setFieldLabel(getCommonTranslation('PERIOD')+'<span class="required" style="color:red"> *</span>');
		 
		 courseComboBoxPBS.allowBlank=false;
		 courseComboBoxPBS.setFieldLabel(getCommonTranslation('COURSE')+'<span class="required" style="color:red"> *</span>');
		 
		 var academyLocationId = this.getCurrentAcademyLocation();
		 var programStore = programComboBox.getStore();
		 programStore.getProxy().extraParams = {
			 academyLocationId : academyLocationId
		 };
	 }
},
	multiselectFields:function(cb){
	 var form = this.getCoursetrackersearch();
		var sectionType = form.getForm().findField('sectionType').getValue();
		var sectionComboBoxCBS = form.down('customcombobox#courseSection_Id');
		var multipleSectionComboBoxCBS = form.down('#multipleCourseSection_Id');
		
		var periodComboBoxCBS = form.down('customcombobox#periodId');
		var courseComboBoxCBS = form.down('customcombobox#courseId');
		
		 var courseComboBoxPBS = form.down('customcombobox#courseId_1');
		 var sectionComboBoxPBS = form.down('customcombobox#courseSection_Id_1');
		 var topicsComboBox = form.down('customcombobox#topicsId');
		
		 var multipleCourseComboBoxPBS = form.down('#multiselectCourseId');
		 var multipleSectionComboBoxPBS = form.down('#multiselectSection_Id_1');
		 var multipleTopicsComboBox = form.down('#multipleTopicsId');
		
		if(!sectionType){

			 if(cb.getValue() =='Section'){
				courseComboBoxCBS.clearValue();
				 
				sectionComboBoxCBS.setVisible(false);
				
				sectionComboBoxCBS.clearValue();
				multipleSectionComboBoxCBS.setVisible(true);
				multipleSectionComboBoxCBS.setDisabled(true);
				
				topicsComboBox.setVisible(true);
				topicsComboBox.setDisabled(true);
				
				multipleTopicsComboBox.setVisible(false);
				//multipleTopicsCommultiselectFieldsboBox.clearValue();
				form.down('#programId').clearValue();
				form.down('#batchId').clearValue();
				
			}else if(cb.getValue()=='Topic'){
				courseComboBoxCBS.clearValue();
				
				topicsComboBox.setVisible(false);
				topicsComboBox.clearValue();
				
				multipleTopicsComboBox.setDisabled(true);
				multipleTopicsComboBox.setVisible(true);
				
				sectionComboBoxCBS.setVisible(true);
				sectionComboBoxCBS.setDisabled(true);
				sectionComboBoxCBS.clearValue();
				multipleSectionComboBoxCBS.setVisible(false);
				multipleSectionComboBoxCBS.clearValue();
				form.down('#programId').clearValue();
				form.down('#batchId').clearValue();
			} else {
				courseComboBoxCBS.clearValue();
			}
		
	}else{
		
		if(cb.getValue() =='Course'){
			periodComboBoxCBS.clearValue();
			
			courseComboBoxPBS.setVisible(false);
			courseComboBoxPBS.allowBlank=true;
			courseComboBoxPBS.clearValue();
			multipleCourseComboBoxPBS.setVisible(true);
			multipleCourseComboBoxPBS.setDisabled(true);
			multipleCourseComboBoxPBS.allowBlank=false;
			multipleCourseComboBoxPBS.setFieldLabel(getCommonTranslation('COURSE')+'<span class="required" style="color:red"> *</span>');
			
			sectionComboBoxPBS.setVisible(true);
			sectionComboBoxPBS.setDisabled(true);
			sectionComboBoxPBS.clearValue();
			multipleSectionComboBoxPBS.setVisible(false);
			multipleSectionComboBoxPBS.clearValue();
			
			topicsComboBox.setVisible(false);
			multipleTopicsComboBox.setVisible(false);
			topicsComboBox.clearValue();
			multipleTopicsComboBox.clearValue();
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				form.down('#periodId').hide();
			}
			form.down('#programId').clearValue();
			form.down('#batchId').clearValue();
			form.down('#batchId').setDisabled(true);
			periodComboBoxCBS.setDisabled(true);
			
			
		}else if(cb.getValue() =='Section'){
			courseComboBoxPBS.clearValue();
			periodComboBoxCBS.clearValue();
			
			courseComboBoxPBS.setVisible(true);
			multipleCourseComboBoxPBS.setVisible(false);
			multipleCourseComboBoxPBS.allowBlank=true;
			multipleCourseComboBoxPBS.clearValue();
			
			sectionComboBoxPBS.setVisible(false);
			sectionComboBoxPBS.clearValue();
			multipleSectionComboBoxPBS.setVisible(true);
			multipleSectionComboBoxPBS.setDisabled(true);
			
			topicsComboBox.setVisible(true);
			topicsComboBox.setDisabled(true);
			multipleTopicsComboBox.setVisible(false);
			multipleTopicsComboBox.clearValue();
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				form.down('#periodId').hide();
			}
			form.down('#programId').clearValue();
			form.down('#batchId').clearValue();
			form.down('#batchId').setDisabled(true);
			periodComboBoxCBS.setDisabled(true);
			
		}else if(cb.getValue() =='Topic'){
			courseComboBoxPBS.clearValue();
			periodComboBoxCBS.clearValue();
			
			topicsComboBox.setVisible(false);
			topicsComboBox.clearValue();
			multipleTopicsComboBox.setDisabled(true);
			multipleTopicsComboBox.setVisible(true);
			
			courseComboBoxPBS.setVisible(true);
			multipleCourseComboBoxPBS.setVisible(false);
			multipleCourseComboBoxPBS.clearValue();
			
			sectionComboBoxPBS.setVisible(true);
			sectionComboBoxPBS.setDisabled(true);
			sectionComboBoxPBS.clearValue();
			multipleSectionComboBoxPBS.setVisible(false);
			multipleCourseComboBoxPBS.allowBlank=true;
			multipleSectionComboBoxPBS.clearValue();	
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			if(wheatherSchool){
				form.down('#periodId').hide();
			}
			form.down('#programId').clearValue();
			form.down('#batchId').clearValue();
			form.down('#batchId').setDisabled(true);
			periodComboBoxCBS.setDisabled(true);
		}
		
	}
},
resetCourseTracker:function(){
	this.getCoursetrackersearch().getForm().reset();
	var form = this.getCoursetrackersearch();
	var courseComboBoxPBS = form.down('customcombobox#courseId_1');
	var sectionComboBoxPBS = form.down('customcombobox#courseSection_Id_1');
	var topicsComboBox = form.down('customcombobox#topicsId');

	/**
	 *  for PBS
	 */
	
	var multipleCourseComboBoxPBS = form.down('#multiselectCourseId');
	var multipleSectionComboBoxPBS = form.down('#multiselectSection_Id_1');
	var multipleTopicsComboBox = form.down('#multipleTopicsId');

	multipleCourseComboBoxPBS.setVisible(false);
	multipleCourseComboBoxPBS.clearValue();
	multipleSectionComboBoxPBS.setVisible(false);
	multipleSectionComboBoxPBS.clearValue();
	multipleTopicsComboBox.setVisible(false);
	multipleTopicsComboBox.clearValue();
	multipleTopicsComboBox.setDisabled(true);
	courseComboBoxPBS.setVisible(true);
	courseComboBoxPBS.setDisabled(true);
	sectionComboBoxPBS.setVisible(true);
	sectionComboBoxPBS.setDisabled(true);
	topicsComboBox.setVisible(true);
	form.down('#batchId').clearValue();
	form.down('#batchId').setDisabled(true);
	form.down('#periodId').setDisabled(true);
	form.down('#topicsId').setDisabled(true);
	
/**
 *  for CBS
 */
	var sectionComboBoxCBS = form.down('customcombobox#courseSection_Id');
	var multipleSectionComboBoxCBS = form.down('#multipleCourseSection_Id');
	sectionComboBoxCBS.setVisible(true);
	sectionComboBoxCBS.setDisabled(true);
	multipleSectionComboBoxCBS.setVisible(false);
	multipleSectionComboBoxCBS.clearValue();	
},
searchCourseTracker:function(){
	var $this = this;
	var form = $this.getCoursetrackersearch().getForm();
	var values = form.getValues();
	
	var multiselectTopics = form.findField('multiselectTopics').getValue();
	
	/*** for multiple topics ***/
     var multiTopicsData;
     var multiTopicsArrayData=[];
     for(var i in multiselectTopics){
         if(Ext.isObject(multiselectTopics[0])){
        	 multiTopicsData = multiselectTopics[i].get("id");
        	 multiTopicsArrayData.push(multiTopicsData);
         }else{
        	 multiTopicsData = multiselectTopics[i];
        	 multiTopicsArrayData.push(multiTopicsData);
         }
     }
	
	var topics =[];
	if(multiTopicsArrayData.length > 0){
		for(var i=0; i<multiTopicsArrayData.length;i++){
			topics.push(multiTopicsArrayData[i]);
		}
	}else if(values.topics !="" && values.topics !=null  ){
		topics.push(values.topics);
	}else{
		topics.push(0);
	}
	
	var startDate;
	if(values.fromDate !="" && values.fromDate !=null && values.fromDate !=undefined){
		startDate = values.fromDate;
	}else{
		startDate = null;
	}
	
	var endDate;
	if(values.toDate !="" && values.toDate !=null && values.toDate !=undefined){
		endDate = values.toDate;
	}else{
		endDate = null;
	}
	
	
	if(values.sectionType == 'CBS'){
		
		var courseId = form.findField('course').getValue();
		var courseSection = form.findField('section').getValue();
		var multiselectSectionCBS = form.findField('multiselectSectionCBS').getValue();
		var periodId = null;
		
	    var multiSectionData;
	    var multiSectionArrayData=[];
		  
	    if(multiselectSectionCBS !="" && multiselectSectionCBS !=null){
		for(var i in multiselectSectionCBS){
	        if(Ext.isObject(multiselectSectionCBS[0])){
	        	multiSectionData = multiselectSectionCBS[i].get("sectionId");
	        	multiSectionArrayData.push(multiSectionData);
	        }else{
	        	multiSectionData = multiselectSectionCBS[i];
	        	multiSectionArrayData.push(multiSectionData);
	        }
	     }
	    }	
		
		var section =[];
		if(multiSectionArrayData.length > 0){
			for(var i=0; i<multiSectionArrayData.length;i++){
				section.push(multiSectionArrayData[i]);
			}
		}else{
			section.push(courseSection);
		}
		
		var course = [];
		course.push(courseId);
		
		var courseTrackerGetData = {
				"courses": course,//[14],
				"sections": section,//[14,15],
				"topics": topics,
				"startDate": startDate,
				"endDate": endDate,
				"periodId":periodId
		};

		submitUrl = SERVERURL.COURSE_PROGRESS_TRACKER_GET_DATA;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : courseTrackerGetData,
			method : 'POST',
			success : function(form, action) {
				 Ext.getBody().unmask();
				var getData = Ext.JSON.decode(form.responseText);
				var store = $this.getStore('coursetracker.CourseTrackerChart');
				if(getData.length > 0 && getData !=null){
					var getDataArray = [];
					for(var i in getData){
						getDataArray.push({
							"id" : getData[i].id,
							"name" : getData[i].name,
							"planned":getData[i].planned,
							"actual":getData[i].actual,
							"courses" : getData[i].courses,
							"sections":getData[i].sections,
							"topics":getData[i].topics,
							"startDate": getData[i].startDate,
							"endDate": getData[i].endDate,
							"keyType": getData[i].keyType
						});
						
						
						store.removeAll();
						store.loadRawData(getDataArray,true);	
					}
				}else{
					store.removeAll();
				}
			}
		});
		
		var strucutureForm = this.getCoursechartndisplaystructure();
		var display  = strucutureForm.down('#dynamicDisplayFieldId');
//		
		var program = form.findField('program').getRawValue();
		var batch = form.findField('batch').getRawValue();
		var period = form.findField('period').getRawValue();
		
		var SectionCBS = form.findField('multiselectSectionCBS');
		var topicsCommon = form.findField('multiselectTopics');
		
		var test;
		if(!SectionCBS.isHidden()){
			test =form.findField('course').getRawValue();
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period + ''+getCommonTranslation('COURSE')+' '+test);
		}else if(!topicsCommon.isHidden()){
			test =form.findField('course').getRawValue();
			var courseSection = form.findField('section').getRawValue();			
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period + ''+getCommonTranslation('COURSE')+' '+test+' '+getCommonTranslation('SECTION')+' '+courseSection);
		}else{
			test =form.findField('course').getRawValue();
			var courseSection = form.findField('section').getRawValue();	
			var topicName = form.findField('topics').getRawValue();
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period + ''+getCommonTranslation('COURSE')+' '+test+' '+getCommonTranslation('SECTION')+' '+courseSection +' '+getCommonTranslation('TOPIC')+' '+topicName);
			
		}
		
	}else{

		var courseIdPBS = form.findField('course_1').getValue();
		var multiselectCoursePBS = form.findField('multiselectCoursePBS').getValue();

		var multiCourseData;
		var multiCourseArrayData=[];

		if(multiselectCoursePBS !="" && multiselectCoursePBS !=null){
			for(var i in multiselectCoursePBS){
				if(Ext.isObject(multiselectCoursePBS[0])){
					multiCourseData = multiselectCoursePBS[i].get("id");
					multiCourseArrayData.push(multiCourseData);
				}else{
					multiCourseData = multiselectCoursePBS[i];
					multiCourseArrayData.push(multiCourseData);
				}
			}
		}	

		var coruseIds =[];
		if(multiCourseArrayData.length > 0){
			for(var i=0; i<multiCourseArrayData.length;i++){
				coruseIds.push(multiCourseArrayData[i]);
			}
		}else{
			coruseIds.push(courseIdPBS);
		}

		var section_1 = form.findField('section_1').getValue();
		var periodId = form.findField('period').getValue();
		var multiselectSection_1PBS = form.findField('multiselectSection_1PBS').getValue();
		
		var multiSectionPBSData;
		var multiSectionPBSArrayData=[];

		if(multiselectSection_1PBS !="" && multiselectSection_1PBS !=null){
			for(var i in multiselectSection_1PBS){
				if(Ext.isObject(multiselectSection_1PBS[0])){
					multiSectionPBSData = multiselectSection_1PBS[i].get("sectionId");
					multiSectionPBSArrayData.push(multiSectionPBSData);
				}else{
					multiSectionPBSData = multiselectSection_1PBS[i];
					multiSectionPBSArrayData.push(multiSectionPBSData);
				}
			}
		}	

		var sectionPBS =[];
		if(multiSectionPBSArrayData.length > 0){
			for(var i=0; i<multiSectionPBSArrayData.length;i++){
				sectionPBS.push(multiSectionPBSArrayData[i]);
			}
		}else if(section_1 != null && section_1){
			sectionPBS.push(section_1);
		}


		var courseTrackerGetData = {
				"courses": coruseIds,//[14],
				"sections": sectionPBS,//[14,15],
				"topics": topics,
				"startDate": startDate,
				"endDate": endDate,
				"periodId":periodId
		};

		submitUrl = SERVERURL.COURSE_PROGRESS_TRACKER_GET_DATA;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : courseTrackerGetData,
			method : 'POST',
			success : function(form, action) {
				 Ext.getBody().unmask();
				var getData = Ext.JSON.decode(form.responseText);
				var store = $this.getStore('coursetracker.CourseTrackerChart');
				if(getData.length > 0 && getData !=null){
					var getDataArray = [];
					for(var i in getData){
						getDataArray.push({
							"id":getData[i].id,
							"name" : getData[i].name,
							"planned":getData[i].planned,
							"actual":getData[i].actual,
							"courses" : getData[i].courses,
							"sections":getData[i].sections,
							"topics":getData[i].topics,
							"startDate": getData[i].startDate,
							"endDate": getData[i].endDate,
							"keyType": getData[i].keyType
						});
						
						
						store.removeAll();
						store.loadRawData(getDataArray,true);	
					}
				}else{
					store.removeAll();
				}
			}
		});
		
		
		var strucutureForm = this.getCoursechartndisplaystructure();
		var display  = strucutureForm.down('#dynamicDisplayFieldId');
		
		var program = form.findField('program').getRawValue();
		var batch = form.findField('batch').getRawValue();
		var period = form.findField('period').getRawValue();
		
		var CoursePBS = form.findField('multiselectCoursePBS');
		var SectionPBS = form.findField('multiselectSection_1PBS');
		var topicsCommon = form.findField('multiselectTopics');
		
		var test;
		if(!CoursePBS.isHidden()){
			test =form.findField('section_1').getRawValue();
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period +' '+getCommonTranslation('SECTION')+' '+test);
		}else if(!SectionPBS.isHidden()){
			test =form.findField('course_1').getRawValue();
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period +' '+getCommonTranslation('COURSE')+' '+test);
		}else if(!topicsCommon.isHidden()){
			test =form.findField('course_1').getRawValue();
			test1 =form.findField('section_1').getRawValue();
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period +' '+getCommonTranslation('COURSE')+' '+test+' '+getCommonTranslation('SECTION')+' '+test1);	
		}else{
			test =form.findField('course_1').getRawValue();
			test1 =form.findField('section_1').getRawValue();
			topicName = form.findField('topics').getRawValue();
			display.setValue(getCommonTranslation('THIS_PROGRAM')+' '+program +' '+getCommonTranslation('BATCH')+' '+batch+' '+getCommonTranslation('PERIOD')+' '+period +' '+getCommonTranslation('COURSE')+' '+test+' '+getCommonTranslation('SECTION')+' '+test1+' '+getCommonTranslation('TOPIC')+' '+topicName );
		}
     }
},
showActualPlannedData:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts){
	var $this=this;
	var searchResultGrid = $this.getCoursetrackergrid();
	var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

	var form = $this.getCoursetrackersearch();
	var values = form.getValues();
	//var sectionType = form.getForm().findField('sectionType').getValue();


	if (searchResultGrid.getSelectionModel().getCount() > 0) {
		var records = searchResultGrid.getSelectionModel().getSelection();
		if (records != undefined && records != ""&& records != null) {

			var id = records[0].data.id;
			var keyType = records[0].data.keyType;

			var	course_1 = values.course_1;
			var	topics = values.topics;
			var	section_1 = values.section_1;
			var	course = values.course;
			var	section= values.section;

			var	fromDate= values.fromDate;
			var	toDate= values.toDate;
			
			var startDate;
			if(!isNullOrEmpty(fromDate)){
				startDate = fromDate;
			}else{
				startDate = null;
			}
			
			var endDate;
			if(!isNullOrEmpty(toDate)){
				endDate = toDate;
			}else{
				endDate = null;
			}
			
//			var	course_1 = values.course_1;
			
			if(columnName=='name'){
				
				//if(sectionType){
				if(values.sectionType == 'PBS'){
					
					if(keyType == 'section' || keyType == 'Section'){
						
						
						var store=$this.getStore('coursetracker.ActulalPlanned');
						store.getProxy().extraParams = {
							courseId: course_1,
							sectionId:id,
							topicId:topics,
							startDate:startDate,
							endDate:endDate	
						};
						store.load();
						
						var store=$this.getStore('coursetracker.PlannedStore');
						store.getProxy().extraParams = {
							courseId: course_1,
							sectionId:id,
							topicId:topics,
							startDate:startDate,
							endDate:endDate	
						};
						store.load();
						this.showActualPlannedWindow();
						
				}else if(keyType == 'Course' || keyType == 'course'){
					
					var store=$this.getStore('coursetracker.ActulalPlanned');
					store.getProxy().extraParams = {
						courseId: id,
						sectionId:section_1,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					var store=$this.getStore('coursetracker.PlannedStore');
					store.getProxy().extraParams = {
						courseId: id,
						sectionId:section_1,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					this.showActualPlannedWindow();
				}else if(keyType == 'Topic' || keyType == 'topic'){
					
					var store=$this.getStore('coursetracker.ActulalPlanned');
					store.getProxy().extraParams = {
						courseId: course_1,
						sectionId:section_1,
						topicId:id,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					var store=$this.getStore('coursetracker.PlannedStore');
					store.getProxy().extraParams = {
						courseId: course_1,
						sectionId:section_1,
						topicId:id,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					this.showActualPlannedWindow();
				}else{
					
					var store=$this.getStore('coursetracker.ActulalPlanned');
					store.getProxy().extraParams = {
						courseId: course_1,
						sectionId:section_1,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					var store=$this.getStore('coursetracker.PlannedStore');
					store.getProxy().extraParams = {
						courseId: course_1,
						sectionId:section_1,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					this.showActualPlannedWindow();
				};
			}else{
				
				if(keyType == 'Section' || keyType == 'section'){
					
					var store=$this.getStore('coursetracker.ActulalPlanned');
					store.getProxy().extraParams = {
						courseId: course,
						sectionId:id,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					var store=$this.getStore('coursetracker.PlannedStore');
					store.getProxy().extraParams = {
						courseId: course,
						sectionId:id,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					this.showActualPlannedWindow();
					
				}else if(keyType == 'Topic' || keyType == 'topic'){
					var store=$this.getStore('coursetracker.ActulalPlanned');
					store.getProxy().extraParams = {
						courseId: course,
						sectionId:section,
						topicId:id,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					var store=$this.getStore('coursetracker.PlannedStore');
					store.getProxy().extraParams = {
						courseId: course,
						sectionId:section,
						topicId:id,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					this.showActualPlannedWindow();						
				}else{
					
					var store=$this.getStore('coursetracker.ActulalPlanned');
					store.getProxy().extraParams = {
						courseId: course,
						sectionId:section,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					
					var store=$this.getStore('coursetracker.PlannedStore');
					store.getProxy().extraParams = {
						courseId: course,
						sectionId:section,
						topicId:topics,
						startDate:startDate,
						endDate:endDate
					};
					store.load();
					this.showActualPlannedWindow();
					
				}
			}; 	
				
			};
			
		};
	};
},
showActualPlannedWindow:function(){
	var $this =this;
	var formWindow = $this.getActulaplannedview();
	if (!formWindow) {
		Ext.widget('actulaplannedview');
		formWindow = $this.getActulaplannedview();
	}
	formWindow.show();	
}
});