/**
 * 
 *  @author Deepak Motlani
 *  @author Bhanu PS
 */
Ext.define('Academia.controller.coursetransaction.sectioncoursecoverageplan.MasterTimeTableController', {
	extend : 'Academia.controller.base.BaseController',
	//models : [],
	stores : ['coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar','attendance.SectionAndFacultyByPeriodID',
	          'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.PeriodSection',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.VariantBySection',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.PeriodsByCalendar',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.RoomByCalendar',
	          'calendar.AccessibleCalendarStore','common.ProgramByAcademyLocationStore',
	          'enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.StudentCourses','course.coursetopic.CourseComponentStore','attendance.SectionByCourseNComponent',
	          'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
	          'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore','importutility.ModuleName','common.ActiveUserStore',
	          'program.programDetails.programBatches.courseParameter.FacultyCombo','coursetransaction.homework.assignmentdetails.Faculty',
	          'importutility.ImportTimeTable','coursetransaction.sectioncoursecoverageplan.mastertimetable.CourseByCalendar',
	          'coursetransaction.facultytopicassignment.FacultyDetails','program.ProgramCodeOrNameSmartSearch',
	          'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom','program.programDetails.programBatches.courseParameter.TimeTableProgramBatchGridStore',
	          'facilitiesresources.resourcemaster.MappedCalenderStore','course.SectionTypeStore','common.AcademicTermStore',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.DayWiseMasterTimeTableStore',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.CycleWorkingDays','course.SectionTypeForExtendTimetableStore',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.WorkingWeekday','importutility.ImportXMLTimeTable','coursetransaction.facultytopicassignment.ParameterizedFaculties','common.ParameterizedProgramBatchPeriodStore',
	          'importutility.ImportExtendedTimeTable','setup.templatemapping.TemplateNameForFoils','program.programDetails.programBatches.courseParameter.ParamatrizedFacultyDepartement','user.UserAcademyLocationStore','facilitiesresources.resourcemaster.MappedCalenderStore',
	          'importutility.ImportExtendedTimeTableUploadGidStore','importutility.UploadExtendedTimeTable'
	          ],
	views : ['coursetransaction.sectioncoursecoverageplan.TimeTableStructure',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterSearchFilter',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableCalendar',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableDetailedWindow',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.UploadTemplate',
	         'importutility.ImportByModule.ImportListTimeTable',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableForm',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableSession',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchTimeTable',
	         'coursetransaction.sectioncoursecoverageplan.ProgramCourseFilters',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.TimeTableProgamBatchGrid',
	         'Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.UploadTemplateStructure',
	         'UploadOptionRadioGroup',
	         'coursetransaction.sectioncoursecoverageplan.mastertimetable.CreateMasterTimeTableGrid',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.DayWiseMasterTimeTableStructure',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.ExtendMasterTimeTable',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.ExtendMasterTimeTableForm',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.XMLUploadTimeTableStructure',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.XMLUploadTemplate',
	          'importutility.ImportByModule.ImportXMLTimeTableList',
	          'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsTabStructure',
	          'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsUploadDownloadForm',
	          'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadTemplatePanel',
	          'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsUploadTemplatePanel',
	          'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadPBSPanel',
	          'coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadCBSPanel',
	          'importutility.ImportByModule.ImportListExtendedTimeTable','examinationcenters.generatehallticket.GenerateTabulationReportWin',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableProgramGridWin',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTableBatchGridWin',
	          'coursetransaction.sectioncoursecoverageplan.mastertimetable.MasterTimeTablePeriodGridWin',
	          'Academia.view.coursetransaction.sectioncoursecoverageplan.ImportExtendedTimeTableTabStructure',
	          'Academia.view.coursetransaction.sectioncoursecoverageplan.ImportExtendedTimeTableUploadDownloadForm',
	          'Academia.view.coursetransaction.sectioncoursecoverageplan.ImportExtendedTimeTableDownloadPanel',
	          'coursetransaction.sectioncoursecoverageplan.ImportExtendedTimeTableUploadTemplatePanel',
	          'importutility.ImportByModule.UploadListExtendedTimeTable'
	         ],
    config: {
    			MASTER_TIME_TABLE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MASTER_TIME_TABLE_PRIVILEGES'),
    			SECTION_COURSE_VIEW_TIMETABLE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SECTION_COURSE_VIEW_TIMETABLE_PRIVILEGES'),
           	    CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
           	    IMPORT_SESSION_AND_TOPICS_MAPPING_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('IMPORT_SESSION_AND_TOPICS_MAPPING_PRIVILEGES'),
           	    IMPORT_MASTER_TIME_TABLE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('IMPORT_MASTER_TIME_TABLE_PRIVILEGES'),
           	    EXTEND_TIME_TABLE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXTEND_TIME_TABLE_PRIVILEGES')
	       },         
	         refs : [{
	        	 ref : 'contentPanel',
	        	 selector:'contentpanel'
	         },{
	        	 ref: 'mastersearchfilter',
	        	 selector: 'mastersearchfilter'
	         },{
	        	 ref: 'mastertimetablecalendar',
	        	 selector: 'mastertimetablecalendar'
	         },{
	        	 ref: 'mastertimetabledetailedwindow',
	        	 selector: 'mastertimetabledetailedwindow'
	         },{
	        	 ref: 'mastertimetableDetailedwindow',
	        	 selector: 'mastertimetabledetailedwindow form'
	         },{
	        	 ref : 'mastertTimeTableImportUtilityWin',
		    	 selector : 'importutilitywin[itemId=mastertimetableimportutilitywin]'
	         },{
	        	 ref : 'uploadtemplate',
		    	 selector : 'uploadtemplate'
	         },{
	        	 ref : 'importlisttimetable',
		    	 selector : 'importlisttimetable'
	         },{
	        	 ref : 'masterTimeTableForm',
	        	 selector : 'mastertimetableform'
	         },{
	        	 ref : 'programcoursefilters',
	        	 selector : 'programcoursefilters'
	         },{
	        	 ref : 'timetableprogambatchgrid',
	        	 selector : 'timetableprogambatchgrid'
	         },{
	        	 ref : 'uploadtemplatestructure',
	        	 selector : 'uploadtemplatestructure'
	         },{
	        	 ref : 'timetablestructure',
	        	 selector : 'timetablestructure'
	         },{
            	 ref : 'uploadoptionradiogroup',
            	 selector : 'uploadoptionradiogroup[itemId=importTimeTableUploadOptionRadioGroupItemId]'
             },{
	        	 ref : 'createmastertimetablegrid',
	        	 selector : 'createmastertimetablegrid'
	         },{
	        	 ref : 'daywisemastertimetablestructure',
	        	 selector : 'daywisemastertimetablestructure'
	         },{
	        	 ref : 'extendmastertimetable',
	        	 selector : 'extendmastertimetable' 
	         },{
	        	 ref : 'extendmastertimetableform',
	        	 selector : 'extendmastertimetableform' 
	         },{
	        	 ref : 'xmluploadtemplate',
		    	 selector : 'xmluploadtemplate'
	         },{
	        	 ref : 'importxmltimetablelist',
		    	 selector : 'importxmltimetablelist'
	         },{
	        	 ref : 'xmluploadtimetablestructure',
	        	 selector : 'xmluploadtimetablestructure'
	         },{
	        	 ref: 'programbatchtimetable',
	        	 selector: 'programbatchtimetable'
	         },{
	        	 ref: 'coursecoverageplanmasterstructure',
	        	 selector: 'coursecoverageplanmasterstructure'
	         },{
	        	 ref: 'importsessiontopicstabstructure',
	        	 selector: 'importsessiontopicstabstructure'
	         },{
	        	 ref: 'importsessiontopicsuploaddownloadform',
	        	 selector: 'importsessiontopicsuploaddownloadform'
	         },{
	        	 ref: 'importsessiontopicsdownloadtemplatepanel',
	        	 selector: 'importsessiontopicsdownloadtemplatepanel'
	         },{
	        	 ref: 'importsessiontopicsuploadtemplatepanel',
	        	 selector: 'importsessiontopicsuploadtemplatepanel'
	         },{
	        	 ref: 'importsessiontopicsdownloadpbspanel',
	        	 selector: 'importsessiontopicsdownloadpbspanel'
	         },{
	        	 ref: 'importsessiontopicsdownloadcbspanel',
	        	 selector: 'importsessiontopicsdownloadcbspanel'
	         },{
	        	 ref : 'importlistextendedtimetable',
		    	 selector : 'importlistextendedtimetable'
	         },{
			        ref : 'generatematertimetablereportwin',
			        selector:'generatetabulationreportwin[itemId=generatematertimetablereportwin]'
			    },{
			    	ref: 'mastertimetableprogramgridwin',
			    	selector: 'mastertimetableprogramgridwin'
			    },{
			    	ref: 'mastertimetablebatchgridwin',
			    	selector: 'mastertimetablebatchgridwin'
			    },{
			    	ref: 'mastertimetableperiodgridwin',
			    	selector: 'mastertimetableperiodgridwin'
			    },{
			    	ref: 'importExtendedTimeTableUploadTemplatePanel',
			    	selector: 'importExtendedTimeTableUploadTemplatePanel'
			    },{
			    	ref: 'uploadListExtendedTimeTable',
			    	selector: 'uploadListExtendedTimeTable',
			    },{
					ref: 'importExtendedTimeTableDownloadPanel',
					selector: 'importExtendedTimeTableDownloadPanel'
				}],
	         init : function() {
	        	 this.control({
	        		 	'coursecoverageplanmasterstructure':{
	        		 		afterrender: function(structure){
	        		 			var me = this;
	        		 			var associatedAcadLocationIds = new Array();
	        		 			associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	        	            	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getIMPORT_SESSION_AND_TOPICS_MAPPING_PERMISSION());
	        	            	var permissionListForExtendedTT = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getEXTEND_TIME_TABLE_PERMISSIONS());
	        		 			
	        	            	Ext.each(permissionList, function(privilege) {
	        	            		if (privilege === 'VIEW') {
			        		 			structure.add({
			        		 				xtype: 'importsessiontopicstabstructure',
			        		 				title: getCommonTranslation('IMPORT_SESSION_TOPICS_MAPPING'),
			        		 				itemId: 'coreERPImportaSessionTopicTab'
			        		 			});
	        	            		}
	        	            	});
	        	            	
	        	            	Ext.each(permissionListForExtendedTT, function(privilege) {
	        	            		if (privilege === 'IMPORT_EXTENDED_TIME_TABLE') {
			        		 			structure.add({
			        		 				xtype: 'importExtendedTimeTableTabStructure',
			        		 				title: getCommonTranslation('IMPORT_EXTENDED_TIME_TABLE'),
			        		 				itemId: 'importExtendedTimeTableTabStructure'
			        		 			});
	        	            		}
	        	            	});
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab]':{
	        		 		afterrender: function(structure){
	        		 			var me = this;
	        		 			var associatedAcadLocationIds = new Array();
	        		 			associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
	        	            	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getIMPORT_SESSION_AND_TOPICS_MAPPING_PERMISSION());
	        	            	
	        	            	var sectionTypeRadioGroup = structure.down('radiogroup[itemId=sectionTypeId]');
	        	            	
	        	            	var isPBSVisible = false;
	        	            	var isCBSVisible = false;
	        	            	
	        	            	Ext.each(permissionList, function(privilege) {
	        	            		if (privilege === 'PROGRAM_BATCH_SECTION') {
	        	            			isPBSVisible = true;
	        	            		}
	        	            		else if (privilege === 'COURSE_SECTION') {
	        	            			isCBSVisible = true;
	        	            		}
	        	            	});
	        	            	
	        	            	if(isPBSVisible == true && isCBSVisible == true){
	        	            		sectionTypeRadioGroup.show();
	        	            		sectionTypeRadioGroup.setValue({sectionType: "PBS"});
	        	            	}
	        	            	else if(isPBSVisible == true){
	        	            		sectionTypeRadioGroup.hide();
	        	            		sectionTypeRadioGroup.setValue({sectionType: "PBS"});
	        	            	}
	        	            	else { // if(isCBSVisible == true || (isPBSVisible == false && isCBSVisible == true)) //CASE
	        	            		sectionTypeRadioGroup.hide();
	        	            		sectionTypeRadioGroup.setValue({sectionType: "CBS"});
	        	            	}
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsuploaddownloadform radiogroup[itemId=templateTypeId]':{
	        		 		change: function( radioGroup, newValue, oldValue, eOpts){
	        		 			var me = this;
	        		 			var importsessiontopicsdownloadtemplatepanel = me.getImportsessiontopicsdownloadtemplatepanel();
	        		 			var importsessiontopicsuploadtemplatepanel = me.getImportsessiontopicsuploadtemplatepanel();
	        		 			var importlistextendedtimetable = me.getImportlistextendedtimetable();
	        		 			if(newValue.templateType == "Upload_Template"){
	        		 				importsessiontopicsdownloadtemplatepanel.hide();
	        		 				importlistextendedtimetable.show();
	        		 				importsessiontopicsuploadtemplatepanel.show();
	        		 			}
	        		 			else{
	        		 				importsessiontopicsdownloadtemplatepanel.show();
	        		 				importsessiontopicsuploadtemplatepanel.hide();
	        		 				importlistextendedtimetable.hide();
	        		 			}
	        		 		}
	        		 	},
						'importExtendedTimeTableTabStructure[itemId=importExtendedTimeTableTabStructure] importExtendedTimeTableUploadDownloadForm radiogroup[itemId=templateTypeId]':{
							change: function(radioGroup, newValue, oldValue, eOpts) {
								var me = this;
								var importExtendedTimeTableDownloadPanel = me.getImportExtendedTimeTableDownloadPanel();
								var importsessiontopicsuploadtemplatepanel = me.getImportsessiontopicsuploadtemplatepanel();
								var importlistextendedtimetable = me.getImportlistextendedtimetable();
								var uploadListExtendedTimeTable = me.getUploadListExtendedTimeTable();
								var importExtendedTimeTableUploadTemplatePanel = me.getImportExtendedTimeTableUploadTemplatePanel();
								if (newValue.extendedTimetableType == "Upload_Template") {
									importExtendedTimeTableUploadTemplatePanel.show();
									uploadListExtendedTimeTable.show();
									importExtendedTimeTableDownloadPanel.hide();
								}
								else {
									importExtendedTimeTableDownloadPanel.show();
									importExtendedTimeTableUploadTemplatePanel.hide();
									uploadListExtendedTimeTable.hide();
								}
							}
						},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsuploadtemplatepanel button[itemId=uploadImportSessionTopicUploadFormItemId]':{
	        		 		click:function(obj){
	        		 		var $this=this;
	        		 		var form=obj.up('importsessiontopicsuploadtemplatepanel');
	        		 		var templateName = form.down('#moduleName').getRawValue()=='Bulk PBS Session Topic Mapping'?'BULK_PBS_SESSION_TOPIC_MAPPING':'BULK_CBS_SESSION_TOPIC_MAPPING';
	        		 		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        		 		            $this.getHashOfFile(form);
	        		 		        setTimeout(function() {
	        		 		form.getForm().submit({
	        		 		method : 'POST',
	        		 		url : submitUrl,
	        		 		success : function(form, action){
	        		 		showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
	        		 		},
	        		 		failure: function(form, action) {
	        		 		    showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	        		 		}
	        		 		});
	        		 		        },1000);

	        		 		       Ext.defer(function() {
	        		    		 		var grid = $this.getImportlistextendedtimetable();
	        		    		 		var isUploadAll = true;
	        		    		 		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,templateName);
	        		    		 		}, 2000, this);
	        		    		 		}  
	        		 	},
	        		 	'importExtendedTimeTableUploadDownloadForm importExtendedTimeTableUploadTemplatePanel button[itemId=uploadExtendedTimeTableBtn]':{
	        		 		click:function(obj){
	        		 			var $this=this;
	        		 			var form=obj.up('importExtendedTimeTableUploadTemplatePanel');
	        		 			var templateName = 'IMPORT_EXTENDED_TIME_TABLE';
	        		 			submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        		 			$this.getHashOfFile(form);
	        		 			setTimeout(function() {
	        		 				form.getForm().submit({
	        		 					method : 'POST',
	        		 					url : submitUrl,
	        		 					success : function(form, action){
	        		 						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') ,getCommonTranslation('SUCCESS'));
	        		 					},
	        		 					failure: function(form, action) {
	        		 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
	        		 					}
	        		 				});
	        		 			},1000);

	        		 			Ext.defer(function() {
	        		 				var grid = $this.getUploadListExtendedTimeTable();
	        		 				var isUploadAll = true;
	        		 				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'Bulk Extended Time Table');
	        		 			}, 2000, this);
	        		 		}  
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadtemplatepanel radiogroup[itemId=sectionTypeId]':{
	        		 		change: function( radioGroup, newValue, oldValue, eOpts){
	        		 			var me = this;
	        		 			var importsessiontopicsdownloadpbspanel = me.getImportsessiontopicsdownloadpbspanel();
	        		 			var importsessiontopicsdownloadcbspanel = me.getImportsessiontopicsdownloadcbspanel();
	        		 			if(newValue.sectionType == "PBS"){
	        		 				importsessiontopicsdownloadpbspanel.show();
	        		 				importsessiontopicsdownloadcbspanel.hide();
	        		 				this.resetImportSessionTopicPBSFilter(importsessiontopicsdownloadpbspanel);
	        		 			}
	        		 			else{
	        		 				importsessiontopicsdownloadpbspanel.hide();
	        		 				importsessiontopicsdownloadcbspanel.show();
	        		 				this.resetImportSessionTopicCBSFilter(importsessiontopicsdownloadcbspanel);
	        		 			}
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadcbspanel':{
	        		 		afterrender: function(panel){
	        		 			var me = this;
	        		 			var academyLocationId = this.getCurrentAcademyLocation();
	        		 			var academicTermCombo = panel.down('#academicTermIdCBS');
	        		 			var academicTermComboStore = academicTermCombo.getStore();
	        		 			academicTermComboStore.getProxy().extraParams = {
	        		 				academyLocationIds : academyLocationId
	        		 			};
	        		 			academicTermComboStore.load({
	        		 				callback: function(rec, success) {
	        		 					if (success) {
	        		 						for(var i in rec){
	        		 							if(rec[i].get('sequence')==1){
	        		 								academicTermCombo.setValue(rec[i].get('id'));
	        		 							}
	        		 						}
	        		 					}
	        		 				}
	        		 			});
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadpbspanel':{
	        		 		afterrender: function(panel){
	        		 			var me = this;
	        		 			var alinfomodel = Academia.model.authentication.ALInfoModel;
		        				   var wheatherSchool = alinfomodel.get('wheatherSchool');
		        				   var form = this.getMastersearchfilter();
		        				   if(wheatherSchool) {
		        					   panel.down('#periodIdPBS').setVisible(false);
		        				   } else{
		        					   panel.down('#periodIdPBS').setVisible(true); 
		        				   }
	        		 			var academyLocationId = this.getCurrentAcademyLocation();
	        		 			var academicTermCombo = panel.down('#academicTermIdPBS');
	        		 			var academicTermComboStore = academicTermCombo.getStore();
	        		 			academicTermComboStore.getProxy().extraParams = {
	        		 				academyLocationIds : academyLocationId
	        		 			};
	        		 			academicTermComboStore.load({
	        		 				callback: function(rec, success) {
	        		 					if (success) {
	        		 						for(var i in rec){
	        		 							if(rec[i].get('sequence')==1){
	        		 								academicTermCombo.setValue(rec[i].get('id'));
	        		 							}
	        		 						}
	        		 					}
	        		 				}
	        		 			});
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadcbspanel customcombobox#academicTermIdCBS':{
		        			   change: function(obj, record) {
		        				   var me = this;
		        				   var importsessiontopicsdownloadcbspanel = obj.up('importsessiontopicsdownloadcbspanel');
		        				   var academicTermId = obj.getValue();
		        				   var batchField = importsessiontopicsdownloadcbspanel.down('#batchId');
		        				   var courseField = importsessiontopicsdownloadcbspanel.down('#course_Id');
		        				   var courseVariantField = importsessiontopicsdownloadcbspanel.down('#downloadCourseVariant_ID');
		        				   var batchStore = batchField.getStore();
		        				   var courseStore = courseField.getStore();
		        				   var courseVariantStore = courseVariantField.getStore();
        						   batchStore.getProxy().extraParams = {
        							   academicTermId:academicTermId
        						   };
        						   batchField.reset();
        						   courseField.reset();
        						   courseVariantField.reset();
        						   batchField.setDisabled(true);
        						   courseField.setDisabled(true);
        						   courseVariantField.setDisabled(true);
        						   me.validateImportSessionTopicsDownloadCBSForm();
        						   batchStore.load({
        							   callback: function(rec, success){
        								   if (success && !isNullOrEmpty(academicTermId)) {
        									   batchField.setDisabled(false);
        									   if(rec.length==1){
        										   batchField.setValue(rec[0].get('id'))
        										   var courseStoreExtraParams = {
        												   academicTermId:academicTermId,
        												   batchIds: rec[0].get('id')
        										   }
        									   }
        									   else{
        										   var courseStoreExtraParams = {
        												   academicTermId:academicTermId
        										   }
        									   }
        									   courseStore.getProxy().extraParams = courseStoreExtraParams;
        									   me.validateImportSessionTopicsDownloadCBSForm();
        									   courseStore.load({
        	        							   callback: function(rec, success){
        	        								   if (success) {
        	        									   courseField.setDisabled(false);
        	        									   if(rec.length==1){
        	        										   courseField.setValue(rec[0].get('id'))
        	        										   var courseVariantStoreExtraParams = {
        	        												   academicTermId:academicTermId,
        	        												   courseIds: rec[0].get('id')
        	        										   }

            	        									   if(!isNullOrEmpty(batchField.getValue())){
            	        										   courseVariantStoreExtraParams.batchIds = courseStoreExtraParams.batchIds;
            	        									   }
            	        									   
            	        									   courseVariantStore.getProxy().extraParams = courseVariantStoreExtraParams;
            	        									   me.validateImportSessionTopicsDownloadCBSForm();
            	        									   courseVariantStore.load({
            	        	        							   callback: function(rec, success){
            	        	        								   if (success) {
            	        	        									   courseVariantField.setDisabled(false);
            	        	        									   if(rec.length==1){
            	        	        										   courseVariantField.setValue(rec[0].get('id'))
            	        	        									   }
            	        	        									   me.validateImportSessionTopicsDownloadCBSForm();
            	        	        								   }
            	        	        							   }
            	        									   });
        	        									   }
        	        								   }
        	        							   }
        									   });
        								   }
        							   }
        						   });
		        			   }
	        		 	},
						'importExtendedTimeTableTabStructure[itemId=importExtendedTimeTableTabStructure] importExtendedTimeTableDownloadPanel customcombobox#academicTermIdExtendedTT':{
							change: function(obj, record) {
								var me = this;
								var importExtendedTimeTableDownloadPanel = obj.up('importExtendedTimeTableDownloadPanel');
								var academicTermId = obj.getValue();
								var batchField = importExtendedTimeTableDownloadPanel.down('#batchIdExtendedTT');
								var periodField = importExtendedTimeTableDownloadPanel.down('#periodIdExtendedTT');
								var batchStore = batchField.getStore();
								var periodStore = periodField.getStore();
								batchStore.getProxy().extraParams = {
									academicTermId: academicTermId
								};
								batchField.reset();
								batchField.setDisabled(true);
								periodField.reset();
								periodField.setDisabled(true);
								batchStore.load({
									callback: function(rec, success) {
										if (success && !isNullOrEmpty(academicTermId)) {
											batchField.setDisabled(false);
											importExtendedTimeTableDownloadPanel.isValid();
											if (rec.length == 1) {
												batchField.setValue(rec[0].get('id'))
												var batchId=rec[0].get('id');
												
												periodStore.getProxy().extraParams = {
													academicTermId: academicTermId,
													batchIds: batchId,
													sectionType:'CourseSection'
												};
												periodField.reset();
												periodField.setDisabled(true);
												var alinfomodel = Academia.model.authentication.ALInfoModel;
												var wheatherSchool = alinfomodel.get('wheatherSchool');
													if (!wheatherSchool) {
														periodStore.load({
															callback: function(rec, success) {
																if (success && !isNullOrEmpty(batchId)) {
																	periodField.setDisabled(false);
																	if (rec.length == 1) {
																		periodField.setValue(rec[0].get('id'))
																	}
																}
															}
														});
													}
											}
										}
									}
								});
							}
						},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadpbspanel customcombobox#academicTermIdPBS':{
		        			   change: function(obj, record) {
		        				   var me = this;
		        				   var importsessiontopicsdownloadpbspanel = obj.up('importsessiontopicsdownloadpbspanel');
		        				   var academicTermId = obj.getValue();
		        				   var batchField = importsessiontopicsdownloadpbspanel.down('#batchIdPBS');
		        				   var courseField = importsessiontopicsdownloadpbspanel.down('#course_IdPBS');
		        				   var periodField = importsessiontopicsdownloadpbspanel.down('#periodIdPBS');
		        				   var batchStore = batchField.getStore();
		        				   var courseStore = courseField.getStore();
		        				   var periodStore = periodField.getStore();
     						   batchStore.getProxy().extraParams = {
     							   academicTermId:academicTermId
     						   };
     						   batchField.reset();
     						   courseField.reset();
     						   periodField.reset();
     						   batchField.setDisabled(true);
     						   courseField.setDisabled(true);
     						   periodField.setDisabled(true);
     						   batchStore.load({
     							   callback: function(rec, success){
     								   if (success && !isNullOrEmpty(academicTermId)) {
     									   batchField.setDisabled(false);
     									   importsessiontopicsdownloadpbspanel.isValid();
     									   if(rec.length==1){
     										   batchField.setValue(rec[0].get('id'))
     									   }
     								   }
     							   }
     						   });
		        			   }
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadpbspanel multiselectcombofield#batchIdPBS':{
	        		 		change: function(obj, record) {
	        		 			var me = this;
		        				   var importsessiontopicsdownloadpbspanel = obj.up('importsessiontopicsdownloadpbspanel');
		        				   var batchIds = importsessiontopicsdownloadpbspanel.down('#batchIdPBS').getValue();
		        				   var academicTermId = importsessiontopicsdownloadpbspanel.down('#academicTermIdPBS').getValue();
		        				   var courseField = importsessiontopicsdownloadpbspanel.down('#course_IdPBS');
		        				   var periodField = importsessiontopicsdownloadpbspanel.down('#periodIdPBS');
		        				   var batchIdArr=[];
		        	 				var batchIdVal = batchIds;
		        	 				var batchIdVals = null;
		        	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
		        						for (var i in batchIdVal) {
		        							if (Ext.isObject(batchIdVal[0])) {
		        								batchIdArr.push(batchIdVal[i].get("id"));
		        							} else {
		        								batchIdArr.push(batchIdVal[i]);
		        							}
		        						}
		        						batchIdVals = batchIdArr.join();
		        					}
		        					else if(!isNullOrEmpty(batchIdVal)){
		        						batchIdVals = batchIdVal;
		        					}
		        				   var courseStore = courseField.getStore();
		        				   var periodStore = periodField.getStore();
		        				   periodStore.getProxy().extraParams = {
	     							   academicTermId:academicTermId,
	     							   batchIds:batchIdVals
	     						   };
	     						   courseField.reset();
	     						   periodField.reset();
	     						   courseField.setDisabled(true);
	     						   periodField.setDisabled(true);
	     						   var alinfomodel = Academia.model.authentication.ALInfoModel;
	    						   var wheatherSchool = alinfomodel.get('wheatherSchool');
	     						   if(!isNullOrEmpty(batchIds) && batchIds.length > 0){
	     							  if(!wheatherSchool){
	     								 periodStore.load({
			     							   callback: function(rec, success){
			     								   if (success && !isNullOrEmpty(batchIds)) {
			     									  periodField.setDisabled(false);
			     									   if(rec.length==1){
			     										  periodField.setValue(rec[0].get('id'))
			     									   }
			     									 courseStore.getProxy().extraParams = {
			     										 academicTermId:academicTermId,
														   batchIds: batchIdVals,
														   periodId:periodField.getValue()
			     		        		 			};
			     									  courseStore.load({
			     	        							   callback: function(rec, success){
			     	        								   if (success) {
			     	        									   courseField.setDisabled(false);
			     	        									   if(rec.length==1){
			     	        										   courseField.setValue(rec[0].get('id'))
			     	        									   }
			     	        								   }
			     	        							   }
			     									   });
			     								   }
			     							   }
			     						   }); 
	     							  } else{
	     								 courseStore.getProxy().extraParams = {
     										 academicTermId:academicTermId,
											 batchIds: batchIdVals
     		        		 			};
	     								courseStore.load({
  	        							   callback: function(rec, success){
  	        								   if (success) {
  	        									   courseField.setDisabled(false);
  	        									   if(rec.length==1){
  	        										   courseField.setValue(rec[0].get('id'))
  	        									   }
  	        								   }
  	        							   }
  									   });
	     							  }
	     							  
	     						   }
	        		 		}
	        		 	},
						'importExtendedTimeTableTabStructure[itemId=importExtendedTimeTableTabStructure] importExtendedTimeTableDownloadPanel customcombobox#batchIdExtendedTT':{
							select: function(obj, record) {
								var me = this;
								var importExtendedTimeTableDownloadPanel = obj.up('importExtendedTimeTableDownloadPanel');
								var batchId = importExtendedTimeTableDownloadPanel.down('#batchIdExtendedTT').getValue();
								var academicTermId = importExtendedTimeTableDownloadPanel.down('#academicTermIdExtendedTT').getValue();
								var periodField = importExtendedTimeTableDownloadPanel.down('#periodIdExtendedTT');
								var periodStore = periodField.getStore();
								periodStore.getProxy().extraParams = {
									academicTermId: academicTermId,
									batchIds: batchId,
									sectionType:'CourseSection'
								};
								periodField.reset();
								periodField.setDisabled(true);
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
									if (!wheatherSchool) {
										periodStore.load({
											callback: function(rec, success) {
												if (success && !isNullOrEmpty(batchId)) {
													periodField.setDisabled(false);
													if (rec.length == 1) {
														periodField.setValue(rec[0].get('id'))
													}
												}
											}
										});
									}
								
							}
						},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadpbspanel customcombobox#periodIdPBS':{
		        			   select: function(obj, record) {
		        				   var me = this;
		        				   var importsessiontopicsdownloadpbspanel = obj.up('importsessiontopicsdownloadpbspanel');
		        				   var academicTermId = importsessiontopicsdownloadpbspanel.down('#academicTermIdPBS').getValue();
		        				   var batchIds = importsessiontopicsdownloadpbspanel.down('#batchIdPBS').getValue();
		        				   var periodId = importsessiontopicsdownloadpbspanel.down('#periodIdPBS').getValue();
		        				   var batchIdArr=[];
		        	 				var batchIdVal = batchIds;
		        	 				var batchIdVals = null;
		        	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
		        						for (var i in batchIdVal) {
		        							if (Ext.isObject(batchIdVal[0])) {
		        								batchIdArr.push(batchIdVal[i].get("id"));
		        							} else {
		        								batchIdArr.push(batchIdVal[i]);
		        							}
		        						}
		        						batchIdVals = batchIdArr.join();
		        					}
		        					else if(!isNullOrEmpty(batchIdVal)){
		        						batchIdVals = batchIdVal;
		        					}
		        				   var courseField = importsessiontopicsdownloadpbspanel.down('#course_IdPBS');
		        				   var courseStore = courseField.getStore();
		        				   courseStore.getProxy().extraParams = {
		        					   academicTermId:academicTermId,
		        					   batchIds:batchIdVals,
		        					   periodId:periodId
		        				   };
		        				   courseField.reset();
		        				   courseStore.load({
		        					   callback: function(rec, success){
		  								   if (success && !isNullOrEmpty(academicTermId)) {
		  									 courseField.setDisabled(false);
		  									   if(rec.length==1){
		  										 courseField.setValue(rec[0].get('id'))
		  									   }
		  								   }
		  							   }
		        				   });
  						   
		        			   }
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadcbspanel multiselectcombofield#batchId':{
	        		 		select: function(obj, record) {
	        		 			this.onBatchChange(obj, record);
	        		 		},
	        		 		change: function(obj, newValue, oldValue, eOpts){
	        		 			try{
	        		 				if(obj.store.count()){
	    	        		 			if(obj.store.count() == obj.value.length){ //onselectall
	    	        		 				this.onBatchChange(obj);
	    	        		 			}
	    	        		 			else if(oldValue.length == obj.store.count() && obj.value.length == 0){ //ondeselectall
	    	        		 				this.onBatchChange(obj);
	    	        		 			}
	    	        		 			else if(obj.getPicker().hidden){
	    	        		 				this.onBatchChange(obj);
	    	        		 			}
	    	    		 			}
	        		 			}
	        		 			catch(e){}
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadcbspanel multiselectcombofield#course_Id':{
	        		 		select: function(obj, record) {
	        		 			this.onCourseChange(obj, record);
	        		 		},
	        		 		change: function(obj, newValue, oldValue, eOpts){
	        		 			try{
	        		 				if(obj.store.count()){
	    	        		 			if(obj.store.count() == obj.value.length){ //onselectall
	    	        		 				this.onCourseChange(obj);
	    	        		 			}
	    	        		 			else if(oldValue.length == obj.store.count() && obj.value.length == 0){ //ondeselectall
	    	        		 				this.onCourseChange(obj);
	    	        		 			}
	    	        		 			else if(obj.getPicker().hidden){
	    	        		 				this.onCourseChange(obj);
	    	        		 			}
	    	    		 			}
	        		 			}
	        		 			catch(e){}
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadcbspanel button[itemId=importSessionTopicCBSResetBtn]':{
	        		 		click: function(btn){
	        		 			var panel = btn.up('importsessiontopicsdownloadcbspanel');
	        		 			this.resetImportSessionTopicCBSFilter(panel);
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadpbspanel button[itemId=importSessionTopicPBSResetBtn]':{
	        		 		click: function(btn){
	        		 			var panel = btn.up('importsessiontopicsdownloadpbspanel');
	        		 			this.resetImportSessionTopicPBSFilter(panel);
	        		 		}
	        		 	},
					 'importExtendedTimeTableTabStructure[itemId=importExtendedTimeTableTabStructure] importExtendedTimeTableDownloadPanel button[itemId=importExtendedTTResetBtn]': {
						 click: function(btn) {
							 var panel = btn.up('importExtendedTimeTableDownloadPanel');
							 this.resetImportExtendedTTFilter(panel);
						 }
						},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsuploadtemplatepanel button[itemId=resetBtnImportSessionTopicUploadFormItemId]':{
	        		 		click: function(btn){
	        		 			btn.up('form').getForm().reset();
	        		 		}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadcbspanel button[itemId=importSessionTopicCBSDownload]':{
	        		 		click:function(obj){
	        	 				var $this = this;
	        	 				var form =obj.up('importsessiontopicsdownloadcbspanel').getForm();
	                            var submitUrl= SERVERURL.DOWNLOAD_TEMPLATE_CBS_SESSION_TOPIC_MAPPING_CREATION;
	        	 				var csvForm = Ext.create('Ext.form.Panel'); 
	        	 				var values = form.getValues();
	        	 				var batchIdArr=[];
	        	 				var batchIdVal = values.batch;
	        	 				var batchIdVals = null;
	        	 				var courseIdArr=[];
	        					var courseIdVal = values.course;
	        					var courseIdVals = null;
	        					var courseVariantArr=[];
	        					var courseVariantIdVal = values.downloadCourseVariantName;
	        					var courseVariantIdVals = null;
	        					
	        					if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
	        						for (var i in batchIdVal) {
	        							if (Ext.isObject(batchIdVal[0])) {
	        								batchIdArr.push(batchIdVal[i].get("id"));
	        							} else {
	        								batchIdArr.push(batchIdVal[i]);
	        							}
	        						}
	        						batchIdVals = batchIdArr.join();
	        					}
	        					else if(!isNullOrEmpty(batchIdVal)){
	        						batchIdVals = batchIdVal;
	        					}

	        					if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
	        						for (var i in courseIdVal) {
	        							if (Ext.isObject(courseIdVal[0])) {
	        								courseIdArr.push(courseIdVal[i].get("id"));
	        							} else {
	        								courseIdArr.push(courseIdVal[i]);
	        							}
	        						}
	        						courseIdVals = courseIdArr.join();
	        					}
	        					else if(!isNullOrEmpty(courseIdVal)){
	        						courseIdVals = courseIdVal;
	        					}
	        					
	        					if (!isNullOrEmpty(courseVariantIdVal) && courseVariantIdVal.length > 0 && !isNullOrEmpty(courseVariantIdVal[0])) {
	        						for (var i in courseVariantIdVal) {
	        							if (Ext.isObject(courseVariantIdVal[0])) {
	        								courseVariantArr.push(courseVariantIdVal[i].get("id"));
	        							} else {
	        								courseVariantArr.push(courseVariantIdVal[i]);
	        							}
	        						}
	        						courseVariantIdVals = courseVariantArr.join();
	        					}
	        					else if(!isNullOrEmpty(courseVariantIdVal)){
	        						courseVariantIdVals = courseVariantIdVal;
	        					}
	        	 				
	        	 				var params = {
	    	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	    	 						academicTermId : values.academicTermCBS,
	    	 						batchIds : batchIdVals,
	         	 					courseIds : courseIdVals,
	         	 					courseVariantIds : courseVariantIdVals
	    	 					};
	        	 				csvForm.getForm().submit({
	        	 					target: '_blank',
	        	 					method:'POST',
	        	 					params :params,
	        	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        	 					url: submitUrl,
	        	 					standardSubmit :true
	        	 				});
	        	 			}
	        		 	},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importsessiontopicsdownloadpbspanel button[itemId=importSessionTopicPBSDownload]':{
	        		 		click:function(obj){
	        	 				var $this = this;
	        	 				var form =obj.up('importsessiontopicsdownloadpbspanel').getForm();
	                            var submitUrl= SERVERURL.DOWNLOAD_TEMPLATE_PBS_SESSION_TOPIC_MAPPING_CREATION;
	        	 				var csvForm = Ext.create('Ext.form.Panel'); 
	        	 				var values = form.getValues();
	        	 				var batchIdArr=[];
	        	 				var batchIdVal = values.batchPBS;
	        	 				var batchIdVals = null;
	        	 				var courseIdArr=[];
	        					var courseIdVal = values.coursePBS;
	        					var courseIdVals = null;
	        					
	        					if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
	        						for (var i in batchIdVal) {
	        							if (Ext.isObject(batchIdVal[0])) {
	        								batchIdArr.push(batchIdVal[i].get("id"));
	        							} else {
	        								batchIdArr.push(batchIdVal[i]);
	        							}
	        						}
	        						batchIdVals = batchIdArr.join();
	        					}
	        					else if(!isNullOrEmpty(batchIdVal)){
	        						batchIdVals = batchIdVal;
	        					}

	        					if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
	        						for (var i in courseIdVal) {
	        							if (Ext.isObject(courseIdVal[0])) {
	        								courseIdArr.push(courseIdVal[i].get("id"));
	        							} else {
	        								courseIdArr.push(courseIdVal[i]);
	        							}
	        						}
	        						courseIdVals = courseIdArr.join();
	        					}
	        					else if(!isNullOrEmpty(courseIdVal)){
	        						courseIdVals = courseIdVal;
	        					}
	        					
	        	 				var params = {
	    	 						access_token : Ext.Ajax.defaultHeaders.access_token,
	    	 						academicTermId : values.academicTermPBS,
	    	 						batchIds : batchIdVals,
	         	 					courseIds : courseIdVals,
	         	 					periodId : values.periodIdPBS
	    	 					};
	        	 				csvForm.getForm().submit({
	        	 					target: '_blank',
	        	 					method:'POST',
	        	 					params :params,
	        	 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        	 					url: submitUrl,
	        	 					standardSubmit :true
	        	 				});
	        	 			}
	        		 	},
						'importExtendedTimeTableTabStructure[itemId=importExtendedTimeTableTabStructure] importExtendedTimeTableDownloadPanel button[itemId=importExtendedTTDownload]':{
							click: function(obj) {
								var $this = this;
								var form = obj.up('importExtendedTimeTableDownloadPanel').getForm();
								var submitUrl = SERVERURL.PATH_DOWNLOAD_FILE_FOR_EXTENDED_TIME_TABLE;
								var csvForm = Ext.create('Ext.form.Panel');
								var values = form.getValues();


								var params = {
									access_token: Ext.Ajax.defaultHeaders.access_token,
									academicTermId: values.academicTermExtendedTT,
									batchId:values.batchExtendedTT,
									periodId: values.periodIdExtendedTT
								};
								csvForm.getForm().submit({
									target: '_blank',
									method: 'POST',
									params: params,
									headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
									url: submitUrl,
									standardSubmit: true
								});
							}
						},
	        		 	'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importlistextendedtimetable':{
		        			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		          				if (e.target.tagName == 'A') {
		          					var fileType=null;
		          					if(cellIndex==1){
		          						fileType='successFile';
		          					}else if(cellIndex==6){
		          						fileType='errorFile';
		          					}else if(cellIndex==7){
		          						fileType='logFile';
		          					}
		          					var documentId = record.get("id");
		          					if (!isNullOrEmpty(documentId)) {
		          						this.getDownloadFile(documentId,fileType);
		          					}
		          				}
		          			}
		         		  },
		         		 'uploadListExtendedTimeTable':{
		        			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		          				if (e.target.tagName == 'A') {
		          					var fileType=null;
		          					if(cellIndex==1){
		          						fileType='successFile';
		          					}else if(cellIndex==6){
		          						fileType='errorFile';
		          					}else if(cellIndex==7){
		          						fileType='logFile';
		          					}
		          					var documentId = record.get("id");
		          					if (!isNullOrEmpty(documentId)) {
		          						this.getDownloadFile(documentId,fileType);
		          					}
		          				}
		          			}
		         		  },
		         		 'importsessiontopicstabstructure[itemId=coreERPImportaSessionTopicTab] importlistextendedtimetable button[itemId=btnForce]':{
		            			click: function(obj) {
		         	            	var grid = this.getImportlistextendedtimetable();
		         	            	if (grid.getSelectionModel().getCount() > 0) {
		         	            		if(grid.getSelectionModel().getCount() > 1){
		         		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		         		        		}else{
		         		        			var this$ = this;
		            	                	var id = grid.getSelectionModel().selectionStart.data.id;
		            	                	console.log(id);
		            	                	var urlAppend="?jobName="+id;
		            	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		            	    	        	Ext.Ajax.request({
		            	    	        		url: submitURL,
		            	    	        		method: 'GET',
		            	    	        		success: function(response) {
		            	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		            	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		            	    	        				//console.log("Manual trigger hit");
		            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		            	    	        			}else if(response.responseText==="SUCCESS"){
		            	    	        				//console.log("Manual trigger hit");
		                	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		            	    	        			}
		            	    	        		}
		            	    	        	});
		         		        		}
		         	            	} else {
		         	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		         	            	}  
		         	            }
		          		   },
		          		 'importExtendedTimeTableUploadDownloadForm uploadListExtendedTimeTable button[itemId=btnForce]':{
		            			click: function(obj) {
		         	            	var grid = this.getUploadListExtendedTimeTable();
		         	            	if (grid.getSelectionModel().getCount() > 0) {
		         	            		if(grid.getSelectionModel().getCount() > 1){
		         		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		         		        		}else{
		         		        			var this$ = this;
		            	                	var id = grid.getSelectionModel().selectionStart.data.id;
		            	                	console.log(id);
		            	                	var urlAppend="?jobName="+id;
		            	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		            	    	        	Ext.Ajax.request({
		            	    	        		url: submitURL,
		            	    	        		method: 'GET',
		            	    	        		success: function(response) {
		            	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		            	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		            	    	        				//console.log("Manual trigger hit");
		            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		            	    	        			}else if(response.responseText==="SUCCESS"){
		            	    	        				//console.log("Manual trigger hit");
		                	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		            	    	        			}
		            	    	        		}
		            	    	        	});
		         		        		}
		         	            	} else {
		         	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		         	            	}  
		         	            }
		          		   },
	        		  'mastersearchfilter':{
	         		     render : function(obj){
	        				 // this.doAccessControlValidation(obj, this.getMASTER_TIME_TABLE_PRIVILEGES());
	         		    	var $this = this; 
	         		    	 this.disableMoreActionSequencePivileges(obj,this.getMASTER_TIME_TABLE_PRIVILEGES());
	        				  var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   var form = this.getMastersearchfilter();
	        				   if(wheatherSchool) {
	        					   form.down('#periodId').setVisible(false);
	        				   }
	        				  var academyLocationId = this.getCurrentAcademyLocation();
	        				  var calendarCombo = this.getMastersearchfilter().down('customcombobox#calendarId');
	        				  var calendarComboStore = calendarCombo.getStore();
	        				  calendarComboStore.getProxy().extraParams = {
	        					  academyLocationId : academyLocationId
	        				  };
	        				  calendarComboStore.load();
	        				  
	        				  var academicTermCombo = this.getMastersearchfilter().down('customcombobox#academicTerm');
	        				  var academicTermComboStore = academicTermCombo.getStore();
	        				  academicTermComboStore.getProxy().extraParams = {
	        					  academyLocationIds : academyLocationId
	        				  };
	        				  academicTermComboStore.load({

	        					  callback: function(rec, success) {
	        						  if (success) {
	        							  for(var i in rec){
	        								  if(rec[i].get('sequence')==1){
	        									  $this.getMastersearchfilter().down('#academicTerm').setValue(rec[i].get('id'));
	        								  }
	        							  }

	        						  }
	        					  }
	        				  });
	        			  }
	         		  },
	         		 'timetableprogambatchgrid':{
	         		     render : function(grid){
	         		    	 var grid = this.getTimetableprogambatchgrid();
	        				 this.exportReportPermission(grid, this.getSECTION_COURSE_VIEW_TIMETABLE_PRIVILEGES());
	        				
	        			  },
	        			  afterrender:function(grid){
	        				  var me =this;
	        				  var newStructure = grid.up('timetablestructure');
	        				  this.getGridHeaderFreeze(grid,newStructure, false);
	         			  
	        				  setTimeout(function(){ 
	        					  me.addDataGridConfigButton(grid, me.getSECTION_COURSE_VIEW_TIMETABLE_PRIVILEGES());
	        				  },1500);
	        			  },
	        			  cellclick : function(grid,td, cellIndex, selectedRecord, tr, rowIndex, e, eOpts ) {
	        				  var me = this;
	        				  if (e.target.tagName == 'A') {
	        					  var currentGrid = grid.up();
	        					  
	        					  var programsArray = selectedRecord.get('programsArray');
	        					  var batchesArray = selectedRecord.get('batchesArray');
	        					  var periodsArray = selectedRecord.get('periodsArray');

	        					  if (grid.up().columns[cellIndex].dataIndex == "programName"){
	        						  
	        						  var arrayOfObjects = [];
	        						  for (var i = 0; i < programsArray.length; i++) {
	        						      var nameObj = { name: programsArray[i] };
	        						      arrayOfObjects.push(nameObj);
	        						  }

	        						  var formWindow = me.getMastertimetableprogramgridwin();
	        						  if (!formWindow) {
	        							  formWindow = Ext.widget('mastertimetableprogramgridwin',{
	        								  storeRecords:arrayOfObjects
	        							  });
	        						  }
	        						  formWindow.show();
	        					  }
	        					  else if (grid.up().columns[cellIndex].dataIndex == "batchName"){
	        						  
	        						  var arrayOfObjects = [];
	        						  for (var i = 0; i < batchesArray.length; i++) {
	        						      var nameObj = { name: batchesArray[i] };
	        						      arrayOfObjects.push(nameObj);
	        						  }
	        						  
	        						  var formWindow = me.getMastertimetablebatchgridwin();
	        						  if (!formWindow) {
	        							  formWindow = Ext.widget('mastertimetablebatchgridwin',{
	        								  storeRecords:arrayOfObjects
	        							  });
	        						  }
	        						  formWindow.show();
	        					  }
	        					  else if (grid.up().columns[cellIndex].dataIndex == "periodName"){
	        						  
	        						  var arrayOfObjects = [];
	        						  for (var i = 0; i < periodsArray.length; i++) {
	        						      var nameObj = { name: periodsArray[i] };
	        						      arrayOfObjects.push(nameObj);
	        						  }
	        						  
	        						  var formWindow = me.getMastertimetableperiodgridwin();
	        						  if (!formWindow) {
	        							  formWindow = Ext.widget('mastertimetableperiodgridwin',{
	        								  storeRecords:arrayOfObjects
	        							  });
	        						  }
	        						  formWindow.show();
	        					  }
	        				  }
	        			  }
             			 
	         		  
	         		  },
	         		  'mastertimetableprogramgridwin':{
	         			  afterrender: function(win){
	         				  var winGrid = win.down('grid');
	         				  var storeRecords = win.storeRecords;
	         				  var winGridStore = winGrid.getStore();
	         				 winGridStore.loadData(storeRecords);
	         			  }
	         		  },
	         		  'mastertimetablebatchgridwin':{
	         			  afterrender: function(win){
	         				  var winGrid = win.down('grid');
	         				  var storeRecords = win.storeRecords;
	         				  var winGridStore = winGrid.getStore();
	         				 winGridStore.loadData(storeRecords);
	         			  }
	         		  },
	         		  'mastertimetableperiodgridwin':{
	         			  afterrender: function(win){
	         				  var winGrid = win.down('grid');
	         				  var storeRecords = win.storeRecords;
	         				  var winGridStore = winGrid.getStore();
	         				 winGridStore.loadData(storeRecords);
	         			  }
	         		  },
	         		  'uploadtemplate':{
	         			  render:function(){
	         				  this.templateTypeDropdown();
	         			  }
	         		  },
	         		 'xmluploadtemplate':{
	         			  render:function(){
	         				  this.loadXmlImportTemplate();
	         			  }
	         		  },
            		   'uploadtemplate uploadoptionradiogroup[itemId=importTimeTableUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
             			   change: function( radioGroup, newValue, oldValue, eOpts){
             				   var grid =this.getImportlisttimetable();
             				   var form =this.getUploadoptionradiogroup();
             				   var isUploadAll = newValue.isUploadAll;
             				   var importWin=this.getUploadtemplate();
             				   var values = importWin.getValues();
             				   var moduleName = null;
             				   var type = values.uploadType;
             				   if(type == 'PROGRAM_BATCH_SECTION') {
             					   moduleName='IMPORT_BULK_TIME_TABLE_UPLOAD';
             				   }else if(type == 'COURSE_SECTION') {
             					   moduleName='IMPORT_BULK_CBS_TIME_TABLE_UPLOAD';
             				   }
             				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, moduleName);
             			   }   
             		   },
	         		 'timetablestructure': {
          			   beforerender:function(timetablestructure){
          				   this.disableTimeTableImportTab(timetablestructure, this.getMASTER_TIME_TABLE_PRIVILEGES());
          			   }
          		   }, 
	         		  
	         		 'uploadtemplate button[itemId=resetBtn]':{
	        			   click: function(){
	        				   var $this=this;
	    	    	        	var form=$this.getUploadtemplate();
	    	    	        	var values = form.getValues();
	    	    	        	if(values.templateType == "Download_Template"){
	    	    	        		form.down('#calendarId').reset();
	    	    	        		form.down('#batchId').reset();
	    	    	        		form.down('#periodId').reset();
	    	    	        		form.down('#sectionId').reset();
	    	    	        		form.down('#cbsProgramId').reset();
	    	    	        		form.down('#cbsBatchId').reset();
	    	    	        		form.down('#cbsProgramId').setDisabled(true);
                                    form.down('#batchId').setDisabled(true);
                                   form.down('#periodId').setDisabled(true);
	    	    	        		form.down('#cbsBatchId').setDisabled(true);
	    	    	        		form.down('#periodId').setDisabled(true);
	    	    	        		form.down('#sectionId').setDisabled(true);
	    	    	        		form.down('#downoladtemplate').setDisabled(true);
	    	    	        		form.down('#programBatchUpload').setVisible(false);
	    	    	        		form.down('#resetBtn').setVisible(true);
	    	    	        		form.down('#resetBtn').setDisabled(true);
	    	    	        	}else if(values.templateType == "Upload_Template"){
	    	    	        		form.down('#uploadFileField').reset();
	    	    	        		var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
	    	    	        		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	    	    	        			isUploadAll: false
	    	    	        		});
	    	    	        		form.isValid();
	    	    	        	}
	        			   }
	        		   },
	         		 'uploadtemplate button[itemId=programBatchUpload]':{
	        			   click: function(){
	        				   var $this=this;
	        				   var moduleName = null;
	    	    	        	var importWin=$this.getUploadtemplate();
	    	    	        	var values = importWin.getValues();
	    	    	        	var type = values.uploadType;
	    	    	        	if(type == 'PROGRAM_BATCH_SECTION') {
	    	    	        		moduleName='IMPORT_BULK_TIME_TABLE_UPLOAD';
	    	    	        	}else if(type == 'COURSE_SECTION') {
	    	    	        		moduleName='IMPORT_BULK_CBS_TIME_TABLE_UPLOAD';
		        				 }
	    	    	        	var grid = $this.getImportlisttimetable();
	    	    	        	var grdStore;
	    	    	        	var form=$this.getUploadtemplate();
	    	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			    	        	$this.getHashOfFile(form);
					        	setTimeout(function() {
		    	    	        	form.getForm().submit({
		    	    	        		method : 'POST',
		    	    	        		url : submitUrl,
		    	    	        		success : function(form, action){
		    	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY') , getCommonTranslation('SUCCESS'));
		    	    	    	        },
		    	    	        		failure: function(form, action) {
		       		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		    	    	    	        }
		    	    	        	});
					        	},1000);
	    	    	        	Ext.defer(function() {
	    	    	        		var form = $this.getUploadoptionradiogroup();
	    	    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	    	    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	    	    	        	}, 2000, this);
	        			   }
	        		   },
	         		 'importlisttimetable':{
	        			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	          				if (e.target.tagName == 'A') {
	          					var fileType=null;
	          					if(cellIndex==1){
	          						fileType='successFile';
	          					}else if(cellIndex==6){
	          						fileType='errorFile';
	          					}else if(cellIndex==7){
	          						fileType='logFile';
	          					}
	          					var documentId = record.get("id");
	          					if (!isNullOrEmpty(documentId)) {
	          						this.getDownloadFile(documentId,fileType);
	          					}
	          				}
	          			}
	         		  },
	         		 'importlisttimetable button[itemId=btnForce]':{
	            			click: function(obj) {
	         	            	var grid = this.getImportlisttimetable();
	         	            	if (grid.getSelectionModel().getCount() > 0) {
	         	            		if(grid.getSelectionModel().getCount() > 1){
	         		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	         		        		}else{
	         		        			var this$ = this;
	            	                	var id = grid.getSelectionModel().selectionStart.data.id;
	            	                	console.log(id);
	            	                	var urlAppend="?jobName="+id;
	            	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	            	    	        	Ext.Ajax.request({
	            	    	        		url: submitURL,
	            	    	        		method: 'GET',
	            	    	        		success: function(response) {
	            	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	            	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	            	    	        				//console.log("Manual trigger hit");
	            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	            	    	        			}else if(response.responseText==="SUCCESS"){
	            	    	        				//console.log("Manual trigger hit");
	                	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	            	    	        			}
	            	    	        		}
	            	    	        	});
	         		        		}
	         	            	} else {
	         	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	         	            	}  
	         	            }
	          		   },
	          		   
	          		   /**
	          		    * @author surendra
	          		    */
	          		   'mastersearchfilter radiogroup[itemId=sectionTypeId]' :{
	          			   change : function(cb) {
	          				   this.changeSectionType();
	          				   var form=this.getMastersearchfilter();
	          				   var calendarField = form.down('#calendarId');
	          				   calendarField.reset();
	          			   }
	          		   },
	          		   'mastersearchfilter button[itemId=resetBtn]' :{
	          			   click : function(cb) {
	          				   var sectionType = cb.up('mastersearchfilter').down('#sectionTypeId').getValue();
	          				   if(sectionType.sectionType==="PROGRAM_BATCH_SECTION"){
	          					   this.changeSectionType(); 
	          				   }
	          				   cb.up('mastersearchfilter').getForm().reset();
	          				   cb.up('mastersearchfilter').down('#sectionTypeId').setValue(sectionType);
	          			   }
	          		   },
	          		   'mastersearchfilter customcombobox#courseId' : {
	          			   select : function(obj, record) {
	          				   var me=this;
	          				   var courseId = record[0].get("courseId");
	          				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	          				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	          				   var form=this.getMastersearchfilter();
	          				   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	          				   mainCalendarPanel.setVisible(false);	          				   
	          				   var searchForm = this.getMastersearchfilter().getForm();	          				   
	          				   var academicTermId=this.getMastersearchfilter().down('#academicTerm').getValue();
	          				   var courseComponentBox = this.getMastersearchfilter().down('customcombobox#componentSectionId');
	          				   var sectionBox = this.getMastersearchfilter().down('customcombobox#courseSection_Id');
	          				   courseComponentBox.clearValue();
	          				   sectionBox.clearValue();
	          				   if(record[0].get("sectionAtComponentLevel")){
	          					   courseComponentBox.show();
	          					   me.setAllowBlank(courseComponentBox,false);
	          					   var store = courseComponentBox.getStore();
	          					   store.getProxy().extraParams = {
	          						   id: courseId,
	          						   wheatherSchool:wheatherSchool
	          					   };
	          					   store.load({

									   callback: function(records, operation, success) {
										   if (success) {
											  
											   if(records.length==1){
												   courseComponentBox.setValue(records[0].get('id'));
												   sectionBox.setDisabled(false);
												   var componentId=records[0].get('id');
												   var store = sectionBox.getStore();
						          				   store.getProxy().extraParams = {
						          					   componentId : componentId,
						          					   parentCourseId : courseId,
						          					   academicTermId: academicTermId
						          				   };
						          				   store.load({

													   callback: function(records, operation, success) {
														   if (success) {
															  
															   if(records.length==1){
																   sectionBox.setValue(records[0].get('sectionId'))
																   searchForm.findField('courseVariantId').setValue(records[0].get("courseVariantId"));
																   if(form.isValid()){
																	            	  form.up('tabpanel').down('#viewCalanderId').setDisabled(false);
																	                  }  
															   }
														   }
													   }
					        					 });
											   }
										   }
									   }
	        					 });
	          				   }
	          				   else {
	          					   var courseComboBox = this.getMastersearchfilter().down('customcombobox#courseSection_Id');
	          					   var courseVariantComboBox = this.getMastersearchfilter().down('#courseVariantId');
	          					   courseComboBox.clearValue();
	          					   courseComponentBox.hide();
	          					   courseComponentBox.allowBlank=true;
	          					   me.setAllowBlank(courseComponentBox,true);
	          					   sectionBox.setDisabled(false);
	          					   var courseStore = courseComboBox.getStore();
	          					   courseStore.getProxy().extraParams = {
	          						   parentCourseId: courseId,
	          						   wheatherSchool:wheatherSchool,
	          						   academicTermId:academicTermId
	          					   };
	          					   courseStore.load({

									   callback: function(records, operation, success) {
										   if (success) {
											  
											   if(records.length==1){
												   courseComboBox.setValue(records[0].get('sectionId'));
												   searchForm.findField('courseVariantId').setValue(records[0].get("courseVariantId"));

											   }
										   }
									   }
	        					 });
	          					   form.isValid()
	          				   }

	          			   }
	          		   },
	          		   'mastersearchfilter customcombobox#componentSectionId' : {
	          			   select : function(obj, record) {
	          				   var componentId = record[0].get("id");
	          				   var form=this.getMastersearchfilter();
	          				   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	          				   mainCalendarPanel.setVisible(false);
	          				   var courseId = this.getMastersearchfilter().getForm().findField('course').getValue();
	          				   var academicTermId=this.getMastersearchfilter().down('#academicTerm').getValue();
	          				   var sectionBox = this.getMastersearchfilter().down('customcombobox#courseSection_Id');
	          				   sectionBox.setDisabled(false);
	          				   sectionBox.clearValue();
	          				   var store = sectionBox.getStore();
	          				   store.getProxy().extraParams = {
	          					   componentId : componentId,
	          					   parentCourseId : courseId,
	          					   academicTermId: academicTermId
	          				   };
	          				   store.load({

								   callback: function(records, operation, success) {
									   if (success) {
										  
										   if(records.length==1){
											   courseComponentBox.setValue(records[0].get('sectionId'))
										   }
									   }
								   }
        					 });
	          			   }
	          		   },
	          		   'mastersearchfilter customcombobox#courseSection_Id' : {
	          			   select : function(obj, record) {
	          				   var sectionId = record[0].get("sectionId");
	          				   var courseVariantId = record[0].get("courseVariantId");
	          				   var searchForm = this.getMastersearchfilter().getForm();
	          				   searchForm.findField('courseVariantId').setValue(courseVariantId);
	          				   
	          				   var form = this.getMastersearchfilter();
	          				   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	        	        	   mainCalendarPanel.setVisible(false);
	          				   //form.down("#tillDate").allowBlank=true;
	          				   //form.down("#startDate").allowBlank=true;
	          			   }
	          		   },
	          		   // END

	        		  'mastersearchfilter customcombobox#calendarId': {
	        			   select: function(obj, record) {
	        				   var calendarId = record[0].get("id");
	        				   if(calendarId > 0){
	        					   var form = this.getMastersearchfilter();
	        					   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	        					   mainCalendarPanel.setVisible(false);
	        					   form.down('#whetherDayWiseScheduleId').setValue(record[0].get("whetherDayWiseSchedule"));
	        					   var sectionType = this.getMastersearchfilter().getForm().findField('sectionType').getValue();
	        					   var academicTermId=this.getMastersearchfilter().down('#academicTerm').getValue();
	        					   if(!sectionType){ // CBS
	        						   form.down("#courseId").setDisabled(false);
	        						   form.down("#courseId").clearValue();
	        						   form.down("#componentSectionId").clearValue();
	        						   form.down("#componentSectionId").setVisible(false);
	        						   form.down("#courseSection_Id").clearValue();
	        						   form.down("#courseSection_Id").setDisabled(true);
		        					   var courseCombo = this.getMastersearchfilter().down('#courseId');		        					   
		        					   var courseStore = courseCombo.getStore();
		        					   courseStore.getProxy().extraParams = {
		        						   calendarId: calendarId,
		        						   sectionType: 'CourseSection',
		        						   academicTermId:academicTermId,
		        					   };
		        					   courseStore.load();
	        					   }else{
	        						   form.down("#sectionId").setDisabled(true);
	        						   form.down("#sectionId").clearValue();
	        						   form.down("#periodId").setDisabled(true);
	        						   form.down("#periodId").clearValue();
		        					   form.down("#batchId").setDisabled(false);
	        						   form.down("#batchId").clearValue();
		        					   var batchCombo = this.getMastersearchfilter().down('#batchId');
		        					   var batchStore = batchCombo.getStore();
		        					   batchStore.getProxy().extraParams = {
		        						   calendarId: calendarId,
		        						   academicTermId:academicTermId
		        					   };
		        					   batchStore.load();
	        					   }
	        				   }
	        			   }
	        		   },
	        		   'mastersearchfilter customcombobox#academicTerm':{
	        			   select: function(obj, record) {
	        				   var calendarId = this.getMastersearchfilter().down('#calendarId').getValue();
	        				   if(calendarId > 0){
	        					   var form = this.getMastersearchfilter();
	        					   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	        					   mainCalendarPanel.setVisible(false);
        						   var academicTermId=this.getMastersearchfilter().down('#academicTerm').getValue();
	        					   var sectionType = this.getMastersearchfilter().getForm().findField('sectionType').getValue();
	        					   if(!sectionType){ // CBS
	        						   form.down("#courseId").setDisabled(false);
	        						   form.down("#courseId").clearValue();
	        						   form.down("#componentSectionId").clearValue();
	        						   form.down("#componentSectionId").setVisible(false);
	        						   form.down("#courseSection_Id").clearValue();
	        						   form.down("#courseSection_Id").setDisabled(true);
	        						   var courseStore = form.down("#courseId").getStore();
	        						   courseStore.getProxy().extraParams = {
	        							   calendarId: calendarId,
	        							   sectionType: 'CourseSection',
	        							   academicTermId:academicTermId
	        						   };
	        						   courseStore.load();
	        					   }
	        					   else{
	        						   form.down("#sectionId").setDisabled(true);
	        						   form.down("#sectionId").clearValue();
	        						   form.down("#periodId").setDisabled(true);
	        						   form.down("#periodId").clearValue();
	        						   form.down("#batchId").setDisabled(false);
	        						   form.down("#batchId").clearValue();
	        						   var batchStore = form.down("#batchId").getStore();
	        						   batchStore.getProxy().extraParams = {
	        							   calendarId: calendarId,
	        							   academicTermId:academicTermId
	        						   };
	        						   batchStore.load();
	        					   }
	        				   }
	        			   }
	        		   },
	        		   'extendmastertimetableform customcombobox[itemId=sectionType]' :{
	        			   change : function(cb) {
	        				   var me = this;
	        				   var form = this.getExtendmastertimetableform();
	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   var academyLocationId = this.getCurrentAcademyLocation();
	        				   var calendarComboBox = form.down('customcombobox#calendarId');
	        				   var batchComboBox = form.down('customcombobox#batchId');
	        				   var academicTermComboBoxCBS = form.down('customcombobox#academicTerm');
	        				   var courseComboBoxCBS = form.down('customcombobox#courseId');
	        				   var componentComboBoxCBS = form.down('customcombobox#componentSectionId');
	        				   var sectionComboBoxCBS = form.down('customcombobox#courseSection_Id');
	        				   var periodComboBox = form.down('customcombobox#periodId');
	        				   var sectionComboBox = form.down('customcombobox#sectionId');
	        				   var startDateBox = form.down('datefield#startDate');
	        				   var tillDateBox = form.down('datefield#tillDate');
	        				   
	        				   var academicTermWiseProgBatch = form.down('#academicTermWiseProgBatch');
	        				   var academicTermWisePeriod = form.down('#academicTermWisePeriod');
	        				   var academicTermWiseCourse = form.down('#academicTermWiseCourse');
	        				   var academicTermWiseSection = form.down('#academicTermWiseSection');
	        				   academicTermWiseProgBatch.reset();
	        				   academicTermWisePeriod.reset();
	        				   academicTermWiseCourse.reset();
	        				   academicTermWiseSection.reset();
	        				   academicTermWisePeriod.setDisabled(true);
	        				   academicTermWiseCourse.setDisabled(true);
	        				   academicTermWiseSection.setDisabled(true);
	        				   academicTermWiseProgBatch.setVisible(false);
	        				   academicTermWisePeriod.setVisible(false);
	        				   academicTermWiseCourse.setVisible(false);
	        				   academicTermWiseSection.setVisible(false);
	        				   
	        				   
	        				   me.setAllowBlank(calendarComboBox,true);
	        				   me.setAllowBlank(batchComboBox,true);
	        				   me.setAllowBlank(academicTermComboBoxCBS,true);
	        				   me.setAllowBlank(courseComboBoxCBS,true);
	        				   me.setAllowBlank(componentComboBoxCBS,true);
	        				   me.setAllowBlank(sectionComboBoxCBS,true);
	        				   me.setAllowBlank(periodComboBox,true);
	        				   me.setAllowBlank(sectionComboBox,true);
	        				   me.setAllowBlank(startDateBox,true);
	        				   me.setAllowBlank(tillDateBox,true);
	        				   
	        				   calendarComboBox.setVisible(false);
	        				   batchComboBox.setVisible(false);
	        				   academicTermComboBoxCBS.setVisible(false);
	        				   courseComboBoxCBS.setVisible(false);
	        				   componentComboBoxCBS.setVisible(false);
	        				   sectionComboBoxCBS.setVisible(false);
	        				   periodComboBox.setVisible(false);
	        				   sectionComboBox.setVisible(false);
	        				   startDateBox.setVisible(false);
	        				   tillDateBox.setVisible(false);

	        				   startDateBox.reset();
	        				   tillDateBox.reset();


        					   batchComboBox.clearValue();
        					   periodComboBox.clearValue();
        					   calendarComboBox.clearValue();
	        				   academicTermComboBoxCBS.clearValue();
        					   componentComboBoxCBS.clearValue();

	        				   var sectionType = form.getForm().findField('sectionType').getValue();
	        				   
	        				   if(sectionType=="COURSE_SECTION"){ // CBS
	        					   sectionComboBox.clearValue();

	        					   calendarComboBox.setVisible(true);
	        					   academicTermComboBoxCBS.setVisible(true);
	        					   courseComboBoxCBS.setVisible(true);
	        					   sectionComboBoxCBS.setVisible(true);
		        				   startDateBox.setVisible(true);
		        				   tillDateBox.setVisible(true);

	        					   courseComboBoxCBS.setDisabled(true);
	        					   sectionComboBoxCBS.setDisabled(true);

	        					   startDateBox.setMinValue(false);
	        					   startDateBox.setMaxValue(false);
	        					   tillDateBox.setMinValue(false);
	        					   tillDateBox.setMaxValue(false);

	        					   me.setAllowBlank(calendarComboBox,false);
		        				   me.setAllowBlank(courseComboBoxCBS,false);
		        				   me.setAllowBlank(sectionComboBoxCBS,false);
		        				   me.setAllowBlank(startDateBox,false);
		        				   me.setAllowBlank(tillDateBox,false);
		        				   
		        				   var  academicTermComboStore = academicTermComboBoxCBS.getStore();
		        				   academicTermComboStore.getProxy().extraParams = {
		        					   academyLocationIds : academyLocationId
		        				   };
		        				   academicTermComboStore.load({
		        					   callback: function(rec, success) {
		        						   if (success) {
		        							   for(var i in rec){
		        								   if(rec[i].get('sequence')==1){
		        									   academicTermComboBoxCBS.setValue(rec[i].get('id'));
		        								   }
		        							   }
		        						   }
		        					   }
		        				   });
	        				   }
	        				   else if(sectionType=="PROGRAM_BATCH_SECTION"){ // PBS
	        					   courseComboBoxCBS.clearValue();
	        					   sectionComboBoxCBS.clearValue();

	        					   calendarComboBox.setVisible(true);
	        					   batchComboBox.setVisible(true);
	        					   if(wheatherSchool){
		        					   periodComboBox.setVisible(false); 
		        				   }else{
		        					   periodComboBox.setVisible(true);
		        				   }
	        					   sectionComboBox.setVisible(true);
		        				   startDateBox.setVisible(true);
		        				   tillDateBox.setVisible(true);

	        					   batchComboBox.setDisabled(true);
	        					   periodComboBox.setDisabled(true);
	        					   sectionComboBox.setDisabled(true);
	        					   
	        					   me.setAllowBlank(calendarComboBox,false);
		        				   me.setAllowBlank(batchComboBox,false);
		        				   me.setAllowBlank(periodComboBox,false);
		        				   me.setAllowBlank(sectionComboBox,false);
		        				   me.setAllowBlank(startDateBox,false);
		        				   me.setAllowBlank(tillDateBox,false);
		        				   
	        				   }
	        				   else if(sectionType=="ACADEMIC_TERM") { // Academic term
	        					   sectionComboBox.clearValue();
	        					   courseComboBoxCBS.clearValue();
	        					   sectionComboBoxCBS.clearValue();

	        					   calendarComboBox.setVisible(true);
	        					   academicTermComboBoxCBS.setVisible(true);
		        				   startDateBox.setVisible(true);
		        				   tillDateBox.setVisible(true);
	        					   
	        					   startDateBox.setMinValue(false);
	        					   startDateBox.setMaxValue(false);
	        					   tillDateBox.setMinValue(false);
	        					   tillDateBox.setMaxValue(false);

	        					   me.setAllowBlank(calendarComboBox,false);
		        				   me.setAllowBlank(academicTermComboBoxCBS,false);
		        				   me.setAllowBlank(startDateBox,false);
		        				   me.setAllowBlank(tillDateBox,false);
		        				   
		        				   academicTermWiseProgBatch.setVisible(true);
		        				   academicTermWisePeriod.setVisible(true);
		        				   academicTermWiseCourse.setVisible(true);
		        				   academicTermWiseSection.setVisible(true);
		        				   
		        				   var  academicTermComboStore = academicTermComboBoxCBS.getStore();
		        				   academicTermComboStore.getProxy().extraParams = {
		        					   academyLocationIds : academyLocationId
		        				   };
		        				   academicTermComboStore.load({
		        					   callback: function(rec, success) {
		        						   if (success) {
		        							   for(var i in rec){
		        								   if(rec[i].get('sequence')==1){
		        									   academicTermComboBoxCBS.setValue(rec[i].get('id'));
		        									   var progBatchStore = academicTermWiseProgBatch.getStore();
		        									   progBatchStore.getProxy().extraParams = {
		       	    					   					academicTermId : rec[i].get('id')
		       	    					   				};
		        									   progBatchStore.load();
		        								   }
		        							   }
		        						   }
		        					   }
		        				   });
	        				   }
	        				   calendarComboBox.validate();
	        				   batchComboBox.validate();
	        				   academicTermComboBoxCBS.validate();
	        				   courseComboBoxCBS.validate();
	        				   componentComboBoxCBS.validate();
	        				   sectionComboBoxCBS.validate();
	        				   periodComboBox.validate();
	        				   sectionComboBox.validate();
	        				   startDateBox.validate();
	        				   tillDateBox.validate();
	        				   
	        				   calendarComboBox.clearInvalid();
	        				   batchComboBox.clearInvalid();
	        				   academicTermComboBoxCBS.clearInvalid();
	        				   courseComboBoxCBS.clearInvalid();
	        				   componentComboBoxCBS.clearInvalid();
	        				   sectionComboBoxCBS.clearInvalid();
	        				   periodComboBox.clearInvalid();
	        				   sectionComboBox.clearInvalid();
	        				   startDateBox.clearInvalid();
	        				   tillDateBox.clearInvalid();
	        			   }
	        		   },
	          			 'extendmastertimetableform customcombobox#calendarId': {
		        			   select: function(obj, record) {
		        				   var calendarId = record[0].get("id");
		        				   if(calendarId > 0){
		        					   var form = this.getExtendmastertimetableform();
		        					   form.down('#whetherDayWiseScheduleId').setValue(record[0].get("whetherDayWiseSchedule"));
		        					   var sectionType = this.getExtendmastertimetableform().getForm().findField('sectionType').getValue();
		        					   if(sectionType=="COURSE_SECTION"){ // CBS
		        						   form.down("#courseId").setDisabled(false);
			        					   var courseCombo = this.getExtendmastertimetableform().down('#courseId');
			        					   courseCombo.clearValue();
			        					   var sectionCombo=this.getExtendmastertimetableform().down('#courseSection_Id');
			        					   sectionCombo.clearValue();
			        					   sectionCombo.setDisabled(true);
			        					   var academicTermId=this.getExtendmastertimetableform().down('#academicTerm').getValue();
			        					   var courseStore = courseCombo.getStore();
			        					   courseStore.getProxy().extraParams = {
			        						   calendarId: calendarId,
			        						   sectionType: 'CourseSection',
			        						   academicTermId:academicTermId,
			        					   };
			        					   courseStore.load();
		        					   }else if(sectionType=="PROGRAM_BATCH_SECTION"){
			        					   form.down("#batchId").setDisabled(false);
			        					   var batchCombo = this.getExtendmastertimetableform().down('#batchId');
			        					   var batchStore = batchCombo.getStore();
			        					   batchStore.getProxy().extraParams = {
			        						   calendarId: calendarId
			        					   };
			        					   batchStore.load();
		        					   }
		        				   }
		        			   }
		        		   },
		        		   'extendmastertimetableform customcombobox#academicTerm':{
		        			   select: function(obj, record) {
		        				   var calendarId = this.getExtendmastertimetableform().down('#calendarId').getValue();
		        				   if(calendarId > 0){
		        					   var form = this.getExtendmastertimetableform();
		        					   var sectionType = this.getExtendmastertimetableform().getForm().findField('sectionType').getValue();
		        					   if(sectionType=="COURSE_SECTION"){ // CBS
		        						   form.down("#courseId").setDisabled(false);
		        						   var courseCombo = this.getExtendmastertimetableform().down('#courseId');
		        						   courseCombo.clearValue();
		        						   var sectionCombo=this.getExtendmastertimetableform().down('#courseSection_Id');
		        						   sectionCombo.clearValue();
			        					   sectionCombo.setDisabled(true);
			        					   var courseComponentBox = this.getExtendmastertimetableform().down('customcombobox#componentSectionId');
			        					   courseComponentBox.clearValue();
			        					   courseComponentBox.hide();
			        					   
		        						   var academicTermId=this.getExtendmastertimetableform().down('#academicTerm').getValue();
		        						   var courseStore = courseCombo.getStore();
		        						   courseStore.getProxy().extraParams = {
		        							   calendarId: calendarId,
		        							   sectionType: 'CourseSection',
		        							   academicTermId:academicTermId,
		        						   };
		        						   courseStore.load();
		        					   }
		        				   }
		        				   var sectionType1 = this.getExtendmastertimetableform().getForm().findField('sectionType').getValue();
	    					   		if(sectionType1=="ACADEMIC_TERM"){
	    					   			var searchForm = this.getExtendmastertimetableform();
	    					   			var progBatchField = searchForm.down('#academicTermWiseProgBatch');
	    					   			progBatchField.clearValue();
	    					   			var progBatchStore = progBatchField.getStore();
	    					   			progBatchStore.getProxy().extraParams = {
	    					   				academicTermId : searchForm.down('#academicTerm').getValue()
	    					   			};
	    					   			progBatchStore.load();
	    					   		}
		        			   }
		        		   },
		        		   'extendmastertimetableform multiselectcombofield#academicTermWiseProgBatch':{
		        			   change: function(obj, record) {
		        				   var form = this.getExtendmastertimetableform();
		        				   var sectionType = form.getForm().findField('sectionType').getValue();
	    					   		if(sectionType=="ACADEMIC_TERM"){
	    					   			var periodField = form.down('#academicTermWisePeriod');
	    					   			periodField.clearValue();
	    					   			periodField.setDisabled(true);
	    					   			var courseField = form.down('#academicTermWiseCourse');
	    					   			courseField.clearValue();
	    					   			courseField.setDisabled(true);
	    					   			var batchIds = form.down('#academicTermWiseProgBatch').getValue();
	    					   			var batchIdArr=[];
	    	        	 				var batchIdVal = batchIds;
	    	        	 				var batchIdVals = null;
	    	        	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
	    	        						for (var i in batchIdVal) {
	    	        							if (Ext.isObject(batchIdVal[0])) {
	    	        								batchIdArr.push(batchIdVal[i].get("id"));
	    	        							} else {
	    	        								batchIdArr.push(batchIdVal[i]);
	    	        							}
	    	        						}
	    	        						batchIdVals = batchIdArr.join();
	    	        					}
	    	        					else if(!isNullOrEmpty(batchIdVal)){
	    	        						batchIdVals = batchIdVal;
	    	        					}
	    	        	 				if(!isNullOrEmpty(batchIds) && batchIds.length > 0){
	    	        	 					periodField.setDisabled(false);
	    	        	 					var periodStore = periodField.getStore();
		    					   			periodStore.getProxy().extraParams = {
		    					   				academicTermId : form.down('#academicTerm').getValue(),
		    					   				batchIds : batchIdVals,
		    					   				sectionType : 'CourseSection'
		    					   			};
		    					   			periodStore.load();
		    					   			courseField.setDisabled(false);
		    					   			var courseStore = courseField.getStore();
		    					   			courseStore.getProxy().extraParams = {
		    					   				academicTermId : form.down('#academicTerm').getValue(),
		    					   				batchIds : batchIdVals,
		    					   				sectionType : 'CourseSection'
		    					   			};
		    					   			courseStore.load();
	    	        	 				}
	    					   		}
		        			   }
		        		   },
		        		   'extendmastertimetableform multiselectcombofield#academicTermWisePeriod':{
		        			   change: function(obj, record) {
		        				   var form = this.getExtendmastertimetableform();
		        				   var sectionType = form.getForm().findField('sectionType').getValue();
	    					   		if(sectionType=="ACADEMIC_TERM"){
	    					   			var courseField = form.down('#academicTermWiseCourse');
	    					   			courseField.clearValue();
	    					   			courseField.setDisabled(true);
	    					   			var batchIds = form.down('#academicTermWiseProgBatch').getValue();
	    					   			var batchIdArr=[];
	    	        	 				var batchIdVal = batchIds;
	    	        	 				var batchIdVals = null;
	    	        	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
	    	        						for (var i in batchIdVal) {
	    	        							if (Ext.isObject(batchIdVal[0])) {
	    	        								batchIdArr.push(batchIdVal[i].get("id"));
	    	        							} else {
	    	        								batchIdArr.push(batchIdVal[i]);
	    	        							}
	    	        						}
	    	        						batchIdVals = batchIdArr.join();
	    	        					}
	    	        					else if(!isNullOrEmpty(batchIdVal)){
	    	        						batchIdVals = batchIdVal;
	    	        					}
	    	        	 				var periodIds = form.down('#academicTermWisePeriod').getValue();
	    					   			var periodIdArr=[];
	    	        	 				var periodIdVal = periodIds;
	    	        	 				var periodIdVals = null;
	    	        	 				if (!isNullOrEmpty(periodIdVal) && periodIdVal.length > 0 && !isNullOrEmpty(periodIdVal[0])) {
	    	        						for (var i in periodIdVal) {
	    	        							if (Ext.isObject(periodIdVal[0])) {
	    	        								periodIdArr.push(periodIdVal[i].get("id"));
	    	        							} else {
	    	        								periodIdArr.push(periodIdVal[i]);
	    	        							}
	    	        						}
	    	        						periodIdVals = periodIdArr.join();
	    	        					}
	    	        					else if(!isNullOrEmpty(periodIdVal)){
	    	        						periodIdVals = periodIdVal;
	    	        					}
	    					   			courseField.setDisabled(false);
	    					   			var courseStore = courseField.getStore();
	    					   			courseStore.getProxy().extraParams = {
	    					   				academicTermId : form.down('#academicTerm').getValue(),
	    					   				batchIds : batchIdVals,
	    					   				periodIds : periodIdVals,
	    					   				sectionType : 'CourseSection'
	    					   			};
	    					   			courseStore.load();
	    					   		}
		        			   }
		        		   },
		        		   'extendmastertimetableform multiselectcombofield#academicTermWiseCourse':{
		        			   change: function(obj, record) {
		        				   var form = this.getExtendmastertimetableform();
		        				   var sectionType = form.getForm().findField('sectionType').getValue();
	    					   		if(sectionType=="ACADEMIC_TERM"){
	    					   			var sectionField = form.down('#academicTermWiseSection');
	    					   			sectionField.clearValue();
	    					   			sectionField.setDisabled(true);
	    					   			var courseIds = form.down('#academicTermWiseCourse').getValue();
	    					   			var courseIdArr=[];
	    	        	 				var courseIdVal = courseIds;
	    	        	 				var courseIdVals = null;
	    	        	 				if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
	    	        						for (var i in courseIdVal) {
	    	        							if (Ext.isObject(courseIdVal[0])) {
	    	        								courseIdArr.push(courseIdVal[i].get("id"));
	    	        							} else {
	    	        								courseIdArr.push(courseIdVal[i]);
	    	        							}
	    	        						}
	    	        						courseIdVals = courseIdArr.join();
	    	        					}
	    	        					else if(!isNullOrEmpty(courseIdVal)){
	    	        						courseIdVals = courseIdVal;
	    	        					}
	    	        	 				if(!isNullOrEmpty(courseIds) && courseIds.length > 0){
	    	        	 					sectionField.setDisabled(false);
		    					   			var sectionStore = sectionField.getStore();
		    					   			sectionStore.getProxy().extraParams = {
		    					   				courseIds : courseIdVals
		    					   			};
		    					   			sectionStore.load();
	    	        	 				}
	    					   		}
		        			   }
		        		   },
		        		   'extendmastertimetableform customcombobox#batchId': {
		        			   select: function(obj, record) {
		        				   var $this = this;
		        				   var batchId = record[0].get("id");
		        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
		        				   var wheatherSchool = alinfomodel.get('wheatherSchool');
		        				   var form = this.getExtendmastertimetableform();
                                   form.down('#periodId').reset();
		        				   form.down('#sectionId').reset();
		        				   if(wheatherSchool) {
		        					   form.down('#periodId').setVisible(false);
		        				   }
		        				   form.down("#periodId").setDisabled(false);
		        				   var periodCombo = this.getExtendmastertimetableform().down('#periodId');
		        				   var periodStore = periodCombo.getStore();
		        				   periodStore.getProxy().extraParams = {
		        					   id: batchId
		        				   };
		        				   periodStore.load({
		        					   callback: function(rec, operation, success) {
		        						   if (success) {
		        							   if(rec.length == 0){
		        								   if(wheatherSchool) {
		        									   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		        								   }
		        							   } else if(rec.length == 1){
		        								   if(wheatherSchool) {
		        									   form.down('#periodId').setVisible(false);
		        								   }
		        								   form.down('#periodId').setValue(rec[0].get("id"));

		        								   form.down("#sectionId").setDisabled(false);
		        								   var sectionCombo = form.down('#sectionId');

		        								   var sectionStore = sectionCombo.getStore();
		        								   sectionStore.getProxy().extraParams = {
		        									   periodId: rec[0].get("id")
		        								   };
		        								   sectionCombo.setValue('');
		        								   sectionCombo.reset();
		        								   sectionStore.load({
													   callback:function(records, success) {
														   if(success){
															   if(records.length==1){
																   sectionCombo.setValue(records[0].get('sectionId'));
															   }	            	                					   	            	                					   
														   }
													   }
		        								   });
		        								   $this.generateDetailedDate(rec[0].get("id"),form);
		        							   } else {
		        								   form.down('#periodId').setVisible(true);
		        								   form.down('#periodId').setValue('');
		        								   form.down('#periodId').reset();
		        							   }
		        						   }
		        					   }
		        				   });
		        			   }
		        		   },
		        		   'extendmastertimetableform customcombobox#periodId': {
		        			   select: function(obj, record) {
		        				   var $this = this;
		        				   var periodId = record[0].get("id");
		        				   var form = this.getExtendmastertimetableform();
		        				   form.down('#sectionId').reset();
		        				   if(periodId > 0){
		        					   var form = this.getExtendmastertimetableform();
		        					   form.down("#sectionId").setDisabled(false);
		        					   var sectionCombo = this.getExtendmastertimetableform().down('#sectionId');
		        					   var sectionStore = sectionCombo.getStore();
		        					   sectionStore.getProxy().extraParams = {
		        						   periodId: periodId
		        					   };
		        					   sectionStore.load();
		        					   this.generateDetailedDate(periodId,form);   
		        				   }
		        			   }
		        		   },
		        		   'extendmastertimetableform customcombobox#courseId' : {
		          			   select : function(obj, record) {
		          				   var  me = this;
		          				   var courseId = record[0].get("courseId");
		          				   var alinfomodel = Academia.model.authentication.ALInfoModel;
			                	   var wheatherSchool = alinfomodel.get('wheatherSchool');
			                	   var form=this.getExtendmastertimetableform();
			                	   var courseComponentBox = this.getExtendmastertimetableform().down('customcombobox#componentSectionId');
		          				   var sectionBox = this.getExtendmastertimetableform().down('customcombobox#courseSection_Id');
		          				   courseComponentBox.clearValue();
		          				   sectionBox.clearValue();
		          				   if(record[0].get("sectionAtComponentLevel")){
		          					   courseComponentBox.show();
		          					   me.setAllowBlank(courseComponentBox,false);
		          					   var store = courseComponentBox.getStore();
		          					   store.getProxy().extraParams = {
		          						   id: courseId,
		          						   wheatherSchool:wheatherSchool
		          					   };
		          					   store.load();
		          				   }
		          				   else {
		          					   var courseComboBox = this.getExtendmastertimetableform().down('customcombobox#courseSection_Id');
		          					   var academicTermId = this.getExtendmastertimetableform().down('customcombobox#academicTerm').getValue();
		          					   courseComboBox.clearValue();
		          					   courseComponentBox.hide();
		          					   me.setAllowBlank(courseComponentBox,true);
		          					   sectionBox.setDisabled(false);
		          					   var courseStore = courseComboBox.getStore();
		          					   courseStore.getProxy().extraParams = {
		          						   parentCourseId: courseId,
		          						   wheatherSchool:wheatherSchool,
		          						   academicTermId:academicTermId
		          					   };
		          					   courseStore.load({

										   callback: function(records, operation, success) {
											   if (success) {
												  
												   if(records.length==1){
													   sectionBox.setValue(records[0].get('sectionId'));
												   }
											   }
										   }
		        					 });
		          				   }
		          				   courseComponentBox.validate();
		          				   courseComponentBox.clearInvalid();
								   form.isValid();

		          			   }
		          		   },
		          		 'extendmastertimetableform customcombobox#componentSectionId' : {
		          			   select : function(obj, record) {
		          				   var componentId = record[0].get("id");
		          				   var alinfomodel = Academia.model.authentication.ALInfoModel;
			                	   var wheatherSchool = alinfomodel.get('wheatherSchool');
		          				   var form=this.getExtendmastertimetableform();
		          				   var courseId = this.getExtendmastertimetableform().getForm().findField('course').getValue();
		          				   var sectionBox = this.getExtendmastertimetableform().down('customcombobox#courseSection_Id');
		          				   var academicTermId = this.getExtendmastertimetableform().down('customcombobox#academicTerm').getValue();
		          				   sectionBox.setDisabled(false);
		          				   sectionBox.clearValue();
		          				   var store = sectionBox.getStore();
		          				   store.getProxy().extraParams = {
		          					   componentId : componentId,
		          					   parentCourseId : courseId,
		          					   wheatherSchool:wheatherSchool,
	          						   academicTermId:academicTermId
		          				   };
		          				   store.load();
								   form.isValid();
		          			   }
		          		   },
	        		   'timetableprogambatchgrid button#btnDelete':{
	        			   click: function(obj) {
	        				  var $this = this;
	        				  var grid = $this.getTimetableprogambatchgrid();
	        				  if(grid.getSelectionModel().getCount()>0){
	        					  showConfirmMessage(getCommonTranslation('TIME_TABLE_SESSIONS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	        							  function(btn, text) {
	        						  if (btn == 'yes') {
	        							  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        							  var records = grid.getSelectionModel().getSelection();
	    	        					  var ids=[];
	    	        					  var calendarEventIds=[];
	    	        					  for (var i in records) {
	    	        						  ids.push(records[i].data.id);
	    	        						  calendarEventIds.push(records[i].data.calendarEventId);
	    	        					  }
	        							  Ext.Ajax.request({
	        								  method : "DELETE",
	        								  type : 'rest',
	        								  url : SERVERURL.DELETE_VIEW_TIMETABLE+ '?ids='+ ids.join()+'&calendarEventIds='+calendarEventIds.join(),
	        								  headers : {
	        									  'Content-Type' : 'application/json'
	        								  },
	        								  params : {
	        									  ids : ids
	        								  },
	        								  success : function(form,action) {
	        									  Ext.getBody().unmask();
	        									  showSuccessMessage(getCommonTranslation('TIME_TABLE_SESSIONS'),getCommonTranslation('SUCCESS'));
	        									  grid.getStore().reload();
	        								  }
	        							  });
	        						  }
	        					  });
	        				  } else {
	        					  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        				  }
	        			   }
	        		   },
	        		   'timetableprogambatchgrid button#exportReport':{
	        			   click: function(obj) {
	        				   var $this = this;
								var tempalte = $this.getStore('setup.templatemapping.TemplateNameListFacultyByCode');
		      				    tempalte.getProxy().extraParams={
		     					    reportType:'Timetable',
		     					   isMasterTimetable:true
		     					    
		  				   };
		      				   tempalte.load({
			   					   callback:function(record) {
			   						   if(record.length==1) {
			   							$this.downloadMasterTimetablePDF(record[0].data.value);
			   						   } else {
			   							   var formWindow = $this.getGeneratematertimetablereportwin();
			  							   if (!formWindow) {
			  								   formWindow = Ext.widget('generatetabulationreportwin',{
			       				        			itemId:'generatematertimetablereportwin'
			       				        	   });
			  							   }
			   							   formWindow.setHeight(160);
			   							   formWindow.setWidth(500);
			   							   formWindow.show();
			   							   var tempalte = formWindow.down('#chooseTemplate').getStore();
			   							   tempalte.getProxy().extraParams={
			   								   reportType:'Timetable',
					     					   isMasterTimetable:true
			   							   };
			   							   tempalte.load();
			   						   }
			   					   }
			   				  });
		      				    
	        				  
	        			   }
	        		   },
	        		   'mastersearchfilter customcombobox#batchId': {
	        			   select: function(obj, record) {
	        				   var $this = this;
	        				   var batchId = record[0].get("id");
	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   var form = this.getMastersearchfilter();
	        				   var academicTermId = form.down('customcombobox#academicTerm').getValue();
	        				   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	        				   mainCalendarPanel.setVisible(false);
	        				   form.down('#sectionId').reset();
	        				   if(wheatherSchool) {
	        					   form.down('#periodId').setVisible(false);
	        				   }
	        				   form.down("#periodId").setDisabled(false);
	        				   var periodCombo = this.getMastersearchfilter().down('#periodId');
	        				   var periodStore = periodCombo.getStore();
	        				   periodStore.getProxy().extraParams = {
	        					   batchId: batchId,
          						   academicTermId:academicTermId
	        				   };
	        				   periodStore.load({
	        					   callback: function(rec, operation, success) {
	        						   if (success) {
	        							   if(rec.length == 0){
	        								   if(wheatherSchool) {
	        									   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	        								   }
	        							   } else if(rec.length == 1){
	        								   if(wheatherSchool) {
	        									   form.down('#periodId').setVisible(false);
	        								   }
	        								   form.down('#periodId').setValue(rec[0].get("id"));
	        								   //form.down("#tillDate").allowBlank=true;
	        								   //form.down("#startDate").allowBlank=true;

	        								   form.down("#sectionId").setDisabled(false);
	        								   var sectionCombo = form.down('#sectionId');

	        								   var sectionStore = sectionCombo.getStore();
	        								   sectionStore.getProxy().extraParams = {
	        									   periodId: rec[0].get("id"),
	        	          						   academicTermId:academicTermId
	        								   };
	        								   sectionStore.load({

												   callback:function(records, success) {
													   if(success){
														   if(records.length==1){
															   sectionCombo.setValue(records[0].get('id'));
														   }	            	                					   	            	                					   
													   }
												   }
											   
	        								   });
	        								   //$this.generateDetailedDate(rec[0].get("id"),form);
	        								   
	        							   } else {
	        								   form.down('#periodId').setVisible(true);
	        							   }
	        						   }
	        					   }
	        				   });
	        			   }
	        		   },
	        		   'mastersearchfilter customcombobox#periodId': {
	        			   select: function(obj, record) {
	        				   var periodId = record[0].get("id");
	        				   if(periodId > 0){
	        					   var form = this.getMastersearchfilter();
	        					   var academicTermId = form.down('customcombobox#academicTerm').getValue();
	        					   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
	        					   mainCalendarPanel.setVisible(false);
	        					   //form.down("#tillDate").allowBlank=true;
	        					   //form.down("#startDate").allowBlank=true;
	        					   
	        					   form.down("#sectionId").setDisabled(false);
	        					   var sectionCombo = this.getMastersearchfilter().down('#sectionId');
	        					   sectionCombo.reset();
	        					   sectionCombo.clearValue();
	        					   
	        					   var sectionStore = sectionCombo.getStore();
	        					   sectionStore.getProxy().extraParams = {
	        						   periodId: periodId,
	          						   academicTermId:academicTermId
	        					   };
	        					   sectionStore.load({
									   callback: function(records, operation, success){
										   if(records.length == 1){
											   sectionCombo.setValue(records[0].data.id);  
										   }
									   }
								   });
	        					//this.generateDetailedDate(periodId,form);   
	        				   }
	        			   }
	        		   },
	        		   'mastersearchfilter customcombobox#sectionId': {
	        			   select: function(obj, record) {
	        				   var form = this.getMastersearchfilter();
        					   var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
        					   mainCalendarPanel.setVisible(false);
	        			   }
	        		   },
	        		   'mastertimetabledetailedwindow customcombobox#weekDayId': {
	        			   select: function(obj, record) {
	        				   var weekday = record[0].get("code");
	        				   var masterSearchFilterForm = this.getMastersearchfilter();
	        				   var filterForm = masterSearchFilterForm.getForm();
	        				   var values = filterForm.getValues();
	        				   var calendarId = values.calendar;
	        				   var academicTermId=values.ACADEMIC_TERM;
	        				   var sectionId = values.section;
	        				   // For CBS
	        				   var courseVariantId;
	        				   if(isNullOrEmpty(sectionId)){
	        					   sectionId = values.courseSection;
	        					   courseVariantId = values.courseVariantId;
	        				   }
	        				   var masterDetailedForm = this.getMastertimetableDetailedwindow();
	        				   var values = masterDetailedForm.getForm().getValues();

	        				   var variantId = values.variant;
	        				   var facultyId = values.faculty;
	        				   if(isNullOrEmpty(variantId)){
	        					   variantId = courseVariantId;
	        				   }

	        				   var periodCombo = masterDetailedForm.down('#periodTimingsId');
	        				   periodCombo.setDisabled(false);
	        				   var periodStore = periodCombo.getStore();
	        				   periodStore.getProxy().extraParams = {
	        					   weekDay: weekday,
	        					   calendarId:calendarId,
	        					   academicTermId:academicTermId,
	        					   sectionId:sectionId,
	        					   variantId:variantId,
	        					   facultyId:facultyId

	        				   };
	        				   periodStore.load();
	        				   
	        			   }
	        		   },
	        		   'mastertimetabledetailedwindow customcombobox#roomId': {

                           select: function(obj, record) {
                               var form = obj.up('form').getForm();
                               if(form.isValid()){
                                   obj.up('form').down('#SubmitBtn').setDisabled(false);
                               }    
                           }
                       },
	        		   
	        		   'mastertimetabledetailedwindow customcombobox#facultyId': {
	        			   select: function(obj, record) {
	        				   var courseVariantId = record[0].get("id");
	        				   var masterDetailedForm = this.getMastertimetableDetailedwindow();
	        				   var weekDayCombo = masterDetailedForm.down('#weekDayId');
	        				   weekDayCombo.reset();
	        				   weekDayCombo.setDisabled(false);
	        			   }
	        		   },
	        		   'mastertimetabledetailedwindow customcombobox#variantId': {
	        			   select: function(obj, record) {
	        				   var courseVariantId = record[0].get("id");
	        				   var masterDetailedForm = this.getMastertimetableDetailedwindow();
	        				   
	        				   var facultyCombo = masterDetailedForm.down('#facultyId');
	        				   facultyCombo.setDisabled(false);
	        				   var facultyStore = facultyCombo.getStore();
	        				   facultyStore.getProxy().extraParams.courseVariantId= courseVariantId
	        				   facultyStore.load();
	        				   
	        				   var facultyDepartmentCombo = masterDetailedForm.down('#facultyDepartmentId');
	        				   var facultyDepartmentStore = facultyDepartmentCombo.getStore();
	        				   facultyDepartmentStore.getProxy().extraParams.courseVariantId= courseVariantId
	        				   facultyStore.load();

	        			   }
	        		   },
	        		   'mastersearchfilter button[itemId=viewCalanderId]' : {
	        			   click : function(btn) {
	        				   //this.openCalendarWin();
	        				   this.openInSameTab(btn);
	        			   }
	        		   },
	        		   'extendmastertimetableform button[itemId=generateDetailedId]' : {
	        			   click : function(btn) {
	        				   this.generateDetailed(btn);
	        			   },
	        			   enable : function( btn, eOpts ){
	        				   btn.up().down('#viewSchedulesBtnItemId').setDisabled(false);
	        			   },
	        			   disable : function( btn, eOpts ){
	        				   btn.up().down('#viewSchedulesBtnItemId').setDisabled(true);
	        			   }
	        		   },
	        		   'extendmastertimetableform button[itemId=viewSchedulesBtnItemId]' : {
	        			   click : function(btn) {
	        				   var me = this;
	        				   var form = btn.up('form');
	        				   var formValues = form.getValues();
	        				   var innerTabPanel = btn.up('tabpanel');
	        				   innerTabPanel.setActiveTab(innerTabPanel.activeTab.next());

	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				   var wheatherSchool = alinfomodel.get('wheatherSchool');

	        				   var masterTimeTableFilterForm = innerTabPanel.getActiveTab().down('form');
	        				   masterTimeTableFilterForm.getForm().reset();
	        				   var sectionTypeField = masterTimeTableFilterForm.down('[name=sectionType]');

	        				   if(formValues.sectionType=="PROGRAM_BATCH_SECTION"){
	        					   sectionTypeField.setValue('CBS');
	        					   setTimeout(function(){
	        						   sectionTypeField.setValue('PBS');
	        						   setTimeout(function(){
	        							   var programBatchStore = form.down('#batchId').getStore();
	        							   var programBatchRecordCount = programBatchStore.find('id',formValues.batch);
	        							   if(programBatchRecordCount>=0){
	        								   var programBatchRecord = programBatchStore.getAt(programBatchRecordCount);
	        								   var programId = programBatchRecord.get('programId');

	        								   var programIdField = masterTimeTableFilterForm.down('#programId');
	        								   programIdField.getStore().getProxy().extraParams.programName = '';
	        								   
	        								   programIdField.getStore().load({
	        									   callback: function(){
	    	        								   programIdField.setValue(programId);
	        									   }
	        								   });
	        								   
	        								   //--
	        								   var batchField = masterTimeTableFilterForm.down('#batchId');
	        								   batchField.clearValue();
	        								   batchField.setDisabled(false);
	        								   var batchStore = batchField.getStore();
	        								   batchStore.getProxy().extraParams = {
	        									   programId : programId
	        								   };
	        								   batchStore.load({
	        									   callback: function(records, operation, success) {
	        										   if (success) {
	        											   if(records.length){
	        												   batchField.setValue(formValues.batch);
	        												   var batch_Id = formValues.batch;

	        												   var periodField = masterTimeTableFilterForm.down('#periodId');
	        												   periodField.clearValue();
	        												   periodField.setDisabled(false);
	        												   var periodStore = periodField.getStore();
	        												   periodStore.getProxy().extraParams = {
	        													   batchId : batch_Id
	        												   };
	        												   periodStore.load({
	        													   callback: function(records, operation, success) {
	        														   if (success) {
	        															   if(records.length){
	        																   periodField.setValue(formValues.period);
	        																   if(wheatherSchool) {
	        																	   periodField.setVisible(false);
	        																   }
	        																   else{
	        																	   periodField.setVisible(true);
	        																   }

	        																   var programCourseComboBox = me.getProgramcoursefilters().down('#courseId_1');
	        																   programCourseComboBox.clearValue();
	        																   programCourseComboBox.setDisabled(false);
	        																   var programBatchStore =programCourseComboBox.getStore(); 
	        																   programBatchStore.getProxy().extraParams = {	
	        																	   periodId: formValues.period,
	        																	   sectionType : 'ProgramBatchSection'
	        																   };
	        																   programBatchStore.load();

	        																   var sectionBox = me.getProgramcoursefilters().down('#courseSection_Id_1');
	        																   sectionBox.clearValue();

	        																   var facultyByCriteriaStore = me.getProgramcoursefilters().down('#facultyId').getStore();
	        																   facultyByCriteriaStore.getProxy().extraParams = {
	        																	   periodId:formValues.period,
	        																	   sectionType:'ProgramBatchSection'
	        																   };
	        																   facultyByCriteriaStore.load();
	        																   
	        																   masterTimeTableFilterForm.down('#withoutMasterTimetableId').setValue(false);

	        																   var searchBtn = masterTimeTableFilterForm.down('#quickSearchId');
	        																   searchBtn.fireEvent('click',searchBtn);
	        															   }
	        														   }
	        													   }
	        												   });					        			        			 
	        											   }
	        										   }
	        									   }
	        								   });
	        							   }
	        						   },10);
	        					   },10);
	        				   }
	        				   else{
	        					   sectionTypeField.setValue('PBS');
	        					   setTimeout(function(){
	        						   sectionTypeField.setValue('CBS');
	        						   setTimeout(function(){
	        							   var academicTermField = masterTimeTableFilterForm.down('#academicTerm');
	        							   academicTermField.getStore().load({
	        								   callback: function(){
	        									   academicTermField.setValue(formValues.ACADEMIC_TERM);

	        									   var academyLocationId = me.getCurrentAcademyLocation();
	        									   var courseIdField = masterTimeTableFilterForm.down('#courseId');
	        									   var academicTermId=me.getProgramcoursefilters().down('#academicTerm').getValue();
	        									   var courseStore = courseIdField.getStore();

	        									   courseStore.getProxy().extraParams = {
	        										   sectionType : 'CourseSection',
	        										   academyLocationIds : academyLocationId,
	        										   academicTermId:academicTermId
	        									   };

	        									   courseStore.load({
	        										   callback: function(records, operation, success){
	        											   var courseId;
	        											   if(formValues.course > 0) {
	        												   if(!isNullOrEmpty(formValues.component)){
		        												   var foundRecInd = courseStore.findBy(function(record) {
		        									                   if (record.data.parentCourseId == formValues.course && 
		        									                		   record.data.componentId == formValues.component) {
		        									                       return true;
		        									                   }
		        									               });
		        									               var foundRec = courseStore.getAt(foundRecInd);
		        									               courseIdField.setValue(foundRec.data.id);
		        												   courseId = foundRec.data.id;
		        											   } else {
		        												   courseIdField.setValue(formValues.course);
		        												   courseId = formValues.course;
		        											   }
		        											   var sectionBox = me.getProgramcoursefilters().down('#courseSection_Id');
		        											   sectionBox.clearValue();
		        											   try{
		        												   sectionBox.setDisabled(false);
		        											   }
		        											   catch(e){
		        											   }
		        											   var sectionStore = sectionBox.getStore();
		        											   sectionStore.getProxy().extraParams = {
		        												   courseId : courseId,
		    	        										   academicTermId:academicTermId
		        											   };
		        											   sectionStore.load({
		        												   callback: function(records, operation, success){
		        													   var section = formValues.courseSection;
		        													   sectionBox.setValue(section);
		        													   sectionBox.setValue(section);
		        													   var facultyByCriteriaStore = me.getProgramcoursefilters().down('#facultyId').getStore();
		        													   facultyByCriteriaStore.getProxy().extraParams = {
		        														   academyLocationIds:academyLocationId,
		        														   courseId:courseId,
		        														   academicTermId:academicTermId,
		        														   sectionId:formValues.courseSection
		        													   };
		        													   facultyByCriteriaStore.load();
		        													   masterTimeTableFilterForm.down('#withoutMasterTimetableId').setValue(false);

		        													   var searchBtn = masterTimeTableFilterForm.down('#quickSearchId');
		        													   searchBtn.fireEvent('click',searchBtn);
		        												   }
		        											   });
	        											   } else {
	        												   var searchBtn = masterTimeTableFilterForm.down('#quickSearchId');
        													   searchBtn.fireEvent('click',searchBtn);
	        											   }
	        										   }
	        									   });
	        								   }
	        							   });
	        						   },500);
	        					   },10);
	        				   }
	        			   }
	        		   },
	        		   'extendmastertimetableform button[itemId=resetBtn]' : {
	        			   click : function(btn) {
	        				   var structure = this.getExtendmastertimetable();
	        				   var form = structure.down('extendmastertimetableform');
	        				   form.destroy();
	        				   structure.insert(0,{xtype:'extendmastertimetableform'});
	        				   /*var extendmastertimetableform =btn.up('extendmastertimetableform');
	        				   var extendmastertimetable = btn.up('extendmastertimetable');
	        				   extendmastertimetableform.destroy();
	        				   extendmastertimetable.insert(0,{xtype:'extendmastertimetableform'});*/
	        			   }
	        		   },
	        		   'extendmastertimetableform':{
	        			   validitychange: function( form, valid, eOpts ){
	        				   try{
		        				   form.down('#generateDetailedId').setDisabled(!valid);
	        				   }
	        				   catch(e){}
	        			   },
	        			   afterrender: function(form){
	        				   var me =this;
	        				   
	        				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				   if(wheatherSchool){
	        					   form.down('#periodId').hide();
	        				   }
	        				   var sectionType = form.down('#sectionType');
	        				   sectionType.getStore().load();

	        				   //---
	        				   
	        				   var viewSchedulesBtn = form.down('#viewSchedulesBtnItemId');
	        				   var generateBtn = form.down('#generateDetailedId');
	        				   
	        				   viewSchedulesBtn.hide();
	        				   generateBtn.hide();

	        				   var associatedAcadLocationIds = new Array();
	        				   var permissionMap = me.getEXTEND_TIME_TABLE_PERMISSIONS();
	        				   associatedAcadLocationIds.push(me.getCurrentAcademyLocation()); 
	        				   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
	        				   var permissionListArray = [];

	        				   Ext.each(permissionList, function(privilege) {
	        					   if (privilege === 'PROGRAM_BATCH_SECTION') {
	        						   permissionListArray.push('PROGRAM_BATCH_SECTION');
	        					   }
	        					   if (privilege === 'COURSE_SECTION') {
	        						   permissionListArray.push('COURSE_SECTION');
	        					   }
	        					   if (privilege === 'ACADEMIC_TERM') {
	        						   permissionListArray.push('ACADEMIC_TERM');
	        					   }
	        					   
	        					   if (privilege === 'VIEW_SCHEDULES') {
	        						   viewSchedulesBtn.show();
	        					   }
	        					   if (privilege === 'GENERATE') {
	        						   generateBtn.show();
	        					   }
	        				   });

	        				   if(permissionListArray.length == 0){
	        					   permissionListArray.push('PROGRAM_BATCH_SECTION'); // default permission
	        				   }

	        				   form.permissionListArray = permissionListArray;

	        				   //---
	        				   
	        				   me.setTabPbsCbsPermission("extendTimeTable");
	        			   }
	        		   },
	        		   'mastersearchfilter datefield[itemId=startDate]' : {
	        			   select : function() {
	        				   this.generateButtonEnable();
	        			   }
	        		   },'mastersearchfilter datefield[itemId=tillDate]' : {
	        			   select : function() {
	        				   this.generateButtonEnable();
	        			   }
	        		   },
	        		   'mastertimetablecalendar':{
	        			   beforerender : function(obj){
	        				   var mastertimetablecalendar=this.getMastertimetablecalendar();
	        				   this.disablePrintAndExportToPngPivileges(mastertimetablecalendar,this.getMASTER_TIME_TABLE_PRIVILEGES());
	        			   }
	        		   },
	          		 'mastertimetablecalendar button[itemId=addButtonId]' : {
	          			 click : function() {
	          				 this.openDetailedWindow();
	          			 }
	          		 },
	          		'mastertimetablecalendar button[itemId=btnDelete]' : {
	          			 click : function() {
	          				var calendar = this.getMastertimetablecalendar();
	          				var eventId = calendar.down('#eventId').getValue();
	          				if(!isNullOrEmpty(eventId)){
	          					var selectedRecords = new Array();
	          					selectedRecords.push(eventId);
	          					ids = selectedRecords.join();
	          					this.deleteMasterTimeTable(ids);	
	          				}else{
	          					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('EVENT_SELECT')); // Please select a record	
	          				}
	          				 
	          			 }
	          		 },
	          		 /*'mastertimetablecalendar calendarpanel[itemId=viewCalendarId]' : {
	          			render : function(obj) {
	          				 console.log('on render obj',obj);
	          				obj.weekViewCfg.dayCount=4;
	          				obj.weekViewCfg.startDay=4;
	          				
	          				obj.items.items[0].dayCount=4;
	          				
	          			 },
	          			 beforerender : function(obj) {
	          				 console.log('obj',obj);
	          				obj.weekViewCfg ={
	          						dayCount:4		
	          				};
	          			 },
	          			 afterrender : function(obj) {
	          				 console.log('after render of obj',obj);
	          				obj.weekViewCfg.dayCount=4; 
	          			 }
	          		 },*/
	          		 
	          		 'mastertimetablecalendar calendarpanel[itemId=viewCalendarId]' : {
	          			eventclick : function(obj,rec) {
		          				var calendar = this.getMastertimetablecalendar();
		          				calendar.down('#eventId').setValue(rec.data.EventId);
		          				
		          			 }
		          	},
	          		'mastertimetabledetailedwindow button[itemId=SubmitBtn]' : {
	          			click : function(btn) {
	          				var me=this;
	          				setTimeout(function(){
	          					if(!btn.isDisabled()){
	          						me.saveMasterTimeTable(btn);
	          					}
	          				},100);
	          			}
	          		 },
	          		 'mastertimetabledetailedwindow button[itemId=CancelBtn]' : {
	          			 click : function() {
	          				 this.closeMasterWindow();
	          			 }
	          		 },
	          		 'mastertimetabledetailedwindow button[itemId=detailedBtn]':{
	          			 click: this.addMoreDetailed
	          		 },
	          		 'mastertimetablecalendar button[itemId=btnPrint]' : {
	        			  click : function(){
	        				  this.exportJRXML();
	        			  }
	        		  },
	        		  /*'mastersearchfilter button[itemId=downoladtemplate]' : {
	        			  click : function(obj){
	        				  var form = obj.up('form');
	        				  this.getDownloadTemplate(form);
	        			  }
	        		  },*/
	        		  'mastersearchfilter button[itemId=uploadtemplate]' : {
	        			  click : this.getOpenMasterTimeTableImportUtilityWin
	        		  },

	        		  'programcoursefilters radiogroup[itemId=courseSectionTypeRadio]' :{
	        			  change : function(cb) {
	        				  this.changePBSSectionType();
	        			  }
	        		  },

	        		  'programcoursefilters button[itemId=quickSearchId]' :{
	        			  click : function(cb) {
	        				  this.loadGridDataForSession();
	        			  }
	        		  },
	        		  
	        		  'programcoursefilters button[itemId=resetBtn]' :{
	        			  click : function(cb) {
	        				  this.resetForSessionPBSC();
	        			  }
	        		  },

	        		  'programcoursefilters [itemId=withoutMasterTimetableId]':{
	        			  change: function( field, newValue, oldValue, eOpts ){
	        				  field.up('form').down('#homeRoom').clearValue();
	        				  field.up('form').down('#homeRoom').setDisabled(newValue);
	        			  }
	        		  },
	        		  'programcoursefilters' : {
		        			 render:function(){
		        				 var me=this;
		        				 me.changePBSSectionType();
		        				 var form=this.getProgramcoursefilters().getForm();
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var roomStore = form.findField('homeRoom').getStore();
		        				 Ext.Ajax.request({
		        	    			  type : 'rest',
		        	    			  url : SERVERURL.GET_LOCATION_BY_ACADEMY_LOCATION+'?id=' + academyLocationId,
		        	    			  method : 'GET',
		        	    			  success : function(form, action) {
		        	    				  var res = Ext.JSON.decode(form.responseText);
		        	    				  roomStore.getProxy().extraParams = {
		        			    			  locationId : res,
		        			    			  };
		        			    		  roomStore.load();
		        	    			  }
		        	    		  });
		        			 }, 
		        			 afterrender: function(){
		        				 var me = this;
		        				 me.setTabPbsCbsPermission("viewMasterTimeTable");
		        			 }
		        		 },
		        		 'programcoursefilters multiselectcombofield#courseId' : {
		        			 change : function(obj, record) {
		        				 var me=this;
		        				 var records = obj.value;
		        				 var allCourseIds = [];
		    	        		 if(!isNullOrEmpty(records)) {
		    	        			 Ext.each(records,function(course){
		    		        			 if(typeof course=="number"){
		    		        				 allCourseIds.push(course);
		    		        			 }else if(!isNullOrEmpty(course.data)){
		    		        				 allCourseIds.push(course.data.id);
		    		        			 }
		    		        		 });
		    	        		 }
		        				 var academyLocationId = this.getCurrentAcademyLocation();
	        					 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        					 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        					 var academicTermId=this.getProgramcoursefilters().down('#academicTerm').getValue();
	        					 var sectionBox = this.getProgramcoursefilters().down('#courseSection_Id');
	        					 var cbsBatchfilter=this.getProgramcoursefilters().down("#cbsBatchId");
		        				 var cbsProgramfilter=this.getProgramcoursefilters().down("#cbsProgramId");
		        				 var cbsPeriodfilter=this.getProgramcoursefilters().down("#cbsPeriodId");
		        				 var sectionGroupComboBoxCBS=this.getProgramcoursefilters().down("#cbsSectionGroupId");
		        				 sectionBox.clearValue();
	        					 sectionBox.setDisabled(false);
	        					 this.getProgramcoursefilters().down('#facultyId').reset();
		        				 if(allCourseIds.length > 0) {
		        					 courseId = allCourseIds.join();
		        					 sectionBox.setDisabled(false);
		        					 var courseSectionStore = sectionBox.getStore();
		        					 courseSectionStore.getProxy().extraParams = {
		        						 courseId: courseId,
		        						 academicTermId:academicTermId,
		        						 sectionGroupId:sectionGroupComboBoxCBS.getValue(),
		        						 academyLocationIds:academyLocationId,
		        						 programId:cbsProgramfilter.getValue(),
		        						 batchId:cbsBatchfilter.getValue(),
		        						 periodId:cbsPeriodfilter.getValue()
		        					 };
		        					 courseSectionStore.load({
		        						 callback: function(records, operation, success) {
		        							 if (success) {
		        								 if(records.length==1){
		        									 var sectionId = records[0].get('id');
		        									 var sections = [sectionId];
		        									 me.getProgramcoursefilters().down('#courseSection_Id').setValue(sections);
		        									 me.getProgramcoursefilters().down('#courseSection_Id').setValue(sections)
		        								 } else {
		        									 var facultyByCriteriaStore = me.getProgramcoursefilters().down('#facultyId').getStore();
		        									 facultyByCriteriaStore.getProxy().extraParams = {
		        										 academyLocationIds:academyLocationId,
		        										 courseId:courseId,
		        										 academicTermId:academicTermId,
		        										 programId:cbsProgramfilter.value,
		        										 batchId:cbsBatchfilter.value,
		        										 periodId:cbsPeriodfilter.value,
		        		        						 sectionGroupId:sectionGroupComboBoxCBS.getValue()
		        									 };
		        									 facultyByCriteriaStore.load();
		        									 
		        									 var facultyDepartmentStore = me.getProgramcoursefilters().down('#facultyDepartmentId').getStore();
		        									 facultyDepartmentStore.getProxy().extraParams = {
		        										 academyLocationIds:academyLocationId,
		        										 courseId:courseId,
		        										 academicTermId:academicTermId,
		        										 programId:cbsProgramfilter.value,
		        										 batchId:cbsBatchfilter.value,
		        										 periodId:cbsPeriodfilter.value,
		        		        						 sectionGroupId:sectionGroupComboBoxCBS.getValue()
		        									 };
		        									 facultyDepartmentStore.load();
		        								 }
		        							 }
		        						 }
		        					 });
		        				 }
		        				 else{
		        					 var facultyByCriteriaStore = me.getProgramcoursefilters().down('#facultyId').getStore();
									 facultyByCriteriaStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId,
										 academicTermId:academicTermId,
										 programId:cbsProgramfilter.value,
										 batchId:cbsBatchfilter.value,
										 periodId:cbsPeriodfilter.value,
		        						 sectionGroupId:sectionGroupComboBoxCBS.getValue()
									 };
									 facultyByCriteriaStore.load();
									 
									 var facultyDepartmentStore = me.getProgramcoursefilters().down('#facultyDepartmentId').getStore();
									 facultyDepartmentStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId,
										 academicTermId:academicTermId,
										 programId:cbsProgramfilter.value,
										 batchId:cbsBatchfilter.value,
										 periodId:cbsPeriodfilter.value,
		        						 sectionGroupId:sectionGroupComboBoxCBS.getValue()
									 };
									 facultyDepartmentStore.load();
		        				 }
		        			 }
		        		 },
		        		 'programcoursefilters multiselectcombofield#courseSection_Id' : {
		        			 change : function(obj, record) {
		        				 var me=this;
		        				 var records = obj.value;
		        				 var allSectionIds = [];
		    	        		 if(!isNullOrEmpty(records)) {
		    	        			 Ext.each(records,function(section){
		    		        			 if(typeof section=="number"){
		    		        				 allSectionIds.push(section);
		    		        			 }else if(!isNullOrEmpty(section.data)){
		    		        				 allSectionIds.push(section.data.id);
		    		        			 }
		    		        		 });
		    	        		 }
		    	        		 var sectionId = allSectionIds.join();
	        					 var searchForm = this.getProgramcoursefilters().getForm();
		        				 var academyLocationId = this.getCurrentAcademyLocation();
	        					 var records = this.getProgramcoursefilters().down('#courseId').getValue();
	        					 var allCourseIds = [];
		    	        		 if(!isNullOrEmpty(records)) {
		    	        			 Ext.each(records,function(course){
		    		        			 if(typeof course=="number"){
		    		        				 allCourseIds.push(course);
		    		        			 }else if(!isNullOrEmpty(course.data)){
		    		        				 allCourseIds.push(course.data.id);
		    		        			 }
		    		        		 });
		    	        		 }
		    	        		 var courseId = allCourseIds.join();
	        					 var academicTermId=this.getProgramcoursefilters().down('#academicTerm').getValue();
		        				 var facultyByCriteriaStore = this.getProgramcoursefilters().down('#facultyId').getStore();
		        				 var facultyDepartmentStore = me.getProgramcoursefilters().down('#facultyDepartmentId').getStore();
		        				 var cbsBatchfilter=this.getProgramcoursefilters().down("#cbsBatchId");
		        				 var cbsProgramfilter=this.getProgramcoursefilters().down("#cbsProgramId");
		        				 var cbsPeriodfilter=this.getProgramcoursefilters().down("#cbsPeriodId");
		        				 var sectionGroupComboBoxCBS=this.getProgramcoursefilters().down("#cbsSectionGroupId");
		        				 if(allSectionIds.length > 0) {
			        				 facultyByCriteriaStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 programId:cbsProgramfilter.value,
										 batchId:cbsBatchfilter.value,
										 periodId:cbsPeriodfilter.value,
			        					 sectionId:sectionId,
			        					 sectionGroupId:sectionGroupComboBoxCBS.getValue()
			        				 };
			        				 facultyByCriteriaStore.load();
			        				 
			        				 facultyDepartmentStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 programId:cbsProgramfilter.value,
										 batchId:cbsBatchfilter.value,
										 periodId:cbsPeriodfilter.value,
			        					 sectionId:sectionId,
			        					 sectionGroupId:sectionGroupComboBoxCBS.getValue()
			        				 };
			        				 facultyDepartmentStore.load();
		        				 } else {
		        					 facultyByCriteriaStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 programId:cbsProgramfilter.value,
										 batchId:cbsBatchfilter.value,
										 periodId:cbsPeriodfilter.value,
										 courseId:courseId,
			        					 sectionGroupId:sectionGroupComboBoxCBS.getValue()
			        				 };
			        				 facultyByCriteriaStore.load();
			        				 
			        				 facultyDepartmentStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 programId:cbsProgramfilter.value,
										 batchId:cbsBatchfilter.value,
										 periodId:cbsPeriodfilter.value,
										 courseId:courseId,
			        					 sectionGroupId:sectionGroupComboBoxCBS.getValue()
			        				 };
			        				 facultyDepartmentStore.load();
		        				 }
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#academicTerm' : {
		        			 change : function(obj, record) {
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var form = this.getProgramcoursefilters();
		        				 form.down("#courseId").setDisabled(false);
		        				 form.down("#courseId").clearValue();
		        				 form.down("#courseSection_Id").clearValue();
		        				 form.down("#courseSection_Id").setDisabled(true);
		        				 form.down("#cbsProgramId").clearValue();
		        				 form.down("#cbsBatchId").setDisabled(true);
		        				 form.down("#cbsBatchId").clearValue();
		        				 
		        				 form.down("#cbsPeriodId").setDisabled(true);
		        				 form.down("#cbsPeriodId").clearValue();
		        				 
		        				 form.down("#facultyId").clearValue();
		        				 
		        				 var courseCombo = form.down('#courseId');
		        				 var academicTermId=form.down('#academicTerm').getValue();
		        				 var courseStore = courseCombo.getStore();
		        				 var sectionGroupComboBoxCBS = form.down('customcombobox#cbsSectionGroupId');
		        				 if(academicTermId > 0){
		        					 
		        					 courseStore.getProxy().extraParams = {
			        					 sectionType : 'CourseSection',
			        					 academyLocationIds : academyLocationId,
			        					 academicTermId:academicTermId
			        				 };
			        				 courseStore.load();
			        				 var facultyByCriteriaStore = form.down('#facultyId').getStore();
			        				 facultyByCriteriaStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 sectionType : 'CourseSection'
			        				 };
			        				 facultyByCriteriaStore.load();
			        				 
			        				 var facultyDepartmentStore = form.down('#facultyDepartmentId').getStore();
			        				 facultyDepartmentStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 sectionType : 'CourseSection'
			        				 };
			        				 facultyDepartmentStore.load();


			        				 var cbsProgramByCriteriaStore = form.down('#cbsProgramId').getStore();
			        				 cbsProgramByCriteriaStore.getProxy().extraParams = {
			        					 academyLocationIds:academyLocationId,
			        					 academicTermId:academicTermId,
			        					 sectionType : 'CourseSection'
			        				 };
			        				 cbsProgramByCriteriaStore.load();
			        				 
			        				 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
			    					 sectionGroupStore.getProxy().extraParams = {
			    						 sectionType : 'CourseSection',
			    						 academyLocationIds : academyLocationId,
			    						 academicTermId:academicTermId
			    					 };
			    					 sectionGroupStore.load();
		        					 
		        				 }
		        				

		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#cbsProgramId' : {
		        			 change : function(obj, record) {
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var form = this.getProgramcoursefilters();
		        				 form.down("#courseId").setDisabled(false);
		        				 form.down("#cbsBatchId").setDisabled(false);
		        				 form.down("#cbsBatchId").clearValue();
		        				 form.down("#courseId").clearValue();
		        				 form.down("#courseSection_Id").clearValue();
		        				 form.down("#courseSection_Id").setDisabled(true);
		        				 form.down("#cbsProgramId").setDisabled(false);
		        				 var cbsProgramfilter=form.down("#cbsProgramId");
		        				 var courseComboBox = form.down('#courseId');
		        				 var academicTermId=form.down('#academicTerm').getValue();
		        				 var sectionGroupComboBoxCBS = form.down('customcombobox#cbsSectionGroupId');
		        				 var cbsBatchStore = form.down('#cbsBatchId').getStore();
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 cbsBatchStore.getProxy().extraParams = {
		        					 academyLocationIds:academyLocationId,
		        					 academicTermId:academicTermId,
		        					 programId:cbsProgramfilter.value,
		        					 sectionType : 'CourseSection'
		        				 };
		        				 cbsBatchStore.load({
		        					 callback: function(records, operation, success) {
		        						 if (success) {
		        							 if(records.length == 1) {
		        								 form.down("#cbsBatchId").setValue(records[0].data.id);
		        							 } else {
		        								 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
		        								 sectionGroupStore.getProxy().extraParams = {
		        									 sectionType : 'CourseSection',
		        									 academyLocationIds : academyLocationId,
		        									 academicTermId:academicTermId,
		        									 programId:cbsProgramfilter.value
		        								 };
		        								 sectionGroupStore.load();

		        								 var facultyStore = facultyCombo.getStore();
		        								 facultyStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 academicTermId:academicTermId,
		        									 programId:cbsProgramfilter.value
		        								 };
		        								 facultyStore.load();
		        								 
		        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        								 facultyDepartmentStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 academicTermId:academicTermId,
		        									 programId:cbsProgramfilter.value
		        								 };
		        								 facultyDepartmentStore.load();

		        								 var courseStore = courseComboBox.getStore();

		        								 courseStore.getProxy().extraParams = {	
		        									 sectionType : 'CourseSection',
		        									 academyLocationIds:academyLocationId,
		        									 academicTermId:academicTermId,
		        									 programId:cbsProgramfilter.value
		        								 };
		        								 courseStore.load();
		        							 }
		        						 }
		        					 }
		        				 });
		        				 
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#cbsBatchId' : {
		        			 change : function(obj, record) {
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var form = this.getProgramcoursefilters();
		        				 form.down("#courseId").setDisabled(false);
		        				 form.down("#cbsPeriodId").setDisabled(false);
		        				 form.down("#cbsPeriodId").clearValue();
		        				 form.down("#courseId").clearValue();
		        				 form.down("#courseSection_Id").clearValue();
		        				 form.down("#courseSection_Id").setDisabled(true);
		        				 form.down("#cbsProgramId").setDisabled(false);
		        				 form.down("#cbsSectionGroupId").clearValue();
		        				 var cbsProgramfilter=form.down("#cbsProgramId");
		        				 var cbsBatchfilter=form.down("#cbsBatchId");
		        				 var cbsPeriodfilter=form.down("#cbsPeriodId");
		        				 var courseComboBox = form.down('#courseId');
		        				 var academicTermId=form.down('#academicTerm').getValue();
		        				 var sectionGroupComboBoxCBS = form.down('customcombobox#cbsSectionGroupId');
		        				 var cbsPeriodStore = form.down('#cbsPeriodId').getStore();
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 var batchId = obj.value;
		        				 if(batchId > 0) {
		        					 cbsPeriodStore.getProxy().extraParams = {
			        					 academyLocationIds:null,
			        					 academicTermId:academicTermId,
			        					 batchId:batchId,
			        					 sectionType : 'CourseSection'
			        				 };
			        				 cbsPeriodStore.load({
			        					 callback: function(records, operation, success) {
			        						 if (success) {
			        							 if(records.length == 1) {
			        								 form.down("#cbsPeriodId").setValue(records[0].data.id);
			        								 var sectionBox = form.down('#courseSection_Id');
			    									 sectionBox.setDisabled(false);
			    		        					 var courseSectionStore = sectionBox.getStore();
			    		        					 courseSectionStore.getProxy().extraParams = {
			    		        						 academicTermId:academicTermId,
			    		        						 sectionGroupId:sectionGroupComboBoxCBS.getValue(),
			    		        						 academyLocationIds:academyLocationId,
			    		        						 programId:cbsProgramfilter.getValue(),
			    		        						 batchId:cbsBatchfilter.getValue(),
			    		        						 periodId:cbsPeriodfilter.getValue()
			    		        					 };
			    		        					 courseSectionStore.load({
			    		        						 callback: function(records, operation, success) {
			    		        							 if (success) {
			    		        								 if(records.length==1){
			    		        									 var sectionId = records[0].get('id');
			    		        									 var sections = [sectionId];
			    		        									 form.down('#courseSection_Id').setValue(sections);
			    		        									 form.down('#courseSection_Id').setValue(sections)
			    		        								 } else {}
			    		        							 }
			    		        						 }
			    		        					 });
			        							 } else {
			        								 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
			    			    					 sectionGroupStore.getProxy().extraParams = {
			    			    						 sectionType : 'CourseSection',
			    			    						 academyLocationIds : academyLocationId,
			    			    						 academicTermId:academicTermId,
			    			    						 programId:cbsProgramfilter.value,
			    			    						 batchId:batchId
			    			    					 };
			    			    					 sectionGroupStore.load();
			    			    					 
			    			    					 var facultyStore = facultyCombo.getStore();
			    									 facultyStore.getProxy().extraParams = {
			    										 academyLocationIds:academyLocationId,
			    										 academicTermId:academicTermId,
			    										 programId:cbsProgramfilter.value,
			    										 batchId:batchId
			    									 };
			    									 facultyStore.load();
			    									 
			    									 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
			    									 facultyDepartmentStore.getProxy().extraParams = {
			    										 academyLocationIds:academyLocationId,
			    										 academicTermId:academicTermId,
			    										 programId:cbsProgramfilter.value,
			    										 batchId:batchId
			    									 };
			    									 facultyDepartmentStore.load();
			    									 
			    									 var courseStore = courseComboBox.getStore();

			    									 courseStore.getProxy().extraParams = {	
			    										 sectionType : 'CourseSection',
			    										 academyLocationIds:academyLocationId,
			    										 academicTermId:academicTermId,
			    										 programId:cbsProgramfilter.value,
			    										 batchId:batchId
			    									 };
			    									 courseStore.load();
			        							 }
			        						 }
			        					 }
			        				 });
		        				 }
		        			 }
		        		 },
		        		/* 'programcoursefilters multiselectcombofield#facultyId' : {
		        			 change : function(obj, record) {
		        				 var form = this.getProgramcoursefilters();
		        				 var grid = this.getTimetableprogambatchgrid();
		        				 var faculty=form.down("#facultyId");
		        				 var cbsPeriodfilter=form.down("#cbsPeriodId");
		        				 var sectionpbs=form.down("#periodId");
		        				 if(!isNullOrEmpty(faculty.value)&&faculty.value.length>0){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }
		        				 else if(!isNullOrEmpty(cbsPeriodfilter.value)||!isNullOrEmpty(sectionpbs.value)){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }else{
		        					 grid.down('#exportReport').setDisabled(true);
		        				 }
		        			 }
		        		 }
		        		 ,*/
		        		 'programcoursefilters multiselectcombofield#homeRoom' : {
		        			 change : function(obj, record) {
		        				 var form = this.getProgramcoursefilters();
		        				 var grid = this.getTimetableprogambatchgrid();
		        				 var rooms=form.down("#homeRoom");
		        				 var cbsPeriodfilter=form.down("#cbsPeriodId");
		        				 var sectionpbs=form.down("#periodId");
		        				 if(!isNullOrEmpty(rooms.value)&&rooms.value.length>0){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }
		        				 else if(!isNullOrEmpty(cbsPeriodfilter.value)||!isNullOrEmpty(sectionpbs.value)){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }else{
		        					 grid.down('#exportReport').setDisabled(true);
		        				 }
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#cbsPeriodId' : {
		        			 change : function(obj, record) {
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var form = this.getProgramcoursefilters();
		        				 form.down("#courseId").setDisabled(false);
		        				 form.down("#cbsPeriodId").setDisabled(false);
		        				 form.down("#courseId").clearValue();
		        				 form.down("#courseSection_Id").clearValue();
		        				 form.down("#courseSection_Id").setDisabled(false);
		        				 form.down("#cbsProgramId").setDisabled(false);
		        				 form.down("#cbsSectionGroupId").clearValue();
		        				 var cbsBatchfilter=form.down("#cbsBatchId");
		        				 var sectionGroupComboBoxCBS = form.down('customcombobox#cbsSectionGroupId');
		        				 var cbsProgramfilter=form.down("#cbsProgramId");
		        				 var cbsPeriodfilter=form.down("#cbsPeriodId");
		        				 var grid = this.getTimetableprogambatchgrid();
		        				 if(!isNullOrEmpty(cbsPeriodfilter.value)){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }else{
		        					 grid.down('#exportReport').setDisabled(true);
		        				 }
		        				 var courseComboBox = form.down('#courseId');
		        				 var academicTermId=form.down('#academicTerm').getValue();
		        				 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 var periodId = obj.value;
		        				 if(periodId > 0) {
		    					 sectionGroupStore.getProxy().extraParams = {
		    						 sectionType : 'CourseSection',
		    						 academyLocationIds : academyLocationId,
		    						 academicTermId:academicTermId,
		    						 programId:cbsProgramfilter.value,
		    						 batchId:cbsBatchfilter.value,
		    						 periodId:cbsPeriodfilter.value
		    					 };
		    					 sectionGroupStore.load();
		    					 
		    					 var facultyStore = facultyCombo.getStore();
								 facultyStore.getProxy().extraParams = {
									 academyLocationIds:academyLocationId,
									 academicTermId:academicTermId,
									 programId:cbsProgramfilter.value,
									 batchId:cbsBatchfilter.value,
									 periodId:cbsPeriodfilter.value,
								 };
								 facultyStore.load();
								 
								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
								 facultyDepartmentStore.getProxy().extraParams = {
									 academyLocationIds:academyLocationId,
									 academicTermId:academicTermId,
									 programId:cbsProgramfilter.value,
									 batchId:cbsBatchfilter.value,
									 periodId:cbsPeriodfilter.value,
								 };
								 facultyDepartmentStore.load();

								 var courseStore = courseComboBox.getStore();

								 courseStore.getProxy().extraParams = {	
									 sectionType : 'CourseSection',
									 academyLocationIds:academyLocationId,
									 academicTermId:academicTermId,
									 programId:cbsProgramfilter.value,
									 batchId:cbsBatchfilter.value,
									 periodId:cbsPeriodfilter.value								 };
								 courseStore.load();
								 var sectionBox = form.down('#courseSection_Id');
								 sectionBox.setDisabled(false);
	        					 var courseSectionStore = sectionBox.getStore();
	        					 courseSectionStore.getProxy().extraParams = {
	        						 academicTermId:academicTermId,
	        						 sectionGroupId:sectionGroupComboBoxCBS.getValue(),
	        						 academyLocationIds:academyLocationId,
	        						 programId:cbsProgramfilter.value,
	        						 batchId:cbsBatchfilter.value,
	        						 periodId:cbsPeriodfilter.value
	        					 };
	        					 courseSectionStore.load({
	        						 callback: function(records, operation, success) {
	        							 if (success) {
	        								 if(records.length==1){
	        									 var sectionId = records[0].get('id');
	        									 var sections = [sectionId];
	        									 form.down('#courseSection_Id').setValue(sections);
	        									 form.down('#courseSection_Id').setValue(sections)
	        								 } else {}
	        							 }
	        						 }
	        					 });
		        			 }
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#cbsSectionGroupId' : {
		        			 change : function(obj, record) {
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var form = this.getProgramcoursefilters();
		        				 form.down("#courseId").setDisabled(false);
		        				 form.down("#cbsPeriodId").setDisabled(false);
		        				 form.down("#courseId").clearValue();
		        				 form.down("#courseSection_Id").clearValue();
		        				 form.down("#courseSection_Id").setDisabled(true);
		        				 form.down("#cbsProgramId").setDisabled(false);
		        				 var cbsBatchfilter=form.down("#cbsBatchId");
		        				 var sectionGroupComboBoxCBS = form.down('customcombobox#cbsSectionGroupId');
		        				 var cbsProgramfilter=form.down("#cbsProgramId");
		        				 var cbsPeriodfilter=form.down("#cbsPeriodId");
		        				 var courseComboBox = form.down('#courseId');
		        				 courseComboBox.reset();
		        				 var academicTermId=form.down('#academicTerm').getValue();
		        				 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
		        				 var facultyCombo = form.down('#facultyId');
		    					 var facultyStore = facultyCombo.getStore();
		    					 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		    					 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		    					 var sectionGroupId = obj.value;
		        				 if(sectionGroupId > 0) {
								 facultyStore.getProxy().extraParams = {
									 academyLocationIds:academyLocationId,
									 academicTermId:academicTermId,
									 programId:cbsProgramfilter.value,
									 batchId:cbsBatchfilter.value,
									 periodId:cbsPeriodfilter.value,
									 sectionGroupId:sectionGroupComboBoxCBS.value
								 };
								 facultyStore.load();
								 
								 facultyDepartmentStore.getProxy().extraParams = {
									 academyLocationIds:academyLocationId,
									 academicTermId:academicTermId,
									 programId:cbsProgramfilter.value,
									 batchId:cbsBatchfilter.value,
									 periodId:cbsPeriodfilter.value,
									 sectionGroupId:sectionGroupComboBoxCBS.value
								 };
								 facultyDepartmentStore.load();
								 
								 var courseStore = courseComboBox.getStore();
								 courseComboBox.getStore().removeAll();
								 courseStore.getProxy().extraParams = {	
									 sectionType : 'CourseSection',
									 academyLocationIds:academyLocationId,
									 academicTermId:academicTermId,
									 programId:cbsProgramfilter.value,
									 batchId:cbsBatchfilter.value,
									 periodId:cbsPeriodfilter.value,
									 sectionGroupId:sectionGroupComboBoxCBS.value
								 };
								 courseStore.load();

		        			 }
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#programId' : {
		        			 select : function(obj, record) {
		        				 this$=this;
		        				 try{
		        					 var programId = record[0].get("id");
		        				 }
		        				 catch(e){
		        					 var programId = record;
		        				 }
		        				 var form= this.getProgramcoursefilters();
		        				 var alinfomodel = Academia.model.authentication.ALInfoModel;
		        				 var wheatherSchool = alinfomodel.get('wheatherSchool');
		        				 var academyLocationId = this.getCurrentAcademyLocation();

		        				 var batchComboBox = form.down('#batchId');
		        				 var periodComboBox = form.down('#periodId');
		        				 var sectionComboBox = form.down('#courseSection_Id_1');
		        				 var courseComboBox = form.down('#courseId_1');
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');

		        				 batchComboBox.clearValue();
		        				 periodComboBox.clearValue();
		        				 sectionComboBox.clearValue();
		        				 courseComboBox.clearValue();
		        				 facultyCombo.clearValue();
		        				 facultyDepartmentCombo.clearValue();

		        				 batchComboBox.setDisabled(false);
		        				 periodComboBox.setDisabled(true);
		        				 sectionComboBox.setDisabled(true);
		        				 courseComboBox.setDisabled(true);

		        				 var batchStore = batchComboBox.getStore();
		        				 batchStore.getProxy().extraParams = {
		        					 programId : programId
		        				 };
		        				 batchStore.load({
		        					 callback: function(records, operation, success) {
		        						 if (success) {
		        							 if(records.length==1){
		        								 batchId=records[0].get('id');
		        								 batchComboBox.setValue(records[0].get('id'));
		        								 periodComboBox.setDisabled(false);
		        								 
		        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
												 facultyDepartmentStore.getProxy().extraParams = {
													 academyLocationIds:academyLocationId,
													 programId:programId,
													 batchId:records[0].get('id')
												 };
												 facultyDepartmentStore.load();
		        								 
		        								 var periodStore = periodComboBox.getStore();
		        								 periodStore.getProxy().extraParams = {
		        									 batchId : records[0].get('id')
		        								 };
		        								 periodStore.load({
		        									 callback: function(records, operation, success) {
		        										 if (success) {
		        											 if(records.length==0){
		        												 if(wheatherSchool) {
		        													 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		        												 }
		        												 var facultyStore = facultyCombo.getStore();
		        												 facultyStore.getProxy().extraParams = {
		        													 academyLocationIds:academyLocationId,
		        													 programId:programId,
		        													 batchId:batchId
		        												 };
		        												 facultyStore.load();
		        												 
		        												 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        												 facultyDepartmentStore.getProxy().extraParams = {
		        													 academyLocationIds:academyLocationId,
		        													 programId:programId,
		        													 batchId:batchId
		        												 };
		        												 facultyDepartmentStore.load();
		        											 }
		        											 if(records.length==1){
		        												 periodComboBox.setValue(records[0].get('id'))
		        												 period_Id = records[0].get("id");
		        												 courseComboBox.clearValue();
		        												 sectionComboBox.clearValue();
		        												 courseComboBox.setDisabled(false);
		        												 sectionComboBox.setDisabled(false);
		        												 
		        												 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        												 facultyDepartmentStore.getProxy().extraParams = {
		        													 academyLocationIds:academyLocationId,
		        													 programId:programId,
		        													 batchId:batchId,
		        													 periodId:records[0].get("id"),
		        												 };
		        												 facultyDepartmentStore.load();
		        												 var sectionStore = sectionComboBox.getStore();
		        												 sectionStore.getProxy().extraParams = {
		        													 periodId : period_Id
		        												 };
		        												 sectionStore.load({
		        													 callback: function(records, operation, success) {
		        														 if (success) {
		        															 if(records.length==1){
		        																 sectionComboBox.setValue(records[0].get('id'));

		        																 var courseStore =courseComboBox.getStore(); 
		        																 courseStore.getProxy().extraParams = {	
		        																	 periodId: period_Id,
		        																	 sectionType : 'ProgramBatchSection',
		        																	 sectionId:records[0].get('id')
		        																 };
		        																 courseStore.load();

		        																 var facultyStore = facultyCombo.getStore();
		        																 facultyStore.getProxy().extraParams = {
		        																	 academyLocationIds:academyLocationId,
		        																	 periodId:period_Id,
		        																	 sectionType : 'ProgramBatchSection',
		        																	 sectionId:records[0].get('id')
		        																 };
		        																 facultyStore.load();
		        																 
		        																 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        																 facultyDepartmentStore.getProxy().extraParams = {
		        																	 academyLocationIds:academyLocationId,
		        																	 programId:programId,
		        		        													 batchId:batchId,
		        																	 periodId:period_Id,
		        																	 sectionType : 'ProgramBatchSection',
		        																	 sectionId:records[0].get('id')
		        																 };
		        																 facultyDepartmentStore.load();
		        															 } else {

		        		        												 var courseStore = courseComboBox.getStore();
		        																 courseStore.getProxy().extraParams = {	
		        																	 periodId: period_Id,
		        																	 sectionType : 'ProgramBatchSection'
		        																 };
		        																 courseStore.load();

		        																 var facultyStore = facultyCombo.getStore();
		        																 facultyStore.getProxy().extraParams = {
		        																	 academyLocationIds : academyLocationId,
		        																	 periodId : period_Id,
		        																	 sectionType : 'ProgramBatchSection'
		        																 };
		        																 facultyStore.load();
		        															 }
		        														 }
		        													 }
		        												 });	        												 

		        											 } else {
		        												 var facultyStore = facultyCombo.getStore();
		        												 facultyStore.getProxy().extraParams = {
		        													 academyLocationIds:academyLocationId,
		        													 programId:programId,
		        													 batchId:batchId
		        												 };
		        												 facultyStore.load();
		        											 }
		        										 }
		        									 }
		        								 });
		        							 } else {
		        								 var facultyStore = facultyCombo.getStore();
		        								 facultyStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 programId:programId
		        								 };
		        								 facultyStore.load();
		        								 
		        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
			        							 facultyDepartmentStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 programId:programId
		        								 };
			        							 facultyDepartmentStore.load();
		        							 }	 
	        							 }
		        						 }
		        					 
		        				 });
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#batchId' : {
		        			 select : function(obj, record) {
		        				 this$=this;
		        				 try{
		        					 var batch_Id = record[0].get("id");
		        				 }
		        				 catch(e){
		        					 var batch_Id = record;
		        				 }
		        				 var alinfomodel = Academia.model.authentication.ALInfoModel;
		        				 var wheatherSchool = alinfomodel.get('wheatherSchool');
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var programId = this.getProgramcoursefilters().down('customcombobox#programId').getValue();

		        				 var form = this.getProgramcoursefilters();
		        				 var periodComboBox = form.down('#periodId');
		        				 var sectionComboBox = form.down('#courseSection_Id_1');
		        				 var courseComboBox = form.down('#courseId_1');
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 
		        				 periodComboBox.clearValue();
		        				 sectionComboBox.clearValue();
		        				 courseComboBox.clearValue();
		        				 facultyCombo.clearValue();
		        				 facultyDepartmentCombo.clearValue();

		        				 
		        				 periodComboBox.setDisabled(false);
		        				 sectionComboBox.setDisabled(true);
		        				 courseComboBox.setDisabled(true);

		        				 var periodComboBox = this.getProgramcoursefilters().down('customcombobox#periodId');

		        				 var period_Id;
		        				 var periodStore = periodComboBox.getStore();
		        				 periodStore.getProxy().extraParams = {
		        					 batchId : batch_Id
		        				 };
		        				 periodStore.load({
		        					 callback: function(records, operation, success) {
		        						 if (success) {
		        							 if(records.length==0){
		        								 if(wheatherSchool) {
		        									 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
		        								 }
		        								 var facultyStore = facultyCombo.getStore();
		        								 facultyStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 programId:programId,
		        									 batchId:batch_Id
		        								 };
		        								 facultyStore.load();
		        								 
		        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        								 facultyDepartmentStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 programId:programId,
		        									 batchId:batch_Id
		        								 };
		        								 facultyDepartmentStore.load();
		        							 }
		        							 if(records.length==1){
		        								 periodComboBox.setValue(records[0].get('id'))
		        								 period_Id = records[0].get("id");
		        								 
		        								 sectionComboBox.clearValue();
		        								 courseComboBox.clearValue();
		        								 courseComboBox.setDisabled(false);
		        								 sectionComboBox.setDisabled(false);
		        								 var sectionStore = sectionComboBox.getStore();
						        				 sectionStore.getProxy().extraParams = {
						        					 periodId : period_Id
						        				 };
						        				 sectionStore.load({
						        					 callback: function(records, operation, success) {
						        						 if (success) {
						        							 if(records.length==1){
						        								 sectionComboBox.setValue(records[0].get('id'));
						        								 
						        								 var courseStore =courseComboBox.getStore(); 
						        		        				 courseStore.getProxy().extraParams = {	
						        		        					 periodId: period_Id,
						        		        					 sectionType : 'ProgramBatchSection',
						        									 sectionId:records[0].get('id')
						        		        				 };
						        		        				 courseStore.load();
						        		        				 
						        								 var facultyStore = facultyCombo.getStore();
						        								 facultyStore.getProxy().extraParams = {
						        									 academyLocationIds:academyLocationId,
						        		        					 periodId:period_Id,
						        		        					 sectionType : 'ProgramBatchSection',
						        									 sectionId:records[0].get('id')
						        								 };
						        								 facultyStore.load();
						        								 
						        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
						        								 facultyDepartmentStore.getProxy().extraParams = {
						        									 academyLocationIds:academyLocationId,
						        		        					 periodId:period_Id,
						        		        					 sectionType : 'ProgramBatchSection',
						        									 sectionId:records[0].get('id')
						        								 };
						        								 facultyDepartmentStore.load();
						        							 } else {
						        								 
						        								 var courseStore = courseComboBox.getStore();
						        								 courseStore.getProxy().extraParams = {	
						        									 periodId: period_Id,
						        									 sectionType : 'ProgramBatchSection'
						        								 };
						        								 courseStore.load();

						        								 var facultyStore = facultyCombo.getStore();
						        								 facultyStore.getProxy().extraParams = {
						        									 academyLocationIds : academyLocationId,
						        									 periodId : period_Id,
						        									 sectionType : 'ProgramBatchSection'
						        								 };
						        								 facultyStore.load();
						        								 
						        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
						        								 facultyDepartmentStore.getProxy().extraParams = {
						        									 academyLocationIds : academyLocationId,
						        									 periodId : period_Id,
						        									 sectionType : 'ProgramBatchSection'
						        								 };
						        								 facultyDepartmentStore.load();
						        							 }
						        						 }
						        					 }
						        				 });

		        							 } else {
		        								 var facultyStore = facultyCombo.getStore();
		        								 facultyStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 programId:programId,
		        									 batchId:batch_Id
		        								 };
		        								 facultyStore.load();
		        								 
		        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        								 facultyDepartmentStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        									 programId:programId,
		        									 batchId:batch_Id
		        								 };
		        								 facultyDepartmentStore.load();
		        							 }
		        						 }
		        					 }
		        				 });
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#periodId' : {
		        			 select : function(obj, record) {
		        				 try{
		        					 var period_Id = record[0].get("id");
		        				 }
		        				 catch(e){
		        					 var period_Id = record;
		        				 }
		        				 var academyLocationId = this.getCurrentAcademyLocation();
		        				 var programId = this.getProgramcoursefilters().down('customcombobox#programId').getValue();
		        				 var batchId = this.getProgramcoursefilters().down('customcombobox#batchId').getValue();

		        				 var form = this.getProgramcoursefilters();
		        				 var sectionComboBox = form.down('#courseSection_Id_1');
		        				 var courseComboBox = form.down('#courseId_1');
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 var sectionComboBox = form.down('#courseSection_Id_1');
		        				 
		        				 sectionComboBox.clearValue();
		        				 courseComboBox.clearValue();
		        				 facultyCombo.clearValue();
		        				 facultyDepartmentCombo.clearValue();
		        				 sectionComboBox.setDisabled(false);
		        				 courseComboBox.setDisabled(false);
		        				 
		        				 var sectionStore = sectionComboBox.getStore();
		        				 sectionStore.getProxy().extraParams = {
		        					 periodId : period_Id
		        				 };
		        				 sectionStore.load({
		        					 callback: function(records, operation, success) {
		        						 if (success) {
		        							 if(records.length==1){
		        								 sectionComboBox.setValue(records[0].get('id'));
		        								 
		        								 var courseStore =courseComboBox.getStore(); 
		        		        				 courseStore.getProxy().extraParams = {	
		        		        					 periodId: period_Id,
		        		        					 sectionType : 'ProgramBatchSection',
		        									 sectionId:records[0].get('id')
		        		        				 };
		        		        				 courseStore.load();
		        		        				 
		        								 var facultyStore = facultyCombo.getStore();
		        								 facultyStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        		        					 programId:programId,
		        		        					 batchId:batchId,
		        		        					 periodId:period_Id,
		        									 sectionId:records[0].get('id')
		        								 };
		        								 facultyStore.load();
		        								 
		        								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        								 facultyDepartmentStore.getProxy().extraParams = {
		        									 academyLocationIds:academyLocationId,
		        		        					 programId:programId,
		        		        					 batchId:batchId,
		        		        					 periodId:period_Id,
		        									 sectionId:records[0].get('id')
		        								 };
		        								 facultyDepartmentStore.load();
		        							 } else {
		        								 
		        								 var courseStore =courseComboBox.getStore(); 
		        		        				 courseStore.getProxy().extraParams = {	
		        		        					 periodId: period_Id,
		        		        					 sectionType : 'ProgramBatchSection'
		        		        				 };
		        		        				 courseStore.load();
		        		        				 
		        								 var facultyStore = facultyCombo.getStore();
		        		        				 facultyStore.getProxy().extraParams = {
		        		        					 academyLocationIds:academyLocationId,
		        		        					 programId:programId,
		        		        					 batchId:batchId,
		        		        					 periodId:period_Id
		        		        				 };
		        		        				 facultyStore.load();
		        		        				 
		        		        				 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
		        		        				 facultyDepartmentStore.getProxy().extraParams = {
		        		        					 academyLocationIds:academyLocationId,
		        		        					 programId:programId,
		        		        					 batchId:batchId,
		        		        					 periodId:period_Id
		        		        				 };
		        		        				 facultyDepartmentStore.load();
		        							 }
		        						 }
		        					 }
		        				 });		        				 
		        			 }
		        		 },
		        		 'programcoursefilters customcombobox#courseId_1' : {
		        			 select : function(obj, record) {
		        				 try{
		        					 var courseId = record[0].get("id");		        					 
		        				 }
		        				 catch(e){
		        					 var courseId = record;
		        				 }
		        				 var me = this;
		        				 var academyLocationId = this.getCurrentAcademyLocation();

		        				 var programId = this.getProgramcoursefilters().down('#programId').getValue();
		        				 var batchId = this.getProgramcoursefilters().down('#batchId').getValue();
		        				 var periodId = this.getProgramcoursefilters().getForm().findField('period').getValue();
		        				 var sectionId = this.getProgramcoursefilters().getForm().findField('section_1').getValue();
		        				 
		        				 var form = this.getProgramcoursefilters();
		        				 var courseComboBox = form.down('#courseId_1');
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 facultyCombo.clearValue();
		        				 facultyDepartmentCombo.clearValue();
		        				 
		        				 var facultyStore = facultyCombo.getStore();
								 facultyStore.getProxy().extraParams = {
									 academyLocationIds:academyLocationId,
									 periodId:periodId,
									 courseId: courseId,
									 sectionId:sectionId
								 };
								 facultyStore.load();
								 
								 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
								 facultyDepartmentStore.getProxy().extraParams = {
									 academyLocationIds:academyLocationId,
									 periodId:periodId,
									 courseId: courseId,
									 sectionId:sectionId
								 };
								 facultyDepartmentStore.load();
		        			 }
		        		 },
		        		 
		        		'programcoursefilters customcombobox#courseSection_Id_1' : {
		        			 select : function(obj, record){
		        				 try{
			        				 var sectionId = record[0].get("id");		        					 
		        				 }
		        				 catch(e){
		        					 var sectionId = record;
		        				 }
		        				 var academyLocationId = this.getCurrentAcademyLocation();
	        					 var courseId = this.getProgramcoursefilters().down('customcombobox#courseId_1').getValue();
		        				 var periodId = this.getProgramcoursefilters().getForm().findField('period').getValue();
		        				 var facultyByCriteriaStore = this.getProgramcoursefilters().down('#facultyId').getStore();
		        				 var form = this.getProgramcoursefilters();
		        				 var courseComboBox = form.down('#courseId_1');
		        				 var facultyCombo = form.down('#facultyId');
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 
		        				 facultyCombo.clearValue();
		        				 facultyDepartmentCombo.clearValue();
		        				 
		        				 courseComboBox.clearValue();
		        				 var courseStore =courseComboBox.getStore(); 
		        				 courseStore.getProxy().extraParams = {	
		        					 periodId: periodId,
		        					 sectionType : 'ProgramBatchSection',
		        					 sectionId:sectionId
		        				 };
		        				 courseStore.load();
	        					 facultyByCriteriaStore.getProxy().extraParams = {
	        						 academyLocationIds:academyLocationId,
	        						 periodId:periodId,
	        						 courseId: courseId,
	        						 sectionId:sectionId
	        					 };
	        					 facultyByCriteriaStore.load();
	        					 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
	        					 facultyDepartmentStore.getProxy().extraParams = {
	        						 academyLocationIds:academyLocationId,
	        						 periodId:periodId,
	        						 courseId: courseId,
	        						 sectionId:sectionId
	        					 };
	        					 facultyDepartmentStore.load();
	        					 
		        			 },
		        			 change : function(){
		        				 var sectionId = this.getProgramcoursefilters().getForm().findField('section_1').getValue();
		        				 var grid = this.getTimetableprogambatchgrid();
		        				 if(!isNullOrEmpty(sectionId)){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }else{
		        					 grid.down('#exportReport').setDisabled(true);
		        				 }
		        	        	 
		        			 }
		        		 },
		        		 'programcoursefilters multiselectcombofield#facultyId' : {
		        			 change : function(){
		        				 var form = this.getProgramcoursefilters();
		        				 var academyLocationId = this.getCurrentAcademyLocation();
	        					 var facultyIds = form.down('multiselectcombofield#facultyId').getValue();
		        				 var facultyDepartmentCombo = form.down('#facultyDepartmentId');
		        				 facultyDepartmentCombo.clearValue();
		        				  var facultyIdsArr=[];
		   					      //facultyIdsArr = facultyIds;
		   					   
		        		        	 if(!isNullOrEmpty(facultyIds)) {
		        		        		 Ext.each(facultyIds,function(facultyId){
		        		        			 if(typeof facultyId=="number"){
		        		        				 facultyIdsArr.push(facultyId);
		        		        			 }
		        		        		 });
		        		        	 }
		        		        	 
		        		        	var facultyIdsString= facultyIdsArr.join();
	        					 
		        		        	 var facultyDepartmentStore = facultyDepartmentCombo.getStore();
	        					 facultyDepartmentStore.getProxy().extraParams = {
	        						 academyLocationIds:academyLocationId,
	        						 FacultyId:facultyIdsString
	        					 };
	        					 facultyDepartmentStore.load();
		        				 var grid = this.getTimetableprogambatchgrid();
		        				 var faculty=form.down("#facultyId");
		        				 var cbsPeriodfilter=form.down("#cbsPeriodId");
		        				 var sectionpbs=form.down("#periodId");
		        				 if(!isNullOrEmpty(faculty.value)&&faculty.value.length>0){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }
		        				 else if(!isNullOrEmpty(cbsPeriodfilter.value)||!isNullOrEmpty(sectionpbs.value)){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }else{
		        					 grid.down('#exportReport').setDisabled(true);
		        				 }
 								if(!isNullOrEmpty(faculty.value)&&faculty.value.length>0){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }
		        				 else if(!isNullOrEmpty(cbsPeriodfilter.value)||!isNullOrEmpty(sectionpbs.value)){
		        					 grid.down('#exportReport').setDisabled(false);
		        				 }else{
		        					 grid.down('#exportReport').setDisabled(true);
		        				 }
	        					 
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#downloadType' : {
		        			 change : function(obj, record) {
		        				 var $this=this;
		        				 var form =$this.getUploadtemplate();
		        				 var downloadType = obj.findRecordByValue(obj.getValue()).data;
		        				 if(!isNullOrEmpty(downloadType)){
		        				 if(downloadType.id =="PROGRAM_BATCH_SECTION"){
		        					 var alinfomodel = Academia.model.authentication.ALInfoModel;
		        					 var wheatherSchool = alinfomodel.get('wheatherSchool');
		        					  if(wheatherSchool){
		        						  form.down('#periodId').setVisible(false);
		        								  }
		        					  else{
		        						  form.down('#periodId').setVisible(true);

		        					  }
		        					 form.down('#calendarId').setVisible(true);
		        					 form.down('#calendarId').allowBlank = false;
		        					 form.down('#calendarId').reset();
		        					 form.down('#batchId').setVisible(true);
		        					 form.down('#batchId').allowBlank = false;
		        					 form.down('#batchId').reset();
		        					 form.down('#periodId').allowBlank = false;
		        					 form.down('#periodId').reset();
		        					 form.down('#sectionId').setVisible(true);
		        					 form.down('#sectionId').allowBlank = false;
		        					 form.down('#sectionId').reset();
		        					 form.down('#downoladtemplate').setVisible(true);
		        	        		 form.down('#downoladtemplate').setDisabled(true);
		        	        		 form.down('#cbsProgramId').setDisabled(true);
		        	        		 form.down('#cbsBatchId').setDisabled(true);
		        	        		 form.down('#cbsProgramId').setVisible(false);
		        	        		 form.down('#cbsBatchId').setVisible(false);
		        	        		 form.down('#cbsProgramId').reset();
		        	        		 form.down('#cbsBatchId').reset();
		        				 }else if (downloadType.id =="COURSE_SECTION"){
		        					 form.down('#calendarId').setVisible(true);
		        					 form.down('#calendarId').allowBlank = false;
		        					 form.down('#calendarId').reset();
		        					 form.down('#batchId').setVisible(false);
		        					 form.down('#batchId').allowBlank = true;
		        					 form.down('#periodId').setVisible(false);
		        					 form.down('#periodId').allowBlank = true;
		        					 form.down('#sectionId').setVisible(false);
		        					 form.down('#sectionId').allowBlank = true;
		        					 form.down('#downoladtemplate').setVisible(true);
		        	        		 form.down('#downoladtemplate').setDisabled(true);
		        	        		 form.down('#cbsProgramId').setVisible(true);
		        	        		 form.down('#cbsBatchId').setVisible(true);
		        	        		 form.down('#cbsProgramId').reset();
		        	        		 form.down('#cbsBatchId').reset();
		        				 }
		        			 }
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#uploadType' : {
		        			 change : function(obj, uploadType) {
		        				 var $this=this;
		        				 var form =$this.getUploadtemplate();
		        				 var values = form.getValues();
		        				 var moduleName = null;
		        				 //var uploadType = record[0].data;
		        				 var type = uploadType;
		        				 if(type == "PROGRAM_BATCH_SECTION") {
		        					 moduleName='IMPORT_BULK_TIME_TABLE_UPLOAD'
		        				 }else if(type == "COURSE_SECTION") {
		        					 moduleName='IMPORT_BULK_CBS_TIME_TABLE_UPLOAD'
		        				 }
		        				 if(type == "PROGRAM_BATCH_SECTION"){
		        					 form.down('#moduleName').setVisible(true);
		        					 //form.down('#uploadFileField').setVisible(true);
		        					 //form.down('#uploadFileField').reset();
		        					 //form.down('#programBatchUpload').setVisible(true);
		        					 //form.down('#programBatchUpload').hidden = false;
		        					 form.isValid();
		        					 form.down('#resetBtn').setVisible(true);
		        					 form.down('#resetBtn').hidden = false;//
		        					 //form.down('#importListTimeTableItemId').setVisible(true);
		        					 var comboImport = form.down('#moduleName');

		        					 comboImport.getStore().load({
		        						 callback:function(records){
		        							 for(var i in records){
		        								 if(records[i].data.value=='MasterTimeTable'){
		        									 comboImport.setValue(records[i].data.id);
		        									 comboImport.setReadOnly(true);
		        								 }
		        							 }
		        						 }
		        					 });
		        				 }else if (type == "COURSE_SECTION"){
		        					 form.down('#moduleName').setVisible(true);
		        					 //form.down('#uploadFileField').setVisible(true);
		        					 //form.down('#uploadFileField').reset();
		        					 //form.down('#programBatchUpload').setVisible(true);
		        					 //form.down('#programBatchUpload').hidden = false;
		        					 form.isValid();
		        					 form.down('#resetBtn').setVisible(true);
		        					 form.down('#resetBtn').hidden = false;
		        					 var comboImport = form.down('#moduleName');
		        					 comboImport.getStore().load({
		        						 callback:function(records){
		        							 for(var i in records){
		        								 if(records[i].data.value=='Bulk CBS TimeTable'){
		        									 comboImport.setValue(records[i].data.id);
		        									 comboImport.setReadOnly(true);
		        								 }
		        							 }
		        						 }
		        					 });
		        				 }
		        				 var grid = $this.getImportlisttimetable();
		        				 grid.setVisible(true);
		        				 var form = $this.getUploadoptionradiogroup();
		        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
		        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#calendarId': {
		        			 select: function(obj, record) {
		        				 var $this = this;
		        				 var calendarId = record[0].get("id");
		        				 if(calendarId > 0){
		        					 var form =$this.getUploadtemplate();
		        					 var type = form.getForm().findField('downloadType').getValue();
		        					 var uploadType = form.getForm().findField('uploadType').getValue();
		        					 if(type=="COURSE_SECTION"  || type=="Course Section" 
		        						 || uploadType=="Course Section" || type=="Subject Section"){ // CBS
		        						 form.down('#downoladtemplate').setVisible(true);
		        						 form.down('#downoladtemplate').hidden = false;
		        						 form.down('#resetBtn').setVisible(true);
		        						 form.down('#downoladtemplate').setDisabled(false);
		        		        		 form.down('#resetBtn').setDisabled(false);
		        		        		 var cbsProgramCombo = form.down('#cbsProgramId');
		        		        		 var cbsBatchCombo = form.down('#cbsBatchId');
		        		        		 cbsProgramCombo.reset();
		        		        		 cbsBatchCombo.reset();
		        		        		 cbsProgramCombo.setDisabled(false);
		        		        		 cbsBatchCombo.setDisabled(true);
		        		        		 var cbsProgramStore = form.down('#cbsProgramId').getStore();
		        						 cbsProgramStore.getProxy().extraParams = {
		        							 calendarId: calendarId
		        						 };
		        						 cbsProgramStore.load();
		        					 }else{
		        						 form.down("#batchId").setDisabled(false);
		        						 var batchCombo = form.down("#batchId");
		        						 var batchStore = batchCombo.getStore();
		        						 batchStore.getProxy().extraParams = {
		        							 calendarId: calendarId
		        						 };
		        						 batchStore.load();
		        					 }
		        				 }
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#cbsProgramId': {
		        			 select: function(obj, record) {
		        				 var $this = this;
		        				 var form =$this.getUploadtemplate();
		        				 var cbsProgramId = record[0].get("id");
		        				 var calendarId = form.down('#calendarId').getValue();
		        				 var cbsBatchCombo = form.down('#cbsBatchId');
		        				 cbsBatchCombo.setDisabled(false);
		        				 cbsBatchCombo.reset();
		        				 cbsBatchStore = cbsBatchCombo.getStore();
		        				 cbsBatchStore.getProxy().extraParams = {
        							 calendarId: calendarId,
        							 programId : cbsProgramId
        						 };
		        				 cbsBatchStore.load();
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#batchId': {
		        			 select: function(obj, record) {
		        				 var $this = this;
		        				 var form =$this.getUploadtemplate();
		        				 var batchId = record[0].get("id");
		        				 var form =$this.getUploadtemplate();
		        				 form.down("#periodId").setDisabled(false);
		        				 var periodCombo = form.down('#periodId');
		        				 var periodStore = periodCombo.getStore();
		        				 periodStore.getProxy().extraParams = {
		        					 id: batchId
		        				 };
		        				 periodStore.load({


	        						   callback: function(records, operation, success) {
	        							   if (success) {
	        								   if(records.length==0){
	        									   if(wheatherSchool) {
	        										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

	        									   } 
	        								   }
	        								   else if(records.length==1){
	        									   form.down("#periodId").setValue(records[0].get('id'))
	        									   form.down("#sectionId").setDisabled(false);
	        									   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
	        									   store.getProxy().extraParams = {
	        										   periodId: records[0].get('id')
	        									   };
	        									   store.load({
	        										   callback: function(records, operation, success) {
	        											   if (success) {
	        												   if(records.length==1){
	        													   form.down("#sectionId").setValue(records[0].data.sectionId);
	        													   form.down('#downoladtemplate').setVisible(true);
	        							        					 form.down('#downoladtemplate').hidden = false;
	        							        					 form.down('#resetBtn').setVisible(true);
	        							        					 form.down('#downoladtemplate').setDisabled(false);
	        							        					 form.down('#resetBtn').setDisabled(false);
	        									    		 
	        											   }
	        											   }
	        										   }
	        									   });

	        								   }else{
	        									   form.down('#periodId').setVisible(true); 
	        								   }
	        							   }
	        						   }
	        					   
	        					   
	        					
	        					   
		        				 });
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#periodId': {
		        			 select: function(obj, record) {
		        				 var $this = this;
		        				 var form =$this.getUploadtemplate();
		        				 var periodId = record[0].get("id");
		        				 if(periodId > 0){
		        					 form.down("#sectionId").setDisabled(false);
		        					 var sectionCombo = form.down('#sectionId');
		        					 var sectionStore = sectionCombo.getStore();
		        					 sectionStore.getProxy().extraParams = {
		        						 periodId : periodId
		        					 };
		        					 sectionStore.load();
		        				 }
		        			 }
		        		 },
		        		 'uploadtemplate customcombobox#sectionId': {
		        			 select: function(obj, record) {
		        				 var $this = this;
		        				 var form =$this.getUploadtemplate();
		        				 var sectionId = record[0].data.sectionId;
		        				 if(sectionId > 0){
		        					 form.down('#downoladtemplate').setVisible(true);
		        					 form.down('#downoladtemplate').hidden = false;
		        					 form.down('#resetBtn').setVisible(true);
		        					 form.down('#downoladtemplate').setDisabled(false);
		        					 form.down('#resetBtn').setDisabled(false);
		        				 }
		        			 }
		        		 },
		        		 'uploadtemplate radiogroup[itemId=templateTypeId]':{
		        			 change: function(obj,record) {
		        				 this.changeTemplateType(obj,record);
		        			 }
		        		 },
		        		 'uploadtemplate button[itemId=downoladtemplate]' : {
		        			 click : function(obj){
		        				 var $this = this;
		        				 var form =$this.getUploadtemplate();
		        				 this.getDownloadTemplate(form);
		        			 }
		        		 },
		        		 'mastertimetabledetailedwindow button[itemId=detailedBtn1]':{
		        			 click: this.addMoreDetailed
		        		 },
		        		 'mastertimetabledetailedwindow button[itemId=detailedDeleteBtn1]':{
		        			 click : function(deleteButton) {
		        				 this.deleteMoreDetailed(deleteButton)
		        			 }
		        		 },
		        		 'timetablestructure tabpanel[itemId=allVisibleTP] tab':{
		        			 activate: function(){
		        				 var me = this;
		        				 setTimeout(function(){
			        				 var  contentPanelMain = me.getContentPanel().getActiveTab();
			        				 try{
				        				 contentPanelMain.scrollBy(0,1);
				        				 contentPanelMain.scrollBy(0,-1);
			        				 }
			        				 catch(e){
			        					 
			        				 }
		        				 },10);
		        			 }
		        		 },
		        		 'createmastertimetablegrid button[itemId=btnAdd]' : {
    	          			 click : function() {
    	          				 this.openDetailedWindow();
    	          			 }
    	          		 },
    	          		 'createmastertimetablegrid button[itemId=btnDelete]' : {
    	          			 click : function() {
    	          				 var grid = this.getCreatemastertimetablegrid();
    	          				 var records = grid.getSelectionModel().getSelection();
    	          				 var selectedRecords = new Array();
    	          				 if(records !=undefined && records.length > 0) {
    	          					 for(var i=0;i<records.length;i++){
    	          						 selectedRecords.push(records[i].data.id);
    	          					 }
    	          					ids = selectedRecords.join();
       	          				 	this.deleteMasterTimeTable(ids);
    	          				 }else{
    	          					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record	
    	          				 }
    	          			 }
    	          		 },
    	          		'mastertimetabledetailedwindow customcombobox#cycleWeekDayId': {
 	        			   select: function(obj, record) {
 	        				   var weekday = record[0].get("code");
 	        				   var masterSearchFilterForm = this.getMastersearchfilter();
 	        				   var filterForm = masterSearchFilterForm.getForm();
 	        				   var values = filterForm.getValues();
 	        				   var calendarId = values.calendar;
 	        				   var sectionId = values.section;
 	        				   // For CBS
 	        				   var courseVariantId;
 	        				   if(isNullOrEmpty(sectionId)){
 	        					   sectionId = values.courseSection;
 	        					   courseVariantId = values.courseVariantId;
 	        				   }
 	        				   var masterDetailedForm = this.getMastertimetableDetailedwindow();
 	        				   var values = masterDetailedForm.getForm().getValues();

 	        				   var variantId = values.variant;
 	        				   var facultyId = values.faculty;
 	        				   if(isNullOrEmpty(variantId)){
 	        					   variantId = courseVariantId;
 	        				   }

 	        				   var periodCombo = masterDetailedForm.down('#periodTimingsId');
 	        				   periodCombo.setDisabled(false);
 	        				   var periodStore = periodCombo.getStore();
 	        				   periodStore.getProxy().extraParams = {
 	        					   weekDay: weekday,
 	        					   calendarId:calendarId,
 	        					   sectionId:sectionId,
 	        					   variantId:variantId,
 	        					   facultyId:facultyId

 	        				   };
 	        				   periodStore.load();
 	        				   
 	        			   }
 	        		   },
 	                  'xmluploadtemplate button[itemId=xmlUploadBtn]':{
 	       			   click: function(){
 	       				   var $this=this;
 	       				   var moduleName = null;
 	     	    	        	var importWin=$this.getXmluploadtemplate();
 	     	    	        	var values = importWin.getValues();
 	     	    	        	var grid = $this.getImportxmltimetablelist();
 	     	    	        	var grdStore;
 	     	    	        	var loggedInUser=$this.getCurrentlyLoggedInUser();
                    		    var loggedInUserId = loggedInUser.id;
 	     	    	        	var form=$this.getXmluploadtemplate();
 	     	    	        	submitUrl = SERVERURL.PATH_XML_IMPORT_FILE;
 			    	        	$this.getHashOfFile(form);
 					        	setTimeout(function() {
	 	     	    	        	form.getForm().submit({
	 	     	    	        		method : 'POST',
	 	     	    	        		url : submitUrl,
	 	     	    	        		
	 	     	    	        		success : function(form, action){
	 	     	    	        			showSuccessMessage(getProgramandcourseTranslation('XML_IMPORT_TIME_TABLE') , getCommonTranslation('SUCCESS'));
	 	     	    	    	        },
	 	     	    	        		failure: function(form, action) {
			   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				    	    	        }
	 	     	    	        	});
 					        	},1000);
 	     	    	        	Ext.defer(function() {
 	     	    	        		 var form = $this.getUploadoptionradiogroup();
 	     	    	        		 //var isUploadAll = form.items.items[0].getValue().isUploadAll;
 	     	    	        		 $this.getXMLUploadedFile(grid);
 	     	    	        	}, 2000, this);
 	       			   }
 	       		   },
 	       		   'importxmltimetablelist':{
 	       			  cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	         				if (e.target.tagName == 'A') {
 	         					var fileType=null;
 	         					if(cellIndex==0){
 	         						fileType='successFile';
 	         					}else if(cellIndex==5){
 	         						fileType='logFile';
 	         					}
 	         					var documentId = record.get("id");
 	         					if (!isNullOrEmpty(documentId)) {
 	         						this.getDownloadTimeTableFile(documentId,fileType);
 	         					}
 	         				}
 	         			}
 	        		  },
 	        		 'importxmltimetablelist button[itemId=btnForce]':{
 	           			click: function(obj) {
 	        	            	var grid = this.getImportxmltimetablelist();
 	        	            	if (grid.getSelectionModel().getCount() > 0) {
 	        	            		if(grid.getSelectionModel().getCount() > 1){
 	        		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
 	        		        		}else{
 	        		        			var this$ = this;
 	           	                	var id = grid.getSelectionModel().selectionStart.data.id;
 	           	                	console.log(id);
 	           	                	var academyLocationId = "&academyLocationId="+this.getCurrentAcademyLocation();
 	           	                	var urlAppend="?jobId="+id;
 	           	                	var submitURL = SERVERURL.PATH_XML_IMPORT_FILE_JOB_FORCERUN+urlAppend+academyLocationId;
 	           	    	        	Ext.Ajax.request({
 	           	    	        		url: submitURL,
 	           	    	        		method: 'GET',
 	           	    	        		success: function(response) {
 	           	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
 	           	    	        				showWarningMessage(getProgramandcourseTranslation('XML_IMPORT_TIME_TABLE'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
 	           	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
 	           	    	        				//console.log("Manual trigger hit");
 	           	    	        				showWarningMessage(getProgramandcourseTranslation('XML_IMPORT_TIME_TABLE'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
 	           	    	        			}else if(response.responseText==="SUCCESS"){
 	           	    	        				//console.log("Manual trigger hit");
 	               	    	        			showSuccessMessage(getProgramandcourseTranslation('XML_IMPORT_TIME_TABLE')	,getCommonTranslation('SUCCESS'));
 	           	    	        			}
 	           	    	        		}
 	           	    	        	});
 	        		        		}
 	        	            	} else {
 	        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
 	        	            	}  
 	        	            }
 	         		   },
 	         		   'xmluploadtemplate button[itemId=resetBtn]':{
 	         			   click: function(){
 	         				   var $this=this;
 	     	    	        	var form=$this.getXmluploadtemplate();
 	     	    	        	var academyLocationField = form.down('#academyLocationComboId');
 	     	    	        	var calendarField = form.down('#calendarId');
 	     	    	        	var academicTermField = form.down('#academicTermId');
		        				academyLocationField.reset();
		        				calendarField.reset();
		        				academicTermField.reset();
		        				calendarField.setDisabled(true);
		        				academicTermField.setDisabled(true);
 	     	    	        	var values = form.getValues();
 	     	    	        		form.down('#uploadFileField').reset();
 	     	    	        		form.isValid();
 	         			   }
 	         		   },
 	         		 
 					'generatetabulationreportwin[itemId=generatematertimetablereportwin] button[itemId=submitBtn]':{
 			  			   click:function(obj){
 			  				   var $this = this;
 			  				   $this.downloadMasterTimetablePDF();
 			  			   }
 			  		},
 			  		'xmluploadtemplate customcombobox#academyLocationComboId':{
 	       			     select: function(obj, record) {
								var $this = this;
		        				var form =$this.getXmluploadtemplate();
		        				var academyLocationId = record[0].data.id;
		        				var calendarField = form.down('#calendarId');
		        				calendarField.setDisabled(false);
		        				var calendarStore = calendarField.getStore();
		            		    calendarStore.getProxy().extraParams = {
		            		   academyLocationId: academyLocationId
		            			};
		            	      calendarStore.load();
	
 	       			   }
 	       		   },
 	       		   
 	       		   'xmluploadtemplate customcombobox#calendarId':{
 	       			     select: function(obj, record) {
								var $this = this;
		        				var form =$this.getXmluploadtemplate();
		        				var calendarId = record[0].data.id;
		        				var academicTermField = form.down('#academicTermId');
		        				academicTermField.reset();
		        				academicTermField.setDisabled(false);
		        				var academicTermStore = academicTermField.getStore();
					academicTermStore.load({
						callback: function(record, operation, success) {
							if (success) {
								if(record.length>0){
									Ext.each(record, function(value) {
										if(value.get('whetherCurrentAcademicTerm')){
											academicTermField.down("#academicTermId").setValue(value.get('id'));
										}
									});
								}
							}
						}
					});
	
 	       			   }
 	       		   },
	        	 });
	         },
	         /**
	          * openCalendarWin open master calendar 
	          */
	         openCalendarWin:function(){
	        	 var $this =this;
	        	 var mastersearchfilter = this.getMastersearchfilter();
	        	 var values = mastersearchfilter.getForm().getValues()
	        	 var whetherDayWiseSchedule = mastersearchfilter.down('#whetherDayWiseScheduleId').getValue();
	        	 var contentpanel = this.getContentPanel();
	        	 if(whetherDayWiseSchedule == 'true') {
	        		 var mastertimetablecalendar = Ext.widget('daywisemastertimetablestructure');
	        		 var grid = mastertimetablecalendar.down('grid');
	        		 var calendar = mastersearchfilter.getForm().findField('calendar').getRawValue();
	        		 if(values.sectionType == 'COURSE_SECTION') {
	        			 grid.columns[2].hidden = true;
		        		 grid.columns[3].hidden = true;
	        			 mastertimetablecalendar.down('#calendarName').setVisible(true);
	        			 mastertimetablecalendar.down('#academicTerm').setVisible(true);
	        			 mastertimetablecalendar.down('#courseName').setVisible(true);
	        			 mastertimetablecalendar.down('#sectionName').setVisible(true);
	        			 mastertimetablecalendar.down('#programBatchName').setVisible(false);
	        			 mastertimetablecalendar.down('#periodName').setVisible(false);
	        			 mastertimetablecalendar.down('#calendarName').setValue(calendar);
	        			 if(isNullOrEmpty(mastersearchfilter.getForm().findField('ACADEMIC_TERM').getRawValue())) {
	        				 mastertimetablecalendar.down('#academicTerm').setValue('-');
	        			 } else {
	        				 mastertimetablecalendar.down('#academicTerm').setValue(mastersearchfilter.getForm().findField('ACADEMIC_TERM').getRawValue());
	        			 }
	        			 mastertimetablecalendar.down('#courseName').setValue(mastersearchfilter.getForm().findField('course').getRawValue());
	        			 mastertimetablecalendar.down('#sectionName').setValue(mastersearchfilter.getForm().findField('courseSection').getRawValue());
	        		 } else {
	        			 grid.columns[2].hidden = false;
		        		 grid.columns[3].hidden = false;
	        			 mastertimetablecalendar.down('#calendarName').setVisible(true);
	        			 mastertimetablecalendar.down('#sectionName').setVisible(true);
	        			 mastertimetablecalendar.down('#programBatchName').setVisible(true);
	        			 var alinfomodel = Academia.model.authentication.ALInfoModel;
      				   	 var wheatherSchool = alinfomodel.get('wheatherSchool');
      				   	 if(wheatherSchool) {
      				   		 mastertimetablecalendar.down('#periodName').setVisible(false);
      				   	 } else {
      				   		 mastertimetablecalendar.down('#periodName').setVisible(true);
      				   	 }
	        			 mastertimetablecalendar.down('#academicTerm').setVisible(false);
	        			 mastertimetablecalendar.down('#courseName').setVisible(false);
	        			 mastertimetablecalendar.down('#calendarName').setValue(calendar);
	        			 mastertimetablecalendar.down('#sectionName').setValue(mastersearchfilter.getForm().findField('section').getRawValue());
	        			 mastertimetablecalendar.down('#programBatchName').setValue(mastersearchfilter.getForm().findField('batch').getRawValue());
	        			 mastertimetablecalendar.down('#periodName').setValue(mastersearchfilter.getForm().findField('period').getRawValue());
	        		 }
	        		 var tabName = getProgramandcourseTranslation('MASTER_TIME_TABLE');
		        	 var getcontroller=this.getController('menu.CoreERPNavigationController');
		        	 var getTab=getcontroller.getTab(tabName);
		        	 if(getTab!=null){
		        		 contentpanel.remove(getTab, true);
		        	 }
		        	 openTab(contentpanel, tabName, mastertimetablecalendar,CONSTANTS.MENU_COLOR_THREE);
	        	 } else {
		        	 var mastertimetablecalendar = Ext.widget('mastertimetableform');
		        	 var tabName = getProgramandcourseTranslation('MASTER_TIME_TABLE');
		        	 var getcontroller=this.getController('menu.CoreERPNavigationController');
		        	 var getTab=getcontroller.getTab(tabName);
		        	 if(getTab!=null){
		        		 contentpanel.remove(getTab, true);
		        	 }
		        	 openTab(contentpanel, tabName, mastertimetablecalendar,CONSTANTS.MENU_COLOR_THREE);
	        	 }
	        	 this.showCalendarData();
	         },
	         
	         openInSameTab: function(button){
	        	 var $this =this;
	        	 try{
		        	 button.up('panel').collapse();
	        	 }
	        	 catch(e){
	        		 
	        	 }
	        	 var mastersearchfilter = this.getMastersearchfilter();
	        	 var values = mastersearchfilter.getForm().getValues()
	        	 var whetherDayWiseSchedule = mastersearchfilter.down('#whetherDayWiseScheduleId').getValue();
	        	 var contentpanel = this.getContentPanel();
	        	 var mainCalendarPanel = mastersearchfilter.up('tabpanel').down('#masterTimeTableMainPanel');
	        	 mainCalendarPanel.setVisible(true);
	        	 if(whetherDayWiseSchedule == 'true') {
	        		 var mastertimetablecalendar = Ext.widget('daywisemastertimetablestructure');
	        		 var grid = mastertimetablecalendar.down('grid');
	        		 var calendar = mastersearchfilter.getForm().findField('calendar').getRawValue();
	        		 if(values.sectionType == 'COURSE_SECTION') {
	        			 grid.columns[2].hidden = true;
		        		 grid.columns[3].hidden = true;
	        			 mastertimetablecalendar.down('#calendarName').setVisible(false);
	        			 mastertimetablecalendar.down('#academicTerm').setVisible(false);
	        			 mastertimetablecalendar.down('#courseName').setVisible(false);
	        			 mastertimetablecalendar.down('#sectionName').setVisible(false);
	        			 mastertimetablecalendar.down('#programBatchName').setVisible(false);
	        			 mastertimetablecalendar.down('#periodName').setVisible(false);
	        			 mastertimetablecalendar.down('#calendarName').setValue(calendar);
	        			 if(isNullOrEmpty(mastersearchfilter.getForm().findField('ACADEMIC_TERM').getRawValue())) {
	        				 mastertimetablecalendar.down('#academicTerm').setValue('-');
	        			 } else {
	        				 mastertimetablecalendar.down('#academicTerm').setValue(mastersearchfilter.getForm().findField('ACADEMIC_TERM').getRawValue());
	        			 }
	        			 mastertimetablecalendar.down('#courseName').setValue(mastersearchfilter.getForm().findField('course').getRawValue());
	        			 mastertimetablecalendar.down('#sectionName').setValue(mastersearchfilter.getForm().findField('courseSection').getRawValue());
	        		 } else {
	        			 grid.columns[2].hidden = false;
		        		 grid.columns[3].hidden = false;
	        			 mastertimetablecalendar.down('#calendarName').setVisible(false);
	        			 mastertimetablecalendar.down('#sectionName').setVisible(false);
	        			 mastertimetablecalendar.down('#programBatchName').setVisible(false);
	        			 var alinfomodel = Academia.model.authentication.ALInfoModel;
      				   	 var wheatherSchool = alinfomodel.get('wheatherSchool');
      				   	 if(wheatherSchool) {
      				   		 mastertimetablecalendar.down('#periodName').setVisible(false);
      				   	 } else {
      				   		 mastertimetablecalendar.down('#periodName').setVisible(false);
      				   	 }
	        			 mastertimetablecalendar.down('#academicTerm').setVisible(false);
	        			 mastertimetablecalendar.down('#courseName').setVisible(false);
	        			 mastertimetablecalendar.down('#calendarName').setValue(calendar);
	        			 mastertimetablecalendar.down('#sectionName').setValue(mastersearchfilter.getForm().findField('section').getRawValue());
	        			 mastertimetablecalendar.down('#programBatchName').setValue(mastersearchfilter.getForm().findField('batch').getRawValue());
	        			 mastertimetablecalendar.down('#periodName').setValue(mastersearchfilter.getForm().findField('period').getRawValue());
	        		 }		
	        	 } else {
		        	 var mastertimetablecalendar = Ext.widget('mastertimetableform');
	        	 }
	        	 mainCalendarPanel.removeAll();
	        	 mainCalendarPanel.add(mastertimetablecalendar);
        		 mainCalendarPanel.doLayout();
        		 
	        	 this.showCalendarData();
	        	 setTimeout(function(){
	        		 var button = mastersearchfilter.down('#viewCalanderId');
	        		 button.setDisabled(false);
	        	 },300);
	         },
	            
	            showCalendarData:function(){
	            	var me=this;
	            	var calendar = this.getMastertimetablecalendar();
	            	var masterSearchFilterForm = this.getMastersearchfilter();
	            	var filterForm = masterSearchFilterForm.getForm();
	            	var whetherDayWiseSchedule = filterForm.findField('whetherDayWiseSchedule').getValue();
	            	var values = filterForm.getValues();
	            	var sectionId = values.section;
	            	// For CBS
	            	if(isNullOrEmpty(sectionId)){
	            		sectionId = values.courseSection;
	            	}
	            	if(whetherDayWiseSchedule == 'false') {
	            		calendar.eventStore.getProxy().url = SERVERURL.MASTER_TIME_TABLE_CALENDAR; //'data/systemusage/CalendarStaticData.json';//submitURL;//'http://localhost:8080/serosoft-academia-web/rest/courseCoveragePlan/calendar?id=71&resourceName=section';   
		            	
		            	calendar.eventStore.getProxy().extraParams = {
		            		sectionId:sectionId
						 };
		            	calendar.eventStore.addListener('load',function(rec){
		            		me.scrollToCurrentTime(rec);
		            	});
		            	calendar.eventStore.load(); 
	            	} else {
	            		var grid = this.getCreatemastertimetablegrid();
	            		var store = grid.getStore();
	            		store.getProxy().extraParams = {
	            			sectionId:sectionId
	            		};
	            		this.resetPageSetting(store);
	            		store.load();
	            		me.scrollToCurrentTime();
	            	}
	            	
	            	
	            },
	            scrollToCurrentTime: function(calendarStore){
	            	try{
	            		var me = this,minTimeArray=[],rawData;
	            		var masterSearchFilterForm = this.getMastersearchfilter();
		            	var filterForm = masterSearchFilterForm.getForm();
		            	var values = filterForm.getValues();
	            		if(calendarStore.data.items.length==0){
	            			Ext.Ajax.request({
	    	                    type: 'rest',
	    	                    url: SERVERURL.PATH_FIND_CALENDER_WEEK_SATRT_DAY_SLOTES_BY_CALENDER_ID, //URL-:rest/application/assignApplicationID													 
	    	                    method: 'GET',
	    	                    async: false,
	    	                    headers: {
	    	                        'Content-Type': 'application/json'
	    	                    },
	    	                    params: {
	    	                    	calendarId:values.calendar
	    	                    },
	    	                    success: function(form, action) {
	    	                    	var timeSlotsAr = JSON.parse(form.responseText);
	    	                    	for(i=0; i<timeSlotsAr.length; i++){
	    	                    		rawData = timeSlotsAr[i].split(':')[0];
	    		            			minTimeArray.push(parseInt(rawData));
	    	                    	}
	    	                    }
	    	                });
	            		}
	            		if(calendarStore && !calendarStore.data.items.length==0){
	            		calendarStore.data.items.forEach(function(rec){
	            			rawData = rec.raw.startTime.split(':')[0];
	            			minTimeArray.push(parseInt(rawData));
	            		});
	            		}
	            		var structure = me.getContentPanel();
	            		var activatedTab = structure.getActiveTab();
	            		var structureBody = activatedTab.body;
	            		var currentTimeHour =Math.min.apply(null,minTimeArray);//new Date().getHours();
	            		structureBody.setScrollTop();
	            		structureBody.scrollBy(0,168);
	            		setTimeout(function(){
	            			structureBody.scrollBy(0,((77*currentTimeHour)));
	            		},500);
	            	}
	            	catch(e){
	            	}
	            },
	            /**
		          * openDetailedWindow open detailed window on click of add button on master calendar 
		          */
	            openDetailedWindow:function(){
	            	var $this =this;
	            	var masterSearchFilterForm = $this.getMastersearchfilter();
	            	var filterForm = masterSearchFilterForm.getForm();
	            	var values = filterForm.getValues();
	            	var formWindow = $this.getMastertimetabledetailedwindow();
	            	if (!formWindow) {
	            		Ext.widget('mastertimetabledetailedwindow');
	            		formWindow = $this.getMastertimetabledetailedwindow();
	            	}
	            	this.disableAllFacultyCheckBoxPivileges(formWindow,this.getMASTER_TIME_TABLE_PRIVILEGES());
	            	formWindow.show();
	            	this.loadWeekDayData();
	            },
	            loadWeekDayData:function(){
	            	var $this = this;
	            	var masterSearchFilterForm = $this.getMastersearchfilter();
	            	var filterForm = masterSearchFilterForm.getForm();
	            	var values = filterForm.getValues();
	            	var calendarId = values.calendar;
	            	var sectionId = values.section;
	            	var academicTermId = values.ACADEMIC_TERM;
	            	var whetherDayWiseSchedule = masterSearchFilterForm.down('#whetherDayWiseScheduleId').getValue();
	            	var masterDetailedForm = $this.getMastertimetableDetailedwindow();	
	            	masterDetailedForm.getForm().findField('academicTermId').setValue(academicTermId);
	            	if(whetherDayWiseSchedule == 'true') {
	            		var weekDayCombo = masterDetailedForm.down('#weekDayId');
	            		weekDayCombo.setVisible(false);
	            		this.setAllowBlank(weekDayCombo, true);
	            		var cycleWeekDayCombo = masterDetailedForm.down('#cycleWeekDayId');
	            		cycleWeekDayCombo.setVisible(true);
		            	var weekDayStore = cycleWeekDayCombo.getStore();
		            	weekDayStore.getProxy().extraParams = {
		            		calendarId: calendarId
		            	};
		            	weekDayStore.load();
	            	} else {
	            		var weekDayCombo = masterDetailedForm.down('#weekDayId');
	            		weekDayCombo.setVisible(true);
	            		var cycleWeekDayCombo = masterDetailedForm.down('#cycleWeekDayId');
	            		cycleWeekDayCombo.setVisible(false);
	            		this.setAllowBlank(cycleWeekDayCombo, true);
		            	var weekDayStore = weekDayCombo.getStore();
		            	weekDayStore.getProxy().extraParams = {
		            		calendarId: calendarId
		            	};
		            	weekDayStore.load();
	            	}
	            	
	            	// for CBS ... hide variant drop down and show faculty directly
	            	if(isNullOrEmpty(sectionId)){
	            		var variantCombo = masterDetailedForm.down('#variantId');
	            		variantCombo.setVisible(false);
	            		variantCombo.allowBlank = true;
	            		sectionId = values.courseSection;
	            		var courseVariantId = values.courseVariantId;
	            		var masterDetailedForm = this.getMastertimetableDetailedwindow();
	            		masterDetailedForm.getForm().findField('courseVariantId').setValue(courseVariantId);
	            		var facultyCombo = masterDetailedForm.down('#facultyId');
	            		facultyCombo.setDisabled(false);
	            		var facultyStore = facultyCombo.getStore();
	            		facultyStore.getProxy().extraParams = {
	            			courseVariantId: courseVariantId
	            		};
	            		facultyStore.load();
	            	} 
	            	else {
	            		var variantCombo = masterDetailedForm.down('#variantId');
	            		var variantStore = variantCombo.getStore();
	            		variantStore.getProxy().extraParams = {
	            			sectionId: sectionId
	            		};
	            		variantStore.load();
	            	}
	            	// courseName hide by Default 
	            	var courseNameLabel = masterDetailedForm.down('displayfield#courseName');
    				courseNameLabel.setVisible(false);
	            	
    				$this.loadSection(sectionId);
	            },
	            
	            /**
	             * add dynamic fields in form 
	             */
	            addMoreDetailed:function(){
	            	var $this = this;

	            	var masterSearchFilterForm = $this.getMastersearchfilter();
	            	var filterForm = masterSearchFilterForm.getForm();
	            	var values = filterForm.getValues();
	            	var whetherDayWiseSchedule = masterSearchFilterForm.down('#whetherDayWiseScheduleId').getValue();
	            	
	            	var periodStore = Ext.create('Ext.data.Store', {
	            		model : 'Academia.model.coursetransaction.sectioncoursecoverageplan.mastertimetable.PeriodsByCalendar',
	            		autoLoad : false,
	            		proxy : {
	            			type : 'rest',
	            			api:{
	            				read:SERVERURL.GET_MASTER_DETAILS
	            			},
	            			reader: {
	            				type:'json'
	            			}
	            		}
	            	});
	            	
	            	var masterDetailedForm = $this.getMastertimetableDetailedwindow();            	
	            	var panelContiner = masterDetailedForm.down('#panelId');

	            	var panelItem = new Array();
	            	if(whetherDayWiseSchedule == 'true') {
	            		panelItem.push({

		            		xtype : 'fieldcontainer',
		            		layout : 'hbox',
		            		defaults : {
		            			labelAlign : 'top',
		            			width:226
		            		},
		            		layout : {
		            			type : 'hbox'
		            		},
		            		items:[{
			       				 xtype: 'customcombobox',
			    				 name: 'faculty',
			    				 store:'coursetransaction.homework.assignmentdetails.Faculty',
			    				 displayField:'value',
			    				 valueField:'id',
			    				 allowBlank:false,
			    				 typeAhead:true,
			    				 forceSelection:true,
			    				 listeners:{
			    					 afterrender: function(obj, rec,value){
			    						 
			    						 var facultyField = obj;
			    						 var variantField = obj.up('form').down('#variantId');
			    						 var cmb = obj.up('form').down('#allFacultyCheckId');

			    						 if(variantField.isVisible()){
			    							 var variantId = variantField.getValue();
			    						 }
			    						 else{
			    							 try{
			    								 var variantId = Ext.ComponentQuery.query('mastersearchfilter')[0].getForm().getValues().courseVariantId;
			    							 }
			    							 catch(e){
			    								 var variantId = '';
			    								 //--
			    							 }
			    						 }

			    						 if(cmb.getValue() == true){
			    							 var facultyStore = Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty',{
			    								 proxy : {
			    									 type : 'rest',
			    									 api:{
			    										 read:SERVERURL.PATH_FIND_STAFF_BY_AL_ID
			    									 },
			    									 reader: {
			    										 type: 'json'
			    									 },
			    									 extraParams: {
			    										 id: this$.getCurrentAcademyLocation()
			    									 }	
			    								 }
			    							 });

			    						 }
			    						 else{
			    							 var facultyStore = Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty',{
			    								 proxy : {
			    									 type : 'rest',
			    									 api:{
			    										 read:SERVERURL.HW_ASSIGN_FACULTY
			    									 },
			    									 reader: {
			    										 type: 'json'
			    									 },
			    									 extraParams: {
			    										 courseVariantId: variantId
			    									 }	
			    								 }
			    							 });
			    						 }

			    						 var cFields = Ext.ComponentQuery.query('mastertimetabledetailedwindow [name=faculty]');

			    						 facultyField.bindStore(facultyStore);
			    						 facultyStore.load({
			    							 callback: function(){
			    								 var masterSearchFilterForm = $this.getMastersearchfilter();
				    							 var filterForm = masterSearchFilterForm.getForm();
				    							 var values = obj.up('form').getForm().getValues();
				    							 var facultyId = values.faculty;
				    							 for(var j in facultyId){
				    								 if(facultyId[j]==""){
				    									 obj.setValue(facultyId[j-1]);
				    								 }
				    							 }
			    							 }
	    								 });
			    					 },
			    					 select: function(obj, rec,value) {
				        				   var courseVariantId = rec[0].get("id");
				        				   obj.nextSibling().reset();
				        			   }
			    				 }
			    			 },{
		        				xtype: 'customcombobox',
		        				name: 'cycleWeekDay',
		        				store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.CycleWorkingDays',
		        				displayField:'value',
		        				valueField:'id',
		        				allowBlank:false,
		        				typeAhead:true,
		        				forceSelection:true,
		            			listeners:{
		            				select:function(obj,rec,value){
		            					var weekday= rec[0].data.code;
		            					var values = obj.up('form').getForm().getValues();
		            					var periodTimingsIds = values.periodTimings;
		            					var cleanPeriodTimings = Ext.Array.clean(periodTimingsIds);
										var isEmpty=true;
										Ext.Array.each(periodTimingsIds, function(item) {
										    if (item !== "") {
										        isEmpty = false; 
										        return false;
										    }
										});
		            					var periodIds;
		            					if(cleanPeriodTimings.length > 0){
		            						periodIds = cleanPeriodTimings.join();
		            					}else if(cleanPeriodTimings.length==0 && isEmpty){
											periodIds="";
										}else{
		            						periodIds = periodTimingsIds;
		            					}
		            					
		            					var variantId = values.variant;
		            					var facultyId = values.faculty;
										var facultyIds =values.faculty;
										for(var j in facultyIds){
												  facultyId=facultyIds[j];		    									 
											}
		            					var masterSearchFilterForm = $this.getMastersearchfilter();
		            					var filterForm = masterSearchFilterForm.getForm();
		            					var filterValues = filterForm.getValues();
		            					var calendarId = filterValues.calendar;
		            					var sectionId = filterValues.section;
		            					// For CBS
		            	            	if(isNullOrEmpty(sectionId)){
		            	            		sectionId = filterValues.courseSection;
		            	            		variantId = filterValues.courseVariantId;
		            	            	}
		            					var nextSiblingField = obj.nextSibling();
		            					nextSiblingField.setDisabled(false);
		            					
		            					var periodStore = obj.nextSibling().getStore();
		            					periodStore.getProxy().extraParams = {
		            						weekDay: weekday,
		            						calendarId:calendarId,
		            						sectionId:sectionId,
		            						variantId:variantId,
		            						facultyId:facultyId,
		            						exceptIds:periodIds

		            					};
		            					periodStore.load();

		            				}
		            			}
		            		},{
		            			xtype: 'customcombobox',
		            			name: 'periodTimings',
		            			//fieldLabel: getProgramandcourseTranslation('PERIOD'),
		            			store:periodStore,
		            			displayField:'periodTimings',
		            			valueField:'calendarSlotId',
		            			queryMode:'local',
		            			allowBlank:false,
		            			disabled:true,
		            			typeAhead:true,
		            			forceSelection:true,
		            			listeners:{
		            				select:function(obj,rec,value){/*
		            					var nextSiblingField = obj.nextSibling();
		            					nextSiblingField.setDisabled(false);
		            					var roomStore = obj.nextSibling().getStore();
		            					roomStore.getProxy().extraParams = {
		            						calendarSlotId: rec[0].data.calendarSlotId
		            					};
		            					roomStore.load();
		            				 */
		            					var nxtSib = obj.nextSibling();
		            					nxtSib.setDisabled(false);
		            					var roomStore = obj.nextSibling().getStore();

		            					var form = obj.up('form').getForm();
		            					var homeRoomId = form.findField('homeRoomId').getValue(); 
		            					/*roomStore.getProxy().extraParams = {
		    							 calendarSlotId: rec[0].data.calendarSlotId
		      					   };
		    					   roomStore.load();*/
		            					obj.nextSibling().clearValue();
		            					obj.nextSibling().getStore().extraParams = {
		       							 calendarSlotId: rec[0].data.calendarSlotId
		       	                	   };
		            					obj.nextSibling().getStore().load({
		            						/*params:{
		            							calendarSlotId: rec[0].data.calendarSlotId
		            						},*/
		            						callback: function(records, operation, success) {
		            							if (success) {
		            								if(records.length > 0){
		            									for(var i in records){
		            										if(homeRoomId == records[i].data.id){
		            											obj.nextSibling().setValue(records[i].data.id);	
		            										}
		            									}
		            									var check = $this.getMastertimetableDetailedwindow().getForm().isValid();
		        		            					if(check){
		        		            						$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
		        		            					}
		            								}

		            							}
		            						}

		            					});

		            				}
		            			}
		            		},{
		            			xtype: 'customcombobox',
		            			name: 'room',
		            			width:226,
		            			//fieldLabel: getCourseTxCommonTranslation('CVG_ROOM'),
		            			store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.RoomByCalendar',
		            			displayField:'value',
		            			valueField:'id',
		            			allowBlank:false,
		            			disabled:true,
		            			typeAhead:true,
		            			forceSelection:true
		            		},{
		            			xtype: 'button',
		            			glyph: ICONGLYPH.DELETEGLYPH,
		            			itemId: 'detailedDeleteBtn1',
		            			width: 'auto',
		            			cls: 'CustomBodyBtnReject',
		            			tooltip: getCommonTranslation('DELETETOOLTIP'),
		            			listeners:{
		            				click:function(obj){
		            					var container = obj.up('fieldcontainer');
		            					//panelContiner.remove(container);
		            					var check = $this.getMastertimetableDetailedwindow().getForm().isValid();
		            					if(check){
		            						$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
		            					}
		            				}
		            			}
		            		},{
		   		        		xtype : 'button',
		   		        		itemId: 'detailedBtn1',
		   		        		width: 'auto',
		   		        		cls: 'CustomBodyBtnSettings',
		   						text: getCommonTranslation('ADDBUTTONTEXT'),
		   						tooltip: getCommonTranslation('ADD')
		        		   }]
		            	});
	            	} else {
	            		panelItem.push({

		            		xtype : 'fieldcontainer',
		            		layout : 'hbox',
		            		defaults : {
		            			labelAlign : 'top',
		            			width:226
		            		},
		            		layout : {
		            			type : 'hbox'
		            		},
		            		items:[{
			       				 xtype: 'customcombobox',
			    				 name: 'faculty',
			    				// fieldLabel: getCourseTxCommonTranslation('FACULTY'),
			    				 store:'coursetransaction.homework.assignmentdetails.Faculty',
			    				 displayField:'value',
			    				 valueField:'id',
			    				 allowBlank:false,
			    				 typeAhead:true,
			    				 forceSelection:true,
			    				 listeners:{
			    					 afterrender: function(obj, rec,value){
			    						 
			    						 var facultyField = obj;
			    						 var variantField = obj.up('form').down('#variantId');
			    						 var cmb = obj.up('form').down('#allFacultyCheckId');

			    						 if(variantField.isVisible()){
			    							 var variantId = variantField.getValue();
			    						 }
			    						 else{
			    							 try{
			    								 var variantId = Ext.ComponentQuery.query('mastersearchfilter')[0].getForm().getValues().courseVariantId;
			    							 }
			    							 catch(e){
			    								 var variantId = '';
			    								 //--
			    							 }
			    						 }

			    						 if(cmb.getValue() == true){
			    							 var facultyStore = Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty',{
			    								 proxy : {
			    									 type : 'rest',
			    									 api:{
			    										 read:SERVERURL.PATH_FIND_STAFF_BY_AL_ID
			    									 },
			    									 reader: {
			    										 type: 'json'
			    									 },
			    									 extraParams: {
			    										 id: this$.getCurrentAcademyLocation()
			    									 }	
			    								 }
			    							 });

			    						 }
			    						 else{
			    							 var facultyStore = Ext.create('Academia.store.coursetransaction.homework.assignmentdetails.Faculty',{
			    								 proxy : {
			    									 type : 'rest',
			    									 api:{
			    										 read:SERVERURL.HW_ASSIGN_FACULTY
			    									 },
			    									 reader: {
			    										 type: 'json'
			    									 },
			    									 extraParams: {
			    										 courseVariantId: variantId
			    									 }	
			    								 }
			    							 });
			    						 }

			    						 var cFields = Ext.ComponentQuery.query('mastertimetabledetailedwindow [name=faculty]');

			    						 facultyField.bindStore(facultyStore);
			    						 facultyStore.load({
			    							 callback: function(){
			    								 var masterSearchFilterForm = $this.getMastersearchfilter();
				    							 var filterForm = masterSearchFilterForm.getForm();
				    							 var values = obj.up('form').getForm().getValues();
				    							 var facultyId = values.faculty;
				    							 for(var j in facultyId){
				    								 if(facultyId[j]==""){
				    									 obj.setValue(facultyId[j-1]);
				    								 }
				    							 }
			    							 }
	    								 });
			    					 },
			    					 select: function(obj, rec,value) {
				        				   var courseVariantId = rec[0].get("id");
				        				   obj.nextSibling().reset();
				        			   }
			    				 }
			    			 },{
		            			xtype: 'customcombobox',
		            			name: 'weekDay',
		            			//fieldLabel: getProgramandcourseTranslation('WEEKDAY'),
		            			store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.WorkingWeekday',
		            			displayField:'value',
		            			valueField:'id',
		            			allowBlank:false,
		            			typeAhead:true,
		            			forceSelection:true,
		            			listeners:{
		            				select:function(obj,rec,value){
		            					var weekday= rec[0].get("code");
		            					var values = obj.up('form').getForm().getValues();
		            					var periodTimingsIds = values.periodTimings;
		            					var cleanPeriodTimings = Ext.Array.clean(periodTimingsIds);
		            					
		            					var periodIds;
		            					if(cleanPeriodTimings.length > 0){
		            						periodIds = cleanPeriodTimings.join();
		            					}else{
		            						periodIds = periodTimingsIds;
		            					}
		            					
		            					var variantId = values.variant;
		            					var faculty = values.faculty;
		            					for(var j in faculty){
		            						facultyId=faculty[j];		    									 
		    							 }

		            					var masterSearchFilterForm = $this.getMastersearchfilter();
		            					var filterForm = masterSearchFilterForm.getForm();
		            					var filterValues = filterForm.getValues();
		            					var calendarId = filterValues.calendar;
		            					var academicTermId=filterValues.ACADEMIC_TERM;
		            					var sectionId = filterValues.section;
		            					// For CBS
		            	            	if(isNullOrEmpty(sectionId)){
		            	            		sectionId = filterValues.courseSection;
		            	            		variantId = filterValues.courseVariantId;
		            	            	}
		            					var nextSiblingField = obj.nextSibling();
		            					nextSiblingField.setDisabled(false);
		            					
		            					var periodStore = obj.nextSibling().getStore();
		            					periodStore.getProxy().extraParams = {
		            						weekDay: weekday,
		            						calendarId:calendarId,
		            						academicTermId:academicTermId,
		            						sectionId:sectionId,
		            						variantId:variantId,
		            						facultyId:facultyId,
		            						exceptIds:periodIds

		            					};
		            					periodStore.load();

		            				}
		            			}
		            		},{
		            			xtype: 'customcombobox',
		            			name: 'periodTimings',
		            			//fieldLabel: getProgramandcourseTranslation('PERIOD'),
		            			store:periodStore,
		            			displayField:'periodTimings',
		            			valueField:'calendarSlotId',
		            			queryMode:'local',
		            			allowBlank:false,
		            			disabled:true,
		            			typeAhead:true,
		            			forceSelection:true,
		            			listeners:{
		            				select:function(obj,rec,value){/*
		            					var nextSiblingField = obj.nextSibling();
		            					nextSiblingField.setDisabled(false);
		            					var roomStore = obj.nextSibling().getStore();
		            					roomStore.getProxy().extraParams = {
		            						calendarSlotId: rec[0].data.calendarSlotId
		            					};
		            					roomStore.load();
		            				 */
		            					var nxtSib = obj.nextSibling();
		            					nxtSib.setDisabled(false);
		            					var roomStore = obj.nextSibling().getStore();

		            					var form = obj.up('form').getForm();
		            					var homeRoomId = form.findField('homeRoomId').getValue(); 
		            					/*roomStore.getProxy().extraParams = {
		    							 calendarSlotId: rec[0].data.calendarSlotId
		      					   };
		    					   roomStore.load();*/
		            					obj.nextSibling().clearValue();
		            					obj.nextSibling().getStore().extraParams = {
		       							 calendarSlotId: rec[0].data.calendarSlotId
		       	                	   };
		            					obj.nextSibling().getStore().load({
		            						/*params:{
		            							calendarSlotId: rec[0].data.calendarSlotId
		            						},*/
		            						callback: function(records, operation, success) {
		            							if (success) {
		            								if(records.length > 0){
		            									for(var i in records){
		            										if(homeRoomId == records[i].data.id){
		            											obj.nextSibling().setValue(records[i].data.id);	
		            										}
		            									}
		            									var check = $this.getMastertimetableDetailedwindow().getForm().isValid();
		        		            					if(check){
		        		            						$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
		        		            					}
		            								}

		            							}
		            						}

		            					});

		            				}
		            			}
		            		},{
		            			xtype: 'customcombobox',
		            			name: 'room',
		            			width:226,
		            			//fieldLabel: getCourseTxCommonTranslation('CVG_ROOM'),
		            			store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.RoomByCalendar',
		            			displayField:'value',
		            			valueField:'id',
		            			allowBlank:false,
		            			disabled:true,
		            			typeAhead:true,
		            			forceSelection:true
		            		},{
		            			xtype: 'button',
		            			glyph: ICONGLYPH.DELETEGLYPH,
		            			itemId: 'detailedDeleteBtn1',
		            			width: 'auto',
		            			cls: 'CustomBodyBtnReject',
		            			tooltip: getCommonTranslation('DELETETOOLTIP'),
		            			listeners:{
		            				click:function(obj){
		            					var container = obj.up('fieldcontainer');
		            					//panelContiner.remove(container);
		            					var check = $this.getMastertimetableDetailedwindow().getForm().isValid();
		            					if(check){
		            						$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
		            					}
		            				}
		            			}
		            		},{
		   		        		xtype : 'button',
		   		        		itemId: 'detailedBtn1',
		   		        		width: 'auto',
		   		        		cls: 'CustomBodyBtnSettings mtAddRow',
		   						text: getCommonTranslation('ADDBUTTONTEXT'),
		   						tooltip: getCommonTranslation('ADD')
		        		   }]
		            	});
	            		
	            	}

	            	panelContiner.add(panelItem);
	            	this.hideShowDetails(panelContiner);
	            	panelContiner.doLayout();
	            	
	            },
	            /**
	             * save master time table data
	             */
	            saveMasterTimeTable:function(btn){
	            	btn.setDisabled(true);
	            	var $this = this;
	            	var masterDetailedForm = $this.getMastertimetableDetailedwindow();
	            	var form = masterDetailedForm.getForm();
	            	var panel = masterDetailedForm.down('#panelId');
	            	var values = form.getValues();

	            	var variant = values.variant;
	            	var faculty = values.faculty;
	            	var weekDay = values.weekDay;
	            	if(isNullOrEmpty(weekDay)) {
	            		weekDay = values.cycleWeekDay;
	            	}
	            	var periodTimings = values.periodTimings;
	            	var room= values.room;

	            	var masterSearchFilterForm = $this.getMastersearchfilter();
	            	var filterForm = masterSearchFilterForm.getForm();
	            	var values = filterForm.getValues();
	            	var periodId = values.period;
	            	var sectionId = values.section;
	            	var whetherDayWiseSchedule = masterSearchFilterForm.down('#whetherDayWiseScheduleId').getValue();
	            	// For CBS
	            	if(isNullOrEmpty(sectionId)){
	            		sectionId = values.courseSection;
	            		variant = values.courseVariantId;
	            	}

	            	var masterData=[];
	            	if(panel.items.length > 1){

	            		for(var i=0; i < weekDay.length; i++){
	            			masterData.push({
	            				"calendarSlotId": periodTimings[i],
	            				"courseVariantId": variant,
	            				"facultyId": faculty[i],
	            				"classRoomId": room[i],
	            				"periodId": periodId,
	            				"sectionId": sectionId
	            			});
	            		}
	            	}else{
	            		masterData.push({
	            			"calendarSlotId": periodTimings,
	            			"courseVariantId": variant,
	            			"facultyId": faculty,
	            			"classRoomId": room,
	            			"periodId": periodId,
	            			"sectionId": sectionId
	            		});
	            	}
	        
	            	submitUrl = SERVERURL.CREATE_MASTER_TIME_TABLE;
	            	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	            	Ext.Ajax.request({
	            		type : 'rest',
	            		url : submitUrl,
	            		jsonData : masterData,
	            		timeout: 3600000,
	            		method : 'POST',
	            		success : function(form, action) {
	            			Ext.getBody().unmask();
	            			$this.closeMasterWindow();
	            			if(whetherDayWiseSchedule == 'true') {
	            				var gridStore = $this.getCreatemastertimetablegrid().getStore();
	            				gridStore.reload();
	            			} else {
		            			$this.getMastertimetablecalendar().close();
	            			}
	            			//$this.openCalendarWin();
	            			$this.openInSameTab();
	            			showSuccessMessage(getProgramandcourseTranslation('MASTER_TIME_TABLE'),getCommonTranslation('SUCCESS'));
	            		}
	            	});
	            },
	        /**
	         * 
	         * Delete calendar event
	         */
	            deleteMasterTimeTable:function(eventId){
	            	var $this = this;
	            	showConfirmMessage(getProgramandcourseTranslation('MASTER_TIME_TABLE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	            			function(btn, text) {
	            		if (btn == 'yes') {
	            			Ext.Ajax.request({
	            				method : "DELETE",
	            				type : 'rest',
	            				url : SERVERURL.DELETE_MASTER_TIME_TABLE+ '?id='+ eventId,
	            				headers : {
	            					'Content-Type' : 'application/json'
	            				},
	            				success : function(form,action) {
	            					if(form.responseText == 'SUCCESS'){
	            						var masterSearchFilterForm = $this.getMastersearchfilter();
	            		            	var filterForm = masterSearchFilterForm.getForm();
	            		            	var values = filterForm.getValues();
	            		            	if(masterSearchFilterForm.down('#whetherDayWiseScheduleId').getValue() == 'true') {
	            		            		var gridStore = $this.getCreatemastertimetablegrid().getStore();
	        	            				gridStore.reload();
	            		            	} else {
	            		            		$this.getMastertimetablecalendar().close();
	            		            	}
		    	            			//$this.openCalendarWin();	
		    	            			$this.openInSameTab();	
		    	            			showSuccessMessage(getProgramandcourseTranslation('MASTER_TIME_TABLE'),getCommonTranslation('SUCCESS'));
	            					}else if(form.responseText == 'MASTER_TIME_TABLE_CANT_BE_DELETED'){
	            						showWarningMessage(getProgramandcourseTranslation('MASTER_TIME_TABLE'),
	            								getProgramandcourseTranslation('MASTER_TIME_TABLE_CANT_BE_DELETED'));
	            					}
	            				}
	            			});
	            		}
	            	});
	            },
	            
	            closeMasterWindow:function(){
	            	this.getMastertimetabledetailedwindow().close();            	
	            },
	            
	            /**
	             *  Generate Detailed Date of master time table.
	             */
	            generateDetailedDate:function(periodId,form){
	            	
	            	var filterForm = form.getForm();
//	            	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PERIOD_FIND_BY_ID,
        				params : {
        					id : periodId
        				},
        				method : 'GET',
        				success : function(response) {
//        					Ext.getBody().unmask();
        					var data = Ext.decode(response.responseText);
        					
        					filterForm.findField('startDate').setMinValue(dateRender(data.programPeriodStart));
        					filterForm.findField('startDate').setMaxValue(dateRender(data.programPeriodEnd));
        					
        					filterForm.findField('tillDate').setMinValue(dateRender(data.programPeriodStart));
        	            	filterForm.findField('tillDate').setMaxValue(dateRender(data.programPeriodEnd));
        					
	              		 }
	              	 });	
	            	
	            	
	            },
	            
	            /**
	             *  Generate Detailed of master time table.
	             */
	            
	            generateDetailed:function(button){
	            	var $this = this; 
	         	   var masterSearchFilterForm = $this.getExtendmastertimetableform();
				   var filterForm = masterSearchFilterForm.getForm();
				   var values = filterForm.getValues();

				   var url = SERVERURL.GENERATE_DETAILS;
				   if(masterSearchFilterForm.down('#whetherDayWiseScheduleId').getValue() == 'true') {
					   url = SERVERURL.GENERATE_DETAILED_TIME_TABLE;
				   }
				   var sectionId = values.section;
				   // For CBS
				   if(isNullOrEmpty(sectionId)){
					   sectionId = values.courseSection;
				   }
				   var sd = filterForm.findField('startDate').getValue();
				   var td = filterForm.findField('tillDate').getValue();
				   
				   var startDate = values.startDate;
				   var endDate = values.tillDate;
				   
				   var sectionType=values.sectionType;
				   var calendar=values.calendar;
				   var academicTerm=values.ACADEMIC_TERM;
				   
				   var extendmastertimetable = $this.getExtendmastertimetable();
				   var batchIdVals = null;
				   var periodIdVals = null;
				   var courseIdVals = null;
				   var sectionIdVals = null;
				   if(sectionType=="ACADEMIC_TERM"){
					   var batchIds = extendmastertimetable.down('#academicTermWiseProgBatch').getValue();
					   var batchIdArr=[];
					   var batchIdVal = batchIds;
					   if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
						   for (var i in batchIdVal) {
							   if (Ext.isObject(batchIdVal[0])) {
								   batchIdArr.push(batchIdVal[i].get("id"));
							   } else {
								   batchIdArr.push(batchIdVal[i]);
							   }
						   }
						   batchIdVals = batchIdArr.join();
					   }
					   else if(!isNullOrEmpty(batchIdVal)){
						   batchIdVals = batchIdVal;
					   }
					   var periodIds = extendmastertimetable.down('#academicTermWisePeriod').getValue();
					   var periodIdArr=[];
					   var periodIdVal = periodIds;
					   if (!isNullOrEmpty(periodIdVal) && periodIdVal.length > 0 && !isNullOrEmpty(periodIdVal[0])) {
						   for (var i in periodIdVal) {
							   if (Ext.isObject(periodIdVal[0])) {
								   periodIdArr.push(periodIdVal[i].get("id"));
							   } else {
								   periodIdArr.push(periodIdVal[i]);
							   }
						   }
						   periodIdVals = periodIdArr.join();
					   }
					   else if(!isNullOrEmpty(periodIdVal)){
						   periodIdVals = periodIdVal;
					   }
					   var courseIds = extendmastertimetable.down('#academicTermWiseCourse').getValue();
					   var courseIdArr=[];
					   var courseIdVal = courseIds;
					   if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
						   for (var i in courseIdVal) {
							   if (Ext.isObject(courseIdVal[0])) {
								   courseIdArr.push(courseIdVal[i].get("id"));
							   } else {
								   courseIdArr.push(courseIdVal[i]);
							   }
						   }
						   courseIdVals = courseIdArr.join();
					   }
					   else if(!isNullOrEmpty(courseIdVal)){
						   courseIdVals = courseIdVal;
					   }
					   var sectionIds = extendmastertimetable.down('#academicTermWiseSection').getValue();
					   var sectionIdArr=[];
					   var sectionIdVal = sectionIds;
					   if (!isNullOrEmpty(sectionIdVal) && sectionIdVal.length > 0 && !isNullOrEmpty(sectionIdVal[0])) {
						   for (var i in sectionIdVal) {
							   if (Ext.isObject(sectionIdVal[0])) {
								   sectionIdArr.push(sectionIdVal[i].get("sectionId"));
							   } else {
								   sectionIdArr.push(sectionIdVal[i]);
							   }
						   }
						   sectionIdVals = sectionIdArr.join();
					   }
					   else if(!isNullOrEmpty(sectionIdVal)){
						   sectionIdVals = sectionIdVal;
					   }
				   }
				   extendmastertimetable.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   Ext.Ajax.request({
              		 type : 'rest',
              		 url : url,
              		 timeout: 3600000,  // 1 hour   
              		 params : {
              			 sectionId : sectionId,
              			 startDate:startDate,
              			 endDate:endDate,
              			 sectionType:sectionType,
              			 calendarId:calendar,
              			 academicTermId:academicTerm,
              			 batchIds:batchIdVals,
              			 periodIds:periodIdVals,
              			 courseIds:courseIdVals,
              			 sectionIds:sectionIdVals
              		 },
              		 method : 'GET',
              		 success : function(form, action) {
              			extendmastertimetable.body.unmask();
              			 if(sectionType=="ACADEMIC_TERM"){
              				if(form.responseText.trim().length>0){
              				 var csvForm = Ext.create('Ext.form.Panel'); 
              					csvForm.getForm().submit({
      //           					 target: '_blank',
                 					 method:'POST',
                 					 params :{
                 						 access_token : Ext.Ajax.defaultHeaders.access_token,
                 						 logs : form.responseText
                 					 },
                 					 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                 					 url: SERVERURL.DOWNLOAD_MASTER_TIME_TABLE_LOG_FILE,
                 					 standardSubmit :true
                 				 }); 
              				}
              				var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getProgramandcourseTranslation('EXTEND_TIME_TABLE')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation('SUCCESS')+'</span>';
        					var box2 =Ext.Msg.show({
        					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
    						msg	: msg,
    						buttons	: Ext.MessageBox.OK,
    						icon: Ext.Msg.INFO,
    						cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
    						fn	: function(response){
    							if(response=="ok"){
    								$this.onSuccessOkayPress(button);
    							}
    						}
        					});	
        					box2.removeCls('newClsMessageConfirmBox');
        					box2.dockedItems.items[1].layout.pack = "end";
        					box2.doLayout();
        					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');
              			 }else{
              				 if(form.responseText == 'SUCCESS'){
              					var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getProgramandcourseTranslation('EXTEND_TIME_TABLE')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation('SUCCESS')+'</span>';
            					var box2 =Ext.Msg.show({
            					//title: getCommonTranslation('TITLE_QUARTZ_DETAIL'),
        						msg	: msg,
        						buttons	: Ext.MessageBox.OK,
        						icon: Ext.Msg.INFO,
        						cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
        						fn	: function(response){
        							if(response=="ok"){
        								$this.onSuccessOkayPress(button);
        							}
        						}
            					});	
            					box2.removeCls('newClsMessageConfirmBox');
            					box2.dockedItems.items[1].layout.pack = "end";
            					box2.doLayout();
            					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');
              				 }else if(form.responseText=='Not-Autorize'){
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('GOOGLE_CALENDAR_NOT_AUTORIZED'));
							}else if(form.responseText=='Connection_refused'){
												showWarningMessage(
														getCommonTranslation('ALERT'),
														getCommonTranslation('GOOGLE_CALENDAR_SERVICE_DOWN'));
							}else{
              					if(form.responseText == 'DETAILED_TIME_TABLE_EXISTS'){
                      				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
            								getProgramandcourseTranslation('DETAILED_TIME_TABLE_EXISTS'));
                      			 }else if(form.responseText == 'INVALID_SECTION'){
                      				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
            								getProgramandcourseTranslation('INVALID_SECTION'));
                      			 }else if(form.responseText == 'NO_VARIANTS_FOUND_FOR_SECTION'){
                      				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
            								getProgramandcourseTranslation('NO_VARIANTS_FOUND_FOR_SECTION'));
                      			 }else if(form.responseText == 'DEFAULT_TOPIC_NOT_FOUND'){
                      				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
            								getProgramandcourseTranslation('DEFAULT_TOPIC_NOT_FOUND'));
                      			 }else if(form.responseText == 'MASTER_TIME_TABLE_MISSING_FOR_VARIANT'){
                      				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
            								getProgramandcourseTranslation('MASTER_TIME_TABLE_MISSING_FOR_VARIANT'));
                      			 }else if(form.responseText == 'NO_WORKING_DATES_FOUND_BW_PERIOD_START_END'){
                      				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
            								getProgramandcourseTranslation('NO_WORKING_DATES_FOUND_BW_PERIOD_START_END'));
                      			 }else{
                      				 var conflict = form.responseText.replace('</br>','<br>');
                      				 showWarningMessage(getCommonTranslation('ALERT'),conflict);
                      			 }
              				 }
              			 }
              		 },
              		failure: function(form, action) {
              			 var  msgs =Ext.decode(form.responseText);
              			extendmastertimetable.body.unmask();
              			var msg = msgs[0].key;
              			/*if(msg == 'DETAILED_TIME_TABLE_EXISTS'){
              				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
    								getProgramandcourseTranslation('DETAILED_TIME_TABLE_EXISTS'));
              			 }else if(msg == 'INVALID_SECTION'){
              				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
    								getProgramandcourseTranslation('INVALID_SECTION'));
              			 }else if(msg == 'NO_VARIANTS_FOUND_FOR_SECTION'){
              				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
    								getProgramandcourseTranslation('NO_VARIANTS_FOUND_FOR_SECTION'));
              			 }else if(msg == 'DEFAULT_TOPIC_NOT_FOUND'){
              				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
    								getProgramandcourseTranslation('DEFAULT_TOPIC_NOT_FOUND'));
              			 }else if(msg == 'MASTER_TIME_TABLE_MISSING_FOR_VARIANT'){
              				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
    								getProgramandcourseTranslation('MASTER_TIME_TABLE_MISSING_FOR_VARIANT'));
              			 }else if(msg == 'NO_WORKING_DATES_FOUND_BW_PERIOD_START_END'){
              				showWarningMessage(getProgramandcourseTranslation('EXTEND_TIME_TABLE'),
    								getProgramandcourseTranslation('NO_WORKING_DATES_FOUND_BW_PERIOD_START_END'));
              			 }*/
                    }
              	 });
	            },
	            onSuccessOkayPress: function(button){
 				   var me = this;
				   var form = button.up('form');
				   var formValues = form.getValues();
				   var innerTabPanel = button.up('tabpanel');
				   innerTabPanel.setActiveTab(innerTabPanel.activeTab.next().next());

				   var alinfomodel = Academia.model.authentication.ALInfoModel;
				   var wheatherSchool = alinfomodel.get('wheatherSchool');
				   var academyLocationId = this.getCurrentAcademyLocation();

				   var extendedTimeTableFilterForm = innerTabPanel.getActiveTab().down('form');
				   extendedTimeTableFilterForm.getForm().reset();
				   var sectionTypeField = extendedTimeTableFilterForm.down('[name=sectionType]');

				   if(formValues.sectionType=="PROGRAM_BATCH_SECTION"){
					   sectionTypeField.setValue('CBS');
					   setTimeout(function(){
						   sectionTypeField.setValue('PBS');
						   setTimeout(function(){
							   var programBatchStore = form.down('#batchId').getStore();
							   var programBatchRecordCount = programBatchStore.find('id',formValues.batch);
							   if(programBatchRecordCount>=0){
								   var programBatchRecord = programBatchStore.getAt(programBatchRecordCount);
								   var programId = programBatchRecord.get('programId');

								   var programIdField = extendedTimeTableFilterForm.down('#programId');
								   programIdField.getStore().getProxy().extraParams = {
				    					 academyLocationIds:academyLocationId,
				    					 sectionType : 'ProgramBatchSection',
				    					 whetherSchool : false,
				    					 isAllProgram : true
				    				 };
								   programIdField.getStore().load({
									   callback: function(){
        								   programIdField.setValue(programId);
									   }
								   });
								   
								   //--
								   var batchField = extendedTimeTableFilterForm.down('#batchId');
								   batchField.clearValue();
								   batchField.setDisabled(false);
								   var batchStore = batchField.getStore();
								   batchStore.getProxy().extraParams = {
									   programId: programId
								   };
								   batchStore.load({
									   callback: function(records, operation, success) {
										   if (success) {
											   if(records.length){
												   batchField.setValue(formValues.batch);
												   var batch_Id = formValues.batch;

												   var periodField = extendedTimeTableFilterForm.down('#periodId');
												   periodField.clearValue();
												   periodField.setDisabled(false);
												   var periodStore = periodField.getStore();
												   periodStore.getProxy().extraParams = {
													   batchId: batch_Id
												   };
												   periodStore.load({
													   callback: function(records, operation, success) {
														   if (success) {
															   if(records.length){
																   periodField.setValue(formValues.period);
																   if(wheatherSchool) {
																	   periodField.setVisible(false);
																   }
																   else{
																	   periodField.setVisible(true);
																   }

																   var programCourseComboBox = extendedTimeTableFilterForm.down('customcombobox#courseId_1');
																   programCourseComboBox.clearValue();
																   programCourseComboBox.setDisabled(false);
																   var programBatchStore =programCourseComboBox.getStore(); 
																   programBatchStore.getProxy().extraParams = {	
																	   periodId: formValues.period,
																	   sectionType : 'ProgramBatchSection'
																   };
																   programBatchStore.load();
																   
																   var facultyStore = extendedTimeTableFilterForm.down("#facultyId").getStore();
											        				 facultyStore.getProxy().extraParams = {
											        					 academyLocationIds : academyLocationId,
											        					 periodId : formValues.period,
											    						 sectionType : 'ProgramBatchSection'
											        				 };
											        				 facultyStore.load();

																   var courseComponentBox = extendedTimeTableFilterForm.down('customcombobox#componentSectionId_1');
																   var sectionBox = extendedTimeTableFilterForm.down('customcombobox#courseSection_Id_1');
																   courseComponentBox.clearValue();
																   sectionBox.clearValue();
																   courseComponentBox.setDisabled(true);
																   
																   var fromDateField = extendedTimeTableFilterForm.down('#fromDate_Id');
																   var toDateField = extendedTimeTableFilterForm.down('#toDate_Id');
																   
																   fromDateField.setValue(formValues.startDate);
																   toDateField.setValue(formValues.tillDate);

																   var searchBtn = extendedTimeTableFilterForm.down('#quickSearchId');
																   searchBtn.fireEvent('click',searchBtn);
															   }
														   }
													   }
												   });					        			        			 
											   }
										   }
									   }
								   });
							   }
						   },10);
					   },10);
				   }
				   else{
					   sectionTypeField.setValue('PBS');
					   setTimeout(function(){
						   sectionTypeField.setValue('CBS');
						   setTimeout(function(){
							   var academicTermField = extendedTimeTableFilterForm.down('#academicTerm');
							   academicTermField.getStore().load({
								   callback: function(){
									   academicTermField.setValue(formValues.ACADEMIC_TERM);

									   var academyLocationId = me.getCurrentAcademyLocation();
									   var courseIdField = extendedTimeTableFilterForm.down('#courseId');
									   var academicTermId=extendedTimeTableFilterForm.down('#academicTerm').getValue();
									   var courseStore = courseIdField.getStore();

									   courseStore.getProxy().extraParams = {
										   sectionType : 'CourseSection',
										   academyLocationIds : academyLocationId,
										   academicTermId:academicTermId
									   };

									   courseStore.load({
										   callback: function(records, operation, success){
											   try{
												   var fromDateField = extendedTimeTableFilterForm.down('#fromDate_Id');
												   var toDateField = extendedTimeTableFilterForm.down('#toDate_Id');
												   
												   fromDateField.setValue(formValues.startDate);
												   toDateField.setValue(formValues.tillDate);
											   }
											   catch(e){
												   
											   }

											   var courseId;
											   if(formValues.course > 0) {
												   if(!isNullOrEmpty(formValues.component)){
    												   var foundRecInd = courseStore.findBy(function(record) {
    									                   if (record.data.parentCourseId == formValues.course && 
    									                		   record.data.componentId == formValues.component) {
    									                       return true;
    									                   }
    									               });
    									               var foundRec = courseStore.getAt(foundRecInd);
    									               courseIdField.setValue(foundRec.data.id);
    												   courseId = foundRec.data.id;
    											   } else {
    												   courseIdField.setValue(formValues.course);
    												   courseId = formValues.course;
    											   }
												   var topicsIdField = extendedTimeTableFilterForm.down('#topicsId');
												   topicsIdField.clearValue();
												   
												   
    											   var sectionBox = extendedTimeTableFilterForm.down('#courseSection_Id');
    											   sectionBox.clearValue();
    											   try{
    												   sectionBox.setDisabled(false);
    											   }
    											   catch(e){
    											   }
    											   var sectionStore = sectionBox.getStore();
    											   sectionStore.getProxy().extraParams = {
    												   courseId : courseId,
	        										   academicTermId:academicTermId
    											   };
    											   sectionStore.load({
    												   callback: function(records, operation, success){
    													   var section = formValues.courseSection;
    													   sectionBox.setValue(section);
    													   sectionBox.setValue(section);
    													   var facultyByCriteriaStore = extendedTimeTableFilterForm.down('#facultyId').getStore();
    													   facultyByCriteriaStore.getProxy().extraParams = {
    														   academyLocationIds:academyLocationId,
    														   courseId:courseId,
    														   academicTermId:academicTermId,
    														   sectionId:formValues.courseSection
    													   };
    													   facultyByCriteriaStore.load();
    													   var searchBtn = extendedTimeTableFilterForm.down('#quickSearchId');
    													   searchBtn.fireEvent('click',searchBtn);
    												   }
    											   });
											   } else {
												   var searchBtn = extendedTimeTableFilterForm.down('#quickSearchId');
												   searchBtn.fireEvent('click',searchBtn);
											   }
										   
											   
											   
											   
											   
											   
											   
											   
											   
											  /* courseIdField.setValue(formValues.course);

											   var courseId = formValues.course;

											   var courseComponentBox = extendedTimeTableFilterForm.down('customcombobox#componentSectionId');
											   var sectionBox = extendedTimeTableFilterForm.down('customcombobox#courseSection_Id');
											   var topicsIdField = extendedTimeTableFilterForm.down('#topicsId');
											   courseComponentBox.clearValue();
											   sectionBox.clearValue();
											   topicsIdField.clearValue();
											   
											   var fromDateField = extendedTimeTableFilterForm.down('#fromDate_Id');
											   var toDateField = extendedTimeTableFilterForm.down('#toDate_Id');
											   
											   fromDateField.setValue(formValues.startDate);
											   toDateField.setValue(formValues.tillDate);

											   if(!isNullOrEmpty(formValues.component)){
												   courseComponentBox.show();
												   var courseComponentBoxStore = courseComponentBox.getStore();
												   courseComponentBoxStore.getProxy().extraParams = {
													   id: courseId
												   };
												   courseComponentBoxStore.load({
													   callback: function(){
														   courseComponentBox.setValue(formValues.component);
														   var componentId = formValues.component;

														   sectionBox.setDisabled(false);
	    												   topicsIdField.setDisabled(false);
														   sectionBox.clearValue();
														   topicsIdField.clearValue();
														   var courseStore = sectionBox.getStore();
														   courseStore.getProxy().extraParams = {
															   componentId : componentId,
															   parentCourseId : courseId
														   };
														   courseStore.load({
															   callback: function(records, operation, success){
																   sectionBox.setValue(formValues.courseSection);
																   var facultyByCriteriaStore = extendedTimeTableFilterForm.down('#facultyId').getStore();
																   facultyByCriteriaStore.getProxy().extraParams = {
																	   academyLocationIds:academyLocationId,
																	   courseId:courseId,
																	   academicTermId:academicTermId,
																	   sectionId:formValues.courseSection,
																	   componentId : componentId
																   };
																   facultyByCriteriaStore.load();
																   var searchBtn = extendedTimeTableFilterForm.down('#quickSearchId');
																   searchBtn.fireEvent('click',searchBtn);
															   }
														   });
													   }
												   });
											   }
											   else{
												   var courseComboBox = extendedTimeTableFilterForm.down('customcombobox#courseSection_Id');
												   courseComboBox.clearValue();
												   topicsIdField.clearValue();
												   courseComponentBox.hide();
												   try{
    												   sectionBox.setDisabled(false);
    												   courseComboBox.setDisabled(false);
    												   topicsIdField.setDisabled(false);
												   }
												   catch(e){
												   }
												   var courseStore = courseComboBox.getStore();
												   courseStore.getProxy().extraParams = {
													   parentCourseId: courseId
												   };
												   courseStore.load({
													   callback: function(records, operation, success){
														   courseComboBox.setValue(formValues.courseSection);
														   var facultyByCriteriaStore =extendedTimeTableFilterForm.down('#facultyId').getStore();
														   facultyByCriteriaStore.getProxy().extraParams = {
															   academyLocationIds:academyLocationId,
															   courseId:courseId,
															   academicTermId:academicTermId,
															   sectionId:formValues.courseSection
														   };
														   facultyByCriteriaStore.load();
														   var searchBtn = extendedTimeTableFilterForm.down('#quickSearchId');
														   searchBtn.fireEvent('click',searchBtn);
													   }
												   });
											   }*/
										   }
									   });
								   }
							   });
						   },500);
					   },10);
				   }
			   },
	            generateButtonEnable:function(){
	            	var masterSearchFilterForm = this.getMastersearchfilter();
	            	var filterForm = masterSearchFilterForm.getForm();
	            	var values = filterForm.getValues();
	            	
	            	var startDate = values.startDate;
	            	var tillDate = values.tillDate;
	            	if(!isNullOrEmpty(startDate) && !isNullOrEmpty(tillDate)){
	            		masterSearchFilterForm.down('#generateDetailedId').setDisabled(false);
	            	}
	            },
	      //************************************Disable more action****************************************
	            disableMoreActionSequencePivileges: function(from,permissionsMap) {
	            	var me = this;
	             	 var associatedAcadLocationIds = new Array();
	             	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	             	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	            //  var adjustmentform = this.getAdjustmentstructure();	
	             	var createviewButton=from.down('#viewCalanderId'); 
	             	createviewButton.setVisible(false);
	             	
	             /*	var generateButton=from.down('#generateDetailedId'); 
	             	generateButton.setVisible(false);*/
	             	
	             	 Ext.each(permissionList, function(privilege) {
	             		 if (privilege === 'CREATEVIEW') {
	             			 if(!isNullOrEmpty(createviewButton)){
	             				createviewButton.setVisible(true);	
	             			 }
	             		 } 
	             		 
	             		 /*if (privilege === 'GENERATE') {
	             			 if(!isNullOrEmpty(generateButton)){
	             				generateButton.setVisible(true);	
	             			 }
	             		 }*/
	             	 });
	             	setTimeout(function(){
	             		me.setTabPbsCbsPermission("createMasterTimeTable");
	             	},400);
	              },
	              loadSection:function(sectionId){
	            	  var $this = this;
	            	  var masterSearchFilterForm = $this.getMastersearchfilter();
	            	  var filterForm = masterSearchFilterForm.getForm();
	            	  var values = filterForm.getValues();

	            	  var masterDetailedForm = $this.getMastertimetableDetailedwindow();
	            	  var form = masterDetailedForm.getForm();
//	            	  var roomCombo = form.findField('room');
//	            	  var store = roomCombo.getStore();
	            	  
	            	  Ext.Ajax.request({
	                		 method: "GET",
	                		 type: 'rest',
	                		 url: SERVERURL.SECTION_FIND_BY_ID,
	                		 headers: {
	                			 'Content-Type': 'application/json'
	                		 },
	                		 params: {
	                			 id: sectionId
	                		 },
	                		 success: function(f, action) {
	                			 var data = f.responseText;
	                			 var  jData=Ext.JSON.decode(data);
	                			 
	                			 if(!isNullOrEmpty(jData.homeRoom)){
	                				 form.findField('homeRoomId').setValue(jData.homeRoom.id);
	                			}
	                			
	                			// display course Name view only mode
	                			if(!isNullOrEmpty(jData.courseVariant)) {
	                				form.findField('courseName').setValue(jData.courseVariant.code);
	                				var courseNameLabel = masterDetailedForm.down('displayfield#courseName');
	                				courseNameLabel.setVisible(true);
	                			}
	                			 
	                		 }
	            	  });

	              },
	              exportJRXML: function() {
	            	  var $this = this;
	            	  var sectionId=null;
	            	  if($this.getMastersearchfilter() != undefined) {
	            		  var formField = $this.getMastersearchfilter();
	            		  var form = formField.getForm();
	            		  sectionId = $this.getMastersearchfilter().down('#sectionId').getValue();
	            		  // For CBS
	            		  if(isNullOrEmpty(sectionId)){
	            			  sectionId = $this.getMastersearchfilter().down('#courseSection_Id').getValue();
	            		  }

	            		  var values = form.getValues();
	            		  var batchId = values.batch;
	                	   if(batchId == "" || batchId == undefined){
	                		   batchId=null;
	                	   }
	                	   var periodId = values.period;
	                	   if(periodId == "" || periodId == undefined){
	                		   periodId=null;
	                	   }
	                	   var academicTermId = values.ACADEMIC_TERM;
	                	   if(academicTermId == "" || academicTermId == undefined){
	                		   academicTermId=null;
	                	   }
	                	   var courseId = values.course;
	                	   if(courseId == "" || courseId == undefined){
	                		   courseId=[];
	                	   }

	            		  // code to identify jasper
	            		  var code ="MASTER_TIME_TABLE_PDF";
	            		  var reportTitle='Master Timetable Report';

	            		  var reportParams =new Object();
	            		  reportParams.sectionIds=String(sectionId); // convert int into string
	            		  reportParams.code = code;
	            		  reportParams.reportTitle = reportTitle;
	            		  reportParams.batchId = batchId;
	            		  reportParams.periodId = periodId;
	            		  if(values.sectionType== "PROGRAM_BATCH_SECTION"){
	            			  reportParams.sectionType = 'ProgramBatchSection';
	            		  }
	            		  if(values.sectionType =="COURSE_SECTION"){
	            			  reportParams.sectionType = 'CourseSection';
	            		  }
	            		  reportParams.courseIds = String(courseId);
	            		  reportParams.courseVariantId = values.courseVariantId;
	            		  reportParams.calendarId = values.calendar;
	            		  reportParams.academicTermId = academicTermId;
	            		  var exportUrl = SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_PDF_REPORT;//rest/ReportDocumentResource/calenderPdf
	            		  var fileType = 'xls';
	            		  $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel',exportUrl);
	            	  }
	              },
	              /**
	               * Down-load template 
	               * @params calendarId,batchId,periodId,sectionId
	               */
	              getDownloadTemplate:function(form){
		        	  
		        	  var getform = form.getForm();
		        	  var values = getform.getValues();
		        	  
		        	  var calendarId = values.calendar;
		        	  var batchId;
		        	  var periodId = values.period;
		        	  var sectionId = values.section;
		        	  var programId = values.cbsProgram;
		        	  var isAllFaculties=values.allFacultyCheck;
		        	  // For CBS
		        	  /*if(isNullOrEmpty(sectionId)){
		        		  sectionId = values.courseSection;
		        	  }*/
		        	  var assignSectionType = null;
		        	  var downloadType = values.downloadType;
		        	  if(downloadType == "Program Batch Section" || downloadType == "Class Batch Section" || downloadType=="PROGRAM_BATCH_SECTION"){
		        	  var assignSectionType = "ProgramBatchSection";
		        	  batchId = values.batch;
		        	  }else{
		        		  assignSectionType = "CourseSection";
		        		  batchId = values.cbsBatch;
		        	  }
		        	  var csvForm = Ext.create('Ext.form.Panel'); 
		        	  csvForm.getForm().submit({
		        		  target: '_blank',
		        		  method:'POST',
		        		  params :{
		        			  access_token : Ext.Ajax.defaultHeaders.access_token,
		        			  calendarId : calendarId,
		        			  programId : programId,
		        			  batchId : batchId,
		        			  periodId : periodId,
		        			  sectionId : sectionId,
		        			  assignSectionType : assignSectionType,
		        			  isAllFaculties:isAllFaculties,
		        		  },
		        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		        		  url: SERVERURL.MASTER_TIME_TABLE_DOWNLOAD_TEMPLATE,
		        		  standardSubmit :true
		        	  });
		          },
		          getOpenMasterTimeTableImportUtilityWin : function(obj){
		        	  var $this = this;
		        	  var importUtilityController=Academia.app.getController('Academia.controller.importutility.ImportUtilityController');
		        	  importUtilityController.getOpenImportUtilityWin();
		        	  importUtilityController.getImportUtilityWin().setTitle(getProgramandcourseTranslation('MASTER_TIME_TABLE_IMPORT_UTILITY'));
		        	  var form = importUtilityController.getImportUtilityWinForm();
		        	  var moduleName = form.down('#moduleName');
		        	  var store = moduleName.getStore();
		        	  store.load({
		        		  callback: function(records, operation, success) {
		        			  if (success) {
		        				  if(records.length > 0){
		        					  moduleName.setValue(records[5].data.id);
		        					  moduleName.setReadOnly(true);
		        				  }		 
		        			  }
		        		  }	   
		        	  });
		          },
		          
		          getDownloadFile : function(documentId,fileType){

			        	if(!isNullOrEmpty(documentId)){
			        		var csvForm = Ext.create('Ext.form.Panel'); 
			        		csvForm.getForm().submit({
			        			target: '_blank',
			        			method:'POST',
			        			params :{
			        				access_token : Ext.Ajax.defaultHeaders.access_token
			        			},
			        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			        			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
			        			standardSubmit :true
			        		});
			        	}
			        },
	    

			        changeSectionType : function() {
			        	var me=this;
			        	var form = this.getMastersearchfilter();
			        	var calendarComboBox = form.down('customcombobox#calendarId');
			        	var alinfomodel = Academia.model.authentication.ALInfoModel;
     				    var wheatherSchool = alinfomodel.get('wheatherSchool');
			        	var batchComboBox = form.down('customcombobox#batchId');
			        	var periodComboBox = form.down('customcombobox#periodId');
			        	var sectionComboBox = form.down('customcombobox#sectionId');

			        	var courseComboBoxCBS = form.down('customcombobox#courseId');
			        	var componentComboBoxCBS = form.down('customcombobox#componentSectionId');
			        	var sectionComboBoxCBS = form.down('customcombobox#courseSection_Id');
			        	var academicTermComboBoxCBS = form.down('customcombobox#academicTerm');
			        	var mainCalendarPanel = form.up('tabpanel').down('#masterTimeTableMainPanel');
			        	mainCalendarPanel.setVisible(false);
			        	//var startDateBox = form.down('datefield#startDate');
			        	//var tillDateBox = form.down('datefield#tillDate');
			        	//var generateButton = form.down('#generateDetailedId');

			        	//var downloadBtn = form.down('#downoladtemplate');

			        	//startDateBox.reset();
			        	//tillDateBox.reset();
			        	//generateButton.setDisabled(true);

			        	calendarComboBox.clearValue();
			        	me.setAllowBlank(componentComboBoxCBS,true);
			        	var sectionType = form.getForm().findField('sectionType').getValue();
			        	if(!sectionType){ // CBS
			        		batchComboBox.clearValue();
			        		periodComboBox.clearValue();
			        		sectionComboBox.clearValue();
			        		componentComboBoxCBS.clearValue();

			        		batchComboBox.allowBlank=true;
			        		periodComboBox.allowBlank=true;
			        		sectionComboBox.allowBlank=true;

			        		courseComboBoxCBS.allowBlank=false;
			        		sectionComboBoxCBS.allowBlank=false;

			        		batchComboBox.setVisible(false);
			        		batchComboBox.clearValue();
			        		periodComboBox.setVisible(false);
			        		periodComboBox.clearValue();
			        		sectionComboBox.setVisible(false);
			        		sectionComboBox.clearValue();
			        		courseComboBoxCBS.setVisible(true);
			        		academicTermComboBoxCBS.setVisible(true);
			        		academicTermComboBoxCBS.clearValue();
			        		sectionComboBoxCBS.setVisible(true);

			        		courseComboBoxCBS.setDisabled(true);
			        		sectionComboBoxCBS.setDisabled(true);

			        		//downloadBtn.hide();
			        	}
			        	else{ // PBS
			        		var alinfomodel = Academia.model.authentication.ALInfoModel;
			        		var wheatherSchool = alinfomodel.get('wheatherSchool');
			        		
			        		courseComboBoxCBS.clearValue();
			        		sectionComboBoxCBS.clearValue();
			        		academicTermComboBoxCBS.clearValue();

			        		courseComboBoxCBS.allowBlank=true;
			        		sectionComboBoxCBS.allowBlank=true;

			        		courseComboBoxCBS.setVisible(false);
			        		sectionComboBoxCBS.setVisible(false);
			        		academicTermComboBoxCBS.setVisible(true);

			        		batchComboBox.setVisible(true);
			        		batchComboBox.clearValue();
			        		periodComboBox.setVisible(true);
			        		periodComboBox.clearValue();
			        		if(wheatherSchool) {
			        			periodComboBox.setVisible(false); 
			        		}
			        		sectionComboBox.setVisible(true);
			        		sectionComboBox.clearValue();
			        		batchComboBox.allowBlank=false;
			        		periodComboBox.allowBlank=false;
			        		sectionComboBox.allowBlank=false;

			        		batchComboBox.setDisabled(true);
			        		periodComboBox.setDisabled(true);
			        		sectionComboBox.setDisabled(true);

			        		componentComboBoxCBS.clearValue();
			        		componentComboBoxCBS.setVisible(false);

			        		//downloadBtn.setVisible(true);
			        	}
			        	var academyLocationId = this.getCurrentAcademyLocation();
			        	var academicTermComboStore = academicTermComboBoxCBS.getStore();
			        	academicTermComboStore.getProxy().extraParams = {
			        		academyLocationIds : academyLocationId
			        	};
			        	academicTermComboStore.load({

			        		callback: function(rec, success) {
			        			if (success) {
			        				for(var i in rec){
			        					if(rec[i].get('sequence')==1){
			        						me.getProgramcoursefilters().down("#cbsProgramId").setDisabled(true);
			        						me.getMastersearchfilter().down('#academicTerm').setValue(rec[i].get('id'));
			        					}
			        				}

			        			}
			        		}
			        	});
			        },
	        
	        changePBSSectionType : function(){
	        	 var me = this;
	        	 var programBatchPeriodContainer = Ext.ComponentQuery.query('fieldcontainer#programBatchCoursePeriodContainerA')[0];
	        	 var courseComponentSectionContainerCBS = Ext.ComponentQuery.query('fieldcontainer#courseComponentSectionContainer_1A')[0];
	        	 var form = this.getProgramcoursefilters();
	        	 var programComboBox = form.down('customcombobox#programId');
	        	 var programComboBoxCBS = form.down('customcombobox#cbsProgramId');
	        	 var batchComboBox = form.down('customcombobox#batchId');
	        	 var batchComboBoxCBS = form.down('customcombobox#cbsBatchId');
	        	 var periodComboBox = form.down('customcombobox#periodId');
	        	 var periodComboBoxCBS = form.down('customcombobox#cbsPeriodId');
	        	 var sectionGroupComboBoxCBS = form.down('customcombobox#cbsSectionGroupId');
	        	 
	        	 var courseComboBoxCBS = form.down('#courseId');
	        	 var sectionComboBoxCBS = form.down('#courseSection_Id');
	        	 var weekdayComboBoxCBS = form.down('#weekday');
	        	 weekdayComboBoxCBS.clearValue();
	        	 var courseCombo = form.down('#courseId_1');
	        	 var academicTermComboBoxCBS = form.down('#academicTerm');
	        	 var academyLocationId = this.getCurrentAcademyLocation();
	        	 var courseComboBoxPBS = form.down('#courseId_1');
	        	 var sectionComboBoxPBS = form.down('#courseSection_Id_1');
	        	 form.down('#withoutMasterTimetableId').setValue(false);
	        	 sectionComboBoxPBS.disable();
	        	 sectionComboBoxCBS.disable();
	        	 var facultyComboBox = form.down('#facultyId');
	        	 var facultyStore = facultyComboBox.getStore();
	        	 var departmentComboBox = form.down('#facultyDepartmentId');
	        	 var departmentStore = departmentComboBox.getStore();
	        	 // reset grid values
	        	 var resultGrid = this.getTimetableprogambatchgrid();
	        	 var resultGridStore = resultGrid.getStore();
	        	 this.resetPageSetting(resultGridStore);
	        	 resultGridStore.loadData([]);
				 var sectionType = form.getForm().findField('sectionType').getValue();				 
				 if(!sectionType){
					 
					 programBatchPeriodContainer.hide();
					 courseComponentSectionContainerCBS.show();
					 courseCombo.setVisible(false);
					 sectionComboBoxPBS.setVisible(false);
					 sectionComboBoxCBS.setVisible(true);
					 batchComboBoxCBS.setVisible(true);
					 periodComboBoxCBS.setVisible(true);
					 sectionGroupComboBoxCBS.setVisible(true);
					 courseComboBoxCBS.setVisible(true);
					 academicTermComboBoxCBS.setVisible(true);
					 programComboBoxCBS.setVisible(true);
					 programComboBox.clearValue();
					 batchComboBox.clearValue();
					 periodComboBox.clearValue();
					 courseComboBoxPBS.clearValue();
					 sectionComboBoxPBS.clearValue();
					 sectionComboBoxPBS.setValue(null);
					 sectionComboBoxCBS.setValue(null);
					 sectionGroupComboBoxCBS.setValue(null);
					 programComboBoxCBS.setValue(null);
					 batchComboBoxCBS.setValue(null);
					 periodComboBoxCBS.setValue(null);
					 academicTermComboBoxCBS.setValue(null);

					 facultyComboBox.clearValue();
					 departmentComboBox.clearValue();
					 programComboBoxCBS.setDisabled(false);
					 sectionComboBoxCBS.setDisabled(true);

					 var gridColumns = resultGrid.columns;
					 var len = gridColumns.length;
					 for (var j = 0; j < len; j++) {
						 var gridColumn = gridColumns[j];
						 if(gridColumn.dataIndex=='pbsSectionName' || gridColumn.dataIndex=='facultyName') { //Managing through dataIndex instead of column index
							 gridColumn.hide();
						 }/* else {
							 gridColumn.show();
						 }*/
					 }
					 var courseCombo = this.getProgramcoursefilters().down('#courseId');		        				 
					 var courseStore = courseCombo.getStore();
					 var academicTermComboStore = academicTermComboBoxCBS.getStore();
					 academicTermComboStore.getProxy().extraParams = {
						 academyLocationIds : academyLocationId
					 };
					 var academicTermId = 0;
					 academicTermComboStore.load({
						 callback: function(rec, success) {
							 if (success) {
								 for(var i in rec){
									 if(rec[i].get('sequence')==1){
										 academicTermId =rec[i].get('id');
										 form.down('#academicTerm').setValue(rec[i].get('id'));
									 }
								 }
								 if(academicTermId == 0) {
									 facultyStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId,
										 sectionType : 'CourseSection'
									 };
									 facultyStore.load();
									 
									 departmentStore.getProxy().extraParams = {
										 academyLocationIds:academyLocationId,
										 sectionType : 'CourseSection'
									 };
									 departmentStore.load();
									 courseStore.getProxy().extraParams = {
										 sectionType : 'CourseSection',
										 academyLocationIds : academyLocationId,
									 };
									 courseStore.load();
									 var programStore = programComboBoxCBS.getStore();
									 programStore.getProxy().extraParams = {
										 sectionType : 'CourseSection',
										 academyLocationIds : academyLocationId,
									 };
									 programStore.load();

									 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
									 sectionGroupStore.getProxy().extraParams = {
										 sectionType : 'CourseSection',
										 academyLocationIds : academyLocationId,
									 };
									 sectionGroupStore.load();
								 }

							 }
						 }
					 });
					 setTimeout(function(){
						 me.showHidePBSColumns(resultGrid, 'CS');
					 },300);
				 }
	        	 else{
	        		 var alinfomodel = Academia.model.authentication.ALInfoModel;
	        		 var wheatherSchool = alinfomodel.get('wheatherSchool');
	        		 if(wheatherSchool){
	        			 periodComboBox.setVisible(false);
	        		 }
	        		 else{
	        			 periodComboBox.setVisible(true);
	        		 }
	        		 programBatchPeriodContainer.show();
	        		 sectionComboBoxPBS.setVisible(true);
	        		 sectionComboBoxCBS.setVisible(false);
	        		 batchComboBoxCBS.setVisible(false);
	        		 batchComboBoxCBS.setVisible(false);
	        		 academicTermComboBoxCBS.setVisible(false);
	        		 periodComboBoxCBS.setVisible(false);
	        		 sectionGroupComboBoxCBS.setVisible(false);
	        		 programComboBoxCBS.setVisible(false);
	        		 courseComponentSectionContainerCBS.show();
	        		 courseComboBoxPBS.setVisible(true);
	        		 courseComboBoxCBS.setVisible(false);
	        		 courseComboBoxCBS.clearValue();
	        		 sectionComboBoxCBS.clearValue();
	        		 sectionComboBoxPBS.setValue(null);
	        		 sectionComboBoxCBS.setValue(null);
	        		 academicTermComboBoxCBS.setValue(null);
	        		 programComboBoxCBS.setValue(null);

	        		 facultyComboBox.clearValue();
	        		 departmentComboBox.clearValue();
	        		 batchComboBox.setDisabled(true);
	        		 periodComboBox.setDisabled(true);
	        		 courseComboBoxPBS.setDisabled(true);
	        		 

	        		 var academyLocationId = this.getCurrentAcademyLocation();
	        		 var programStore = programComboBox.getStore();
	        		 programStore.getProxy().extraParams = {
	        			 academyLocationIds:academyLocationId,
    					 sectionType : 'ProgramBatchSection',
    					 whetherSchool : false,
    					 isAllProgram : true
	        		 };
	        		 programStore.load();
	        		 
	        		 facultyStore.getProxy().extraParams = {
	        			 academyLocationIds : academyLocationId,
						 sectionType : 'ProgramBatchSection'
	        		 };
	        		 facultyStore.load();
	        		 
	        		 departmentStore.getProxy().extraParams = {
	        			 academyLocationIds : academyLocationId,
						 sectionType : 'ProgramBatchSection'
	        		 };
	        		 departmentStore.load();
	        		 
	        		 var gridColumns = resultGrid.columns;
	        		 var len = gridColumns.length;
	        		 for (var j = 0; j < len; j++) {
	        			 var gridColumn = gridColumns[j];
	        			 if(gridColumn.dataIndex=='pbsSectionName' || gridColumn.dataIndex=='facultyName') { //Managing through dataIndex instead of column index
	        				 gridColumn.hide();
	        			 } /*else {
	        				 gridColumn.show();
	        			 }*/
	        		 }
	        		 setTimeout(function(){
						 me.showHidePBSColumns(resultGrid, 'PBS');
					 },300);
	        	 }
	         },
	         loadGridDataForSession:function() {
	        	 var $this = this;
	        	 var grid = $this.getTimetableprogambatchgrid();
	        	 var formValues = $this.getProgramcoursefilters().getForm().getValues();
	        	 var form = $this.getExtendmastertimetableform();
		   		 var batchIds = form.down('#academicTermWiseProgBatch').getValue();
		   		 var facDeptIds=$this.getProgramcoursefilters().down('#facultyDepartmentId').getValue();
		   		 var batchIdArr=[];
	 			 var batchIdVal = batchIds;
	 			 var batchIdVals = null;
	 				if (!isNullOrEmpty(batchIdVal) && batchIdVal.length > 0 && !isNullOrEmpty(batchIdVal[0])) {
						for (var i in batchIdVal) {
							if (Ext.isObject(batchIdVal[0])) {
								batchIdArr.push(batchIdVal[i].get("id"));
							} else {
								batchIdArr.push(batchIdVal[i]);
							}
						}
						batchIdVals = batchIdArr.join();
					}
					else if(!isNullOrEmpty(batchIdVal)){
						batchIdVals = batchIdVal;
					}
	 				var periodIds = form.down('#academicTermWisePeriod').getValue();
		   			var periodIdArr=[];
	 				var periodIdVal = periodIds;
	 				var periodIdVals = null;
	 				if (!isNullOrEmpty(periodIdVal) && periodIdVal.length > 0 && !isNullOrEmpty(periodIdVal[0])) {
						for (var i in periodIdVal) {
							if (Ext.isObject(periodIdVal[0])) {
								periodIdArr.push(periodIdVal[i].get("id"));
							} else {
								periodIdArr.push(periodIdVal[i]);
							}
						}
						periodIdVals = periodIdArr.join();
					}
					else if(!isNullOrEmpty(periodIdVal)){
						periodIdVals = periodIdVal;
					}
		   			var courseIds = form.down('#academicTermWiseCourse').getValue();
		   			var courseIdArr=[];
	 				var courseIdVal = courseIds;
	 				var courseIdVals = null;
	 				if (!isNullOrEmpty(courseIdVal) && courseIdVal.length > 0 && !isNullOrEmpty(courseIdVal[0])) {
						for (var i in courseIdVal) {
							if (Ext.isObject(courseIdVal[0])) {
								courseIdArr.push(courseIdVal[i].get("id"));
							} else {
								courseIdArr.push(courseIdVal[i]);
							}
						}
						courseIdVals = courseIdArr.join();
					}
					else if(!isNullOrEmpty(courseIdVal)){
						courseIdVals = courseIdVal;
					}
		   			var sectionIds = form.down('#academicTermWiseSection').getValue();
		   			var sectionIdArr=[];
	 				var sectionIdVal = sectionIds;
	 				var sectionIdVals = null;
	 				if (!isNullOrEmpty(sectionIdVal) && sectionIdVal.length > 0 && !isNullOrEmpty(sectionIdVal[0])) {
						for (var i in sectionIdVal) {
							if (Ext.isObject(sectionIdVal[0])) {
								sectionIdArr.push(sectionIdVal[i].get("sectionId"));
							} else {
								sectionIdArr.push(sectionIdVal[i]);
							}
						}
						sectionIdVals = sectionIdArr.join();
					}
					else if(!isNullOrEmpty(sectionIdVal)){
						sectionIdVals = sectionIdVal;
					}
	        	 var gStore = grid.getStore();
	        	 /*Ext.Array.each(grid.columns, function(record) {
	        		 if(record.dataIndex==="facultyCode"){
	        			 record.hide();
	        		 }
	        	 });*/
	        	 if(formValues.withoutMasterTimetable){
	        		 grid.down('#btnDelete').hide();
	        		 Ext.Array.each(grid.columns, function(record) {
        				 if(record.dataIndex==="facultyName" || record.dataIndex==="day" || record.dataIndex==="timeslot" || record.dataIndex==="roomName"){
        					 record.hide();
        				 }
        			 });
	        	 }else{
	        		 if(grid.down('#btnDelete').permission){
		        		 grid.down('#btnDelete').show();
	        		 } 
	        		 Ext.Array.each(grid.columns, function(record) {
        				 if(record.dataIndex==="facultyName" || record.dataIndex==="day" || record.dataIndex==="timeslot" || record.dataIndex==="roomName"){
        					 record.show();
        				 }
        			 });
	        	 }
	        	 var allFacultyIds = [];
	        	 if(!isNullOrEmpty(formValues.faculty)) {
	        		 Ext.each(formValues.faculty,function(faculty){
	        			 if(typeof faculty=="number"){
	        				 allFacultyIds.push(faculty);
	        			 }else if(!isNullOrEmpty(faculty.data)){
	        				 allFacultyIds.push(faculty.data.id);
	        			 }
	        		 });
	        	 }
	        	 
	        	 var allFacultyDepartment = [];
	        	 if(!isNullOrEmpty(facDeptIds)) {
	        		 Ext.each(facDeptIds,function(department){
	        			 if(typeof department=="number"){
	        				 allFacultyDepartment.push(department);
	        			 }
	        			 else if(!isNullOrEmpty(department.data)){
	        				 allFacultyDepartment.push(department.data.id);
	        			 }
	        		 });
	        	 }
	        	 
	        	 var allRoomIds = [];
	        	 if(!isNullOrEmpty(formValues.homeRoom)) {
	        		 Ext.each(formValues.homeRoom,function(room){
	        			 if(typeof room=="number"){
	        				 allRoomIds.push(room);
	        			 }else if(!isNullOrEmpty(room.data)){
	        				 allRoomIds.push(room.data.id);
	        			 }
	        		 });
	        	 }
	        	 
	        	 if(formValues.sectionType=="PBS"){
	        		 if(formValues.withoutMasterTimetable){
	        			 Ext.Array.each(grid.columns, function(record) {
	        				 if(record.dataIndex==="courseVariantName" || record.name==="cbsSectionName"){
	        					 record.hide();
	        				 }else if(record.name==="pbsSectionName" || record.dataIndex==="courseName"){
	        					 record.show();
	        				 }
	        			 });
	        		 }else{
	        			 Ext.Array.each(grid.columns, function(record) {
	        				 if(record.dataIndex==="courseVariantName" || record.name==="cbsSectionName" ){
	        					 record.show();
	        				 }else if(record.name==="pbsSectionName"){
	        					 record.hide();
	        				 }

	        			 });
	        		 }
	        		 gStore.getProxy().extraParams= {
	        			 pbs:1,
	        			 programId:formValues.program,
	        			 batchId:formValues.batch,
	        			 periodId:formValues.period,
	        			 sectionId:formValues.section_1,
	        			 courseId:formValues.course_1,
	        			 facultyId:allFacultyIds.join(),
	        			 facultyDepartmentId:allFacultyDepartment.join(),
	        			 roomId:allRoomIds.join(),
	        			 withoutMasterTimetable:formValues.withoutMasterTimetable,
	        			 day:formValues.weekday
	        		 };
	        		 
		        	 $this.showHidePBSColumns(grid, 'PBS');
	        	 } else {
	        		 if(formValues.withoutMasterTimetable){
	        			 Ext.Array.each(grid.columns, function(record) {
	        				 if(record.dataIndex==="programName" || record.dataIndex==="batchName" ||
	        						 record.dataIndex==="periodName" || record.name==="pbsSectionName" || record.name==="cbsSectionName"){
	        					 record.hide();
	        				 }
	        				 else if(record.dataIndex==="courseName"){
	        					 record.show();
	        				 }
	        			 });
	        		 }
	        		 var allCourseIds = [];
	        		 if(!isNullOrEmpty(formValues.course)) {
	        			 Ext.each(formValues.course,function(course){
		        			 if(typeof course=="number"){
		        				 allCourseIds.push(course);
		        			 }else if(!isNullOrEmpty(course.data)){
		        				 allCourseIds.push(course.data.id);
		        			 }
		        		 });
	        		 }
	        		 var allSectionIds = [];
	        		 if(!isNullOrEmpty(formValues.section)) {
	        			 Ext.each(formValues.section,function(section){
		        			 if(typeof section=="number"){
		        				 allSectionIds.push(section);
		        			 }else if(!isNullOrEmpty(section.data)){
		        				 allSectionIds.push(section.data.id);
		        			 }
		        		 });
	        		 }

	        		 gStore.getProxy().extraParams= {
	        			 pbs:0,
	        			 sectionId:allSectionIds.join(),
	        			 academicTermId:formValues.ACADEMIC_TERM,
	        			 programId:formValues.cbsProgram,
	        			 batchId:formValues.cbsBatch,
	        			 periodId:formValues.cbsPeriod,
	        			 sectionGroupId:formValues.cbsSectionGroupId,
	        			 courseId:allCourseIds.join(),
	        			 facultyId:allFacultyIds.join(),
	        			 facultyDepartmentId:allFacultyDepartment.join(),
	        			 roomId:allRoomIds.join(),
	        			 withoutMasterTimetable:formValues.withoutMasterTimetable,
	        			 day:formValues.weekday,
	        			 batchIds:batchIdVals,
	        			 periodIds:periodIdVals,
	        			 courseIds:courseIdVals,
	        			 sectionIds:sectionIdVals
	        		 };
		        	 $this.showHidePBSColumns(grid, 'CS')
	        	 }
	        	 grid.config.searchFilterForm = $this.getProgramcoursefilters();
	        	 
	        	 $this.resetPageSetting(gStore);
	        	 gStore.load();
	        	 
	         },
	         resetForSessionPBSC:function() {
	         /*
				Code Merge fromm 
				var structure = this.getProgrambatchtimetable();
	        	 var form = structure.down('programcoursefilters');
	        	 form.destroy();
	        	 structure.insert(0,{
	        		 xtype : 'programcoursefilters',
	        		 cls:'horizontal-scrolling-fix'
	        	 });
			*/
	        	 var $this = this;
	        	 var form = this.getProgramcoursefilters();
	        	 form.down('#withoutMasterTimetableId').setValue(false);
	        	 var grid = this.getTimetableprogambatchgrid();
	        	 grid.down('#exportReport').setDisabled(true);
	        	 var programComboBox = form.down('#programId');
	        	 var batchComboBox = form.down('#batchId');
	        	 var periodComboBox = form.down('#periodId');
	        	 var sectionComboBoxPBS = form.down('#courseSection_Id_1');
	        	 var courseComboBoxPBS = form.down('#courseId_1');

	        	 var academicTermComboBoxCBS = form.down('#academicTerm');
	        	 var batchComboBoxCBS = form.down('#cbsBatchId');
	        	 var programComboBoxCBS = form.down('#cbsProgramId');
	        	 var periodComboBoxCBS = form.down('#cbsPeriodId');
	        	 var courseComboBoxCBS = form.down('#courseId');
	        	 var sectionGroupComboBoxCBS = form.down('#cbsSectionGroupId');
	        	 var weekdayComboBoxCBS = form.down('#weekday');
	        	 
	        	 var sectionComboBoxCBS = form.down('#courseSection_Id');
	        	 
	        	 var facultyCombo = form.down('#facultyId');
	        	 var departmentCombo = form.down('#facultyDepartmentId');
	        	 var roomCombo = form.down('#homeRoom')
	        	 var sectionType = form.getForm().findField('sectionType').getValue();
	        	 var academyLocationId = this.getCurrentAcademyLocation();
	        	 //PBS
	        	 programComboBox.clearValue();
	        	 batchComboBox.clearValue();
	        	 periodComboBox.clearValue();
	        	 sectionComboBoxPBS.clearValue();
	        	 courseComboBoxPBS.clearValue();
	        	 sectionGroupComboBoxCBS.clearValue();
	        	 weekdayComboBoxCBS.clearValue();
	        	 
	        	 batchComboBox.setDisabled(true);
	        	 periodComboBox.setDisabled(true);
	        	 sectionComboBoxPBS.setDisabled(true);
	        	 courseComboBoxPBS.setDisabled(true);
	        	 
	        	 //CBS
	        	 courseComboBoxCBS.clearValue();
	        	 sectionComboBoxCBS.clearValue();
	        	 batchComboBoxCBS.clearValue();
	        	 programComboBoxCBS.clearValue();
	        	 periodComboBoxCBS.clearValue();
	        	 
	        	 sectionComboBoxCBS.setDisabled(true);
	        	 batchComboBoxCBS.setDisabled(true);
	        	 periodComboBoxCBS.setDisabled(true);
	        	 courseComboBoxPBS.setDisabled(true);
	        	 
	        	 facultyCombo.clearValue();
	        	 departmentCombo.clearValue();
	        	 roomCombo.clearValue();
	        	 
	        	 if(sectionType) {
	        		 var programStore = programComboBox.getStore();
	        		 programStore.getProxy().extraParams = {
	        			 academyLocationIds:academyLocationId,
    					 sectionType : 'ProgramBatchSection',
    					 whetherSchool : false,
    					 isAllProgram : true
	        		 };
	        		 programStore.load();
	        		 
	        		 var facultyStore = facultyCombo.getStore();
	        		 facultyStore.getProxy().extraParams = {
	        			 academyLocationIds : academyLocationId,
	        			 sectionType : 'ProgramBatchSection'
	        		 };
	        		 facultyStore.load();
	        		 
	        		 var departmentStore = departmentCombo.getStore();
	        		 departmentStore.getProxy().extraParams = {
	        			 academyLocationIds : academyLocationId,
	        			 sectionType : 'ProgramBatchSection'
	        		 };
	        		 departmentStore.load();
	        		 
	        		 
	        		 var sectionGroupStore = sectionGroupComboBoxCBS.getStore();
					 sectionGroupStore.getProxy().extraParams = {
						 sectionType : 'CourseSection',
						 academyLocationIds : academyLocationId,
					 };
					 sectionGroupStore.load();
	        		 
	        	 } else {
	        		 var  academicTermComboStore = academicTermComboBoxCBS.getStore();
	        		 var academicTermId = 0;
	        		 academicTermComboBoxCBS.reset();
	        		 academicTermComboBoxCBS.clearValue();
	        		 academicTermComboStore.getProxy().extraParams = {
	        			 academyLocationIds : academyLocationId
	        		 };
	        		 academicTermComboStore.load({
	        			 callback: function(rec, success) {
	        				 if (success) {
	        					 for(var i in rec){
	        						 if(rec[i].get('sequence')==1){
	        							 academicTermComboBoxCBS.setValue(rec[i].get('id'));
	        							 academicTermId = rec[i].get('id');
	        						 }
	        					 }
	        				 }
	        			 }
	        		 });
	        	 }
	        	 
	        	 
	         },
	         templateTypeDropdown:function(){
	        	 var $this=this;
	        	 var form =$this.getUploadtemplate();
	        	 var grid = $this.getImportlisttimetable();
	        	 grid.setVisible(false);
	        	 var templateType = form.getForm().findField('templateType').getValue();
	        	 
	        	 //-------
	        	 
	        	 var associatedAcadLocationIds = new Array();
             	 var permissionMap = $this.getIMPORT_MASTER_TIME_TABLE_PERMISSION();
             	 associatedAcadLocationIds.push($this.getCurrentAcademyLocation()); 
             	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
             	 var permissionListArray = [];
             	 //All Faculty checkBox Permission
             	 this.disableAllFacultyCheckBoxPivileges(form,this.getMASTER_TIME_TABLE_PRIVILEGES());
             	 
             	 Ext.each(permissionList, function(privilege) {
             		 if (privilege === 'PROGRAM_BATCH_SECTION') {
             			 permissionListArray.push('PROGRAM_BATCH_SECTION');
             		 }
             		 if (privilege === 'COURSE_SECTION') {
             			permissionListArray.push('COURSE_SECTION');
            		 }
             	 });
             	 
             	 if(permissionListArray.length == 0){
             		permissionListArray.push('PROGRAM_BATCH_SECTION'); // default permission
             	 }
             	 
             	 form.permissionListArray = permissionListArray;
	        	 
	        	 //-------
	        	 
	        	 if(templateType){
	        		 var alinfomodel = Academia.model.authentication.ALInfoModel;
					 var wheatherSchool = alinfomodel.get('wheatherSchool');
					  if(wheatherSchool){
						  form.down('#periodId').setVisible(false);
								  }
					  else{
			        		 form.down('#periodId').setVisible(true);

					  }
	        		 form.down('#downloadType').setVisible(true);
	        		 form.down('#uploadType').setVisible(false);
	        		 form.down('#calendarId').setVisible(true);
	        		 form.down('#calendarId').allowBlank = false;
	        		 form.down('#calendarId').reset();
	        		 form.down('#batchId').setVisible(true);
	        		 form.down('#batchId').allowBlank = false;
	        		 form.down('#batchId').reset();
	        		 form.down('#periodId').allowBlank = false;
	        		 form.down('#periodId').reset();
	        		 form.down('#sectionId').setVisible(true);
	        		 form.down('#sectionId').allowBlank = false;
	        		 form.down('#sectionId').reset();
	        		 form.down('#downoladtemplate').setVisible(true);
	        		 form.down('#downoladtemplate').setDisabled(true);
	        		 form.down('#programBatchUpload').setVisible(false);
	        		 form.down('#uploadFileField').setVisible(false);
	        		 form.down('#resetBtn').setVisible(true);
	        		 form.down('#resetBtn').setDisabled(true);
	        		 var calendarCombo = form.down('#calendarId');
	        		 var calendarComboStore = calendarCombo.getStore();
	        		 calendarComboStore.getProxy().extraParams = {
	        			 academyLocationId : $this.getCurrentAcademyLocation()
	        		 };
	        		 calendarComboStore.load();
	        	 }else{
	        		 form.down('#downloadType').setVisible(false);
	        		 form.down('#uploadType').setVisible(true);
	        		 form.down('#calendarId').reset();
	        		 form.down('#moduleName').setVisible(true);
	        		 form.down('#uploadFileField').setVisible(true);
	        		 form.down('#programBatchUpload').setVisible(true);
	        		 form.down('#programBatchUpload').hidden = false;
	        		 form.down('#resetBtn').setVisible(true);
	        		 form.down('#resetBtn').hidden = false;
	        	 }
	        	 $this.setTabPbsCbsPermission("importMasterTimeTable");
	         },
	         changeTemplateType : function(obj,record){
	        	 var $this = this;
	        	 var form = $this.getUploadtemplate();
	        	 var grid = $this.getImportlisttimetable();
	        	 grid.setVisible(false);
	        	 //form.getForm().reset();
	        	 var templateType = form.getForm().findField('templateType').getValue();
	        	 var importList =  this.getImportlisttimetable();
	        	 importList.setVisible(false);
	        	 if(templateType){
	        		 form.down('#downloadType').setVisible(true);
	        		 form.down('#downloadType').reset();
	        		 var downloadTypeCombo = form.down('#downloadType');
	        		 downloadTypeCombo.getStore().load({
	        			 callback:function(records){
	        				 downloadTypeCombo.setValue(downloadTypeCombo.getStore().data.items[0].data.id);
	        			 }
	        		 });
	        		 var alinfomodel = Academia.model.authentication.ALInfoModel;
					 var wheatherSchool = alinfomodel.get('wheatherSchool');
					  if(wheatherSchool){
						  form.down('#periodId').setVisible(false);
								  }
					  else{
						  form.down('#periodId').setVisible(true);

					  }
					 form.down('#importTimeTableUploadOptionRadioGroupItemId').setVisible(false);
	        		 form.down('#uploadType').setVisible(false);
	        		 form.down('#uploadType').reset();
	        		 form.down('#moduleName').setVisible(false);
	        		 form.down('#uploadFileField').setVisible(false);
	        		 form.down('#uploadType').setVisible(false);
	        		 form.down('#calendarId').setVisible(true);
	        		 form.down('#calendarId').allowBlank = true;
	        		 form.down('#calendarId').reset();
	        		 form.down('#batchId').setVisible(true);
	        		 form.down('#batchId').allowBlank = true;
	        		 form.down('#batchId').setDisabled(true);
	        		 form.down('#batchId').reset();
	        		 form.down('#periodId').allowBlank = true;
	        		 form.down('#periodId').reset();
	        		 form.down('#periodId').setDisabled(true);
	        		 form.down('#sectionId').setVisible(true);
	        		 form.down('#sectionId').allowBlank = true;
	        		 form.down('#sectionId').reset();
	        		 form.down('#sectionId').setDisabled(true);
	        		 form.down('#downoladtemplate').setVisible(true);
	        		 form.down('#downoladtemplate').setDisabled(true);
	        		 form.down('#programBatchUpload').setVisible(false);
	        		 form.down('#resetBtn').setVisible(true);
	        		 form.down('#resetBtn').setDisabled(true);
	        		 var calendarCombo = form.down('#calendarId');
	        		 var calendarComboStore = calendarCombo.getStore();
	        		 calendarComboStore.getProxy().extraParams = {
	        			 academyLocationId : $this.getCurrentAcademyLocation()
	        		 };
	        		 calendarComboStore.load();
	        	 }else{
	        		 var moduleName = null;
	        		 form.down('#downloadType').setVisible(false);
	        		 form.down('#downloadType').reset();
	        		 form.down('#uploadType').setVisible(true);
	        		 form.down('#uploadType').reset();
	        		 form.down('#resetBtn').setDisabled(false);
	        		 var uploadTypeCombo = form.down('#uploadType');
	        		 uploadTypeCombo.getStore().load({
	        			 callback:function(records){
	        				 uploadTypeCombo.setValue(uploadTypeCombo.getStore().data.items[0].data.id);
	        			 }
	        		 });
	        		 form.down('#moduleName').setVisible(true);
	        		 var comboImport = form.down('#moduleName');
	        		 comboImport.getStore().load({
	        			 callback:function(records){
	        				 for(var i in records){
	        					 if(records[i].data.value=='MasterTimeTable' || records[i].data.code=='MasterTimeTable'){
	        						 comboImport.setValue(records[i].data.id);
	        						 comboImport.setReadOnly(true);
	        						 moduleName = records[i].data.code;
	        					 }
	        				 }
	        				 var grid = $this.getImportlisttimetable();
	        				 grid.setVisible(true);
	        			 }
	        		 });
	        		 form.down('#calendarId').setVisible(false);
	        		 form.down('#calendarId').allowBlank = true;
	        		 form.down('#calendarId').reset();
	        		 form.down('#batchId').setVisible(false);
	        		 form.down('#batchId').allowBlank = true;
	        		 form.down('#periodId').setVisible(false);
	        		 form.down('#periodId').allowBlank = true;
	        		 form.down('#sectionId').setVisible(false);
	        		 form.down('#sectionId').allowBlank = true;
	        		 form.down('#uploadFileField').setVisible(true);
	        		 form.down('#downoladtemplate').setVisible(false);
	        		 form.down('#programBatchUpload').setVisible(true);
	        		 form.down('#resetBtn').setVisible(true);
	        		 form.down('#cbsProgramId').setVisible(false);
	        		 form.down('#cbsBatchId').setVisible(false);
	        		 form.down('#cbsProgramId').setDisabled(true);
	        		 form.down('#cbsBatchId').setDisabled(true);
	        		 form.down('#cbsProgramId').reset();
	        		 form.down('#cbsBatchId').reset();
	        		 var grid = $this.getImportlisttimetable();
	        		 grid.setVisible(true);
	        		 $this.doAccessControlValidationForLoader($this.getUploadtemplate(),$this.getCORE_ERP_LOADER_PERMISSIONS());
    				 var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
    				 uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    					 isUploadAll: false
    				 });
    				 $this.onChangeUploadOptionRadioGroup(false,grid, 'MasterTimeTable');
	        		
	        	 }
	         },
	         deleteMoreDetailed: function(deleteButton) {
	        	 var this$ = this;
	        	 var form = this.getMastertimetableDetailedwindow();
	        	 var timeSlotPanel = form.down('#panelId');
	        	 var container = deleteButton.up('fieldcontainer');

	        	 if (container != null && timeSlotPanel != null) {
	        		 if (timeSlotPanel.items.length > 1) {
	        			 timeSlotPanel.remove(container);
	        			 this$.hideShowDetails(timeSlotPanel);
	        		 }
	        	 }
	         },
	         hideShowDetails: function(detailedPanel) {
	        	 var this$ = this;
	        	 var form = this.getMastertimetableDetailedwindow();
	        	 detailedPanel.items.each(function(item, index, items) {
	        		 var addButton = item.getComponent(item.items.length - 1);
	        		 if (index == (items - 1)) {
	        			 if (addButton != null) {
	        				 addButton.show();
	        			 }
	        		 } else {
	        			 if (addButton != null) {
	        				 addButton.hide();
	        			 }
	        		 }
	        	 });
	         },
	         disablePrintAndExportToPngPivileges: function(Calform, permissionsMap) {
	        	 var me = this;
            	 setTimeout(function(){
    	        	 var associatedAcadLocationIds = new Array();
                     associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
                     var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                     var btnPrint=Calform.down('#btnPrint');
                     var exportToPngBtn=Calform.down('#exportToPngBtn');
                     var btnAdd=Calform.down('#addButtonId');
                     var btnDelete=Calform.down('#btnDelete');
                     btnPrint.setVisible(false);
                     exportToPngBtn.setVisible(false);
                     btnAdd.setVisible(false);
                     btnDelete.setVisible(false);
                     Ext.each(permissionList, function(privilege) {
                    	 if(privilege=="PRINT"){
                    		 btnPrint.setVisible(true);
                    	 }
                    	  if(privilege=="EXPORT_TO_PNG"){
                    		  exportToPngBtn.setVisible(true);
                    	 }
                    	  if(privilege=="ADD"){
                    		  btnAdd.setVisible(true);
                    	  }
                           if(privilege=="DELETE"){
                        	   btnDelete.setVisible(true);
                    	  }
                     });
            	 },300);
             },
	         /*****START:Applied Permssion Management for TimeTable Import****************/
             //@author Ranga
	         disableTimeTableImportTab:function(timetablestructure,permissionsMap){
          	   var associatedAcadLocationIds = new Array();
          	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
          	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
          	   var timetableUploadDownloadStructureTab=false;
          	   var showAscTimetablePanel=false;
          	   Ext.each(permissionList, function(privilege) {
          		   if (privilege === 'BULK_TIMETABLE') {
          			 timetableUploadDownloadStructureTab=true;       		
          		   }
          		 if (privilege === 'IMPORT_ASC_TIMETABLE') {
          			showAscTimetablePanel=true;       		
          		   }
          	   });

          	   this.showImportTimeTableTab(timetableUploadDownloadStructureTab, timetablestructure,showAscTimetablePanel);
             },
             exportReportPermission:function(grid,permissionsMap){
            	   var associatedAcadLocationIds = new Array();
            	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            	   var exportBtn = grid.down('#exportReport');
            	   var btnDelete = grid.down('#btnDelete');
            	   exportBtn.setVisible(false); 
            	   btnDelete.setVisible(false);
            	   btnDelete.permission = false; //To manage during search
            	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
            	   Ext.each(permissionList, function(privilege) {
            		   if (privilege === 'EXPORT_TIMETABLE') {
            			   exportBtn.setVisible(true);    		
            		   }
            		   if (privilege === 'DELETE') {
            			   btnDelete.permission = true; //To manage during search
            			   btnDelete.setVisible(true);    		
            		   }
            	   });
               },
             showImportTimeTableTab : function(timetableUploadDownloadStructureTab, timetablestructure,showAscTimetablePanel) {
            	 var panelItem = new Array();
            	 var $this = this;
            	 var newcont=timetablestructure.items.items.length;
            	 var insertPosition=newcont+1;
            	 if(timetableUploadDownloadStructureTab) {
            		 if(showAscTimetablePanel){
            			 panelItem.push({
            				 xtype:'tabpanel',
            				 itemId:'allVisibleTP',
            				 plain: true,
            				 style:{overflow:'hidden !important',margin:'0!important'},
            				 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
            				 frame: false,
            				 border:false,
            				 defaults: {
            					 labelAlign: 'top'
            				 },
            				 items:[{
            					 title : getCommonTranslation('CREATE_MASTER_TIMETABLE'),	
            					 xtype: 'mastersearchfilter'
            				 },{
            					 title : getCommonTranslation('EXTEND_TIMETABLE'),	
            					 xtype: 'extendmastertimetable'

            				 },{
            					 title : getCommonTranslation('VIEW_MASTER_TIME_TABLE'),	
            					 xtype: 'mastertimetablesession'

            				 },{
            					 title : getCommonTranslation('EXTENDED_TIMETABLE'),	
            					 xtype: 'coursecoverageplanmasterstructure'

            				 },{
            					 title : getCommonTranslation('IMPORT_MASTER_TIMETABLE'),	
            					 xtype: 'uploadtemplatestructure'
            				 },{
            					 title : getProgramandcourseTranslation('Import_ASC_Timetable'),
            					 xtype: 'xmluploadtimetablestructure'

            				 }]
            			 });

            		 }else{
            			 panelItem.push({
            				 xtype:'tabpanel',
            				 itemId:'allVisibleTP',
            				 plain: true,
            				 style:{overflow:'hidden !important',margin:'0!important'},
            				 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
            				 frame: false,
            				 border:false,
            				 defaults: {
            					 labelAlign: 'top'
            				 },
            				 items:[{
            					 title : getCommonTranslation('CREATE_MASTER_TIMETABLE'),	
            					 xtype: 'mastersearchfilter'
            				 },{
            					 title : getCommonTranslation('EXTEND_TIMETABLE'),	
            					 xtype: 'extendmastertimetable'

            				 },{
            					 title : getCommonTranslation('VIEW_MASTER_TIME_TABLE'),	
            					 xtype: 'mastertimetablesession'

            				 },{
            					 title : getCommonTranslation('EXTENDED_TIMETABLE'),	
            					 xtype: 'coursecoverageplanmasterstructure'

            				 },{
            					 title : getCommonTranslation('IMPORT_MASTER_TIMETABLE'),	
            					 xtype: 'uploadtemplatestructure'
            				 }]
            			 });
            		 }
            	 } else {
            		 panelItem.push({
            			 xtype:'tabpanel',
            			 itemId:'allVisibleTP',
            			 plain: true,
            			 style:{overflow:'hidden !important',margin:'0!important'},
            			 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
            			 frame: false,
            			 border:false,
            			 defaults: {
            				 labelAlign: 'top'
            			 },
            			 items:[{
            				 title : getCommonTranslation('CREATE_MASTER_TIMETABLE'),	
            				 xtype: 'mastersearchfilter'
            			 },{
            				 title : getCommonTranslation('EXTEND_TIMETABLE'),	
            				 xtype: 'extendmastertimetable'

            			 },{
            				 title : getCommonTranslation('VIEW_MASTER_TIME_TABLE'),	
            				 xtype: 'mastertimetablesession'

            			 },{
            				 title : getCommonTranslation('EXTENDED_TIMETABLE'),	
            				 xtype: 'coursecoverageplanmasterstructure'

            			 }]
            		 });

            	 }
            	 timetablestructure.insert(insertPosition,panelItem);
             },
        /*****END:Applied Permssion Management for TimeTable Import****************/
             loadXmlImportTemplate:function(){
            	 var $this=this;
	        	 var form =$this.getXmluploadtemplate();
	        	 var grid = $this.getImportxmltimetablelist();
	        	 //var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        	 var isUploadAll = false;
	        	 $this.getXMLUploadedFile(grid);
             },
             getDownloadTimeTableFile : function(documentId,fileType){

            	 if(!isNullOrEmpty(documentId)){
            		 var csvForm = Ext.create('Ext.form.Panel'); 
            		 csvForm.getForm().submit({
            			 target: '_blank',
            			 method:'POST',
            			 params :{
            				 access_token : Ext.Ajax.defaultHeaders.access_token
            			 },
            			 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            			 url: SERVERURL.XML_IMPORT_FILE_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
            			 standardSubmit :true
            		 });
            	 }
             },

             downloadMasterTimetablePDF : function(tempCode){
            	 var flag=true;
            	 var $this = this;
            	 var window = $this.getGeneratematertimetablereportwin();
     	    	var code;
         	    if(tempCode) {
         		   code = tempCode;
         	    } else {
         		   code = window.down('#chooseTemplate').valueModels[0].data.value;
         	    }
           	 var formField = $this.getProgramcoursefilters();
           	 var form = formField.getForm();
           	 var academyLocationId = this.getCurrentAcademyLocation();
           	 var programName;
           	 var batchName;
           	 var periodName;
           	 var sectionName;
           	 var sectionGroupName;
           	 var values = form.getValues();
         	    if(code=='MASTER_TIME_TABLE_CODE'){
            	 var reportTitle = "Master Timetable Report";
            	 var code = 'MASTER_TIME_TABLE_PDF';
            	 var courseId;
            	 var sectionId;
            	 var selectedRecords = new Array();
            	 var courseIds;
            	 var selectedsectionRecords = new Array();
            	 var sectionIds;
            	 if(values.sectionType=="CBS"){
            		 courseId=values.course;
            		 sectionId=values.section;
            		 if(courseId !=undefined && courseId.length > 0){
                		 for(var i in courseId){
                			 if(Ext.isObject(courseId[i])){
                				 selectedRecords.push(courseId[i].get("id"));
                			 }else{
                				 selectedRecords.push(courseId[i]);
                			 }
                		 }
                	 }
            		 
            		 if(sectionId !=undefined && sectionId.length > 0){
                		 for(var i in sectionId){
                			 if(Ext.isObject(sectionId[i])){
                				 selectedsectionRecords.push(sectionId[i].get("id"));
                			 }else{
                				 selectedsectionRecords.push(sectionId[i]);
                			 }
                		 }
                	 }
                	 
            	 }else if(values.sectionType=="PBS"){
            		 courseId=values.course_1;
            		 sectionId=values.section_1;
            		 selectedRecords.push(courseId);
            		 selectedsectionRecords.push(sectionId);
            	 }
            	 courseIds = selectedRecords.join();
            	 sectionIds = selectedsectionRecords.join();
            	 
            	 var facultyId=values.faculty;
            	 var selectedFacultyRecords = new Array();
            	 var facultyIds;
            	 if(facultyId !=undefined && facultyId.length > 0){
            		 for(var i in facultyId){
            			 if(Ext.isObject(facultyId[i])){
            				 selectedFacultyRecords.push(facultyId[i].get("id"));
            			 }else{
            				 selectedFacultyRecords.push(facultyId[i]);
            			 }
            		 }
            	 }
            	 facultyIds = selectedFacultyRecords.join();

            	 var homeRoomId=values.homeRoom;
            	 var selectedhomeRoomRecords = new Array();
            	 var homeRoomIds;
            	 if(homeRoomId !=undefined && homeRoomId.length > 0){
            		 for(var i in homeRoomId){
            			 if(Ext.isObject(homeRoomId[i])){
            				 selectedhomeRoomRecords.push(homeRoomId[i].get("id"));
            			 }else{
            				 selectedhomeRoomRecords.push(homeRoomId[i]);
            			 }
            		 }
            	 }
            	 homeRoomIds = selectedhomeRoomRecords.join();

            	 var reportParams = new Object();
            	 reportParams.code = code;
            	 reportParams.reportTitle = reportTitle;
            	 reportParams.academyLocationIds = academyLocationId;
            	 var academicTermId = values.ACADEMIC_TERM;
	          	   if(academicTermId == "" || academicTermId == undefined){
	          		   academicTermId=null;
	          	   }
            	 if(values.sectionType=="CBS"){
            		 reportParams.programId = values.cbsProgram;
            		 reportParams.batchId = values.cbsBatch;
            		 reportParams.periodId = values.cbsPeriod;
            		 reportParams.sectionGroupId = values.cbsSectionGroupId;
            		 reportParams.sectionType = 'CourseSection';
            		 reportParams.academicTermId = academicTermId;
            		 reportParams.sectionIds = sectionIds;
                	 reportParams.courseIds = courseIds;
                	 reportParams.programName = formField.down('#cbsProgramId').getRawValue();
                	 reportParams.batchName = formField.down('#cbsBatchId').getRawValue();
                	 reportParams.periodName = formField.down('#cbsPeriodId').getRawValue();
                	 reportParams.sectionGroupName = formField.down('#cbsSectionGroupId').getRawValue();
                	 if(isNullOrEmpty(formField.down('#cbsPeriodId').getRawValue())){
                   	  	flag=false
                   	  	showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('SELECT_PERIOD_RECORD_CBS'));
                   	  } 
            	 }
            	 else if(values.sectionType=="PBS"){
            		 reportParams.programId = values.program;
            		 reportParams.batchId = values.batch;
            		 reportParams.periodId = values.period;
            		 reportParams.sectionType = 'ProgramBatchSection';
            		 reportParams.sectionIds = sectionIds;
                	 reportParams.courseIds = courseIds;
                	 reportParams.programName = formField.down('#programId').getRawValue();
                	 reportParams.batchName = formField.down('#batchId').getRawValue();
                	 reportParams.periodName = formField.down('#periodId').getRawValue();
                	 reportParams.sectionName = formField.down('#courseSection_Id_1').getRawValue();
                	 if(isNullOrEmpty(formField.down('#courseSection_Id_1').getRawValue())){
                  	  	flag=false
                  	  	showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('SELECT_PERIOD_RECORD'));
                  	  }  
            	 }
            	           	 
            	 reportParams.facultyIds = facultyIds;
            	 reportParams.roomIds = homeRoomIds;
            	 if(flag){
            	 $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_PDF_REPORT);
         	    }
         	    }
         	 else if(code=='MASTER_TIME_TABLE_CODE_FACULTY_WISE'){
         	    	
         	 var formField = $this.getProgramcoursefilters();
        	 var reportTitle = "Master Timetable Faculty Wise";
        	 var code = 'MASTER_TIME_TABLE_CODE_FACULTY_WISE';
        	 var facultyId=values.faculty;
        	 var academicTermId = values.ACADEMIC_TERM;
        	   if(academicTermId == "" || academicTermId == undefined){
        		   academicTermId=null;
        	   }
        	 var reportParams = new Object();
        
        	 if(values.sectionType=="CBS"){
        		 reportParams.sectionType = 'CourseSection'
        		reportParams.academicTermId = academicTermId;
        	}else{
        		 reportParams.sectionType = 'ProgramBatchSection'
        	}
        	
        			 var facultyIds;
        			 var selectedFacultyRecords = new Array();
                	for(var i in facultyId){
                			 if(Ext.isObject(facultyId[i])){
                				 selectedFacultyRecords.push(facultyId[i].get("id"));
                			 }
                		 }
                	if(selectedFacultyRecords.length > 1){
                		flag=false;
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD'));
                	}else if(selectedFacultyRecords==0){
                		flag=false;
                		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ONE_FACULTY_RECORD'));
                	}
                	facultyIds = selectedFacultyRecords.join();
                	reportParams.academyLocationIds = academyLocationId;
            reportParams.facultyIds = facultyIds;
            if(flag){
        	 $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_ROOM_FACULTY_WISE_PDF_REPORT);
            }
        	 }
         	 else if(code=='MASTER_TIME_TABLE_CODE_ROOM_WISE'){
         	 var reportTitle = "Master Timetable Room Wise";
           	 var code = 'MASTER_TIME_TABLE_CODE_ROOM_WISE';
         	 var homeRoomId=values.homeRoom;
         	 var academicTermId = values.ACADEMIC_TERM;
          	   if(academicTermId == "" || academicTermId == undefined){
          		   academicTermId=null;
          	   }
         	 var reportParams = new Object(); 	
         	    	
         	    		var selectedhomeRoomRecords = new Array();
                   	 var homeRoomIds;
                   		 for(var i in homeRoomId){
                   			 if(Ext.isObject(homeRoomId[i])){
                   				 selectedhomeRoomRecords.push(homeRoomId[i].get("id"));
                   			 }
                   	 }
                   		 if(values.sectionType=="CBS"){
                    		 reportParams.sectionType = 'CourseSection'
                    		reportParams.academicTermId = academicTermId;
                    	}else{
                    		 reportParams.sectionType = 'ProgramBatchSection'
                    	}
                   		if(selectedhomeRoomRecords.length > 1){
                   			flag=false;
             	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD'));
             	    	}
             	 else if(selectedhomeRoomRecords.length ==0){
             		 flag=false;
            		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ONE_ROOM_RECORD'));
            	}
                   	 homeRoomIds = selectedhomeRoomRecords.join();	
                   	reportParams.academyLocationIds = academyLocationId;
                   	 reportParams.roomIds = homeRoomIds;
                   	 if(flag){
         	    	 $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_ROOM_FACULTY_WISE_PDF_REPORT);
         	 }
         	 }  
         	 // new time table //V2D-461772
         	 
         	 else if(code=='MASTER_TIME_TABLE_SECTION_WISE'){
         	 var formField = $this.getProgramcoursefilters();
        	 var reportTitle = "Master Timetable Section Wise";
        	 var code = 'MASTER_TIME_TABLE_SECTION_WISE';
        	 var facultyId=values.faculty;
        	 var sectionId=values.section;
        	 var academicTermId = values.ACADEMIC_TERM;
        	   if(academicTermId == "" || academicTermId == undefined){
        		   academicTermId=null;
        	   }
        	 var reportParams = new Object();
             reportParams.programId = null;
        	 if(values.sectionType=="CBS"){
        		 reportParams.sectionType = 'CourseSection'
        		reportParams.academicTermId = academicTermId;
        		reportParams.programId = values.cbsProgram;
            	reportParams.batchId = values.cbsBatch;
            	reportParams.periodId = values.cbsPeriod;
            	reportParams.sectionGroup = values.cbsSectionGroupId;
        	}else{
        		 reportParams.sectionType = 'ProgramBatchSection'
        	}
        	
        			 var facultyIds;
        			 var selectedFacultyRecords = new Array();
                	for(var i in facultyId){
                			 if(Ext.isObject(facultyId[i])){
                				 selectedFacultyRecords.push(facultyId[i].get("id"));
                			 }
                		 }
                     var sectionIds;
                     var selectedSectionRecords = new Array();
                	 for(var i in sectionId){
                			 if(Ext.isObject(sectionId[i])){
                				selectedSectionRecords.push(sectionId[i].get("id"));
                			 }
                      }	 
                	/*if(selectedSectionRecords==0){
                		//flag=false;
                		//showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('SELECT_ATLEAST_ONE_SECTION_RECORD'));
                	}*/
                	facultyIds = selectedFacultyRecords.join();
                	sectionIds = selectedSectionRecords.join();
                	reportParams.academyLocationIds = academyLocationId;
                    reportParams.facultyIds = facultyIds;
                    reportParams.sectionIds = sectionIds;
            if(flag){
        	 $this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.GET_EXPORT_MASTER_TIME_TABLE_SECTION_WISE_PDF_REPORT);
            }
        	 }
        	 
         	//// 
             
             window.close();
             },
             
             onBatchChange: function(obj, record){
            	 var me = this;
            	 var importsessiontopicsdownloadcbspanel = obj.up('importsessiontopicsdownloadcbspanel');
            	 var academicTermField = importsessiontopicsdownloadcbspanel.down('#academicTermIdCBS');
            	 var batchField = importsessiontopicsdownloadcbspanel.down('#batchId');
            	 var courseField = importsessiontopicsdownloadcbspanel.down('#course_Id');
            	 var courseVariantField = importsessiontopicsdownloadcbspanel.down('#downloadCourseVariant_ID');
            	 var academicTermId = academicTermField.getValue();

            	 var batchStore = batchField.getStore();
            	 var courseStore = courseField.getStore();
            	 var courseVariantStore = courseVariantField.getStore();

            	 var batchIds = '';
            	 var courseIds = '';

            	 if(Ext.isDefined(batchField.getValue()) && batchField.getValue().length){
            		 try{
            			 batchIds = Ext.Array.pluck(Ext.Array.pluck(batchField.value,'data'),'id').join();
            		 }
            		 catch(e){
            			 try{
            				 if(typeof batchField.value[0] != "object"){
            					 batchIds = batchField.value.join();
            				 }
            			 }
            			 catch(e){}
            		 }
            	 }

            	 courseStore.getProxy().extraParams = {
            		 academicTermId:academicTermId,
            		 batchIds: batchIds
            	 };

            	 courseField.reset();
            	 courseVariantField.reset();

            	 courseField.setDisabled(true);
            	 courseVariantField.setDisabled(true);
            	 
            	 me.validateImportSessionTopicsDownloadCBSForm();

            	 courseStore.load({
            		 callback: function(rec, success){
            			 if (success) {
            				 courseField.setDisabled(false);
            				 if(rec.length==1){
            					 courseField.setValue(rec[0].get('courseId'));

            					 if(Ext.isDefined(courseField.getValue()) && courseField.getValue().length){
            						 try{
            							 courseIds = rec[0].get('courseId');
            						 }
            						 catch(e){}
            					 }

            					 var courseVariantStoreExtraParams = {
            							 academicTermId:academicTermId,
            							 courseIds: courseIds,
            							 batchIds: batchIds
            					 }

            					 courseVariantStore.getProxy().extraParams = courseVariantStoreExtraParams;
            					 me.validateImportSessionTopicsDownloadCBSForm();
            					 courseVariantStore.load({
            						 callback: function(rec, success){
            							 if (success && !isNullOrEmpty(courseIds)) {
            								 courseVariantField.setDisabled(false);
            								 if(rec.length==1){
            									 courseVariantField.setValue(rec[0].get('id'));
            								 }
            								 me.validateImportSessionTopicsDownloadCBSForm();
            							 }
            						 }
            					 });
            				 }
            			 }
            		 }
            	 });
             },
   	      onCourseChange: function(obj, record){
   	    	  var me = this;
   	    	  var importsessiontopicsdownloadcbspanel = obj.up('importsessiontopicsdownloadcbspanel');
   	    	  var academicTermField = importsessiontopicsdownloadcbspanel.down('#academicTermIdCBS');
   	    	  var batchField = importsessiontopicsdownloadcbspanel.down('#batchId');
   	    	  var courseField = importsessiontopicsdownloadcbspanel.down('#course_Id');
   	    	  var courseVariantField = importsessiontopicsdownloadcbspanel.down('#downloadCourseVariant_ID');
   	    	  var academicTermId = academicTermField.getValue();
   	    	  courseVariantField.reset();
   	    	  courseVariantField.setDisabled(true);
   	    	  var courseVariantStore = courseVariantField.getStore();

   	    	  var batchIds = '';
   	    	  var courseIds = '';

   	    	  if(Ext.isDefined(batchField.getValue()) && batchField.getValue().length){
   	    		  try{
   	    			  batchIds = Ext.Array.pluck(Ext.Array.pluck(batchField.value,'data'),'id').join();
   	    		  }
   	    		  catch(e){
   	    			  try{
   		    			  if(typeof batchField.value[0] != "object"){
   		    				  batchIds = batchField.value.join();
   		    			  }
   	    			  }
   	    			  catch(e){}
   	    		  }
   	    	  }

   	    	  if(Ext.isDefined(courseField.getValue()) && courseField.getValue().length){
   	    		  try{
   	    			  courseIds = Ext.Array.pluck(Ext.Array.pluck(courseField.value,'data'),'id').join();
   	    		  }
   	    		  catch(e){
   	    			  try{
   		    			  if(typeof courseField.value[0] != "object"){
   		    				  courseIds = courseField.value.join();
   		    			  }
   	    			  }
   	    			  catch(e){}
   	    		  }
   	    	  }

   	    	  courseVariantStore.getProxy().extraParams = {
   	    		  academicTermId:academicTermId,
   	    		  courseIds: courseIds,
   	    		  batchIds: batchIds
   	    	  };

   	    	  me.validateImportSessionTopicsDownloadCBSForm();
   	    	  courseVariantStore.load({
   	    		  callback: function(rec, success){
   	    			  if (success && !isNullOrEmpty(courseIds)) {
   	    				  courseVariantField.setDisabled(false);
   	    				  if(rec.length==1){
   	    					  courseVariantField.setValue(rec[0].get('id'))
   	    				  }
   	    			  }
   	    			  me.validateImportSessionTopicsDownloadCBSForm();
   	    		  }
   	    	  });
   	      },
   	      
   	      validateImportSessionTopicsDownloadCBSForm: function(){
   	    	  var me = this;
   	    	  var importsessiontopicsdownloadcbspanel = me.getImportsessiontopicsdownloadcbspanel();
   	    	  var academicTermIdCBS = importsessiontopicsdownloadcbspanel.down('#academicTermIdCBS');
   	    	  var course_Id = importsessiontopicsdownloadcbspanel.down('#course_Id');
   	    	  var importSessionTopicCBSDownload = importsessiontopicsdownloadcbspanel.down('#importSessionTopicCBSDownload');
   	    	  
   	    	  if(isNullOrEmpty(academicTermIdCBS.getValue()) || isNullOrEmpty(course_Id.getValue())){
   	    		  importSessionTopicCBSDownload.setDisabled(true);
   	    	  }
   	    	  else{
   	    		  if(course_Id.getValue().length==1 && isNullOrEmpty(course_Id.getValue()[0])){
   	    			  importSessionTopicCBSDownload.setDisabled(true);
   	    		  }
   	    		  else{
   	    			  importSessionTopicCBSDownload.setDisabled(false);
   	    		  }
   	    	  }
   	      },
   	      
   	   validateImportSessionTopicsDownloadPBSForm: function(){
	    	  var me = this;
	    	  var importsessiontopicsdownloadpbspanel = me.getImportsessiontopicsdownloadpbspanel();
	    	  var academicTermIdPBS = importsessiontopicsdownloadpbspanel.down('#academicTermIdPBS');
	    	  var batchField = importsessiontopicsdownloadpbspanel.down('#batchIdPBS');
	    	  var importSessionTopicPBSDownload = importsessiontopicsdownloadpbspanel.down('#importSessionTopicPBSDownload');
	    	  
	    	  if(isNullOrEmpty(academicTermIdPBS.getValue()) || isNullOrEmpty(batchField.getValue())){
	    		  importSessionTopicPBSDownload.setDisabled(true);
	    	  }
	    	  else{
	    		  if(batchField.getValue().length==1 && isNullOrEmpty(batchField.getValue()[0])){
	    			  importSessionTopicPBSDownload.setDisabled(true);
	    		  }
	    		  else{
	    			  importSessionTopicPBSDownload.setDisabled(false);
	    		  }
	    	  }
	      },
	      
	      resetImportSessionTopicPBSFilter : function(panel){

				var me = this;
				var academyLocationId = this.getCurrentAcademyLocation();
				var academicTermCombo = panel.down('#academicTermIdPBS');
				var batchField = panel.down('#batchIdPBS');
				var periodField = panel.down('#periodIdPBS');
				var courseField = panel.down('#course_IdPBS');
				
				academicTermCombo.reset();
				batchField.reset();
				courseField.reset();
				periodField.reset();
				
				batchField.setDisabled(true);
				courseField.setDisabled(true);
				periodField.setDisabled(true);
				
				var academicTermComboStore = academicTermCombo.getStore();
				academicTermComboStore.getProxy().extraParams = {
					academyLocationIds : academyLocationId
				};
				academicTermComboStore.load({
					callback: function(rec, success) {
						if (success) {
							for(var i in rec){
								if(rec[i].get('sequence')==1){
									academicTermCombo.setValue(rec[i].get('id'));
								}
							}
						}
					}
				});
	       },
		   
		   resetImportExtendedTTFilter : function(panel){

		   			var me = this;
		   			var academyLocationId = this.getCurrentAcademyLocation();
		   			var academicTermCombo = panel.down('#academicTermIdExtendedTT');
		   			var batchField = panel.down('#batchIdExtendedTT');
		   			var periodField = panel.down('#periodIdExtendedTT');
		   			
		   			academicTermCombo.reset();
		   			batchField.reset();
		   			periodField.reset();
		   			
		   			batchField.setDisabled(true);
		   			periodField.setDisabled(true);
		   			
		   			var academicTermComboStore = academicTermCombo.getStore();
		   			academicTermComboStore.getProxy().extraParams = {
		   				academyLocationIds : academyLocationId
		   			};
		   			academicTermComboStore.load({
		   				callback: function(rec, success) {
		   					if (success) {
		   						for(var i in rec){
		   							if(rec[i].get('sequence')==1){
		   								academicTermCombo.setValue(rec[i].get('id'));
		   							}
		   						}
		   					}
		   				}
		   			});
		          },
	       
	       resetImportSessionTopicCBSFilter : function(panel){
	    	   var me = this;
	 			var academyLocationId = this.getCurrentAcademyLocation();
	 			var academicTermCombo = panel.down('#academicTermIdCBS');
	 			var batchField = panel.down('#batchId');
	 			var courseField = panel.down('#course_Id');
	 			var courseVariantField = panel.down('#downloadCourseVariant_ID');
	 			
	 			academicTermCombo.reset();
	 			batchField.reset();
	 			courseField.reset();
	 			courseVariantField.reset();
	 			
	 			batchField.setDisabled(true);
	 			courseField.setDisabled(true);
	 			courseVariantField.setDisabled(true);
	 			
	 			var academicTermComboStore = academicTermCombo.getStore();
	 			academicTermComboStore.getProxy().extraParams = {
	 				academyLocationIds : academyLocationId
	 			};
	 			academicTermComboStore.load({
	 				callback: function(rec, success) {
	 					if (success) {
	 						for(var i in rec){
	 							if(rec[i].get('sequence')==1){
	 								academicTermCombo.setValue(rec[i].get('id'));
	 							}
	 						}
	 					}
	 				}
	 			});
	       },
	       
	    disableAllFacultyCheckBoxPivileges: function(formReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		formReference.down('#allFacultyCheckId').setVisible(false);
		Ext.each(permissionList, function(privilege) {
		if (privilege === 'ALL_FACULTIES') {
		formReference.down('#allFacultyCheckId').setVisible(true);
		}
		});
		},
		
		showHidePBSColumns: function(grid, stype){
			  var gridColumns = grid.columns;
			  var len = gridColumns.length;
			  for (var j = 0; j < len; j++) {
				  var gridColumn = gridColumns[j];
				  if(stype == "PBS"){
					  if(gridColumn.dataIndex=='programName' || gridColumn.dataIndex=='batchName' || gridColumn.dataIndex=='periodName') { //Managing through dataIndex instead of column index
						  gridColumn.hide();
					  }
				  }
				  else{
					  if(grid.visibleColumns && grid.visibleColumns.length && grid.visibleColumns){
						  if(gridColumn.dataIndex=='programName' && grid.visibleColumns.indexOf('programName')){
							  gridColumn.show();
						  }
						  else if(gridColumn.dataIndex=='batchName' && grid.visibleColumns.indexOf('batchName')){
							  gridColumn.show();
						  }
						  else if(gridColumn.dataIndex=='periodName' && grid.visibleColumns.indexOf('periodName')){
							  gridColumn.show();
						  }
					  }
					  else if(gridColumn.dataIndex=='programName' || gridColumn.dataIndex=='batchName' || gridColumn.dataIndex=='periodName') { //Managing through dataIndex instead of column index
						  gridColumn.show();
					  }
				  }
			  }
		}
             

});
