/**
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.criteriabuilder.SavedAdvanceSearchCriteriaController', {
    extend: 'Academia.controller.base.BaseController',
    views: ['Academia.view.criteriabuilder.SavedAdvanceSearchCriteria', 'Academia.view.criteriabuilder.SavedAdvanceSearchTab',
            'reports.admission.AdmissionSearchCriteriaReport'],
            
    stores: ['Academia.store.criteriabuilder.SavedSearchCriteriaConfig'],
            
    init: function(application) {
    	
    	this.control({
    		'savedadvancesearchcriteria treepanel[itemId=saveSearchCriteriaTreePanel]': {
    			render: function(treePanel, eOpts) {
		       		var moduleName = treePanel.up('savedadvancesearchcriteria').moduleName;
		        	var userId=this.getCurrentlyLoggedInUser().id;
		        	if(!isNullOrEmpty(moduleName) && !isNullOrEmpty(userId)){
		        		var store = treePanel.getStore();
			       		store.load({
			       			params:{
			       				userid: userId,
				       			moduleName: moduleName
			       			}
			       		});
		        	}
		       		
		          },
        		itemclick : function( treePanel, record, item, index, e, eOpts ) {
					var savedAdvanceSearchCriteria = treePanel.up('savedadvancesearchcriteria');
					var saveSearchCriteriaTree = savedAdvanceSearchCriteria.down('#saveSearchCriteriaTreePanel');
					var tabDetail = record.data;
					if(!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.searchConfigCode) && !isNullOrEmpty(tabDetail.searchResultViewCode)){
						saveSearchCriteriaTree.toggleCollapse();
						var advanceSearchCriteriaTab = savedAdvanceSearchCriteria.down('#advanceSearchCriteriaTab');
						
						if (advanceSearchCriteriaTab) {
							
							var newTab = advanceSearchCriteriaTab.items.findBy(function(tab) {
					    		return tab.title === tabDetail.text;
					    	});
							if(!newTab){
								newTab = advanceSearchCriteriaTab.add({
							        xtype: 'advancedsearchquerybuilder',
							        closable: true,
							        autoScroll: false,
							        saveSearchId: tabDetail.id,
							        title: tabDetail.text,
							        searchConfigCode : tabDetail.searchConfigCode,
									searchResultViewCode: tabDetail.searchResultViewCode,
									permissionMapKey: 'STUDENTS_REPORT_PRIVILEGES',
									gridTitle: tabDetail.text,
									tabCls: 'right-tab',
									FPCONSTANTS:'PUBLIC_PRIVILEGES'
							    });
							}
							
							advanceSearchCriteriaTab.setActiveTab(newTab);
							treePanel.getSelectionModel().deselectAll();
						} 
					}
					
				}
       	     },
       	     
	       	  'savedadvancesearchcriteria searchcriteriagroup[itemId=defaultGroup]': {
	       		boxready: function(defaultGroup){
	       			var advancedSearchQueryBuilder = defaultGroup.up('advancedsearchquerybuilder');
	       			advancedSearchQueryBuilder.down('panel').toggleCollapse( );
	       			setTimeout(function() {
	                    advancedSearchQueryBuilder.loadSavedSearchCriteria(advancedSearchQueryBuilder, advancedSearchQueryBuilder.saveSearchId,true);
	       			},200);
	       			advancedSearchQueryBuilder.down('#loadSavedSearchComboId').hide();
	       			
	       			
	       		 }
	       	  },
	       	'savedadvancesearchcriteria button[itemId=SaveSearchButton]': {
	       		show: function(button, eOpts) {
		       		  button.setDisabled(true);
		       		  button.setVisible(false);
		          }
	       	}
    	});
    }
 
});