/**
 * 
 * Rajkumar
 */

Ext.define('Academia.controller.enquiry.closure.ClosureDetailController', {
	extend: 'Academia.controller.base.BaseController',
	 stores : ['enquiry.closure.ReopenReasonStore','enquiry.closure.ClosureForOtherEnquiryType','enquiry.followup.ApplicationSearchStore'],
     views : [ 'enquiry.closure.ClosureDetailStructure','enquiry.closure.ClosureDetailForm',
               'enquiry.closure.ClosureDetailGrid','enquiry.closure.ClosureDetailForOtherEnquiryTypeGrid'],
	  alias : "widget.ClosureDetailController",
	                    refs : [{
	                    	ref : 'closuredetailForm',
	                    	selector : 'closuredetailform form'
	                    },{
	                    	ref : 'closuredetailform',
	                    	selector : 'closuredetailform'
	                    },{
	                    	ref : 'closuredetailgrid',
	                    	selector : 'closuredetailgrid'
	                    },{
	                    	ref : 'closuredetailstructure',
	                    	selector : 'closuredetailstructure'
	                    },{	  
	                    	ref : 'enquirytabstructure',
	                    	selector : 'enquirytabstructure'  
	                    },{	  
	                    	ref : 'closuredetailforotherenquirytypegrid',
	                    	selector : 'closuredetailforotherenquirytypegrid'  
	                    }],
                config: {
	        	          	/*
	        	      	   	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	        	      	   	 */
	        	          	/**
	        	               * @cfg {Array} CLOSURE_DETAIL_PERMISSIONS array (required)
	        	               * The array of permissions to use for Access control wise enabling and disabling buttons.
	        	               * @accessor
	        	               */
	        		      CLOSURE_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CLOSURE_DETAIL_PRIVILEGES')
	        	          },   

	                    init : function() {

	                    	this.control({
	                    		'closuredetailgrid':{
	                    			render:function(grid){
	                    				this.doAccessControlValidation(grid, this.getCLOSURE_DETAIL_PERMISSIONS());
	                    				var commonForm = this.getEnquirytabstructure().getForm();
	                        	        var commonVal = commonForm.getValues();
	                        			var buttonId = commonVal.buttonType;
	                                    if(buttonId == 'View'){
	                                		grid.down('#btnEdit').setVisible(false);
	                                   }
	                    			}
	                    		},	                    	
	                    		'closuredetailforotherenquirytypegrid':{
	                    			render:function(grid){
	                    				this.doAccessControlValidation(grid, this.getCLOSURE_DETAIL_PERMISSIONS());
	                    				var commonForm = this.getEnquirytabstructure().getForm();
	                        	        var commonVal = commonForm.getValues();
	                        			var buttonId = commonVal.buttonType;
	                                    if(buttonId == 'View'){
	                                		grid.down('#btnEdit').setVisible(false);
	                                   }
	                    			}
	                    		},
	                    		'closuredetailgrid button[itemId=btnAdd]':{
	                    			click:this.showFormWindow
	                    		},
	                    		'closuredetailgrid button[itemId=btnEdit]':{
	                    			click:function(){
	                    				var grid = Ext.getCmp('closuredetail_grid');
	        	                    	var store=this.getStore('enquiry.closure.ClosureStore');
	        	                    	this.editFormWindow(grid,store);
	                    			}
	                    		},
	                    		'closuredetailgrid button[itemId=btnDelete]':{
	                    			click:this.deleteFormWindow
	                    		},
	                    		'closuredetailgrid button[itemId=btnView]':{
	                    			click:this.viewFormWindow
	                    		},
	                    		'closuredetailform radiogroup[itemId=programExam_radioBtn]':{
	                    			change:this.showAndHideReasons
	                    		},
	                    		'closuredetailform button[itemId=closureform_submitbuttonId]':{
	                    			click:function(h)
	                    			{
	                    				var form = this.getClosuredetailForm().getForm();
	                    				this.showInvalidIconOnField(this.getClosuredetailForm());
	    	        	 	        	var val = form.getValues();
	    	        	 	        	
	    	        	 	        	var reopenRemarks1= val.reopenRemarks;
	    	              	        	var closureRemarks1= val.closureRemarks;
	    	              	        	var closureRemarks1Valid='';
	    	              	        	var reopenRemarks1Valid='';
	    	              	        	
	    		        	        	if(closureRemarks1 != ''){
	    		        	        		closureRemarks1Valid=closureRemarks1.trim();
	    		        	        		if(closureRemarks1Valid==''){
		                    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CLOSURE_REMARKS_ALERT'));
		                    					}
	    		        	        		}
	    		        	        	if(reopenRemarks1 != ''){
	    		        	        		reopenRemarks1Valid=reopenRemarks1.trim();
	    		        	        		if(reopenRemarks1Valid==''){
		                    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('REOPEN_REMARKS_ALERT'));
		                    					}
	    		        	        		}
	    		        	        	
	    		        	        	if(closureRemarks1Valid !=''){
	               						this.saveClosureDetail(h);	
	               							}
	    		        	        	if(reopenRemarks1Valid !=''){
		               						this.saveClosureDetail(h);	
		               							}
	                    			}
	                    		},
	                    		'closuredetailform button[itemId=closureform_cancelbuttonId]':{
	                    			click:this.cancelClosureDetail
	                    		},
	                    		'closuredetailstructure' : {
	                    			activate: function(f){
	                    				this.onClosureFormRender();
	                    			}
	                    		},
	                    		'closuredetailforotherenquirytypegrid button[itemId=btnEdit]' : {
	                    			click:function(){
	                    				var closureDetailForOtherAcademyGrid =  Ext.getCmp('closuredetailforotherEnqType_grid');
	                    				var store= closureDetailForOtherAcademyGrid.getStore();
	                    				this.editFormWindow(closureDetailForOtherAcademyGrid,store);
	                    			}
	                    		},
/*	                    		'closuredetailform customcombobox[itemId=closureReasonItemId]':{
	                    			render:function(combo){
	                    				var closureReasonStore=combo.getStore();
	                    				closureReasonStore.on('load', function(){
	                        				for(var i=0; i< closureReasonStore.data.items.length;i++){
	                        					if(closureReasonStore.data.items[i].data.value == 'Closed Successfully'){
	                        						closureReasonStore.removeAt(i);
	                        					} 
	                        				}
	                        			});
	                    			}
	                    		}*/
	                    		
	                    		 'closuredetailform customcombobox#closureReasonItemId':{
	                      			 select:function(obj,record){
	                      				 var form = this.getClosuredetailForm().getForm();
	                      				 var closureReason = record[0].get("value")
	                      				 var applicationField = form.findField("applicationId");;
	                      				 applicationField.allowBlank=true;
	                      				 applicationField.setVisible(false);
	                      				 applicationField.clearValue();

	                      				 if(closureReason=="Closed Successfully"){
	                      					applicationField.setVisible(true);
	                      					applicationField.allowBlank=false;
	                      				 }
	                      				 
	                      				var valid = this.getClosuredetailForm().getForm().isValid();      				
	                      				if(valid) {
	                      					form.down('#SubmitBtn').setDisabled(false);
	                      				}
	                      			 }
	                      		 },
	                      		 'closuredetailform':{
	                      			render:function(window){
	                    				var $this = this
	                    				window.body.on('click', function() {
	                    					var filter = window.down('form');
	                    					$this.hideInvalidIconFromField(filter);
	                    			       });
	                    			}
	                      		 }
	                    	});
	                    },
	                    showAndHideReasons : function(val){
	                    	var form = this.getClosuredetailForm().getForm();
	                    	var checkbox = form.findField("programExam");
	                    	var closure = checkbox.items.items[0].getValue();
	                    	var reopen = checkbox.items.items[1].getValue();

	                    	if(val=="Closed"){
	                    		
	                    		reopen =true;
	                    		checkbox.items.items[1].setValue(true);
	                    		checkbox.items.items[0].setDisabled(true);
	                    		checkbox.items.items[1].setDisabled(false);
	                    		checkbox.items.items[0].setValue(false);
	                    	}else if(val=="Open"){
	                    		reopen =  false;
	                    		checkbox.items.items[0].setValue(true);
	                    		checkbox.items.items[1].setValue(false);
	                    		checkbox.items.items[0].setDisabled(false);
	                    		checkbox.items.items[1].setDisabled(true)
	                    	}

	                    	if(reopen){
	                    		form.findField("closureDate").hide();
	                    		form.findField("closureReason").hide();
	                    		form.findField("closureRemarks").hide();
	                    		form.findField("applicationId").hide();
	                    		

	                    		form.findField("reopenDate").show();
	                    		form.findField("reopenReason").show();
	                    		form.findField("reopenRemarks").show();
	                    		
	                    		form.findField("closureDate").allowBlank=true;
	                    		form.findField("closureReason").allowBlank=true;
	                    		form.findField("closureRemarks").allowBlank=true;
	                    		form.findField("applicationId").allowBlank=true;
	                    		
	                    		form.findField("reopenDate").allowBlank=false;
	                    		form.findField("reopenReason").allowBlank=false;
	                    		form.findField("reopenRemarks").allowBlank=false;
	                    		
	                    	}else{
	                    		form.findField("closureDate").show();
	                    		form.findField("closureReason").show();
	                    		form.findField("closureRemarks").show();
	                    		//form.findField("applicationId").show();
	                    		
	                    		form.findField("reopenDate").hide();
	                    		form.findField("reopenReason").hide();
	                    		form.findField("reopenRemarks").hide();
	                    		
	                    		form.findField("closureDate").allowBlank=false;
	                    		form.findField("closureReason").allowBlank=false;
	                    		form.findField("closureRemarks").allowBlank=false;
	                    		//form.findField("applicationId").allowBlank=false;
	                    		
	                    		form.findField("reopenDate").allowBlank=true;
	                    		form.findField("reopenReason").allowBlank=true;
	                    		form.findField("reopenRemarks").allowBlank=true;
	                    	}


	                    },
	                    showFormWindow : function() {

	                    	var formWindow = this.getClosuredetailform();
	                    	if (!formWindow) {
	                    		Ext.widget('closuredetailform');
	                    		formWindow = this.getClosuredetailform();
	                    	}
	                    	formWindow.show();

	                    },

	                    editFormWindow: function(grid,store) {
	                    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                    	var row = store.indexOf(selectedRecord);
	                    	var storedata=store.getAt(row);
	                    	var commonForm = this.getEnquirytabstructure().getForm();
	                    	var commonVal = commonForm.getValues();
	                    	var date = commonVal.enquiryDate;
                         	if (grid.getSelectionModel().getCount() > 0) {
	                    		var selectedRecords = grid.getSelectionModel().getSelection(), tempArray = new Array();
		                    	for(var i=0; i<selectedRecords.length; i++){
		                    		if(selectedRecords[i].data.status === "Open"){
		                    			tempArray.push(selectedRecords[i]);
		                    		}
		                    	}
		                    	if(tempArray.length === 0 || tempArray.length === selectedRecords.length){
		                    		this.showFormWindow();
		                    		var form = this.getClosuredetailForm();
			                    	if(!isNullOrEmpty(date)){
			                    		form.getForm().findField('closureDate').setMinValue(date);
			                    	}
		                    		var records = grid.getSelectionModel().getSelection();
		                            		
		                    		var addstore=form.down('#applicationCmp').getStore();
		                    			
//		               
		                    		if(!isNullOrEmpty(records[0]) && !isNullOrEmpty(records[0].get('enquiryStudentDetail')))
		                    			{
		                    					if(!isNullOrEmpty(records[0].get('enquiryStudentDetail').id)){
		                    					addstore.getProxy().extraParams = 
		                    					{
			                    			enquiryStudentDetailid: records[0].get('enquiryStudentDetail').id
		                    					};
		                    			      }
                                             
		                    				}
		            
		                    		/*if (records != undefined && records != "" && records != null) {
	                    				form.loadRecord(records[0]);
		                    		}*/
		                    		form.getForm().findField('closureDate').setValue(new Date());
		                    		var ids = records[0].get('id');
		                    		var status=storedata.data.status;
		                    		this.showAndHideReasons(status);
	                    		}
		                    	else{
		                    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_OPEN_OR_CLOSE'));
		                    	}
	                    	} else {
	                    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
	                    	}
	                    },
	                    deleteFormWindow : function(){
	                    	alert('under construction');
	                    },
	                    viewFormWindow : function(){
	                    	this.editFormWindow();
	                    	var form =this.getClosuredetailform();
	                    	if (form) {
	                    		form.down('#closureform_submitbuttonId').setVisible(false);
	                    		form = form.getForm();
	                    		toggleReadOnlyFormItems(form, true);
	                    	}
	                    },
	                    cancelClosureDetail : function(){
	                    	var form = this.getClosuredetailform();	
	                    	form.close();
	                    },
	                    saveClosureDetail : function(h){
	                    	var $this = this;
	                    	var form = $this.getClosuredetailForm().getForm();	
	                    	var commonForm = $this.getEnquirytabstructure().getForm();
	                    	var grid =  Ext.getCmp('closuredetail_grid');
	                    	var closureDetailForOtherAcademyGrid =  Ext.getCmp('closuredetailforotherEnqType_grid'); 
	                    	
	                    	var commonVal = commonForm.getValues();
	                    	var enquiryId = commonVal.enqId;
	                    	var studentDetailId = commonVal.studentDetailId;  
	                    	var value = form.getValues();
	                    	if(!isNullOrEmpty(value.applicationId)){
	                    		var applicationId = $this.getIdValueJson(value.applicationId.id);
	                    	}

	                    	var closureDetails = new Array();
	                    	var selectedRecords = grid.getSelectionModel().getSelection();
	                    	for(var i=0; i<selectedRecords.length; i++){
	                    		var closureModel = new Academia.model.enquiry.closure.ClosureSubmitModel();
	                    		//closureModel.set("id",value.id);
	                    		closureModel.set("enquiry",$this.getIdValueJson(enquiryId));
	                    		closureModel.set("closureReason",$this.getIdValueJson(value.closureReason));
	                    		closureModel.set("enquiryStudentDetailId",studentDetailId);
	                    		closureModel.set("admissionEnqDetailsId",selectedRecords[i].data.id);
	                    		closureModel.set("closureDate",value.closureDate);
	                    		closureModel.set("reasonRemark",value.closureRemarks);
	                    		closureModel.set("whetherDeleted","false");
	                    		if(!isNullOrEmpty(value.applicationId)){
                                    closureModel.set("application",value.applicationId);
                                }
	                    		closureDetails.push(closureModel.data);
	                    	}

	                    	

	                    	var reopenDetails = new Array();
	                    	for(var j=0; j<selectedRecords.length; j++){
	                    		var reopenModel = new Academia.model.enquiry.closure.ReopenSubmitModel();
	                    		//reopenModel.set("id",value.id);
	                    		reopenModel.set("enquiry",$this.getIdValueJson(enquiryId));
	                    		reopenModel.set("reOpenReason",$this.getIdValueJson(value.reopenReason));
	                    		reopenModel.set("enquiryStudentDetailId",studentDetailId);
	                    		reopenModel.set("admissionEnqDetailsId",selectedRecords[j].data.id);
	                    		reopenModel.set("reopenDate",value.reopenDate);
	                    		reopenModel.set("reasonRemark",value.reopenRemarks);
	                    		reopenModel.set("whetherDeleted","false");
	                    		
	                    		reopenDetails.push(reopenModel.data);
	                    	}
                            var submitData =null;
                            var grdStore =null;
                            /**
                             * Use different url according to the grid of enquiry type. 
                             */
                            if(!grid.isHidden()){	
                            	grdStore= grid.getStore();
	                    		if(value.programExam==0){
	                    			submitData= Ext.encode(closureDetails);//Ext.encode(closureModel.data);
		                    		submitUrl = SERVERURL.ENQUIRY_CLOSURE_CREATE;
		                    	}else{
		                    		submitData = Ext.encode(reopenDetails);//Ext.encode(reopenModel.data);
		                    		submitUrl = SERVERURL.ENQUIRY_REOPEN_CREATE;
		                    	}
	                    	}else{
	                    		 grdStore = closureDetailForOtherAcademyGrid.getStore();
	                    		if(value.programExam==0){
		                    		submitData = {
		                    			    "enquiry": {
		                    			        "id": parseInt(enquiryId)
		                    			    },
		                    			    "closureReason": {
		                    			        "id": value.closureReason
		                    			    },
		                    			    "closureDate": value.closureDate,
		                    			    "reasonRemark": value.closureRemarks,
		                    			    "whetherDeleted": "false"
		                    			};
		                    		submitUrl = SERVERURL.CLOSURE_DETAIL_FOR_OTHER_ENQUIRY_TYPE_CLOSER_CREATE_URL;
		                    	}else{
		                    		submitData = {
		                    			    "enquiry": {
		                    			        "id": parseInt(enquiryId)
		                    			    },
		                    			    "reOpenReason": {
		                    			        "id":value.reopenReason
		                    			    },
		                    			    "reopenDate": value.reopenDate,
		                    			    "reasonRemark": value.reopenRemarks,
		                    			    "whetherDeleted": "false"
		                    			};
		                    		submitUrl = SERVERURL.CLOSURE_DETAIL_FOR_OTHER_ENQUIRY_TYPE_REOPEN_CREATE_URL;
		                    	}
	                    	}
                            
	                    	Ext.Ajax.request({
	                    		method: "POST",
	                    		type:'rest',
	                    		url: submitUrl,
	                    		jsonData: submitData,
	                    		headers: {
	    							'Content-Type': 'application/json'
	    						},
	    						scope:this,
	                    		success: function(response) {
	                    			grid.getSelectionModel().deselectAll();
	                    			grdStore.reload();
	                    			$this.cancelClosureDetail();
	                    			if(value.programExam==0){
	                    				Ext.getCmp('dispalyEnquiryStatus').setValue(getCommonTranslation('CLOSE'));
	                    			}else{
	                    				Ext.getCmp('dispalyEnquiryStatus').setValue(getCommonTranslation('OPEN'));
	                    			}
	                    			showSuccessMessage(getCommonTranslation('CLOSURE_TITLE'),getCommonTranslation('SUCCESS'));
	                    		}
	                    	});
	                    },
	                    onClosureFormRender : function(){
	                    	var commonForm = this.getEnquirytabstructure().getForm();
	                    	var commonVal = commonForm.getValues();
	                    	var studentDetailId = commonVal.studentDetailId;  
	                    	
	                    	var closureDetailGrid = this.getClosuredetailgrid();
                                 closureDetailGrid.setVisible(false);
                                 /**
                                  * here id is to fetch grid to hide and show grid.
                                  */
                            var closureDetailForOtherAcademyGrid =  Ext.getCmp('closuredetailforotherEnqType_grid').hide();
                                 closureDetailForOtherAcademyGrid.setVisible(false);
                                 var enqThroughStaffTarget = commonForm.findField('forEnquiryStaffTargetFlag').getValue();
                             if(enqThroughStaffTarget){
                            	 closureDetailForOtherAcademyGrid.show();
                            	 var store = closureDetailForOtherAcademyGrid.getStore();
	       	                    	 store.getProxy().extraParams = {
	       	                    		id: commonVal.enqId
	       	                    	  };
	       	                    	 store.load();
                             }else{
                            	 if(commonVal.enqTypes!="Admission"){
                                	 closureDetailForOtherAcademyGrid.show();
                                	 var store = closureDetailForOtherAcademyGrid.getStore();
    	       	                    	 store.getProxy().extraParams = {
    	       	                    		id: commonVal.enqId
    	       	                    	  };
    	       	                    	 store.load();
                                 }else{
                                	 closureDetailGrid.setVisible(true);
          	                    	var store = closureDetailGrid.getStore();
    	      	                    	store.getProxy().extraParams = {
    	      	                    		id: studentDetailId
    	      	                    	};
    	      	                    	store.load();
                                 }	 
                             }    
                                 
                             
	                    },
	                    getIdValueJson: function(id, value) {
	                    	if (id) return {
	                    		id: id,
	                    		value: value
	                    	};
	                    },
	                            
});
