/**
 *  @author Ravi Choudhary
 */
Ext.define('Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['enquiry.enquiryDetail.EnquiryDetailModel'],
	stores: ['enquiry.EnquirySourceStore', 'enquiry.EnquiryRegisteredBy','common.CountryStore',
	         'enquiry.EnquiryModeStore','common.ProgramByAcAndLoIdStore','enquiry.AcademicBatchStore',
	         'enquiry.ProgramBatchSeatTypeStore','program.programDetails.programBatches.PrimaryAcademicStore',
	         'organization.academylocations.AcademicTenureStore','enquiry.enquiryDetail.EnquiryDetailStore',
	         'campaignnew.ModeOfDeliveryStore','campaignnew.RegistrationTypeStore','enquiry.EnquiryTypeCounsellingStore','common.ModeOfDeliveryStore',
	         'common.RegistrationTypeStore','campaignnew.CampaignSchoolNameStore','enquiry.EnquiryCurrentGradeStore',
	         'enquiry.EnqStudSchoolSubject','Academia.store.common.IntakeYearStore','common.ExamBoardStore','enquiry.FinanceModeStore'],
	views: ['enquiry.enquirydetail.EnquiryDetailStructure','enquiry.enquirydetail.EnquiryDetailFormRevamp',
	        'enquiry.TrackEnquiryStructure','enquiry.dashboard.EnquiryGridsForPendingEnquiryDashboard',
	        'enquiry.TrackEnquiryForm','enquiry.EnquiryMulProgramForm'],

	        alias: "widget.enquirydetailrevampcontroller",
	        refs: [{
	        	ref:'trackenquirygrid', 
	        	selector:'trackenquirygrid'
	        },{
	        	ref:'searchresultgrid',
	        	selector:'searchresultgrid[itemId=trackenquirygrid]'
	        },{
	        	ref:'trackcorporateenquirygrid',
	        	selector:'searchresultgrid[itemId=trackcorporateenquirygrid]'
	        },{
	        	ref: 'enquirydetailformrevamp',
	        	selector: 'enquirydetailformrevamp'
	        }, {
	        	ref: 'enquirytabstructure',
	        	selector: 'enquirytabstructure'
	        }, {
	        	ref: 'enquirygridsforpendingenquirydashboard',
	        	selector: 'enquirygridsforpendingenquirydashboard'
	        },{
	        	ref:'tracknonadmissionenquirygrid',
	        	selector:'searchresultgrid[itemId=tracknonadmissionenquirygrid]'
	        },{
	        	ref:'trackenquiryform',
	        	selector:'trackenquiryform'
	        },{
          	  ref: 'enquiryMulProgramFormEdit',
        	  selector: 'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId]'
          },{
        	  ref: 'enquirydetailstructure',
        	  selector: 'enquirydetailstructure'
          }, {
        	  ref: 'enquirymulprogramform',
        	  selector: 'enquirymulprogramform'
          }],

	        init: function() {

	        	this.control({
	        		'enquirydetailformrevamp button[itemId=enquirydetail_SubmitButtonId]': {
	        			click: function(f) {
	        				var form = f.ownerCt.ownerCt.getForm();
	        				var val = form.getValues();
	        				var referId = val.referredType;
	        				var comment= val.remark;
	        				var checkBlank=form.findField('remark');
	        				if(checkBlank.allowBlank){
	        					this.saveEnquiryDetail(f);
	        				}else{
	        					var x=comment.trim();
	        					if(x==''){
	        						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ADMISSION_ENQUIRY_COMMENT'));
	        					}
	        					else{
	        						this.saveEnquiryDetail(f);
	        					}  	
	        				}
	        			}
	        		},
	        		/*'enquirydetailformrevamp button[itemId=enquirydetail_EditButtonId]': {
                click: this.editEnquiryDetail
            },*/

	        		'enquirydetailformrevamp': {
	        			render: function(f) {
	        				this.onFormRender(f);
	        			}
	        		},
	        		
	        		'enquirydetailformrevamp customcombobox#educationDepartmentItemId': {
	        			select: function(obj, record){
	        				var educationDepartmentId = record[0].get("id");
	        				var form = obj.up('form');
	        				var campaignSchoolCombo = form.down("#campaignSchool");
	        				var campaignSchoolStore = campaignSchoolCombo.getStore();

	        				var isEducationDeptOthers = false;
	        				var educationDepartmentCombo = form.down("#educationDepartmentItemId");

	        				if( !isNullOrEmpty(educationDepartmentCombo) && !isNullOrEmpty(educationDepartmentCombo.getValue()) ) {
	        					if( educationDepartmentCombo.getRawValue() == 'Others' ){
	        						isEducationDeptOthers = true;
	        					}
	        					campaignSchoolStore.getProxy().extraParams.educationDepartmentId = educationDepartmentId;
	        					campaignSchoolStore.getProxy().extraParams.isEducationDeptOthers = isEducationDeptOthers;
	        				}

	        				campaignSchoolStore.removeAll();
	        				campaignSchoolCombo.reset();

	        				campaignSchoolStore.load();

	        			} 
          		  },

	        		'enquirytabstructure textfield[itemId=enquiryTxtId]' : {
	        			blur : function(obj) {
	        				var $this = this;
	        				var structFilter = $this.getEnquirytabstructure().getForm();
	        				var defaultText=structFilter.findField("enquiryTxtId").getValue();
	        				if(!isNullOrEmpty(Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0])){
	        					//Unique check here
	        					if(!isNullOrEmpty(Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue())){
	        						if(structFilter.findField("enquiryTxtId").getValue()!=Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue()){
	        							var editUrl = SERVERURL.FIND_ENQUIRY_CODE_UNIQUENESS;
	        							Ext.Ajax.request({
	        								method: "GET",
	        								type: 'rest',
	        								url: editUrl,
	        								params: {
	        									code: Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue()
	        								},
	        								success: function(response, action) {
	        									var receiptData = Ext.JSON.decode(response.responseText);
	        									if(receiptData==false){
	        										if (!isNullOrEmpty(Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0])) {
														Ext.ComponentQuery
																.query('textfield[itemId=enquiryTxtId]')[0]
																.setValue(defaultText);
													}
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENQUIRY_UNIQUE_CHECK_ERROR_MSG'));
	        									}
	        								}
	        							})
	        						}
	        					}else{
	        						if (!isNullOrEmpty(Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0])) {
										Ext.ComponentQuery
												.query('textfield[itemId=enquiryTxtId]')[0]
												.setValue(defaultText);
									}
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENQUIRY_UNIQUE_CHECK_ERROR_MSG'));
	        					}
	        				}
	        			}
	        		},

	        		'enquirydetailformrevamp customcombobox#country': {
	        			select: function(obj, record) {
  	        				var form = obj.up('form');
  	        				form.down('#genericFieldId1').clearValue();
  	        				form.down('#genericFieldId1').setDisabled(false);
  	        				form.down('#city').clearValue();
  	        				form.down('#city').setDisabled(true);
  	        				var countryId = record[0].get("id");
  	        				if (countryId > 0) {
  	        					var store = form.down('#genericFieldId1').getStore();
  	        					store.getProxy().extraParams = {
  	        						cid: countryId
  	        					};
  	        					store.load();
  	        				}
  	        				form.getForm().checkValidity();
	        			}
	        		},
	        		'enquirydetailformrevamp customcombobox#genericFieldId1':{
	        			select:function(obj,rec){
  	        				var form = obj.up('form');
  	        				form.down('#city').clearValue();
  	        				form.down('#city').setDisabled(false);
  	        				var countryRegionId=rec[0].data.id;
  	        				var store = form.down('#city').getStore();
  	        				store.getProxy().extraParams = {
  	        					id: countryRegionId
  	        				};
  	        				store.load();
  	        				form.getForm().checkValidity();
	        			}
	        		},
	        		'enquirydetailformrevamp customcombobox#referredType': {
	        			select: function(obj, record) {
	        				var form=obj.up('form').getForm();
	        				var refUserNameField=form.findField('refUserName');
	        				var refrredNameField = form.findField("referrerName");
	        				refrredNameField.reset();
	        				refrredNameField.setVisible(false);
	        				var refType = record[0].get("value");

	        				if (refType != 'None') {
	        					if(refType == 'Others'){
	        					refUserNameField.setVisible(true);
	        					refUserNameField.setDisabled(false);
	        					refUserNameField.allowBlank = false;
	        					
	        					refrredNameField.setVisible(false);
	        					refrredNameField.allowBlank = true;
	        					}else{
	        					refrredNameField.setVisible(true);
	        					refrredNameField.allowBlank = false;
	        					
	        					refUserNameField.setVisible(false);
	        					refUserNameField.allowBlank = true;
	        					refUserNameField.reset();
	        					}
	        				} else {
	        					refrredNameField.allowBlank = true;
	        					refUserNameField.setVisible(false);
	        					refUserNameField.allowBlank = true;
	        					refUserNameField.reset();
	        				}
	        				var store = this.getStore('enquiry.ReferredIdStore');
	        				store.getProxy().extraParams = {
	        					refTypeId:record[0].data.id
	        				};
	        				store.load();
	        				form.isValid();
	        			}
	        		},
	        		/*'enquirydetailformrevamp customcombobox[name=campaign]': {
	        			render: function(obj){
	        				var campaignStore = obj.getStore();
	        				campaignStore.load();
	        			}
	        		},*/
	        		'enquirydetailformrevamp customcombobox#enquiryCampaign': {
	        			render: function(obj){
	        				var campaignNewStore = obj.getStore();
	        				campaignNewStore.getProxy().extraParams = {
	        					academyLocationIds: this.getCurrentAcademyLocation()
	        				};
	        				campaignNewStore.load();
	        			},
	        			select: function(obj, record){
	        				var form = this.getEnquirydetailformrevamp();
	        				var campaignId = record[0].get("id");
	        				var schoolPriorityField = form.down("#schoolPriority");
            				var newSchoolPriorityField = form.down("#schoolPriorityNew");
            				schoolPriorityField.reset();
            				newSchoolPriorityField.reset();
            				schoolPriorityField.setVisible(true);
            				newSchoolPriorityField.setVisible(false);
            				this.loadDFRForSchoolPriority(schoolPriorityField);
	        				this.selectNewCampaignField(obj, campaignId);
	        			}
	        		},
	        		'enquirydetailformrevamp customcombobox#campaignSchool': {
	        			select: function(obj, record){
	        				var form = this.getEnquirydetailformrevamp();
	        				var campaignNewId = record[0].get("campaignId");
	        				var campaignSchoolId = record[0].get("schoolId");
	        				var newSchoolPriorityField = form.down("#schoolPriorityNew");
	        				newSchoolPriorityField.setDisabled(false);
	        				this.selectCampaignSchoolField(obj, campaignNewId, campaignSchoolId);
	        			}
	        		},
	        		'enquirydetailformrevamp combo[itemId=enquiryDetail_enquiryType]': {
	                    change: function(combo, record) {
	                        var me = this;
	                        var enquiryForm = combo.up('enquirydetailformrevamp');
	                        var id = combo.getValue(); // record[0].get('name');
	                        var store = combo.getStore().findRecord('id',id);
	                        var selectedApplicationType = store.data.code;
	                        if (!isNullOrEmpty(selectedApplicationType)) {
	                            me.showHideEnquiryMulProgramFormEditWindow(selectedApplicationType, enquiryForm);
	                            var enquiryProgramForm=me.getEnquiryMulProgramFormEdit();
	                        }
	                    }
	                },
	                'enquirydetailformrevamp customcombobox#enquiryDetail_cellCountrycode': {
	                    select: function(rowModel, record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                    	var countryCodeField = form.down("#enquiryDetail_cellCountrycode");
	                     	var mobileField = form.down("#enquiryDetail_cellNumber");
	                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                    }
	                },
	                'enquirydetailformrevamp customcombobox#enquiryDetail_enquirySource': {
	                    select: function(rowModel, record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                    	var sourceOther = form.down("#enquiryDetail_enquirySourceOther");
	                    	if(record[0].data.value.toLowerCase()=='other' || record[0].data.value.toLowerCase()=='others'){
	                    		sourceOther.setVisible(true);
	                    		this.loadDFRForsourceOther(sourceOther);
	                    	}
	                    	else{
	                    		sourceOther.reset();
	                    		sourceOther.setVisible(false);
	                    	}
	                    }
	                },
	                'enquirydetailformrevamp numberfield#enquiryDetail_cellNumber': {
	                    change: function(record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                     	var mobileField = form.down("#enquiryDetail_cellNumber");
	                     	mobileField.isValid();
	            			form.getForm().checkValidity();
	                    }
	                },
	                'enquirydetailformrevamp customcombobox#enquiryDetail_alternateCellCountrycode': {
	                    select: function(rowModel, record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                    	var countryCodeField = form.down("#enquiryDetail_alternateCellCountrycode");
	                     	var mobileField = form.down("#enquiryDetail_alternateCellNumberField");
	                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                    }
	                },
	                'enquirydetailformrevamp numberfield#enquiryDetail_alternateCellNumber': {
	                    change: function(record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                     	var mobileField = form.down("#enquiryDetail_alternateCellNumber");
	            			form.getForm().checkValidity();
	                    }
	                },
	                'enquirydetailformrevamp customcombobox#enQStdCountryCodeItemId': {
	                    select: function(rowModel, record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                    	var countryCodeField = form.down("#enQStdCountryCodeItemId");
	                     	var mobileField = form.down("#enQStdMobileNumberItemId");
	                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                    }
	                },
	                'enquirydetailformrevamp numberfield#enQStdMobileNumberItemId': {
	                    change: function(record) {
	                    	var this$ = this;
	                    	var form = this$.getEnquirydetailformrevamp();
	                     	var mobileField = form.down("#enQStdMobileNumberItemId");
	                     	mobileField.isValid();
	            			form.getForm().checkValidity();
	                    }
	                },
	                'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] button[itemId=enquiryMulProSubmitBtnId]': {
          			  click: function() {
        				  this.saveEnqMulProgGridData();
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] button[itemId=enquiryMulProCancelBtnId]': {
        			  click: function() {
        				  this.closeEnqMulProgWindow();
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId]': {
        		   close:function(obj){
        			    this.closeEnqMulProgWindowSetValue();
         			 }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] customcombobox#academyLocationId': {
        			  select: function(obj, record) {
        				  this.resetDropDownFields('ACADEMYLOCATION',obj.up('form'));
        				  var programComboField = obj.up('form').down('#programId');
        				  var academyLocationField = obj.up('form').down('#academyLocationId');
        				  var modeOfDelivery = obj.up('form').down('#modeDeliveryId');
        				  var registrationTypeEnum = obj.up('form').down('#registrationTypeId');
        				  var alValue = academyLocationField.getValue();
        				  programComboField.reset();
        				  programComboField.getStore().getProxy().extraParams = {
        					  academyLocationIds:alValue,
        					  isOtherBlankProgramRequired:false
        				  }
        				  if(!isNullOrEmpty(modeOfDelivery.getValue()) ){
        					  programComboField.getStore().getProxy().extraParams.modeOfDeliveryId = modeOfDelivery.getValue();
        				  }
        				  if(!isNullOrEmpty(registrationTypeEnum.getValue()) ){
        					  if(registrationTypeEnum.getValue()=='PART_TIME'){
        						  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = true;  
        					  }else if(registrationTypeEnum.getValue()=='FULL_TIME'){
        						  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = false;
        					  }
        				  }
        				  programComboField.getStore().load();

        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] customcombobox#registrationTypeId': {
        			  select: function(obj, record) {
        				  var programComboField = obj.up('form').down('#programId');
        				  var academyLocationField = obj.up('form').down('#academyLocationId');
        				  var modeOfDelivery = obj.up('form').down('#modeDeliveryId');
        				  var alValue = academyLocationField.getValue();
        				  programComboField.reset();
        				  programComboField.getStore().getProxy().extraParams = {
        					  academyLocationIds:alValue,
        					  isOtherBlankProgramRequired:false
        				  }
        				  var registrationTypeId = obj;
        				  if(!isNullOrEmpty(modeOfDelivery.getValue()) ){
        					  programComboField.getStore().getProxy().extraParams.modeOfDeliveryId = modeOfDelivery.getValue();
        				  }
        				  if(!isNullOrEmpty(registrationTypeId.getValue()) ){
        					  var registrationTypeEnum = registrationTypeId;
        					  if(!isNullOrEmpty(registrationTypeEnum.getValue()) ){
            					  if(registrationTypeEnum.getValue()=='PART_TIME'){
            						  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = true;  
            					  }else if(registrationTypeEnum.getValue()=='FULL_TIME'){
            						  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = false;
            					  }
            				  }
        				  }
        				  programComboField.getStore().load();
        				  var batchCombo = obj.up("form").down("#batchId");
                          batchCombo.reset();
                          batchCombo.setDisabled(true);
                          var seatTypeCombo = obj.up("form").down("#seatTypeId");
                          seatTypeCombo.reset();
                          seatTypeCombo.setDisabled(true);
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] customcombobox#modeDeliveryId': {
        			  select: function(obj, record) {
        				  var programComboField = obj.up('form').down('#programId');
        				  var academyLocationField = obj.up('form').down('#academyLocationId');
        				  var registrationTypeEnum = obj.up('form').down('#registrationTypeId');
        				  var alValue = academyLocationField.getValue();
        				  programComboField.reset();
        				  programComboField.getStore().getProxy().extraParams = {
        					  academyLocationIds:alValue,
        					  isOtherBlankProgramRequired:true 	
        				  }
        				  var modeOfDelivery = obj;
        				  if(!isNullOrEmpty(modeOfDelivery.getValue()) ){
        					  programComboField.getStore().getProxy().extraParams.modeOfDeliveryId = modeOfDelivery.getValue();
        				  }
        				  if(!isNullOrEmpty(registrationTypeEnum.getValue()) ){
        					  if(registrationTypeEnum.getValue()=='PART_TIME'){
        						  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = true;  
        					  }else if(registrationTypeEnum.getValue()=='FULL_TIME'){
        						  programComboField.getStore().getProxy().extraParams.registrationTypeEnum = false;
        					  }
        				  }
        				  programComboField.getStore().load();
        				  var batchCombo = obj.up("form").down("#batchId");
        				  batchCombo.reset();
        				  batchCombo.setDisabled(true);
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] customcombobox#programId': {
        			  select: function(obj, record) {
        				  this.resetDropDownFields('PROGRAM',obj.up('form'));
        				  var batchCombo = obj.up('form').down('#batchId');
        				  var registrationTypeEnum = obj.up('form').down('#registrationTypeId');
        				  var batchCombo = obj.up('form').down('#batchId');
        				  var seatTypeCombo = obj.up('form').down('#seatTypeId');
        				  var fieldOfInterest = obj.up('form').down('#fieldOfInterest');
        				  var modeOfDelivery = obj.up('form').down('#modeDeliveryId');
        				  batchCombo.setDisabled(true);
        				  batchCombo.reset();
        				  seatTypeCombo.setDisabled(true);
        				  seatTypeCombo.reset();
        				  fieldOfInterest.setDisabled(true);
        				  fieldOfInterest.reset();
        				  var programId = record[0].get("id");
        				  if (programId > 0) {
        					  batchCombo.setDisabled(false);
        					  var store = batchCombo.getStore('enquiry.AcademicBatchStore');
        					  store.getProxy().extraParams = {
        						  id: programId,
        						  enquiryEnable:true
        					  };
							 if(!isNullOrEmpty(registrationTypeEnum) && !isNullOrEmpty(registrationTypeEnum.getValue()) ){
            					  if(registrationTypeEnum.getValue()=='PART_TIME'){
            						  store.getProxy().extraParams.batchPartTime = true;  
            					  }else if(registrationTypeEnum.getValue()=='FULL_TIME'){
            						  store.getProxy().extraParams.batchPartTime = false;
            					  }
            				  }
												
							if(!isNullOrEmpty(modeOfDelivery) && !isNullOrEmpty(modeOfDelivery.getValue())){
            					  store.getProxy().extraParams.modeOfDeliveryId = modeOfDelivery.getValue();
            				  }
        					  store.load({
           						 callback: function(records, operation, success) {
           							 if (success) {
           								 if(records.length == 1){
           									 batchCombo.setValue(records[0].data.id);
           									 batchCombo.fireEvent('select',batchCombo,records);
           								 }	
           							 }
           						 }
           					  });
        				  }
        				  if( programId == 0 ){
    						  fieldOfInterest.setDisabled(false);
    					  }
        			  },
        			  afterrender: function(obj){
        				  var task = new Ext.util.DelayedTask(function(){
        					  var registrationTypeEnum = obj.up('form').down('#registrationTypeId');
        					  if(!isNullOrEmpty(registrationTypeEnum) && !isNullOrEmpty(registrationTypeEnum.getValue()) ){
            					  if(registrationTypeEnum.getValue()=='PART_TIME'){
            						  obj.getStore().getProxy().extraParams.registrationTypeEnum = true;  
            					  }else if(registrationTypeEnum.getValue()=='FULL_TIME'){
            						  obj.getStore().getProxy().extraParams.registrationTypeEnum = false;
            					  }
            				  }
            				  var modeDeliveryCombo = obj.up('form').down('#modeDeliveryId');
            				  if(!isNullOrEmpty(modeDeliveryCombo.getValue())){
            					  obj.getStore().getProxy().extraParams.modeOfDeliveryId = modeDeliveryCombo.getValue();
            				  }
        				  });
        				  task.delay(500);
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] customcombobox#batchId': {
        			  select: function(obj, record) {
        				  this.resetDropDownFields('BATCH',obj.up('form'));
        				  var seatCombo = obj.up('form').down('#seatTypeId');
        				  
        				  var batchId = record[0].get("id");
        				  if (batchId > 0) {
        					  var store = this.getStore('enquiry.ProgramBatchSeatTypeStore');
        					  store.getProxy().extraParams = {
        						  id: batchId,
        						  enquiryEnable:true
        						  
        					  };
        					  store.load({
           						 callback: function(records, operation, success) {
           							 if (success) {
           								 if(records.length == 1){
           									 seatCombo.setValue(records[0].data.id);
           								 }	
           							 }
           						 }
           					  });
        				  }
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] nestedJsonCombo[itemId=examBoardItemId]': {
        			  change: function(combo) {
        				var this$ = this;
                  		var id = combo.getValue();
                  		var examBoardOther = null;
                  		var value = combo.getRawValue();
                  		
                  		var form = combo.up('form');
                       	var enqStudentSubject = form.down("#enquiryStudentSchoolSubjectItemId");
                       	var store = enqStudentSubject.getStore();
                       	
                  		if(value == 'Others'){
                  			examBoardOther = true ;
                  		}else{
                  			examBoardOther = false ; 
                  		}
                  		store.getProxy().extraParams = {
                  			id:id ,
                  			examBoardOther:examBoardOther
                  		};
                  		store.load();
        			  },
        			  select: function(combo) {
        				  	var this$ = this;
                      		var form = combo.up('form');
                           	var enqStudentSubject = form.down("#enquiryStudentSchoolSubjectItemId");
                           	enqStudentSubject.reset();
                           	var formValidity = combo.up('form');
                           	formValidity.getForm().checkValidity();
        			  }
        		  },
        		  'enquirymulprogramform[itemId=enquiryMulProgramFormEditItemId] multiselectcombofield[itemId=enquiryStudentSchoolSubjectItemId]': {
            		  afterrender: function(combo) {
            			  var this$ = this;
            			  var form = combo.up('form');
                          if(form.down("#examBoardItemId").getValue()==null){
                              var store = combo.getStore();
                              store.getProxy().extraParams = {
                                  id: null,
                                  examBoardOther:null
                              };
                          }
                          store.load();
                      }
        	  	   },
         		 'enquirytabstructure tabpanel tab':{
         			 activate: function(tab){
         				 var tab = tab.up('tabpanel').getActiveTab();
         				 if(tab.isReloadTabRequire){
         					 if(tab.down('studentdetailform')){
         						var getForm = tab.down('form');
            					 getForm.fireEvent('render',getForm) ;
         					 }else if(tab.down('admissionreqmntdetailgrid')){
         						var getItems = tab.down('admissionreqmntdetailgrid');
         						var getStructure = getItems.up('admissionreqmntstructure');
         						getStructure.fireEvent('render',getStructure); 
         						getItems.fireEvent('render',getItems); 
         					 }else{
         						if(!Ext.app.checkVelocity){
         						var getItems = tab.down('educationdetailgrid');
         						var getStructure = getItems.up('educationdetailstructure');
         						getStructure.fireEvent('render',getStructure); 
         						getItems.fireEvent('render',getItems); 
         						}	
         					 }
         					 tab.isReloadTabRequire=false;
         				 }
         				 
         				 
         			 }
     				},
          		  'enquirydetailformrevamp radiogroup[itemId=enQSD_radioBtn_orgSiblling]':{
        			  change:function(radioGroup){
        				  this.checkEnqOrgSiblling(radioGroup);
        			  }
        		  },
        		  'enquirydetailformrevamp customcombobox[name=sibilingUser1]':{
        			  afterrender: function(combo){
        				  var me = this;
        				  combo.getStore().on('load',function(){
        					  var sform = me.getEnquirydetailformrevamp();
        					  var combo1 = sform.down('[name=sibilingUser1]');
        					  var combo2 = sform.down('[name=sibilingUser2]');
        					  var combo3 = sform.down('[name=sibilingUser3]');
        					  
        					  combo1.getStore().clearFilter();
        					  if(!isNullOrEmpty(combo2.getValue()) && !isNullOrEmpty(combo3.getValue())){
        						  combo1.getStore().filterBy(function(record, id){
        							  return (record.get('id') != combo2.getValue() && record.get('id') != combo3.getValue());
        						  });
        					  }
        					  else if(!isNullOrEmpty(combo2.getValue())){
        						  combo1.getStore().filterBy(function(record, id){
        							  return record.get('id') != combo2.getValue();
        						  });
        					  }
        					  else if(!isNullOrEmpty(combo3.getValue())){
        						  combo1.getStore().filterBy(function(record, id){
        							  return record.get('id') != combo3.getValue();
        						  });
        					  }
        					  combo1.lastQuery = null;
        				  });
        			  },
        			  render: function(combo){
                    		combo.getStore().getProxy().extraParams = { 
                        		 isMultiAccessAllowForSibiling:true
            				  };
                         }
        		  },
        		  'enquirydetailformrevamp customcombobox[name=sibilingUser2]':{
        			  afterrender: function(combo){
        				  var me = this;
        				  combo.getStore().on('load',function(){
        					  var sform = me.getEnquirydetailformrevamp();
        					  var combo1 = sform.down('[name=sibilingUser1]');
        					  var combo2 = sform.down('[name=sibilingUser2]');
        					  var combo3 = sform.down('[name=sibilingUser3]');
        					  
        					  combo2.getStore().clearFilter();
        					  if(!isNullOrEmpty(combo1.getValue()) && !isNullOrEmpty(combo3.getValue())){
        						  combo2.getStore().filterBy(function(record, id){
        							  return (record.get('id') != combo1.getValue() && record.get('id') != combo3.getValue());
        						  });
        					  }
        					  else if(!isNullOrEmpty(combo1.getValue())){
        						  combo2.getStore().filterBy(function(record, id){
        							  return record.get('id') != combo1.getValue();
        						  });
        					  }
        					  else if(!isNullOrEmpty(combo3.getValue())){
        						  combo2.getStore().filterBy(function(record, id){
        							  return record.get('id') != combo3.getValue();
        						  });
        					  }
        					  combo2.lastQuery = null;
        				  });
        			  },
        			  render: function(combo){
                  		combo.getStore().getProxy().extraParams = { 
                      		 isMultiAccessAllowForSibiling:true
          				  };
                       }
        		  },
        		  'enquirydetailformrevamp customcombobox[name=sibilingUser3]':{
        			  afterrender: function(combo){
        				  var me = this;
        				  combo.getStore().on('load',function(){
        					  var sform = me.getEnquirydetailformrevamp();
        					  var combo1 = sform.down('[name=sibilingUser1]');
        					  var combo2 = sform.down('[name=sibilingUser2]');
        					  var combo3 = sform.down('[name=sibilingUser3]');
        					  
        					  combo3.getStore().clearFilter();
        					  if(!isNullOrEmpty(combo1.getValue()) && !isNullOrEmpty(combo2.getValue())){
        						  combo3.getStore().filterBy(function(record, id){
        							  return (record.get('id') != combo1.getValue() && record.get('id') != combo2.getValue());
        						  });
        					  }
        					  else if(!isNullOrEmpty(combo1.getValue())){
        						  combo3.getStore().filterBy(function(record, id){
        							  return record.get('id') != combo1.getValue();
        						  });
        					  }
        					  else if(!isNullOrEmpty(combo2.getValue())){
        						  combo3.getStore().filterBy(function(record, id){
        							  return record.get('id') != combo2.getValue();
        						  });
        					  }
        					  combo3.lastQuery = null;
        				  });
        			  },
        			  render: function(combo){
                  		combo.getStore().getProxy().extraParams = { 
                      		 isMultiAccessAllowForSibiling:true
          				  };
                       }
        		  },
        		  'enquirydetailstructure': {
          			render:function(structure){
          				var $this = this
          				structure.body.on('click', function() {
          					var form = structure.down('enquirydetailformrevamp');
          					//$this.hideInvalidIconFromField(form);
          			       });
          			}
          		}
          		});
	        	this.callParent(arguments);
	        },
	        selectCampaignSchoolField: function(obj, campaignNewId, campaignSchoolId, enquiryId, enquiryAcademyLocationId){
	        	var form = obj.up('form');
	        	var schoolPriorityField = form.down("#schoolPriority");
	        	var url='';
	        	var educationDepartmentId = null;
	        	var isEducationDeptOthers = false;
	        	var educationDepartmentCombo = form.down("#educationDepartmentItemId");
	        	
	        	if( !isNullOrEmpty(educationDepartmentCombo) && !isNullOrEmpty(educationDepartmentCombo.getValue()) ) {
	        		educationDepartmentId = educationDepartmentCombo.getValue();
	        		if( educationDepartmentCombo.getRawValue() == 'Others' ){
	        			isEducationDeptOthers = true;
	        		}
	        	}
	        	
	        	if(isNullOrEmpty(educationDepartmentId)){
	        		educationDepartmentId = "";
	        	}
	        	
	        	if(campaignNewId==null){
	        		url = SERVERURL.CAMPAIGN_NEW_DETAILS + "?schoolId="+campaignSchoolId+"&educationDepartmentId="+educationDepartmentId+"&isEducationDeptOthers="+isEducationDeptOthers;
	        	}
	        	else
	        	{
	        		url = SERVERURL.CAMPAIGN_NEW_DETAILS + "?campaigId="+campaignNewId+"&schoolId="+campaignSchoolId+"&educationDepartmentId="+educationDepartmentId+"&isEducationDeptOthers="+isEducationDeptOthers;
	        		if( !isNullOrEmpty(enquiryId) && enquiryId > 0 ){
	        			url = url+"&academyLocationIds="+enquiryAcademyLocationId;
	        		}
	        	}
	        	
	        	
	        	
	        	Ext.Ajax.request({
	        		type: 'rest',
	        		url: url,
	        		method: 'GET',
	        		success: function(response) {
	        			var data = Ext.decode(response.responseText);
	        			if( !isNullOrEmpty(data) && data.length!=0 ){
	        				if( !isNullOrEmpty(data[0].schoolPriority) ){
	        					var schoolPriority = data[0].schoolPriority.value;
	        					schoolPriorityField.setValue(schoolPriority);
	        				}
	        			}
	        		}
	        	});
	        },
	        selectNewCampaignField: function(obj, campaignNewId, campaignSchoolId, enquiryId, enquiryAcademyLocationId){
				  var form = obj.up('form');
				  var campaignSchoolCombo = form.down("#campaignSchool");
				  var campaignTypeField = form.down("#campaignType");
				  var presentationTypeField = form.down("#presentationType");
				  var schoolPriorityField = form.down("#schoolPriority");
				  schoolPriorityField.reset();
				  var $this = this;
				  var campSchoolId = campaignSchoolId;
				  var schoolPriority = '';
				  $this.setAllowBlank(campaignSchoolCombo,true);
				  if( form.isValid() ){
					  form.down("#enquirydetail_SubmitButtonId").setDisabled(false);
				  } else{
					  form.down("#enquirydetail_SubmitButtonId").setDisabled(true);
				  }
				  var academyLocUrl = '';
				  if( !isNullOrEmpty(enquiryId) && enquiryId > 0 ){
					  academyLocUrl = enquiryAcademyLocationId;
				  }
				  else
					  academyLocUrl = this.getCurrentAcademyLocation();
				  
				  if(!isNullOrEmpty(campaignNewId)){
					  campSchoolId = null;
				  }
				  
				  if(campaignNewId!=null){
				  var url = SERVERURL.PATH_CAMPAIGN_DEATIL_BY_ID +"?campaignId="+campaignNewId;
				  Ext.Ajax.request({
					  type: 'rest',
					  url: url,
					  method: 'GET',
					  success: function(response) {
						  if(response.responseText != null && response.responseText != ""){
							  var responseData = Ext.JSON.decode(response.responseText);
							  if( !isNullOrEmpty(campaignTypeField) && !isNullOrEmpty(responseData.campaignType) ){
								  campaignTypeField.setValue(responseData.campaignType);
							  }
							  if( !isNullOrEmpty(presentationTypeField) && !isNullOrEmpty(responseData.presentationType) ){
								  presentationTypeField.setValue(responseData.presentationType);
							  }
					  		}
					     }
				  });
				 }

				  var campaignSchoolStore = campaignSchoolCombo.getStore();
				  campaignSchoolStore.getProxy().extraParams = {					  
					campaigId:campaignNewId,
					academyLocationIds:academyLocUrl,
					schoolId:campSchoolId
				  };
				  
				  var educationDepartmentId = null;
				  var isEducationDeptOthers = false;
				  var educationDepartmentCombo = form.down("#educationDepartmentItemId");

				  if( !isNullOrEmpty(educationDepartmentCombo) && !isNullOrEmpty(educationDepartmentCombo.getValue()) ) {
					  educationDepartmentId = educationDepartmentCombo.getValue();
					  if( educationDepartmentCombo.getRawValue() == 'Others' ){
						  isEducationDeptOthers = true;
					  }
					  campaignSchoolStore.getProxy().extraParams.educationDepartmentId = educationDepartmentId;
					  campaignSchoolStore.getProxy().extraParams.isEducationDeptOthers = isEducationDeptOthers;
				  }
				  
				  campaignSchoolStore.removeAll();
                  campaignSchoolCombo.reset();
				  
				  campaignSchoolStore.load({
					  callback: function(records, operation, success) {
						  for(var i in records){							  
							  campaignSchoolCombo.setValue(records[i].data.schoolId);
							  if(campaignSchoolId == records[i].data.schoolId && !isNullOrEmpty(records[i].data.schoolPriority))
								  schoolPriority = records[i].data.schoolPriority.value;
						  }
						
						  if(records.length!=0){
							 
							  if( records.length!=1 ){
								  $this.setAllowBlank(campaignSchoolCombo,false);
								  campaignSchoolCombo.select(campaignSchoolId);
								  schoolPriorityField.setValue(schoolPriority);
								  if( form.isValid() ){
                					  form.down("#enquirydetail_SubmitButtonId").setDisabled(false);
                				  } else{
                					  form.down("#enquirydetail_SubmitButtonId").setDisabled(true);
                				  }
							  }
						  }
						  if( !isNullOrEmpty(records) && records.length == 1 ){
							  campaignSchoolCombo.select(records[0].data.schoolId);
							  if(!isNullOrEmpty(records[0].data.schoolPriority)){
							  schoolPriorityField.setValue(records[0].data.schoolPriority.value);
							  }
						  }
					  }  
				  });
	        },
	        saveEnquiryDetail: function(f) {

	        	var $this = this;
	        	var structure = f.ownerCt.ownerCt;
	        	this.showInvalidIconOnField(structure);
	        	var form = f.ownerCt.ownerCt.getForm();
	        	var val = form.getValues();
	        	var referId = val.referredType;
	        	var referredTypeName=form.findField('referredType').getRawValue();
	        	var referrerNameField=form.findField('referrerName');
	        	var structFilter = $this.getEnquirytabstructure().getForm();
	        	var enqDetail = new Academia.model.enquiry.enquiryDetail.EnquiryDetailModel();
	        	var enqType;
	        	var trackenquiryform;
	        	var enqId;
	        	var schoolPriorityVal = null;
	        	var programCategoryVal = null;
	        	var financeVal = null;
	        	
	        	if (Ext.ComponentQuery.query('trackenquiryform')[0]){
	        		trackenquiryform = $this.getTrackenquiryform().getForm();
	        		var id = trackenquiryform.findField('enquiryType').getValue();
	            	var passId = trackenquiryform.findField('enquiryType').findRecord('id',id);
	            	enqType = passId.data.code;
	        		enqId= trackenquiryform.findField('enquiryType').getValue();
	        	}else{
	        		var store=$this.getStore('enquiry.enquiryDetail.EnquiryDetailStore');
	        		var tab = $this.getEnquirytabstructure();
	        		var commonForm = tab.getForm();
	        		var dataModel = commonForm.getDataModel();
	        		enqType=dataModel.data.enquiryType.code;
	        		enqId=dataModel.data.enquiryType.id;
	        	}
	        	var enqTypeStore = $this.getStore('enquiry.EnquiryTypeStore');
	        	var enqTypeId,enqTypeJson, followUpUserJson;
	        	enqTypeStore.getProxy().async=false;
	        	enqTypeStore.getProxy().reader.async=false;
	        	enqTypeStore.load({
	        		callback:function(record){
	        			for(var i in record) {
	        				if(record[i].data.value == enqType){
	        					enqTypeId=record[i].data.id;
	        				}
	        			}
	        		}
	        	});
	        	if(enqType != 'Counselling'){
	        		enqTypeJson={
	        				"id" : enqId,
	        				"value" : enqType
	        		};
	        	}
	        	followUpUserJson = {
	        			"id" : 1
	        	};
	        	
	        	 if(isNullOrEmpty(val.campaignNew) && !isNullOrEmpty(val.campaignSchool)){
	        		 schoolPriorityVal = val.schoolPriorityNew
           	  	 }
	        	if(!isNullOrEmpty(val.programCategory)){
	        		programCategoryVal = val.programCategory
	        	}
	        	if(!isNullOrEmpty(val.finance)){
	        		financeVal = val.finance
	        	}
	        	 
	        	enqDetail.set("id", Ext.getCmp("enquiryDetail_id").getValue());
	        	enqDetail.set("code", Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0].getValue());
	        	enqDetail.set("enquirySource", $this.getIdValueJson(Ext.getCmp("enquiryDetail_enquirySource").getValue()));
	        	enqDetail.set("enquirySourceOther", Ext.getCmp("enquiryDetail_enquirySourceOther").getValue());
	        	enqDetail.set("registeredByType", Ext.getCmp("enquiryDetail_registeredByType").getValue());
	        	enqDetail.set("firstName", Ext.getCmp("enquiryDetail_firstName").getValue());
	        	enqDetail.set("middleName", Ext.getCmp("enquiryDetail_middleName").getValue());
	        	enqDetail.set("lastName", Ext.getCmp("enquiryDetail_lastName").getValue());
	        	enqDetail.set("enquiryDate", val.enquiryDate);
	        	enqDetail.set("remark", val.remark);
	        	enqDetail.set("externalSysRefOne", val.enqExtSystemRefFirst);
	        	enqDetail.set("externalSysRefTwo", val.enqExtSystemRefSecond);
	        	enqDetail.set("externalSysRefThree", val.enqExtSystemRefThird);
	        	enqDetail.set("campaign", $this.getIdValueJson(Ext.getCmp("enquiryDetail_campaign").getValue()));
	        	enqDetail.set("salutation",$this.getIdValueJson(Ext.getCmp("enqDetailSalutaion").getValue()));
	        	enqDetail.set("enquiryType", enqTypeJson);
	        	enqDetail.set("followUpUser", followUpUserJson);
	        	enqDetail.set("whetherDeleted", false);
	        	enqDetail.set("customData", val.customData);
	        	enqDetail.set("campaignNew", $this.getIdValueJson(val.campaignNew));
	        	enqDetail.set("campaignSchool", $this.getIdValueJson(val.campaignSchool));
	        	enqDetail.set("whetherCompanySponsored", val.whetherCompanySponsored);
	        	enqDetail.set("schoolPriority", schoolPriorityVal);
	        	enqDetail.set("programCategory", $this.getIdValueJson(programCategoryVal));
	        	enqDetail.set("intakeYear",$this.getIdValueJson(val.enqIntakeYear));
	        	enqDetail.set("whetherReceiveCommunication", val.whetherReceiveCommunication);
	        	enqDetail.set("finance", $this.getIdValueJson(financeVal));

	        	if(!isNullOrEmpty(val.enquiryMode)) {
	        		var mode={
	        				"id":val.enquiryMode
	        		};
	        		enqDetail.set("enqMode", mode);
	        	} else {
	        		enqDetail.set("enqMode", null);
	        	}
	        	enqDetail.set("phoneCountryCode", Ext.getCmp("enquiryDetail_cellCountrycode").getValue());
	        	enqDetail.set("phoneNo", Ext.getCmp("enquiryDetail_cellNumber").getValue());
	        	enqDetail.set("alternateCountryCode", Ext.getCmp("enquiryDetail_alternateCellCountrycode").getValue());
	        	enqDetail.set("alternatePhoneNo", Ext.getCmp("enquiryDetail_alternateCellNumber").getValue());
	        	enqDetail.set("primaryeEmailId", Ext.getCmp("enquiryDetail_primaryeEmailId").getValue());
	        	
	        	var educationDepartmentId = null;
	        	if( !isNullOrEmpty(val.educationDepartment) ){
	        		educationDepartmentId = val.educationDepartment;
	        	}
	        	
	        	if( !isNullOrEmpty(educationDepartmentId) ){
	        		enqDetail.set("educationDepartment",this.getIdValueJson(educationDepartmentId));
	        	}

	        	var enqModeMultiple = [];
	        	var enqModeArray = val.enquiryMultipleMode;


	        	for(i in enqModeArray){
	        		var recordEnqMode = enqModeArray[i];
	        		if(Ext.isObject(recordEnqMode)){
		        	if(recordEnqMode.data != undefined)
		        	{
		        		enqModeId = recordEnqMode.data.id;
		        		enqObj = {
		        				"enquiryMode": {
		        					"id": enqModeId
		        				},
		        				"enquiry": {
		        					"id": Ext.getCmp("enquiryDetail_id").getValue()
		        				}
		        		};
		        		enqModeMultiple.push(enqObj);
		        	}
	        		} else if(!isNullOrEmpty(recordEnqMode)) {
	        			enqObj = {
	        					"enquiryMode": {
	        						"id": recordEnqMode
	        					},
	        					"enquiry": {
	        						"id": Ext.getCmp("enquiryDetail_id").getValue()
	        					}
	        			};
	        			enqModeMultiple.push(enqObj);
	        		}
	        	}
	        	enqDetail.set("enquiryMultipleMode",enqModeMultiple);

	        	enqDetail.set("enquiryReferrerType", $this.getIdValueJson(referId));
	        	if (referId == 5) {
	        		enqDetail.set("refUserName", val.referrerName);
	        	}
	        	enqDetail.set("refEnquirer", $this.getIdValueJson(val.enquirerID));
	        	enqDetail.set("refUser", $this.getIdValueJson(val.referrerId));

	        	if(referredTypeName == 'Others' || referredTypeName == 'Corporate'){
	        		enqDetail.set("refUserName", val.refUserName);
	        	}else if(referredTypeName == 'Employee' || referredTypeName == 'Student' ||referredTypeName == 'External User'){
	        		enqDetail.set("refUser", $this.getIdValueJson(referrerNameField.getValue()));
	        	}else if(referredTypeName == 'Enquirer'){
	        		enqDetail.set("refEnquirer", $this.getIdValueJson(referrerNameField.getValue()));
	        	}

	        	enqDetail.set("enqIntermediateType", $this.getIdValueJson(val.enqIntermediateTypeId, val.enqIntermediateType));

	        	var user = {
	        			id: Ext.getCmp("enquiryDetail_userId").getValue(),
	        	};

	        	enqDetail.set("user", user);

	        	var address = [];
	        	address.push({
	        		"id": Ext.getCmp("enquiryDetail_addressId").getValue(),
	        		"enquiry": $this.getIdValueJson(Ext.getCmp("enquiryDetail_id").getValue()),
	        		"address": {
	        			"id": Ext.getCmp("enquiryDetail_enquiryAddressId").getValue(),
	        			"country": $this.getIdValueJson(Ext.getCmp("enquiryDetail_country").getValue()),
	        			"parentCountryRegion": $this.getIdValueJson(Ext.getCmp("genericFieldId1").getValue()),
	        			"countryRegion": $this.getIdValueJson(Ext.getCmp("enquiryDetail_countryRegion").getValue()),
	        			"city": $this.getIdValueJson(Ext.getCmp("enquiryDetail_city").getValue()),
	        			"cellCountryCode": Ext.getCmp("enquiryDetail_cellCountrycode").getValue(),
	        			"cellNo": Ext.getCmp("enquiryDetail_cellNumber").getValue(),
	        			"primaryeEmailId": Ext.getCmp("enquiryDetail_primaryeEmailId").getValue(),
	        			"version": Ext.getCmp("enquiryDetail_versionId").getValue()
	        		}
	        	});

	        	enqDetail.set("enquiryAddresses", address);
	        	var getStudentDetailModel=form.findField('setStudentDetailModel').getValue();
	        	var decodeStudentModelValue = Ext.decode(getStudentDetailModel);
	        	decodeStudentModelValue.studentDateOfBirth = val.studentDateOfBirth;
	        	decodeStudentModelValue.genderCSM = $this.getIdValueJson(val.gender);
	        	decodeStudentModelValue.isLearnerSACitizen = val.isLearnerSACitizen;
	        	decodeStudentModelValue.nationalId = val.nationalId;
	        	decodeStudentModelValue.fatherSalutationId = val.fatherSalutationId;
	        	decodeStudentModelValue.fatherFirstName = val.fatherFirstName;
	        	decodeStudentModelValue.fatherLastName = val.fatherLastName;
	        	decodeStudentModelValue.fatherEmailId = val.fatherEmailId;
	        	decodeStudentModelValue.fatherPhoneCountryCode = val.fatherPhoneCountryCode;
	        	decodeStudentModelValue.fatherPhoneNo = val.fatherPhoneNo;
	        	decodeStudentModelValue.whetherSiblingStudying = val.whetherSiblingStudying;
	        	
	        	if(val.gender!=null){
	        		decodeStudentModelValue.genderCSM = $this.getIdValueJson(val.gender);
	        	} else {
	        		form.findField('gender').reset();
	        		delete decodeStudentModelValue.genderCSM
	        	}
	        	if(!isNullOrEmpty(val.sibilingUser1) && !isNullOrEmpty(val.whetherSiblingStudying) && val.whetherSiblingStudying == true){
	        		decodeStudentModelValue.sibilingUser1 = $this.getIdValueJson(val.sibilingUser1);
	        	} else {
	        		form.findField('sibilingUser1').reset();
	        		delete decodeStudentModelValue.sibilingUser1
	        	}
	        	if(!isNullOrEmpty(val.sibilingUser2) && !isNullOrEmpty(val.whetherSiblingStudying) && val.whetherSiblingStudying == true){
	        		decodeStudentModelValue.sibilingUser2 = $this.getIdValueJson(val.sibilingUser2);
	        	} else {
	        		form.findField('sibilingUser2').reset();
	        		delete decodeStudentModelValue.sibilingUser2
	        	}
	        	if(!isNullOrEmpty(val.sibilingUser3) && !isNullOrEmpty(val.whetherSiblingStudying) && val.whetherSiblingStudying == true){
	        		decodeStudentModelValue.sibilingUser3 = $this.getIdValueJson(val.sibilingUser3);
	        	} else {
	        		form.findField('sibilingUser3').reset();
	        		delete decodeStudentModelValue.sibilingUser3
	        	}
	        	
	        	decodeStudentModelValue.gender=null;
	        	enqDetail.set("enquiryStudentDetailsForEnquiry", decodeStudentModelValue);

	        	if(!isNullOrEmpty(enqDetail.data)){
	        		if(isNullOrEmpty(enqDetail.data.educationDepartment)){
	        			enqDetail.data.educationDepartment=null;
	        		}
	        	}
	        	var submitData = Ext.encode(enqDetail.data);

	        	var submitUrl = SERVERURL.ENQUIRY_DETAIL_ENQUIRY_AND_ADDRESS;
	        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	Ext.Ajax.request({
	        		url: submitUrl,
	        		jsonData: submitData,
	        		method: 'POST',
	        		success: function(response) {
	        			var personController=  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
	        			var enquiryTabStructure = personController.getEnquirytabstructure();
	        			enquiryTabFormValue = enquiryTabStructure.getValues();
	        			var enquiryTabForm = enquiryTabStructure.getForm();
	        			var displayParentName = enquiryTabForm.findField("displayParentName");
	        			displayParentName.setValue(enquiryTabFormValue.firstName);
	        			if($this.getSearchresultgrid() !=undefined){
	        				var grid=$this.getSearchresultgrid();
	        				grid.getSelectionModel().deselectAll();
	        				if(!isNullOrEmpty($this.getTrackcorporateenquirygrid().getSelectionModel().getSelection())) {
	        					grid = $this.getTrackcorporateenquirygrid();
	        				} 
	        				if(!isNullOrEmpty($this.getTracknonadmissionenquirygrid().getSelectionModel().getSelection())){
	        					grid = $this.getTracknonadmissionenquirygrid();
	        				}

	        				grid.getStore().reload();
	        				grid.getSelectionModel().deselectAll();
	        			}
	        			Ext.getBody().unmask();
	        			//loadEnquiryGrid
	        			showSuccessMessage(getEnquiryTranslation('ENQUIRY_DETAILS'), getCommonTranslation('SUCCESS'));
	        		}
	        	});
	        },
	        cancelEnquiryDetail: function() {
	        	var form = this.getEnquirydetailformrevamp().getForm();
	        	form.reset();
	        },

	        onFormRender: function(f) {
	        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	        	var this$ = this;

	        	var tab = this.getEnquirytabstructure();
	        	var tabs = tab.items.items[1].items;
	        	var form = f.getForm();
	        	var voipForm=this$.getEnquirydetailformrevamp();

	        	var commonForm = tab.getForm();
	        	var commonVal = commonForm.getValues();
	        	var enquiryId = commonVal.enqId;
	        	var buttonId = commonVal.buttonType;
	
	        	var voipCallSettingStore = Ext.create('Academia.store.user.VoipCallSettingStore');
				 //var voipTabs = voipForm.up('tabpanel').items.items;
				var voipTabs = voipForm.up('tabpanel');
				voipCallSettingStore.load({
					callback: function(records, operation, success){
						if(!isNullOrEmpty(records[0].data.value)){
							voipForm.down('#parentAddressMobileNo').setVisible(false);
							voipForm.down("#enquiryDetail_primaryeEmailId").setVisible(false);
							voipForm.down("#enQMobileNoFldItemId").setVisible(false);
							voipForm.down("#enQStdEmailId").setVisible(false);
							voipForm.down("#enquiryDetail_alternateCellNumber").setVisible(false);
							var tabForm=voipTabs.getComponent('studentdetailsId').down('studentdetailform');
							tabForm.down("#mobileNoFldItemId").setVisible(false);
							tabForm.down("#stdEmailId").setVisible(false);
							tabForm.down("#alternateMobileNoFldItemId").setVisible(false);
							var sgappointmentTab=voipTabs.getComponent('sgappointmentdetailId');
							voipTabs.remove(sgappointmentTab);
							var communicationhistoryTab=voipTabs.getComponent('communicationhistoryId');
							voipTabs.remove(communicationhistoryTab);
							/*var communictionTab=voipTabs[5].down('sgappointmentdetailgrid');
							if(!isNullOrEmpty(communictionTab)){
								voipTabs[5].close();
								voipTabs[5].close();
							}*/
						}
					}
				});
	        	if (buttonId == 'View') {
	        		f.down('#enquirydetail_SubmitButtonId').setVisible(false);
	        		f.down('#enquirydetail_EditButtonId').setVisible(false);
	        		this$.toggleReadOnlyFormItems(tabs.items[0].down('form').getForm(), true);
	        		if(tabs.items[1])
	        		this$.toggleReadOnlyFormItems(tabs.items[1].down('form').getForm(), true);
	        		
	        		if(tabs.items[2]){
	        			var gridReference = tabs.items[2].items.items[0];
		        		buttonsToolBar = gridReference.query('toolbar')[0];
		        		buttonsToolBar.query('#btnAdd')[0].setVisible(false);
		        		buttonsToolBar.query('#btnEdit')[0].setVisible(false);
		        		buttonsToolBar.query('#btnView')[0].setVisible(false);
		        		buttonsToolBar.query('#btnDelete')[0].setVisible(false);
	        		}
	        		
	        	}
	        	var record;
	        	var openclose;
	        	if (buttonId == 'Edit') {
	        		var grid=this$.getSearchresultgrid();
	        		if(grid==undefined) {
	        			if(this$.getEnquirygridsforpendingenquirydashboard()!=undefined){
	        				grid=this$.getEnquirygridsforpendingenquirydashboard().down('#trackEnquiryGridDashBoardItemId');
	        				record=grid.getSelectionModel().getSelection()[0];
	    	        		//console.log('record...',record);
	    	        		if(!isNullOrEmpty(record)){
	    	        			openclose = record.get('TRACK_ENQUIRY_STATUS');
	    	        		}
	        			}
	        			
	        		}
	        		f.down('#enquirydetail_SubmitButtonId').setVisible(true);
	        		if(openclose=='Closed'){
	        			f.down('#enquirydetail_SubmitButtonId').setVisible(false);
	        		}
	        		
	        	}

	        	if (enquiryId > 0) {
	        		Ext.Ajax.request({
	        			method: 'GET',
	        			scope:this$,
	        			corsSupport: true,
	        			url: SERVERURL.ENQUIRY_DETAIL_FIND_BY_ID,
	        			params: {
	        				id: enquiryId
	        			},
	        			success: function(response) {
	        				if(form.monitor != null) {
	        				form.findField("registeredByType").setReadOnly(true);
	        				if (response.responseText != null && response.responseText != "") {
	        					var data = JSON.parse(response.responseText);
	        					  var enquiryModeItemId = form.findField('enquiryMultipleMode');
	            				   var EnquiryModeStore =  enquiryModeItemId.getStore();
	            				   EnquiryModeStore.load({
	    	                		   callback: function(records, operation, success) {
	    	                			   if (success) {
	    	                				   var academyLocationArray= [];
	    	                				   if(data.enquiryMultipleMode.length > 0){
	    	                				   for(var i in data.enquiryMultipleMode){
	    	                						   academyLocationArray.push(data.enquiryMultipleMode[i].enquiryMode.id);
	    	                					   }
	    	                				   enquiryModeItemId.setValue(academyLocationArray);
	    	                				   }
	    	                			   }
	    	                		   }
	    	                	   });
	            				var enqType = data.enquiryType.code;
	            				var student = this$.setStudentDetailsOnEnquirytab(enqType,f,this$,data,buttonId);
	        					
	        					var enquiryDetail = new Academia.model.enquiry.enquiryDetail.EnquiryDetailModel(data);
	        					if (!Ext.ComponentQuery.query('trackenquiryform')[0]) {
										Ext.apply(commonForm, {
											dataModel : null,
											setDataModel : function(dataModel) {
												form.dataModel = dataModel;
											},
											getDataModel : function() {
												return form.dataModel;
											}
										});
										commonForm.setDataModel(enquiryDetail);
								}
	        					var enquiryAcademyLocationId = data.academyLocation.id;
	            					   
								var enquiryAddresses = data.enquiryAddresses;
	        					form.loadRecord(enquiryDetail);
	        					var phoneCountryCode = form.findField("cellCountrycode");
	        					var numberContainer = form.findField("parentAddressMobileNo");
	        					this$.loadDFRForMobileNumber(numberContainer);
	        					
	        					var alternatePhoneCountryCode = form.findField("alternateCellCountrycode");
	        					form.findField("cellNo").setValue(data.phoneNo);
	        					form.findField("alternateCellNo").setValue(data.alternatePhoneNo);
                                var campaignNew=form.findField("campaignNew");
                                var campaignSchool=form.findField("campaignSchool");
                                var programCategory=form.findField("programCategory");
                                var programCategoryStore=programCategory.getStore();
                                
                                var getEnqStructure = this$.getEnquirytabstructure();
                                getEnqStructure.down('#hiddenEnquiryMobileNo').setValue(data.phoneNo);
                                getEnqStructure.down('#hiddenEnquiryMobileCode').setValue(data.phoneCountryCode);
                                getEnqStructure.down('#hiddenEnquiryStudentEmail').setValue(data.primaryeEmailId);
                                getEnqStructure.down('#enqExtSystemRefFirst').setValue(data.externalSysRefOne);
                                getEnqStructure.down('#enqExtSystemRefSecond').setValue(data.externalSysRefTwo);
                                getEnqStructure.down('#enqExtSystemRefThird').setValue(data.externalSysRefThree);
                                var campaignNewStore=campaignNew.getStore();
                                campaignNewStore.getProxy().extraParams = {
                                	academyLocationIds: this.getCurrentAcademyLocation(),
                                	isActive: true
                                };
                                if( !isNullOrEmpty(data.campaignNew) && !isNullOrEmpty(data.campaignNew.id) ){
                                	campaignNewStore.getProxy().extraParams.oldCampaignId = data.campaignNew.id;
                                }
                                if( !isNullOrEmpty(data.programCategory) && !isNullOrEmpty(data.programCategory.id) ){
                                	programCategoryStore.load({
                                		scope:this,
                                		callback: function(records, operation, success) {
                                			if (success) {
                                				for(var i in records) {
                                					if(records[i].data.id == data.programCategory.id) {
                                						form.findField("programCategory").setValue(records[i].data.id);
                                						break;
     	        			    					}
     	        		    					}
     	        							}
                                		}
                                	});
                                }
                                
                                var financeCombo = form.findField("finance");
                                if (!isNullOrEmpty(data.finance)) {
        							financeCombo.getStore().load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									financeCombo.setValue(data.finance.id);
	        								}
	        							}
	        						});
                                }
                                
                                Ext.defer(function() {
                                	campaignNewStore.load({
                                		scope:this,
                                		callback: function(records, operation, success) {

                                			if(!isNullOrEmpty(data.campaignNew)){
                                				campaignNew.setVisible(true);
                                				campaignNew.setValue(data.campaignNew.id);
                                				if( !isNullOrEmpty(data.campaignSchool) ){
                                					this$.selectNewCampaignField(campaignNew, data.campaignNew.id, data.campaignSchool.id, enquiryId, enquiryAcademyLocationId);
                                				} else {
                                					this$.selectNewCampaignField(campaignNew, data.campaignNew.id, null, enquiryId, enquiryAcademyLocationId);
                                				}
                                			}else if(isNullOrEmpty(data.campaignNew) && !isNullOrEmpty(data.campaignSchool)){                                				
                                				var schoolPriorityField = form.findField("schoolPriority");
                                				var schoolPriorityNewField = form.findField("schoolPriorityNew");
                                				schoolPriorityField.setVisible(false);
                                				this$.loadDFRForSchoolPriority(schoolPriorityNewField);
                                				schoolPriorityNewField.setDisabled(false);
                                				schoolPriorityNewField.getStore().load({
               	        						  callback: function(record, operation, success) {
               	        							  if (success) {
               	        								  for(var i in record) {
               	        									  if(data.schoolPriority!=null) {
               	        			    					  	if(record[i].data.id ==data.schoolPriority) {
               	        			    					  	schoolPriorityNewField.setValue(record[i].data.id);
               	        			    					 	}
               	        		    					 	 }
               	        									  else {
               	        										schoolPriorityNewField.setValue(null);
               	        									  }
               	        								  }
               	        							  }
               	        						  }
               	        					  });
                                				
                                				  var campaignSchoolCombo = form.findField("campaignSchool");
                                				  var academyLocUrl = '';
                                				  if( !isNullOrEmpty(enquiryId) && enquiryId > 0 ){
                                					  academyLocUrl = enquiryAcademyLocationId;
                                				  }
                                				  else
                                					  academyLocUrl = this$.getCurrentAcademyLocation();
                                				  
                                				  var campaignSchoolStore = campaignSchoolCombo.getStore();
                                				  campaignSchoolStore.getProxy().extraParams = {					  
                                					campaigId:null,
                                					academyLocationIds:academyLocUrl,
                                					schoolId:data.campaignSchool.id
                                				  };
                                				  
                                				  var educationDepartmentId = null;
                                				  var isEducationDeptOthers = false;
                                				  var educationDepartmentCombo = form.findField("educationDepartment");

                                				  if( !isNullOrEmpty(educationDepartmentCombo) && !isNullOrEmpty(educationDepartmentCombo.getValue()) ) {
                                					  educationDepartmentId = educationDepartmentCombo.getValue();
                                					  if( educationDepartmentCombo.getRawValue() == 'Others' ){
                                						  isEducationDeptOthers = true;
                                					  }
                                					  campaignSchoolStore.getProxy().extraParams.educationDepartmentId = educationDepartmentId;
                                					  campaignSchoolStore.getProxy().extraParams.isEducationDeptOthers = isEducationDeptOthers;
                                				  }
                                				  
                                				  campaignSchoolStore.removeAll();
                                                  campaignSchoolCombo.reset();
                                				  
                                				  campaignSchoolStore.load({
                                					  callback: function(records, operation, success) {
                                						  for(var i in records){	
                                							  if(records[i].data.schoolId == data.campaignSchool.id){
                                							  campaignSchoolCombo.setValue(records[i].data.schoolId);
                                							  }
                                						   }                                						                               					
                                					  }  
                                				  });
                                			}
                                			else if(isNullOrEmpty(data.campaignNew) && isNullOrEmpty(data.campaignSchool)){
                                				var schoolPriorityField = form.findField("schoolPriority");
                                				var schoolPriorityNewField = form.findField("schoolPriorityNew");
                                				schoolPriorityField.setVisible(false);
                                				this$.loadDFRForSchoolPriority(schoolPriorityNewField);
                                				schoolPriorityNewField.setDisabled(true);
                                			}
                                		}	
                                	});
                                });
                                
                                form.findField("whetherCompanySponsored").setValue(data.whetherCompanySponsored);
                                
                                var whetherCompanySponsoredFld = form.findField('whetherCompanySponsored');
                                var whetherCompanySponsoredGroup = form.findField('whetherCompanySponsored').up();
                                if( !isNullOrEmpty(data.whetherCompanySponsored) && data.whetherCompanySponsored != undefined && data.whetherCompanySponsored == true ){
                                	whetherCompanySponsoredGroup.items.items[0].setValue(true);
                                	whetherCompanySponsoredGroup.items.items[1].setValue(false);
                                }
                                if( !isNullOrEmpty(data.whetherCompanySponsored) && data.whetherCompanySponsored != undefined && data.whetherCompanySponsored == false ){
                                	whetherCompanySponsoredGroup.items.items[0].setValue(false);
                                	whetherCompanySponsoredGroup.items.items[1].setValue(true);
                                }

                                
                                if(!isNullOrEmpty(data.whetherReceiveCommunication)){
                                form.findField("whetherReceiveCommunication").setValue(data.whetherReceiveCommunication);
                                form.findField("whetherReceiveCommunication").setReadOnly(true);
                                var whetherReceiveCommunicationFld = form.findField('whetherReceiveCommunication');
                                var whetherReceiveCommunicationGroup = form.findField('whetherReceiveCommunication').up();
                                if( !isNullOrEmpty(data.whetherReceiveCommunication) && data.whetherReceiveCommunication != undefined && data.whetherReceiveCommunication == true ){
                                	whetherReceiveCommunicationGroup.items.items[0].setValue(true);
                                	whetherReceiveCommunicationGroup.items.items[1].setValue(false);
                                }
                                if( !isNullOrEmpty(data.whetherReceiveCommunication) && data.whetherReceiveCommunication != undefined && data.whetherReceiveCommunication == false ){
                                	whetherReceiveCommunicationGroup.items.items[0].setValue(false);
                                	whetherReceiveCommunicationGroup.items.items[1].setValue(true);
                                }
                               } else{
                            	   var receiveCommunicationItem =form.findField("receiveCommunication");
                            	   var whetherReceiveCommunication =  form.findField("whetherReceiveCommunication").setValue(true);
                            	   var whetherReceiveCommunicationGroup = form.findField('whetherReceiveCommunication').up();
                            	   whetherReceiveCommunicationGroup.items.items[0].setValue(true);
                                	whetherReceiveCommunicationGroup.items.items[1].setValue(false);
                               }
                                var whetherReceiveCommunicationGroup = form.findField('whetherReceiveCommunication').up();
                         	    whetherReceiveCommunicationGroup.items.items[0].setReadOnly(true);
                             	whetherReceiveCommunicationGroup.items.items[1].setReadOnly(true);
                                
	        					if (data.enqIntermediateType != null) {
	        						form.findField("enqIntermediateTypeId").setValue(data.enqIntermediateType.id);
	        						form.findField("enqIntermediateType").setValue(data.enqIntermediateType.value);
	        					}
	        					var ReferredTypeStore = form.findField("referredType").getStore();
        						ReferredTypeStore.on('load', function(){
        								for(var i=0; i< ReferredTypeStore.data.items.length;i++){
	        								if(ReferredTypeStore.data.items[i].data.value == 'Corporate'){
	        									ReferredTypeStore.removeAt(i);
	        								} 
	        							}
        						});
        						
        						var educationDepartmentCombo = form.findField("educationDepartment");
        						if (data.educationDepartment != null) {
        							educationDepartmentCombo.getStore().load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									educationDepartmentCombo.setValue(data.educationDepartment.id);
	        								}
	        							}
	        						});
        						}
        						
        						var enqIntakeYear = form.findField("enqIntakeYear");
        						if (data.intakeYear != null) {
        							enqIntakeYear.getStore().load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									enqIntakeYear.setValue(data.intakeYear.id);
	        								}
	        							}
	        						});
        						}
	        					if (data.enquiryReferrerType != null) {

	        						var refUserNameField=form.findField('refUserName');
	        						var refrredNameField = form.findField('referrerName');
	        						refrredNameField.setVisible(false);
	        						refrredNameField.reset();
	        						refrredNameField.allowBlank = true;

	        						var refferTypeId = data.enquiryReferrerType.id;
	        						var refType = data.enquiryReferrerType.value;

	        						if (refType != 'None') {
	        							if(refType == 'Others'){
	        							refUserNameField.setVisible(true);
	        							refUserNameField.setDisabled(false);
	        							}else{
	        							refUserNameField.setVisible(false);	
	        							refrredNameField.setVisible(true);
	        							}
	        						} 

	        						if(refType == 'Others' || refType == 'Corporate'){
	        							form.findField('refUserName').setValue(data.refUserName);
	        						}
	        						var store = this$.getStore('enquiry.ReferredTypeStore');
	        						store.load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									form.findField("referredType").setValue(refferTypeId);
	        								}
	        							}
	        						});
	        					}else{
	        						var store = this$.getStore('enquiry.ReferredTypeStore');
	        						store.load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									form.findField("referredType").setValue(7);//default  none
	        									form.findField("referrerName").setVisible(false);
	        									form.findField("referrerName").allowBlank=true;
	        								}
	        							}
	        						});
	        					}
	        					if (data.refUser != null || data.refEnquirer!=null) {

	        						var refferTypeId = data.enquiryReferrerType.id;
	        						var refNameId = null;
	        						var name;
	        						if (data.refUser != null) {
	        							name = data.refUser.value;
	        							refNameId=data.refUser.id;
	        						} else {
	        							name = data.refEnquirer.value;
	        							refNameId=data.refEnquirer.id;
	        						}
	        						var store = this$.getStore('enquiry.ReferredIdStore');
	        						store.load({
	        							params: {
	        								refTypeId: refferTypeId,
	        								name: name,
	        								isEnquiryEditMod: true,
	        								enquirerExternalUserId: refNameId
	        							},
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									form.findField("referrerName").setValue(refNameId);
	        								}
	        							}
	        						});
	        						
	        					}

	        					if (data.enquiryAddresses.length > 0) {

	        						var addId = enquiryAddresses[0].id;
	        						var address = enquiryAddresses[0].address;

	        						form.findField("enquiryAddressId").setValue(address.id);
	        						form.findField("addressId").setValue(addId);
	        						form.findField("version").setValue(address.version);
	        						var countryId;
	        						if(!isNullOrEmpty(address.country)){
	        							countryId = address.country.id;
	        						}else{
	        							form.findField("parentCountryRegion").setDisabled(true);
		        						form.findField("city").setDisabled(true);
	        						}
	        						var cityId;
	        						if(!isNullOrEmpty(address.city)){
	        							cityId = address.city.id;
	        						}
	        						var val = this$.findSettingValue('primaryeEmailId', enquiryAddresses);
	        						if (val != null) {
	        							if(!isNullOrEmpty(val.primaryeEmailId)){
		        							form.findField("primaryeEmailId").setValue(val.primaryeEmailId);
	        							}
	        							if(!isNullOrEmpty(val.cellCountryCode)){
	        								form.findField("cellCountrycode").setValue(val.cellCountryCode);
	        							}
	        							if(!isNullOrEmpty(val.cellNo)){
	        								form.findField("cellNo").setValue(val.cellNo);
	        							}
//	        						
	        							if (address.parentCountryRegion != null) {
	        								form.findField("parentCountryRegionId").setValue(address.parentCountryRegion.id);
	        							}
	        							if (address.countryRegion != null) {
	        								form.findField("countryRegionId").setValue(address.countryRegion.id);
	        							}
	        						}
	        						var countryStore = this$.getStore('common.CountryStore');
	        						countryStore.load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									form.findField("country").setValue(countryId);
	        								}
	        							}
	        						});

	        						var countryRegionStore = this$.getStore('organization.CountryRegionStore');
	        						countryRegionStore.getProxy().extraParams = {
	        							cid: countryId
	        						};
	        						countryRegionStore.load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									if(!isNullOrEmpty(address.countryRegion)){
	        										form.findField("parentCountryRegion").setValue(address.countryRegion.id);
	        									}
	        								}
	        							}
	        						});

	        						var cityStore = this$.getStore('organization.CityByCountryRegion');
	        						if(!isNullOrEmpty(address.countryRegion)){
	        							cityStore.getProxy().extraParams = {
	        								id: address.countryRegion.id
	        							};
	        							cityStore.load({
	        								callback: function(record, operation, success) {
	        									if (success) {
	        										if(!isNullOrEmpty(address.city)){
	        											form.findField("city").setValue(address.city.id);
	        										}
	        									}
	        								}
	        							});
	        						}
	        						var registeredByType = this$.getStore('enquiry.EnquiryRegisteredBy');
	        						registeredByType.load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									form.findField("registeredByType").setValue(data.registeredByType);
	        									if(data.registeredByType=="STUDENT" && !isNullOrEmpty(data.linkStudentId) && !isNullOrEmpty(data.linkStudentId.id)) {
	        										form.findField("registeredByType").setReadOnly(true);
	        									}
	        									else{
	        										form.findField("registeredByType").setReadOnly(false);
	        									}
	        								}
	        							}
	        						});
	        					};
	        					
	        					var genderField = form.findField('gender');
	        					  genderField.getStore().load({
	        						  callback: function(record, operation, success) {
	        							  if (success) {
	        								  for(var i in record) {
	        									  if(data.enquiryStudentDetailsForEnquiry.genderCSM!=null && data.enquiryStudentDetailsForEnquiry.genderCSM!=undefined) {
	        			    					  	if(record[i].data.id ==data.enquiryStudentDetailsForEnquiry.genderCSM.id) {
	        			    							  genderField.setValue(record[i].data.id);
	        			    					 	}
	        		    					 	 }
	        									  else {
	        										  genderField.setValue(null);
	        									  }
	        								  }
	        							  }
	        						  }
	        					  });

	        					var campaignId = null;
	        					if (enquiryDetail.data.campaign != null) {
	        						campaignId = enquiryDetail.data.campaign.id;
	        					}
	        					var enquiryTypeId = enquiryDetail.data.enquiryType.id;
	        					var enquiryTypeName = enquiryDetail.data.enquiryType.code;
	        					var enquiryId = enquiryDetail.data.id;
	        					if (enquiryTypeName == 'Corporate') {
	        						f.down("#enquiryDetailNamePanel").setVisible(false);//	        						
	        					} else {
	        						f.down("#enquiryDetailNamePanel").setVisible(true);//	        						
	        					}
	        					if(enquiryTypeName!='Counselling'){
	        		        		form.findField('enquiryType').setVisible(false);
	        		        	}else{
	        		        		var enquiryTypeField = form.findField('enquiryType');
	        		        		enquiryTypeFieldStore=enquiryTypeField.getStore();
	                                   var store = this$.getStore('enquiry.EnquiryTypeCounsellingStore');
	                                   enquiryTypeFieldStore.on('load', function(){
	                                   	for(var i=0; i< store.data.items.length;i++){
	                                   		if(store.data.items[i].data.code == 'Corporate' || store.data.items[i].data.code == 'Placement'){
	                                   			store.removeAt(i);
	                                   		} 
	                                   	}
	                                   });
	        		        		enquiryTypeField.getStore().load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									for(var i in record) {
	        	    								if(enquiryTypeName == 'Counselling' && enquiryTypeName == record[i].data.code){
	        	    									enquiryTypeField.setValue(record[i].data.id);
	        	    								}
	        	    							}
	        									
	        								}
	        							}
	        						});
	        		        	}
	        					if(enquiryTypeName != 'Counselling'){
	        						var programCategoryField = form.findField('programCategory');
	        						programCategoryField.setVisible(false);
	        						programCategoryField.allowBlank = true;
	        		        		f.getForm().checkValidity();
	        		        	}
	        					
	        					var campaignStore = form.findField("campaign").getStore();
	        					campaignStore.clearFilter(true);
	        					var campaignid = null;
	        					if(enquiryDetail.data.campaign!=null){
	        						campaignid = enquiryDetail.data.campaign.id;
	        					}
	        					campaignStore.getProxy().extraParams={
	        						academyLocationId:this$.getCurrentAcademyLocation(),
//	        						codeOrName:campaignValue
	        						//id:campaignid
	        					};
	        					campaignStore.load({
	        						callback: function(record, operation, success) {
	        							if (success) {
	        								/**
	        								 * make field readonly if campaign is deleted
	        								 */
	        								if(record.length>0){
	        									Ext.Array.each(record,function(value){
	        										if(value.data.id==campaignId){
	        											form.findField("campaign").setValue(value.data.id);
	        											if(!value.data.code){
	        												form.findField("campaign").setReadOnly(true);
	        											}
	        										}
	        									});
	        								}
	        							}
	        						}
	        					});
	        					if (enquiryDetail.data.salutation != null) {
	        						var salutationId = enquiryDetail.data.salutation.id;
	        					}
	        					var salutationStore=this$.getStore('common.SalutationStore');
	        					salutationStore.load({
	        						callback:function(record,operation,success){
	        							if(success){
	        								form.findField("enquiryDetailSalutation").setValue(salutationId);
	        							}
	        						}
	        					});
	        			
	        					if(data.enquirySource){
	        						var sourceEnquiryStore = this$.getStore('enquiry.EnquirySourceStore');
	        						sourceEnquiryStore.load({
	        							callback: function(record, operation, success) {
	        								if (success) {
	        									form.findField("sourceCode").setValue(data.enquirySource.id);
	        			                    	if(data.enquirySource.value.toLowerCase()=='other' || data.enquirySource.value.toLowerCase()=='others'){
	        			                    		var sourceOther = form.findField("enquirySourceOther");
	        			                    		form.findField("enquirySourceOther").setValue(data.enquirySourceOther);
	        			                    		form.findField("enquirySourceOther").setVisible(true);
	        			                    		this$.loadDFRForsourceOther(sourceOther);
	        			                        }
	        			                    	else{
	        			                    		form.findField("enquirySourceOther").setVisible(false);
	        			                    	}
	        								}
	        							}
	        						});
	        					}
	        					var studentStructure = this$.getEnquirytabstructure();
	        					form.findField("enquiryDate").setValue(dateRender(enquiryDetail.data.enquiryDate));

	        					if(!isNullOrEmpty(enquiryDetail.data.user)) {
	        					form.findField("userId").setValue(enquiryDetail.data.user.id);
	        					}

	        					if(enquiryDetail.data.enquiryType.code=='Corporate' && !isNullOrEmpty(enquiryDetail.data.user))
	        					{
	        						studentStructure.down('#assignToId').setValue(enquiryDetail.data.user.value);
	        				    }
	        				}
	        				phoneCountryCode.getStore().load({
        						callback:function(record) {
        							setTimeout(function(){
	        							var enquirydetailformrevamp = this$.getEnquirydetailformrevamp();
	        							if(enquirydetailformrevamp.isValid()){
	        								enquirydetailformrevamp.down('#enquirydetail_SubmitButtonId').setDisabled(false);
	        							} else {
	        								enquirydetailformrevamp.down('#enquirydetail_SubmitButtonId').setDisabled(true);
	        							}
	    	        					form.clearInvalid();
	        							Ext.getBody().unmask();
        							},500);
        							for(var i in record) {
        								if(record[i].data.isdCode == data.phoneCountryCode){
        									phoneCountryCode.setRawValue(record[i].data.isdCode);
        								}
        							}
        							if(isNullOrEmpty(phoneCountryCode.getValue())){
        								if(!isNullOrEmpty(Ext.app.defaultCountryCode)){
        									phoneCountryCode.setValue(Ext.app.defaultCountryCode);
        								}
        							}
        						}
        					});
	        				alternatePhoneCountryCode.getStore().load({
        						callback:function(record) {
        							for(var i in record) {
        								if(record[i].data.isdCode == data.alternateCountryCode){
        									alternatePhoneCountryCode.setRawValue(record[i].data.isdCode);
        								}
        							}
        							if(isNullOrEmpty(alternatePhoneCountryCode.getValue())){
        								if(!isNullOrEmpty(Ext.app.defaultCountryCode)){
        									alternatePhoneCountryCode.setValue(Ext.app.defaultCountryCode);
        								}
        							}
        						}
        					});
	        				var cellCountryCode = form.findField("cellCountrycode");
	        				var mobileField = form.findField("cellNo");
	        				this.setMaximumMinimumDigitsForMobileNoValidation(form, cellCountryCode, mobileField, null);
	        				var cellCountryCode = form.findField("alternateCellCountrycode");
	        				var mobileField = form.findField("alternateCellNo");
	        				this.setMaximumMinimumDigitsForMobileNoValidation(form, cellCountryCode, mobileField, null);
	        		 } },
	        			failure: function() {
	        				showErrorMessage(getCommonTranslation('ORGINFOTITLE'), getCommonTranslation('FAILURE'));
	        				Ext.getBody().unmask();
	        			}
	        		});
	        	}
	        },
	        findSettingValue: function(key, enquiryAddresses) {
	        	var retvalue = null;
	        	Ext.each(enquiryAddresses[0].address, function(rec) {
	        		retvalue = rec;
	        	});
	        	return retvalue;
	        },
	        getIdValueJson: function(id, value) {
	        	if (id) return {
	        		id: id,
	        		value: value
	        	};
	        },
	        showHideEnquiryMulProgramFormEditWindow : function(selectedApplicationType, enquiryForm) {
	        	var $this = this;
	        	if (selectedApplicationType != 'Counselling') {
	        		var formWindow = $this.getEnquiryMulProgramFormEdit();
	        		if (!formWindow) {
	        			Ext.widget('enquirymulprogramform',{
	        				itemId:'enquiryMulProgramFormEditItemId'
	        			});
	        			formWindow = $this.getEnquiryMulProgramFormEdit();
	        		}
	        		formWindow.show();
	        		var EnquiryId = enquiryForm.down('#enquiryDetail_id').getValue();
	        		var getEnquiryUrl = SERVERURL.PATH_FIND_STUDENT_DETAIL_ENQUIRYID;
					Ext.Ajax.request({
						method: "GET",
						type: 'rest',
						url: getEnquiryUrl,
						params: {
							enquiryId: EnquiryId
						},
						success: function(response, action) {
							var responseData = Ext.JSON.decode(response.responseText);
							var registrationType=formWindow.down("#registrationTypeId");
							if(responseData.length>0)
							{
								//Set Enquiry Student Details
								$this.setEnquiryStudentDetails(responseData,formWindow);
								if(responseData[0].batchPartTime ==true){
	              					  registrationType.getStore().reload();
	              					  registrationType.setValue('PART_TIME');
						          	}
								else if(responseData[0].batchPartTime ==false){
									 registrationType.getStore().reload();
	              					  registrationType.setValue('FULL_TIME');
								}
							}else{
								 var ALField=formWindow.down("#academyLocationId");
					          	  var programCombo=formWindow.down('#programId');
					          	  var fieldOfInterest=formWindow.down('#fieldOfInterest');
					          	  fieldOfInterest.setVisible(false);
					          	  var modeOfDelivery=formWindow.down("#modeDeliveryId");
					          	  var store = ALField.getStore();
					          	  store.load({
					          		  callback: function(operation, success) {
					          			  if(success){	 
					          					  ALField.setValue($this.getCurrentAcademyLocation());
					          				  programCombo.setDisabled(false);
					          				  programCombo.getStore().getProxy().extraParams = {
					          					  academyLocationIds: $this.getCurrentAcademyLocation(),
					          					  isOtherBlankProgramRequired:false,
					          					
					      					  };
					          				 programCombo.getStore().load();
					          				
					          			  }
					          		  }
					          	  });
							}
						}
					});						
	        	}
	        },
	        saveEnqMulProgGridData: function(f) {
	        	var $this = this;
	        	var formLayout = $this.getEnquirymulprogramform();
	        	var myForm = formLayout.down('form');
	    		this.showInvalidIconOnField(myForm);
	        	var getEnquiryDetail = $this.getEnquirydetailformrevamp();
	        	var enquiryTypeField  = getEnquiryDetail.down('#enquiryDetail_enquiryType');
	        	var enquiryId  = getEnquiryDetail.down('#enquiryDetail_id');
	        	var form = $this.getEnquiryMulProgramFormEdit().down('form').getForm();
	        	var values = form.getValues();
	        	var studentEnquiryDetailsJson = new Array();
	        	var salutation = values.salutation;
	        	var studentFname = values.studentFname;
	        	var studentMname = values.studentMname;
	        	var studentLname = values.studentLname;
	        	var registrationType = values.registrationType;
	        	var studentDateOfBirth = values.studentDateOfBirth;
	        	var academyLocation = values.academyLocation;
	        	var admissionEnquiryDetailId = values.admissionEnquiryDetailId;
	        	var enquiryStudentDetailId = values.enquiryStudentDetailId;
	        	var emailId = values.emailId;
	        	var programId = values.programId;
	        	var batchId = values.batchId;
	        	var seatTypeId = values.seatTypeId;
	        	var mobileCountryCode = values.mobileCountryCode;
	        	var mobileNumber = values.mobileNumber;
	        	var mobileNumber = values.mobileNumber;
	        	var alternateMobileNo = values.alternateMobileCountryCode;
	        	var isLearnerSACitizen = values.isLearnerSACitizen;
	        	var nationalId = values.nationalId;
	        	var whetherProgramOtherSelected = false;
	        	var gradeElevenAverage = values.gradeElevenAverage;
	        	var currentGrade = values.currentGrade;
	        	var gradeTwelveAverage = values.gradeTwelveAverage;
	        	var examBoard = values.examBoard;
	        	var studentFirstNameOtherLanguage = values.studentFirstNameOtherLanguage;
	        	var studentMiddleNameOtherLanguage = values.studentMiddleNameOtherLanguage;
	        	var studentLastNameOtherLanguage = values.studentLastNameOtherLanguage;
	        	if( !isNullOrEmpty(programName) && programId == 0 ){
	        		whetherProgramOtherSelected = true; 
	        	}

	        	var stdDetails=new Object();
	        	if(typeof salutation == 'object'){
	        		stdDetails.salutation = salutation
	        	} else {
	        		stdDetails.salutation = $this.getIdValueJson(salutation);
	        	}

	        	if(typeof currentGrade == 'object'){
	        		stdDetails.currentGrade = currentGrade
	        	} else {
	        		stdDetails.currentGrade = $this.getIdValueJson(currentGrade);
	        	}
	        	
	        	if(typeof examBoard == 'object'){
	        		stdDetails.examBoard = examBoard
	        	} else {
	        		stdDetails.examBoard = $this.getIdValueJson(examBoard);
	        	}

	        	stdDetails.gradeElevenAverage = gradeElevenAverage;
	        	stdDetails.gradeTwelveAverage = gradeTwelveAverage;
	        	stdDetails.studentFirstNameOtherLanguage = studentFirstNameOtherLanguage;
	        	stdDetails.studentMiddleNameOtherLanguage = studentMiddleNameOtherLanguage;
	        	stdDetails.studentLastNameOtherLanguage = studentLastNameOtherLanguage;
	        	stdDetails.id = enquiryStudentDetailId;
	        	stdDetails.studentFirstName = studentFname;
	        	stdDetails.studentMiddleName = studentMname;
	        	stdDetails.studentLastName = studentLname;
	        	stdDetails.mobileCountryCode = mobileCountryCode;
	        	stdDetails.mobileNumber = mobileNumber;
	        	stdDetails.studentDateOfBirth = studentDateOfBirth;
	        	stdDetails.alternateMobileCountryCode = alternateMobileNo;
	        	stdDetails.alternateMobileNo = alternateMobileNo;
	        	stdDetails.whetherDeleted = false;
	        	stdDetails.isLearnerSACitizen = isLearnerSACitizen;
	        	stdDetails.nationalId = nationalId;
	        	var admDetails=new Object();
	        	admDetails.academyLocation =$this.getIdValueJson(academyLocation);
	        	admDetails.id = admissionEnquiryDetailId;
	        	admDetails.whetherDeleted = false;
	        	admDetails.program = $this.getIdValueJson(programId);
	        	admDetails.batch = {
	        			"id":batchId,
	        	};
	        	admDetails.programBatchSeatConfiguration = {
	        			"id":seatTypeId,
	        	};
	        	if( !isNullOrEmpty(values.registrationType)){
	        		
	        		if(!isNullOrEmpty(values.registrationType) && values.registrationType!="" ) {
    	            	if(values.registrationType=='FULL_TIME'){
    	            		admDetails.batchPartTime=false
    	            	}else{
    	            		admDetails.batchPartTime=true
    	            	}
    	            }
	        		/*admDetails.registrationTypeCSM=$this.getIdValueJson(registrationType);*/
	        	}
	        	if( !isNullOrEmpty(values.modeofDelivery)){
	        		admDetails.modeOfDeliveryCSM=$this.getIdValueJson(values.modeofDelivery);
	        	}
	        	/*delete admDetails.registrationTypeCSM;
	        	delete admDetails.modeOfDeliveryCSM;*/
	        	stdDetails.admissionEnquiryDetails = [admDetails]; 
	        	studentEnquiryDetailsJson.push(stdDetails);
	        	var enquiryType = {
	        			"id": 1,
	        			"value": "Admission"
	        	};
	        	var saveJsonDetails = {
	        			"enquiryType":enquiryType,
	        			"id":enquiryId.getValue(),
	        			"enquiryStudentDetails":studentEnquiryDetailsJson
	        	};
	        	if( !isNullOrEmpty(values.enquiryStudentSchoolSubject) ){
	        		var enquiryStudentSchoolSubjectArr = [];
	        		var schoolSubjArr = values.enquiryStudentSchoolSubject;
	        		for( var p in schoolSubjArr ){
	        			var schoolSubj = {};
	        			var subject = {};
	        			if( !isNullOrEmpty(schoolSubjArr[p].data) ){
	        				subject.id = schoolSubjArr[p].data.id;
	        				schoolSubj.subject = subject; 
	        			} else {
	        				subject.id = schoolSubjArr[p];
	        				schoolSubj.subject = subject; 
	        			}
	        			schoolSubj.enquiryStudentDetail = {"id":values.enquiryStudentDetailId};
	        			enquiryStudentSchoolSubjectArr.push(schoolSubj);
	        		}
	        		stdDetails.enquiryStudentExamBoardSubject = enquiryStudentSchoolSubjectArr;
	        	}
	        	delete stdDetails.enquiryStudentSchoolSubject;
	        	if(isNullOrEmpty(stdDetails.enquiryStudentExamBoardSubject) || isNullOrEmpty(stdDetails.enquiryStudentExamBoardSubject[0]) || 
	        			isNullOrEmpty(stdDetails.enquiryStudentExamBoardSubject[0].subject.id) ){
	        		delete stdDetails.enquiryStudentExamBoardSubject;
	        	}
	        	var submitUrl = SERVERURL.PATH_SAVE_ENQUIRY_CONVERT_TOADMISSION;
	        	$this.applyWindowMask(); 
	        	Ext.Ajax.request({
	        		type: 'rest',
	        		url: submitUrl,
	        		jsonData: saveJsonDetails,
	        		method: 'POST',
	        		success: function(response) {	
	        			var responseData = Ext.JSON.decode(response.responseText);
	        			if(!isNullOrEmpty(responseData.enquiryStudentDetailId)){
	        				enquiryTypeField.setVisible(false);
	        				var studentStructure = $this.getEnquirytabstructure();
	        				var tabPanel = studentStructure.down('tabpanel');
	        				tabPanel.items.items[1].isReloadTabRequire = true;
	        				tabPanel.items.items[2].isReloadTabRequire = true;
	        				tabPanel.items.items[3].isReloadTabRequire = true;
	        				studentStructure.down('#studentDetailId').setValue(responseData.enquiryStudentDetailId);
	        				studentStructure.down('#enqTypeId').setValue('Admission');
	        				studentStructure.down('#displayStudentName').setValue(studentFname+" "+studentMname+" "+studentLname);
	        				var programValue = form.findField('programId').getDisplayValue();
	        				var batchValue = form.findField('batchId').getDisplayValue();
	        				studentStructure.down('#displayGradeIntakeYear').setValue(programValue+" - "+batchValue);
	        				$this.getEnquiryMulProgramFormEdit().close();
	        				var trackEnquiryController=  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
	        				trackEnquiryController.loadEnquiryGrid();
	        				if(enquiryType.id==1){
	        					getEnquiryDetail.down('#enQStudentDetails_studentDateOfBirth').setValue(studentDateOfBirth);
	        					getEnquiryDetail.down('#enQStudentDetails_gender').setValue(values.gender);
	        					var isLearnerSACitizenFld = getEnquiryDetail.getForm().findField('isLearnerSACitizen');
	        					var isLearnerSACitizenRadioGroup = getEnquiryDetail.down('#enQStdIsLearnerSACitizenItemId');
	        					if( !isNullOrEmpty(isLearnerSACitizen) && isLearnerSACitizen != undefined && isLearnerSACitizen == true ){
	        						isLearnerSACitizenRadioGroup.items.items[0].setValue(true);
	        						isLearnerSACitizenRadioGroup.items.items[1].setValue(false);
	        					}
	        					if( !isNullOrEmpty(isLearnerSACitizen) && isLearnerSACitizen != undefined && isLearnerSACitizen == false ){
	        						isLearnerSACitizenRadioGroup.items.items[0].setValue(false);
	        						isLearnerSACitizenRadioGroup.items.items[1].setValue(true);
	        					}

	        					isLearnerSACitizenFld.setValue(isLearnerSACitizen);
	        					getEnquiryDetail.down('#enQStdNationalId').setValue(nationalId);
	        					$this.validateStudentDetails(getEnquiryDetail,false);
	        				}
	        				showSuccessMessage(getEnquiryTranslation('ENQUIRY_DETAILS'), getCommonTranslation('SUCCESS'));

	        			}
	        		}
	        	});
	        },
            resetDropDownFields : function(parentCombo, form) {
          	  var programGroupField = form.down('#programGroup');
                var programComboField = form.down('#programId');
                var batchField = form.down('#batchId');
                var seatTypeField = form.down('#seatTypeId');
          	  if(parentCombo == 'ACADEMYLOCATION') {
          		  programComboField.reset();
          		  batchField.reset();
          		  batchField.setDisabled(true);
          		  seatTypeField.reset();
          		  seatTypeField.setDisabled(true);
          	  } else if(parentCombo == 'PROGRAMGROUP') {
          		  programComboField.reset();
          		  batchField.reset();
          		  batchField.setDisabled(true);
          		  seatTypeField.reset();
          		  seatTypeField.setDisabled(true);
          	  } else if(parentCombo == 'PROGRAM') {
          		  batchField.reset();
          		  batchField.setDisabled(false);
          		  seatTypeField.reset();
          		  seatTypeField.setDisabled(true);
          	  } else if(parentCombo == 'BATCH') {
          		  seatTypeField.reset();
          		  seatTypeField.setDisabled(false);
          	  } 
            },
            closeEnqMulProgWindow: function() {
              this.getEnquiryMulProgramFormEdit().close();
              var form = this.getEnquirydetailformrevamp().getForm();
              var enquiryTypeField = form.findField('enquiryType');
              enquiryTypeField.getStore().load({
					callback: function(record, operation, success) {
						if (success) {
							for(var i in record) {
								if(record[i].data.code == 'Counselling'){
									enquiryTypeField.setValue(record[i].data.id);
								}
							}
							
						}
					}
				});
            },
            closeEnqMulProgWindowSetValue: function() {
                var form = this.getEnquirydetailformrevamp().getForm();
                var enquiryTypeField = form.findField('enquiryType');
                enquiryTypeField.getStore().load({
  					callback: function(record, operation, success) {
  						if (success) {
  							for(var i in record) {
  								if(record[i].data.code == 'Counselling'){
  									enquiryTypeField.setValue(record[i].data.id);
  								}
  							}
  							
  						}
  					}
  				});
              },
            setEnquiryStudentDetails: function(responseData,formWindow){
				var fieldOfInterest=formWindow.down('#fieldOfInterest');
	            fieldOfInterest.setVisible(false);
	            
	            formWindow.down("#admissionEnquiryDetailId").setValue(responseData[0].admissionEnquiryDetailId);
	            formWindow.down("#enquiryStudentDetailId").setValue(responseData[0].enquiryStudentDetailId);
	            
				var SFN = formWindow.down("#studentFname");
				var SMN = formWindow.down("#studentMname");
				var SLN = formWindow.down("#studentLname");
				var salutationMulProgram = formWindow.down("#salutation");
				
				var gradeElevenAverage = formWindow.down("#gradeElevenAverageItemId");
				var gradeTwelveAverage = formWindow.down("#gradeTwelveAverageItemId");
				var studentFirstNameOtherLanguage = formWindow.down("#studentFirstNameOtherLanguageItemId");
				var studentMiddleNameOtherLanguage = formWindow.down("#studentMiddleNameOtherLanguageItemId");
				var studentLastNameOtherLanguage = formWindow.down("#studentLastNameOtherLanguageItemId");
				
				var currentGradeId = formWindow.down("#currentGradeItemId");;
				var enquiryStudentSchoolSubjectids = formWindow.down("#enquiryStudentSchoolSubjectItemId");
				
				//V2D-165735
				  /*var enquiryStudSchoolSubjStore = enquiryStudentSchoolSubjectids.getStore();
					  
					  if(!isNullOrEmpty(responseData[0].wsEnquiryStudentSchoolSubject)) {
						enquiryStudSchoolSubjStore.load({
							  callback: function(records, operation, success) {
								  if (success) {
									  var enquiryStudSchoolSubj= [];
									  if(records.length > 0){
										  responseData[0].wsEnquiryStudentSchoolSubject.forEach(function(enquiryStudSchoolSubjrec){
											  var result = records.filter(function (obj) {
												  return obj.data.code === enquiryStudSchoolSubjrec.enquiryStudentSubject;
											  })[0];
											  enquiryStudSchoolSubj.push(result.data.code);
										  });
										enquiryStudentSchoolSubjectids.setValue(enquiryStudSchoolSubj);
									  }
								  }
							  }
						  });
					  }*/
				
				
				
				var dobField=formWindow.down("#studentDateOfBirth");
				var programId = formWindow.down('#programId');
				programId.enable(true);
				if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
					dobField.allowBlank = false;
					var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
					dobField.labelSeparator = '';
					dobField.setFieldLabel(getEnquiryTranslation('DATE_OF_BIRTH')+allowblankFalse);
				}
				
				if(!isNullOrEmpty(responseData[0].salutationId)){
					salutationMulProgram.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
									if(record[i].data.id == responseData[0].salutationId){
										salutationMulProgram.setValue(record[i].data.id);
									}
								}
							}
						}
					});
				}
				if(!isNullOrEmpty(responseData[0].currentGradeId)){
					currentGradeId.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
									if(record[i].data.id == responseData[0].currentGradeId){
										currentGradeId.setValue(record[i].data.id);
									}
								}
							}
						}
					});
				}
				
				SFN.setValue(responseData[0].firstName);
				SMN.setValue(responseData[0].middleName);
				SLN.setValue(responseData[0].lastName);
				gradeElevenAverage.setValue(responseData[0].gradeElevenAverage);
				gradeTwelveAverage.setValue(responseData[0].gradeTwelveAverage);
				studentFirstNameOtherLanguage.setValue(responseData[0].studentFirstNameOtherLanguage);
				studentMiddleNameOtherLanguage.setValue(responseData[0].studentMiddleNameOtherLanguage);
				studentLastNameOtherLanguage.setValue(responseData[0].studentLastNameOtherLanguage);
				
				var modeDeliveryField = formWindow.down("#modeDeliveryId");
				if(!isNullOrEmpty(responseData[0].modeOfDeliveryCSM)){
					modeDeliveryField.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
    								if(record[i].data.value == responseData[0].modeOfDeliveryCSM){
    									modeDeliveryField.setValue(record[i].data.id);
    								}
    							}
							}
						}
					});
				}	
				var registrationTypeField = formWindow.down("#registrationTypeId");
				if(!isNullOrEmpty(responseData[0].registrationTypeCSM)){
					registrationTypeField.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
    								if(record[i].data.value == responseData[0].registrationTypeCSM){
    									registrationTypeField.setValue(record[i].data.id);
    								}
    							}
							}
						}
					});
				}
				var registrationTypeEnumValue ;
				var academyLocationField = formWindow.down("#academyLocationId");
				var programCombo=formWindow.down('#programId');
				var registrationType=formWindow.down("#registrationTypeId");
				if(!isNullOrEmpty(responseData[0].academyLocationId)){
					academyLocationField.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
    								if(record[i].data.id == responseData[0].academyLocationId){
    									academyLocationField.setValue(record[i].data.id);
    									programCombo.setDisabled(false);
    									if(registrationType.getValue() == 'PART_TIME' ){
    										registrationTypeEnumValue = true ;
    									}
    									else if(registrationType.getValue() == 'FULL_TIME' )
    										{
    										registrationTypeEnumValue = false ; 
    										}
				          				  programCombo.getStore().getProxy().extraParams = {
				          					  academyLocationIds: record[i].data.id,
				          					  isOtherBlankProgramRequired:false,
				          					registrationTypeEnum :registrationTypeEnumValue,
				          					modeOfDeliveryId:modeDeliveryField.getValue()
				      					  };
				          				/*  if(!isNullOrEmpty(registrationType.value())){
				          					  programCombo.getStore().getProxy().extraParams.registrationTypeId= registrationType.value();
				          				  }*/
				          				  programCombo.getStore().load();
    								}
    							}
							}
						}
					});
				}
				var countryCodeField = formWindow.down("#countryCodeItemId");
				if(!isNullOrEmpty(responseData[0].mobileCountryCode)){
					countryCodeField.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
    								if(record[i].data.isdCode == responseData[0].mobileCountryCode){
    									countryCodeField.setValue(responseData[0].mobileCountryCode);
    								}
    							}
							}
						}
					});	
				}
				var mobileNumberField = formWindow.down("#mobileNumberItemId");
				mobileNumberField.setValue(responseData[0].mobileNumber);
				var alternateMobileCountryCodeField = formWindow.down("#alternateMobileCountryCode");
				if(!isNullOrEmpty(responseData[0].alternateMobileCountryCode)){
					alternateMobileCountryCodeField.getStore().load({
						callback : function(record,success) {
							if (success){
								for(var i in record) {
    								if(record[i].data.isdCode == responseData[0].alternateMobileCountryCode){
    									alternateMobileCountryCodeField.setValue(responseData[0].alternateMobileCountryCode);
    								}
    							}
							}
						}
					});	
				}
				var alternateMobileNoField = formWindow.down("#alternateMobileNo");
				alternateMobileNoField.setValue(responseData[0].alternateMobileNo);
				var emailIdField = formWindow.down("#emailId");
				emailIdField.setValue(responseData[0].emailId);
				dobField.setValue(responseData[0].dateOfBirth);
				var nationalIdField = formWindow.down("#nationalId");
				nationalIdField.setValue(responseData[0].nationalId);
				var isLearnerSACitizenFld = formWindow.down('form').getForm().findField('isLearnerSACitizen');
            	  var isLearnerSACitizenRadioGroup = formWindow.down('#isLearnerSACitizenItemId');
            	  
            	  if( !isNullOrEmpty(responseData[0].isLearnerSACitizen) && responseData[0].isLearnerSACitizen != undefined && responseData[0].isLearnerSACitizen == true ){
            		  isLearnerSACitizenRadioGroup.items.items[0].setValue(true);
            		  isLearnerSACitizenRadioGroup.items.items[1].setValue(false);
            	  }
            	  if( !isNullOrEmpty(responseData[0].isLearnerSACitizen) && responseData[0].isLearnerSACitizen != undefined && responseData[0].isLearnerSACitizen == false ){
            		  isLearnerSACitizenRadioGroup.items.items[0].setValue(false);
            		  isLearnerSACitizenRadioGroup.items.items[1].setValue(true);
            	  }
            	  
            	  isLearnerSACitizenFld.setValue(responseData[0].isLearnerSACitizen);
            	  
            	  var registrationTypeIdCombo = formWindow.down('#registrationTypeId');
/*            	  registrationTypeIdCombo.getStore().load({
            		  callback: function(records, operation, success) {
            			  if(records.length>0){
            				  for(var i in records){
                				  if(responseData[0].batchPartTime == true && records[i].data.id == 'PART_TIME'){
                					  registrationTypeIdCombo.setValue(records[i].data.id);
                				  }else{
                					  registrationTypeIdCombo.setValue(records[i].data.id); 
                				  }
                			  }  
            			  }
            		  } 
  			  });
   */         },
      	  checkEnqOrgSiblling : function(radioGroup){
    		  var siblingDetailsComponent = radioGroup.up('enquirydetailformrevamp').down('#siblingDetailsComponent');
    		  siblingDetailsComponent.setVisible(radioGroup.getValue().whetherSiblingStudying);
    	  },
    	  setStudentDetailsOnEnquirytab:function(enquiryType,form,this$,data,buttonId){
    		  var enquiryStudentDetail = new Academia.model.enquiry.studentDetail.StudentDetailModel(data.enquiryStudentDetailsForEnquiry);
    		  form.getForm().loadRecord(enquiryStudentDetail);
    		  var getData = data.enquiryStudentDetailsForEnquiry;
    		  
    		  if( !isNullOrEmpty(getData) && !isNullOrEmpty(getData.customData) ){
    			  var customFields = getData.customData;
    			  for(var i in customFields) {
    				  customFields[i].id = customFields[i].customHiddenId;
    				  delete customFields[i].customHiddenId;
    				  delete customFields[i].customHiddenVersion;
    			  }
    		  }
    		  
    		  if(!isNullOrEmpty(getData.nationalId)){
    			  form.down('#enQStdNationalId').setValue(getData.nationalId);
    		  }
    		  form.down('#setStudentDetailModel').setValue(Ext.encode(getData));
    		  
    		  var genderField = form.down('#enQStudentDetails_gender');
			  genderField.getStore().load({
				  callback: function(record, operation, success) {
					  if (success) {
						  for(var i in record) {
							  if(getData.genderCSM!=null) {
	    					  	if(record[i].data.id ==getData.genderCSM.id) {
	    							  genderField.setValue(record[i].data.id);
	    					 	}
    					 	 }
						  }
					  }
				  }
			  });
    		  
    		  var studentDateofBirthField = form.down('#enQStudentDetails_studentDateOfBirth');
    		  studentDateofBirthField.setValue(dateRender(getData.studentDateOfBirth));
    		  
    		  var enQStdEmailIdField = form.down('#enQStdEmailId');
    		  enQStdEmailIdField.setValue(getData.fatherEmailId);
    		  
    		  var enQStdCountryCodeField = form.down('#enQStdCountryCodeItemId');
    		  enQStdCountryCodeField.getStore().load({
				  callback: function(record, operation, success) {
					  if (success) {
						  for(var i in record) {
							  if(record[i].data.isdCode == getData.fatherPhoneCountryCode){
								  enQStdCountryCodeField.setValue(record[i].data.isdCode); 
							  }
							  if(isNullOrEmpty(getData.fatherPhoneCountryCode)){
  								if(!isNullOrEmpty(Ext.app.defaultCountryCode)){
  									enQStdCountryCodeField.setValue(Ext.app.defaultCountryCode);
  								}
  							}
						  }
					  }
				  }
			  });
    		  
    		  var enQStdMobileNumberField = form.down('#enQStdMobileNumberItemId');
    		  enQStdMobileNumberField.setValue(getData.fatherPhoneNo);
    		  
    		  var isLearnerSACitizenFld = form.getForm().findField('isLearnerSACitizen');
    		  var isLearnerSACitizenRadioGroup = form.down('#enQStdIsLearnerSACitizenItemId');
    		  if( !isNullOrEmpty(getData.isLearnerSACitizen) && getData.isLearnerSACitizen != undefined && getData.isLearnerSACitizen == true ){
    			  isLearnerSACitizenRadioGroup.items.items[0].setValue(true);
    			  isLearnerSACitizenRadioGroup.items.items[1].setValue(false);
    		  }
    		  if( !isNullOrEmpty(getData.isLearnerSACitizen) && getData.isLearnerSACitizen != undefined && getData.isLearnerSACitizen == false ){
    			  isLearnerSACitizenRadioGroup.items.items[0].setValue(false);
    			  isLearnerSACitizenRadioGroup.items.items[1].setValue(true);
    		  }

    		  isLearnerSACitizenFld.setValue(getData.isLearnerSACitizen);

    		  if(!isNullOrEmpty(getData.sibilingUser1)){
    			  var sibilingUser1 = this$.getStore('enquiry.ReferredIdStore2');
    			  sibilingUser1.getProxy().extraParams = {
    				  name: getData.sibilingUser1.code,
    				  isMultiAccessAllowForSibiling:true
    			  };
    			  sibilingUser1.load({
    				  callback: function(record, operation, success) {
    					  if (success) {
    						  form.down('#enQStudentDetails_addmissionIdofsiblling1').setValue(getData.sibilingUser1.id);
    					  }
    				  }
    			  });
    		  }if(!isNullOrEmpty(getData.sibilingUser2)){
    			  var sibilingUser2 = this$.getStore('enquiry.ReferredIdStore3');
    			  sibilingUser2.getProxy().extraParams = {
    				  name: getData.sibilingUser2.code,
    				  isMultiAccessAllowForSibiling:true
    			  };
    			  sibilingUser2.load({
    				  callback: function(record, operation, success) {
    					  if (success) {
    						  form.down('#enQStudentDetails_addmissionIdofsiblling2').setValue(getData.sibilingUser2.id);
    					  }
    				  }
    			  });
    		  }if(!isNullOrEmpty(getData.sibilingUser3)){
    			  var sibilingUser3 = this$.getStore('enquiry.ReferredIdStore4');
    			  sibilingUser3.getProxy().extraParams = {
    				  name: getData.sibilingUser3.code,
    				  isMultiAccessAllowForSibiling:true
    			  };
    			  sibilingUser3.load({
    				  callback: function(record, operation, success) {
    					  if (success) {
    						  form.down('#enQStudentDetails_addmissionIdofsiblling3').setValue(getData.sibilingUser3.id);
    					  }
    				  }
    			  });
    		  }
    		  if(enquiryType!='Admission' && data.enquiryStudentDetailsForEnquiry.id == null){
    			  this$.validateStudentDetails(form,true);
    		  }
    		  if(enquiryType=='Counselling'){
    			  form.down('#enqIntakeYearItemId').setVisible(true);
    			  var $this = this;
    			  Ext.Ajax.request({
    				  type: 'rest',
    				  async: false,
    				  url: SERVERURL.COMMON_FORM_FIELD_INFO,
    				  params: {
    					  screenName: 'enquirydetailformrevamp',
    					  academyLocationId: this.getCurrentAcademyLocation(),
    					  languageCode:'en'
    				  },
    				  method: 'GET',
    				  success: function(res, action) {
    					  var response = Ext.decode(res.responseText);
    					  if( Object.keys(response).length > 0 ){
    						  var records=response.enquirydetailformrevamp;
    						  for(i in records){
    							  if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='enqIntakeYearItemId' && records[i].isVisible==false){
    								  form.down('#enqIntakeYearItemId').setVisible(false);
    							  }
    						  }
    					  }
    				  }
    			  });
    		  }else{
    			  form.down('#enqIntakeYearItemId').setVisible(false);
    		  }
    	  },
    	  validateStudentDetails:function(form,value){
    		  form.down('#enQStudentDetails_studentDateOfBirth').setReadOnly(value);
    		  form.down('#enQAgeAsOnBirthDate').setReadOnly(value);
    		  form.down('#enQStudentDetails_gender').setReadOnly(value);
    		  form.down('#enQStdIsLearnerSACitizenItemId').setReadOnly(value);
    		  form.down('#enQStdNationalId').setReadOnly(value);
    		  form.down('#fatherSalutationId').setReadOnly(value);
    		  form.down('#enQStudentDetails_fatherFirstName').setReadOnly(value);
    		  form.down('#enQStudentDetails_fatherLastName').setReadOnly(value);
    		  form.down('#enQStdEmailId').setReadOnly(value);
    		  form.down('#enQStdCountryCodeItemId').setReadOnly(value);
    		  form.down('#enQStdMobileNumberItemId').setReadOnly(value);
    		  form.down('#enQSD_radioBtn_orgSiblling').setReadOnly(value);
    		  form.down('#enQStudentDetails_addmissionIdofsiblling1').setReadOnly(value);
    		  form.down('#enQStudentDetails_addmissionIdofsiblling2').setReadOnly(value);
    		  form.down('#enQStudentDetails_addmissionIdofsiblling3').setReadOnly(value);
    	  },
          loadDFRForSchoolPriority: function(schoolPriorityField){
          	var $this = this;
          	Ext.Ajax.request({
          		type: 'rest',
          		async: false,
          		url: SERVERURL.COMMON_FORM_FIELD_INFO,
          		params: {
          			screenName: 'enquirydetailformrevamp',
          			academyLocationId: this.getCurrentAcademyLocation(),
          			languageCode:'en'
          		},
          		method: 'GET',
          		success: function(res, action) {
          			var response = Ext.decode(res.responseText);
          			if( Object.keys(response).length > 0 ){
          				var records=response.enquiryformrevamp;
          				for(i in records){
          					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='schoolPriority' && records[i].isVisible==false){
          						schoolPriorityField.setVisible(false);
          					}
          					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='schoolPriorityNew' && records[i].isVisible==true){
           						schoolPriorityField.setVisible(true);
           					}
          				}
          			}else{
           				schoolPriorityField.setVisible(true);
           			}
          		}
          		
          	});
          	
          },
    	  
    	  loadDFRForsourceOther: function(sourceOther){
            	var $this = this;
            	Ext.Ajax.request({
            		type: 'rest',
            		async: false,
            		url: SERVERURL.COMMON_FORM_FIELD_INFO,
            		params: {
            			screenName: 'enquirydetailformrevamp',
            			academyLocationId: this.getCurrentAcademyLocation(),
            			languageCode:'en'
            		},
            		method: 'GET',
            		success: function(res, action) {
            			var response = Ext.decode(res.responseText);
            			if( Object.keys(response).length > 0 ){
            				var records=response.enquirydetailformrevamp;
            				var k=false;
            				for(i in records){
            					if(records[i].formFieldInputType=='textfield' && records[i].formFieldName=='enquirySourceOther' && records[i].isVisible==true){
            						sourceOther.setVisible(true);
            						k=true;
            						break;
            					}
            				}
            				if(k==false){
            					sourceOther.setVisible(false);
            				}
            		   } 
            		}
            		
            	});
            	
            },
            loadDFRForMobileNumber: function(numberContainer){
              	var $this = this;
              	var form = $this.getEnquirydetailformrevamp();
              	var mobileCodeField = form.down('#enquiryDetail_cellCountrycode');
				var mobileNumberField = form.down('#enquiryDetail_cellNumber');
              	Ext.Ajax.request({
              		type: 'rest',
              		async: false,
              		url: SERVERURL.COMMON_FORM_FIELD_INFO,
              		params: {
              			screenName: 'enquirydetailformrevamp',
              			academyLocationId: this.getCurrentAcademyLocation(),
              			languageCode:'en'
              		},
              		method: 'GET',
              		success: function(res, action) {
              			var response = Ext.decode(res.responseText);
              			if( Object.keys(response).length > 0 ){
              				var records=response.enquirydetailformrevamp;
              				for(i in records){
              					if(records[i].formFieldInputType=='fieldcontainer' && records[i].formFieldId=='parentAddressMobileNo' && records[i].isMandatory==true && records[i].isVisible==true){
              						mobileCodeField.setFieldLabel('');
              						mobileNumberField.setFieldLabel('');
              						mobileCodeField.allowBlank=false;
              						mobileNumberField.allowBlank=false;
              					}
              				}
              			}
              		}
              	});
              	
              }
});