/**
 * @author Deepika Parmar
 * 
 **/
Ext.define('Academia.controller.examexecution.StudentMarkRemarkEntryFacultyController', {
	extend: 'Academia.controller.base.BaseController',
	models: ['common.IdValueCodeDataModel'
		],
		stores: ['examexecution.StudentMarkRemarkStore','examexecution.StudentRemarkCourseStore','examexecution.StudentRemarkProgramStore',
			'examexecution.StudentRemarkBatchStore','examexecution.StudentRemarkPeriodStore','examexecution.StudentRemarkSectionStore','examexecution.StudentRemarkEvalPlanStore',
			'examexecution.StudentMarkRemarkGridStore','gradeMaster.GradeGroupMapping','examexecution.StudentMarkRemarkCheckHistoryGridStore'],
			views: ['examexecution.StudentMarkRemarkEntryFacultyStructure','examexecution.StudentMarkRemarkEntryFacultyFilter','examexecution.StudentMarkRemarkEntryFacultyGrid',
				'examexecution.StudentMarkRemarkEntryCheckHistoryWindow','examexecution.checkHistoryWindowGrid'],
			config: {
				STUDENT_MARK_REMARK_ENTRY_FACULTY_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_MARK_REMARK_ENTRY_FACULTY_PRIVILEGES'),

			},
			refs: [{
				ref:'studentmarkremarkentryfacultyfilter',
				selector:'studentmarkremarkentryfacultyfilter'
			},{
				ref:'studentmarkremarkfacultystructure',
				selector:'studentmarkremarkfacultystructure'
			},{
				ref:'studentmarkremarkentryfacultygrid',
				selector:'studentmarkremarkentryfacultygrid'
			},{
				ref:'studentmarkremarkentrycheckhistorywindow',
				selector:'studentmarkremarkentrycheckhistorywindow'				
			},{
				ref:'checkhistorywindowgrid',
				selector: 'checkhistorywindowgrid'
			}],
			init: function() {
				this.control({
					'studentmarkremarkfacultystructure':{
						beforerender: function(structure){
							var permissionsMap = this.getSTUDENT_MARK_REMARK_ENTRY_FACULTY_PERMISSION(),
								associatedAcadLocationIds = new Array(),
								permissionList;
							var grid = this.getActiveTabfromContentPanel().down('studentmarkremarkentryfacultygrid');
							Ext.defer(function() {
								if(grid.getRootNode().childNodes) {
									grid.getRootNode().removeAll();
								}
							}, 1000);
				        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				        	permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				        	
				        	if(Ext.Array.contains(permissionList, 'SAVE')){
				        		structure.saveButtonHidden = false;
				        	}
				        	else {
				        		structure.saveButtonHidden = true;
				        	}
				        	
				        	if(Ext.Array.contains(permissionList, 'SUBMIT')){
				        		structure.submitButtonHidden = false;
				        	}
				        	else {
				        		structure.submitButtonHidden = true;
				        	}
				        	
				        	if(Ext.Array.contains(permissionList, 'DELETE_MARKS_GRADE')){
				        		structure.deleteMarksGradeHidden = false;
				        	}
				        	else {
				        		structure.deleteMarksGradeHidden = true;
				        	}
				        	
				        	if(Ext.Array.contains(permissionList, 'PUBLISH_MARKS_GRADE')){
				        		structure.publishMarksGradeHidden = false;
				        	}
				        	else {
				        		structure.publishMarksGradeHidden = true;
				        	}
				        	
				        	if(Ext.Array.contains(permissionList, 'CREATE')){
				        		structure.createRemarkHidden = false;
				        	}
				        	else {
				        		structure.createRemarkHidden = true;
				        	}
				        	
				        	if(Ext.Array.contains(permissionList, 'EDIT')){
				        		structure.editRemarkHidden = false;
				        	}
				        	else {
				        		structure.editRemarkHidden = true;
				        	}

				        	if(Ext.Array.contains(permissionList, 'DELETE')){
				        		structure.deleteRemarkHidden = false;
				        	}
				        	else {
				        		structure.deleteRemarkHidden = true;
				        	}
				        	if(Ext.Array.contains(permissionList, 'UNPUBLISH_MARKS_GRADE')){
				        		structure.unpublishMarksGradeHidden = false;
				        	}
				        	else {
				        		structure.unpublishMarksGradeHidden = true; 
				        	}
				        	if(Ext.Array.contains(permissionList, 'CHECK_HISTORY')){
				        		structure.checkHistoryHidden = false;
				        	}
				        	else {
				        		structure.checkHistoryHidden = true; 
				        	}
						}
					},
					'studentmarkremarkentryfacultygrid':{
						afterrender: function(grid){
							var me = this,
							saveButton = grid.down('#studentMarkRemarkSaveBtn'),
							submitButton = grid.down('#studentMarkRemarkSubmitBtn'),
							deleteMarksGradeButton = grid.down('#deleteMarksGradeBtn'),
							publishMarksGradeButton = grid.down('#publishMarksGradeBtn'),
							unpublishMarksGradeButton = grid.down('#unpublishMarksGradeBtnFaculty'),
							studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
							checkHistoryButton = grid.down('#checkHistoryBtnFaculty'),	
							gridColumns = grid.columnManager.columns;
							
							Ext.each(gridColumns, function(currentColumn){
								if(currentColumn.dataIndex=="penaltyMarks" || currentColumn.dataIndex=="graceMarks"){
									currentColumn.hide();
								}
							});

							saveButton.setVisible(!studentmarkremarkfacultystructure.saveButtonHidden);
							submitButton.setVisible(!studentmarkremarkfacultystructure.saveButtonHidden);
							deleteMarksGradeButton.setVisible(!studentmarkremarkfacultystructure.deleteMarksGradeHidden);
							publishMarksGradeButton.setVisible(!studentmarkremarkfacultystructure.publishMarksGradeHidden);
							unpublishMarksGradeButton.setVisible(!studentmarkremarkfacultystructure.unpublishMarksGradeHidden);
							checkHistoryButton.setVisible(!studentmarkremarkfacultystructure.checkHistoryHidden);

							grid.getStore().on('load',function(){
								if(grid.getRootNode().childNodes.length){
									grid.getRootNode().childNodes[0].cascadeBy(function (node) {
										if (node.getDepth() < 2) { 
											node.expand();
										}
										if (node.getDepth() > 1) { return false; }
									});
								}
							});
						},
						beforeitemdblclick: function( d, record, item, index, e, eOpts ){
							return false;
						},
						afteritemexpand: function( node, index, item, eOpts ){
							var me = this;
							node.expand(true);
						},
						headerclick: function( ct, column, e, t, eOpts ){
							var me = this;
							var headerClick = true; 
							if(e.target.type=="checkbox"){
								var nodes = [];
								try{
									var nodes = ct.grid.getRootNode().childNodes;
									Ext.each(nodes, function(currentNode){
										if(currentNode.hasChildNodes()){
											currentNode.set('checked', t.checked);
											currentNode.cascadeBy(function(node) {
												node.set('checked', t.checked);
											});
										}
										
										me.selectParentNodesTreePanel(currentNode, t.checked, headerClick);
									})
								}
								catch(e){
									console.log('');
								}
							}
						},
						checkchange: function(node, checked, eOpts) {
							var me = this;
							var headerClick = false;
							if(node.hasChildNodes()){
								node.set('checked', checked);
								node.cascadeBy(function(node) {
									node.set('checked', checked);
								});
							}
							me.selectParentNodesTreePanel(node, checked, headerClick);
						},
						beforerender: this.reconfigureGridWithVisibility
					},
					'studentmarkremarkentryfacultyfilter' :{
						afterrender: function(filter){
							var $this= this;
							var academicTerm = filter.down('#academicTerm');
							var studentName = filter.down('#studentNameItemId');
							var evaluationplantype= filter.down('#evaluationplantypeItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var facultyId = $this.getCurrentlyLoggedInUser();

							academicTerm.getStore().load({
								callback:function(records){
									Ext.Array.each(records,function(val){
										if(val.get('sequence') == 1){
											academicTerm.setValue(val.data.id);
											studentName.reset();
											studentName.setDisabled(false);
											studentName.getStore().getProxy().extraParams = {
												academicTermId :val.data.id,
												academyLocationId :academyLocationIds,
												facultyId:facultyId.id
											}
											studentName.getStore().load({
												callback:function(studentRecords){
													if(studentRecords.length ==1){
														studentName.setValue(studentRecords[0].data.id);
														$this.onSelectStudentName(null,studentRecords)
													}
												}
											});
										}
									});
								}
							});
							evaluationplantype.getStore().load({
								callback: function(records){
									evaluationplantype.setValue(records[0].data.id);
								}
							});
						}
					},
					'studentmarkremarkentryfacultyfilter customcombobox#academicTerm' :{
						select: function(combo,record){
							var $this  = this;
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var studentName = filter.down('#studentNameItemId');
							var evaluationplantype= filter.down('#evaluationplantypeItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();

							var evaluationLevelField = filter.down('#evalPlanLevelItemId');
							var evaluationPlanItemId = filter.down('#evaluationPlanItemId');
							var detailSequenceItemId = filter.down('#detailSequenceItemId');
							var courseItemId = filter.down('#courseItemId');
							var programIdItemId= filter.down('#programIdItemId');
							var batchIdItemId= filter.down('#batchIdItemId');
							var periodIdItemId= filter.down('#periodIdItemId');
							var sectionIdItemId= filter.down('#sectionIdItemId');
							var facultyId = $this.getCurrentlyLoggedInUser();

							evaluationLevelField.reset();
							evaluationPlanItemId.reset();
							detailSequenceItemId.reset();
							courseItemId.reset();
							programIdItemId.reset();
							batchIdItemId.reset();
							periodIdItemId.reset();
							sectionIdItemId.reset();


							evaluationLevelField.disable();
							evaluationPlanItemId.disable();
							detailSequenceItemId.disable();
							courseItemId.disable();
							programIdItemId.disable();
							batchIdItemId.disable();
							periodIdItemId.disable();
							sectionIdItemId.disable();


							studentName.reset();
							studentName.enable();
							studentName.getStore().getProxy().extraParams ={
								academicTermId :record[0].data.id,
								academyLocationId :academyLocationIds,
								facultyId : facultyId.id
								
							}
							studentName.getStore().load({
								callback:function(studentRecords){
									if(studentRecords.length ==1){
										studentName.setValue(studentRecords[0].data.id);

										$this.onSelectStudentName(null,studentRecords)
									}
								}
							});

						}
					},
					'studentmarkremarkentryfacultyfilter customcombobox#studentNameItemId' :{
						select: function(combo,record){
							this.onSelectStudentName(combo,record);
						}
					},
					'studentmarkremarkentryfacultyfilter customcombobox#evaluationPlanItemId' :{
						select: function(combo,record){ 
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue =filter.getForm().getValues();
							var evaluationLevelField = filter.down('#evalPlanLevelItemId');
							var detailSequenceItemId = filter.down('#detailSequenceItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							detailSequenceItemId.reset();
							detailSequenceItemId.enable();
							var isDynamicScheme=false;
							if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
								if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
									isDynamicScheme=true;
								}
							}
							detailSequenceItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,												
								evalPlanId : formValue.evaluationPlan,
								isDynamicScheme :isDynamicScheme,
							
							}

							detailSequenceItemId.getStore().load({
								callback : function(records){
									if(records.length == 1){
										detailSequenceItemId.setValue(records[0].data.id);
									}
								}
							});
							evaluationLevelField.reset();
							evaluationLevelField.setDisabled(false);

							evaluationLevelField.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,								
								evaluationPlanId : formValue.evaluationPlan,
								isStatus:false
							}
							evaluationLevelField.getStore().load({
								callback :function(records){
									evaluationLevelField.reset();
									evaluationLevelField.enable();
									if(records.length == 1){
										evaluationLevelField.setValue(records[0].data.id);
										var isDynamicScheme=false;
										if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
											if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
												isDynamicScheme=true;
											}
										}
										detailSequenceItemId.getStore().getProxy().extraParams ={
											academyLocationIds :academyLocationIds,
											academicTermId :formValue.academicTerm,												
											evalPlanId : formValue.evaluationPlan,
											isDynamicScheme :isDynamicScheme,
										}
										detailSequenceItemId.reset();
										detailSequenceItemId.enable();

										detailSequenceItemId.getStore().load({
											callback : function(records){
												if(records.length == 1){
													detailSequenceItemId.setValue(records[0].data.id);
												}
											}
										});
									}
								}
							});
						} 
					},
					'studentmarkremarkentryfacultyfilter groupingcombobox#evalPlanLevelItemId' :{
						select: function(combo,record){ 

							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue =filter.getForm().getValues();
							var evaluationLevelField = filter.down('#evalPlanLevelItemId');
							var detailSequenceItemId = filter.down('#detailSequenceItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();

							var levelOneId=null;
							var levelTwoId=null; 
							var levelThreeId=null;
							if(!isNullOrEmpty(record[0].data.code)){
								if(record[0].data.code=="Assessment Method"){
									levelThreeId=record[0].data.levelId;
								}else if(record[0].data.code=="Assessment Sub Type"){
									levelTwoId=record[0].data.levelId;
								}else if(record[0].data.code=="Assessment Type"){
									levelOneId=record[0].data.levelId;
								}
							}
							detailSequenceItemId.reset();
							detailSequenceItemId.enable();
							var isDynamicScheme=false;
							if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
								if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
									isDynamicScheme=true;
								}
							}
							detailSequenceItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,												
								evalPlanId : formValue.evaluationPlan,
								isDynamicScheme:isDynamicScheme,
								evaluationPlanLevelOneId: levelOneId,
								evaluationPlanLevelTwoId: levelTwoId,
								evaluationSequenceId: levelThreeId,
								
							}
							detailSequenceItemId.getStore().load({
								callback : function(records){
									if(records.length == 1){
										detailSequenceItemId.reset();
										detailSequenceItemId.enable();
										detailSequenceItemId.setValue(records[0].data.id);
									}
								}
							});

						} 
					},
					'studentmarkremarkentryfacultyfilter customcombobox#evaluationplantypeItemId' :{
						select: function(combo,record){
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue = filter.getForm().getValues();
							var courseItemId = filter.down('#courseItemId');
							var programIdItemId= filter.down('#programIdItemId');
							var batchIdItemId= filter.down('#batchIdItemId');
							var periodIdItemId= filter.down('#periodIdItemId');
							var sectionIdItemId= filter.down('#sectionIdItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var evaluationLevelField = filter.down('#evalPlanLevelItemId');
							var evaluationPlanItemId = filter.down('#evaluationPlanItemId');
							var detailSequenceItemId = filter.down('#detailSequenceItemId');
							var academicTerm = filter.down('#academicTerm');
							var facultyId = this.getCurrentlyLoggedInUser();

							if(record[0].data.id == "OTHER"){
								courseItemId.setVisible(false);
								programIdItemId.setVisible(true);
								batchIdItemId.setVisible(true);
								periodIdItemId.setVisible(true);
								sectionIdItemId.setVisible(true);
							if(!isNullOrEmpty(formValue.studentName)){
								programIdItemId.reset();
								programIdItemId.enable();
								programIdItemId.getStore().getProxy().extraParams ={
									academyLocationIds :academyLocationIds,
									academicTermId :formValue.academicTerm,
									studentId :formValue.studentName,
									facultyId : facultyId.id

								}

								programIdItemId.getStore().load({
									callback :function(programRecords){
										if(programRecords.length ==1 ){
											programIdItemId.setValue(programRecords[0].data.id);	
											batchIdItemId.reset();
											batchIdItemId.enable();

											batchIdItemId.getStore().getProxy().extraParams ={
												academyLocationIds :academyLocationIds,
												academicTermId :formValue.academicTerm,
												studentId :formValue.studentName,
												programId:programRecords[0].data.id
											}

											batchIdItemId.getStore().load({
												callback :function(batchRecords){
													if(batchRecords.length ==1){
														batchIdItemId.setValue(batchRecords[0].data.id);
														periodIdItemId.getStore().getProxy().extraParams = {
															academyLocationIds :academyLocationIds,
															academicTermId :formValue.academicTerm,
															studentId :formValue.studentName,
															batchId : batchRecords[0].data.id,
														}
														periodIdItemId.reset();
														periodIdItemId.enable();

														periodIdItemId.getStore().load({
															callback: function(periodRecords){
																if(periodRecords.length ==1){
																	periodIdItemId.setValue(periodRecords[0].data.id);
																	sectionIdItemId.reset();
																	sectionIdItemId.enable();
																	sectionIdItemId.getStore().getProxy().extraParams = {
																		academyLocationIds :academyLocationIds,
																		academicTermId :formValue.academicTerm,
																		studentId :formValue.studentName,
																		periodId : periodRecords[0].data.id,
																		facultyId :facultyId.id
																	}
																	sectionIdItemId.getStore().load({
																		callback: function(sectionRecords){
																			if(sectionRecords.length ==1){
																				sectionIdItemId.setValue(sectionRecords[0].data.id);
																			}
																		}
																	});
																}
															}
														});
													}
												}
											});

										}
									}
								});

								evaluationPlanItemId.getStore().getProxy().extraParams ={
									academyLocationIds :academyLocationIds,
									academicTermId :academicTerm.getValue(),
									studentId :formValue.studentName,
									planType :formValue.evaluationplantype,
									courseId :null
								}
								detailSequenceItemId.reset();
								detailSequenceItemId.disable();
								evaluationLevelField.reset();
								evaluationLevelField.disable();
								evaluationPlanItemId.reset();
								evaluationPlanItemId.enable();
								evaluationPlanItemId.getStore().load({
									callback: function(records){
										if(records.length == 1){
											evaluationPlanItemId.setValue(records[0].data.id);
											var isDynamicScheme=false;
											if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
												if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
													isDynamicScheme=true;
												}
											}
											detailSequenceItemId.enable();
											detailSequenceItemId.getStore().getProxy().extraParams ={
												academyLocationIds :academyLocationIds,
												academicTermId :academicTerm.getValue(),												
												evalPlanId : records[0].data.id,
												isDynamicScheme :isDynamicScheme,
											}

											detailSequenceItemId.getStore().load({
												callback : function(records){
													if(records.length == 1){
														detailSequenceItemId.setValue(records[0].data.id);
													}
												}
											});
											evaluationLevelField.getStore().getProxy().extraParams ={
												academyLocationIds :academyLocationIds,
												academicTermId :formValue.academicTerm,								
												evaluationPlanId : records[0].data.id,
												isStatus:false
											}
											evaluationLevelField.reset();
											evaluationLevelField.enable();

											evaluationLevelField.getStore().load({
												callback :function(records){
													if(records.length == 1){
														evaluationLevelField.setValue(records[0].data.id);
														var isDynamicScheme=false;
														if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
															if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
																isDynamicScheme=true;
															}
														}
														detailSequenceItemId.getStore().getProxy().extraParams ={
															academyLocationIds :academyLocationIds,
															academicTermId :formValue.academicTerm,												
															evalPlanId : records[0].data.id,
															isDynamicScheme :isDynamicScheme,
														}
														detailSequenceItemId.reset();
														detailSequenceItemId.enable();

														detailSequenceItemId.getStore().load({
															callback : function(records){
																if(records.length == 1){
																	detailSequenceItemId.setValue(records[0].data.id);
																}
															}
														});
													}
												}
											});
										}
									}
								});
							}
							}
							else if(record[0].data.id == "ACADEMICS"){
								
								courseItemId.reset();
								courseItemId.setVisible(true);
								programIdItemId.reset();
								programIdItemId.setVisible(false);
								batchIdItemId.reset();
								batchIdItemId.setVisible(false);
								periodIdItemId.reset();
								periodIdItemId.setVisible(false);
								sectionIdItemId.reset();
								sectionIdItemId.setVisible(false);
							if(!isNullOrEmpty(formValue.studentName)){

								courseItemId.enable();
								courseItemId.getStore().getProxy().extraParams ={
									academyLocationIds :academyLocationIds,
									academicTermId :academicTerm.getValue(),
									studentId :formValue.studentName,
									facultyId: facultyId //
								}
								courseItemId.getStore().load({
									callback: function(records){
										if(records.length ==1){
											courseItemId.setValue(records[0].data.id);
										}
									}
								});
								programIdItemId.reset();
								programIdItemId.enable();
								programIdItemId.getStore().getProxy().extraParams ={
									academyLocationIds :academyLocationIds,
									academicTermId :academicTerm.getValue(),
									studentId :formValue.studentName,
									facultyId:facultyId.id
								}
								programIdItemId.getStore().load({
									callback :function(programRecords){
										if(programRecords.length ==1 ){
											programIdItemId.setValue(programRecords[0].data.id);	
											batchIdItemId.reset();
											batchIdItemId.enable();

											batchIdItemId.getStore().getProxy().extraParams ={
												academyLocationIds :academyLocationIds,
												academicTermId :formValue.academicTerm,
												studentId :formValue.studentName,
												programId:programRecords[0].data.id,
											}

											batchIdItemId.getStore().load({
												callback :function(batchRecords){

													if(batchRecords.length ==1){
														batchIdItemId.setValue(batchRecords[0].data.id);
														periodIdItemId.reset();
														periodIdItemId.enable();

														periodIdItemId.getStore().getProxy().extraParams = {
															academyLocationIds :academyLocationIds,
															academicTermId :formValue.academicTerm,
															studentId :formValue.studentName,
															batchId :batchRecords[0].data.id,
														}
														periodIdItemId.getStore().load({
															callback: function(periodRecords){

																if(periodRecords.length ==1){
																	periodIdItemId.setValue(periodRecords[0].data.id);
																	sectionIdItemId.reset();
																	sectionIdItemId.enable();
																	sectionIdItemId.getStore().getProxy().extraParams = {
																		academyLocationIds :academyLocationIds,
																		academicTermId :formValue.academicTerm,
																		studentId :formValue.studentName,
																		periodId : periodRecords[0].data.id,
																		facultyId:facultyId.id
																	}
																	sectionIdItemId.getStore().load({
																		callback: function(sectionRecords){
																			if(sectionRecords.length ==1){
																				sectionIdItemId.setValue(sectionRecords[0].data.id);
																			}
																		}
																	});
																}
															}
														});
													}
												}
											});

										}
									}
								});
								evaluationPlanItemId.reset();
								evaluationPlanItemId.enable();

								evaluationLevelField.reset();
								evaluationLevelField.disable();

								detailSequenceItemId.reset();
								detailSequenceItemId.disable();

								evaluationPlanItemId.getStore().getProxy().extraParams ={
									academyLocationIds :academyLocationIds,
									academicTermId :academicTerm.getValue(),
									studentId :formValue.studentName,
									planType :formValue.evaluationplantype,
									//courseId :formValue.courseId
								}
								evaluationPlanItemId.getStore().load({
									callback: function(records){
										if(records.length == 1){

											evaluationPlanItemId.reset();
											evaluationPlanItemId.enable();
											evaluationPlanItemId.setValue(records[0].data.id);
											detailSequenceItemId.enable();
											detailSequenceItemId.reset();
											var isDynamicScheme=false;
											if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
												if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
													isDynamicScheme=true;
												}
											}
											detailSequenceItemId.enable();
											detailSequenceItemId.getStore().getProxy().extraParams ={
												academyLocationIds :academyLocationIds,
												academicTermId :academicTerm.getValue(),												
												evalPlanId : records[0].data.id,
												isDynamicScheme :isDynamicScheme,
											}

											detailSequenceItemId.getStore().load({
												callback : function(records){
													if(records.length == 1){
														detailSequenceItemId.setValue(records[0].data.id);
													}
												}
											});
											evaluationLevelField.getStore().getProxy().extraParams ={
												academyLocationIds :academyLocationIds,
												academicTermId :academicTerm.getValue(),								
												evaluationPlanId : records[0].data.id,
												isStatus:false
											}
											evaluationLevelField.reset();
											evaluationLevelField.enable();
											evaluationLevelField.getStore().load({
												callback :function(records){
													if(records.length == 1){
														evaluationLevelField.setValue(records[0].data.id);

														detailSequenceItemId.getStore().getProxy().extraParams ={
															academyLocationIds :academyLocationIds,
															academicTermId :academicTerm.getValue(),												
															evalPlanId : formValue.evaluationPlan,
															isDynamicScheme :isDynamicScheme,
														}
														detailSequenceItemId.reset();
														detailSequenceItemId.enable();

														detailSequenceItemId.getStore().load({
															callback : function(records){
																if(records.length == 1){
																	detailSequenceItemId.setValue(records[0].data.id);
																}
															}
														});
													}
												}
											});

										}
									}
								});

							}
							}
						}
					},
					'studentmarkremarkentryfacultyfilter multiselectcombofield#courseItemId' :{
						change: function(record,value){
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue = filter.getForm().getValues();
							var academyLocationIds = this.getCurrentAcademyLocation();
							var academicTerm = filter.down('#academicTerm');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var evaluationLevelField = filter.down('#evalPlanLevelItemId');
							var evaluationPlanItemId = filter.down('#evaluationPlanItemId');
							var detailSequenceItemId = filter.down('#detailSequenceItemId');
							evaluationLevelField.reset();
							evaluationLevelField.disable();
							detailSequenceItemId.reset();
							detailSequenceItemId.disable();


							var courseList=[];
							if(!isNullOrEmpty(formValue.courseId)){
								for(var i=0;i<formValue.courseId.length;i++){
									var courses=formValue.courseId[i];
									courseList.push(courses);
								}
							}
							evaluationPlanItemId.reset();
							evaluationPlanItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :academicTerm.getValue(),
								studentId :formValue.studentName,
								planType :formValue.evaluationplantype,
								courseId :courseList.join()
							}
							evaluationPlanItemId.getStore().load({
								callback: function(records){
									if(records.length == 1){
										evaluationPlanItemId.reset();
										evaluationPlanItemId.enable();
										evaluationPlanItemId.setValue(records[0].data.id);

										evaluationLevelField.getStore().getProxy().extraParams ={
											academyLocationIds :academyLocationIds,
											academicTermId :formValue.academicTerm,								
											evaluationPlanId :records[0].data.id,
											isStatus:false
										}
										evaluationLevelField.reset();
										evaluationLevelField.enable();
										
										var isDynamicScheme=false;
										if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
											if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
												isDynamicScheme=true;
											}
										}
										detailSequenceItemId.getStore().getProxy().extraParams ={
											academyLocationIds :academyLocationIds,
											academicTermId :formValue.academicTerm,												
											evalPlanId : records[0].data.id,
											isDynamicScheme :isDynamicScheme,
										}
										detailSequenceItemId.reset();
										detailSequenceItemId.enable();

										detailSequenceItemId.getStore().load({
											callback : function(records){
												if(records.length == 1){
													detailSequenceItemId.setValue(records[0].data.id);
												}
											}
										});

										evaluationLevelField.getStore().load({
											callback :function(records){
												if(records.length == 1){
													evaluationLevelField.setValue(records[0].data.id);
													var isDynamicScheme=false;
													if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
														if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
															isDynamicScheme=true;
														}
													}
													detailSequenceItemId.getStore().getProxy().extraParams ={
														academyLocationIds :academyLocationIds,
														academicTermId :formValue.academicTerm,												
														evalPlanId : formValue.evaluationPlan,
														isDynamicScheme :isDynamicScheme,
													}
													detailSequenceItemId.reset();
													detailSequenceItemId.enable();

													detailSequenceItemId.getStore().load({
														callback : function(records){
															if(records.length == 1){
																detailSequenceItemId.setValue(records[0].data.id);
															}
														}
													});
												}
											}
										});
									}
								}
							});

						},
						afterrender: function( combo, e, eOpts )
						{
							combo.inputEl.on('keyup', function(){
							if(combo.disabled){
								
								combo.clearAllDataFn()
							}
							});
						}
					},
					'studentmarkremarkentryfacultyfilter customcombobox#programIdItemId' :{
						select: function(combo,record){
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue = filter.getForm().getValues();
							var academicTerm = filter.down('#academicTerm');
							var programIdItemId= filter.down('#programIdItemId');
							var batchIdItemId= filter.down('#batchIdItemId');
							var periodIdItemId= filter.down('#periodIdItemId');
							var sectionIdItemId= filter.down('#sectionIdItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var facultyId = this.getCurrentlyLoggedInUser();

							batchIdItemId.reset();
							batchIdItemId.enable();
							batchIdItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,
								studentId :formValue.studentName,
								programId:record[0].data.id,
							}
							batchIdItemId.getStore().load({
								callback :function(batchRecords){
									if(batchRecords.length ==1){
										batchIdItemId.setValue(batchRecords[0].data.id);
										periodIdItemId.getStore().getProxy().extraParams = {
											academyLocationIds :academyLocationIds,
											academicTermId :formValue.academicTerm,
											studentId :formValue.studentName,
											batchId : formValue.batchId,
										}
										periodIdItemId.reset();
										periodIdItemId.enable();

										periodIdItemId.getStore().load({
											callback: function(periodRecords){
												if(periodRecords.length ==1){
													periodIdItemId.setValue(periodRecords[0].data.id);
													sectionIdItemId.reset();
													sectionIdItemId.enable();
													sectionIdItemId.getStore().getProxy().extraParams = {
														academyLocationIds :academyLocationIds,
														academicTermId :formValue.academicTerm,
														studentId :formValue.studentName,
														periodId : formValue.periodId,
														facultyId:facultyId.id
													}
													sectionIdItemId.getStore().load({
														callback: function(sectionRecords){
															if(sectionRecords.length ==1){
																sectionIdItemId.setValue(sectionRecords[0].data.id);	
															}
														}
													});
												}
											}
										});
									}
								}
							});
						}
					},
					'studentmarkremarkentryfacultyfilter customcombobox#batchIdItemId' :{
						select: function(combo,record){
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue = filter.getForm().getValues();
							var academicTerm = filter.down('#academicTerm');
							var programIdItemId= filter.down('#programIdItemId');
							var batchIdItemId= filter.down('#batchIdItemId');
							var periodIdItemId= filter.down('#periodIdItemId');
							var sectionIdItemId= filter.down('#sectionIdItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var facultyId = this.getCurrentlyLoggedInUser();

							periodIdItemId.reset();
							periodIdItemId.enable();
							periodIdItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,
								studentId :formValue.studentName,
								programId:formValue.programId,
								batchId : record[0].data.id,
							}
							periodIdItemId.getStore().load({
								callback: function(records){
									if(records.length ==1){
										periodIdItemId.setValue(records[0].data.id);
										sectionIdItemId.reset();
										sectionIdItemId.enable();
										sectionIdItemId.getStore().getProxy().extraParams = {
											academyLocationIds :academyLocationIds,
											academicTermId :formValue.academicTerm,
											studentId :formValue.studentName,
											periodId : formValue.periodId,
											facultyId: facultyId.id
										}
										sectionIdItemId.getStore().load({
											callback: function(sectionRecords){
												if(sectionRecords.length ==1){
													sectionIdItemId.setValue(sectionRecords[0].data.id);
												}
											}
										});
									}
								}
							});
						}
					},
					'studentmarkremarkentryfacultyfilter customcombobox#periodIdItemId' :{
						select: function(combo,record){
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue = filter.getForm().getValues();
							var academicTerm = filter.down('#academicTerm');
							var programIdItemId= filter.down('#programIdItemId');
							var batchIdItemId= filter.down('#batchIdItemId');
							var periodIdItemId= filter.down('#periodIdItemId');
							var sectionIdItemId= filter.down('#sectionIdItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var facultyId = this.getCurrentlyLoggedInUser();

							sectionIdItemId.reset();
							sectionIdItemId.enable();
							sectionIdItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,
								studentId :formValue.studentName,
								periodId:record[0].data.id,
								facultyId: facultyId.id
							}
							sectionIdItemId.getStore().load({
								callback: function(sectionRecords){
									if(sectionRecords.length ==1){
										sectionIdItemId.setValue(sectionRecords[0].data.id);
									}
								}
							});
						}
					},

					'studentmarkremarkentryfacultyfilter button#resetBtn' :{
						click:function(){
							var $this = this;
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var academicTerm = filter.down('#academicTerm');
							var studentName = filter.down('#studentNameItemId');
							var evaluationplantype= filter.down('#evaluationplantypeItemId');
							var evaluationLevelField = filter.down('#evalPlanLevelItemId');
							var evaluationPlanItemId = filter.down('#evaluationPlanItemId');
							var detailSequenceItemId = filter.down('#detailSequenceItemId');
							var courseItemId = filter.down('#courseItemId');
							var programIdItemId= filter.down('#programIdItemId');
							var batchIdItemId= filter.down('#batchIdItemId');
							var periodIdItemId= filter.down('#periodIdItemId');
							var sectionIdItemId= filter.down('#sectionIdItemId');
							var academyLocationIds = this.getCurrentAcademyLocation();
							var facultyId = $this.getCurrentlyLoggedInUser();
							var grid = this.getStudentmarkremarkentryfacultygrid();
							academicTerm.reset();
							studentName.reset();
							evaluationLevelField.reset();
							evaluationPlanItemId.reset();
							detailSequenceItemId.reset();
							courseItemId.reset();
							programIdItemId.reset();
							batchIdItemId.reset();
							periodIdItemId.reset();
							sectionIdItemId.reset();

							studentName.disable();
							evaluationLevelField.disable();
							evaluationPlanItemId.disable();
							detailSequenceItemId.disable();
							courseItemId.disable();
							programIdItemId.disable();
							batchIdItemId.disable();
							periodIdItemId.disable();
							sectionIdItemId.disable();

							courseItemId.setVisible(true);
							programIdItemId.setVisible(false);
							batchIdItemId.setVisible(false);
							periodIdItemId.setVisible(false);
							sectionIdItemId.setVisible(false);

							academicTerm.getStore().load({
								callback:function(records){
									Ext.Array.each(records,function(val){
										if(val.get('sequence') == 1){
											academicTerm.setValue(val.data.id);
											studentName.reset();
											studentName.setDisabled(false);
											studentName.getStore().getProxy().extraParams = {
												academicTermId :val.data.id,
												academyLocationId :academyLocationIds,
												facultyId :facultyId.id
											}
											studentName.getStore().load({
												callback:function(studentRecords){
													if(studentRecords.length ==1){
														studentName.setValue(studentRecords[0].data.id);
														$this.onSelectStudentName(null,studentRecords)
													}
												}
											});
										}
									});
								}
							});
							evaluationplantype.getStore().load({
								callback: function(records){
									evaluationplantype.setValue(records[0].data.id);
								}
							});
								grid.getStore().getRootNode().removeAll();
						}
					},
					'studentmarkremarkentryfacultyfilter button#searchBtn' :{
						click:function(){
							var me = this;
							var filter = this.getStudentmarkremarkentryfacultyfilter();
							var formValue = filter.getForm().getValues();
							var grid = this.getStudentmarkremarkentryfacultygrid();
							var markRemarkPanel = filter.up('#studentMarkRemarkFacultyPanel');
							markRemarkPanel.collapse();
							var academyLocationIds = this.getCurrentAcademyLocation();
							var coursesIds = [];
							if(typeof formValue.courseId=='number'){
								coursesIds.push(formValue.courseId);
							}else if(!isNullOrEmpty(formValue.courseId)&&formValue.courseId !=""){
								for (var i=0 ; i<formValue.courseId.length; i++){
									coursesIds.push(formValue.courseId[i].data.id);
								}
							}
							var evalLevel=null;
							var evaluationLevelId=null;
							if(!isNullOrEmpty(filter.down('#evalPlanLevelItemId').valueModels) && !filter.down('#evalPlanLevelItemId').valueModels.length==0 ){
								evalLevel=filter.down('#evalPlanLevelItemId').valueModels[0].get('code');
								evaluationLevelId=filter.down('#evalPlanLevelItemId').valueModels[0].data.levelId;
							}
							var facultyId = this.getCurrentlyLoggedInUser();
							var FacID=facultyId.id;
							if(formValue.evaluationplantype=='ACADEMICS'){
								grid.getStore().getProxy().extraParams = {
									academicTermId :formValue.academicTerm,
									studentId: formValue.studentName,
									programId: formValue.programId,
									batchId: formValue.batchId,
									sectionId: formValue.sectionId,
									academyLocationId :academyLocationIds,
									courseIds:coursesIds.join(),
									evaluationPlanId: formValue.evaluationPlan,
									evaluationLevel:evalLevel,
									evaluationLevelId:evaluationLevelId,
									evalPlanLevel: formValue.evalPlanLevelId,
									eventId :formValue.detailSequence,
									facultyId:FacID,  
									
								}
								grid.getStore().load({
									callback: function(record, operation, success) {
										if (success & record.length>0) {
											var grid = me.getStudentmarkremarkentryfacultygrid();
											var gridRecord=me.getGridAllChildren(grid);
											var isGradeType = false;
											var gradeType = '';
											var evaluationSequenceId = '';
											if(gridRecord.length>0){
												for (var i in gridRecord) {
													if(gridRecord[i].get('markEntryType') != "MARK"){
														isGradeType = true;
														gradeType = gridRecord[i].get('gradeType');
														evaluationSequenceId = gridRecord[i].get('evaluationSequenceId');
													}
												}
											}

											if(isGradeType==true){
												var gradeStore=me.getStore('gradeMaster.GradeGroupMapping');
												gradeStore.getProxy().extraParams = {
													gradeType:gradeType,
													evaluationDetailSequneceId:evaluationSequenceId
												};
												gradeStore.load();
											}
											if(grid.eventLevelRemarkStore) {
						        				grid.eventLevelRemarkStore.load();
						        			}
										}
									}
								});
							}
						}
					},
					
					'studentmarkremarkentryfacultygrid button[itemId=publishMarksGradeBtn]' :{
						click:function(obj){
		        			  var $this = this;
		        			  var grid = $this.getStudentmarkremarkentryfacultygrid();
		        			  var gridRecord=$this.getGridCheckedChildren(grid);
		        			  var jsonData=[];
		        			  var whetherQPApplicablePublishYes=[];
			        		  var whetherQPApplicablePublishNo=[];
		        			  if(gridRecord.length > 0){
		        				  for (var i in gridRecord) {
		        					  var data = {
		        							  levelIds:gridRecord[i].raw.examinationResultId,
		        							  isResultPublish:true
		        					  };
		        					  whetherQPApplicablePublishYes.push({
			        					"levelIds":gridRecord[i].raw.examinationResultId,
			        					"isResultPublish":true,
			        					"whetherQPPublish":true,
			        					"courseId":gridRecord[i].raw.courseId,
			        					"eventId":gridRecord[i].raw.eventId
			        					});
		        					  whetherQPApplicablePublishNo.push({
			        					"levelIds":gridRecord[i].data.id,
			        					"isResultPublish":true,
			        					"whetherQPPublish":false,
			        					"courseId":gridRecord[i].data.courseId,
				        				 "eventId":gridRecord[i].raw.eventId
	        					  });
		        					  jsonData.push(data);
		        				  }

		        				  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		        				  Ext.Ajax.request({
		        					  type : 'rest',
		        					  url : SERVERURL.EXAM_RESULT_PUBLISH_MARK_ENTRY_SAVE_PUBLISH_RESULT,
		        					  jsonData : jsonData,
		        					  method : 'POST',
		        					  success : function(resp, action) {
		        						  Ext.getBody().unmask();
		        						  if(resp.responseText=="SUCCESS"){
		        							  showSuccessMessage(getExaminationTranslation('RESULT_PUBLISH'),
		        									  getExaminationTranslation('RESULT_PUBLISHED_SUCCESSFULLY'));
		        							  grid.getStore().reload();
		        							  grid.getSelectionModel().deselectAll();
		        							  if(grid && grid.columns && grid.columns[0] && grid.columns[0].textEl && grid.columns[0].textEl.dom) {
		        								  grid.columns[0].textEl.dom.children[0].checked = false;
		        							  }
		        						  } 
		        						  else{
		        							  showWarningMessage(getCommonTranslation('ERROR'),getCommonTranslation('DEPENDENCY_EXISTS'));
		        						  }
		        					  }
		        				  }); 
		        			  } else{
			        			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			        	      }
		        		  }
					},
					
					'studentmarkremarkentryfacultygrid button[itemId=deleteMarksGradeBtn]':{
	      			   click:function(obj){
		        			  var $this = this;
		        			  var grid = $this.getStudentmarkremarkentryfacultygrid();
		        			  var gridRecord=$this.getGridCheckedChildren(grid);
		    				  var jsonData=[];
		            		  if(gridRecord.length > 0){
		            			  for(var i in gridRecord) {
			        				  if(!isNullOrEmpty(gridRecord[i].data.obtainedMarksGrade)){
			  	  						var data = {
			          	   	 				id:gridRecord[i].raw.examinationResultId,
			          	   	 			};
			  	  						jsonData.push(data);
			        				  }
			        			  }
		            			  if(jsonData.length<1) {
		 		        			 showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('EXAM_RESULT_DELETE_MARK_NOT_ENTERED_MESSEGE'));
		 		        			 return;
		 		        	      }
		 	            		  var submitUrl = SERVERURL.PATH_FIND_DELETE_MARK_ENTRY;
		 	                	  showConfirmMessage(getExaminationTranslation('EXAM_RESULT_DELETION'),
		 	                			  getExaminationTranslation('EXAM_RESULT_DELETE_POPUP_MESSAGE'),function(btn,text){
		                			 if (btn == 'yes') {
		                				Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
		                				Ext.Ajax.request({
		                					type : 'rest',
		                					url : submitUrl,
		                					jsonData : jsonData,
		                					method : 'DELETE',
		                					success : function(response, action) {
		                						Ext.getBody().unmask();
		                						grid.getStore().reload();
		                						grid.getSelectionModel().deselectAll();
		                						grid.columns[0].textEl.dom.children[0].checked = false; 
		                						grid.getView().refresh();
		                						showSuccessMessage(getExaminationTranslation('EXAM_RESULT_DELETION'),
		                								getCommonTranslation('EXAM_RESULT_DELETED_SUCCESSFULLY'));
		                					}
		                				});
		                			 }
		 	                	  });
		            		  }else{
			        			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			        	      }
	      			   }
	      		   },
	      		   
	      		   'studentmarkremarkentryfacultygrid button[itemId=studentMarkRemarkSaveBtn]':{
	      			   click:this.onSaveSubmitStudentMarks
	      		   },
	      		   
	      		   'studentmarkremarkentryfacultygrid button[itemId=studentMarkRemarkSubmitBtn]':{
	      			   click:this.onSubmitFacultyManageEvaluationResultNew
	      		   },
	      		 'studentmarkremarkentryfacultygrid button[itemId=unpublishMarksGradeBtnFaculty]' :{
						click: this.unpublishMarksGrade
	      		 },
	      		'studentmarkremarkentryfacultygrid button[itemId=checkHistoryBtnFaculty]' :{
					click: this.checkHistory
	      		},
				});
			},
			
			onSaveSubmitStudentMarks: function(button){ //added by @raghavendra.soni
				var $this=this;
				button.setDisabled(true);
				var isAllFilled=true;
				var courseVariantIdValue=null;
				var filter = this.getStudentmarkremarkentryfacultyfilter();
				var grid=this.getStudentmarkremarkentryfacultygrid();
				var checkHistoryButton = grid.down('#checkHistoryBtnFaculty');    
				                checkHistoryButton.setDisabled(true);
				//var windowForm=grid.up('panel').down('form').getForm();
				//var masterGrid=$this.getMangeevalresultmastergrid();
				//var masterRecords=masterGrid.getStore().data.items;
				var form=filter.getForm();
				//courseVariantIdValue=form.findField('courseVariant').getValue();

				var detailSequenceVal = form.findField('detailSequence').getValue();
				var gridRecord=$this.getGridCheckedChildren(grid);

				if (gridRecord.length > 0) {
					var jsonData=[];
					var isResultPublishYes = [];
					var isResultPublishNo = [];
					var whetherQPApplicablePublishYes=[];
					var whetherQPApplicablePublishNo=[];
					var isResultPublish=false;
					var whetherQPApplicable=null;
					var whetherQPApplicable=gridRecord[0].data.whetherQPApplicable;
					if(!isNullOrEmpty(gridRecord[0].data.isResultPublish) && 
							gridRecord[0].data.isResultPublish && 
							(gridRecord[0].data.resultPublishMode!='DO_NOT_PUBLISH'
									&& gridRecord[0].data.resultPublishMode!='AUTO_PUBLISH')){
						isResultPublish=true;
					}

					if(gridRecord[0].data.markEntryType=='MARK'){
						for(var i=0;i<gridRecord.length;i++){
							if(isNullOrEmpty(gridRecord[i].data.obtainedMarksGrade) && //finalMarks
									gridRecord[i].data.whetherExamAttended){
								isResultPublish=false;
							}
						}
					} else{
						for(var i=0;i<gridRecord.length;i++){
							if(isNullOrEmpty(gridRecord[i].data.obtainedMarksGrade) && //finalGrade
									gridRecord[i].data.whetherExamAttended){
								isResultPublish=false;
							}
						}	
					}

					Ext.Array.each(gridRecord, function(value) {
						if(!isNullOrEmpty(value.data.obtainedMarksGrade)){
							if(value.data.markEntryType=="MARK"){
										   value.data.obtainedMarks = value.data.obtainedMarksGrade;
			
												if(value.data.penaltyMarks==null&&value.data.graceMarks==null||value.data.penaltyMarks==""&&value.data.graceMarks==""){
													value.data.finalMarks=value.data.obtainedMarks;
												 }
												if(value.data.obtainedMarks==0){
													value.data.finalMarks=value.data.obtainedMarks;
												}
												if(value.data.obtainedMarks>0){
													if(value.data.penaltyMarks!=null&& value.data.penaltyMarks!=""&&value.data.penaltyMarks>=0){
														if(value.data.obtainedMarks>value.data.penaltyMarks){
															if(value.data.graceMarks>=0&&value.data.graceMarks!=""){
																var finalMarks=value.data.obtainedMarks-value.data.penaltyMarks;
																var finalMarksG=parseFloat(finalMarks)+parseFloat(value.data.graceMarks);
																value.data.finalMarks=finalMarksG;
															}
																if(value.data.graceMarks==null||value.data.graceMarks==""){
																var finalMarks=parseFloat(value.data.obtainedMarks)-parseFloat(value.data.penaltyMarks);
																value.data.finalMarks=finalMarks;
															}
														}else{
															value.data.penaltyMarks=null;
														}
												}
													if(value.data.graceMarks!=null&& value.data.graceMarks!=""&&value.data.graceMarks>=0){
														if(value.data.penaltyMarks>=0&&value.data.penaltyMarks!=""){
															var finalMarks=parseFloat(value.data.obtainedMarks)-parseFloat(value.data.penaltyMarks);
															var finalMarksval=parseFloat(finalMarks)+parseFloat(value.data.graceMarks);
																value.data.finalMarks=finalMarksval;
														}
														}
			      							   }
							}
							else{
								value.data.grade = value.data.obtainedMarksGrade;
							}

						}
						if((!isNullOrEmpty(value.data.obtainedMarks) && !isNullOrEmpty(value.data.finalMarks)) || !isNullOrEmpty(value.data.grade)) {
							var effectiveMarks=null;
							var examResultStatusValue=null;
							var weitage= value.data.weightage; //effectiveWeightage windowForm Field

							if(weitage!=null && value.data.finalMarks!=null && value.data.finalMarks>=0){
								effectiveMarks=(value.data.finalMarks*weitage)/100;
							}

							if(portalId  == 2 && button.itemId=="studentMarkRemarkSaveBtn") {
								examResultStatusValue=null;
							} else {
								examResultStatusValue="RESULT_ENTERED";
							}

							var data={
									"id":value.raw.examinationResultId,
									"similarityIndex":value.parentNode.parentNode.parentNode.parentNode.get('similarityIndex'),
									"evaluationSequenceDetailId":value.data.eventId,
									"admissionId":value.data.admissionId,
									"sectionId":value.data.sectionId,
									"courseVariantId":value.data.courseVariantId,
									"totalMarksGiven":value.data.obtainedMarks,
									"penultyMarksGiven":value.data.penaltyMarks,
									"graceMarksGiven":value.data.graceMarks,
									"finalMarks":value.data.finalMarks,
									"examResultStatus": examResultStatusValue,
									"finalGrade":value.data.grade,
									"gradePoints":value.data.gradePoint,
									"finalDescription":value.data.finalDescription,
									"whetherRevaluation":false,
									"effectiveMarks":effectiveMarks,
									"whetherMalpracticeReported":false,
									"whetherExamAttended":true,
									"examUniqueCode":value.data.examUniqueCode,
									"periodId":value.data.periodId,
									"isDynamicScheme":value.data.isDynamicScheme,
									"whetherPublish":value.data.whetherPublish,
									"isResultPublish":value.data.isResultPublish,
									"evaluationGroupId":value.data.evaluationGroupId,
									"whetherQPApplicable":value.data.whetherQPApplicable,
									"applicationStatus":value.data.applicationStatus,
									"centerStatus":value.data.centerStatus,
									"feesStatus":value.data.feesStatus,
									"roomAllocationStatus":value.data.roomAllocationStatus,
									"hallticket":value.data.hallticket
							};
							whetherQPApplicable=value.data.whetherQPApplicable;
							isResultPublishYes.push({
								"levelIds":value.raw.examinationResultId,
								"isResultPublish":false
							});
							isResultPublishNo.push({
								"levelIds":value.raw.examinationResultId,
								"isResultPublish":true
							});
							whetherQPApplicablePublishYes.push({
								"levelIds":value.raw.examinationResultId,
								"isResultPublish":true,
								"whetherQPPublish":true,
								"courseId":value.data.courseId,
								"eventId":value.data.evaluationSequenceDetailId
							});
							whetherQPApplicablePublishNo.push({
								"levelIds":value.raw.examinationResultId,
								"isResultPublish":true,
								"whetherQPPublish":false,
								"courseId":value.data.courseId,
								"eventId":value.data.evaluationSequenceDetailId
							});
							jsonData.push(data);
							courseVariantIdValue = value.data.courseVariantId;

						} else {
							isAllFilled=false; 
						}
					});
					if(isAllFilled) {
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_SAVE_MARKENTRY_FOR_STUDENT,
							jsonData: jsonData,
							method: 'POST',
							success: function(obj, action) {
								Ext.getBody().unmask();
								button.setDisabled(false);
								var trigger=false;
								if(obj.responseText!=""){
									if(isResultPublish){
										showConfirmMessage(getExaminationTranslation('RESULT_PUBLISH'),
												getExaminationTranslation('MARK_ENTRY_RESULT_PUBLISH_SELECTED_RECORDS'),function(btn,text){
											if (btn == 'yes') {
												var updateResultPublish=isResultPublishYes;
												trigger=true;
											}else if(btn == 'no'){
												var updateResultPublish=isResultPublishNo;
												trigger=true;
											}
											if(trigger){
												Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
												Ext.Ajax.request({
													type : 'rest',
													url : SERVERURL.EXAM_RESULT_PUBLISH_MARK_ENTRY_SAVE_PUBLISH_RESULT,
													jsonData : updateResultPublish,
													method : 'POST',
													success : function(response, action) {
														Ext.getBody().unmask();
														grid.getStore().reload();
														grid.getSelectionModel().deselectAll();
														if(grid && grid.columns && grid.columns[0] && grid.columns[0].textEl && grid.columns[0].textEl.dom) {
															grid.columns[0].textEl.dom.children[0].checked = false;
														}
											        	grid.getView().refresh();
														showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS'));
														//$this.loadResultGridData(detailSequenceVal,courseVariantIdValue);
														//$this.closeMarksEntryTab();
													}
												});
											}
										});
									}else{
										grid.getStore().reload();
										grid.getSelectionModel().deselectAll();
										grid.columns[0].textEl.dom.children[0].checked = false; 
                						grid.getView().refresh();
										showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS')); 
										//$this.closeMarksEntryTab();
									}
									//$this.loadResultGridData(detailSequenceVal,courseVariantIdValue);
								}
							}
						});
					} else {
						button.setDisabled(false);
						Ext.getBody().unmask();
						showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('PLEASE_FILL_ALL_MARK_GRADE_ENTRY'));
						return;
					}
				}else{
					button.setDisabled(false);
					Ext.getBody().unmask();
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
				}
			},
			
			onSubmitFacultyManageEvaluationResultNew:function(button){ //added by @raghavendra.soni
				var $this=this;
				var form=null;
				var isAllFilled=true;
				var isAllAbsent=false;
				var courseVariantIdValue=null;
				var evalPlanFilterForm=$this.getStudentmarkremarkentryfacultyfilter();
				var grid=this.getStudentmarkremarkentryfacultygrid();
				form=evalPlanFilterForm.getForm();
				//courseVariantIdValue=form.findField('courseVariant').getValue();

				var detailSequenceVal=form.findField('detailSequence').getValue();
				var gridRecord=$this.getGridCheckedChildren(grid);

				if (gridRecord.length > 0) {
					var jsonData=[];
					var isResultPublishYes = [];
					var isResultPublishNo = [];
					var isResultPublish=false;
					if(!isNullOrEmpty(gridRecord[0].data.isResultPublish) && 
							gridRecord[0].data.isResultPublish && 
							(gridRecord[0].data.resultPublishMode!='DO_NOT_PUBLISH'
									&& gridRecord[0].data.resultPublishMode!='AUTO_PUBLISH')) {
						isResultPublish=true;
					}

					if(gridRecord[0].data.markEntryType=='MARK'){
						for(var i=0;i<gridRecord.length;i++){
							if(isNullOrEmpty(gridRecord[i].data.obtainedMarksGrade) && 
									gridRecord[i].data.whetherExamAttended){
								isResultPublish=false;
							}
						}
					} else{
						for(var i=0;i<gridRecord.length;i++){
							if(isNullOrEmpty(gridRecord[i].data.obtainedMarksGrade) && 
									gridRecord[i].data.whetherExamAttended){
								isResultPublish=false;
							}
						}	
					}

					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.CHECK_GRADE_TYPE_BY_EVAL_SEQ_DETAIL,
						method: 'GET',
						params:{
							evalSeqDetailId:gridRecord[0].data.eventId,
							isDynamicScheme:gridRecord[0].data.isDynamicScheme,
							courseVariantId: gridRecord[0].data.courseVariantId,
							periodId: gridRecord[0].data.periodId
						},
						success: function(obj, action) {
							if(obj.responseText!=""){
								var data = Ext.decode(obj.responseText);

								var respEvaluationPlanNumber = data.evaluationPlanNumber;
								var respEventName = data.eventName;
								var respMinPassMarks = data.minMarks;
								var respMaxMarks = data.maxMarks;
								var respWeightage = data.weightage;

								if(!isNullOrEmpty(data.userDefinedWeighting)){
									var respWeightage = data.userDefinedWeighting;
									var respEffectiveWeightage = data.weightage;
								}else{
									var respEffectiveWeightage = data.weightage;
								}

								if(data.evalInMarksOrGrade=='GRADE'){
									var respMinPassMarks = data.minGrade;
									var respMaxMarks = data.maxGrade;
								}

								Ext.Array.each(gridRecord, function(value) {
									if(!isNullOrEmpty(value.data.whetherExamAttended) && value.data.whetherExamAttended){
										if(!isNullOrEmpty(value.data.obtainedMarksGrade)){
											if(value.data.markEntryType=="MARK"){
			      								   value.data.obtainedMarks = value.data.obtainedMarksGrade;
			
												if(value.data.penaltyMarks==null&&value.data.graceMarks==null||value.data.penaltyMarks==""&&value.data.graceMarks==""){
													value.data.finalMarks=value.data.obtainedMarks;
												 }
												if(value.data.obtainedMarks==0){
													value.data.finalMarks=value.data.obtainedMarks;
												}
												if(value.data.obtainedMarks>0){
													if(value.data.penaltyMarks!=null&& value.data.penaltyMarks!=""&&value.data.penaltyMarks>=0){
														if(value.data.obtainedMarks>value.data.penaltyMarks){
															if(value.data.graceMarks>=0&&value.data.graceMarks!=""){
																var finalMarks=value.data.obtainedMarks-value.data.penaltyMarks;
																var finalMarksG=parseFloat(finalMarks)+parseFloat(value.data.graceMarks);
																value.data.finalMarks=finalMarksG;
															}
																if(value.data.graceMarks==null||value.data.graceMarks==""){
																var finalMarks=parseFloat(value.data.obtainedMarks)-parseFloat(value.data.penaltyMarks);
																value.data.finalMarks=finalMarks;
															}
														}else{
															value.data.penaltyMarks=null;
														}
												}
													if(value.data.graceMarks!=null&& value.data.graceMarks!=""&&value.data.graceMarks>=0){
														if(value.data.penaltyMarks>=0&&value.data.penaltyMarks!=""){
															var finalMarks=parseFloat(value.data.obtainedMarks)-parseFloat(value.data.penaltyMarks);
															var finalMarksval=parseFloat(finalMarks)+parseFloat(value.data.graceMarks);
																value.data.finalMarks=finalMarksval;
														}
														}
			      							   }
											}
											else{
												value.data.grade = value.data.obtainedMarksGrade;
											}

										}
										if((!isNullOrEmpty(value.data.obtainedMarks) && !isNullOrEmpty(value.data.finalMarks))|| !isNullOrEmpty(value.data.grade)) {
											var effectiveMarks=null;
											var examResultStatusValue=null;
											var weitage=respEffectiveWeightage;
											if(isNullOrEmpty(weitage)) {
												weitage=respWeightage;
											}
											if(weitage!=null && value.data.finalMarks!=null && value.data.finalMarks>=0){
												effectiveMarks=(value.data.finalMarks*weitage)/100;
											}

											if(portalId  == 2 && button.itemId=="saveBtnNew") {
												examResultStatusValue=null;
											} else {
												examResultStatusValue="RESULT_ENTERED";
											}
											
											var data={
													"id":value.raw.examinationResultId,
													"similarityIndex":value.parentNode.parentNode.parentNode.parentNode.get('similarityIndex'),
													"evaluationSequenceDetailId":value.data.eventId,
													"admissionId":value.data.admissionId,
													"sectionId":value.data.sectionId,
													"courseVariantId":value.data.courseVariantId,
													"totalMarksGiven": value.data.obtainedMarks,
													"penultyMarksGiven":value.data.penaltyMarks,
													"graceMarksGiven":value.data.graceMarks,
													"finalMarks":value.data.finalMarks,
													"examResultStatus": examResultStatusValue,
													"finalGrade":value.data.grade,
													"gradePoints":value.data.gradePoint,
													"finalDescription":value.data.finalDescription,
													"whetherRevaluation":false,
													"effectiveMarks":effectiveMarks,
													"whetherMalpracticeReported":false,//student.data.whetherMalpracticeReported
													"whetherExamAttended":true,
													"examUniqueCode":value.data.examUniqueCode,
													"periodId":value.data.periodId,
													"isDynamicScheme":value.data.isDynamicScheme,
													"isResultPublish":value.data.whetherPublish
											};

											isResultPublishYes.push({
												"levelIds":value.raw.examinationResultId,
												"isResultPublish":false
											});
											isResultPublishNo.push({
												"levelIds":value.raw.examinationResultId,
												"isResultPublish":true
											});

											jsonData.push(data);
										} else {
											isAllFilled=false;
										}
									}
								});
								if(jsonData.length == 0){
									isAllAbsent = true;
								}
								if(isAllFilled & !isAllAbsent) {
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_SAVE_MARKENTRY_FOR_STUDENT,
										jsonData: jsonData,
										method: 'POST',
										success: function(obj, action) {
											Ext.getBody().unmask();
											button.setDisabled(false);
											if(obj.responseText!=""){
												if(isResultPublish){
													showConfirmMessage(getExaminationTranslation('RESULT_PUBLISH'),
															getExaminationTranslation('MARK_ENTRY_RESULT_PUBLISH_SELECTED_RECORDS'),function(btn,text){
														var trigger=false;
														if (btn == 'yes') {
															var updateResultPublish=isResultPublishYes;
															trigger=true;
														}else if(btn == 'no'){
															var updateResultPublish=isResultPublishNo;
															trigger=true; 
														}
														if(trigger){
															Ext.getBody().mask(getCommonTranslation("SUBMITTING_FORM"), 'x-mask-loading');
															Ext.Ajax.request({
																type : 'rest',
																url : SERVERURL.EXAM_RESULT_PUBLISH_MARK_ENTRY_SAVE_PUBLISH_RESULT,
																jsonData : updateResultPublish,
																method : 'POST',
																success : function(response, action) {
																	Ext.getBody().unmask();
	      					                						grid.getStore().reload();
	      					                						grid.getSelectionModel().deselectAll();
	      					                						grid.columns[0].textEl.dom.children[0].checked = false; 
	      					                						grid.getView().refresh();
	      														   showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS'));
																}
															});
														}
													});
												}else{
													grid.getStore().reload();
			                						grid.getSelectionModel().deselectAll();
			                						grid.columns[0].textEl.dom.children[0].checked = false; 
			                						grid.getView().refresh();
	      										   showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS')); 
												}
											}
										}
									});
								} else if (isAllAbsent) {
									Ext.getBody().unmask();
									showSuccessMessage(getExaminationTranslation('MARK_ENTRY'), getCommonTranslation('SUCCESS'));
									return;
								} else {
									button.setDisabled(false);
									Ext.getBody().unmask();
									showWarningMessage(getCommonTranslation('ALERT'), getExaminationTranslation('PLEASE_FILL_ALL_MARK_GRADE_ENTRY'));
									return;
								}
							}
						}
					});
				}else{
					button.setDisabled(false);
					Ext.getBody().unmask();
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
				}
			},

			onSelectStudentName :function(combo, record){
				var filter = this.getStudentmarkremarkentryfacultyfilter();
				var academicTerm = filter.down('#academicTerm');
				var formValue = filter.getForm().getValues();
				var courseItemId = filter.down('#courseItemId');
				var programIdItemId= filter.down('#programIdItemId');
				var batchIdItemId= filter.down('#batchIdItemId');
				var periodIdItemId= filter.down('#periodIdItemId');
				var sectionIdItemId= filter.down('#sectionIdItemId');
				var academyLocationIds = this.getCurrentAcademyLocation();
				var evaluationLevelField = filter.down('#evalPlanLevelItemId');
				var evaluationPlanItemId = filter.down('#evaluationPlanItemId');
				var detailSequenceItemId = filter.down('#detailSequenceItemId');
				var facultyId = this.getCurrentlyLoggedInUser();
				var facId=facultyId.id;

				courseItemId.reset();
				courseItemId.enable();
				courseItemId.getStore().getProxy().extraParams ={
					academyLocationIds :academyLocationIds,
					academicTermId :academicTerm.getValue(),
					studentId :record[0].data.id,
					facultyId: facId // Nonce_implementation  
				}
				courseItemId.getStore().load({
					callback: function(records){
						if(records.length ==1){
							courseItemId.setValue(records[0].data.id);
						}
					}
				});
				programIdItemId.reset();
				programIdItemId.enable();
				programIdItemId.getStore().getProxy().extraParams ={
					academyLocationIds :academyLocationIds,
					academicTermId :academicTerm.getValue(),
					studentId :record[0].data.id,
					facultyId : facultyId.id

				}
				programIdItemId.getStore().load({
					callback :function(programRecords){
						if(programRecords.length ==1 ){
							programIdItemId.setValue(programRecords[0].data.id);	
							batchIdItemId.reset();
							batchIdItemId.enable();

							batchIdItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :formValue.academicTerm,
								studentId :formValue.studentName,
								programId:programRecords[0].data.id,
							}

							batchIdItemId.getStore().load({
								callback :function(batchRecords){

									if(batchRecords.length ==1){
										batchIdItemId.setValue(batchRecords[0].data.id);
										periodIdItemId.reset();
										periodIdItemId.enable();

										periodIdItemId.getStore().getProxy().extraParams = {
											academyLocationIds :academyLocationIds,
											academicTermId :formValue.academicTerm,
											studentId :formValue.studentName,
											batchId :batchRecords[0].data.id,
										}
										periodIdItemId.getStore().load({
											callback: function(periodRecords){

												if(periodRecords.length ==1){
													periodIdItemId.setValue(periodRecords[0].data.id);
													sectionIdItemId.reset();
													sectionIdItemId.enable();
													sectionIdItemId.getStore().getProxy().extraParams = {
														academyLocationIds :academyLocationIds,
														academicTermId :formValue.academicTerm,
														studentId :formValue.studentName,
														periodId : periodRecords[0].data.id,
														facultyId:facultyId.id
													}
													sectionIdItemId.getStore().load({
														callback: function(sectionRecords){
															if(sectionRecords.length ==1){
																sectionIdItemId.setValue(sectionRecords[0].data.id);
															}
														}
													});
												}
											}
										});
									}
								}
							});

						}
					}
				});
				evaluationPlanItemId.reset();
				evaluationPlanItemId.enable();

				evaluationLevelField.reset();
				evaluationLevelField.disable();

				detailSequenceItemId.reset();
				detailSequenceItemId.disable();

				evaluationPlanItemId.getStore().getProxy().extraParams ={
					academyLocationIds :academyLocationIds,
					academicTermId :academicTerm.getValue(),
					studentId :record[0].data.id,
					planType :formValue.evaluationplantype,
					//courseId :formValue.courseId
				}
				evaluationPlanItemId.getStore().load({
					callback: function(records){
						if(records.length == 1){

							evaluationPlanItemId.reset();
							evaluationPlanItemId.enable();
							evaluationPlanItemId.setValue(records[0].data.id);
							detailSequenceItemId.enable();
							detailSequenceItemId.reset();
							var isDynamicScheme=false;
							if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels)){
								if(!isNullOrEmpty(filter.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
									isDynamicScheme=true;
								}
							}
							detailSequenceItemId.enable();
							detailSequenceItemId.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :academicTerm.getValue(),												
								evalPlanId : records[0].data.id,
								isDynamicScheme :isDynamicScheme,
							}

							detailSequenceItemId.getStore().load({
								callback : function(records){
									if(records.length == 1){
										detailSequenceItemId.setValue(records[0].data.id);
									}
								}
							});
							evaluationLevelField.getStore().getProxy().extraParams ={
								academyLocationIds :academyLocationIds,
								academicTermId :academicTerm.getValue(),								
								evaluationPlanId : records[0].data.id,
								isStatus:false
							}
							evaluationLevelField.reset();
							evaluationLevelField.enable();
							evaluationLevelField.getStore().load({
								callback :function(records){
									if(records.length == 1){
										evaluationLevelField.setValue(records[0].data.id);

										detailSequenceItemId.getStore().getProxy().extraParams ={
											academyLocationIds :academyLocationIds,
											academicTermId :academicTerm.getValue(),												
											evalPlanId : formValue.evaluationPlan,
											isDynamicScheme :isDynamicScheme,
										}
										detailSequenceItemId.reset();
										detailSequenceItemId.enable();

										detailSequenceItemId.getStore().load({
											callback : function(records){
												if(records.length == 1){
													detailSequenceItemId.setValue(records[0].data.id);
												}
											}
										});
									}
								}
							});

						}
					}
				});
			},
			
			getGridCheckedChildren: function(grid){
					var allChecked = grid.getChecked();
			    	var returnArray = [];
			    	Ext.each(allChecked, function(currentRecord){
			    		if(Ext.isDefined(currentRecord.get('leaf')) && currentRecord.get('leaf')==true){
			    			returnArray.push(currentRecord);
			    		}
			    	});
			    	return returnArray;
			    },
			    
			    getGridAllChildren: function(grid){
			    	var returnArray = [];
			    	grid.getRootNode().cascadeBy(function(currentRecord) {
			    		if(currentRecord.isLeaf()){
			    			returnArray.push(currentRecord);
			    		}
			    	});
			    	return returnArray;
			    },
			
		    	uncheckGridHeader: function(grid){
		        	/*if(grid.getStore().getRootNode().childNodes.length>0){
		        		grid.down('#deleteMarksGradeBtn').setDisabled(false);
		        		grid.down('#publishMarksGradeBtn').setDisabled(false);
		        	}
		        	else {
		        		grid.down('#deleteMarksGradeBtn').setDisabled(true);
		        		grid.down('#publishMarksGradeBtn').setDisabled(true);
		        	}*/
		        	grid.columns[0].textEl.dom.children[0].checked = false; 
		        	grid.getView().refresh();
		        },
		        
		        selectParentNodesTreePanel: function(node, checked, headerClick){
		     	   var me = this;
					   var parentNode = node.parentNode;
					   if(parentNode){
						   if(checked == false){
							   var childChecked = false;
							   if(parentNode.hasChildNodes()){
								   parentNode.cascadeBy(function(childNode) {
									   if(parentNode.data.treeNode !=childNode.data.treeNode){
										   if(childChecked == false){
											   childChecked = childNode.get('checked'); 
										   }
									   }
								   });
							   }
							   if(!childChecked){
								   if(parentNode.data.leaf != true){
									   parentNode.set('checked', false);
									   me.selectParentNodesTreePanel(parentNode, false, headerClick);
								   }
							   }
						   }else{
							   if(parentNode.data.leaf != true){
								   parentNode.set('checked', true);
								   me.selectParentNodesTreePanel(parentNode, true, headerClick);
							   }
						   }

					   }
					   
					   var grid = me.getStudentmarkremarkentryfacultygrid();
						var Unpublishbtn=grid.down('#unpublishMarksGradeBtnFaculty');
					   var checkedCount = grid.getChecked().length;
					   if(checkedCount){
						   var isEveryEventOpenforMarkEntry = true;
							 var isPublish = false;    
						   Ext.each(grid.getChecked(),function(checkedRec){
							   if(checkedRec.isLeaf() && checkedRec.data.examStatus != "CONDUCTED"){
								   isEveryEventOpenforMarkEntry = false;
							   }
						   });
			 				
						    var gridRecord = me.getGridCheckedChildren(grid);
							var recCount = 0;
							for (var i in gridRecord) {  
								
							 if(gridRecord[i].raw.isStudentResultPublish){      
								       
						         Unpublishbtn.enable();
							}
							else {
								recCount = recCount + 1;
							}
						   }
							if(recCount == gridRecord.length) {
								Unpublishbtn.disable();
							}
							
						   grid.down('#deleteMarksGradeBtn').setDisabled(!isEveryEventOpenforMarkEntry);
						   grid.down('#publishMarksGradeBtn').setDisabled(!isEveryEventOpenforMarkEntry);
						   grid.down('#checkHistoryBtnFaculty').setDisabled(false);							
						   if(headerClick==false){
							   if(grid && grid.columns && grid.columns[0] && grid.columns[0].textEl && grid.columns[0].textEl.dom) {
								   grid.columns[0].textEl.dom.children[0].checked = true;
							   }
						   }
					   }
					   else {
						   grid.down('#deleteMarksGradeBtn').setDisabled(true);
						   grid.down('#publishMarksGradeBtn').setDisabled(true);
						   grid.down('#unpublishMarksGradeBtnFaculty').setDisabled(true); 
						   grid.down('#checkHistoryBtnFaculty').setDisabled(true);
						   if(headerClick==false){
							   me.uncheckGridHeader(grid);
						   }
					   }
				   },
				   unpublishMarksGrade: function(btn) {
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   var $this = this;
					   var grid = $this.getStudentmarkremarkentryfacultygrid();
					   var gridRecord = $this.getGridCheckedChildren(grid);
					   var jsonData = [];
					   var whetherQPApplicablePublishYes = [];
					   var whetherQPApplicablePublishNo = [];
					   if(gridRecord.length > 0){
						   for (var i in gridRecord) {
							   var data = {
									   levelIds: gridRecord[i].raw.examinationResultId,
									   isResultPublish: false
							   };
							   whetherQPApplicablePublishYes.push({
								   "levelIds": gridRecord[i].raw.examinationResultId,
								   "isResultPublish": true,
								   "whetherQPPublish": true,
								   "courseId": gridRecord[i].raw.courseId,
								   "eventId": gridRecord[i].raw.eventId
							   });
							   whetherQPApplicablePublishNo.push({
								   "levelIds": gridRecord[i].data.id,
								   "isResultPublish": true,
								   "whetherQPPublish": false,
								   "courseId": gridRecord[i].data.courseId,
								   "eventId": gridRecord[i].raw.eventId
							   });
							   jsonData.push(data);
						   }
						   Ext.Ajax.request({
							   type: 'rest',
							   url: SERVERURL.EXAM_RESULT_PUBLISH_MARK_ENTRY_SAVE_UNPUBLISH_RESULT,
							   jsonData: jsonData,
							   method: 'POST',
							   success: function(resp, action) {
								   Ext.getBody().unmask();
								   if(resp.responseText == "SUCCESS"){
									   showSuccessMessage(getExaminationTranslation('UNPUBLISH_MARKS_GRADE'), getExaminationTranslation('UNPUBLISH_MARKS_GRADE_SUCCESS'));
									   grid.getStore().reload();
									   grid.getSelectionModel().deselectAll();
									   grid.columns[0].textEl.dom.children[0].checked = false; 
								   } 
								   else{
									   showWarningMessage(getCommonTranslation('ERROR'), getCommonTranslation('DEPENDENCY_EXISTS'));
								   }
							   }
						   }); 
					   }
					   else{
						   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						   Ext.getBody().unmask();
					   }
				   },
				   checkHistory: function(btn){
					   var histroyPopup = Ext.widget('studentmarkremarkentrycheckhistorywindow');
					   histroyPopup.show();
					   var grid = histroyPopup.down('grid');
					   var store = grid.getStore();
					   var markRemarkGrid = this.getStudentmarkremarkentryfacultygrid();
					   var selection = this.getGridCheckedChildren(markRemarkGrid);
					   var admissionIds = [];
					   var cvIds = [];
					   var eventIds = [];
					   for(var i = 0; i < selection.length; i++) {
						   if(admissionIds.indexOf(selection[i].get('admissionId')) == -1) {
							   admissionIds.push(selection[i].get('admissionId'));
						   }
						   if(cvIds.indexOf(selection[i].get('courseVariantId')) == -1) {
							   cvIds.push(selection[i].get('courseVariantId'));
						   }
						   if(eventIds.indexOf(selection[i].get('eventId')) == -1) {
							   eventIds.push(selection[i].get('eventId'));
						   }
						   grid.marksOrGrade = selection[i].get('markEntryType');
					   }
					   store.getProxy().extraParams = {
						   admissionId: admissionIds.join(),
						   courseVariantIds: cvIds.join(),
						   eventIds: eventIds.join()
					   };
					   this.resetPageSetting(store, grid);
					   store.pageSize = 100;
					   store.load({
						   callback: function() {
							   grid.setWidth(grid.getWidth() + 5);
							   histroyPopup.center();
						   }
					   });
					   histroyPopup.center();
				   },
				   reconfigureGridWithVisibility: function (grid) {
					    Ext.Ajax.request({
					        type: 'rest',
					        url: SERVERURL.PATH_STUDENT_MARK_REMARK_ENTRY_CSM,
					        method: 'GET',
					        success: function (response, action) {
					            var data = Ext.decode(response.responseText);
					            if (!isEmpty(data)) {
					                var gridStore = grid.getStore();
					                var gridCols = [{
					            		header:  "<input type='checkbox'>",
					            		width:50,
					            		hideable : false,
					            		menuDisabled: true,
					            		resizable: false,
					            		sealed: true
					            	},{
					                    xtype: 'treecolumn',
					                    text: getCommonTranslation('COURSE_CODE_NAME'),
					                    flex: .33,
					                    dataIndex: 'treeNode',
					            		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
					            			if(record.get('isCourseLevelNode') || record.isLeaf()){
					            				return val;
					            			}
					            			else{
					            				rec.innerCls = "x-grid-cell-inner-treecolumn noChecked";
					            				return val;
					            			}
					            		}
					                }];
					                for (var i = 0; i < data.length; i++) {
					                    switch (data[i].programShortName) {
					                    case "Similarity Index (%)":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header:  getExaminationTranslation('SIMILARITY_INDEX'),
					                        		dataIndex: 'similarityIndex',
					                        		flex:.15,
					                        		editor: {
					                                	xtype: 'numberfield',
					                        			name: 'similarityIndex',
					                        			itemId:'similarityIndex',
					                        			minValue:0,
					                        			maxValue:100,
					                        			decimalPrecision:4,
					                        			mouseWheelEnabled:false
					                                },
					                        		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
					                        			if(record.get('isCourseLevelNode')){
					                        				if(!isNullOrEmpty(val)){
					                        					return roundToPrecision(val,2);
					                        				} else {
					                        					rec.tdCls = 'gridInputCustomStyle';
					                        	        		return getExaminationTranslation('CLICK_TO_ENTER');
					                        				}
					                        			} else {
					                        				return '';
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Mark Entry Status":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header:  getExaminationTranslation('MARK_ENTRY_STATUS'),
					                        		dataIndex: 'examStatus',
					                        		flex:.15,
					                        		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
					                        			if(record.get('isCourseLevelNode')){
					                        				return '';
					                        			} else if(!record.isLeaf()) {
					                        				return '-';
					                        			} else {
					                        				if(val=="CONDUCTED"){
					                        					return getExaminationTranslation('OPEN_FOR_MARKENTRY');
					                        				}
					                        				else{
					                        					return Ext.util.Format.capitalize(getExaminationTranslation(val));
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Max Marks / Grade":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header:  getExaminationTranslation('MAX_MARKS_GRADE'),
					                        		dataIndex: 'maxMarksOrGrade',
					                        		flex:.15,
					                        		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
					                        			if(record.get('isCourseLevelNode')){
					                        				return '';
					                        			} else if(!record.isLeaf()) {
					                        				return '-';
					                        			} else {
					                        				return val;
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Marks / Grade Obtained":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
													header: getExaminationTranslation('MARKS_GRADE_OBTAINED'),
													dataIndex: 'obtainedMarksGrade',
													flex: .15,
													getEditor: function(record) {
													if (record.data.markEntryType == 'MARK') { 
														var isRounded = record.data.whetherRoundedMark;
															return Ext.create('Ext.grid.CellEditor', {
																field: Ext.create('Ext.form.field.Number', {
																	name: 'totalMarks',
																	minValue: 0,
																	maxValue: 100,
																	allowDecimals: !isRounded,
																	decimalPrecision: isRounded ? 0 : 4, // Set decimal precision based on 'isRounded'
																	mouseWheelEnabled: false
																})
															});

														}
														else {
															return Ext.create('Ext.grid.CellEditor', {
					                        					field: Ext.create( 'Ext.form.field.ComboBox', {
					                        						name:'finalGrade',
					                        						store:'gradeMaster.GradeGroupMapping',
					                        						valueField:'grade',
					                        						displayField:'grade',
					                        						editable:false
					                        					})
					                        				});
					                        			}
					                        		},
													renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
														if (record.get('isCourseLevelNode') || !(record.get('whetherExamAttended'))) {
															return '';
														} else if (!record.isLeaf()) {
															return '-';
														} else {
															if (isNullOrEmpty(val)) {
																if (record.get('examStatus') != "CONDUCTED") {
																	return '';
																}
																else {
																	rec.tdCls = 'gridInputCustomStyle';
																	return getExaminationTranslation('CLICK_TO_ENTER');
																}
															} else {
																if (record.get('markEntryType') == "MARK") {

																	if (val > parseFloat(record.get('maxMarksOrGrade')) || val < 0) {
																		return '';
																	}
																	return roundToPrecision(val, 2);
																}
																else {
																	return val;
																}
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Penalty Marks":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header:  getExaminationTranslation('PENALTY_MARKS'),
					                        		dataIndex: 'penaltyMarks',
					                        		flex:.15,
					                        		editor: {
					                        			xtype: 'numberfield',
					                        			name:'penaltyMarks',
					                        			minValue:0,
					                        			maxValue:100,
					                        			decimalPrecision:4,
					                        			mouseWheelEnabled:false
					                        		},
					                        		renderer:function(val,rec,record){
					                        			var data=rec.record.data;
					                        			if(!record.isLeaf()) {
					                        				return '';
					                        			} else if(data.markEntryType != "MARK" || !(data.whetherExamAttended)){
					                        				return '';
					                        			}
					                        			else{
					                        				//--code here
					                        				if(isNullOrEmpty(val)){
					                        					if(data.examStatus!="CONDUCTED"){
					                        						return '';
					                        					}
					                        					else{
					                        						rec.tdCls = 'gridInputCustomStyle'; 
					                        						return getExaminationTranslation('CLICK_TO_ENTER');
					                        					}
					                        				}else{
					                        					if(val>parseFloat(data.maxMarksOrGrade) || val<0){
					                        						return '';
					                        					}
					                        					if(val>parseFloat(data.obtainedMarksGrade)){
					                        						data.penaltyMarks = '';
					                        						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('TOTAL_PENALTY_MARKS_WARNING_MSG'));
					                        						rec.tdCls = 'gridInputCustomStyle'; 
					                                	    		return getExaminationTranslation('CLICK_TO_ENTER');
					                        					}
					                        					return roundToPrecision(val,2);
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Grace Marks":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header:  getExaminationTranslation('GRACE_MARKS'),
					                        		dataIndex: 'graceMarks',
					                        		flex:.15,
					                        		editor: {
					                        			xtype: 'numberfield',
					                        			name:'graceMarks',
					                        			minValue:0,
					                        			maxValue:100,
					                        			decimalPrecision:4,
					                        			mouseWheelEnabled:false
					                        		},
					                        		renderer:function(val,rec,record){
					                        			var data=rec.record.data;
					                        			if(!record.isLeaf()) {
					                        				return '';
					                        			} else if(data.markEntryType != "MARK" || !(data.whetherExamAttended)){
					                        				return '';
					                        			}
					                        			else{
					                        				//--code here
					                        				if(isNullOrEmpty(val)){
					                        					if(data.examStatus!="CONDUCTED"){
					                        						return '';
					                        					}
					                        					else{
					                        						rec.tdCls = 'gridInputCustomStyle'; 
					                        						return getExaminationTranslation('CLICK_TO_ENTER');
					                        					}
					                        				}else{
					                        					if(val>parseFloat(data.maxMarksOrGrade) || val<0){
					                        						return '';
					                        					}
					                        					if(!isNullOrEmpty(data.obtainedMarksGrade)){
					                        						var oM = data.obtainedMarksGrade;
					                        						var pM = data.penaltyMarks;
					                        						var gM = data.graceMarks;
					                        						if(isNullOrEmpty(data.obtainedMarksGrade)){
					                        							oM = 0;
					                        						}
					                        						if(isNullOrEmpty(data.penaltyMarks)){
					                        							pM = 0;
					                        						}
					                        						if(isNullOrEmpty(data.graceMarks)){
					                        							gM = 0;
					                        						}
					                        						var totalMarksCalc = parseFloat(oM) - parseFloat(pM) + parseFloat(gM);
					                        						if(totalMarksCalc>parseFloat(data.maxMarksOrGrade)){
					                        							data.graceMarks = '';
					                        							showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
					                        							rec.tdCls = 'gridInputCustomStyle'; 
					                        	        	    		return getExaminationTranslation('CLICK_TO_ENTER');
					                        						}
					                        					}
					                        					else{
					                        						data.graceMarks = '';
					                        						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('NET_MARKS_MAX_AWARD_WARNING_MSG'));
					                        						rec.tdCls = 'gridInputCustomStyle'; 
					                                	    		return getExaminationTranslation('CLICK_TO_ENTER');
					                        					}
					                        					return roundToPrecision(val,2);
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Total Marks":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header: getExaminationTranslation('NET_TOTAL_MARKS'),
					                        		dataIndex: 'totalMarkCalc',
					                        		flex:.15,
					                        		hidden: true,
					                        		renderer: function(val,rec,record){
					                        			var data=rec.record.data;
					                        			if(!record.isLeaf()) {
					                        				return '';
					                        			} else if(data.markEntryType != "MARK" || !(data.whetherExamAttended)){
					                        				return '';
					                        			}
					                        			else{
					                        				//--code here
					                        				if(!isNullOrEmpty(data.obtainedMarksGrade)){
					                        					var oM = data.obtainedMarksGrade;
					                        					var pM = data.penaltyMarks;
					                        					var gM = data.graceMarks;
					                        					if(isNullOrEmpty(data.obtainedMarksGrade)){
					                        						oM = 0;
					                        					}
					                        					if(isNullOrEmpty(data.penaltyMarks)){
					                        						pM = 0;
					                        					}
					                        					if(isNullOrEmpty(data.graceMarks)){
					                        						gM = 0;
					                        					}
					                        					var totalMarksCalc = parseFloat(oM) - parseFloat(pM) + parseFloat(gM);
					                        					if(totalMarksCalc>parseFloat(data.maxMarksOrGrade) || val<0){
					                        						return '';
					                        					}
					                        					return roundToPrecision(totalMarksCalc,2);
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Absent Status":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header: getCommonTranslation('ABSENT_STATUS'),
					                        		dataIndex: 'whetherExamAttended',
					                        		flex:.15,
					                        		hidden: true,
					                        		renderer: function(val,rec,record){
					                        			var data=rec.record.data;
					                        			if(!record.isLeaf()) {
					                        				return '';
					                        			}
					                        			else{
					                        				if(val){
					                        	                return getExaminationTranslation('PRESENT');
					                        	            }else {
					                        	                return getExaminationTranslation('ABSENT');
					                        	            }
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Remark Entry Status":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header: getExaminationTranslation('REMARK_ENTRY_STATUS'),
					                        		flex:.15,
					                        		renderer:function(val,rec,record){
					                        			if(record.get('isCourseLevelNode') || record.isLeaf()){
					                        				return '';
					                        			}
					                        			else{
					                        				if(!record.get('whetherRemark')) {
					                        					return 'N/A';
					                        				} else{
					                        					if(record.parentNode.data.isCourseLevelNode){
					                        						//type
					                        						var remark = record.get('typeStatus');
					                        					}
					                        					else if(record.childNodes[0].isLeaf()){
					                        						//method
					                        						var remark = record.get('methodStatus');
					                        					}
					                        					else{
					                        						//subtype
					                        						var remark = record.get('subTypeStatus');
					                        					}
					                        					return (remark=="COMPLETED") ? "Closed" : "Open";
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Remark":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		header:  getAdmissionTranslation('REMARK'),
					                        		flex:.15,
					                        		dataIndex: 'finalDescription',
					                                editor: {
					                                    xtype: 'customcombobox',
					                                    name: 'remarkName',
					                                    store: Ext.create('Academia.store.eventlevelremark.EventLevelRemarkNameStore'),
					                                    valueField: 'remarkName',
					                                    displayField: 'remarkName',
					                                    editable: true,
					                                    maxLength: 255,
					                                    listConfig: {
					                                        listeners: {
					                                            beforeshow: function (picker) {
					                                                picker.minWidth = picker.up('combobox').getSize().width;
					                                                picker.maxWidth = picker.up('combobox').getSize().width;
					                                            }
					                                        },
					                                        loadingText: getCommonTranslation('SEARCHING'),
					                                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					                                        getInnerTpl: function () {
					                                            return '<div class="search-item">' +
					                                                '{courseCodeName}' +
					                                                '</div>';
					                                        }
					                                    },
					                                    listeners: {
					                                    	afterrender: function(cmp) {
					                                    		Ext.defer(function() {
					                                    			if(cmp.rawValue == getExaminationTranslation('CLICK_TO_ENTER')) {
						                                    			cmp.setRawValue('');
						                                    		}
					                                    		}, 1);
					                                    	}
					                                    }
					                                },
					                        		renderer:function(val,rec,record){
					                        			if(record.get('isCourseLevelNode') || record.isLeaf()){
					                        				if(record.isLeaf()) {
					                                    		if (isNullOrEmpty(val)) {
						                                            rec.tdCls = 'gridInputCustomStyle';
						                                            return getExaminationTranslation('CLICK_TO_ENTER');
						                                        }
					                                    		else{
					                            					return val;
					                            				}
					                                    	}
					                        				return '';
					                        			}
					                        			else{
					                        				if(!record.get('whetherRemark')) {
					                        					return '-';
					                        				} else{
					                        		    		rec.style = 'white-space: nowrap !important;overflow: hidden;text-overflow: ellipsis;';
					                        					if(record.parentNode.data.isCourseLevelNode){
					                        						//type
					                        						rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.get('typeRemark')) + '"';
					                        						return record.get('typeRemark');
					                        					}
					                        					else if(record.childNodes[0].isLeaf()){
					                        						//method
					                        						rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.get('methodRemark')) + '"';
					                        						return record.get('methodRemark');
					                        					}
					                        					else{
					                        						//subtype
					                        						rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.get('subTypeRemark')) + '"';
					                        						return record.get('subTypeRemark');
					                        					}
					                        				}
					                        			}
					                        		}
					                        	});
					                        }
					                        break;
					                    case "Remark Actions":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        		xtype:'actioncolumn',
					                        		header: getExaminationTranslation('REMARK_ACTIONS'),
					                        		flex:.15,
					                                items: [{
					                                	tooltip: getCommonTranslation('ADD'),
					                            		iconCls: 'addButtonClsForGridActionCls gridColumnBtns',
					                            		handler: function(tGrid, rowIndex, colIndex) {
					                            			var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0];
					                            			var btn = this.items[0];
					                            			var store = tGrid.getStore();
					                            			var storeRecord = store.getAt(rowIndex);
					                            			var remarkId = storeRecord.get('remarkId');
					                            			var submitUrl = SERVERURL.EVALUATION_REMARK_CREATE_URl;
					                            			var data = {
					                            					"id":storeRecord.data.remarkId,
					                            					"admissionId" : storeRecord.data.admissionId,
					                            					"evaluationPlanId" : storeRecord.raw.evaluationPlanId,
					                            					"evaluationSequenceId": btn.level3Id,
					                            					"evaluationPlanLevelTwoId" : btn.level2Id,
					                            					"evaluationPlanLevelOneId" : btn.level1Id,
					                            					"remark" : null,
					                        						"sectionId" : storeRecord.raw.sectionId,
					                            					"courseVariantId":storeRecord.raw.courseVariantId,
					                            					"periodId":storeRecord.raw.periodId,
					                            					"remarkOnlyAssessment":storeRecord.raw.remarkOnlyAssessment
					                            			};
					                            			var newTagLinkWindow = Ext.create('Ext.window.Window', {
					                            				title: getAdmissionTranslation('REMARK'),
					                            				height: 250,
					                            				width: 400,
					                            				resizable:false,
					                            				border:true,
					                            				autoScroll : false,
					                            				modal : true,
					                            				closeAction: 'destroy',
					                            				layout: 'vbox',
					                            				items: [{
					                            					xtype: 'textareafield',
					                            					name: 'remark',
					                            					fieldLabel: getAdmissionTranslation('REMARK'),        
					                            					labelAlign: 'top',
					                            					width: 350,
					                            					height: 100,
					                            					maxLength: 2048
					                            				},{
					                            					xtype: 'fieldcontainer',
					                            					width: '100%',
					                            					style: 'margin-top:10px !important;',
					                            					items: [{
					                            						xtype: 'button',
					                            						text: getCommonTranslation('SAVE'),
					                            						buttonAlign: 'right',
					                            						ui: 'CustomBtnSubmit',
					                            						scale: CONSTANTS.BUTTONSIZE,
					                            						handler: function(btn){
					                            							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					                            							data.remark = btn.up('window').down('[name=remark]').value;
					                            							Ext.Ajax.request({
					                            								type : 'rest',
					                            								url : submitUrl,
					                            								jsonData : [data],
					                            								method : 'POST',
					                            								success : function(resp, action) {
					                            									Ext.getBody().unmask();
					                            									btn.up('window').close();
					                            									grid.getStore().reload();
					                            									grid.getSelectionModel().deselectAll();
					                            								}
					                            							});
					                            						}
					                            					}, {
					                            						xtype: 'button',
					                            						text: getCommonTranslation('CANCEL'),
					                            						handler: function(btn){
					                            							btn.up('window').close();
					                            						},
					                            						ui: 'CustomBtnCancel',
					                            						scale: CONSTANTS.BUTTONSIZE
					                            					}]
					                            				}]
					                            			}).show();
					                            		},
					                                    isDisabled: function(view, rowIndex, colIndex, item, record){
					                                    	var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0],
					                                    	studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
					                        					createRemarkHidden = studentmarkremarkfacultystructure.createRemarkHidden,
					                        					editRemarkHidden = studentmarkremarkfacultystructure.editRemarkHidden,
					                        					deleteRemarkHidden = studentmarkremarkfacultystructure.deleteRemarkHidden,
					                        					buttonDisabled = false,
					                        					buttonHidden = false,
					                        					store = record.store;
					                                    	if(record.get('isCourseLevelNode') || record.isLeaf() || createRemarkHidden == true){
					                                    		buttonHidden = true;
					                            			}
					                                    	else{
					                            				if(!record.get('whetherRemark')) {
					                            					buttonHidden = true;
					                            					//-- set '-'
					                            				} else{
					                            					var level1Id = null;
					                            					var level2Id = null;
					                            					var level3Id = null;
					                            					if(record.parentNode.data.isCourseLevelNode){
					                            						//type
					                            						var remark = record.get('typeStatus');
					                            						var remarkVal = record.get('typeRemark');
					                            						level1Id = record.raw.evaluationPlanLevelOneId;
					                            					}
					                            					else if(record.childNodes[0].isLeaf()){
					                            						//method
					                            						var remark = record.get('methodStatus');
					                            						var remarkVal = record.get('methodRemark');
					                            						level3Id = record.raw.evaluationSequenceId;
					                            					}
					                            					else{
					                            						//subtype
					                            						var remark = record.get('subTypeStatus');
					                            						var remarkVal = record.get('subTypeRemark');
					                            						level2Id = record.raw.evaluationPlanLevelTwoId;
					                            					}
					                            					if (remark=="COMPLETED"){
					                            						var buttonDisabled = true;
					                            					}
					                            					else{
					                            						var buttonDisabled = false;
					                            					}

					                            					if(!isNullOrEmpty(remarkVal)){
					                            						buttonHidden = true;
					                            					}
					                            					else{
					                                					item.level1Id= level1Id;
					                                					item.level2Id= level2Id;
					                                					item.level3Id= level3Id;
					                            					}
					                            				}
					                                    	}
					                                    	if(buttonHidden){
					                                    		item.iconCls = 'addButtonClsForGridActionCls gridColumnBtns hiddenItem';
					                                    	}
					                                    	else{
					                                    		item.iconCls = 'addButtonClsForGridActionCls gridColumnBtns';
					                                    	}
					                                    	return buttonDisabled;
					                                    }
					                                },{
					                                	tooltip: getCommonTranslation('EDIT'),
					                            		iconCls: 'editButtonClsForGridActionCls gridColumnBtns',
					                            		handler: function(tGrid, rowIndex, colIndex) {
					                            			var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0];
					                            			var btn = this.items[1];
					                            			var store = tGrid.getStore();
					                            			var storeRecord = store.getAt(rowIndex);
					                            			var remarkId = storeRecord.get('remarkId');
					                            			var submitUrl = SERVERURL.EVALUATION_REMARK_CREATE_URl;
					                            			var data = {
					                            					"id":storeRecord.data.remarkId,
					                            					"admissionId" : storeRecord.data.admissionId,
					                            					"evaluationPlanId" : storeRecord.raw.evaluationPlanId,
					                            					"evaluationSequenceId": btn.level3Id,
					                            					"evaluationPlanLevelTwoId" : btn.level2Id,
					                            					"evaluationPlanLevelOneId" : btn.level1Id,
					                            					"remark" : null,
					                            					"sectionId" : storeRecord.raw.sectionId,
					                            					"courseVariantId":storeRecord.raw.courseVariantId,
					                            					"periodId":storeRecord.raw.periodId,
					                            					"remarkOnlyAssessment":storeRecord.raw.remarkOnlyAssessment
					                            			};
					                            			var newTagLinkWindow = Ext.create('Ext.window.Window', {
					                            				title: getAdmissionTranslation('REMARK'),
					                            				height: 250,
					                            				width: 400,
					                            				resizable:false,
					                            				border:true,
					                            				autoScroll : false,
					                            				modal : true,
					                            				closeAction: 'destroy',
					                            				layout: 'vbox',
					                            				items: [{
					                            					xtype: 'textareafield',
					                            					name: 'remark',
					                            					fieldLabel: getAdmissionTranslation('REMARK'),        
					                            					labelAlign: 'top',
					                            					width: 350,
					                            					height: 100,
					                            					maxLength: 2048,
					                            					value: btn.remarkVal
					                            				},{
					                            					xtype: 'fieldcontainer',
					                            					width: '100%',
					                            					style: 'margin-top:10px !important;',
					                            					items: [{
					                            						xtype: 'button',
					                            						text: getCommonTranslation('SAVE'),
					                            						buttonAlign: 'right',
					                            						ui: 'CustomBtnSubmit',
					                            						scale: CONSTANTS.BUTTONSIZE,
					                            						handler: function(btn){
					                            							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					                            							data.remark = btn.up('window').down('[name=remark]').value;
					                            							Ext.Ajax.request({
					                            								type : 'rest',
					                            								url : submitUrl,
					                            								jsonData : [data],
					                            								method : 'POST',
					                            								success : function(resp, action) {
					                            									Ext.getBody().unmask();
					                            									btn.up('window').close();
					                            									grid.getStore().reload();
					                            									grid.getSelectionModel().deselectAll();
					                            								}
					                            							});
					                            						}
					                            					}, {
					                            						xtype: 'button',
					                            						text: getCommonTranslation('CANCEL'),
					                            						handler: function(btn){
					                            							btn.up('window').close();
					                            						},
					                            						ui: 'CustomBtnCancel',
					                            						scale: CONSTANTS.BUTTONSIZE
					                            					}]
					                            				}]
					                            			}).show();
					                            		},
					                                    isDisabled: function(view, rowIndex, colIndex, item, record){
					                                    	var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0],
					                                    	studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
					                        					createRemarkHidden = studentmarkremarkfacultystructure.createRemarkHidden,
					                        					editRemarkHidden = studentmarkremarkfacultystructure.editRemarkHidden,
					                        					deleteRemarkHidden = studentmarkremarkfacultystructure.deleteRemarkHidden,
					                        					buttonDisabled = false,
					                        					buttonHidden = false,
					                        					store = record.store;
					                                    	if(record.get('isCourseLevelNode') || record.isLeaf() || editRemarkHidden == true){
					                                    		buttonHidden = true;
					                            			}
					                                    	else{
					                            				if(!record.get('whetherRemark')) {
					                            					buttonHidden = true;
					                            					//-- set '-'
					                            				} else{
					                            					var level1Id = null;
					                            					var level2Id = null;
					                            					var level3Id = null;
					                            					if(record.parentNode.data.isCourseLevelNode){
					                            						//type
					                            						var remark = record.get('typeStatus');
					                            						var remarkVal = record.get('typeRemark');
					                            						level1Id = record.raw.evaluationPlanLevelOneId;
					                            					}
					                            					else if(record.childNodes[0].isLeaf()){
					                            						//method
					                            						var remark = record.get('methodStatus');
					                            						var remarkVal = record.get('methodRemark');
					                            						level3Id = record.raw.evaluationSequenceId;
					                            					}
					                            					else{
					                            						//subtype
					                            						var remark = record.get('subTypeStatus');
					                            						var remarkVal = record.get('subTypeRemark');
					                            						level2Id = record.raw.evaluationPlanLevelTwoId;
					                            					}
					                            					if (remark=="COMPLETED"){
					                            						var buttonDisabled = true;
					                            					}
					                            					else{
					                            						var buttonDisabled = false;
					                            					}

					                            					if(isNullOrEmpty(remarkVal)){
					                                					buttonHidden = true;
					                            					}
					                            					else{
					                                					item.level1Id= level1Id;
					                                					item.level2Id= level2Id;
					                                					item.level3Id= level3Id;
					                                					item.remarkVal = remarkVal;
					                            					}
					                            				}
					                                    	}
					                                    	if(buttonHidden){
					                                    		item.iconCls = 'editButtonClsForGridActionCls gridColumnBtns hiddenItem';
					                                    	}
					                                    	else{
					                                    		item.iconCls = 'editButtonClsForGridActionCls gridColumnBtns';
					                                    	}
					                                    	return buttonDisabled;
					                                    }
					                                },{
					                                	xtype: 'button',
					                                	tooltip: getCommonTranslation('DELETE'),
					                            		iconCls: 'deleteButtonClsForGridActionCls gridColumnBtns',
					                            		handler: function(tGrid, rowIndex, colIndex) {
					                            			var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0];
					                            			var btn = this.items[2];
					                            			var store = tGrid.getStore();
					                            			var storeRecord = store.getAt(rowIndex);
					                            			var remarkId = storeRecord.get('remarkId');
					                            			var submitUrl = SERVERURL.EVALUATION_REMARK_CREATE_URl;
					                            			var data = {
					                            					"id":storeRecord.data.remarkId,
					                            					"admissionId" : storeRecord.data.admissionId,
					                            					"evaluationPlanId" : storeRecord.raw.evaluationPlanId,
					                            					"evaluationSequenceId": btn.level3Id,
					                            					"evaluationPlanLevelTwoId" : btn.level2Id,
					                            					"evaluationPlanLevelOneId" : btn.level1Id,
					                            					"remark" : null,
					                            					"sectionId" : storeRecord.raw.sectionId,
					                            					"courseVariantId":storeRecord.raw.courseVariantId,
					                            					"periodId":storeRecord.raw.periodId,
					                            					"remarkOnlyAssessment":storeRecord.raw.remarkOnlyAssessment
					                            			};
					                            			showConfirmMessage(getExaminationTranslation('REMARK'), getExaminationTranslation('DELETE_REMARK_CORFIRMATION_MSG'),
					                            					function(btn, text) {
					                            				if (btn == 'yes') {
					                            					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					                            					Ext.Ajax.request({
					                            						type : 'rest',
					                            						url : submitUrl,
					                            						jsonData : [data],
					                            						method : 'POST',
					                            						success : function(resp, action) {
					                            							Ext.getBody().unmask();
					                            							showSuccessMessage(getExaminationTranslation('REMARK'),
					                            									getExaminationTranslation('REMARK_DELETED_SUCCESSFULLY'));
					                            							grid.getStore().reload();
					                            							grid.getSelectionModel().deselectAll();
					                            						}
					                            					});
					                            				}
					                            			});
					                                    },
					                                    isDisabled: function(view, rowIndex, colIndex, item, record){
					                                    	var grid = Ext.ComponentQuery.query('studentmarkremarkentryfacultygrid')[0],
					                                    	studentmarkremarkfacultystructure = grid.up('studentmarkremarkfacultystructure'),
					                        					createRemarkHidden = studentmarkremarkfacultystructure.createRemarkHidden,
					                        					editRemarkHidden = studentmarkremarkfacultystructure.editRemarkHidden,
					                        					deleteRemarkHidden = studentmarkremarkfacultystructure.deleteRemarkHidden,
					                        					buttonDisabled = false,
					                        					buttonHidden = false,
					                        					store = record.store;
					                                    	if(record.get('isCourseLevelNode') || record.isLeaf() || deleteRemarkHidden == true){
					                                    		buttonHidden = true;
					                            			}
					                                    	else{
					                            				if(!record.get('whetherRemark')) {
					                            					buttonHidden = true;
					                            					//-- set '-'
					                            				} else{
					                            					var level1Id = null;
					                            					var level2Id = null;
					                            					var level3Id = null;
					                            					if(record.parentNode.data.isCourseLevelNode){
					                            						//type
					                            						var remark = record.get('typeStatus');
					                            						var remarkVal = record.get('typeRemark');
					                            						level1Id = record.raw.evaluationPlanLevelOneId;
					                            					}
					                            					else if(record.childNodes[0].isLeaf()){
					                            						//method
					                            						var remark = record.get('methodStatus');
					                            						var remarkVal = record.get('methodRemark');
					                            						level3Id = record.raw.evaluationSequenceId;
					                            					}
					                            					else{
					                            						//subtype
					                            						var remark = record.get('subTypeStatus');
					                            						var remarkVal = record.get('subTypeRemark');
					                            						level2Id = record.raw.evaluationPlanLevelTwoId;
					                            					}
					                            					if (remark=="COMPLETED"){
					                            						var buttonDisabled = true;
					                            					}
					                            					else{
					                            						var buttonDisabled = false;
					                            					}

					                            					if(isNullOrEmpty(remarkVal)){
					                            						buttonHidden = true;
					                            					}
					                            					else{
					                                					item.level1Id= level1Id;
					                                					item.level2Id= level2Id;
					                                					item.level3Id= level3Id;
					                            					}
					                            				}
					                                    	}
					                                    	if(buttonHidden){
					                                    		item.iconCls = 'deleteButtonClsForGridActionCls gridColumnBtns hiddenItem';
					                                    	}
					                                    	else{
					                                    		item.iconCls = 'deleteButtonClsForGridActionCls gridColumnBtns';
					                                    	}
					                                    	return buttonDisabled;
					                                    }
					                                }]
					                        	});
					                        }
					                        break;
					                    case "Offered US Credits":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('OFFERED_US_CREDITS'),
					                        	    dataIndex: 'offeredUsCredits',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    case "Offered ECTS Credits":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('OFFERED_ECTS_CREDITS'),
					                        	    dataIndex: 'offeredEctsCredits',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    /*case "Assessment Events":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('ASSESSMENT_EVENTS'),
					                        	    dataIndex: 'assessmentEvent',
					                        	    flex: .1
					                        	});
					                        }
					                        break;*/
					                    case "Offered Marks / Grades":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('OFFERED_MARKS_OR_GRADES'),
					                        	    dataIndex: 'typeRemark',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    case "Course Average":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('COURSE_AVERAGE'),
					                        	    dataIndex: 'courseAverage',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    case "Special Grades":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('SPECIAL_GRADES'),
					                        	    dataIndex: 'specialGrade',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    case "Status":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('STATUS'),
					                        	    dataIndex: 'status',
					                        	    flex: .1,
					                        	    renderer: function(val, rec, record) {
					                        	    	if(!isNullOrEmpty(val)) {
					                        	    		return getExaminationTranslation(val);
					                        	    	}
					                        	    	return val;
					                        	    }
					                        	});
					                        }
					                        break;
					                    case "Retake Course":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('RETAKE_COURSE'),
					                        	    dataIndex: 'retakeCourse',
					                        	    flex: .1,
					                        	    renderer: function(val, rec, record) {
					                        	    	if(!isNullOrEmpty(val) && val) {
					                        	    		return getExaminationTranslation('YES');
					                        	    	}
					                        	    	else  if(!isNullOrEmpty(val) && val == false) {
					                        	    		return getExaminationTranslation('NO');
					                        	    	}
					                        	    	return val;
					                        	    }
					                        	});
					                        }
					                        break;
					                    case "Resit":
					                        if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getCommonTranslation('RESIT'),
					                        	    dataIndex: 'resit',
					                        	    flex: .1,
					                        	    renderer: function(val, rec, record) {
					                        	    	if(!isNullOrEmpty(val) && val) {
					                        	    		return getExaminationTranslation('YES');
					                        	    	}
					                        	    	else  if(!isNullOrEmpty(val) && val == false) {
					                        	    		return getExaminationTranslation('NO');
					                        	    	}
					                        	    	return val;
					                        	    }
					                        	});
					                        }
					                        break;
					                    case "Obtained US Credits":
					                    	if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('OBTAINED_US_CREDITS'),
					                        	    dataIndex: 'obtainedUsCredits',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    case "Obtained ECTS Credits":
					                    	if (data[i].requireacademicStanding == true) {
					                            gridCols.push({
					                        	    header: getExaminationTranslation('OBTAINED_ECTS_CREDITS'),
					                        	    dataIndex: 'obtainedEctsCredits',
					                        	    flex: .1
					                        	});
					                        }
					                        break;
					                    }
					                }
					                grid.reconfigure(gridStore, gridCols);
					                grid.getView().refresh();
					            }
					        }
					    });
					}
});