/**
 * @author Anand Verma
 * 
 */
Ext.define('Academia.controller.examinationcenters.examlogistic.ExamLogisticController', {
	extend: 'Academia.controller.base.BaseController',
	stores : ['examCenter.AssignSequence.EvaluationType','examinationcenters.CenterUseFor','examinationcenters.evaluation.PlacementAcademyOthers','examinationcenters.examlogistic.ExamLogisticEvalGroup',
	          'examinationcenters.examlogistic.ExamLogisticMalPractice','examinationcenters.examlogistic.StudentAttendanceEvalGroup','examinationcenters.examlogistic.StudentAttendanceEvalPlan',
	          'program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore','examinationcenters.examlogistic.ExamTimeSlotStore',
	          'examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterName','examinationcenters.roomallocation.RoomAllocationCourses','examinationcenters.examlogistic.ExamDateStore',
	          'examinationcenters.manageEvaluation.evaluationgroup.ManageEvaluationDetailSequence','common.ProgramStore','common.BatchesByProgramId','examinationcenters.examlogistic.ExamRoomStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore','examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
	          'servicerequest.examrelatedrequest.DetailEvaluationSequences','examinationcenters.evaluationgrouplisting.centerallocation.CenterNameByEvalGroupIdCenterType',
	          'coursetransaction.sectionmanagement.SectionsStore','examinationcenters.roomallocation.RoomAllocationDateByCenter','examinationcenters.roomallocation.RoomAllocationBatchByCenterAndDate',
	          'examinationcenters.examlogistic.EvalPlanByPeriodSection','transport.vehicle.PresentAbsentEnum','examinationcenters.examstaffallocation.commonFilter.ExamCVFilter','examinationcenters.examlogistic.StudentWiseAttendanceGridStore',
	          'examinationcenters.reports.ExaminationReportEPStore','examinationcenters.reports.EventForAttendanceStore','examinationcenters.examlogistic.PlanWiseAttendanceGridStore',
	          'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter','examinationcenters.examstaffallocation.commonFilter.ExamSectionFilter','examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter',
	          'examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter','examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter','examinationcenters.examstaffallocation.commonFilter.ExamBatchFilter',
	          'examinationcenters.examstaffallocation.commonFilter.ExamDateFilter','examinationcenters.examstaffallocation.commonFilter.FindAllRoomNo','examinationcenters.examlogistic.RoomWiseAttendanceGridStore',
	          'examinationcenters.examlogistic.ExamCourseStore','examinationcenters.examlogistic.ExamCourseVariantStore',
	          'examinationcenters.reports.ExaminationReportStudentStore','examinationcenters.examlogistic.ExamCenterStore','examinationcenters.examlogistic.EvaluationGroupStore','examinationcenters.reports.ExaminationReportCourseStore',
	          'examinationcenters.reports.ExaminationReportCVStore','common.AssignedProgramStore','setup.templatemapping.TemplateNameForReport','examinationcenters.evalresultlisting.EvaluationGroup',
	          'examinationcenters.reports.ExaminationReportProgramStore','examinationcenters.reports.SpecialGradeBatchStore','common.CurrentBatchStore','examinationcenters.examlogistic.StudentWiseAttendanceSummaryStore',
	          'examinationcenters.examlogistic.RoomWiseAttendanceSummaryStore','examinationcenters.examlogistic.PlanWiseAttendanceSummaryStore',
	          'examinationcenters.evaluation.SortingFilterForRoomAttendanceStore','examinationcenters.reports.EventForAttendancePlanStore',
	          'attendance.ExamAttendanceCourseStore'
	],
	views : ['examinationcenters.examlogistic.ExamLogisticStructure','examinationcenters.examlogistic.ExamLogisticFilter','examinationcenters.examlogistic.studentattendance.StudentAttendanceStructure',
	         'examinationcenters.examlogistic.studentattendance.StudentAttendanceFilter','examinationcenters.examlogistic.studentattendance.MalpracticeWin',
	         'examinationcenters.examlogistic.studentattendance.StudentAttendanceEvalGroupGrid','examinationcenters.examlogistic.studentattendance.StudentAttendanceEvalPlanGrid',
	         'examinationcenters.examlogistic.studentattendance.StudentAttendanceEvalPlanFilter','examinationcenters.examlogistic.studentattendance.StudentAttendanceEvalGrpFilter',
	         'examinationcenters.examlogistic.studentattendance.StudentAttendanceWin','examinationcenters.examlogistic.ExamLogisticSubStructure','examinationcenters.examlogistic.RoomWiseAttendanceView'
	         ,'examinationcenters.examlogistic.RoomWiseGrid','examinationcenters.examlogistic.PlanWiseAttendanceView','examinationcenters.examlogistic.PlanLogisticFilter','examinationcenters.examlogistic.PlanWiseGrid',
	         'examinationcenters.examlogistic.StudentLogisticFilter','examinationcenters.examlogistic.StudentWiseAttendanceView','examinationcenters.examlogistic.StudentWiseGrid',
	         'examinationcenters.generatehallticket.GenerateReportWin','setup.templatemapping.PreviewTemplate','examinationcenters.examlogistic.RoomWiseAttendanceSummary',
	         'examinationcenters.examlogistic.SchemeWiseAttendanceSummary','examinationcenters.examlogistic.StudentWiseAttendanceSummary',
	         'examinationcenters.generatehallticket.GenerateRoomWiseReportWin'],		
     config:{
      	 /*
          	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
           		   	 */
           	   	/**
           	        * @cfg {Array} Exam Logistics array (required)
           	        * The array of permissions to use for Access control wise enabling and disabling buttons.
           	        * @accessor
           	        */
    	   /**
    	    * These permission are for Exam Logistic CB grid. 
    	    */
    	 EXAM_LOGISTICS_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_LOGISTICS_PRIVILEGES'),
    	 STUDENT_ATTENDANCE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ATTENDANCE_PRIVILEGES'),
    	 STUDENT_ATTENDANCE_EVAL_GROUP_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ATTENDANCE_EVAL_GROUP_PRIVILEGES'),
    	 EXAM_ROOM_WISE_ATTENDANCE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_ROOM_WISE_ATTENDANCE_PRIVILEGES'),
    	 EXAM_PLAN_WISE_ATTENDANCE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_PLAN_WISE_ATTENDANCE_PRIVILEGES'),
    	 EXAM_STUDENT_WISE_ATTENDANCE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAM_STUDENT_WISE_ATTENDANCE_PRIVILEGES'),
    	 MANAGE_EXAM_ATTENDANCE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_EXAM_ATTENDANCE_PRIVILEGES')
       },
	refs : [{
				ref:'examLogisticInternalGrid',
				selector:'searchresultgrid[itemId=examLogisticInternalGridItemId]'
		    },{
				ref:'examLogisticExternalGrid',
				selector:'searchresultgrid[itemId=examLogisticExternalGridItemId]'
		    },{
				ref:'contentPanel',
				selector:'contentPanel'
		    },{
				ref:'studentattendancestructure',
				selector:'studentattendancestructure'
		    },{
				ref:'studentAttendanceInnerStructure',
				selector:'studentattendancestructure form'
		    },{
				ref:'malpracticeWin',
				selector:'malpracticeWin'
		    },{
				ref:'malpracticeForm',
				selector:'malpracticeWin form'
		    },{
				ref:'examlogisticfilter',
				selector:'examlogisticfilter'
		    },{
				ref:'studentattendancefilter',
				selector:'studentattendancefilter'
		    },{
				ref:'studentattendanceevalplangrid',
				selector:'studentattendanceevalplangrid'
		    },{
				ref:'studentattendanceevalgroupgrid',
				selector:'studentattendanceevalgroupgrid'
		    },{
				ref:'studentattendanceevalplanfilter',
				selector:'studentattendanceevalplanfilter'
		    },{
				ref:'studentattendanceevalgrpfilter',
				selector:'studentattendanceevalgrpfilter'
		    },{
				ref:'studentattendancewin',
				selector:'studentattendancewin'
		    },{
				ref:'studentAttendanceWinForm',
				selector:'studentattendancewin form'
		    },{
				ref:'roomwisegrid',
				selector:'roomwisegrid'
		    },{
				ref:'examlogisticsubstructure',
				selector:'examlogisticsubstructure'
		    },{
				ref:'planwiseattendanceview',
				selector:'planwiseattendanceview'
		    },{
				ref:'roomwiseattendanceview',
				selector:'roomwiseattendanceview'
		    },{
				ref:'planlogisticfilter',
				selector:'planlogisticfilter'
		    },{
				ref:'planwisegrid',
				selector:'planwisegrid'
		    },{
				ref:'studentwiseattendanceview',
				selector:'studentwiseattendanceview'
		    },{
				ref:'studentlogisticfilter',
				selector:'studentlogisticfilter'
		    },{
				ref:'studentwisegrid',
				selector:'studentwisegrid'
		    },{
				ref:'generatereportwin',
				selector:'generatereportwin'
		    },{
				ref:'previewtemplate',
				selector:'previewtemplate'
		    },{
				ref:'roomwiseattendancesummary',
				selector:'roomwiseattendancesummary'
		    },{
				ref:'schemewiseattendancesummary',
				selector:'schemewiseattendancesummary'
		    },{
				ref:'studentwiseattendancesummary',
				selector:'studentwiseattendancesummary'
		    },{
				ref:'generateroomwisereportwin',
				selector:'generateroomwisereportwin'
		    }],
	          init : function() {
	        	  this.control({
	        		  
	        		//***********************Export Functionality Start*******************************
	        		  //***************************Internal***********************************
	        		  'searchresultgrid[itemId=examLogisticInternalGridItemId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
      		            click: function() {
      		            	   var searchResultGrid=this.getExamLogisticInternalGrid();
      			               var quickSearchForm=this.getExamlogisticfilter(); 
      			               var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_INTERNAL_LIST_CONFIGCODE;
      		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
      		            }
      		        },
       		        'searchresultgrid[itemId=examLogisticInternalGridItemId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
       		            click: function() {
       		            	var searchResultGrid=this.getExamLogisticInternalGrid();
       		            	var quickSearchForm=this.getExamlogisticfilter(); 
       		            	var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_INTERNAL_LIST_CONFIGCODE;	
      			               this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
       		            }
       		        },
       		        'searchresultgrid[itemId=examLogisticInternalGridItemId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
       		            click: function() {
       		            	var searchResultGrid=this.getExamLogisticInternalGrid();
       		            	var quickSearchForm=this.getExamlogisticfilter(); 
       		            	var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_INTERNAL_LIST_CONFIGCODE;
      			               this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode); 		            
      			                }
       		        },
       		        'searchresultgrid[itemId=examLogisticInternalGridItemId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
       		            click: function() {
       		            	var searchResultGrid=this.getExamLogisticInternalGrid();
       		            	var quickSearchForm=this.getExamlogisticfilter(); 
       		            	var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_INTERNAL_LIST_CONFIGCODE;
      			               this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode); 		            
      			               }
       		        },
       		   //***************************External***********************************
	        		  'searchresultgrid[itemId=examLogisticExternalGridItemId] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
    		            click: function() {
    		            	   var searchResultGrid=this.getExamLogisticExternalGrid();
    			               var quickSearchForm=this.getExamlogisticfilter(); 
    			               var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_EXTERNAL_LIST_CONFIGCODE;
    		                this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
    		            }
    		        },
     		        'searchresultgrid[itemId=examLogisticExternalGridItemId] splitbutton[itemId=exportToPdfBtn] #exportAll': {
     		            click: function() {
     		            	var searchResultGrid=this.getExamLogisticExternalGrid();
     		            	var quickSearchForm=this.getExamlogisticfilter(); 
     		            	var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_EXTERNAL_LIST_CONFIGCODE;	
    			               this.exportUserList(SERVERURL.PDFEXPORT,'pdf',false,quickSearchForm,searchResultGrid,configCode);
     		            }
     		        },
     		        'searchresultgrid[itemId=examLogisticExternalGridItemId] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
     		            click: function() {
     		            	var searchResultGrid=this.getExamLogisticExternalGrid();
     		            	var quickSearchForm=this.getExamlogisticfilter(); 
     		            	var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_EXTERNAL_LIST_CONFIGCODE;
    			               this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode); 		            
    			                }
     		        },
     		        'searchresultgrid[itemId=examLogisticExternalGridItemId] splitbutton[itemId=exportToXcelBtn] #exportAll': {
     		            click: function() {
     		            	var searchResultGrid=this.getExamLogisticExternalGrid();
     		            	var quickSearchForm=this.getExamlogisticfilter(); 
     		            	var configCode = CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_EXTERNAL_LIST_CONFIGCODE;
    			               this.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true,quickSearchForm,searchResultGrid,configCode); 		            
    			               }
     		        },
       		        //******************************Export Functionality END********************************************************
	        		  'examlogisticfilter button[itemId=searchBtn]' : {
							click : this.loadExamLogisticFilter
	        		  },
	        		  'examlogisticfilter button[itemId=generateReport]' : {
							click : this.openRoomWiseGenerateReportWindow
	        		  },
	        		  'examlogisticfilter customcombobox[itemId=evalPlanTypeItemId]':{
	        			  select:function(ob,record){ 
	        				  this.evaluationTypeChanges(ob,record,'examlogisticfilter');
	        			  }
	        		  },
	        		  'generateroomwisereportwin button[itemId=submitBtn]':{
		        		  click:function(obj){
		        			  var $this = this;
		        			  var template = obj.up().up().down("#chooseTemplate");
	        				  var quickSearchForm = $this.getExamlogisticfilter();
	        				  var formValue = quickSearchForm.getForm().getValues();
	        				  var timeSlotField = quickSearchForm.getForm().findField("timeSlot");
	  	        	    	  var centerNameField = quickSearchForm.getForm().findField("centerName");
						      var programId = quickSearchForm.getForm().findField("programId");
						      var batchId = quickSearchForm.getForm().findField("batchId");
						      var periodId = quickSearchForm.getForm().findField("periodId");
						      var section = quickSearchForm.getForm().findField("section");
						      var courseId = quickSearchForm.getForm().findField("courseId");
						      var courseVariant = quickSearchForm.getForm().findField("courseVariant");
						      var scheduleDate = quickSearchForm.getForm().findField('date').getValue();
						      var roomNo = quickSearchForm.getForm().findField("roomNo");
		        			  
						      var reportParams =new Object();
		        			  reportParams.code =template.getValue();
		        			  reportParams.reportTitle=template.getDisplayValue()
		        			  reportParams.EVALUATION_GROUP_ID=formValue.evalGroup;
		        			  reportParams.ROOM_NO_ID=formValue.roomNo;	
		        			  reportParams.CENTER_ID=formValue.centerName;
		        			  reportParams.GROUP_BATCH_ID=formValue.timeSlot;
		        			  reportParams.CENTER_TYPE=centerNameField.valueModels[0].data.code;
		        			  reportParams.COURSE_ID=courseId.getValue();
		        			  reportParams.COURSE_VARIANT_ID=courseVariant.getValue();
		        			  reportParams.PROGRAM_ID=programId.getValue();
		        			  reportParams.BATCH_ID=batchId.getValue();
		        			  reportParams.ACADEMY_LOCATION_ID= $this.getCurrentAcademyLocation();
		        			  reportParams.GROUP_DATE_BATCH_CENTER_ID=parseInt(timeSlotField.valueModels[0].data.code);
		        			  reportParams.SECTION_ID=section.getValue();
		        			  reportParams.PERIOD_ID=periodId.getValue();
		        			  if(reportParams.code != "STUDENT_ATTENDANCE_AND_ATTEMPTS_REPORT"){
		        				  reportParams.SORTING_TYPE=obj.up().up().getValues().firstSortingFilter;
		        			  }
		        			  reportParams.TIME_SLOT = timeSlotField.getDisplayValue();
		        			  reportParams.CENTER_NAME = centerNameField.valueModels[0].data.value;
		        			  reportParams.SCHEDULE_DATE=scheduleDate;
		        			  reportParams.ROOM_NO = roomNo.getDisplayValue();
		        			  $this.getGenerateroomwisereportwin().close();
		        			  reportParams.reportTitle
							  $this.exportJRXMLReport(reportParams.code,reportParams,reportParams.reportTitle,'.pdf',SERVERURL.PATH_GENERATE_ROOM_WISE_REPORT);
		        			  
		        		  }
		        	  },
	        		  'searchresultgrid[itemId=examLogisticInternalGridItemId]':{
	        			render:function(grid){
	        				/**
	        				 * Apply Privilege for Internal grid
	        				 */
	        				this.gridRenderFunction(grid);
	        				
	        				this.genericCBGridAccessControlValidation(grid,this.getEXAM_LOGISTICS_PERMISSION());
	        			}  
	        		  },
	        		  'searchresultgrid[itemId=examLogisticExternalGridItemId]':{
		        			render:function(grid){
		        				this.gridRenderFunction(grid);
		        				/**
		        				 * Apply Privilege for External grid
		        				 */
		        				this.genericCBGridAccessControlValidation(grid,this.getEXAM_LOGISTICS_PERMISSION());
		        			}  
		        	 },
	        		  'searchresultgrid[itemId=examLogisticInternalGridItemId] button[itemId=searchResultGridBtnAdd]':{
	        			click:function(){
	        				this.openStudentAttendanceTab();
	        			}  
	        		  },
	        		  'searchresultgrid[itemId=examLogisticExternalGridItemId] button[itemId=searchResultGridBtnAdd]':{
		        			click:function(){
		        				this.openStudentAttendanceTab();
		        			}  
		        	 },
	        		  'examlogisticfilter button[itemId=resetBtn]':{
	                        click:function(obj){
	                            var filterForm=obj.up('form').getForm();
	                            filterForm.findField('evalStage_1').setDisabled(true);
	                            filterForm.findField('evalStage_2').setDisabled(true);
	                            filterForm.findField('evalGroup').setDisabled(true);
	                            filterForm.findField('centerName').setDisabled(true);
	                            filterForm.findField('course').setDisabled(true);
	                            filterForm.findField('detailedSequence').setDisabled(true);
	                            filterForm.findField('date').setDisabled(true);
	                            filterForm.reset();
	                        }
	                    },
	                 /* 'studentattendancefilter button[itemId=resetBtn]':{
		                    click:function(obj){
		                         obj.up('form').getForm().reset();
		                      }
		                 },*/
	                  'malpracticeWin button[itemId=CancelBtn]' : {
               			 click :function(){
               				 this.getMalpracticeWin().close();
               			 }
               		 },  
               		 'examlogisticfilter customcombobox[itemId=evalStage_1]':{
	        			  select:function(ob,record){ 
	        				  var data=  record[0].data.id;
	        				  /**
	        		           * Load Assessment group on the bases of evaluation stage
	        		           */
               		           this.loadEvaluationGroupByEvalStage(data);
	        			  }  
	        		  },  
               		 'examlogisticfilter customcombobox[itemId=evalStage_2]':{
	        			  select:function(ob,record){ 
	        				  var data=  record[0].data.id;
	        				  /**
	        		           * Load Assessment group on the bases of evaluation stage
	        		           */
               		           this.loadEvaluationGroupByEvalStage(data);
	        			  }  
	        		  },
	        		  'examlogisticfilter':{
	        			  render:function(ob){ 
	        				  	var $this = this;
		       				    var form = $this.getExamlogisticfilter();
		       				    var associatedAcadLocationIds = new Array();
						    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		       				    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getEXAM_ROOM_WISE_ATTENDANCE_PERMISSION());
		       				    var generateButton= form.down("#generateReport");
		       				    generateButton.setVisible(false);
		       				    Ext.each(permissionList, function(privilege) {
						    		if (privilege === 'GENERATEREPORT') {
						    			if(!isNullOrEmpty(generateButton)){
						    				form.down("#generateReport").setVisible(true);
						    			}        		
						    		}
						    	});
		       				 
		       				    var grp = form.getForm().findField("evalGroup");
			       				 grp.getStore().getProxy().extraParams={
			       					academyLocationId:$this.getCurrentAcademyLocation()
			       				 };
			       				 grp.getStore().load();

	        			  },
	        			  
	        			  afterrender : function() {
								 var $this = this;
								 var alinfomodel = Academia.model.authentication.ALInfoModel;
								 var wheatherSchool = alinfomodel.get('wheatherSchool');
								 if(wheatherSchool) {
									 $this.getExamlogisticfilter().down('#periodItemId').setVisible(false);
								 } else {
									 $this.getExamlogisticfilter().down('#periodItemId').setVisible(true);
								 }
					    }

	        		  },
	        		  
	        		  
	        		  'examlogisticfilter customcombobox[itemId=evalGroupItemId]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var centerNameField = form.findField('centerName');
                            var dateNameField = form.findField('date');
                            var timeSlotNameField = form.findField('timeSlot');
                            var roomNoNameField = form.findField('roomNo');
	       				    var grp = form.findField("evalGroup");
	       					var programId = form.findField("programId");
	       					var academyLocationIds = [];
	       					academyLocationIds.push($this.getCurrentAcademyLocation());
	       					programId.enable();
	       					programId.reset();
	       				    centerNameField.enable();
	       				    centerNameField.reset();
                            dateNameField.reset();
                            roomNoNameField.reset();
                            timeSlotNameField.reset();
	       				    var store =	centerNameField.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:data,
	       				    	centerType:record[0].data.code
	       				    };
	       				    programId.getStore().getProxy().extraParams={
	       				    	academyLocationIds:academyLocationIds.join(), 
	       				    	whetherMarksheet:true,
	       				    	evaluationGroupId:data
	       				    };
	       				    programId.getStore().load();
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=programIdQuickFiltr]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var grp = form.findField("evalGroup");
	       					var batchId = form.findField("batchId");
	       					/*batchId.enable();
	       					batchId.reset();
	       				    var store =	batchId.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	programId:data
	       				    };
	       				    store.load();*/
	       					
	       				 var batchField=$this.getExamlogisticfilter().down('#batchIdQuickFiltr');
           				 var periodField=$this.getExamlogisticfilter().down('#periodItemId');
           				 var sectionField=$this.getExamlogisticfilter().down('#sectionItemId');
           				 batchField.reset();
           				 batchField.enable();
           				 periodField.reset();
           				 var alinfomodel = Academia.model.authentication.ALInfoModel;
		                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
		                	 if(wheatherSchool) {
		                		 periodField.setVisible(false);
		                	 }
           				 var programId = record[0].get("id");
           				 if(programId > 0){
           					 var store = this.getStore('examinationcenters.reports.SpecialGradeBatchStore');

           					 store.getProxy().extraParams = {
           						 programId: programId,
           						 whetherMarksheet:true
           					 };
           					 store.load({
           						 callback: function(records, operation, success) {
           							 if (success) {
           								 var batchId = 0;
           								 for(var i=0,j=0; i<records.length; i++){
           									 if (records.length == 1) {
           										 batchId = records[i].data.id;
           									 } else if(records[i].data.isCurrentPeriodOfProgram){
           										 if(j==0){
           											 batchId = records[i].data.id;
           											 j++;
           										 } else {
           											 batchId = 0;
           											 sectionField.reset();
       												 sectionField.disable();
           											 return;
           										 }
           									 }
           								 }
           							 }
           							 if(batchId > 0){
           								 batchField.setValue(batchId);
           								 var store = $this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
           								 store.getProxy().extraParams = {
           									 id : batchId,
           									 whetherMarksheet:true
           								 };
           								 store.load({
           									 callback: function(records, operation, success) {
           										 if (success) {
           											 if(records.length == 0){
           												 if(wheatherSchool) {
           												 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
           												 sectionField.reset();
           												 sectionField.getStore().loadRawData([]);
           												 }
           											 } else if(records.length == 1){
           												 periodField.enable();
           												 periodField.setValue(records[0].data.id);
           												 sectionField.reset();
           												 sectionField.enable();
           												 sectionField.getStore().getProxy().extraParams = {
                       		            					 periodId: records[0].data.id
                       		    	    				   };
           												 sectionField.getStore().load();
           												 if(wheatherSchool) {
           													 periodField.setVisible(false);
           												 }
           											 } else {
           												 periodField.enable();
           												 periodField.setVisible(true);
           												 sectionField.reset();
           												 sectionField.disable();
           											 }
           										 }
           									 }
           								 });
           							 }
           						 }
           					 });
           				 }
	       					
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=batchIdQuickFiltr]':{
	        			  select:function(ob,record){ 
	        				  //var data=  record[0].data.id;
	        				  var $this=this;
	        				  var form = $this.getExamlogisticfilter().getForm(); 
	        				  var grp = form.findField("evalGroup");
	        				  var batchId = form.findField("batchId");
	        				  var periodId = form.findField("periodId");
	        				  var programId = form.findField("programId");

	            				 var periodField=$this.getExamlogisticfilter().down('#periodItemId');
	            				 var sectionField=$this.getExamlogisticfilter().down('#sectionItemId');
	        				  var batchId = record[0].get("id");
	        				  var alinfomodel = Academia.model.authentication.ALInfoModel;
	        				  var wheatherSchool = alinfomodel.get('wheatherSchool');
	        				  if(wheatherSchool) {
	        					  periodField.setVisible(false);
	        				  }
	        				  if(batchId > 0){
	        					  var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	        					  store.getProxy().extraParams = {
	        						  id : batchId
	        					  };
	        					  store.load({
	        						  callback: function(records, operation, success) {
	        							  if (success) {
	        								  if(records.length == 0){
	        									  if(wheatherSchool) {
	        										  showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	        										  sectionField.reset();
	        										  sectionField.getStore().loadRawData([]);
	        										  //sectionField.disable();
	        									  }
	        								  } else if(records.length == 1){
	        									  periodField.enable();
	        									  periodField.setValue(records[0].data.id);
	        									  sectionField.reset();
	        									  sectionField.enable();
	        									  sectionField.getStore().getProxy().extraParams = {
	        										  periodId: records[0].data.id
	        									  };
	        									  sectionField.getStore().load();
	        									  if(wheatherSchool) {
	        										  periodField.setVisible(false);
	        									  }
	        								  } else {
	        									  periodField.setVisible(true);
	        									  periodField.enable();
	        								  }
	        							  }
	        						  }
	        					  });
	        				  }


	        				  /*periodId.enable();
	       					periodId.reset();
	       				    var store =	periodId.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	programId:programId.getValue(),
	       				    	batchId:data
	       				    };
	       				    store.load();*/
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=periodItemId]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var grp = form.findField("evalGroup");
	       					var batchId = form.findField("batchId");
	       					var periodId = form.findField("periodId");
	       					var programId = form.findField("programId");
	       					var section = form.findField("section");
	       					section.enable();
	       					section.reset();
	       				    var store =	section.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	programId:programId.getValue(),
	       				    	batchId:batchId.getValue(),
	       				    	periodId:data
	       				    };
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter button[itemId=resetBtn]':{
	        			  click:function(ob){ 
	        				  this.roomWiseViewResetFunctionality();
	        			  }
	        		  },
	        		  
	        		  'examlogisticsubstructure radiogroup[itemId=attendanceBygroupId]':{
	        			  change: this.tabChangeFunctionality
	        		  },
	        		  
	        		  'examlogisticsubstructure':{
	        			  afterrender:function(ob){ 
	        				  if(this.getCurrentLoggedPortalId()==2) {
	        					  var $this = this;
	        					  var $this = this;
	        					  var room = $this.getRoomwiseattendanceview();
	        					  var plan = $this.getPlanwiseattendanceview();
	        					  var student = $this.getStudentwiseattendanceview();
	        					  var examlogisticsubstructure = this.getExamlogisticsubstructure();
	        					  var attendanceBygroupId = examlogisticsubstructure.down('#attendanceBygroupId');
	        					  attendanceBygroupId.setVisible(false);
	        					  room.hide();
	        					  student.hide();
	        					  plan.show();
	        					  this.planWiseViewResetFunctionality();
	        				  }
	        			  },
	        			  render: function(structure) {
	        				  var $this = this;
        					  $this.permissionManagementForAttendanceRadioBtn(structure, $this.getEXAM_LOGISTICS_PERMISSION());
	        			  }
	        		  },
	        		  'planwiseattendanceview': {
	        			render: function(structure) {
	        				this.doAccessControlValidation(structure, this.getEXAM_PLAN_WISE_ATTENDANCE_PERMISSION());
	        				this.disableExamPlanWiseOtherPivileges(structure,this.getEXAM_PLAN_WISE_ATTENDANCE_PERMISSION());
	        				var $this = this;
	        				var form  = $this.getPlanlogisticfilter();
	        				var cv = form.down('#courseVariantItemId');
	        				cv.allowBlank = true;
	        				form.down('#evaluationStageItemId').setVisible(false);
	        			}  
	        		  },
	        		  'roomwisegrid ':{
	        			  render:function(grid){
		        				this.doAccessControlValidation(grid, this.getEXAM_ROOM_WISE_ATTENDANCE_PERMISSION());
		        				this.disableExamAttendanceOtherPivileges(grid,this.getEXAM_ROOM_WISE_ATTENDANCE_PERMISSION());
		        				var buttonsToolBar = grid.query('toolbar')[0];
		        				var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
		        		    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
		        		    	var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
		        		    	var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
		        		         grid.getStore().removeAll();
		        		    /*	pdfAllBtn.setVisible(false);
		        		    	excelAllBtn.setVisible(false);*/
	        			  }
	        		  },
	        		  'studentwisegrid ':{
	        			  render:function(grid){
		        				this.doAccessControlValidation(grid, this.getEXAM_STUDENT_WISE_ATTENDANCE_PERMISSION());
		        				this.disableExamAttendanceOtherPivileges(grid,this.getEXAM_STUDENT_WISE_ATTENDANCE_PERMISSION());
		        				var buttonsToolBar = grid.query('toolbar')[0];
		        				var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
		        		    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
		        		    	var pdfAllBtn = pdftoolbar.menu.down('#exportPDFAll');
		        		    	var excelAllBtn = exceltoolbar.menu.down('#exportExcelAll');
		        		    	pdfAllBtn.setVisible(false);
		        		    	excelAllBtn.setVisible(false);
		        		    	 grid.getStore().removeAll();
	        			  }
	        		  },
	        		  'planwisegrid ':{
	        			  render:function(grid){
		        				var buttonsToolBar = grid.query('toolbar')[0];
		        				var btnExportToPDF = buttonsToolBar.query('#btnExportToPDF')[0];
		        		    	var btnExportToExcel = buttonsToolBar.query('#btnExportToExcel')[0];
		        		    	var pdfAllBtn = buttonsToolBar.down('#exportPDFAll');
		        		    	var excelAllBtn = buttonsToolBar.down('#exportExcelAll');
		        		    	pdfAllBtn.setVisible(true);
		        		    	excelAllBtn.setVisible(true);
		        		    	btnExportToExcel.setVisible(true);
		        		    	btnExportToPDF.setVisible(true)
		        		    	grid.getStore().removeAll();
	        			  }
	        		  },
	        		  'roomwisegrid button[itemId=btnPresentItemId]':{
	        			  click:function(ob){ 
	        				 this.setStatusForPresentAbsent(getExaminationTranslation("PRESENT"), getExaminationTranslation("ROOM_WISE"));
	        			  }
	        		  },
	        		  
	        		  'roomwisegrid button[itemId=btnSaveItemId]':{
	        			  click:function(ob){ 
	        				 this.saveAttendanceAndMalPractice(getExaminationTranslation("ROOM_WISE"));
	        			  }
	        		  },
	        		  
	        		  'roomwisegrid button[itemId=btnAbsentItemId]':{
	        			  click:function(ob){ 
	        				 this.setStatusForPresentAbsent(getExaminationTranslation("ABSENT"), getExaminationTranslation("ROOM_WISE"));
	        			  }
	        		  },
	        		  
	        		  'planwisegrid button[itemId=btnAbsentItemId]':{
	        			  click:function(ob){ 
	        				 this.setStatusForPresentAbsent(getExaminationTranslation("ABSENT"), getExaminationTranslation("PLAN_WISE"));
	        			  }
	        		  },
	        		  
	        		  'planwisegrid button[itemId=btnSaveItemId]':{
	        			  click:function(ob){ 
	        				  this.saveAttendanceAndMalPractice(getExaminationTranslation("PLAN_WISE"));
	        			  }
	        		  },
	        		  
	        		  'planwisegrid button[itemId=btnPresentItemId]':{
	        			  click:function(ob){ 
	        				 this.setStatusForPresentAbsent(getExaminationTranslation("PRESENT"), getExaminationTranslation("PLAN_WISE"));
	        			  }
	        		  },
	        		  
	        		  
	        		  
	        		  'studentwisegrid button[itemId=btnAbsentItemId]':{
	        			  click:function(ob){ 
	        				 this.setStatusForPresentAbsent(getExaminationTranslation("ABSENT"), getExaminationTranslation("STUDENT_WISE"));
	        			  }
	        		  },
	        		  
	        		  'studentwisegrid button[itemId=btnSaveItemId]':{
	        			  click:function(ob){ 
	        				  this.saveAttendanceAndMalPractice(getExaminationTranslation("STUDENT_WISE"));
	        			  }
	        		  },
	        		  
	        		  'studentwisegrid button[itemId=btnPresentItemId]':{
	        			  click:function(ob){ 
	        				 this.setStatusForPresentAbsent(getExaminationTranslation("PRESENT"), getExaminationTranslation("STUDENT_WISE"));
	        			  }
	        		  },
	        		  
	        		  
	        		  
	        		  
	        		  'examlogisticfilter customcombobox[itemId=sectionItemId]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var grp = form.findField("evalGroup");
	       					var batchId = form.findField("batchId");
	       					var periodId = form.findField("periodId");
	       					var programId = form.findField("programId");
	       					var section = form.findField("section");
	       					var courseId = form.findField("courseId");
	       					courseId.enable();
	       					courseId.reset();
	       				    var store =	courseId.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	programId:programId.getValue(),
	       				    	batchId:batchId.getValue(),
	       				    	periodId:periodId.getValue(),
	       				    	sectionId:section.getValue()
	       				    };
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter button[itemId=resetBtn]':{
	        			  click:function(ob){ 
	        				  this.planWiseViewResetFunctionality();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter button[itemId=generateReport]':{
	        			  click:function(ob){ 
	        				  this.openGenerateReportWindow();
	        			  }
	        		  },
	        		  'generatereportwin radiogroup[itemId=reportType]':{
	        			  change:function(cb, nv, ov){
	        				  var $this = this;
	        				  var $this = this;
	        				  var formWindow = $this.getGeneratereportwin();
	        				  var tempalte = formWindow.down('#chooseTemplate').getStore();
	        				 
	        				  if(nv.reportTypeId == true){ 
	        					  tempalte.getProxy().extraParams={
		        					  reportType:'Examination Absentee Report'
		        				  };
		        				  tempalte.load();
	        				  } 
	        				  if(nv.reportTypeId == false){
	        					  tempalte.getProxy().extraParams={
		        					  reportType:'Examination Attendance Report'
		        				  };
		        				  tempalte.load();
	        				  }
	        			  }
	        		  },
	        		  'generatereportwin button[itemId=submitBtn]':{
		        		  click:function(obj){
		        			  var $this = this;
		        			  $this.generateAllReportReport();
		        		  }
		        	  },
	        		  'generatereportwin button[itemId=previewTemplateBtn]':{
							 click:function(obj){
								  var $this=this;
		        				  var filterForm=$this.getGeneratereportwin();
		        				  var templateField=filterForm.down('#chooseTemplate');
		        				  if(!isNullOrEmpty(templateField.getValue())){
		        						var formWindow = $this.getPreviewtemplate();
		        						if (!formWindow) {
		        							Ext.widget('previewtemplate');
		        							formWindow = $this.getPreviewtemplate();
		        						}
		        						formWindow.show();

		        						var previewForm = $this.getPreviewtemplate();

		        						var templateId = templateField.getValue();
		        						var id=null;
		        						var url = SERVERURL.TEMPLATE_FIND_BY_ID;
		        						Ext.Ajax.request({
		        							type : 'rest',
		        							url : url,
		        							params : {
		        								id : templateId
		        							},
		        							method : 'GET',
		        							success : function(response) {
		        								var data = Ext.decode(response.responseText);
		        								id = data.reportTemplate.id;

		    	        						if(!isNullOrEmpty(data.reportTemplate)){
		    	        						var url = SERVERURL.TEMPLATE_PREVIEW;
		    	        						Ext.Ajax.request({
		    	        							type: 'rest',
		    	        							binary: true,
		    	        							url: url+'?id='+data.reportTemplate.id,
		    	        							method: 'GET',
		    	        							success : function(response){
		    	        								if(response.responseBytes.length>0){
		    	        									var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
		    	        									if(!isNullOrEmpty(blob) && blob != undefined){
		    	        										var url = window.URL.createObjectURL(blob);
		    	        										var a=previewForm.down("#profile_image");
		    	        										a.getEl().dom.src=url;
		    	        									}
		    	        								}
		    	        							}
		    	        						});
		    	        						}
		        							}
		        						});
		        					}
							 }
						 },
	        		  
	        		  'studentlogisticfilter':{
	        			  render:function(ob){ 
	        				  var $this=this;
	        				  var form = $this.getStudentlogisticfilter().getForm();
	        				  var studentId = form.findField("studentId");
	        				  /*var als = [];
	        				  als.push($this.getCurrentAcademyLocation());
	        				  studentId.getStore().getProxy().extraParams={
	        					  academyLocationIds:als
	        				  };
	        				  studentId.getStore().load();*/
	        			  }
	        		  },
	        		  
	        		  'studentlogisticfilter customcombobox[itemId=studentItemId]':{
	        			  render:function(combo){	        				 
		        				var $this=this;
		        				combo.getStore().on('beforeload', function(store, operation) {
			       				    var form = $this.getStudentlogisticfilter().getForm();
			        				var formValues= form.getValues();	        				 
			       				    var al = formValues.academyLocation;
				       				 var als=[];		       				
				 	        	    	if(al && typeof al[0] == 'object'){
				 	                       al.forEach(function(obj){
				 	                         als.push(obj.get('id'));
					 	                     });
					 	               }
					 	               else{
					 	                   als.push(al)
					 	               }
				 	        	    	 store.proxy.extraParams = {
				       				    	whetherMarksheet:true,
			    	        	    		academyLocationIds:als.join(),
				       				    };
	                 		 })
	        			  },
	        			  select:function(ob,record){ 
	        				  var data=  record[0].data.id;
	        				  var $this=this;
	        				  var form = $this.getStudentlogisticfilter().getForm();
	        				  var formValues = form.getValues();
	          	    		  var alValues = formValues.academyLocation;
		       				  var cv = form.findField("courseVariant");
		       				  var plan = form.findField("evaluationPlanId");
		       				  var event = form.findField("eventId");
		       				form.findField("evalPlanLevelId").setDisabled(true);
		       				  form.findField("evalPlanLevelId").reset();
		       				  var als = [];
	        				  //als.push($this.getCurrentAcademyLocation());
		       				if(typeof alValues == 'object'){
	 	        	    		alValues.forEach(function(obj){
	 	                         als.push(obj.get('id'));
		 	                     });
		 	               }
		 	               else{
		 	                   als.push(alValues)
		 	               }
	        				  cv.enable();
	        				  cv.reset();
	        				  cv.getStore().getProxy().extraParams={
	        					  academyLocationIds:als.join(),
	        					  whetherMarksheet:true,
	        					  admissionId:data
	        				  };
	        				  cv.getStore().load();
	        				  plan.reset();
	        				  event.reset();
	        				  plan.disable();
	        				  event.disable();
	        			  }
	        		  },
	        		  
	        		  'studentlogisticfilter customcombobox[itemId=courseVariantItemId]':{
	        			  select:function(ob,record){ 
	        				  var data=  record[0].data.id;
	        				  var $this=this;
	        				  var form = $this.getStudentlogisticfilter().getForm();
	        				  var formValues = form.getValues();
	          	    		  var alValues = formValues.academyLocation;
	        				  var studentId = form.findField("studentId");
		       				  var cv = form.findField("courseVariant");
		       				  var plan = form.findField("evaluationPlanId");
		       				  var event = form.findField("eventId");
			       				var als = [];
		        				  //als.push($this.getCurrentAcademyLocation());
			       				if(typeof alValues == 'object'){
		 	        	    		alValues.forEach(function(obj){
		 	                         als.push(obj.get('id'));
			 	                     });
			 	               }
			 	               else{
			 	                   als.push(alValues)
			 	               }
	        				  plan.enable();
	        				  plan.reset();
	        				  plan.getStore().getProxy().extraParams={
	        					  academyLocationIds:als.join(),
	        					  whetherMarksheet:true,
	        					  admissionId:studentId.getValue(),
	        					  courseVariantId:data
	        				  };
	        				  plan.getStore().load();
	        				  event.reset();
	        				  event.disable();
	        			  }
	        		  },
	        		  'studentlogisticfilter groupingcombobox[itemId=evalPlanLevelItemId]':{
	        			  select:function(obj,record){ 
	        				  var formData = obj.up().up()
	        				  var formValues = formData.getValues()
	        				  var evaluationPlan = formData.down('#evaluationPlanItemId')
	        				  var evaluationPlan = evaluationPlan.getValue()
	        				  var eventItemId = formData.down('#eventItemId')
	        				  var levelOneId=null;
	  					    var levelTwoId=null;
	  					    var levelThreeId=null;
	  		        	 if(!isNullOrEmpty(record[0].data.code)){
	  						   if(record[0].data.code=="Assessment Method"){
	  							   levelThreeId=record[0].data.levelId;
	  						   }else if(record[0].data.code=="Assessment Sub Type"){
	  							   levelTwoId=record[0].data.levelId;
	  						   }else if(record[0].data.code=="Assessment Type"){
	  							   levelOneId=record[0].data.levelId;
	  						   }
	  					    }
	  		        	eventItemId.reset();
	  		        	eventItemId.enable();
	  						var isDynamicScheme=false;
	  								if(!isNullOrEmpty(formData.down('#evaluationPlanItemId').valueModels)){
	  									if(!isNullOrEmpty(formData.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
	  										isDynamicScheme=true;
	  									}
	  								}
	  								eventItemId.getStore().getProxy().extraParams ={												
	  									evalPlanId : evaluationPlan,
	  									isDynamicScheme:isDynamicScheme,
	  									evaluationPlanLevelOneId: levelOneId,
	  									evaluationPlanLevelTwoId: levelTwoId,
	  									evaluationSequenceId: levelThreeId,
	  									//portalId:portalId!=1?null:portalId
	  								}
	  								eventItemId.getStore().load({
	  									callback : function(records){
	  										eventItemId.reset();
	  										eventItemId.enable();
	  										if(records.length == 1){;
	  											eventItemId.setValue(records[0].data.id);
	  										}
	  									}
	  								});
	        			  }
	        		  },
	        		  'studentlogisticfilter customcombobox[itemId=evaluationPlanItemId]':{
	        			  select:function(ob,record){ 
	        				  var data=  record[0].data.id;
	        				  var $this=this;
	        				  var form = $this.getStudentlogisticfilter().getForm();
	        				  var formValues = form.getValues();
	          	    		  var alValues = formValues.academyLocation;
	        				  var studentId = form.findField("studentId");
		       				  var cv = form.findField("courseVariant");
		       				  var plan = form.findField("evaluationPlanId");
		       				  var evalPlanLevelId = form.findField("evalPlanLevelId");
		       				  var event = form.findField("eventId");
		       				    event.reset();
			       				var als = [];
		        				  //als.push($this.getCurrentAcademyLocation());
			       				if(typeof alValues == 'object'){
		 	        	    		alValues.forEach(function(obj){
		 	                         als.push(obj.get('id'));
			 	                     });
			 	               }
			 	               else{
			 	                   als.push(alValues)
			 	               }
			       				evalPlanLevelId.enable();
			       				evalPlanLevelId.reset();
			       				var planLevelStore = evalPlanLevelId.getStore()
			       				planLevelStore.getProxy().extraParams={
	        					  academyLocationIds:als.join(),
	        					  whetherMarksheet:true,
	        					  admissionId:studentId.getValue(),
	        					  courseVariantIds:cv.getValue(),
	        					  evaluationPlanId:plan.getValue(),
	        				  };
			       				planLevelStore.load({
			       					callback:function(reco){
		    								event.setDisabled(false);
		    			       				var planLevelStore = evalPlanLevelId.getStore()

		    								if(reco.length==1) {
		    									event.reset();
		    									event.setVisible(true);
		    									
		    									event.setValue(reco[0].data.id);
//		    									generateReport.setDisabled(false);
		    									//form.isValid();
		    								} else {
//		    									generateReport.setDisabled(true);
		    									event.allowBlank=false;
		    									form.isValid();
		    								}
		    							}
			       				});
//			       				event.enable()
//	        				  event.reset();
//	        				  event.enable();
//	        				  event.getStore().getProxy().extraParams={
//	        					  academyLocationIds:als.join(),
//	        					  whetherMarksheet:true,
//	        					  admissionId:studentId.getValue(),
//	        					  courseVariantId:cv.getValue(),
//	        					  planId:data
//	        				  };
//	        				  event.getStore().load();
//	        				  evalPlanLevelId.enable()
	        			  }
	        		  },
	        		  
	        		  'studentlogisticfilter button[itemId=searchBtn]':{
	        			  click:function(ob){ 
	        				  this.listStudentWiseGrid();
	        			  }
	        		  },
	        		  
	        		  'studentlogisticfilter button[itemId=resetBtn]':{
	        			  click:function(ob){ 
	        				  this.studentWiseViewResetFunctionality();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=evaluationType_Id]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getPlanlogisticfilter().getForm();
	       				    var formValues = form.getValues();
	       				    var stage = form.findField("evaluationStage");
	       					var course = form.findField("courseId");
	       					var cv = form.findField("courseVariant");
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var btnGenerateReport = $this.getPlanlogisticfilter().down('#generateReport');
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var alinfomodel = Academia.model.authentication.ALInfoModel;
    						var wheatherSchool = alinfomodel.get('wheatherSchool');
//	       					btnGenerateReport.setVisible(false);
    						var planStore = plan.getStore();
    						var level = form.findField('evalPlanLevelId');
    						var term = form.findField('academicTerm');
    						var attendanceAsHostFaculty = form.findField('attendanceAsHostFaculty');
    						term.reset();
    						term.getStore().load({
	    	    				callback:function(record){
	    	    					for(var i in record){
	    	    						if(record[i].data.whetherCurrentAcademicTerm==true){
	    	    							term.setValue(record[i].data.id);
	    	    							term.fireEvent('select', term);
		   								   }		    	    						
	    	    					}
	    	    				}	        			
    							    					
	    	    			});
	       					if(data == getExaminationTranslation('CNTRL_ACADEMICS')){
//	       						btnGenerateReport.setVisible(true);
	       						course.enable();
	       						course.setVisible(true);
	       						course.allowBlank=false;
	       						cv.setVisible(true);
		       					course.reset();
		       					var store =	course.getStore();
			       				var als=[];
		 	        	    	if(attendanceAsHostFaculty && attendanceAsHostFaculty.getValue()){
		 	        	    		store.getProxy().api.read=SERVERURL.PATH_FIND_COURSE_AND_CV;
		 	        	    	}else{
		 	        	    		store.getProxy().api.read=SERVERURL.PATH_FIND_COURSE_FOR_VARIANT_MAPPING;
		 	        	    		als.push($this.getCurrentAcademyLocation());
		 	        	    	}
		 	        	    	var facultyId=null;
		 	        	    	if($this.getCurrentLoggedPortalId() == 2) {
		 	        	    		facultyId=$this.getCurrentlyLoggedInUser().id;
		 	        	    	}
		       				    store.getProxy().extraParams={
//		       				    	whetherMarksheet:true,
	    	        	    		academyLocationIds:formValues.attendanceAsHostFaculty?null:als.join(),
	    	        	    		facultyId:formValues.attendanceAsHostFaculty?null:facultyId
		       				    };
		       				    
		       				    store.load();
		       				    cv.reset();
		       				    cv.disable();
		       				    program.setVisible(false);
		       				    program.reset();
	       						batch.setVisible(false);
	       						batch.reset();
	       						period.setVisible(false);
	       						period.reset();
	       						section.setVisible(false);
	       						section.reset();
	       						planStore.getProxy().api.read = SERVERURL.EXAM_REPORT_COMMON_FILTER_URL;
	       					} else {
	       						course.setVisible(false);
	       						course.allowBlank=true;
	       						cv.setVisible(false);
	       						program.setVisible(true);
		       					if($this.getCurrentLoggedPortalId() == 2) {
	          					   program.getStore().getProxy().extraParams = {
	          						   //academyLocationIds:$this.getCurrentAcademyLocation(),
	          						   //facultyId : $this.getCurrentlyLoggedInUser().id
	          					   };
	      					    } else {
	      					    	program.getStore().getProxy().extraParams = {
	          						   //academyLocationIds:$this.getCurrentAcademyLocation(),
	      					    		academicTermId: formValues.academicTerm
	          					    };
	      					    }
		       					var progStore = program.getStore();
		       					if(!formValues.attendanceAsHostFaculty) {
		       						Object.assign(program.getStore().getProxy().extraParams, {
		       							academyLocationIds: $this.getCurrentAcademyLocation(),
		       							facultyId : $this.getCurrentlyLoggedInUser().id
		       						});
		       						progStore.getProxy().api.read = SERVERURL.FIND_ALL_ACTIVE_PROGRAM_BY_ASSIGNED_FACULTYID;
		       					}
		       					else {
		       						progStore.getProxy().api.read = SERVERURL.PATH_FIND_PROGRAM_FOR_OTHER_IMPORT_MARK_REMARK;
		       					}
		       					program.getStore().load();
	       						batch.setVisible(true).disable();
	       						period.setVisible(true).disable();
	       						section.setVisible(true).disable();
	       						//plan.allowBlank=true;
		       					//$this.setAllowBlank(plan, true);
	       						//event.allowBlank=true;
	       						
	    						if(wheatherSchool) {
	    							period.setVisible(false); 
	    						}else{
	    							period.setVisible(true);
	    						}
	    						planStore.getProxy().api.read = SERVERURL.PATH_PLANS_FOR_OTHER;
	    						
	       					}
	       					level.reset();
    						level.disable();
//	       					stage.reset();
	       				    plan.reset();
	       				    event.reset();
	       					plan.disable();
	       				    event.disable();
	       				    form.isValid();
	        			  }
	        		  },
	        		  'planlogisticfilter customcombobox[itemId=evaluationStageItemId]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getPlanlogisticfilter().getForm(); 
	       				    var formValues = form.getValues();
	       				    var stage = form.findField("evaluationStage");
	       					var course = form.findField("courseId");
	       					var cv = form.findField("courseVariant");
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					
	       					var evaluationPlanType = form.findField("evaluationPlanType");
	       					var program = form.findField("programId");
	       					if(getExaminationTranslation('CNTRL_ACADEMICS')==evaluationPlanType.getValue()){
	       						course.enable();
		       					course.reset();
		       				    var store =	course.getStore();
			       				var als=[];
		 	        	    	als.push($this.getCurrentAcademyLocation());
		       				    store.getProxy().extraParams = {
		       				    	whetherMarksheet:true,
	    	        	    		//academyLocationIds:als
		       				    };
		       				    if(!formValues.attendanceAsHostFaculty) {
		       				    	Object.assign(store.getProxy().extraParams, {
		       				    		academyLocationIds: als
		       				    	});
		       				    }
		       				    store.load();
		       				    cv.reset();
		       				    cv.disable();
	       					} else {
	       						if($this.getCurrentLoggedPortalId() == 2) {
	          					   program.getStore().getProxy().extraParams = {
	          						   academyLocationIds:$this.getCurrentAcademyLocation(),
	          						   facultyId : $this.getCurrentlyLoggedInUser().id
	          					   };
		      					}
	       						program.getStore().load();
	       						program.setDisabled(false);
	       					}
	       				    plan.reset();
	       				    event.reset();
	       					plan.disable();
	       				    event.disable();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=programIdQuickFiltr]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getPlanlogisticfilter().getForm(); 
	       				    var vals = form.getValues();
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var evaluationPlanType = form.findField("evaluationPlanType");
	       					var stage = form.findField("evaluationStage");
	       					var evalPlanLevelId = form.findField("evalPlanLevelId");
		       				var als=[];
		       				als.push($this.getCurrentAcademyLocation());
		       				evalPlanLevelId.enable();
		       				evalPlanLevelId.reset();
		       				evalPlanLevelId.setDisabled(true)
	       					//plan.allowBlank=false;
		       				plan.enable();
	       					section.reset();
	       					section.setDisabled(true);
	       					period.reset();
	       					period.setDisabled(true);
	       					batch.setDisabled(false);
	       					batch.reset();
	       					/*batch.getStore().getProxy().extraParams={
	       						id:data
	       					};
	       					batch.getStore().load({
	       						callback:function(record){
	       				    		if(record.length==1) {
	       				    			batch.setValue(record[0].data.id);
	       				    			period.getStore().getProxy().extraParams={
	       		       						id:record[0].data.id
	       		       					};
	       				    			period.getStore().load({
	       				    				callback:function(rec){
	       				    					period.setDisabled(false);
	       				    					if(rec.length==1) {
	       				    						period.reset();
	       				    						period.setValue(rec[0].data.id);
	       				    						section.setDisabled(false);
	       					       					section.getStore().getProxy().extraParams={
	       					       						periodId:rec[0].data.id
	       					       					};
	       					       					section.getStore().load({
	       					       						callback:function(res){
	       					       							section.setDisabled(false);
	       					       							plan.reset();
	       					       							if(res.length==1) {
	       					       								section.reset();
	       					       								section.setValue(res[0].data.id);
	       					       								plan.getStore().getProxy().extraParams = {
	       					       									whetherMarksheet:true,
	       					       									academyLocationIds:als,
	       					       									evaluationType:evaluationPlanType.getValue(),
	       					       									evaluationStage:stage.getValue(),
	       					       									programId:program.getValue(),
	       					       									batchId:batch.getValue(),
	       					       									periodId:period.getValue(),
	       					       									sectionIds:section.getValue()
	       					       								};
	       					       								plan.getStore().load();
	       					       								plan.setDisabled(false);
	       					       								//plan.allowBlank=false;
	       					       							} else{
	       					       								plan.setDisabled(false);
	       					       								//plan.allowBlank=false;
	       					       							}
	       					       						}
	       					       					});
	       				    					}
	       				    				}
	       				    			});
	       				    		}
	       						}
	       					});*/
	       					
	       					
	       				 var batchField=$this.getPlanlogisticfilter().down('#batchIdQuickFiltr');
        				 var periodField=$this.getPlanlogisticfilter().down('#periodIdQuickFiltr');
        				 var sectionField=$this.getPlanlogisticfilter().down('#sectionIdQuickFiltr');
        				 batchField.reset();
        				 batchField.enable();
        				 periodField.reset();
        				 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	 if(wheatherSchool) {
	                		 periodField.setVisible(false);
	                	 }
        				 var programId = record[0].get("id");
        				 if(programId > 0){
        					 var store = this.getStore('common.CurrentBatchStore');

        					 store.getProxy().extraParams = {
        						 programId: programId,
        						 academicTermId: vals.academicTerm
        					 };
        					 store.load({
        						 callback: function(records, operation, success) {
        							 if (success) {
        								 var batchId = 0;
        								 for(var i=0,j=0; i<records.length; i++){
        									 if (records.length == 1) {
        										 batchId = records[i].data.id;
        									 } else if(records[i].data.isCurrentPeriodOfProgram){
        										 if(j==0){
        											 batchId = records[i].data.id;
        											 j++;
        										 } else {
        											 batchId = 0;
        											 sectionField.reset();
    												 sectionField.disable();
        											 return;
        										 }
        									 }
        								 }
        							 }
        							 if(batchId > 0){
        								 batchField.setValue(batchId);
        								 var store = $this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
        								 store.getProxy().extraParams = {
        									 id : batchId,
        									 academicTermId: vals.academicTerm
        								 };
        								 store.load({
        									 callback: function(records, operation, success) {
        										 if (success) {
        											 if(records.length == 0){
        												 if(wheatherSchool) {
        												 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
        												 sectionField.reset();
        												 sectionField.getStore().loadRawData([]);
        												 plan.enable();
        												 plan.getStore().getProxy().extraParams = {
        	            				       					whetherMarksheet:true,
        	            				       					academyLocationIds:als,
        	            				       					evaluationType:evaluationPlanType.getValue(),
        	            				       					evaluationStage:stage.getValue(),
        	            				       					programId:programId,
        	            				       					batchId:batchId,
        	            				       					//periodId:records[0].data.id
        	            				       				};
        	            							     plan.getStore().load();
        												 }
        											 } else if(records.length == 1){
        												 periodField.enable();
        												 periodField.setValue(records[0].data.id);
        												 sectionField.reset();
        												 sectionField.enable();
        												 plan.reset();
        												 plan.enable();
        												 plan.getStore().getProxy().extraParams = {
     	            				       					whetherMarksheet:true,
     	            				       					academyLocationIds:als,
     	            				       					evaluationType:evaluationPlanType.getValue(),
     	            				       					evaluationStage:stage.getValue(),
     	            				       					programId:programId,
     	            				       					batchId:batchId,
     	            				       					periodId:records[0].data.id
     	            				       				};
        												 plan.getStore().load();
        												 sectionField.getStore().getProxy().extraParams = {
                    		            					 periodId: records[0].data.id
                    		    	    				   };
        												 sectionField.getStore().load({
     	       					       						callback:function(res){
     	       					       						sectionField.setDisabled(false);
    	       					       							plan.reset();
    	       					       							if(res.length==1) {
    	       					       									sectionField.reset();
    	       					       									sectionField.setValue(res[0].data.id);
    	       					       									plan.getStore().getProxy().extraParams = {
    	       					       									whetherMarksheet:true,
    	       					       									academyLocationIds:als,
    	       					       									evaluationType:evaluationPlanType.getValue(),
    	       					       									evaluationStage:stage.getValue(),
    	       					       									programId:program.getValue(),
    	       					       									batchId:batch.getValue(),
    	       					       									periodId:period.getValue(),
    	       					       									sectionIds:sectionField.getValue()
    	       					       								};
    	       					       								plan.getStore().load();
    	       					       								plan.setDisabled(false);
    	       					       								//plan.allowBlank=false;
    	       					       							} else{
    	       					       								plan.setDisabled(false);
    	       					       								//plan.allowBlank=false;
    	       					       							}
    	       					       						}
    	       					       					});
        												 if(wheatherSchool) {
        													 periodField.setVisible(false);
        												 }
        											 } else {
        												 periodField.enable();
        												 periodField.setVisible(true);
        												 sectionField.reset();
        												 sectionField.disable();
        											 }
        										 }
        									 }
        								 });
        							 }
        						 }
        					 });
        				 }
	       				    plan.reset();
	       				    event.reset();
	       					//plan.disable();
	       				    event.disable();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=batchIdQuickFiltr]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getPlanlogisticfilter().getForm(); 
	       				    var vals = form.getValues();
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var evaluationPlanType = form.findField("evaluationPlanType");
	       					var evalPlanLevel = form.findField("evalPlanLevelId");
	       					var stage = form.findField("evaluationStage");
	       					var als=[];
		       				als.push($this.getCurrentAcademyLocation());
	       					/*section.reset();
	       					section.setDisabled(true);
	       					period.setDisabled(false);
	       					period.reset();
	       					period.getStore().getProxy().extraParams={
	       						id:data
	       					};
	       					period.getStore().load();*/
	       					
	       					

           				 var periodField=$this.getPlanlogisticfilter().down('#periodIdQuickFiltr');
           				 var sectionField=$this.getPlanlogisticfilter().down('#sectionIdQuickFiltr');
           				 var batchId = record[0].get("id");
           				 
           				 evalPlanLevel.clearValue();
           				 evalPlanLevel.setDisabled(true);
           				 
           				 var alinfomodel = Academia.model.authentication.ALInfoModel;
		                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
		                	 if(wheatherSchool) {
		                		 periodField.setVisible(false);
		                	 }
           				 if(batchId > 0){
           					 periodField.enable();
           					 var store = this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
           					 store.getProxy().extraParams = {
           						 id : batchId,
           						academicTermId: vals.academicTerm
           					 };
           					 store.load({
           						 callback: function(records, operation, success) {
           							 if (success) {
           								 if(records.length == 0){
           									 if(wheatherSchool) {
           										 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
           										 sectionField.reset();
           										 sectionField.getStore().loadRawData([]);
               									 sectionField.enable();
               									 plan.reset();
               									 plan.getStore().getProxy().extraParams = {
               				       					whetherMarksheet:true,
               				       					academyLocationIds:als,
               				       					evaluationType:evaluationPlanType.getValue(),
               				       					evaluationStage:stage.getValue(),
               				       					programId:program.getValue(),
               				       					batchId:batchId.getValue(),
               				       				};
               									 plan.getStore().load();
               									 plan.enable();
           									 }
           								 } else if(records.length == 1){
           									 periodField.enable();
           									 periodField.setValue(records[0].data.id);
           									 sectionField.reset();
           									 sectionField.enable();
           									 sectionField.getStore().getProxy().extraParams = {
           		            					 periodId: records[0].data.id,
           		            					academicTermId: vals.academicTerm
           		    	    				   };
           									 sectionField.getStore().load();
           									 if(wheatherSchool) {
           										 periodField.setVisible(false);
           									 }
           									 plan.reset();
           									 plan.getStore().getProxy().extraParams = {
            				       					whetherMarksheet:true,
            				       					academyLocationIds:als,
            				       					evaluationType:evaluationPlanType.getValue(),
            				       					evaluationStage:stage.getValue(),
            				       					programId:program.getValue(),
            				       					batchId:batchId,
            				       					periodId:records[0].data.id
            				       				};
            							     plan.getStore().load();
           									 plan.enable();
           								 } else {
           									 periodField.setVisible(true);
           									 periodField.enable();
           									 plan.reset();
           									 plan.enable();
           								 }
           							 }
           						 }
           					 });
           				 }
	       				    plan.reset();
	       				    event.reset();
	       				    if(evaluationPlanType.getValue() == 'ACADEMICS') {
	       				    	plan.disable();
	       				    }
	       				    event.disable();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=periodIdQuickFiltr]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getPlanlogisticfilter().getForm(); 
	       				    var vals = form.getValues();
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var evalPlanLevel = form.findField("evalPlanLevelId");
	       					section.setDisabled(false);
	       					section.reset();
	       					section.getStore().getProxy().extraParams={
	       						periodId:data,
	       						academicTermId: vals.academicTerm
	       					};
	       					section.getStore().load();
	       				    plan.reset();
	       				    event.reset();
	       				    evalPlanLevel.reset();
	       				    evalPlanLevel.disable();
	       					//plan.disable();
	       				    event.disable();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=sectionIdQuickFiltr]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getPlanlogisticfilter().getForm(); 
	       				    var vals = form.getValues();
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var evaluationPlanType = form.findField("evaluationPlanType");
	       					var stage = form.findField("evaluationStage");
	       					var store =	plan.getStore();
		       				var als=[];
		       				als.push($this.getCurrentAcademyLocation());
		       				store.getProxy().extraParams = {
		       					whetherMarksheet:true,
		       					academyLocationIds:als,
		       					evaluationType:evaluationPlanType.getValue(),
		       					evaluationStage:stage.getValue(),
		       					programId:program.getValue(),
		       					batchId:batch.getValue(),
		       					periodId:period.getValue(),
		       					sectionIds:section.getValue(),
		       					academicTermId: vals.academicTerm,
		       					sectionId: section.getValue(),
		       					evaluationPlanType: evaluationPlanType.getValue(),
		       					isHostFacultyCheck: vals.attendanceAsHostFaculty
		       				};
		       				if(vals.evaluationPlanType == 'OTHER') {
		       					store.getProxy().api.read = SERVERURL.PATH_PLANS_FOR_OTHER;
				        	}
				        	else {
				        		store.getProxy().api.read = SERVERURL.EXAM_REPORT_COMMON_FILTER_URL;
				        	}
	       				    store.load();
	       				    event.reset();
	       				    plan.reset();
	       				    plan.enable();
	        			  }
	        		  },
	        		  'planlogisticfilter customcombobox[itemId=courseItemId]':{
	        			  render:function(combo){	        				 
		        				var $this=this;
		        				combo.getStore().on('beforeload', function(store, operation) { 
			       				    var form = $this.getPlanlogisticfilter().getForm();
			        				var formValues= form.getValues();	        				 
			       				    var al = formValues.academyLocation;
				       				 var acTerm = formValues.academicTerm;
				       				 var als=[];		       				
				 	        	    	if(typeof al == 'object'){
				 	                       al.forEach(function(obj){
				 	                         als.push(obj.get('id'));
					 	                     });
					 	               }
					 	               else{
					 	                   als.push(al)
					 	               }
				 	        	    	 store.proxy.extraParams = {
				       				    	//whetherMarksheet:true,
			    	        	    		academyLocationIds:formValues.attendanceAsHostFaculty?null:als.join(),
			    	        	    		academicTermId:acTerm,
				       				    };
				 	        	    	if(!formValues.attendanceAsHostFaculty) {
				        					Object.assign(store.getProxy().extraParams, {
				        						academyLocationIds: als.join()
				        					});
				        				}
	                 		 })
	        			  },
	        			  select:function(ob,record){ 	
	        				var data=  record[0].data.id;
	        				var $this=this;
	        				var currentAL = $this.getCurrentAcademyLocation()
	       				    var form = $this.getPlanlogisticfilter().getForm();
	        				 var formValues= form.getValues();	        				 
	       				    var al = formValues.academyLocation;
	       				    var acTerm = formValues.academicTerm;
	       				    var stage = form.findField("evaluationStage");
	       					var course = form.findField("courseId");
	       					var cv = form.findField("courseVariant");
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var evaluationPlanType = form.findField("evaluationPlanType");
	       					var stage = form.findField("evaluationStage");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var evalPlanLevel = form.findField("evalPlanLevelId");
	       					
//	       					var generateReport = $this.getPlanlogisticfilter().down('#generateReport');
	       					var als=[];
	       					if(portalId==2) {
		       					var facultyId=$this.getCurrentlyLoggedInUser().id;
		       					als.push($this.getCurrentAcademyLocation());
	       					} 
	       					cv.enable();
	       					cv.reset();
	       					//var courseStore = course.getStore()
	       				    var store =	cv.getStore();
	       				    //var planStore =	plan.getStore();
	       				    
	       				    var als=[];
		       				 	       				
	 	        	    	if(typeof al == 'object'){
	 	                       al.forEach(function(obj){
	 	                         als.push(obj.get('id'));
		 	                     });
		 	               }
		 	               else{
		 	                   als.push(al)
		 	               }	 	        	    	
	 	        	    	var cvArr = []
	 	        	    	/*courseStore.getProxy().extraParams = {
	       				    	whetherMarksheet:true,
    	        	    		academyLocationIds:als.join(),
    	        	    		academicTermId:acTerm,
	       				    };
	 	        	    	courseStore.load();*/
	       				    store.getProxy().extraParams = {
//	       				    	whetherMarksheet:true,
    	        	    		//academyLocationIds:als.join(),
    	        	    		academicTermId:acTerm,
    	        	    		courseId:data,
    	        	    		facultyId:facultyId,
    	        	    		isHostFacultyCheck: formValues.attendanceAsHostFaculty
	       				    };
	       				    if(!formValues.attendanceAsHostFaculty) {
	       				    	Object.assign(store.getProxy().extraParams, {
	       				    		academyLocationIds: als.join()
	       				    	});
	       				    }
	       				    store.load({
	       				    	callback:function(record){
	       				    		if(record.length==1) {
	       				    			cv.setValue(record[0].data.id);
	       				    			cvArr.push(cv.getValue())
	       				    			plan.setVisible(true);
	       				    			/*var storePlan =	plan.getStore();
	       				    			storePlan.getProxy().extraParams = {
	       				    				whetherMarksheet:true,
  				    						academyLocationIds:als.join(),
	       				    				courseId:course.getValue(),
	       				    				//courseVariantId:record[0].data.id,
	       				    				courseVariantIds:cvArr.join(),
	       				    				evaluationType:evaluationPlanType.getValue(),
	       				    				evaluationStage:stage.getValue()
	       				    			};
	       				    			storePlan.load({
	       				    				callback:function(rec){
	       				    					plan.setDisabled(false);
	       				    					if(rec.length==1) {
	       				    						plan.reset();
	       				    						plan.setValue(rec[0].data.id);       				    						
	       				    						//evalPlanLevel.setDisabled(false);
	       				    						var storePlanLevel = evalPlanLevel.getStore();
	       				    						storePlanLevel.getProxy().extraParams = {
	       				    							whetherMarksheet:true,
	       				    							academyLocationIds:als.join(),
	       				    							courseId:course.getValue(),
	       				    							courseVariantIds:cvArr.join(),
	       				    							evaluationPlanId:rec[0].data.id,
	       				    							evaluationPlanType:evaluationPlanType.getValue(),
	       				    							evaluationStage:stage.getValue(),
	       				    							programId:program.getValue(),
	       				    							batchId:batch.getValue(),
	       				    							periodId:period.getValue(),
	       				    							sectionIds:section.getValue(),
	       				    							evaluationPlanId:plan.getValue()
	       				    						};
	       				    						storePlanLevel.load({
	       				    							callback:function(rec){
	       				    								if(plan.getValue()){
	       				    									evalPlanLevel.setDisabled(false)
	       				    								}
	       				    								else{
	       				    									evalPlanLevel.setDisabled(true)
	       				    								}
	       				    								//if(rec.length>0) { 
	       				    									//evalPlanLevel.setValue(rec[0].data.id);       				    						
	       				    									var storeEvent = event.getStore();
	       		       				    						storeEvent.getProxy().extraParams = {
	       		       				    							whetherMarksheet:true,
	       		       				    							academyLocationIds:als.join(),
	       		       				    							courseId:course.getValue(),
	       		       				    							courseVariantIds:cvArr.join(),
	       		       				    							evaluationPlanId:rec[0].data.id,
	       		       				    							evaluationPlanType:evaluationPlanType.getValue(),
	       		       				    							evaluationStage:stage.getValue(),
	       		       				    							programId:program.getValue(),
	       		       				    							batchId:batch.getValue(),
	       		       				    							periodId:period.getValue(),
	       		       				    							sectionIds:section.getValue()
	       		       				    						};
	       		       				    						storeEvent.load({
	       		       				    							callback:function(reco){
	       		       				    								//event.setDisabled(false);
	       		       				    								if(reco.length==1) {
	       		       				    									event.reset();
	       		       				    									event.setVisible(true);
	       		       				    									event.setValue(reco[0].data.id);
//	       		       				    									generateReport.setDisabled(false);
	       		       				    									form.isValid();
	       		       				    								} else {
//	       		       				    									generateReport.setDisabled(true);
	       		       				    									event.allowBlank=false;
	       		       				    									form.isValid();
	       		       				    								}
	       		       				    							}	       				    						
	       		       				    						});
	       				    								//}
	       				    							}
	       				    						})
	       				    					}
	       				    				}
	       				    			});*/
	       				    		} else {
	       				    				plan.reset();
		       				    			plan.setDisabled(true);
		       				    			event.reset();
		       				    			event.setDisabled(true);
		       				    			event.allowBlank=false;
		       				    			plan.allowBlank=false;
   		       				    			var storePlan =	plan.getStore();
   		       				    			storePlan.getProxy().extraParams = {
   		       				    				whetherMarksheet:true,
   		       				    				academyLocationIds:als.join(),
   		       				    				courseId:course.getValue(),
   		       				    				evaluationType:evaluationPlanType.getValue(),
   		       				    				evaluationStage:stage.getValue(),
   		       				    				filterType: 'PLAN'
   		       				    			};
   		       				    			storePlan.load();
   		       				    		}
	       				    	}
	       				    });
	       				    form.isValid();
	        			  },
	        			  afterrender: function(cmp) {
	        				  cmp.getStore().on('beforeload', function(store, operation) {
	        					  store.lastOperation = operation;
	        				  });
	        			  }
	        		  },
//	        		  'planlogisticfilter multiselectcombofield[itemId=courseVariantItemId]':{ 
//	        			  change:function(ob,record){ 
//	        				  var formData = ob.up('#planlogisticfilter');
//	        				  	formData.down('#evaluationPlanItemId').reset();
//	        				  	formData.down('#evaluationPlanItemId').clearValue();
//	        				  	formData.down('#evaluationPlanItemId').setDisabled(true);
////		        				formData.down('#evalPlanLevelItemId').reset();
////		        				formData.down('#eventItemId').reset();
//	        				  	var formValues = formData.getValues();
//		        				var als = formValues.academyLocation;
//		        				var acTerm = formValues.academicTerm;	
//		        				var cvVal = formValues.courseVariant;
//		        				var plan = formData.down("#evaluationPlanItemId");
//		        				
//		        				var cvArr = []
//		       					if(typeof cvVal == 'object'){
//		       						cvVal.forEach(function(obj){
//			                        	 cvArr.push(obj.get('id'));
//			                       });
//		       					}
//		        				 var alArr = [];
//			       				 if(typeof als == 'object'){
//			                         als.forEach(function(obj){
//			                             alArr.push(obj.get('id'));
//			                       });
//			                     }
//			                     else{
//			                         alArr.push(als)
//			                     }
//			       				var store =	plan.getStore();
//			       				store.getProxy().extraParams = {
//		       				    	whetherMarksheet:true,
//	    	        	    		academyLocationIds:alArr.join(),
//	    	        	    		academicTermId:acTerm,
//	    	        	    		courseId:course.getValue(),
//	    	        	    		//courseVariantId:data,
//	    	        	    		//courseVariantIds:cvArr.join(),
//	    	        	    		//evaluationType:evaluationPlanType.getValue(),
//	    	        	    		//evaluationStage:stage.getValue()
//		       				    };
//		       				    store.load({
//		       				    	callback:function(rec) {
//		       				    		plan.setDisabled(false);
//		       				    	}
//		       				    })
//	        				  	
//	        				  	
//	        			  }
//	        			  
//	        		  },
	        		  
	        		  'planlogisticfilter multiselectcombofield[itemId=courseVariantItemId]':{
	        			  change:function(ob,record){ 
	        				//var data=  record[0].data.id;
	        				  if(ob.preventChange) {
	        					  return;
	        				  }
	        				var $this=this;
	        				var formV2 = ob.up('#planlogisticfilter');
	       				    var form = $this.getPlanlogisticfilter().getForm(); 
	       				    var formValues = form.getValues();
	       				    var als = formValues.academyLocation;
	       				    var acTerm = formValues.academicTerm;	       				    
	       				    var evaluationPlanType = form.findField("evaluationPlanType");
	       					var stage = form.findField("evaluationStage");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var course = form.findField("courseId");
	       					var cv = form.findField("courseVariant");
	       					var cvVal = formValues.courseVariant;
//	       					var plan = form.findField("evaluationPlanId");
//	       					var event = form.findField("eventId");
//	       					var evalPlanLevel = form.findField("evalPlanLevelId");
	       						       					
	        				var plan = formV2.down('#evaluationPlanItemId')
	        				var evalPlanLevel= formV2.down('#evalPlanLevelItemId')
	        				var event = formV2.down('#eventItemId')
	       					
	        				plan.reset()
	        				plan.clearValue();
	        				//plan.setDisabled(true);
	        				
	        				evalPlanLevel.reset()
	        				evalPlanLevel.setDisabled(true);
	        				
	        				event.reset()
	        				event.setDisabled(true);
	        				
//	        				if(isNullOrEmpty(cvVal)){
//	        					plan.reset()
//		        				plan.clearValue();
//		        				plan.setDisabled(true);
//	        				}
	        				
//	       					var cvArr = []
//	       					if(typeof cvVal == 'object'){
//	       						cvVal.forEach(function(obj){
//		                        	 cvArr.push(obj.get('id'));
//		                       });
//	       					//plan.enable();
//		       					plan.reset();
//		       					plan.setDisabled(false)
//		       					plan.allowBlank=false;
//		       					form.isValid();	       											
//		                     }
	        				
	        				if(!isNullOrEmpty(cvVal) && cvVal.length > 0){
	                            try{
	                            	cvArr = Ext.Array.pluck(Ext.Array.pluck(cvVal, 'data'), 'id').join();
	                            } catch(e) {
	                            	cvArr = cvVal.join();
	                            }
	                            plan.reset();
		       					plan.setDisabled(false)
		       					plan.allowBlank=false;
		       					form.isValid();	  
	                        //}
	        				
	        				
//	       					else{
//	       						cvArr.push(obj.get('id'));
//	       					} 
//	       					var generateReport = $this.getPlanlogisticfilter().down('#generateReport');
	       					//plan.enable();
//	       					plan.reset();
//	       					plan.setDisabled(false)
	       					var store =	plan.getStore();
	       				    var alArr = [];
		       				 if(typeof als == 'object'){
		                         als.forEach(function(obj){
		                             alArr.push(obj.get('id'));
		                       });
		                     }
		                     else{
		                         alArr.push(als)
		                     }
	 	        	    	//als.push($this.getCurrentAcademyLocation());
	       				    store.getProxy().extraParams = {
	       				    	whetherMarksheet:true,
    	        	    		//academyLocationIds:alArr.join(),
    	        	    		academicTermId:acTerm,
    	        	    		courseId:course.getValue(),
    	        	    		//courseVariantId:data,
    	        	    		courseVariantIds:cvArr,
    	        	    		evaluationType:evaluationPlanType.getValue(),
    	        	    		evaluationStage:stage.getValue(),
    	        	    		filterType: 'PLAN'
	       				    };
	       				    if(!formValues.attendanceAsHostFaculty) {
	       				    	Object.assign(store.getProxy().extraParams, {
	       				    		academyLocationIds: alArr.join()
	       				    	});
	       				    }
	       				    store.load({
	       				    	callback:function(rec) {
	       				    		if(rec.length==1) {
	       				    			plan.reset();
	       				    			plan.setDisabled(false);
	       				    			plan.setValue(rec[0].data.id);
	       				    			plan.fireEvent('select', plan, rec);
				    						var storePlanLevel = evalPlanLevel.getStore();
				    						storePlanLevel.getProxy().extraParams = {
				    							whetherMarksheet:true,
				    							academyLocationIds:alArr.join(),
				    							courseId:course.getValue(),
				    							courseVariantIds:cvArr,
				    							evaluationPlanId:rec[0].data.id,
				    							evaluationPlanType:evaluationPlanType.getValue(),
				    							evaluationStage:stage.getValue(),
				    							programId:program.getValue(),
				    							batchId:batch.getValue(),
				    							periodId:period.getValue(),
				    							sectionIds:section.getValue(),
				    							evaluationPlanId:plan.getValue()
				    						};
				    						storePlanLevel.load({
   				    							callback:function(rec){
   				    								if(plan.getValue()){
   				    									evalPlanLevel.setDisabled(false)
   				    								}
   				    								else{
   				    									evalPlanLevel.setDisabled(true)
   				    								} 
   				    								var storeEvent = event.getStore();
   				    									var storeEvent = event.getStore();
   		       				    						storeEvent.getProxy().extraParams = {
   		       				    							whetherMarksheet:true,
   		       				    							academyLocationIds:alArr.join(),
   		       				    							courseId:course.getValue(),
   		       				    							courseVariantIds:cvArr,
   		       				    							evaluationPlanId:rec[0].data.id,
   		       				    							evaluationPlanType:evaluationPlanType.getValue(),
   		       				    							evaluationStage:stage.getValue(),
   		       				    							programId:program.getValue(),
   		       				    							batchId:batch.getValue(),
   		       				    							periodId:period.getValue(),
   		       				    							sectionIds:section.getValue()
   		       				    						};
   		       				    					storeEvent.load({
		       				    							callback:function(reco){
		       				    								//event.setDisabled(false);
		       				    								if(reco.length==1) {
		       				    									event.reset();
		       				    									event.setVisible(true);
		       				    									event.setValue(reco[0].data.id);
//		       				    									generateReport.setDisabled(false);
		       				    									form.isValid();
		       				    								} else {
//		       				    									generateReport.setDisabled(true);
		       				    									event.allowBlank=false;
		       				    									form.isValid();
		       				    								}
		       				    							}
   		       				    					})
   				    							}
   				    						})
	       				    		}
	       				    		else if(record.length>0){
	       				    			plan.setDisabled(false);
	       				    			plan.allowBlank=false;
	    								form.isValid();
	       				    		}
	       				    		else{
	       				    			plan.setDisabled(true);
	       				    		}
	       				    	}
	       				    });
	        				}
	       				    //event.reset();
	       				    //event.disable();		       				
	       				    form.isValid();
	        			  }, 
	        		  },
	        		  
	        		  'planlogisticfilter button[itemId=searchBtn]':{
	        			  click:function(ob){ 
	        				  var $this=this;
	        				  var form = $this.getPlanlogisticfilter().getForm();
	        				 
	        				  var cv = form.findField('courseVariant').getValue()
	        				  
	        				  var cvArr = []
		       					if(typeof cv == 'object'){
			                         cv.forEach(function(obj){
			                        	 cvArr.push(obj.get('id'));
			                       });
			                     }
		       					else{
		       						cvArr.push(cv)
				 	               }
	        	  
	        				  /*if(form.findField('evaluationPlanType').getValue().toLowerCase() 
	        						  == getExaminationTranslation('CNTRL_ACADEMICS').toLowerCase() && isNullOrEmpty(cvArr.join())) {
	        					  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('SELECTION_ALERT_MSG'));
	        				  } else if (form.findField('evaluationPlanType').getValue().toLowerCase() 
	        						  == getExaminationTranslation('CNTRL_OTHER').toLowerCase() && isNullOrEmpty(form.findField('eventId').getValue())) {
	        					  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('SELECTION_ALERT_MSG'));
	        				  } else {*/
	        					  $this.listPlanWiseGrid();
	        				  //}
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=evaluationPlanItemId]':{
	        			  select:function(ob,record){ 
	        				var $this=this;
	        				var data=  record[0].data.id;
	        				var form = $this.getPlanlogisticfilter().getForm();
	        				var formValues= form.getValues();
	        				var al = formValues.academyLocation; 
	       				    var stage = form.findField("evaluationStage");
	       					var evaluationPlanType = form.findField("evaluationPlanType");
	       					var course = form.findField("courseId");
	       					var cv = form.findField("courseVariant");
	       					var plan = form.findField("evaluationPlanId");
	       					var event = form.findField("eventId");
	       					var program = form.findField("programId");
	       					var batch = form.findField("batchId");
	       					var period = form.findField("periodId");
	       					var section = form.findField("sectionId");
	       					var cvVal = formValues.courseVariant;
	       					var evalPlanLevel = form.findField("evalPlanLevelId");
	       					
	       					//event.enable();
	       					//event.reset();
	       					//event.allowBlank=false;
	       					evalPlanLevel.setDisabled(false);
	       					var levelStore = evalPlanLevel.getStore()
	       				    var store =	event.getStore();
		       				var als=[];
//	 	        	    	als.push($this.getCurrentAcademyLocation());		       				
	 	        	    	if(typeof al == 'object'){
	 	                       al.forEach(function(obj){
	 	                         als.push(obj.get('id'));
		 	                     });
		 	               }
		 	               else{
		 	                   als.push(al)
		 	               }
	       					var cvArr = []
	       					if(typeof cvVal == 'object'){
	       						cvVal.forEach(function(obj){
									if (obj && obj.get('id')) cvArr.push(obj.get('id'));//V2D-529843
		                       });
		                     }
	       					if(typeof cvVal == 'object'){
		                         cvVal.forEach(function(obj){
									if (obj && obj.get && obj.get('id')) {
									    cvArr.push(obj.get('id'));
									}
		                       });
		                     }
	       				 var storePlanLevel = evalPlanLevel.getStore();
    						storePlanLevel.getProxy().extraParams = {
    							whetherMarksheet:true,
    							//academyLocationIds:als.join(),
    							courseId:course.getValue(),
    							courseVariantIds:cvArr.join(),
    							evaluationPlanId:record[0].data.id,
    							evaluationPlanType:evaluationPlanType.getValue(),
    							evaluationStage:stage.getValue(),
    							programId:program.getValue(),
    							batchId:batch.getValue(),
    							periodId:period.getValue(),
    							sectionIds:section.getValue(),
    							evaluationPlanId:plan.getValue(),
    							remarkAsHostFaculty: formValues.attendanceAsHostFaculty,
    							sectionId: section.getValue()
    						};
    						if(!formValues.attendanceAsHostFaculty) {
	       				    	Object.assign(storePlanLevel.getProxy().extraParams, {
	       				    		academyLocationIds: als.join()
	       				    	});
	       				    }
    						storePlanLevel.load({
    							callback:function(rec){
    								if(evalPlanLevel.getValue()){
    									event.setDisabled(false)
    								}
    								else{
    									event.setDisabled(true)
    								}
    								//if(rec.length>0) { 
    									//evalPlanLevel.setValue(rec[0].data.id);       				    						
    									var storeEvent = event.getStore();
				    						storeEvent.getProxy().extraParams = {
				    							whetherMarksheet:true,
				    							academyLocationIds:als.join(),
				    							courseId:course.getValue(),
				    							courseVariantIds:cvArr.join(),
				    							evaluationPlanId:record[0].data.id,
				    							evaluationPlanType:evaluationPlanType.getValue(),
				    							evaluationStage:stage.getValue(),
				    							programId:program.getValue(),
				    							batchId:batch.getValue(),
				    							periodId:period.getValue(),
				    							sectionIds:section.getValue()
				    						};
				    						storeEvent.load({
				    							callback:function(reco){
				    								//event.setDisabled(false);
				    								if(reco.length==1) {
				    									event.reset();
				    									event.setVisible(true);
				    									event.setValue(record[0].data.id);
//				    									generateReport.setDisabled(false);
				    									form.isValid();
				    								} else {
//				    									generateReport.setDisabled(true);
				    									event.allowBlank=false;
				    									form.isValid();
				    								}
				    							}	       				    						
				    						});
    								//}
    							}
    						})
//	       				    var generateReport = $this.getPlanlogisticfilter().down('#generateReport');
//	       				    store.load({
//	       				    	callback:function(record) {
//	       				    		form.isValid();
//	       				    		plan.setDisabled(false);
//	       				    		if(record.length==1) {
//	       				    			event.setValue(record[0].data.id);
////	       				    			generateReport.setDisabled(false);
//	       				    		} else {
////	       				    			generateReport.setDisabled(true);
//	       				    		}
//	       				    	}
//	       				    });
	       				    form.isValid();
	        			  }
	        		  },
	        		  
	        		  'planlogisticfilter customcombobox[itemId=eventItemId]':{
	        			  select:function(ob,record){ 
	        				  var $this=this;
		       				  var form = $this.getPlanlogisticfilter().getForm(); 
//	        				  var generateReport = $this.getPlanlogisticfilter().down('#generateReport');
	        				  form.isValid();
//	        				  generateReport.setDisabled(false);
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=courseItemId]':{
	        			  select:function(ob,record){ 
	        				var data=  record[0].data.id;
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var grp = form.findField("evalGroup");
	       					var batchId = form.findField("batchId");
	       					var periodId = form.findField("periodId");
	       					var programId = form.findField("programId");
	       					var section = form.findField("section");
	       					var courseId = form.findField("courseId");
	       					var courseVariant = form.findField("courseVariant");
	       					courseVariant.enable();
	       					courseVariant.reset();
	       				    var store =	courseVariant.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	programId:programId.getValue(),
	       				    	batchId:batchId.getValue(),
	       				    	periodId:periodId.getValue(),
	       				    	sectionId:section.getValue(),
	       				    	courseId:data
	       				    };
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=centerItemId]':{
	        			  select:function(ob,record){ 
	        				var data=record[0].data.id;
	        				var $this=this; 
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var centerField = form.findField('centerName');
	       				    var grp = form.findField("evalGroup");
	       				    var roomNo = form.findField("roomNo");
	       				    roomNo.enable();
	       				    roomNo.reset();
	       				    var store =	roomNo.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	centerId:data,
	       				    	centerType:record[0].data.code
	       				    };
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=roomItemId]':{
	        			  select:function(ob,record){ 
	        				var data=record[0].data.id;  
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var centerField = form.findField('centerName');
	       				    var grp = form.findField("evalGroup");
	       				    var roomNo = form.findField("roomNo");
	       					var date = form.findField("date");
	       					date.enable();
	       					date.reset();
	       				    var store =	date.getStore();
	       				    store.getProxy().extraParams = {
	       				    	centerId:centerField.getValue(),
	       				    };
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		  'examlogisticfilter customcombobox[itemId=dateItemId]':{
	        			  select:function(ob,record){ 
	        				//var data=record[0].data.id;  
	        				var scheduleDate=record[0].data.value;  
	        				var $this=this;
	       				    var form = $this.getExamlogisticfilter().getForm(); 
	       				    var centerField = form.findField('centerName');
	       				    var grp = form.findField("evalGroup");
	       				    var roomNo = form.findField("roomNo");
	       					var date = form.findField("date");
	       					var timeSlot = form.findField("timeSlot");
	       					timeSlot.reset();
	       					timeSlot.enable();
	       				    var store =	timeSlot.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	centerId:centerField.getValue(),
	       				    	roomId:roomNo.getValue(),
	       				    	scheduleDate:scheduleDate
	       				    };
	       				    store.load();
	        			  }
	        		  },
	        		  
	        		/*  'examlogisticfilter customcombobox[itemId=dateItemId]':{
	        			  select:function(ob,record){ 
	        				var data=record[0].data.id;  
	       				    var form = this.getExamlogisticfilter().getForm(); 
	       				    var centerField = form.findField('centerName');
	       				    var grp = form.findField("evalGroup");
	       				    var roomNo = form.findField("roomNo");
	       					var date = form.findField("date");
	       					var timeSlot = form.findField("timeSlot");
	       					
	       					timeSlot.enable();
	       				    var store =	timeSlot.getStore();
	       				    store.getProxy().extraParams = {
	       				    	evaluationGroupId:grp.getValue(),
	       				    	centerId:centerField.getValue(),
	       				    	roomId:roomNo.getValue(),
	       				    	scheduleDateId:data
	       				    };
	       				    store.load();
	        			  }
	        		  },*/
	        		  
	        		  'examlogisticfilter customcombobox[itemId=detailedSequenceItemId]':{
	        			  select:function(ob,record){ 
	              				/**
	 	        		        * Load date by evaluation group id and detail sequence id
	 	        		        */
	 	        		       this.loadDateByEvalGrpAndDetailSeq();
		        			  }
	        		  },
	        	/*	  'examlogisticfilter customcombobox[itemId=courseItemId]':{
	        			  select:function(ob,record){
	        				var data=record[0].data.id;  
	       				    var form = this.getExamlogisticfilter().getForm(); 
	       				    var detailedSequenceField = form.findField('detailedSequence');
	       				    detailedSequenceField.enable();
	       				    var store =	detailedSequenceField.getStore();
		              			  store.getProxy().extraParams = {
		              				courseId:data,	   
		              				externalCourseId:0,
		              				categoryId:0
		              				};
		              				store.load();
		        			  }
	        		  },*/
	        		  'studentattendancefilter radiogroup[itemId=examstaffallocationTypeItemId]':{
	        			  change:function(obj,value){
	        				  var $this=this;
	        				  var evalGroupGrid=$this.getStudentattendanceevalgroupgrid();
	        				  var evalPlanGrid=$this.getStudentattendanceevalplangrid();
	        				  var evalGroupFilter=$this.getStudentattendanceevalgrpfilter();
	        				  var evalPlanFilter=$this.getStudentattendanceevalplanfilter();
	        				  
	        				  evalGroupGrid.setVisible(false);
	        				  evalPlanGrid.setVisible(false);
	        				  evalGroupFilter.setVisible(false);
	        				  evalPlanFilter.setVisible(false);
	        				  /**
	        				   * Change filter and grid  the bases of Assessment Scheme and evaluation group 
	        				   */
	        				  if(value.examstaffallocationType){
	        					  evalPlanGrid.setVisible(true);
	        					  evalPlanFilter.setVisible(true);
	        				  }else if(!value.examstaffallocationType){
	        					  evalGroupGrid.setVisible(true);
	        					  evalGroupFilter.setVisible(true);
	        					  var evalGroupFilterForm=evalGroupFilter.getForm();
	        					  evalGroupFilterForm.findField('evalGroupId').getStore().load();
	        				  }
	        			  }
	        		  },
	        		  'studentattendanceevalplanfilter customcombobox[itemId=evalPlanTypeItemId]':{
	        			  select:function(ob,record){ 
	        				  this.evaluationTypeChanges(ob,record,'studentattendanceevalplanfilter');
	        			  }
	        		  },
	        		  'studentattendanceevalplanfilter customcombobox[itemId=programItemId]':{
	        			  select:function(obj,rec){ 
	        				  var data=rec[0].data.id;
	        				  var form=obj.up('form').getForm();
	        				  var batchField=form.findField('batch');
	        				  batchField.enable();
	        				  batchField.reset();
	        				  batchField.getStore().getProxy().extraParams = {
		              				id:data,
		              				isActive:true 
		              				};
	        				  batchField.getStore().load();
	        				  /**
	        				   * Load Course By Program id and batch id
	        				   */
	        				  this.loadCourseByProgramAndBatch();
	        			  }
	        		  },
	        		  'studentattendanceevalplanfilter customcombobox[itemId=batchItemId]':{
	        			  select:function(ob,rec){ 
	        				  var form=ob.up('form').getForm();
	        				  
	        				  /**
	        				   * Load Course By Program id and batch id
	        				   */
	        				  this.loadCourseByProgramAndBatch();
	        				  /**
	        				   *Load period in By Batch Id 
	        				   */
	        				  var periodField=form.findField('periodId');
	        				  if(!periodField.isHidden()){
	        					  periodField.reset();
		        				  var periodStore=periodField.getStore();
									periodStore.getProxy().extraParams ={
						        		id:rec[0].data.id	
						        	};
									periodStore.load();
									periodField.enable();
	        				  }
	        				 
	        			  }
	        		  },
					  'studentattendanceevalplanfilter  customcombobox[itemId=periodIdItemId]':{
							select:function(obj,rec){
								var form=obj.up('form').getForm();
								var fieldId=rec[0].data.id;
								var sectionField=form.findField('sectionId');
								sectionField.reset();
								var sectionStore=sectionField.getStore();
								sectionStore.getProxy().extraParams ={
					        		periodId:fieldId	
					        	};
								sectionStore.load();
								sectionField.enable();
								/**
								 *Load eval plan in case other by period id and section id 
								 */
								this.loadEvalPlanInOtherBySectionPeriod();
							}
					 },
					  'studentattendanceevalplanfilter  customcombobox[itemId=sectionIdItemId]':{
							select:function(obj,rec){
								/**
								 *Load eval plan in case other by period id and section id 
								 */
								this.loadEvalPlanInOtherBySectionPeriod();
							}
						},
	        		  'studentattendanceevalplanfilter customcombobox[itemId=courseItemId]':{
	        			  select:function(ob,rec){ 
                              /**
                               * Load Assessment Scheme by Course and evaluation Stage
                               */
	        				  this.loadEvalPlanByCourseAndEvalStage();
	        			  }
	        		  },
	        		  'studentattendanceevalplanfilter customcombobox[itemId=evaluationPlanItemId]':{
	        			  select:function(ob,rec){ 
	        				var data=rec[0].data.id;  
	       				    var form = ob.up('form').getForm(); 
	       				    var detailedSequenceField = form.findField('detailedSequence');
	       				         detailedSequenceField.enable();
	       				    var store =	detailedSequenceField.getStore();
		              			  store.getProxy().extraParams = {
		              				evalPlanId:data,
		              				status:getExaminationTranslation('CNTRL_CONDUCTED')
		              				};
		              				store.load();
	        			  }
	        		  },
	        		  'studentattendanceevalplanfilter customcombobox[itemId=evaluationPlanOtherItemId]':{
	        			  select:function(ob,rec){ 
	        				var data=rec[0].data.evaluationPlanId;  
	       				    var form = ob.up('form').getForm(); 
	       				    var detailedSequenceField = form.findField('detailedSequence');
	       				        detailedSequenceField.enable();
	       				        detailedSequenceField.reset();
	       				    var store =	detailedSequenceField.getStore();
		              			store.getProxy().extraParams = {
	              				  evalPlanId:data,
		              			  status:getExaminationTranslation('CNTRL_CONDUCTED')
	              				};
	              				store.load();
	        			  }
	        		  },  
               		 'studentattendanceevalplanfilter customcombobox[itemId=evalStage_1]':{
	        			  select:function(ob,record){ 
	        				  /**
	        		           * Load  Assessment Scheme by course Id and evaluation stage
	        		           */
               		           this.loadEvalPlanByCourseAndEvalStage();
	        			  }  
	        		  },  
               		 'studentattendanceevalplanfilter customcombobox[itemId=evalStage_2]':{
	        			  select:function(ob,record){ 
	        				  /**
	        		           * Load  Assessment Scheme by course Id and evaluation stage
	        		           */
               		           this.loadEvalPlanByCourseAndEvalStage();
	        			  }  
	        		  },  
	               	 'studentattendanceevalgrpfilter customcombobox[itemId=evalGroupItemId]':{
	        			  select:function(ob,record){ 
	        				  var data=record[0].data.id;  
		       				  var form = ob.up('form').getForm(); 
		       				  var courseIdField = form.findField('courseId');
		       				  courseIdField.enable();
		       				/**
              				  * Load Course by evaluation group
              				  */
		       				  var store =courseIdField.getStore();
		              			  store.getProxy().extraParams = {
		              				evaluationGroupIds:data	  
		              				};
		              				store.load();
		              				
              			  /**
          		           * Load date by eval group ,course , center type and center Id in evaluation group case 
          		           */
          		          this.loadDateByEvalGroupCourseCenterTypeNCenterId();			
		              				
		       			 /**
          		           *Load center name by eval group course and center type in evaluation group case 
          		           */
		              		this.loadCenterNameByEvalGroupCourseNCenterType();
		              	 /**
		  		           *Load batch by eval group ,course , center type , center Id and date in evaluation group case 
		  		           */
		  		          this.loadBatchByEvalGroupCourseCenterTypeCenterIdNDate();	
	        			  }  
		        	  },  
	               	 'studentattendanceevalgrpfilter customcombobox[itemId=courseItemId]':{
	        			  select:function(obj,rec){
	        				  var data=rec[0].data.detailSequenceId;
	        				  var form=obj.up('form').getForm();
	        				  form.findField('detailSequenceId').setValue(data);
	        		     /**
          		           *Load center name by eval group course and center type in evaluation group case 
          		           */
		              		this.loadCenterNameByEvalGroupCourseNCenterType();		
		              	 /**
          		           * Load date by eval group ,course , center type and center Id in evaluation group case 
          		           */
          		          this.loadDateByEvalGroupCourseCenterTypeNCenterId(); 
          		        /**
		  		           *Load batch by eval group ,course , center type , center Id and date in evaluation group case 
		  		           */
		  		          this.loadBatchByEvalGroupCourseCenterTypeCenterIdNDate();	  
	        			  }  
		        	  },  
	               	 'studentattendanceevalgrpfilter customcombobox[itemId=centerTypeItemId]':{
	        			  select:function(ob,record){ 
              			  /**
          		           *Load center name by eval group course and center type in evaluation group case 
          		           */
		              		this.loadCenterNameByEvalGroupCourseNCenterType();
		                 /**
          		           * Load date by eval group ,course , center type and center Id in evaluation group case 
          		           */
          		            this.loadDateByEvalGroupCourseCenterTypeNCenterId();
          		          /**
  		  		           *Load batch by eval group ,course , center type , center Id and date in evaluation group case 
  		  		           */
  		  		          this.loadBatchByEvalGroupCourseCenterTypeCenterIdNDate();	 
	        			  }  
		        	  },  
	               	 'studentattendanceevalgrpfilter customcombobox[itemId=centerNameItemId]':{
	        			  select:function(ob,record){ 
		                 /**
          		           * Load date by eval group ,course , center type and center Id in evaluation group case 
          		           */
          		            this.loadDateByEvalGroupCourseCenterTypeNCenterId();
          		          /**
  		  		           *Load batch by eval group ,course , center type , center Id and date in evaluation group case 
  		  		           */
  		  		          this.loadBatchByEvalGroupCourseCenterTypeCenterIdNDate();	  
	        			  }  
		        	  },  
	               	 'studentattendanceevalgrpfilter customcombobox[itemId=dateItemId]':{
	        			  select:function(ob,record){ 
        				  /**
		  		           *Load batch by eval group ,course , center type , center Id and date in evaluation group case 
		  		           */
		  		          this.loadBatchByEvalGroupCourseCenterTypeCenterIdNDate();	
	        			  }  
		        	  },  
	               	 'studentattendanceevalgrpfilter button[itemId=resetBtn]':{
	        			  click:function(obj){ 
	       				  var filterForm=obj.up('form').getForm();
	       				      filterForm.findField('courseId').setDisabled(true);
	       				      filterForm.findField('centerName').setDisabled(true);
	       				      filterForm.findField('date').setDisabled(true);
	       				      filterForm.findField('timeSlot').setDisabled(true);
	       				      filterForm.reset(); 
	        			  }  
		        	  },  
	               	 'studentattendanceevalplanfilter button[itemId=resetBtn]':{
	               		  click:function(obj){ 
	               			var filterForm=obj.up('form').getForm();
	       				      filterForm.findField('evalStage_1').setDisabled(true);
	       				      filterForm.findField('evalStage_2').setDisabled(true);
	       				      filterForm.findField('batch').setDisabled(true);
	       				      filterForm.findField('course').setDisabled(true);
	       				      filterForm.findField('periodId').setDisabled(true);
	       				      filterForm.findField('sectionId').setDisabled(true);
	       				      filterForm.findField('evaluationPlanOther').setDisabled(true);
	       				      filterForm.findField('evaluationPlan').setDisabled(true);
	       				      filterForm.findField('detailedSequence').setDisabled(true);
	       				      filterForm.reset(); 
	        			  }  
		        	  },  
               		  'studentattendanceevalplanfilter button[itemId=searchBtn]':{
	        			  click:function(obj){ 
               		        var $this=this;  
               		        var form=obj.up('form').getForm();
               		        var formValues=form.getValues();
               		        
               		        var evalPlanId=null;
               		        
               		        if(!isNullOrEmpty(formValues.evaluationPlan)){
               		        	evalPlanId=formValues.evaluationPlan;
               		        }else if(!isNullOrEmpty(formValues.evaluationPlanOther)){
               		        	evalPlanId=formValues.evaluationPlanOther;
               		        }
               		        /**
               		         * Load grid on click of search by sending param in case of Assessment Scheme
               		         */
               		        var evalPlanGrid=$this.getStudentattendanceevalplangrid();
		               		     evalPlanGrid.getStore().getProxy().extraParams = {
				        			  programId:formValues.program,
				        			  coursesId:formValues.course,
				        			  batchId:formValues.batch,
				        			  evaluationPlanId:evalPlanId,
				        			  evaluationSequenceDetailId:formValues.detailedSequence
		            				};
				        		  evalPlanGrid.getStore().load();
	        			  }  
	        		  },  
               		  'studentattendanceevalgrpfilter button[itemId=searchBtn]':{
	        			  click:function(obj){ 
               		        var $this=this;
               		        var form=obj.up('form').getForm();
            		        var formValues=form.getValues();
            		        var dateValue=form.findField('date').getRawValue();
            		        var timeSlotValue=form.findField('timeSlot').getRawValue();
            		        /**
            		         * Load grid on click of search by sending param in case of evaluation Group
            		         */
               		        var evalGroupGrid=$this.getStudentattendanceevalgroupgrid();      
               		        evalGroupGrid.getStore().getProxy().extraParams = {
               		        	  evaluationGroupId:formValues.evalGroupId,
               		        	  courseId:formValues.courseId,
               		        	  detailSequenceId:formValues.detailSequenceId,
               		        	  examCenterType:formValues.centerType,
               		        	  examCenterId:formValues.centerName,
               		        	  scheduleDate:dateValue,
               		        	  groupScheduleBatch:timeSlotValue
	               				};
	  		        		   evalGroupGrid.getStore().load();
	        			  }  
	        		  },
	        		  'studentattendanceevalplangrid':{
	        			  render:function(grid){
		        				this.doAccessControlValidation(grid,this.getSTUDENT_ATTENDANCE_PERMISSION());
		        				this.disableMoreActionPivileges(grid,this.getSTUDENT_ATTENDANCE_PERMISSION());
	        			    /**
                              * This function is used to hide button menu while scrolling.
                              */
                             this.hideButtonMenuWhileScrolling(grid);
		        			},
	        			  cellclick:function(view, record, colIndex, rowIndex, event,target,pop){
	        				  if(pop.target.tagName=='A'){
	        					  if(colIndex==7){
	        						  this.openMalscriptWindow();
	        						  var malPracticeForm=this.getMalpracticeForm();
	        						  var getForm=malPracticeForm.getForm();
	        						  var malpracticeTypeField=getForm.findField('malpracticeType');
	        						  malpracticeTypeField.getStore().load({
	        							  callback:function(){
		        							  malpracticeTypeField.setValue(rowIndex.data.malPracticeId);  
		        						  }
	        						  });
	        						  getForm.findField('malpracticeDescription').setValue(rowIndex.data.malPracticeAction);
	        						  malPracticeForm.down('#SubmitBtn').setVisible(false);
	        						  toggleReadOnlyFormItems(getForm,true);
	        					  }
	        				  }
	        			  }
	        		  },
	        		  'studentattendanceevalplangrid button[itemId=btnSave]':{
	        			click:function(){
	        				var grid=this.getStudentattendanceevalplangrid();
		        			if(grid.getSelectionModel().getCount()>0){
		        				this.openStudentAttendaceWindow();
		        			 }else{
	                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	  }
	        			}  
	        		  },
	        		  'studentattendanceevalplangrid button[itemId=btnMalPracticeSave]':{
	        			click:function(){
	        				var grid=this.getStudentattendanceevalplangrid();
	        				if(grid.getSelectionModel().getCount()>0){
	        				  this.openMalscriptWindow();
	        				 }else{
	                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	  }
	        			}  
	        		  },
	        		  'studentattendanceevalgroupgrid':{
	        			  render:function(grid){
		        				this.doAccessControlValidation(grid,this.getSTUDENT_ATTENDANCE_EVAL_GROUP_PERMISSION());
		        				this.disableMoreActionPivileges(grid,this.getSTUDENT_ATTENDANCE_EVAL_GROUP_PERMISSION());
	        				/**
                              * This function is used to hide button menu while scrolling.
                              */
                             this.hideButtonMenuWhileScrolling(grid);
		        			},
	        			  cellclick:function(view, record, colIndex, rowIndex, event,target,pop){
	        				  if(pop.target.tagName=='A'){
	        					  if(colIndex==7){
	        						  this.openMalscriptWindow();
	        						  var malPracticeForm=this.getMalpracticeForm()
	        						  var getForm=malPracticeForm.getForm();
	        						  var malpracticeTypeField=getForm.findField('malpracticeType');
	        						  malpracticeTypeField.getStore().load({
	        							  callback:function(){
		        							  malpracticeTypeField.setValue(rowIndex.data.malPracticeId);  
		        						  }
	        						  });
	        						  getForm.findField('malpracticeDescription').setValue(rowIndex.data.malPracticeAction);
	        						  malPracticeForm.down('#SubmitBtn').setVisible(false);
	        						  toggleReadOnlyFormItems(getForm,true);
	        					  }
	        				  }
	        			  }
	        		  },
	        		  'studentattendanceevalgroupgrid button[itemId=btnSave]':{
	        			click:function(){
	        				var grid=this.getstudentattendanceevalgroupgrid();
	        				 if(grid.getSelectionModel().getCount()>0){
	        				    this.openStudentAttendaceWindow();
	        				 }else{
	                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                		 }
	        			}  
	        		  },
	        		  'studentattendanceevalgroupgrid button[itemId=btnMalPracticeSave]':{
	        			click:function(){
	        				var grid=this.getstudentattendanceevalgroupgrid();
	        				if(grid.getSelectionModel().getCount()>0){
	        				  this.openMalscriptWindow();
	        				}else{
	                			 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	  }
	        			}  
	        		  },
	        		  'malpracticeWin button[itemId=SubmitBtn]':{
	        			  click:function(){
	        				  this.saveMalPracticeWinData();
	        			  }
	        		  },
	        		  'studentattendancewin button[itemId=SubmitBtn]':{
	        			click:function(){
	        				this.saveStudentAttendanceData();
	        			}  
	        		  },
	        		  'studentattendancewin button[itemId=CancelBtn]':{
	        			click:function(){
	        				this.getStudentattendancewin().close();
	        			}  
	        		  },
	        		  'planlogisticfilter multiselectcombofield[itemId=academyLocationIdExamAttend]':{
	        			  change: function(obj){
	        				  var alArr = [];
		        				var formData = obj.up('#planlogisticfilter');
		        				formData.down('#courseItemId').reset();
		        				var variant = formData.down('#courseVariantItemId');
		        				variant.reset();
		        				variant.clearValue();
		        				variant.disable();
		        				var evalPlan = formData.down('#evaluationPlanItemId');
		        				evalPlan.reset();
		        				evalPlan.disable();
		        				formData.down('#evalPlanLevelItemId').reset();
		        				formData.down('#eventItemId').reset();
		        				var alId = formData.down('#academyLocationIdExamAttend');
		        				var formValues = formData.getValues();
		        				var als = formValues.academyLocation;
		        				var academicTerm = formData.down('#academicTermExamAttend');
		        				academicTerm.reset()	
		        			/* code commented for V2D-477029
		        			academicTerm.getStore().load({
		    	    				callback:function(record){
		    	    					for(var i in record){
		    	    						if(record[i].data.whetherCurrentAcademicTerm==true){
		    	    							academicTerm.setValue(record[i].data.id);
		    	    							academicTerm.fireEvent('select', academicTerm);
			   								   }		    	    						
		    	    					}
		    	    				}	        			
	    							    					
		    	    			});*/
		        				if(isNullOrEmpty(als)) {
		        					als = [this.getCurrentAcademyLocation()];
		        				}
		        				if(typeof als[0] == 'object'){
		        					als.forEach(function(obj){
			 	                    	  alArr.push(als.get('id'));
				 	                     });
				 	               }
				 	               else{
				 	            	  alArr.push(als)
				 	               }
		        				alId.getStore().getProxy().extraParams={
		                            whetherMarksheet:true,
		                            academyLocationIds:alArr.join(),	                            
		                        };
		        			//	alId.getStore().load()
		        				
//		        				if(!obj.getValue()){
//		        					formData.down('#courseItemId').setDisabled(true)
//		                		}
	        			  }
	        			  
	        		  },
	        		  'planlogisticfilter customcombobox[itemId=academicTermExamAttend]':{
	        			select:function(obj){
	        				var alArr = [];
	        				var formData = obj.up('#planlogisticfilter')
	        				var formValues = formData.getValues()
	        				//var alExamAttend = formData.down('#academyLocationIdExamAttend')
	        				var als = formValues.academyLocation
	        				var academicTerm = formValues.academicTerm;
	        				//var courseVariant = formValues.courseVariant
	        				var courseVariant = formData.down('#courseVariantItemId')
	        				var evaluationPlan = formData.down('#evaluationPlanItemId')
	        				var evalPlanLevel = formData.down('#evalPlanLevelItemId')
	        				var event =formData.down('#eventItemId');
		        			var sections = formData.down('#sectionIdQuickFiltr');
	        				var period = formData.down('#periodIdQuickFiltr');	
	        				var courseItemId = formData.down('#courseItemId');
	        				var batch = formData.down('#batchIdQuickFiltr');
		        			batch.setDisabled(true);
	        				batch.reset();
		        			sections.setDisabled(true);
		        			sections.reset();
		        			period.setDisabled(true);
		        			period.reset();
	        				courseItemId.reset();
	        				
	        				courseVariant.preventChange = true;
	        				courseVariant.reset();
	        				courseVariant.setDisabled(true);
	        				delete courseVariant.preventChange;
	        				
	        				evaluationPlan.reset()
	        				
	        				
	        				evalPlanLevel.reset()
	        				evalPlanLevel.setDisabled(true);
	        				
	        				event.reset()
	        				event.setDisabled(true);
	        					        				
	        				if(typeof als == 'object'){
	        	                  als.forEach(function(obj){
	        	                	  alArr.push(obj.get('id'));
	        	                });
		        	          }
		        	          else{
		        	        	  alArr.push(als)
		        	          }
	        				courseItemId.getStore().getProxy().extraParams={
	                            //whetherMarksheet:true,
	                            academicTermId: academicTerm
	                        };
	        				if(!formValues.attendanceAsHostFaculty) {
	        					Object.assign(courseItemId.getStore().getProxy().extraParams, {
	        						academyLocationIds: alArr.join()
	        					});
	        				}
	        				//courseItemId.getStore().load()
	        				if(formValues.evaluationPlanType == 'OTHER') {
	        					var program = formData.down('#programIdQuickFiltr');
	        					var progStore = program.getStore();
	        					progStore.getProxy().extraParams = {
	        						academicTermId: academicTerm
	        					};
	        					if(!formValues.attendanceAsHostFaculty) {
		        					Object.assign(progStore.getProxy().extraParams, {
		        						academyLocationIds: alArr.join()
		        					});
		        				}
	        					progStore.load({
	        						callback: function(record, operation, success) {
	        							if (success) {
	        			    				if(record && record.length && record.length == 1) {
	        			    					program.setValue(record[0].get('id'));
	        			    					program.fireEvent('select', program, record);
	        			    				}
	        			    			}
	        						}
	        					});
	        					var planStore =	evaluationPlan.getStore();
			       				var als = [];
			       				als.push(this.getCurrentAcademyLocation());
			       				planStore.getProxy().extraParams = {
			       					whetherMarksheet: true,
			       					//academyLocationIds: als,
			       					evaluationType: formValues.evaluationPlanType,
			       					evaluationStage: formValues.evaluationStage,
			       					programId: formValues.programId,
			       					batchId: formValues.batchId,
			       					periodId: formValues.periodId,
			       					sectionIds: formValues.sectionId,
			       					academicTermId: formValues.academicTerm,
			       					sectionId: formValues.sectionId,
			       					evaluationPlanType: formValues.evaluationPlanType,
			       					isHostFacultyCheck: formValues.attendanceAsHostFaculty
			       				};
			       				if(formValues.evaluationPlanType == 'OTHER') {
			       					planStore.getProxy().api.read = SERVERURL.PATH_PLANS_FOR_OTHER;
					        	}
					        	else {
					        		planStore.getProxy().api.read = SERVERURL.EXAM_REPORT_COMMON_FILTER_URL;
					        	}
			       				if(!formValues.attendanceAsHostFaculty) {
			       					Object.assign(planStore.getProxy().extraParams, {
			       						academyLocationIds: als
		        					});
			       				}
			       				planStore.load();
			       				evaluationPlan.setDisabled(false);
	        				}else{
	        					evaluationPlan.setDisabled(true);
	        				}
	        			}  
	        		  },
	        		  'planlogisticfilter groupingcombobox[itemId=evalPlanLevelItemId]':{
	        			  select:function(obj,record){ 
	        				  var formData = obj.up('#planlogisticfilter')
	        				  var formValues = formData.getValues()
	        				  var evaluationPlan = formData.down('#evaluationPlanItemId')
	        				  var evaluationPlan = evaluationPlan.getValue()
	        				  var eventItemId = formData.down('#eventItemId');

								eventItemId.reset();
								eventItemId.enable();
								
	        				  var levelOneId=null;
	  					    var levelTwoId=null;
	  					    var levelThreeId=null;
	  		        	 if(!isNullOrEmpty(record[0].data.code)){
	  						   if(record[0].data.code=="Assessment Method"){
	  							   levelThreeId=record[0].data.levelId;
	  						   }else if(record[0].data.code=="Assessment Sub Type"){
	  							   levelTwoId=record[0].data.levelId;
	  						   }else if(record[0].data.code=="Assessment Type"){
	  							   levelOneId=record[0].data.levelId;
	  						   }
	  					    }
	  		        	//eventItemId.reset();
	  		        	//eventItemId.enable();
	  						var isDynamicScheme=false;
	  								if(!isNullOrEmpty(formData.down('#evaluationPlanItemId').valueModels)){
	  									if(!isNullOrEmpty(formData.down('#evaluationPlanItemId').valueModels[0].data.sequence)){
	  										isDynamicScheme=true;
	  									}
	  								}
	  								eventItemId.getStore().getProxy().extraParams ={												
	  									evalPlanId : evaluationPlan,
	  									isDynamicScheme:isDynamicScheme,
	  									evaluationPlanLevelOneId: levelOneId,
	  									evaluationPlanLevelTwoId: levelTwoId,
	  									evaluationSequenceId: levelThreeId,
	  									//portalId:portalId!=1?null:portalId
	  								}
	  								eventItemId.getStore().load({
	  									callback : function(records){
		  										 eventItemId.allowBlank = false
                                                 formData.isValid();
	  										if(records.length == 1){
	  											eventItemId.setValue(records[0].data.id);
	  										}
	  									}
	  								});
	        			  }
	        		  },
	        	
	        		  'studentlogisticfilter multiselectcombofield[itemId=academyLocationIdExamAttend]':{ 
	        			  change: function(obj){
	        				  var alArr = [];
		        				var formData = obj.up('form');
		        				formData.down('#studentItemId').reset();
		        				formData.down('#courseVariantItemId').reset();
		        				formData.down('#evaluationPlanItemId').reset();
		        				formData.down('#evalPlanLevelItemId').reset();
		        				formData.down('#eventItemId').reset();
		        				formData.down('#courseVariantItemId').setDisabled(true);
		        				formData.down('#evaluationPlanItemId').setDisabled(true);
		        				formData.down('#evalPlanLevelItemId').setDisabled(true);
		        				formData.down('#eventItemId').setDisabled(true);
		        				var alId = formData.down('#academyLocationIdExamAttend');
		        				var studentId = formData.down('#studentItemId');
		        				var formValues = formData.getValues();
		        				var als = formValues.academyLocation;
		        				if(typeof als[0] == 'object'){
		        					als.forEach(function(obj){
			 	                    	  alArr.push(als.get('id'));
				 	                     });
				 	               }
				 	               else{
				 	            	  alArr.push(als)
				 	               }
		        				alId.getStore().getProxy().extraParams={
		                            whetherMarksheet:true,
		                            academyLocationIds:alArr.join(),	                            
		                        };
		        			//	alId.getStore().load()
		        				
		        				studentId.getStore().getProxy().extraParams={
		                            whetherMarksheet:true,
		                            academyLocationIds:alArr.join(),	                            
		                        };
		        			//	studentId.getStore().load()
		        				
//		        				if(!obj.getValue()){
//		        					formData.down('#courseItemId').setDisabled(true)
//		                		}
	        			  }
	        		  },
	        		  'planlogisticfilter checkboxfield[itemId=attendanceAsHostFaculty]': {
	        			  change: this.onAttendanceHostFacultyChange
	        		  },
	        		  'planlogisticfilter': {
	        			  render: this.onPlanLogisticFilterRender
	        		  }
	        	  });
	        	  },
	        	  /** 	
					* this function is used to hide button menu while scrolling
					*/
		            hideButtonMenuWhileScrolling:function(grid){
		        	    var studentattendancestructure=this.getStudentattendancestructure();
		        	    studentattendancestructure.body.on('scroll', function(e){
						var moreactionButton=grid.down('#spBtnMoreActions');
						    moreactionButton.hideMenu();
					    }, studentattendancestructure);
		            },
	        	  /**
	        	   * Hide and show fields on the bases of evaluation type in 
	        	   * "EXAMLOGISTICS FILTER" form and "STUDENT ATTENDANCE EVAL PLAN FILTER" form.
	        	   */
	        	  evaluationTypeChanges:function(obj,record,formName){
	        		  var form=obj.up('form').getForm();
	        		  var evalType=record[0].data.id;
		        	  var evalStageField_1=form.findField('evalStage_1');
		        	  var evalStageField_2=form.findField('evalStage_2');	
		        	  
		        	  /**
		        	   * This case for STUDENT ATTENDANCE EVAL PLAN FILTER form
		        	   */
		        	  if(formName=="studentattendanceevalplanfilter"){
		        		  var programField=form.findField('program');
			        	  var batchField=form.findField('batch');
			        	  var detailedSequenceField=form.findField('detailedSequence');
			        	  
			        	  programField.reset();
			        	  
			        	  batchField.reset();
			        	  batchField.setDisabled(true);
			        	  
			        	  detailedSequenceField.reset();
			        	  detailedSequenceField.setDisabled(true);
			        	  
			        	  var evaluationPlanOtherField=form.findField('evaluationPlanOther');
			        	  var evaluationPlanField=form.findField('evaluationPlan');
			        	  var periodIdField=form.findField('periodId');	
			        	  var sectionIdField=form.findField('sectionId');
			        	  
			        	  evaluationPlanOtherField.reset();
			        	  evaluationPlanOtherField.setVisible(false);
			        	  evaluationPlanOtherField.setDisabled(true);
			        	  evaluationPlanOtherField.allowBlank=true;
			        	  
			        	  evaluationPlanField.reset();
			        	  evaluationPlanField.setVisible(false);
			        	  evaluationPlanField.setDisabled(true);
			        	  evaluationPlanField.allowBlank=true;
			        	  
			        	  periodIdField.reset();
			        	  periodIdField.setVisible(false);
			        	  periodIdField.setDisabled(true);
			        	  periodIdField.allowBlank=true;
			        	  
			        	  sectionIdField.reset();
			        	  sectionIdField.setVisible(false);
			        	  sectionIdField.setDisabled(true);
			        	  sectionIdField.allowBlank=true;
			        	  
		        	  }
		        	  
		        	  var courseField=form.findField('course');
		        	  
		        	  
		        	  courseField.reset();
		        	  courseField.setVisible(false);
		        	  courseField.setDisabled(true);
		        	  courseField.allowBlank=true;
		        	  
		        	  evalStageField_1.reset();
		        	  evalStageField_1.hide();
		        	  evalStageField_1.setDisabled(true);
		        	  evalStageField_1.allowBlank=true;
		        	  
		        	  evalStageField_2.reset();
		        	  evalStageField_2.hide();
		        	  evalStageField_2.setDisabled(true);
		        	  evalStageField_2.allowBlank=true;
		        	  
	        		  if( evalType== getExaminationTranslation('CNTRL_ACADEMICS')){
	        			
	        			  courseField.setVisible(true);
	        			  courseField.allowBlank=false;
	        		  if(formName=="studentattendanceevalplanfilter"){  
	        			  evaluationPlanField.setVisible(true);
	        			  evaluationPlanField.allowBlank=false;
	        		    } 
	        			  
	        			  evalStageField_1.setVisible(true);
	        			  evalStageField_1.enable();
	        			  evalStageField_1.allowBlank=false;
	        			  evalStageField_1.setFieldLabel(getExaminationTranslation('EVALUATION_STAGE')+'<span class="required" style="color:red"> *</span>');
		        	  
	        		  }else if(evalType == getExaminationTranslation('CNTRL_EXTERNAL_ORGANISATION')){
		        		  
	        			  courseField.setVisible(true);
	        			  courseField.allowBlank=false;
	        			  
	        			if(formName=="studentattendanceevalplanfilter"){  
	        			  evaluationPlanField.setVisible(true);
	        			  evaluationPlanField.allowBlank=false;
	        			}
	        			  
		        		  evalStageField_2.setVisible(true);
		        		  evalStageField_2.enable();		
		        		  evalStageField_2.allowBlank=false;
		        		  evalStageField_2.setFieldLabel(getExaminationTranslation('EVALUATION_STAGE')+'<span class="required" style="color:red"> *</span>');
		        		  
		        	  }else if(evalType == getExaminationTranslation('CNTRL_OTHER')){
		        		  
		        		if(formName=="studentattendanceevalplanfilter"){
		        		  evaluationPlanOtherField.setVisible(true);
		        		  evaluationPlanOtherField.allowBlank=false;
		        		  evaluationPlanOtherField.setFieldLabel(getExaminationTranslation('EVALUATION_PLAN')+'<span class="required" style="color:red"> *</span>');
		        		
		        		  periodIdField.setVisible(true);
		        		  periodIdField.allowBlank=false;
		        		  periodIdField.setFieldLabel(getExaminationTranslation('PERIOD')+'<span class="required" style="color:red"> *</span>');
		        		  
		        		  sectionIdField.setVisible(true);
		        		  sectionIdField.allowBlank=false;
		        		  sectionIdField.setFieldLabel(getExaminationTranslation('SECTION')+'<span class="required" style="color:red"> *</span>');
		        		}  
		        		  evalStageField_1.setVisible(true);
	        			  evalStageField_1.enable();
	        			  evalStageField_1.allowBlank=false;
	        			  evalStageField_1.setFieldLabel(getExaminationTranslation('EVALUATION_STAGE')+'<span class="required" style="color:red"> *</span>');
	        			  
		        	  }
	        		 // form.isValid();
		          },
		          /**
		           *Load center name by eval group, course and center type in evaluation group case 
		           */
		          loadCenterNameByEvalGroupCourseNCenterType:function(){
		        	var $this=this;
		        	var stdEvalGroupFilterForm=$this.getStudentattendanceevalgrpfilter();
		        	var getForm=  stdEvalGroupFilterForm.getForm();
		        	var evalGroupField=getForm.findField('evalGroupId');
		        	var courseIdField=getForm.findField('courseId');
		        	var centerTypeField=getForm.findField('centerType');
		        	var centerNameField=getForm.findField('centerName');
		        	if(evalGroupField.getValue()!=null&&courseIdField.getValue()!=null&&centerTypeField.getValue()!=null){
		        		centerNameField.reset();
		        		centerNameField.enable();
		        		centerNameField.getStore().getProxy().extraParams={
		        			evaluationGroupIds:evalGroupField.getValue(),
		        			courseIds:courseIdField.getValue(),
		        			centerType:centerTypeField.getValue()
		        		};
		        		centerNameField.getStore().load();
		        	}
		          },
		          /**
		           *Load date by eval group ,course , center type and center Id in evaluation group case 
		           */
		          loadDateByEvalGroupCourseCenterTypeNCenterId:function(){
		        	var $this=this;
		        	var stdEvalGroupFilterForm=$this.getStudentattendanceevalgrpfilter();
		        	var getForm=  stdEvalGroupFilterForm.getForm();
		        	var evalGroupField=getForm.findField('evalGroupId');
		        	var courseIdField=getForm.findField('courseId');
		        	var centerTypeField=getForm.findField('centerType');
		        	var centerNameField=getForm.findField('centerName');
		        	var dateField=getForm.findField('date');
		        	if(evalGroupField.getValue()!=null&&courseIdField.getValue()!=null&&centerTypeField.getValue()!=null&&centerNameField.getValue()!=null){
		        		dateField.reset();
		        		dateField.enable();
		        		dateField.getStore().getProxy().extraParams={
		        			evaluationGroupIds:evalGroupField.getValue(),
		        			courseIds:courseIdField.getValue(),
		        			centerType:centerTypeField.getValue(),
		        			examCenterIds:centerNameField.getValue()
		        		};
		        		dateField.getStore().load();
		        	}
		          },
		          /**
		           *Load batch by eval group ,course , center type , center Id and date in evaluation group case 
		           */
		          loadBatchByEvalGroupCourseCenterTypeCenterIdNDate:function(){
		        	var $this=this;
		        	var stdEvalGroupFilterForm=$this.getStudentattendanceevalgrpfilter();
		        	var getForm=  stdEvalGroupFilterForm.getForm();
		        	var evalGroupField=getForm.findField('evalGroupId');
		        	var courseIdField=getForm.findField('courseId');
		        	var centerTypeField=getForm.findField('centerType');
		        	var centerNameField=getForm.findField('centerName');
		        	var dateField=getForm.findField('date');
		        	var timeSlotField=getForm.findField('timeSlot');
		        	if(evalGroupField.getValue()!=null&&courseIdField.getValue()!=null&&centerTypeField.getValue()!=null&&centerNameField.getValue()!=null&&dateField.getValue()!=null){
		        		timeSlotField.reset();
		        		timeSlotField.enable();
		        		timeSlotField.getStore().getProxy().extraParams={
		        			evaluationGroupIds:evalGroupField.getValue(),
		        			courseIds:courseIdField.getValue(),
		        			centerType:centerTypeField.getValue(),
		        			examCenterIds:centerNameField.getValue(),
		        			scheduleDateIds:dateField.getValue()
		        		};
		        		timeSlotField.getStore().load();
		        	}
		          },
		          /**
		           * Load Assessment group on the bases of evaluation stage
		           */
		          loadEvaluationGroupByEvalStage:function(data){
     				    var form = this.getExamlogisticfilter().getForm(); 
     				    var evalGroupField = form.findField('evalGroup');
     				    var store =	evalGroupField.getStore();
 				          evalGroupField.enable();
              			  store.getProxy().extraParams = {
              				evaluationStage:data	              				 
              				};
              				store.load();
		          },
		          /**
		           * Load Date on the bases of evaluation group Id and detail sequence Id
		           */
		          loadDateByEvalGrpAndDetailSeq:function(){
     				    var form = this.getExamlogisticfilter().getForm(); 
     				    var dateField = form.findField('date');
     				    var evalGroupField = form.findField('evalGroup');
     				    var detailedSequenceField = form.findField('detailedSequence');
     				    if(evalGroupField.getValue()!=null&&detailedSequenceField.getValue()!=null){
     				    	dateField.enable();
     				    var store =	dateField.getStore();
              			    store.getProxy().extraParams = {
	              				evaluationGroupIds:evalGroupField.getValue(),	     
	              				detailSequenceIds:detailedSequenceField.getValue()
	              				};
              				store.load();
     				    }		
		          },
		          /**
		           * Load  course by program Id and batch Id
		           */
		          loadCourseByProgramAndBatch:function(){
     				    var form = this.getStudentattendancefilter().getForm(); 
     				    var courseField = form.findField('course');
     				    var programField = form.findField('program');
     				    var batchField = form.findField('batch');
     				    if(programField.getValue()!=null&&batchField.getValue()!=null){
     				    	courseField.enable();
     				    var store =	courseField.getStore();
              			    store.getProxy().extraParams = {
              			    	programId:programField.getValue(),	     
              			    	batchId:batchField.getValue()
	              				};
              				store.load();
     				    }		
		          },
		          /**
		           * Load  Assessment Scheme by course Id and evaluation stage
		           */
		          loadEvalPlanByCourseAndEvalStage:function(){
     				    var form = this.getStudentattendancefilter().getForm(); 
     				    var evaluationPlanField = form.findField('evaluationPlan');
     				    var courseField = form.findField('course');
     				    var evalStage_1Field = form.findField('evalStage_1');
    				    var evalStage_2Field = form.findField('evalStage_2');
     				    var evalStageField=null;
     				    
     				    if(!evalStage_1Field.isHidden()){
     				    	evalStageField=evalStage_1Field;
     				    }else if(!evalStage_2Field.isHidden()){
     				    	evalStageField=evalStage_2Field;
     				    }
     				    
     				    if(courseField.getValue()!=null&&evalStageField.getValue()!=null){
     				    	evaluationPlanField.enable();
     				    var store =	evaluationPlanField.getStore();
              			    store.getProxy().extraParams = {
              			    	   courseId:courseField.getValue(),
	        					   //externalCourseId:0,
	        					   //otherCategoryId:0,
	        					   //evaluationStage:evalStageField.getValue(),
	        					   status:getExaminationTranslation('CNTRL_MARK_ENTRY_PENDING')
	              				};
              				store.load();
     				    }		
		          },
		          /**
				    *Load eval plan in case other by period id and section id 
				    */
				   loadEvalPlanInOtherBySectionPeriod:function(){
					   var form=this.getStudentattendanceevalplanfilter().getForm();
					   var periodIdField = form.findField('periodId');
    				   var sectionIdField = form.findField('sectionId');
    				   var evaluationPlanOtherField = form.findField('evaluationPlanOther');
    				    
    				    if(periodIdField.getValue()!=null&&sectionIdField.getValue()!=null){
    				    	evaluationPlanOtherField.enable();
    				    	evaluationPlanOtherField.reset();
    				    var store =	evaluationPlanOtherField.getStore();
             			    store.getProxy().extraParams = {
             			    	periodId:periodIdField.getValue(),
             			    	sectionId:sectionIdField.getValue()
	              				};
             				store.load();
    				    }		
					   
				   },
		          /**
		           * Open Studetn Attendance Tab
		           */
	        	  openStudentAttendanceTab:function(){
	        	    	 var $this = this;
	        	    	 var contentpanel = $this.getContentPanel();
	        	    	 var stdAttendanceTab = Ext.widget('studentattendancestructure');
	        	    	 var tabName = getExaminationTranslation('STUDENT_ATTENDANCE');
	        	    	 /**
		              	   * This is to remove tab from content panel and open same tab again 
		              	   */
		              	  var getcontroller=this.getController('menu.CoreERPNavigationController');
		              	  var getTab=getcontroller.getTab(tabName);
		              	   if(getTab!=null){
		              		 contentpanel.remove(getTab, true);
		              	   }
	        	    	 openTab(contentpanel, tabName, stdAttendanceTab,CONSTANTS.MENU_COLOR_FOUR);
	        	    },
	        	  /**
		           * Open Mal Practice  window
		           */
	        	    openMalscriptWindow:function(){
	        	    	 var formWindow = this.getMalpracticeWin();
	        	         if (!formWindow) {
	        	             Ext.widget('malpracticeWin');
	        	             formWindow = this.getMalpracticeWin();
	        	         }
	        	         formWindow.show();
	        	    },
	        	  /**
		           * Open student attendace  window
		           */
	        	    openStudentAttendaceWindow:function(){
	        	    	 var formWindow = this.getStudentattendancewin();
	        	         if (!formWindow) {
	        	             Ext.widget('studentattendancewin');
	        	             formWindow = this.getStudentattendancewin();
	        	         }
	        	         formWindow.show();
	        	    },
	        	    /**
	        	     * Save student Attendance Data
	        	     */
	        	    saveStudentAttendanceData:function(){
	        	    	 var $this=this;
	        	    	 var grid=null;
	        	    	 var evalPlanGrid=$this.getStudentattendanceevalplangrid();
	        	    	 var evalGroupGrid=$this.getStudentattendanceevalgroupgrid();
	        	    	 var stdAttendanceForm=$this.getStudentAttendanceWinForm();
	        	    	 var stdAttendanceFormValues=stdAttendanceForm.getValues();
	        	    	 
		        	     if(!evalPlanGrid.isHidden()){
	                       	 grid=evalPlanGrid;
	                     }else if(!evalGroupGrid.isHidden()){
	                       	 grid=evalGroupGrid;
	                     }
		        	     /**
		        	      *It is used to close editing cell in grid.
		        	      *//*
		        	     editor = grid.findPlugin('cellediting');
                         editor.completeEdit();*/
		        	     
		        	     var whetherExamAttended=null;
		        	     if(stdAttendanceFormValues.whetherExamAttended=="PRESENT"){
                    		 whetherExamAttended= true;
                    	 }else{
                    		 whetherExamAttended= false;
                    	 }
		        	     
		        	     if(grid.getSelectionModel().getCount()>0){
		                     var records=grid.getSelectionModel().getSelection();
		                     var submitData=[];
		                     Ext.Array.each(records,function(value){
		                    	
		                    	 var whethermMalPractice=null;
		                    	 
		                    	 if(value.data.whetherMalpracticeReported==null){
		                    		 whethermMalPractice= false;
		                    	 }else{
		                    		 whethermMalPractice= value.data.whetherMalpracticeReported;
		                    	 }
		                    	 
		                    	 var data={
		                        	       "id": value.data.id,
		                        	       "malPracticeId":value.data.malPracticeId,
		                        	       "whetherExamAttended":whetherExamAttended,
		                        	       "whetherMalpracticeReported": whethermMalPractice,
		                        	       "malPracticeAction":value.data.malPracticeAction
		                        	   };
		                    	 submitData.push(data);
		                     });
	                         
		        	    	submitUrl = SERVERURL.STUDENT_ATTENDANCE_SAVE_URL;
		             	    Ext.Ajax.request({
			             		   type : 'rest',
			             		   url : submitUrl,
			             		   jsonData : submitData,
			             		   method : 'POST',
			             		   success : function(response, action) {
			             			   showSuccessMessage(getExaminationTranslation('STUDENT_ATTENDANCE'),getExaminationTranslation('STUDENT_ATTENDANCE_DONE_SUCCESSFULLY'));
			             			   grid.getStore().reload();
			             			   $this.getStudentattendancewin().close();
			             		   }
			             	   });
		        	     }    
	        	    },
	        	    /**
	        	     * Save mal pratice student Data
	        	     */
	        	    saveMalPracticeWinData:function(){
	        	    	 var $this=this;
	        	    	 var grid=null;
	        	    	 var evalPlanGrid=$this.getStudentattendanceevalplangrid();
	        	    	 var evalGroupGrid=$this.getStudentattendanceevalgroupgrid();
	        	    	 var malPracticeForm=$this.getMalpracticeForm();
	        	    	 var malPracticeFormValues=malPracticeForm.getValues();
	        	    	 
                         if(!evalPlanGrid.isHidden()){
                        	 grid=evalPlanGrid;
                         }else if(!evalGroupGrid.isHidden()){
                        	 grid=evalGroupGrid;
                         }
	        	    	if(grid.getSelectionModel().getCount()>0){
	                     var records=grid.getSelectionModel().getSelection();
	                     
	                     //var whetherExamAttended=null;
	                     var arrayData=[];
	                   Ext.Array.each(records,function(value){
	                	   
                    	 var whethermMalPractice=null;
                    	 
                    	/* if(Ext.isObject(records.data.whetherExamAttended)){
                    		 whetherExamAttended= records.data.whetherExamAttended.examAttended;
                    	 }else{
                    		 whetherExamAttended= records.data.whetherExamAttended;
                    	 }*/
                    	 
                    	 if(!value.data.whetherExamAttended){
                    		 showWarningMessage(getExaminationTranslation("STUDENT_ATTENDANCE"),getExaminationTranslation("MALPRACTICE_CANT_DONE_FOR_ABSENT_STUDENTS"));
                    		 return;
                    	 }
                    	 
                    	 if(value.data.whetherMalpracticeReported==null){
                    		 whethermMalPractice= false;
                    	 }else{
                    		 whethermMalPractice= value.data.whetherMalpracticeReported;
                    	 }
                    	 
                          data={
                        	       "id": value.data.id,
                        	       "malPracticeId":malPracticeFormValues.malpracticeType,
                        	       "whetherExamAttended": true,
                        	       "whetherMalpracticeReported": whethermMalPractice,
                        	       "malPracticeAction": malPracticeFormValues.malpracticeDescription
                        	   };
                          arrayData.push(data);
                         
	                   }); 
	                   
		        	    	submitUrl = SERVERURL.MAL_PRATICE_SAVE_URL;
		        	    	 $this.applyWindowMask(); 
		        	    	 
		             	    Ext.Ajax.request({
			             		   type : 'rest',
			             		   url : submitUrl,
			             		   jsonData : arrayData,
			             		   method : 'POST',
			             		   success : function(response, action) {
			             			    $this.hideWindowMask();
			             			   showSuccessMessage(getExaminationTranslation('MALPRACTICE_REPORT'),getExaminationTranslation('MALPRACTICE_CREATED_SUCCESSFULLY'));
			             			   $this.getMalpracticeWin().close();
			             			   grid.getStore().reload();
			             		   }
			             	   });
	        	        }
	        	    },
	        	    
	        	    saveAttendanceAndMalPractice: function(view) {
	        	    	var $this = this;
	        	    	var grid;
	        	    	
	        	    	if(view==getExaminationTranslation('ROOM_WISE')){
	        	    		grid = $this.getRoomwisegrid();
	        	    		var gridCount = this.getRoomwiseattendancesummary();
	        	    	}
	        	    	if(view==getExaminationTranslation('PLAN_WISE')){
	        	    		grid = $this.getPlanwisegrid();
	        	    		var gridCount = this.getSchemewiseattendancesummary();
	        	    	}
	        	    	if(view==getExaminationTranslation('STUDENT_WISE')){
	        	    		grid = $this.getStudentwisegrid();
	        	    		var gridCount = this.getStudentwiseattendancesummary();
	        	    	}
	        	    	
	        	   	 	if (grid.getSelectionModel().getCount() > 0) {
	        	   	 		var jSon=[]
	        	   	 		var records = grid.getSelectionModel().getSelection();
	        	   	 		for(var i in records){
	        	   	 			var isExamAttended=true, malPracticeId;
	        	   	 			if(records[i].data.presentAbsId=="Absent"){
	        	   	 				isExamAttended=false;
	        	   	 			}
	        	   	 			if(records[i].data.malPracticeId != null || records[i].data.malPracticeId!=""){
	        	   	 				malPracticeId=records[i].data.malPracticeId;
	        	   	 			}
	        	   	 			var data = {
	        	   	 				examinationResultId:records[i].data.examinationResultId,
	        	   	 				admissionId:records[i].data.admissionId,
	        	   	 				examMalPracticTypeId:malPracticeId,
	        	   	 				whetherExamAttended:isExamAttended
	        	   	 			};
	        	   	 			jSon.push(data);
	        	   	 		}
	        	   	 		
	        	   	 		for(var j in records){
	        	   	 		var prePercent='0%', absPercent='0%';
		  	        	   	var abs=0,pre=0,oth=0;
		  	        		var  presentSummaryCount = 0, absentSummaryCount= 0;
	        	   	 		  if(records[j].data.presentAbsId=="Absent"){
								   abs++;
								   absentSummaryCount++;
							   }else{
								   pre++;
								   presentSummaryCount++
							   }
	        	   	 		}
	        	   	 		
	        	   	 		var storeData = {
	        	   	 				totalStudent:records.length,
	        	   	 				totalPresent:pre,
	        	   	 				totalAbsent:abs,
	        	   	 				otherCount:oth,
	        	   	 				presentPercent:parseFloat((presentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	   	 				absentPercent:parseFloat((absentSummaryCount/records.length)*100).toFixed(2)+"%",

	        	   	 		};
	        	   	 		var summaryGridStore =  gridCount.getStore();
	        	   	 		summaryGridStore.removeAll();
	        	   	 		if(!isNullOrEmpty(jSon)){
	        	   	 			var submitUrl = SERVERURL.PATH_SAVE_ATTENDANCE_MALPRACTICE_URL;
	        	   	 			showConfirmMessage(getExaminationTranslation('MARK_ATTENDANCE'),
	        	   	 					getExaminationTranslation('MANAGE_ATTENDANCE_MSG'),
	        	   	 					function(btn, text) {
	        	   	 				if (btn == 'yes') {
	        	   	 				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        			  			Ext.Ajax.request({
	        			  						type : 'rest',
	        			  						url : submitUrl,
	        			  						jsonData : jSon,
	        			  						method : 'POST',
	        			  						success : function(resp, action) {
	        			  							Ext.getBody().unmask();
	        			  							if(resp.responseText=="SUCCESS"){
	        			  								showSuccessMessage(getExaminationTranslation('MARK_ATTENDANCE'),getCommonTranslation('SUCCESS'));
	        			  								grid.getStore().reload();
	        			  								grid.getSelectionModel().deselectAll();
	        			  		        	   	 		summaryGridStore.loadRawData(storeData, true);
	        			  							}
	        			  						}
	        			  				});
	        	   	 				}
	        	   	 			});
	        	   	 		} 
	        	   	 	}else {
	        	   	 		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	   	 	}
	        	    	//PATH_SAVE_ATTENDANCE_MALPRACTICE_URL
	        	    },
	        	    
	        	    roomWiseViewResetFunctionality:function(){
	        	    	var $this=this;
	        	    	var form = $this.getExamlogisticfilter().getForm();
	        	    	var evalGroup = form.findField("evalGroup");
	        	    	var centerName = form.findField("centerName");
	        	    	var roomNo = form.findField("roomNo");
	        	    	var date = form.findField("date");
	        	    	var timeSlot = form.findField("timeSlot");
	        	    	var programId = form.findField("programId");
	        	    	var batchId = form.findField("batchId");
	        	    	var periodId = form.findField("periodId");
	        	    	var section = form.findField("section");
	        	    	var courseId = form.findField("courseId");
	        	    	var courseVariant = form.findField("courseVariant");
	        	    	
	        	    	 var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	 var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	 if(wheatherSchool) {
	                		 periodId.hide();
	                	 }else{
	                		 periodId.show();
	                	 }
	        	    	
	        	    	form.reset();
	        	    	centerName.disable();
	        	    	roomNo.disable();
	        	    	date.disable();
	        	    	timeSlot.disable();
	        	    	programId.disable();
	        	    	batchId.disable();
	        	    	periodId.disable();
	        	    	section.disable();
	        	    	courseId.disable();
	        	    	courseVariant.disable();
	        	    },
	        	    
	        	    studentWiseViewResetFunctionality:function(){
	        	    	var $this=this;
	        	    	var academyLocationId = this.getCurrentAcademyLocation();
	        	    	var studentForm = $this.getStudentlogisticfilter().getForm(); 
	        	    	studentForm.reset();
	        	    	var studentId = studentForm.findField("studentId");
	        	    	var loggedAL = studentForm.findField('academyLocation');
	        	    	loggedAL.getStore().load({
		    	    		callback: function(){
			    				loggedAL.setValue(academyLocationId);
			        	    	studentId.getStore().getProxy().extraParams={
			        	    		whetherMarksheet:true,
			        	    		academyLocationIds:academyLocationId
			        	    	}
			        	    	studentId.getStore().load();
			    			}
        	    		})
	        	    	var courseVariant = studentForm.findField("courseVariant");
	        	    	var evalPlan = studentForm.findField("evaluationPlanId");
	        	    	var evalPlanLevel = studentForm.findField("evalPlanLevelId");
	        	    	var event = studentForm.findField("eventId");
	        	    	var als=[];
	        	    	als.push($this.getCurrentAcademyLocation());
	        	    	courseVariant.disable();
	        	    	evalPlan.disable();
	        	    	evalPlanLevel.disable();
	        	    	event.disable();
	        	    },
	        	    planWiseViewResetFunctionality:function(){
	        	    	var $this=this;
              			var academyLocationId = this.getCurrentAcademyLocation();
	        	    	var planForm = $this.getPlanlogisticfilter().getForm();
	        	    	var formValues = planForm.getValues();
	        	    	planForm.reset();	        	    	
	        	    	var loggedAL = planForm.findField("academyLocation");
	        	    		loggedAL.setValue(academyLocationId);
	        	    	var type = planForm.findField("evaluationPlanType");
	        	    	var stage = planForm.findField("evaluationStage");
	        	    	var course = planForm.findField("courseId");
//	        	    	var generateReport = $this.getPlanlogisticfilter().down('#generateReport');
//       					generateReport.setDisabled(true);
	        	    	var program = planForm.findField("programId");
       					var batch = planForm.findField("batchId");
       					var period = planForm.findField("periodId");
       					var section = planForm.findField("sectionId");
       					var als=[];
	        	    	
       					var academicTerm = planForm.findField("academicTerm");
       					var evalPlanLevelId = planForm.findField("evalPlanLevelId");
       					
       					if(portalId==2) {
       						var facultyId=$this.getCurrentlyLoggedInUser().id;
       						als.push($this.getCurrentAcademyLocation());
       					} 
       					program.reset();
       					program.setVisible(false);
       					batch.reset();
       					batch.setVisible(false);
       					period.reset();
       					period.setVisible(false);
       					section.reset();
       					section.setVisible(false);
       					course.setVisible(true);
       					course.reset();
       					//evalPlanLevelId.setVisible(false);
       					//evalPlanLevelId.reset();
	        	    	var courseVariant = planForm.findField("courseVariant");
	        	    	courseVariant.setVisible(true);
       					courseVariant.reset();
       					courseVariant.setDisabled(true);
       					evalPlanLevelId.setDisabled(true);
       					courseVariant.allowBlank=false;
	        	    	var evalPlan = planForm.findField("evaluationPlanId");
	        	    	var event = planForm.findField("eventId");
	        	    	
	        	    	var loggedAL = planForm.findField("academyLocation");	        	    	
	        	    
	        	    	loggedAL.getStore().load({
		    	    		callback: function(){
			    				loggedAL.setValue(academyLocationId)
			    			}
        	    		})
	        	    	
	        	    	type.getStore().load({
    	    				callback:function(record){
    	    					type.setValue(record[0].data.id);
    	    				}
    	    			});
	        	    	stage.getStore().load({
							callback:function(record){
								stage.setValue(record[1].data.id);      	    					
							}
	        	    	});
	        	    	academicTerm.getStore().load({
    	    				callback:function(record){
    	    					for(var i in record){
    	    						if(record[i].data.whetherCurrentAcademicTerm==true){
    	    							academicTerm.setValue(record[i].data.id);
    	    							academicTerm.fireEvent('select', academicTerm);
	   								   }
    	    					}
    	    				}
    	    			});
    	    			/* commented for V2D-477029 due to multiple api call
	        	    	academicTerm.getStore().load({
    	    				callback:function(record){
    	    					for(var i in record){
    	    						if(record[i].data.whetherCurrentAcademicTerm==true){
    	    							academicTerm.setValue(record[i].data.id);
	   								   }
    	    					}
    	    				}
    	    			});
	        	    	*/
	        	    	course.enable();
	        	    	course.getStore().getProxy().extraParams={
//	        	    		whetherMarksheet:true,
	        	    		//academyLocationIds:als,
       						facultyId:facultyId
	        	    	};
	        	    	if(!formValues.attendanceAsHostFaculty) {
        					Object.assign(course.getStore().getProxy().extraParams, {
        						academyLocationIds: als
        					});
        				}
	        	    	//course.getStore().load();
	        	    	courseVariant.disable();
	        	    	evalPlan.disable();
	        	    	event.disable();
//	        	    	var generateReport = $this.getPlanlogisticfilter().down('#generateReport');
//       					generateReport.setDisabled(true);
       					course.allowBlank=false;
       					//planForm.isValid();
       					//event.allowBlank=false;*/
       					try {
       						var courseStore = course.getStore();
       						if (courseStore.loading && courseStore.lastOperation) {
       							var requests = Ext.Ajax.requests;
       							for (id in requests) {
       								if (requests.hasOwnProperty(id) && requests[id].options == courseStore.lastOperation.request) {
       									Ext.Ajax.abort(requests[id]);
       									courseStore.lastOperation = null;
       									course.reset();
       								}
       							}
       						}
       					}
       					catch(e) {
       						course.reset();
       					}
	        	    },
	        	    
	        	    tabChangeFunctionality: function(cb, nv, ov){
	        	    	var $this = this;
	        	    	var room = $this.getRoomwiseattendanceview();
	        	    	var plan = $this.getPlanwiseattendanceview();
	        	    	var student = $this.getStudentwiseattendanceview();
	        	    	if(nv.downloadUploadTemplate == 'forRoomWise'){ 
	        	    		room.show();
	        	    		plan.hide();
	        	    		student.hide();
	        	    		$this.roomWiseViewResetFunctionality();
	        	    	} 
	        	    	if(nv.downloadUploadTemplate == "forPlanWise"){
	        	    		room.hide();
	        	    		student.hide();
	        	    		plan.show();
	        	    		$this.planWiseViewResetFunctionality();
	        	    	}
	        	    	if(nv.downloadUploadTemplate == "forStudentWise"){
	        	    		room.hide();
	        	    		plan.hide();
	        	    		student.show();
	        	    		$this.studentWiseViewResetFunctionality();
	        	    	}
	        	    },
	        	    
	        	    setStatusForPresentAbsent: function(status, view) {
	        	    	var $this = this;
	        	    	var grid;
	        	    	if(view=="Room Wise"){
	        	    		grid= $this.getRoomwisegrid();
	        	    	}
	        	    	if(view=="Plan Wise" || view=="Scheme Wise"){
	        	    		grid= $this.getPlanwisegrid();
	        	    	}
	        	    	if(view=="Student Wise"){
	        	    		grid= $this.getStudentwisegrid();
	        	    	}
	        	    	
	        	    	var store = grid.getStore();
	        	    	var models = grid.getStore().getRange();
	        	    	if(status=="Present"){
	        	    		for(var i =0; i<store.data.length;i++){
	        	    			models[i].set('presentAbsId', "Present");
	        	    		}
	        	    		if(view != "Plan Wise" && view != "Scheme Wise") {
	        	    			grid.getStore().each(function(record) {
	        	    				grid.getSelectionModel().select(record,true);
	        	    			});
	        	    		}
	        	    	}
	        	    	if(status=="Absent"){
	        	    		for(var i =0; i<store.data.length;i++){
	        	    			try{
	        	    				models[i].set('presentAbsId', "Absent");
	        	    				models[i].set('malPracticeStatus', null);
	        	    			}
	        	    			catch(e){

	        	    			}
	        	    		}
	        	    		if(view != "Plan Wise" && view != "Scheme Wise") {
	        	    			grid.getStore().each(function(record) {
	        	    				grid.getSelectionModel().select(record,true);
	        	    			});
	        	    		}
	        	    	}

	        	    },
	        	    
	        	    listStudentWiseGrid: function() {
	        	    	var $this=this;
	        	    	var quickSearchForm = $this.getStudentlogisticfilter();
	        	    	var grid = $this.getStudentwisegrid();
						grid.config.searchFilterForm = quickSearchForm;
	        	    	var formValue = quickSearchForm.getForm().getValues();
	        	    	var store = this.getStore('examinationcenters.examlogistic.ExamLogisticMalPractice');
	        	    	var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
       				    var al = formValue.academyLocation;
						var als=[];		       				
 	        	    	if(typeof al == 'object'){
 	                       al.forEach(function(obj){
 	                         als.push(obj.get('id'));
	 	                     });
	 	               }
	 	               else{
	 	                   als.push(al)
	 	               }
	        	    	Ext.apply(grid,{
			        		mlpData:null,
			     		  setMlpData : function(mlpData){
			     			 grid.mlpData = mlpData;
			     		  },
			     		  getMlpData:function(){
			     			  return grid.mlpData;
			     		  }
						});
	        	    	var arr=[];
	        	    	store.load({
	        	    		callback:function(record){
	        	    			if(record.length>0){
	        	    				for(var i in record){
	        	    					arr.push(record[i])
	        	    				}
	        	    			}
	        	    			grid.setMlpData(arr);
	        	    		}
	        	    	});
	        	    	grid.getStore().getProxy().extraParams={
	        	    		academyLocationIds:als.join(),
	        	    		courseVariantId:formValue.courseVariant,
	        	    		evaluationPlanId:formValue.evaluationPlanId,
	        	    		eventId:formValue.eventId,
	        	    		admissionId:formValue.studentId
	        	    	};
	        	    	var gridCount = $this.getStudentwiseattendancesummary();
	        	    	var studentWiseSummaryGridStore =  gridCount.getStore();
	        	    	grid.getStore().load({
	        	    		callback: function(records, operation, success) {
	        	    			if (success) {
	        	    				if(records.length!=0){
	        	    					var prePercent='0%', absPercent='0%';
	        		  	        	   	var abs=0,pre=0,oth=0;
	        		  	        	   	var  presentSummaryCount = 0, absentSummaryCount= 0;
	        	    					for(var i in records){
	        	    						if(records[i].data.presentAbsId=="Absent"){
	        	    							abs++;
	        	    							absentSummaryCount++;

	        	    						}else{
	        	    							pre++;
	        	    							presentSummaryCount++
	        	    						}
	        	    					}
	        	    					
	        	    					var storeData = {
	        	    							totalStudent:records.length,
	        	    							totalPresent:pre,
	        	    							totalAbsent:abs,
	        	    							otherCount:oth,
	        	    							presentPercent:parseFloat((presentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	    							absentPercent:parseFloat((absentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	    					};
	        	    					studentWiseSummaryGridStore.removeAll();
	        	    					studentWiseSummaryGridStore.loadRawData(storeData, true);
	        	    					grid.down('#btnPresentItemId').setDisabled(false);
	        	    					grid.down('#btnAbsentItemId').setDisabled(false);
	        	    				}else{
	        	    					studentWiseSummaryGridStore.removeAll();
	        	    				}
	        	    			}
	        	    		}
    				   });
	        	    	
	        	    	var gridColumns = grid.columns;
						var len = gridColumns.length;
						if(wheatherSchool) {
							for (var j = 0; j < len; j++) {
								var gridColumn = gridColumns[j];
								if (gridColumn.dataIndex == "periodName") {
									gridColumn.hide();
								}
							}
						}else{
							for (var j = 0; j < len; j++) {
								var gridColumn = gridColumns[j];
								if (gridColumn.dataIndex == "periodName") {
									gridColumn.show();
								}
							}
						}
						
						$this.resetPageSetting(grid.getStore(), grid);
						grid.getStore().load();     
						grid.getSelectionModel().deselectAll();
						grid.getStore().pageSize=100;
	        	    },

	        	    listPlanWiseGrid: function() {
	        	    	var $this=this;
	        	    	var quickSearchForm = $this.getPlanlogisticfilter();
	        	    	var grid = $this.getPlanwisegrid();
						grid.config.searchFilterForm = quickSearchForm;
	        	    	var formValue = quickSearchForm.getForm().getValues();
	        	    	var planForm = quickSearchForm.getForm();
	        	    	var program = planForm.findField("programId");
       					var batch = planForm.findField("batchId");
       					var period = planForm.findField("periodId");
       					var section = planForm.findField("sectionId");
       					var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						var al = formValue.academyLocation;
	       				var acTerm = formValue.academicTerm;
	       				var cv = formValue.courseVariant
	       				 var als=[];		       				
	 	        	    	if(typeof al == 'object'){
	 	                       al.forEach(function(obj){
	 	                         als.push(obj.get('id'));
		 	                     });
		 	               }
		 	               else{
		 	                   als.push(al)
		 	               }
 	        	    	var cvArr = []
       					if(typeof cv == 'object'){
	                         cv.forEach(function(obj){
	                        	 cvArr.push(obj.get('id'));
	                       });
	                     }
       					else{
       						cvArr.push(cv)
		 	               }
	        	    	var store = this.getStore('examinationcenters.examlogistic.ExamLogisticMalPractice');
	        	    	Ext.apply(grid,{
			        		mlpData:null,
			     		  setMlpData : function(mlpData){
			     			 grid.mlpData = mlpData;
			     		  },
			     		  getMlpData:function(){
			     			  return grid.mlpData;
			     		  }
						});
	        	    	var arr=[];
	        	    	store.load({
	        	    		callback:function(record){
	        	    			if(record.length>0){
	        	    				for(var i in record){
	        	    					arr.push(record[i])
	        	    				}
	        	    			}
	        	    			grid.setMlpData(arr);
	        	    		}
	        	    	});
	        	    	var gridColumns = grid.columns;
						var len = gridColumns.length;
	        	    	if(formValue.evaluationPlanType == getExaminationTranslation('CNTRL_ACADEMICS')){
	        	    		grid.getStore().getProxy().extraParams={
		        	    		academyLocationIds:als.join(),
		        	    		academicTermId:acTerm,
		        	    		courseId:formValue.courseId,
		        	    		courseVariantIds:cvArr.join(),
		        	    		evaluationPlanId:formValue.evaluationPlanId,
		        	    		evaluationPlanType:formValue.evaluationPlanType,
		        	    		evaluationStage:formValue.evaluationStage,
		        	    		eventId:formValue.eventId
		        	    	};
	        	    		for (var j = 0; j < len; j++) {
								var gridColumn = gridColumns[j]; 
								if (gridColumn.dataIndex == "courseName") {
									gridColumn.show();
								}
								if(wheatherSchool) {
									if (gridColumn.dataIndex == "periodName") {
										gridColumn.hide();
									}
								}
							}
	        	    	} else {
	        	    		grid.getStore().getProxy().extraParams={
//		        	    		academyLocationId:$this.getCurrentAcademyLocation(),
		        	    		evaluationPlanId:formValue.evaluationPlanId,
		        	    		evaluationPlanType:formValue.evaluationPlanType,
		        	    		evaluationStage:formValue.evaluationStage,
		        	    		eventId:formValue.eventId,
		        	    		programId:program.getValue(),
		       					batchId:batch.getValue(),
		       					periodId:period.getValue(),
		       					sectionId:section.getValue()
		        	    	};
	        	    		for (var j = 0; j < len; j++) {
								var gridColumn = gridColumns[j];
								if (gridColumn.dataIndex == "courseName") {
									gridColumn.hide();
								}
								if(wheatherSchool) {
									if (gridColumn.dataIndex == "periodName") {
										gridColumn.hide();
									}
								}
							}
	        	    	}
	        	    	var gridCount = $this.getSchemewiseattendancesummary();
	        	    	var planWiseSummaryGridStore =  gridCount.getStore();
    					planWiseSummaryGridStore.removeAll();
	        	    	grid.getStore().load({
	        	    		callback: function(records, operation, success) {
	        	    			if (success) {
	        	    				if(records.length!=0){
	        	    					var prePercent='0%', absPercent='0%';
	        		  	        	   	var abs=0,pre=0,oth=0;
	        		  	        	   	var  presentSummaryCount = 0, absentSummaryCount= 0;
	        	    					for(var i in records){
	        	    						if(records[i].data.presentAbsId=="Absent"){
	        	    							abs++;
	        	    							absentSummaryCount++;

	        	    						}else{
	        	    							pre++;
	        	    							presentSummaryCount++
	        	    						}
	        	    					}
	        	    					var storeData = {
	        	    							totalStudent:records.length,
	        	    							totalPresent:pre,
	        	    							totalAbsent:abs,
	        	    							otherCount:oth,
	        	    							presentPercent:parseFloat((presentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	    							absentPercent:parseFloat((absentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	    					};
	        	    					planWiseSummaryGridStore.removeAll();
	        	    					planWiseSummaryGridStore.loadRawData(storeData, true);
	        	    				} else{
	        	    					planWiseSummaryGridStore.removeAll();
	        	    				}
	        	    				if(records.length>0){
										grid.down('#btnPresentItemId').setDisabled(false);
										grid.down('#btnAbsentItemId').setDisabled(false);
									}
	        	    			}
	        	    		}
    				   });
	        	    },
	        	    
	        	    loadExamLogisticFilter : function() {
	        	    	var $this=this;
	        	    	var quickSearchForm = $this.getExamlogisticfilter();
	        	    	var grid = $this.getRoomwisegrid();
						grid.config.searchFilterForm = quickSearchForm;
	        	    	var formValue = quickSearchForm.getForm().getValues();
	        	    	var timeSlotField = quickSearchForm.getForm().findField("timeSlot");
	        	    	var centerNameField = quickSearchForm.getForm().findField("centerName");
	        	    	var store = this.getStore('examinationcenters.examlogistic.ExamLogisticMalPractice');
	        	    	var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						
	        	    	Ext.apply(grid,{
			        		code:null,
			     		  setCode : function(code){
			     			 grid.code = code;
			     		  },
			     		  getCode:function(){
			     			  return grid.code;
			     		  }
						});
	        	    	var arr=[];
	        	    	store.load({
	        	    		callback:function(record){
	        	    			if(record.length>0){
	        	    				for(var i in record){
	        	    					arr.push(record[i])
	        	    				}
	        	    			}
	        	    			grid.setCode(arr);
	        	    		}
	        	    	});
	        	    	var programId = quickSearchForm.getForm().findField("programId");
	        	    	var batchId = quickSearchForm.getForm().findField("batchId");
	        	    	var periodId = quickSearchForm.getForm().findField("periodId");
	        	    	var section = quickSearchForm.getForm().findField("section");
	        	    	var courseId = quickSearchForm.getForm().findField("courseId");
	        	    	var courseVariant = quickSearchForm.getForm().findField("courseVariant");
	        	    	var scheduleDate = quickSearchForm.getForm().findField('date').getValue();
	        	    	
	        	    	grid.getStore().getProxy().extraParams={
	        	    		evaluationGroupId:formValue.evalGroup,
	        	    		roomNoId:formValue.roomNo,
	        	    		//scheduleDateId:formValue.date,
	        	    		centerId:formValue.centerName,
	        	    		groupBatchId:formValue.timeSlot,
	        	    		centerType:centerNameField.valueModels[0].data.code,
	        	    		courseId:courseId.getValue(),
	        	    		courseVariantId:courseVariant.getValue(),
	        	    		programId:programId.getValue(),
	        	    		batchId:batchId.getValue(),
	        	    		periodId:periodId.getValue(),
	        	    		sectionId:section.getValue(),
	        	    		groupDateBatchCenterId:parseInt(timeSlotField.valueModels[0].data.code),
	        	    		scheduleDate:scheduleDate,
	        	    		academyLocationId: $this.getCurrentAcademyLocation()
	        	    	};
	        	    	$this.resetGridSetting(grid);
	        	    	var gridCount = $this.getRoomwiseattendancesummary();
    					var roomWiseSummaryGridStore =  gridCount.getStore();
	        	    	grid.getStore().load({
	        	    		callback: function(records, operation, success) {
	        	    			if (success) {
	        	    				if(records.length!=0){
	        	    					var prePercent='0%', absPercent='0%';
	        		  	        	   	var abs=0,pre=0,oth=0;
	        		  	        	   	var  presentSummaryCount = 0, absentSummaryCount= 0;
	        	    					for(var i in records){
	        	    						if(records[i].data.presentAbsId=="Absent"){
	        	    							abs++;
	        	    							absentSummaryCount++;

	        	    						}else{
	        	    							pre++;
	        	    							presentSummaryCount++
	        	    						}
	        	    					}
	        	    					var storeData = {
	        	    							totalStudent:records.length,
	        	    							totalPresent:pre,
	        	    							totalAbsent:abs,
	        	    							otherCount:oth,
	        	    							presentPercent:parseFloat((presentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	    							absentPercent:parseFloat((absentSummaryCount/records.length)*100).toFixed(2)+"%",
	        	    					};
	        	    					roomWiseSummaryGridStore.removeAll();
	        	    					roomWiseSummaryGridStore.loadRawData(storeData, true);
	        	    					grid.down('#btnPresentItemId').setDisabled(false);
	        	    					grid.down('#btnAbsentItemId').setDisabled(false);
	        	    				}else{
	        	    					roomWiseSummaryGridStore.removeAll();
	        	    				}
	        	    			}
	        	    		}
    				   }); 
	        	    	
	        	    	var gridColumns = grid.columns;
						var len = gridColumns.length;
						if(wheatherSchool) {
							for (var j = 0; j < len; j++) {
								var gridColumn = gridColumns[j];
								if (gridColumn.dataIndex == "periodName") {
									gridColumn.hide();
								}
							}
						}else{
							for (var j = 0; j < len; j++) {
								var gridColumn = gridColumns[j];
								if (gridColumn.dataIndex == "periodName") {
									gridColumn.show();
								}
							}
						}
	        	    	
	        	    	
						/*console.log('quickSearchForm.......',quickSearchForm);
						var getQuickSearchForm=quickSearchForm.getForm();
						var centerTypeValue=getQuickSearchForm.findField('centerType').getValue();
						*//**
						 * Load XML 
						 *//*
						var searchResultGrid =null;
						var viewCode=null;
						var configCode=null;
						var examLogisticInternalGrid = $this.getExamLogisticInternalGrid();
						var examLogisticExternalGrid = $this.getExamLogisticExternalGrid();
						examLogisticInternalGrid.setVisible(false);
						examLogisticExternalGrid.setVisible(false);
						*//**
						 * Load xml on the bases of center type
						 *//*
						if(centerTypeValue==getExaminationTranslation('CNTRL_INTERNAL')){
							viewCode=CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_INTERNAL_LIST_VIEWCODE;
							configCode=CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_INTERNAL_LIST_CONFIGCODE;
							searchResultGrid=examLogisticInternalGrid;
						}else if (centerTypeValue==getExaminationTranslation('CNTRL_EXTERNAL')){
							viewCode=CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_EXTERNAL_LIST_VIEWCODE;
							configCode=CONSTANTS.CB.EXAM_LOGISTIC_STUDENT_ATTENDANCE_EXTERNAL_LIST_CONFIGCODE;
							searchResultGrid=examLogisticExternalGrid;
						}
						searchResultGrid.setVisible(true);
						
						var jsonFormatFormData = $this.createJsonFormat(getQuickSearchForm,configCode );
						var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
						resultViewUrl = resultViewUrl.concat(viewCode);
						searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl,jsonFormatFormData);*/
					},
					createJsonFormat : function(quickSearchForm, configCode) {
						var formValues=quickSearchForm.getValues();
						var values = new Object();
						var searchcriteria = new Array();
						values.configCode = configCode;
						
						var COURSE_ID = this.getJsonObject('COURSE_ID', formValues.course);
	                	this.pushJsonObjectInArray(COURSE_ID,searchcriteria);
	                	var EXAM_CENTER_ID = this.getJsonObject('EXAM_CENTER_ID', formValues.centerName);
	                	this.pushJsonObjectInArray(EXAM_CENTER_ID,searchcriteria);
	                	var EVAL_SEQ_DETAIL_ID = this.getJsonObject('EVAL_SEQ_DETAIL_ID', formValues.detailedSequence);
	                	this.pushJsonObjectInArray(EVAL_SEQ_DETAIL_ID,searchcriteria);
	                	var EXAM_MALPRACTICE_TYPE_ID = this.getJsonObject('EXAM_MALPRACTICE_TYPE_ID', formValues.malpracticesReported);
	                	this.pushJsonObjectInArray(EXAM_MALPRACTICE_TYPE_ID,searchcriteria);
	                	var EVAL_GROUP_SCH_DATE_ID = this.getJsonObject('EVAL_GROUP_SCH_DATE_ID', formValues.date);
	                	this.pushJsonObjectInArray(EVAL_GROUP_SCH_DATE_ID,searchcriteria);
	                	var CENTER_TYPE = this.getJsonObject('CENTER_TYPE', formValues.centerType);
	                	this.pushJsonObjectInArray(CENTER_TYPE,searchcriteria);
	                	
	                	var evalStage=null;
	                	if(formValues.evalStage_1!=""){
	                		evalStage=formValues.evalStage_1;
	                	}else if(formValues.evalStage_2!=""){
	                		evalStage=formValues.evalStage_2;
	                	} 
	                	var EVALUATION_STAGE = this.getJsonObject('EVALUATION_STAGE', evalStage);
	                	this.pushJsonObjectInArray(EVALUATION_STAGE,searchcriteria);
						values.searchCriterias = searchcriteria;
						return values;
					},
					getJsonObject : function(key, value, additionalValue) {
						if (value != '' && value != null
								&& additionalValue == undefined) {
							return {
								"paramCode" : key,
								"paramValues" : [ value ]
							};
						} else if (value != '' && additionalValue != undefined) {
							return {
								"paramCode" : key,
								"paramValues" : [ value, additionalValue ]
							};
						}
					},
					pushJsonObjectInArray : function(object, array) {
						if (object) {
							array.push(object);
						}
					},
	      	    gridRenderFunction:function(grid){
	             	grid.addButtonToolbar();
	      	   	/*grid.addDocked({
         				 xtype: 'toolbar',
         				 dock:'top',
         				 items:[{
         					 xtype: 'button',
         					 itemId: 'btnAdd',
         					 tooltip : getCommonTranslation('ADD'),
         					 glyph: ICONGLYPH.ADDGLYPH
         				 },{
         					 xtype: 'button',
         					 itemId: 'btnDelete',
         					 cls: 'CustomToolbarBtnReject',
         					 tooltip : getCommonTranslation('DELETE'),
         					 glyph: ICONGLYPH.DELETEGLYPH
         				 }]
         			 });*/
	              },
	        	
					//***********************Export Functionality Pnc*************************************
		            exportUserList : function(exportUrl,filetype,whetherAll,quickSearchForm,searchResultGrid,configCode) {
			               var pagingtoolbaroptions = searchResultGrid.down('pagingtoolbar').getStore().lastOptions;
			               console.log('pagingtoolbaroptions',pagingtoolbaroptions);
			               var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
			               var jsonFormatFormData = this.createJsonFormat(quickSearchForm,configCode);
			               var visibleColumns=this.getVisibleColumns(searchResultGrid);
			               var reportTitle=getCommonTranslation('EXAMLOGISTIC_LIST');
			               
			      if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null){
			                             jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
			                      }
			      searchResultGrid.exportData(exportUrl, filetype,jsonFormatFormData,pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);

			      },
			      createSearchCriteriaString: function(searchForm) {
			    	  var me=this;
			    	  var formValues = new Array();
			    	  formValues = searchForm.getValues();        
			    	  var searchCriteriaString="";
			    	  for (var key in formValues) {
			    		  var value = formValues[key];            
			    		  if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
			    			  var keyValueJsonObject = me.getJsonObject( key , value);
			    			  searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
			    		  }
			    	  }
			    	  searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
			    	  return searchCriteriaString;
			      }, 
			      // ********* Hide  all more Action button for Student Attendance *************
			      disableMoreActionPivileges: function(gridReference,permissionsMap) {
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				    	var attendanceSaveButton = gridReference.down('#btnSave');
				    	var malpracticeSaveButton = gridReference.down('#btnMalPracticeSave');
				    	attendanceSaveButton.setVisible(false);
				    	malpracticeSaveButton.setVisible(false);
				    	
				    	Ext.each(permissionList, function(privilege) {
				    		if (privilege === 'SAVEBUTTON') {
				    			//var button = buttonsToolBar.query('#btnSave')[0];
				    			if(!isNullOrEmpty(attendanceSaveButton)){
				    				attendanceSaveButton.setVisible(true);
				    			}        		
				    		}
				    		if (privilege === 'MALPRACTICESAVABUTTON') {
				    			//var button = buttonsToolBar.query('#btnSave')[0];
				    			if(!isNullOrEmpty(malpracticeSaveButton)){
				    				malpracticeSaveButton.setVisible(true);
				    			}        		
				    		}
				    	});
				    },  
				    openGenerateReportWindow:function() {
				    	var $this = this;
				    	var formWindow = $this.getGeneratereportwin();
				    	if (!formWindow) {
				    		Ext.widget('generatereportwin');
				    		formWindow = $this.getGeneratereportwin();
				    	}
				    	formWindow.setHeight(230);
				    	formWindow.setWidth(500);
				    	formWindow.show();
				    	var tempalte = formWindow.down('#chooseTemplate').getStore();
				    	tempalte.getProxy().extraParams={
				    		reportType:'Examination Absentee Report'
				    	};
				    	tempalte.load();
				    },
				    openRoomWiseGenerateReportWindow:function() {
				    	var $this = this;
					    var formWindow = $this.getGenerateroomwisereportwin();
					    if (!formWindow) {
					    		Ext.widget('generateroomwisereportwin');
					    		formWindow = $this.getGenerateroomwisereportwin();
					    }
				    	formWindow.setHeight(200);
				    	formWindow.setWidth(450);
				    	formWindow.show();
					    var tempalte = formWindow.down('#chooseTemplate').getStore();
					    tempalte.getProxy().extraParams={
						   reportType:'Examination Attendance Report'
					    };
					    tempalte.load();
					    var sorting = formWindow.down('#firstSortingFilterItemId');
				    	sorting.getStore().load({
	        	    		callback: function(records, operation, success) {
	        	    			if (success) {
	        	    				if(records.length>0){
	        	    					sorting.setValue(records[0]);
	        	    				}
	        	    			}
	        	    		}
				    	});
			    	 },
				    
				    generateAllReportReport:function() {
				    	var $this = this;
			        	var form = $this.getPlanlogisticfilter().getForm(); 
			        	var formValues = form.getValues();
			        	var fromWindow = $this.getGeneratereportwin();
			        	var reportTypeCode = fromWindow.down('#chooseTemplate');
			        	var studentType = fromWindow.down('#studentTypeId');
			        	var code = reportTypeCode.valueModels[0].data.value;
			        	
			        	var reportParams =new Object();
			        	if(!isNullOrEmpty(formValues.eventId)) {
			        		reportParams.EVENT_ID=formValues.eventId;
			        	}
			        	if(!isNullOrEmpty(formValues.courseVariant)) {
			        		try {
			        			if(formValues.courseVariant.length > 1) {
			        				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_SINGLE_COURSE_VARIANT'));
			        				return;
			        			}
			        			if(typeof formValues.courseVariant == 'number') {
			        		reportParams.COURSEVARIANT_ID=formValues.courseVariant;
			        	}
			        			else {
			        				reportParams.COURSEVARIANT_ID=formValues.courseVariant[0].get('id');
			        			}
			        		}
			        		catch(e) {}
			        	}
			        	if(fromWindow.down('#evaluationGroupItemId').valueModels.length>0) {
			        		reportParams.EVALUATION_GROUP_NAME = fromWindow.down('#evaluationGroupItemId').valueModels[0].data.code;
			        	}
			        	reportParams.COURSE_ID=formValues.courseId;
			        	reportParams.STUDENT_TYPE=studentType.getValue().studentType;
			        	
			        	reportParams.code = code;
			        	fromWindow.close();
			        	
			        	if(code=="RGI_ATTENDANCE_SHEET"){
			        		var exportUrl = SERVERURL.PATH_GENERATE_ROOM_WISE_REPORT;
			        	} else {
			        		var exportUrl = SERVERURL.PATH_GENERATE_FOILS_REPORT;
			        	}
			        	
			        	$this.exportJRXMLReport(code,reportParams,reportTypeCode.valueModels[0].data.value+'_'+form.findField('courseId').getRawValue()
			        			,'.pdf',exportUrl);
				    },
				    
				  //Disable other Privileges button 
				    disableExamPlanWiseOtherPivileges: function(structure,permissionsMap) {
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				    	var generateReport = structure.down('#planlogisticfilter').down('#generateReport');
				    	var planwisegrid = structure.down('#planwisegridId');
				    	this.disableExamAttendanceOtherPivileges(planwisegrid, this.getEXAM_PLAN_WISE_ATTENDANCE_PERMISSION());
				    	generateReport.setVisible(false);
				    	Ext.each(permissionList, function(privilege) {
//				    		console.log(privilege);
				    		if (privilege === 'GENERATEREPORT') {
				    			if(!isNullOrEmpty(generateReport)){
				    				generateReport.setVisible(true);
				    			}        		
				    		}
				    	});
				    },
				    
				  //Disable other Privileges button 
				    disableExamAttendanceOtherPivileges: function(gridReference,permissionsMap) {
				    	var associatedAcadLocationIds = new Array();
				    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				    	var buttonsToolBar = gridReference.query('toolbar')[0];
				    	buttonsToolBar.setVisible(false);
				    	var btnSaveItemId = buttonsToolBar.query('#btnSaveItemId')[0];
				    	var btnPresentItemId = buttonsToolBar.query('#btnPresentItemId')[0];
				    	var btnAbsentItemId = buttonsToolBar.query('#btnAbsentItemId')[0];
				    	btnSaveItemId.setVisible(true);
				    	btnPresentItemId.setVisible(true);
				    	btnAbsentItemId.setVisible(true);
				    	/*Ext.each(permissionList, function(privilege) {
//				    		console.log(privilege);
				    		if (privilege === 'CREATE') {
				    			if(!isNullOrEmpty(btnSaveItemId)){
				    				btnSaveItemId.setVisible(true);
				    			}        		
				    		} else if (privilege === 'MARKALLPRESENT') {
				    			if(!isNullOrEmpty(btnPresentItemId)){
				    				btnPresentItemId.setVisible(true);
				    			}        		
				    		} else if (privilege === 'MARKALLABSENT') {
				    			if(!isNullOrEmpty(btnAbsentItemId)){
				    				btnAbsentItemId.setVisible(true);
				    			}        		
				    		}
				    	});*/
				    	buttonsToolBar.setVisible(true);
			    		var obj = this.getPlanlogisticfilter();
				    	Ext.each(permissionList, function(privilege) {
			    			if(privilege === 'MARK_ATTENDANCE_AS_A_HOST_FACULTY' && portalId == '1'){
			    				obj.insert(0, {
			    					xtype: 'fieldcontainer',
			    					width: '100%',
			    					items: [{
			    						xtype: 'checkboxfield',
			    						labelAlign: 'right',
			    						itemId: 'attendanceAsHostFaculty',
			    						hidden: false,
			    						boxLabel: getExaminationTranslation('MARK_ATTENDANCE_AS_A_HOST_FACULTY'),
			    						name: 'attendanceAsHostFaculty',
			    						inputValue: true,
			    						uncheckedValue: false
			    					}]
			    				});
			    			}
			    		});
				    },
				    
				    permissionManagementForAttendanceRadioBtn : function(structure, permissionsMap) {
				    	
				    	var $this = this;
      				  
				    	var attendanceBygroupId = structure.down('#attendanceBygroupId');
				    	
				    	var associatedAcadLocationIds = new Array();
			    	    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	    var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			    	    
				    	var roomAttendanceBtn = attendanceBygroupId.items.items[0];
				    	var planAttendanceBtn = attendanceBygroupId.items.items[1];
				    	var studentAttendanceBtn = attendanceBygroupId.items.items[2];
				    	
				    /*	var roomAttendanceScreen = $this.getRoomwiseattendanceview();
  					  	var planAttendanceScreen = $this.getPlanwiseattendanceview();
  					  	var studentAttendanceScreen = $this.getStudentwiseattendanceview();*/
				    	
  					  	roomAttendanceBtn.setVisible(false);
  					  	planAttendanceBtn.setVisible(false);
  					  	studentAttendanceBtn.setVisible(false);
				    	var r=false,p=false,s=false;
				    	Ext.each(permissionList, function(privilege) {
				    		if (privilege === 'ROOM_WISE_ATTENDANCE') {
				        		if(!isNullOrEmpty(roomAttendanceBtn)){
				        			r=true;
				        			roomAttendanceBtn.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'SCHEME_WISE_ATTENDANCE') {
				        		if(!isNullOrEmpty(planAttendanceBtn)){
				        			p=true;
				        			planAttendanceBtn.setVisible(true);
				        		}        		
				        	}
				    		if (privilege === 'STUDENT_WISE_ATTENDANCE') {
				        		if(!isNullOrEmpty(studentAttendanceBtn)){
				        			s=true;
				        			studentAttendanceBtn.setVisible(true);
				        		}        		
				        	}
				    	});
				    	if(r && p && s){
				    		var data={
				    				"downloadUploadTemplate":'forRoomWise'	
				    		}
				    		$this.tabChangeFunctionality(null, data, null);
				    	} else if(r){
				    		var data={
				    				"downloadUploadTemplate":'forRoomWise'	
				    		}
				    		$this.tabChangeFunctionality(null, data, null);
				    	} else if(!r && p){
				    		var data={
				    				"downloadUploadTemplate":'forPlanWise'	
				    		}
				    		$this.tabChangeFunctionality(null, data, null);
				    	} else if(!r && !p && s){
				    		var data={
				    				"downloadUploadTemplate":'forStudentWise'	
				    		}
				    		$this.tabChangeFunctionality(null, data, null);
				    	}
				    },
				    
				    onAttendanceHostFacultyChange: function(cmp, nval) {
				    	var form = cmp.up('form');
				    	var academyLocationId = this.getCurrentAcademyLocation();
				    	var alFld = form.down('#academyLocationIdExamAttend');
				    	/*alFld.reset();
				    	alFld.getStore().load({
		    	    		callback: function(){
		    	    			alFld.setValue(academyLocationId);
			    			}
        	    		})*/
				    	alFld.setDisabled(nval);
				    	var planType = form.down('#evaluationType_Id');
				    	planType.setValue('ACADEMICS');
				    	planType.fireEvent('select', planType, planType.lastSelection);
				    	alFld.fireEvent('change', alFld);
				    	var academicTerm = form.down('#academicTermExamAttend');
				    	academicTerm.reset()	
				    	/*academicTerm.getStore().load({
				    		callback:function(record){
				    			for(var i in record){
				    				if(record[i].data.whetherCurrentAcademicTerm == true){
				    					academicTerm.setValue(record[i].data.id);
				    					academicTerm.fireEvent('select', academicTerm);
				    				}
				    			}
				    		}
				    	});*/
				    	var course = form.down('#courseItemId');
				    	course.reset();
				    	var variant = form.down('#sectionIdQuickFiltr');
				    	variant.reset();
				    	var plan = form.down('#evaluationPlanItemId');
				    	plan.reset();
				    	var level = form.down('#evalPlanLevelItemId');
				    	level.reset();
				    	var event = form.down('#eventItemId');
				    	event.reset();
				    },
				    
				    onPlanLogisticFilterRender: function(form) {
				    	if(portalId == '2') {
				    		var permissionsMap = this.getMANAGE_EXAM_ATTENDANCE_PERMISSION();
				    		var associatedLocationIds = new Array();
				    		associatedLocationIds.push(this.getCurrentAcademyLocation());
				    	    var permissionsList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedLocationIds, permissionsMap);
				    	    Ext.each(permissionsList, function(privilege) {
				    			if(privilege === 'MARK_ATTENDANCE_AS_A_HOST_FACULTY'){
				    				form.insert(0, {
				    					xtype: 'fieldcontainer',
				    					width: '100%',
				    					items: [{
				    						xtype: 'checkboxfield',
				    						labelAlign: 'right',
				    						itemId: 'attendanceAsHostFaculty',
				    						hidden: false,
				    						boxLabel: getExaminationTranslation('MARK_ATTENDANCE_AS_A_HOST_FACULTY'),
				    						name: 'attendanceAsHostFaculty',
				    						inputValue: true,
				    						uncheckedValue: false
				    					}]
				    				});
				    			}
				    		});
				    	}
				    }
});
