/**
 * @author Deepika Parmar
 */
Ext.define('Academia.controller.examinationcenters.reports.UpdatedMarksRemarksReportController',{
	extend: 'Academia.controller.examinationcenters.reports.ExamReportCommonController',
	stores : ['examinationcenters.reports.updatedmarksremarks.UpdatedMarksRemarksGridStore','examinationcenters.remark.StudentLevelRemarkReportGridStore','examinationcenters.reports.ExaminationResultReportGridStore'],
	views : ['examinationcenters.reports.updatedmarkremarkreport.UpdatedMarksRemarksReportStructure','examinationcenters.reports.updatedmarkremarkreport.UpdatedMarksRemarksReportFilter',
		'examinationcenters.reports.updatedmarkremarkreport.UpdatedMarksRemarksReportGrid',
		'examinationcenters.reports.StudentLevelRemarkReportFilter','examinationcenters.reports.StudentLevelRemarkReportGrid',
		'examinationcenters.reports.ExaminationResultReportStructure',
		'examinationcenters.reports.ExaminationResultReportFilter','examinationcenters.reports.ExaminationResultReportGrid'],

		refs : [{
			ref: 'contentPanel',
			selector: 'contentpanel'
		},{
			ref:'updatedmarksremarksreportstructure',
			selector:'updatedmarksremarksreportstructure'
		},{
			ref:'updatedmarksremarksreportfilter',
			selector:'updatedmarksremarksreportfilter'
		},{
			ref:'updatedmarksremarksreportgrid',
			selector:'updatedmarksremarksreportgrid'
		},{
			ref:'studentlevelremarkreportfilter',
			selector:'studentlevelremarkreportfilter'
		},{
			ref:'studentlevelremarkreportgrid',
			selector:'studentlevelremarkreportgrid'
		},{
   			ref:'examinationresultreportfilter',
			selector:'examinationresultreportfilter'
		},{
			ref:'examinationresultreportstructure',
			selector:'examinationresultreportstructure'
		},{
			ref:'examinationresultreportgrid',
			selector:'examinationresultreportgrid'
		}],
		config:{
			EXAMINATION_REPORTS_UPDATED_MARKS_REMARKS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_REPORTS_UPDATED_MARKS_REMARKS_PRIVILEGES'),
			STUDENT_LEVEL_REMARK_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LEVEL_REMARK_REPORT_PRIVILEGES'),
      	  
			EXAMINATION_RESULT_REPORTS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EXAMINATION_RESULT_REPORTS_PRIVILEGES'),
			EXAMINATION_RESULT_REPORTS_FACULTY_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_EXAMINATION_RESULT_REPORTS_PRIVILEGES'),
		},

		init : function(application) {
			this.control({
				'updatedmarksremarksreportfilter':{
					afterrender:function(filterForm){
						var form = filterForm.getForm();
						var programId =form.findField('programId');
						var programStore = programId.getStore();
						var academyLocationIds =this.getAcademyLocationIds();
						programStore.getProxy().extraParams={
							academyLocationIds : academyLocationIds,
							whetherMarksheet:false
						};
						programStore.load();
					}
				},
				'updatedmarksremarksreportfilter customcombobox[itemId=programIdItemId]':{
					select:function(programCombo,programRecord){
						var filterForm =this.getUpdatedmarksremarksreportfilter();
						var form = filterForm.getForm(); 
						var batchField =form.findField('batchId');
						var periodField =form.findField('periodId');
						var studentField = form.findField('studentId');
						var courseField = form.findField('courseId');
						var courseVariant =form.findField('courseVariant');
						var studentStatus =form.findField('studentStatus');
						

						batchField.enable();
						periodField.disable();
						studentField.disable();
						courseField.disable();
						courseVariant.disable();

						batchField.reset();
						periodField.reset();
						studentField.reset();
						courseField.reset();
						courseVariant.reset();
						studentStatus.reset();
						batchField.getStore().getProxy().extraParams={
							programId:programRecord[0].data.id,
							whetherMarksheet:false
						};
						batchField.getStore().load({
							callback:function(batchRecord){
								if(batchRecord.length == 1){
									batchField.setValue(batchRecord[0].data.id)
									periodField.enable();
									periodField.getStore().getProxy().extraParams={
										programId:programRecord[0].data.id,
										batchId:batchRecord[0].data.id,
										whetherMarksheet:false
									};

									periodField.getStore().load({
										callback:function(periodRecord){
											if(periodRecord.length == 1){
												periodField.setValue(periodRecord[0].data.id)
												studentField.enable();
												studentField.getStore().getProxy().extraParams={
													periodId:periodRecord[0].data.id
												};

												studentField.getStore().load({
													callback:function(studentRecord){
														if(studentRecord.length ==1){
															studentField.setValue(studentRecord[0].data.id);
															studentStatus.getStore().load({
																callback:function(){
																	studentStatus.setValue(studentRecord[0].data.activeStatus);
																}
															})

														}
													}
												});
												courseField.enable();
												courseField.getStore().getProxy().extraParams={
													periodId:periodRecord[0].data.id
												};

												courseField.getStore().load({
													callback:function(courseRecord){
														if(courseRecord.length ==1){
															courseField.setValue(courseRecord[0].data.id);
															courseVariant.enable();
															courseVariant.getStore().getProxy().extraParams={
																courseId:courseRecord[0].data.id,
																periodId:periodRecord[0].data.id
															};
															courseVariant.getStore().load();
														}
													}
												});
											}
										}
									});

								}
							}
						});
					}
				},

				'updatedmarksremarksreportfilter customcombobox[itemId=batchIdItemId]':{
					select:function(batchCombo,batchRecord){
						var filterForm =this.getUpdatedmarksremarksreportfilter();
						var form = filterForm.getForm(); 
						var periodField =form.findField('periodId');
						var studentField = form.findField('studentId');
						var courseField = form.findField('courseId');
						var courseVariant =form.findField('courseVariant');
						var studentStatus = form.findField('studentStatus');
						
						studentField.disable();
						courseField.disable();
						courseVariant.disable();

						periodField.reset();
						studentField.reset();
						courseField.reset();
						courseVariant.reset();
						studentStatus.reset();

						periodField.enable();
						periodField.getStore().getProxy().extraParams={
							batchId:batchRecord[0].data.id,
							whetherMarksheet:false
						};

						periodField.getStore().load({
							callback:function(periodRecord){
								if(periodRecord.length == 1){
									periodField.setValue(periodRecord[0].data.id)
									studentField.enable();
									studentField.getStore().getProxy().extraParams={
										periodId:periodRecord[0].data.id
									};

									studentField.getStore().load({
										callback:function(studentRecord){
											if(studentRecord.length ==1){
												studentField.setValue(studentRecord[0].data.id);
												studentStatus.getStore().load({
													callback:function(){
														studentStatus.setValue(studentRecord[0].data.activeStatus);
													}
												})

											}
										}
									});
									courseField.enable();
									courseField.getStore().getProxy().extraParams={
										periodId:periodRecord[0].data.id
									};

									courseField.getStore().load({
										callback:function(courseRecord){
											if(courseRecord.length ==1){
												courseField.setValue(courseRecord[0].data.id);
												courseVariant.enable();
												courseVariant.getStore().getProxy().extraParams={
													courseId:courseRecord[0].data.id,
													periodId:periodRecord[0].data.id
												};
												courseVariant.getStore().load();
											}
										}
									});
								}
							}

						});
					}
				},
				'updatedmarksremarksreportfilter customcombobox[itemId=periodIdItemId]':{
					select:function(periodCombo,periodRecord){
						var filterForm =this.getUpdatedmarksremarksreportfilter();
						var form = filterForm.getForm(); 
						var studentField = form.findField('studentId');
						var courseField = form.findField('courseId');
						var courseVariant =form.findField('courseVariant');
						var studentStatus = form.findField('studentStatus');
						studentField.enable();
						courseField.enable();
						courseVariant.disable();

						studentField.reset();
						courseField.reset();
						courseVariant.reset();
						studentStatus.reset();

						studentField.enable();
						studentField.getStore().getProxy().extraParams={
							periodId:periodRecord[0].data.id
						};

						studentField.getStore().load({
							callback:function(studentRecord){
								if(studentRecord.length ==1){
									studentField.setValue(studentRecord[0].data.id);
									studentStatus.getStore().load({
										callback:function(){
											studentStatus.setValue(studentRecord[0].data.activeStatus);
										}
									})

								}
							}
						});
						courseField.enable();
						courseField.getStore().getProxy().extraParams={
							periodId:periodRecord[0].data.id
						};

						courseField.getStore().load({
							callback:function(courseRecord){
								if(courseRecord.length ==1){
									courseField.setValue(courseRecord[0].data.id);
									courseVariant.enable();
									courseVariant.getStore().getProxy().extraParams={
										courseId:courseRecord[0].data.id,
										periodId:periodRecord[0].data.id
									};
									courseVariant.getStore().load();
								}
							}
						});


					}
				},
				'updatedmarksremarksreportfilter customcombobox[itemId=courseItemId]':{
					select:function(courseCombo,courseRecord){
						var filterForm =this.getUpdatedmarksremarksreportfilter();
						var form = filterForm.getForm(); 
						var courseVariantField = form.findField('courseVariant');
						var studentField =  form.findField('studentId');
						var periodField =  form.findField('periodId');
						var batchField = form.findField('batchId');

						courseVariantField.enable();

						courseVariantField.reset();

						courseVariantField.getStore().getProxy().extraParams={
							admissionId:studentField.getValue(),
							courseId:courseRecord[0].data.id,
							periodId:periodField.getValue(),
							batchId:batchField.getValue()
						};
						courseVariantField.getStore().load({
							callback:function(courseVariantRecord){
								if(courseVariantRecord.length ==1){
									courseVariantField.setValue(courseVariantRecord[0].data.id);


								}
							}
						});


					}
				},
				'updatedmarksremarksreportfilter customcombobox[itemId=studentItemId]':{
					select:function(studentCombo,studentRecord){
						var filterForm =this.getUpdatedmarksremarksreportfilter();
						var form = filterForm.getForm(); 
						var studentStatus = form.findField('studentStatus');
						studentStatus.reset();
						studentStatus.getStore().load({
							callback:function(){
								studentStatus.setValue(studentRecord[0].data.activeStatus)
							}
						});
						

					}
				},
				'updatedmarksremarksreportfilter button[itemId=searchBtn]':{
					click:function(obj){
						var form =obj.up('form');
						var filterForm=obj.up('form').getForm();
						var formValues =filterForm.getValues()
						var grid = this.getUpdatedmarksremarksreportgrid();
						grid.config.searchFilterForm =form;
						grid.getStore().getProxy().extraParams = {
							batchId:formValues.batchId,
							periodId:formValues.periodId,
							courseVariantId:formValues.courseVariant,
							admissionId:formValues.studentId,
							status: formValues.studentStatus,
							courseId: formValues.courseId
						}
						this.resetPageSetting(grid.getStore(), grid);
						grid.getStore().load();
					}
				},
				'updatedmarksremarksreportfilter button[itemId=resetBtn]':{
					click:function(obj){
						var filterForm=obj.up('form').getForm();
						var programId =filterForm.findField('programId')
						var batchId =filterForm.findField('batchId');
						var periodId =filterForm.findField('periodId');
						var courseId =filterForm.findField('courseId');
						var courseVariant =filterForm.findField('courseVariant');
						var studentId =filterForm.findField('studentId');
						var academyLocationIds =this.getAcademyLocationIds();

						batchId.setDisabled(true);
						periodId.setDisabled(true);
						courseId.setDisabled(true);
						courseVariant.setDisabled(true);
						studentId.setDisabled(true);
						filterForm.reset();
						programId.getStore().getProxy().extraParams={
							academyLocationIds : academyLocationIds,
							whetherMarksheet:false
						};
						programId.getStore().load();
					}
				},
				'studentlevelremarkreportfilter':{
					afterrender:function(filter){	
						var form=filter.getForm();
						var userTypeField=form.findField('userType');
						userTypeField.getStore().load({
							callback: function(records, operation, success) {
								if (success) {
									Ext.each(records, function(value) {
										if(value.data.code=="CLASS_TEACHER"){
											userTypeField.setValue(value.data.id);
										}
									});
								}
							}
						});
					}
				},
				'studentlevelremarkreportfilter customcombobox#academicTerm' :{
					select:function(obj,rec){
						var $this = this;
						var data=rec[0].data.id;
						var filterForm=obj.up('form').getForm();
						var programField=filterForm.findField('programId');
						var evaluationPlan = filterForm.findField('evaluationPlan');
						var batchField=filterForm.findField('batchId');
						var period = filterForm.findField('periodId');
						var section = filterForm.findField('sectionId');
						var evaluationLevel = filterForm.findField('evaluationLevel');
						var evalLevelName = filterForm.findField('evalLevelName');
						var academyLocationIds =this.getAcademyLocationIds();
						var studentIdName =filterForm.findField('studentIdName');
	    		    		
						
						programField.reset();
						programField.getStore().getProxy().extraParams = {
							academicTermId:data,
							academyLocationIds:academyLocationIds,
						};
						programField.enable()
						programField.getStore().load();
						batchField.reset();
						batchField.disable();
						period.reset();
						period.disable();
						section.reset();
						section.disable();
						evaluationPlan.reset();
						evaluationPlan.disable()
						evaluationLevel.reset();
						evaluationLevel.disable();
						evalLevelName.reset();
						evalLevelName.disable();
						studentIdName.reset();
						studentIdName.disable();
					}
				},
				'studentlevelremarkreportfilter customcombobox#programItemId':{
					select:function(obj,rec){
						var $this = this;
						var data=rec[0].data.id;
						var filterForm=obj.up('form').getForm();
						var batchField=filterForm.findField('batchId');
						var period = filterForm.findField('periodId');
						var section = filterForm.findField('sectionId');
						var academicTermField = filterForm.findField('academicTerm');
						var evaluationPlan=filterForm.findField('evaluationPlan');
    		    		var evaluationLevel =filterForm.findField('evaluationLevel');
    		    		var evalLevelName =filterForm.findField('evalLevelName');
    		    		var studentIdName =filterForm.findField('studentIdName');
						
						period.disable();
						section.disable();						
						batchField.enable();
						evaluationPlan.disable();
						evaluationLevel.disable();
						evalLevelName.disable();
						studentIdName.disable();
						
						batchField.reset();
						period.reset();
						section.reset();
						evaluationPlan.reset();
						evaluationLevel.reset();
						evalLevelName.reset();
						studentIdName.reset();
						batchField.getStore().getProxy().extraParams = {
							programId:data,
							academicTermId:academicTermField.getValue()
						};
						batchField.getStore().load();
						

					}
				},
				 'studentlevelremarkreportfilter customcombobox[itemId=batchItemId]':{
						select:function(obj,rec){
							var $this=this;
							var data=rec[0].data.id;
							var filterForm=obj.up('form').getForm();
							var periodField=filterForm.findField('periodId');
							var section = filterForm.findField('sectionId');
							var evaluationPlan=filterForm.findField('evaluationPlan');
	    		    		var evaluationLevel =filterForm.findField('evaluationLevel');
	    		    		var evalLevelName =filterForm.findField('evalLevelName');
	    		    		var studentIdName =filterForm.findField('studentIdName');
							
	    		    		section.disable();						
							evaluationPlan.disable();
							evaluationLevel.disable();
							evalLevelName.disable();							
							periodField.enable();
							studentIdName.disable();
							
							periodField.reset();
							section.reset();
							evaluationPlan.reset();
							evaluationLevel.reset();
							evalLevelName.reset();
							studentIdName.disable();
							studentIdName.reset();
							periodField.getStore().getProxy().extraParams = {
								id:data
		   					   };
							periodField.getStore().load();
					    }
					},
     		     'studentlevelremarkreportfilter customcombobox[itemId=periodItemId]':{
     		    	 select:function(obj,rec){
     		    		 var $this=this;
     		    		 var data=rec[0].data.id;
     		    		 var filterForm=obj.up('form').getForm();
     		    		 var sectionField=filterForm.findField('sectionId');
     		    		 var academicTerm=filterForm.findField('academicTerm');
     		    		 var evaluationPlan=filterForm.findField('evaluationPlan');
     		    		 var evaluationLevel =filterForm.findField('evaluationLevel');
     		    		 var evalLevelName =filterForm.findField('evalLevelName');
     		    		 var studentIdName =filterForm.findField('studentIdName');
     		    		 var academyLocationIds =this.getAcademyLocationIds();
						
     		    		     evaluationPlan.enable();
     		    		     evaluationPlan.reset();
     		    		     evaluationLevel.reset();
     		    		     evaluationLevel.disable();
     		    		     evalLevelName.reset();
     		    		     evalLevelName.disable();
     		    		     studentIdName.disable();

     		    		 sectionField.enable();
     		    		 sectionField.reset();
     		    		 studentIdName.reset();

     		    		 sectionField.getStore().getProxy().extraParams = {
     		    			 periodId: data
     		    		 };
     		    		sectionField.getStore().load()
     		    		evaluationPlan.getStore().getProxy().extraParams = {
     		    			 periodId: data,
     		    			 academicTermId:academicTerm.getValue(),
     		    			 evaluationPlanType :"ACADEMICS",
     		    			 academyLocationIds:academyLocationIds
     		    		 };
     		    		evaluationPlan.getStore().load()
     		    	 }
     		     },
     		    'studentlevelremarkreportfilter customcombobox[itemId=evaluationPlanItemId]':{
    		    	 select:function(obj,rec){
    		    		 var $this=this;
    		    		 var data=rec[0].data.id;
    		    		 var filterForm=obj.up('form').getForm();
    		    		 var evaluationPlan=filterForm.findField('evaluationPlan');
    		    		 var evaluationLevel = filterForm.findField('evaluationLevel');
    		    		 var evalLevelName =filterForm.findField('evalLevelName');
    		    		 var studentIdName =filterForm.findField('studentIdName');
    		    		 var periodField=filterForm.findField('periodId');
							
    		    		 evalLevelName.reset();
    		    		 evaluationLevel.enable();
    		    		 evalLevelName.disable();
    		    		 studentIdName.disable();
    		    		 studentIdName.reset();
    		    		 evaluationLevel.getStore().getProxy().extraParams = {
    		    			 evaluationPlanId: rec[0].data.id,
    		    			 periodId:periodField.getValue()
    		    		 };
    		    		 evaluationLevel.getStore().load()
    		    	 }
    		     },
    		     'studentlevelremarkreportfilter customcombobox[itemId=evaluationLevelItemId]':{
    		    	 select:function(obj,rec){
    		    		 var $this=this;
    		    		 var data=rec[0].data.id;
    		    		 var filterForm=obj.up('form').getForm();
    		    		 var evaluationPlan=filterForm.findField('evaluationPlan');
    		    		 var evaluationLevel = filterForm.findField('evaluationLevel');
    		    		 var evalLevelName =filterForm.findField('evalLevelName');
    		    		 var studentIdName =filterForm.findField('studentIdName');
    		    		 var periodField=filterForm.findField('periodId');
    		    		 evalLevelName.enable();
    		    		 studentIdName.disable();
    		    		 studentIdName.reset();
    		    		 evalLevelName.getStore().getProxy().extraParams = {
    		    			 evaluationPlanId: evaluationPlan.getValue(),
    		    			 evaluationLevel:rec[0].data.id,
    		    			 periodId:periodField.getValue()
    		    		 };
    		    		 evalLevelName.getStore().load()
    		    	 }
    		     },
    		     'studentlevelremarkreportfilter customcombobox[itemId=evaluationLevelNameItemId]':{
    		    	 select:function(obj,rec){
    		    		 var $this=this;
    		    		 var data=rec[0].data.id;
    		    		 var filterForm=obj.up('form').getForm();
    		    		 var evaluationPlan=filterForm.findField('evaluationPlan');
    		    		 var evaluationLevel = filterForm.findField('evaluationLevel');
    		    		 var evalLevelName =filterForm.findField('evalLevelName');
    		    		 var studentIdName =filterForm.findField('studentIdName');
    		    		 var academyLocationIds =this.getAcademyLocationIds();
 						
    		    		 studentIdName.enable();
    		    		 studentIdName.reset();
    		    		 
    		    		 var levelValue =evaluationLevel.getValue();
    		    		 if(levelValue == "EVALUATION_PLAN"){
    		    			 studentIdName.getStore().getProxy().extraParams = {
        		    			 evaluationPlanId: evalLevelName.getValue(),
        		    			 academyLocationIds:academyLocationIds
        		    			 
        		    		 };
    		    		 }
    		    		 if(levelValue == "EVALUATION_TYPE"){
    		    			 studentIdName.getStore().getProxy().extraParams = {
        		    			
        		    			 evaluationPlanLevelOneId:evalLevelName.getValue(),
        		    			 academyLocationIds:academyLocationIds
        		    		 };
    		    		 }
    		    		 if(levelValue == "EVALUATION_SUB_TYPE"){
    		    			 studentIdName.getStore().getProxy().extraParams = {
        		    			
    		    				 evaluationPlanLevelTwoId:evalLevelName.getValue(),
    		    				 academyLocationIds:academyLocationIds
        		    		 };
    		    		 }
    		    		 if(levelValue == "EVALUATION_METHOD"){
    		    			 studentIdName.getStore().getProxy().extraParams = {
        		    			
    		    				 evaluationSequenceId:evalLevelName.getValue(),
    		    				 academyLocationIds:academyLocationIds
        		    		 };
    		    		 }
    		    		
    		    		 studentIdName.getStore().load()
    		    	 }
    		     },
    		     'studentlevelremarkreportfilter button#resetBtn':{
    		    	 click:function(btn){
    		    		 
    		    		 var filterForm=btn.up('form').getForm();
    		    		 filterForm.reset();
    		    		 
    		    		var programField=filterForm.findField('programId');
 						var evaluationPlan = filterForm.findField('evaluationPlan');
 						var batchField=filterForm.findField('batchId');
 						var period = filterForm.findField('periodId');
 						var section = filterForm.findField('sectionId');
 						var evaluationLevel = filterForm.findField('evaluationLevel');
 						var evalLevelName = filterForm.findField('evalLevelName');
 						var academyLocationIds =this.getAcademyLocationIds();
 						var studentIdName =filterForm.findField('studentIdName');
 						var userTypeField=filterForm.findField('userType');
						userTypeField.getStore().load({
							callback: function(records, operation, success) {
								if (success) {
									Ext.each(records, function(value) {
										if(value.data.code=="CLASS_TEACHER"){
											userTypeField.setValue(value.data.id);
										}
									});
								}
							}
						});
 						
 				
						programField.disable();
						batchField.disable();
						period.disable();
						section.disable();
						evaluationPlan.disable()
						evaluationLevel.disable();
						evalLevelName.disable();
						studentIdName.disable();
 						
    		    	 }
    		     },
    		     'studentlevelremarkreportfilter button#searchBtn':{
    		    	 click:function(btn){
    		    		var filterForm=btn.up('form').getForm();
    		    		var grid =this.getStudentlevelremarkreportgrid();
    		    		var programField=filterForm.findField('programId');
 						var evaluationPlan = filterForm.findField('evaluationPlan');
 						var batchField=filterForm.findField('batchId');
 						var period = filterForm.findField('periodId');
 						var section = filterForm.findField('sectionId');
 						var evaluationLevel = filterForm.findField('evaluationLevel');
 						var evalLevelName = filterForm.findField('evalLevelName');
 						var academyLocationIds =this.getAcademyLocationIds();
 						var studentIdName =filterForm.findField('studentIdName');
 						var userType = filterForm.findField('userType');
 					    var admissionId = studentIdName.getValue()
 						
 						grid.getStore().getProxy().extraParams ={
 							academyLocationId: academyLocationIds,
 							programId: programField.getValue(),
 							batchId: batchField.getValue(),
 							periodId: period.getValue(),
 							sectionIds:section.getValue() ,
 							levelName: evaluationLevel.getValue(),
 							levelValue: evalLevelName.getRawValue(),
 							evaluationPlanId: evaluationPlan.getValue(),
 							userTypeId: userType.getValue(),
 							whetherReport :true,
 							admissionId: admissionId
 						};
 						this.resetPageSetting(grid.getStore(), grid);
 						grid.getStore().load();
 						grid.config.searchFilterForm =btn.up('form');
     		    		  
    		    	 }
    		     },
    		     'studentlevelremarkreportgrid':{
    		    	 afterrender :function(grid){
    		    		 var this$ = this;
    		    		 setTimeout(function(){
    		    			 this$.addDataGridConfigButton(grid,this$.getSTUDENT_LEVEL_REMARK_REPORT_PERMISSIONS());    	    		    	 
    		    		 },500);
    		    	}
    		     },
				'examinationresultreportfilter':{
					afterrender:function(form){
						var programId = form.down('#programIdItemId');
						if(portalId == "2"){
							var academyLocationIds = this.getCurrentAcademyLocation();
							var facultyId  = this.getCurrentlyLoggedInUser().id
							programId.getStore().getProxy().extraParams = {
								academyLocationIds : academyLocationIds,
								whetherMarksheet:true,
								facultyId:facultyId
							}
						}
						if(portalId == "1"){
							var academyLocationIds =this.getAcademyLocationIds();
							programId.getStore().getProxy().extraParams = {
								academyLocationIds : academyLocationIds,
								whetherMarksheet:true,
								
							}
						}
						
						programId.getStore().load();
						}
					},
					'examinationresultreportfilter customcombobox[itemId=programIdItemId]':{
						select:function(programCombo,programRecord){
							var filterForm =this.getExaminationresultreportfilter();
							var form = filterForm.getForm(); 
							var batchField =form.findField('batchId');
							var periodField =form.findField('periodId');
							var studentField = form.findField('studentId');
							var courseField = form.findField('courseId');
							var courseVariant =form.findField('courseVariant');
							var studentStatus =form.findField('studentStatus');
							

							batchField.enable();
							periodField.disable();
							studentField.disable();
							courseField.disable();
							courseVariant.disable();

							batchField.reset();
							periodField.reset();
							studentField.reset();
							courseField.reset();
							courseVariant.reset();
							studentStatus.reset();
							batchField.getStore().getProxy().extraParams={
								programId: programCombo.getValue(),
								whetherMarksheet:false
							};
							batchField.getStore().load({
								callback:function(batchRecord){
									if(batchRecord.length == 1){
										batchField.setValue(batchRecord[0].data.id)
										periodField.enable();
										periodField.getStore().getProxy().extraParams={
											programId: programCombo.getValue(),
											batchId:batchRecord[0].data.id,
											whetherMarksheet:false
										};

										periodField.getStore().load({
											callback:function(periodRecord){
												if(periodRecord.length == 1){
													periodField.setValue(periodRecord[0].data.id)
													studentField.enable();
													studentField.getStore().getProxy().extraParams={
														periodId:periodRecord[0].data.id
													};

													studentField.getStore().load({
														callback:function(studentRecord){
															if(studentRecord.length ==1){
																studentField.setValue(studentRecord[0].data.id);
																studentStatus.getStore().load({
																	callback:function(){
																		studentStatus.setValue(studentRecord[0].data.activeStatus);
																	}
																})

															}
														}
													});
													courseField.enable();
													courseField.getStore().getProxy().extraParams={
														periodId:periodRecord[0].data.id
													};

													courseField.getStore().load({
														callback:function(courseRecord){
															if(courseRecord.length ==1){
																courseField.setValue(courseRecord[0].data.id);
																courseVariant.enable();
																courseVariant.getStore().getProxy().extraParams={
																	courseId:courseRecord[0].data.id,
																	periodId:periodRecord[0].data.id
																};
																courseVariant.getStore().load();
															}
														}
													});
												}
											}
										});

									}
								}
							});
						}
					},
					
					'examinationresultreportfilter customcombobox[itemId=batchIdItemId]':{
						select:function(batchCombo,batchRecord){
							var filterForm =this.getExaminationresultreportfilter();
							var form = filterForm.getForm(); 
							var periodField =form.findField('periodId');
							var studentField = form.findField('studentId');
							var courseField = form.findField('courseId');
							var courseVariant =form.findField('courseVariant');
							var studentStatus = form.findField('studentStatus');
							
							studentField.disable();
							courseField.disable();
							courseVariant.disable();

							periodField.reset();
							studentField.reset();
							courseField.reset();
							courseVariant.reset();
							studentStatus.reset();

							periodField.enable();
							periodField.getStore().getProxy().extraParams={
								batchId:batchRecord[0].data.id,
								whetherMarksheet:false
							};

							periodField.getStore().load({
								callback:function(periodRecord){
									if(periodRecord.length == 1){
										periodField.setValue(periodRecord[0].data.id)
										studentField.enable();
										studentField.getStore().getProxy().extraParams={
											periodId:periodRecord[0].data.id
										};

										studentField.getStore().load({
											callback:function(studentRecord){
												if(studentRecord.length ==1){
													studentField.setValue(studentRecord[0].data.id);
													studentStatus.getStore().load({
														callback:function(){
															studentStatus.setValue(studentRecord[0].data.activeStatus);
														}
													})

												}
											}
										});
										courseField.enable();
										courseField.getStore().getProxy().extraParams={
											periodId:periodRecord[0].data.id
										};

										courseField.getStore().load({
											callback:function(courseRecord){
												if(courseRecord.length ==1){
													courseField.setValue(courseRecord[0].data.id);
													courseVariant.enable();
													courseVariant.getStore().getProxy().extraParams={
														courseId:courseRecord[0].data.id,
														periodId:periodRecord[0].data.id
													};
													courseVariant.getStore().load();
												}
											}
										});
									}
								}

							});
						}
					},
					'examinationresultreportfilter customcombobox[itemId=periodIdItemId]':{
						select:function(periodCombo,periodRecord){
							var filterForm =this.getExaminationresultreportfilter();
							var form = filterForm.getForm(); 
							var studentField = form.findField('studentId');
							var courseField = form.findField('courseId');
							var courseVariant =form.findField('courseVariant');
							var studentStatus = form.findField('studentStatus');
							studentField.enable();
							courseField.enable();
							courseVariant.disable();

							studentField.reset();
							courseField.reset();
							courseVariant.reset();
							studentStatus.reset();

							studentField.enable();
							studentField.getStore().getProxy().extraParams={
								periodId:periodRecord[0].data.id
							};

							studentField.getStore().load({
								callback:function(studentRecord){
									if(studentRecord.length ==1){
										studentField.setValue(studentRecord[0].data.id);
										studentStatus.getStore().load({
											callback:function(){
												studentStatus.setValue(studentRecord[0].data.activeStatus);
											}
										})

									}
								}
							});
							courseField.enable();
							courseField.getStore().getProxy().extraParams={
								periodId:periodRecord[0].data.id
							};

							courseField.getStore().load({
								callback:function(courseRecord){
									if(courseRecord.length ==1){
										courseField.setValue(courseRecord[0].data.id);
										courseVariant.enable();
										courseVariant.getStore().getProxy().extraParams={
											courseId:courseRecord[0].data.id,
											periodId:periodRecord[0].data.id
										};
										courseVariant.getStore().load();
									}
								}
							});


						}
					},
					'examinationresultreportfilter customcombobox[itemId=courseItemId]':{
						select:function(courseCombo,courseRecord){
							var filterForm =this.getExaminationresultreportfilter();
							var form = filterForm.getForm(); 
							var courseVariantField = form.findField('courseVariant');
							var studentField =  form.findField('studentId');
							var periodField =  form.findField('periodId');

							courseVariantField.enable();

							courseVariantField.reset();

							courseVariantField.getStore().getProxy().extraParams={
								admissionId:studentField.getValue(),
								courseId:courseRecord[0].data.id,
								periodId:periodField.getValue()
							};
							courseVariantField.getStore().load({
								callback:function(courseVariantRecord){
									if(courseVariantRecord.length ==1){
										courseVariantField.setValue(courseVariantRecord[0].data.id);


									}
								}
							});


						}
					},
					'examinationresultreportfilter customcombobox[itemId=studentItemId]':{
						select:function(studentCombo,studentRecord){
							var filterForm =this.getExaminationresultreportfilter();
							var form = filterForm.getForm(); 
							var studentStatus = form.findField('studentStatus');
							studentStatus.reset();
							studentStatus.getStore().load({
								callback:function(){
									studentStatus.setValue(studentRecord[0].data.activeStatus)
								}
							});
							

						}
					},
					'examinationresultreportfilter button[itemId=searchBtn]':{
						click:function(obj){
							var form =obj.up('form');
							var filterForm=obj.up('form').getForm();
							var formValues =filterForm.getValues()
							var grid = this.getExaminationresultreportgrid();
							grid.config.searchFilterForm =form;
							grid.getStore().getProxy().extraParams = {
								batchId:formValues.batchId,
								periodId:formValues.periodId,
								courseVariantId:formValues.courseVariant,
								courseId:formValues.courseId,
								admissionId:formValues.studentId,
								status: formValues.studentStatus
							}
							this.resetPageSetting(grid.getStore(), grid);
							grid.getStore().load();
						}
					},
					'examinationresultreportfilter button[itemId=resetBtn]':{
						click:function(obj){
							var filterForm=obj.up('form').getForm();
							var programId =filterForm.findField('programId')
							var batchId =filterForm.findField('batchId');
							var periodId =filterForm.findField('periodId');
							var courseId =filterForm.findField('courseId');
							var courseVariant =filterForm.findField('courseVariant');
							var studentId =filterForm.findField('studentId');
							
							batchId.setDisabled(true);
							periodId.setDisabled(true);
							courseId.setDisabled(true);
							courseVariant.setDisabled(true);
							studentId.setDisabled(true);
							filterForm.reset();
							if(portalId == "2"){
								var academyLocationIds = this.getCurrentAcademyLocation()
								var facultyId  = this.getCurrentlyLoggedInUser().id
								programId.getStore().getProxy().extraParams = {
									academyLocationIds : academyLocationIds,
									whetherMarksheet:true,
									facultyId:facultyId
								}
							}
							if(portalId == "1"){
								var academyLocationIds =this.getAcademyLocationIds();
								programId.getStore().getProxy().extraParams={
									academyLocationIds : academyLocationIds,
									whetherMarksheet:true
								};

							}

							programId.getStore().load();
						}
					},
					'examinationresultreportgrid':{
						afterrender:function(grid){
							var me=this;
							setTimeout(function(){
								if(portalId == "1"){
									var permissionMap = me.getEXAMINATION_RESULT_REPORTS_PERMISSIONS()
								}
								if(portalId == "2"){
									var permissionMap = me.getEXAMINATION_RESULT_REPORTS_FACULTY_PERMISSIONS()
								}
			    					me.addDataGridConfigButton(grid,permissionMap);
			    				},1500);
						}
					}
			});
		},


});