/**
 * @author Raghavendra.Soni
 * 
 */
var currentEditRecord = null;
Ext.define('Academia.controller.examinationcenters.studentportal.SPStudentAssessmentReportController', {
	extend: 'Academia.controller.base.BaseController',
	models : [],
	stores : [
		'servicerequest.placementrequest.PlacementPrograms',
		'common.CurrentBatchStore',
		'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'course.AssignedPeriodCoursesFacultyStore',
		'examinationcenters.remark.CourseEvaluationRemark',
		'examinationcenters.studentportal.SPStudentAssessmentReportGridStore',
		'examinationcenters.manageEvaluation.EvaluationEventByEvalPlan',
		'examinationcenters.reports.anonymousreportfilter.AnonymousEventStore',
		'examinationcenters.assessmentEvent.StudentAssessmentLevelListStore',
		'setup.templatemapping.TemplateNameListFacultyByCode',
		'examinationcenters.assessmentEvent.StudentAssessmentLevelNameListStore',
		'examinationcenters.reports.ExaminationReportCourseUpdatedStore',
		'examinationcenters.remark.CourseEvaluationRemarkForSP'      
		],
	views : [
		'studentPortal.SPStudentAssessmentReportStructure',
		'studentPortal.SPStudentAssessmentReportFilter',
		'studentPortal.SPStudentAssessmentReportGrid',
		'studentPortal.SPStudentAssessmentCommentWindow',
		'examinationcenters.reports.StudentAssessmentReportWin'
		],
	config:{
		STUDENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES'),
		PARENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES')
	},           
	refs : [
		{
    	   ref: 'contentPanel',
    	   selector: 'contentpanel'
       },{
    	   ref:'spstudentassessmentreportstructure',
    	   selector:'spstudentassessmentreportstructure'
       },{
    	   ref:'spstudentassessmentreportfilter',
    	   selector:'spstudentassessmentreportfilter'
       },{
    	   ref:'spstudentassessmentreportgrid',
    	   selector: 'spstudentassessmentreportgrid'
       },{
    	   ref:'spstudentassessmentcommentwindow',
    	   selector: 'spstudentassessmentcommentwindow'
       },{
    	   ref:'studentassessmentreportwin',
    	   selector: 'studentassessmentreportwin'
       }
    ],
    init : function() {
    	this.control({
    		'spstudentassessmentreportgrid':{
    			headerclick: function( ct, column, e, t, eOpts ){
 				   var me = this;
 				   var headerClick = true;
 				   if(e.target.type=="checkbox"){
 					   var nodes = [];
 					   try{
 						   var nodes = ct.grid.getRootNode().childNodes;
 						   Ext.each(nodes, function(currentNode){
 							   if(currentNode.hasChildNodes()){
 								   currentNode.set('checked', t.checked);
 								   currentNode.cascadeBy(function(node) {
         							   node.set('checked', t.checked);
         						   });
         					   }
         					   me.selectParentNodesTreePanelSP(currentNode, t.checked, headerClick);
 						   })
 					   }
 					   catch(e){
 						   console.log('');
 					   }
 				   }
 			   },
 			   checkchange: function(node, checked, eOpts) {
 				   var me = this;
 				   var headerClick = false;
					   if(node.hasChildNodes()){
						   node.set('checked', checked);
						   node.cascadeBy(function(node) {
							   node.set('checked', checked);
						   });
					   }
					   me.selectParentNodesTreePanelSP(node, checked, headerClick);
 			   },
 			   afterrender: function(tree, eOpts) {
 				  
 				   if(this.getCurrentLoggedPortalId()==7){
 					   this.visibleSPExamStudentAssessmentReportPivileges(tree,this.getPARENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES());
 				   }else{
 					   this.visibleSPExamStudentAssessmentReportPivileges(tree,this.getSTUDENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES());
 				   }
 			   },
 				beforerender: function(grid) {
 				//var grid =	this.getSpstudentassessmentreportgrid();
 					Ext.Ajax.request({
 						type: 'rest',
 						url: SERVERURL.PATH_STUDENT_ASSESSMENT_REPORT_FIND_VISIBLITY,
// 						params: {
// 							academyLocatonId: academyLocationId
// 						},
 						method: 'GET',
 						success: function(response, action) {
 							var data = Ext.decode(response.responseText);
 							if (!isEmpty(data)) {
 								var gridStore = grid.getStore();
 								var gridCols = [{
 									header:  "<input type='checkbox'>",
 									width: 42,
 									hideable : false,
 									menuDisabled: true,
 									resizable: false,
 									sealed: true
 								},{
 							        xtype: 'treecolumn',
 							        text: getCommonTranslation('COURSE_CODE_NAME'),
 							        flex: .33,
 							        dataIndex: 'treeNode'
 							    }, {
 									header:  getExaminationTranslation('TEACHER_COMMENT'),
 									dataIndex: 'eventRemark',
 									flex:.1
 								}];
 								for (var i = 0; i < data.length; i++) {
 									switch (data[i].programShortName) {
 									case "Assessment Scheme":
 										if(data[i].requireacademicStanding == true){
 											gridCols.push({
 	 											header:  getExaminationTranslation('EVALUATION_PLAN'),
 	 											dataIndex: 'evaluationPlanName',
 	 											flex:.1
 	 										});
 										}
 									case "Student Comment":
 										if(data[i].requireacademicStanding == true){
 											gridCols.push({
 												header:  getExaminationTranslation('STUDENT_COMMENT'),
 			 									dataIndex: 'studentEventRemark',
 			 									flex:.1,
 			 									renderer: function(val,rec,record,rowIndex,colIndex,store,view){
 			 										if(record.isLeaf()){
 			 											if(isNullOrEmpty(val)){
 			 												val = "Add comment";
 			 											}
 			 											rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
 			 								    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
 			 											return "<a href='#'>"+val+"</a>";
 			 										}
 			 										return "";
 			 									}
 	 										});
 										}
 									
 										break;
 									case "Date submitted":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getCommonTranslation('DATE_SUBMITTED'),
 											dataIndex: 'conductedDate',
 											flex:.1
 										 });
 										}
 										break;
 									case "Marks obtained":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('RAW_SCORE'),
 											dataIndex: 'eventMarksObtained',
 											flex:.1
 										 });
 										}
 										break;
 									case "Max Marks":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('MAX_RAW_SCORE'),
 											dataIndex: 'eventTotalMarks',
 											flex:.1
 										 });
 										}
 										break;
 									case "Score (%)":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('SCORE_AS_A_PERCENTAGE'),
 											dataIndex: 'eventPercentageObtained',
 											flex:.1,
 											renderer:function(value,rec){
								            var checkPublishMarksOnSP=rec.record.data.eventMarksObtained;
									            if(isNullOrEmpty(checkPublishMarksOnSP)){
													return "";
												}
												return value;
											}
 										 });
 										}
 										break;
 									case "Effective marks":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getCommonTranslation('EFFECTIVE_MARKS'),
 											dataIndex: 'effectiveMarks',
 											flex:.1
 									     });
 										}
 										break;
 									case "% Weight":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('PERCENTAGE_WEIGHT'),
 											dataIndex: 'eventWeightage',
 											flex:.1
 									    	});
 										}
 										break;
 									case "Weight Score":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header: getExaminationTranslation('WEIGHTED_SCORE_AS_A_PERCENTAGE'),
 											dataIndex: 'weigtageOfObtainedPercentage',
 											flex:.1
 										});
 										}
 										break;
 									case "Numerical Grade":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:   getExaminationTranslation('NUMERICAL_GRADE'),
 											dataIndex: 'numericalGrade',
 											flex:.1
 									    	});
 										}
 										break;
 									case "Weight Grade":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('WEIGHTED_GRADE'),
 											dataIndex: 'weightedGrade',
 											flex:.1
 										});
 										}
 										break;
 									case "Assessment code":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('ASSESSMENT_CODE'),
 											dataIndex: 'eventGradeObtained',
 											flex:.1
 										 });
 										}
 										break;
 									case "Report status":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('REPORT_STATUS'),
 											dataIndex: 'whetherPublish',
 											flex:.1,
 											renderer: function(val, rec) {
											 //return statusRender(value);
								            /*if(isNullOrEmpty(value) || value == true) {
								                return "Published";
								            } else{
								                return "Not Published";
								            }*/
													if (rec.record.isLeaf()) {
														if (rec.record.get('status') == "Hold For Student") {
															return getCommonTranslation('HOLD_APPLIED');
														} else

															if (isNullOrEmpty(val) || val == false) {
																return "Not Published";
															}
														return "Published";
													}
													return "";
												}
											});
											}
 										break;
 									case "Published Date":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('PUBLISHED_DATE'),
 											dataIndex: 'publishDate',
 											flex:.1
 										});
 										}
 										break;
 									case "Program":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('PROGRAM_NAME'),
 											dataIndex: 'program',
 											flex:.1
 										});
 										}
 										break;
 									case "Batch":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getProgramandcourseTranslation('BATCH'),
 											dataIndex: 'batchName',
 											flex:.1
 										});
 										}
 										break;
 									case "Period":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getProgramandcourseTranslation('PERIOD'),
 											dataIndex: 'periodName',
 											flex:.1
 										});
 										}
 										break;
 									case "Academy Location":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('ACADEMY_LOCATION'),
 											dataIndex: 'academyLocationName',
 											flex:.1
 										});
 										}
 										break;
 									case "Course variant":
 										if(data[i].requireacademicStanding == true){
 										gridCols.push({
 											header:  getExaminationTranslation('COURSE_VARIANT'),
 											dataIndex: 'courseVariantName',
 											flex:.1
 										});
 										}
 										break;
 									}
 								}
 								grid.reconfigure(gridStore, gridCols);
 							}
 						}
 					});
            	},
			   beforedestroy: function(tree, eOpts){
				   tree.getStore().getRootNode().removeAll();
			   },
			   cellclick: function(tree, td, cellIndex, record, tr, rowIndex, e, eOpts){
				   if (e.target.tagName == 'A') {
					   this.openStudentCommentWindow(record,rowIndex);
				   }
			   }
    		},
    		
    		'spstudentassessmentreportgrid button[itemId=saveSPStudentAssessmentReportItemId]':{
    			click:function(btn){
    				var me = this;
    				var tree = btn.up('treepanel');
    				var checkedRecords = tree.getChecked().length;
    				if(checkedRecords>0){
        				var examreportcommoncontroller = Academia.app.getController('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController');
        				var checkedRecords = examreportcommoncontroller.getGridCheckedSPChildren(tree);
        				 var formValues = Ext.encode(checkedRecords.map);
        				var examResultIdsArray = checkedRecords.examResultIds;
        				var studentCommentsArray = checkedRecords.studentEventRemark;
        				var isSubmitted = false;
        				
        				Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
    		        	
        				Ext.Ajax.request({
   	  		   	 		 type: 'rest',
   	  		   	 		 jsonData:formValues,
   	  		   	 		 url: SERVERURL.PATH_UPDATE_SP_STUDENT_ASSESSMENT_REPORT,
   	  		   	 		 method: 'PUT',
   	  		   	 		 success: function(obj, action) {
   	  		   	 			 Ext.getBody().unmask();
   	  		   	 			 var grid = me.getSpstudentassessmentreportgrid();
   	  		   	 			 grid.store.load();
   	  		   	 			 me.uncheckSPGridHeader(grid);
   	  		   	 			 showSuccessMessage(getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'), getCommonTranslation('SUCCESS'));
   	  		   	 		 }
           		       });
        				
        				//---code for saving data here
    				}
    			}
    		},
    		
    		// Submit
    		'spstudentassessmentreportgrid button[itemId=submitSPStudentAssessmentReportItemId]':{
    			click:function(btn){
    				var me = this;
    				var tree = btn.up('treepanel');
    				var checkedRecords = tree.getChecked().length;
    				if(checkedRecords>0){
        				var examreportcommoncontroller = Academia.app.getController('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController');
        				var checkedRecords = examreportcommoncontroller.getGridCheckedSPChildren(tree);
        				 var formValues = Ext.encode(checkedRecords.map);
        				var examResultIdsArray = checkedRecords.examResultIds;
        				var studentCommentsArray = checkedRecords.studentEventRemark;
        				var isSubmitted = false;
        				
        				Ext.getBody().mask(getCommonTranslation('SUBMIT_FORM'), 'x-mask-loading');
    		        	
        				Ext.Ajax.request({
   	  		   	 		 type: 'rest',
   	  		   	 		 jsonData:formValues,
   	  		   	 		 url: SERVERURL.PATH_SUBMIT_STUDENT_ASSESSMENT_REPORT,
   	  		   	 		 method: 'PUT',
   	  		   	 		 success: function(obj, action) {
   	  		   	 			 Ext.getBody().unmask();
   	  		   	 			 var grid = me.getSpstudentassessmentreportgrid();
   	  		   	 			 grid.store.load();
   	  		   	 			 me.uncheckSPGridHeader(grid);
   	  		   	 			 showSuccessMessage(getExaminationTranslation('MARK_TO_GRADE'), getCommonTranslation('SUCCESS'));
   	  		   	 		 }
           		       });
    				}
    			}
    		},
    		
    		'spstudentassessmentreportgrid button[itemId=exportSPStudentAssessmentGradeReportItemId]' : {
    			click:function(obj){
    				var $this = this;
    				var controller = Academia.app.getController('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController');
    				var grid = $this.getSpstudentassessmentreportgrid();
    				var gridRecord = controller.getGridCheckedChildren(grid);
    				var form=$this.getSpstudentassessmentreportfilter().getForm();
    				var formValues=form.getValues();
    				var templateId = null;
    				var reportParams =new Object();
    				var reportTitle="";
    				var zipFileName = null;
    				var code = null;
    				var evaluationPlanLevelName=[];
    				var batchName =grid.items.items[0].getStore().data.items[0].firstChild.data.batchName;
    				 if(!isNullOrEmpty(formValues.evalLevelName) && formValues.evalLevelName!=""){
  					   for(var i=0;i<formValues.evalLevelName.length;i++){
  						   var item = formValues.evalLevelName[i];
    			 		   var value = (item && item.data && item.data.value != null) ? item.data.value : item;
  						   evaluationPlanLevelName.push(value);
  					   }
				   }
				     
    				if(gridRecord.admissionIds.length>0) {
    					var programGroupName=gridRecord.programGroupName[0];
    					var form=this.getSpstudentassessmentreportfilter();
    					var getForm=form.getForm();
    					var reprotTemplateField=getForm.findField('chooseSPAssessmentReportTemplateId');
    					var tempConfiguration=false;
    					var reprotTemplateFieldStore=reprotTemplateField.getStore();
    					reprotTemplateFieldStore.getProxy().extraParams={
    						reportType:'Student Assessment Reports'
    					};
    					reprotTemplateFieldStore.load({
    						callback:function(rec,success){
    							if(rec.length==0){
    								showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REPORT_TEMPLATE_IS_NOT_CONFIGURED'));
    								return false;
    							}else{
    								for(var i=0; i< rec.length;i++){
    									if(programGroupName=="Junior College" && rec[i].data.value=="SIS_ASSESSMENT_REPORT_JC1_JC2"){
    										code='SIS Assessment Report JC1-JC2'
    											reportParams.examResultIds=formValues.evalLevelName;
    										reportParams.zipFileName='SIS Assessment Report JC1-JC2';
    										reportParams.reportTemplateId=rec[i].data.id;
    										reportParams.evaluationLevelName=evaluationPlanLevelName.join();
    										var URL = SERVERURL.PATH_DOWNLOAD_ALL_EXCEL_ZIP;
    										$this.exportJRXMLReport(code, reportParams, code,'.vnd.ms-excel', URL);
    										tempConfiguration=false;
    										break;
    									} else if (programGroupName=="Primary" && rec[i].data.value=="SIS_ASSESSMENT_REPORT_P3_P6_PDF"){
    										
    										if (batchName.search("2018") != -1){
    											code='SIS Assessment Report P3-P6 PDF'
    											reportParams.reportTemplateId=rec[i].data.id;
    											
    										}else{
    											for(var j=0; j< rec.length;j++){
    												if(rec[j].data.value=="SIS_ASSESSMENT_REPORT_P3_P6_PDF_NEW"){
    													code='SIS Assessment Report P3-P6 PDF New'
    													reportParams.reportTemplateId=rec[j].data.id;
    												}
    											}
    										}
    										
    										reportParams.examResultIds=gridRecord.examResultIds.join();
    										reportParams.zipFileName='SIS Assessment Report P3-P6 PDF';
    										reportParams.evaluationLevelName=evaluationPlanLevelName.join();
    										//reportParams.reportTemplateId=rec[i].data.id;
    										var URL = SERVERURL.PATH_DOWNLOAD_ALL_PDF_ZIP;
    										$this.exportJRXMLReport(code, reportParams, code,'pdf', URL);
    										tempConfiguration=false;
    										break;
    									} else if (programGroupName=="Secondary" && rec[i].data.value=="SIS_ASSESSMENT_REPORT_S1_S4_PDF"|| rec[i].data.value=="SIS_ASSESSMENT_REPORT_S1_S4_PDF_NEW" || rec[i].data.value=="SIS_JC_IB_STUDENT_ASSESSMENT_REPORT_PDF_NEW")
    									{
    										if (batchName.search("2018") != -1){
    											code='SIS Assessment Report S1-S4 PDF'
    											reportParams.reportTemplateId=rec[i].data.id;
    										}else{
    											for(var j=0; j< rec.length;j++){
	    											if(rec[j].data.value=="SIS_ASSESSMENT_REPORT_S1_S4_PDF_NEW")
	    											{
	    													code='SIS Assessment Report S1-S4 PDF New'
	    													reportParams.reportTemplateId=rec[j].data.id;
													}
	    											if(rec[j].data.value=="SIS_ASSESSMENT_REPORT_S1_S4_PDF_NEW")
	    											{
	    													code='SIS JC IB Student Assessment Report'
	    													reportParams.reportTemplateId=rec[j].data.id;
													}
    											}
    											
    										}
    										reportParams.examResultIds=gridRecord.examResultIds.join();
    										reportParams.zipFileName='SIS Assessment Report S1-S4 PDF';
    										reportParams.evaluationLevelName=evaluationPlanLevelName.join();
    										//reportParams.reportTemplateId=rec[i].data.id;
    										var URL = SERVERURL.PATH_DOWNLOAD_ALL_PDF_ZIP;
    										$this.exportJRXMLReport(code, reportParams, code,'pdf', URL);
    										tempConfiguration=false;
    										break;
    									}else if(rec[i].data.value=="INTERIM_GRADE_REPORT_GLION") {
	                                              for(var j=0; j< rec.length;j++){
	    											if(rec[j].data.value=="INTERIM_GRADE_REPORT_GLION")
	    											{
	    													code='Sommet Interim Grade Report'
	    													reportParams.reportTemplateId=rec[j].data.id;
													}
													}
														reportParams.examResultIds=gridRecord.examResultIds.join();
    										reportParams.zipFileName='Sommet Interim Grade Report PDF';
    										reportParams.evaluationLevelName=evaluationPlanLevelName.join();
    										//reportParams.reportTemplateId=rec[i].data.id;
    										var URL = SERVERURL.PATH_DOWNLOAD_ALL_PDF_ZIP;
    										$this.exportJRXMLReport(code, reportParams, code,'pdf', URL);
    										tempConfiguration=false;
    										break;
	
}   									
    
    									else{
    										tempConfiguration=true;
    									}
    								}
    							}
    							if(tempConfiguration){
    	    						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('REPORT_TEMPLATE_IS_NOT_CONFIGURED'));
    	    						return false;
    	    					}
    						}
    					});

    					

    				} else {
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				}
    			}
 		   },
 		  'spstudentassessmentreportgrid button[itemId=exportSPStudentAssessmentReportItemId]' : {
 			  click:function(obj){
 				  var $this = this;
 				  var controller = Academia.app.getController('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController');
 				  var grid = $this.getSpstudentassessmentreportgrid();
 				  var gridRecord = controller.getGridCheckedChildren(grid);
 				  if(gridRecord.admissionIds.length==0){
 					  var allGridRecord = controller.getGridAllChildren(grid);
 					  var examResultIds = allGridRecord.examResultIds;
 					  var admissionIds = allGridRecord.admissionIds;
 				  }else{
 					  var checkedChildren = controller.getGridCheckedChildren(grid);
 					  var examResultIds = checkedChildren.examResultIds;
 					  var admissionIds = checkedChildren.admissionIds;
 				  }
 				  var reportParams =new Object();
 				  var reportTitle="";
 				  var code = "SIS_STUDENT_ASSESSMENT_REPORT";
 				  reportParams.examResultIds=examResultIds.join();
 				  reportParams.admissionIds=admissionIds.join();
 				  var URL = SERVERURL.EXPORT_STUDENT_ASSESSMENT_REPORT;
 				  $this.exportJRXMLReport(code, reportParams, code,'.vnd.ms-excel', URL);
 			  }
 		   },
 		   
 		   'studentassessmentreportwin[itemId=studentParentPortalWin] button[itemId=submitBtn]':{
 			   click:function(obj){
 				   var $this = this;
 				   var controller = Academia.app.getController('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController');
 				   var grid = $this.getSpstudentassessmentreportgrid();
	        		   var gridRecord=grid.getChecked();
	        		   var checkedChildren = controller.getGridCheckedChildren(grid);
 				   // code to identify jasper
	        		   var examResultIds = checkedChildren.examResultIds;
	        		   
	        		   var studentassessmentreportwin = $this.getStudentassessmentreportwin();
 				   var reportType = studentassessmentreportwin.down('#chooseHallticketTemplate');
 				   var templateId = reportType.getValue();//"CourseWiseMarksheetReport"; //Enum value put here
 				   var reportParams =new Object();
 				  
 				   var reportTitle="";
 				   
 				   var zipFileName = reportType.getRawValue();
 				   var code = reportType.getRawValue();

             	   reportParams.examResultIds=examResultIds.join();
             	   reportParams.zipFileName=zipFileName;
             	   reportParams.reportTemplateId=templateId;
 				   var URL = SERVERURL.PATH_DOWNLOAD_ALL_EXCEL_ZIP;
 				   studentassessmentreportwin.close();
 				   $this.exportJRXMLReport(code, reportParams, code,'.vnd.ms-excel', URL);

 			   }
 		   },
    		
    		'spstudentassessmentreportfilter':{
    	    	render : function(form){
    	    		var $this = this;
    	    		if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
    	    			$this.spStudentAssessmentReportFilterRenderAndReset();
    	    		}
    	    		
    	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
 				   var whetherSchool = alinfomodel.get('wheatherSchool');
 				   if(whetherSchool) {
 					   form.down("#periodId").setVisible(false);
 				   } else {
 					   form.down("#periodId").setVisible(true);
 				   }
    	    	}
    		},
    		
    		 'spstudentassessmentreportfilter customcombobox[itemId=programId]':{
    	  			select:function(obj,rec){
						var form=obj.up('form').getForm();
						 var courseField=form.findField("course");
						 var batchCombo = form.findField("batch");
						 var programField=form.findField('program');
	    	    		 var studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id;
	    	    		 var admissionId=this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	    	    		  var evaluationLevel = form.findField("evalLevelName");
	    	    		
						var evaluationLevelType = "EVALUATION_TYPE";
						batchCombo.reset();
	    	    		 evaluationLevel.reset();
	    	    		 var evaluationLevelType = "EVALUATION_TYPE";
						 batchCombo.getStore().getProxy().extraParams = { 
							   programId:programField.getValue(),
							   studentId:studentId,
							   onlyCurrentRecord:false
						 };
						batchCombo.getStore().load({
							callback : function(records, success){
								if(success){
									var recordId;
									if (records && records.length > 0 && records[0] && records[0].data) {
									       recordId = records[0].data.id;
									   }
									form.findField("batch").setValue(recordId);
									var periodField=form.findField('period');
									periodField.setDisabled(false);
									var batchId=recordId; 
									periodField.getStore().getProxy().extraParams = {
										id:batchId,										
										studentId:studentId,
										onlyCurrentRecords:false
									};
									periodField.getStore().load({
										callback : function(records, success){
   	    								if(success){
   	    									//form.findField("period").setValue(studentperiodId);
   	    									var periodId;
   	    									if(!isNullOrEmpty(records)&& records.length!=0){
   	    										periodId=records[0].data.id;
   	    									}
   	    									
										    var valueCheck="";						                				                                            
                                                
                                                    var url = SERVERURL.PATH_GET_AUTO_SELECT_ALL_LEVEL_VALUE;
                                                        Ext.Ajax.request({
                                                        type : 'rest',
                                                        url : url,                                                      
                                                        method : 'GET',
                                                        success : function(response) {
                                                               var jsonResponse = Ext.JSON.decode(response.responseText); 
                                                               valueCheck = jsonResponse[0] ? jsonResponse[0].value : "";
                                                           	 evaluationLevel.getStore().getProxy().extraParams={
			                					   programId: form.findField('evalLevelName').getValue(),  
			                					   batchId:batchCombo.getValue(),
			                					   periodId:periodId,//records[0].data.id,
			                					   evaluationLevel:evaluationLevelType,
			                					   isGroupBy:true,
			                					   isOtherEval:false
			                				   };
			                				   
			                				    evaluationLevel.getStore().load({
                                                                        callback:function(records){
                                                                            var levelIds=[];
                                                                            var localVar = "Yes";
                                                                            for (var i = 0; i < records.length; i++) {
                                                                                   if(valueCheck.toLowerCase() === localVar.toLowerCase()){
                                                                                        levelIds.push(records[i].data.id);
                                                                                    }
                                                                                
                                                                            }
                                                                            
                                                                            evaluationLevel.setValue(levelIds);
                                                                            
                                                                         }
                                                                     });
			                				   
			                				  // evaluationLevel.getStore().load();
			                				   evaluationLevel.setDisabled(false);
                                                        }
                                                    });  
   	    								}
										}
									});
									
									courseField.getStore().getProxy().extraParams = {
			    						programId:programField.getValue(),
			    						batchId:batchCombo.getValue(),
										studentId:studentId
			    					};
			    					courseField.getStore().load();
			    					 
								}
							}
						});
					
    	  			}
    		 }, 

           'spstudentassessmentreportfilter customcombobox[itemId=batchId]':{
    	  			select:function(obj,rec){
						var form=obj.up('form').getForm();
						 var courseField=form.findField("course");
						 var batchCombo = form.findField("batch");
						 var programField=form.findField('program');
	    	    		 var studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id;
	    	    		 var admissionId=this.getCurrentlyLoggedInUserInfoForPortal().admissionDetails[0].id;
	    	    		 var evaluationLevel = form.findField("evalLevelName");
	    	    		 evaluationLevel.reset();
	    	    		 var evaluationLevelType = "EVALUATION_TYPE";
						 batchCombo.getStore().getProxy().extraParams = { 
							   programId:programField.getValue(),
							   onlyCurrentRecord:false
						 };
						
									var periodField=form.findField('period');
									periodField.setDisabled(false);
									periodField.getStore().getProxy().extraParams = {
										id:batchCombo.getValue(),										
										studentId:studentId,
										onlyCurrentRecords:false
									};
									periodField.getStore().load({
										callback : function(records, success){
   	    								if(success){
   	    									//form.findField("period").setValue(studentperiodId);
   	    									var periodId;
   	    									if(!isNullOrEmpty(records)&& records.length!=0){
   	    										periodId=records[0].data.id;
   	    									}
   	    								
										    var valueCheck="";						                				                                            
                                                
                                                    var url = SERVERURL.PATH_GET_AUTO_SELECT_ALL_LEVEL_VALUE;
                                                        Ext.Ajax.request({
                                                        type : 'rest',
                                                        url : url,                                                      
                                                        method : 'GET',
                                                        success : function(response) {
                                                               var jsonResponse = Ext.JSON.decode(response.responseText); 
														valueCheck = jsonResponse[0] ? jsonResponse[0].value : "";
                                                           	 evaluationLevel.getStore().getProxy().extraParams={
			                					   programId: form.findField('evalLevelName').getValue(),  
			                					   batchId:batchCombo.getValue(),
			                					   periodId:periodId,
			                					   evaluationLevel:evaluationLevelType,
			                					   isGroupBy:true,
			                					   isOtherEval:false
			                				   };
			                				   
			                				    evaluationLevel.getStore().load({
                                                                        callback:function(records){
                                                                            var levelIds=[];
                                                                            var localVar = "Yes";
                                                                            for (var i = 0; i < records.length; i++) {
                                                                                   if(valueCheck.toLowerCase() === localVar.toLowerCase()){
                                                                                        levelIds.push(records[i].data.id);
                                                                                    }
                                                                                
                                                                            }
                                                                            
                                                                            evaluationLevel.setValue(levelIds);
                                                                            
                                                                         }
                                                                     });
			                				   
			                				  // evaluationLevel.getStore().load();
			                				   evaluationLevel.setDisabled(false);
                                                        }
                                                    });
   	    								}
										}
									});
								courseField.getStore().getProxy().extraParams = {
			    						programId:programField.getValue(),
			    						batchId:batchCombo.getValue(),
										studentId:studentId
			    					};
			    					courseField.getStore().load(); 
			    					 
							
					
    	  			}
    		 },

			'spstudentassessmentreportfilter customcombobox[itemId=evalLevelName]':{
 	  			select:function(obj,rec){
 	  				var form=obj.up('form').getForm();
 	  				var program=form.findField('program');
 	  				var batch = form.findField("batch");
 	  				var period = form.findField("period");
 	  				var evalLevelName=form.findField("evalLevelName");
 	  				var course=form.findField("course");
 	  				var courseVarient=form.findField("courseVarient");
 	  				var detailSequence =form.findField("detailSequenceId");
 	  				detailSequence.reset();
 	  				detailSequence.getStore().getProxy().extraParams = {
    					programId: program.getValue(),
    					batchId: batch.getValue(),
    					evaluationPlanId:evalLevelName.getValue(),
    					evaluationLevel: "EVALUATION_EVENT",
    					courseVariantId: courseVarient.getValue(),
    				};
 	  				detailSequence.getStore().load(); 
 	  				
 	  			}
    		 },
    		
			 'spstudentassessmentreportfilter multiselectcombofield[itemId=periodId]': {
			     change: function(periodCombo, newValue, oldValue) { 
					 var form = periodCombo.up('form').getForm(); 
			         var programField = form.findField('program');
			         var batchField = form.findField('batch');
			         var courseField = form.findField('course');
					 var selectedPeriodIds = [];
			         if (!isNullOrEmpty(newValue)) { // Check if anything is selected
			             if (Ext.isArray(newValue)) {
			                 for (var i = 0; i < newValue.length; i++) {
			                     if (Ext.isObject(newValue[i])) {
			                         selectedPeriodIds.push(newValue[i].get('id')); 
			                     } else {
			                         selectedPeriodIds.push(newValue[i]); 
			                     }
			                 }
			             } else { 
			                 selectedPeriodIds.push(newValue);
			             }
			         }
						
					 
			         courseField.enable();
			         courseField.reset();
					 var studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id;
					 courseField.getStore().getProxy().extraParams = {
						 programId: programField.getValue(),
						 batchId: batchField.getValue(),
						 periodIds: selectedPeriodIds.join(','),
						 studentId: studentId
					 };


					 courseField.getStore().load({
						 callback: function(loadedRecords, operation, success) {
							 if (success) {
								 var courseCodesToSelect = [];
								 if (!isNullOrEmpty(loadedRecords)) {
									 for (var i = 0; i < loadedRecords.length; i++) {
										 courseCodesToSelect.push(loadedRecords[i].data.code);
									 }
									 courseField.setValue(courseCodesToSelect);
								 }
							 }
						 }
					 });

					 var evaluationLevel = form.findField("evalLevelName");
					evaluationLevel.reset();
					 evaluationLevel.getStore().getProxy().extraParams = {
						 programId:programField.getValue(),
						 batchId: batchField.getValue(),
						 //  periodId: null, // for Student Portal changes V2D-514520
						 evaluationLevel: "EVALUATION_TYPE",
						 periodIds: selectedPeriodIds.join(','),
						 isGroupBy: true,
						 isOtherEval: false

					 };
					 evaluationLevel.getStore().load(); 


				 }
			 }, 
		   
			'spstudentassessmentreportfilter customcombobox[itemId=course_Id]':{
    			select:function(obj,rec){
    				var data=rec[0].data.courseId;
    				var form=obj.up('form').getForm();
   	    		 	var studentId=this.getCurrentlyLoggedInUserInfoForPortal().student.id;
    				var programField=form.findField('program');
    				var courseVarient=form.findField('courseVarient');
    				var detailSequence=form.findField('detailSequenceId');
    				courseVarient.reset();
    				detailSequence.reset();
    				courseVarient.enable();
    				courseVarient.getStore().getProxy().extraParams = {
    					//academyLocationId:studentprogramId,
    					courseId:data,
    					studentId:studentId
    				};
    				courseVarient.getStore().load();
    			}
    		},
 		   
    		'spstudentassessmentreportfilter customcombobox[itemId=courseVarient_Id]':{
    			select:function(obj,rec){
    				var data=rec[0].data.id;
    				var form=obj.up('form').getForm();
    				var program=form.findField('program');
    				var batch=form.findField('batch');
    				var periodField=form.findField('period');
    				var detailSequence=form.findField('detailSequenceId');
    				detailSequence.enable();
    				
    				var periodArray=[];
  					if(!isNullOrEmpty(periodField.getStore().data.items)){
  						for(var i=0;i<periodField.getStore().data.items.length;i++){
  							if(Ext.isObject(periodField.getStore().data.items[i])){
  								periodArray.push(periodField.getStore().data.items[i].get('id'));
  							}else{
  								periodArray.push(periodField.getStore().data.items);
  							}
  						}
  					}
    				detailSequence.reset();
    				detailSequence.enable();
    				detailSequence.getStore().getProxy().extraParams = {
    					programId: program.getValue(),
    					batchId: batch.getValue(),
    					//periodId:periodArray.join(),
    					courseVariantId: data,
    					//whetherMarksheet:true,
    					evaluationLevel: "EVALUATION_EVENT",
    				};
    				detailSequence.getStore().load();
    				
    			}
    		},
    		
    		'spstudentassessmentreportfilter button[itemId=resetBtn]':{
    			click:function(form){
    				var $this = this;
					
    				var form=this.getSpstudentassessmentreportfilter();
    				var grid = $this.getSpstudentassessmentreportgrid();
    				 var msg= grid.down('#progressionStatusMessage');
    				 msg.setVisible(true);
    				 msg.setValue('');
    				var getForm=form.getForm();
    				getForm.reset();
    				if(this.getCurrentLoggedPortalId()==3 || this.getCurrentLoggedPortalId()==7){
    					$this.spStudentAssessmentReportFilterRenderAndReset();
    	    		}
    	    		
    	    	   var alinfomodel = Academia.model.authentication.ALInfoModel;
 				   var whetherSchool = alinfomodel.get('wheatherSchool');
 				   if(whetherSchool) {
 					   form.down("#periodId").setVisible(false);
 				   } else {
 					   form.down("#periodId").setVisible(true);
 				   }
    			}
    		},
    		
    		'spstudentassessmentreportfilter button[itemId=searchBtn]':{
    			click:function(obj){
    				obj.setDisabled(true);
    				obj.up('form').collapse();
    				var $this=this;
    				var form=this.getSpstudentassessmentreportfilter().getForm();
    				var formValues=form.getValues();
    				var evaluationLevelType = "EVALUATION_TYPE";
    				//var programId=formValues.program;
    				//var batchId=formValues.batchId;
    				var course=formValues.course;
    				var courseVarient=formValues.courseVarient;
    				var detailSequenceId=formValues.detailSequenceId;
    				var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
    				var studentprogramId = studentPortalInfo.programBatchDetails.programId;
	    			var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
	    			var admissionId=studentPortalInfo.admissionDetails[0].id;
	    			var studentId=studentPortalInfo.student.id;
	    			var studentCode = studentPortalInfo.student.code;
	    			var periodIdValue = formValues.period;
	    			
	    			
	    			
	    			var batchId=null;
	    			 if (!isNullOrEmpty(formValues.batch)) {
	    				 batchId=formValues.batch;
	    			 }else{
	    				 batchId=studentbatchId;
	    			 }
	    			var programId=null;
	    			 if (!isNullOrEmpty(formValues.program)) {
	    				 programId=formValues.program;
	    			 }else{
	    				 programId=studentprogramId;
	    			 }
    				var eventIdArray = [];
    				 var periodArray = [];
 			        var records;
					if (!isNullOrEmpty(formValues.period)) {
						if (formValues.period.length) {
							for (var i = 0; i < formValues.period.length; i++) {
								var periodIds = formValues.period[i];
								if (Ext.isObject(periodIds)) {
									periodArray.push(periodIds.data.id);
								} else {
									periodArray.push(periodIds);
								}
							}
						}
						else if (!isNaN(formValues.period)) {
							periodArray.push(formValues.period);
						}
					}
 			       eventIdArray.push(detailSequenceId);
 			       var spStudentassessmentreportgrid = $this.getSpstudentassessmentreportgrid();
 			       var evalLevelNameArray = [];
 			       if (!isNullOrEmpty(formValues.evalLevelName)) {
			            for (var i = 0; i < formValues.evalLevelName.length; i++) {
			                var evalLevelNameValue = formValues.evalLevelName[i];
			                if (Ext.isObject(evalLevelNameValue)) {
			                	evalLevelNameArray.push(evalLevelNameValue.data.value);
			                } else {
			                	evalLevelNameArray.push(evalLevelNameValue);
			                }
//			                evaluationLevelValue = formValues.evalLevelName[i].data.value;
			            }
			        }
 			       spStudentassessmentreportgrid.getStore().getProxy().extraParams={
 			    	   studentId:studentId,
// 			    	   admissionId:admissionId,
					   programId:programId,
					   batchId: batchId,
					   periodIds:periodArray.join(),
					   courseId:course,
					   courseVariantId:courseVarient,
					   eventIds:eventIdArray.join(),
					   evaluationLevelName: evalLevelNameArray.join(),
					   assessmentType:evaluationLevelType
				   };
 			       $this.uncheckSPGridHeader(spStudentassessmentreportgrid);
 			       spStudentassessmentreportgrid.getStore().load({
					    callback: function(records) {
							   var exportBtn = spStudentassessmentreportgrid.down('#exportSPStudentAssessmentReportItemId');
							   obj.setDisabled(false);
							   if (records.length) {
								   exportBtn.setDisabled(false);
							   }
							   else {
								   exportBtn.setDisabled(true);
							   }
							   $this.onSearchCheckedAll(spStudentassessmentreportgrid);
						   }
				   });
 			       
 			       if(periodIdValue.length >1 || (periodIdValue.length == 1 && isNullOrEmpty(periodIdValue[0]))){
 			    	  var grid = $this.getSpstudentassessmentreportgrid();
 			    	  var msg= grid.down('#progressionStatusMessage');
     				 msg.setVisible(true);
     				 msg.setValue(''); 
 			       }
 			       
 			       if(periodIdValue.length == 1 && !isNullOrEmpty(periodIdValue[0])){
 			    	   var periodVal;
 			    	   if(!isNaN(periodIdValue[0])) {
 			    		  periodVal = periodIdValue[0];
 			    	   }
 			    	   else {
 			    		  periodVal = periodIdValue[0].data.id;
 			    	   }
 			    	          var submitValue={
 			    			        studentId:studentId,
 		    	    			    periodId:periodVal,
 		    	    	            };
 			    	 
 		    	    	        
 		    	    	        Ext.Ajax.request({
 		    	    	            type: 'rest',
 		    	    	            url: SERVERURL.PATH_PROGRESSION_STATUS_ON_STUDENT_PORTAL,
 		    	    	            params:submitValue,
 		    	    	            method : 'GET',
 		    	    	            success: function(f, action) {
 		    	    	                var data = f.responseText;
 		    	    	                var msg= spStudentassessmentreportgrid.down('#progressionStatusMessage');
 		    	    	               msg.setVisible(true);
 		    	    	               if(data == "NOT_AVAILABLE"){
 		    	    	            	  msg.setValue('');
 		    	    	            	   
 		    	    	               }else{
 		    	    	            	  msg.setValue(getExaminationTranslation('YOUR_PROGRESSION_STATUS') + " " + data); 
 		    	    	               }
 		    	    	            },
 		    	    	            failure: function(result, request) {
 		    	    	                showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
 		    	    	                return false;
 		    	    	            }
 		    	    	        });
 			       }else if(!isNaN(periodIdValue) && !isNullOrEmpty(periodIdValue[0])){
 			       
 			    	  var submitValue={
		    			        studentId:studentId,
	    	    			    periodId:periodIdValue,
	    	    	            };
 			    	   
 			    	  Ext.Ajax.request({
 	 		    	    	            type: 'rest',
 	 		    	    	            url: SERVERURL.PATH_PROGRESSION_STATUS_ON_STUDENT_PORTAL,
 	 		    	    	            params:submitValue,
 	 		    	    	            method : 'GET',
 	 		    	    	            success: function(f, action) {
 	 		    	    	                var data = f.responseText;
 	 		    	    	                var msg= spStudentassessmentreportgrid.down('#progressionStatusMessage');
 	 		    	    	               msg.setVisible(true);
 	 		    	    	               if(data == "NOT_AVAILABLE"){
 	 		    	    	            	  msg.setValue('');
 	 		    	    	            	   
 	 		    	    	               }else{
 	 		    	    	            	  msg.setValue(getExaminationTranslation('YOUR_PROGRESSION_STATUS') + " " + data); 
 	 		    	    	               }
 	 		    	    	            },
 	 		    	    	            failure: function(result, request) {
 	 		    	    	                showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
 	 		    	    	                return false;
 	 		    	    	            }
 	 		    	    	        });
 			    	   
 			       }
 			     
    			}
    		},
    		
    		'spstudentassessmentcommentwindow button[itemId=submitBtn]':{
    			click:function(btn){
    				var $this=this;
    				var win = btn.up('window');
    				var stCommentRowIndex = win.down('#stCommentRowIndex').getValue();
    				var stCommentExamResultId = win.down('#stCommentExamResultId').getValue();
    				var studentEventRemark = win.down('#studentComment').getValue();
    				if(studentEventRemark.replace(/\s/g, '').length){
    					if(!isNullOrEmpty(studentEventRemark)){
        					currentEditRecord.set('studentEventRemark',studentEventRemark);
        					currentEditRecord = null;
        					win.close();
        				}
    				}else{
                            currentEditRecord.set('studentEventRemark',studentEventRemark);
        					currentEditRecord = null;
        					win.close();
                        }
    			}
    		},
         
    	});
    },
    selectParentNodesTreePanelSP: function(node, checked, headerClick){
    	var me = this;
    	var parentNode = node.parentNode;
    	if(parentNode){
    		if(checked == false){
    			var childChecked = false;
    			if(parentNode.hasChildNodes()){
    				parentNode.cascadeBy(function(childNode) {
    					if(parentNode.data.treeNode !=childNode.data.treeNode){
    						if(childChecked == false){
    							childChecked = childNode.get('checked'); 
    						}
    					}
    				});
    			}
    			if(!childChecked){
    				if(parentNode.data.leaf != true){
    					parentNode.set('checked', false);
    					me.selectParentNodesTreePanelSP(parentNode, false, headerClick);
    				}
    			}
    		}else{
    			if(parentNode.data.leaf != true){
    				parentNode.set('checked', true);
    				me.selectParentNodesTreePanelSP(parentNode, true, headerClick);
    			}
    		}

    	}

    	var grid = me.getSpstudentassessmentreportgrid();
    	var checkedCount = grid.getChecked().length;
    	if(checkedCount){
    		var examreportcommoncontroller = Academia.app.getController('Academia.controller.examinationcenters.studentresultreport.StudentResultReportController');
			var checkedRecords = examreportcommoncontroller.getGridCheckedChildren(grid, true);
    		

    		grid.down('#saveSPStudentAssessmentReportItemId').setDisabled(false);
			if(checkedRecords.isStudentRemarkSubmitted){
	    		grid.down('#submitSPStudentAssessmentReportItemId').setDisabled(true);
	    		grid.down('#saveSPStudentAssessmentReportItemId').setDisabled(true);
			}
			else{
	    		grid.down('#submitSPStudentAssessmentReportItemId').setDisabled(false);
			}
			
			if(checkedRecords.isCommentNull){
				grid.down('#submitSPStudentAssessmentReportItemId').setDisabled(true);
			}
			//---finding for weatherSubmitted & enabling button

    		grid.down('#exportSPStudentAssessmentGradeReportItemId').setDisabled(false);
    		//grid.down('#exportSPStudentAssessmentReportItemId').setDisabled(false);
    		if(headerClick==false && grid.columns[0].textEl){
        		grid.columns[0].textEl.dom.children[0].checked = true;
    		}
    		if(checkedRecords.counter.length) {
    			grid.down('#exportSPStudentAssessmentGradeReportItemId').setDisabled(true);
    			grid.down('#exportSPStudentAssessmentReportItemId').setDisabled(true);
    		}
    		else {
    			grid.down('#exportSPStudentAssessmentGradeReportItemId').setDisabled(false);
    			grid.down('#exportSPStudentAssessmentReportItemId').setDisabled(false);
    		}
    	}
    	else {
    		grid.down('#saveSPStudentAssessmentReportItemId').setDisabled(true);
    		grid.down('#submitSPStudentAssessmentReportItemId').setDisabled(true);
    		grid.down('#exportSPStudentAssessmentGradeReportItemId').setDisabled(true);
    		//grid.down('#exportSPStudentAssessmentReportItemId').setDisabled(true);
    		if(headerClick==false){
        		me.uncheckSPGridHeader(grid);
    		}
    	}
    },
    visibleSPExamStudentAssessmentReportPivileges: function(grid, permissionsMap) {
 	   var associatedAcadLocationIds = new Array();
 	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
 	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
 	   
 	   var saveSPStudentAssessmentReport = grid.down('#saveSPStudentAssessmentReportItemId');
 	   var submitSPStudentAssessmentReport = grid.down('#submitSPStudentAssessmentReportItemId');
 	   var exportSPStudentAssessmentGradeReport = grid.down('#exportSPStudentAssessmentGradeReportItemId');
 	   var exportSPStudentAssessmentReportItemId = grid.down('#exportSPStudentAssessmentReportItemId');

 	   saveSPStudentAssessmentReport.setVisible(false);
 	   submitSPStudentAssessmentReport.setVisible(false);
 	   exportSPStudentAssessmentGradeReport.setVisible(false);
 	   exportSPStudentAssessmentReportItemId.setVisible(false);
 	   Ext.each(permissionList, function(privilege) {
 		   if (privilege === 'SAVE') {
 			   if(!isNullOrEmpty(saveSPStudentAssessmentReport)){
 				  saveSPStudentAssessmentReport.setVisible(true);	
 			   }
 		   }
 		   if (privilege === 'SUBMIT') {
 			   if(!isNullOrEmpty(submitSPStudentAssessmentReport)){
 				  submitSPStudentAssessmentReport.setVisible(true);	
 			   }
 		   }
 		   if (privilege === 'EXPORT_GRADE_BOOK') {
 			   if(!isNullOrEmpty(exportSPStudentAssessmentGradeReport)){
 				  exportSPStudentAssessmentGradeReport.setVisible(true);	
 			   }
 		   }
 		  if (privilege === 'EXPORT_REPORTS') {
			   if(!isNullOrEmpty(exportSPStudentAssessmentReportItemId)){
				   exportSPStudentAssessmentReportItemId.setVisible(true);	
			   }
		   }
 	   });
    },
    openStudentCommentWindow: function(record,rowIndex){
    	var me = this;
    	var win = me.getSpstudentassessmentcommentwindow();
		if(!win){
			win = Ext.widget('spstudentassessmentcommentwindow');
		}
		win.show();
		currentEditRecord = record;
    	win.down('#stCommentRowIndex').setValue(rowIndex);
    	win.down('#stCommentExamResultId').setValue(record.get('examResultId'));
    	win.down('#studentComment').setValue(record.get('studentEventRemark'));
    	
    	/*examResultId
    	studentComment*/
    },
    uncheckSPGridHeader: function(grid){
        grid.down('#exportSPStudentAssessmentReportItemId').setDisabled(false);
        if(grid && grid.columns && grid.columns[0] && grid.columns[0].textEl && grid.columns[0].textEl.dom)
			grid.columns[0].textEl.dom.children[0].checked = false;
    },
    
    onSearchCheckedAll:function(grid){
		   var me = this;
		   var headerClick = true;
		   var isExportButtonDisabled = false;
		   //if(e.target.type=="checkbox"){
			   var nodes = [];
			   var checked = false;
			   try{
				   var nodes = grid.getRootNode().childNodes;
				   if(nodes.length && grid.columns[0].textEl){
					   grid.columns[0].textEl.dom.children[0].checked = true;
				   }
				   Ext.each(nodes, function(currentNode){
					   if(currentNode.hasChildNodes()){
						   currentNode.set('checked', true);
						   checked = true;
						   currentNode.cascadeBy(function(node) {
							   node.set('checked', true);
							   checked = true;
							   if(node.data.wheatherPublished==false && node.data.leaf==true){
								   node.set('checked', false);
								   checked = false;
							   }
							   if(node.data.status==  "Hold For Student"){
								   isExportButtonDisabled =true;
							   }
						   });
					   }
					   me.selectParentNodesTreePanelSP(currentNode, checked, headerClick);
				   });
				   grid.down('#exportSPStudentAssessmentReportItemId').setDisabled(isExportButtonDisabled);
			   }
			   catch(e){
				   console.log('');
			   }
		   //}
	   
    },
    spStudentAssessmentReportFilterRenderAndReset: function(){
    	var $this = this;
    	var form=$this.getSpstudentassessmentreportfilter();
		var studentPortalInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
		var studentprogramId = studentPortalInfo.programBatchDetails.programId;
		var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
		var studentperiodId = studentPortalInfo.programBatchDetails.periodId;
		var admissionId=studentPortalInfo.admissionDetails[0].id;
		var programId = form.down("#programId");
		var batchCombo = form.down("#batchId");
		var detailSequence=form.down('#detailSequenceItemId');
		var evaluationLevel = form.down("#evalLevelName");
		var courseVariant = form.down("#courseVarient_Id");
		var periodId=null;
		courseVariant.setDisabled(true);
		evaluationLevel.reset();
	    var evaluationLevelType = "EVALUATION_TYPE";
		programId.setDisabled(false);
		programId.getStore().getProxy().extraParams = {
			studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
			onlyCurrentRecords:false,
			 academyLocationId:$this.getCurrentAcademyLocation()
		};
		programId.getStore().load({
			callback : function(records, success){
				if(success){
					form.down("#programId").setValue(studentprogramId);
					 var courseField=form.down("#course_Id");
					 courseField.setDisabled(false);
					 batchCombo.getStore().getProxy().extraParams = { 
						   programId:studentprogramId,
						   studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
						   onlyCurrentRecord:false
					 };
					form.down("#batchId").setDisabled(false);
					batchCombo.getStore().load({
						callback : function(records, success){
							if(success){
								form.down("#batchId").setValue(studentbatchId);
								var periodField=form.getForm().findField('period');
								periodField.setDisabled(false);
								periodField.getStore().getProxy().extraParams = {
									id:studentbatchId,
									studentId:$this.getCurrentlyLoggedInUserInfoForPortal().student.id,
									onlyCurrentRecords:false
								};
								periodField.getStore().load({
									callback : function(records, success){
	    								if(success){
											var curPeriod = periodField.getStore().findRecord('isCurrentPeriodOfProgram', true);
										   if(curPeriod) {
											   periodField.setValue([curPeriod.get('id')]);
											   periodId=curPeriod.get('id');
										   }
										   else {
											   form.down("#periodId").setValue([studentperiodId]);
										   }
										   
										    var valueCheck="";						                				                                            
                                                
                                                    var url = SERVERURL.PATH_GET_AUTO_SELECT_ALL_LEVEL_VALUE;
                                                        Ext.Ajax.request({  
                                                        type : 'rest',
                                                        url : url,                                                      
                                                        method : 'GET',
                                                        success : function(response) {
                                                               var jsonResponse = Ext.JSON.decode(response.responseText); 
                                                               valueCheck = jsonResponse[0] ? jsonResponse[0].value : "";
                                                           	 evaluationLevel.getStore().getProxy().extraParams={
			                					   programId:form.down("#programId").getValue(),
			                					   batchId:studentbatchId,
			                					   periodId:periodField.value[0],
			                					   evaluationLevel:evaluationLevelType,
			                					   isGroupBy:true,
			                					   isOtherEval:false
			                				   };
			                				   
			                				    evaluationLevel.getStore().load({
                                                                        callback:function(records){
                                                                            var levelIds=[];
                                                                            var localVar = "Yes";
                                                                            for (var i = 0; i < records.length; i++) {
                                                                                   if(valueCheck.toLowerCase() === localVar.toLowerCase()){
                                                                                        levelIds.push(records[i].data.id);
                                                                                    }
                                                                                
                                                                            }
                                                                            
                                                                            evaluationLevel.setValue(levelIds);
                                                                            
                                                                         }
                                                                     });
			                				   
			                				  // evaluationLevel.getStore().load();
			                				   evaluationLevel.setDisabled(false);
                                                        }
                                                    });  
	    								
			                				   
			                				   
	    								}
									}
								});


								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var whetherSchool = alinfomodel.get('wheatherSchool');
								if (whetherSchool) {
									studentperiodId = null;
								}
								var studentId=studentPortalInfo.student.id;
								courseField.getStore().getProxy().extraParams = {
									programId: studentprogramId,
		    						batchId:studentbatchId,
									periodId:studentperiodId,
									studentId:studentId, 
									periodIds:null
		    					};
		    					// courseField.getStore().load(); 
		    					
							}
						}
					});
				}
			}
		});
		detailSequence.reset();
		detailSequence.setDisabled(true);
		detailSequence.getStore().getProxy().extraParams = {
			programId: studentprogramId,
			batchId: studentbatchId,
			evaluationLevel: "EVALUATION_EVENT",
			isOtherEval:false
		};
		detailSequence.getStore().load();
    	
    }
    
    
});
