/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.controller.examinationcenters.thesisManagement.FacultyThesisManagementController', {
	extend: 'Academia.controller.base.BaseController',
	stores : [
		'common.AcademicTermByMappedPeriodStore',
		'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
		'attendance.AttendanceProgramSectionStore',
		'attendance.FacultyCodeSmartSearch',
		'common.AcademyLocationNameSeparated',
		'examinationcenters.thesisManagement.ThesisManagementGridStore',
		'common.AllUserBySmartSearch',
		'examinationcenters.thesisManagement.ThesisManagementSupervisorDetailsGridStore',
		'examinationcenters.thesisManagement.ThesisManagementStatusGridStore',
		'examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore',
		'examinationcenters.thesisManagement.ThesisManagementAccessModeStore',
		'facilitiesresources.managegallery.FileUploadWindowDataviewStore','attendance.FacultyProgramBatchPeriodStore'
	],
	views : [
		'examinationcenters.thesisManagement.FacultyThesisManagementStructure',
		'examinationcenters.thesisManagement.FacultyThesisManagementSearch',
		'examinationcenters.thesisManagement.FacultyThesisManagementGrid',
		'examinationcenters.thesisManagement.FacultyThesisManagementFormWin',
		'examinationcenters.thesisManagement.FacultyThesisManagementSupervisorDetailsgrid',
		'examinationcenters.thesisManagement.FacultyCancelNominationForm',
		'examinationcenters.thesisManagement.FacultyEditThesisManagementFormWin',
		'examinationcenters.thesisManagement.FacultyThesisManagementApproveRejectWin',
		'examinationcenters.thesisManagement.FacultyThesisManagementStatusDetailGrid',
		'examinationcenters.thesisManagement.FacultyThesisManagementStatusGrid',
		'examinationcenters.thesisManagement.FacultyThesisManagementStatusDocumentWindow',
		'examinationcenters.thesisManagement.FacultyThesisMangementStatusDetailWin',
		'examinationcenters.thesisManagement.FacultyThesisManagementSubmitDocumentWindow',
		'facilitiesresources.managegallery.FileUploadWin',
		],
		config:{
			FACULTY_THESIS_MANAGEMENT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_THESIS_MANAGEMENT_PRIVILEGES'),
		},     
		refs : [{
			ref:'facultythesismanagementstructure',
			selector:'facultythesismanagementstructure'
		},{
			ref:'facultythesismanagementsearch',
			selector:'facultythesismanagementsearch'
		},{
			ref:'facultythesismanagementgrid',
			selector:'facultythesismanagementgrid'
		},{
			ref:'facultythesismanagementsupervisordetailsgrid',
			selector:'facultythesismanagementsupervisordetailsgrid'
		},{
			ref:'facultythesismanagementformwin',
			selector:'facultythesismanagementformwin'
		},{
			ref : 'facultycancelnominationform',
			selector : 'facultycancelnominationform'
		},{
			ref : 'facultyeditthesismanagementformwin',
			selector : 'facultyeditthesismanagementformwin'
		},{
			ref : 'facultythesismanagementapproverejectwin',
			selector : 'facultythesismanagementapproverejectwin'
		},{
			ref : 'facultythesismanagementstatusdetailgrid',    
			selector : 'facultythesismanagementstatusdetailgrid'
		},{
			ref : 'facultythesismanagementstatusgrid',
			selector : 'facultythesismanagementstatusgrid'
		},{
			ref : 'facultythesismanagementstatusdocumentwindow',
			selector : 'facultythesismanagementstatusdocumentwindow'
		},{
			ref : 'facultythesismangementstatusdetailwin',
			selector : 'facultythesismangementstatusdetailwin'
		},{
			ref: 'facultythesismanagementsubmitdocumentwindow',
			selector: 'facultythesismanagementsubmitdocumentwindow'
		},{
			ref: 'fileuploadwin',
			selector: 'fileuploadwin'
		}],
		init : function() {
			this.control({
				'facultythesismanagementstructure':{},
				'facultythesismanagementapproverejectwin button[itemId=btnAcceptDocumentAddImage]':{
    				click : this.openDocumentAddWindow
    			},
    			'facultythesismanagementapproverejectwin button[itemId=btnAcceptDocumentDeleteImage]':{
    				click: function(btn) {
    					var $this=this;
    					var form=$this.getFacultythesismanagementapproverejectwin();
    					var dataview = form.down('#acceptDocumentDataView');
    					var store = dataview.getStore();
    					var imageIDs = $("[name=thesisImageId]:checked").map(function(){
    						return $(this).val();
    					}).get();
    					if(imageIDs.length>0){
    						var submitURL = SERVERURL.DELETE_THESIS_DOCUMENTS+'?id='+imageIDs.toString();
    						Ext.Ajax.request({
    							method: "GET",
    							type: 'rest',
    							url : submitURL,
    							headers: {
    								'Content-Type': 'application/json'
    							},
    							success: function(form, action) {
    								showSuccessMessage(getCommonTranslation('ACCEPT_REJECT_THESIS'), getFeeAndPaymentCommonTranslation('REFERENCE_DOCUMENT_DELETED_SUCCESSFULLY'));	
    								Ext.each(imageIDs, function(documentId) {
    									store.removeAt(store.find('documentId',documentId));
    								});
    								btn.setDisabled(true);
    							}});

    					}
    				}
    			},
				'facultythesismanagementsearch' : {
					render : function(form) {
						var $this = this;
						var thesisStatus = form.down("#thesisStatus");
						var form=this.getFacultythesismanagementsearch();
						
						var academicTermCombo = form.down('#academicTerm');
						var studentCombo = form.down('#thesisManagementStudent');
						var programCombo = form.down('#programId');				
						var batchComboBox = form.down('#batchId');
						var periodComboBox = form.down('#periodId');
						var facultyId = $this.getCurrentlyLoggedInUser().id;
						academicTermCombo.reset();
						studentCombo.reset();
						studentCombo.setDisabled(true);
						programCombo.reset();
						programCombo.setDisabled(true);
						batchComboBox.reset();
						batchComboBox.setDisabled(true);
						periodComboBox.reset();
						periodComboBox.setDisabled(true);
						
						var alIds=[];
						alIds.push(this.getCurrentAcademyLocation());
						var academyLocationIds = alIds.join();
						
						var thesisStatusStore = thesisStatus.getStore();
						thesisStatusStore.load();
						
						var academicTermComboStore = academicTermCombo.getStore();
						academicTermComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							facultyId : facultyId
						};
						academicTermComboStore.load({
							callback: function(records, operation, success) {
								for(var i in records) {
									if(records[i].get('sequence') == 1) {
										academicTermId = records[i].get('id');
										academicTermCombo.setValue(academicTermId);
										studentCombo.setDisabled(false);
										programCombo.setDisabled(false);
										var programComboStore = programCombo.getStore();
										programComboStore.getProxy().extraParams = {
										academyLocationIds : academyLocationIds,
										academicTermId : academicTermId,
										facultyId: facultyId
										};
										programComboStore.load();
										studentCombo.getStore().getProxy().extraParams = {
											academyLocationIds : academyLocationIds,
											academicTermId: academicTermId,
											facultyId : facultyId
										};
										studentCombo.getStore().load();
									}
								}
							}
						});
					}
				},
				'facultythesismanagementsearch combo#academicTerm':{
					select : function(obj,record){
						var this$ = this;
						var academyLocationVal = this.getCurrentAcademyLocation();
						var academicTermId = record[0].get('id');
						var form = this$.getFacultythesismanagementsearch();
						var thesisManagementStudentCombo=form.down("#thesisManagementStudent");
						var programCombo = obj.up('form').down('#programId');				
						var batchComboBox = obj.up('form').down('#batchId');
						var periodComboBox = obj.up('form').down('#periodId');
						var facultyId = this$.getCurrentlyLoggedInUser().id;
						thesisManagementStudentCombo.reset();
						thesisManagementStudentCombo.setDisabled(false);
						programCombo.reset();
						programCombo.setDisabled(false);
						batchComboBox.reset();
						batchComboBox.setDisabled(true);
						periodComboBox.reset();
						periodComboBox.setDisabled(true);
						var alids=[];
						var academyLocationIds = null;

						if (!isNullOrEmpty(academyLocationVal) && academyLocationVal.length > 0 && !isNullOrEmpty(academyLocationVal[0])) {
							for (var i in academyLocationVal) {
								if (Ext.isObject(academyLocationVal[0])) {
									alids.push(academyLocationVal[i].get("id"));
								} else {
									alids.push(academyLocationVal[i]);
								}
							}
							academyLocationIds = alids.join();
						}
						else if(!isNullOrEmpty(academyLocationVal)){
							academyLocationIds = academyLocationVal;
						}
						
						var thesisManagementStudentStore = thesisManagementStudentCombo.getStore();
						thesisManagementStudentStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							academicTermId : academicTermId,
							facultyId : facultyId
						};
						thesisManagementStudentStore.load();
						
						var programComboStore = programCombo.getStore();
						programComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							academicTermId : academicTermId,
							facultyId: facultyId
						};
						programComboStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 1){
										var programId = records[0].data.id;
										programCombo.setValue(programId);
										batchComboBox.setDisabled(false);
										var batchComboStore = batchComboBox.getStore();
										batchComboStore.getProxy().extraParams = {
											academicTermId : academicTermId,
											programId : programId
										};
										batchComboStore.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 1){
														var batchId = records[0].data.id;
														batchComboBox.setValue(batchId);
														periodComboBox.setDisabled(false);
														var periodComboStore = periodComboBox.getStore();
														periodComboStore.getProxy().extraParams = {
															academicTermId : academicTermId,
															batchId : batchId
														};
														periodComboStore.load({
															callback: function(records, operation, success) {
																if (success) {
																	if(records.length == 1){
																		var periodId = records[0].data.id;
																		periodComboBox.setValue(periodId);
																	}		 
																}
															}
														});
													}		 
												}
											}
										});
									}		 
								}
							}
						});
					}
				},
				'facultythesismanagementsearch combo#thesisManagementStudent':{
					select : function(obj,record){
						var this$ = this;
						var academyLocationVal = this.getCurrentAcademyLocation();
						var form = obj.up('form');
						var academicTermCombo = form.down('#academicTerm');
						var facultyId = this$.getCurrentlyLoggedInUser().id;
						var academicTermId = academicTermCombo.getValue();
						var thesisManagementStudentId = record[0].get("secondId");
						var programCombo = obj.up('form').down('#programId');	
						var batchComboBox = obj.up('form').down('#batchId');
						var periodComboBox = obj.up('form').down('#periodId');
						programCombo.reset();
						batchComboBox.reset();
						periodComboBox.reset();
						var alids=[];
						var academyLocationIds = academyLocationVal;
						
						var programComboStore = programCombo.getStore();
						programComboStore.getProxy().extraParams = {
							academyLocationIds:academyLocationIds,
							studentId:thesisManagementStudentId,
							academicTermId:academicTermId,
							facultyId:facultyId
						};
						programComboStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 1){
										var programId = records[0].data.id;
										programCombo.setValue(programId);
										batchComboBox.setDisabled(false);
										var batchComboStore = batchComboBox.getStore();
										batchComboStore.getProxy().extraParams = {
											academicTermId : academicTermId,
											programId : programId,
											facultyId : facultyId,
											studentId : thesisManagementStudentId
										};
										batchComboStore.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 1){
														var batchId = records[0].data.id;
														batchComboBox.setValue(batchId);
														periodComboBox.setDisabled(false);
														var periodComboStore = periodComboBox.getStore();
														periodComboStore.getProxy().extraParams = {
															academicTermId : academicTermId,
															batchId : batchId,
															facultyId : facultyId,
															studentId : thesisManagementStudentId
														};
														periodComboStore.load({
															callback: function(records, operation, success) {
																if (success) {
																	if(records.length == 1){
																		var periodId = records[0].data.id;
																		periodComboBox.setValue(periodId);
																	}		 
																}
															}
														});
													}		 
												}
											}
										});
									}		 
								}
							}
						});
					}
				},
				'facultythesismanagementsearch combo#programId':{
					select : function(obj,record){
						var this$ = this;
						var academyLocationVal = this.getCurrentAcademyLocation();						
						var form = this$.getFacultythesismanagementsearch();
						var academicTermId = form.down("#academicTerm").getValue();
						var thesisManagementStudentId = record[0].get("secondId");
						var programId = form.down('#programId').getValue();
						var batchCombo = form.down('#batchId');
						var periodCombo = form.down('#periodId');
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var alids=[];
						var academyLocationIds = academyLocationVal;
						batchCombo.setDisabled(false);
						batchCombo.reset();
						periodCombo.setDisabled(true);
						periodCombo.reset();
						var batchComboStore = batchCombo.getStore();
						batchComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							academicTermId : academicTermId,
							programId : programId,
							facultyId : facultyId,
							studentId : thesisManagementStudentId
						};
						batchComboStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 1){
										var batchId = records[0].data.id;
										batchCombo.setValue(batchId);
										periodCombo.setDisabled(false);
										var periodComboStore = periodCombo.getStore();
										periodComboStore.getProxy().extraParams = {
											academyLocationIds : academyLocationIds,
											academicTermId : academicTermId,
											batchId : batchId,
											facultyId : facultyId,
											studentId : thesisManagementStudentId
										};
										periodComboStore.load({
											callback: function(records, operation, success) {
												if (success) {
													if(records.length == 1){
														var periodId = records[0].data.id;
														periodCombo.setValue(periodId);
													}		 
												}
											}
										});
									}		 
								}
							}
						});
					}
				},
				'facultythesismanagementsearch combo#batchId':{
					select : function(obj,record){
						var this$ = this;
						var academyLocationVal = this.getCurrentAcademyLocation();
						var form = this$.getFacultythesismanagementsearch();
						var academicTermId = form.down("#academicTerm").getValue();
						var thesisManagementStudentId = record[0].get("secondId");
						var batchId = form.down('#batchId').getValue();
						var periodCombo = form.down('#periodId');
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var alids=[];
						var academyLocationIds = academyLocationVal;
						periodCombo.setDisabled(false);
						periodCombo.reset();
						var periodComboStore = periodCombo.getStore();
						periodComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							academicTermId : academicTermId,
							batchId : batchId,
							facultyId : facultyId,
							studentId : thesisManagementStudentId
						};
						periodComboStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length == 1){
										periodCombo.setValue(records[0].data.id);
									}		 
								}
							}
						});
					}
				},
				'facultythesismanagementsearch combo#thesisStatus':{
					select : function(obj,record){
						var this$ = this;
						var form = this$.getFacultythesismanagementsearch();
						var thesisStatus = form.down('#thesisStatus').getValue();
						var accessModeCombo = form.down('#accessMode');
						accessModeCombo.reset();
						if(thesisStatus == 'Approved'){
							accessModeCombo.setVisible(true);
							var accessModeStore = accessModeCombo.getStore();
							accessModeStore.load();
						} else{
							accessModeCombo.setVisible(false);
						}
					}
				},
				'facultythesismanagementsearch button[itemId=resetBtn]':{
					click: function() {
	    				this.resetThesisManagementFilter();
	    			}
				},
				'facultythesismanagementsearch button[itemId=programSearchBtn]':{
					click: function() {
	    				this.loadThesisManagementGrid();
	    			}
				},
				'facultythesismanagementgrid':{
					render: function(grid){
						var grid = this.getFacultythesismanagementgrid();
						this.checkPermissionForExport(grid, this.getFACULTY_THESIS_MANAGEMENT_PERMISSION());
						grid.getStore().removeAll();
	    			},
	    			afterrender:function(grid){
	    				setTimeout(function(){
	    					grid.getHeader().items.items[1].show();
	    				},3000);
	    			},
	    			cellclick: function(View, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	    				var $this = this;
	    				var grid = $this.getFacultythesismanagementgrid();
	    				var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	    				if (e.target.tagName == 'A') {
	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
	    					if(dataIndex == 'thesisStatus'){
	    						$this.viewThesisStatusRecord(record,grid);
	    					}
	    				}
	    				
	    				if (e.target.tagName == 'A') {
	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
	    					if(dataIndex == 'supervisorName'){
	    						this.viewThesisManagementSupervisorDetail(record, grid);
	    					}
	    				}
	    				if (e.target.tagName == 'A') {
	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
	    					if(dataIndex == 'thesisDocument'){
	    						this.viewThesisManagementDetail(record, grid);
	    					}
	    				}
	    			},
					selectionchange: function(column, selected) {
	            		var grid = this.getFacultythesismanagementgrid();
	            		if(selected.length== 1){ 
	            			var record = selected[0].data;
		            		var thesisStatus = record.thesisStatus;
	            			if(!isNullOrEmpty(thesisStatus) && thesisStatus=='Nominated'){
	            				grid.down('#btnEdit').setDisabled(false);
	            			} else{
	            				grid.down('#btnEdit').setDisabled(true);
	            			}
	            			if(!isNullOrEmpty(thesisStatus) && (thesisStatus=='Nominated' || thesisStatus=='Rejected')){
	            				grid.down('#btnSubmitThesis').setDisabled(false);
	            			} else{
	            				grid.down('#btnSubmitThesis').setDisabled(true);
	            			}
	            			if(!isNullOrEmpty(thesisStatus) && (thesisStatus=='Submitted')){
	            				grid.down('#btnApproveReject').setDisabled(false);
	            			} else{
	            				grid.down('#btnApproveReject').setDisabled(true);
	            			}
	            			if(!isNullOrEmpty(thesisStatus) && (thesisStatus=='Cancelled')){
	            				grid.down('#btnCancelNomination').setDisabled(true);
	            			} else{
	            				grid.down('#btnCancelNomination').setDisabled(false);
	            			}
	            			grid.down('#btnView').setDisabled(false);
	            		}
	            		else{
	            			grid.down('#btnEdit').setDisabled(true);
	            			grid.down('#btnView').setDisabled(true);
	            			grid.down('#btnCancelNomination').setDisabled(true);
	            			grid.down('#btnSubmitThesis').setDisabled(true);
	            			grid.down('#btnApproveReject').setDisabled(true);
	            		}
	            	}
				},
				'facultythesismanagementstatusgrid' : {
	    			cellclick: function(View, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	    				var $this = this;
	    				var grid = $this.getFacultythesismanagementgrid();
	    				var columnName = grid.columnManager.columns[cellIndex].dataIndex;

	    				if (e.target.tagName == 'A') {
	    					var dataIndex = View.ownerCt.columnManager.columns[cellIndex].dataIndex;
	    					if(dataIndex == 'document'){
	    						$this.viewThesisStatusDocument(record,grid);
	    					}
	    				}
	    				
	    			}
				},
				
				'facultythesismanagementgrid button[itemId=btnAdd]': {
					click: function(grid){
						this.showThesisManagementWindow();
					}
				},
				'facultythesismanagementgrid button[itemId=btnEdit]': {
					click: function(grid){
						var grid = this.getFacultythesismanagementgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							var records = grid.getSelectionModel().getSelection();
							var mode="edit";
							this.editThesisManagementWindow(mode,grid);
						} else {
							showWarningMessage(getCommonTranslation('THESIS_MANAGEMENT_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
						
					}
				},
				'facultythesismanagementgrid button[itemId=btnView]': {
					click: function(grid){
						var grid = this.getFacultythesismanagementgrid();
						if (grid.getSelectionModel().getCount() > 0) {
							var mode="view";
							this.editThesisManagementWindow(mode,grid);
						} else {
							showWarningMessage(getCommonTranslation('THESIS_MANAGEMENT_LIST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
						
					}
				},
				'facultythesismanagementgrid button[itemId=btnApproveReject]': {
					click: function(grid){
						this.showThesisManagementApproveRejectWindow();
					}
				},
				'facultythesismanagementgrid button[itemId=btnSubmitThesis]':{
					click: this.openSubmitThesisWindow
				},
				'facultythesismanagementapproverejectwin':{
					render : function(form){
						var thesisStatus=form.down('#thesisStatus');
						var thesisStatusStore=thesisStatus.getStore();
						thesisStatusStore.getProxy().extraParams = {
							whetherApproveEnum : true
						};
						thesisStatusStore.load();
						
					},
					beforeclose:function(win){
						var form=win.down('form');
						var thesisStatus=form.down('#thesisStatus');
						if(thesisStatus.getValue()==getCommonTranslation("APPROVED") && isNullOrEmpty(win.isSave)){
							var ids=[];
							if(!isNullOrEmpty(form.down('#acceptDocumentDataView').getStore().data)){
								var documentData=Ext.Array.pluck(form.down('#acceptDocumentDataView').getStore().data.items,'data');
								Ext.Array.each(documentData,function(value){
									ids.push(value.documentId);
								});
								if(ids.length>0){
								var submitURL = SERVERURL.OFFLINE_PAYMENT_DELETEMULTIPLEDOCUMENTS+'?id='+ids.join();
								Ext.Ajax.request({
									method: "GET",
									type: 'rest',
									url : submitURL,
									headers: {
										'Content-Type': 'application/json'
									},
									success: function(form, action) {

									}});
								}
							}
						}
					}
				},
				'facultythesismanagementapproverejectwin button[itemId=CancelBtn]' : {
					click : function(btn) {
						this.getFacultythesismanagementapproverejectwin().close();
					}
				},
				'facultythesismanagementapproverejectwin[itemId=thesismanagementapproverejectwinItemId] button[itemId=SubmitBtn]' : {
					click : function(btn) {
						var form=btn.up('form');
						this.approveAndRejectThesisMangement(form);
					}
				},
				'facultythesismanagementapproverejectwin customcombobox#thesisStatus':{
					select : function(obj, record){
						var $this=this;
						var form =obj.up('form');
						var accessMode=form.down('#accessMode');
						var accessModeDate=form.down('#accessModeDate');
						accessModeDate.reset();
						var date = new Date();
						var newDate = date.setMonth(date.getMonth()+36);
                    	newDate = new Date(newDate);
                    	accessModeDate.minValue=new Date();
                    	accessModeDate.setMaxValue(newDate);
						var dataview = form.down('#acceptDocumentDataView');
						var store = dataview.getStore();
						store.removeAll();
						form.down('#acceptDocumentPanel').hide();
						accessModeDate.hide();
						if(record[0].data.value==getCommonTranslation("APPROVED")){
							accessMode.allowBlank=false;
							accessMode.show();
						}else{
							accessMode.allowBlank=true;
							accessMode.hide();
						}
						form.isValid();
						accessMode.reset();
					}
				},
				'facultythesismanagementapproverejectwin customcombobox#accessMode':{
					select : function(obj, record){
						var $this=this;
						var form =obj.up('form');
						var accessModeValue=record[0].data.value;
						var accessModeDate=form.down('#accessModeDate');
						accessModeDate.reset();
						var date = new Date();
						var newDate = date.setMonth(date.getMonth()+36);
                    	newDate = new Date(newDate);
                    	accessModeDate.minValue=new Date();
						accessModeDate.setMaxValue(newDate);
						var dataview = form.down('#acceptDocumentDataView');
						var store = dataview.getStore();
						store.removeAll();
						form.down('#acceptDocumentPanel').hide();
						accessModeDate.hide();
						var showDate=false;
						var showDoument=false;
						if(accessModeValue=="Date" || accessModeValue=="date" || accessModeValue=="DATE"){
							accessModeDate.show();
						}else if(accessModeValue=="Document" || accessModeValue=="document" || accessModeValue=="DOCUMENT"){
							form.down('#acceptDocumentPanel').show();
						}else if(accessModeValue=="Date And Document" || accessModeValue=="date and document" || accessModeValue=="DATE AND DOCUMENT"
							|| accessModeValue=="DATE_AND_DOCUMENT" || accessModeValue=="date_and_document" || accessModeValue=="date & document" 
								|| accessModeValue=="Date & Document" || accessModeValue=="DATE & DOCUMENT") {
							accessModeDate.show();
							form.down('#acceptDocumentPanel').show();
						}


					}
				},
				'facultythesismanagementformwin':{
					render : function(form){
						var $this=this;
						var academyLocationId = this.getCurrentAcademyLocation();
						var academicTermCombo = form.down('#academicTermId');
						var studentCombo = form.down('#admissionId');
						var superVisorCombo = form.down('#superVisorId');
						var academicTermId = 0;
						var facultyId = $this.getCurrentlyLoggedInUser().id;
						var academicTermStore = academicTermCombo.getStore();
						academicTermStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId,
							facultyId:facultyId
						};
						academicTermStore.load({
							callback: function(records, operation, success) {
								for(var i in records) {
									if(records[i].get('sequence') == 1) {
										academicTermId = records[i].get('id');
										academicTermCombo.setValue(academicTermId);
									}
								}
							}
						});
						var superVisorStore = superVisorCombo.getStore();
						superVisorStore.getProxy().extraParams = {
							academyLocationId : academyLocationId
						};
					}
				},
				'facultythesismanagementformwin customcombobox#academicTermId': {
					change: function(obj, record) {
						var this$ = this;
						var academyLocationId = this.getCurrentAcademyLocation();
						var academicTermId = obj.value;
						var form = this$.getFacultythesismanagementformwin();
						var studentCombo = form.down('#admissionId');
						var programCombo = form.down('#programId');
						var batchCombo = form.down('#batchId');
						var periodCombo = form.down('#periodId');
						var facultyId = this$.getCurrentlyLoggedInUser().id;
						studentCombo.reset();
						programCombo.reset();
						batchCombo.reset();
						periodCombo.reset();
						
						studentCombo.setDisabled(false);
						programCombo.setDisabled(true);
						batchCombo.setDisabled(true);
						
						
						if(academicTermId > 0) {
							var thesisManagementStudentStore = studentCombo.getStore();
							thesisManagementStudentStore.getProxy().extraParams = {
								academyLocationIds : academyLocationId,
								academicTermId : academicTermId,
								facultyId : facultyId,
								isCurrentRecord:true
							};
							thesisManagementStudentStore.load();
						}
					}
				},
				'facultythesismanagementformwin customcombobox#admissionId' : {
					select : function(obj, record) {
						var $this = this;
						var form = $this.getFacultythesismanagementformwin();
						var studentId = record[0].get("secondId");
						var program = form.down('#programId');
						var academyLocationIds = this.getCurrentAcademyLocation();
						var academicTermId = form.down('#academicTermId').getValue();
						var facultyId = $this.getCurrentlyLoggedInUser().id;
						program.reset();
						form.down('#batchId').reset();
						form.down('#periodId').reset();
						
						program.setDisabled(false);
						form.down('#batchId').setDisabled(true);
						
						var programByAcademyLocationStore = program.getStore();
						programByAcademyLocationStore.getProxy().extraParams = {
							academyLocationIds:academyLocationIds,
							studentId:studentId,
							onlyCurrentRecords:true,
							academicTermId:academicTermId,
							facultyId:facultyId
						};
						programByAcademyLocationStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length==1){
										program.setValue(records[0].get('id'));
									}	
								}
							}	   
						});
					}
				},
				'facultythesismanagementformwin customcombobox#programId': {
					change : function(obj, record) {
						var this$ = this;
						var academyLocationId = this.getCurrentAcademyLocation();
						var programId = obj.value;
						var form = this$.getFacultythesismanagementformwin();
						var academicTermCombo = form.down('#academicTermId');
						var studentCombo = form.down('#admissionId');
						var batchCombo = form.down('#batchId');
						var periodCombo = form.down('#periodId');
						var facultyId = this$.getCurrentlyLoggedInUser().id;
						
						batchCombo.reset();
						periodCombo.reset();
						
						batchCombo.setDisabled(true);
						
						if(programId > 0) {
							batchCombo.setDisabled(false);
							var batchStore = batchCombo.getStore();
							batchStore.getProxy().extraParams = {
								programId: programId,
								studentId:studentCombo.getValue(),
								academicTermId:academicTermCombo.getValue(),
								onlyCurrentRecords:true,
								facultyId:facultyId
							};
							batchStore.load({
								callback: function(records, operation, success) {
									if (success) {
										if(records.length==1) {
											batchCombo.setValue(records[0].get('id'));
										}
									}
								}
							});
						}
					}
				},
				'facultythesismanagementformwin customcombobox#batchId': {
					change : function(obj, record) {
						var this$ = this;
						var batchId = obj.value;
						var form = this$.getFacultythesismanagementformwin();
						var studentCombo = form.down('#admissionId');
						var academicTermCombo = form.down('#academicTermId');
						var periodCombo = form.down('#periodId');
						var facultyId = this$.getCurrentlyLoggedInUser().id;
						periodCombo.reset();
						if(batchId > 0) {
							var periodStore = Ext.create('Academia.store.attendance.FacultyProgramBatchPeriodStore');
							periodStore.getProxy().extraParams = {
								batchId : batchId,
								academicTermId:academicTermCombo.getValue(),
								studentId:studentCombo.getValue(),
								onlyCurrentRecords:true,
								facultyId:facultyId
							};
							periodStore.load({
								callback: function(records, operation, success) {
									if (success) {
										 if(records.length>0) {
											periodCombo.setValue(records[0].get('id'));
										}
									}
								}
							});
						}
					}
				},
				'facultythesismanagementformwin[itemId=thesismanagementformwinItemId] button[itemId=SubmitBtn]' : {
					click : function(btn) {
						var form=btn.up('form');
						this.saveUpdateThesisMangement(form);
					}
				},
				'facultythesismanagementformwin button[itemId=addDetailedBtn]' : {
					click: function(){
						var $this=this;
        				var form=$this.getFacultythesismanagementformwin();
						this.addMoreSuperVisor(form);
					}
        			 
        		},
        		'facultythesismanagementformwin button[itemId=addDetailedBtn1]' : {
        			click: function(){
        				var $this=this;
        				var form=$this.getFacultythesismanagementformwin();
						this.addMoreSuperVisor(form);
					}
        		},
        		'facultythesismanagementformwin button[itemId=detailedDeleteButton1OfSupervidor]':{
        			click : function(deleteButton) {
        				var $this=this;
        				var form=$this.getFacultythesismanagementformwin();
        				this.deleteMoreDetailedOfSuperVisor(deleteButton,form)
        			}
        		},
				'facultythesismanagementformwin button[itemId=CancelBtn]' : {
					click : function() {
						var $this=this;
        				var form=$this.getFacultythesismanagementformwin();
						this.getFacultythesismanagementformwin().close();
					}
				},
				'facultyeditthesismanagementformwin button[itemId=addDetailedBtn]' : {
					click: function(){
						var $this=this;
        				var form=$this.getFacultyeditthesismanagementformwin();
						this.addMoreSuperVisor(form);
					}
        		},
        		'facultyeditthesismanagementformwin button[itemId=addDetailedBtn1]' : {
        			click: function(){
        				var $this=this;
        				var form=$this.getFacultyeditthesismanagementformwin();
						this.addMoreSuperVisor(form);
					}
        		},
        		'facultyeditthesismanagementformwin button[itemId=detailedDeleteButton1OfSupervidor]':{
        			click : function(deleteButton) {
        				var $this=this;
        				var form=$this.getFacultyeditthesismanagementformwin();
        				this.deleteMoreDetailedOfSuperVisor(deleteButton,form)
        			}
        		},
				'facultyeditthesismanagementformwin button[itemId=CancelBtn]' : {
					click : function() {
						this.getFacultyeditthesismanagementformwin().close();
					}
				},
				'facultyeditthesismanagementformwin[itemId=editthesismanagementformwinItemId] button[itemId=SubmitBtn]' : {
					click : function(btn) {
						var form=btn.up('form');
						this.saveUpdateThesisMangement(form);
					}
				}
    			,
				 'facultythesismanagementgrid button[itemId=btnCancelNomination]': {
					 click: function() {
						 var $this = this;
						 var grid = $this.getFacultythesismanagementgrid();
						 var allHolds=false;
						 var flag=false;
						if (grid.getSelectionModel().getCount() > 0) {
							 this.showCancelNomination();
						 }else{
							 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						 }
					 }
				 }
				,
				 'facultycancelnominationform button[itemId=submitBtn]' : {
					 click : function(){
						 this.cancelNomination();
					 }
				 }
				,
				 'facultycancelnominationform button[itemId=cancelBtn]' : {
					 click : function(){
						 this.getFacultycancelnominationform().close();
					 }
				 }, 
	    			'facultythesismanagementsubmitdocumentwindow button[itemId=btnThesisDocumentAddImage]':{
	    				click : this.openDocumentAddWindow
	    			}, 
	    			'facultythesismanagementsubmitdocumentwindow button[itemId=btnOtherDocumentAddImage]':{
	    				click : this.openDocumentAddWindow
	    			},
	    			'facultythesismanagementsubmitdocumentwindow button[itemId=thesisDocumentFormSubmitButtonId]':{
	    				click : this.submitThesisDocument
	    			},
	    			'facultythesismanagementsubmitdocumentwindow button[itemId=thesisDocumentFormCancelButtonId]':{
	    				click : function(button){
	    					button.up('window').close();
	    				}
	    			},
	    			'facultythesismanagementsubmitdocumentwindow dataview[itemId=thesisDocumentDataView]':{
	    				afterrender: function(dataview){
	    					var me = this;
	    					var grid = me.getFacultythesismanagementgrid();
	    					var record = grid.getSelectionModel().getSelection();
	    					var thesisManagementId = record[0].data.id;
	    					var dataViewStore = dataview.getStore();
	    					var facultythesismanagementsubmitdocumentwindow = me.getFacultythesismanagementsubmitdocumentwindow();
	    					dataViewStore.getProxy().extraParams = {
	    						thesisManagementId : thesisManagementId,
	    						documentType: 'THESIS_DOCUMENT'
	    					};
	    					dataViewStore.removeAll();
	    					dataViewStore.load({
	    						callback: function(records, operation, success) {
	    							if (success) {
	    								if(records.length > 0){
	    									facultythesismanagementsubmitdocumentwindow.down('#btnThesisDocumentAddImage').hide();
	    								}
	    								else{
	    									facultythesismanagementsubmitdocumentwindow.down('#btnThesisDocumentAddImage').show();
	    								}
	    							}
	    						}
	    					});
	    				}
	    			},
	    			'facultythesismanagementsubmitdocumentwindow dataview[itemId=otherDocumentDataView]':{
	    				afterrender: function(dataview){
	    					var me = this;
	    					var grid = me.getFacultythesismanagementgrid();
	    					var record = grid.getSelectionModel().getSelection();
	    					var thesisManagementId = record[0].data.id;
	    					var dataViewStore = dataview.getStore();
	    					dataViewStore.getProxy().extraParams = {
	    						thesisManagementId : thesisManagementId,
	    						documentType: 'OTHER_DOCUMENT'
	    					};
	    					dataViewStore.removeAll();
	    					dataViewStore.load();
	    				}
	    			},
	    			'facultythesismanagementsubmitdocumentwindow button[itemId=btnThesisDocumentDeleteImage]':{
	    				click: this.deleteThesisDocument
	    			},
	    			'facultythesismanagementsubmitdocumentwindow button[itemId=btnOtherDocumentDeleteImage]':{
	    				click: this.deleteOtherDocument
	    			},
	    			'fileuploadwin[itemId=thesisDocument] button[itemId=submitImageBtnWin]': {
	    				click: this.uploadThesisDocument
	    			},
	    			'fileuploadwin[itemId=thesisDocument] button[itemId=cancelImageBtnWin]': {
	    				click: function(btn){
	    					btn.up('window').close();
	    				}
	    			},
	    			'fileuploadwin[itemId=thesisApproveDocument] button[itemId=submitImageBtnWin]': {
	    				click: this.uploadThesisApproveDocument
	    			},
			});
		},
		onSave : function(){

		},
		checkPermissionForExport : function(grid, permissionMap){
			this.doAccessControlValidation(grid, this.getFACULTY_THESIS_MANAGEMENT_PERMISSION());
			var associatedAcadLocationIds = new Array();
	   	 	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
			var btnAdd = grid.down('#btnAdd');
			var btnEdit = grid.down('#btnEdit');
			var btnView = grid.down('#btnView');
			var btnCancelNomination = grid.down('#btnCancelNomination');
			var btnSubmitThesis = grid.down('#btnSubmitThesis');
			var btnApproveReject = grid.down('#btnApproveReject');
			Ext.each(permissionList, function(privilege) {
		   		 if (privilege === 'VIEW') {
		   			btnView.setVisible(true);      		
		   		 }else if (privilege === 'ADD') {
		   			btnAdd.setVisible(true);      		
		   		 }else if (privilege === 'EDIT') {
		   			btnEdit.setVisible(true);     		
		   		 }else if (privilege === 'CANCEL_NOMINATION') {
		   			btnCancelNomination.setVisible(true);     		
		   		 }else if (privilege === 'SUBMIT_THESIS') {
		   			btnSubmitThesis.setVisible(true);      		
		   		 }else if (privilege === 'APPROVE_REJECT') {
		   			btnApproveReject.setVisible(true);      		
		   		 }
		   	 	});
			
		},
		resetThesisManagementFilter : function(){
			var $this = this;
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var form=this.getFacultythesismanagementsearch();
			form.getForm().reset();
			var thesisStatus = form.down("#thesisStatus");
			var academicTermCombo = form.down('#academicTerm');
			var studentCombo = form.down('#thesisManagementStudent');
			var programCombo = form.down('#programId');				
			var batchComboBox = form.down('#batchId');
			var periodComboBox = form.down('#periodId');
			academicTermCombo.reset();
			studentCombo.reset();
			studentCombo.setDisabled(true);
			programCombo.reset();
			programCombo.setDisabled(true);
			batchComboBox.reset();
			batchComboBox.setDisabled(true);
			periodComboBox.reset();
			periodComboBox.setDisabled(true);
			
			var alIds=[];
			alIds.push(this.getCurrentAcademyLocation());
			var academyLocationIds = alIds.join();
			
			var thesisStatusStore = thesisStatus.getStore();
			thesisStatusStore.load();
			
			var academicTermComboStore = academicTermCombo.getStore();
			academicTermComboStore.getProxy().extraParams = {
				academyLocationIds : academyLocationIds,
				facultyId : facultyId
			};
			academicTermComboStore.load({
				callback: function(records, operation, success) {
					for(var i in records) {
						if(records[i].get('sequence') == 1) {
							academicTermId = records[i].get('id');
							academicTermCombo.setValue(academicTermId);
							studentCombo.setDisabled(false);
							programCombo.setDisabled(false);
							var programComboStore = programCombo.getStore();
							programComboStore.getProxy().extraParams = {
							academyLocationIds : academyLocationIds,
							academicTermId : academicTermId,
							facultyId: facultyId
						  };
						  programComboStore.load();
						}
					}
				}
			});

			var grid = this.getFacultythesismanagementgrid();
			grid.getStore().removeAll();
		},
		loadThesisManagementGrid : function(){
			var $this = this;
			var filterForm = $this.getFacultythesismanagementsearch();
			var formValue = filterForm.getValues();
			var facultyId = this.getCurrentlyLoggedInUser().id;
			var grid = $this.getFacultythesismanagementgrid();
			var alIds=[];
			alIds.push(this.getCurrentAcademyLocation());
			var academyLocationIds = alIds.join();
			
			grid.getStore().getProxy().extraParams= {
				facultyId:facultyId,
				academyLocationIds:academyLocationIds,
	    		academicTerm:formValue.academicTerm,
	    		admissionId:formValue.thesisManagementStudent,
	    		superVisorId:formValue.supervisorName,
	    		programId:formValue.programId,
	    		batchId:formValue.batchId,
	    		periodId:formValue.periodId,
	    		thesisStatus:formValue.thesisStatus,
	    		accessModeId:formValue.accessMode,
	    		startDate:formValue.startDate,
	    		tillDate:formValue.tillDate
	    		
	    	};
			grid.getStore().load();
			grid.getSelectionModel().deselectAll();
		},
		viewThesisManagementSupervisorDetail : function(record, grid){
			var $this = this;
			var window =  $this.getFacultythesismanagementsupervisordetailsgrid();
     		if (!window) {
     			Ext.widget('facultythesismanagementsupervisordetailsgrid');
     			window = $this.getFacultythesismanagementsupervisordetailsgrid();
     		}
     		window.show();
     		var grid = window.down('grid');
     		if(!isNullOrEmpty(record)){
     			var store = grid.getStore();
     			store.getProxy().extraParams = {
     				thesisManagementId:record.data.id
     			};
     			this.resetPageSetting(store, grid);
     			store.load({
     				callback: function(){
     	         		window.center();
     				}
     			});
     		}
		},
		showThesisManagementWindow : function() {
			var formWindow = this.getFacultythesismanagementformwin();
			if (!formWindow) {
				formWindow = Ext.widget('facultythesismanagementformwin', {
					itemId: 'thesismanagementformwinItemId'
				});

			}
			formWindow.show();
		}
		,showThesisManagementApproveRejectWindow : function() {
			var formWindow = this.getFacultythesismanagementformwin();
			if (!formWindow) {
				formWindow = Ext.widget('facultythesismanagementapproverejectwin', {
					itemId: 'thesismanagementapproverejectwinItemId'
				});

			}
			var dataview = formWindow.down('#acceptDocumentDataView');
			var store = dataview.getStore();
			store.removeAll();
			formWindow.show();
		},
		editThesisManagementWindow : function(mode,grid) {
			var formWindow = this.getFacultyeditthesismanagementformwin();
			var $this=this;
			var facultyId = $this.getCurrentlyLoggedInUser().id;
			if (!formWindow) {
				formWindow = Ext.widget('facultyeditthesismanagementformwin', {
					itemId: 'editthesismanagementformwinItemId'
				});

			}
			formWindow.show();
			if(!isNullOrEmpty(mode)){
				var isView=false;
				if(mode=="view"){
					isView=true;
				}
				var records = grid.getSelectionModel().getSelection();
				if (records != undefined && records != "" && records != null) {
        			var id = records[0].data.id;
        			Ext.Ajax.request({
        				type : 'rest',
        				url : SERVERURL.PATH_GET_THESIS_MANAGEMENT_BY_Id,
        				params : {
        					id : id
        				},
        				method : 'GET',
        				success : function(response) {
        					var data = Ext.decode(response.responseText);
        					var academicTerm = formWindow.down('#academicTermId');
        					if(data.academicTermId !=null){
        						academicTerm.store.load({
        							callback : function(records,operation,success) {
        								if (success) {
        									academicTerm.setValue(data.academicTermId);
        								}
        							}
        						});
        					} 
        					var admissionId = formWindow.down('#admissionId');
        					if(!isNullOrEmpty(data.studentId)){
    							var studentStore = admissionId.getStore();
    							studentStore.getProxy().extraParams = {
    								academyLocationIds :data.academyLocationId,
    								academicTermId:data.academicTermId,
    								facultyId : facultyId,
    								isCurrentRecord:false
    								
    							};
    							studentStore.load({
        							callback : function(records,operation,success) {
        								if (success) {
        									admissionId.setValue(data.studentId);
        								}
        							}
        						});
    						}
        					var program = formWindow.down('#programId');
        					if(!isNullOrEmpty(data.programId)){
        						var programComboStore = program.getStore();
        						programComboStore.getProxy().extraParams = {
        							academyLocationIds : data.academyLocationId,
        							academicTermId : data.academicTermId,
        							studentId:data.studentId,
        							onlyCurrentRecords:false,
        							facultyId:facultyId
        						};
        						programComboStore.load({
        							callback : function(records,operation,success) {
        								if (success) {
        									program.setValue(data.programId);
        								}
        							}
        						});
        						
        					}
        					var batch = formWindow.down('#batchId');
        					if(!isNullOrEmpty(data.batchId)){
        						var batchStore = batch.getStore();
    							batchStore.getProxy().extraParams = {
    								programId: data.programId,
    								studentId:data.studentId,
    								academicTermId:data.academicTermId,
    								onlyCurrentRecords:false,
        							facultyId:facultyId
    							}
    							batchStore.load({
        							callback : function(records,operation,success) {
        								if (success) {
        									batch.setValue(data.batchId);
        								}
        							}
        						});
        					}
        					formWindow.down('#periodId').setValue(data.periodId);
        					formWindow.down('#remarksId').setValue(data.remarks);
        					formWindow.down('#thesisManagementId').setValue(data.id);
        					formWindow.down('#thesisManagementStatusId').setValue(data.thesisManagementStatusId);
        					if(data.thesisManagementSupervisors.length==1){
        						var supervisorInformation=data.thesisManagementSupervisors[0];
        						formWindow.down('#thesisManagementSupervisorId').setValue(supervisorInformation.id);
        						var supervisor=formWindow.down('#superVisorId');
        						var supervisorStore=supervisor.getStore();
        						supervisorStore.getProxy().extraParams = {
        							academyLocationId:academyLocationId
        						}
        						supervisorStore.load({
        							callback : function(records,operation,success) {
        								if (success) {
        									supervisor.setValue(supervisorInformation.supervisor.id);
        									if(isView){
        										supervisor.setReadOnly(true);
        										var fieldContainer=formWindow.down('#panelIdH').items.items[0].items.items;
        										fieldContainer[2].setDisabled(true);
        									}
        								}
        							}
        						});
        					}else if(data.thesisManagementSupervisors.length>1){
        						var i=0;
        						Ext.each(data.thesisManagementSupervisors,function(supervisorInformation){
                                    if(i==0){
                						formWindow.down('#thesisManagementSupervisorId').setValue(supervisorInformation.id);
                						var supervisor=formWindow.down('#superVisorId');
                						var supervisorStore=supervisor.getStore();
                						supervisorStore.getProxy().extraParams = {
                							academyLocationId:academyLocationId
                						}
                						supervisorStore.load({
                							callback : function(records,operation,success) {
                								if (success) {
                									supervisor.setValue(supervisorInformation.supervisor.id);
                									if(isView){
                										supervisor.setReadOnly(true);
                										var fieldContainer=formWindow.down('#panelIdH').items.items[0].items.items;
                                                		fieldContainer[2].setDisabled(true);
                									}
                								}
                							}
                						});
                					}else{
                						$this.addMoreSuperVisor(formWindow,supervisorInformation,isView);
                					}
                                    i++;
        						});
        						
        					}
        					if(mode=="view"){
        						academicTerm.setReadOnly(true);
        						admissionId.setReadOnly(true);
        						program.setReadOnly(true);
        						batch.setReadOnly(true);
        						formWindow.down('#graduationCeremonyId').setReadOnly(true);
        						formWindow.down('#thesisManagementDroolId').setReadOnly(true);
        						formWindow.down('#remarksId').setReadOnly(true);
        						formWindow.down('#SubmitBtn').hide();
        						
        					}else{
        						academicTerm.setReadOnly(true);
        						admissionId.setReadOnly(true);
        						program.setReadOnly(true);
        						batch.setReadOnly(true);
        						formWindow.down('#SubmitBtn').show();
        						
        					}
						}
        			});
        			
        		}
				
			}
		},
		getIdValueJson : function(id, value, code) {
			if (id)
				return {
				id : id,
				value : value,
				code : code
			};
		},
		addMoreSuperVisor : function(thesisManagementform,supervisorInformation,isView) {
			var $this = this;
			var panelContiner = thesisManagementform.down('#panelIdH');
			var indx;
			var comboValue=null;
			var id=null;
			if(!isNullOrEmpty(supervisorInformation)){
				comboValue=supervisorInformation.supervisor.id;
				id=supervisorInformation.id;
			}
			if(panelContiner.items.items.length<=2){
				var panelItem = new Array();
				indx = panelContiner.items.items.length;
				panelItem.push({
					xtype : 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					scope: $this,
					defaults : {
						labelAlign : 'top',
						width:'235'
					},layout : {
						type : 'hbox'
					},
					items:[{
						xtype: 'customcombobox',
						width: 235,
						name: 'superVisor',
						store: 'common.AllUserBySmartSearch',
						valueField: 'id',
						displayField: 'value',
						queryParam:'codeOrName',
						allowBlank: false,
						typeAhead: false,
						minChars:3,
						rowIndx:indx,
						value:comboValue,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						},
						listeners:{
							render: function(combo){
								if(isView){
									combo.setReadOnly(true);
								}
							}
						}
					},{
	    				xtype: 'hidden',
	    				name: 'thesisManagementSupervisorId',
	    				itemId:'thesisManagementSupervisorId',
	    				value:id
					},
					{
						xtype: 'button',
						glyph: ICONGLYPH.DELETEGLYPH,
						itemId: 'detailedDeleteButton1OfSupervidor',
						width: 'auto',
						disabled:(isView ? true : false),
						cls: 'CustomBodyBtnReject',
						tooltip: getCommonTranslation('DELETETOOLTIP'),
						listeners:{
							click:function(obj){
								var container = obj.up('fieldcontainer');
							}
						}
					},
					{
						xtype: 'button',
						itemId: 'addDetailedBtn1',
						width: 'auto',
						cls: 'CustomBodyBtnSettings',
						width: 'auto',
						disabled:(isView ? true : false),
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),

					}]

				});
				panelContiner.add(panelItem);
				//this.setSupervisorValue();
				this.superVisorHideShowDetails(panelContiner,thesisManagementform);
				panelContiner.doLayout();
			}
		},
		superVisorHideShowDetails: function(detailedPanel,form) {
			var this$ = this;
			var cnt = detailedPanel.items.length;
			detailedPanel.items.each(function(item, index, items) {
				var addButton = item.getComponent(item.items.length - 1);
				if (index == (items - 1)) {
					if (addButton != null) {
						addButton.show();
						if(cnt == 3){
							addButton.hide();
						}
					}
				} else {
					if (addButton != null) {
						addButton.hide();
					}
				}
			});
		},
        deleteMoreDetailedOfSuperVisor: function(deleteButton,form) {
        	var this$ = this;
        	var superVisorPanel = form.down('#panelIdH');
        	var container = deleteButton.up('fieldcontainer');
        	if (container != null && superVisorPanel != null) {
        		if (superVisorPanel.items.length > 1) {
        			container.items.items[0].reset();
        			container.items.items[0].allowBlank=true;
        			container.items.items[0].validate();
        			superVisorPanel.remove(container);
        			this$.superVisorHideShowDetails(superVisorPanel,form);
        		}
        	}
        }
		,
		showCancelNomination:function(){
			var $this = this;
			var formWindow = $this.getFacultycancelnominationform();
			if (!formWindow) {
				Ext.widget('facultycancelnominationform');
				formWindow = $this.getFacultycancelnominationform();
			}
			formWindow.show();	
		},
		
		cancelNomination : function(){
			var $this = this;
			var grid=$this.getFacultythesismanagementgrid();
			var form=$this.getFacultycancelnominationform();
			var remarks = form.down('#remarkID').getValue();
			
			if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			var pk =records[0].data.id;
			var status =records[0].data.thesisStatus;
			var wsThesisManagement = {
					
					thesisStatusEnum:"CANCELLED",
					remarks:remarks,
					id:pk,
			};
			}
			submitUrl = SERVERURL.PATH_CANCEL_NOMINATION;
			$this.applyWindowMask(); 
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : wsThesisManagement,
				method : 'POST',
				success : function(response, form, action) {
					$this.hideWindowMask();
					
					if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
						showSuccessMessage(getCommonTranslation('CANCEL_NOMINATION'),getCommonTranslation('CANCELLED_STUDENT'));
						$this.getFacultycancelnominationform().close();
						$this.getFacultythesismanagementgrid().getStore().reload();
						$this.getFacultythesismanagementgrid().getSelectionModel().deselectAll();
						
					} 
				}
			});
			
			
			
		},
		saveUpdateThesisMangement:function(form){
			var $this = this;
			var submitUrl=null;
			var grid=$this.getFacultythesismanagementgrid();
			var thesisManagementForm =form.getForm();
			var values = thesisManagementForm.getValues();
			var periodId=thesisManagementForm.findField('period').getValue();
			var studentId=thesisManagementForm.findField('admission').getValue();
			var admissionId=thesisManagementForm.findField('admission').findRecord("secondId",studentId).data.id;
			var graduationCeremonyId=thesisManagementForm.findField('graduationCeremony').getValue();
			var thesisManagementDroolId=thesisManagementForm.findField('thesisManagementDrool').getValue();
			var periodCombo = this.getIdValueJson(periodId);
			var admissionCombo = this.getIdValueJson(admissionId);
			var graduationCeremonyCombo = this.getIdValueJson(graduationCeremonyId);
			var thesisManagementDroolCombo = this.getIdValueJson(thesisManagementDroolId);

			var remarks = thesisManagementForm.findField('remarks').getValue();
			var submitButton = form.down('#SubmitBtn');
			submitButton.setDisabled(true);
			var id=null;
			var thesisManagementStatusId=null;
			if (thesisManagementForm.findField('id').getSubmitValue() == null
					|| thesisManagementForm.findField('id').getSubmitValue() == "") {
				submitUrl = SERVERURL.PATH_SAVE_THESIS_MANAGEMENT;
			} else {
				id=values.id;
				thesisManagementStatusId=values.thesisManagementStatusId;
				submitUrl = SERVERURL.PATH_UPDATE_THESIS_MANAGEMENT;
			}
			var superVisiorArray = [];
			var duplicateIdMap = new Ext.util.HashMap();
			var duplicateIdFlag=false;
			if (!isNullOrEmpty(form.down('#panelIdH').items.items)
					&& form.down('#panelIdH').items.items.length > 1) {

				for (var i = 0; i < form.down('#panelIdH').items.items.length; i++) {
					var newData = {
							"supervisor" : $this.getIdValueJson(values.superVisor[i],values.superVisor[i]),
							"id":parseInt(values.thesisManagementSupervisorId[i])
					};
					if(duplicateIdMap.containsKey(values.superVisor[i])){
						duplicateIdFlag=true;
						break;
					}
					duplicateIdMap.add(values.superVisor[i], i);
					superVisiorArray.push(newData);
				}

			}else if(!isNullOrEmpty(form.down('#panelIdH').items.items)
					&& form.down('#panelIdH').items.items.length == 1){
				var newData = {
						"supervisor" : $this.getIdValueJson(values.superVisor,values.superVisor),
						"id":parseInt(values.thesisManagementSupervisorId)
				};
				superVisiorArray.push(newData);

			}
			if(duplicateIdFlag){
				showWarningMessage(getCommonTranslation('NOMINATE_STUDENT'),
						getCommonTranslation('DUPLICATE_SUPERVISOR_SELECTED')); 
				return false;
			}
			var wsThesisManagement = {
					programBatchPeriodConfiguration:periodCombo,
					admission:admissionCombo,
					graduationCeremony:graduationCeremonyCombo,
					thesisManagementDrool:thesisManagementDroolCombo,
					thesisStatusEnum:"NOMINATED",
					remarks:remarks,
					id:id,
					thesisManagementSupervisors:superVisiorArray,
					thesisManagementStatusId:thesisManagementStatusId
			};


			$this.applyWindowMask(); 
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : wsThesisManagement,
				method : 'POST',
				success : function(response, form, action) {
					$this.hideWindowMask();
					if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
						if(isNullOrEmpty(id)){
							showSuccessMessage(getCommonTranslation('NOMINATE_STUDENT'),getCommonTranslation('STUDENT_HAS_BEEN_NOMINATED_SUCCESSFULLY'));
							$this.getFacultythesismanagementformwin().close();
						}else{
							showSuccessMessage(getCommonTranslation('NOMINATE_STUDENT'),getCommonTranslation('NOMINATION_DETAILS_UPDATED_SUCCESSFULLY'));
							$this.getFacultyeditthesismanagementformwin().close();
						}
						grid.getStore().reload();
						grid.getSelectionModel().deselectAll();
						
					} 
				}
			});
		},
		approveAndRejectThesisMangement:function(form){
			var $this = this;
			var grid=$this.getFacultythesismanagementgrid();
			var remarks = form.down('#remarksId').getValue();
			var thesisStatus=form.down('#thesisStatus');
			if (grid.getSelectionModel().getCount() > 0) {
				var records = grid.getSelectionModel().getSelection();
				var thesisManagementId =records[0].data.id;
				if(thesisStatus.getValue()==getCommonTranslation("REJECTED")){
					var wsThesisManagement = {
							thesisStatusEnum:"REJECTED",
							remarks:remarks,
							id:thesisManagementId,
					};

					submitUrl = SERVERURL.PATH_CANCEL_NOMINATION;
					$this.applyWindowMask(); 
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : wsThesisManagement,
						method : 'POST',
						success : function(response, form, action) {
							$this.hideWindowMask();

							if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
								$this.getFacultythesismanagementapproverejectwin().isSave=true;
								showSuccessMessage(getCommonTranslation('ACCEPT_REJECT_THESIS'),getCommonTranslation('THESIS_DOCUMENT_REJECTED'));
								$this.getFacultythesismanagementapproverejectwin().close();
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll();
							} 
						}
					});
				}else if(thesisStatus.getValue()==getCommonTranslation("APPROVED")){
					var thesisManagement=$this.getIdValueJson(thesisManagementId);
					var accessModeId=form.down('#accessMode').getValue();
					var accessModeDate=form.down('#accessModeDate').getValue();
					var accessMode=$this.getIdValueJson(accessModeId);
					var documentArray = [];
					if(!isNullOrEmpty(form.down('#acceptDocumentDataView').getStore().data)){
						var documentData=Ext.Array.pluck(form.down('#acceptDocumentDataView').getStore().data.items,'data');
						Ext.each(documentData, function(records){
							var newData = {
									"document" : $this.getIdValueJson(records.documentId,records.documentId),
									"thesisManagement":thesisManagement,
									"thesisStatusEnum":"APPROVED",
									"documentType":"ACCEPTED_DOCUMENT"
							};
							documentArray.push(newData);
						});
					}
					var wsThesisManagementStatus = {
							thesisStatusEnum:"APPROVED",
							remarks:remarks,
							thesisManagement:thesisManagement,
							accessMode:accessMode,
							accessModeDate:accessModeDate,
							wsThesisManagementDocuments:documentArray
					};
					submitUrl = SERVERURL.PATH_THESIS_MANAGEMENT_APPROVED;
					$this.applyWindowMask(); 
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl,
						jsonData : wsThesisManagementStatus,
						method : 'POST',
						success : function(response, form, action) {
							$this.hideWindowMask();
							if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
								$this.getFacultythesismanagementapproverejectwin().isSave=true;
								showSuccessMessage(getCommonTranslation('ACCEPT_REJECT_THESIS'),getCommonTranslation('THESIS_DOCUMENT_APPROVED'));
								$this.getFacultythesismanagementapproverejectwin().close();
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll();
							} 
						}
					});
				
					
				}
			}

		},
	viewThesisStatusRecord:function(record,grid){
			
			var window =  this.getFacultythesismanagementstatusdetailgrid();
			var records = grid.getSelectionModel().getSelection();
			var pk =records[0].data.id;
     		if (!window) {
     			Ext.widget('facultythesismanagementstatusdetailgrid');
     			window = this.getFacultythesismanagementstatusdetailgrid();
     		}
     		window.show();
     		var grid = window.down('grid');
     		if(!isNullOrEmpty(record)){
     			var store = grid.getStore();
     			store.getProxy().extraParams = {
     				thesisManagementId:pk,
		    		
     			};
     			this.resetPageSetting(store, store);
     			store.load({
     				callback: function(){
     	         		window.center();
     				}
     			});
     		}
			
		},
		viewThesisStatusDocument : function(record,grid){
			var window=	this.getFacultythesismanagementstatusdocumentwindow();
			var me=this;
			var records = grid.getSelectionModel().getSelection();
			var pk =records[0].data.id;
			var status =record.raw.thesisStatusEnum;
			if (!window) {
     			Ext.widget('facultythesismanagementstatusdocumentwindow');
     			window = this.getFacultythesismanagementstatusdocumentwindow();
     		}
     		window.show();
     		var dstore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore');
			dstore.getProxy().extraParams = {
				thesisManagementId:pk,
				documentType:'ACCEPTED_DOCUMENT',
			};
			dstore.load({
				callback: function(records, operation, success){
					
					var msg = getCommonTranslation('DOUBLE_CLICK_TO_DOWNLOAD_FILE');							

					
						var imageTpl = new Ext.XTemplate(
								'<tpl for=".">',
								'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
								'<tpl else>',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="'+msg+'">',
								'</tpl>',
								'<img src="{iconImage}" />',
								'<br/><span>{imageName}</span>',
								//'<div><input type="checkbox" value="{id}" name="imageId" onclick="changePaymentPlanDeleteBtnState();" /></div>',
								'</div>',
								'</tpl>'
						);
					
				
					Ext.each(Ext.ComponentQuery.query('#krishna'), function(currentGalleryDataView){
						currentGalleryDataView.destroy();
					});
					Ext.create('Ext.view.View', {
						store:dstore,
						tpl: imageTpl,
						itemSelector: 'div.gallery-thumb-wrap',
						emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
						renderTo: window.down('#planDocDataView').body,
						itemId: 'krishna',
						height: '90%',
						deferEmptyText: false,
						style: {
							marginTop: '15px',
							marginLeft: '10px'
						},
						listeners: {
							itemclick: function( dataview, record, item, index, e, eOpts ){

							},
							itemdblclick: function(dataview, record, item, index, e, eOpts ){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
									|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
										|| extension == "txt" || extension == "odt"|| extension=="png"||extension=="jpeg"||extension=="jpg"||extension=="gif"){
									me.downloadDocumentFile(record.data.id);
								}
							}
						}
					});

				}
			});
		 console.log('in')	;
		},
		
		viewThesisManagementDetail : function(record,grid){
			var window=	this.getFacultythesismangementstatusdetailwin();
			var me=this;
			var records = grid.getSelectionModel().getSelection();
			var pk =records[0].data.id;
			var status=records[0].data.thesisStatus;
			if (!window) {
     			Ext.widget('facultythesismangementstatusdetailwin');
     			window = this.getFacultythesismangementstatusdetailwin();
     		}
     		window.show();
     		var otherStore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore');
			otherStore.getProxy().extraParams = {
				thesisManagementId:pk,
				documentType:'OTHER_DOCUMENT',
			    thesisStatus:'SUBMITTED'
			};
			otherStore.load({
				callback: function(records, operation, success){
					
					var msg = getCommonTranslation('DOUBLE_CLICK_TO_DOWNLOAD_FILE');							

					
						var imageTpl = new Ext.XTemplate(
								'<tpl for=".">',
								'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
								'<tpl else>',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="'+msg+'">',
								'</tpl>',
								'<img src="{iconImage}" />',
								'<br/><span>{imageName}</span>',
								//'<div><input type="checkbox" value="{id}" name="imageId" onclick="changePaymentPlanDeleteBtnState();" /></div>',
								'</div>',
								'</tpl>'
						);
					
				
					Ext.each(Ext.ComponentQuery.query('#krishna'), function(currentGalleryDataView){
						currentGalleryDataView.destroy();
					});
					Ext.create('Ext.view.View', {
						store:otherStore,
						tpl: imageTpl,
						itemSelector: 'div.gallery-thumb-wrap',
						emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
						renderTo: window.down('#OtherDocDataView').body,
						itemId: 'krishna',
						height: '90%',
						deferEmptyText: false,
						style: {
							marginTop: '15px',
							marginLeft: '10px'
						},
						listeners: {
							itemclick: function( dataview, record, item, index, e, eOpts ){

							},
							itemdblclick: function(dataview, record, item, index, e, eOpts ){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
									|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
										|| extension == "txt" || extension == "odt"|| extension=="png"||extension=="jpeg"||extension=="jpg"||extension=="gif"){
									me.downloadDocumentFile(record.raw.documentId);
								}
							}
						}
					});

				}
			});
			var bstore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementStatusDocumentListStore');
			bstore.getProxy().extraParams = {
				thesisManagementId:pk,
				documentType:'THESIS_DOCUMENT',
					thesisStatus:'SUBMITTED'
			};
			bstore.load({
				callback: function(records, operation, success){
					
					var msg = getCommonTranslation('DOUBLE_CLICK_TO_DOWNLOAD_FILE');							

					
						var imageTpl = new Ext.XTemplate(
								'<tpl for=".">',
								'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
								'<tpl else>',
								'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="'+msg+'">',
								'</tpl>',
								'<img src="{iconImage}" />',
								'<br/><span>{imageName}</span>',
								//'<div><input type="checkbox" value="{id}" name="imageId" onclick="changePaymentPlanDeleteBtnState();" /></div>',
								'</div>',
								'</tpl>'
						);
					
				
					Ext.each(Ext.ComponentQuery.query('#krishna1'), function(currentGalleryDataView){
						currentGalleryDataView.destroy();
					});
					Ext.create('Ext.view.View', {
						store:bstore,
						tpl: imageTpl,
						itemSelector: 'div.gallery-thumb-wrap',
						emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
						renderTo: window.down('#DocDataView').body,
						itemId: 'krishna1',
						height: '90%',
						deferEmptyText: false,
						style: {
							marginTop: '15px',
							marginLeft: '10px'
						},
						listeners: {
							itemclick: function( dataview, record, item, index, e, eOpts ){

							},
							itemdblclick: function(dataview, record, item, index, e, eOpts ){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
									|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
										|| extension == "txt" || extension == "odt"|| extension=="png"||extension=="jpeg"||extension=="jpg"||extension=="gif"){
									me.downloadDocumentFile(record.raw.documentId);
								}
							}
						}
					});

				}
			});
			console.log('in');
		}
		,
		downloadDocumentFile : function(documentId){
			var whetherFile = false;
			if(!isNullOrEmpty(documentId)){
				var csvForm = Ext.create('Ext.form.Panel'); 
	       		csvForm.getForm().submit({
	       			target: '_blank',
	       			method:'GET',
	       			params :{
	       				access_token : Ext.Ajax.defaultHeaders.access_token
	       			},
	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	       			url: SERVERURL.PATH_THESIS_DOCUMENT_FILE_DOWNLOAD + documentId,
	       			standardSubmit :true
	       		});
				
			
			}
		},
		openSubmitThesisWindow: function(grid){
			var me = this;
			var window =  me.getFacultythesismanagementsubmitdocumentwindow();
     		if (!window) {
     			Ext.widget('facultythesismanagementsubmitdocumentwindow');
     			window = me.getFacultythesismanagementsubmitdocumentwindow();
     		}
     		window.show();
		},
		openDocumentAddWindow: function(button){
			var me = this;
			var maxFileUpload = 10;
			if(button.itemId=="btnThesisDocumentAddImage"){
				var winTitle = getCommonTranslation('THESIS_DOCUMENT');
				var dataViewItemId = 'thesisDocumentDataView';
				var maxFileUpload = 1;
			}else if(button.itemId=="btnAcceptDocumentAddImage"){
				var winTitle = getCommonTranslation('DOCUMENTS');
				var dataViewItemId = 'acceptDocumentDataView';
				var dataView=button.up('window').down('#acceptDocumentDataView');
				maxFileUpload=10-dataView.getStore().data.items.length;
			}else{
				var winTitle = getCommonTranslation('OTHER_DOCUMENTS');
				var dataViewItemId = 'otherDocumentDataView';
				var dataView=button.up('window').down('#otherDocumentDataView');
				maxFileUpload=10-dataView.getStore().data.items.length;
			}
			var formWindow = me.getFileuploadwin();
			if(maxFileUpload==0){
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UPTO_10_FILES_CAN_BE_UPLOADED_MSG'));
			}else if(button.itemId=="btnAcceptDocumentAddImage"){
				if (!formWindow) {
					Ext.widget('fileuploadwin',{
						itemId:'thesisApproveDocument',
						title: winTitle,
						dataViewItemId: dataViewItemId,
						maxFileUpload: maxFileUpload,
						maxFileSize:10000,
					});
					formWindow = me.getFileuploadwin();
				}
			}else{
				if (!formWindow) {
					Ext.widget('fileuploadwin',{
						itemId:'thesisDocument',
						title: winTitle,
						dataViewItemId: dataViewItemId,
						maxFileUpload: maxFileUpload,
						maxFileSize:10000,
					});
					formWindow = me.getFileuploadwin();
				}
			}
			formWindow.maxFileUpload= maxFileUpload;
			var dataview = formWindow.down('#galleryDataViewAddWin');
			var store = dataview.getStore();
			store.removeAll();
			formWindow.show();
		},
		uploadThesisDocument: function(btn){
			var me = this;
			var grid = me.getFacultythesismanagementgrid();
			var record = grid.getSelectionModel().getSelection();
			var thesisManagementId = record[0].data.id;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var formData = new FormData();
			
			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
			var galleryStore = galleryDataViewAddWin.getStore();
			
			if(galleryStore.data.length>0){
				Ext.each(galleryStore.data.items,function(currentFile){
					formData.append("file[]", currentFile.data.fileData);
				});
			}
			btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			$.ajax({
				url: SERVERURL.PATH_THESIS_MANAGEMENT_DOCUMENT,//+'?thesisManagementId='+thesisManagementId+'&uploadedBy='+uploadedBy,
				method: 'POST',
				data: formData,
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					if(response.length){
						var window =  me.getFacultythesismanagementsubmitdocumentwindow();
						if(btn.up('window').dataViewItemId=="thesisDocumentDataView"){
							Ext.ComponentQuery.query('#'+btn.up('window').dataViewItemId)[0].getStore().removeAll();
							window.down('#btnThesisDocumentAddImage').hide();
						}
						Ext.ComponentQuery.query('#'+btn.up('window').dataViewItemId)[0].getStore().add(response);
						if(Ext.ComponentQuery.query('#thesisDocumentDataView')[0].getStore().data.items.length){
							window.down('#thesisDocumentFormSubmitButtonId').setDisabled(false);
						}
						else{
							window.down('#thesisDocumentFormSubmitButtonId').setDisabled(true);
						}
					}
					btn.up('window').close();
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
		
		},
		uploadThesisApproveDocument: function(btn){
			var me = this;
			var grid = me.getFacultythesismanagementgrid();
			var record = grid.getSelectionModel().getSelection();
			var thesisManagementId = record[0].data.id;
			var uploadedBy = this.getCurrentlyLoggedInUser().id;
			var formData = new FormData();
			
			var galleryDataViewAddWin = btn.up('form').down('#galleryDataViewAddWin');
			var galleryStore = galleryDataViewAddWin.getStore();
			
			if(galleryStore.data.length>0){
				Ext.each(galleryStore.data.items,function(currentFile){
					formData.append("file[]", currentFile.data.fileData);
				});
			}
			btn.up('window').body.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			$.ajax({
				url: SERVERURL.PATH_THESIS_MANAGEMENT_DOCUMENT,//+'?thesisManagementId='+thesisManagementId+'&uploadedBy='+uploadedBy,
				method: 'POST',
				data: formData,
				contentType: false,
				processData: false,
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				success: function (response) {
					btn.up('window').body.unmask();
					if(response.length){
						Ext.ComponentQuery.query('#'+btn.up('window').dataViewItemId)[0].getStore().add(response);
					}
					btn.up('window').close();
				},
				error: function (err) {
					btn.up('window').body.unmask();
					//console.log(err);
				}
			});
		
		},
		
		deleteThesisDocument: function(button){
			var me = this;
			showConfirmMessage(getCommonTranslation('THESIS_DOCUMENT'), getCommonTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function(btn, text) {
				if (btn == 'yes') {
					var window=me.getFacultythesismanagementsubmitdocumentwindow();
					var dataview = window.down('#thesisDocumentDataView');
					var store = dataview.getStore();
					var imageIDs = $("[name=thesisDocumentDataViewImage]:checked").map(function(){
						return $(this).val();
					}).get();
					if(imageIDs.length>0){
						var submitURL = SERVERURL.DELETE_THESIS_DOCUMENTS+'?id='+imageIDs.toString();
						Ext.Ajax.request({
							method: "GET",
							type: 'rest',
							url : submitURL,
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('THESIS_DOCUMENT'), getServiceRequestTranslation("DOCUMENT_DELETE"));	
								Ext.each(imageIDs, function(documentId) {
									store.removeAt(store.find('documentId',documentId));
								});
								button.setDisabled(true);
								window.down('#btnThesisDocumentAddImage').show();
								
								if(Ext.ComponentQuery.query('#thesisDocumentDataView')[0].getStore().data.items.length){
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(false);
								}
								else{
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(true);
								}
								
							}
						});
					}
				}
			});
		},
		
		deleteOtherDocument: function(button){
			var me = this;
			showConfirmMessage(getCommonTranslation('THESIS_DOCUMENT'), getCommonTranslation('DELETE_DOCUMENTS_CONFIRMATION_MSG'), function(btn, text) {
				if (btn == 'yes') {
					var window=me.getFacultythesismanagementsubmitdocumentwindow();
					var dataview = window.down('#otherDocumentDataView');
					var store = dataview.getStore();
					var imageIDs = $("[name=otherDocumentDataViewImage]:checked").map(function(){
						return $(this).val();
					}).get();
					if(imageIDs.length>0){
						var submitURL = SERVERURL.DELETE_THESIS_DOCUMENTS+'?id='+imageIDs.toString();
						Ext.Ajax.request({
							method: "GET",
							type: 'rest',
							url : submitURL,
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('THESIS_DOCUMENT'), getServiceRequestTranslation("DOCUMENT_DELETE"));	
								Ext.each(imageIDs, function(documentId) {
									store.removeAt(store.find('documentId',documentId));
								});
								button.setDisabled(true);
								
								if(Ext.ComponentQuery.query('#thesisDocumentDataView')[0].getStore().data.items.length){
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(false);
								}
								else{
									window.down('#thesisDocumentFormSubmitButtonId').setDisabled(true);
								}
							}
						});
					}
				}
			});
		},
		
		submitThesisDocument: function(button){
			var $this = this;
			var grid=$this.getFacultythesismanagementgrid();
			var form = button.up('window');
			var remarks = form.down('#thesisDocumentRemark').getValue();

			if (grid.getSelectionModel().getCount() > 0) {
				var records = grid.getSelectionModel().getSelection();
				var thesisManagementId =records[0].data.id;

				var thesisManagement=$this.getIdValueJson(thesisManagementId);
				
				var documentArray = [];
				if(!isNullOrEmpty(form.down('#thesisDocumentDataView').getStore().data)){
					var documentData=Ext.Array.pluck(form.down('#thesisDocumentDataView').getStore().data.items,'data');
					Ext.each(documentData, function(records){
						var newData = {
								"document" : $this.getIdValueJson(records.documentId,records.documentId),
								"thesisManagement":thesisManagement,
								"thesisStatusEnum":"SUBMITTED",
								"documentType":"THESIS_DOCUMENT"
						};
						documentArray.push(newData);
					});
				}
				if(!isNullOrEmpty(form.down('#otherDocumentDataView').getStore().data)){
					var documentData=Ext.Array.pluck(form.down('#otherDocumentDataView').getStore().data.items,'data');
					Ext.each(documentData, function(records){
						var newData = {
								"document" : $this.getIdValueJson(records.documentId,records.documentId),
								"thesisManagement":thesisManagement,
								"thesisStatusEnum":"SUBMITTED",
								"documentType":"OTHER_DOCUMENT"
						};
						documentArray.push(newData);
					});
				}
				var wsThesisManagementStatus = {
						thesisStatusEnum:"SUBMITTED",
						remarks:remarks,
						thesisManagement:thesisManagement,
//						accessMode:accessMode,
//						accessModeDate:accessModeDate,
						wsThesisManagementDocuments:documentArray
				};
				submitUrl = SERVERURL.PATH_THESIS_MANAGEMENT_APPROVED;
				$this.applyWindowMask(); 
				Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : wsThesisManagementStatus,
					method : 'POST',
					success : function(response, form, action) {
						$this.hideWindowMask();

						if (response.responseText == 'SUCCESS' || response.responseText.indexOf('<br/>') == -1) {
							showSuccessMessage(getCommonTranslation('THESIS_DOCUMENT'),getCommonTranslation('THESIS_DOCUMENT_SUBMITTED'));
							$this.getFacultythesismanagementsubmitdocumentwindow().close();
							grid.getStore().reload();
							grid.getSelectionModel().deselectAll();
						} 
					}
				});
			
				
			
			}
			
		}
		
});
