/**
 *  @author Rajkumar.Patidar
 * 
 */
Ext.define('Academia.controller.feeandpayment.payment.PaymentController', {
	extend: 'Academia.controller.base.BaseController',
	mixins: { 		
		ReceiptsController:'Academia.controller.feeandpayment.receipts.ReceiptsController',
    },
	models : ['feeandpayment.payment.CommonPaymentHeader','feeandpayment.payment.PaymentForCashAndBank',
	          'feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetails',
	          'feeandpayment.payment.BillHeaderAdjustmentDetails','feeandpayment.payment.PaymentInstrumentModel',
	          'feeandpayment.managebill.ScholarshipSmartSearch','feeandpayment.payment.OfflinePaymentDetailRecordSaveModel',
	          'feeandpayment.payment.OfflinePaymentActionDocumentModel'],
	stores : ['feeandpayment.payment.PaymentStatus','feeandpayment.managebill.BillStatus',
	          'feeandpayment.payment.PaymentForDependedFeeHead','feeandpayment.payment.PaymentForPCAndServiceProvided',
	          'feeandpayment.payment.PaymentForScholarship','feeandpayment.payment.PaymentForServiceProvided',
	          'feeandpayment.payment.PaymentForServiceReceived','feeandpayment.payment.VoucherMode',
	          'feeandpayment.payment.PaymentHeaderPCAndServiceProvidedForApplicant',
	          'feeandpayment.payment.PaymentHeaderPCAndServiceProvidedForSponsor',
	          'feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetails',
	          'feeandpayment.payment.BillHeaderAdjustmentDetails','feeandpayment.payment.PaymentInstrumentTempStore',
	          'feeandpayment.payment.PaymentVoucherNo','feeandpayment.managebill.ScholarshipSmartSearch',
	          'feeandpayment.managebill.ScholarshipStudent','feeandpayment.managebill.BillType',
	          'feeandpayment.managebill.BillFor','feeandpayment.managebill.ThirdParties',
	          'feeandpayment.managebill.Sponsors','feeandpayment.managebill.Applicant',
	          'feeandpayment.managebill.User','feeandpayment.managebill.Student','feeandpayment.managebill.BillTypeForPayment',
	          'feeandpayment.FeeCurrencyStore','feeandpayment.FeePaymentMode','feeandpayment.receipts.BillGenerationType',
	          'feeandpayment.managebill.DependentBillId','common.ProgramByAcademyLocationStore',
	          'program.programbatchdetail.BatchStore','coursetransaction.sectionmanagement.SectionMultiSelect',
	          'feeandpayment.ALUnit','feeandpayment.receipts.Bank','feeandpayment.receipts.FeeLedgerName','program.ProgramGroupStore',
	          'feeandpayment.receipts.DrawnOnBank','feeandpayment.receipts.DrawnOnBankStore','feeandpayment.managebill.BillForPayment','personinfo.common.pasthistory.TransportDetailsGridStore',
	          'feeandpayment.payment.FeeOfflinePaymentDetailGridStore','feeandpayment.payment.OfflinePaymentDocumentListStore','feeandpayment.payment.FeeOfflinePaymentReceiptNoStore',
	          'feeandpayment.payment.FeeOfflinePaymentStatusStore','feeandpayment.payment.FeeOfflinePaymentDetailMainGridStore','feeandpayment.reports.Student',
	          'importutility.ModuleName','importutility.ImportUtilityList','importutility.ImportPayments','feeandpayment.managebill.BillForPayment','feeandpayment.dashboardAndReports.DiscountFindAllUserTypeStore',
	          'feeandpayment.discount.DiscountApplicantStore', 'feeandpayment.managebill.StudentDetailsByNationalId','feeandpayment.receipts.CostCentreReceipt','feeandpayment.PaymentOnStore'],
	views : ['feeandpayment.payment.PaymentStructure','feeandpayment.payment.PaymentSearchForm',
	         'feeandpayment.payment.PaymentListForPCAndServiceProvided','feeandpayment.payment.PaymentListForDependedFeeHead',
	         'feeandpayment.payment.PaymentListForScholarship','feeandpayment.payment.PaymentListForServiceProvided',
	         'feeandpayment.payment.PaymentListForServiceReceived','feeandpayment.payment.PaymentListForPCAndServiceProvidedForSponsor',
	         'feeandpayment.payment.PaymentListForPCAndServiceProvidedForApplicant','feeandpayment.payment.ManagePaymentForm',
	         'feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetailsGridWindow',
	         'feeandpayment.payment.BillHeaderAdjustmentDetailsGridWindow','feeandpayment.payment.PaymentsForm',
	         'feeandpayment.payment.PaymentInstrumentGrid','feeandpayment.payment.PaymentHeaderStructure','personinfo.common.pasthistory.TransportPersonDetailsGrid',
	         'feeandpayment.payment.FeeOfflinePaymentDetailStructure','feeandpayment.payment.FeeOfflinePaymentDetailForm',
	         'feeandpayment.payment.FeeOfflinePaymentDetailGrid','feeandpayment.payment.ManageOfflinePaymentDetailForm',
	         'feeandpayment.payment.FeeOfflinePaymentDocumentListGrid','feeandpayment.payment.OfflinePaymentDetailMainStructure','feeandpayment.payment.FeeOfflinePaymentDetailMainForm',
	         'feeandpayment.payment.FeeOfflinePaymentDetailMainGrid','feeandpayment.payment.OfflinePaymentDocumentListWindow','feeandpayment.payment.ManageOfflinePaymentDetailMainForm',
	         'feeandpayment.payment.FeeOfflinePaymentDocumentListMainGrid','feeandpayment.payment.OfflinePaymentDocumentListMainWindow','feeandpayment.receipts.ManageReceiptForm',
	         'feeandpayment.payment.ImportPaymentStructure','feeandpayment.payment.ImportPaymentForm', 'feeandpayment.payment.DownloadPaymentForm', 
	         'feeandpayment.payment.ImportDownloadPaymentForm','importutility.ImportByModule.ImportListPayments',	
	         'personinfo.common.paymentandrefund.ReceiptGridForApplicant','admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsGrid',
             'admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionRefundsGrid','feeandpayment.payment.FeeOfflinePaymentDeatilForApplicantGrid',
             'feeandpayment.reports.FeeHeadWiseCollectionReportForm','feeandpayment.reports.FeeHeadWiseCollectionReportGrid','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportForm','feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportGrid',
			 'programCourseDashboard.organizationUnit.OrganizationUnit'],	
	         
     config: {
         
       	 /* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
        		   	 
	   	*//**
	        * @cfg {Array} MANAGE_PAYMENT_PERMISSIONS array (required)
	        * The array of permissions to use for Access control wise enabling and disabling buttons.
	        * @accessor
	        */
    	 STUDENT_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PAYMENT_PRIVILEGES'),
    	 APPLICANT_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_FEE_PAYMENT_PRIVILEGES'),
    	 SPONSOR_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SPONSOR_PAYMENT_PRIVILEGES'),
    	 THIRDPARTY_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('THIRDPARTY_PAYMENT_PRIVILEGES'),
    	 USER_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('USER_PAYMENT_PRIVILEGES'),
    	 SRANDUSER_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SRANDUSER_PAYMENT_PRIVILEGES'),
    	 SCHOLARSHIPANDSTUDENT_PAYMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIPANDSTUDENT_PAYMENT_PRIVILEGES'),
    	 MANAGE_PAYMENTS_PETMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENTS_PRIVILEGES'),
    	 PAYMENT_BULK_IMPORT_UTILITY_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PAYMENT_BULK_IMPORT_UTILITY_PRIVILEGES'),
    	 PAYMENT_LIST_FOR_PC_SERVICEPROVIDED_FOR_APPLICANT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_APPLICANT_GRID_PRIVILEGES'),
    	 PAYMENT_LIST_FOR_PC_AND_SERVICEPROVIDED: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_FOR_PC_AND_SERVICEPROVIDED_GRID_PRIVILEGES'),
    	 PAYMENT_LIST_FOR_PC_SERVICEPROVIDED_FOR_SPONSOR: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_SPONSOR_GRID_PRIVILEGES'),
    	 PAYMENT_LIST_FOR_SCHOLARSHIP:  Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_FOR_SCHOLARSHIP_GRID_PRIVILEGES'),
    	 MANAGE_OFFLINE_PAYMENT:  Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_OFFLINES_PAYMENT_GRID_CONFIGURATION'),
    	 PAYMENT_LIST_FOR_SERVICE_PROVIDED: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_SERVICE_PROVIDED_USER_GRID_PRIVILEGES'),
    	 PAYMENT_LIST_FOR_SERVICE_RECEIVED: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_SERVICE_RECEIVED_USER_GRID_PRIVILEGES'),
    	 MANAGE_PAYMENT_FOR_INACTIVE_STUDENT: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_FOR_INACTIVE_STUDENT'),
    	 MANAGE_PAYMENT_PRIVILEGES:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_PAYMENT_PRIVILEGES'),
       },     	         

	refs : [{
        	   ref:'paymentstructure',
        	   selector:'paymentstructure'
	       },{
	    	   ref:'paymentlistforpcandserviceprovided',
        	   selector:'paymentlistforpcandserviceprovided'
	       },{
	    	   ref:'paymentlistforscholarship',
        	   selector:'paymentlistforscholarship'
	       },{
	    	   ref:'paymentlistforserviceprovided',
        	   selector:'paymentlistforserviceprovided'
	       },{
	    	   ref:'paymentlistfordependedfeehead',
        	   selector:'paymentlistfordependedfeehead'
	       },{
	    	   ref:'paymentlistforservicereceived',
        	   selector:'paymentlistforservicereceived'
	       },{
	    	   ref:'paymentsearchform',
        	   selector:'paymentsearchform'
	       },{
	    	   ref:'paymentlistforpcandserviceprovidedforsponsor',
	    	   selector:'paymentlistforpcandserviceprovidedforsponsor'
	       },{
	    	   ref:'paymentlistforpcandserviceprovidedforapplicant',
	    	   selector:'paymentlistforpcandserviceprovidedforapplicant'
	       },{
	    	   ref:'managepaymentform',
	    	   selector:'managepaymentform'
	       },{
	    	   ref:'contentPanel',
	    	   selector:'contentPanel'
	       },{
	    	   ref:'paymentheaderinstrumentadjustmentdetailsgridwindow',
	    	   selector:'paymentheaderinstrumentadjustmentdetailsgridwindow'
	       },{
	    	   ref:'billheaderadjustmentdetailsgridwindow',
	    	   selector:'billheaderadjustmentdetailsgridwindow'
	       },{
	    	   ref:'adjustmentstructure',
	    	   selector:'adjustmentstructure'
	       },{
	    	   ref:'paymentsform',
	    	   selector:'paymentsform'
	       },{
	    	   ref:'paymentAddressDetailPanel',
	    	   selector:'addressdetailpanel[itemId=paymentaddressdetailpanel]'
	       },{
	    	   ref:'paymentHeaderStructure',
	    	   selector:'paymentheaderstructure'
	       },{
          	 ref : 'pendingbillsgrid',
        	 selector : 'pendingbillsgrid'
         },{
        	 ref : 'paymentreceivedhistorygrid',
        	 selector : 'paymentreceivedhistorygrid'
         },{
        	 ref : 'refundhistorygrid',
        	 selector : 'refundhistorygrid'
         },{
        	 ref : 'hostelpersondetailsgrid',
        	 selector : 'hostelpersondetailsgrid[itemId=paymenthostelpersondetailsgrid]'
         },{
        	 ref : 'transportpersondetailsgrid',
        	 selector : 'transportpersondetailsgrid[itemId=paymenttransportpersondetailsgrid]'
         },{
        	 ref : 'feeofflinepaymentdetailform',
        	 selector : 'feeofflinepaymentdetailform'
         },{
        	 ref : 'feeofflinepaymentdetailgrid',
        	 selector : 'feeofflinepaymentdetailgrid'
         },{
        	 ref : 'contentpanel',
        	 selector : 'contentpanel'
         },{
        	 ref : 'manageofflinepaymentdetailform',
        	 selector : 'manageofflinepaymentdetailform'
         },{
        	 ref : 'feeofflinepaymentdocumentlistgrid',
        	 selector : 'feeofflinepaymentdocumentlistgrid' 
         },{
        	 ref : 'simpledocumentform',
        	 selector : 'simpledocumentform'
         },{
        	 ref : 'offlinepaymentdocumentlistwindow',
        	 selector : 'offlinepaymentdocumentlistwindow'
         },{
        	 ref : 'feeofflinepaymentdetailmainform',
        	 selector : 'feeofflinepaymentdetailmainform' 
         },{
        	 ref : 'feeofflinepaymentdetailmaingrid',
        	 selector : 'feeofflinepaymentdetailmaingrid' 
         },{
        	 ref : 'manageofflinepaymentdetailmainform',
        	 selector : 'manageofflinepaymentdetailmainform' 
         },{
        	 ref : 'feeofflinepaymentdocumentlistmaingrid',
        	 selector : 'feeofflinepaymentdocumentlistmaingrid' 
         },{
        	 ref : 'offlinepaymentdocumentlistmainwindow',
        	 selector : 'offlinepaymentdocumentlistmainwindow' 
         },{
        	 ref : 'managereceiptform',
        	 selector : 'managereceiptform' 
         },
         {
        	 ref : 'importpaymentstructure',
        	 selector : 'importpaymentstructure' 
         },
         {
        	 ref : 'importpaymentform',
        	 selector : 'importpaymentform'
         },
         {
        	 ref : 'downloadpaymentform',
        	 selector : 'downloadpaymentform'
         },
         {
        	 ref : 'importdownloadpaymentform',
        	 selector : 'importdownloadpaymentform'
         },{
        	 ref : 'importlistpayments',
        	 selector : 'importlistpayments'
         },
         {
        	 ref : 'importpaymentuploadoptionradiogroup',
        	 selector : 'uploadoptionradiogroup[itemId=importpaymentUploadOptionRadioGroupItemId]'
         },{
       	   ref : 'receiptgridforapplicant',
    	   selector : 'receiptgridforapplicant' 
       }
       ,{
     	   ref : 'preadmissionpaymentsgrid',
    	   selector : 'preadmissionpaymentsgrid' 
       },{
     	   ref : 'preadmissionrefundsgrid',
    	   selector : 'preadmissionrefundsgrid' 
       },{
    	  
    	   ref : 'offlinepaymentdetailmainstructure',
    	   selector : 'offlinepaymentdetailmainstructure'
       },{
    	   ref : 'feeofflinepaymentdeatilforapplicantgrid',
    	   selector : 'feeofflinepaymentdeatilforapplicantgrid'
       },{
  			ref : 'feeheadwisecollectionreportform',
			selector : 'feeheadwisecollectionreportform'
		},{
			ref : 'feeheadwisecollectionreportgrid',
			selector : 'feeheadwisecollectionreportgrid'
		},
		{
			ref:'applicantfeeheadwisecollectionreportform',
			selector:'applicantfeeheadwisecollectionreportform'
		},
		{
			ref:'applicantfeeheadbasedcollectionreportgrid',
			selector:'applicantfeeheadbasedcollectionreportgrid'
		},{
			ref:'applicantfeeheadwisecollectionreportgrid',
			selector:'applicantfeeheadwisecollectionreportgrid'
		},{
			ref : 'organizationunit',
			selector : 'organizationunit'
		}
         ],

      init : function() {
    	  this.managepaymentFormMode=null;
    	  this.control({
    		  'paymentstructure': {
    			  render: function(structure) {
      				this.disablePaymentImportTab(structure, this.getPAYMENT_BULK_IMPORT_UTILITY_PERMISSION());
      			}
    		  },
    		  'paymentheaderstructure':{
    			
    			afterrender : function(structure){
    			  var $this = this;
    			  var result;
		    	  var grid;
		    	  var academyLocationId = $this.getCurrentAcademyLocation();
		    	  Ext.Ajax.request({
		    		  method: "GET",
		    		  type: 'rest',
		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
		    		  params:{
		    			  academyLocationId:academyLocationId
		    		  },
		    		  success: function(response) {
		    			  if(response){
		    				  result=response.responseText;	
		    			  }
		    	    		  structure.down("#paymentlistforpcandserviceprovided").setVisible(true);
		    	    		  grid=structure.down("#paymentlistforpcandserviceprovided");
		    	    		  if(result=="false"){
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length!=null && length!=""){
		    	 					 for(var i=0; i<length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='totalConvertedAmount'){
		    	 							 gridColumns[i].setVisible(false);
		    	 						 }
		    	 					 }
		    	 				 }
		    	 			  }else{
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length!=null && length!=""){
		    	 					 for(var i=0; i<length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='totalConvertedAmount'){
		    	 							 gridColumns[i].setVisible(true);
		    	 						 }
		    	 					 }
		    	 				 }
		    	    	  }
		    		  }
		    	  });
    			  var searchForm = structure.items.items[0];
   				  structure.body.on('scroll', function(e, target) {
    				  var pcstructure = structure.down("#paymentlistforpcandserviceprovided");
    				  var scholarshipstructure = structure.down("#paymentlistforscholarship");
    				  var serviceprovidedstructure = structure.down("#paymentlistforserviceprovided");
    				  var servicereceivedstructure = structure.down("#paymentlistforservicereceived");
    				  var dependendfeestructure =  structure.down("#paymentlistfordependedfeehead");
    				  var sponsorestructure= structure.down('#paymentlistforpcandserviceprovidedforsponsor');
    				  var applicantstructure= structure.down('#paymentlistforpcandserviceprovidedforapplicant');
    				  var academyLocationId = $this.getCurrentAcademyLocation();
    				  var grid = null;
    				//  var checkCurrency =null;
    				  
    				  if(!pcstructure.isHidden()){
    					  grid = pcstructure;
    				  }
    				  if(!scholarshipstructure.isHidden()){
    				      grid = scholarshipstructure;
    				  }
    				  if(!serviceprovidedstructure.isHidden()){
    					  grid = serviceprovidedstructure;
    				  }
    				  if(!servicereceivedstructure.isHidden()){
    					  grid = servicereceivedstructure;
    				  } 
    				  if(!dependendfeestructure.isHidden()){
    					  grid = dependendfeestructure;
    				  }
    				  if(!sponsorestructure.isHidden()){
    					  grid = sponsorestructure;
    				  }
    				  if(!applicantstructure.isHidden()){
    					  grid = applicantstructure;
    				  }	 
					grid.config.searchFilterForm =searchForm;

    				  $this.getMultipleGridHeaderFreeze(grid,structure);
				 });
    				  
    			}  
    		  },

    		  'paymentsearchform customcombobox[itemId=billType]':{
    			  select:function(){
    				  $this=this
    				   var form=this.getPaymentsearchform().getForm();
						var billType=form.findField('billType').getValue();

							if(billType=="SCHOLARSHIP"){
							form.findField('inactiveStudents').setVisible(false);
							}
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=billFor]':{
    			  select:function(){
    				  $this=this
    				  var result;
    		    	  var grid;
    		    	  var academyLocationId = this.getCurrentAcademyLocation();
                       var form=this.getPaymentsearchform().getForm();
						var billType=form.findField('billType').getValue();

						var billFor=form.findField('billFor').getDisplayValue();
						if(billFor=="Sponsor" || billFor=="User" ||billFor=="Applicant"){
							form.findField('inactiveStudents').setVisible(false);
						}else{
							form.findField('inactiveStudents').setVisible(true);
						}
						if(billFor=="Student"){
							if(billType=="SCHOLARSHIP"){
							form.findField('inactiveStudents').setVisible(false);
							}
						}
    		    	  Ext.Ajax.request({
    		    		  method: "GET",
    		    		  type: 'rest',
    		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
    		    		  params:{
    		    			  academyLocationId:academyLocationId
    		    		  },
    		    		  success: function(response) {
    		    			  if(response){
    		    				  result=response.responseText;	
    		    			  }
    		    			  $this.showHideSmartSearch(result);
    		    		  }
    		    	  });
    			  }
    		  },
    		  'paymentsearchform button[itemId=resetBtn]':{
    			  click:function(){
    				  this.getResetPaymentForm();
    			  }
    		  },
    		  'paymentsearchform customcombobox#billType': {
    			  afterrender:function(obj){
    				  var store=obj.getStore();
    				  store.on('beforeload',function() {
    					  store.getProxy().extraParams = {
    						  screenType:'payment'
    					  };
    				  }, this);
    			  },
    			  select: function(obj, record) {
    			var form=this.getPaymentsearchform().getForm();
				var paymentlistforpcandserviceprovidedGrid = this.getPaymentlistforpcandserviceprovided();
                var paymentlistforpcandserviceprovidedforapplicantGrid = this.getPaymentlistforpcandserviceprovidedforapplicant();
                var paymentlistforservicereceivedGrid = this.getPaymentlistforservicereceived();
                var paymentlistforpcandserviceprovidedforsponsorGrid = this.getPaymentlistforpcandserviceprovidedforsponsor();
                var paymentlistforscholarshipGrid = this.getPaymentlistforscholarship();
                var paymentlistforserviceprovidedGrid = this.getPaymentlistforserviceprovided();


				paymentlistforpcandserviceprovidedGrid.config.searchFilterForm = this.getPaymentsearchform();
				paymentlistforpcandserviceprovidedforapplicantGrid.config.searchFilterForm = this.getPaymentsearchform();
				paymentlistforservicereceivedGrid.config.searchFilterForm = this.getPaymentsearchform();
				paymentlistforpcandserviceprovidedforsponsorGrid.config.searchFilterForm = this.getPaymentsearchform();
				paymentlistforscholarshipGrid.config.searchFilterForm = this.getPaymentsearchform();
				paymentlistforserviceprovidedGrid.config.searchFilterForm = this.getPaymentsearchform();

    				  var raiseBillType = record[0].get("id");
    				  if(raiseBillType != null){
    					//  var store = this.getStore('feeandpayment.managebill.BillForPayment');
    					  var billForField = form.findField('billFor');
    					  var billForStore = billForField.getStore();
    					  billForStore.getProxy().extraParams = {
    						  raiseBillType: raiseBillType,
    						  screenType:'payment'
    					  };
    					  billForStore.load();                    
    				  }
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=academy]':{
    			  change:function(obj,record){
    				  var academyId = record.join();
    					  var store = this.getStore('feeandpayment.Location');
    					  store.getProxy().extraParams = {
    						  academyIds: academyId
    					  },
    					  store.load();                    
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=location]':{
    			  change:function(obj,record){
    				  var locationId = record.join();
    					  var store = this.getStore('facilitiesresources.resourcemaster.ProgramGridStore');
    					  store.getProxy().extraParams = {
    						  academyLocationIds: locationId
    					  },
    					  store.load();                    
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=student]':{
    			  select:function(obj,record){
    				  var form = this.getPaymentsearchform();
    				  var billedUserTypeId = form.down("#billFor").getValue();
    				  var billedUserType = form.down("#billFor").getRawValue();
    				  var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    				  this.billNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    			  },
                   change:function(obj,record){
    				 var form = this.getPaymentsearchform();
                    var studentField = form.down("#student");
                  var studentFieldStore = studentField.getStore();
                var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
               var isInactive = form.down("#inactiveStudentItemId").getValue();
                var ALsId = [];
      	       for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
               studentFieldStore.getProxy().extraParams = {
            	   		   academyLocationIds: academyLocationIds,
        				   limit :500,
                           isInactive:isInactive,
                           studentNameOrCode:record
      				 };
                  if(record!=null && record.length>=3){
	                 studentFieldStore.load();
}
    				  
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=thirdParty]':{
    			  select:function(obj,record){
    				  var form = this.getPaymentsearchform();
    				  var billedUserTypeId = form.down("#billFor").getValue();
    				  var billedUserType = form.down("#billFor").getRawValue();
    				  var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    				  this.billNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=sponsors]':{
    			  select:function(obj,record){
    				  var form = this.getPaymentsearchform();
    				  var billedUserTypeId = form.down("#billFor").getValue();
    				  var billedUserType = form.down("#billFor").getRawValue();
    				  var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    				  this.billNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=applicant]':{
    			  select:function(obj,record){
    				  var form = this.getPaymentsearchform();
    				  var billedUserTypeId = form.down("#billFor").getValue();
    				  var billedUserType = form.down("#billFor").getRawValue();
    				  var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    				  this.billNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=userId]':{
    			  select:function(obj,record){
    				  var form = this.getPaymentsearchform();
    				  var billedUserTypeId = form.down("#billFor").getValue();
    				  var billedUserType = form.down("#billFor").getRawValue();
    				  var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    				  this.billNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    			  }
    		  },
    		  'paymentsearchform customcombobox[itemId=scholarshipStudent]':{
    			  select:function(obj,record){
    				  var form = this.getPaymentsearchform();
    				  var billedUserTypeId = form.down("#billFor").getValue();
    				  var billedUserType = form.down("#billFor").getRawValue();
    				  var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    				  this.billNoSearch(billedUserTypeId,billedUserType,record[0].get("id"),academyLocationId);
    			  }
             },
    		  'paymentsearchform multiselectcombofield[itemId=program]':{
    			  change:function(obj,record){
    				  var value = obj.getValue();
    				  var form = this.getPaymentsearchform();
    				  form.down("#batch").reset();
    				  form.down("#batch").clearAllDataFn();
    				  form.down("#section").reset();
    				  form.down("#section").clearAllDataFn();
    				  form.down("#batch").setDisabled(true);
    				  form.down("#section").setDisabled(true);
    				  if(value.length>0){
        			  form.down("#batch").setDisabled(false);
        			  if(!Ext.isObject(record[0])){
    				  var programId = record.join();
    					  var store = this.getStore('program.programbatchdetail.BatchStore');
    					  store.getProxy().extraParams = {
    						  programIds: programId
    					  },
    					  store.load();
        			  }
    			  }
    			  }
    		  },
    		  'paymentsearchform multiselectcombofield[itemId=batch]':{
    			  change:function(obj,record){
    				  var value = obj.getValue();
    				  var form = this.getPaymentsearchform();
    				  form.down("#section").reset();
    				  form.down("#section").clearAllDataFn();
					  form.down("#section").setDisabled(true);
    				  if(value.length>0){
        			  form.down("#section").setDisabled(false);
        			  if(!Ext.isObject(record[0])){
    				  var batchId = record.join();
    					  var store = this.getStore('coursetransaction.sectionmanagement.SectionMultiSelect');
    					  store.getProxy().extraParams = {
    						  batchIds: batchId
    					  },
    					  store.load(); 
        			  }
    			  }
    			  }
    		  },
    		  'paymentsearchform customcombobox#feePlanType':{
    			  select: function(obj, record) {
    				  var feePlanTypeId = record[0].get("id");
    				  if(feePlanTypeId > 0){
    					  var store = this.getStore('feeandpayment.FeePlan');
    					  store.getProxy().extraParams = {
    						  feePlanTypeId: feePlanTypeId
    			      },
    					  store.load();
    				  }
    			  }
    		  },
    		  'paymentsearchform customcombobox#feePlan':{
    			  select: function(obj, record) {
    				  var feePlanId = record[0].get("id");
    				  if(feePlanId > 0){
    					  var store = this.getStore('feeandpayment.FeeHeads');
    					  store.getProxy().extraParams = {
    						  feePlanId: feePlanId
    			      },
    					  store.load();
    				  }
    			  }

    		  },
    		  'paymentsearchform button[itemId=searchBtn]':{
    			  click:function(){
				  var form1=this.getPaymentsearchform();
    			  var paymentHeaderStructure = this.getPaymentHeaderStructure();	  
    			  var structure = this.getPaymentsearchform();
    				  
    			  var pcstructure = paymentHeaderStructure.down("#paymentlistforpcandserviceprovided");
    			  var serviceProvided = paymentHeaderStructure.down("#paymentlistforserviceprovided");
    			  var dependentstructure = paymentHeaderStructure.down("#paymentlistfordependedfeehead");
    			  var scholarshipstructure = paymentHeaderStructure.down("#paymentlistforscholarship");
    			  var servicereceivedstructure =  paymentHeaderStructure.down("#paymentlistforservicereceived");
    			  var pcservicereceivedforapplicantstructure= paymentHeaderStructure.down('#paymentlistforpcandserviceprovidedforapplicant');
    			  var pcservicereceivedforsponsorstructure= paymentHeaderStructure.down('#paymentlistforpcandserviceprovidedforsponsor');
	    			  
			  var pcorspAndStudentGrid =  this.getPaymentlistforpcandserviceprovided(); // student
			  
			  
			  pcorspAndStudentGrid.config.searchFilterForm = form1;

    			  var isEnum = false;
    			  if(!pcstructure.isHidden()){
    			      this.getPaymentHeaderGridForPC(pcstructure,isEnum);
    			  }
    			  if(!serviceProvided.isHidden()){
    				  this.getPaymentHeaderGridForServiceProvidedForUser(serviceProvided,isEnum);//pending
    			  }
    			  if(!dependentstructure.isHidden()){
    				  this.getPaymentHeaderGridForDependentFee(dependentstructure,isEnum);
    			  }
			      if(!scholarshipstructure.isHidden()){
			    	  this.getPaymentHeaderGridForScholarship(scholarshipstructure,isEnum);
			      } 
    			  if(!servicereceivedstructure.isHidden()){
    			      this.getPaymentHeaderGridForServiceReceived(servicereceivedstructure,isEnum);
    			  	}
    			  if(!pcservicereceivedforapplicantstructure.isHidden()){
    			      this.getPaymentHeaderGridForPCAndServiceReceivedForApplicant(pcservicereceivedforapplicantstructure,isEnum);//pending
    			  	}
    			  if(!pcservicereceivedforsponsorstructure.isHidden()){
    			      this.getPaymentHeaderGridForPCAndServiceReceivedForSponsor(pcservicereceivedforsponsorstructure,isEnum);//pending
    			  	}
    			  }
    		  },
    		  'paymentsearchform multiselectcombofield[itemId=program]' : {
            	afterrender : function(combo) {
            		var form=this.getPaymentsearchform();
            		var alField = form.down('#fnpMultiBrandCampusPaymentItemId')
            		var store = combo.getStore();
            		store.on('beforeload',function() {
            			var academyLocationIds = null;
            			var multiselectAcademyLocation=alField.getValue();
            			var ALsId = [];
            			for(var i in multiselectAcademyLocation){
            				if(!isNullOrEmpty(multiselectAcademyLocation[i]) && typeof multiselectAcademyLocation[i]=='object'){
            					ALsId.push(multiselectAcademyLocation[i].data.id);
            				}else{
            					ALsId.push(multiselectAcademyLocation[i]);
            				}
            			}
            			store.getProxy().extraParams = {
            				academyLocationIds: ALsId.join()
            			};
            		}, this);
            	}
    		   },
    		  //*********SearchForm RaiseBillType And RaiseBill For Default Value Setting********//
    		  'paymentsearchform':{
    			render:function(){
    				var $this=this;
    				var form=this.getPaymentsearchform().getForm();
 					var costCenter = form.findField("costCentre");
                     costCenter.setFieldLabel(getFeeAndPaymentCommonTranslation("COST_CENTER"));
					var academyLocationId = this.getCurrentAcademyLocation();
    				var billTypeField = form.findField('billType');
    				$this.setAllowBlank(form.findField('scholarship'),true);
    				var billTypeStore=billTypeField.getStore();
    				 billTypeStore.getProxy().extraParams = {
    					screenType: 'payment'
  					 };
    				var billForField = form.findField('billFor');
    				var billForStore = billForField.getStore();
    				var programStore = form.findField('program').getStore();
    				programStore.getProxy().extraParams={
    					academyLocationIds:academyLocationId
    				};
    				//programStore.load();
    				
    				billTypeStore.load({
       					callback: function(record, operation, success) {
       						if (success) {
       							billTypeField.setValue(record[0].data.id);
       							
       							billForStore.load({
       								params : {
       									raiseBillType : record[0].data.id,
       									screenType:'payment'
       								},
       		       					callback: function(rec, operation, success) {
       		       						if (success) {
       		       						   billForField.setValue(rec[0].data.id);
       		       						 // $this.paymentVoucherNoSearch(rec[0].data.id,rec[0].data.value,null,academyLocationId);
       		       						 //  $this.billNoSearch(rec[0].data.id,rec[0].data.value,null,academyLocationId);
       		       						}
       		       					}
       		       				});
       						}
       					}
       				});
   				 if(academyLocationId>0){
   					 var store = this.getStore('common.ProgramByAcademyLocationStore');
   					 store.getProxy().extraParams = {
   						 academyLocationId: academyLocationId
   					 };                             
				
   					 //store.load();
		  	  
   				 }
   			  var pcorspAndStudentGrid =  this.getPaymentlistforpcandserviceprovided(); // student
			  this.doAccessControlValidation(pcorspAndStudentGrid, this.getSTUDENT_PAYMENT_PRIVILEGES());
			  var pcorspAndapplicantGrid =  this.getPaymentlistforpcandserviceprovidedforapplicant(); // applicant
			  this.doAccessControlValidation(pcorspAndapplicantGrid, this.getAPPLICANT_PAYMENT_PRIVILEGES());
			  var pcorspAndSponsorGrid =  this.getPaymentlistforpcandserviceprovidedforsponsor(); //sponsor 
			  this.doAccessControlValidation(pcorspAndSponsorGrid, this.getSPONSOR_PAYMENT_PRIVILEGES());
			  var spAndUserGrid =  this.getPaymentlistforserviceprovided(); //sp and user
			  this.doAccessControlValidation(spAndUserGrid, this.getUSER_PAYMENT_PRIVILEGES());
			  var scholarshipAndStudentGrid =  this.getPaymentlistforscholarship(); // scholarship
			  this.doAccessControlValidation(scholarshipAndStudentGrid, this.getSCHOLARSHIPANDSTUDENT_PAYMENT_PRIVILEGES());
			  var srAndUserGrid= this.getPaymentlistforservicereceived(); // sr and user
			  this.doAccessControlValidation(srAndUserGrid, this.getSRANDUSER_PAYMENT_PRIVILEGES());
			  var dfhAndThirdPartyGrid =  this.getPaymentlistfordependedfeehead();// third Partry
			  this.doAccessControlValidation(dfhAndThirdPartyGrid, this.getTHIRDPARTY_PAYMENT_PRIVILEGES());
			  
			  this.disablePaymentAcademyLocationPivileges(form, this.getMANAGE_PAYMENTS_PETMISSION());
	
    			}, 
    			afterrender: function() {
    				var form=this.getPaymentsearchform().getForm();
    				var costCenter = form.findField("costCentre");
    				costCenter.setFieldLabel(getFeeAndPaymentCommonTranslation("COST_CENTER"));
    			}
    			
    		  },
    		//*********ManagePaymentForm RaiseBillType And RaiseBill For Default Value Setting********//
    		  'managepaymentform':{
    			  render:function(){
    				  var $this = this;
    				  var academyLocationId = this.getCurrentAcademyLocation();
    				  var form=this.getManagepaymentform().getForm();
    				  var currencyField = form.findField('paymentCurrency');
    				  var iauField = form.findField('payingIAU');
    				  var paymentToField = form.findField('paymentTo');
    				  var paymentToFieldStore = paymentToField.getStore();
    				  var paymentForField = form.findField('paymentFor');
    				  var paymentForStore = paymentForField.getStore();
    				 
    				  var instrumentDateField = form.findField('instrumentDate');
    				  instrumentDateField.setMaxValue(false);
    				  instrumentDateField.setMinValue(false);
    				  var defaultBankAccount=form.findField('drawnOnBank');
    				  var defaultBankAccountStore=defaultBankAccount.getStore();
    				  
    				  var scholarshipFormField = form.findField('scholarship');
    				  var scholarshipFormStore = scholarshipFormField.getStore();
    				  
    				  
    				  
    				  
    				  defaultBankAccountStore.load({
   					   params:{
   						   defaultAccount:0,
						   academyLocationIds:academyLocationId
   					   },
   					   callback: function(record, operation, success) {
						   if (success) {
							   for(i=0;i<record.length;i++)
							   {
							   if(record[i].data.sequence!=null)
								   {
								   defaultBankAccount.setValue(record[i].data.id);
								   }
							   }
				   }
					   }
   				   });
    				  
    				  scholarshipFormStore.getProxy().extraParams ={
   					   academyLocationIds:academyLocationId
   				   };
    				  scholarshipFormStore.load();

    				  paymentToFieldStore.load({
    					  params:{
    						screenType:'add'  
    					  },
    					  callback: function(record, operation, success) {
    						  if (success) {
    							  paymentToField.setValue(record[0].data.id);

    							  paymentForStore.load({
    								  params : {
    									  raiseBillType : record[0].data.id
    								  },
    								  callback: function(rec, operation, success) {
    									  if (success) {
    										  paymentForField.setValue(rec[0].data.id);
    										  $this.checkpaymentFor();
    										  // disable to smart search validation
    										  /*Ext.defer(function() {
    											  $this.checkpaymentFor();
    							        		 }, 0.5, $this);*/
    									  }
    								  }
    							  });
    						  }
    					  }
    				  });
    				  Ext.Ajax.request({
    					  method: "GET",
    					  type: 'rest',
    					  url: SERVERURL.DEFAULT_ORGANIZATION_UNIT_CURRENCY,
    					  params:{
    						  academyLocationId:academyLocationId
    					  },
    					  success: function(f, action) {
    						  defaultcurrncyId = Ext.JSON.decode(f.responseText);
    						  var currencyStore = currencyField.getStore();
    						  currencyStore.load({
    							  callback: function(rec, operation, success) {
    								  if (success) {
    									  if(!isNullOrEmpty(defaultcurrncyId)){
    										  currencyField.setValue(defaultcurrncyId.id);
    									  }
    								  }
    							  }
    						  });
    					  }
    				  });
    				  //for Create Payment Screen
    				  Ext.Ajax.request({
    					  method: "GET",
    					  type: 'rest',
    					  url: SERVERURL.BASE_CURRENCY_ACADEMY_LOCATION,
    					  params:{
    						  academyLocationId:academyLocationId
    					  },
    					  success: function(f, action) {
    						  var aaa = Ext.JSON.decode(f.responseText);
    		                  var currencyStore = currencyField.getStore();
    		                  currencyStore.getProxy().extraParams = {
    		                  academyLocationId:academyLocationId
    		                  };
    		                  currencyStore.load({
    		                  callback: function(rec, operation, success) {
    		                  for(var i in rec){
    		                   if(rec[i].data.id==aaa.id){
    		                  currencyField.setValue(rec[i].data.id);
    		                   }
    		                   }
    		               
    		                  }
    		                  });
    		                         
    					  }
    				  });

    				  Ext.Ajax.request({
    					  method: "GET",
    					  type: 'rest',
    					  url: SERVERURL.DEFAULT_ORGANIZATION_IAU,
    					  params:{
    						  academyLocationId:academyLocationId
    					  },
    					  success: function(f, action) {
    						  defaultIAUId = Ext.JSON.decode(f.responseText);
    						  var iauStore = iauField.getStore();
    						  iauStore.load({
    							  callback: function(rec, operation, success) {
    								  if (success) {
    									  if(!isNullOrEmpty(defaultIAUId)){
    										  iauField.setValue(defaultIAUId.id);
    									  }
    								  }
    							  }
    						  });
    					  }
    				  });	
    			  } ,
    			  afterrender:function(form) {
    				  form.down("#costCentre").setFieldLabel(getFeeAndPaymentCommonTranslation('COST_CENTER'));
    				  if(this.managepaymentFormMode!='VIEW'){
    					  this.showHidepaymentOnFieldFromDFR('STUDENT');
    				  }
    			  }
    		  },
    		  // ***** add button for P_AND_C_FEE and STUDENT*******
    		  'paymentlistforpcandserviceprovided button[itemId=btnAdd]':{
    			  click :  this.getOpenManagePaymentForm
    		  },
    		  'paymentlistforpcandserviceprovided button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforpcandserviceprovided button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for P_AND_C_FEE and APPLICANT*******
    		  'paymentlistforpcandserviceprovidedforapplicant button[itemId=btnAdd]':{
    			  click : this.getOpenManagePaymentForm
    		  },
    		  'paymentlistforpcandserviceprovidedforapplicant button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforpcandserviceprovidedforapplicant button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for P_AND_C_FEE and USER*******
    		  'paymentlistforserviceprovided button[itemId=btnAdd]':{
    			  click : this.getOpenManagePaymentForm
    			  
    		  },
    		  'paymentlistforserviceprovided button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforserviceprovided button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for SERVICE_PROVIDED and STUDENT*******
    		  'paymentlistforpcandserviceprovided button[itemId=btnAdd]':{
    			  click : this.getOpenManagePaymentForm
    		  },
    		  'paymentlistforpcandserviceprovided button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforpcandserviceprovided button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for SERVICE_PROVIDED and SPONSOR*******
    		  'paymentlistforpcandserviceprovidedforsponsor button[itemId=btnAdd]':{
    			  click : this.getOpenManagePaymentForm
    		  },
    		  'paymentlistforpcandserviceprovidedforsponsor button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforpcandserviceprovidedforsponsor button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for SCHOLARSHIP and STUDENT*******
    		  'paymentlistforscholarship button[itemId=btnAdd]':{
    			  click :this.getOpenManagePaymentForm
    		  },
    		  'paymentlistforscholarship button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforscholarship button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for SERVICE_RECEIVED and USER*******
    		  'paymentlistforservicereceived button[itemId=btnAdd]':{
    			  click : this.getOpenManagePaymentForm
    		  },
    		  'paymentlistforservicereceived button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistforservicereceived button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  // ***** add button for DEPENDENT_BILLS and THIRD PARTY*******
    		  'paymentlistfordependedfeehead button[itemId=btnAdd]':{
    			  click : this.getOpenManagePaymentForm
    		  },
    		  'paymentlistfordependedfeehead button[itemId=btnView]':{
    			  click : this.getViewPaymentDetails
    		  },
    		  'paymentlistfordependedfeehead button[itemId=btnDelete]':{
    			  click : this.getDeletePaymentDetails
    		  },
    		  'managepaymentform radiogroup[itemId=paymentmode]':{
      			 change :this.showHideBankLadgerField
      		  },
      		  'managepaymentform customcombobox[itemId=paymentTo]':{
      			  render:function(obj){
      				 var store=obj.getStore();
      				store.getProxy().extraParams = {
	    				  screenType: 'add'
	    	              };
	    			  store.load();
      				
      			  },
    			  select:function(obj,record){
    				  obj.nextSibling().clearValue();
    				  var paymentType = record[0].get("id");
	    			  var store = this.getStore('feeandpayment.managebill.BillForPayment');
	    			  store.getProxy().extraParams = {
	    				  raiseBillType: paymentType
	    	                 };
	    			  store.load();
	    			  var form = this.getManagepaymentform();
     				  var bankAmount = form.down("#amount");
     				  var cashAmount = form.down("#amount1");
     				  bankAmount.setMaxValue(false);
     				  cashAmount.setMaxValue(false);
     				  bankAmount.reset();
    				  cashAmount.reset();
    				  if(form.getForm().hasInvalidField()==false){
     					  form.down('#SubmitBtn').setDisabled(false);
     					  form.down('#SubmitAndAdjustmentBtn').setDisabled(false);
     				  }else{
     					  form.down('#SubmitBtn').setDisabled(true);
     					  form.down('#SubmitAndAdjustmentBtn').setDisabled(true);
     				  }
    				  if(paymentType =="SCHOLARSHIP"){
   					   form.down('#paymentCurrency2').setVisible(true);
   					   form.down('#paymentCurrency2').allowBlank = false;
   					   form.down('#paymentCurrency2').clearInvalid();
   					   form.down('#paymentCurrency').setVisible(false);
                       form.down('#inActiveStudentItemId').setVisible(false);
   					   form.down('#paymentCurrency').allowBlank = true;
   					   form.down('#paymentCurrency').clearInvalid();
    			  }
   				   else {
   					   form.down('#paymentCurrency2').setVisible(false);
   					   form.down('#paymentCurrency2').allowBlank = true;
   					   form.down('#paymentCurrency2').clearInvalid();
   					   form.down('#paymentCurrency').setVisible(true);
                       form.down('#inActiveStudentItemId').setVisible(true);
   					   form.down('#paymentCurrency').allowBlank = false;
   					   form.down('#paymentCurrency').clearInvalid();
   				   }
    			  }
    		  },
    		  'managepaymentform customcombobox[itemId=paymentFor]':{
    			  select:function(obj,rec){
    				  this.checkpaymentFor(obj,rec);
    				  
    			  }
    		  },
    		  'managepaymentform customcombobox[itemId=thirdParty]':{
    			  select:this.setAddressForThirdParty 
    		  },
    		  'managepaymentform customcombobox[itemId=applicant]':{
    			  select:this.setAddressForApplicant
    		  },
    		  'managepaymentform customcombobox[itemId=sponsors]':{
    			  select:this.setAddressForSponsors 
    		  },
    		  'managepaymentform customcombobox[itemId=userId]':{
    			  select:this.setAddressForUser 
    		  },
    		  'managepaymentform customcombobox[itemId=student]':{
    			  afterrender: function(combo) {
    				  var form = combo.up('form'),
    				  inActiveStudentCheckBox =form.down('#inActiveStudentItemId'),
    				  store = combo.getStore();
    				  store.on('beforeload',function() {
    					  if(inActiveStudentCheckBox){
    						  store.getProxy().setExtraParam('isInactive', inActiveStudentCheckBox.getValue());
    					  }
    				  }, this);
    			  },
    			  select:this.setAddressForStudent
    		  },
    		  'managepaymentform checkboxfield[itemId=inActiveStudentItemId]': {
    			  change:function(obj,newValue, oldValue, eOpts ){
    				  var form = obj.up('form'),
    				  student = form.down('#student'),
    				  scholarshipStudent = form.down('#scholarshipStudent');
    				  if(student && scholarshipStudent){
    					  student.clearValue();
    					  scholarshipStudent.clearValue();
    				  }
    			  }
    		  },
    		  'managepaymentform customcombobox[itemId=scholarship]':{
    			  select:function(obj,rec){
    				  var scholarshipId=rec[0].data.id;
    				  var form=this.getManagepaymentform().getForm();
    				  var scholarshipStudent=form.findField('scholarshipStudent');
    				  scholarshipStudent.setDisabled(false);

    				  var academyLocationId = form.findField("fnpBrandCampusName").getValue();
    				  var alIds = [];
    				  var academyLocationIds = null;
    				  if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    					  for (var i in academyLocationId) {
    						  if (Ext.isObject(academyLocationId[0])) {
    							  if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
    								  alIds.push(academyLocationId[i].get("id"));
    							  }else{
    								  alIds.push(academyLocationId[i]);
    							  }
    						  } else {
    							  alIds.push(academyLocationId[i]);
    						  }
    					  }
    					  academyLocationIds = alIds.join();
    				  }else{
    					  academyLocationIds = academyLocationId;
    				  }

    				  
    				  
    				  scholarshipStudent.getStore().getProxy().extraParams={
    					  scholarshipId:scholarshipId,
    					  academyLocationIds:academyLocationIds
    				  };
    				  scholarshipStudent.getStore().load();
    				  var currencyField = form.findField('paymentCurrency2');
    				  var raiseBillType = form.findField('paymentTo').getRawValue();
    				  var paymentFormValue = form.findField("paymentFor").getRawValue();
    				  var currencyStore = currencyField.getStore();
    				  currencyStore.getProxy().extraParams = {
						   academyLocationId: this.getCurrentAcademyLocation(),
						   scholarshipId: scholarshipId,
						   userType: paymentFormValue,
						   raiseBillType: raiseBillType
					   };
					   currencyStore.load({
						   callback: function(rec, operation, success) {
							   for(var i in rec) {
								   currencyField.setValue(rec[i].data.id);
							   }
						   }
					   });
    			  }
    		  },
    		  'managepaymentform customcombobox[itemId=scholarshipStudent]':{
    			  afterrender: function(combo) {
    				  var form = combo.up('form'),
    				  inActiveStudentCheckBox =form.down('#inActiveStudentItemId'),
    				  store = combo.getStore();
    				  store.on('beforeload',function() {
    					  if(inActiveStudentCheckBox){
    						  store.getProxy().setExtraParam('isInactive', inActiveStudentCheckBox.getValue());
    					  }
    				  }, this);
    			  },
     			  select:function(obj,rec){
     				  this.setAddressForStudent(obj,rec);
     				  var form=this.getManagepaymentform().getForm();

     				  var scholarshipId=form.findField('scholarship').getValue();
     				  var scholarshipStudentId=rec[0].data.id;
     				  
     				 var academyLocationId = form.findField("fnpBrandCampusName").getValue();
  				   var alIds = [];
  	        	   var academyLocationIds = null;
  	        	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
  	        		   for (var i in academyLocationId) {
  	        			   if (Ext.isObject(academyLocationId[0])) {
  	        				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
  	        					   alIds.push(academyLocationId[i].get("id"));
  	        				   }else{
  	        					   alIds.push(academyLocationId[i]);
  	        				   }
  	        			   } else {
  	        				   alIds.push(academyLocationId[i]);
  	        			   }
  	        		   }
  	        		   academyLocationIds = alIds.join();
  	        	   }else{
  	        		   academyLocationIds = academyLocationId;
  	        	   }

     				  var store =obj.getStore();
     				  store.getProxy().extraParams = {
     					  scholarshipId: scholarshipId,
     					 scholarshipStudentId:scholarshipStudentId,
     					academyLocationIds: academyLocationIds
     				  };
     				  store.load({
     					  callback: function(records, operation, success) {
     						  if (success) {
     							 var amount = records[0].data.scholarShipAmount;
     		    				  var bankAmount = form.findField('amount');
     		    				  var cashAmount = form.findField('amount1');
     		    				  if(!bankAmount.isHidden()){
     		    					  bankAmount.setValue(amount);
     		    					 bankAmount.setMaxValue(amount);
     		    				  }
     		    				  if(!cashAmount.isHidden()){
     		    					 cashAmount.setValue(amount);
     		    					cashAmount.setMaxValue(amount);
     		    				  }
     						  }
     					  }	   
     				  });
     			  }
     		  },

    		  'paymentsearchform customcombobox[itemId=scholarship]':{
    			  select:function(obj,rec){
    				  var scholarshipId=rec[0].data.id;
    				  var form=this.getPaymentsearchform().getForm();
    				  var scholarshipStudent=form.findField('scholarshipStudent');
    				  scholarshipStudent.setDisabled(false);
    				  var academyLocationId = form.findField("fnpMultiBrandCampusNamePayment").getValue();
    				  var alIds = [];
    				  var academyLocationIds = null;
    				  if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    					  for (var i in academyLocationId) {
    						  if (Ext.isObject(academyLocationId[0])) {
    							  if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
    								  alIds.push(academyLocationId[i].get("id"));
    							  }else{
    								  alIds.push(academyLocationId[i]);
    							  }
    						  } else {
    							  alIds.push(academyLocationId[i]);
    						  }
    					  }
    					  academyLocationIds = alIds.join();
    				  }else{
    					  academyLocationIds = academyLocationId;
    				  }
    				  scholarshipStudent.getStore().getProxy().extraParams={
    					  scholarshipId:scholarshipId,
    					  academyLocationIds:academyLocationIds
    				  };
    				  scholarshipStudent.getStore().load();
    				  var frm = this.getPaymentsearchform();
    				  var billedUserTypeId = frm.down("#billFor").getValue();
    				  var billedUserType = frm.down("#billFor").getRawValue();
    				  var academyLocationId = frm.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    				  this.billNoSearch(billedUserTypeId,billedUserType,null,academyLocationId);
    				  this.paymentVoucherNoSearch(billedUserTypeId,billedUserType,null,academyLocationId);
    			  }
    		  },
    		  'managepaymentform button[itemId=btnAddPaymetHeader]':{
     			  click:this.addPaymentHeaderContainer
     		  },
     		  'managepaymentform radiogroup[itemId=paymentType]':{
     			  change : function(obj,newValue,oldValue){
     				  var value = newValue.paymentType;
     				  var form = this.getManagepaymentform();
     				  form.down("#isAutoSettlementPayment").setValue(false);
     				  var paymentheaderPanel = form.down("#paymentheaderPanel");
     				  var panelItem = paymentheaderPanel.items.items;

     				  if(value=="PDC"){
     					  form.down("#isAutoSettlementPayment").setVisible(false);
     					  form.down("#SubmitAndAdjustmentBtn").setVisible(false);
     					  form.down("#instrumentDate").reset();	
     					  if(panelItem.length>0){
     						  for(var i in panelItem){
     							  panelItem[i].items.items[2].setMinValue(Ext.Date.add(new Date(),Ext.Date.DAY, 1));
     							  panelItem[i].items.items[2].setMaxValue(false);
     							  panelItem[i].items.items[2].reset();
     						  }
     					  }else{
     						  form.down("#instrumentDate").setMinValue(Ext.Date.add(new Date(),Ext.Date.DAY, 1));
     						  form.down("#instrumentDate").setMaxValue(false);
     					  }
     				  }else{
     					  if(panelItem.length>0){
     						  for(var i in panelItem){
     							  panelItem[i].items.items[2].setValue(new Date());
     							  panelItem[i].items.items[2].setMaxValue(false);
     							  panelItem[i].items.items[2].setMinValue(false);
     							  panelItem[i].items.items[2].validate();
     						  }
     					  }else{
     						  form.down("#instrumentDate").setMaxValue(new Date());
     					  }
     					  form.down("#isAutoSettlementPayment").setVisible(true);
     					  form.down("#SubmitAndAdjustmentBtn").setVisible(true);
     					 this.loadDFRForManagePaymentFieldVisibility(form.down("#isAutoSettlementPayment"),form.down("#SubmitAndAdjustmentBtn"));
     				  }
     				 if(form.getForm().hasInvalidField()==false){
     					  form.down('#SubmitBtn').setDisabled(false);
     					  form.down('#SubmitAndAdjustmentBtn').setDisabled(false);
     				  }else{
     					  form.down('#SubmitBtn').setDisabled(true);
     					  form.down('#SubmitAndAdjustmentBtn').setDisabled(true);
     				  }
     				
     				// form.getForm().isValid();
     			  }
     		  },
     		 'managepaymentform radiogroup[itemId=isAutoSettlementPayment]':{
     			 change:function(value,newValue){
   				  var form=this.getManagepaymentform();
   				  form.down("#SubmitAndAdjustmentBtn").setVisible(true);
   				  this.loadDFRForManagePaymentFieldVisibility(null,form.down("#SubmitAndAdjustmentBtn"));
   				  if(newValue.onlineAutoAdjustment==true){
   				    form.down("#SubmitAndAdjustmentBtn").setVisible(false);
   				  }else{
   	   				  form.down("#SubmitAndAdjustmentBtn").setVisible(true);

   				  }
   				 
   			  }
   		  },
     		 'managepaymentform button[itemId=SubmitBtn]':{
    			  click: function(){
    				  var onlineAutoAdjustment = this.getManagepaymentform().down("#isAutoSettlementPayment").getValue();
					  var onlineAdjustment = false;
					  var makePayment = false;
					  var savePayment =true;
					  if(onlineAutoAdjustment.onlineAutoAdjustment==true){
    					  savePayment = false; 
    				  }
			          this.getSavePaymentHeader(savePayment,onlineAdjustment,onlineAutoAdjustment.onlineAutoAdjustment,makePayment);
    			  }
    		  },
    		  'managepaymentform button[itemId=btnCancel]':{
    			  click:this.getResetManagePaymentForm
    		  },
    		  'managepaymentform button[itemId=SubmitAndAdjustmentBtn]':{
    			  click:function(){
    				  var onlineAdjustment=true;
    				  var onlineAutoAdjustment=false;
    				  var makePayment = false;
    				  var savePayment =true;
    				  isManagePaymentForm=true;
    				  var form = this.getManagepaymentform();
    				  var isInactive = form.down('#inActiveStudentItemId');
    				  if(isInactive.getValue()){
   					   return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CANNOT_PROCEED_FOR_INACTIVE_STUDENTS'));
   				      }
    				  this.getSavePaymentHeader(savePayment,onlineAdjustment,onlineAutoAdjustment,makePayment);
    			  }
    		  },
    		  'managepaymentform button[itemId=SubmitAndGenerateBillBtn]':{
    			  click:function(){
    				  var onlineAutoAdjustment=false;
    				  var onlineAdjustment=false;
    				  var makePayment = true;
    				  var savePayment =false;
    				  this.getSavePaymentHeader(savePayment,onlineAdjustment,onlineAutoAdjustment,makePayment);
    			  }
    		  },
    		  'paymentlistforpcandserviceprovided':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     },
     		     	afterrender:function(grid){
     		    	 var me = this;
     		    	setTimeout(function(){
     		    	me.addDataGridConfigButton(grid,me.getPAYMENT_LIST_FOR_PC_AND_SERVICEPROVIDED());
     		    	},1500);
     		     }
     		  },
     		 'paymentlistforscholarship':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     },
  		     	afterrender:function(grid){
    		    	 var me = this;
    		    	setTimeout(function(){
    		    	me.addDataGridConfigButton(grid,me.getPAYMENT_LIST_FOR_SCHOLARSHIP());
    		    	},1500);
    		     }
     		  },
     		 'paymentlistforserviceprovided':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     },

             	afterrender:function(grid){
             		var me = this;
             		setTimeout(function(){
             			me.addDataGridConfigButton(grid,me.getPAYMENT_LIST_FOR_SERVICE_PROVIDED());
             		},1500);
             	}
             
     		  },
     		 'paymentlistfordependedfeehead':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     }
     		  },
     		 'paymentlistforservicereceived':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     },
              	afterrender:function(grid){
              		var me = this;
              		setTimeout(function(){
              			me.addDataGridConfigButton(grid,me.getPAYMENT_LIST_FOR_SERVICE_RECEIVED());
              		},1500);
              	}
     		  },
     		 'paymentlistforpcandserviceprovidedforsponsor':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     },
     		     	afterrender:function(grid){
     		        var me = this;
     		      	setTimeout(function(){
     		   		me.addDataGridConfigButton(grid,me.getPAYMENT_LIST_FOR_PC_SERVICEPROVIDED_FOR_SPONSOR());
     		  	},1500);
     		   }
     		  },
     		 'paymentlistforpcandserviceprovidedforapplicant':{
     		     cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     		    	var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
     		      if(columnName=="adjustmentDetails"){
                    if(e.target.tagName=='A'){
                    	this.getOpenBillHeaderAdjustmentGrid(grid,record);
                    }
     		      }
     		     if(columnName=="instrumentDetails"){
                     if(e.target.tagName=='A'){
                    	 this.getViewInstrumentAdjustment(grid,record);
                     }
      		      }
     		     },
     		     	afterrender:function(grid){
     		        var me = this;
     		      	setTimeout(function(){
     		   		me.addDataGridConfigButton(grid,me.getPAYMENT_LIST_FOR_PC_SERVICEPROVIDED_FOR_APPLICANT());
     		  	},1500);
     		   }
     		  },
     		  
     		  'addressdetailpanel[itemId=paymentaddressdetailpanel] displayfield[itemId=statementaccountId]':{
  			   render: function(component) {
  				   var $this =this;
  				   var infoPanel = $this.getPaymentAddressDetailPanel();
  				   if(!isNullOrEmpty(infoPanel)) {
  					   infoPanel.down('#statementaccountId').setValue("<a href='#'>Statement of Account</a>");
  					   component.getEl().on('click', function(e) {
  						   if(e.target.tagName=='A'){
  							   var path = SERVERURL.IS_ACCOUNT_CFG_EXISTS_OR_NOT+"?academyLocationId="+$this.getCurrentAcademyLocation();
  							   Ext.Ajax.request({
  								   url: path,
  								   method: 'GET',
  								   success: function(response) {
  									   var responseData = Ext.decode(response.responseText);
  									   if(responseData) {
  										   var form = $this.getManagepaymentform();
  										   var studentId = form.down('#student').getValue();
  										   
  										   if(isNullOrEmpty(studentId))
  										   {
  		  								   var studentId = form.down('#scholarshipStudent').getValue();
  										   }
  										   
  										   if(!isNullOrEmpty(studentId)){
  											   var contentpanel = $this.getContentPanel();
  											   Academia.app.getController('Academia.controller.feeandpayment.AccountStatementReportController');
  											   var accountstatmentstructure = Ext.widget('accountstatmentstructure');
  											   var tabName = 'Statement of Account';
  											   /**
  											    * This is to remove tab from content panel and open same tab again 
  											    */
  											   var getcontroller=$this.getController('menu.CoreERPNavigationController');
  											   var getTab=getcontroller.getTab(tabName);
  											   if(getTab!=null){
  												   contentpanel.remove(getTab, true);
  											   }
  											   openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);
  											   var frm = accountstatmentstructure.down('form');
  											   var student = frm.down('#student');
  											   var recieptView = frm.down('#recieptView');
  											   var showAllStudents = frm.down('#showAllStudentsItemId');
  											   var statusComboItemId = frm.down('#statusComboItemId');
		                					   showAllStudents.setValue(true);
  											   student.getStore().load({
  												   callback:function(rec) {
  													   for (var i in rec) {
  														   if(rec[i].data.id==studentId) {
																 student.setValue(studentId);
																 if(rec[i].data.studentStatus=="Active"){
																	 statusComboItemId.setValue(true);
																 }else if(rec[i].data.studentStatus=="Inactive"){
																	 statusComboItemId.setValue(false);
																 }else{ 
																	 statusComboItemId.setValue(null);
																	 statusComboItemId.setReadOnly(true);}
															 }
  													   }
  												   var status = statusComboItemId.getValue();
  												   var gird = accountstatmentstructure.down('grid');
  	  											   gird.getStore().getProxy().extraParams={
  	  												   id:studentId,
  	  												   billedUserType:'STUDENT',
  	  												   status:status,
					                				   screenName:'StatementOfAccount',
					                				   whetherShowAllStudents:true
  	  											   };
  	  											   gird.getStore().load();
  												   }
  											   });
  											   
  										   } else {
  											   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECT_STUENT'));
  										   }
  									   } else {
  										   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ACCOUNTING_CFG_IS_NOT_DONE_MSG'));
  									   }
  								   }
  							   });
  						   }
  					   });    
  				   }
  			   }
  		   },
  		 'addressdetailpanel[itemId=paymentaddressdetailpanel] displayfield[itemId=feeheadwisedistributionId]':{
			 render: function(component) {
				 var $this =this;
				 var infoPanel = $this.getPaymentAddressDetailPanel();
				 if(!isNullOrEmpty(infoPanel)) {
					 var  detail = getCommonTranslation('FEE_HEADWISE_DISTRIBUTION');
					 infoPanel.down('#feeheadwisedistributionId').setValue("<a href='#'>"+detail+"</a>");
					 component.getEl().on('click', function(e) {
						 if(e.target.tagName=='A'){

							 var billFlayOutForm = $this.getManagepaymentform();
 							   
 							   var studentId = billFlayOutForm.down('#student').getValue();
 							  var applicantId = billFlayOutForm.down('#applicant').getValue();

							 if(!isNullOrEmpty(studentId)){
								 var contentpanel = $this.getContentPanel();
								 Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
								 var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
								 var tabName = 'Fee Reports';
								 /**
								  * This is to remove tab from content panel and open same tab again 
								  */
								 var getcontroller=$this.getController('menu.CoreERPNavigationController');
								 var getTab=getcontroller.getTab(tabName);
								 if(getTab!=null){
									 contentpanel.remove(getTab, true);
								 }
								 openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

								 var frm = accountstatmentstructure.down('form');
								 var studentfeereportfinalstructure = accountstatmentstructure;
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								 /* var academyForm = $this.getStudentFeeAndPaymentOrganizationUnit().getForm();
        											   var values = academyForm.getValues();
        											   if(values.multiselectAcademyLocation[0] =="" || values.multiselectAcademyLocation.length==0){
        												   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ATLEAST_ONE_ACADEMY_LOCATION'));
        												   return;
        											   }*/
								 var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
								 // var feeReportTabStructure = $this.getFeeReportTabStructure();
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								 // feeReportTabStructure.removeAll();
								 var tabDetail = 'feeheadwisecollectionreportstructure';
								 var structure = Ext.widget(tabDetail);

								 openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('STUDENT_FEE_HEAD_WISE'),
										 structure);

								 treeTab.toggleCollapse();
								 var headWiseForm = $this.getFeeheadwisecollectionreportform();
								 var moreFilterOpt = headWiseForm.down('fieldset');
								 moreFilterOpt.expand(true);		                												   
								 var studentField = headWiseForm.down('#student');
								 var studentFieldStore =  studentField.getStore();
								 studentFieldStore.getProxy().extraParams = { 
									 pageSize: 0,
									 limit: 0,};
								 
								 
								 setTimeout(function(){
									 studentFieldStore.load({
										 callback: function(records, operation, success) {
											 if (success) {
												 for(var i in records){
													 if(records[i].data.id==studentId){
														 studentField.setValue(records[i].data.id);
													 }
												 }

											 }
										 }
									 });
									 var feeheadwisecollectionreportgrid = $this.getFeeheadwisecollectionreportgrid();
									 var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
									 
									  var organizationForm=$this.getOrganizationunit().getForm();
						                var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
						                var ALsId = [];
						                for(var i in multiselectAcademyLocation){

						                ALsId.push(multiselectAcademyLocation[i]);
						                }
						               
									 feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
										 academyLocationIds: ALsId.join(),
										 studentId: studentId,
										 onlyStudent: false,
										 isSchool: false,
										 studentStatus: true,
										 screenName: "feeheadwisecollectionreportform"
									 };
									 feeheadwisecollectionreportgridStore.load();


								 },1500);
								


							 } 
							 else if(!isNullOrEmpty(applicantId)){

								 var contentpanel = $this.getContentPanel();
								 Academia.app.getController('Academia.controller.feeandpayment.reports.FeeReportCommonController');
								 var accountstatmentstructure = Ext.widget('studentfeereportfinalstructure');
								 var tabName = 'Fee Reports';
								 /**
								  * This is to remove tab from content panel and open same tab again 
								  */
								 var getcontroller=$this.getController('menu.CoreERPNavigationController');
								 var getTab=getcontroller.getTab(tabName);
								 if(getTab!=null){
									 contentpanel.remove(getTab, true);
								 }
								 openTab(contentpanel, tabName, accountstatmentstructure, CONSTANTS.MENU_COLOR_FIVE);

								 var frm = accountstatmentstructure.down('form');
								 var studentfeereportfinalstructure = accountstatmentstructure;
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								
								 var treeTab = studentfeereportfinalstructure.down('#studentReportTreePanelItemId');
								 var feeReportTabStructure = studentfeereportfinalstructure.down('#feeReportTabStructure');
								 var tabDetail = 'applicantfeeheadwisecollectionreportstructure';
								 var structure = Ext.widget(tabDetail);

								 openTab(feeReportTabStructure, getFeeAndPaymentCommonTranslation('APPLIACNT_HEAD_WISE'),
										 structure);

								 treeTab.toggleCollapse();
								 var headWiseForm = $this.getApplicantfeeheadwisecollectionreportform();
								 var moreFilterOpt = headWiseForm.down('fieldset');
								 moreFilterOpt.expand(true);		                												   
								 var studentField = headWiseForm.down('#applicantId');
								 var studentFieldStore =  studentField.getStore();
								 studentFieldStore.getProxy().extraParams = { 
									 pageSize: 0,
									 limit: 0,
									 applicantId :applicantId};
								
								 setTimeout(function(){
									 studentFieldStore.load({
										 callback: function(records, operation, success) {
											 if (success) {
												 for(var i in records){
													 if(records[i].data.id==applicantId){
														 studentField.setValue(records[i].data.id);
													 }
												 }

											 }
										 }
									 });
								 var feeheadwisecollectionreportgrid = $this.getApplicantfeeheadwisecollectionreportgrid();
								 var feeheadwisecollectionreportgridStore =  feeheadwisecollectionreportgrid.getStore();
								  var organizationForm=$this.getOrganizationunit().getForm();
					                var multiselectAcademyLocation=organizationForm.findField('multiselectAcademyLocation').getValue();
					                var ALsId = [];
					                for(var i in multiselectAcademyLocation){

					                ALsId.push(multiselectAcademyLocation[i]);
					                }
					               
								 feeheadwisecollectionreportgridStore.getProxy().extraParams = { 
									 academyLocationIds: ALsId.join(),
									 applicantId: applicantId,
									 onlyApplicant: false,

								 };
								 feeheadwisecollectionreportgridStore.load();

								 },1500);




							 }


						 }
					 });    
				 }
			 }
		 },


  		   
  		   'addressdetailpanel[itemId=paymentaddressdetailpanel] displayfield[itemId=hosteldetailId]':{
  			   render: function(component) {
  				   var $this =this;
  				   var infoPanel = $this.getPaymentAddressDetailPanel();
  				   if(!isNullOrEmpty(infoPanel)) {
  					   infoPanel.down('#hosteldetailId').setValue("<a href='#'>Hostel Detail</a>");
  					   component.getEl().on('click', function(e) {		                						

  						   if(e.target.tagName=='A'){
  							   var billFlayOutForm = $this.getManagepaymentform();
  							   var tabTitle =  billFlayOutForm.down('#student').getValue();

  							   var programBatchSeatTypeConfigId = null;
  							   var personId = $this.getPaymentAddressDetailPanel().down('#person').getValue(); //billFlayOutForm.down('#person').getValue();
  							   var userId = billFlayOutForm.down('#student').getValue();
  							   
  							   if(isNullOrEmpty(userId))
  							   {
  								   var tabTitle =  billFlayOutForm.down('#scholarshipStudent').getValue();
  								   var userId = billFlayOutForm.down('#scholarshipStudent').getValue();
  							   }
  							   
  							   var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
  							   var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   

  							   /* For student case */
  							   if(!isNullOrEmpty(userId)){
  								   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
  								   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
  								   personController.isProfilePicSaved = false;
  								   if(!isNullOrEmpty(personId)){
  									   personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
  									   personController.addPersonTabPanel('STUDENT', 'studentHostelPersonDetails', 'HOSTEL_DETAILS', 'hostelpersondetailsgrid', 'paymenthostelpersondetailsgrid', true);
  									   var pendingGrid = $this.getHostelpersondetailsgrid();
  									   var pendingGridStore = pendingGrid.getStore();
  									   pendingGridStore.getProxy().extraParams = {		                									
  										   personId:personId
  									   };
  									   pendingGridStore.load();
  								   }		                										                								
  							   }			                				           
  						   }

  					   });    
  				   }
  			   }
  		   },
  		   
  		   /*added for transport detail*/
  		   'addressdetailpanel[itemId=paymentaddressdetailpanel] displayfield[itemId=transportdetailId]':{
  			   render: function(component) {
  				   var $this =this;
  				   var infoPanel = $this.getPaymentAddressDetailPanel();
  				   if(!isNullOrEmpty(infoPanel)) {
  					   infoPanel.down('#transportdetailId').setValue("<a href='#'>Transport Details</a>");
  					   component.getEl().on('click', function(e) {		                						

  						   if(e.target.tagName=='A'){
  							   var billFlayOutForm = $this.getManagepaymentform();
  							   var tabTitle =  billFlayOutForm.down('#student').getValue();

  							   var programBatchSeatTypeConfigId = null;
  							   var personId = $this.getPaymentAddressDetailPanel().down('#person').getValue(); //billFlayOutForm.down('#person').getValue();
  							   var userId = billFlayOutForm.down('#student').getValue();
  							 if(isNullOrEmpty(userId))
							   {
  								   var tabTitle =  billFlayOutForm.down('#scholarshipStudent').getValue();
								   var userId = billFlayOutForm.down('#scholarshipStudent').getValue();
							   }
  							   var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
  							   var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   

  							   /* For student case */
  							   if(!isNullOrEmpty(userId)){
  								   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
  								   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
  								   personController.isProfilePicSaved = false;
  								   if(!isNullOrEmpty(personId)){
  									   personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
  									   personController.addPersonTabPanel('STUDENT', 'studentTransportPersonDetails', 'TRANSPORT_DETAILS', 'transportpersondetailsgrid', 'paymenttransportpersondetailsgrid', true);
  									   var pendingGrid = $this.getTransportpersondetailsgrid();
  									   var pendingGridStore = pendingGrid.getStore();
  									   pendingGridStore.getProxy().extraParams = {		                									
  										   userId:userId
  									   };
  									   pendingGridStore.load();
  								   }		                										                								
  							   }			                				           
  						   }

  					   });    
  				   }
  			   }
  		   },
     		  
     		  /*added for total bill amount flyout link manage receipt link*/
     		  'addressdetailpanel[itemId=paymentaddressdetailpanel] [itemId=totalAcadInvoiceAmount]':{
     			  render: function(component) {
     				  var $this =this;
     				  component.getEl().on('click', function(e) {
     					  if(e.target.tagName=='A'){
     						  var billFlayOutForm = $this.getManagepaymentform();
     						  var tabTitle =  $this.getPaymentAddressDetailPanel().down('#studentCode').getValue();
     						  var personId = null;
     						  var programBatchSeatTypeConfigId = null;
     						  var userId = billFlayOutForm.down('#student').getValue();
     						  var applicantId = billFlayOutForm.down('#applicant').getValue();
     						  var raiseBillFor=billFlayOutForm.down("#paymentFor").getValue();
     						  var actualUserId = billFlayOutForm.down('#userId').getValue();
     						  
     						  if(isNullOrEmpty(userId))
							   {
     							   var tabTitle =  billFlayOutForm.down('#scholarshipStudent').getValue();
								   var userId = billFlayOutForm.down('#scholarshipStudent').getValue();
							   }
     						  
     						 /* For User case */
   						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='4' || raiseBillFor=='7'){
      						   if(!isNullOrEmpty(actualUserId)){
        							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
        							  var admissionId = null; 
           						  var applicationId = null; 
       							   
           						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
       							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//       							   personController.isProfilePicSaved = false;
       							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
       							   personController.addPersonTabPanel('USER', 'userPendingBillDetails', 'BILL', 'pendingbillsgrid', 'userPendingBillsGrid', true);
       							   
       							   
       							   var params = {
       			                     		id : actualUserId,
       			                     		billedUserType : 'USER',
       			         					raiseBillCategory : 'BILL_PAYABLE'
       			                     };
       							   $this.loadGridStoreFaculty('#pendingbillsgrid', SERVERURL.FACULTY_PENDING_BILLS_DETAILS, params);
       							  
          						   } }else{

     						  /* For student case */
     						  if(!isNullOrEmpty(userId)){
     							 var admissionId = null; //billFlayOutForm.down('#addmissionId').getValue();
     							 var applicationId = null; //billFlayOutForm.down('#applicationId').getValue();		                						   
     							  
     							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							  personController.isProfilePicSaved = false;
     							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							  personController.addPersonTabPanel('STUDENT', 'studentPendingBillDetails', 'BILL', 'pendingbillsgrid', 'studentPendingBillsGrid', true);
     							  var pendingGrid = $this.getPendingbillsgrid();
     							  var pendingGridStore = pendingGrid.getStore();
     							  pendingGridStore.getProxy().extraParams = {
     								  id:userId,
     								  billedUserType:'STUDENT',
     								  raiseBillCategory:'BILL_RECEIVABLE'
     							  };
     							  // pendingGridStore.load();
     							  pendingGridStore.load({ 
     								  callback: function(record, operation, success) {
     									  if (record.length > 0) {
     										  $this.toggleGridSummaryRow(pendingGrid,true);
     									  }else{
     										  $this.toggleGridSummaryRow(pendingGrid,false);
     									  }
     								  }
     							  });
     						  }	
          				}
     				//For Applicant.......
   						   if(!isNullOrEmpty(applicantId)){
 							   var tabTitle =  $this.getPaymentAddressDetailPanel().down('#applicationId').getValue();
   							  
 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
 							  personController.isProfilePicSaved = false;
 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
 							 personController.addPersonTabPanel('APPLICANT', 'applicantPendingBillDetails', 'Payment', 'preadmissionpaymentsgrid', 'applicantPendingBillDetails', true);
							  var pendingGridNew = $this.getPreadmissionpaymentsgrid();
							  var pendingGridStoreNew = pendingGridNew.getStore();
							  pendingGridStoreNew.getProxy().extraParams = {
								  applicantId:applicantId
								 //  billedUserType:'APPLICANT',
								 //  raiseBillCategory:'BILL_RECEIVABLE'
							   };
						
							  pendingGridStoreNew.load({ 
					        		callback: function(record, operation, success) {
								 if (record.length > 0) {
									 $this.toggleGridSummaryRow(pendingGrid,true);
									 }else{
										 $this.toggleGridSummaryRow(pendingGrid,false);
									 }
								 }
							});
 							  
						   }
     					  }
     				  });    
     			  }		                			   
     		  },

     		  /*added for total reciept flyout link to manage receipt link*/
     		  'addressdetailpanel[itemId=paymentaddressdetailpanel] [itemId=totalAcadReceiptAmount]':{
     			  render: function(component) {
     				  var $this =this;
     				  component.getEl().on('click', function(e) {
     					  if(e.target.tagName=='A'){
     						  var billFlayOutForm = $this.getManagepaymentform();
     						  var tabTitle = $this.getPaymentAddressDetailPanel().down('#studentCode').getValue();
     						  var personId = null;
     						  var programBatchSeatTypeConfigId = null;
     						  var userId = billFlayOutForm.down('#student').getValue();
     						  var applicantId = billFlayOutForm.down('#applicant').getValue();
     						  var raiseBillFor=billFlayOutForm.down("#paymentFor").getValue();
     						  var actualUserId = billFlayOutForm.down('#userId').getValue();

     						 
     						 if(isNullOrEmpty(userId))
							   {
     							   var tabTitle = billFlayOutForm.down('#scholarshipStudent').getValue();
								   var userId = billFlayOutForm.down('#scholarshipStudent').getValue();
							   }

 						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='4' || raiseBillFor=='7'){
 							   if(!isNullOrEmpty(actualUserId)){
          							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
          							  var admissionId = null; 
             						  var applicationId = null; 
         							   
             						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
         							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//         							   personController.isProfilePicSaved = false;
         							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
         							   personController.addPersonTabPanel('USER', 'userPaymentReceivedHistoryDetails', 'RECEIPTS', 'paymentreceivedhistorygrid', 'userPaymentReceivedHistoryGrid', true);
         							   
         							   var params = {
         			                     		id : actualUserId,
         			                     };
         							   $this.loadGridStoreFaculty('#facultyPaymentReceivedHistoryGrid', SERVERURL.FACULTY_PAYMENT_RECEIVED_HISTORY_DETAILS, params);
         							  
            						   } 
 						   }				                 						
 						   else{
     						 
     						  /* For student case */
     						  if(!isNullOrEmpty(userId)){
     							  
     							  var admissionId = null;
        						  var applicationId = null;
     							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							  personController.isProfilePicSaved = false;
     							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							  personController.addPersonTabPanel('STUDENT', 'studentPaymentReceivedHistoryDetails', 'RECEIPTS', 'paymentreceivedhistorygrid', 'studentPaymentReceivedHistoryGrid', true);
     							  var paymentReceivedGrid = $this.getPaymentreceivedhistorygrid();
     							  // var pendingGridStore = $this.getStore('Academia.store.personinfo.common.paymentandrefund.PendingBillStore');
     							  var paymentReceivedGridStore = paymentReceivedGrid.getStore();
     							  paymentReceivedGridStore.getProxy().extraParams = {
     								  studentId:userId		                								   
     							  };
     							  paymentReceivedGridStore.load({ 
     								  callback: function(record, operation, success) {
     									  if (record.length > 0) {
     										  $this.toggleGridSummaryRow(paymentReceivedGrid,true);
     									  }else{
     										  $this.toggleGridSummaryRow(paymentReceivedGrid,false);
     									  }
     								  }
     							  });
     						  	}   
 						   }
     			     				//For Applicant.......
     	   						   if(!isNullOrEmpty(applicantId)){
     	 							   var tabTitle = $this.getPaymentAddressDetailPanel().down('#applicationId').getValue();
     	   							  
     	 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
     	 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
     	 							  personController.isProfilePicSaved = false;
     	 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
     	 							  personController.addPersonTabPanel('APPLICANT', 'applicantPaymentReceivedHistoryDetails', 'RECEIPTS', 'receiptgridforapplicant', 'applicantPaymentReceivedHistoryGrid', true);
                 						
     	 							  var pendingGridNew = $this.getReceiptgridforapplicant();
        							  var pendingGridStoreNew = pendingGridNew.getStore();
        							  pendingGridStoreNew.getProxy().extraParams = {
        								  personId:applicantId,
        								  billedUserType: 'APPLICANT',
        								  adjustmentType: 'BILL_RECEIVABLE',
        								  whetherDeleted: 'FALSE',
        								  raiseBillType: 'P_AND_C_FEE'
        						
        							   };
        							  pendingGridStoreNew.load({ 
        								   callback: function(record, operation, success) {
        									   if (record.length > 0) {
        										   $this.toggleGridSummaryRow(paymentReceivedGrid,true);
        									   }else{
        										   $this.toggleGridSummaryRow(paymentReceivedGrid,false);
        									   }
        								   }
        							   });
     						  }			                				           
     					  }
     				  });    
     			  }		                			   
     		  },

     		  /*added for total payment amount flyout link to manage receipt link*/
     		  'addressdetailpanel[itemId=paymentaddressdetailpanel] [itemId=totalAcadPaymentAmount]':{
     			  render: function(component) {
     				  var $this =this;
     				  component.getEl().on('click', function(e) {
     					  if(e.target.tagName=='A'){
     						  var billFlayOutForm = $this.getManagepaymentform();
     						  var tabTitle = $this.getPaymentAddressDetailPanel().down('#studentCode').getValue();
     						  var personId = null;
     						  var programBatchSeatTypeConfigId = null;
     						  var userId = billFlayOutForm.down('#student').getValue();
     						  var applicantId = billFlayOutForm.down('#applicant').getValue();
     						  var raiseBillFor=billFlayOutForm.down("#paymentFor").getValue();
     						  var actualUserId = billFlayOutForm.down('#userId').getValue();

     						  if(isNullOrEmpty(userId))
							   {	
     							   var tabTitle =  billFlayOutForm.down('#scholarshipStudent').getValue();
								   var userId = billFlayOutForm.down('#scholarshipStudent').getValue();
							   }
     						 
   						   /* For User case */
   						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='4' || raiseBillFor=='7'){
      						   if(!isNullOrEmpty(actualUserId)){
        							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
        							  var admissionId = null; 
           						  var applicationId = null; 
       							   
           						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
       							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//       							   personController.isProfilePicSaved = false;
       							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
       							   personController.addPersonTabPanel('USER', 'userPaymentMadeHistoryGrid', 'Payment Made History', 'paymentmadehistorygrid', 'userPaymentMadeHistoryGrid', true);
       							   
       							   var params = {
       			                     		id : actualUserId,
       							   	};
       							   
       							   $this.loadGridStoreFaculty('#facultyPaymentMadeGrid', SERVERURL.FACULTY_PAYMENT_MADE_HISTORY_DETAILS, params);
       							  
          						   } }else{

     						  /* For student case */
     						  if(!isNullOrEmpty(userId)){
     							  var admissionId = null;
        						  var applicationId = null;		                						   
     							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							  personController.isProfilePicSaved = false;
     							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							  personController.addPersonTabPanel('STUDENT', 'studentRefundHistoryDetails', 'REFUNDS', 'refundhistorygrid', 'studentRefundHistoryGrid', true);
     							  var refundhistorygrid = $this.getRefundhistorygrid();
     							  var refundhistorygridStore = paymentReceivedGrid.getStore();
     							  refundhistorygridStore.getProxy().extraParams = {
     								  studentId:userId		                								   
     							  };
     							  refundhistorygridStore.load({ 
     								  callback: function(record, operation, success) {
     									  if (record.length > 0) {
     										  $this.toggleGridSummaryRow(refundhistorygrid,true);
     									  }else{
     										  $this.toggleGridSummaryRow(refundhistorygrid,false);
     									  }
     								  }
     							  });
     						  }			
          						   }
			   			//For Applicant.......
	   						   if(!isNullOrEmpty(applicantId)){
	 							   var tabTitle =  $this.getPaymentAddressDetailPanel().down('#applicationId').getValue();
	   							  
	 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  personController.isProfilePicSaved = false;
	 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
	 							 personController.addPersonTabPanel('APPLICANT', 'applicantRefundHistoryDetails', 'REFUNDS', 'preadmissionrefundsgrid', 'applicantRefundHistoryGrid', true);
	 							   var preadrefundsgrid = $this.getPreadmissionrefundsgrid();
  							   var preadrefundsgridStore = preadrefundsgrid.getStore();
  							   preadrefundsgridStore.getProxy().extraParams = {
  								   studentId:userId		                								   
  							   };
  							   preadrefundsgridStore.load({ 
  								   callback: function(record, operation, success) {
  									   if (record.length > 0) {
  										   $this.toggleGridSummaryRow(refundhistorygrid,true);
  									   }else{
  										   $this.toggleGridSummaryRow(refundhistorygrid,false);
  									   }
  								   }
  							   });
						  }
     					  }
     				  });    
     			  }		                			   
     		  },

     		  /*added for total outstanding amount flyout link manage receipt link*/
     		  'addressdetailpanel[itemId=paymentaddressdetailpanel] [itemId=totalConvertedOutstanding]':{
     			  render: function(component) {
     				  var $this =this;
     				  component.getEl().on('click', function(e) {
     					  if(e.target.tagName=='A'){
     						  var billFlayOutForm = $this.getManagepaymentform();
     						  var tabTitle =  $this.getPaymentAddressDetailPanel().down('#studentCode').getValue()
     						  var personId = null;
     						  var programBatchSeatTypeConfigId = null;
     						  var userId = billFlayOutForm.down('#student').getValue();
     						  var applicantId = billFlayOutForm.down('#applicant').getValue();
     						  var raiseBillFor=billFlayOutForm.down("#paymentFor").getValue();
      						  var actualUserId = billFlayOutForm.down('#userId').getValue();

      						   
     						 if(isNullOrEmpty(userId))
							   {
     							   var tabTitle =  billFlayOutForm.down('#scholarshipStudent').getValue();
								   var userId = billFlayOutForm.down('#scholarshipStudent').getValue();
							   }
   						   
   						   /* For User case */
   						   if(!isNullOrEmpty(actualUserId) && raiseBillFor=='4' || raiseBillFor=='7'){
      						   if(!isNullOrEmpty(actualUserId)){
        							  var tabTitle =  billFlayOutForm.down('#userId').getValue();
        							  var admissionId = null; 
           						  var applicationId = null; 
       							   
           						   Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
       							   var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
//       							   personController.isProfilePicSaved = false;
       							   personController.addContentPanelTab(tabTitle, 'facultyprofile', actualUserId, personId, applicationId, admissionId, null);
       							   personController.addPersonTabPanel('USER', 'userPendingBillDetails', 'BILL', 'pendingbillsgrid', 'userPendingBillsGrid', true);
       							   
       							   
       							   var params = {
       			                     		id : actualUserId,
       			                     		billedUserType : 'USER',
       			         					raiseBillCategory : 'BILL_PAYABLE'
       			                     };
       							   $this.loadGridStoreFaculty('#pendingbillsgrid', SERVERURL.FACULTY_PENDING_BILLS_DETAILS, params);
      						   } }else{

     						  /* For student case */
     						  if(!isNullOrEmpty(userId)){
     							  var admissionId = null;
        						  var applicationId = null;	                						  
     							  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
     							  var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
     							  personController.isProfilePicSaved = false;
     							  personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, applicationId, admissionId, null);
     							  personController.addPersonTabPanel('STUDENT', 'studentPendingBillDetails', 'BILL', 'pendingbillsgrid', 'studentPendingBillsGrid', true);
     							  var pendingGrid = $this.getPendingbillsgrid();
     							  var pendingGridStore = pendingGrid.getStore();
     							  pendingGridStore.getProxy().extraParams = {
     								  id:userId,
     								  billedUserType:'STUDENT',
     								  raiseBillCategory:'BILL_RECEIVABLE'
     							  };
     							  // pendingGridStore.load();
     							  pendingGridStore.load({ 
     								  callback: function(record, operation, success) {
     									  if (record.length > 0) {
     										  $this.toggleGridSummaryRow(pendingGrid,true);
     									  }else{
     										  $this.toggleGridSummaryRow(pendingGrid,false);
     									  }
     								  }
     							  });
     						  }		
      						  }
			     		//For Applicant.......
	   						   if(!isNullOrEmpty(applicantId)){
	 							   var tabTitle = $this.getPaymentAddressDetailPanel().down('#applicationId').getValue();
	   							  
	 							  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  var personController=  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	 							  personController.isProfilePicSaved = false;
	 							  personController.addContentPanelTab(tabTitle, 'applicantprofile', applicantId, personId, applicantId, admissionId, null);
	 							 personController.addPersonTabPanel('APPLICANT', 'applicantPendingBillDetails', 'Payment', 'preadmissionpaymentsgrid', 'applicantPendingBillDetails', true);
    							  var pendingGridNew = $this.getPreadmissionpaymentsgrid();
   							  var pendingGridStoreNew = pendingGridNew.getStore();
   							  pendingGridStoreNew.getProxy().extraParams = {
   								  applicantId:applicantId
   								 //  billedUserType:'APPLICANT',
   								 //  raiseBillCategory:'BILL_RECEIVABLE'
   							   };
   						
   							  pendingGridStoreNew.load({ 
   					        		callback: function(record, operation, success) {
   								 if (record.length > 0) {
   									 $this.toggleGridSummaryRow(pendingGrid,true);
   									 }else{
   										 $this.toggleGridSummaryRow(pendingGrid,false);
   									 }
   								 }
   							});
						  }
     					  }
     				  });    
     			  }		                			   
     		  },
     		 'managepaymentform customcombobox[itemId=fnpBrandCampusItemId]': {
    			 render: function(){
    				 var $this = this;
    				 var formLayout = $this.getManagepaymentform();
    				 var academyLocationId = this.getCurrentAcademyLocation();
    				 var fnpBrandCampusId = formLayout.down('#fnpBrandCampusItemId');
    				 var ALComboStore = fnpBrandCampusId.getStore();
    				 ALComboStore.load({
    					 callback: function(records, operation, success) {
    						 if (success) {
    							 for(var i in records){
    								   if(records[i].data.id==academyLocationId){
    									   fnpBrandCampusId.setValue(academyLocationId);
    								   }
    							   }
    						 }
    					 }
    				 });
    				 var studentField = formLayout.down('#student');
    				 var studentStore = studentField.getStore();
    				 studentStore.getProxy().extraParams = {
    					 academyLocationIds: academyLocationId,
    				 };
    				 studentStore.load();
    				 var applicantField = formLayout.down('#applicant');
    				 var applicantStore = applicantField.getStore();
    				 applicantStore.getProxy().extraParams = {
    					 academyLocationIds: academyLocationId,
    				 };
    				 applicantStore.load();
    				 var sponsorField = formLayout.down('#sponsors');
    				 var sponsorStore = sponsorField.getStore();
    				 sponsorStore.getProxy().extraParams = {
    					 academyLocationIds: academyLocationId,
    				 };
    				 sponsorStore.load();
    				 var userField = formLayout.down('#userId');
    				 var userStore = userField.getStore();
    				 userStore.getProxy().extraParams = {
    					 academyLocationIds: academyLocationId,
    				 };
    				 userStore.load();
    			 },
    			 select : function(obj, record) {
    				 this.fnpChangeAcademyLocationEventManagePayment(obj, record);
    			 }
    		 },
     		  
     		 'managepaymentform textfield[itemId=paymentVoucherNo]':{
    			 blur:function(obj,value){
    				 if(obj.readOnly!=true && !isNullOrEmpty(obj.getValue())){
    					 var getUrl =  SERVERURL.PATH_CHECK_PAYMENT_VOUCHER_NO_DUPLICATE;
    					 Ext.Ajax.request({
    						 method: "GET",
    						 type: 'rest',
    						 url: getUrl,
    						 params: {
    							 paymentVoucherNo: obj.getValue()
    						 },
    						 success:function(response, action){
    							 if(response.responseText == false  || response.responseText == "false"){
    								 showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PAYMENT_MSSG_ALREADY_EXISTS'));
    								 obj.reset();
    								 return false
    							 }else{
    								 return true;
    							 }
    						 }
    					 }); 
    				 }
    			 }
    		 },
    		 'feeofflinepaymentdetailform button[itemId=searchBtn]':{
    			 click: this.loadFeeOfflinePaymentDetail
    		 },
    		 'feeofflinepaymentdetailform button[itemId=resetBtn]':{
    			 click:this.resetOfflinePaymentSearchDetails
    		 },
    		 'feeofflinepaymentdetailgrid button[itemId=btnAdd]':{
    			 click:this.openOfflinePaymentDetails
    		 },
    		 'feeofflinepaymentdetailgrid button[itemId=btnEdit]':{
    			 click:this.editOfflinePaymentDetails
    		 },
    		 'feeofflinepaymentdetailgrid button[itemId=btnView]':{
    			 click:this.ViewOfflinePaymentDetails
    		 },
    		 'feeofflinepaymentdetailgrid button[itemId=btnDelete]':{
    			 click:this.deleteOfflinePaymentDetails
    		 },
    		 'manageofflinepaymentdetailform button[itemId=btnAddOfflinePaymentHeader]':{
    			 click:this.addOfflinePaymentHeaderContainer
    		 },
    		 'manageofflinepaymentdetailform button#uploadDocument' : {
    			click : function() {
    				this.getDocumentController().showDocumentFormWindow('fee_offline_paymentdocumentlist_grid','DOCUMENT');
    			}
    		},
    		'documentformwindow[itemId=fee_offline_paymentdocumentlist_grid] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
    			click : function() {
    				var $this = this;
    				var isTransient = false;
    				var module = 'offlinePayment';
    				var entityId;
    				var entityType = 'offlinePaymentActionDocument';

    				$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
    						function(success,response,isCallBackTransient) {
    					var path = SERVERURL.PATH_FIND_BY_ID_OFFLINE_PAYMENT;
    						var documentId = Ext.decode(response.responseText);
		    					Ext.Ajax.request({
		        					type: 'rest',
		        					url: path ,
		        					method: 'GET',
		        					params: {
           							 id:documentId 
           						 },
		        					success: function(res, action) {
		        						var data = Ext.decode(res.responseText);
		        						if(!isEmpty(data)){
		        							if(!isNullOrEmpty(data.path)){
		        								path=data.path;
		        								var documentModel = new Academia.model.feeandpayment.payment.OfflinePaymentActionDocumentModel();
		            							documentModel.set("name",data.name);
		            							documentModel.set("path",data.path);
		            							documentModel.set("type",data.type);
		            							documentModel.set("documentId",data.id);
		            							documentModel.set("encryptedDocId",data.encryptedDocId);
		            							var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistgrid();
		            							var store = feeOfflinePaymentDocGrid.getStore();
		            							$this.getDocumentController().closeDocumentFormWindow();
		            						    showSuccessMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS'),getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS'));
		        							
		            							store.add(documentModel);
		            							if (feeOfflinePaymentDocGrid.isHidden() && store.data.items.length > 0) {
		            								feeOfflinePaymentDocGrid.setVisible(true);
		            							}
		            							}
		        						}
		        					}
		        				});
    						
    						}, isTransient);
    			}
    		},
    		'documentformwindow[itemId=fee_offline_paymentdocumentlist_grid] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
    			click : function() {
    				this.getDocumentController().closeDocumentFormWindow();
    			}
    		},
    		'feeofflinepaymentdocumentlistgrid':{
    			cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
    				if (e.target.tagName == 'A') {
    					if(!isNullOrEmpty(record.get("encryptedDocId"))){
    						var documentId = record.get("encryptedDocId");
    					}else{
    						var documentId = record.get("id");
    					}
    					
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFileForOfflinePaymentDocument(documentId);
    					}
    				}
    			}  
    		},
    		'feeofflinepaymentdocumentlistgrid button[itemId=downloadDocumentItemId]':{
    			click:function(obj){
    				this.documentReportDocumentZip();
    			}
    		},
    		'manageofflinepaymentdetailform button[itemId=SubmitBtn]':{
    			click:function(){
    				this.getSaveOfflinePaymentDetail();
    			}
    		},
 		   'manageofflinepaymentdetailform button[itemId=btnReset]':{
			   click:this.getResetOfflinePaymentDetailForm  
		   },
		   //*********Manage Offline Payment Detail Setting For Default Value********//
 		  'manageofflinepaymentdetailform':{
 			  render:function(){
 				  var $this = this;
 				  var form=$this.getManageofflinepaymentdetailform().getForm();
 				 /* var receivingCurrency=form.findField('receivingCurrency');
 				  var receivingCurrencyStore=receivingCurrency.getStore();
 				  receivingCurrencyStore.load({
 					  callback: function(record, operation, success) {
 						  if (success) {
 							  for(i=0;i<record.length;i++)
 							  {
 								  if(record[i].data.name=='INR')
 								  {
 									  receivingCurrency.setValue(record[i].data.id);
 								  }
 							  }
 						  }
 					  }
 				  });*/
 				  var documentGrid= $this.getFeeofflinepaymentdocumentlistgrid();
 				 documentGrid.getStore().removeAll();
 				 
 			  }  
 		  },
 		  'feeofflinepaymentdetailform':{
 			  render:function(obj){
 				  var $this = this;
 				  var receiptNo = obj.down('#receiptNo');
 				  var user=$this.getCurrentlyLoggedInUserInfoForPortal().student.id;
 				  var receiptNoStore = receiptNo.getStore();
 				  receiptNoStore.getProxy().extraParams = {
 					  studentId:user		                								   
 				  };
 				  receiptNoStore.load();
 			  }
 		  },
     	 'feeofflinepaymentdocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					this.offlinePaymentDeleteDocument();
				}
      	 },
      	 'feeofflinepaymentdetailgrid':{
      		selectionchange: function(column, selected,eOpts ){
            	this.disableOfflinePaymentGridButton(column,selected);                	
            },
            cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				   if(columnName=="noOfDocuments"){
           			   if(e.target.tagName=='A'){
            				  /*if(record.data.noOfDocuments== 1){
              			    	var whetherFile = false;
                			    	var documentId= record.data.id;
                			    	if(!isNullOrEmpty(documentId)){
                			    	Ext.Ajax.request({
                			            type: 'rest',
                			            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
                			            method: 'GET',
                			            callback : function(opt, success, response){
                			            	if(response.responseText == 'true') {
                			            		var csvForm = Ext.create('Ext.form.Panel'); 
                			        	    	csvForm.getForm().submit({
                			        		    	target: '_blank',
                			        		    	method:'GET',
                			        		    	params :{
                			        		    		access_token : Ext.Ajax.defaultHeaders.access_token
                			        		    	},
                			        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                			        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
                			        		    	standardSubmit :true
                			        	    	});
                			            	} else {
                			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
                			            	}
                			            }
                			         });
                			    	}} else */if(record.data.noOfDocuments >= 1){
            					  var docWindow = this.getOfflinepaymentdocumentlistwindow();
            					  var ID = record.data.id;
            					  if (!docWindow) {
            						 // Ext.widget('disciplinaryactiondocumentlist');
            						  docWindow = Ext.widget('offlinepaymentdocumentlistwindow',{
            							  itemId:'studentOfflinePaymentDocumentListWindow'
            						  });
            						//  docWindow = this.getDisciplinaryactiondocumentlist();
            					  }
            					  docWindow.show();
            					var documentlistgrid = docWindow.down('#feeofflinepaymentdocumentlistgridItemId');
            						documentlistgrid.down('#btnDelete').setVisible(false);
            						documentlistgrid.down('#downloadDocumentItemId').setVisible(false);
            						var checkcolumn = documentlistgrid.columnManager.getColumns()[0];
            						checkcolumn.destroy();
            						documentlistgrid.reconfigure();
            					documentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
            					 var portalId = this.getCurrentLoggedPortalId();
            					  var store = documentlistgrid.getStore();
            					  store.getProxy().extraParams = {
            						  offlinePaymentId: record.data.id
            					  };
            					  store.load();
            				  }
            			   }
   				   }
			   }
      	 },
		 'feeofflinepaymentdetailmainform button[itemId=searchBtn]':{
			// click: this.loadFeeOfflinePaymentMainDetail
			 click:this.getOfflinePaymentSearchList
		 },
		 'feeofflinepaymentdetailmainform button[itemId=resetBtn]':{
			 click:this.resetOfflinePaymentMainSearchDetails
		 },
		 'feeofflinepaymentdetailmaingrid button[itemId=btnView]':{
			 click:this.ViewOfflinePaymentMainDetails
		 },
		 'feeofflinepaymentdeatilforapplicantgrid button[itemId=btnView]':{
			 click:this.ViewOfflinePaymentMainDetails
		 },
		 'feeofflinepaymentdetailmaingrid button[itemId=availablebtnView]':{
			 click:this.ViewAvailablePaymentDetails
		 },
		 'feeofflinepaymentdetailmainform':{

			 render:function(){
         		var $this = this;
         		var form = this.getFeeofflinepaymentdetailmainform().getForm();
         		var frm = this.getFeeofflinepaymentdetailmainform();
         		//var form=this.getManagediscountfilter().getForm();
         		var userTypeField = form.findField('userType');
				var userTypeStore = userTypeField.getStore();
				
				userTypeStore.getProxy().extraParams = {
       			screenType:'offlinePayment'
        			};
				
				userTypeStore.load({
					callback: function(rec) {
						for (var i in rec) {
								userTypeField.setValue(rec[1].data.id);
						}
						$this.receiptSearch(rec[1].data.id,null);
					},
					/*params : {
						screenType:'offlinePayment'
					}*/
				});
				
         	}
		 },
		 'feeofflinepaymentdetailmainform customcombobox[itemId=userType]':{
				select:function(obj,record){
					var form = this.getFeeofflinepaymentdetailmainform()
					this.getShowAndHideOffilePaymentUser(obj,record,form); 
					var userType = form.down('#userType').getValue();
					var userId = form.down("#student").getValue();
					this.receiptSearch(userType,userId);
				}
			},
			'feeofflinepaymentdetailmainform customcombobox[itemId=student]':{
				select:function(obj,record){
					var form = this.getFeeofflinepaymentdetailmainform()
					var userType = form.down('#userType').getValue();
					var userId = form.down("#student").getValue();
					this.receiptSearch(userType,userId);
				}
			},
			'feeofflinepaymentdetailmainform customcombobox[itemId=applicant]':{
				select:function(obj,record){
					var form = this.getFeeofflinepaymentdetailmainform()
					var userType = form.down('#userType').getValue();
					var userId = form.down("#applicant").getValue();
					this.receiptSearch(userType,userId);
				}
			},
		

		 'manageofflinepaymentdetailmainform':{
 			  render:function(){
 				  var $this = this;
 				  var form=$this.getManageofflinepaymentdetailmainform().getForm();
 				  var documentGrid= $this.getFeeofflinepaymentdocumentlistmaingrid();
 				 documentGrid.getStore().removeAll();
 				 
 			  }  
 		  },
 		  'feeofflinepaymentdocumentlistmaingrid':{
 			  cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
 				  if (e.target.tagName == 'A') {
 					  var documentId = record.get("id");
 					  if (!isNullOrEmpty(documentId)) {
 						  this.getDownloadFileForOfflinePaymentMainDocument(documentId);
 					  }
 				  }
 			  }  
 		  },
 		  'feeofflinepaymentdocumentlistmaingrid button[itemId=downloadDocumentItemId]':{
 			  click:function(obj){
 				  this.documentReportDocumentMainZip();
 			  }
 		  },
       	 'feeofflinepaymentdetailmaingrid':{
             cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 				   if(columnName=="noOfDocuments"){
            			   if(e.target.tagName=='A'){
             				  /*if(record.data.noOfDocuments== 1){
               			    	var whetherFile = false;
                 			    	var documentId= record.data.id;
                 			    	if(!isNullOrEmpty(documentId)){
                 			    	Ext.Ajax.request({
                 			            type: 'rest',
                 			            url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
                 			            method: 'GET',
                 			            callback : function(opt, success, response){
                 			            	if(response.responseText == 'true') {
                 			            		var csvForm = Ext.create('Ext.form.Panel'); 
                 			        	    	csvForm.getForm().submit({
                 			        		    	target: '_blank',
                 			        		    	method:'GET',
                 			        		    	params :{
                 			        		    		access_token : Ext.Ajax.defaultHeaders.access_token
                 			        		    	},
                 			        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                 			        		    	url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
                 			        		    	standardSubmit :true
                 			        	    	});
                 			            	} else {
                 			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
                 			            	}
                 			            }
                 			         });
                 			    	}} else */if(record.data.noOfDocuments >= 1){
             					  var docWindow = this.getOfflinepaymentdocumentlistmainwindow();
             					  var ID = record.data.id;
             					  if (!docWindow) {
             						 // Ext.widget('disciplinaryactiondocumentlist');
             						  docWindow = Ext.widget('offlinepaymentdocumentlistmainwindow',{
             							  itemId:'OfflinePaymentDocumentListMainWindow'
             						  });
             						//  docWindow = this.getDisciplinaryactiondocumentlist();
             					  }
             					  docWindow.show();
             					var documentlistgrid = docWindow.down('#feeofflinepaymentdocumentlistmaingridItemId');
             					documentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
             					 var portalId = this.getCurrentLoggedPortalId();
             					  var store = documentlistgrid.getStore();
             					  store.getProxy().extraParams = {
             						  offlinePaymentId: record.data.id
             					  };
             					  store.load();
             				  }
             			   }
    				   }
 			   },
 		  			afterrender:function(grid){
 		  					var me = this;
 		  					setTimeout(function(){
 		  					me.addDataGridConfigButton(grid, me.getMANAGE_OFFLINE_PAYMENT());
 		  			},1500);
			   }
       	 	},
       	 'feeofflinepaymentdetailmaingrid':{
       		 itemclick: function(dv, record, item, index, e) {
       			 var status = record.data.status;
       			 var studentGrid = this.getFeeofflinepaymentdetailmaingrid();
					var availablebtnView=studentGrid.down("#availablebtnView");
					  if(status=="PENDING"){
						  availablebtnView.setDisabled(false);
					  }else{
						  availablebtnView.setDisabled(true);
					  }
					
       			 
       		 }
       	 },
       	 'feeofflinepaymentdeatilforapplicantgrid':{
       		 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				   if(columnName=="noOfDocuments"){
          			   if(e.target.tagName=='A'){
           		if(record.data.noOfDocuments >= 1){
           					  var docWindow = this.getOfflinepaymentdocumentlistmainwindow();
           					  var ID = record.data.id;
           					  if (!docWindow) {
           						 // Ext.widget('disciplinaryactiondocumentlist');
           						  docWindow = Ext.widget('offlinepaymentdocumentlistmainwindow',{
           							  itemId:'OfflinePaymentDocumentListMainWindow'
           						  });
           						//  docWindow = this.getDisciplinaryactiondocumentlist();
           					  }
           					  docWindow.show();
           					var documentlistgrid = docWindow.down('#feeofflinepaymentdocumentlistmaingridItemId');
           					documentlistgrid.setTitle(getCommonTranslation('LIST_OF_DOCUMENTS'));
           					 var portalId = this.getCurrentLoggedPortalId();
           					  var store = documentlistgrid.getStore();
           					  store.getProxy().extraParams = {
           						  offlinePaymentId: record.data.id
           					  };
           					  store.load();
           				  }
           			   }
  				   }
       		 },
       		afterrender:function(grid){
					var me = this;
					setTimeout(function(){
					me.addDataGridConfigButton(grid, me.getMANAGE_OFFLINE_PAYMENT());
			},1500);
   }
       		 
       	 },
       	 	'manageofflinepaymentdetailmainform button[itemId=rejectBtn]':{
       	 		click:function(obj){
       	 			this.rejectOfflinePaymentDetails();
       	 		}
       	 	},
       	 	'manageofflinepaymentdetailmainform button[itemId=generateReceipt]':{
       	 		click:function(obj){
       	 			var $this = this;
       	 			var studentGrid = $this.getFeeofflinepaymentdetailmaingrid();
       	 			var applicantGrid = $this.getFeeofflinepaymentdeatilforapplicantgrid();
       	 			var grid=null;
       	 			if(!studentGrid.isHidden()){
       	 				grid =studentGrid ;
       	 			}
       	 			if(!applicantGrid.isHidden()){
       	 				grid =applicantGrid ;
       	 			}
       	 			this.generateOfflinePaymentDetailsReceipt(grid);
       	 		}
       	 	},
       	 	'paymentsearchform multiselectcombofield[itemId=fnpMultiBrandCampusPaymentItemId]': {
			 render: function(){
				 var $this = this;
				 var formLayout = $this.getPaymentsearchform();
				 var academyLocationId = this.getCurrentAcademyLocation();
				 var multiBrandCampusId = formLayout.down('#fnpMultiBrandCampusPaymentItemId');
				 var ALComboStore = multiBrandCampusId.getStore();
				 ALComboStore.load({
					 callback: function(records, operation, success) {
						 if (success) {
							 multiBrandCampusId.select(multiBrandCampusId.getStore().collect(multiBrandCampusId.valueField));
						 }
					 }   
				 });
			 },
			 change : function(obj,record) { 
				 var $this = this;
				 setTimeout(function(){
					 $this.fnpChangePaymentAcademyLocationEvent(obj,record);
				 },300);
			 }

       	 	},
       	 	/*** Start code for loader forms ***/
       	 	
       	 'downloadpaymentform':{
			   render:function(obj,record){
				   var $this = this;
				   var form = $this.getDownloadpaymentform().getForm();
				   var store = form.findField("raiseBillType").getStore();
				   store.getProxy().extraParams = {
					   screenType:"add"
				   };
				   store.load();
					this.disableInactiveStudentPivileges(form, this.getMANAGE_PAYMENT_FOR_INACTIVE_STUDENT(),form.findField("whetherInactiveStudent"));

			   }
		   },

		   'downloadpaymentform customcombobox[itemId=raiseBillType]':{
			   select:function(obj,record){
				   var $this = this;
				   var form = $this.getDownloadpaymentform().getForm();
				   var receiptForField = form.findField('paymentFor');
				   var raiseBillType = record[0].get("id");
				   var store = this.getStore('feeandpayment.managebill.BillForPayment');
				   store.getProxy().extraParams = {
					   raiseBillType: raiseBillType
				   };
				   store.load({
					   callback: function(records, operation, success) {
						   if (success) {
							   if(raiseBillType == "SCHOLARSHIP" || raiseBillType == "SERVICE_RECEIVED") {
								   receiptForField.setValue(records[0].data.id);
								   receiptForField.fireEvent('select',receiptForField,records[0].data.id);
							   }
						   }
					   }	
				   });
			   }
		   },
		   
		   'downloadpaymentform customcombobox[itemId=paymentFor]':{
			   select:function(obj,record){
				   var $this = this;
				   var form = $this.getDownloadpaymentform().getForm();
				   var receiptForField = form.findField('paymentFor');
				 var   paymentForValue=  receiptForField.getDisplayValue();
				   var whetherInactive = form.findField('whetherInactiveStudent');
				   
				   if(paymentForValue=='STUDENT'){
					   whetherInactive.reset();
					   whetherInactive.setDisabled(false);
				   }else{
					   whetherInactive.setDisabled(true);
					   whetherInactive.reset();
				   }
			   }
		   },

		   'importpaymentform button[itemId=SubmitBtn]':{
			   click:function(obj){
				   var $this=this;
				   var importWin = $this.getImportpaymentform()
				   var grdStore;
				   /*if($this.getImportUtilityList() !=undefined){
						grdStore = $this.getImportUtilityList().getStore();
					}*/
				   var form = $this.getImportpaymentform();
				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	           $this.getHashOfFile(form);
		           setTimeout(function() {
  				   form.getForm().submit({
  					   method : 'POST',
  					   url : submitUrl,
  					   success : function(form, action){
  						   //$this.getCloseImportUtilityWin();
  						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
  						   //grdStore.reload();
  						   /*if($this.getImportUtilityList() !=undefined){
      			grdStore.reload();
      		}*/
  					   },
  					   failure: function(form, action) {
  						   //$this.getCloseImportUtilityWin();
		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
  						   //grdStore.reload();
  						   /*if($this.getImportUtilityList() !=undefined){
      			grdStore.reload();
      		}*/
  					   }
  				   });
		        	  },1000);

				   Ext.defer(function() {
					   var grid = $this.getImportlistpayments();
					   var form = this.getImportpaymentuploadoptionradiogroup();
					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
					   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_PAYMENT_UPLOAD');
				   }, 2000, this);
			   }  
		   },
		   'importpaymentform uploadoptionradiogroup[itemId=importpaymentUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
			   change: function( radioGroup, newValue, oldValue, eOpts){
				   var grid = this.getImportlistpayments();
				   var form = this.getImportpaymentuploadoptionradiogroup();
				   var isUploadAll = newValue.isUploadAll;
				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_PAYMENT_UPLOAD');
			   }   
		   },

		   'importpaymentform button[itemId=resetBtn]':{
			   click:function(obj){
				   var $this = this;
				   var form = $this.getImportpaymentform().getForm();
				   form.findField('file').reset();	 
				   var uploadoptionradiogroupform  = $this.getImportpaymentuploadoptionradiogroup();
				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
					   isUploadAll: false
 				   });
				   form.isValid();
			   },
			   render :function(obj){
				   var $this = this;
				   var form = $this.getImportpaymentform().getForm();
				   var combo = form.findField('importUtilityMasterId');
				   combo.getStore().load({
					   callback: function(records, operation, success) {
						   for(var i in records){
							   if(records[i].data.value=='Bulk Payments'){
								   combo.setValue(records[i].data.id);
								   combo.setReadOnly(true);
							   }
						   }
					   }	   
				   });
			   }  
		   },

		   'downloadpaymentform button[itemId=resetBtn]':{
			   click:function(obj){
				   var $this = this;
				   var form =$this.getDownloadpaymentform().getForm();
				   form.findField('whetherInactiveStudent').setDisabled(false);
				   form.reset();
			   }  
		   },

		   'downloadpaymentform button[itemId=paymentDownload]':{
			   click:function(obj){
				   var $this = this;
				   var form = $this.getDownloadpaymentform().getForm();
				   var importDownloadPaymentForm = $this.getImportdownloadpaymentform();
				   var academyLocationId = importDownloadPaymentForm.down("#fnpMultiBrandCampusItemId").getValue();
				   
            	 //*********for multiselect Academy Location**********
            	   var ALsId = [];
            	   for(var i in academyLocationId){
            		   if(Ext.isObject(academyLocationId[i])){
            			   ALsId.push(academyLocationId[i].data.id);
            		   }else{
            			   ALsId.push(academyLocationId[i]);
            		   }
            	   }
            	   var academyLocationIds = ALsId.join();
            	   if(isNullOrEmpty(academyLocationIds)) {
            		   academyLocationIds = academyLocationId;
            	   }
            	   if(academyLocationIds == "") {
            		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD') + " :  " + getCommonTranslation('BRAND_CAMPUS'));
            		 return false;
            	   }
            	   else {
            		   var value = form.getValues();
            		   var csvForm = Ext.create('Ext.form.Panel'); 
            		   csvForm.getForm().submit({
            			   target: '_blank',
            			   method:'POST',
            			   params :{
            				   access_token : Ext.Ajax.defaultHeaders.access_token,
            				   academyLocationId: $this.getCurrentAcademyLocation(),
            				   billType: value.raiseBillType,
            				   paymentFor: form.findField("paymentFor").getRawValue(),
            				   voucherType: value.paymentmode,
            				   autosettle: value.onlineAutoAdjustment,
            				   academyLocationIds: academyLocationIds,
            				   whetherInactive:value.whetherInactiveStudent
            			   },
            			   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
            			   url: SERVERURL.DOWNLOAD_TEMPLATE_PAYMENT,
            			   standardSubmit :true
            		   });
            	   }
			   }  
		   },
		   'importdownloadpaymentform':{
			   render: function(form){
				   var $this = this;
				   $this.fncDisablePaymentImportALPivileges(form, $this.getPAYMENT_BULK_IMPORT_UTILITY_PERMISSION());
			   }
		   },
		   'importdownloadpaymentform multiselectcombofield[itemId=fnpMultiBrandCampusItemId]': {

			   change : function(obj, record) {
				   var $this = this;
				   var formLayout = $this.getDownloadpaymentform();
				   var paymentBtn = formLayout.down('#paymentDownload');
				   if(record.length == 0) {
					   paymentBtn.setDisabled(true);
				   } 
				   else {
					   paymentBtn.setDisabled(false);
				   }
			   }
		   },
		   'importdownloadpaymentform radiogroup[itemId=importDownloadgroupId]':{
			   change: this.downloadUploadFormChange
		   },
		   'importlistpayments':{
			   render:function(obj){
				   var $this = this;
				   var grid = $this.getImportlistpayments();
				   var form = this.getImportpaymentuploadoptionradiogroup();
				   var isUploadAll = form.items.items[0].getValue().isUploadAll;
				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_PAYMENT_UPLOAD');
			   },
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   if (e.target.tagName == 'A') {
					   var fileType = null;
					   if(cellIndex == 1){
						   fileType = 'successFile';
					   }else if(cellIndex == 6){
						   fileType = 'errorFile';
					   }else if(cellIndex == 7){
						   fileType = 'logFile';
					   }
					   var documentId = record.get("id");
					   if (!isNullOrEmpty(documentId)) {
						   this.getDownloadFile(documentId,fileType);
					   }
				   }
			   }
		   },
		   'importlistpayments button[itemId=btnForce]':{
			   click: function(obj) {
				   var grid = this.getImportlistpayments();
				   if (grid.getSelectionModel().getCount() > 0) {
					   if(grid.getSelectionModel().getCount() > 1){
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					   }else{
						   var this$ = this;
						   var id = grid.getSelectionModel().selectionStart.data.id;
						   console.log(id);
						   var urlAppend="?jobName="+id;
						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						   Ext.Ajax.request({
							   url: submitURL,
							   method: 'GET',
							   success: function(response) {
								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
									   //console.log("Manual trigger hit");
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
								   }else if(response.responseText==="SUCCESS"){
									   //console.log("Manual trigger hit");
									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
									   grid.getStore().reload();
								   }
							   }
						   });
					   }
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }  
			   }
		   },
		   'feeofflinepaymentdocumentlistgrid':{
			   afterlayout:function(grid){
				   var recordCount = grid.getStore().getCount();
				   if(document.getElementsByClassName('gridTotalDivCls '+grid.id)[0]){
					    if(recordCount==0){
						    document.getElementsByClassName('gridTotalDivCls '+grid.id)[0].innerHTML = " ";
					    }else{
						    document.getElementsByClassName('gridTotalDivCls '+grid.id)[0].innerHTML = "<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": "+recordCount+ "</span>";
					    }
				   }
			   }
		   },
		   'addressdetailpanel[itemId=paymentaddressdetailpanel]':{
				 render:function(flyOut){
					this.doAccessControlValidationForFlyOut(flyOut, this.getMANAGE_PAYMENT_PRIVILEGES());
				 }
			 }
    	  });//
      },
      // ********** show Hide field based on payment mode******
      showHideBankLadgerField : function(value,newValue){
    	
    	  var form = this.getManagepaymentform();
          
    	  var paymentType = form.down("#paymentType");
       	  var bankAcount = form.down("#depositedBankAcount");
       	  var depositeledger = form.down("#depositedLedger");
       	  var paymentheaderPanel = form.down("#paymentheaderPanel");
       	  var amount1 = form.down("#amount1");
       	  var paymentCurrency = form.down("#paymentCurrency");
       	  var value = form.getValues();
       	  var academyLocationId = value.fnpBrandCampusName;
       	  var paymentOn = form.down("#paymentOn");
		  var paymentOnText =  form.down("#paymentOnText");
       	 
       	  bankAcount.reset();
          depositeledger.reset();
          amount1.reset();
 		  
          paymentType.setVisible(false);
 		 // bankAcount.setVisible(false);
 		 // depositeledger.setVisible(false);
 		  paymentheaderPanel.setVisible(false);
 		  amount1.setVisible(false);
 		  paymentCurrency.setVisible(false);
 		  amount1.allowBlank = true;
       	  if(newValue.paymentmode=='CASH'){
       		//depositeledger.setVisible(true); 
       		amount1.setVisible(true);
       		amount1.hideLabel = true;
       		amount1.allowBlank = false;
       		paymentCurrency.setVisible(true);
       		amount1.setFieldLabel(getFeeAndPaymentCommonTranslation('AMOUNT')+'<span class="required" style="color:red"> *</span>');
       		paymentheaderPanel.items.each(function(item, index, items) {
       			
       		  var paymentMode = item.down('#paymentMode');	 
      	      var instrumentsNo = item.down('#instrumentsNo');
      	      var instrumentDate = item.down('#instrumentDate');
      	      var amount = item.down('#amount');
      	      var drawnOnBank = item.down('#drawnOnBank');
       			
	      	  paymentMode.reset();
	  	      instrumentsNo.reset();
	  	      instrumentDate.reset();
	  	      amount.reset();
	  	      drawnOnBank.reset();
  	      
     	      paymentMode.allowBlank = true;
     	      instrumentsNo.allowBlank = true;
     	      instrumentDate.allowBlank = true;
     	      amount.allowBlank = true;
     	      drawnOnBank.allowBlank = true;
       	   });
       		this.removeDynamicFields();
			 this.loadDFRForManagePaymentFieldVisibility(form.down("#isAutoSettlementPayment"),form.down("#SubmitAndAdjustmentBtn"));
       	  }
       	  if(newValue.paymentmode=='BANK'){
       		//bankAcount.setVisible(true);
         	paymentCurrency.setVisible(true);
       		paymentheaderPanel.setVisible(true);
       		paymentType.setVisible(true);
       		paymentheaderPanel.items.each(function(item, index, items) {
       		 var paymentMode = item.down('#paymentMode');	 
     	      var instrumentsNo = item.down('#instrumentsNo');
     	      var instrumentDate = item.down('#instrumentDate');
     	      var amount = item.down('#amount');
     	      var drawnOnBank = item.down('#drawnOnBank');
     	      paymentMode.allowBlank = false;
     	      instrumentsNo.allowBlank = false;
     	      instrumentDate.allowBlank = false;
     	      amount.allowBlank = false;
     	      drawnOnBank.allowBlank = false;
       	   });
       	  var defaultBankAccount=form.down('#drawnOnBank');
		  var defaultBankAccountStore=defaultBankAccount.getStore();
		  
		  defaultBankAccountStore.load({
			   params:{
				   defaultAccount:0,
				   academyLocationIds:academyLocationId
				   },
			   callback: function(record, operation, success) {
			   if (success) {
				   for(i=0;i<record.length;i++)
				   {
				   if(record[i].data.sequence!=null)
					   {
					   defaultBankAccount.setValue(record[i].data.id);
					   }
				   }
	   }
		   }
		   });
		  if( this.getManagepaymentform().down("#paymentType").getValue().paymentType=="PDC"){
			  this.getManagepaymentform().down("#isAutoSettlementPayment").setVisible(false);
			  this.getManagepaymentform().down("#isAutoSettlementPayment").items.items[0].setValue(false);
			  this.getManagepaymentform().down("#isAutoSettlementPayment").items.items[1].setValue(true);
			  this.getManagepaymentform().down("#SubmitAndAdjustmentBtn").setVisible(false);
		   }   
		  
		  
		  this.showHidepaymentOnFieldFromDFR();
		  }else{
			  paymentOn.setVisible(false);
			  paymentOnText.setVisible(false);
		   }
       	  
       	
      },
    
      //******** to check paymet for students,users or etc.
      checkpaymentFor : function(obj,record){
    	 
    	  var form = this.getManagepaymentform();
    	  
    	  var value = null;
    	  if(record){
    		  value = record[0].get("value");  
    	  }else{
    		  value = form.down("#paymentFor").getRawValue();
    	  }
    	  var paymentTo = form.down("#paymentTo").getValue();
    	  var paymentOn = form.down("#paymentOn");
    	  
    	  var thirdPartyField = form.down("#thirdParty");
    	  var applicantField = form.down("#applicant");
    	  var sponsorField = form.down("#sponsors");
    	  var userField = form.down("#userId");
    	  var studentField = form.down("#student");
    	  var scholarshipField = form.down("#scholarship");
    	  var scholarshipStudentField = form.down("#scholarshipStudent");
    	  var inActiveStudent = form.down("#inActiveStudentItemId");
    	  var formMode = this.managepaymentFormMode;
    	  
    	  applicantField.setVisible(false);
		  sponsorField.setVisible(false);
		  thirdPartyField.setVisible(false);
		  userField.setVisible(false);
		  studentField.setVisible(false);
		  scholarshipField.setVisible(false);
		  scholarshipStudentField.setVisible(false);
		  inActiveStudent.setVisible(false);
		  inActiveStudent.reset();
		  
		  applicantField.allowBlank=true;
		  sponsorField.allowBlank=true;
		  thirdPartyField.allowBlank=true;
		  userField.allowBlank=true;
		  studentField.allowBlank=true;
		  
		  if(paymentTo =="SCHOLARSHIP" && value=="STUDENT"){
			  scholarshipField.allowBlank=false;
			  scholarshipStudentField.allowBlank=false;
			  if(formMode!='VIEW')
			    inActiveStudent.setVisible(true);
    	  }else{
    		  scholarshipField.allowBlank=true;
    		  scholarshipStudentField.allowBlank=true;
    	  }
         if(value=="STUDENT"){
							if(paymentTo=="SCHOLARSHIP"){
							inActiveStudent.setVisible(false);
							}
					      }
		  
		  applicantField.reset();
		  sponsorField.reset();
		  thirdPartyField.reset();
		  userField.reset();
		  studentField.reset();
		  scholarshipField.reset();
		  scholarshipStudentField.reset();
		  paymentOn.reset();
		  
    	  if(paymentTo !="SCHOLARSHIP" && value=="STUDENT"){
    		  studentField.allowBlank=false;
    		  studentField.setVisible(true);
    		  if(formMode!='VIEW')
    		   inActiveStudent.setVisible(true);
    	  }
    	  if(value=="USER"){
    		  userField.allowBlank=false;
    		  userField.setVisible(true);
    	  } 
    	  if(value=="SPONSOR"){
    		  sponsorField.allowBlank=false;
    		  sponsorField.setVisible(true);
    	  }
    	  
    	  if(value=="THIRD PARTY"){
    		  thirdPartyField.allowBlank=false;
    		  thirdPartyField.setVisible(true);
    	  }
    	  if(value=="APPLICANT"){
    		  applicantField.allowBlank=false;
    		  applicantField.setVisible(true);
    	  }
    	  if(paymentTo=="SCHOLARSHIP"){
    		  scholarshipField.allowBlank=false;
    		  scholarshipField.setVisible(true);
    		  scholarshipStudentField.setVisible(true);
    		  scholarshipField.allowBlank=false;
    	  }
    	  if(form.getForm().hasInvalidField()==false){
			  form.down('#SubmitBtn').setDisabled(false);
			  form.down('#SubmitAndAdjustmentBtn').setDisabled(false);
		  }else{
			  form.down('#SubmitBtn').setDisabled(true);
			  form.down('#SubmitAndAdjustmentBtn').setDisabled(true);
		  }
    	  if(this.managepaymentFormMode!='VIEW'){
    		  this.showHidepaymentOnFieldFromDFR(value);
    	  }
    	  paymentOn.getStore().removeAll();
      },
      //********* Set Address For third Party*********
      setAddressForThirdParty:function(obj,record){
    	  var form = this.getPaymentAddressDetailPanel();
    	  if (form.collapsed) {
    		  form.expand();
    	  }
    	  
    		 
    	  
    	  form.down("#emailId").setValue(record[0].get("emailId"));
    	  form.down("#contactNo").setValue(record[0].get("cellNo"));
    	  form.down("#address").setValue(record[0].get("addressText"));
      },
      //********* Set Address For Sponsor *********
      setAddressForSponsors:function(obj,record){
    	  var form = this.getPaymentAddressDetailPanel();
    	  var paymentForm = this.getManagepaymentform();
    	  var paymentOnCombo = paymentForm.down('#paymentOn');
    	  var paymentOnComboStore = paymentOnCombo.getStore();
    	  paymentOnComboStore.removeAll();
    	  
    	  if (form.collapsed) {
    		  form.expand();
    	  }
    	  form.down("#profile_image").setVisible(false);
    	  var sponsorId ;
    	  if(record){
    		  sponsorId = record[0].get("id");
    	  }else{
    		  sponsorId = obj;
    	  }

    	  paymentOnComboStore.getProxy().extraParams = {
    		  id:sponsorId,
    		  userType:'SPONSOR'
    	  };
    	  paymentOnComboStore.load();
    	  Ext.Ajax.request({
    		  method: "GET",
    		  type: 'rest',
    		  url: SERVERURL.SPONSOR_FLYOUT,
    		  params: {
    			  sponsorId: sponsorId
    		  },
    		  success: function(f, action) {
    			  var responseData = Ext.JSON.decode(f.responseText);
    			  form.down("#sponsorType").setVisible(true);
    			  form.down("#sponsorCode").setVisible(true);
    			  form.down("#noOfSponsoredStudents").setVisible(true);

    			  form.down("#addmissionId").setVisible(false);
    			  form.down("#applicationId").setVisible(false);
    			  form.down("#userId").setVisible(false);
    			  form.down("#program").setVisible(false);
    			  form.down("#batch").setVisible(false);
    			  form.down("#section").setVisible(false);
    			  form.down("#seatType").setVisible(false);
    			  form.down("#period").setVisible(false);
    			  form.down("#whetherFaculty").setVisible(false);
    			  form.down("#whetherInternal").setVisible(false);
    			  form.down("#departmentName").setVisible(false);
    			  form.down("#feeheadwisedistributionId").setVisible(false);

    			  form.down("#name").setValue(responseData.sponsorName);
    			  form.down("#address").setValue(responseData.addressText);
    			  form.down("#emailId").setValue(responseData.primaryEmailId);
    			  form.down("#contactNo").setValue(responseData.phoneNo);
    			  form.down("#sponsorType").setValue(responseData.sponsorType);
    			  form.down("#sponsorCode").setValue(responseData.sponsorCode);
    			  if(!isNullOrEmpty(form.down("#totalDiscountAmount"))){
    				 form.down("#totalDiscountAmount").setValue(responseData.totalDiscountAmount);
    			  }
    			  form.down("#noOfSponsoredStudents").setValue(responseData.noOfSponsoredStudents);
    			  if(!isNullOrEmpty(form.down("#totalAdvanceFee"))){
    				 form.down("#totalAdvanceFee").setValue(responseData.totalAdvanceFee);
    			  }
    			  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
    			  form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
    			  form.down("#totalBalance").setValue(responseData.totalBalance);
    			  form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
    			  form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
    		 
    		  }
    	  });

      },
      //********* Set Address For Applicant *********
      setAddressForApplicant:function(obj,record){
    	  var form = this.getPaymentAddressDetailPanel();
    	  var paymentForm = this.getManagepaymentform();
    	  var paymentOnCombo = paymentForm.down('#paymentOn');
    	  var paymentOnComboStore = paymentOnCombo.getStore();
    	  paymentOnComboStore.removeAll();
    	  if (form.collapsed) {
    		  form.expand();
    	  }
    	  form.down("#profile_image").setVisible(true);

    	  var applicantId ;
    	  var personId;
    	  if(record){
    		  applicantId = record[0].get("id");
    		  personId = record[0].get("personId");
    	  }else{
    		  applicantId = obj.applicant.id;
    		  personId =obj.applicant.personId;
    	  }
    	  paymentOnComboStore.getProxy().extraParams = {
    		  id:applicantId,
    		  userType:'APPLICANT'
    	  };
    	  paymentOnComboStore.load();

    	  form.down("#applicantId").setValue(applicantId);
    	  if(!isNullOrEmpty(personId)){
    		  Ext.Ajax.request({
    			  type: 'rest',
    			  binary: true,
    			  url: SERVERURL.APPLICANT_IMAGE_DOWNLOAD+'?personId='+personId,
    			  method: 'GET',
    			  success : function(response){
    				  if(response.responseBytes.length>0){
    					  var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					  var url = window.URL.createObjectURL(blob);
    					  var image = form.down("#profile_image");
    					  image.getEl().dom.src=url;
    				  }
    			  }
    		  });
    	  }
    	  Ext.Ajax.request({
    		  method: "GET",
    		  type: 'rest',
    		  url: SERVERURL.APPLICANT_FLYOUT,
    		  params: {
    			  id: applicantId
    		  },
    		  success: function(f, action) {
    			  var responseData = Ext.JSON.decode(f.responseText);
    			  form.down("#program").setVisible(true);
    			  form.down("#batch").setVisible(true);
    			  form.down("#seatType").setVisible(true);
    			  form.down("#applicationId").setVisible(true);

    			  form.down("#sponsorType").setVisible(false);
    			  form.down("#sponsorCode").setVisible(false);
    			  form.down("#noOfSponsoredStudents").setVisible(false);
    			  form.down("#addmissionId").setVisible(false);
    			  form.down("#period").setVisible(false);
    			  form.down("#section").setVisible(false);
    			  form.down("#userId").setVisible(false);
    			  form.down("#whetherFaculty").setVisible(false);
    			  form.down("#whetherInternal").setVisible(false);
    			  form.down("#departmentName").setVisible(false);
    			  form.down("#feeheadwisedistributionId").setVisible(true);

    			  form.down("#name").setValue(responseData.applicantName);
    			  form.down("#fatherName").setValue(responseData.fatherName);
    			  form.down("#address").setValue(responseData.addressText);
    			  form.down("#emailId").setValue(responseData.primaryeEmailId);
    			  form.down("#contactNo").setValue(responseData.cellNo);
    			  form.down("#applicationId").setValue(responseData.code);
    			  form.down("#program").setValue(responseData.program);
    			  form.down("#batch").setValue(responseData.batch);
    			  form.down("#seatType").setValue(responseData.seatType);	
//    			  form.down("#totalDiscountAmount").setValue(responseData.totalDiscountAmount);
//    			  form.down("#totalAdvanceFee").setValue(responseData.totalAdvanceFee);
    			  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
    			  form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
    			  form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
    			  form.down("#totalBalance").setValue(responseData.totalBalance);
    			  form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
    			  form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
    			  form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);
    		  }
    	  });
      },
      //********* Set Address For user *********
      setAddressForUser:function(obj,record){
    	  var form = this.getPaymentAddressDetailPanel();
    	  if (form.collapsed) {
    		  form.expand();
    	  }
    	  form.down("#profile_image").setVisible(true);
    	  var userId ;
    	  var personId;
    	  if(record){
    		  userId = record[0].data.id;
    		  personId = record[0].data.personId;
    	  }else{
    		  userId = obj.user.id;
      		 personId = obj.user.personId;
    	  }

    	  if(!isNullOrEmpty(userId)){
    		  Ext.Ajax.request({
    			  type: 'rest',
    			  binary: true,
    			  url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
    			  method: 'GET',
    			  success : function(response){
    				  if(response.responseBytes.length>0){
    					  var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					  var url = window.URL.createObjectURL(blob);
    					  var image = form.down("#profile_image");
    					  image.getEl().dom.src=url;
    				  }
    			  }

    		  });

    		  Ext.Ajax.request({
    			  method: "GET",
    			  type: 'rest',
    			  url: SERVERURL.STAFFF_LYOUT,
    			  params: {
    				  userId:userId

    			  },
    			  success: function(f, action) {
    				  var responseData = Ext.JSON.decode(f.responseText);
    				  form.down("#departmentName").setVisible(true),
    				  form.down("#whetherFaculty").setVisible(true),
    				  form.down("#whetherInternal").setVisible(true),
    				  form.down("#userId").setVisible(true),

    				  form.down("#addmissionId").setVisible(false);
    				  form.down("#applicationId").setVisible(false);
    				  form.down("#program").setVisible(false);
    				  form.down("#batch").setVisible(false);
    				  form.down("#period").setVisible(false);
    				  form.down("#section").setVisible(false);
    				  form.down("#seatType").setVisible(false);
    				  form.down("#sponsorType").setVisible(false);
    				  form.down("#sponsorCode").setVisible(false);
    				  form.down("#noOfSponsoredStudents").setVisible(false);

    				  form.down("#name").setValue(responseData.printName);
    				  form.down("#address").setValue(responseData.addressText);
    				  form.down("#emailId").setValue(responseData.primaryEmailId);
    				  form.down("#contactNo").setValue(responseData.cellNo);
    				  form.down("#userId").setValue(responseData.userId);
    				  form.down("#departmentName").setValue(responseData.departmentName);
    				  form.down("#whetherFaculty").setValue(responseData.whetherFaculty);
    				  form.down("#whetherInternal").setValue(responseData.whetherInternal);
    				  form.down("#totalBalance").setValue(responseData.totalBalance);
    				  form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
    				  form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
    				  form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount); 
    				  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);

    				  
    			  }
    		  });
    	  }
      },
      //********* Set Address For Student *********
      setAddressForStudent : function(obj,record){
    	  var form = this.getPaymentAddressDetailPanel();
    	  var paymentForm = this.getManagepaymentform();
    	  var paymentOnCombo = paymentForm.down('#paymentOn');
    	  var paymentOnComboStore = paymentOnCombo.getStore();
    	  paymentOnComboStore.removeAll();
    	  
    	  if (form.collapsed) {
    		  form.expand();
    	  }
    	  form.down("#profile_image").setVisible(true);

    	  var studentId ;
    	  var personId;
    	  if(record){
    		  studentId = record[0].get("id");
    		  personId = record[0].get("personId");
    	  }else{
    		  studentId = obj.student.id;
    		  personId =obj.student.personId;
    	  }

    	  paymentOnComboStore.getProxy().extraParams = {
    		  id:studentId,
    		  userType:'STUDENT'
    	  };
    	  paymentOnComboStore.load();
    	  if(!isNullOrEmpty(personId)){
    		  Ext.Ajax.request({
    			  type: 'rest',
    			  binary: true,
    			  url: SERVERURL.PERSON_IMAGE_DOWNLOAD+'?personId='+personId,
    			  method: 'GET',
    			  success : function(response){
    				  if(response.responseBytes.length>0){
    					  var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					  var url = window.URL.createObjectURL(blob);
    					  var image = form.down("#profile_image");
    					  image.getEl().dom.src=url;
    				  }
    			  }
    		  });
    	  }
    	  Ext.Ajax.request({
    		  method: "GET",
    		  type: 'rest',
    		  url: SERVERURL.PAYMENT_STUDENT_FO_FLYOUT_INFO,
    		  params: {
    			  studentId: studentId
    		  },
    		  success: function(f, action) {
    			  var responseData = Ext.JSON.decode(f.responseText);

    			  form.down("#departmentName").setVisible(false),
    			  form.down("#whetherFaculty").setVisible(false),
    			  form.down("#whetherInternal").setVisible(false),
    			  form.down("#sponsorType").setVisible(false);
    			  form.down("#sponsorCode").setVisible(false);
    			  form.down("#noOfSponsoredStudents").setVisible(false);

    			  form.down("#addmissionId").setVisible(true);
    			  form.down("#applicationId").setVisible(true);
    			  form.down("#program").setVisible(true);
    			  form.down("#batch").setVisible(true);
    			  form.down("#feeheadwisedistributionId").setVisible(true);
    			  
    			  var alinfomodel = Academia.model.authentication.ALInfoModel;
    			  var wheatherSchool = alinfomodel.get('wheatherSchool');
    			  if(wheatherSchool){
    			     form.down("#period").setVisible(false);
    			  }else{
    			     form.down("#period").setVisible(true);
    			     form.down("#period").setValue(responseData.period);   
    			  }
    			  
    			  form.down("#section").setVisible(true);
    			  form.down("#seatType").setVisible(true);
    			  form.down("#userId").setVisible(true);

    			  form.down("#name").setValue(responseData.studentName);
    			  form.down("#applicantId").setValue(" ");
    			  form.down("#fatherName").setValue(responseData.fatherName);
    			  form.down("#address").setValue(responseData.addressText);
    			  form.down("#emailId").setValue(responseData.primaryeEmailId);
    			  form.down("#contactNo").setValue(responseData.cellNo);
    			  form.down("#addmissionId").setValue(responseData.admissionID);
    			  form.down("#applicationId").setValue(responseData.applicationID);
    			  form.down("#userId").setValue(responseData.id);
    			  form.down("#program").setValue(responseData.programName);
    			  form.down("#batch").setValue(responseData.batch);
    			  form.down("#period").setValue(responseData.period);
    			  form.down("#section").setValue(responseData.sectionCode);
    			  form.down("#seatType").setValue(responseData.seatType);	
    			  form.down("#studentCode").setValue(responseData.studentCode);
    			  
    			  form.down("#totalBalance").setValue(responseData.totalBalance);	
    			  form.down("#totalAcadInvoiceAmount").setValue(responseData.totalAcadInvoiceAmount);
    			  form.down("#totalAcadReceiptAmount").setValue(responseData.totalAcadReceiptAmount);
    			  form.down("#totalConvertedOutstanding").setValue(responseData.totalConvertedOutstanding);
    			  form.down("#person").setValue(responseData.personId);
//    			  form.down("#totalDiscountAmount").setValue(responseData.totalDiscountAmount);
//    			  form.down("#totalAdvanceFee").setValue(responseData.totalAdvanceFee);
    			  form.down("#totalAcadPaymentAmount").setValue(responseData.totalAcadPaymentAmount);
    			  form.down("#totalAcadDicountAmount").setValue(responseData.totalAcadDicountAmount);
  			      form.down("#totalAcadLocAdvanceAmount").setValue(responseData.totalAcadLocAdvanceAmount);

    		  }
    	  });
      },
      // ********** getSave payment detail****************
      getSavePaymentHeader : function(savePayment,onlineAdjustment,onlineAutoAdjustment,makePayment){
    	 var $this = this;
     	 var form = $this.getManagepaymentform().getForm();
     	 var addressForm = $this.getPaymentAddressDetailPanel();
     	 var value = form.getValues();
     	var receivingForm = form.findField("paymentFor").getRawValue();
     	var raiseBillType = form.findField("paymentTo").getValue();
     	if(form.findField('student').lastSelection.length){
     		value.studentCode= form.findField('student').lastSelection[0].data.studentCode;
     	}
     	if(form.findField('applicant').lastSelection.length){
     		value.applicantCode = form.findField('applicant').lastSelection[0].data.code
     	}
     	
 	   var academyLocationId = value.fnpBrandCampusName;
 	  var costCentreId;
 	 	if(!isNullOrEmpty(value.costCentre))
 	 	     costCentreId=value.costCentre;
 	   var academyLocationIds = [];
 	   if(!isNullOrEmpty(academyLocationId)){
 		   if(isArray(academyLocationId)){
     		   for(var i in academyLocationId){
   				  if(Ext.isObject(academyLocationId[0])){
   					 academyLocationIds.push({
       					  "academyLocationId": academyLocationId[i].get("id")
       				  });
   			  }else{
   				 academyLocationIds.push({
     					  "academyLocationId": academyLocationId[i]
     				  });
   				  }
   			  }   
     	   }else{
     		   academyLocationIds.push({
  					  "academyLocationId": academyLocationId
  				  });
     	   }  
 	   }else{
 		   academyLocationIds.push({
					  "academyLocationId": $this.getCurrentAcademyLocation()
				  });  
 	   }

     	
     	 var paymentFor = form.findField("paymentFor").getRawValue(); 
     	 var cashModel = new Academia.model.feeandpayment.payment.PaymentForCashAndBank();
     	 cashModel.set("user",null);
     	 cashModel.set("applicant",null);
     	 cashModel.set("feeThirdParties",null);
     	 cashModel.set("student",null);
     	 cashModel.set("sponsor",null);
     	 cashModel.set("scholarship",null);
     	 cashModel.set("voucherType","PAYMENT");
     	 cashModel.set("paymentFor",$this.getIdValueJson(value.paymentFor,receivingForm));
     	 cashModel.set("transactionDate",value.transactionDate);
     	 cashModel.set("tallyVoucherId",null);
     	 cashModel.set("integratedWithTally",false);
     	 cashModel.set("narration",value.narration);
     	 cashModel.set("paymentUniqueNumber",null);
     	 cashModel.set("iau",$this.getIdValueJson(value.payingIAU));
     	// cashModel.set("currency",$this.getIdValueJson(value.paymentCurrency));
     	 cashModel.set("paymentVoucherNo",value.paymentVoucherNo);
     	 cashModel.set("paymentStatus","FULLY_PENDING");
       	 cashModel.set("academyLocationIds",academyLocationIds);
       	 cashModel.set("costCentre",costCentreId);

		   if(value.paymentCurrency==""){
			   cashModel.set("currency",$this.getIdValueJson(value.paymentCurrency2));
		   }else{
  		   cashModel.set("currency",$this.getIdValueJson(value.paymentCurrency));
		   }
	   

     	 var name = null;
     	 if(!(raiseBillType=="SCHOLARSHIP") && paymentFor=="STUDENT"){
     		 name = form.findField("student").getValue();
     		 cashModel.set("student",$this.getIdValueJson(value.student));
     	 }
     	 
     	  if(raiseBillType=="SCHOLARSHIP"){
    		  name = form.findField("scholarship").getValue();
    		  cashModel.set("student",$this.getIdValueJson(value.scholarshipStudent));
    		  cashModel.set("scholarship",$this.getIdValueJson(value.scholarship));
    	  }
     	 
     	 if(paymentFor=="USER"){
     		 name = form.findField("user").getValue();
     		 cashModel.set("user",$this.getIdValueJson(value.user));
     	 } 
     	 if(paymentFor=="SPONSOR"){
     		 name = form.findField("sponsors").getValue();
     		 cashModel.set("sponsor",$this.getIdValueJson(value.sponsors));
     	 }
     	 if(paymentFor=="THIRD PARTY"){
     		 name = form.findField("thirdParty").getValue();
     		 cashModel.set("feeThirdParties",$this.getIdValueJson(value.thirdParty));
     	 }
     	 if(paymentFor=="APPLICANT"){
     		 name = form.findField("applicant").getValue();
     		 cashModel.set("applicant",$this.getIdValueJson(value.applicant));
     	 }
     	
     	 if(value.paymentmode=="BANK"){
     	 //if(value.paymentmode==getFeeAndPaymentCommonTranslation('bank')){
     		 cashModel.set("voucherMode","BANK");
     		 cashModel.set("paymentType",value.paymentType);
     		 cashModel.set("paymentBank",$this.getIdValueJson(value.paymentBank));
     		 cashModel.set("paymentCash",null);

     		 var myJson = new Array();
     		 if (!isEmpty(value["paymentMode"])) {
     			 var isArr = isArray(value["paymentMode"]);
     			 if (isArr == true) {
     				 for (var i = 0; i < value["paymentMode"].length; i++) {
     					 var obj = new Object();
     					 obj.paymentMode = $this.getIdValueJson(value["paymentMode"][i]);
     					 obj.paymentInstrumentBank = $this.getIdValueJson(value["drawnOnBank"][i]);
     					 obj.instrumentNo = value["instrumentsNo"][i];
     					 obj.instrumentDate = value["instrumentDate"][i];
     					 obj.amount = value["amount"][i];
     					 myJson.push(obj);

     					 var amount=0;
     					 amount = amount + value["amount"][i];
     					 cashModel.set("amount",amount);
     				 }
     			 }
     		 }else{
     			 var obj = new Object();
     			 obj.paymentMode = $this.getIdValueJson(value.paymentMode);
     			 obj.paymentInstrumentBank = $this.getIdValueJson(value.drawnOnBank);
     			 obj.instrumentNo = value.instrumentsNo;
     			 obj.instrumentDate = value.instrumentDate;
     			 obj.amount = value.amount;
     			 myJson.push(obj);
     			 cashModel.set("amount",value.amount);
     		 }

     		 cashModel.set("receiptPaymentInstruments",myJson);
     	 }else{
      		 cashModel.set("voucherMode","CASH");
      		 cashModel.set("amount",value.amount1);
      		 cashModel.set("paymentType",null);
      		 cashModel.set("paymentCash",$this.getIdValueJson(value.paymentCash));
      		 cashModel.set("paymentBank",null);
      	 }
     	  
     	 cashModel.set("feePlanId",value.feePlanId);
   	     cashModel.set("feePlanRuleStageId",value.feePlanRuleStageId);
   	     cashModel.set("feeHeadId",value.feeHeadId);
   	     cashModel.set("stageName",value.stageName);
   	     cashModel.set("feePlanType",value.feePlanType);
   	     cashModel.set("paymentOn",form.findField('paymentOn').getDisplayValue());
   	  
   	  if(value.raiseBillCategory==null || value.raiseBillCategory ==""){
   	   cashModel.set("raiseBillCategory",null);
   	  }else{
   		  cashModel.set("raiseBillCategory",value.raiseBillCategory);
   	  }
   	  
     	  var submitUrl = SERVERURL.PAYMENT_HEADER_CREATE;
     	  var submitAdjustmentUrl = SERVERURL.PAYMENT_AUTO_ADJUSTMENT;
     	  var submitCreateBillUrl = SERVERURL.PAYMENT_HEADER_SAVEANDCREATEBILL;
     	  var submitData = Ext.encode(cashModel.data);
     	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     	 if(makePayment==true){
   		  Ext.Ajax.request({
       		  url: submitCreateBillUrl,
       		  jsonData: submitData,
       		  method: 'POST',
       		  success: function(response) {
       			Ext.getBody().unmask();
       			  showSuccessMessage(getFeeAndPaymentCommonTranslation('RECEIPT_MSSG'),getFeeAndPaymentCommonTranslation('BILL_GENERATE_SUCCESSFULLY'));  
       			  form.reset();
        		  $this.removeDynamicFields();
        		  addressForm.getForm().reset();
        		  addressForm.collapse();
        		  
				  var formObj = $this.getManagepaymentform();
				  formObj.fireEvent("render",formObj);
				  var paymentDateObj = formObj.getForm().findField('transactionDate');
				  paymentDateObj.fireEvent("render",paymentDateObj);
				  var instrumentDateObj = formObj.getForm().findField('instrumentDate');
				  instrumentDateObj.fireEvent("render",instrumentDateObj);
        		  
       		  }});  
   	        }else if(onlineAutoAdjustment==true){
     		  Ext.Ajax.request({
        		  url: submitAdjustmentUrl,
        		  jsonData: submitData,
        		  method: 'POST',
        		  success: function(response) {
        			  Ext.getBody().unmask();
        			  showSuccessMessage(getFeeAndPaymentCommonTranslation('PAYMENT_TITLE'),getFeeAndPaymentCommonTranslation('PAYMENT_AND_AUTO_ADJUSTMENT_CREATED_SUCCESSFULLY'));  
        			  form.reset();
         			  $this.removeDynamicFields();
         			  addressForm.getForm().reset();
           		      addressForm.collapse();
           		      
           		   var formObj = $this.getManagepaymentform();
 				  formObj.fireEvent("render",formObj);
 				  var paymentDateObj = formObj.getForm().findField('transactionDate');
 				  paymentDateObj.fireEvent("render",paymentDateObj);
 				  var instrumentDateObj = formObj.getForm().findField('instrumentDate');
 				  instrumentDateObj.fireEvent("render",instrumentDateObj);
      		
 				  var tabName = getFeeAndPaymentCommonTranslation('PAYMENT_DETAIL');
 					 var newTab = $this.getTabReferenceByTabTitle(tabName);
 			     	 var academyLocationId = $this.getCurrentAcademyLocation();
 						 var multiBrandCampusId = newTab.down('#fnpBrandCampusItemId');
 						 var ALComboStore = multiBrandCampusId.getStore();
 						 ALComboStore.load({
 							 callback: function(records, operation, success) {
 								 if (success) {
 									 for(var i in records){
 										   if(records[i].data.id==academyLocationId){
 											   multiBrandCampusId.setValue(academyLocationId);
 										   }
 									   }
 								 }
 							 }
 						 });
 						 var form11 = $this.getManagepaymentform();     		  
 						 form11.down('#paymentCurrency2').setVisible(false);
 						   form11.down('#paymentCurrency2').allowBlank = true;
 						   form11.down('#paymentCurrency2').clearInvalid();
 						   form11.down('#paymentCurrency').setVisible(true);
 						   form11.down('#paymentCurrency').allowBlank = false;
 						   form11.down('#paymentCurrency').clearInvalid();
 						   form11.down('#paymentCurrency2').setVisible(false);
 						   form11.down('#paymentCurrency2').allowBlank = true;
 						   form11.down('#paymentCurrency2').clearInvalid();
 						   form11.down('#paymentCurrency').setVisible(true);
 						   form11.down('#paymentCurrency').allowBlank = false;
 						   form11.down('#paymentCurrency').clearInvalid();
 			
           	/*	      var formObj = $this.getManagepaymentform();
	 				  formObj.fireEvent("render",formObj);
	 				  var paymentDateObj = formObj.getForm().findField('paymentDate');
					  paymentDateObj.fireEvent("render",paymentDateObj);
					  var instrumentDateObj = formObj.getForm().findField('instrumentDate');
					  instrumentDateObj.fireEvent("render",instrumentDateObj);*/
           		      
        		  }});
     		  
     	  }else if(savePayment==true){

     	  Ext.Ajax.request({
     		  url: submitUrl,
     		  jsonData: submitData,
     		  method: 'POST',
     		  success: function(response) {
     			 Ext.getBody().unmask();
     			  var paymentHeaderId = Ext.decode(response.responseText); 
     			  showSuccessMessage(getFeeAndPaymentCommonTranslation('PAYMENT_TITLE'),getFeeAndPaymentCommonTranslation('PAYMENT_CREATED_SUCCESSFULLY'));
     			  form.reset();
     			  $this.removeDynamicFields();
     			  addressForm.getForm().reset();
       		      addressForm.collapse();
     			  if(onlineAdjustment==true){
     				  var contentpanel = $this.getContentPanel();
     		    	  var tabName = getFeeAndPaymentCommonTranslation('MANAGE_ADJUSTMENTS');
     		    	  var getcontroller=$this.getController('menu.CoreERPNavigationController');
     		    	  var getTab=getcontroller.getTab(tabName);
     		    	  if(getTab!=null){
     		    		  contentpanel.remove(getTab, true);
     		    	  }
     				  $this.onlinePaymentAdjustment(paymentFor,value,name,paymentHeaderId);
     			  }
     			  var formObj = $this.getManagepaymentform();
				  formObj.fireEvent("render",formObj);
				  var paymentDateObj = formObj.getForm().findField('transactionDate');
				  paymentDateObj.fireEvent("render",paymentDateObj);
				  var instrumentDateObj = formObj.getForm().findField('instrumentDate');
				  instrumentDateObj.fireEvent("render",instrumentDateObj);
     		
				  var tabName = getFeeAndPaymentCommonTranslation('PAYMENT_DETAIL');
					 var newTab = $this.getTabReferenceByTabTitle(tabName);
			     	 var academyLocationId = $this.getCurrentAcademyLocation();
						 var multiBrandCampusId = newTab.down('#fnpBrandCampusItemId');
						 var ALComboStore = multiBrandCampusId.getStore();
						 ALComboStore.load({
							 callback: function(records, operation, success) {
								 if (success) {
									 for(var i in records){
										   if(records[i].data.id==academyLocationId){
											   multiBrandCampusId.setValue(academyLocationId);
										   }
									   }
								 }
							 }
						 });
						 var form11 = $this.getManagepaymentform();     		  
						 form11.down('#paymentCurrency2').setVisible(false);
						   form11.down('#paymentCurrency2').allowBlank = true;
						   form11.down('#paymentCurrency2').clearInvalid();
						   form11.down('#paymentCurrency').setVisible(true);
						   form11.down('#paymentCurrency').allowBlank = false;
						   form11.down('#paymentCurrency').clearInvalid();
						   form11.down('#paymentCurrency2').setVisible(false);
						   form11.down('#paymentCurrency2').allowBlank = true;
						   form11.down('#paymentCurrency2').clearInvalid();
						   form11.down('#paymentCurrency').setVisible(true);
						   form11.down('#paymentCurrency').allowBlank = false;
						   form11.down('#paymentCurrency').clearInvalid();
						 
     		  }
     	  
     	  });
     	  }
      },
      onlinePaymentAdjustment : function(paymentFor,value,name,paymentHeaderId){
    	  var $this = this;

    	  var contentpanel = $this.getContentPanel();
    	  var structure = Ext.widget('adjustmentstructure');
    	  structure.isEditable = true;
    	  var tabName = getFeeAndPaymentCommonTranslation('MANAGE_ADJUSTMENTS');
    	  
    	  openTab(contentpanel, tabName, structure,CONSTANTS.MENU_COLOR_FIVE);

    	  var adjustmentFor = structure.down("#adjustmentFor");
    	  var adjustment = structure.down("#adjustment");
    	  var al = structure.down("#fnpBrandCampusItemId");

    	  adjustmentFor.setReadOnly(true);
    	  adjustment.setReadOnly(true);
    	  al.setReadOnly(true);
    	  var adjustmentstore = adjustment.getStore();
    	  var adjustmentForstore = adjustmentFor.getStore();
    	  var alstore = al.getStore();
    	  
    	  adjustmentstore.load({
    		  callback: function(records, operation, success) {
    			  if (success) {
    				  adjustment.setValue(records[2].get('id'));
    			  }
    		  }
    	  });

    	  structure.down("#resetBtn").setVisible(false);
    	  structure.down("#searchBtn").setVisible(false);

    	  var billedUserType = null ;
    	  var id = null ;

    	  if(paymentFor=="STUDENT"){
    		  billedUserType ="STUDENT";
    		  id = value.student;
    		  var studentField = structure.down("#student");
    		  studentField.setReadOnly(true);
    		 
    		  //var studentNameComboStore = $this.getStore('feeandpayment.managebill.Student'); student is not getting set
    		  adjustmentForstore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  adjustmentFor.setValue(records[0].get('id'));
    				  }
    			  }
    		  });
    		  studentNameComboStore=studentField.getStore();
         	   studentNameComboStore.getProxy().extraParams = {
         		   academyLocationIds: value.fnpBrandCampusName,
         		  studentNameOrCode:value.studentCode
         	   };
    		  studentNameComboStore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  Ext.defer(function(){
    						  if(!isNullOrEmpty(value.scholarshipStudent)) {
        						  studentField.setValue(value.scholarshipStudent);
        					  } else {
        						  studentField.setValue(name);
        					  }
    					  },500);
    					 
    				  }
    			  }
    		  });


    	  }
    	  else if(paymentFor=="APPLICANT"){
    		  billedUserType ="APPLICANT";
    		  id = value.applicant;
    		  var applicantField = structure.down("#applicant");
    		  applicantField.setReadOnly(true);
    		  
    		  var applicantNameComboStore = $this.getStore('feeandpayment.managebill.Applicant');
   		   applicantNameComboStore.getProxy().extraParams = {
          		   academyLocationIds: value.fnpBrandCampusName,
          		   codeOrName:value.applicantCode
          	   };
    		  
    		  adjustmentForstore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  adjustmentFor.setValue(records[1].get('id'));
    				  }
    			  }
    		  });
    		  applicantNameComboStore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  Ext.defer(function(){
    						  applicantField.setValue(name);
    					  },1000)
    					  
    				  }
    			  }
    		  });
    	  }
    	  else if(paymentFor=="SPONSOR"){
    		  billedUserType ="SPONSOR";
    		  id = value.sponsor;
    		  var sponsors = structure.down("#sponsors");
    		  sponsors.setReadOnly(true);
    		  adjustmentForstore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  adjustmentFor.setValue(records[2].get('id'));
    				  }
    			  }
    		  });
    		  sponsors.store.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  sponsors.setValue(name);
    				  }
    			  }
    		  });
    	  }
    	  else if(paymentFor=="USER"){
    		  billedUserType ="USER";
    		  id = value.user;
    		  var userField = structure.down("#userId");
    		  userField.setReadOnly(true);
    		  
    		  var userNameComboStore = $this.getStore('feeandpayment.managebill.User');
    		  userNameComboStore.getProxy().extraParams = {
             		   academyLocationIds: value.fnpBrandCampusName
             	   };
    		  
    		  adjustmentForstore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  adjustmentFor.setValue(records[3].get('id'));
    				  }
    			  }
    		  });
    		  userNameComboStore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  userField.setValue(name);
    				  }
    			  }
    		  });
    	  }
    	  else if(paymentFor=="THIRD PARTY"){
    		  billedUserType ="THIRD PARTY";
    		  id = value.thirdParty;
    		  var thirdParty = structure.down("#thirdParty");
    		  thirdParty.setReadOnly(true);
    		  adjustmentForstore.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  adjustmentFor.setValue(records[4].get('id'));
    				  }
    			  }
    		  });
    		  thirdParty.store.load({
    			  callback: function(records, operation, success) {
    				  if (success) {
    					  thirdParty.setValue(name);
    				  }
    			  }
    		  });
    	  }
    	  var adjustmentType ="Payment";
    	  structure.down("#receiptslist").setVisible(false);
          var paymentGrid = structure.down("#paymentslist");
          paymentGrid.setVisible(true);
    	  var receiptAdjustmentstore = paymentGrid.getStore();
    	  receiptAdjustmentstore.getProxy().extraParams = {
    		  billedUserType: billedUserType,
    		  id:id,
    		  paymentHeaderId:paymentHeaderId
    	  };
    	  receiptAdjustmentstore.load();

          var billReceivableGrid = structure.down("#billreceivablelist");
    	  var billAdjustmentstore = billReceivableGrid.getStore();
    	  billAdjustmentstore.getProxy().extraParams = {
    		  billedUserType: billedUserType,
    		  id:id,
    		  adjustmentType:adjustmentType,
    		  paymentHeaderId:paymentHeaderId
    	  };
    	  billAdjustmentstore.load();
    	  
    	   alstore.load({
    		   callback: function(records, operation, success) {
    			   if (success) {
    				   al.setValue(value.fnpBrandCampusName);
    			   }
    		   }
    	   });

      },
    //*****Show Hide Smart Search****************//
      
      showHideSmartSearch:function(result){

    	  var form = this.getPaymentsearchform();
    	  
    	  var billType = form.getForm().findField("billType").getValue();
    	  //var billFor = form.getForm().findField("billFor").getRawValue();
    	  
    	  var billForNonEnumValue = form.getForm().findField("billFor").getRawValue();
    	  var billFor = form.getForm().findField("billFor").store.findRecord('value', billForNonEnumValue).data.displayValue;
    	  
    	  var academyLocationIds = this.getPaymentsearchform().down("#fnpMultiBrandCampusPaymentItemId").getValue();
    	  
    	  this.paymentVoucherNoSearch(form.getForm().findField("billFor").getValue(),billFor,null,academyLocationIds);
    	  this.billNoSearch(form.getForm().findField("billFor").getValue(),billFor,null,academyLocationIds);
    	  
    	  var thirdPartyField = form.down("#thirdParty");
    	  var applicantField = form.down("#applicant");
    	  var sponsorField = form.down("#sponsors");
    	  var userField = form.down("#userId");
    	  var studentField = form.down("#student");
    	  var scholarshipField = form.down("#scholarship");
    	  var scholarshipStudentField = form.down("#scholarshipStudent");
    	  
    	  var programCombo = form.down("#program");
    	  var batchCombo = form.down("#batch");
    	  var sectionCombo = form.down("#section");
    	  
    	  applicantField.setVisible(false);
    	  sponsorField.setVisible(false);
    	  thirdPartyField.setVisible(false);
    	  userField.setVisible(false);
    	  studentField.setVisible(false);
    	  programCombo.setVisible(false);
    	  batchCombo.setVisible(false);
    	  sectionCombo.setVisible(false);
    	  scholarshipField.setVisible(false);
    	  scholarshipStudentField.setVisible(false);
    	  
    	  
    	  applicantField.reset();
    	  sponsorField.reset();
    	  thirdPartyField.reset();
    	  userField.reset();
    	  studentField.reset();
    	  programCombo.reset();
    	  batchCombo.reset();
    	  sectionCombo.reset();
    	  scholarshipField.reset();
    	  scholarshipStudentField.reset();

    	  if(billType =="SCHOLARSHIP"){
    		  studentField.setVisible(false);
    		  scholarshipField.setVisible(true);
        	  scholarshipStudentField.setVisible(true);
              

    	  }
    	  
    	  if(!(billType =="SCHOLARSHIP")&& billFor =="STUDENT"){
    		  studentField.setVisible(true);
    		  programCombo.setVisible(true);
        	  batchCombo.setVisible(true);
        	  sectionCombo.setVisible(true); 
    	  }
    	  if(billFor =="APPLICANT"){
    		  applicantField.setVisible(true);
    		  programCombo.setVisible(true);
        	  batchCombo.setVisible(true);
    	  }
    	  if(billFor =="SPONSOR"){
    		  sponsorField.setVisible(true);
    	  }
    	  if(billFor =="USER"){
    		  userField.setVisible(true);
    	  }
    	  if(billFor == "THIRD PARTY"){
    		  thirdPartyField.setVisible(true);
    	  }
    	  //***********for  var 
    /*	  var result =false;
    	  var grid;
    	  var academyLocationId = this.getCurrentAcademyLocation();
    	  Ext.Ajax.request({
    		  method: "GET",
    		  type: 'rest',
    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
    		  params:{
    			  academyLocationId:academyLocationId
    		  },
    		  success: function(response) {
    			  if(response){
    				  result=response.responseText;							  
    			  }
    	  
    		  }
    	  });*/
    	 //***********for Grid hide and show purpose **********
    	  var structure = this.getPaymentHeaderStructure();
    	  
      	 structure.down("#paymentlistforpcandserviceprovided").setVisible(false);
      	 structure.down("#paymentlistforscholarship").setVisible(false);
      	 structure.down("#paymentlistforserviceprovided").setVisible(false);
      	 structure.down("#paymentlistforservicereceived").setVisible(false);
      	 structure.down("#paymentlistfordependedfeehead").setVisible(false);
      	 structure.down("#paymentlistforpcandserviceprovidedforapplicant").setVisible(false);
      	 structure.down("#paymentlistforpcandserviceprovidedforsponsor").setVisible(false);
		 structure.down("#paymentlistforpcandserviceprovided").config.searchFilterForm =form;
		 structure.down("#paymentlistforpcandserviceprovidedforapplicant").config.searchFilterForm =form;
		 structure.down("#paymentlistforservicereceived").config.searchFilterForm =form;
		 structure.down("#paymentlistforpcandserviceprovidedforsponsor").config.searchFilterForm =form;
		 structure.down("#paymentlistforscholarship").config.searchFilterForm =form;
		 structure.down("#paymentlistforserviceprovided").config.searchFilterForm =form;
	
    	 if((billType =="ALL" || billType =="P_AND_C_FEE" || billType =="SERVICE_PROVIDED") 
    			  && (billFor =="STUDENT")){
    		  structure.down("#paymentlistforpcandserviceprovided").setVisible(true);
    		  grid=structure.down("#paymentlistforpcandserviceprovided");
    		  if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='totalConvertedAmount'){
 							 gridColumns[i].setVisible(false);
 						 }
 					 }
 				 }
 			  }else{
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='totalConvertedAmount'){
 							 gridColumns[i].setVisible(true);
 						 }
 					 }
 				 }
 			  }
    	  }
    	  
    	  if(billType =="SCHOLARSHIP" && billFor =="STUDENT"){
    		  structure.down("#paymentlistforscholarship").setVisible(true);
    		  grid=structure.down("#paymentlistforscholarship");
    		  if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(false);
 						 }
 					 }
 				 }
 			  }else{
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(true);
 						 }
 					 }
 				 }
 			  }
    	  }
    	  
    	  if(billType =="SERVICE_PROVIDED" && billFor =="USER"){
    		  structure.down("#paymentlistforserviceprovided").setVisible(true);
    		  grid=structure.down("#paymentlistforserviceprovided");
    		  if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(false);
    	  }
 					 }
 				 }
    		  }else{
 	 				 var gridColumns=grid.columns;
 	 				 var length = gridColumns.length;
 	 				 if(length!=null && length!=""){
 	 					 for(var i=0; i<length; i++){
 	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 	 							 gridColumns[i].setVisible(true);
 	 						 }
 	 					 }
 	 			  }
 			  }
    	  }
    	  
    	  if((billType =="ALL" || billType =="SERVICE_RECEIVED") && billFor =="USER"){
    		  structure.down("#paymentlistforservicereceived").setVisible(true);
    		  grid=structure.down("#paymentlistforservicereceived");
    		  if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(false);
 						 }
 					 }
    	  }
 			  }else{
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(true);
 						 }
 					 }
 				 }
 			  }
    	  }
    	  
    	  if((billType =="ALL" || billType =="DEPENDENT_BILLS") && billFor =="THIRD PARTY"){
    		  structure.down("#paymentlistfordependedfeehead").setVisible(true);
    		  grid=structure.down("#paymentlistfordependedfeehead");
    		  if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(false);
    	  }
 					 }
 				 }
 			  }else{
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(true);
 						 }
 					 }
 				 }
 			  }
    	  }
    	  
    	  if((billType =="ALL" || billType =="P_AND_C_FEE" || billType =="SERVICE_PROVIDED") 
    			  && (billFor =="SPONSOR")){
    		  structure.down("#paymentlistforpcandserviceprovidedforsponsor").setVisible(true);
    		  grid=structure.down("#paymentlistforpcandserviceprovidedforsponsor");
    		  if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(false);
 						 }
 					 }
    	  }
 			  }else{
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(true);
 						 }
 					 }
 				 }
 			  }
    	  }
    	  
    	  if((billType =="ALL" || billType =="P_AND_C_FEE"|| billType =="SERVICE_PROVIDED") 
    			  && (billFor =="APPLICANT")){
    		  structure.down("#paymentlistforpcandserviceprovidedforapplicant").setVisible(true);
    		  grid=structure.down("#paymentlistforpcandserviceprovidedforapplicant");
				if(result=="false"){
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(false);
 						 }
 					 }
    	  }
 			  }else{
 				 var gridColumns=grid.columns;
 				 var length = gridColumns.length;
 				 if(length!=null && length!=""){
 					 for(var i=0; i<length; i++){
 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
 							 gridColumns[i].setVisible(true);
 						 }
 					 }
 				 }
 			  }
    	  }
      },
    
   //************* paramerter Passing P&C AND Service Provided**************
      /**/
      getPaymentHeaderGridForPC : function(grid,isEnum){
    	      	var $this = this;
      	var form = this.getPaymentsearchform();
      	form.down('#searchBtn').setDisabled(true);
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var costcenter = form.down("#costCentre").getValue();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	
      	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
        var inactiveStudents = form.down("#inactiveStudentItemId").getValue();
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
      		if(!isNullOrEmpty(billedUserTypeEnumValue)){
      			var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      		}

      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
  		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
  		   //*********for multiselect Academy Location**********
      	   var ALsId = [];
      	   for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
      	   if(isNullOrEmpty(academyLocationIds)){
      		   academyLocationIds = academyLocationId;
      	   }  
  	   }else{
  		   academyLocationIds = academyLocationId;  
  	   }
  	
  	
      	

 		//************for multiselct cost center*************
 	      var costCentersId = [];
 	       for(var i in costcenter){
 		   if(Ext.isObject(costcenter[i])){
 			   costCentersId.push(costcenter[i].data.id);
 		   }else{
 			   costCentersId.push(costcenter[i]);
 		   }
 	   }
 	   var costCenterId = costCentersId.join();
       	
      	
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy for Student_Payment**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   
 	   // nonse issue start
 	 if(billingfromdate != null){
 	 billingfromdate= new Date(billingfromdate);
 	 billingfromdate = Ext.Date.format(billingfromdate, 'Y-m-d');
     }
 	 
 	if(billingtodate != null){
 	billingtodate= new Date(billingtodate);
 	billingtodate = Ext.Date.format(billingtodate, 'Y-m-d');
 	}
 	
 	if(billingduefromdate != null){
 	billingduefromdate= new Date(billingduefromdate);
 	billingduefromdate = Ext.Date.format(billingduefromdate, 'Y-m-d');
 	}
 	
 	if(billingduetodate != null){
 	billingduetodate= new Date(billingduetodate);
 	billingduetodate = Ext.Date.format(billingduetodate, 'Y-m-d');
 	}
 	
 	if(paymentDateFrom != null){
 	paymentDateFrom= new Date(paymentDateFrom);
 	paymentDateFrom = Ext.Date.format(paymentDateFrom, 'Y-m-d');
 	}
 	
 	if(paymentDateTo != null){
 	paymentDateTo= new Date(paymentDateTo);
 	paymentDateTo = Ext.Date.format(paymentDateTo, 'Y-m-d');
 	} 
 	   //nonse issue end
 	   var sectionId = sectionsId.join();      	
      	var store = grid.getStore();
      	store.getProxy().extraParams = {
	        	currencyId:currencyId,
	        	costCenterId:costCenterId,
	        	programId:programId,
	        	batchId:batchId,
	        	sectionId:sectionId,
	        	paymentStatus:paymentStatus,
	        	voucherMode : voucherMode,
	        	billStatus:billStatus,
	        	personId:personId,
	        	paymentHeaderId : paymentHeaderId,
	        	billHeaderId:billHeaderId,
	        	billedUserType :billedUserType,
	        	raiseBillType :raiseBillType,
	        	sponsorId:sponsorId,
	        	feeThirdPartiesId:feeThirdPartiesId,
	        	userId:userId,
	        	applicantId:applicantId,
	        	billingfromdate:billingfromdate,
	        	billingtodate:billingtodate,
	        	billingduefromdate:billingduefromdate,
	        	billingduetodate:billingduetodate,
	        	paymentDateFrom:paymentDateFrom,
	        	paymentDateTo:paymentDateTo,
	        	academyLocationId:academyLocationIds,
	        	paymentModeId:paymentModeId,
	        	billGenerationType:billGenerationType,
                inactiveStudents:inactiveStudents 
                
	        },
	        $this.resetPageSetting(store);
      	/*if(store.data.items["length"]>0 && !isNullOrEmpty(store.data.items[store.data.items["length"]-1].data.acadLocBaseCurrency))
      		{
	        store.load({
				 callback: function(record, operation, success) {
					 $this.toggleGridSummaryRow(grid,false);
				 }
			});
      		}
      	else{*/
      	   store.load({
				 callback: function(record, operation, success) {
					 if (success) {
						   form.down('#searchBtn').setDisabled(false); 
					   }
					if (record.length > 0) {
						grid.removeCls('managePaymentCls');
					 }else{
						 grid.addCls('managePaymentCls');
					 }
				 }
			});
      //	}
	     
    	  
      },
      
//************* paramerter Passing Service Received For User**************
      
      getPaymentHeaderGridForServiceReceived : function(grid, isEnum){
    	var $this = this;      	
      	var form = this.getPaymentsearchform();
      	form.down('#searchBtn').setDisabled(true); 
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var costcenter = form.down("#costCentre").getValue();
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
        var inactiveStudents = form.down("#inactiveStudentItemId").getValue();
      	
  	   // nonse issue start
    	 if(billingfromdate != null){
    	 billingfromdate= new Date(billingfromdate);
    	 billingfromdate = Ext.Date.format(billingfromdate, 'Y-m-d');
        }
    	 
    	if(billingtodate != null){
    	billingtodate= new Date(billingtodate);
    	billingtodate = Ext.Date.format(billingtodate, 'Y-m-d');
    	}
    	
    	if(billingduefromdate != null){
    	billingduefromdate= new Date(billingduefromdate);
    	billingduefromdate = Ext.Date.format(billingduefromdate, 'Y-m-d');
    	}
    	
    	if(billingduetodate != null){
    	billingduetodate= new Date(billingduetodate);
    	billingduetodate = Ext.Date.format(billingduetodate, 'Y-m-d');
    	}
    	
    	if(paymentDateFrom != null){
    	paymentDateFrom= new Date(paymentDateFrom);
    	paymentDateFrom = Ext.Date.format(paymentDateFrom, 'Y-m-d');
    	}
    	
    	if(paymentDateTo != null){
    	paymentDateTo= new Date(paymentDateTo);
    	paymentDateTo = Ext.Date.format(paymentDateTo, 'Y-m-d');
    	} 
    	   //nonse issue end
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
    	  	var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
  		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
  		   //*********for multiselect Academy Location**********
      	   var ALsId = [];
      	   for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
      	   if(isNullOrEmpty(academyLocationIds)){
      		   academyLocationIds = academyLocationId;
      	   }  
  	   }else{
  		   academyLocationIds = academyLocationId;  
  	   }
      	 
      	//************for multiselct cost center*************
	      var costCentersId = [];
	       for(var i in costcenter){
		   if(Ext.isObject(costcenter[i])){
			   costCentersId.push(costcenter[i].data.id);
		   }else{
			   costCentersId.push(costcenter[i]);
		   }
	   }
	   var costCenterId = costCentersId.join();
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   var sectionId = sectionsId.join();       	
      	
        var store = grid.getStore();
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	costCenterId:costCenterId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	personId:personId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationIds,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType,
            inactiveStudents:inactiveStudents 
	        },
	        $this.resetPageSetting(store);
	        store.load({
				 callback: function(record, operation, success) {
					 if (success) {
						 form.down('#searchBtn').setDisabled(false); 
						 if (record.length > 0) {
							// $this.toggleGridSummaryRow(grid,true);
							 grid.removeCls('managePaymentCls');
						 }else{
							 $this.toggleGridSummaryRow(grid,false);
							 grid.addCls('managePaymentCls');
						 }
					 }
				 }
			});
    	  
      },
      
//************* paramerter Passing Scholarship and Student**************
      
      getPaymentHeaderGridForScholarship : function(grid, isEnum){
    	var $this = this;      	
      	var form = this.getPaymentsearchform();
      	form.down('#searchBtn').setDisabled(true);
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	
      	var costcenter = form.down("#costCentre").getValue();
      	var studentId = form.down("#scholarshipStudent").getValue();
      	var scholarshipId = form.down("#scholarship").getValue();
      	
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
    	  	var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
  		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
  		   //*********for multiselect Academy Location**********
      	   var ALsId = [];
      	   for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
      	   if(isNullOrEmpty(academyLocationIds)){
      		   academyLocationIds = academyLocationId;
      	   }  
  	   }else{
  		   academyLocationIds = academyLocationId;  
  	   }
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();
 	   
 	  
     	//************for multiselct cost center*************
	      var costCentersId = [];
	       for(var i in costcenter){
		   if(Ext.isObject(costcenter[i])){
			   costCentersId.push(costcenter[i].data.id);
		   }else{
			   costCentersId.push(costcenter[i]);
		   }
	   }
	   var costCenterId = costCentersId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   var sectionId = sectionsId.join();       	
      	
      	var store = grid.getStore();
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	costCenterId:costCenterId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	studentId:studentId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationIds,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType,
        	scholarshipId:scholarshipId
	        },
	        $this.resetPageSetting(store);
	        store.load({
				 callback: function(record, operation, success) {
					 if (success) {
						 form.down('#searchBtn').setDisabled(false); 
						 if (record.length > 0) {
							 $this.toggleGridSummaryRow(grid,true);
							 grid.removeCls('managePaymentCls');
						 }else{
							 $this.toggleGridSummaryRow(grid,false);
							 grid.addCls('managePaymentCls');
						 }
					 }
				 }
			});
    	  
      },
//************* paramerter Passing Scholarship and Student**************
      
      /*getPaymentHeaderGridForScholarship : function(){
    	      	
      	var form = this.getPaymentsearchform();
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	var billedUserType = form.down("#billFor").getRawValue();
      	var raiseBillType = form.down("#billType").getValue();
      	
      	
      	//*********for multiselect Program**********
      	  var programsId = [];
      	  for(var i in program){
      		  programsId.push(program[i].data.id) ;
      	  }
      	  var programId = programsId.join();
      	
      	//*********for multiselect Batch**********
      	var batchesId = [];
      	  for(var i in batch){
      		  batchesId.push(batch[i].data.id) ;
      	  }
      	  var batchId = batchesId.join();
      	  
      	//*********for multiselect Acacdemy**********
      	  var sectionsId = [];
      	  for(var i in section){
      		  sectionsId.push(section[i].data.id) ;
      	  }
      	  var sectionId = sectionsId.join();  	
      	
      	var store = this.getStore('feeandpayment.payment.PaymentForScholarship');
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	personId:personId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate ,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationId,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType
	        },
  	    store.load();
    	  
      },*/
//************* paramerter Passing Depended Fee Head and Third Parties**************
      
      getPaymentHeaderGridForDependentFee : function(grid, isEnum){
    	var $this = this;      	
      	var form = this.getPaymentsearchform();
      	form.down('#searchBtn').setDisabled(true);
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
    	  	var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
  		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
  		   //*********for multiselect Academy Location**********
      	   var ALsId = [];
      	   for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
      	   if(isNullOrEmpty(academyLocationIds)){
      		   academyLocationIds = academyLocationId;
      	   }  
  	   }else{
  		   academyLocationIds = academyLocationId;  
  	   }
      	
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   var sectionId = sectionsId.join();	
      	      	
      	var store = grid.getStore();
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	personId:personId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationIds,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType
	        },
	        $this.resetPageSetting(store);
//  	    store.load();
	    	store.load({
				 callback: function(record, operation, success) {
					 if (success) {
						 form.down('#searchBtn').setDisabled(false); 
						 if (record.length > 0) {
							 $this.toggleGridSummaryRow(grid,true);
							 grid.removeCls('managePaymentCls');
						 }else{
							 $this.toggleGridSummaryRow(grid,false);
							 grid.addCls('managePaymentCls');
						 }
					 }
				 }
			});
    	  
      },
//************* paramerter Passing PC & ServiceProvided For Applicant**************
      
      getPaymentHeaderGridForPCAndServiceReceivedForApplicant : function(grid, isEnum){
    	var $this = this;      	
      	var form = this.getPaymentsearchform();
      	form.down('#searchBtn').setDisabled(true);
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var costcenter = form.down("#costCentre").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	
  	   // nonse issue start
    	 if(billingfromdate != null){
    	 billingfromdate= new Date(billingfromdate);
    	 billingfromdate = Ext.Date.format(billingfromdate, 'Y-m-d');
        }
    	 
    	if(billingtodate != null){
    	billingtodate= new Date(billingtodate);
    	billingtodate = Ext.Date.format(billingtodate, 'Y-m-d');
    	}
    	
    	if(billingduefromdate != null){
    	billingduefromdate= new Date(billingduefromdate);
    	billingduefromdate = Ext.Date.format(billingduefromdate, 'Y-m-d');
    	}
    	
    	if(billingduetodate != null){
    	billingduetodate= new Date(billingduetodate);
    	billingduetodate = Ext.Date.format(billingduetodate, 'Y-m-d');
    	}
    	
    	if(paymentDateFrom != null){
    	paymentDateFrom= new Date(paymentDateFrom);
    	paymentDateFrom = Ext.Date.format(paymentDateFrom, 'Y-m-d');
    	}
    	
    	if(paymentDateTo != null){
    	paymentDateTo= new Date(paymentDateTo);
    	paymentDateTo = Ext.Date.format(paymentDateTo, 'Y-m-d');
    	} 
    	   //nonse issue end
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
    	  	var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
  		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
  		   //*********for multiselect Academy Location**********
      	   var ALsId = [];
      	   for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
      	   if(isNullOrEmpty(academyLocationIds)){
      		   academyLocationIds = academyLocationId;
      	   }  
  	   }else{
  		   academyLocationIds = academyLocationId;  
  	   }
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();
 	   

		//************for multiselct cost center*************
	      var costCentersId = [];
	       for(var i in costcenter){
		   if(Ext.isObject(costcenter[i])){
			   costCentersId.push(costcenter[i].data.id);
		   }else{
			   costCentersId.push(costcenter[i]);
		   }
	   }
	       var costCenterId = costCentersId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   var sectionId = sectionsId.join();     	
      	var store = grid.getStore();
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	costCenterId:costCenterId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	personId:personId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationIds,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType
	        },
	        $this.resetPageSetting(store);
	        store.load({
				 callback: function(record, operation, success) {
					 if (success) {
						   form.down('#searchBtn').setDisabled(false); 
					   }
					 if (record.length > 0) {
						 grid.removeCls('managePaymentCls');
					 }else{
						 grid.addCls('managePaymentCls');
					 }
				 }
			});
    	  
      },
//************* paramerter Passing PC & ServiceProvided For Sponsor**************
      
      getPaymentHeaderGridForPCAndServiceReceivedForSponsor : function(grid, isEnum){
    	var $this = this;
      	var form = this.getPaymentsearchform();
      	form.down('#searchBtn').setDisabled(true);
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var costcenter = form.down("#costCentre").getValue();
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	
      	
  	   // nonse issue start
    	 if(billingfromdate != null){
    	 billingfromdate= new Date(billingfromdate);
    	 billingfromdate = Ext.Date.format(billingfromdate, 'Y-m-d');
        }
    	 
    	if(billingtodate != null){
    	billingtodate= new Date(billingtodate);
    	billingtodate = Ext.Date.format(billingtodate, 'Y-m-d');
    	}
    	
    	if(billingduefromdate != null){
    	billingduefromdate= new Date(billingduefromdate);
    	billingduefromdate = Ext.Date.format(billingduefromdate, 'Y-m-d');
    	}
    	
    	if(billingduetodate != null){
    	billingduetodate= new Date(billingduetodate);
    	billingduetodate = Ext.Date.format(billingduetodate, 'Y-m-d');
    	}
    	
    	if(paymentDateFrom != null){
    	paymentDateFrom= new Date(paymentDateFrom);
    	paymentDateFrom = Ext.Date.format(paymentDateFrom, 'Y-m-d');
    	}
    	
    	if(paymentDateTo != null){
    	paymentDateTo= new Date(paymentDateTo);
    	paymentDateTo = Ext.Date.format(paymentDateTo, 'Y-m-d');
    	} 
    	   //nonse issue end
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
    	  	var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
  		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
  		   //*********for multiselect Academy Location**********
      	   var ALsId = [];
      	   for(var i in academyLocationId){
      		   if(Ext.isObject(academyLocationId[i])){
      			   ALsId.push(academyLocationId[i].data.id);
      		   }else{
      			   ALsId.push(academyLocationId[i]);
      		   }
      	   }
      	   var academyLocationIds = ALsId.join();
      	   if(isNullOrEmpty(academyLocationIds)){
      		   academyLocationIds = academyLocationId;
      	   }  
  	   }else{
  		   academyLocationIds = academyLocationId;  
  	   }
      	 
      	//************for multiselct cost center*************
	      var costCentersId = [];
	       for(var i in costcenter){
		   if(Ext.isObject(costcenter[i])){
			   costCentersId.push(costcenter[i].data.id);
		   }else{
			   costCentersId.push(costcenter[i]);
		   }
	   }
	   var costCenterId = costCentersId.join();
      	
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   var sectionId = sectionsId.join();     	
      	var store = grid.getStore();
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	costCenterId:costCenterId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	personId:personId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate ,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationIds,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType
	        },
	        $this.resetPageSetting(store);
//  	    store.load();
	        store.load({
	        	callback: function(record, operation, success) {
	        		if (success) {
	        			form.down('#searchBtn').setDisabled(false); 
	        			if (record.length > 0) {
							// $this.toggleGridSummaryRow(grid,true);
							 grid.removeCls('managePaymentCls');
						 }else{
							 $this.toggleGridSummaryRow(grid,false);
							 grid.addCls('managePaymentCls');
						 }
	        		}
	        	}
			});
    	  
      },
//************* paramerter Passing ServiceProvided For User**************
      
      getPaymentHeaderGridForServiceProvidedForUser : function(grid, isEnum){
    	var $this = this
      	var form = this.getPaymentsearchform();
    	form.down('#searchBtn').setDisabled(true); 
      	var academyLocationId = this.getCurrentAcademyLocation();
      	var currencyId = form.down("#paymentCurrency").getValue();
      	var program = form.down("#program").getValue();
      	var batch = form.down("#batch").getValue();
      	var section = form.down("#section").getValue();
      	var paymentStatus = form.down("#paymentStatus").getValue();
      	var voucherMode = form.down("#voucherMode").getValue();
      	var billStatus = form.down("#billStatus").getValue();
      	var personId = form.down("#student").getValue();
      	var paymentHeaderId = form.down("#paymentVoucherNo").getValue();
    	var billHeaderId = form.down("#billNo").getValue();
    	var paymentModeId = form.down("#paymentMode").getValue();
      	var billGenerationType = form.down("#generationType").getValue();
      	
      	var costcenter = form.down("#costCentre").getValue();
      	var sponsorId = form.down("#sponsors").getValue();
      	var feeThirdPartiesId = form.down("#thirdParty").getValue();
      	var userId = form.down("#userId").getValue();
      	var applicantId = form.down("#applicant").getValue();
      	var billingfromdate = form.down("#billDateFrom").getValue();
      	var billingtodate = form.down("#billDateTill").getValue();
      	var billingduefromdate = form.down("#billDueDateFrom").getValue();
      	var billingduetodate = form.down("#billDueDateTill").getValue();
      	var paymentDateFrom = form.down("#paymentDateFrom").getValue();
      	var paymentDateTo = form.down("#paymentDateTo").getValue();
      	
      	if(isEnum){
      		var billedUserType = form.down("#billFor").getRawValue();
      	}else{
      		var billedUserTypeEnumValue = form.down("#billFor").getRawValue();
    	  	var billedUserType = form.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;
      	}
      	
      	var raiseBillType = form.down("#billType").getValue();
      	
      	
      	
      	 if(form.down("#fnpMultiBrandCampusPaymentItemId").hidden!=true){
    		   var academyLocationId = form.down("#fnpMultiBrandCampusPaymentItemId").getValue();
    		   //*********for multiselect Academy Location**********
        	   var ALsId = [];
        	   for(var i in academyLocationId){
        		   if(Ext.isObject(academyLocationId[i])){
        			   ALsId.push(academyLocationId[i].data.id);
        		   }else{
        			   ALsId.push(academyLocationId[i]);
        		   }
        	   }
        	   var academyLocationIds = ALsId.join();
        	   if(isNullOrEmpty(academyLocationIds)){
        		   academyLocationIds = academyLocationId;
        	   }  
    	   }else{
    		   academyLocationIds = academyLocationId;  
    	   }
      	
      	//************for multiselct cost center*************
	      var costCentersId = [];
	       for(var i in costcenter){
		   if(Ext.isObject(costcenter[i])){
			   costCentersId.push(costcenter[i].data.id);
		   }else{
			   costCentersId.push(costcenter[i]);
		   }
	   }
	   var costCenterId = costCentersId.join();
 	   //*********for multiselect Program**********
 	   var programsId = [];
 	   for(var i in program){
 		   if(Ext.isObject(program[i])){
 			   programsId.push(program[i].data.id);
 		   }else{
 			   programsId.push(program[i]);
 		   }
 	   }
 	   var programId = programsId.join();

 	   //*********for multiselect Batch**********
 	   var batchesId = [];
 	   for(var i in batch){
 		   if(Ext.isObject(batch[i])){
 			   batchesId.push(batch[i].data.id) ;
 		   }else{
 			   batchesId.push(batch[i]) ;
 		   }
 	   }
 	   var batchId = batchesId.join();

 	   //*********for multiselect Acacdemy**********
 	   var sectionsId = [];
 	   for(var i in section){
 		   if(Ext.isObject(section[i])){
 			   sectionsId.push(section[i].data.id);
 		   }else{
 			   sectionsId.push(section[i]);
 		   }
 	   }
 	   var sectionId = sectionsId.join();     	
      	var store = grid.getStore();
      	store.getProxy().extraParams = {
        	currencyId:currencyId,
        	costCenterId:costCenterId,
        	programId:programId,
        	batchId:batchId,
        	sectionId:sectionId,
        	paymentStatus:paymentStatus,
        	voucherMode : voucherMode,
        	billStatus:billStatus,
        	personId:personId,
        	paymentHeaderId : paymentHeaderId,
        	billHeaderId:billHeaderId,
        	billedUserType :billedUserType,
        	raiseBillType :raiseBillType,
        	sponsorId:sponsorId,
        	feeThirdPartiesId:feeThirdPartiesId,
        	userId:userId,
        	applicantId:applicantId,
        	billingfromdate:billingfromdate,
        	billingtodate:billingtodate,
        	billingduefromdate:billingduefromdate,
        	billingduetodate:billingduetodate,
        	paymentDateFrom:paymentDateFrom,
        	paymentDateTo:paymentDateTo,
        	academyLocationId:academyLocationIds,
        	paymentModeId:paymentModeId,
        	billGenerationType:billGenerationType
	        },
	        $this.resetPageSetting(store);
	        store.load({
				 callback: function(record, operation, success) {
					 if (success) {
						 form.down('#searchBtn').setDisabled(false); 
						 if (record.length > 0) {
							 grid.removeCls('managePaymentCls');
							 //$this.toggleGridSummaryRow(grid,true);
						 }else{
							 $this.toggleGridSummaryRow(grid,false);
							 grid.addCls('managePaymentCls');
						 }
							
					 }
					}
			});
    	  
      },
      //**************** click on add button grid manage form will open********
      getOpenManagePaymentForm : function(){
    	  if(this.managepaymentFormMode!='VIEW'){
    		  this.managepaymentFormMode='ADD';
    	  }
    	  var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	  var tabName = getFeeAndPaymentCommonTranslation('PAYMENT_DETAIL');
    	  var getcontroller=this.getController('menu.CoreERPNavigationController');
    	  var getTab=getcontroller.getTab(tabName);
    	  if(getTab!=null){
    		  contentPanel.remove(getTab, true);
    	  }
    	  var contentXtype ='paymentsform';
    	  var newTab = this.getTabReferenceByTabTitle(tabName);
    	  if(!newTab){
    		  newTab = contentPanel.add({
    			  xtype: contentXtype,
    			  closable: true,
    			  title: tabName,
    			  menuColorCls: CONSTANTS.MENU_COLOR_FIVE
    		  });
    	  }

    	  var alinfomodel = Academia.model.authentication.ALInfoModel;
    	  var wheatherSchool = alinfomodel.get('wheatherSchool');
    	  if(wheatherSchool){
    	     newTab.down('addressdetailpanel').down('#period').hide();
    	  }
    	  contentPanel.setActiveTab(newTab);
    	  
      },
      
      addPaymentHeaderContainer: function() {
    	  var this$ = this;
    	  var form = this$.getManagepaymentform();
    	  var getform = form.getForm();
    	  var panelItem = new Array();
    	  var academyLocationId = this.getCurrentAcademyLocation();
			 var fnpBrandCampusId = form.down('#fnpBrandCampusItemId');
			 var fnpBrandCampusIdValue = fnpBrandCampusId.getValue();
			
    	  panelItem.push({
    		  xtype: 'fieldcontainer',
    		  width: '100%',
    		  layout: {
    			  type: 'hbox',
    			  align: 'bottom'
    		  },
    		  items: [{
    			  xtype: 'customcombobox',
    			  itemId: 'paymentMode',
    			  name: 'paymentMode',
    			  labelAlign: 'top',
    			  store: 'feeandpayment.FeePaymentMode',
    			  width: 135,
    			  valueField: 'id',
    			  displayField: 'value',
    			  allowBlank: false,
    			  forceSelection:true
    		  }, {
    			 /* xtype: 'numberfield',
    			  itemId: 'instrumentsNo',
    			  width: 130,
    			  labelAlign: 'top',
    			  name: 'instrumentsNo',
    			  allowBlank: false,
    			  minValue: 0,
    			  mouseWheelEnabled:false,
    			  hideTrigger:true,
    			  minValue:0,
    			  maxLength: 40,
//    			  enforceMaxLength : true,
    			  allowDecimals:false*/
    			  xtype:'textfield',
  				enableKeyEvents : true,
  				itemId: 'instrumentsNo',
  				labelAlign: 'top',
  				width: 130,
  				name: 'instrumentsNo',
  				maxLength: 40,
  				allowBlank: false,
  				listeners:{
  						keypress : function(e, t){
  					 		try {
  								if (window.event) {
  									var charCode = window.event.keyCode;
  						 		}else if (e) {
  						 			var charCode = e.which;
  						 		}else { return true; } 						
  						 		if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
  						 				return t.preventDefault();
  						 					}
  						 		}
  							catch (err) {
  						 		alert(err.Description);
  							} 
  				 		}
  					}
    		  },{
    			  xtype:'datefield',
    			  itemId:'instrumentDate',
    			  width: 130,
    			  name:'instrumentDate',
    			  labelAlign: 'top',
    			  format: CONSTANTS.DATE_FORMAT,
    			  //--submitFormat: CONSTANTS.DATE_FORMAT,
    			 // value:new Date(),
    			  allowBlank: false,
//    			  maxValue:new Date()
    			  listeners: {
            		  render: function(obj) {
            			  obj = dateFormatRender(obj);						
            			  obj.setMaxValue(new Date());
            		  }
            	  }
    		  },{
    			  xtype:'numberfield',
    			  name:'amount',
    			  allowExponential:true,
    			  width: 130,
    			  itemId:'amount',
    			  minValue:0,
    			  maxLength:8,
    			  hideTrigger:true,
    			  mouseWheelEnabled:false,
    			  allowBlank: false,
    			  labelAlign: 'top'
    		  },{
    			  xtype: 'customcombobox',
    			  itemId: 'drawnOnBank',
    			  width: '31%',
    			  name: 'drawnOnBank',
    			  labelAlign: 'top',
    			  store: 'feeandpayment.receipts.DrawnOnBankStore',
    			  valueField: 'id',
    			  allowBlank: false,
    			  displayField: 'value',
    			  queryMode: 'local',
    			 listeners:{
    				  afterrender:function(obj)
    			  {
    				  var defaultBankAccountStore=obj.getStore();
    				  
    				  defaultBankAccountStore.load({
    					   params:{
    						   defaultAccount:0,
    						   academyLocationIds:fnpBrandCampusIdValue
    					   },
    					   callback: function(record, operation, success) {
    					   if (success) {
    						   for(i=0;i<record.length;i++)
    						   {
    						   if(record[i].data.sequence!=null)
    							   {
    							   obj.setValue(record[i].data.id);
    							   }
    						   }
    			   }
    				   }
    				   });
    			  }
    			  }
    		  },{
    			  xtype: 'button',
    			  glyph: ICONGLYPH.DELETEGLYPH,
    			  cls: 'CustomBodyBtnReject',
    			  tooltip: getCommonTranslation('DELETETOOLTIP'),
    			  listeners:{
    				  click:function(obj){
    					  var frm = obj.ownerCt.ownerCt.ownerCt;
    					  var receiptPanel = frm.down('#paymentheaderPanel');
    					  var container = obj.up('fieldcontainer');
    					  receiptPanel.remove(container);
    					  if(getform.hasInvalidField()==false){
    						  form.down('#SubmitBtn').setDisabled(false);
    						  form.down('#SubmitAndAdjustmentBtn').setDisabled(false);
    					  }else{
    						  form.down('#SubmitBtn').setDisabled(true);
    						  form.down('#SubmitAndAdjustmentBtn').setDisabled(true);
    					  }
    					  getform.isValid();
    					  frm.doLayout();
    				  }
    			  }
    		  }]    
    	  });

          var paymentheaderPanel = form.down('#paymentheaderPanel');
          var paymentType = form.down('#paymentType');
          if(paymentheaderPanel.items.length<3){
        	  paymentheaderPanel.add(panelItem);
        	  var panelItem = paymentheaderPanel.items.items;
        	 
        	  if(paymentType.getValue().paymentType=="PDC"){
        		  for(var i in panelItem){
        			  panelItem[i].items.items[2].setMinValue(Ext.Date.add(new Date(),Ext.Date.DAY, 1));
        			  panelItem[i].items.items[2].setMaxValue(false);
        		  }
        	  }else{
        		  for(var i in panelItem){
        			  panelItem[i].items.items[2].setMinValue(false);
        			  panelItem[i].items.items[2].setMaxValue(new Date());
        		  }
        	  }
          }
         if(getform.hasInvalidField()==false){
			  form.down('#SubmitBtn').setDisabled(false);
			  form.down('#SubmitAndAdjustmentBtn').setDisabled(false);
		  }else{
			  form.down('#SubmitBtn').setDisabled(true);
			  form.down('#SubmitAndAdjustmentBtn').setDisabled(true);
		  }
          getform.isValid();
          form.doLayout();
         
      },
      //******* remove dynamic fileds*************
      removeDynamicFields : function(){
    	  var form = this.getManagepaymentform();
		  var receiptPanel = form.down('#paymentheaderPanel');
		  for(var i=receiptPanel.items.length-1; i>0;i--){
			  receiptPanel.remove(receiptPanel.items.items[i]);
		  }
		  form.doLayout();
      },
      //*********create json formate**********
      getIdValueJson: function(id, value) {
  		if (id) return {
  			id: id,
  			value: value
  		};
      },
     //**********View PaymentHeaderAdjustmentInstrumentDetailsGrid ************//
      getViewInstrumentAdjustment : function(grid,record){
    	  
    	  var paymentHeaderId = record.get("id");

    	  var formWindow = this.getPaymentheaderinstrumentadjustmentdetailsgridwindow();
	          if (!formWindow) {
	            Ext.widget('paymentheaderinstrumentadjustmentdetailsgridwindow');
	            formWindow = this.getPaymentheaderinstrumentadjustmentdetailsgridwindow();
	          }
	          var gridColumns = formWindow.items.items[0].columns;
			  var length = gridColumns.length;
	          var academyLocationId = this.getCurrentAcademyLocation();
				Ext.Ajax.request({
					method: "GET",
					type: 'rest',
					url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
					params:{
						academyLocationId:academyLocationId
					},
					success: function(response) {
						if(response){
							result = response.responseText;	
						}
						if(result === "false"){
							if(length != null && length != ""){
								for(var i = 0; i < length; i++){
									if(gridColumns[i].dataIndex == 'currencyExchangeRate' || gridColumns[i].dataIndex == 'convertedAmount'){
										gridColumns[i].setVisible(false);
									}
								}
							}
						}
						else {
							if(length != null && length != ""){
								for(var i = 0; i < length; i++){
									if(gridColumns[i].dataIndex =='currencyExchangeRate' || gridColumns[i].dataIndex == 'convertedAmount'){
										gridColumns[i].setVisible(true);
									}
								}
							}
						}
					}
				});     
	          formWindow.show();
	        
	        var store = this.getStore('feeandpayment.payment.PaymentHeaderInstrumentAdjustmentDetails');
	        store.getProxy().extraParams = {
	        	paymentHeaderId: paymentHeaderId
		  };
	        store.load();
      },
      
    //**********View PaymentHeaderAdjustmentInstrumentDetailsGrid ************//
      getOpenBillHeaderAdjustmentGrid : function(grid,record){
    	  
    	  var paymentHeaderId = record.get("id");

    	  var formWindow = this.getBillheaderadjustmentdetailsgridwindow();
	          if (!formWindow) {
	            Ext.widget('billheaderadjustmentdetailsgridwindow');
	            formWindow = this.getBillheaderadjustmentdetailsgridwindow();
	          }
	          formWindow.show();
	        
	        var store = this.getStore('feeandpayment.payment.BillHeaderAdjustmentDetails');
	        store.getProxy().extraParams = {
	        	paymentHeaderId: paymentHeaderId
		  };
	        store.load();
      },
      
      //***************** payment findBY Id*****************
      
      getViewPaymentDetails : function(){
    	  var $this = this;
    	  var structure = $this.getPaymentHeaderStructure();
    	  this.managepaymentFormMode='VIEW';
		  var pcstructure = structure.down("#paymentlistforpcandserviceprovided");
		  var scholarshipstructure = structure.down("#paymentlistforscholarship");
		  var serviceprovidedstructure = structure.down("#paymentlistforserviceprovided");
		  var servicereceivedstructure = structure.down("#paymentlistforservicereceived");
		  var dependendfeestructure =  structure.down("#paymentlistfordependedfeehead");
		  var sponsorestructure= structure.down('#paymentlistforpcandserviceprovidedforsponsor');
		  var applicantstructure= structure.down('#paymentlistforpcandserviceprovidedforapplicant');
		  
		  var grid = null;
		  
		  if(!pcstructure.isHidden()){
			  grid = this.getPaymentlistforpcandserviceprovided();
		  }
		  if(!scholarshipstructure.isHidden()){
		      grid = this.getPaymentlistforscholarship();
		  }
		  if(!serviceprovidedstructure.isHidden()){
			  grid = this.getPaymentlistforserviceprovided();
		  }
		  if(!servicereceivedstructure.isHidden()){
			  grid = this.getPaymentlistforservicereceived();
		  } 
		  if(!dependendfeestructure.isHidden()){
			  grid = this.getPaymentlistfordependedfeehead();
		  }
		  if(!sponsorestructure.isHidden()){
			  grid = this.getPaymentlistforpcandserviceprovidedforsponsor();
		  }
		  if(!applicantstructure.isHidden()){
			  grid = this.getPaymentlistforpcandserviceprovidedforapplicant();
		  }
		  
		  if (grid.getSelectionModel().getCount() > 0) {
			  	var record = grid.getSelectionModel().getSelection()[0];
				$this.getOpenManagePaymentForm();
				var id = record.get("id");
				var billedUserType =  record.get("billedUserType");
			    this.getViewPaymentDetailsByIdAndType(record, id, billedUserType);
		  }else{
	    	 showWarningMessage(getFeeAndPaymentCommonTranslation('PAYMENT_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	      }
      },
      getViewPaymentDetailsByIdAndType : function(record, id, billedUserType){
    	  
    	  var $this = this,userId;	
    	  var form = $this.getManagepaymentform();

			var editUrl = SERVERURL.PAYMENT_HEADER_FIND_BY_ID;
          Ext.Ajax.request({
               method: "GET",
               type: 'rest',
               url: editUrl,
               params: {
                   id: id,
                   billedUserType:billedUserType
               },
           success: function(f, action) {
          	
               var paymentData = Ext.JSON.decode(f.responseText);
               
               var frm = form.getForm();
				 toggleReadOnlyFormItems(frm, true);
              
              var paymentBank = form.down("#depositedBankAcount");
				var paymentCash = form.down("#depositedLedger");
				var paymentmode = form.down("#paymentmode");
				var paymentType = form.down("#paymentType");
				var payingIAU = form.down("#payingIAU");
				var paymentCurrency = form.down("#paymentCurrency");
				var paymentOn = form.down("#paymentOn");
				var paymentOnText =  form.down('#paymentOnText');
				 
               
               if(paymentData.voucherMode=='BANK'){
              	 paymentmode.items.items[0].setValue(true);
              	 if (paymentData.paymentType == 'PDC') {
              		 paymentType.items.items[1].setValue(true);
//              		 paymentType.setValue(paymentData.paymentType);
              	 }

              	 paymentBankStore = paymentBank.getStore();
              	 paymentBankStore.load({
						callback: function(record, operation, success) {
							if (success) {
								paymentBank.setValue(paymentData.depositedBankId);
							}
						}
					});
               }else{
              	 paymentmode.items.items[1].setValue(true);
              	 
              	 paymentCashStore = paymentCash.getStore();
              	 paymentCashStore.load({
						callback: function(record, operation, success) {
							if (success) {
								paymentCash.setValue(paymentData.cashLedgerId);
							}
						}
					});
               }
               
				   if(paymentData.paymentForId){
					  var raiseBillFor = form.down("#paymentFor");
					  raiseBillFor.store.load({
				    		 callback: function(records, operation, success) {
				    			 if (success) {
				    				 raiseBillFor.setValue(paymentData.paymentForId);
				    				 $this.showHidepaymentOnFieldFromDFR(paymentData.paymentFor);
				    			 }
				    		 }
				    	 });
				   }	                 
               if(paymentData.iauId){
              	 payingIAUStore = payingIAU.getStore();
              	 payingIAUStore.load({
						callback: function(record, operation, success) {
							if (success) {
								payingIAU.setValue(paymentData.iauId);
							}
						}
					});
				}

				if(paymentData.currencyId){
					paymentCurrencyStore = paymentCurrency.getStore();
					paymentCurrencyStore.load({
						callback: function(record, operation, success) {
							if (success) {
								paymentCurrency.setValue(paymentData.currencyId);
							}
						}
					});
				}
				
				 $this.checkpaymentFor();
               
				form.down("#paymentVoucherNo").setValue(paymentData.paymentVoucherNo);
				form.down("#paymentVoucherNo").setReadOnly(true);
				form.down("#paymentTo").setValue(paymentData.paymentTo);
				form.down("#transactionDate").setValue(dateRender(paymentData.transactionDate));
				form.down("#narration").setValue(paymentData.narration);
				form.down("#amount1").setValue(paymentData.amount);
				form.down("#SubmitBtn").setVisible(false);
				form.down("#SubmitAndAdjustmentBtn").setVisible(false);
				form.down("#btnCancel").setVisible(false);
				form.down("#isAutoSettlementPayment").setVisible(false);
				paymentOnText.setValue(paymentData.paymentOn);
				var costCentre = form.down("#costCentre");
				costCentre.store.load({
				callback: function(records, operation, success) {
				 	  if (success) {
				 		 paymentData.costCentre &&  costCentre.setValue(paymentData.costCentre.id);
				 	           }
				 	         }
				        });
				var raiseBillType = paymentData.paymentTo;
				
				var record=null;
				
				
				if(!(raiseBillType =="SCHOLARSHIP")){
				if(paymentData.student){
					userId = paymentData.student.id;
					var studentField = form.down("#student");
					studentField.setVisible(true);
					var studentStore = studentField.getStore();
					var filterForm = $this.getPaymentsearchform();
					if(filterForm){
					var fnpAcademyLocationId = filterForm.down("#fnpMultiBrandCampusPaymentItemId").getValue();
					var ALsId = [];
					for(var i in fnpAcademyLocationId){
						if(Ext.isObject(fnpAcademyLocationId[i])){
							ALsId.push(fnpAcademyLocationId[i].data.id);
						}else{
							ALsId.push(fnpAcademyLocationId[i]);
						}
					}
					var academyLocationIds = ALsId.join();
					}else{
						var academyLocationIds = $this.getCurrentAcademyLocation();
					}
					studentStore.getProxy().extraParams = {
						academyLocationIds: academyLocationIds,
						studentNameOrCode:paymentData.student ? paymentData.student.studentCode:'',
						limit:null
					};
					studentStore.load({
			    		 callback: function(records, operation, success) {
			    			 if (success) {
			    				 Ext.defer(function(){
			    					 studentField.setValue(paymentData.student.id);
			    				 },100)
			    				
			    			 }
			    		 }
			    	 });
					
					$this.setAddressForStudent(paymentData,record);
				}else{
					  Ext.defer(function() {
						  form.down('#student').setVisible(false);
					   }, 2000);
					
				}
			}else if(raiseBillType =="SCHOLARSHIP"){
				form.down("#isAutoSettlementPayment").setVisible(false);
				if(paymentData.scholarship){
					var scholarshipField = form.down("#scholarship");
					scholarshipField.setVisible(true);
					scholarshipField.store.load({
			    		 callback: function(records, operation, success) {
			    			 if (success) {
			    				 scholarshipField.setValue(paymentData.scholarship.id);
			    			 }
			    		 }
			    	 });
				}
				
				if(paymentData.student){
					userId = paymentData.student.id;
					var scholarshipStudentField = form.down("#scholarshipStudent");
					scholarshipStudentField.store.getProxy().extraParams = {
						academyLocationIds: academyLocationIds,
						studentNameOrCode:paymentData.student ? paymentData.student.studentCode:'',
						limit:null
					};
					scholarshipStudentField.store.load({
						callback: function(records, operation, success) {
							if (success) {
								scholarshipStudentField.setValue(paymentData.student.id);
								scholarshipStudentField.setVisible(true);
								scholarshipStudentField.setDisabled(false);
							}
						}
					});
					$this.setAddressForStudent(paymentData,record);
					
				}
			}
				if(paymentData.thirdParty){
					var thirdPartyField = form.down("#thirdParty");
					thirdPartyField.setVisible(true);
					thirdPartyField.store.load({
			    		 callback: function(records, operation, success) {
			    			 if (success) {
			    				 thirdPartyField.setValue(paymentData.thirdParty.id);
			    			 }
			    		 }
			    	 });
				}
				if(paymentData.sponsor){
					//form.down("#student").setVisible(true);
					var sponsorField = form.down("#sponsors");
					sponsorField.setVisible(true);
					sponsorField.store.load({
			    		 callback: function(records, operation, success) {
			    			 if (success) {
			    				 sponsorField.setValue(paymentData.sponsor.id);
			    			 }
			    		 }
			    	 });
					$this.setAddressForSponsors(paymentData.sponsor.id,record);
				}
				
				if(paymentData.applicant){
					userId = paymentData.applicant.id;
					var applicantField = form.down("#applicant");
					applicantField.store.getProxy().extraParams = {
						codeOrName:paymentData.applicant ? paymentData.applicant.code:''
					};
					applicantField.store.load({
			    		 callback: function(records, operation, success) {
			    			 if (success) {
			    				 applicantField.setValue(paymentData.applicant.id);
			    				 applicantField.setVisible(true);
			    				 applicantField.setDisabled(false);
			    			 }
			    			 
			    		 }
			    	 });
					$this.setAddressForApplicant(paymentData,record);
				}
				if(paymentData.user){
					userId = paymentData.user.id;
					var userField = form.down("#userId");
					userField.store.load({
			    		 callback: function(records, operation, success) {
			    			 if (success) {
			    				 var raiseBillFor = form.down("#paymentFor");
								  raiseBillFor.store.load({
							    		 callback: function(records, operation, success) {
							    			 if (success) {
							    				 raiseBillFor.setValue(paymentData.paymentForId);
							    				 form.down("#paymentTo").setValue(paymentData.paymentTo);
							    				 var studentField = form.down("#student");
							    				 studentField.setVisible(false);
							    				 userField.setVisible(true);
							    				 userField.setValue(paymentData.user.id);
							    				 $this.setAddressForUser(paymentData,record);
							    			 }
							    		 }
							    	 });
			    			 }
			    		 }
			    	 });
				}
				 var fnpBrandCampusId = form.down('#fnpBrandCampusItemId');
				 var ALComboStore = fnpBrandCampusId.getStore();
				 ALComboStore.getProxy().extraParams = {
						id: userId
					};
				 ALComboStore.load({
					 callback: function(records, operation, success) {
						 if (success) {
								   if(records.length){
									   fnpBrandCampusId.setValue(records[0].data.id);
								   }
							  
						 }
					 }
				 });
				var instrument = paymentData.receiptPaymentInstruments;
				
				if(instrument.length>0){
					var store = $this.getStore('feeandpayment.payment.PaymentInstrumentTempStore');
					 if(store.getRange()){
						 store.removeAll();	 
					 }
					 store.loadRawData(instrument, true);
					 form.down("#paymentheaderPanel").setVisible(false);
					 $this.getPaymentsform().down("#paymentinstrumentgrid").setVisible(true);
				}
           }		 
			     
       });
          var inActiveStudentField = form.down("#inActiveStudentItemId");
          Ext.defer(function() {
        	  inActiveStudentField.setValue(record.raw.isInactiveStudentId);
        	  inActiveStudentField.setVisible(false);
          }, 2000);

      },
      //*************** delete the payment records *********
      getDeletePaymentDetails : function(){
    	 
    	  var $this = this;
    	  var structure = $this.getPaymentHeaderStructure();
    	  
		  var pcstructure = structure.down("#paymentlistforpcandserviceprovided");
		  var scholarshipstructure = structure.down("#paymentlistforscholarship");
		  var serviceprovidedstructure = structure.down("#paymentlistforserviceprovided");
		  var servicereceivedstructure = structure.down("#paymentlistforservicereceived");
		  var dependendfeestructure =  structure.down("#paymentlistfordependedfeehead");
		  var sponsorestructure= structure.down('#paymentlistforpcandserviceprovidedforsponsor');
		  var applicantstructure= structure.down('#paymentlistforpcandserviceprovidedforapplicant');
		  
		  var grid = null;
		  
		  if(!pcstructure.isHidden()){
			  grid = this.getPaymentlistforpcandserviceprovided();
		  }
		  if(!scholarshipstructure.isHidden()){
		      grid = this.getPaymentlistforscholarship();
		  }
		  if(!serviceprovidedstructure.isHidden()){
			  grid = this.getPaymentlistforserviceprovided();
		  }
		  if(!servicereceivedstructure.isHidden()){
			  grid = this.getPaymentlistforservicereceived();
		  } 
		  if(!dependendfeestructure.isHidden()){
			  grid = this.getPaymentlistfordependedfeehead();
		  }
		  if(!sponsorestructure.isHidden()){
			  grid = this.getPaymentlistforpcandserviceprovidedforsponsor();
		  }
		  if(!applicantstructure.isHidden()){
			  grid = this.getPaymentlistforpcandserviceprovidedforapplicant();
		  }
		  
		  var grdStore = grid.getStore();

       	  if(grid.getSelectionModel().getCount()>0){
       		showConfirmMessage(getFeeAndPaymentCommonTranslation('PAYMENT_TITLE'), getFeeAndPaymentCommonTranslation('CANCEL_CONFIRM_MESSAGE'), function(btn, text) {
       			  if (btn == 'yes') {
       				  var records=grid.getSelectionModel().getSelection();						        
       				  var id=records[0].get("id");
       				  Ext.Ajax.request({
       					  method: "DELETE",
       					  type: 'rest',
       					  url: SERVERURL.PAYMENT_HEADER_DELETE+'?id='+id,
       					  headers: {
       						  'Content-Type': 'application/json'
       					  },
       					  success:function(form, action){
       						  grdStore.reload();
       						  showSuccessMessage(getFeeAndPaymentCommonTranslation('PAYMENT_TITLE'),getFeeAndPaymentCommonTranslation('PAYMENT_DELETED_SUCCESSFULLY'));
       					  }
       				  });
       			  }
       		  });
       	  }else{
       		  showWarningMessage(getFeeAndPaymentCommonTranslation('PAYMENT_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
       	  }
      },
      //************ Reset Serch form expect bill type and receipt view *********
      getResetPaymentForm : function(){
    	  var $this = this;
     	 var form = this.getPaymentsearchform().getForm();
     	 form.getFields().each(function(field) {
     		 if(field.name !== 'billType' && field.name != 'billFor') {
     			 field.reset();	
     		 }
     		if(field.name === 'batch' || field.name === 'section') {
       			field.clearValue();	
       			field.setDisabled(true);	
      		 }
     	 });
     	 var fnpMultiBrandCampusNameField = form.findField('fnpMultiBrandCampusNamePayment');
     	 fnpMultiBrandCampusNameField.reset();

     	 var ALComboStore = fnpMultiBrandCampusNameField.getStore();
     	 ALComboStore.load({
     		 callback: function(records, operation, success) {
     			 if (success) {
     				 fnpMultiBrandCampusNameField.select(fnpMultiBrandCampusNameField.getStore().collect(fnpMultiBrandCampusNameField.valueField));
     			 }
     		 }   
     	 });
     	var billDateFrom = form.findField('billDateFrom');
     	var billDateTill = form.findField('billDateTill');
     	var billDueDateFrom = form.findField('billDueDateFrom');
     	var billDueDateTill = form.findField('billDueDateTill');
     	var paymentDateFrom = form.findField('paymentDateFrom');
     	var paymentDateTo = form.findField('paymentDateTo');
     	form.findField('inactiveStudents').setVisible(true);
     	billDateFrom.setMaxValue(false);
     	billDateFrom.setMinValue(false);
     	
     	billDateTill.setMaxValue(false);
     	billDateTill.setMinValue(false);
     	
     	billDueDateFrom.setMaxValue(false);
     	billDueDateFrom.setMinValue(false);
     	
     	billDueDateTill.setMaxValue(false);
     	billDueDateTill.setMinValue(false);
     	
     	paymentDateFrom.setMaxValue(false);
     	paymentDateFrom.setMinValue(false);
     	
     	paymentDateTo.setMaxValue(false);
     	paymentDateTo.setMinValue(false);
     	
     /*	var billTypeField = form.findField('billType');
		var billTypeStore=billTypeField.getStore();
     	billTypeStore.load({
				callback: function(record, operation, success) {
					if (success) {
						billTypeField.setValue(record[0].data.id);
					//old	
						billForStore.load({
							params : {
								raiseBillType : record[0].data.id,
								screenType:'payment'
							},
	       					callback: function(rec, operation, success) {
	       						if (success) {
	       						   billForField.setValue(rec[0].data.id);
	       						   $this.paymentVoucherNoSearch(rec[0].data.id,rec[0].data.value,null);
	       						   $this.billNoSearch(rec[0].data.id,rec[0].data.value,null);
	       						}
	       					}
	       				});
						//old
					}
				}
			}); 
	*/		
			 var billForField = form.findField('billFor');
  	   var billForStore=billForField.getStore();
  	     form.isValid();
  	   var billTypeField = form.findField('billType');
		   var billTypeStore=billTypeField.getStore();
  	   billTypeStore.load({
			   params:{
				   screenType:'payment'  
			   },
			   
			   callback: function(record, operation, success) {
				   if (success) {
					   billTypeField.setValue(record[0].data.id);
					   $this.getShowAndHidePaymentsForResetList();
					   billForStore.load({
						   params : {
							   raiseBillType : record[0].data.id,
							   screenType:'payment'
						   },
						   callback: function(rec, operation, success) {
							   if (success) {
								   var form1 = $this.getPaymentsearchform();
								   
              				   var academyLocationIds = form1.down("#fnpMultiBrandCampusPaymentItemId").getValue()
								   billForField.setValue(rec[0].data.id);
								   $this.billNoSearch(rec[0].data.id,rec[0].data.value,null,academyLocationIds);
								   $this.paymentVoucherNoSearch(rec[0].data.id,rec[0].data.value,null,academyLocationIds);
							   }
						   }
					   });
				   }
			   }
		   });
  	   
     	 Ext.resumeLayouts();
      },
      //***************PaymentVoucherNo smart search***************//
      paymentVoucherNoSearch : function(billedUserTypeId,billedUserType,id,academyLocationId){

    	 // var academyLocationId = this.getCurrentAcademyLocation();
    	   var alIds = [];
    	  var academyLocationIds = null;
    	  if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    		  for (var i in academyLocationId) {
    			  if (Ext.isObject(academyLocationId[0])) {
    				  if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
    					  alIds.push(academyLocationId[i].get("id"));
    				  }else{
    					  alIds.push(academyLocationId[i]);
    				  }
    			  } else {
    				  alIds.push(academyLocationId[i]);
    			  }
    		  }
    		  academyLocationIds = alIds.join();
    	  }else{
    		  academyLocationIds = academyLocationId;
    	  }
    	  var paymentVoucherNostore = this.getStore('feeandpayment.payment.PaymentVoucherNo');
    	  if(billedUserTypeId==9)
        	{
        		var frm = this.getPaymentsearchform();
        		var scholarshipId = frm.down("#scholarship").getValue();
        		paymentVoucherNostore.getProxy().extraParams = {
        			academyLocationId: academyLocationIds,
        			billedUserTypeId:billedUserTypeId,
        			billedUserType:billedUserType,
        			id:id,
        			scholarshipId:scholarshipId
        		};
          	  paymentVoucherNostore.load();
        	}else
        	{
        		paymentVoucherNostore.getProxy().extraParams = {
        			academyLocationId: academyLocationIds,
        			billedUserTypeId:billedUserTypeId,
        			billedUserType:billedUserType,
        			id:id
        		};
          	  paymentVoucherNostore.load();
        	}
      },
      billNoSearch : function(billedUserTypeId,billedUserType,id,academyLocationId){
     	//var academyLocationId = this.getCurrentAcademyLocation();
      	var alIds = [];
 	   var academyLocationIds = null;
 	   if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
 		   for (var i in academyLocationId) {
 			   if (Ext.isObject(academyLocationId[0])) {
 				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
 					   alIds.push(academyLocationId[i].get("id"));
 				   }else{
 					   alIds.push(academyLocationId[i]);
 				   }
 			   } else {
 				   alIds.push(academyLocationId[i]);
 			   }
 		   }
 		   academyLocationIds = alIds.join();
 	   }else{
 		   academyLocationIds = academyLocationId;
 	   }
      	var billNostore = this.getStore('feeandpayment.managebill.DependentBillId');
      	if(billedUserTypeId==9)
      	{
      		var frm = this.getPaymentsearchform();
      		var scholarshipId = frm.down("#scholarship").getValue();
      		billNostore.getProxy().extraParams = {
      			academyLocationId: academyLocationIds,
      			billedUserTypeId:billedUserTypeId,
      			billedUserType:billedUserType,
      			screenType:"Payment",
      			scholarshipId:scholarshipId,
      			id:id
      		};
      		billNostore.load();
      	}else
      	{
      		billNostore.getProxy().extraParams = {
				academyLocationId: academyLocationIds,
				billedUserTypeId:billedUserTypeId,
				billedUserType:billedUserType,
				screenType:"Payment",
				id:id
			};
			billNostore.load();
      	}
      },
      getResetManagePaymentForm : function(){
    	  var form = this.getManagepaymentform();
    	  var getForm= form.getForm();
    	  getForm.getFields().each(function(field) {
    		  if(field.name !== 'raiseBillType' && field.name != 'receiptForm') {
    			  field.reset();	
    		  }
    	  });
    	  form.fireEvent("render",form);
		  var paymentDateObj = form.getForm().findField('transactionDate');
		  var currencyField = form.getForm().findField('paymentCurrency');
		  var studentField = form.getForm().findField('#student');
		  paymentDateObj.fireEvent("render",paymentDateObj);
		  var instrumentDateObj = form.getForm().findField('instrumentDate');
		  instrumentDateObj.fireEvent("render",instrumentDateObj);
    	  this.removeDynamicFields();
    	  var addresDetailPanel = this.getPaymentAddressDetailPanel();	
		  var addressForm=addresDetailPanel.getForm();
		  var nameField = addressForm.findField('name');
		  nameField.reset();
		  var fatherNameField = addressForm.findField('fatherName');
		  fatherNameField.reset();
		  var addressField = addressForm.findField('address');
		  addressField.reset();
		  var emailIdField = addressForm.findField('emailId');
		  emailIdField.reset();
		  var contactNoField = addressForm.findField('contactNo');
		  contactNoField.reset();
		  var addmissionIdField = addressForm.findField('addmissionId');
		  addmissionIdField.reset();
		  var applicationIdField = addressForm.findField('applicationId');
		  applicationIdField.reset();
		  var actualUserId = addressForm.findField('actualUserId');
		  actualUserId.reset();
		  var applicantIdField = addressForm.findField('applicantId');
		  applicantIdField.reset();
		  var programField = addressForm.findField('program');
		  programField.reset();
		  var batchField = addressForm.findField('batch');
		  batchField.reset();
		  var periodField = addressForm.findField('period');
		  periodField.reset();
		  var sectionField = addressForm.findField('section');
		  sectionField.reset();
		  var seatTypeField = addressForm.findField('seatType');
		  seatTypeField.reset();
		  var totalAcadInvoiceAmountField = addressForm.findField('totalAcadInvoiceAmount');
		  totalAcadInvoiceAmountField.reset();
		  var totalAcadReceiptAmountField = addressForm.findField('totalAcadReceiptAmount');
		  totalAcadReceiptAmountField.reset();
		  var totalAcadPaymentAmountField = addressForm.findField('totalAcadPaymentAmount');
		  totalAcadPaymentAmountField.reset();
		  var totalConvertedOutstandingField = addressForm.findField('totalConvertedOutstanding');
		  totalConvertedOutstandingField.reset();
		  var totalAcadDicountAmountField = addressForm.findField('totalAcadDicountAmount');
		  totalAcadDicountAmountField.reset();
		  var totalAcadLocAdvanceAmountField = addressForm.findField('totalAcadLocAdvanceAmount');
		  totalAcadLocAdvanceAmountField.reset();
		  
		  
		  addresDetailPanel.collapse();
    	  Ext.resumeLayouts();
    	  if(getForm.hasInvalidField()==false){
    		  form.down('#SubmitBtn').setDisabled(false);
    		  form.down('#SubmitAndAdjustmentBtn').setDisabled(false);
    	  }else{
    		  form.down('#SubmitBtn').setDisabled(true);
    		  form.down('#SubmitAndAdjustmentBtn').setDisabled(true);
    	  }
				   form.down('#paymentCurrency2').setVisible(false);
				   form.down('#paymentCurrency2').allowBlank = true;
				   form.down('#paymentCurrency2').clearInvalid();
				   form.down('#paymentCurrency').setVisible(true);
				   form.down('#paymentCurrency').allowBlank = false;
				   form.down('#paymentCurrency').clearInvalid();
				   form.down('#paymentCurrency2').setVisible(false);
				   form.down('#paymentCurrency2').allowBlank = true;
				   form.down('#paymentCurrency2').clearInvalid();
				   form.down('#paymentCurrency').setVisible(true);
				   form.down('#paymentCurrency').allowBlank = false;
				   form.down('#paymentCurrency').clearInvalid();
				   
				   form.down('#student').setVisible(true);
				   form.down('#student').clearInvalid();
				   form.down('#userId').setVisible(false);
				   form.down('#sponsors').setVisible(false);
				   form.down('#applicant').setVisible(false);
				   form.down('#scholarship').setVisible(false);
				   form.down('#scholarship').allowBlank = true;
				   form.down('#scholarship').clearInvalid();
				   form.down('#scholarshipStudent').setVisible(false);
				   form.down('#scholarshipStudent').allowBlank = true;
				   form.down('#scholarshipStudent').clearInvalid();
				   
				 
				 var tabName = getFeeAndPaymentCommonTranslation('PAYMENT_DETAIL');
				 var newTab = this.getTabReferenceByTabTitle(tabName);
              	 var academyLocationId = this.getCurrentAcademyLocation();
  				 var multiBrandCampusId = newTab.down('#fnpBrandCampusItemId');
  				 var ALComboStore = multiBrandCampusId.getStore();
  				 ALComboStore.load({
  					 callback: function(records, operation, success) {
  						 if (success) {
  							 for(var i in records){
  								   if(records[i].data.id==academyLocationId){
  									   multiBrandCampusId.setValue(academyLocationId);
  								   }
  							   }
  						 }
  					 }
  				 });
				   
				   var currencyStore = currencyField.getStore();
					  currencyStore.load({
						  callback: function(rec, operation, success) {
							  if (success) {
								  if(!isNullOrEmpty(defaultcurrncyId)){
									  currencyField.setValue(defaultcurrncyId.id);
								  }
							  }
						  }
					  });
					  
		
      },
      loadFeeOfflinePaymentDetail:function(){
    	  var $this=this;
    	  var form = $this.getFeeofflinepaymentdetailform();
    	  var user=$this.getCurrentlyLoggedInUserInfoForPortal().student.id;
    	  var receiptNo = form.down("#receiptNo").getValue();
    	  var status = form.down("#status").getValue();
    	  var startDate = form.down("#startDate").getValue();
    	  var endDate = form.down("#tillDate").getValue();
    	  var grid = $this.getFeeofflinepaymentdetailgrid();
    	  grid.getSelectionModel().deselectAll(true);
    	  var values = form.getForm().getValues();
    	  var store =  grid.getStore();
    	  if(!isNullOrEmpty(status)){
    		  store.getProxy().extraParams = {
    			  receiptNo: receiptNo,
    			  status: status,
    			  fromDate: startDate,
    			  tillDate: endDate,
    			  studentId:user
    		  }; 
    	  }else{
    		  store.getProxy().extraParams = {
    			  receiptNo: receiptNo,
    			  fromDate: startDate,
    			  tillDate: endDate,
    			  studentId:user
    		  }; 
    	  }
    	  $this.resetPageSetting(store);
    	  store.load();
      },
      //********Open New Tab for Add Offline Details **********
      openOfflinePaymentDetails : function(){
    	  $this = this;
    	  var contentpanel = $this.getContentpanel();
    	  var offlinePaymentDetailFrom=Ext.widget("manageofflinepaymentdetailform");
    	  var tabName = getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS');
    	  var newTab = this.getTabReferenceByTabTitle(tabName);
    	  var getcontroller=$this.getController('menu.CoreERPNavigationController');
    	  var getTab=getcontroller.getTab(tabName);
    	  if(getTab!=null){
    		  contentpanel.remove(getTab, true);
    	  }
    	  openTab(contentPanel, tabName, offlinePaymentDetailFrom, CONSTANTS.MENU_COLOR_TWO);
    	  contentPanel.setActiveTab(newTab);
    	  var form = $this.getManageofflinepaymentdetailform();
    	  var receivingCurrency=form.down('#receivingCurrency');
			  var receivingCurrencyStore=receivingCurrency.getStore();
			  receivingCurrencyStore.load({
				  callback: function(record, operation, success) {
					  if (success) {
						  for(i=0;i<record.length;i++)
						  {
							  if(record[i].data.name=='INR')
							  {
								  receivingCurrency.setValue(record[i].data.id);
							  }
						  }
					  }
				  }
			  });
      },
      // ************ Offline Payment HeaderRender for add and delete button*************
      addOfflinePaymentHeaderContainer: function() {
   	   var this$ = this;
   	   var form = this$.getManageofflinepaymentdetailform();
   	   var getform = form.getForm();
   	   var panelItem = new Array();
   	   panelItem.push({
   		   xtype: 'fieldcontainer',
   		   width: '100%',
   		   layout: {
   			   type: 'hbox',
   			   align: 'bottom'
   		   },
   		   items: [{
   			   xtype: 'customcombobox',
   			   itemId: 'paymentMode',
   			   name: 'paymentMode',
   			   width: 135,
   			   labelAlign: 'top',
   			   store: 'feeandpayment.FeePaymentMode',
   			   valueField: 'id',
   			   displayField: 'value',
   			   allowBlank: false,
   			   forceSelection:true
   		   }, {
   			   xtype:'textfield',
   			   enableKeyEvents : true,
   			   itemId: 'instrumentsNo',
   			   labelAlign: 'top',
   			   width: 130,
   			   name: 'instrumentsNo',
   			   maxLength: 40,
   			   allowBlank: false,
   			   listeners:{
					keypress : function(e, t){
						try {
							if (window.event) {
								var charCode = window.event.keyCode;
							}else if (e) {
								var charCode = e.which;
							}else { return true; }

							if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
								return t.preventDefault();
							}
						}
						catch (err) {
							alert(err.Description);
						} 
					}
				}
   		   },{
   			   xtype:'datefield',
   			   itemId:'instrumentDate',
   			   name:'instrumentDate',
   			   width: 130,
   			   labelAlign: 'top',
   			   allowBlank: false,
   			   listeners: {
  					render: function(field) {
  						return dateFormatRender(field);
  					}
  				}
   		   },{
   			   xtype: 'numberfield',
   			   itemId: 'amount',
   			   labelAlign: 'top',
   			   name: 'amount',
   			   width: 130,
   			   minValue: 0,
   			   allowDecimals:false,
   			   hideTrigger:true,
   			   maxLength:10,
   			   mouseWheelEnabled:false,
   			   allowBlank: false
   		   },{
   			   xtype: 'customcombobox',
   			   itemId: 'drawnOnBank',
   			   name: 'drawnOnBank',
   			   width: '31%',
   			   labelAlign: 'top',
   			   store: 'feeandpayment.receipts.DrawnOnBank',
   			   valueField: 'id',
   			   displayField: 'value',
   			   allowBlank: false,
   			   typeAhead:true,
   			   forceSelection:true

   		   },{
   			   xtype: 'button',
   			   glyph: ICONGLYPH.DELETEGLYPH,
   			   cls: 'CustomBodyBtnReject',
   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
   			   listeners:{
   				   click:function(obj){
   					   var frm = obj.ownerCt.ownerCt.ownerCt;
   					   var offlinePaymentheaderPanel = frm.down('#offlinePaymentheaderPanel');
   					   var container = obj.up('fieldcontainer');
   					   offlinePaymentheaderPanel.remove(container);
   					   getform.isValid();
   					   if(getform.isValid() == true){
   						frm.down('#SubmitBtn').setDisabled(false);  
   					   }
   					   frm.doLayout();
   				   }
   			   }
   		   },{
			   xtype:'hidden',
			   name:'instrumentId'
		   }]    
   	   });
   	   var offlinePaymentheaderPanel = form.down('#offlinePaymentheaderPanel');
   	   if(offlinePaymentheaderPanel.items.length<3){
   		   offlinePaymentheaderPanel.add(panelItem);
   		   var panelItem = offlinePaymentheaderPanel.items.items;
   		   for(var i in panelItem){
   			   panelItem[i].items.items[2].setMinValue(false);
   			   //panelItem[i].items.items[2].setMaxValue(false);
   			   panelItem[i].items.items[2].setMaxValue(new Date());
   		   }
   	   }

   	   if(form.getForm().isValid() == true){
   		form.down('#SubmitBtn').setDisabled(false);  
   	   }else{
   		form.down('#SubmitBtn').setDisabled(true);    
   	   }
   	   form.doLayout();
      },
      getDocumentController : function() {
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
    //  view Offline Payment details******************
    ViewOfflinePaymentDetails : function(){
 	   var $this = this;
 	   var grid = $this.getFeeofflinepaymentdetailgrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var record = grid.getSelectionModel().getSelection()[0];
 		   $this.openOfflinePaymentDetails();
 		   var form = $this.getManageofflinepaymentdetailform();
 		   form.down("#btnReset").setVisible(false);
		   form.down("#SubmitBtn").setVisible(false);
		   form.down("#uploadDocument").setVisible(false);
 		   var id = record.get("id");
 		   var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
 		   Ext.Ajax.request({
 			   method: "GET",
 			   type: 'rest',
 			   url: editUrl,
 			   params: {
 				  offlinePaymentId: id
 			   },
 			   success: function(response, action) {
 				   var offlinePaymentData = Ext.JSON.decode(response.responseText);
				   var frm = form.getForm();
				   frm.findField('id').setValue(id);
				   toggleReadOnlyFormItems(frm, true);
				   var receivingCurrency = form.down("#receivingCurrency");
				   var receivingCurrencyStore=receivingCurrency.getStore();
	 				  receivingCurrencyStore.load({
	 					  callback: function(record, operation, success) {
	 						  if (success) {
	 						   receivingCurrency.setValue(offlinePaymentData.currency.id);
	 						  }
	 					  }
	 				  });
				   form.down("#offlinePaymentProofNo").setValue(offlinePaymentData.proofno);
				   var receivingCurrency = form.down("#receivingCurrency");
				   var instrumentLength= offlinePaymentData.offlinePaymentInstrument.length;
				   if(instrumentLength>0){
					   var fieldPanel=form.down('#offlinePaymentheaderPanel');
					   Ext.Array.each(offlinePaymentData.offlinePaymentInstrument,function(value,index){
						   if(index>0){
							   $this.addOfflinePaymentHeaderContainer();	
						   }
						   var filedContainer = fieldPanel.items.items[index];
						   var paymentMode = filedContainer.items.items[0];
						   var paymentModeStore = paymentMode.getStore();
						   paymentModeStore.load({
							   callback: function(rec, operation, success) {
								   if (success) {
									   paymentMode.setValue(value.paymentMode.id);
									   paymentMode.setReadOnly(true);
								   }
							   }
						   });

						   filedContainer.items.items[1].setValue(value.instrumentNo);
						   filedContainer.items.items[1].setReadOnly(true);
						   filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
						   filedContainer.items.items[2].setReadOnly(true);
						   filedContainer.items.items[3].setValue(value.amount);
						   filedContainer.items.items[3].setReadOnly(true);
						   var drawnOnBank = filedContainer.items.items[4];

						   var drawnOnBankStore = drawnOnBank.getStore();
						   drawnOnBankStore.load({
							   callback: function(rec, operation, success) {
								   if (success) {
									   drawnOnBank.setValue(value.instrumentBank.id);
								   }
							   }
						   });
						   filedContainer.items.items[4].setReadOnly(true);
						   filedContainer.items.items[5].setVisible(false);
						   filedContainer.items.items[6].setValue(value.id);
					   });

				   }
				   var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistgrid();
				   feeOfflinePaymentDocGrid.down('#btnDelete').setDisabled(true);
				   feeOfflinePaymentDocGrid.getStore().removeAll();
				   feeOfflinePaymentDocGrid.getStore().load({
							params : {
								 offlinePaymentId: id
								},
		       					callback: function(rec, operation, success) {
		       						if (success) {}
		       					}
		       				});
				   feeOfflinePaymentDocGrid.setVisible(true);
 			   }
 				  
 		   });
 	   }else{
 		   showWarningMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
 	   }
    },
    // edit Offline Payment Detail. only *******
    editOfflinePaymentDetails : function(){
 	   var $this = this;
 	   var grid = $this.getFeeofflinepaymentdetailgrid();
 	   if (grid.getSelectionModel().getCount() > 0) {
 		   var record = grid.getSelectionModel().getSelection()[0];
 		   $this.openOfflinePaymentDetails();
 		   var form = $this.getManageofflinepaymentdetailform();
 		   var id = record.get("id");
 		   var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
 		   Ext.Ajax.request({
 			   method: "GET",
 			   type: 'rest',
 			   url: editUrl,
 			   params: {
 				  offlinePaymentId: id
 			   },
 			   success: function(response, action) {
 				   var offlinePaymentData = Ext.JSON.decode(response.responseText);
				   var frm = form.getForm();
				   frm.findField('id').setValue(id);
				   form.down("#offlinePaymentProofNo").setValue(offlinePaymentData.proofno);
				   var receivingCurrency = form.down("#receivingCurrency");
				   var receivingCurrencyStore=receivingCurrency.getStore();
	 				  receivingCurrencyStore.load({
	 					  callback: function(record, operation, success) {
	 						  if (success) {
	 						   receivingCurrency.setValue(offlinePaymentData.currency.id);
	 						  }
	 					  }
	 				  });
				   form.down("#btnReset").setVisible(false);
				   var instrumentLength= offlinePaymentData.offlinePaymentInstrument.length;

				   if(instrumentLength>0){
					   var fieldPanel=form.down('#offlinePaymentheaderPanel');
					   Ext.Array.each(offlinePaymentData.offlinePaymentInstrument,function(value,index){
						   if(index>0){
							   $this.addOfflinePaymentHeaderContainer();	
						   }
						   var filedContainer = fieldPanel.items.items[index];
						   var paymentMode = filedContainer.items.items[0];
						   var paymentModeStore = paymentMode.getStore();
						   paymentModeStore.load({
							   callback: function(rec, operation, success) {
								   if (success) {
									   paymentMode.setValue(value.paymentMode.id);
									   paymentMode.setReadOnly(false);
								   }
							   }
						   });

						   filedContainer.items.items[1].setValue(value.instrumentNo);
						   filedContainer.items.items[1].setReadOnly(false);
						   filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
						   filedContainer.items.items[2].setReadOnly(false);
						   filedContainer.items.items[3].setValue(value.amount);
						   filedContainer.items.items[3].setReadOnly(false);
						   var drawnOnBank = filedContainer.items.items[4];

						   var drawnOnBankStore = drawnOnBank.getStore();
						   drawnOnBankStore.load({
							   callback: function(rec, operation, success) {
								   if (success) {
									   drawnOnBank.setValue(value.instrumentBank.id);
								   }
							   }
						   });
						   filedContainer.items.items[4].setReadOnly(false);
						   filedContainer.items.items[6].setValue(value.id);
					   });

				   }
				   var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistgrid();
				   feeOfflinePaymentDocGrid.getStore().removeAll();
				   feeOfflinePaymentDocGrid.getStore().load({
							params : {
								 offlinePaymentId: id
								},
		       					callback: function(rec, operation, success) {
		       						if (success) {}
		       					}
		       				});
				   feeOfflinePaymentDocGrid.setVisible(true);
 			   }
 		   });
 	   }else{
 		   showWarningMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
 	   }

    },
    //********* Delete Offline Payment Detail records***********
    deleteOfflinePaymentDetails : function(){
    	var $this = this;
    	var grid = $this.getFeeofflinepaymentdetailgrid();
    	var grdStore = grid.getStore();
    	var user = $this.getCurrentlyLoggedInUserInfoForPortal().student.id; 
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				var records=grid.getSelectionModel().getSelection();						        
    				var id=records[0].get("id");
    				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method: "GET",
    					type: 'rest',
    					url: SERVERURL.PATH_OFFLINE_PAYMENT_DETAIL_DELETE+'?id='+id,
    					headers: {
    						'Content-Type': 'application/json'
    					},
    					success:function(form, action){
    						Ext.getBody().unmask();
    						grdStore.reload({
    	    					params : {
    								 studentId: user
    								},
    		       					callback: function(rec, operation, success) {
    		       						if (success) {}
    		       					}
    	    				});
    						grid.getSelectionModel().deselectAll(true);
    						showSuccessMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('RECORD_DELETE_SUCCESS'));
    					}
    				});
    			}
    		});
    	}else{
    		showWarningMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
    	}
    },
    // ******************* Manage Receipts Form****************
    getSaveOfflinePaymentDetail : function(){
    	var $this = this;
    	var form = $this.getManageofflinepaymentdetailform().getForm();
    	var value = form.getValues();
    	var user = $this.getCurrentlyLoggedInUserInfoForPortal().student.id; 
    	var offlineForm = $this.getManageofflinepaymentdetailform();
    	var offlinePaymentModel = new Academia.model.feeandpayment.payment.OfflinePaymentDetailRecordSaveModel();
    	offlinePaymentModel.set("currency",$this.getIdValueJson(value.receivingCurrency));
    	offlinePaymentModel.set("voucherMode","BANK");
    	var myJson = new Array();
    	if (!isEmpty(value["paymentMode"])) {
    		var isArr = isArray(value["paymentMode"]);
    		if (isArr == true) {
    			var amount=0;
    			for (var i = 0; i < value["paymentMode"].length; i++) {
    				var obj = new Object();
    				obj.paymentMode = $this.getIdValueJson(value["paymentMode"][i]);
    				obj.instrumentBank = $this.getIdValueJson(value["drawnOnBank"][i]);
    				obj.instrumentNo = value["instrumentsNo"][i];
    				obj.instrumentDate = value["instrumentDate"][i];
    				obj.amount = value["amount"][i];
    				//obj.instrumentId = value["instrumentId"][i];
    				myJson.push(obj);
    				amount = amount + parseInt(value["amount"][i]);
    			}
    			offlinePaymentModel.set("amount",amount);
    		}
    	}else{
    		var obj = new Object();
    		obj.paymentMode = $this.getIdValueJson(value.paymentMode);
    		obj.instrumentBank = $this.getIdValueJson(value.drawnOnBank);
    		obj.instrumentNo = value.instrumentsNo;
    		obj.instrumentDate = value.instrumentDate;
    		obj.amount = value.amount;
    		//obj.instrumentId = value.instrumentId;
    		myJson.push(obj);
    		offlinePaymentModel.set("amount",value.amount);
    	}
    	offlinePaymentModel.set("proofno",value["offlinePaymentProofNo"]);
    	offlinePaymentModel.set("offlinePaymentInstrument",myJson);
    	offlinePaymentModel.set("status","PENDING");
    	offlinePaymentModel.set("student",$this.getIdValueJson(user));
    	offlinePaymentModel.set("createdOn",new Date());
    	offlinePaymentModel.set("receiptFor",$this.getIdValueJson(1));
    	
    	var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistgrid();
    	var docStore = feeOfflinePaymentDocGrid.getStore();
    	offlinePaymentModel.set("noOfDocuments",docStore.data.length);
    	
       	var docArray = [];
       	if (docStore.data.items != null
       			&& docStore.data.items.length > 0) {
       		Ext.each(docStore.data.items, function(val) {
       			if(val.raw!=undefined){
       				var newData = {
           					"document" : $this.getIdValueJson(val.raw.docId),
           			};
       			}else{
       				var newData = {
           					"document" : $this.getIdValueJson(val.data.documentId),
           			};
       			}
       			
       			docArray.push(newData);
       		});
       	}
       	offlinePaymentModel.set("offlinePaymentDocuments",docArray);
    	if (value.id == null ||value.id == "") {
    		submitUrl = SERVERURL.PATH_OFFLINE_PAYMENT_DETAIL_CREATE; 
    	} else {
    		offlinePaymentModel.set("id",value.id);
    		submitUrl = SERVERURL.PATH_OFFLINE_PAYMENT_DETAIL_UPDATE;
    	}

    	var submitData = Ext.encode(offlinePaymentModel.data);
    	if(offlinePaymentModel.get('amount')>0){
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		offlineForm.down('#SubmitBtn').setDisabled(true);
    		Ext.Ajax.request({
    			url: submitUrl,
    			jsonData: submitData,
    			method: 'POST',
    			success: function(response) {
    				Ext.getBody().unmask();
    				var offlinePaymentHeaderId = Ext.decode(response.responseText); 
    				if (value.id == null ||value.id == "") {
    					showSuccessMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_CREATED_SUCCESSFULLY'));
    				} else {
    					showSuccessMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_UPDATE_SUCCESSFULLY'));
    				}
    				form.reset();
    				feeOfflinePaymentDocGrid.getStore().removeAll();
    				feeOfflinePaymentDocGrid.setVisible(false);
    				var feeOfflinePaymentGrid = $this.getFeeofflinepaymentdetailgrid();
    				feeOfflinePaymentGrid.getSelectionModel().deselectAll(true);
    				feeOfflinePaymentGrid.getStore().load({
    					params : {
							 studentId: user
							},
	       					callback: function(rec, operation, success) {
	       						if (success) {}
	       					}
    				});
    				$this.removeDynamicOfflineFields();
    				  var receivingCurrency=offlineForm.down('#receivingCurrency');
    				  var receivingCurrencyStore=receivingCurrency.getStore();
    				  receivingCurrencyStore.load({
    					  callback: function(record, operation, success) {
    						  if (success) {
    							  for(i=0;i<record.length;i++)
    							  {
    								  if(record[i].data.name=='INR')
    								  {
    									  receivingCurrency.setValue(record[i].data.id);
    								  }
    							  }
    						  }
    					  }
    				  });
    			}
    		});
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_ZERO'));
    	}
    },
    getResetOfflinePaymentDetailForm : function(){
    	var form = this.getManageofflinepaymentdetailform().getForm();
    	form.getFields().each(function(field) {
    		field.reset();	
    	});
    	var formObj = this.getManageofflinepaymentdetailform();
    	formObj.fireEvent("render",formObj);
    	this.removeDynamicOfflineFields();

    }, //******* remove dynamic fileds*************
    removeDynamicOfflineFields : function(){
 	   var form = this.getManageofflinepaymentdetailform();
 	   var offlinePaymentheaderPanel = form.down('#offlinePaymentheaderPanel');
 	   for(var i=offlinePaymentheaderPanel.items.length-1; i>0;i--){
 		  offlinePaymentheaderPanel.remove(offlinePaymentheaderPanel.items.items[i]);
 	   }
 	   form.doLayout();
    },
    offlinePaymentDeleteDocument:function(){
     	 var $this=this;
     	 var user = $this.getCurrentlyLoggedInUserInfoForPortal().student.id; 
     	 var offlineForm = $this.getManageofflinepaymentdetailform();
     	 var offlinePaymentId = offlineForm.getForm().findField('id').value;
      	 var offlinePaymentDocumentgrid= $this.getFeeofflinepaymentdocumentlistgrid();
      	 if (offlinePaymentDocumentgrid.getSelectionModel().getCount() > 0) {
      		 var records = offlinePaymentDocumentgrid.getSelectionModel().getSelection();
      		 var ids=[];
      		 var offlinePaymentDocumentId=[];
      		if(!isNullOrEmpty(offlinePaymentId)){
      			Ext.Array.each(records,function(value){
         			 ids.push(value.data.id);
         			offlinePaymentDocumentId.push(value.data.offlinePaymentDocumentId);
         		 });
      			var submitURL = SERVERURL.PATH_OFFLINE_PAYMENT_DOCUMENT_DELETE+'?id='+ids.join()+'&offlinePaymentHeaderId='+offlinePaymentId+'&offlinePaymentDocumentId='+offlinePaymentDocumentId.join();
      		}else{
      			Ext.Array.each(records,function(value){
         			 ids.push(value.data.documentId);
         		 });
      			var submitURL = SERVERURL.OFFLINE_PAYMENT_DELETEMULTIPLEDOCUMENTS+'?id='+ids.join();
      		}
      		 showConfirmMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
      			 if (btn == 'yes'){
      				 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      				 Ext.Ajax.request({
      					 method: "GET",
      					 type: 'rest',
      					 url : submitURL,
      					 headers: {
      						 'Content-Type': 'application/json'
      					 },
      					 success: function(form, action) {
      						 Ext.getBody().unmask();
      						 showSuccessMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS'),getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));	 
      						 offlinePaymentDocumentgrid.store.reload();
      						 offlinePaymentDocumentgrid.getSelectionModel().deselectAll(true);

      						 var feeOfflinePaymentGrid = $this.getFeeofflinepaymentdetailgrid();
      						 feeOfflinePaymentGrid.getSelectionModel().deselectAll(true);
      						 feeOfflinePaymentGrid.getStore().load({
      							 params : {
      								 studentId: user
      							 },
      							 callback: function(rec, operation, success) {
      								 if (success) {}
      							 }
      						 });
      					 }
      				 });
      			 }
      		 });
      	 } else {
      		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
      	 }
       },
       getDownloadFileForOfflinePaymentDocument : function(documentId){
       	if(!isNullOrEmpty(documentId)){
       		var csvForm = Ext.create('Ext.form.Panel'); 
       		csvForm.getForm().submit({
       			target: '_blank',
       			method:'GET',
       			params :{
       				access_token : Ext.Ajax.defaultHeaders.access_token
       			},
       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
       			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
       			standardSubmit :true
       		});
       	}
       },
       documentReportDocumentZip : function() {
    	   var $this = this;
    	   var offlinePaymentDocumentGrid = $this.getFeeofflinepaymentdocumentlistgrid();
    	   if (offlinePaymentDocumentGrid.getSelectionModel().getCount() > 0) {
    		   var records = offlinePaymentDocumentGrid.getSelectionModel().getSelection();
    		   var dispatchZipName = "Offline Payment  Documents";
    		   var saveModel=[];  
    		   for(var i in records){
    			   if(!isNullOrEmpty(records[i].get('path'))) {
    				   saveModel.push(records[i].get('path'));
    			   }
    			   showConfirmMessage(getFileManagementTranslation('DOCUMENT'),getFileManagementTranslation('DOWNLOAD_ALL_DOCUMENT_MSG'),
    					   function(btn, text) {
    				   if (btn == 'yes') {
    					   var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
    					   $this.getController('Academia.controller.document.DocumentController')
    					   .downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
    					   if(Ext.isDefined(Ext.ComponentQuery.query('offlinepaymentdocumentlistwindow')))
    						   {
    						   var offlineDocWin = Ext.ComponentQuery.query('offlinepaymentdocumentlistwindow');
    						   offlineDocWin[0].close();
    						   }
    				   }
    			   });

    		   }
    	   }
    	   else {
    		   $this.hideWindowMask();
    		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	   }
       },
       resetOfflinePaymentSearchDetails : function(){
       	var form = this.getFeeofflinepaymentdetailform().getForm();
       	form.getFields().each(function(field) {
       		if(field.name!='pageSize'){
       			field.reset();	
       		}
       	});
       	var startDate = form.findField('startDate');
    	var tillDate = form.findField('tillDate');
    	startDate.setMinValue(false);
    	startDate.setMaxValue(false);
    	tillDate.setMinValue(false);
    	tillDate.setMaxValue(false);
       },
       disableOfflinePaymentGridButton:function(column,selected) {
    	var grid = this.getFeeofflinepaymentdetailgrid();
    	var addButtonItemId = grid.down('#btnAdd');
    	var editButtonItemId = grid.down('#btnEdit');
    	var viewButtonItemId = grid.down('#btnView');
    	var deleteButtonItemId = grid.down('#btnDelete');
    	deleteButtonItemId.setDisabled(false);
    	if(selected.length!=0){
    		var status=selected[0].getData().status;
        	if(status == 'PENDING'){
        		editButtonItemId.setDisabled(false);
        		deleteButtonItemId.setDisabled(false);
        	}else{
        		editButtonItemId.setDisabled(true);
        		deleteButtonItemId.setDisabled(true);
        	}	
    	}
    },
    getOfflinePaymentSearchList : function(obj){
    	var $this = this;
    	var form = $this.getFeeofflinepaymentdetailmainform();
    	userType = form.down('#userType').getValue();

		$this.getFeeofflinepaymentdetailmaingrid().config.searchFilterForm = form;
		$this.getFeeofflinepaymentdeatilforapplicantgrid().config.searchFilterForm = form

    	if(userType == 'APPLICANT'){
    		var applicantGrid = $this.getFeeofflinepaymentdeatilforapplicantgrid();
        	if(!applicantGrid.isHidden()){
        		this.loadFeeOfflinePaymentMainDetail(applicantGrid);
        		if(applicantGrid.getSelectionModel()){
        			if(applicantGrid.getSelectionModel().getSelection().length>0)
        				applicantGrid.getSelectionModel().deselectAll();
        		}
        	}
    	}
    	if(userType == 'STUDENT'){
    		var studentGrid = $this.getFeeofflinepaymentdetailmaingrid();
        	if(!studentGrid.isHidden()){
        		this.loadFeeOfflinePaymentMainDetail(studentGrid);
        		if(studentGrid.getSelectionModel()){
        			if(studentGrid.getSelectionModel().getSelection().length>0)
        				studentGrid.getSelectionModel().deselectAll();
        		}
        	}
    	}
    	
    	
    
    	
    },
    loadFeeOfflinePaymentMainDetail:function(grid){
    	
    	$this =this;
    	var form = $this.getFeeofflinepaymentdetailmainform();
    	form.down('#searchBtn').setDisabled(true);
    	var getForm = form.getForm();
    	var getFormValues = getForm.getValues();
    	var store = grid.getStore();
    	var userTypeField = getForm.findField('userType');
    	var userType = form.down("#userType").getValue();
    	if(userTypeField.getValue() =='STUDENT')
    	{
    		var form = $this.getFeeofflinepaymentdetailmainform();
    		var receiptNo = form.down("#receiptNo").getValue();
    		var status = form.down("#status").getValue();
    		var startDate = form.down("#startDate").getValue();
    		if(startDate != null){
                startDate= new Date(startDate);
                startDate = Ext.Date.format(startDate, 'Y-m-d');
            }
    		var endDate = form.down("#tillDate").getValue();
    		if(endDate != null){
                endDate= new Date(endDate);
                endDate = Ext.Date.format(endDate, 'Y-m-d');
            }
    		var student = form.down("#student").getValue();
    		var academyLocationId = this.getCurrentAcademyLocation();
    		var grid = $this.getFeeofflinepaymentdetailmaingrid();
    		grid.getSelectionModel().deselectAll(true);
    		var values = form.getForm().getValues();
    		var store =  grid.getStore();
    		if(!isNullOrEmpty(status)){
    			store.getProxy().extraParams = {
    				userType: userType,
    				receiptNo: receiptNo,
    				status: status,
    				fromDate: startDate,
    				tillDate: endDate,
    				studentId: student,
    				academyLocationId:academyLocationId
    			}; 
    		}else{
    			store.getProxy().extraParams = {
    				userType: userType,
    				receiptNo: receiptNo,
    				fromDate: startDate,
    				tillDate: endDate,
    				studentId: student,
    				academyLocationId:academyLocationId
    			}; 
    		}
    		$this.resetPageSetting(store);
    		store.load({
				  callback: function(record, operation, success) {
					  form.down('#searchBtn').setDisabled(false); 
					  }
				  });
    	}
    	else
    	{
    		var form = $this.getFeeofflinepaymentdetailmainform();
    		var receiptNo = form.down("#receiptNo").getValue();
    		var status = form.down("#status").getValue();
    		var startDate = form.down("#startDate").getValue();
    		if(startDate != null){
                startDate= new Date(startDate);
                startDate = Ext.Date.format(startDate, 'Y-m-d');
            }
    		var endDate = form.down("#tillDate").getValue();
    		if(endDate != null){
                endDate= new Date(endDate);
                endDate = Ext.Date.format(endDate, 'Y-m-d');
            }
    		var applicant = form.down("#applicant").getValue();
    		var academyLocationId = this.getCurrentAcademyLocation();
    		var grid = $this.getFeeofflinepaymentdeatilforapplicantgrid();
    		grid.getSelectionModel().deselectAll(true);
    		var values = form.getForm().getValues();
    		var store =  grid.getStore();
    		if(!isNullOrEmpty(status)){
    			store.getProxy().extraParams = {
    				userType: userType,
    				receiptNo: receiptNo,
    				status: status,
    				fromDate: startDate,
    				tillDate: endDate,
    				applicantId: applicant,
    				academyLocationId:academyLocationId
    			}; 
    		}else{
    			store.getProxy().extraParams = {
    				userType: userType,
    				receiptNo: receiptNo,
    				fromDate: startDate,
    				tillDate: endDate,
    				applicantId: applicant,
    				academyLocationId:academyLocationId
    			}; 
    		}
    		$this.resetPageSetting(store);
    		store.load({
				  callback: function(record, operation, success) {
					  form.down('#searchBtn').setDisabled(false); 
					  }
				  });

    	}
    },
    resetOfflinePaymentMainSearchDetails : function(){
    	var $this = this;
    	var form = this.getFeeofflinepaymentdetailmainform().getForm();
    	var student = form.findField('student');
    	var applicant = form.findField('applicant');
    	form.getFields().each(function(field) {
    		if(field.name!='pageSize'){
    			field.reset();
    		}
    	});
    	var userTypeField = form.findField('userType');
    	var userTypeStore = userTypeField.getStore();

    	userTypeStore.load({
    		callback: function(rec) {
    			for (var i in rec) {
    				userTypeField.setValue(rec[1].data.value);
    				$this.getShowAndHide(form,rec[1].data.value);
    			}
    		},
    		params : {
    			screenType:'offlinePayment'
    		}
    	});
    	student.setVisible(false);
    	applicant.setVisible(true);
    	var startDate = form.findField('startDate');
    	var tillDate = form.findField('tillDate');
    	startDate.setMinValue(false);
    	startDate.setMaxValue(false);
    	tillDate.setMinValue(false);
    	tillDate.setMaxValue(false);
    },
    //  view Offline Payment main details******************
    ViewOfflinePaymentMainDetails : function(){
  	   var $this = this;
  	   
  	   var studentGrid = $this.getFeeofflinepaymentdetailmaingrid();
  	   var applicantGrid = $this.getFeeofflinepaymentdeatilforapplicantgrid();
  	   var grid=null;
  	   if(!studentGrid.isHidden()){
  		   grid =studentGrid ;
  		 if (grid.getSelectionModel().getCount() > 0) {
  		   var record = grid.getSelectionModel().getSelection()[0];
  		   $this.openOfflinePaymentMainDetails();
  		   var form = $this.getManageofflinepaymentdetailmainform();
  		   var id = record.get("id");
  		   var studentId = record.get("student.id");
  		 var studentCode = record.get("student.code");
  		 var studentCodefield=form.down('#studentCode');
  		 studentCodefield.setValue(studentCode);
  		   if(record.data.status!='PENDING'){
  			   form.down('#generateReceipt').setVisible(false);
  			   form.down('#rejectBtn').setVisible(false);
  		   }
  		   var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
  		   Ext.Ajax.request({
  			   method: "GET",
  			   type: 'rest',
  			   url: editUrl,
  			   params: {
  				  offlinePaymentId: id
  			   },
  			   success: function(response, action) {
  				   var offlinePaymentData = Ext.JSON.decode(response.responseText);
 				   var frm = form.getForm();
 				   frm.findField('id').setValue(id);
 				   frm.findField('studentId').setValue(studentId);
 				   toggleReadOnlyFormItems(frm, true);
 				   form.down("#offlinePaymentProofNo").setValue(offlinePaymentData.proofno);
 				   var receivingCurrency = form.down("#receivingCurrency");
 				 // receivingCurrency.setValue(offlinePaymentData.currency.name);
				  /* var receivingCurrencyStore=receivingCurrency.getStore();
	 				  receivingCurrencyStore.load({
	 					  callback: function(record, operation, success) {
	 						  if (success) {
	 						   receivingCurrency.setValue(offlinePaymentData.currency.id);
	 						  }
	 					  }
	 				  });*/
 				   var instrumentLength= offlinePaymentData.offlinePaymentInstrument.length;
 				   if(instrumentLength>0){
 					   var fieldPanel=form.down('#offlinePaymentMainheaderPanel');
 					   Ext.Array.each(offlinePaymentData.offlinePaymentInstrument,function(value,index){
 						   if(index>0){
 							   $this.addOfflinePaymentMainHeaderContainer();	
 						   }
 						   var filedContainer = fieldPanel.items.items[index];
 						   var paymentMode = filedContainer.items.items[0];
 						   var paymentModeStore = paymentMode.getStore();
 						   paymentModeStore.load({
 							   callback: function(rec, operation, success) {
 								   if (success) {
 									   paymentMode.setValue(value.paymentMode.id);
 									   paymentMode.setReadOnly(true);
 								   }
 							   }
 						   });

 						   filedContainer.items.items[1].setValue(value.instrumentNo);
 						   filedContainer.items.items[1].setReadOnly(true);
 						   filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
 						   filedContainer.items.items[2].setReadOnly(true);
 						   filedContainer.items.items[3].setValue(value.amount);
 						   filedContainer.items.items[3].setReadOnly(true);
 						   var drawnOnBank = filedContainer.items.items[4];

 						   var drawnOnBankStore = drawnOnBank.getStore();
 						   drawnOnBankStore.load({
 							   callback: function(rec, operation, success) {
 								   if (success) {
 									   drawnOnBank.setValue(value.instrumentBank.id);
 								   }
 							   }
 						   });
 						   filedContainer.items.items[4].setReadOnly(true);
 						   filedContainer.items.items[5].setVisible(false);
 						   filedContainer.items.items[6].setValue(value.id);
 					   });

 				   }
 				  receivingCurrency.setRawValue(offlinePaymentData.currency.name);
 				  receivingCurrency.setReadOnly(true);
 				  receivingCurrency.allowBlank=true;
 				  var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistmaingrid();
				   feeOfflinePaymentDocGrid.getStore().removeAll();
				   feeOfflinePaymentDocGrid.getStore().load({
							params : {
								 offlinePaymentId: id
								},
		       					callback: function(rec, operation, success) {
		       						if (success) {}
		       					}
		       				});
				   feeOfflinePaymentDocGrid.setVisible(true);
  			   }
  				  
  		   });
  	   }
  		 else{
   		   showWarningMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
   	   }
  		
  	   
  	   }
  	
  	   if(!applicantGrid.isHidden()){
  		   grid =applicantGrid ;
  		 if (grid.getSelectionModel().getCount() > 0) {
    		   var record = grid.getSelectionModel().getSelection()[0];
    		   $this.openOfflinePaymentMainDetails();
    		   var form = $this.getManageofflinepaymentdetailmainform();
    		   
    		   //to be ewplace with new one
    		   
    		   var appCode = record.get("applicationCode");
               var studentCodefield=form.down('#studentCode');
               studentCodefield.setValue(appCode);
      		   var id = record.get("id");
      		   var studentId = record.get("applicationId");
      		   if(record.data.status!='PENDING'){
      			   form.down('#generateReceipt').setVisible(false);
      			   form.down('#rejectBtn').setVisible(false);
      		   }
      		   var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
      		   Ext.Ajax.request({
      			   method: "GET",
      			   type: 'rest',
      			   url: editUrl,
      			   params: {
      				  offlinePaymentId: id
      			   },
      			   success: function(response, action) {
      				   var offlinePaymentData = Ext.JSON.decode(response.responseText);
     				   var frm = form.getForm();
     				   frm.findField('id').setValue(id);
     				   frm.findField('applicantId').setValue(studentId);
     				   toggleReadOnlyFormItems(frm, true);
     				   form.down("#offlinePaymentProofNo").setValue(offlinePaymentData.proofno);
     				   var receivingCurrency = form.down("#receivingCurrency");
     				 // receivingCurrency.setValue(offlinePaymentData.currency.name);
    				  /* var receivingCurrencyStore=receivingCurrency.getStore();
    	 				  receivingCurrencyStore.load({
    	 					  callback: function(record, operation, success) {
    	 						  if (success) {
    	 						   receivingCurrency.setValue(offlinePaymentData.currency.id);
    	 						  }
    	 					  }
    	 				  });*/
     				   var instrumentLength= offlinePaymentData.offlinePaymentInstrument.length;
     				   if(instrumentLength>0){
     					   var fieldPanel=form.down('#offlinePaymentMainheaderPanel');
     					   Ext.Array.each(offlinePaymentData.offlinePaymentInstrument,function(value,index){
     						   if(index>0){
     							   $this.addOfflinePaymentMainHeaderContainer();	
     						   }
     						   var filedContainer = fieldPanel.items.items[index];
     						   var paymentMode = filedContainer.items.items[0];
     						   var paymentModeStore = paymentMode.getStore();
     						   paymentModeStore.load({
     							   callback: function(rec, operation, success) {
     								   if (success) {
     									   paymentMode.setValue(value.paymentMode.id);
     									   paymentMode.setReadOnly(true);
     								   }
     							   }
     						   });

     						   filedContainer.items.items[1].setValue(value.instrumentNo);
     						   filedContainer.items.items[1].setReadOnly(true);
     						   filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
     						   filedContainer.items.items[2].setReadOnly(true);
     						   filedContainer.items.items[3].setValue(value.amount);
     						   filedContainer.items.items[3].setReadOnly(true);
     						   var drawnOnBank = filedContainer.items.items[4];

     						   var drawnOnBankStore = drawnOnBank.getStore();
     						   drawnOnBankStore.load({
     							   callback: function(rec, operation, success) {
     								   if (success) {
     									   drawnOnBank.setValue(value.instrumentBank.id);
     								   }
     							   }
     						   });
     						   filedContainer.items.items[4].setReadOnly(true);
     						   filedContainer.items.items[5].setVisible(false);
     						   filedContainer.items.items[6].setValue(value.id);
     					   });

     				   }
     				  receivingCurrency.setRawValue(offlinePaymentData.currency.name);
     				  receivingCurrency.setReadOnly(true);
     				  receivingCurrency.allowBlank=true;
     				  var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistmaingrid();
    				   feeOfflinePaymentDocGrid.getStore().removeAll();
    				   feeOfflinePaymentDocGrid.getStore().load({
    							params : {
    								 offlinePaymentId: id
    								},
    		       					callback: function(rec, operation, success) {
    		       						if (success) {}
    		       					}
    		       				});
    				   feeOfflinePaymentDocGrid.setVisible(true);
      			   }
      				  
      		   });

    		   
    		   
  	   }
  		else{
   		   showWarningMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
   	   }

  	   }
  	   
  	   
  	   
  	   
  	  
  	 /*  if (grid.getSelectionModel().getCount() > 0) {
  		   var record = grid.getSelectionModel().getSelection()[0];
  		   $this.openOfflinePaymentMainDetails();
  		   var form = $this.getManageofflinepaymentdetailmainform();
  		   var id = record.get("id");
  		   var studentId = record.get("student.id");
  		   if(record.data.status!='PENDING'){
  			   form.down('#generateReceipt').setVisible(false);
  			   form.down('#rejectBtn').setVisible(false);
  		   }
  		   var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
  		   Ext.Ajax.request({
  			   method: "GET",
  			   type: 'rest',
  			   url: editUrl,
  			   params: {
  				  offlinePaymentId: id
  			   },
  			   success: function(response, action) {
  				   var offlinePaymentData = Ext.JSON.decode(response.responseText);
 				   var frm = form.getForm();
 				   frm.findField('id').setValue(id);
 				   frm.findField('studentId').setValue(studentId);
 				   toggleReadOnlyFormItems(frm, true);
 				   form.down("#offlinePaymentProofNo").setValue(offlinePaymentData.proofno);
 				   var receivingCurrency = form.down("#receivingCurrency");
 				 // receivingCurrency.setValue(offlinePaymentData.currency.name);
				   var receivingCurrencyStore=receivingCurrency.getStore();
	 				  receivingCurrencyStore.load({
	 					  callback: function(record, operation, success) {
	 						  if (success) {
	 						   receivingCurrency.setValue(offlinePaymentData.currency.id);
	 						  }
	 					  }
	 				  });
 				   var instrumentLength= offlinePaymentData.offlinePaymentInstrument.length;
 				   if(instrumentLength>0){
 					   var fieldPanel=form.down('#offlinePaymentMainheaderPanel');
 					   Ext.Array.each(offlinePaymentData.offlinePaymentInstrument,function(value,index){
 						   if(index>0){
 							   $this.addOfflinePaymentMainHeaderContainer();	
 						   }
 						   var filedContainer = fieldPanel.items.items[index];
 						   var paymentMode = filedContainer.items.items[0];
 						   var paymentModeStore = paymentMode.getStore();
 						   paymentModeStore.load({
 							   callback: function(rec, operation, success) {
 								   if (success) {
 									   paymentMode.setValue(value.paymentMode.id);
 									   paymentMode.setReadOnly(true);
 								   }
 							   }
 						   });

 						   filedContainer.items.items[1].setValue(value.instrumentNo);
 						   filedContainer.items.items[1].setReadOnly(true);
 						   filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
 						   filedContainer.items.items[2].setReadOnly(true);
 						   filedContainer.items.items[3].setValue(value.amount);
 						   filedContainer.items.items[3].setReadOnly(true);
 						   var drawnOnBank = filedContainer.items.items[4];

 						   var drawnOnBankStore = drawnOnBank.getStore();
 						   drawnOnBankStore.load({
 							   callback: function(rec, operation, success) {
 								   if (success) {
 									   drawnOnBank.setValue(value.instrumentBank.id);
 								   }
 							   }
 						   });
 						   filedContainer.items.items[4].setReadOnly(true);
 						   filedContainer.items.items[5].setVisible(false);
 						   filedContainer.items.items[6].setValue(value.id);
 					   });

 				   }
 				  receivingCurrency.setRawValue(offlinePaymentData.currency.name);
 				  receivingCurrency.setReadOnly(true);
 				  receivingCurrency.allowBlank=true;
 				  var feeOfflinePaymentDocGrid = $this.getFeeofflinepaymentdocumentlistmaingrid();
				   feeOfflinePaymentDocGrid.getStore().removeAll();
				   feeOfflinePaymentDocGrid.getStore().load({
							params : {
								 offlinePaymentId: id
								},
		       					callback: function(rec, operation, success) {
		       						if (success) {}
		       					}
		       				});
				   feeOfflinePaymentDocGrid.setVisible(true);
  			   }
  				  
  		   });
  	   }else{
  		   showWarningMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
  	   }*/
     },// ************ Offline Payment HeaderRender for add and delete button*************
    addOfflinePaymentMainHeaderContainer: function() {
    	   var this$ = this;
    	   var form = this$.getManageofflinepaymentdetailmainform();
    	   var getform = form.getForm();
    	   var panelItem = new Array();
    	   panelItem.push({
    		   xtype: 'fieldcontainer',
    		   width: '100%',
    		   layout: {
    			   type: 'hbox',
    			   align: 'bottom'
    		   },
    		   items: [{
    			   xtype: 'customcombobox',
    			   itemId: 'paymentMode',
    			   name: 'paymentMode',
    			   width: 135,
    			   labelAlign: 'top',
    			   store: 'feeandpayment.FeePaymentMode',
    			   valueField: 'id',
    			   displayField: 'value',
    			   allowBlank: false,
    			   forceSelection:true
    		   }, {
    			   xtype:'textfield',
    			   enableKeyEvents : true,
    			   itemId: 'instrumentsNo',
    			   labelAlign: 'top',
    			   width: 130,
    			   name: 'instrumentsNo',
    			   maxLength: 40,
    			   allowBlank: false,
    			   listeners:{
 					keypress : function(e, t){
 						try {
 							if (window.event) {
 								var charCode = window.event.keyCode;
 							}else if (e) {
 								var charCode = e.which;
 							}else { return true; }

 							if (charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90) && (charCode < 97 || charCode > 122)) {
 								return t.preventDefault();
 							}
 						}
 						catch (err) {
 							alert(err.Description);
 						} 
 					}
 				}
    		   },{
    			   xtype:'datefield',
    			   itemId:'instrumentDate',
    			   name:'instrumentDate',
    			   width: 130,
    			   labelAlign: 'top',
    			   allowBlank: false,
    			   listeners: {
   					render: function(field) {
   						return dateFormatRender(field);
   					}
   				}
    		   },{
    			   xtype: 'numberfield',
    			   itemId: 'amount',
    			   labelAlign: 'top',
    			   name: 'amount',
    			   width: 130,
    			   minValue: 0,
    			   allowDecimals:false,
    			   hideTrigger:true,
    			   maxLength:10,
    			   mouseWheelEnabled:false,
    			   allowBlank: false
    		   },{
    			   xtype: 'customcombobox',
    			   itemId: 'drawnOnBank',
    			   name: 'drawnOnBank',
    			   width: '31%',
    			   labelAlign: 'top',
    			   store: 'feeandpayment.receipts.DrawnOnBank',
    			   valueField: 'id',
    			   displayField: 'value',
    			   allowBlank: false,
    			   typeAhead:true,
    			   forceSelection:true

    		   },{
    			   xtype: 'button',
    			   glyph: ICONGLYPH.DELETEGLYPH,
    			   cls: 'CustomBodyBtnReject',
    			   tooltip: getCommonTranslation('DELETETOOLTIP'),
    			   listeners:{
    				   click:function(obj){
    					   var frm = obj.ownerCt.ownerCt.ownerCt;
    					   var offlinePaymentheaderPanel = frm.down('#offlinePaymentheaderPanel');
    					   var container = obj.up('fieldcontainer');
    					   offlinePaymentheaderPanel.remove(container);
    					   getform.isValid();
    					   frm.doLayout();
    				   }
    			   }
    		   },{
 			   xtype:'hidden',
 			   name:'instrumentId'
 		   }]    
    	   });
    	   var offlinePaymentheaderMainPanel = form.down('#offlinePaymentMainheaderPanel');
    	   if(offlinePaymentheaderMainPanel.items.length<3){
    		   offlinePaymentheaderMainPanel.add(panelItem);
    		   var panelItem = offlinePaymentheaderMainPanel.items.items;
    		   for(var i in panelItem){
    			   panelItem[i].items.items[2].setMinValue(false);
    			   panelItem[i].items.items[2].setMaxValue(new Date());
    		   }
    	   }
    	   form.doLayout();
       },
       //********Open New Tab for Add Offline Details **********
       openOfflinePaymentMainDetails : function(){
     	  $this = this;
     	  var contentpanel = $this.getContentpanel();
     	  var offlinePaymentDetailMainFrom=Ext.widget("manageofflinepaymentdetailmainform");
     	  var tabName = getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS');
     	  var newTab = this.getTabReferenceByTabTitle(tabName);
     	  var getcontroller=$this.getController('menu.CoreERPNavigationController');
     	  var getTab=getcontroller.getTab(tabName);
     	  if(getTab!=null){
     		  contentpanel.remove(getTab, true);
     	  }
     	  openTab(contentPanel, tabName, offlinePaymentDetailMainFrom, CONSTANTS.MENU_COLOR_FIVE);
     	  contentPanel.setActiveTab(newTab);
       },
       getDownloadFileForOfflinePaymentMainDocument : function(documentId){
          	if(!isNullOrEmpty(documentId)){
          		var csvForm = Ext.create('Ext.form.Panel'); 
          		csvForm.getForm().submit({
          			target: '_blank',
          			method:'GET',
          			params :{
          				access_token : Ext.Ajax.defaultHeaders.access_token
          			},
          			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
          			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
          			standardSubmit :true
          		});
          	}
          },
          documentReportDocumentMainZip : function() {
       	   var $this = this;
       	   var offlinePaymentDocumentGrid = $this.getFeeofflinepaymentdocumentlistmaingrid();
       	   if (offlinePaymentDocumentGrid.getSelectionModel().getCount() > 0) {
       		   var records = offlinePaymentDocumentGrid.getSelectionModel().getSelection();
       		   var dispatchZipName = "Offline Payment  Documents";
       		   var saveModel=[];  
       		   for(var i in records){
       			   if(!isNullOrEmpty(records[i].get('path'))) {
       				   saveModel.push(records[i].get('path'));
       			   }
       			   showConfirmMessage(getFileManagementTranslation('DOCUMENT'),getFileManagementTranslation('DOWNLOAD_ALL_DOCUMENT_MSG'),
       					   function(btn, text) {
       				   if (btn == 'yes') {
       					   var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
       					   $this.getController('Academia.controller.document.DocumentController')
       					   .downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
       					   if(Ext.isDefined(Ext.ComponentQuery.query('offlinepaymentdocumentlistmainwindow')))
						   {
						   var offlineDocWin = Ext.ComponentQuery.query('offlinepaymentdocumentlistmainwindow');
						   offlineDocWin[0].close();
						   }
       				   }
       			   });

       		   }
       	   }
       	   else {
       		   $this.hideWindowMask();
       		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
       	   }
          },
          fnpChangeAcademyLocationEventManagePayment:function(obj,record){
       	   var $this = this;
       	   var formLayout = $this.getManagepaymentform();
       	   var studentNameCombo= formLayout.down('#student');
       	   var thirdPartyNameCombo= formLayout.down('#thirdParty');
       	   var sponsorsNameCombo= formLayout.down('#sponsors');
       	   var applicantNameCombo= formLayout.down('#applicant');
       	   var userIdNameCombo= formLayout.down('#userId');
       	   var receivingCurrencyCombo= formLayout.down('#paymentCurrency');
       	   var depositedBankAcountCombo= formLayout.down('#depositedBankAcount');
       	   var scholarshipNameCombo= formLayout.down('#scholarship');
       	   var scholarshipStudentNameCombo= formLayout.down('#scholarshipStudent');
       	   var ourBankAccountCombo= formLayout.down('#drawnOnBank');


       	   studentNameCombo.reset();
       	   thirdPartyNameCombo.reset();
       	   sponsorsNameCombo.reset();
       	   applicantNameCombo.reset();
       	   userIdNameCombo.reset();
       	   depositedBankAcountCombo.reset();
       	   scholarshipNameCombo.reset();
       	   scholarshipStudentNameCombo.reset();
       	   ourBankAccountCombo.reset();
       	   	                	   
       	   var alids=[];
       	   if(record.length>0){
       		   for (var i in record) {
       			   if(Ext.isObject(record[i])){
       				   alids.push(record[i].get('id'));
       			   }
       			   else{
       				   alids.push(record[i]);	
       			   }
       		   }
       	   }else{
       		   alids = $this.getCurrentAcademyLocation();
       	   }
       	   
       	   $this.fnpLoadStudentApplicantSponsorCombo(studentNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(thirdPartyNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(sponsorsNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(applicantNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(userIdNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(receivingCurrencyCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorComboAutoFill(depositedBankAcountCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(scholarshipNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorCombo(scholarshipStudentNameCombo,alids.join());
       	   $this.fnpLoadStudentApplicantSponsorComboAutoFill(ourBankAccountCombo,alids.join());


       	   
       	   var scholarshipNameCombo= formLayout.down('#scholarship');
       	   scholarshipNameCombo.reset();
       	   var scholarshipStudentNameCombo= formLayout.down('#scholarshipStudent');
       	   scholarshipStudentNameCombo.reset();
       	   scholarshipStudentNameCombo.setDisabled(true);
          },
          fnpLoadStudentApplicantSponsorCombo:function(formCombo,ids){
       	   var store = formCombo.getStore();
       	   store.getProxy().extraParams = {
       		   academyLocationIds:ids
       	   };
       	   store.load();
          },
          fnpLoadStudentApplicantSponsorComboAutoFill:function(formCombo,ids){
       	   var store = formCombo.getStore();
       	   store.load({
       		   params:{
       			   defaultAccount:0,
       			   academyLocationIds:ids
       		   },
       		   callback: function(record, operation, success) {
       			   if (success) {
       				   for(i=0;i<record.length;i++)
       				   {
       					   if(record[i].data.sequence!=null)
       					   {
       						   formCombo.setValue(record[i].data.id);
       					   }
       				   }
       			   }
       		   }
       	   });
          },
          ViewAvailablePaymentDetails : function(){
        	  var $this = this;
        	  var grid = this.getFeeofflinepaymentdetailmaingrid();
        	  var records = grid.getSelectionModel().getSelection();
        	  if (!records || records.length === 0){
        	  	  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	   }
        	  var studentId = records[0].get('student.id');
        	  var rawAmount = records[0].get('amount');
        	  var amount = Number(rawAmount.replace(/[^0-9.]/g, ''));
        	  //var amount  = records[0].get('amount');
        	  var id=records[0].get('id');
        	  var offlinePaymentHeaderId = id;
        	  Ext.Ajax.request({
        		              method: "GET",
        		              type: 'rest',
        		              url: SERVERURL.FIND_AVAILABLE_SFC_CREDIT_AMOUNT+"?studentId="+studentId,//studentId
        		  success : function(res, action) {
        			  var data = Ext.decode(res.responseText);
        			  var  totalAvailableSfcAmount=  data.totalAvailableSfcAmount;
        			  var financialSupportId=data.id;
        			  if(totalAvailableSfcAmount >= amount){
        				 
        				  Ext.Ajax.request({
        					              method: "POST",
        					              type: 'rest',
        					             url: SERVERURL.FIND_PATH_UPDATE_AND_CREATE_RECEIPT_FOR_SFC
        				        + "?offlinePaymentHeaderId=" + offlinePaymentHeaderId
        				        + "&financialSupportId=" + financialSupportId
        				        + "&studentId=" + studentId,
        					  success : function(res, action) {
        						  var grdStore = grid.getStore();
        						  grid.getSelectionModel().deselectAll();
        						  grdStore.load();
        						  var data = Ext.decode(res.responseText);
        						  var  totalAvailableSfcAmount=  data.totalAvailableSfcAmount;
        						  if(totalAvailableSfcAmount>=amount){

        							  showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SFC fund validation completed successfully. The receipt has been generated'));
        							  // receipt creation & Offline Payment status update 'APPROVED'
        						  } else {

        							  return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Sufficient Amount is not available in SFC Account'));

        							  //  Offline Payment status update REJECTED
        						  }


        					  }
        				                 	
        				  });
        				  
        				  
        				  showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SFC fund validation completed successfully. The receipt has been generated'));
        				 // receipt creation & Offline Payment status update 'APPROVED'
        			  } else {
        				  
        				  Ext.Ajax.request({
        					              method: "GET",
        					              type: 'rest',
        					              url: SERVERURL.PATH_OFFLINE_PAYMENT_CHANGE_STATUS+"?id="+id+"&status="+encodeURIComponent("REJECTED"),//studentId
        					  success : function(res, action) {
        						  var grdStore = grid.getStore();
        						  grid.getSelectionModel().deselectAll();
        						  grdStore.load();
        						  var data = Ext.decode(res.responseText);
        						  var  totalAvailableSfcAmount=  data.totalAvailableSfcAmount;
        						  if(totalAvailableSfcAmount>=amount){

        							  showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SFC fund validation completed successfully. The receipt has been generated'));
        							  // receipt creation & Offline Payment status update 'APPROVED'
        						  } else {

        							  return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Sufficient Amount is not available in SFC Account'));

        							  //  Offline Payment status update REJECTED
        						  }


        					  }
        				                 	
        				  });

        				  return showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Sufficient Amount is not available in SFC Account'));
        				  //  Offline Payment status update REJECTED
        			  }
        			  

        		  }
        	                 	
        	  });

          },
          //********* Delete Offline Payment Detail records***********
          rejectOfflinePaymentDetails : function(){
          	var $this = this;
          	var form = $this.getManageofflinepaymentdetailmainform();
          	var getId = form.getForm().findField('id').value;
          		showConfirmMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'), getFeeAndPaymentCommonTranslation('REJECT_OFFLINE_PAYMENT_CONFIRM_MESSAGE'), function(btn, text) {
          			if (btn == 'yes') {
          				Ext.Ajax.request({
          					method: "GET",
          					type: 'rest',
          					url: SERVERURL.PATH_OFFLINE_PAYMENT_CHANGE_STATUS,
          					params: {
          						id: getId,
          						status:'REJECTED'
          					},
          					headers: {
          						'Content-Type': 'application/json'
          					},
          					success:function(form, action){
          						var tabName = getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_DETAILS');
         						var contentPanel = $this.getContentpanel(); //get hold of the content panel where we are adding all the tabs
         						var getcontroller=$this.getController('menu.CoreERPNavigationController');
         						var getTab=getcontroller.getTab(tabName);
         						if(getTab!=null){
         							contentPanel.remove(getTab, true);
         						}
         						if(Ext.isDefined(Ext.ComponentQuery.query('feeofflinepaymentdetailmaingrid')[0]))
         						{
         							var offlineGrid =Ext.ComponentQuery.query('feeofflinepaymentdetailmaingrid')[0];
         							offlineGrid.getStore().reload();
         							offlineGrid.getSelectionModel().deselectAll(true);
         						}
          						showSuccessMessage(getFeeAndPaymentCommonTranslation('OFFLINE_PAYMENT_PROOF'),getFeeAndPaymentCommonTranslation('REJECT_OFFLINE_PAYMENT_SUCCESS_MESSAGE'));
          					}
          				});
          			}
          		});
          	
          },
          generateOfflinePaymentDetailsReceipt : function(grid){
        	  Academia.app.getController('Academia.controller.feeandpayment.receipts.ReceiptsController');
        	  $this = this;
        	  var offlineForm = $this.getManageofflinepaymentdetailmainform();
        	  var offlinePaymentId = offlineForm.getForm().findField('id').value;
        	  if(grid.xtype == 'feeofflinepaymentdetailmaingrid')
        	  {

        		  var studentId = offlineForm.getForm().findField('studentId').value;
        		 var studentCode= offlineForm.down('#studentCode').getValue();
        		  $this.getOpenOfflineReceiptDetails(offlinePaymentId,studentId,true,studentCode);
        		  var form = $this.getManagereceiptform();
        		  var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
        		  Ext.Ajax.request({
        			  method: "GET",
        			  type: 'rest',
        			  url: editUrl,
        			  params: {
        				  offlinePaymentId: offlinePaymentId
        			  },
        			  success: function(response, action) {
        				  var receiptData = Ext.JSON.decode(response.responseText);
        				  var frm = form.getForm();
        				  var receivingCurrency = form.down("#receivingCurrency");
        				  receivingCurrency.setVisible(false);
        				  var receivingCurrencyOffline = form.down("#receivingCurrencyOfflinePayment");
        				  receivingCurrencyOffline.setVisible(true);
        				  receivingCurrencyOffline.setValue(receiptData.currency.name);

        				  var receivingCurrencyId = form.down("#receivingCurrencyOfflinePaymentId");
        				  receivingCurrencyId.setValue(receiptData.currency.id);

        				  // var receivingCurrencyStore=receivingCurrency.getStore();
        				  /*receivingCurrencyStore.load({
					  callback: function(record, operation, success) {
						  if (success) {
						   receivingCurrency.setValue(receiptData.currency.id);
						  }
					  }
				  });*/
        				  var instrumentLength= receiptData.offlinePaymentInstrument.length;

        				  if(instrumentLength>0){
        					  var fieldPanel=form.down('#receiptheaderPanel');
        					  Ext.Array.each(receiptData.offlinePaymentInstrument,function(value,index){
        						  if(index>0){
        							  $this.addReceiptHeaderContainer();	
        						  }
        						  var filedContainer = fieldPanel.items.items[index];
        						  var paymentMode = filedContainer.items.items[0];
        						  var paymentModeStore = paymentMode.getStore();
        						  paymentModeStore.load({
        							  callback: function(rec, operation, success) {
        								  if (success) {
        									  paymentMode.setValue(value.paymentMode.id);
        									  paymentMode.setReadOnly(true);
        								  }
        							  }
        						  });

        						  filedContainer.items.items[1].setValue(value.instrumentNo);
        						  filedContainer.items.items[1].setReadOnly(true);
        						  filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
        						  filedContainer.items.items[2].setReadOnly(true);
        						  filedContainer.items.items[3].allowDecimals=true;
        						  filedContainer.items.items[3].setValue(value.amount);
        						  filedContainer.items.items[3].setReadOnly(true);
        						  var drawnOnBank = filedContainer.items.items[4];

        						  var drawnOnBankStore = drawnOnBank.getStore();
        						  drawnOnBankStore.load({
        							  callback: function(rec, operation, success) {
        								  if (success) {
        									  drawnOnBank.setValue(value.instrumentBank.id);
        								  }
        							  }
        						  });
        						  filedContainer.items.items[4].setReadOnly(true);
        						  filedContainer.items.items[5].setVisible(false);
        						  filedContainer.items.items[6].setValue(value.id);
        					  });
        				  }
        			  }
        		  });
        	  }
        	  if(grid.xtype == 'feeofflinepaymentdeatilforapplicantgrid')
        	  {
        		   var applicantId = offlineForm.getForm().findField('applicantId').value;
        		  //var studentId = offlineForm.getForm().findField('studentId').value;
        		   var applicantCode=grid.getSelectionModel().selected.items[0].data.applicationCode;
        		   
        		  $this.getOpenOfflineReceiptDetails(offlinePaymentId,applicantId,false,applicantCode);
        		  var form = $this.getManagereceiptform();
        		  var editUrl = SERVERURL.PATH_FINDBY_OFFLINEPAYMENT_DETAIL;
        		  Ext.Ajax.request({
        			  method: "GET",
        			  type: 'rest',
        			  url: editUrl,
        			  params: {
        				  offlinePaymentId: offlinePaymentId
        			  },
        			  success: function(response, action) {
        				  var receiptData = Ext.JSON.decode(response.responseText);
        				  var frm = form.getForm();
        				  var receivingCurrency = form.down("#receivingCurrency");
        				  receivingCurrency.setVisible(false);
        				  var receivingCurrencyOffline = form.down("#receivingCurrencyOfflinePayment");
        				  receivingCurrencyOffline.setVisible(true);
        				  receivingCurrencyOffline.setValue(receiptData.currency.name);

        				  var raiseBillTypeField = frm.findField('raiseBillType');
        				  var raiseBillTypeStore=raiseBillTypeField.getStore();
        				
        				  var receiptFormField = frm.findField('receiptForm');
        				  var receiptFormStore = receiptFormField.getStore();
     					  raiseBillTypeStore.load({
       					   params:{
       						   screenType:'add'  
       					   },
       					   callback: function(record, operation, success) {
       						   if (success) {
       							   raiseBillTypeField.setValue(record[0].data.id);

       							   receiptFormStore.load({
       								   params : {
       									   raiseBillType : record[0].data.id
       								   },
       								   callback: function(rec, operation, success) {
       									   if (success) {
       										   receiptFormField.setValue(rec[1].data.id);
       										   // disable to smart serach validation
       									   }
       								   }
       							   });
       						   }
       					   }
       				   });
     				   
        				  var studentField = form.down("#student");
        				  studentField.setVisible(false);
        				  
        				  var applicantField = form.down("#applicant");
        				  applicantField.setVisible(true);

        				  var receivingCurrencyId = form.down("#receivingCurrencyOfflinePaymentId");
        				  receivingCurrencyId.setValue(receiptData.currency.id);

        				  // var receivingCurrencyStore=receivingCurrency.getStore();
        				  /*receivingCurrencyStore.load({
    					  callback: function(record, operation, success) {
    						  if (success) {
    						   receivingCurrency.setValue(receiptData.currency.id);
    						  }
    					  }
    				  });*/
        				  var instrumentLength= receiptData.offlinePaymentInstrument.length;

        				  if(instrumentLength>0){
        					  var fieldPanel=form.down('#receiptheaderPanel');
        					  Ext.Array.each(receiptData.offlinePaymentInstrument,function(value,index){
        						  if(index>0){
        							  $this.addReceiptHeaderContainer();	
        						  }
        						  var filedContainer = fieldPanel.items.items[index];
        						  var paymentMode = filedContainer.items.items[0];
        						  var paymentModeStore = paymentMode.getStore();
        						  paymentModeStore.load({
        							  callback: function(rec, operation, success) {
        								  if (success) {
        									  paymentMode.setValue(value.paymentMode.id);
        									  paymentMode.setReadOnly(true);
        								  }
        							  }
        						  });

        						  filedContainer.items.items[1].setValue(value.instrumentNo);
        						  filedContainer.items.items[1].setReadOnly(true);
        						  filedContainer.items.items[2].setValue(dateRender(value.instrumentDate));
        						  filedContainer.items.items[2].setReadOnly(true);
        						  filedContainer.items.items[3].setValue(value.amount);
        						  filedContainer.items.items[3].setReadOnly(true);
        						  var drawnOnBank = filedContainer.items.items[4];

        						  var drawnOnBankStore = drawnOnBank.getStore();
        						  drawnOnBankStore.load({
        							  callback: function(rec, operation, success) {
        								  if (success) {
        									  drawnOnBank.setValue(value.instrumentBank.id);
        								  }
        							  }
        						  });
        						  filedContainer.items.items[4].setReadOnly(true);
        						  filedContainer.items.items[5].setVisible(false);
        						  filedContainer.items.items[6].setValue(value.id);
        						  var radioButton = form.down("#isAutoSettlementReceipt");
        						  radioButton.setValue({onlineAutoAdjustment:true});
        						  radioButton.setReadOnly(true);
        					  });
        				  }
        			  }
        		  });

        	  }
        	  
          },
          loadDFRForManagePaymentFieldVisibility: function(autoSettle,submitAdjustment){
        		var $this = this;
        		Ext.Ajax.request({
        			type: 'rest',
        			async: false,
        			url: SERVERURL.COMMON_FORM_FIELD_INFO,
        			params: {
        				screenName: 'managepaymentform',
        				academyLocationId: this.getCurrentAcademyLocation(),
        				languageCode:'en'
        			},
        			method: 'GET',
        			success: function(res, action) {
        				var response = Ext.decode(res.responseText);
        				if( Object.keys(response).length > 0 ){
        					var records=response.managepaymentform;
        					for(i in records){    
        						if(!isNullOrEmpty(autoSettle)){
        							if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='isAutoSettlementPayment' && records[i].isVisible==true){
            							autoSettle.setVisible(true);
            							break;
            						}else{
            							autoSettle.setVisible(false);
            						}
        						}
        					}
        					for(i in records){
        						if(!isNullOrEmpty(submitAdjustment)){
    							if(records[i].formFieldInputType=='button' && records[i].formFieldId=='SubmitAndAdjustmentBtn' && records[i].isVisible==true){
        							submitAdjustment.setVisible(true);
        							break;
        						}else{
        							submitAdjustment.setVisible(false);
        						}
    						}
        					}
        				}
        			}
        			
        		});
        		
        	},
        	//************ disableAcademyLocationPivileges****************  
        	disablePaymentAcademyLocationPivileges: function(form,permissionsMap) {
       	   var associatedAcadLocationIds = new Array();
       	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
       	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       	   var fnpMultiBrandCampusName = form.findField('fnpMultiBrandCampusNamePayment');
       	   fnpMultiBrandCampusName.setVisible(false);
       	   Ext.each(permissionList, function(privilege) {	
       		   if (privilege === 'MAP_ACADEMY_LOCATIONS') {
       			   if(!isNullOrEmpty(fnpMultiBrandCampusName)){
       				   fnpMultiBrandCampusName.setVisible(true);
       			   }        		
       		   }
       	   });
          },
          fnpChangePaymentAcademyLocationEvent:function(obj,record){
       	   var $this = this;
       	   var formLayout = $this.getPaymentsearchform();
       	   var studentNameCombo= formLayout.down('#student');
       	   var thirdPartyNameCombo= formLayout.down('#thirdParty');
       	   var sponsorsNameCombo= formLayout.down('#sponsors');
       	   var applicantNameCombo= formLayout.down('#applicant');
       	   var userIdNameCombo= formLayout.down('#userId');
       	   var scholarshipNameCombo= formLayout.down('#scholarship');
       	   var billNoCombo = formLayout.down('#billNo');
       	   var paymentNoCombo = formLayout.down('#paymentVoucherNo');
       	   var billedUserTypeId = formLayout.down("#billFor").getValue();
       	   var billedUserType = formLayout.down("#billFor").getRawValue();
		     	   
       	   
       	   studentNameCombo.reset();
       	   thirdPartyNameCombo.reset();
       	   sponsorsNameCombo.reset();
       	   applicantNameCombo.reset();
       	   userIdNameCombo.reset();
       	   scholarshipNameCombo.reset();
       	   billNoCombo.reset();
       	   paymentNoCombo.reset();
       	   if(obj.hidden!=true){
       		   var alids=[];
           	   if(record.length>0){
           		   for (var i in record) {
           			   if(Ext.isObject(record[i])){
           				   alids.push(record[i].get('id'));
           			   }
           			   else{
           				   alids.push(record[i]);	
           			   }
           		   }
           	   }else{
           		   alids = $this.getCurrentAcademyLocation();
           	   }  
       	   }else{
       		   alids = $this.getCurrentAcademyLocation(); 
       	   }
       	   
       	   
       	   if(isArray(alids)){
       		   alidsValue =  alids.join(); 
       	   }else{
       		   alidsValue = alids;
       	   }
       	   
       	   var studentNameComboStore = studentNameCombo.getStore();
       	   studentNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };

       	    var billNoComboStore = billNoCombo.getStore();
          	   billNoComboStore.getProxy().extraParams = {
           		   academyLocationId: alidsValue,
           		   billedUserTypeId:billedUserTypeId,
           		   billedUserType:billedUserType,
           		   screenType:"Payment",
           		   id:""
          	   };                	  
          	  // billNoComboStore.load();  
          	   
          	   
           var paymentNoComboStore =paymentNoCombo.getStore();
           paymentNoComboStore.getProxy().extraParams = {
       		   academyLocationId: alidsValue,
       		   billedUserTypeId:billedUserTypeId,
       		   billedUserType:billedUserType,
       		   screenType:"Payment",
       		   id:""
      	   };                	  
          // paymentNoComboStore.load();  
          	   
       	   var thirdPartyNameComboStore = thirdPartyNameCombo.getStore();
       	   thirdPartyNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };
       	   //thirdPartyNameComboStore.load();

       	   var sponsorsNameComboStore = sponsorsNameCombo.getStore();
       	   sponsorsNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };
       	   //sponsorsNameComboStore.load();

       	   var applicantNameComboStore = applicantNameCombo.getStore();
       	   applicantNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };

       	   var userIdNameComboStore = userIdNameCombo.getStore();
       	   userIdNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };
       	   //userIdNameComboStore.load();
       	   
       	   var scholarshipNameComboStore =scholarshipNameCombo.getStore();
       	   scholarshipNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };
       	   //scholarshipNameComboStore.load();

       	   var programNameCombo= formLayout.down('#program');
       	   programNameCombo.reset();
       	   var programNameComboStore = programNameCombo.getStore();
       	   programNameComboStore.getProxy().extraParams = {
       		   academyLocationIds: alidsValue
       	   };
       	   
          },
          //*********************** Payment listing******************************
          getShowAndHidePaymentsForResetList : function(obj,record,indexSponsor,fromLink){

        	  var form = this.getPaymentsearchform();
        	  var structure = this.getPaymentHeaderStructure();
        	  var billFor = form.down("#billFor").getValue();
        	  var billType = form.down("#billType").getValue();

        	  structure.down("#paymentlistforpcandserviceprovided").setVisible(false);
        	  structure.down("#paymentlistforscholarship").setVisible(false);
        	  structure.down("#paymentlistforserviceprovided").setVisible(false);
        	  structure.down("#paymentlistforservicereceived").setVisible(false);
        	  structure.down("#paymentlistfordependedfeehead").setVisible(false);
        	  structure.down("#paymentlistforpcandserviceprovidedforapplicant").setVisible(false);
        	  structure.down("#paymentlistforpcandserviceprovidedforsponsor").setVisible(false);

        	  var thirdPartyField = form.down("#thirdParty");
        	  var applicantField = form.down("#applicant");
        	  var sponsorField = form.down("#sponsors");
        	  var userField = form.down("#userId");
        	  var studentField = form.down("#student");

        	  var scholarshipStudentField = form.down("#scholarshipStudent");
        	  var scholarshipField = form.down("#scholarship");

        	  var programCombo = form.down("#program");
        	  var batchCombo = form.down("#batch");
        	  var sectionCombo = form.down("#section");

        	  applicantField.setVisible(false);
        	  sponsorField.setVisible(false);
        	  thirdPartyField.setVisible(false);
        	  userField.setVisible(false);
        	  studentField.setVisible(false);
        	  programCombo.setVisible(false);
        	  batchCombo.setVisible(false);
        	  sectionCombo.setVisible(false);

        	  scholarshipStudentField.setVisible(false);
        	  scholarshipField.setVisible(false);

        	  applicantField.reset();
        	  if(isNullOrEmpty(fromLink))
        	  {
        		  sponsorField.reset();
        	  }
        	  thirdPartyField.reset();
        	  userField.reset();
        	  studentField.reset();
        	  programCombo.reset();
        	  batchCombo.reset();
        	  sectionCombo.reset();

        	  scholarshipStudentField.reset();
        	  scholarshipField.reset();

        	  studentField.setVisible(true);
        	  programCombo.setVisible(true);
        	  batchCombo.setVisible(true);
        	  batchCombo.setDisabled(true);
        	  sectionCombo.setVisible(true); 
        	  sectionCombo.setDisabled(true);
        	  structure.down("#paymentlistforpcandserviceprovided").setVisible(true);
          },
          /*****START:Applied Permssion Management for Payment Import****************/
          disablePaymentImportTab: function(paymentHeaderStructure,permissionsMap){
        	  var associatedAcadLocationIds = new Array();
        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	  var paymentUploadDownloadStructureTab = false;
        	  Ext.each(permissionList, function(privilege) {
        		  if (privilege === 'IMPORT_BULK_PAYMENTS') {
        			  paymentUploadDownloadStructureTab = true;       		
        		  }
        	  });

        	  this.showPaymentTab(paymentUploadDownloadStructureTab, paymentHeaderStructure);
          },
          showPaymentTab : function(paymentUploadDownloadStructureTab, paymentHeaderStructure) {
       	   var panelItem = new Array();
       	   var $this = this;
       	   var newcont = paymentHeaderStructure.items.items.length;
       	   var insertPosition = newcont + 1;
       	   if(paymentUploadDownloadStructureTab) {
       		   panelItem.push({
       			   xtype:'tabpanel',
       			   itemId:'allVisibleTP',
       			   plain: true,
       			   style:{overflow:'hidden !important',margin:'0!important'},
       			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
       			   frame: false,
       			   border:false,
       			   defaults: {
       				   labelAlign: 'top'
       			   },
       			   items:[{
       				xtype:'paymentheaderstructure',
       				title: getCommonTranslation('SEARCH'),
       				tabCls: 'right-tab',
       				listeners: {
 						 activate: function(me, eOpts){
							 var  contentPanelMain = $this.getContentpanel().getActiveTab();
							 if(contentPanelMain){
								 setTimeout(function(){
 								 contentPanelMain.scrollBy(0,1);
 								 contentPanelMain.scrollBy(0,-1);
 							 },5); 
							 }
						 }
					 }
       		},{
       				   xtype:'importdownloadpaymentform',
       				   title: getFeeAndPaymentCommonTranslation('IMPORT_PAYMENT'),
       				   tabCls: 'right-tab'
       			   }]
       		   });

       	   } else {
       		   panelItem.push({
       			   xtype:'tabpanel',
       			   itemId:'allVisibleTP',
       			   plain: true,
       			   style:{overflow:'hidden !important',margin:'0!important'},
       			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
       			   frame: false,
       			   border:false,
       			   defaults: {
       				   labelAlign: 'top'
       			   },
       			   items:[{
          				xtype:'paymentheaderstructure',
           				title: getCommonTranslation('SEARCH'),
           				tabCls: 'right-tab',
           				listeners: {
     						 activate: function(me, eOpts){
    							 var  contentPanelMain = $this.getContentpanel().getActiveTab();
    							 if(contentPanelMain){
    								 setTimeout(function(){
     								 contentPanelMain.scrollBy(0,1);
     								 contentPanelMain.scrollBy(0,-1);
     							 },5); 
    							 }
    						 }
    					 }
           		}]
       		   });

       	   }
       	   paymentHeaderStructure.insert(insertPosition,panelItem);
          },
     /*****END:Applied Permssion Management for Payment Import****************/
          //************ disableAcademyLocationPivileges****************  
          fncDisablePaymentImportALPivileges: function(form, permissionsMap) {
        	  var associatedAcadLocationIds = new Array();
        	  associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
        	  var $this = this;
			  var academyLocationId = $this.getCurrentAcademyLocation();
        	  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	  var fnpMultiBrandCampusName = form.down('#fnpMultiBrandCampusItemId');
        	  fnpMultiBrandCampusName.setVisible(false);
        	  fnpMultiBrandCampusName.reset();
        	  Ext.each(permissionList, function(privilege) {	
        		  if (privilege === 'MAP_ACADEMY_LOCATIONS') {
        			  if(!isNullOrEmpty(fnpMultiBrandCampusName)){
        				  var fnpBrandCampusId = form.down('#fnpMultiBrandCampusItemId');
        				  var ALComboStore = fnpBrandCampusId.getStore();
        				  ALComboStore.load({
        					  callback: function(records, operation, success) {
        						  if (success) {
        							  for(var i in records){
        								  if(records[i].data.id == academyLocationId){
        									  fnpBrandCampusId.setValue(academyLocationId);
        								  }
        							  }
        						  }
        					  }
        				  });
        				  fnpMultiBrandCampusName.setVisible(true);
        			  }        		
        		  }
        	  });
          },
          getDownloadtemplate: function(){
			   var temForm = this.getDownloadtemplatewinform();
			   var tempFormValue = temForm.getForm().findField('importUtilityMasterId').getValue();
			   var csvForm = Ext.create('Ext.form.Panel'); 
			   csvForm.getForm().submit({
				   target: '_blank',
				   method:'POST',
				   params :{
					   access_token : Ext.Ajax.defaultHeaders.access_token,
					   code:tempFormValue
				   },
				   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_TEMPLATE_URL,
				   standardSubmit :true
			   });
			   this.getCloseDownloadtemplateWin();
		   },

		   /** Download upload form change **/

		   downloadUploadFormChange: function(cb, nv, ov){
			   var $this = this;
			   var downloadTemplateForm = $this.getDownloadpaymentform();
			   var uploadTemplateForm = $this.getImportpaymentform();
			   var grid = $this.getImportlistpayments();
			   if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
				   /*Ext.ComponentQuery.query('studentpncattendancestructure#studentattendanceId')[0].show();
	   Ext.ComponentQuery.query('facultypncattendancestructure#facultyattendanceId')[0].hide();*/

				   uploadTemplateForm.hide();
				   downloadTemplateForm.show();
				   grid.setVisible(false);

				   downloadTemplateForm.down("#paymentmode").reset();
				   downloadTemplateForm.down('#autoSettlementType').reset();
				   downloadTemplateForm.down("#raiseBillType").reset();
				   downloadTemplateForm.down("#paymentFor").reset();

			   }else{
				   //uploadTemplateForm.reset();
//				   $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
				   var uploadoptionradiogroupform  = $this.getImportpaymentuploadoptionradiogroup();
				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
					   isUploadAll: false
				   });
				   downloadTemplateForm.hide();
				   uploadTemplateForm.show();
				   grid.setVisible(true);

//				   uploadTemplateForm.down("#moduleName").reset();
				   uploadTemplateForm.down("#uploadFileField").reset();

			   }
		   },
		   getDownloadFile : function(documentId,fileType){

			   if(!isNullOrEmpty(documentId)){
				   var csvForm = Ext.create('Ext.form.Panel'); 
				   csvForm.getForm().submit({
					   target: '_blank',
					   method:'POST',
					   params :{
						   access_token : Ext.Ajax.defaultHeaders.access_token
					   },
					   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
					   standardSubmit :true
				   });
			   }
		   },
      	loadGridStoreFaculty: function(gridItemId, url, params) {
            var this$ = this;
            var personProfile = this.getContentpanel();
            var grid=null;
            
            Ext.ComponentQuery.query('facultyprofile').forEach(function(entry) {
			    if(entry.isHidden() == false){
			    	var tabPanel=entry.down('tabpanel');
			    	grid=tabPanel.activeTab.down('grid');
			    }
			    
			});

//            var facutyProfile =  Ext.ComponentQuery.query('facultyprofile')[0]
 //           var facProfile = facutyProfile.down('tabpanel')
   //         var grid=facProfile.activeTab.down('grid');

            
            if (grid) {
            	var store = grid.getStore();
                store.getProxy().api.read = url;
                store.getProxy().extraParams = params;
            	 if(portalId == 2){
        			 setTimeout(function(){
        			var check=grid.selModel.view.selModel.mode=='MULTI';
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 if(length != null && length != ""){
   	 					 for(var i = 0; i < length; i++){
   	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='receiptStatus'){
   	 							 gridColumns[i].destroy();
   	 						 }
   	 					 }
   	 					store.load({ 
   	                 	callback: function(record, operation, success) {
   	                 		if (record.length > 0) {
   	                 			for(var i in record){
   	                 				if (record[i].data.whetherDisplayTotal != false) {
   	                 					this$.toggleGridSummaryRow(grid,true); 
   	                 				}
   	                 			}
   	                 		}else{
   	                 			this$.toggleGridSummaryRow(grid,false);
   	                 		}
   	                 	}
   	                 });
   	 				} 
   	 				},300);
   	 				 
        			 
        		 } if(portalId == 1){
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 var academyLocationId = this.getCurrentAcademyLocation();
				   
   	 				 Ext.Ajax.request({
			    		  method: "GET",
			    		  type: 'rest',
			    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
			    		  params:{
			    			  academyLocationId:academyLocationId
			    		  },
			    		  success: function(response) {
			    			  if(response){
			    				  result=response.responseText;	
			    			  }
			    	    		  if(result=="false"){
			    	 				 var gridColumns=grid.columns;
			    	 				 var length = gridColumns.length;
			    	 				 if(length!=null && length!=""){
			    	 					 for(var i=0; i<length; i++){
			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
			    	 							 gridColumns[i].setVisible(false);
			    	 						 }
			    	 					 }
			    	 				 }
			    	 			  }else{
			    	 				 var gridColumns=grid.columns;
			    	 				 var length = gridColumns.length;
			    	 				 if(length!=null && length!=""){
			    	 					 for(var i=0; i<length; i++){
			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
			    	 							 gridColumns[i].setVisible(true);
			    	 						 }
			    	 					 }
			    	 				 }
			    	    	  }
			    		  }
			    	  });
   	 		
        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     					this$.toggleGridSummaryRow(grid,true); 
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 
        		 }
            	 else{
        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				if (record[i].data.whetherDisplayTotal != false) {
                     					this$.toggleGridSummaryRow(grid,true); 
                     				}
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 }
                
                
            }
    },
    getShowAndHideOffilePaymentUser : function(obj,record,form){
        var $this = this;
    	var userType = record[0].get("value");
    	var applicantField = form.down("#applicant");
    	var studentField = form.down("#student");
    	applicantField.setVisible(false);
    	studentField.setVisible(false);

    	applicantField.reset();
    	studentField.reset();

    	if(userType==getFeeAndPaymentCommonTranslation('STUDENT')){
    		studentField.setVisible(true);
    		form.down("#feeofflinepaymentdetailmaingrid").setVisible(true);
    		form.down("#feeofflinepaymentdeatilforapplicantgrid").setVisible(false);
    		 var studentGrid = $this.getFeeofflinepaymentdetailmaingrid();
	
                if(!studentGrid.isHidden()){
	
                        this.loadFeeOfflinePaymentMainDetail(studentGrid);
	
                        if(studentGrid.getSelectionModel()){
	
                                if(studentGrid.getSelectionModel().getSelection().length>0)
	
                                        studentGrid.getSelectionModel().deselectAll();
	
                        }
	
                }
    	}
    	if(userType==getFeeAndPaymentCommonTranslation('APPLICANT')){
    		applicantField.setVisible(true);
    		form.down("#feeofflinepaymentdeatilforapplicantgrid").setVisible(true);
    		form.down("#feeofflinepaymentdetailmaingrid").setVisible(false);
    		var applicantGrid = $this.getFeeofflinepaymentdeatilforapplicantgrid();
	
                if(!applicantGrid.isHidden()){
	
                        this.loadFeeOfflinePaymentMainDetail(applicantGrid);
	
                        if(applicantGrid.getSelectionModel()){
	
                                if(applicantGrid.getSelectionModel().getSelection().length>0)
	
                                        applicantGrid.getSelectionModel().deselectAll();
	
                        }
	
                }
	
            }
	
            },
    	
      
    	 getShowAndHide : function(form,value){
    		 var form = this.getFeeofflinepaymentdetailmainform();
    		 var applicantField = form.down("#applicant");
    		  var applicantGrid = $this.getFeeofflinepaymentdeatilforapplicantgrid();
    		 if(value==getFeeAndPaymentCommonTranslation('APPLICANT')){
    		
    	    		applicantField.setVisible(true);
    	    		this.loadFeeOfflinePaymentMainDetail(applicantGrid);
    	    		form.down("#feeofflinepaymentdeatilforapplicantgrid").setVisible(true);
    	    		form.down("#feeofflinepaymentdetailmaingrid").setVisible(false);
    	    	}
    	 },
    	 receiptSearch : function(userType,userId)
    	 {
    		 var receiptNostore = this.getStore('feeandpayment.payment.FeeOfflinePaymentReceiptNoStore');
    		 receiptNostore .getProxy().extraParams = {
    			 userType : userType,
    			 userId : userId,
    		 };
  		   receiptNostore.load();
    	 },
    	 showHidepaymentOnFieldFromDFR:function(value){
    		 var $this = this;
    		 var form = this.getManagepaymentform();
    		 var paymentOn = form.down('#paymentOn');
    		 var paymentOnText =  form.down('#paymentOnText');
    		 Ext.Ajax.request({
 				type: 'rest',
 				async: false,
 				url: SERVERURL.COMMON_FORM_FIELD_INFO,
 				params: {
 					screenName: 'managepaymentform',
 					academyLocationId: this.getCurrentAcademyLocation(),
 					languageCode:'en'
 				},
 				method: 'GET',
 				success: function(res, action) {
 					var response = Ext.decode(res.responseText);
 					if( Object.keys(response).length > 0 ){
 						var records=response.managepaymentform;
 						var payementMode = $this.getManagepaymentform().down('#paymentmode').getValue();
 						var payementTo = $this.getManagepaymentform().down('#paymentFor').getDisplayValue();
 						for(i in records){
 							if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='paymentOn' && records[i].isVisible==true  && payementMode.paymentmode=='BANK'){
 								if($this.managepaymentFormMode=='VIEW'){
 									paymentOn.setVisible(false);
 									paymentOnText.setVisible(true);
 	 								if(!isNullOrEmpty(records[i].formFieldLabel)){
 	 									paymentOnText.setFieldLabel(records[i].formFieldLabel);
 	 								}
 	 								if(records[i].isMandatory){
 	 									var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
 	 									paymentOnText.setFieldLabel(records[i].formFieldLabel+''+allowblankFalse);
 	 								}
 	 								break;
 								}else{
 									paymentOn.setVisible(true);
 									break;
 								}
 							}
 							else {
 								paymentOn.setVisible(false);
 								paymentOnText.setVisible(false);
 							}
 						}
 					}
 				}
 			});
    	 }
    	 
    	
});
