/**
 * @author kamlesh
 */
Ext.define('Academia.controller.gradeMaster.GradeMasterController', {
   // extend: 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
    stores: ['campaign.CampaignsStructureStore','gradeMaster.GradeStatusStore','gradeMaster.GradeTypeNameValueStore',
             'gradeMaster.GroupNameValueStore', 'common.AcademyStore', 'common.AcademyLocationByAcademyId', 'campaign.MediaStructureStore', 
             'common.ProgramByAcademyLocationStore', 'common.UsersComboStore','gradeMaster.GradeGroupMapping','gradeMaster.ExamResultStatusStore'],
    models: ['campaign.CampaignCoverageGridModel','gradeMaster.GradeMasterModel','gradeMaster.GroupMasterModel', 'common.IdValueCodeDataModel', 
             'organization.LocationAddress', 'common.IdValueDataModel'],//'
    views: ['gradeMaster.GradeMasterTabStructure', 'baselayout.contentarea.ContentPanel','gradeMaster.group.GroupMasterGrid','gradeMaster.group.GradeGroupMappingWindow','gradeMaster.grade.GradeMasterGrid'],
    config:{
   	 /*
       	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
        		   	 */
        	   	/**
        	        * @cfg {Array}  EXAMINATIONCENTER_PERMISSION array (required)
        	        * The array of permissions to use for Access control wise enabling and disabling buttons.
        	        * @accessor
        	        */
    	GRADE_MASTER_GROUP_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('GRADE_MASTER_GROUP_PRIVILEGES'),
		GRADEMASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('GRADEMASTER_PRIVILEGES') 
    },
    refs: [ {
		        ref: 'grademastertabstructure',
		        selector: 'grademastertabstructure'
	    	},{
		        ref: 'groupmasteraddform',
		        selector: 'groupmasteraddform'
	    	},{
		        ref: 'grademasteraddform',
		        selector: 'grademasteraddform'
	    	},{
		        ref: 'groupMasterAddForm',
		        selector: 'groupmasteraddform form'
	    	},{
		        ref: 'searchresultgrid',
		        selector: 'searchresultgrid'
	    	},{
	           	 ref: 'contentPanel',
	        	 selector: 'contentPanel'
	         },{
	           	 ref: 'groupmastergrid',
	        	 selector: 'groupmastergrid'
	         },{
            	 ref: 'groupmastergridItemId',
            	 selector: 'searchresultgrid[itemId=groupmastergridItemId]'
             },{
            	 ref: 'grademastersearchItemId',
            	 selector: 'searchresultgrid[itemId=grademastersearchItemId]'
             },{
            	 ref: 'gradegroupmappingwindow',
            	 selector: 'gradegroupmappingwindow'
             },{
            	 ref: 'gradeGroupMappingForm',
            	 selector: 'gradegroupmappingwindow form'
             },{
            	ref:'grademastergrid',
            	selector:'grademastergrid'
            }],
    init: function(application) {
        this.control({
        	'grademasteraddform':{
        		afterrender:function(form){
    				$this = this;
    			form.body.on('click',function() {
  						$this.hideInvalidIconFromField(form);
			       });
					var associatedAcadLocationIds = new Array();       
					form.down('#editableTransferMarkstoGradeId').setVisible(false);                    
				    associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,$this.getGRADEMASTER_PERMISSIONS()); 
					Ext.each(permissionList, function(privilege) {     
					     
				    if (privilege === 'EDITABLE_GRADE') 
					{
				       form.down('#editableTransferMarkstoGradeId').setVisible(true);
				    }else{form.down('#editableTransferMarkstoGradeId').setVisible(false); }
    			  });
    			},
             },
	        'groupmasteraddform  button[itemId=groupMasterAddButtonId]': {
	            click: this.saveUpdateGroup
	        },
	        'groupmasteraddform  button[itemId=groupMasterCancelButtonId]': {
	            click: function(){
	            this.getGroupmasteraddform().close();	
	            }
	        },
	        'grademasteraddform  button[itemId=gradeMasterAddButtonId]': {
	            click: this.saveUpdateGrade
	        },
	        'grademasteraddform  button[itemId=gradeMasterResetButtonId]': {
	            click: function(obj){	
	            	
	            	var form=obj.up('form').getForm();
                   
	            	form.reset();
	            	form.findField('contributionInTheTotalCredits').setVisible(false);
	                form.findField('contributeInTheSgpaCgpa').setVisible(false);
					form.findField('editableTransferMarkstoGradeId').setDisabled(true);   
	            	
	            	
	            }
	        },
			 'grademastersearch customcombobox[itemId=gradeStatus]':{
				afterrender:function(obj){
					obj.getStore().load();
				}
			
			},
	        'grademastersearch customcombobox[itemId=gradeTypeItemId]':{
   			 select:function(obj,rec){
   				 var data=rec[0].data.value;
   				 var form=obj.up('form').getForm();
   				 var gradeField=form.findField('grade');
   				 gradeField.enable();
   				 gradeField.getStore().getProxy().extraParams = {
   					gradeType : data
   				   };
   				gradeField.getStore().load();
   				var gradeStatusField=form.findField('gradeStatus');
   	   			gradeStatusField.enable();
   	   			gradeStatusField.clearValue();
   	   			gradeStatusField.getStore().getProxy().extraParams = {
   					 id: data
   				   };
   	   			gradeStatusField.getStore().load();
   	   			
   			  
   			 }
		 },
		 'grademastersearch customcombobox[itemId=gradeItemId]':{
   			 select:function(obj,rec){
   				 var data=rec[0].data.id;
   				 var form=obj.up('form').getForm();
   				 var groupNameValueField=form.findField('groupNameValue');
   				 groupNameValueField.enable();
   				 //TODO Need rest call for group name on the bases of grade
   				/* groupNameValueField.getStore().getProxy().extraParams = {
   					 id: data
   				   };
   				 groupNameValueField.getStore().load();*/
   			 }
		 },
	        'grademasteraddform  radiogroup[itemId=hasGroupRadioItemId]': {
	            change:function(obj, newValue, oldValue, eOpts ){
	            	var form=this.getGrademasteraddform().getForm();
	            	var maxPermField=form.findField('maxPercent');
	            	var minPermField=form.findField('minPercent');
	            	if(newValue.hasGroup){
	            		maxPermField.reset();
	            		maxPermField.allowBlank=true;
	            		maxPermField.hide();
	            		
	            		minPermField.allowBlank=true;
	            		minPermField.reset();
	            		minPermField.hide();
	            	}else if(!newValue.hasGroup){
	            		maxPermField.show();
	            		maxPermField.allowBlank=false;
	            		maxPermField.setFieldLabel(getExaminationTranslation('MAX_PERMISSIBLE_PERCENTAGE')+'<span class="required" style="color:red"> *</span>');
	            		
	            		minPermField.show();
	            		minPermField.allowBlank=false;
	            		minPermField.setFieldLabel(getExaminationTranslation('MIN_PERMISSIBLE_PERCENTAGE')+'<span class="required" style="color:red"> *</span>');
	            	}
	            }
	        },
	        'searchresultgrid[itemId=groupmastergridItemId] button[itemId=searchResultGridBtnAdd]':{
	        	click:function(){
	        		this.showAddGroupFormWindow();
	        	}
	        },
	        'searchresultgrid[itemId=groupmastergridItemId] button[itemId=searchResultGridBtnDelete]':{
	        	click:function(){
	        		this.deleteGroupData();
	        	}
	        },
	        'searchresultgrid[itemId=groupmastergridItemId] button[itemId=searchResultGridBtnEdit]':{
	        	click:function(){
	        		this.editGroupData();
	        	}
	        },
	        'searchresultgrid[itemId=groupmastergridItemId] button[itemId=searchResultGridBtnAddMoreDetail]':{
	        	click:function(){
	        	var $this=this;
	        	var grid = $this.getGroupmastergridItemId();
		        var records = grid.getSelectionModel().getSelection()[0];
		        if (grid.getSelectionModel().getCount() > 0) {
		        	var gradeCombo=Ext.ComponentQuery.query('customcombobox#comboGradeType')[0];
		        	var gradeComboValue=gradeCombo.getRawValue();
		        	if(gradeComboValue!="" &&gradeComboValue!=null){
		        		/**
		   				 * Load data in  Mapping Grade and group window
		   				 */
		        		var store=$this.getStore('gradeMaster.GradeGroupMapping');
		        		store.getProxy().extraParams = {
		        			gradeType:gradeComboValue 
		   				 };
		   				 store.load();
		   				/**
		   				 * open Mapping Grade and group window
		   				 */
		   				$this.openGradeGroupMappingWindow();
		   				var gradeGroupForm=$this.getGradeGroupMappingForm().getForm();
		   			    gradeGroupForm.findField('groupId').setValue(records.data.ID);
		   				
		   				/**
		   				 * Rest CAll for item Selector selected values
		   				 */
		   				submitUrl=SERVERURL.GRADE_GROUP_MAPPING_ITEMSELECTOR_SELECTED_DATA_URL;
		   				Ext.Ajax.request({
		   					type : 'rest',
		   					url : submitUrl,
		   					method : 'GET',
		   					params:{
		   						groupId:records.data.ID,
		   						gradeType:gradeComboValue
		   					},
		   					success : function(obj, action) {
		   					 if(obj.responseText!=""){
	        	    	   		  var data = obj.responseText;
	        	    			  var jData=Ext.JSON.decode(data);
	        	    			  var selectedGradeId=[];
	        	    			  if(jData!=null&&jData.length>0){
	        	    			  Ext.Array.each(jData, function(value) {	
	        	    				  selectedGradeId.push(value.gradeId);
	        	    			    });
	        	    			  gradeGroupForm.findField('gradeGroup').setValue(selectedGradeId);
	        	    			  }
		   					  }
		   					}
		   				});
		        	}else {
		   	   		 showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('SELECT_GRADE_TYPE')); 
		   	   	 }
		        }else {
			   		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			   	 }
	          }
	        },
	        'gradegroupmappingwindow button[itemId=btnGradeMappingSave]':{
	        	click:function(){
	        		this.saveGradeGroupMapping();
	        	}
	        },
	        'gradegroupmappingwindow button[itemId=btnGradeMappingCancel]':{
	        	click:function(){
	        		this.getGradegroupmappingwindow().close();
	        	}
	        },
	   		 /*'searchresultgrid[itemId=groupmastergridItemId]':{
				 render:function(grid){
	                 this.gridRenderFunction(grid);
	                 this.genericCBGridAccessControlValidation(grid,this.getGRADE_MASTER_GROUP_PERMISSION());
	                 this.loadGridAndSearchPrograms();
	              }    
			 },*/
			 'grademasteraddform customcombobox[itemId=gradeTypeItemId]':{
				 select:function(obj,rec){
					 var gradeType=rec[0].data.value;
					 var isSpecialGrade=rec[0].data.secondCheck;
					 var form=obj.up('form').getForm();
					 this.resetFormFields(form);
					 this.changeLabelOnTheBasesOfGradeType(form,gradeType,isSpecialGrade);
					 this.changeLabelOntheBaeseofSpecialGrade(form,true);
					 
					 var gradeRangeFromFld = form.findField('gradeRangeFrom');
					 var gradeRangeToFld = form.findField('gradeRangeTo');
					 var gradePointFld = form.findField('gradePoint');
					 
					 /*this.setAllowBlank(gradeRangeFromFld, isSpecialGrade);
					 this.setAllowBlank(gradeRangeToFld, isSpecialGrade);
					 this.setAllowBlank(gradePointFld, isSpecialGrade);*/
					 var whetherDeleteMarksRadio = form.findField('whetherDeleteMarks');
					 whetherDeleteMarksRadio.setVisible(isSpecialGrade);
					 whetherDeleteMarksRadio.setDisabled(!isSpecialGrade);
					 
					 var isSecondGrade = rec[0].data.check;
					 var secondGradePointField = form.findField('secondaryGradePoint');

					 secondGradePointField.setVisible(isSecondGrade);
					 secondGradePointField.setDisabled(!isSecondGrade);   
					 
				 }
			 },
				'grademasteraddform customcombobox[itemId=resultStatusItemId]':{
				 select:function(obj,rec){     
					 var resultStatus=rec[0].data.value;
				     var gradeType = obj.up('form').down('#gradeTypeItemId');
				     var isSpecialGrade=gradeType.lastSelection.length ?  gradeType.lastSelection[0].data.secondCheck : false;
				     if(resultStatus=='Fail')
                    { 
					 var form=obj.up('form').getForm();           
					gradeType=form.findField('gradeType').getValue();
					form.findField('editableTransferMarkstoGradeId').setReadOnly(false);  
                     this.changeLabelOnTheBasesOfGradeType(form,gradeType,isSpecialGrade);
				    }
				else{
					 var form=obj.up('form').getForm();    
					gradeType1=form.findField('gradeType').getValue();
					 var form=obj.up('form').getForm();
                     this.changeLabelOnTheBasesOfGradeType(form,gradeType1,isSpecialGrade);
					form.findField('editableTransferMarkstoGradeId').setDisabled(true);
					form.findField('editableTransferMarkstoGradeId').setReadOnly(true);   
					}
				    }
              },
              'grademasteraddform numberfield[itemId=gradeRangeFrom]': {
            	  change: function(cmp) {
            		  cmp.up('form').isValid();
            	  }
              },
              'grademasteraddform numberfield[itemId=gradeRangeTo]': {
            	  change: function(cmp) {
            		  cmp.up('form').isValid();
            	  }
              }
        });
    },
    openGradeGroupMappingWindow:function(){   
    	 var formWindow = this.getGradegroupmappingwindow();  
         if (!formWindow) {
             Ext.widget('gradegroupmappingwindow');
             formWindow = this.getGradegroupmappingwindow();
         }
         formWindow.show();
    },
    showAddGroupFormWindow: function() {
        var formWindow = this.getGroupmasteraddform();
        if (!formWindow) {
            Ext.widget('groupmasteraddform');
            formWindow = this.getGroupmasteraddform();
        }
        formWindow.show();
    },
    saveUpdateGroup: function(model, records) {
		var $this = this;
		var form = $this.getGroupMasterAddForm().getForm();
		var value = form.getValues();
		var group = new Academia.model.gradeMaster.GroupMasterModel();
		group.set("id", value.id);
		group.set("groupName", value.groupName);
		group.set("minPercent", value.minPercent);
		group.set("maxPercent", value.maxPercent);
		var submitUrl;
		if (form.findField('id').getSubmitValue() == null
				|| form.findField('id').getSubmitValue() == "") {
			submitUrl = SERVERURL.GRADE_GROUP_ADD;
		} else {
			group.set("id", value.id);
			submitUrl = SERVERURL.GRADE_GROUP_UPDATE;
		}
		var formData = Ext.encode(group.data);
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(fm, action) {
				showSuccessMessage(getExaminationTranslation('GROUP'),
						getExaminationTranslation('GROUP_SUCCESS_MSG'));
				$this.getGroupmasteraddform().close();
				$this.getGroupmastergridItemId().getStore().load();
			}
		});
    },
    saveUpdateGrade: function(model, records) {
		var $this = this;
		var grademasteradd = $this.getGrademasteraddform();
		var grid=$this.getGrademastergrid();
		var form = grademasteradd.getForm();
		var value = form.getValues();
		var grade = new Academia.model.gradeMaster.GradeMasterModel();
		grade.set("id", value.id);
		grade.set("gradeName", value.gradeName);
		grade.set("gradeType", value.gradeType);
		grade.set("minPercent", value.minPercent);
		grade.set("maxPercent", value.maxPercent);
		grade.set("hasGroup",true);/** As discussed siddarth sir feilds are by default true and disabled ; min and max permissible will be hidden*/ 
		grade.set("gradeStatus", value.gradeStatus);	
		grade.set("gradeDescription", value.gradeDescription);
		grade.set("gradeDescriptionOtherLang", value.gradeDescriptionOther);
		grade.set("resultStatus", value.resultStatus);
		grade.set("publishMarkOnTheStudentPortal", value.isPublishMarksOnSP);
		grade.set("publishGradeOnTheStudentPortal", value.isPublishGradesOnSP);
		if(value.resultStatus=='Pass'){value.editableTransferMarkstoGradeId=false;}
		grade.set("isContributeInTheSgpaCgpa", value.isContributeInTheSgpaCgpa);
		grade.set("isContributeInTheTotalCredits", value.isContributeInTheTotalCredits);
		grade.set("editableTransferMarkstoGrade", value.editableTransferMarkstoGradeId);
		grade.set("whetherSpecialGrade", form.findField('gradeType').lastSelection[0].get('secondCheck'));
		grade.set("marksRemovalSpecialGrade", value.isDeleteMarks);
		

		// Set gradeRangeFrom based on value.gradeRangeFrom or default to 0 if null
		grade.set("gradeRangeFrom", (value.gradeRangeFrom == "") ? 0 : value.gradeRangeFrom);

		// Set gradeRangeTo based on value.gradeRangeTo or default to 0 if null
		grade.set("gradeRangeTo", (value.gradeRangeTo == "") ? 0 :  value.gradeRangeTo);

		// Set gradePoint based on value.gradePoint or default to 0 if null
		grade.set("gradePoint", (value.gradePoint == "") ? 0 : value.gradePoint);
		
		grade.set("secondaryGradePoint", (value.secondaryGradePoint == "") ? 0 : value.secondaryGradePoint);

		var submitUrl;
		
		if (form.findField('id').getSubmitValue() == null
				|| form.findField('id').getSubmitValue() == "") { 
			submitUrl = SERVERURL.GRADE_MASTER_ADD;
		} else {
			grade.set("id", value.id);
			submitUrl = SERVERURL.GRADE_MASTER_UPDATE_URL;
		}
		var formData = Ext.encode(grade.data);
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(fm, action) {
				Ext.getBody().unmask();
				if(fm.responseText=='INPUT_DATA_IS_NOT_UNIQUE'){
					showWarningMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_N_RANGE_ALREADY_EXIST'));
				}else if(fm.responseText=='GRADE_RANGE_IS_NOT_UNIQUE'){
					showWarningMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_RANGE_ALREADY_EXIST'));
				}else {
					showSuccessMessage(getExaminationTranslation('GRADE'),getExaminationTranslation('GRADE_SUCCESS_MSG'));
					form.reset();
					form.findField('maxPercent').setReadOnly(false);
					form.findField('minPercent').setReadOnly(false);
				}
				grid.getStore().reload();
				var contentpanel = $this.getContentPanel();
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var tabName = getExaminationTranslation('MANAGE_GRADE');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentpanel.remove(getTab, true);
				}
			}
		});
    },
    getGroupIdJson: function(id) {
   	 if (id) return {
   		wsGradeGroup:{
   			id: id
   		}
   	 };
    },
    getGroupIdUpdateJson: function(id,name,min,max,extraId) {
      	 if (id) return {
      		     id:extraId,
        		wsGradeGroup:{
        			id: id,
        			groupName:name,
        			maxPercent:max,
        			minPercent:	min
        		}
        	 };
         },
         editGroupData:function(){
        	var $this=this;
        	var grid = $this.getGroupmastergridItemId();
	        var records = grid.getSelectionModel().getSelection()[0];
	        if (grid.getSelectionModel().getCount() > 0) {
	        	$this.showAddGroupFormWindow();
	        var form = $this.getGroupMasterAddForm().getForm();
	        	var data=records.data;
	        	form.findField('id').setValue(data.ID);
	        	form.findField('groupName').setValue(data.GROUP_NAME);
	        	form.findField('maxPercent').setValue(data.MAX_PERCENT);
	        	form.findField('minPercent').setValue(data.MIN_PERCENT);
	        }else{
    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
    		}
	        
         },
         deleteGroupData:function(){
	    	 var $this=this;
	    	 var grid = $this.getGroupmastergridItemId();
	         var records = grid.getSelectionModel().getSelection()[0];  
	         if (grid.getSelectionModel().getCount() > 0) {
	        	    var id=records.data.id;
	        	    showConfirmMessage(getExaminationTranslation('GROUP'),getExaminationTranslation('GROUP_DELETED_MSG'),
        				 function(btn, text) {
        			 if (btn == 'yes'){
	        	 Ext.Ajax.request({
	    				type: 'rest',
	    				url: SERVERURL.GRADE_GROUP_DELETE+'?id='+id,
	    				method: 'DELETE',
	    				headers: {
                             'Content-Type': 'application/json'
                        },
	    				params:{
	    					id:id
	    				},
	    				success: function(resp, action) {
	    					showSuccessMessage(getExaminationTranslation('GROUP'), getExaminationTranslation('GROUP_DELETED_MSG'));
	    					grid.getStore().reload();
	    				}
	    			});
        			 }
        		 });
	    		}else{
	    			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); // Please select a record
	    		}
	    },
	    saveGradeGroupMapping:function(){
	    	 var $this=this; 
	    	 var gradeGroupWindow=$this.getGradegroupmappingwindow();
	    	 var gradeGroupForm=$this.getGradeGroupMappingForm().getForm();
			 var formValues=gradeGroupForm.getValues();
			 var gradeCombo=Ext.ComponentQuery.query('customcombobox#comboGradeType')[0];
	         var gradeComboValue=gradeCombo.getRawValue();
			 var mapping=[];
			 var removeUrl=SERVERURL.GRADE_GROUP_REMOVE_MAPPING_URL;
			 Ext.Ajax.request({
					type : 'rest',
					url : removeUrl,
					method : 'GET',
					params:{
						gradeType:gradeComboValue,
						groupId:formValues.groupId
					},
					success : function(fm, action) {
					  if(formValues.gradeGroup!=null&&formValues.gradeGroup.length>0){
					  Ext.Array.each(formValues.gradeGroup, function(value) {
						  var groupId=parseInt(formValues.groupId);
						  var formData={
							  "groupId":groupId,
							  "gradeId":value
				          };
						  mapping.push(formData);
					    });
			  }
			  submitUrl=SERVERURL.GRADE_GROUP_CREATE_MAPPING_URL;
			  Ext.Ajax.request({
					type : 'rest',
					url : submitUrl,
					jsonData : mapping,
					method : 'POST',
					success : function(fm, action) {
						showSuccessMessage(getCommonTranslation('GROUP'),
								getExaminationTranslation('GROUP_GRADE_SUCCESS_MSG'));
						gradeGroupWindow.close();
					}
				});
			  }
		    });
	    },
	    changeLabelOnTheBasesOfGradeType: function(form, gradeType,isSpecialGrade) {
     var $this = this;
     Ext.Ajax.request({
         type: 'rest',
         url: SERVERURL.GET_STATUS_BY_GRADE_TYPE,
         method: 'GET',
         params: {
             gradeType: gradeType
         },
         success: function(jData, action) {
             var gradeRangeFromField = form.findField('gradeRangeFrom');
             var gradeRangeToField = form.findField('gradeRangeTo');
             var resultStatus = form.findField('resultStatus');
             var gradePointFld = form.findField('gradePoint');
            
   
              if (jData.responseText == getExaminationTranslation('ABSOLUTE')) {

                 gradeRangeFromField.setFieldLabel(getExaminationTranslation('MARK_RANGE_FROM'));
                 gradeRangeToField.setFieldLabel(getExaminationTranslation('MARK_RANGE_TO'));
                  if(isSpecialGrade){
	             $this.setAllowBlank(gradeRangeFromField, true);
                 $this.setAllowBlank(gradeRangeToField, true);
                 $this.setAllowBlank(gradePointFld, true);
                 }else{
	              $this.setAllowBlank(gradeRangeFromField, false);
                 $this.setAllowBlank(gradeRangeToField, false);
                 $this.setAllowBlank(gradePointFld, false);
                
                 }
                 
             } else if (jData.responseText == getExaminationTranslation('RELATIVE')) {
                 gradeRangeFromField.setFieldLabel(getExaminationTranslation('GRADE_POINT_RANGE_FROM'));
                 gradeRangeToField.setFieldLabel(getExaminationTranslation('GRADE_POINT_RANGE_TO'));
                if(isSpecialGrade){
	             $this.setAllowBlank(gradeRangeFromField, true);
                 $this.setAllowBlank(gradeRangeToField, true);
                 $this.setAllowBlank(gradePointFld, true);
                 }else{
	              $this.setAllowBlank(gradeRangeFromField, false);
                 $this.setAllowBlank(gradeRangeToField, false);
                 $this.setAllowBlank(gradePointFld, false);
                
                 }
                 
                 if (resultStatus.getValue() == 'Fail') {
                     form.findField('editableTransferMarkstoGradeId').setDisabled(false);
                 } else {
                     form.findField('editableTransferMarkstoGradeId').setDisabled(true);
                 }
             }
         }
     });
 },
	    gridRenderFunction:function(grid){
       	 grid.addButtonToolbar();
	    /*	grid.addDocked(
       			 {
       				 xtype: 'toolbar',
       				 dock:'top',
       				 items:[{
       					 xtype: 'button',
       					 itemId: 'btnAdd',
       					 tooltip : getCommonTranslation('ADD'),
       					 glyph: ICONGLYPH.ADDGLYPH
       				 }, {
       					 xtype: 'button',
       					 itemId: 'btnEdit',
       					 tooltip : getCommonTranslation('EDIT'),
       					 glyph: ICONGLYPH.EDITGLYPH
       				 }, {
       					 xtype: 'button',
       					 itemId: 'btnView',
       					 tooltip : getCommonTranslation('VIEW'),
       					 iconCls: 'view-icon'	
       				 },{
       					 xtype: 'button',
       					 itemId: 'btnDelete',
       					 cls: 'CustomToolbarBtnReject',
       					 tooltip : getCommonTranslation('DELETE'),
       					 glyph: ICONGLYPH.DELETEGLYPH
       				 }, {
       					 xtype: 'button',
       					 itemId: 'btnAddMoreDetail',
       					 tooltip : getCommonTranslation('ADD_MORE_DETAILS'),
       					 text:getCommonTranslation('ADD_MORE_DETAILS')
       				 }, {
       					 xtype: 'customcombobox',
       					 itemId: 'comboGradeType',
       					 name: 'gradeType',
       		             fieldLabel: getExaminationTranslation('GRADE_TYPE'),
       		             store:'gradeMaster.GradeTypeNameValueStore',
       		             displayField:'value',
       		             valueField:'id',
       		             emptyText:getCommonTranslation('SELECT_COMBOBOX')
       				 }]});*/
        },
        
        loadGridAndSearchPrograms : function(model, records) {
        	var quickSearchForm = this.getGroupmasteraddform();
    		var jsonFormatFormData = this.createJsonFormat(quickSearchForm,records);
    		var searchResultGrid = this.getGroupmastergridItemId();
    		var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.EXAMINATION_GRADE_GROUP_LISTING_VIEWCODE);
       	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    	},   	
    	createJsonFormat:function(quickSearchForm, record){			
    		var values = new Object();
    		values.configCode = CONSTANTS.CB.EXAMINATION_GRADE_GROUP_LISTING_CONFIGCODE;
    		var searchcriteria = new Array();
    		values.searchCriterias=searchcriteria;
    		return values;
    	},
    	
    	changeLabelOntheBaeseofSpecialGrade:function(form,isSpecialGrade){
    		var resultStatusField=form.findField('resultStatus');
    		var isSpecialGradeValue = form.findField('isSpecialGrade');
    		var contributionInTheTotalCredits=form.findField('contributionInTheTotalCredits');
    		var contributeInTheSgpaCgpa=form.findField('contributeInTheSgpaCgpa');        
    		resultStatusField.reset();
    		contributionInTheTotalCredits.reset();
    		contributeInTheSgpaCgpa.reset();
    		if(isSpecialGrade){
    			
    			isSpecialGradeValue.setValue('true');
    			resultStatusField.setVisible(true);
    			resultStatusField.allowBlank=false;
    			contributionInTheTotalCredits.setVisible(true);
    			contributeInTheSgpaCgpa.setVisible(true);
            
            
    		 resultStatusField.getStore().load();
	    			/*callback:function(record) {
	    				resultStatusField.setValue(record[0].data.value);
	    			}*/
	    		
      		}else{
    			isSpecialGradeValue.setValue('false');
    			resultStatusField.setVisible(false);
    			resultStatusField.allowBlank=true;
    			contributionInTheTotalCredits.setVisible(false);
    			contributeInTheSgpaCgpa.setVisible(false);
    		}
   	    },
   	    
   	    resetFormFields:function(form){
   	    	form.findField('gradeName').reset();
   	    	form.findField('gradeRangeFrom').reset();
   	    	form.findField('gradeRangeTo').reset();
   	    	form.findField('gradeStatus').reset();
   	    	form.findField('gradePoint').reset();
   	    	form.findField('minPercent').reset();
   	    	form.findField('maxPercent').reset();
   	    	form.findField('gradeDescription').reset();
   	    },
});
   