/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.hostel.reports.HostelFeeReportController', {
	extend : 'Academia.controller.base.BaseController',
	
	models : [],
	
	stores : ['hostel.roomallocation.UserSmartSearchByUserType','user.UserAcademyLocationStore','hostel.reports.hostelfeereport.FeePlanByAcademyLocation',
	          'hostel.reports.hostelfeereport.TransactionType','hostel.reports.hostelfeereport.BillNumberByAcademyLocation',
	          'hostel.managehostel.hostel.ManageHostelCodeName','hostel.managehostel.building.ManageBuildingCodeName',
	          'hostel.managehostel.floor.ManageFloorCodeName','hostel.reports.hostelfeereport.ReceiptNoByAcademyLocation',
	          'feeandpayment.FeePaymentMode','hostel.reports.hostelfeereport.PaymentVoucherNoByAcademyLocation',
	          'hostel.reports.hostelfeereport.HostelFeeReportGridStr','hostel.reports.hostelfeereport.HostelBillDetails','hostel.reports.hostelfeereport.HostelReceiptDetails',
	          'hostel.roomallocation.UserSmartSearchForOccupant'
	          
	          ],
	          
	views : ['hostel.reports.hostelfeereports.HostelFeeReportSearch','hostel.reports.hostelfeereports.HostelFeeReportStructure',
	         'hostel.reports.hostelfeereports.HostelFeeReportGrid','hostel.reports.hostelfeereports.HostelBillReceiptDetailWindow',
	         'hostel.reports.hostelfeereports.HostelBillDetails',
	         'hostel.reports.hostelfeereports.HostelReceiptDetails'
	         ],
	         
	refs :[{
		ref: 'hostelfeereportsearch',
		selector: 'hostelfeereportsearch'
	},{
		ref: 'hostelfeereportgrid',
		selector: 'hostelfeereportgrid'
	},{
		ref: 'hostelbillreceiptdetailwindow',
		selector: 'hostelbillreceiptdetailwindow'
	}],
	config: {
		HOSTEL_FEE_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOSTEL_FEE_REPORT_PRIVILEGES'),
    },
	
	init : function() {
		this.control({
			 'hostelfeereportstructure':{
	    			afterrender : function(structure){
	    			  var $this = this;
	    			  var result;
			    	  var grid;
			    	  var academyLocationId = $this.getCurrentAcademyLocation();
			    	  Ext.Ajax.request({
			    		  method: "GET",
			    		  type: 'rest',
			    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
			    		  params:{
			    			  academyLocationId:academyLocationId
			    		  },
			    		  success: function(response) {
			    			  if(response){
			    				  result=response.responseText;	
			    			  }
			    	    		  structure.down("hostelfeereportgrid").setVisible(true);
			    	    		  grid=structure.down("hostelfeereportgrid");
			    	    		  if(result=="false"){
			    	 				 var gridColumns=grid.columns;
			    	 				 var length = gridColumns.length;
			    	 				 if(length!=null && length!=""){
			    	 					 for(var i=0; i<length; i++){
			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='currencyTotalAmount' || gridColumns[i].dataIndex=='currencyOutstandingAmount'){
			    	 							 gridColumns[i].setVisible(false);
			    	 						 }
			    	 					 }
			    	 				 }
			    	 			  }else{
			    	 				 var gridColumns=grid.columns;
			    	 				 var length = gridColumns.length;
			    	 				 if(length!=null && length!=""){
			    	 					 for(var i=0; i<length; i++){
			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='currencyTotalAmount' || gridColumns[i].dataIndex=='currencyOutstandingAmount'){
			    	 							 gridColumns[i].setVisible(true);
			    	 						 }
			    	 					 }
			    	 				 }
			    	    	  }
			    		  }
			    	  });
	    			  var searchForm = structure.items.items[0];
	    			   structure.body.on('scroll', function(e, target) {
	    				  var pcstructure = structure.down("#hostelfeereportgrid");
	    				  var academyLocationId = $this.getCurrentAcademyLocation();
	    				  var grid = null;
	    				//  var checkCurrency =null;
	    				  
	    				  if(!pcstructure.isHidden()){
	    					  grid = pcstructure;
	    				  }
	    				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
					 });
	    				  
	    			}  
	    		  },
	    		 
			'hostelfeereportsearch combo[itemId=transactionType]':{
				render:function(combo){
					var store = combo.getStore();
					store.load({
						callback:function(records, operation, success){
							if (success) {
								combo.setValue(records[0].get("id"));									
							}
						}
					});
				},
				select:function(combo,record){
					this.onSelectTransactionType(combo,record);
					this.onChangeAcademyLocations(combo);
					
					var form = this.getHostelfeereportsearch();
					if(record[0].data.id == 'PAYMENT' || record[0].data.id == 'RECEIPT'){
						form.down('#whetherGroupByStudentFees').setDisabled(true)
					}else{
						form.down('#whetherGroupByStudentFees').setDisabled(false)
					}
				}
			},
			'hostelfeereportsearch combo[itemId=academyLocation]':{
				render:function(combo){
					var store = combo.getStore();
					store.getProxy().extraParams = {
						id: this.getCurrentlyLoggedInUser().id
					};
					store.load({
						callback:function(records, operation, success){
							if (success) {
								if(records.length == 1){
									combo.setValue(records[0].get("id"));									
								}
							}
						}
					});

				},
				select:function(combo,record){
					this.onChangeAcademyLocations(combo);
				}
			},
			'hostelfeereportsearch customcombobox[itemId=hostelCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var hostelCode = record[0].get("id");
					var buildingCodeName  = form.down('#buildingCodeName');
					buildingCodeName.clearValue();
					var buildingCodeStore =  buildingCodeName.getStore();
					var values = form.getForm().getValues();
					buildingCodeStore.getProxy().extraParams = {
						hostelCode:hostelCode,
						status:values.status
					};
					buildingCodeStore.load();
				}
			},
			'hostelfeereportsearch customcombobox[itemId=buildingCodeName]':{
				select: function(obj,record){
					var form = obj.up('form');
					var buildingCode = record[0].get("id");
					var floorCodeName  = form.down('#floorCodeNo');
					floorCodeName.clearValue();
					var floorCodeStore =  floorCodeName.getStore();
					var values = form.getForm().getValues();
					floorCodeStore.getProxy().extraParams = {
						buildingCode:buildingCode,
						status:values.status,
						resourceGroup:'Floor'
					};
					floorCodeStore.load();
				}
			},
			'hostelfeereportsearch button[itemId=searchBtn]':{
				click:function(obj){
					this.searchHosteFeeReport(obj);
				}
			},
			'hostelfeereportsearch button[itemId=resetButton]':{
				click:function(obj){
					this.resetHosteFeeReport(obj);
					this.onRenderFeeReportStoreLoad();
				}
			},
			'hostelfeereportsearch':{
				render:function(){
					this.onRenderFeeReportStoreLoad();
				}
			},
			
			/*V2D-12386*/
			'hostelfeereportsearch checkboxfield[itemId=whetherGroupByStudentFees]':{
				change: function(value,newValue,oldValue){					
					$this = this;
					var form = $this.getHostelfeereportsearch();
					var grid = $this.getHostelfeereportgrid();
					var gridStore = grid.getStore();
					

					//gridStore.removeAll();
					//$this.resetGridSetting(grid);
					//gridStore.loadRawData([]);
					if(newValue){
						form.down('#floorCodeNo').setDisabled(true);
						form.down('#buildingCodeName').setDisabled(true);
						form.down('#hostelCodeName').setDisabled(true);
						form.down('#billNo').setDisabled(true);
						form.down('#feePlanName').setDisabled(true);
						form.down('#paymentMode').setDisabled(true);
						form.down('#paymentVoucherNo').setDisabled(true);
						form.down('#receiptNo').setDisabled(true);
						
//						grid.columns[21].setVisible(false);
//						grid.columns[4].setVisible(false);
//						grid.columns[8].setVisible(false);
//						grid.columns[9].setVisible(false);
//						grid.columns[10].setVisible(false);
//						grid.columns[11].setVisible(false);
//						
//						grid.columns[5].setVisible(true);
//						grid.columns[6].setVisible(true);
//						grid.columns[20].setVisible(true);
//						grid.columns[0].setVisible(true)
						
					}else{
						form.down('#floorCodeNo').setDisabled(false);
						form.down('#buildingCodeName').setDisabled(false);
						form.down('#hostelCodeName').setDisabled(false);
						form.down('#billNo').setDisabled(false);
						form.down('#feePlanName').setDisabled(false);
						form.down('#paymentMode').setDisabled(false);
						form.down('#paymentVoucherNo').setDisabled(false);
						form.down('#receiptNo').setDisabled(false);
						
//						grid.columns[21].setVisible(true);
//						grid.columns[4].setVisible(true);
//						grid.columns[8].setVisible(true);
//						grid.columns[9].setVisible(true);
//						grid.columns[10].setVisible(true);
//						grid.columns[11].setVisible(true);
//						
//						grid.columns[5].setVisible(false);
//						grid.columns[6].setVisible(false);
//						grid.columns[20].setVisible(false);
//						grid.columns[0].setVisible(false)
						
					}
					
					
				}
			},
			
			'hostelfeereportgrid':{
            	render : function(grid){
            		this.doAccessControlValidation(grid, this.getHOSTEL_FEE_REPORT_PERMISSIONS());
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   				 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
	
	   				 if(columnName == "billDetails" || columnName == "receiptDetails"){
	   					 if(e.target.tagName=='A'){
	   						 this.openHostelFeeDetail(record,columnName);
	   					 }
	   				 }
	   			 },
			}
		});
	},
	onRenderFeeReportStoreLoad:function(){
		var form = this.getHostelfeereportsearch();
		var hostelCodeName  = form.down('#hostelCodeName');
		var buildingCodeName  = form.down('#buildingCodeName');
		var floorCodeNoField  = form.down('#floorCodeNo');

		var hostelCodeNameStore =  hostelCodeName.getStore();
		var buildingCodeStore =  buildingCodeName.getStore();
		var floorCodeNo = floorCodeNoField.getStore();
		form.down('#academyLocation').setValue(this.getCurrentAcademyLocation());
		var values = form.getForm().getValues();

		hostelCodeNameStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Hostel'
		};
		hostelCodeNameStore.load();
		
		buildingCodeStore.getProxy().extraParams = {
			hostelCode:values.hostelCodeName,
			status:values.status,
			resourceGroup:'Building'
		};
		buildingCodeStore.load();

		floorCodeNo.getProxy().extraParams = {
			buildingCode:values.floorCodeNo,
			status:values.status,
			resourceGroup:'Floor'
		};
		floorCodeNo.load();
	},
	onChangeAcademyLocations:function(combo){
		var form = combo.up('form');
		var alIds = form.down('#academyLocation').getValue();
		
		
		/*var academyLocationIds = null;
		if(!isNullOrEmpty(alIds)){
			academyLocationIds = alIds.join(); 
		}*/
		  var alIdsids=[];
		  var academyLocations = null;
		   if(alIds !=undefined && alIds.length > 0){
	    		for(var i in alIds){
	    			if(Ext.isObject(alIds[0])){
	    				alIdsids.push(alIds[i].get("id"));
	    			}else{
	    				alIdsids.push(alIds[i]);
	    			}
	    		}
	    		academyLocations = alIdsids.join();
		   }
		
		
		var transactionType = form.down('#transactionType').getValue();
		
		var billNoField = form.down('#billNo');
		var receiptNoField = form.down('#receiptNo');
		var paymentVoucherNoField = form.down('#paymentVoucherNo');
		
		if(transactionType == 'BILL'){
			var billNoStore = billNoField.getStore();
			billNoStore.getProxy().extraParams = {
				academyLocationIds: academyLocations
			};
			billNoStore.load();	
		}
		
		if(transactionType == 'RECEIPT'){
			var receiptNoStore = receiptNoField.getStore();
			receiptNoStore.getProxy().extraParams = {
				academyLocationIds: academyLocations
			};
			receiptNoStore.load();
		}
		
		if(transactionType == 'PAYMENT'){
			var paymentVoucherNoStore = paymentVoucherNoField.getStore();
			paymentVoucherNoStore.getProxy().extraParams = {
				academyLocationIds: academyLocations
			};
			paymentVoucherNoStore.load();
		}

		var feePlanNameField = form.down('#feePlanName');
		var feePlanNameStore = feePlanNameField.getStore();
		feePlanNameStore.getProxy().extraParams = {
			academyLocationIds: academyLocations
		};
		feePlanNameStore.load();
		
		var hostelCodeNameField = form.down('#hostelCodeName');
		var hostelCodeNameStore = hostelCodeNameField.getStore();
		hostelCodeNameStore.getProxy().extraParams = {
			academyLocationIds: academyLocations
		};
		hostelCodeNameStore.load();
		

	},
	onSelectTransactionType:function(combo,record){
		var form = combo.up('form');
		var transactionId = record[0].get("id");
		
		var billNoField = form.down('#billNo');
		var receiptNoField = form.down('#receiptNo');
		var paymentVoucherNoField = form.down('#paymentVoucherNo');
		var paymentModeField = form.down('#paymentMode');
		
		var grid = this.getHostelfeereportgrid();
		var billId = grid.down('#billId');
		var billDate = grid.down('#billDate');
		var receiptNo = grid.down('#receiptNo');
		var receiptDate = grid.down('#receiptDate');
		var paymentVoucherNo = grid.down('#paymentVoucherNo');
		var paymentDate = grid.down('#paymentDate');
		var outstandingAmount = grid.down('#outstandingAmount');
		var settledAmount = grid.down('#settledAmount');
		var totalAmount=grid.down('#totalAmount');
		var billDetails=grid.down('#billDetails');
		var receiptDetails=grid.down('#receiptDetails');
		
		
		if(transactionId == 'BILL'){
			billNoField.setVisible(true);
			
			receiptNoField.clearValue();
			paymentVoucherNoField.clearValue();
			paymentModeField.clearValue();
			
			receiptNoField.setVisible(false);
			paymentVoucherNoField.setVisible(false);
			paymentModeField.setVisible(false);
			
			billId.setVisible(false);
			billDate.setVisible(false);
			outstandingAmount.setVisible(true);
			settledAmount.setVisible(false);
			receiptNo.setVisible(false);
			receiptDate.setVisible(false);
			paymentVoucherNo.setVisible(false);
			paymentDate.setVisible(false);
			totalAmount.setVisible(true);
			billDetails.setVisible(true);
			receiptDetails.setVisible(false);
		}else if(transactionId == 'RECEIPT'){
			receiptNoField.setVisible(true);
			paymentModeField.setVisible(true);
			
			billNoField.clearValue();
			paymentVoucherNoField.clearValue();
			
			billNoField.setVisible(false);
			paymentVoucherNoField.setVisible(false);
			
			billId.setVisible(false);
			billDate.setVisible(false);
			receiptNo.setVisible(false);
			receiptDate.setVisible(false);
			paymentVoucherNo.setVisible(false);
			paymentDate.setVisible(false);
			outstandingAmount.setVisible(false);
			settledAmount.setVisible(true);
			totalAmount.setVisible(false);
			receiptDetails.setVisible(true);
			billDetails.setVisible(false);
		}else if(transactionId == 'PAYMENT'){
			paymentVoucherNoField.setVisible(true);
			paymentModeField.setVisible(true);
			
			billNoField.clearValue();
			receiptNoField.clearValue();
			
			billNoField.setVisible(false);
			receiptNoField.setVisible(false);
			
			billId.setVisible(false);
			billDate.setVisible(false);
			receiptNo.setVisible(false);
			receiptDate.setVisible(false);
			paymentVoucherNo.setVisible(true);
			paymentDate.setVisible(true);
			outstandingAmount.setVisible(false);
			settledAmount.setVisible(true);
			receiptDetails.setVisible(false);
			billDetails.setVisible(false);
		}
	},
	searchHosteFeeReport:function(obj){
		var searchForm = obj.up('form');
		var values = searchForm.getForm().getValues();
		var form = searchForm.getForm();
		var billNo = form.findField('billNo').getRawValue();

		var grid = this.getHostelfeereportgrid();
		var store = grid.getStore();
		store.currentPage=1;
		var transactionType = values.transactionType;
		var groupByStudentFees = false;
		if(values.whetherGroupByStudentFees){
			groupByStudentFees = true;
		}
		var alIds = values.academyLocation;
		var alIdsids=[];
		var academyLocations = null;
		if(alIds !=undefined && alIds.length > 0){
			for(var i in alIds){
				if(Ext.isObject(alIds[0])){
					alIdsids.push(alIds[i].get("id"));
				}else{
					alIdsids.push(alIds[i]);
				}
			}
			academyLocations = alIdsids.join();
		}


		if(transactionType == 'BILL'){
			store.getProxy().extraParams = {
				occupantId:values.studentName,
				academyLocationIds:academyLocations,
				feeTransactionType:values.transactionType,
				fromDate:values.fromDate,
				toDate:values.toDate,
				billNo:billNo,
				receiptNo:values.receiptNo,
				paymentNo:values.paymentVoucherNo,
				feePlanId:values.feePlanName,
				hostelId:values.hostelCodeName,
				buildingId:values.buildingCodeName,
				floorId:values.floorCodeNo,
				paymentModeId:values.paymentMode,
				whetherGroupByStudentFee:groupByStudentFees,
			};
			store.load();
		}else if(transactionType == 'PAYMENT'){
			store.getProxy().extraParams = {
				occupantId:values.studentName,
				academyLocationIds:academyLocations,
				feeTransactionType:values.transactionType,
				fromDate:values.fromDate,
				toDate:values.toDate,
				billNo:billNo,
				receiptNo:values.receiptNo,
				paymentNo:values.paymentVoucherNo,
				feePlanId:values.feePlanName,
				hostelId:values.hostelCodeName,
				buildingId:values.buildingCodeName,
				floorId:values.floorCodeNo,
				paymentModeId:values.paymentMode,
				whetherGroupByStudentFee:groupByStudentFees,
			};
			store.load();
		}else if(transactionType == 'RECEIPT'){
			store.getProxy().extraParams = {
				occupantId:values.studentName,
				academyLocationIds:academyLocations,
				feeTransactionType:values.transactionType,
				fromDate:values.fromDate,
				toDate:values.toDate,
				billNo:billNo,
				receiptNo:values.receiptNo,
				paymentNo:values.paymentVoucherNo,
				feePlanId:values.feePlanName,
				hostelId:values.hostelCodeName,
				buildingId:values.buildingCodeName,
				floorId:values.floorCodeNo,
				paymentModeId:values.paymentMode,
				whetherGroupByStudentFee:groupByStudentFees,
			};
			store.load();
		}
		var chkWhetherGroup = searchForm.down('#whetherGroupByStudentFees');
		if(chkWhetherGroup.getValue()){
			grid.down('[dataIndex=billDetails]').setVisible(false);
			grid.down('[dataIndex=academyLocation]').setVisible(false);
			grid.down('[dataIndex=buildingCode]').setVisible(false);
			grid.down('[dataIndex=floorCode]').setVisible(false);
			grid.down('[dataIndex=roomNo]').setVisible(false);
			grid.down('[dataIndex=roomType]').setVisible(false);

			grid.down('[dataIndex=programName]').setVisible(true);
			grid.down('[dataIndex=batchName]').setVisible(true);
			grid.down('[dataIndex=settledAmount]').setVisible(true);
			grid.down('[dataIndex=admissionCode]').setVisible(true);
		}
		else{
			grid.down('[dataIndex=billDetails]').setVisible(true);
			grid.down('[dataIndex=academyLocation]').setVisible(true);
			grid.down('[dataIndex=buildingCode]').setVisible(true);
			grid.down('[dataIndex=floorCode]').setVisible(true);
			grid.down('[dataIndex=roomNo]').setVisible(true);
			grid.down('[dataIndex=roomType]').setVisible(true);

			grid.down('[dataIndex=programName]').setVisible(false);
			grid.down('[dataIndex=batchName]').setVisible(false);
			grid.down('[dataIndex=settledAmount]').setVisible(false);
			grid.down('[dataIndex=admissionCode]').setVisible(false);
		}
		  var academyLocationIds=null;
	      var result;
		  var grid;
		  Ext.Ajax.request({
			  method: "GET",
			  type: 'rest',
			  url: SERVERURL.FIND_WHETHER_MULTI_ACAD_LOC_APPLICABLE_FOR_CURRENCY,
			  params:{
				  academyLocationIds:academyLocations
			  },
			  success: function(response) {
				  if(response){
					  result=response.responseText;	
				  }
		    		  if(result=="false"){
		 				 var gridColumns=grid.columns;
		 				 var length = gridColumns.length;
		 				 if(length!=null && length!=""){
		 					 for(var i=0; i<length; i++){
		 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='currencyTotalAmount' || gridColumns[i].dataIndex=='currencyOutstandingAmount'){
		 							 gridColumns[i].setVisible(false);
		 						 }
		 					 }
		 				 }
		 			  }else{
		 				 var gridColumns=grid.columns;
		 				 var length = gridColumns.length;
		 				 if(length!=null && length!=""){
		 					 for(var i=0; i<length; i++){
		 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='currencyTotalAmount' || gridColumns[i].dataIndex=='currencyOutstandingAmount'){
		 							 gridColumns[i].setVisible(true);
		 						 }
		 					 }
		 				 }
		    	  }
			  }
		  });
	},
	resetHosteFeeReport:function(obj){
		this.getHostelfeereportsearch().getForm().reset();
	},
	openHostelFeeDetail: function(record,columnName){
		var $this=this;
		
		var billreceiptdetailwindow = $this.getHostelbillreceiptdetailwindow();
		if (!billreceiptdetailwindow) {
			billreceiptdetailwindow = Ext.widget('hostelbillreceiptdetailwindow');
		}
		var windowGrid;
		if(columnName=="billDetails"){	
			windowGrid=billreceiptdetailwindow.down('#hostelbilldetailsId');
			windowGrid.setVisible(true);
			windowGrid.getStore().getProxy().extraParams={
				hostelRoomAllotmentId:record.get('id'),
				feeTransactionType:'Bill'
			}
		}else if(columnName=='receiptDetails'){
			windowGrid=billreceiptdetailwindow.down('#hostelreceiptdetailsId');
			windowGrid.setVisible(true);	
			windowGrid.getStore().getProxy().extraParams={
				hostelRoomAllotmentId:record.get('id'),
				feeTransactionType:'Receipt'
			}
		}	
		windowGrid.getStore().load();
		billreceiptdetailwindow.show();	
	}
});
