/**
 * @author Rajkumar.patidar
 * 
 */

Ext.define('Academia.controller.importutility.ImportUtilityController', {
	//extend: 'Ext.app.Controller',
	extend : 'Academia.controller.base.BaseController',
	models :['importutility.ImportUtilityDataModel','importutility.ModuleName'],
	stores: ['importutility.ModuleName','importutility.ImportUtilityList'],
	views: ['importutility.ImportUtilityStructure','importutility.ImportUtilityList',
	        'importutility.ImportUtilityWin','importutility.DownloadTemplateWin'],

	        refs: [{
	        	ref : 'importUtilityStructure',
	        	selector : 'importutilitystructure' 
	        },{
	        	ref : 'importUtilityList',
	        	selector : 'importutilitylist' 
	        },{
	        	ref:'importUtilityWin',
	        	selector:'importutilitywin'
	        },{
	        	ref:'importUtilityWinForm',
	        	selector:'importutilitywin form'
	  /*      },{
	        	ref:'importutilitywin',
	        	selector:'importutilitywin'*/
	        },{
	        	ref:'downloadtemplatewin',
	        	selector:'downloadtemplatewin'
	        },{
	        	ref:'downloadtemplatewinform',
	        	selector:'downloadtemplatewin form'
	        }],
	        config : {
	        	IMPORT_UTILITY_FORCE_RUN_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
	    				.getFeaturePrivilegesMap('IMPORT_UTILITY_FORCE_RUN_PRIVILEGES'),
	        },
	        init: function() {

	        	this.control({
	        		'importutilitylist button[itemId=btnAdd]':{
	        			click:this.getOpenImportUtilityWin
	        		},
	        		'importutilitylist button[itemId=btnDownloadTemp]':{
	        			click:this.getOpenDownloadtemplatewin
	        		},
	        		'importutilitywin button[itemId=CancelBtn]':{
	        			click:this.getCloseImportUtilityWin
	        		},
	        		'downloadtemplatewin button[itemId=SubmitBtn]':{
	        			click:this.getDownloadtemplate
	        		},
	        		'downloadtemplatewin button[itemId=CancelBtn]':{
	        			click:this.getCloseDownloadtemplateWin
	        		},
	        		'importutilitywin':{
	        			show: function(obj){
	        				var userInfo = this.getCurrentlyLoggedInUser();
	        				//obj.down("#importedById").setValue(userInfo.id);
	        				//obj.down("#importedBy").setValue(userInfo.code);
	        			}
	        		},
	        		'importutilitywin  button[itemId=SubmitBtn]':{
	        			click: this.saveDocumentImportUtiltyWin
	        		},
	        		'importutilitylist':{
	        			render : function(grid){
	        				this.getRenderImportutilityList();
	        				console.log('this.getIMPORT_UTILITY_FORCE_RUN_PERMISSIONS()..',this.getIMPORT_UTILITY_FORCE_RUN_PERMISSIONS())
	        				this.doAccessControlValidationForForceRun(grid, this.getIMPORT_UTILITY_FORCE_RUN_PERMISSIONS());
	        			},
	        			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	        				//console.log('e. tag name',e.target);
	        				if (e.target.tagName == 'A') {
	        					var fileType=null;
	        					if(cellIndex==1){
	        						fileType='successFile';
	        					}else if(cellIndex==6){
	        						fileType='errorFile';
	        					}else if(cellIndex==7){
	        						fileType='logFile';
	        					}
	        					var documentId = record.get("id");
	        					if (!isNullOrEmpty(documentId)) {
	        						this.getDownloadFile(documentId,fileType);
	        					}
	        				}
	        			}
	        		},'importutilitylist button[itemId=btnForce]':{
	        			click: function(obj) {
        	            	var grid = this.getImportUtilityList();
        	            	if (grid.getSelectionModel().getCount() > 0) {
        	            		if(grid.getSelectionModel().getCount() > 1){
        		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        		        		}else{
        		        			var this$ = this;
            	                	var id = grid.getSelectionModel().selectionStart.data.id;
            	                	console.log(id);
            	                	var urlAppend="?jobName="+id;
            	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
            	    	        	Ext.Ajax.request({
            	    	        		url: submitURL,
            	    	        		method: 'GET',
            	    	        		success: function(response) {
            	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
            	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
            	    	        				//console.log("Manual trigger hit");
            	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
            	    	        			}else if(response.responseText==="SUCCESS"){
            	    	        				//console.log("Manual trigger hit");
                	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
            	    	        			}
            	    	        		}
            	    	        	});
        		        		}
        	            	} else {
        	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	            	}  
        	            }
	        		},
	        		'importutilitylist button[itemId=btnRunAllPending]':{
	        			click: function(obj) {
	        				var submitURL = SERVERURL.IMPORT_UTIL_RUN_ALL_PENDING;
    	    	        	Ext.Ajax.request({
    	    	        		url: submitURL,
    	    	        		method: 'GET',
    	    	        		success: function(response) {
    	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    	    	        		}
    	    	        	});        	            	
        	            }
	        		}
	        	});
	        },
	        saveDocumentImportUtiltyWin:function(){
	        	var $this=this;
	        	var importWin=$this.getImportUtilityWin()
	        	var grdStore;
	        	if($this.getImportUtilityList() !=undefined){
	        		grdStore = $this.getImportUtilityList().getStore();
        		}
	        	var form=$this.getImportUtilityWinForm();
	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        	$this.getHashOfFile(form);
	        	setTimeout(function() {
		        	form.getForm().submit({
		        		method : 'POST',
		        		url : submitUrl,
		        		success : function(form, action){
		        			$this.getCloseImportUtilityWin();
		    	        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		    	        	//grdStore.reload();
		    	        	if($this.getImportUtilityList() !=undefined){
			        			grdStore.reload();
			        		}
		        		},
		        		failure: function(form, action) {
		        			$this.getCloseImportUtilityWin();
	   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		    	        	//grdStore.reload();
		    	        	if($this.getImportUtilityList() !=undefined){
			        			grdStore.reload();
			        		}
		        	    }
		        	});
	        	},1000);
	        	
	        },
	        saveDocuments :function(path){
	        	var $this = this;
	        	var fileName = path.split("/");
	        	var grdStore = $this.getImportUtilityList().getStore();
	        	var form = $this.getImportUtilityWinForm().getForm();
	        	var value = form.getValues();
	        	var importDocModel = new Academia.model.importutility.ImportUtilityDataModel();

	        	importDocModel.set("id",value.id);
	        	importDocModel.set("importUtilityMasterId",value.importUtilityMasterId);
	        	importDocModel.set("fileName",fileName[2]);
	        //	importDocModel.set("importedBy",value.importedBy);
	        	//importDocModel.set("importedById",value.importedById);
	        	importDocModel.set("importedOn",new Date());
	        	importDocModel.set("filePath",path);

	        	var submitData = importDocModel.data;
	        	var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	        	Ext.Ajax.request({
	        		url: submitUrl,
	        		jsonData: submitData,
	        		method: 'POST',
	        		success: function(response) {
	        			$this.getCloseImportUtilityWin();
	        			grdStore.reload();
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	        		}
	        	});
	        	
	        },
	        getDownloadtemplate:function(){
	        	var temForm=this.getDownloadtemplatewinform();
	        	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getValue();
	        	var csvForm = Ext.create('Ext.form.Panel'); 
	    		csvForm.getForm().submit({
	    			target: '_blank',
	    			method:'POST',
	    			params :{
	    				access_token : Ext.Ajax.defaultHeaders.access_token,
	    				code:tempFormValue
	    			},
	    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    			url: SERVERURL.IMPORT_UTILITY_DOWNLOAD_FINANCIAL_SUPPORT,
	    			standardSubmit :true
	    		});
	    		this.getCloseDownloadtemplateWin();
	        },
	        getOpenImportUtilityWin : function(){

	        	var formWindow = this.getImportUtilityWin();
	        	if (!formWindow) {
	        		Ext.widget('importutilitywin');
	        		formWindow = this.getImportUtilityWin();
	        	}
	        	formWindow.show();
	        },
	        getOpenDownloadtemplatewin : function(){

	        	var formWindow = this.getDownloadtemplatewin();
	        	if (!formWindow) {
	        		Ext.widget('downloadtemplatewin');
	        		formWindow = this.getDownloadtemplatewin();
	        	}
	        	formWindow.show();
	        },
	        getCloseImportUtilityWin : function(){
	        	this.getImportUtilityWin().close();
	        },
	        getCloseDownloadtemplateWin : function(){
	        	this.getDownloadtemplatewin().close();
	        },
	        getRenderImportutilityList : function(){
	        	var store = this.getStore('importutility.ImportUtilityList');
	        	store.load();
	        },
	        getDownloadFile : function(documentId,fileType){

	        	if(!isNullOrEmpty(documentId)){
	        		var csvForm = Ext.create('Ext.form.Panel'); 
	        		csvForm.getForm().submit({
	        			target: '_blank',
	        			method:'POST',
	        			params :{
	        				access_token : Ext.Ajax.defaultHeaders.access_token
	        			},
	        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	        			standardSubmit :true
	        		});
	        	}
	        },
	     // ********* Hide  all more Action button of sequence *************
	        doAccessControlValidationForForceRun: function(gridReference,permissionsMap) {
	        	var associatedAcadLocationIds = new Array();
	        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        	//buttonsToolBar = gridReference.query('toolbar')[0];
	        	//var splitbuttons = buttonsToolBar.query('splitbutton')[0];
	        	var forceRunButton = gridReference.down('#btnForce');
	        	forceRunButton.setVisible(false);
	        	/*Ext.each(splitbuttons.menu.items.items, function(menuItems) {
	        		menuItems.setVisible(false);
	        	});*/
	        	Ext.each(permissionList, function(privilege) {
	        		if (privilege === 'FORCERUN') {
	        			//var button = buttonsToolBar.query('#spBtnMoreActions')[0];
	        			if(!isNullOrEmpty(forceRunButton)){
	        				forceRunButton.setVisible(true);
	        			}        		
	        		}
	        		
	        	});
	        },
});