/**
 * @author Deepak Sharma
 */
Ext.define('Academia.controller.leavemanagement.leavegeneralsetting.LeaveGeneralSettingController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['leavemanagement.leavegeneralsetting.LeaveServiceEligibilityStore',
    		 'leavemanagement.LeaveTypeStore',
    		 'leavemanagement.leavegeneralsetting.LeaveServicePeriodTypeStore',
    		 'leavemanagement.leavegeneralsetting.LeaveSanctioningDaysStore',
    		 'leavemanagement.leavegeneralsetting.LeaveCombinationStore',
    		 'leavemanagement.leavegeneralsetting.LeaveTypeGeneralSettingStore',
    		 'leavemanagement.leavegeneralsetting.LeaveHolidayCheckStore',
    		 'leavemanagement.leavegeneralsetting.LeaveHolidayCheckComboStore'],
    views: ['leavemanagement.leavegeneralsetting.LeaveGeneralSettingForm',
    		'leavemanagement.leavegeneralsetting.LeaveServiceEligibilityGrid',
    		'leavemanagement.leavegeneralsetting.LeaveSanctioningDaysGrid',
    		'leavemanagement.leavegeneralsetting.LeaveCombinationGrid',
    		'leavemanagement.leavegeneralsetting.LeaveCominationFormWindow',
    		'leavemanagement.leavegeneralsetting.LeaveHolidayCheckGrid'
    	   ],
    refs: [{
        ref: 'contentpanel',
        selector: 'contentpanel'
    }, {
        ref: 'leavegeneralsettingform',
        selector: 'leavegeneralsettingform'
    },{
    	ref: 'leaveserviceeligibilitygrid',
        selector: 'leaveserviceeligibilitygrid'
    },{
    	ref: 'leavesanctioningdaysgrid',
        selector: 'leavesanctioningdaysgrid'
    },{
    	ref: 'leavecombinationgrid',
        selector: 'leavecombinationgrid'
    },{
    	ref: 'leavecominationformwindow',
        selector: 'leavecominationformwindow'
    },{
    	ref: 'leaveholidaycheckgrid',
        selector: 'leaveholidaycheckgrid'
    }],
    /*config: {
    },*/
    init: function(application) {
        this.control({
        	'leavegeneralsettingform': {
        		render: this.loadGeneralSettingFormRender
            },
            'leaveserviceeligibilitygrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getLeaveserviceeligibilitygrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;

                    if (e.target.tagName == 'DIV') {
                        if (columnName == "addButton") {
                            if (e.target.className == "addButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    var serialNo;
                                    if (grid.getStore() != null)
                                        serialNo = grid.getStore().getCount();
                                    this.addNewRowInLeaveServiceEligibilityGrid(serialNo + 1);
                                }
                            }
                        } else if (columnName == "deleteButton") {
                            if (e.target.className == "deleteButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    if (grid.getStore().getRange().length > 0) {
                    					var id = record.get('id');
                    					if(!isNullOrEmpty(id)){
                    						showConfirmMessage(getPersonModuleTranslation('LEAVE_SERVICE_PERIOD_ELIGIBILITY_GENERAL_SETTING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    							if (btn == 'yes') {
                    								Ext.Ajax.request({
                    									type: 'rest',
                    									url: SERVERURL.PATH_DELETE_HR_LEAVE_SETTING + '?id=' + id +'&leaveSettingType=SERVICE_PERIOD_ELLIGIBILITY',
                    									method: 'DELETE',
                    									params: {
                    										id : id,
                    										leaveSettingType:'SERVICE_PERIOD_ELLIGIBILITY'
                    									},
                    									headers: {
                    										'Content-Type': 'application/json'
                    									},
                    									success: function(form, action) {
                    										grid.getStore().removeAt(rowIndex);
                                                            var models = grid.getStore().getRange();
                                                            for (var i = 0; i < models.length; i++) {
                                                                models[i].data.serialNo = i + 1;
                                                            }
                                                            grid.getStore().loadRawData(models, true);
                                                            if(models.length == 0){
                                                            	grid.down('#btnAdd').show();
                                                            }
                    										showSuccessMessage(getPersonModuleTranslation('LEAVE_SERVICE_PERIOD_ELIGIBILITY_GENERAL_SETTING'), getPersonModuleTranslation('LEAVE_SERVICE_PERIOD_ELIGIBILITY_GENERAL_SETTING_DELETE_MSG'));
                    									}
                    								});
                    							}
                    						});
                    					}
                    					else{
                    						grid.getStore().removeAt(rowIndex);
                    						var models = grid.getStore().getRange();
                      						 for (var i = 0; i < models.length; i++) {
   		                    							models[i].data.serialNo = i + 1;
   		                    				}
                      						grid.getStore().loadRawData(models, true);
   	                    						if(models.length == 0){
   	                    							grid.down('#btnAdd').show();
   	                    						}
                    					}
                                    }
                                }
                            }
                        }
                    }
                }
            },
            'leavesanctioningdaysgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getLeavesanctioningdaysgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;

                    if (e.target.tagName == 'DIV') {
                    	if (columnName == "addButton") {
                    		if (e.target.className == "addButtonClsForGridActionCls") {
                    			if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                    				var serialNo;
                    				if (grid.getStore() != null)
                    					serialNo = grid.getStore().getCount();
                    				this.addNewRowInLeaveSanctioningDaysGrid(serialNo + 1);
                    			}
                    		}
                    	} else if (columnName == "deleteButton") {
                    		if (e.target.className == "deleteButtonClsForGridActionCls") {
                    			if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                    				if (grid.getStore().getRange().length > 0) {
                    					var id = record.get('id');
                    					if(!isNullOrEmpty(id)){
                    						showConfirmMessage(getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    							if (btn == 'yes') {
                    								Ext.Ajax.request({
                    									type: 'rest',
                    									url: SERVERURL.PATH_DELETE_HR_LEAVE_SETTING + '?id=' + id +'&leaveSettingType=SANCTIONING_DAYS',
                    									method: 'DELETE',
                    									params: {
                    										id : id,
                    										leaveSettingType:'SANCTIONING_DAYS'
                    									},
                    									headers: {
                    										'Content-Type': 'application/json'
                    									},
                    									success: function(form, action) {
                    										grid.getStore().removeAt(rowIndex);
                    										var models = grid.getStore().getRange();
                    										for (var i = 0; i < models.length; i++) {
                    											models[i].data.serialNo = i + 1;
                    										}
                    										grid.getStore().loadRawData(models, true);
                    										if(models.length == 0){
                    											grid.down('#btnAdd').show();
                    										}
                    										showSuccessMessage(getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING'), getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING_DELETE_MSG'));
                    									}
                    								});
                    							}
                    						});
                    					}
                    					else{
                    						grid.getStore().removeAt(rowIndex);
                    						var models = grid.getStore().getRange();
                    						 for (var i = 0; i < models.length; i++) {
		                    							models[i].data.serialNo = i + 1;
		                    				}
                    						grid.getStore().loadRawData(models, true);
	                    						if(models.length == 0){
	                    							grid.down('#btnAdd').show();
	                    						}
                    					}
                    				}
                    			}
                    		}
                    	}
                    }
                }
            },
            'leaveholidaycheckgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getLeaveholidaycheckgrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;

                    if (e.target.tagName == 'DIV') {
                        if (columnName == "addButton") {
                            if (e.target.className == "addButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    var serialNo;
                                    if (grid.getStore() != null)
                                        serialNo = grid.getStore().getCount();
                                    this.addNewRowInLeaveCheckHolidayGrid(serialNo + 1);
                                }
                            }
                        } else if (columnName == "deleteButton") {
                            if (e.target.className == "deleteButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                                    if (grid.getStore().getRange().length > 0) {
                    					var id = record.get('id');
                    					if(!isNullOrEmpty(id)){
                    						showConfirmMessage(getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    							if (btn == 'yes') {
                    								Ext.Ajax.request({
                    									type: 'rest',
                    									url: SERVERURL.PATH_DELETE_HR_LEAVE_SETTING + '?id=' + id +'&leaveSettingType=HOLIDAY_CHECK',
                    									method: 'DELETE',
                    									params: {
                    										id : id,
                    										leaveSettingType:'HOLIDAY_CHECK'
                    									},
                    									headers: {
                    										'Content-Type': 'application/json'
                    									},
                    									success: function(form, action) {
                    										grid.getStore().removeAt(rowIndex);
                                                            var models = grid.getStore().getRange();
                                                            for (var i = 0; i < models.length; i++) {
                                                                models[i].data.serialNo = i + 1;
                                                            }
                                                            grid.getStore().loadRawData(models, true);
                                                            if(models.length == 0){
                                                            	grid.down('#btnAdd').show();
                                                            }
                    										showSuccessMessage(getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING'), getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING_DELETE_MSG'));
                    									}
                    								});
                    							}
                    						});
                    					}
                    					else{
                    						grid.getStore().removeAt(rowIndex);
                    						var models = grid.getStore().getRange();
                   						 for (var i = 0; i < models.length; i++) {
		                    							models[i].data.serialNo = i + 1;
		                    				}
                   						grid.getStore().loadRawData(models, true);
	                    						if(models.length == 0){
	                    							grid.down('#btnAdd').show();
	                    						}
                    					}
                                    }
                                }
                            }
                        }
                    }
                }
            },
            'leavecombinationgrid button[itemId=btnAdd]':{
    			click: this.addLeaveCombinationWinRecord
    		},
    		'leavecombinationgrid button[itemId=btnEdit]':{
    			click: this.editLeaveCombinationWinRecord
    		},
    		'leavecombinationgrid button[itemId=btnDelete]':{
    			click: this.deleteLeaveCombinationWinRecord
    		},
    		'leavecominationformwindow button[itemId=btnCancelLeaveCombinationForm]':{
    			click: this.cancelLeaveCombinationWin
    		},
    		'leavecominationformwindow button[itemId=btnSaveLeaveCombinationForm]':{
    			click: this.saveLeaveCombinationWinData
    		},
    		'leavecominationformwindow customcombobox[itemId=leaveTypeCombinationItemId]':{
    			select:function(obj,rec){
    				var $this = this;
    				var form = $this.getLeavecominationformwindow().down('form').getForm();
    				var leaveCombineWith = form.findField('leaveCombineWith');
    				var leaveCombineWithStore = leaveCombineWith.getStore();
    				leaveCombineWith.reset();
    				leaveCombineWith.setDisabled(false);
    				/*leaveCombineWithStore.getProxy().extraParams={
    					leaveTypeNotInIDs:obj.getValue()
    	        	}*/
    	        	leaveCombineWithStore.load();
    			},
                focus: function(combo, e, eOpts) {
                	var $this = this;
                	var grid = $this.getLeavecombinationgrid();
                	var ids = [];
                	
                	if(!combo.readOnly){
                		grid.getStore().each(function(rec){
                    		ids.push(rec.get('leaveType'));
                    	});
    					combo.getStore().on('beforeload', function(){
    						this.getProxy().extraParams = {
    							leaveTypeNotInIDs: ids.join()
    						};
    					});
    					combo.getStore().load();	
                	}
				}
    		},
    		'leavegeneralsettingform button[itemId=SubmitBtn]':{
    			click: this.saveLeaveGeneralSetting
    		},
    		'leavesanctioningdaysgrid button[itemId=btnAdd]':{
    			click: function(button) {
    				this.addNewRowInLeaveSanctioningDaysGrid(1);
    			}
    		},
    		'leaveserviceeligibilitygrid button[itemId=btnAdd]':{
    			click: function(button) {
    				this.addNewRowInLeaveServiceEligibilityGrid(1)
    			}
    		},
    		'leaveholidaycheckgrid button[itemId=btnAdd]':{
    			click: function(button) {
    				this.addNewRowInLeaveCheckHolidayGrid(1);
    			}
    		}
        });
    },
    
    loadGeneralSettingFormRender: function(){
		var $this = this;
		var gridEligibility = $this.getLeaveserviceeligibilitygrid();
		var gridLeaveSanctioning = $this.getLeavesanctioningdaysgrid();
		var gridLeaveCombination = $this.getLeavecombinationgrid();
		var gridLeaveHolidayCheck = $this.getLeaveholidaycheckgrid();
		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_GET_HR_LEAVE_SETTING,
            method: 'GET',
            success: function(response, action) {
                var responseData = Ext.decode(response.responseText);
                var listServicePeriodEligibility = responseData.wsHRLeaveSettingServiePeriodElligibilityList;
                var listSanctioningDays = responseData.wsHRLeaveSettingSanctioningDaysList;
                var listClubbings = responseData.wsHRLeaveSettingClubbingList;
                var listHolidayCheck = responseData.wsHRLeaveSettingHolidayCheckList;
                if(isNullOrEmpty(listServicePeriodEligibility) && isNullOrEmpty(listSanctioningDays) && isNullOrEmpty(listClubbings) && isNullOrEmpty(listHolidayCheck)){
                	gridEligibility.getStore().removeAll();
        			gridLeaveSanctioning.getStore().removeAll();
        			gridLeaveCombination.getStore().removeAll();
        			gridLeaveHolidayCheck.getStore().removeAll();
        			gridEligibility.down('#btnAdd').show();
        			gridLeaveSanctioning.down('#btnAdd').show();
        			gridLeaveHolidayCheck.down('#btnAdd').show();
        			Ext.getBody().unmask();
                }
                else{
                	if(!isNullOrEmpty(listServicePeriodEligibility) && listServicePeriodEligibility.length>0){
                		gridEligibility.getStore().removeAll();
                		var ObjModelSPE = [];
                		var cntSPE = 1; 
                		listServicePeriodEligibility.forEach(function(obj){
                			var leaveServiceEligibilityModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveServiceEligibilityModel();
                			leaveServiceEligibilityModel.set("serialNo", cntSPE);
                			leaveServiceEligibilityModel.set("id", obj.id);
                            leaveServiceEligibilityModel.set("leaveType", obj.hrLeaveType.id);
                            leaveServiceEligibilityModel.set("leaveTypeName", obj.hrLeaveType.value);
                            leaveServiceEligibilityModel.set("servicePeriodType", obj.servicePeriodType);
                            leaveServiceEligibilityModel.set("minimumServiceTerm", obj.minumumServiceTerm);
                            leaveServiceEligibilityModel.set("isEditable", 'ADD');
                            leaveServiceEligibilityModel.set("isAddDeleteRow", true);
                            leaveServiceEligibilityModel.commit();
                            ObjModelSPE.push(leaveServiceEligibilityModel);
                            cntSPE = cntSPE+1;
                    	});
                		gridEligibility.getStore().loadRawData(ObjModelSPE, true);
                	}
                	else {
                		gridEligibility.getStore().removeAll();
                		gridEligibility.down('#btnAdd').show();
                	}
                	if(!isNullOrEmpty(listSanctioningDays) && listSanctioningDays.length>0){
                		Ext.getBody().unmask();
                		gridLeaveSanctioning.getStore().removeAll();
                		var ObjModelSD = [];
                		var cntSD = 1; 
                		listSanctioningDays.forEach(function(obj){
                			var leaveServiceEligibilityModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveServiceEligibilityModel();
                			leaveServiceEligibilityModel.set("serialNo", cntSD);
                			leaveServiceEligibilityModel.set("id", obj.id);
                            leaveServiceEligibilityModel.set("leaveType", obj.hrLeaveType.id);
                            leaveServiceEligibilityModel.set("leaveTypeName", obj.hrLeaveType.value);
                            leaveServiceEligibilityModel.set("minDays", obj.minDays);
                            leaveServiceEligibilityModel.set("maxDays", obj.maxDays);
                            leaveServiceEligibilityModel.set("isEditable", 'ADD');
                            leaveServiceEligibilityModel.set("isAddDeleteRow", true);
                            leaveServiceEligibilityModel.commit();
                            ObjModelSD.push(leaveServiceEligibilityModel);
                            cntSD = cntSD+1;
                    	});
                		gridLeaveSanctioning.getStore().loadRawData(ObjModelSD, true);
                	}
                	else {
                		gridLeaveSanctioning.getStore().removeAll();
                		gridLeaveSanctioning.down('#btnAdd').show();
                	}
                	
                	if(!isNullOrEmpty(listClubbings) && listClubbings.length>0){
                		gridLeaveCombination.getStore().removeAll();
                		var ObjModelClubbings = [];
                		var cntClubbings = 1; 
                		var listClubbingsLength=0;
                		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                		listClubbings.forEach(function(obj){
                			var leaveCombModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveCombinationModel();
                			var leaveTypeName = obj.hrLeaveType.value;

                			listClubbingsLength=listClubbingsLength+1;
                			
                			if(!isNullOrEmpty(obj.clubbingLeaveTypeIds)){
                				var leaveCombineArr = [];
                				var leaveCombineWithStore= Ext.getStore('leavemanagement.leavegeneralsetting.LeaveTypeGeneralSettingStore');
                				/*leaveCombineWithStore.getProxy().extraParams={
                					leaveTypeNotInIDs:obj.hrLeaveType.id
                				}*/
                				leaveCombineWithStore.load({
                					callback:function(rec) {
                						var leaveCombineIds = obj.clubbingLeaveTypeIds.split(',').map(function(item) {
                							return parseInt(item, 10);
                						});
                						leaveCombineIds.forEach(function(val){
                							var result = rec.filter(function (obj) {
                								return obj.data.id === val;
                							})[0];
                							leaveCombineArr.push(result.data.value);
                						});
                						leaveCombModel.set("id", obj.id);
                						leaveCombModel.set("serialNo", cntClubbings);
                						leaveCombModel.set("leaveType", obj.hrLeaveType.id);
                						leaveCombModel.set("leaveTypeName", leaveTypeName);
                						leaveCombModel.set("leaveCombineWith", leaveCombineArr.join(', '));
                						leaveCombModel.set("leaveCombineWithIds", obj.clubbingLeaveTypeIds);
                						leaveCombModel.commit();
                						ObjModelClubbings.push(leaveCombModel);
                						cntClubbings = cntClubbings+1;
                						gridLeaveCombination.getStore().loadRawData(ObjModelClubbings, true);
                						
                						
                						if(gridLeaveCombination.getStore().data.items.length==listClubbingsLength){
                                           Ext.getBody().unmask();
                						
                                        }
                					}
                				});
                			}
                		});
                	}
                	else{
                		gridLeaveCombination.getStore().removeAll();
                	}
                	if(!isNullOrEmpty(listHolidayCheck) && listHolidayCheck.length>0){
                		gridLeaveHolidayCheck.getStore().removeAll();
                		var ObjModelHC = [];
                		var cntHC = 1; 
                		listHolidayCheck.forEach(function(obj){
                			var leaveServiceEligibilityModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveServiceEligibilityModel();
                			leaveServiceEligibilityModel.set("serialNo", cntHC);
                			leaveServiceEligibilityModel.set("id", obj.id);
                            leaveServiceEligibilityModel.set("leaveType", obj.hrLeaveType.id);
                            leaveServiceEligibilityModel.set("leaveTypeName", obj.hrLeaveType.value);
                            leaveServiceEligibilityModel.set("holidayCheck", obj.holidayCheck);
                            leaveServiceEligibilityModel.set("isEditable", 'ADD');
                            leaveServiceEligibilityModel.set("isAddDeleteRow", true);
                            leaveServiceEligibilityModel.commit();
                            ObjModelHC.push(leaveServiceEligibilityModel);
                            cntHC = cntHC+1;
                    	});
                		gridLeaveHolidayCheck.getStore().loadRawData(ObjModelHC, true);
                	}
                	else{
                		gridLeaveHolidayCheck.getStore().removeAll();
                		gridLeaveHolidayCheck.down('#btnAdd').show();
                	}
                }
            }
        });
    },
    
    addNewRowInLeaveServiceEligibilityGrid: function(serialNo) {
        var $this = this;
        var grid = $this.getLeaveserviceeligibilitygrid();
        var ObjModel = [];
        var leaveServiceEligibilityModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveServiceEligibilityModel();

        leaveServiceEligibilityModel.set("serialNo", serialNo);
        leaveServiceEligibilityModel.set("leaveType", '');
        leaveServiceEligibilityModel.set("servicePeriodType", '');
        leaveServiceEligibilityModel.set("minimumServiceTerm", 1);
        leaveServiceEligibilityModel.set("isEditable", 'ADD');
        leaveServiceEligibilityModel.set("isAddDeleteRow", true);

        ObjModel.push(leaveServiceEligibilityModel);
        grid.getStore().loadRawData(ObjModel, true);
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        }
        var gridDom = grid.el ? grid.el.dom : null;
		gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();	
    },
    addNewRowInLeaveSanctioningDaysGrid: function(serialNo) {
        var $this = this;
        var grid = $this.getLeavesanctioningdaysgrid();
        var ObjModel = [];
        var leaveServiceEligibilityModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveServiceEligibilityModel();
        leaveServiceEligibilityModel.set("serialNo", serialNo);
        leaveServiceEligibilityModel.set("leaveType", '');
        leaveServiceEligibilityModel.set("leaveTypeName", '');
        leaveServiceEligibilityModel.set("minDays", 0);
        leaveServiceEligibilityModel.set("maxDays", 1);
        leaveServiceEligibilityModel.set("isEditable", 'ADD');
        leaveServiceEligibilityModel.set("isAddDeleteRow", true);
        ObjModel.push(leaveServiceEligibilityModel);
        grid.getStore().loadRawData(ObjModel, true);
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        }
        var gridDom = grid.el ? grid.el.dom : null;
		gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();	
    },
    addLeaveCombinationWinRecord: function(){
    	var $this=this;
    	var formWindow = $this.getLeavecominationformwindow();
		if (!formWindow) {
			Ext.widget('leavecominationformwindow');
			formWindow = $this.getLeavecominationformwindow();
		}
		formWindow.config.isEdit = false;
		formWindow.show();
    },
    addNewRowInLeaveCheckHolidayGrid: function(serialNo) {
        var $this = this;
        var grid = $this.getLeaveholidaycheckgrid();
        var ObjModel = [];
        var leaveServiceEligibilityModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveServiceEligibilityModel();

        leaveServiceEligibilityModel.set("serialNo", serialNo);
        leaveServiceEligibilityModel.set("leaveType", '');
        leaveServiceEligibilityModel.set("holidayCheck", '');
        leaveServiceEligibilityModel.set("isEditable", 'ADD');
        leaveServiceEligibilityModel.set("isAddDeleteRow", true);

        ObjModel.push(leaveServiceEligibilityModel);
        grid.getStore().loadRawData(ObjModel, true);
        if(serialNo == 1){
        	grid.down('#btnAdd').hide();
        }
        var gridDom = grid.el ? grid.el.dom : null;
		gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
    },
    cancelLeaveCombinationWin: function(){
    	var $this=this;
    	var formWindow = $this.getLeavecominationformwindow();
    	formWindow.close();
    },
    saveLeaveCombinationWinData: function(){
    	var $this = this;
        var grid = $this.getLeavecombinationgrid();
        var formWindow = $this.getLeavecominationformwindow();
        var ObjModel = [];
        var form = formWindow.down('form').getForm();
        var values = form.getValues();
        var leaveCombineArr = [];
        var leaveCombineIdsArr = [];
        
        if(formWindow.config.isEdit == true){

        	if(values.leaveCombineWith.length>0){
            	values.leaveCombineWith.forEach(function(obj){
            		if(Ext.isObject(obj)){
						leaveCombineArr.push(obj.data.value);
	            		leaveCombineIdsArr.push(obj.data.id);
					}
            	});
            }
        	var rec = grid.getSelectionModel().getSelection()[0];
        	rec.set("leaveCombineWith", leaveCombineArr.join(', '));
        	rec.set("leaveCombineWithIds", leaveCombineIdsArr.join(','));
        	formWindow.close();
            grid.getSelectionModel().deselectAll(true);
        }
        else{
        	var leaveCombModel = new Academia.model.leavemanagement.leavegeneralsetting.LeaveCombinationModel();
            var count = grid.getStore().getCount();
            
            count = count+1;
            
           
            var leaveTypeName = form.findField('leaveType').getRawValue();

            if(values.leaveCombineWith.length>0){
            	values.leaveCombineWith.forEach(function(obj){
            		leaveCombineArr.push(obj.data.value);
            		leaveCombineIdsArr.push(obj.data.id);
            	});
            }
            leaveCombModel.set("serialNo", count);
            leaveCombModel.set("leaveType", values.leaveType);
            leaveCombModel.set("leaveTypeName", leaveTypeName);
            leaveCombModel.set("leaveCombineWith", leaveCombineArr.join(', '));
            leaveCombModel.set("leaveCombineWithIds", leaveCombineIdsArr.join(','));

            // ObjModel.push(leaveCombModel);
            var store = grid.getStore().add(leaveCombModel);
            grid.getSelectionModel().deselectAll(true);
            var models = grid.getStore().getRange();
            for (var i = 0; i < models.length; i++) {
                models[i].data.serialNo = i + 1;
            }
            grid.getStore().loadRawData(models, true);
           // grid.getStore().loadRawData(ObjModel, true);
            formWindow.close();
            grid.getSelectionModel().deselectAll(true);
        }
        formWindow.config.isEdit = null;
    },
    editLeaveCombinationWinRecord: function(){
    	var $this=this;
    	var grid = $this.getLeavecombinationgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		var formWindow = $this.getLeavecominationformwindow();
    		if (!formWindow) {
    			Ext.widget('leavecominationformwindow');
    			formWindow = $this.getLeavecominationformwindow();
    		}
    		formWindow.config.isEdit = true;
    		formWindow.show();
    		var form = formWindow.down('form').getForm();
    		var leaveTypeFld= form.findField('leaveType');
    		
    		var leaveTypeFldStore = leaveTypeFld.getStore();
    		leaveTypeFldStore.load({
				callback:function(rec) {
					leaveTypeFld.setValue(record.data.leaveType);
					leaveTypeFld.setReadOnly(true);
				}
			});
			
    		var leaveCombineWith = form.findField('leaveCombineWith');
			var leaveCombineWithStore = leaveCombineWith.getStore();
			leaveCombineWith.setDisabled(false);
			/*leaveCombineWithStore.getProxy().extraParams={
				leaveTypeNotInIDs:record.data.leaveType
        	}*/
        	leaveCombineWithStore.load({
				callback:function(rec) {
					var leaveCombineIds = record.data.leaveCombineWithIds;
					var leaveCombineIds = leaveCombineIds.split(',').map(function(item) {
					    return parseInt(item, 10);
					});
					var leaveCombineArr = [];
					leaveCombineIds.forEach(function(val){
						var result = rec.filter(function (obj) {
							return obj.data.id === val;
						})[0];
						leaveCombineArr.push(result);
					});
					
					leaveCombineWith.setValue(leaveCombineArr);
				}
			});
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    deleteLeaveCombinationWinRecord: function(){
    	var $this=this;
    	var grid = $this.getLeavecombinationgrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection()[0];
    		var id=records.get("id");
    		showConfirmMessage(getPersonModuleTranslation('LEAVE_COMBINATION_GENERAL_SETTING'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes'){
    				if(!isNullOrEmpty(id)){
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.PATH_DELETE_HR_LEAVE_SETTING + '?id=' + id +'&leaveSettingType=CLUBBING',
    						method: 'DELETE',
    						params: {
    							id : id,
    							leaveSettingType:'CLUBBING'
    						},
    						headers: {
    							'Content-Type': 'application/json'
    						},
    						success: function(form, action) {
    							var store = grid.getStore().remove(records);
    							grid.getSelectionModel().deselectAll(true);
    							var models = grid.getStore().getRange();
    							for (var i = 0; i < models.length; i++) {
    								models[i].data.serialNo = i + 1;
    							}
    							grid.getStore().loadRawData(models, true);
    							showSuccessMessage(getPersonModuleTranslation('LEAVE_COMBINATION_GENERAL_SETTING'), getPersonModuleTranslation('LEAVE_COMBINATION_GENERAL_SETTING_DELETE_MSG'));
    						}
    					});
    				}
    				else{
    					var store = grid.getStore().remove(records);
    					grid.getSelectionModel().deselectAll(true);
    					var models = grid.getStore().getRange();
    					for (var i = 0; i < models.length; i++) {
    						models[i].data.serialNo = i + 1;
    					}
    					grid.getStore().loadRawData(models, true);
    				}
    			}
    		});
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    saveLeaveGeneralSetting: function(){
    	var $this=this;
    	var contentPanel = $this.getContentpanel();

    	var gridEligibility = $this.getLeaveserviceeligibilitygrid();
    	var gridSanctioning = $this.getLeavesanctioningdaysgrid();
    	var gridCombination = $this.getLeavecombinationgrid();
    	var gridHolidayCheck = $this.getLeaveholidaycheckgrid();

    	var jsonEligibility = [];
    	var jsonSanctioning = [];
    	var jsonCombination = [];
    	var jsonHolidayCheck = [];

    	var gridEligibilityStore = gridEligibility.getStore();
    	var gridSanctioningStore = gridSanctioning.getStore();
    	var gridCombinationStore = gridCombination.getStore();
    	var gridHolidayCheckStore = gridHolidayCheck.getStore();

    	var flagIsSave = true;
    	if(gridEligibilityStore.getCount()>0){
    		gridEligibilityStore.data.items.every(function(obj){
    			
    			if (isNullOrEmpty(obj.data.leaveType) || obj.data.leaveType.length == 0) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SERVICE_PERIOD_ELIGIBILITY_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_SELECT_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LMAS_LEAVE_TYPE') + ' in row ' + obj.data.serialNo );
    				flagIsSave = false;
    				return false;
    				
    			}
    			else if (isNullOrEmpty(obj.data.servicePeriodType) || obj.data.servicePeriodType.length == 0) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SERVICE_PERIOD_ELIGIBILITY_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_SELECT_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LEAVE_GENERAL_SETTING_SERVICE_PERIOD_TYPE') + ' in row ' + obj.data.serialNo );
    				flagIsSave = false;
    				return false;
    			}
    			else if (isNullOrEmpty(obj.data.minimumServiceTerm) || obj.data.minimumServiceTerm == 0) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SERVICE_PERIOD_ELIGIBILITY_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_FILL_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LEAVE_GENERAL_SETTING_MIN_SERVICE_TERM') + ' in row ' + obj.data.serialNo );
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var jsonObj = {
        					"id":obj.data.id,
        					"hrLeaveType":{
        						"id":obj.data.leaveType
        					},
        					"servicePeriodType":obj.data.servicePeriodType,
        					"minumumServiceTerm":obj.data.minimumServiceTerm
        			}
        			jsonEligibility.push(jsonObj);
    				return true;
    			}
    		});
    	}
    	if(gridSanctioningStore.getCount()>0){
    		gridSanctioningStore.data.items.every(function(obj){
    			
    			if (isNullOrEmpty(obj.data.leaveType) || obj.data.leaveType.length == 0) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_SELECT_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LMAS_LEAVE_TYPE') + ' in row ' + obj.data.serialNo);
    				flagIsSave = false;
    				return false;
    			}
    			else if (isNullOrEmpty(obj.data.minDays)) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_FILL_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LEAVE_GENERAL_SETTING_MIN_DAYS') + ' in row ' + obj.data.serialNo);
    				flagIsSave = false;
    				return false;
    			}
    			else if (isNullOrEmpty(obj.data.maxDays) || obj.data.maxDays == 0) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_FILL_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LEAVE_GENERAL_SETTING_MAX_DAYS') + ' in row ' + obj.data.serialNo);
    				flagIsSave = false;
    				return false;
    			}
    			else if (obj.data.minDays > obj.data.maxDays) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_SANCTIONING_DAYS_GENERAL_SETTING'), getPersonModuleTranslation('LEAVE_GENERAL_SETTING_MIN_MAX_CHECK') + ' in row ' + obj.data.serialNo);
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var jsonObj = {
        					"id":obj.data.id,
        					"hrLeaveType":{
        						"id":obj.data.leaveType
        					},
        					"minDays":obj.data.minDays,
        					"maxDays":obj.data.maxDays
        			}
        			jsonSanctioning.push(jsonObj);
    				return true;
    			}
    		});
    	}
    	if(gridHolidayCheckStore.getCount()>0){
    		gridHolidayCheckStore.data.items.every(function(obj){
    			if (isNullOrEmpty(obj.data.leaveType) || obj.data.leaveType.length == 0) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_SELECT_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LMAS_LEAVE_TYPE') + ' in row ' + obj.data.serialNo);
    				flagIsSave = false;
    				return false;
    			}
    			else if (isNullOrEmpty(obj.data.holidayCheck)) {
    				showWarningMessage(getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING'), getPersonModuleTranslation('PLEASE_FILL_GENERAL_SETTING') + ' ' +
    						getPersonModuleTranslation('LEAVE_HOLIDAY_CHECK_GENERAL_SETTING') + ' in row ' + obj.data.serialNo);
    				flagIsSave = false;
    				return false;
    			}
    			else{
    				var jsonObj = {
        					"id":obj.data.id,
        					"hrLeaveType":{
        						"id":obj.data.leaveType
        					},
        					"holidayCheck":obj.data.holidayCheck
        			}
    				jsonHolidayCheck.push(jsonObj);
    				return true;
    			}
    		});
    	}
    	if(gridCombinationStore.getCount()>0){
    		gridCombinationStore.data.items.forEach(function(obj){
    			var jsonObj = {
    					"id":obj.data.id,
    					"hrLeaveType":{
    						"id":obj.data.leaveType
    					},
    					"clubbingLeaveTypeIds":obj.data.leaveCombineWithIds
    			}
    			jsonCombination.push(jsonObj);
    		});
    	}

    	var jsonDataObj = {
    			"wsHRLeaveSettingServiePeriodElligibilityList":jsonEligibility,
    			"wsHRLeaveSettingSanctioningDaysList":jsonSanctioning,
    			"wsHRLeaveSettingClubbingList":jsonCombination,
    			"wsHRLeaveSettingHolidayCheckList":jsonHolidayCheck
    	}

    	if(flagIsSave){
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.PATH_SAVE_HR_LEAVE_SETTING,
    			jsonData: jsonDataObj,
    			method: 'POST',
    			success: function(frm, action) {
    				Ext.getBody().unmask();
    				var data = frm.responseText;
    				var tabName = getPersonModuleTranslation('LEAVE_GENERAL_SETTING');
    				var getcontroller=$this.getController('menu.CoreERPNavigationController');
    				var getTab=getcontroller.getTab(tabName);
    				if(getTab!=null){
    					contentPanel.remove(getTab, true);
    				}
    				showSuccessMessage(getPersonModuleTranslation('LEAVE_GENERAL_SETTING'), getPersonModuleTranslation('LEAVE_GENERAL_SETTING_SAVED_MSG'));
    			}
    		});
    	}
    }
});