/**
 *  @author Soham.Gurjar
 * 
 */
Ext.define('Academia.controller.lecturerCostingDefinition.LecturerCostingDefinitionController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['Academia.model.common.IdValueCodeDataModel','Academia.model.lecturercostingdefinition.LCDCourseGridModel','Academia.model.importutility.ModuleName'],
    
    stores : ['common.AcademicTermStoreForIntakeYearId','common.MappedFacultyStore','programCourseDashboard.ParameterisedCoursesStore',
    		  'coursetransaction.sectionmanagement.CoruseVariantSectionStore','lecturercostingdefinition.LCDCourseStore','lecturercostingdefinition.LCDCourseVariantStore',
    		  'lecturercostingdefinition.LCDCourseGridStore','feeandpayment.AccountingConfigCurrencyStore','lecturercostingdefinition.LCDEditCourseStore',
    		  'othermasters.servicemaster.ServiceCoordinatorComboStore','Academia.store.lecturercostingdefinition.LCDEditServiceStore','lecturercostingdefinition.LecturerCostingTypeComboStore',
    		  'importutility.ImportLecturerCostingStore','importutility.ImportLecturerCostingUploadGridStore'],
    
	views : [
		'lecturerCostingDefinition.LecturerCostingDefinitionStructure','lecturerCostingDefinition.LecturerCostingCourseFilter','lecturerCostingDefinition.ManageLecturerCostDefinitionStructure',
		'lecturerCostingDefinition.LecturerCostingCourseGrid','lecturerCostingDefinition.LCDAddCostWindow','lecturerCostingDefinition.LCDEditCourseWindow','Academia.view.lecturerCostingDefinition.LecturerCostingServiceFilter'
		,'Academia.view.lecturerCostingDefinition.LecturerCostingServiceGrid','Academia.view.lecturerCostingDefinition.LCDAddCostServiceWindow','Academia.view.lecturerCostingDefinition.LCDEditServiceWindow','Academia.view.lecturerCostingDefinition.LecturerCostingUploadDownloadStructure',
		'Academia.view.lecturerCostingDefinition.DownloadBulkImportCostingTypeForm','Academia.view.lecturerCostingDefinition.DownloadCourseCostingForm','Academia.view.lecturerCostingDefinition.DownloadServiceCostingForm',
		'Academia.view.lecturerCostingDefinition.UploadLecturerCostingUploadForm','Academia.view.importutility.ImportByModule.ImportUtilitylecturerCostingList','Academia.view.UploadOptionRadioGroup',
		'Academia.view.lecturerCostingDefinition.LecturerCostingCourseInnerGrid','Academia.view.lecturerCostingDefinition.LecturerCostingCourseInnerDetails',
		'Academia.view.lecturerCostingDefinition.LecturerCostingServiceInnerGrid','Academia.view.lecturerCostingDefinition.LecturerCostingServiceInnerDetails'
	],	 
	
	config:{
		LECTURER_COSTING_DEFINITION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LECTURER_COSTING_DEFINITION_PRIVILEGES')  		  
	},
               
     refs : [{
    	 ref : 'lecturercostingdefinitionstructure',
    	 selector : 'lecturercostingdefinitionstructure'
     },{
    	 ref : 'lecturercostingcoursefilter',
    	 selector : 'lecturercostingcoursefilter'
     },
     {
    	 ref : 'managelecturercostdefinitionstructure',
    	 selector : 'managelecturercostdefinitionstructure'
     },
     {
    	 ref : 'lecturercostingcoursegrid',
    	 selector : 'lecturercostingcoursegrid'
     },
     {
    	 ref : 'lcdaddcostwindow',
    	 selector : 'lcdaddcostwindow'
     },
     {
    	 ref : 'lcdeditcoursewindow',
    	 selector : 'lcdeditcoursewindow'
     },
     {
    	 ref : 'lecturercostingservicefilter',
    	 selector : 'lecturercostingservicefilter'
     },
     {
    	 ref : 'lecturercostingservicegrid',
    	 selector : 'lecturercostingservicegrid'
     },
     {
    	 ref : 'lcdaddcostservicewindow',
    	 selector : 'lcdaddcostservicewindow'
     },
     {
    	 ref : 'lcdeditservicewindow',
    	 selector : 'lcdeditservicewindow'
     },
     {
    	 ref : 'lecturercostinguploaddownloadstructure',
    	 selector : 'lecturercostinguploaddownloadstructure'
     },
     {
    	 ref : 'downloadbulkimportcostingtypeform',
    	 selector : 'downloadbulkimportcostingtypeform'
     },
     {
    	 ref : 'downloadcoursecostingform',
    	 selector : 'downloadcoursecostingform'
     },
     {
    	 ref : 'downloadservicecostingform',
    	 selector : 'downloadservicecostingform'
     },
     {
    	 ref : 'uploadlecturercostinguploadform',
    	 selector : 'uploadlecturercostinguploadform'
     },
     {
    	 ref : 'importutilitylecturercostinglist',
    	 selector : 'importutilitylecturercostinglist'
     },
     {
    	 ref : 'uploadoptionradiogroup',
    	 selector : 'uploadoptionradiogroup' 
     },{
    	 ref : 'lecturercostingcourseinnergrid',
    	 selector : 'lecturercostingcourseinnergrid'
     },{
    	 ref : 'lecturercostingcourseinnerdetails',
    	 selector : 'lecturercostingcourseinnerdetails'
     },{
    	 ref : 'lecturercostingserviceinnergrid',
    	 selector : 'lecturercostingserviceinnergrid'
     },{
    	 ref : 'lecturercostingserviceinnerdetails',
    	 selector : 'lecturercostingserviceinnerdetails'
     }],

	init : function() {
		this.control({
			'lecturercostingdefinitionstructure' : {
				beforerender:function(){
					this.getLecturercostingcoursegrid().getStore().removeAll();
					this.getLecturercostingservicegrid().getStore().removeAll();
				},
				afterrender : function(structure){
   				 this.disableLecturerCostingDefinitionRadioButton(structure, this.getLECTURER_COSTING_DEFINITION_PRIVILEGES());
				}
			},
			
			'managelecturercostdefinitionstructure' : {
				beforerender : function(structure){
					 Ext.suspendLayouts();
					 this.disableBulkImportLecturerCostingDefinition(structure, this.getLECTURER_COSTING_DEFINITION_PRIVILEGES());
	   				 Ext.resumeLayouts();
				}
			},
			
			'lecturercostingdefinitionstructure radiogroup[itemId=costTypeId]': {
				change : function(value,newValue,oldValue){
					this.onChangeCostType(value,newValue,oldValue);
				}
			},
			
			'lecturercostingcoursefilter': {
			/*	beforerender: function(filter){
					var me = this;
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermField = filter.down('#academicTerm');
					var academicTermFieldStore = academicTermField.getStore();
					
					academicTermFieldStore.load({
						callback: function(rec, success) {
							if (success) {
								for(var i in rec){
									if(rec[i].get('sequence')==1){
										academicTermCombo.setValue(rec[i].get('id'));
									}
								}
							}
						}
					});

				},*/
				afterrender: function(filter){
					var me = this;
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermField = filter.down('#academicTerm');
					var academicTermFieldStore = academicTermField.getStore();
					var courseField = filter.down('#courseCodeId');
					var courseFieldStore = courseField.getStore();
					var lecturerField= filter.down('#lecturerId');
					var lecturerFieldStore = lecturerField.getStore();
					var batchField = filter.down('#programWiseProgramId');
					var periodField = filter.down('#programWisePeriodId');
					var batchStore =batchField.getStore();
					var periodFieldStore= periodField.getStore();

					var courseVariantField= filter.down('#courseVariantId');
					var courseVariantFieldStore = courseVariantField.getStore();
					academicTermFieldStore.load({
						callback: function(rec, success) {
							if (success) {
								for(var i in rec){
									if(rec[i].get('sequence')==1){
										academicTermCombo.setValue(rec[i].get('id'));
									}
								}
							}
						}
					});

							
					if(!courseField.isVisible()){
						me.setAllowBlank(courseField, true);
					}
					if(!lecturerField.isVisible()){
						me.setAllowBlank(lecturerField, true);
					}
					if(!courseVariantField.isVisible()){
						me.setAllowBlank(courseVariantField, true);
					}
					if(!batchField.isVisible()){
						me.setAllowBlank(batchField, true);
					}
					if(!periodField.isVisible()){
						me.setAllowBlank(periodField, true);
					}
				}
			},
			
			'lecturercostingservicefilter': {
				afterrender: function(filter){
					var me = this;
					var academyLocationId=this.getCurrentAcademyLocation();
					var service = filter.down('#serviceId');
					var serviceFieldStore = service.getStore();
					var serviceCordinatorField= filter.down('#serviceCoordinatorId');
					var serviceCordinatorFieldStore = serviceCordinatorField.getStore();

			
					serviceFieldStore.getProxy().extraParams= {
						alId:academyLocationId
					};
					serviceFieldStore.load();
					
					serviceCordinatorFieldStore.getProxy().extraParams= {
						alId:academyLocationId
					};
					serviceCordinatorFieldStore.load()


					
					if(!service.isVisible()){
						me.setAllowBlank(service, true);
					}
					if(!serviceCordinatorField.isVisible()){
						me.setAllowBlank(serviceCordinatorField, true);
					}
					
					filter.isValid();
				}
			},
			
			'lecturercostingcoursefilter combo#academicTerm' :{
				 select: function(obj, record) {
					 var $this = this;
					 var filter = $this.getLecturercostingcoursefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermId = record[0].get("id");
					var lecturerField= filter.down('#lecturerId');
					var courseField = filter.down('#courseCodeId');
					var courseVariantField= filter.down('#courseVariantId');
					var batchField= filter.down('#programWiseProgramId');
					var periodField = filter.down('#programWisePeriodId');
					var lecturerFieldStore = lecturerField.getStore();
					var courseVariantFieldStore = courseVariantField.getStore();
					var courseFieldStore = courseField.getStore();
					var batchStore = batchField.getStore();
					lecturerField.reset();
					courseField.reset();
					courseVariantField.reset();
					batchField.reset();
					periodField.reset()
					periodField.setDisabled(true);
					
					lecturerField.setDisabled(false);
					courseField.setDisabled(false);
					batchField.setDisabled(false);
					
					lecturerFieldStore.getProxy().extraParams= {
						academyLocationId:academyLocationId,
						academicTermId:academicTermId
					};
					lecturerFieldStore.load();
					
					courseFieldStore.getProxy().extraParams= {
						alId:academyLocationId,
						academicTermId:academicTermId
					};
					courseFieldStore.load();
					
					batchStore.getProxy().extraParams= {
						academyLocationIds:academyLocationId,
						academicTermIds:academicTermId
					};
					batchStore.load();
					
					
					
					
				 }
			},
			
			'lecturercostingcoursefilter multiselectcombofield#lecturerId' :{
				change: function() {
					 var $this = this;
					var filter = $this.getLecturercostingcoursefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermId = filter.down("#academicTerm").getValue();
					var facultyIds = filter.down('multiselectcombofield#lecturerId').getValue();
					var courseField = filter.down('#courseCodeId');
					var courseVariantField= filter.down('#courseVariantId');
					var batchField= filter.down('#programWiseProgramId');
					var periodField = filter.down('#programWisePeriodId');
					var courseVariantFieldStore = courseVariantField.getStore();
					var courseFieldStore = courseField.getStore();
					var batchStore = batchField.getStore();
					
					
					var facultyIdsArr=[];
					
					 if(!isNullOrEmpty(facultyIds)) {
		        		 Ext.each(facultyIds,function(facultyId){
		        			 if(typeof facultyId=="number"){
		        				 facultyIdsArr.push(facultyId);
		        			 }
		        		 });
		        	 }
		        	 
		        	var facultyIdsString= facultyIdsArr.join();
					courseField.reset();
					courseVariantField.reset();
					batchField.reset();
					periodField.reset()
					periodField.setDisabled(true);
					courseVariantField.setDisabled(true);
					
					if(facultyIdsArr.length>0){
					
					courseFieldStore.getProxy().extraParams= {
						alId:academyLocationId,
						academicTermId:academicTermId,
						facultyIds:facultyIdsString
					};
					courseFieldStore.load();
							
					batchStore.getProxy().extraParams= {
						academyLocationIds:academyLocationId,
						academicTermIds:academicTermId,
						facultyIds:facultyIdsString
					};
					batchStore.load();
					
					}
					
				 }
			},
			
			'lecturercostingcoursefilter multiselectcombofield#courseCodeId' :{
				change: function() {
					 var $this = this;
					 var filter = $this.getLecturercostingcoursefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermId = filter.down("#academicTerm").getValue();
					var facultyIds = filter.down('multiselectcombofield#lecturerId').getValue();
					var courseIds = filter.down('multiselectcombofield#courseCodeId').getValue();
					var courseVariantField= filter.down('#courseVariantId');
					var batchField= filter.down('#programWiseProgramId');
					var periodField = filter.down('#programWisePeriodId');
					var courseVariantFieldStore = courseVariantField.getStore();
					var batchStore = batchField.getStore();
					courseVariantField.reset();
					batchField.reset();
					periodField.reset()
					periodField.setDisabled(true);
					courseVariantField.setDisabled(true);

					 var facultyId = [];
		        	 if(facultyIds !=undefined && facultyIds.length > 0){
		        		 for(var i in facultyIds){
		        			 if(Ext.isObject(facultyIds[i])){
		        				 facultyId.push(facultyIds[i].get("id"));
		        			 }else{
		        				 facultyId.push(facultyIds[i]);
		        			 }
		        		 }
		        	 }
		        	 
		        	var facultyIdsString= facultyId.join();
		        	
		        	var courseIdsArr=[];
					
					 if(!isNullOrEmpty(courseIds)) {
		        		 Ext.each(courseIds,function(courseId){
		        			 if(typeof courseId=="number"){
		        				 courseIdsArr.push(courseId);
		        			 }
		        		 });
		        	 }
		        	 
		        	var courseIdsString= courseIdsArr.join();
		        	
		        	if(courseIdsArr.length > 0){
		        	courseVariantField.setDisabled(false);
					courseVariantFieldStore.getProxy().extraParams= {
						alId:academyLocationId,
						academicTermId:academicTermId,
						facultyIds:facultyIdsString,
						courseIds:courseIdsString,
					};
					courseVariantFieldStore.load();
					
					batchStore.getProxy().extraParams= {
						academyLocationIds:academyLocationId,
						academicTermIds:academicTermId,
						facultyIds:facultyIdsString,
						courseIds:courseIdsString,
					};
					batchStore.load();
		        	}
				}
			},
			
			'lecturercostingcoursefilter multiselectcombofield#courseVariantId' :{
				change: function() {
					 var $this = this;
					 var filter = $this.getLecturercostingcoursefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermId = filter.down("#academicTerm").getValue();
					var facultyIds = filter.down('multiselectcombofield#lecturerId').getValue();
					var courseIds = filter.down('multiselectcombofield#courseCodeId').getValue();
					var courseVariantIds= filter.down('#courseVariantId').getValue();
					var batchField= filter.down('#programWiseProgramId');
					var periodField = filter.down('#programWisePeriodId');
					var batchStore = batchField.getStore();
					batchField.reset();
					periodField.reset()
					periodField.setDisabled(true);

					 var facultyId = [];
		        	 if(facultyIds !=undefined && facultyIds.length > 0){
		        		 for(var i in facultyIds){
		        			 if(Ext.isObject(facultyIds[i])){
		        				 facultyId.push(facultyIds[i].get("id"));
		        			 }else{
		        				 facultyId.push(facultyIds[i]);
		        			 }
		        		 }
		        	 }
		        	 
		        	var facultyIdsString= facultyId.join();
		        	
					 var courseId = [];
		        	 if(courseIds !=undefined && courseIds.length > 0){
		        		 for(var i in courseIds){
		        			 if(Ext.isObject(courseIds[i])){
		        				 courseId.push(courseIds[i].get("id"));
		        			 }else{
		        				 courseId.push(courseIds[i]);
		        			 }
		        		 }
		        	 }
		        	 
		        	var courseIdsString= courseId.join();
		        	
		        	var courseVariantIdsArr=[];
					
					 if(!isNullOrEmpty(courseVariantIds)) {
		        		 Ext.each(courseVariantIds,function(courseVariantId){
		        			 if(typeof courseVariantId=="number"){
		        				 courseVariantIdsArr.push(courseVariantId);
		        			 }
		        		 });
		        	 }
		        	 
		        	var courseVariantIdsString= courseVariantIdsArr.join();
					if(courseVariantIdsArr.length>0){
					batchStore.getProxy().extraParams= {
						academyLocationIds:academyLocationId,
						academicTermIds:academicTermId,
						facultyIds:facultyIdsString,
						courseIds:courseIdsString,
						courseVariantIds:courseVariantIdsString
					};
					batchStore.load();
					}
				 }
			},
			
			'lecturercostingcoursefilter multiselectcombofield#programWiseProgramId' :{
				change: function() {
					 var $this = this;
					 var filter = $this.getLecturercostingcoursefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTermId = filter.down("#academicTerm").getValue();
					var facultyIds = filter.down('multiselectcombofield#lecturerId').getValue();
					var courseIds = filter.down('multiselectcombofield#courseCodeId').getValue();
					var courseVariantIds= filter.down('#courseVariantId').getValue();
					var batchIds= filter.down('#programWiseProgramId').getValue();
					var periodField = filter.down('#programWisePeriodId');
					var periodStore = periodField.getStore();
					periodField.setDisabled(true);

					 var facultyId = [];
		        	 if(facultyIds !=undefined && facultyIds.length > 0){
		        		 for(var i in facultyIds){
		        			 if(Ext.isObject(facultyIds[i])){
		        				 facultyId.push(facultyIds[i].get("id"));
		        			 }else{
		        				 facultyId.push(facultyIds[i]);
		        			 }
		        		 }
		        	 }
		        	 
		        	var facultyIdsString= facultyId.join();
		        	
					 var courseId = [];
		        	 if(courseIds !=undefined && courseIds.length > 0){
		        		 for(var i in courseIds){
		        			 if(Ext.isObject(courseIds[i])){
		        				 courseId.push(courseIds[i].get("id"));
		        			 }else{
		        				 courseId.push(courseIds[i]);
		        			 }
		        		 }
		        	 }
		        	 
		        	var courseIdsString= courseId.join();
		        	
		        	 var courseVariantId = [];
		        	 if(courseVariantIds !=undefined && courseVariantIds.length > 0){
		        		 for(var i in courseVariantIds){
		        			 if(Ext.isObject(courseVariantIds[i])){
		        				 courseVariantId.push(courseVariantIds[i].get("id"));
		        			 }else{
		        				 courseVariantId.push(courseVariantIds[i]);
		        			 }
		        		 }
		        	 }
		        	 
		        	var courseVariantIdsString= courseVariantId.join();
		        	
		        	var batchIdsArr=[];
					
					 if(!isNullOrEmpty(batchIds)) {
		        		 Ext.each(batchIds,function(batchId){
		        			 if(typeof batchId=="number"){
		        				 batchIdsArr.push(batchId);
		        			 }
		        		 });
		        	 }
		        	 
		        	var batchIdsString= batchIdsArr.join();
		        	
		        	if(batchIdsArr.length > 0){
		        		periodField.setDisabled(false);
		        		
		        		periodStore.getProxy().extraParams= {
						academyLocationIds:academyLocationId,
						academicTermIds:academicTermId,
						facultyIds:facultyIdsString,
						courseIds:courseIdsString,
						courseVariantIds:courseVariantIdsString,
						batchIds:batchIdsString
					};
		        		periodStore.load();
		        	}
				 }
			},
			'lecturercostingcoursefilter multiselectcombofield#programWisePeriodId' :{
				change: function() {
					 var $this = this;
					 var filter = $this.getLecturercostingcoursefilter();
					 var searchBtn =filter.down('#lecturerCostingSearchBtn');
					 var form = filter.getForm();
					 if(form.isValid()){
						 searchBtn.setDisabled(false);
					 }
					 else{
						 searchBtn.setDisabled(true);
					 }
		        	
				 }
			},
			'lecturercostingservicefilter multiselectcombofield#serviceId' :{
				change: function() {
					 var $this = this;
					 var filter = $this.getLecturercostingservicefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var serviceIds = filter.down('multiselectcombofield#serviceId').getValue();
					var serviceCordinator= filter.down('#serviceCoordinatorId');
					var serviceCordinatorFieldStore = serviceCordinator.getStore();
					serviceCordinator.reset();
 
		        	var service=[];
					
					 if(!isNullOrEmpty(serviceIds)) {
		        		 Ext.each(serviceIds,function(serviceId){
		        			 if(typeof serviceId=="number"){
		        				 service.push(serviceId);
		        			 }
		        		 });
		        	 }
		        	 
		        	var serviceIdsString= service.join();
		        	serviceCordinatorFieldStore.getProxy().extraParams= {
						alId:academyLocationId,
						serviceIds:serviceIdsString
					};
		        	serviceCordinatorFieldStore.load();
				 }
			},
			'lecturercostingcoursefilter button[itemId=resetButton]' :{
				click : function(){
					 var $this = this;
					 var filter = $this.getLecturercostingcoursefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var academicTerm = filter.down('#academicTerm');
					var lecturerField= filter.down('#lecturerId');
					var courseField = filter.down('#courseCodeId');
					var courseVariantField= filter.down('#courseVariantId');
					var batchField= filter.down('#programWiseProgramId')
					var periodField = filter.down('#programWisePeriodId');
					var lecturerFieldStore = lecturerField.getStore();
					var courseVariantFieldStore = courseVariantField.getStore();
					var courseFieldStore = courseField.getStore();
					var batchStore = batchField.getStore();
					
					academicTerm.clearValue();
					lecturerField.reset();
					courseField.reset();
					courseVariantField.reset();
					batchField.reset();
					periodField.clearValue();
					periodField.reset();
					lecturerField.setDisabled(true);
					courseField.setDisabled(true);
					batchField.setDisabled(true);
					
				 }
			},
			
			'lecturercostingservicefilter button[itemId=resetButton]' :{
				click : function(){
					 var $this = this;
					 var filter = $this.getLecturercostingservicefilter();
					var academyLocationId=this.getCurrentAcademyLocation();
					var serviceField = filter.down('#serviceId');
					var serviceCordinatorField= filter.down('#serviceCoordinatorId');
					var serviceFieldStore = serviceField.getStore();
					var serviceCordinatorFieldStore = serviceCordinatorField.getStore();
					
					
					serviceField.clearValue();
					serviceCordinatorField.clearValue();
				

					serviceFieldStore.getProxy().extraParams= {
						alId:academyLocationId
					};
					serviceFieldStore.load();

					serviceCordinatorFieldStore.getProxy().extraParams={
						alId:academyLocationId
					}
					serviceCordinatorFieldStore.load();
				 }
			},
			'lecturercostingcoursefilter button[itemId=lecturerCostingSearchBtn]' :{
				 click : this.loadLCDCourseGrid
			},
			
			'lecturercostingservicefilter button[itemId=lcdServiceSearchBtn]' :{
				 click : this.loadLCDServiceGrid
			},
			
			'lecturercostingcoursegrid':{
				selectionchange: function (column, selected, eOpts) {
                    var grid = this.getLecturercostingcoursegrid();
                    this.enableDisableAddCostButton(column, selected);
                },
                cellclick: this.onCostDetailsClick
			},
			
			'lecturercostingservicegrid':{
				selectionchange: function (column, selected, eOpts) {
                    var grid = this.getLecturercostingservicegrid();
                    this.enableDisableAddCostServiceButton(column, selected);
                },
                cellclick: this.onServiceCostDetailsClick
			},
			
			'lecturercostingcoursegrid button[itemId=addCourseCostingBtn]':{
				 click: function() {
    				 var $this = this;
    				 var grid = $this.getLecturercostingcoursegrid();
    				 if (grid.getSelectionModel().getCount() > 0) {
    					 this.showAddCostWindow();
    				 }else{
    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				 }
    			 }
		},
		'lecturercostingservicegrid button[itemId=addServiceCostingBtn]':{
			click: function() {
				var $this = this;
				var grid = $this.getLecturercostingservicegrid();
				if (grid.getSelectionModel().getCount() > 0) {
					this.showAddCostServiceWindow();
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
			}
		},
		'lcdaddcostwindow button[itemId=costCancelBtn]':{
			click: function() {
				this.getLcdaddcostwindow().destroy();
			}
		},
		
		'lcdaddcostwindow button[itemId=costSubmitBtn]':{
			click: function() {
				this.saveCourseCosting();
			}
		},
		
		'lcdaddcostservicewindow button[itemId=costServiceCancelBtn]':{
			click: function() {
				this.getLcdaddcostservicewindow().destroy();
			}
		},
		
		'lcdaddcostservicewindow button[itemId=costServiceSubmitBtn]':{
			click: function() {
				this.saveServiceCosting();
			}
		},
		'lcdeditcoursewindow':{
			afterrender: function(win){
				var me = this;
				me.disableLecturergridBtn(win, this.getLECTURER_COSTING_DEFINITION_PRIVILEGES());
				var currentIdx = win.recordIdx;
				me.loadLCDCourseWindow(win,currentIdx);
			}
		},
		
		'lcdeditservicewindow':{
			afterrender: function(win){
				var me = this;
				me.disableLecturerServicegridBtn(win, this.getLECTURER_COSTING_DEFINITION_PRIVILEGES());
				var currentIdx = win.recordIdx;
				me.loadLCDServiceWindow(win,currentIdx);
			}
		},
		
		'lcdeditcoursewindow button[itemId=addCourseCostingBtn] ':{
			click: function(btn){
				this.lcdEditCourseCost(btn);
			}
		},
		
		'lcdeditcoursewindow button[itemId=btnDelete] ':{
			click: function(btn){
				this.lcdDeleteCourseCost(btn);
			}
		},
		
		'lcdeditservicewindow button[itemId=editServiceCostingBtn] ':{
			click: function(btn){
				this.lcdEditServiceCost(btn);
			}
		},
		
		'lcdeditservicewindow button[itemId=btnDelete] ':{
			click: function(btn){
				this.lcdDeleteServiceCost(btn);
			}
		},
		
		'downloadbulkimportcostingtypeform combo#costingTypeId ':{
			   change: this.costingserviceFormChange
		},
		
		'downloadcoursecostingform combo#academicTerm ':{
			select:function(obj, record) {
				 var $this = this;
				 var filter = $this.getDownloadcoursecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				//var academicTermId = record[0].get("id");
				var programBatchField = filter.down("#programWiseProgramId");
				var periodField = filter.down("#programWisePeriodId");
				var lecturerField= filter.down('#lecturerId');
				var courseField = filter.down('#courseCodeId');
				var courseVariantField= filter.down('#courseVariantId');
				var programBatchStore = programBatchField.getStore();
				var periodStore = periodField.getStore();
				var lecturerFieldStore = lecturerField.getStore();
				var courseVariantFieldStore = courseVariantField.getStore();
				var courseFieldStore = courseField.getStore();
				
				var academicTermIdsArr = [];
				if(!isNullOrEmpty(record)) {
					Ext.each(record,function(academicTerm){
						if(typeof academicTerm=="number"){
							academicTermIdsArr.push(academicTerm);
						}else if(!isNullOrEmpty(academicTerm.data)){
							academicTermIdsArr.push(academicTerm.data.id);
						}
					});
				}
				
				programBatchField.reset();
				periodField.reset();
				lecturerField.reset();
				courseField.reset();
				courseVariantField.reset();
				
				
				programBatchField.setDisabled(true);
				periodField.setDisabled(true);
				lecturerField.setDisabled(true);
				courseField.setDisabled(true);
				courseVariantField.setDisabled(true);
				if(academicTermIdsArr.length > 0 && academyLocationId > 0) {
					var academicTermString = academicTermIdsArr.join();
				programBatchField.setDisabled(false);
				programBatchStore.getProxy().extraParams={
					academyLocationIds:academyLocationId,
					academicTermIds:academicTermString
				}
				
				programBatchStore.load();
					
				lecturerField.setDisabled(false);
				courseField.setDisabled(false);
				lecturerFieldStore.getProxy().extraParams= {
					academyLocationId:academyLocationId,
					academicTermIds:academicTermString
				};
				lecturerFieldStore.load();
				
				courseFieldStore.getProxy().extraParams= {
					alId:academyLocationId,
					academicTermIds:academicTermString
				};
				courseFieldStore.load();
				
				}
			}
		},
		
		'downloadcoursecostingform multiselectcombofield[itemId=programWiseProgramId]':{
			change:function(obj, record) {
				 var $this = this;
				 var filter = $this.getDownloadcoursecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				var academicTermId = filter.down('#academicTerm').getValue();
				var programBatchField = filter.down('#programWiseProgramId');
				var periodField = filter.down('#programWisePeriodId');
				var lecturerId= filter.down('#lecturerId').getValue();
				var courseId = filter.down('#courseCodeId').getValue();
				var courseVariantId= filter.down('#courseVariantId').getValue();
				var programBatchStore = programBatchField.getStore();
				var periodStore = periodField.getStore();
				
				 var courseIds = [];
	        	 if(courseId !=undefined && courseId.length > 0){
	        		 for(var i in courseId){
	        			 if(Ext.isObject(courseId[i])){
	        				 courseIds.push(courseId[i].get("id"));
	        			 }else{
	        				 courseIds.push(courseId[i]);
	        			 }
	        		 }
	        	 }
	        	 
	        	var courseIdString= courseIds.join();
	        	
	        	 var courseVariantIds = [];
	        	 if(courseVariantId !=undefined && courseVariantId.length > 0){
	        		 for(var i in courseVariantId){
	        			 if(Ext.isObject(courseVariantId[i])){
	        				 courseVariantIds.push(courseVariantId[i].get("id"));
	        			 }else{
	        				 courseVariantIds.push(courseVariantId[i]);
	        			 }
	        		 }
	        	 }
	        	 
	        	var courseVariantIdString= courseVariantIds.join();
	        	
	        	 var facultyIds = [];
	        	 if(lecturerId !=undefined && lecturerId.length > 0){
	        		 for(var i in lecturerId){
	        			 if(Ext.isObject(lecturerId[i])){
	        				 facultyIds.push(lecturerId[i].get("id"));
	        			 }else{
	        				 facultyIds.push(lecturerId[i]);
	        			 }
	        		 }
	        	 }
	        	 
	        	var facultyIdString= facultyIds.join();
				
				
				var batchIdsArr = [];
				if(!isNullOrEmpty(record)) {
					Ext.each(record,function(batch){
						if(typeof batch=="number"){
							batchIdsArr.push(batch);
						}else if(!isNullOrEmpty(batch.data)){
							batchIdsArr.push(batch.data.id);
						}
					});
				}
				
				periodField.reset();

				if(batchIdsArr.length > 0 || academyLocationId > 0) {
				var batchIds =batchIdsArr.join();
				if(batchIdsArr.length > 0){
				periodField.setDisabled(false);
				periodStore.getProxy().extraParams={
					academyLocationIds:academyLocationId,
					academicTermIds:academicTermId,
					batchIds : batchIds,
					courseIds : courseIdString,
					courseVariantIds : courseVariantIdString,
					facultyIds:facultyIdString
				};
				
				periodStore.load();
				}
		
				}
			}
		},
	
		
		'downloadcoursecostingform multiselectcombofield[itemId=lecturerId]':{
			change:function(obj, record) {
				 var $this = this;
				 var filter = $this.getDownloadcoursecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				var academicTermId = filter.down('#academicTerm').getValue();
				var batchField = filter.down('#programWiseProgramId')
				var periodField = filter.down('#programWisePeriodId')
				var courseId = filter.down('#courseCodeId').getValue();
				var courseVariantId= filter.down('#courseVariantId').getValue();
				var batchStore = batchField.getStore();
				var periodStore = periodField.getStore();
				
		
			
				 var courseIds = [];
	        	 if(courseId !=undefined && courseId.length > 0){
	        		 for(var i in courseId){
	        			 if(Ext.isObject(courseId[i])){
	        				 courseIds.push(courseId[i].get("id"));
	        			 }else{
	        				 courseIds.push(courseId[i]);
	        			 }
	        		 }
	        	 }
	        	 
	        	var courseIdString= courseIds.join();
	        	
	        	 var courseVariantIds = [];
	        	 if(courseVariantId !=undefined && courseVariantId.length > 0){
	        		 for(var i in courseVariantId){
	        			 if(Ext.isObject(courseVariantId[i])){
	        				 courseVariantIds.push(courseVariantId[i].get("id"));
	        			 }else{
	        				 courseVariantIds.push(courseVariantId[i]);
	        			 }
	        		 }
	        	 }
	        	 
	        	var courseVariantIdString= courseVariantIds.join();
				
				var facultyIdsArr = [];
				if(!isNullOrEmpty(record)) {
					Ext.each(record,function(faculty){
						if(typeof faculty=="number"){
							facultyIdsArr.push(faculty);
						}else if(!isNullOrEmpty(faculty.data)){
							facultyIdsArr.push(faculty.data.id);
						}
					});
				}
				
				
				
				periodField.reset();
				batchField.reset();
				
		
				if(facultyIdsArr.length > 0) {
				var facultyIds =facultyIdsArr.join();
				
				

				
				batchStore.getProxy().extraParams= {
					academyLocationIds:academyLocationId,
					academicTermIds:academicTermId,
					facultyIds:facultyIds,
					courseIds:courseIdString,
					courseVariantIds:courseVariantIdString
				};
				batchStore.load();
			
				
				}
			}
		},
		
		'downloadcoursecostingform multiselectcombofield[itemId=courseCodeId]':{
			change:function(obj, record) {
				 var $this = this;
				 var filter = $this.getDownloadcoursecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				var academicTermId = filter.down('#academicTerm').getValue();
				var batchField = filter.down('#programWiseProgramId')
				var periodField = filter.down('#programWisePeriodId')
				var facultyField = filter.down('#lecturerId')
				var courseVariantField= filter.down('#courseVariantId');
				var courseVariantFieldStore = courseVariantField.getStore();
				var facultyStore = facultyField.getStore();
				var batchStore = batchField.getStore();
				
	
				
				var courseIdsArr = [];
				if(!isNullOrEmpty(record)) {
					Ext.each(record,function(course){
						if(typeof course=="number"){
							courseIdsArr.push(course);
						}else if(!isNullOrEmpty(course.data)){
							courseIdsArr.push(course.data.id);
						}
					});
				}
				
	
				courseVariantField.reset();
				courseVariantField.setDisabled(true);
				facultyField.reset();
				batchField.reset();
				periodField.reset();
				
				if(courseIdsArr.length > 0) {
				var courseIds =courseIdsArr.join();
				courseVariantField.setDisabled(false);
				courseVariantFieldStore.getProxy().extraParams= {
					alId:academyLocationId,
					academicTermIds:academicTermId,
					courseIds:courseIds
				};
				courseVariantFieldStore.load();
				
				facultyStore.getProxy().extraParams= {
					alId:academyLocationId,
					academicTermIds:academicTermId,
					courseIds:courseIds
				};
				facultyStore.load();
				
				batchStore.getProxy().extraParams= {
					academyLocationIds:academyLocationId,
					academicTermIds:academicTermId,
					courseIds:courseIds
				};
				batchStore.load();
				
				
				}
			}
		},
		
		'downloadcoursecostingform multiselectcombofield[itemId=courseVariantId]':{
			change:function(obj, record) {
				 var $this = this;
				 var filter = $this.getDownloadcoursecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				var academicTermId = filter.down('#academicTerm').getValue();
				var batchField = filter.down('#programWiseProgramId')
				var periodField = filter.down('#programWisePeriodId')
				var facultyField = filter.down('#lecturerId')
				var courseId = filter.down('#courseCodeId').getValue()
				var courseVariantField= filter.down('#courseVariantId');
				var courseVariantFieldStore = courseVariantField.getStore();
				var facultyStore = facultyField.getStore();
				var batchStore = batchField.getStore();
				
				
			
				
				var courseIdsArr = [];
				if(!isNullOrEmpty(courseId)) {
					Ext.each(courseId,function(rec){
						if(typeof rec=="number"){
							courseIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							courseIdsArr.push(rec.data.id);
						}
					});
				}
				
				var courseIdsString = courseIdsArr.join();
				
				var courseVariantIdsArr = [];
				if(!isNullOrEmpty(record)) {
					Ext.each(record,function(courseVariant){
						if(typeof courseVariant=="number"){
							courseVariantIdsArr.push(courseVariant);
						}else if(!isNullOrEmpty(courseVariant.data)){
							courseVariantIdsArr.push(courseVariant.data.id);
						}
					});
				}
				
				var courseVariantIdsStr = courseVariantIdsArr.join();
			
				facultyField.reset();
				batchField.reset();
				periodField.reset();
				
				if(courseIdsArr.length > 0) {
				var courseIds =courseIdsArr.join();
			
				
				facultyStore.getProxy().extraParams= {
					alId:academyLocationId,
					academicTermIds:academicTermId,
					courseIds:courseIds,
					courseVariantIds:courseVariantIdsStr
				};
				facultyStore.load();
				
				batchStore.getProxy().extraParams= {
					academyLocationIds:academyLocationId,
					academicTermIds:academicTermId,
					courseIds:courseIds,
					courseVariantIds:courseVariantIdsStr
				};
				batchStore.load();
				
				
				}
			}
		},
		
		'downloadcoursecostingform button[itemId=resetBtn]' :{
			click : function(){
				 var $this = this;
				var filter = $this.getDownloadcoursecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				var academicTerm = filter.down('#academicTerm');
				var batchField = filter.down('#programWiseProgramId');
				var periodField = filter.down('#programWisePeriodId');
				var lecturerField= filter.down('#lecturerId');
				var courseField = filter.down('#courseCodeId');
				var courseVariantField= filter.down('#courseVariantId');
				var batchStore = batchField.getStore();
				var periodStore = periodField.getStore();
				var lecturerFieldStore = lecturerField.getStore();
				var courseVariantFieldStore = courseVariantField.getStore();
				var courseFieldStore = courseField.getStore();
				
				
/*				academicTerm.clearValue();
				batchField.clearValue();
				periodField.clearValue();
				lecturerField.clearValue();
				courseField.clearValue();
				courseVariantField.clearValue();*/
				
				academicTerm.reset();
				courseField.reset();
				courseVariantField.reset();
				lecturerField.reset();
				batchField.reset();
				periodField.reset();
				
				
				batchField.setDisabled(true);
				periodField.setDisabled(true);
				lecturerField.setDisabled(true);
				courseField.setDisabled(true);
				courseVariantField.setDisabled(true);
			 }
		},
		
		'downloadcoursecostingform button[itemId=downoladBtnId]' :{
			click:function(obj){
 				var $this = this;
 				var form = this.getDownloadbulkimportcostingtypeform();
 				var courseForm = this.getDownloadcoursecostingform();
 				var formValues = form.getValues();
 				var courseFormValues = courseForm.getValues();
 				
 				var academyLocationId = this.getCurrentAcademyLocation();
 				var costingtype = formValues.costingType
 				var academicTermIds = courseFormValues.academicTerm
 				var batchIds = courseFormValues.programWiseProgram
 				var periodString;
 				if(!isNullOrEmpty(courseFormValues.programWisePeriod)){
 				var periodIds = courseFormValues.programWisePeriod
 				var periodIdsArr = [];
				if(!isNullOrEmpty(periodIds)) {
					Ext.each(periodIds,function(rec){
						if(typeof rec=="number"){
							periodIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							periodIdsArr.push(rec.data.id);
						}
					});
				}
				var periodString = periodIdsArr.join();
 				}
 				var lecturerIds = courseFormValues.lecturer
 				var courseIds =courseFormValues.COURSE_ID
 				var courseVariantIds =courseFormValues.COURSE_VARIENT_ID
 				
 			
				
				var batchIdsArr = [];
				if(!isNullOrEmpty(batchIds)) {
					Ext.each(batchIds,function(rec){
						if(typeof rec=="number"){
							batchIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							batchIdsArr.push(rec.data.id);
						}
					});
				}
				
				var batchIdsString = batchIdsArr.join();
 				
				var lecturerIdsArr = [];
				if(!isNullOrEmpty(lecturerIds)) {
					Ext.each(lecturerIds,function(rec){
						if(typeof rec=="number"){
							lecturerIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							lecturerIdsArr.push(rec.data.id);
						}
					});
				}
				
				var lectureIdsString = lecturerIdsArr.join();
 				
				var courseIdsArr = [];
				if(!isNullOrEmpty(courseIds)) {
					Ext.each(courseIds,function(rec){
						if(typeof rec=="number"){
							courseIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							courseIdsArr.push(rec.data.id);
						}
					});
				}
				
				var courseIdsString = courseIdsArr.join();
				
				var courseVariantIdsArr = [];
				if(!isNullOrEmpty(courseVariantIds)) {
					Ext.each(courseVariantIds,function(rec){
						if(typeof rec=="number"){
							courseVariantIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							courseVariantIdsArr.push(rec.data.id);
						}
					});
				}
				
				var courseVariantIdsString = courseVariantIdsArr.join();
 				
 				var csvForm = Ext.create('Ext.form.Panel'); 
 				csvForm.getForm().submit({
 					target: '_blank',
 					method:'POST',
 					params :{
 						access_token : Ext.Ajax.defaultHeaders.access_token,
 						academyLocationId : academyLocationId,
 						academicTermId : academicTermIds,
 						costingtype : costingtype,
 		 				batchIds : batchIdsString,
 		 				periodIds : periodString,
 		 				lecturerIds:lectureIdsString,
 		 				courseIds:courseIdsString,
 		 				courseVariantIds:courseVariantIdsString
 					},
 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 					url: SERVERURL.PATH_DOWNLOAD_FILE_FOR_LECTURER_COSTING,
 					standardSubmit :true
 				});
 			}  
		}, 
		
		'downloadservicecostingform button[itemId=downoladBtnId]' :{
			click:function(obj){
 				var $this = this;
 				var form = this.getDownloadbulkimportcostingtypeform();
 				var serviceForm = this.getDownloadservicecostingform();
 				var formValues = form.getValues();
 				var serviceFormValues = serviceForm.getValues();
 				
 				var academyLocationId = this.getCurrentAcademyLocation();
 				var costingtype = formValues.costingType
 				var serviceString;
 				if(!isNullOrEmpty(serviceFormValues.serviceId)){
 				var serviceIds = serviceFormValues.serviceId
 				var serviceIdsArr = [];
				if(!isNullOrEmpty(serviceIds)) {
					Ext.each(serviceIds,function(rec){
						if(typeof rec=="number"){
							serviceIdsArr.push(rec);
						}else if(!isNullOrEmpty(rec.data)){
							serviceIdsArr.push(rec.data.id);
						}
					});
				}
				var serviceString = serviceIdsArr.join();
 				}
				
 				var csvForm = Ext.create('Ext.form.Panel'); 
 				csvForm.getForm().submit({
 					target: '_blank',
 					method:'POST',
 					params :{
 						access_token : Ext.Ajax.defaultHeaders.access_token,
 						academyLocationId : academyLocationId,
 						serviceIds : serviceString,
 						costingtype : costingtype
 					},
 					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 					url: SERVERURL.PATH_DOWNLOAD_FILE_FOR_LECTURER_COSTING,
 					standardSubmit :true
 				});
 			}  
		},
		
		'downloadservicecostingform button[itemId=resetBtn]' :{
			click : function(){
				 var $this = this;
				var filter = $this.getDownloadservicecostingform();
				var academyLocationId=this.getCurrentAcademyLocation();
				var serviceField = filter.down('#serviceId');
				var serviceStore = serviceField.getStore();
				
				serviceField.clearValue();
				serviceStore.getProxy().extraParams= {
					academyLocationId:academyLocationId
				}
				serviceStore.load();
			 }
		},
		 
		'lecturercostinguploaddownloadstructure radiogroup[itemId=importDownloadgroupId]': {
			change : this.onChangeDownloadUploadRadioBtn
			
		},
		
		'uploadlecturercostinguploadform button[itemId=resetBtn]':{
			click:function(obj){
				var $this = this;
				var form =obj.up('uploadlecturercostinguploadform').getForm();
				form.reset();
				form.findField('file').reset();
				var uploadoptionradiogroupform = $this.getUploadoptionradiogroup();
				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
					isUploadAll: false
				});
				form.isValid();
			}
		},
		'uploadlecturercostinguploadform customcombobox[itemId=uploadTypeItemId]': {
 			select: function(obj, record) {
 				var $this = this;
	 			var form = this.getUploadlecturercostinguploadform().getForm();
	 			var templateName = form.getValues().uploadType;
	 			var moduleName = null;
	 			if(templateName=="CourseType"){
					moduleName = "Lecturer Costing For Course";
				}else if(templateName=="ServiceType"){
					moduleName = "Lecturer Costing For Service";
				}
	 			var combo = form.findField('importUtilityMasterId');
 				combo.getStore().load({
 					callback: function(records, operation, success) {
 						for(var i in records){
 							if(records[i].data.value==moduleName){
 								combo.setValue(records[i].data.id);
 								combo.setReadOnly(true);
 							}
 						}
 					}	   
 				});
 				
 				var grid = $this.getImportutilitylecturercostinglist();
 				var form =this.getUploadoptionradiogroup();
 				var isUploadAll = form.items.items[0].getValue();
 				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, moduleName);
 			}
		},
		
		/*'uploadlecturercostinguploadform customcombobox[itemId=moduleName]':{
			select:function(obj, record){
				var $this = this;
				var grid = this.getImportutilitylecturercostinglist();
				var form = this.getUploadoptionradiogroup();
				var uploadForm =$this.getUploadlecturercostinguploadform();
				var templatecombo = uploadForm.down('#moduleName');
				var templateName = templatecombo.rawValue;
				if(!isNullOrEmpty(templateName)){
				if(templateName=="Lecturer Costing For Course"){
					moduleName = "Lecturer Costing For Course";
				}else if(templateName=="Assign Courses"){
					moduleName = "Assign Courses";
				}
				var isUploadAll = form.items.items[0].getValue().isUploadAll;
				this.onChangeUploadOptionRadioGroup(isUploadAll, grid, templateName);
			}
		}
	},*/
		
		// Upload form
		'uploadlecturercostinguploadform button[itemId=uploadId]':{
			click:function(obj){
				var $this=this;
				var form = this.getUploadlecturercostinguploadform();
	 			var templateName = form.getValues().uploadType;
	 			var moduleName = null;
	 			if(templateName=="CourseType"){
					moduleName = "Lecturer Costing For Course";
				}else if(templateName=="ServiceType"){
					moduleName = "Lecturer Costing For Service";
				}
				var submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			
				$this.getHashOfFile(form);
				setTimeout(function() {
					form.getForm().submit({
						method : 'POST',
						url : submitUrl,
						success : function(form, action){
							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						},
						failure: function(form, action) {
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
						}
					});
				},1000);
				Ext.defer(function() {
					var grid = $this.getImportutilitylecturercostinglist();
					var form = this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
				}, 2000, this);
			}  
		},
		
		'importutilitylecturercostinglist':{
			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				if (e.target.tagName == 'A') {
					var fileType=null;
					if(cellIndex==1){
						fileType='successFile';
					}else if(cellIndex==6){
						fileType='errorFile';
					}else if(cellIndex==7){
						fileType='logFile';
					}
					var documentId = record.get("id");
					if (!isNullOrEmpty(documentId)) {
						this.getDownloadFile(documentId,fileType);
					}
				}
			}
		},
		
		'importutilitylecturercostinglist button[itemId=btnForce]':{
			click: function(obj) {
				var grid = this.getImportutilitylecturercostinglist();
				if (grid.getSelectionModel().getCount() > 0) {
					if(grid.getSelectionModel().getCount() > 1){
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					}else{
						var this$ = this;
						var id = grid.getSelectionModel().selectionStart.data.id;
						console.log(id);
						var urlAppend="?jobName="+id;
						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						Ext.Ajax.request({
							url: submitURL,
							method: 'GET',
							success: function(response) {
								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
								}else if(response.responseText==="SUCCESS"){
									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
									grid.getStore().reload();
								}
							}
						});
					}
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}  
			}
		},
		
		'uploadoptionradiogroup radiogroup[itemId=uploadgroupItemId]':{
			change: function(radioGroup, newValue, oldValue, eOpts) {
				var grid = this.getImportutilitylecturercostinglist();
				var form = this.getUploadlecturercostinguploadform().getForm();
	 			var templateName = form.getValues().uploadType;
	 			var moduleName = null;
	 			if(templateName=="CourseType"){
					moduleName = "Lecturer Costing For Course";
				}else if(templateName=="ServiceType"){
					moduleName = "Lecturer Costing For Service";
				}
				var isUploadAll = newValue.isUploadAll;
				this.onChangeUploadOptionRadioGroup(isUploadAll, grid, moduleName);
				}
			},
			
			'lecturercostingcourseinnergrid': {
				afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getLECTURER_COSTING_DEFINITION_PRIVILEGES());
					},1500);
				}
			},
			'lecturercostingserviceinnergrid': {
				afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getLECTURER_COSTING_DEFINITION_PRIVILEGES());
					},1500);
				}
			}
			
		});
	},

			
	disableLecturerCostingDefinitionRadioButton: function(structure,permissionsMap) {
		 var associatedAcadLocationIds = new Array();
      	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
      	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
      	 var courseWise, serviceWise = false;
      	 var costTypeId=structure.down('#costTypeId');
      	costTypeId.setVisible(false);
      	Ext.each(permissionList, function(privilege) {
             if (privilege === 'COURSE_COSTING') {   
            	 courseWise = true;
               
             }
             if (privilege === 'SERVICE_COSTING') {
            	 serviceWise = true;
             }
      	});
      	if (courseWise && serviceWise) {
      		costTypeId.setVisible(true);
      		costTypeId.items.items[0].setValue(true);
      		costTypeId.items.items[1].setValue(false);
            
      	}
      	else if(serviceWise)
      	{	costTypeId.setVisible(false)
      		costTypeId.items.items[0].setValue(false);
      		costTypeId.items.items[1].setValue(true);
      	}
      	else if(courseWise)
      	{	costTypeId.setVisible(false);
      		costTypeId.items.items[0].setValue(true);
      		costTypeId.items.items[1].setValue(false)
      	}
	},
	
	disableLecturergridBtn: function(structure,permissionsMap) {
		 var associatedAcadLocationIds = new Array();
     	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
     	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
     	 var saveBtn =false;
     	 var deleteBtn =false;
     	 var courseEditWindow =this.getLcdeditcoursewindow();
     	 var saveCourseBtn = courseEditWindow.down('#addCourseCostingBtn');
     	 var deleteCourseBtn = courseEditWindow.down('#btnDelete');
   
     	saveCourseBtn.hide();
     	deleteCourseBtn.hide();

     	Ext.each(permissionList, function(privilege) {
            if (privilege === 'CREATE') {   
            	saveBtn = true;
              
            }
            if (privilege === 'DELETE') {
            	deleteBtn = true;
            }
     	});
     	
     	if(saveBtn){
     		saveCourseBtn.show();
     	}
     	if(deleteBtn){
     		deleteCourseBtn.show();
     	}
     	
	},
	
	disableLecturerServicegridBtn: function(structure,permissionsMap) {
		 var associatedAcadLocationIds = new Array();
    	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,permissionsMap);
    	 var saveBtn =false;
    	 var deleteBtn =false;
    	 var serviceEditWindow = this.getLcdeditservicewindow();
    	 var saveServiceBtn = serviceEditWindow.down('#editServiceCostingBtn');
    	 var deleteServiceBtn = serviceEditWindow.down('#btnDelete');
    	saveServiceBtn.hide();
    	deleteServiceBtn.hide();
    	Ext.each(permissionList, function(privilege) {
           if (privilege === 'CREATE') {   
           	saveBtn = true;
             
           }
           if (privilege === 'DELETE') {
           	deleteBtn = true;
           }
    	});
    	
    	if(saveBtn){
    		saveServiceBtn.show();
    	}
    	if(deleteBtn){
    		deleteServiceBtn.show();
    	}
    	
	},
	disableBulkImportLecturerCostingDefinition: function(structure,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var bulkCourse = false;
		Ext.each(permissionList, function(privilege) {
			if (privilege === "IMPORT_BULK_LECTURER_COSTING") {
				bulkCourse=true;
			}
		});

		var panelItem = new Array();
		var $this = this;
		var newcont = structure.items.items.length;
		var insertPosition = newcont;
		panelItem.push({
			xtype:'tabpanel',
			plain: true,
			style:{overflow:'hidden !important',margin:'0!important'},
			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			frame: false,
			border:false,
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'lecturercostingdefinitionstructure',
				title: getCommonTranslation('SEARCH'),
				tabCls: 'right-tab',
				listeners: {
                	activate: function(me, eOpts){
                		var contentPanelMain = $this.getActiveTabfromContentPanel();
                		if(!isNullOrEmpty(contentPanelMain)){
                			contentPanelMain.scrollBy(0,1);
                			contentPanelMain.scrollBy(0,-1);
                		}
                	}
                }
			}]
		});
    	var insertAt = panelItem["0"].items.length;;
		if(bulkCourse) {
			panelItem["0"].items[insertAt] = {
					xtype: 'lecturercostinguploaddownloadstructure',
					title: getProgramandcourseTranslation('BULK_IMPORT'),
				};
			insertAt = insertAt+1;
		}
		structure.insert(insertPosition, panelItem);
	},
	
	onChangeCostType : function(value,newValue,oldValue){
		var $this = this;
		var lcdCoursegrid = $this.getLecturercostingcoursegrid();
		var lcdServicegrid = $this.getLecturercostingservicegrid();
		var structure =  	$this.getLecturercostingdefinitionstructure();
		var courseCostingFilter = $this.getLecturercostingcoursefilter();
		var serviceCostingFilter = $this.getLecturercostingservicefilter();
		var alinfomodel = Academia.model.authentication.ALInfoModel;
		var wheatherSchool = alinfomodel.get('wheatherSchool');
		/*courseCostingFilter.getForm().reset()
		serviceCostingFilter.getForm().reset()
		lcdCoursegrid.getStore().removeAll();
		//lcdCoursegrid.getStore().loadRawData([]);
		lcdServicegrid.getStore().removeAll();*/
		//lcdServicegrid.getStore().loadRawData([]);
		if(newValue.weatherCourseOrService==true){
			courseCostingFilter.setVisible(true);
			serviceCostingFilter.setVisible(false);
			lcdCoursegrid.setVisible(true);
			lcdServicegrid.setVisible(false);
			courseCostingFilter.isValid();

		} else {
			courseCostingFilter.setVisible(false);
			serviceCostingFilter.setVisible(true);
			lcdCoursegrid.setVisible(false);
			lcdServicegrid.setVisible(true);
			serviceCostingFilter.isValid();
		}
	},
	
	loadLCDCourseGrid: function(){
		var $this = this;
		var lcdCourseFilter = $this.getLecturercostingcoursefilter();
		lcdCourseFilter.down('#lecturerCostingSearchBtn').setDisabled(true);
		var grid = $this.getLecturercostingcoursegrid();
		var form = lcdCourseFilter.getForm();
		var values = form.getValues();
		var academyLocationId  = this.getCurrentAcademyLocation();
		var academicTermId = values.academicTerm;
		var facultyIds = values.lecturer;
		var courseIds = values.COURSE_ID;
		var courseVariantIds = values.COURSE_VARIENT_ID;
		var batchIds = values.programWiseProgram;
		var periodIds = values.programWisePeriod;
		 var facultyId = [];
    	 if(facultyIds !=undefined && facultyIds.length > 0){
    		 for(var i in facultyIds){
    			 if(Ext.isObject(facultyIds[i])){
    				 facultyId.push(facultyIds[i].get("id"));
    			 }else{
    				 facultyId.push(facultyIds[i]);
    			 }
    		 }
    	 }
    	 var facultyIdsString= facultyId.join();
    	 
    	 var courseId = [];
    	 if(courseIds !=undefined && courseIds.length > 0){
    		 for(var i in courseIds){
    			 if(Ext.isObject(courseIds[i])){
    				 courseId.push(courseIds[i].get("id"));
    			 }else{
    				 courseId.push(courseIds[i]);
    			 }
    		 }
    	 }
    	 var courseIdsIdsString= courseId.join();
    	
    	 var courseVariantId = [];
    	 if(courseVariantIds !=undefined && courseVariantIds.length > 0){
    		 for(var i in courseVariantIds){
    			 if(Ext.isObject(courseVariantIds[i])){
    				 courseVariantId.push(courseVariantIds[i].get("id"));
    			 }else{
    				 courseVariantId.push(courseVariantIds[i]);
    			 }
    		 }
    	 }
    	 var courseVariantIdsString= courseVariantId.join();
    	 
    	 var batchId=[];
    	 if(batchIds !=undefined && batchIds.length > 0){
    		 for(var i in batchIds){
    			 if(Ext.isObject(batchIds[i])){
    				 batchId.push(batchIds[i].get("id"));
    			 }else{
    				 batchId.push(batchIds[i]);
    			 }
    		 }
    	 }
    	 var batchIdsString= batchId.join();
    	 
    	 var periodId=[];
    	 if(periodIds !=undefined && periodIds.length > 0){
    		 for(var i in periodIds){
    			 if(Ext.isObject(periodIds[i])){
    				 periodId.push(periodIds[i].get("id"));
    			 }else{
    				 periodId.push(periodIds[i]);
    			 }
    		 }
    	 }
    	 var periodIdsString= periodId.join();
    	
    	
		var store = grid.getStore();

		store.getProxy().extraParams = {
			alId:academyLocationId,
			academicTermId:academicTermId,
			facultyIds:facultyIdsString,
			courseIds:courseIdsIdsString,
			courseVariantIds:courseVariantIdsString,
			batchIds :batchIdsString,
			periodIds:periodIdsString	
		};
		this.resetPageSetting(store);
		store.load({
			callback: function(records, operation, success) {
				lcdCourseFilter.down('#lecturerCostingSearchBtn').setDisabled(false);
			}
		});
		grid.config.searchFilterForm = lcdCourseFilter;
	},
	
	loadLCDServiceGrid: function(){
		var $this = this;
		var lcdServiceFilter = $this.getLecturercostingservicefilter();
		lcdServiceFilter.down('#lcdServiceSearchBtn').setDisabled(true);
		var grid = $this.getLecturercostingservicegrid();
		var form = lcdServiceFilter.getForm();
		var values = form.getValues();
		var academyLocationId  = this.getCurrentAcademyLocation();
		var serviceNameIds = values.serviceId;
		var cordinatorNameIds = values.serviceCoordinatorName;
		 var facultyId = [];
    	 if(cordinatorNameIds !=undefined && cordinatorNameIds.length > 0){
    		 for(var i in cordinatorNameIds){
    			 if(Ext.isObject(cordinatorNameIds[i])){
    				 facultyId.push(cordinatorNameIds[i].get("coordinatorId"));
    			 }else{
    				 facultyId.push(cordinatorNameIds[i]);
    			 }
    		 }
    	 }
    	 var cordinatorNameIdsString= facultyId.join();
    	 
    	 var serviceId = [];
    	 if(serviceNameIds !=undefined && serviceNameIds.length > 0){
    		 for(var i in serviceNameIds){
    			 if(Ext.isObject(serviceNameIds[i])){
    				 serviceId.push(serviceNameIds[i].get("id"));
    			 }else{
    				 serviceId.push(serviceNameIds[i]);
    			 }
    		 }
    	 }
    	 var serviceNameIdsString= serviceId.join();
    	
    	
    	
		var store = grid.getStore();

		store.getProxy().extraParams = {
			alId:academyLocationId,
			coordinatorIds:cordinatorNameIdsString,
			serviceIds:serviceNameIdsString
		};
		this.resetPageSetting(store);
		store.load({
			callback: function(records, operation, success) {
				lcdServiceFilter.down('#lcdServiceSearchBtn').setDisabled(false);
			}
		});
		grid.config.searchFilterForm = lcdServiceFilter;
	},
	
	enableDisableAddCostButton: function (column, selected) {
         var grid = this.getLecturercostingcoursegrid();
         var AddCostBtn = grid.down('#addCourseCostingBtn');
         if (!isNullOrEmpty(selected) && selected.length > 0) {
        	 AddCostBtn.setDisabled(false);
         } else {
        	 AddCostBtn.setDisabled(true);
         }
     },
     
     enableDisableAddCostServiceButton: function (column, selected) {
         var grid = this.getLecturercostingservicegrid();
         var AddCostBtn = grid.down('#addServiceCostingBtn');
         if (!isNullOrEmpty(selected) && selected.length > 0) {
        	 AddCostBtn.setDisabled(false);
         } else {
        	 AddCostBtn.setDisabled(true);
         }
     },
     
     showAddCostWindow : function(){
    	 var this$ = this;
       	 var formWindow = this$.getLcdaddcostwindow();
       	 if (!formWindow) {
       		 Ext.widget('lcdaddcostwindow');
       		 formWindow = this$.getLcdaddcostwindow();
       	 }
       	 formWindow.show();
     },
     
     showAddCostServiceWindow : function(){
    	 var this$ = this;
       	 var formWindow = this$.getLcdaddcostservicewindow();
       	 if (!formWindow) {
       		 Ext.widget('lcdaddcostservicewindow');
       		 formWindow = this$.getLcdaddcostservicewindow();
       	 }
       	 formWindow.show();
     },
     
     saveCourseCosting:	function() {
			var grid = this.getLecturercostingcoursegrid();
			var formWindow = this.getLcdaddcostwindow();
			var fromDate = formWindow.down('#costStart').getValue();
			var endDate = formWindow.down('#costend').getValue();
			var currencyId = formWindow.down('#currency').getValue();
			var cost = formWindow.down('#costId').getValue();
			var maxDailyHours = formWindow.down('#maxDailyHours').getValue();
			var comments = formWindow.down('#comments').getValue();
			var json=[];
			if (grid.getSelectionModel().getCount() > 0) {
	            var records = grid.getSelectionModel().getSelection();
	            }
			
			records.forEach(function(obj){
				var facultyId={id:obj.get("facultyId"),itemValue:obj.get("facultyName")}
				var currency={id:currencyId}
				var academicTerm ={id:obj.get("academicTermId")}
				var courseVariant={id:obj.get("courseVariantId")}
				var programBatchCourseParam={id:obj.get("id")}
				json.push({
					fromDate:fromDate,
					tillDate:endDate,
					currency:currency,
					cost:cost,
					maxDailyHours:maxDailyHours,
					comments:comments,
					facultyId:facultyId,
					programBatchCourseParam:programBatchCourseParam,
					courseVariant:courseVariant,
					academicTerm:academicTerm
				});
			});			
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	var	submitUrl=SERVERURL.PATH_COURSE_LECTURER_COST_DEF_SAVE;
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : submitUrl,
	    		jsonData : json,
	    		method : 'POST',
	    		success : function(response,form, action) {
	    			msg =Ext.decode(response.responseText);
	    			Ext.getBody().unmask();
	    			if(msg=='SUCCESS')
	    			showSuccessMessage(getCommonTranslation('COST_DETAILS'),getCommonTranslation('SUCCESS'));
	    			else{
	    				msg = msg.substring(0,msg.length-2);
	    				 showWarningMessage(getCommonTranslation('ALERT'),(getCommonTranslation('RECORD_IS_ALREADY_PRESENT_FOR')+" "+ msg + " " + getCommonTranslation('LECTURER')))
	    			}
	    	    	formWindow.close();
	    			var lcdCourseFridStore = grid.getStore();
	    			lcdCourseFridStore.load();
	    			grid.getSelectionModel().deselectAll();
	    			formWindow.unmask();
	    		}
	    	});
		},
		
		saveServiceCosting:	function() {
			var grid = this.getLecturercostingservicegrid();
			var formWindow = this.getLcdaddcostservicewindow();
			var fromDate = formWindow.down('#costStart').getValue();
			var endDate = formWindow.down('#costend').getValue();
			var currencyId = formWindow.down('#currency').getValue();
			var cost = formWindow.down('#costId').getValue();
			var maxDailyHours = formWindow.down('#maxDailyHours').getValue();
			var comments = formWindow.down('#comments').getValue();
			var json=[];
			if (grid.getSelectionModel().getCount() > 0) {
	            var records = grid.getSelectionModel().getSelection();
	            }
			
			records.forEach(function(obj){
				var coordinator={id:obj.get("coordinatorId"), itemValue:obj.get("coordinatorName")}
				var currency={id:currencyId}
			
				var service={id:obj.get("serviceId")}
				var serviceStaff={id:obj.get("id")}
				json.push({
					fromDate:fromDate,
					tillDate:endDate,
					currency:currency,
					cost:cost,
					maxDailyHours:maxDailyHours,
					comments:comments,
					coordinator:coordinator,
					serviceStaff:serviceStaff,
					service:service,
				});
			});			
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	    	var	submitUrl=SERVERURL.PATH_SERVICE_LECTURER_COST_DEF_SAVE;
	    	Ext.Ajax.request({
	    		type : 'rest',
	    		url : submitUrl,
	    		jsonData : json,
	    		method : 'POST',
	    		success : function(response,form, action) {
	    			msg =Ext.decode(response.responseText);
	    			Ext.getBody().unmask();
	    			if(msg=='SUCCESS')
	    			showSuccessMessage(getCommonTranslation('COST_DETAILS'),getCommonTranslation('SUCCESS'));
	    			else{
	    				msg = msg.substring(0,msg.length-2);
	    				 showWarningMessage(getCommonTranslation('ALERT'),(getCommonTranslation('RECORD_IS_ALREADY_PRESENT_FOR')+" "+ msg + " " + getCommonTranslation('SERVICE_COORDINATOR')))
	    			}
	    	    	formWindow.close();
	    			var lcdServiceGridStore = grid.getStore();
	    			lcdServiceGridStore.load();
	    			grid.getSelectionModel().deselectAll();
	    			formWindow.unmask();
	    		}
	    	});
		},
		
		onCostDetailsClick : function(view, CellEl, ColIdx, record, RowEl, rowIndex, e,eopts)  {
			var this$ = this;
			var academyLocationId = this$.getCurrentAcademyLocation();
			var grid = view.up('grid');
			var columnName = grid.columnManager.columns[ColIdx].dataIndex;
			var portalInfo = Academia.model.authentication.StudentERPInfoModel;
			if(columnName=='costDetails' && record.data.isCostDtlsPresent){
				var formWindow = this$.getLcdeditcoursewindow();
				if (!formWindow) {
					Ext.widget('lcdeditcoursewindow',{
						minIdx: 0,
						recordIdx: rowIndex,
						maxIdx: grid.getStore().getCount()-1
					});
					formWindow = this$.getLcdeditcoursewindow();
				}
				formWindow.show();
				formWindow.down('#lecturer').setValue(record.get("facultyName"));
				formWindow.down('#courseVariantId').setValue(record.get("courseVariantName"));
			}
		},
		
		onServiceCostDetailsClick : function(view, CellEl, ColIdx, record, RowEl, rowIndex, e,eopts)  {
			var this$ = this;
			var academyLocationId = this$.getCurrentAcademyLocation();
			var grid = view.up('grid');
			var columnName = grid.columnManager.columns[ColIdx].dataIndex;
			var portalInfo = Academia.model.authentication.StudentERPInfoModel;
			if(columnName=='costDetails' && record.data.isCostDtlsPresent){
				var formWindow = this$.getLcdeditservicewindow();
				if (!formWindow) {
					Ext.widget('lcdeditservicewindow',{
						minIdx: 0,
						recordIdx: rowIndex,
						maxIdx: grid.getStore().getCount()-1
					});
					formWindow = this$.getLcdeditservicewindow();
				}
				formWindow.show();
				formWindow.down('#service').setValue(record.get("serviceName"));
				formWindow.down('#serviceCordinatorId').setValue(record.get("coordinatorName"));
			}
		},
		loadLCDCourseWindow : function(win,currentIdx){
			try{
				win.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				
				var me = this;
				var grid = me.getLecturercostingcoursegrid();
				var record = grid.getStore().getAt(currentIdx);
				var facultyId = record.data.facultyId;
				var paramId = record.data.id;
				var academicTermId =record.data.academicTermId;
				var courseVariantId = record.data.courseVariantId;
				//var lcdEditCourseGrid = win.down('#lcdCourseGridId');
				var lcdEditCourseGrid=this.getLecturercostingcourseinnergrid();
				var lecturerCostingDetails=this.getLecturercostingcourseinnerdetails();
				var lcdEditCourseGridStore = lcdEditCourseGrid.getStore();
				lcdEditCourseGridStore.getProxy().extraParams = {
					paramId:paramId,
					academicTermId:academicTermId,
					courseVariantId:courseVariantId,
					facultyId:facultyId
				};
				lcdEditCourseGridStore.load();
				win.unmask();
			}
			catch(e){
				win.unmask();
			}
			
		},
		
		loadLCDServiceWindow : function(win,currentIdx){
			try{
				win.mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
				
				var me = this;
				var grid = me.getLecturercostingservicegrid();
				var record = grid.getStore().getAt(currentIdx);
				var serviceStaffId = record.data.id;
				var serviceId =record.data.serviceId;
				var coordinatorId = record.data.coordinatorId;
				//var lcdEditServiceGrid = win.down('#lcdServiceGridId');
				var lcdEditServiceGrid=this.getLecturercostingserviceinnergrid();
				var lecturerCostingDetails=this.getLecturercostingserviceinnerdetails();
				var lcdEditServiceGridStore = lcdEditServiceGrid.getStore();
				lcdEditServiceGridStore.getProxy().extraParams = {
					serviceStaffId:serviceStaffId,
					serviceId:serviceId,
					coordinatorId:coordinatorId,
				};
				lcdEditServiceGridStore.load();
				win.unmask();
			}
			catch(e){
				win.unmask();
			}
			
		},
		lcdEditCourseCost : function(btn){
			var $this = this;
			var formWindow=$this.getLcdeditcoursewindow();
			var costGridWindow=$this.getLcdeditcoursewindow();
			var grid = btn.up().up();
			var flag =true;
	    	 var gridStore = grid.getStore();
	    	 var modifiedRecords = gridStore.getModifiedRecords();
	    	 var jsonData =[];
	    	 var currentIdx = costGridWindow.recordIdx;
	    	 var costCourseGrid = $this.getLecturercostingcoursegrid();
	    	 var costGridRecord = costCourseGrid.getStore().getAt(currentIdx);
				var facultyId = {id:costGridRecord.data.facultyId};
				var programBatchCourseParam = {id:costGridRecord.data.id};
				var academicTerm ={id:costGridRecord.data.academicTermId};
				var courseVariant = {id:costGridRecord.data.courseVariantId};
	    	 if(modifiedRecords.length==0){
	    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_IS_NOT_AVAILABLE_FOR_UPDATAION'))
	    		 return;	
	    	 }
	    	 else{
	    		 modifiedRecords.forEach(function(obj){
	    			 var id = obj.get('id');
	    			 if(isNullOrEmpty(obj.get('fromDate'))){
	    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FROM_DATE_MANDATORY'));
	    				 flag=false;
	    	    		 return;
	    			 }
	    			 else if(isNullOrEmpty(obj.get('tillDate'))){
	    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('TILL_DATE_MANDATORY'));
	    				 flag=false;
	    	    		 return;
	    			 }
	    			/* else if(isNullOrEmpty(obj.get('comments'))){
	    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMMENTS_MANDATORY'));
	    				 flag=false;
	    	    		 return;
	    			 }*/
	    			 else if(isNullOrEmpty(obj.get('cost'))){
	    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COST_MANDATORY'));
	    				 flag=false;
	    	    		 return;
	    			 }
	    			 var fromDate = dateFormatRender(obj.get('fromDate'));
	    			 var tillDate = dateFormatRender(obj.get('tillDate'));
	    			 var comments = obj.get('comments');
	    			 var currency = {id:obj.get('currencyId')};
	    			 var cost =obj.get('cost')
	    			 var maxDailyHours=obj.get('maxDailyHours');
	    			 
	    			 
	    			 
	    			 
	    			 jsonData.push({
	    				 id:id,
	    				 fromDate:fromDate,
	    				 tillDate:tillDate,
	    				 comments:comments,
	    				 currency:currency,
	    				 cost:cost,
	    				 maxDailyHours:maxDailyHours,
	    				 facultyId:facultyId,
	    				 programBatchCourseParam:programBatchCourseParam,
	    				 academicTerm:academicTerm,
	    				 courseVariant:courseVariant
	    			 });
	    			 
	    		 });
	    		 
	    		 if(flag){
		    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			 	    	var	submitUrl=SERVERURL.PATH_COURSE_LECTURER_COST_DEF_UPDATE;
			 	    	Ext.Ajax.request({
			 	    		type : 'rest',
			 	    		url : submitUrl,
			 	    		jsonData : jsonData,
			 	    		method : 'POST',
			 	    		success : function(response,form, action) {
			 	    			Ext.getBody().unmask();
			 	    			var msg=Ext.decode(response.responseText);
			 	    			if(msg=='SUCCESS'){
			 	    				showSuccessMessage(getCommonTranslation('COST_DETAILS'),getCommonTranslation('SUCCESS'))
			 		       			}
			 	    			else{
			 	    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_IS_ALREADY_PRESENT_FOR_UPDATED_DURATION'))
			 	    			}
			 	    	    	formWindow.close();
			 	    			var lcdCourseFridStore = grid.getStore();
			 	    			lcdCourseFridStore.load();
			 	    			grid.getSelectionModel().deselectAll();
			 	    			formWindow.unmask();
			 	    		}
			 	    	});
	    		 }
	    		 formWindow.unmask();

	    	 }
	     },
	     
	     lcdDeleteCourseCost : function(btn){
				var $this = this;
				var formWindow=$this.getLcdeditcoursewindow();
				var costGridWindow=$this.getLcdeditcoursewindow();
				var lecturerGrid = $this.getLecturercostingcoursegrid();
				var grid = btn.up().up();
				
				if(grid.getSelectionModel().getCount()>0){
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					var id = selectedRecord.get("id");
					var idx = grid.getStore().indexOf(selectedRecord);
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var	submitUrl=SERVERURL.PATH_COURSE_LECTURER_COST_DEF_DELETE;
					Ext.Ajax.request({
						type : 'rest',
						url : submitUrl +'?id='+ id,
						method : 'DELETE',
						success : function(response,form, action) {
							Ext.getBody().unmask();
							grid.getStore().removeAt(idx);
							if(grid.getStore().getCount() == 0){
								formWindow.close();
								lecturerGrid.getSelectionModel().deselectAll();
								lecturerGrid.getStore().load();
							}
							showSuccessMessage(getCommonTranslation('COST_DETAILS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
							
						}
					});
					
				}
				else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_RECORD_IS_SELECTED_FOR_DELETION'));
					Ext.getBody().unmask();
					formWindow.unmask();
				}
		    		 formWindow.unmask();
		     },
	     
	     lcdEditServiceCost : function(btn){
				var $this = this;
				var formWindow=$this.getLcdeditservicewindow();
				var costGridWindow=$this.getLcdeditservicewindow();
				var grid = btn.up().up();
				var flag =true;
		    	 var gridStore = grid.getStore();
		    	 var modifiedRecords = gridStore.getModifiedRecords();
		    	 var jsonData =[];
		    	 var currentIdx = costGridWindow.recordIdx;
		    	 var costServiceGrid = $this.getLecturercostingservicegrid();
		    	 var costGridRecord = costServiceGrid.getStore().getAt(currentIdx);
					var serviceStaff = {id:costGridRecord.data.id};
					var service ={id:costGridRecord.data.serviceId};
					var coordinator = {id:costGridRecord.data.coordinatorId};
		    	 if(modifiedRecords.length==0){
		    		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_IS_NOT_AVAILABLE_FOR_UPDATAION'))
		    		 return;	
		    	 }
		    	 else{
		    		 modifiedRecords.forEach(function(obj){
		    			 var id = obj.get('id');
		    			 if(isNullOrEmpty(obj.get('fromDate'))){
		    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FROM_DATE_MANDATORY'));
		    				 flag=false;
		    	    		 return;
		    			 }
		    			 else if(isNullOrEmpty(obj.get('tillDate'))){
		    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('TILL_DATE_MANDATORY'));
		    				 flag=false;
		    	    		 return;
		    			 }
		    			/* else if(isNullOrEmpty(obj.get('comments'))){
		    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMMENTS_MANDATORY'));
		    				 flag=false;
		    	    		 return;
		    			 }*/
		    			 else if(isNullOrEmpty(obj.get('cost'))){
		    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COST_MANDATORY'));
		    				 flag=false;
		    	    		 return;
		    			 }
		    			 var fromDate = dateFormatRender(obj.get('fromDate'));
		    			 var tillDate = dateFormatRender(obj.get('tillDate'));
		    			 var comments = obj.get('comments');
		    			 var currency = {id:obj.get('currencyId')};
		    			 var cost =obj.get('cost')
		    			 var maxDailyHours =obj.get('maxDailyHours');
		    			 
		    			 
		    			 
		    			 
		    			 jsonData.push({
		    				 id:id,
		    				 fromDate:fromDate,
		    				 tillDate:tillDate,
		    				 comments:comments,
		    				 currency:currency,
		    				 cost:cost,
		    				 maxDailyHours:maxDailyHours,
		    				 serviceStaff:serviceStaff,
		    				 service:service,
		    				 coordinator:coordinator
		    			 });
		    			 
		    		 });
		    		 
		    		 if(flag){
			    		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 	    	var	submitUrl=SERVERURL.PATH_SERVICE_LECTURER_COST_DEF_UPDATE;
				 	    	Ext.Ajax.request({
				 	    		type : 'rest',
				 	    		url : submitUrl,
				 	    		jsonData : jsonData,
				 	    		method : 'POST',
				 	    		success : function(response,form, action) {
				 	    			Ext.getBody().unmask();
				 	    			var msg=Ext.decode(response.responseText);
				 	    			if(msg=='SUCCESS'){
				 	    				showSuccessMessage(getCommonTranslation('COST_DETAILS'),getCommonTranslation('SUCCESS'))
				 		       			}
				 	    			else{
				 	    				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_IS_ALREADY_PRESENT_FOR_UPDATED_DURATION'))
				 	    			}
				 	    	    	formWindow.close();
				 	    			var lcdServiceFieldStore = grid.getStore();
				 	    			lcdServiceFieldStore.load();
				 	    			grid.getSelectionModel().deselectAll();
				 	    			formWindow.unmask();
				 	    		}
				 	    	});
		    		 }
		    		 formWindow.unmask();

		    	 }
		     },
		     
		     lcdDeleteServiceCost : function(btn){
					var $this = this;
					var formWindow=$this.getLcdeditservicewindow();
					//var costGridWindow=$this.getLcdeditcoursewindow();
					var serviceLecturerGrid = $this.getLecturercostingservicegrid();
					var grid = btn.up().up();
					
					if(grid.getSelectionModel().getCount()>0){
						var selectedRecord = grid.getSelectionModel().getSelection()[0];
						var id = selectedRecord.get("id");
						var idx = grid.getStore().indexOf(selectedRecord);
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						var	submitUrl=SERVERURL.PATH_SERVICE_LECTURER_COST_DEF_DELETE;
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl +'?id='+ id,
							method : 'DELETE',
							success : function(response,form, action) {
								Ext.getBody().unmask();
								grid.getStore().removeAt(idx);
								if(grid.getStore().getCount() == 0){
									formWindow.close();
									serviceLecturerGrid.getSelectionModel().deselectAll();
									serviceLecturerGrid.getStore().load();
								}
								showSuccessMessage(getCommonTranslation('COST_DETAILS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
							}
						});
						
					}
					else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_RECORD_IS_SELECTED_FOR_DELETION'));
						Ext.getBody().unmask();
						formWindow.unmask();
					}
			    		 formWindow.unmask();
			     },
		     
		     costingserviceFormChange : function(cb, nv, ov) {
					var $this = this;
					var academyLocationId = this$.getCurrentAcademyLocation();
					var structure = cb.up('downloadbulkimportcostingtypeform');
					var course = structure.down('downloadcoursecostingform');
					
					var service = structure.down('downloadservicecostingform');

					var courseForm = $this.getDownloadcoursecostingform();
					var serviceForm = $this.getDownloadservicecostingform();
					courseForm.getForm().reset();
					serviceForm.getForm().reset();
					
					courseForm.down("#programWiseProgramId").setDisabled(true);
					courseForm.down("#programWisePeriodId").setDisabled(true);
					courseForm.down("#lecturerId").setDisabled(true);
					courseForm.down("#courseCodeId").setDisabled(true);
					courseForm.down("#courseVariantId").setDisabled(true);
					
					/*cbsForm.down("#componentSectionItemId").setDisabled(true);
					cbsForm.down("#componentSectionItemId").hide();
					cbsForm.down("#courseVariantId").setDisabled(true);
					cbsForm.down("#courseVariantId").hide();
					cbsForm.down("#courseSectionId").setDisabled(true);
					cbsForm.down("#facultyId").setDisabled(true);
					*/
					if(structure.getForm().getValues().costingType == 'CourseType'){
						service.hide();
						course.show();
						var academicTerm = course.down("#academicTerm");
						var academicTermStore =academicTerm.getStore();
						academicTermStore.load();
					} else {
						course.hide();
						service.show();
						var serviceField = service.down("#serviceId");
						var serviceStore = serviceField.getStore();
						serviceStore.getProxy().extraParams={
							alId:academyLocationId
						}
						serviceStore.load();
					}		
				},
		
				onChangeDownloadUploadRadioBtn : function(cb,newValue,oldValue){
					var $this = this;
					var structure = cb.up('lecturercostinguploaddownloadstructure');
					var downloadTemplateForm = structure.down('downloadbulkimportcostingtypeform');
					var uploadTemplateForm = structure.down('uploadlecturercostinguploadform');
					var grid = $this.getImportutilitylecturercostinglist();
					if(newValue.downloadUploadTemplate == 'forDownloadTemplate'){
						uploadTemplateForm.hide();
						downloadTemplateForm.show();
						grid.setVisible(false);
					}else{
						downloadTemplateForm.hide();
						uploadTemplateForm.show();
						grid.setVisible(true);
						uploadTemplateForm.down("#uploadFileField").reset();
					}
				},
				
				getDownloadFile : function(documentId,fileType){
					if(!isNullOrEmpty(documentId)){
						var csvForm = Ext.create('Ext.form.Panel'); 
						csvForm.getForm().submit({
							target: '_blank',
							method:'POST',
							params :{
								access_token : Ext.Ajax.defaultHeaders.access_token
							},
							headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
							standardSubmit :true
						});
					}
				},
			
});
