/*
 * Controller for supervision tab of organization module.
 */
Ext.define('Academia.controller.organization.Supervision', {
    extend: 'Academia.controller.base.BaseController',
    requires: ['Academia.utilities.date.DateHelper'],
    views: [
            'organization.supervision.SupervisoryTreeStructure',
            'organization.supervision.SupervisionFormWindow',
            'organization.supervision.LinkedALPGrid',
            'organization.supervision.LinkedALPStructureWindow',
            'organization.supervision.ALPToChildGrid',
            'common.NestedJsonCombo'
           ],
    models: ['organization.OrganizationUnit'],
    stores: ['common.UsersComboStore', 'organization.StructureTreeStore',
             'organization.AllocatedALPs', 'organization.ALPToChildren'],

    refs: [{
        ref: 'supervisionFormWindow',
        selector: 'supervisionFormWindow'
    }, {
        ref: 'supervisorytreeStructure',
        selector: 'supervisorytreeStructure'
    },{
        ref: 'supervisoryForm',
        selector: 'supervisionFormWindow form'
    },{
    	ref: 'supervisoryStructure',
    	selector: 'supervisoryStructure'
    },	
    /*
     * references for the popup
     */
    {
    	ref: 'linkedALPWindow',
    	selector: 'linkedalpstructurewindow'
    }, {
    	ref: 'linkedALPGrid',
    	selector: 'linkedalpgrid'
    }, {
    	ref: 'alpToChildGrid',
    	selector: 'alptochildgrid'
    }],
    config: {
    	ORGANIZATION_STRUCTURE_SUPERVISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ORGANIZATION_STRUCTURE_SUPERVISION_PRIVILEGES')
    },
    init: function() {
        this.control({
        	'supervisorytreeStructure[itemId=supervisorytreeStructure]':{
        		render: function(tree){
        			this.doAccessControlValidation(tree, this.getORGANIZATION_STRUCTURE_SUPERVISION_PERMISSIONS());
        			this.disableMoreActionPivileges(tree,this.getORGANIZATION_STRUCTURE_SUPERVISION_PERMISSIONS());
        		}
        	},
        	'supervisorytreeStructure': {
        		render : this.renderSupervisoryTreeStructure
        	},
            'supervisiontreeStructure [panel=treePanel]': {
                nodedragover: function(targetNode, position, dragData) {
                }
            },
            //Listeners for supervision tree
            'supervisorytreeStructure button[itemId=btnAdd]': {
                click: function() {
                    this.addChild();
                }
            },
            'supervisorytreeStructure button[itemId=btnEdit]': {
                click: function() {
                    this.editForm();
                }
            },
            'supervisorytreeStructure button[itemId=btnView]': {
                click: function() {
                    this.viewForm();
                }
            },
            //'supervisorytreeStructure #spBtnMoreActions menuitem[itemId=viewLinkedALP]': {
            'supervisorytreeStructure splitbutton [itemId=viewLinkedALP]': {
                click: function() {
                    this.showLinkedAlpWindow();
                }
            },
            'supervisionFormWindow form button[action=Submit]': {
                click: this.saveISU
            },
            'supervisionFormWindow form button[action=Cancel]': {
                click: this.closeTreeFormWindow
            },
            /*
             * Listening to the application level event which is fired from the tree drag and drop 
             * event of the StatutoryAccountingTree.js.
             * 
             * @event: statutoryAccountingTreeDrag
             * @param: node is the selected node.
             * @param: data {refer the documentation of drag drop of tree}
             * @param: overModel{refer the documentation of drag drop of tree}
             * @param: dropPosition{refer the documentation of drag drop of tree}
             * @param: dropPosition{refer the documentation of drag drop of tree}
             */
            '*': {
            	supervisionTreeDrag:function(node, data, overModel, dropPosition, dropHandlers) {
            		this.moveNode(node, data, overModel, dropPosition, dropHandlers);
        		}
            },
/*
            'linkedalpgrid grid[itemId=linkedAlpGridOfSUP]' : {
            	render: function(this$, eOpts) {
            		this.loadTreeAndDropdowns(this$);   
            	 }
           }*/
            'linkedalpstructurewindow linkedalpgrid': {
            	render: function(this$, eOpts) {
            		this.loadTreeAndDropdowns(this$);   
            	}
            }            
        });
    },
    renderSupervisoryTreeStructure:function(){
    	var tree=this.getSupervisorytreeStructure();
    	var form=this.getSupervisoryStructure().getForm();
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.ORG_SUP_UNIT_FIND_SUID,
             method: 'GET',
             success: function(response) {
            	 form.setValues({organizationSupervisoryUnit:response.responseText});
            	 var store=tree.getStore();
         			store.getProxy().extraParams = {
                       id: response.responseText
                   };
         		  store.reload();
             }
         });
    	 
    },
    showLinkedAlpWindow: function() {
    	var tree=this.getSupervisorytreeStructure();
		if(tree.getSelectionModel().getCount()>0){
		    var linkedAlpWindow = this.getLinkedALPWindow();
			if (!linkedAlpWindow) {
			    Ext.widget('linkedalpstructurewindow');
			    linkedAlpWindow = this.getLinkedALPWindow();
			}
			linkedAlpWindow.show();
		}
		else {
			showWarningMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
    },
    
    showFormWindow: function() {
        var formWindow = this.getSupervisionFormWindow();
        if (!formWindow) {
            Ext.widget('supervisionFormWindow');
            formWindow = this.getSupervisionFormWindow();
        }
        formWindow.show();
        
        var value=this.getSupervisoryUnitId();
        this.getSupervisoryForm().getForm().setValues({organizationSupervisoryUnit: value});
    },
    getSupervisoryUnitId : function(){
    	var form=this.getSupervisoryStructure().getForm();
    	return form.findField('organizationSupervisoryUnit').getSubmitValue();
	},
    closeTreeFormWindow: function() {
        this.getSupervisionFormWindow().close();
    },

    viewForm: function() {
        this.editForm();
        var form = this.getSupervisoryForm();
        if (form) {
            form.down('#supervisionSaveButton').setVisible(false);
            form = form.getForm();
            toggleReadOnlyFormItems(form, true);
        }
    },

    loadTreeAndDropdowns: function( this$) {
	var tree=this.getSupervisorytreeStructure();
	/*
	 * Load the records only if any record is selected.
	 */
		if(tree.getSelectionModel().getCount()>0) {
		    var record=tree.getSelectionModel().getSelection()[0];
		    var orgUnitId = record.data.id;
		    var allocatedALPToOthersStore = this$.items.items[0].getStore();
		    var alpToChildrenStore = this.getAlpToChildGrid().items.items[0].getStore();
		    allocatedALPToOthersStore.getProxy().extraParams = {
		           organizationUnitId: orgUnitId
		    };
		    allocatedALPToOthersStore.load();
		    alpToChildrenStore.getProxy().extraParams = {
		           organizationUnitId: orgUnitId
		    };
		    alpToChildrenStore.load();
		} 
    },

    addChild: function() {
	var tree=this.getSupervisorytreeStructure();
	if(tree.getSelectionModel().getCount()>0){
	    this.showFormWindow();
	    var record=tree.getSelectionModel().getSelection()[0];
            var supervisionformwindow = this.getSupervisionFormWindow();
            if (record.parentNode != null) {
        	supervisionformwindow.down('#parentOrganizationHiddenId').setValue(record.getId());
            }
            var parentOrganization = record.getData().text;
            supervisionformwindow.down('#parentISU').setValue(parentOrganization);
            supervisionformwindow.down('#parentItemId').setValue(record.getId());
	} else {
		showWarningMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
    },

    editForm: function() {
        tree = this.getSupervisorytreeStructure();
        if (tree.getSelectionModel().getCount() > 0 ) {
            var record = tree.getSelectionModel().getSelection()[0];
            
            /*
             * check for restricting the user from doing edit operation on the root node 
             */
            if( record.data.text !== getCommonTranslation('ROOTNODEFORTREE')) {
                this.showFormWindow();
                var form = this.getSupervisoryForm();
                
                if (record != undefined && record != "" && record != null) {
                    var data = record.raw.model;
                    var organizationUnit = new Academia.model.organization.OrganizationUnit(data);
                    var parent = organizationUnit.get('parentOrganizationUnit');
                    form.loadRecord(organizationUnit);
                    form.down("#startDate").setValue(dateRender(data.startDate));
                    form.down("#tillDate").setValue(dateRender(data.tillDate));

                    if (parent != null) {
                        form.down('#parentISU').setValue(organizationUnit.get('parentOrganizationUnit').value);
                    }else {
                    	form.down('#parentISU').setValue(getCommonTranslation('ROOTNODEFORTREE'));
                    }
                      //  form.down('#ownerId').setValue(organizationUnit.get('owner').value);
                        form.down('#parentItemId').setValue(record.parentNode.data.id);
                        //form.down('').setValue(record.raw.text);
                    
                    form.down('#startDate').setReadOnly(true);
                }
            } else {
        	tree.getSelectionModel().deselectAll(true);
        	showWarningMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), getCommonTranslation('NOOPERATIONSONROOT'));
            }
        } else {
        	showWarningMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    saveISU: function(button) {
	 var this$ = this;
        var supervisionForm = this.getSupervisoryForm();
        var parentStartDate = '';
        var parentTillDate = '';
        var submitUrl = '';
        var successMessage;
        var parent = false;
        var tree=this.getSupervisorytreeStructure();
        var record=tree.getSelectionModel().getSelection()[0];

        var organizationUnit = new Academia.model.organization.OrganizationUnit();
        var id = supervisionForm.getForm().findField('id').getSubmitValue();

        if (id == null || id == "") {
            submitUrl = SERVERURL.MGMTACCOUNTINGCREATE;
            successMessage = getCommonTranslation('SUPERVISION_UNIT_ADD_SUCCESS');
            if(record.raw.model) {
        	parentStartDate = record.raw.model.startDate;
        	parentTillDate = record.raw.model.tillDate;
            }else {
        	/*
        	 * set parent as true if the node to be added is below root node
        	 */
        	parent = true;
            }
        } else {
            parentStartDate = record.raw.model.startDate;
            parentTillDate = record.raw.model.tillDate;
            submitUrl = SERVERURL.MGMTACCOUNTINGUPDATENODE;
            successMessage = getCommonTranslation('SUPERVISION_UNIT_UPDATE_SUCCESS');
        }
        var childStartDate = supervisionForm.getForm().findField('startDate').getSubmitValue();
        var childTillDate = supervisionForm.getForm().findField('tillDate').getSubmitValue();
        var childStartDateVal = new Date(childStartDate).getTime();
        var childTillDateVal = new Date(childTillDate).getTime();
        var parentId = supervisionForm.getForm().findField('parentId').getSubmitValue();
        var parentValue = supervisionForm.getForm().findField('parentOrganizationUnit').getSubmitValue();
        var parentOrganizationUnit = {
            id: parentId,
            value: parentValue
        };

        
        if (parent || Academia.utilities.date.DateHelper.validateDate(parentStartDate, parentTillDate, childStartDateVal, childTillDateVal)) {
            supervisionForm.updateRecord(organizationUnit);
            organizationUnit.set('parentOrganizationUnit', parentOrganizationUnit);

            if(parent) {
        	delete organizationUnit.data.parentOrganizationUnit;
            }
            if(!parent) {
        	organizationUnit.set('parentOrganizationUnit', parentOrganizationUnit);
            }
            /*
             *  Code to format the dates according to the dmy format and set it back in the obj.
             */
            var startdt = Ext.Date.format(organizationUnit.data.startDate, CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
            organizationUnit.data.startDate = startdt;
            var tilldt = Ext.Date.format(organizationUnit.data.tillDate, CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
            organizationUnit.data.tillDate = tilldt;
            
            organizationUnit.set('owner', {
                id: organizationUnit.get('owner')
            });
            var values = Ext.encode(organizationUnit.data);
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: values,
                method: 'POST',
                success: function() {
                    tree.getStore().load();
                    tree.getSelectionModel().deselectAll(true);
                    this$.closeTreeFormWindow();
                    showSuccessMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), successMessage);
                },
                failure: function(){
                    this$.closeTreeFormWindow();
                    //showErrorMessage(getCommonTranslation('SUPMESSAGEBOXTITLE'), getCommonTranslation('FAILURE'));
                }
            });
        }
    },
    moveNode: function(node, data, overModel, dropPosition, dropHandlers) {
        var orgUnit = data.records[0].raw.model;
        var childStartDate = orgUnit.startDate;
        var childTillDate = orgUnit.tillDate;
        var parentStartDate = '';
        var parentTillDate = '';
        var parent = false;
        if(overModel.raw.model) {
            parentStartDate = overModel.raw.model.startDate;
            parentTillDate = overModel.raw.model.tillDate;
        }else {
    	/*
    	 * set parent as true if the node to be added is below root node
    	 */
    		parent = true;
        }
        var tree=this.getSupervisorytreeStructure();
        dropHandlers.wait = true;
        if (parent || Academia.utilities.date.DateHelper.validateDate(parentStartDate, parentTillDate, childStartDate, childTillDate)) {
            var parentOrganizationUnit = {
                id: overModel.data.id,
                value: overModel.data.text
            };
            orgUnit.parentOrganizationUnit = parentOrganizationUnit;
            var values = Ext.encode(orgUnit);
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.MGMTACCOUNTINGUPDATENODE,
                jsonData: values,
                success: function() {
                    dropHandlers.processDrop();
                    
                    var store=tree.getStore();
         		     store.reload();         		  
                }
            });
        } else {
            dropHandlers.cancelDrop();
        }
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var tree = this.getSupervisorytreeStructure();
   		var Button = tree.down("#spBtnMoreActions");//itemId of split button
       	
   		Button.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(Button)){
           			Button.setVisible(true);//enable more action button
           		}        		
           	}
       	});
       }
    
});
