/**
 * @author Pravin.Surve
 * 
 * This controller is used for Request Status Master related Actions.   
 */
Ext.define('Academia.controller.othermasters.requeststatusmaster.RequestStatusMasterController', {
    extend: 'Academia.controller.base.BaseController',

    models: ['othermasters.requeststatusmaster.RequestStatusMasterModel'],
    stores: ['othermasters.requeststatusmaster.RequestStatusMasterStore'],

    views: ['othermasters.requeststatusmaster.RequestStatusMaster', 'othermasters.requeststatusmaster.RequestStatusMasterGrid',
            'othermasters.requeststatusmaster.RequestStatusMasterFormWindow'],

    alias: "widget.requestStatusMasterController",

    refs: [{
        ref: 'requestStatusMasterGrid',
        selector: 'requeststatusmastergrid[itemId=requestStatusMasterGrid]'
    }, {
        ref: 'requestStatustMasterForm',
        selector: 'requeststatusmasterformwindow form[itemId=requestStatustMasterForm]'
    }, {
        ref: 'requestStatusMaster',
        selector: 'requeststatusmaster'
    }, {
        ref: 'requestStatusMasterFormWindow',
        selector: 'requeststatusmasterformwindow'
    }],
    config: {
    	REQUEST_STATUS_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('REQUEST_STATUS_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            'requeststatusmastergrid': {
                render: function(component, options) {
                    component.getStore().load();
                }
            },
            'requeststatusmastergrid[itemId=requestStatusMasterGrid]': {
            	render: function(grid) {
                    this.doAccessControlValidation(grid, this.getREQUEST_STATUS_MASTER_PERMISSIONS());
                }
            },
            'requeststatusmastergrid[itemId=requestStatusMasterGrid] button[itemId=btnAdd]': {
                click: this.addRequestStatusMaster
            },
            'requeststatusmastergrid[itemId=requestStatusMasterGrid] button[itemId=btnEdit]': {
                click: Ext.bind(this.editRequestStatusMaster, this, [false])
            },
            'requeststatusmastergrid[itemId=requestStatusMasterGrid] button[itemId=btnView]': {
                click: Ext.bind(this.editRequestStatusMaster, this, [true])
            },
            'requeststatusmastergrid[itemId=requestStatusMasterGrid] button[itemId=btnDelete]': {
                click: this.deleteRequestStatusMaster
            },
            'requeststatusmasterformwindow form[itemId=requestStatustMasterForm] button[itemId=btnSaveRequestStatustMasterForm]': {
                click: this.saveRequestStatusMasterForm
            },
            'requeststatusmasterformwindow form[itemId=requestStatustMasterForm] button[itemId=btnCancelRequestStatustMasterForm]': {
                click: this.cancelRequestStatusMasterForm
            }
        });
    },

    /** This function is used for to show Request Status  Master Details Dialog box after clicking on Add button*/

    addRequestStatusMaster: function() {
        var winRequestStatusMasterFormWindow = Ext.widget('requeststatusmasterformwindow');
        winRequestStatusMasterFormWindow.show();
    },


    /** This function is used for to show Request Status Master Details Dialog box with values of selected record after clicking on edit button*/

    editRequestStatusMaster: function(isView) {
        var me = this;
        var grid = me.getRequestStatusMasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            me.addRequestStatusMaster();
            var records = grid.getSelectionModel().getSelection()[0];
            if (records != "" && records != null && records != undefined) {
                var requestStatustMasterForm = me.getRequestStatustMasterForm();
                requestStatustMasterForm.loadRecord(records);
                grid.getStore().reload();
                if (isView) {
                    var winrequeststatusmasterformwindow = me.getRequestStatusMasterFormWindow();
                    winrequeststatusmasterformwindow.down('#btnSaveRequestStatustMasterForm').setVisible(false);
                    toggleReadOnlyFormItems(requestStatustMasterForm.getForm(), true);
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /** This function is used for to save Request Status Master Details after clicking on save button*/

    saveRequestStatusMasterForm: function() {
        var this$ = this;
        var winrequeststatusmasterformwindow = this$.getRequestStatusMasterFormWindow();
        var refRequestStatusForm = this$.getRequestStatustMasterForm();
        var formData = refRequestStatusForm.getValues();
        var grid = this$.getRequestStatusMasterGrid();
        var submitUrl, methodType, isUpdate = false;

        var requeststatusmaster = refRequestStatusForm.down('#requestStatustMaster_hidden_field');
        if (requeststatusmaster.getSubmitValue() == null || requeststatusmaster.getSubmitValue() == "" || requeststatusmaster.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.REQUEST_STATUS_MASTER_ADD_UPDATE_DELETE,
            methodType = 'POST',
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.REQUEST_STATUS_MASTER_ADD_UPDATE_DELETE,
            methodType = 'PUT',
            isUpdate = true;
        }

        var jsonFormatFormData = Ext.encode(formData);
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: methodType,
            success: function(form, action) {
                winrequeststatusmasterformwindow.close();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();

                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('UPDATE_REQUEST_STATUS_MASTER_MSG'), getCommonTranslation('UPDATE_REQUEST_STATUS_MASTER_MSG')); //Request Status Master updated successfully												
                } else {
                    showSuccessMessage(getCommonTranslation('ADD_REQUEST_STATUS_MASTER_MSG'), getCommonTranslation('ADD_REQUEST_STATUS_MASTER_MSG')); //Request Status Master added successfully												
                }
            }

        });
    },


    /** This function is used for to close Request Status master Details Dialog box after clicking on cancel button   */

    cancelRequestStatusMasterForm: function() {
        this.getRequestStatusMasterFormWindow().close();
    },

    /** This function is used for to delete Request Status master Details  after clicking on delete button   */
    
    deleteRequestStatusMaster: function() {
        var grid = this.getRequestStatusMasterGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	  showConfirmMessage(getCommonTranslation('REQUEST_STATUS_MASTER'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (records[count].get("id") != "" && records[count].get("id") != undefined && records[count].get("id") != null) {
                                    id = records[count].get("id");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'DELETE',
                                    url: SERVERURL.REQUEST_STATUS_MASTER_ADD_UPDATE_DELETE + '?id=' + id,
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                    	grid.getStore().reload();
                                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_REQUEST_STATUS_MASTER_MSG')); 
                                    },
                                    failure: function(form, action) {
                                        showSuccessMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
                                    }
                                });
                            }
                        }
                    }
                
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    }

});
