/**
 *	This controller is used for student request action
 *	@author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.faculty.FacultyRequestActionController', {
    extend: 'Academia.controller.personinfo.common.PersonRequestActionController',

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personRequestPendingDecisionForm',
        selector: 'requestpendingdecisionform[itemId=facultyRequestPendingDecisionForm]'
    }, {
        ref: 'personRequestRaisedHistoryForm',
        selector: 'requestraisedhistoryform[itemId=facultyRequestRaisedHistoryForm]'
    }, {
        ref: 'personRequestPendingActionForm',
        selector: 'requestpendingdecisionform[itemId=facultyRequestPendingActionForm]'
    }, {
        ref: 'personRequestExecutedHistoryForm',
        selector: 'requestpendingdecisionform[itemId=facultyRequestExecutedHistoryForm]'
    }, {
    	ref : 'findfacultyportalrequestform',
    	selector : 'findfacultyportalrequestform'
    }],
    config: {
    	FACULTY_REQUEST_RAISED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REQUEST_RAISED_HISTORY_PRIVILEGES'),
    	FACULTY_REQUEST_EXECUTED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REQUEST_EXECUTED_HISTORY_PRIVILEGES'),
    	FACULTY_REQUEST_REQUEST_PENDING_ACTION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REQUEST_PENDING_ACTION_PRIVILEGES'),
    	FACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_REQUEST_PENDING_DESCISION_PRIVILEGES'),
    	FACULTY_PROFILE_REQUEST_RAISED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_REQUEST_RAISED_HISTORY_PRIVILEGES'),
    	FACULTY_PROFILE_REQUEST_EXECUTED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_REQUEST_EXECUTED_HISTORY_PRIVILEGES'),
    	FACULTY_PROFILE_REQUEST_PENDING_DESCISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_REQUEST_PENDING_DESCISION_PRIVILEGES'),
    	FACULTY_PROFILE_REQUEST_PENDING_ACTION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PROFILE_REQUEST_PENDING_ACTION_PRIVILEGES')
    },
    init: function(application) {
        this.control({
            /**
             * Request Raised History
             */'requestraisedhistorygrid[itemId=facultyRequestRaisedHistoryGrid]': {
                render: function(grid) {
                    this.loadGridStore('#facultyRequestRaisedHistoryGrid', SERVERURL.PERSON_SERVICE_REQUEST_RAISED);
                	var portalId = this.getCurrentLoggedPortalId();
                	if (portalId == 1){
                		this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_REQUEST_RAISED_HISTORY_PERMISSIONS());	
                	} else if (portalId == 2){
                		this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_RAISED_HISTORY_PERMISSIONS());
                	}
                }
            },
            'requestraisedhistorygrid[itemId=facultyRequestRaisedHistoryGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestRaisedHistory('REQUEST_RAISED_HISTORY', 'facultyRequestRaisedHistoryForm', '#facultyRequestRaisedHistoryGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] requestraisedhistoryform[itemId=facultyRequestRaisedHistoryForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            /**
             * Request Execution History
             */'requestexecutedhistorygrid[itemId=facultyRequestExecutedHistoryGrid]': {
                render: function(grid) {
                	this.loadGridStore('#facultyRequestExecutedHistoryGrid', SERVERURL.PERSON_SERVICE_REQUEST_EXECUTED);
                	var portalId = this.getCurrentLoggedPortalId();
                	if (portalId == 1){
                		this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_REQUEST_EXECUTED_HISTORY_PERMISSIONS());	
                	} else if (portalId == 2){
                		this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_EXECUTED_HISTORY_PERMISSIONS());
                	}
                }
            },
            'requestexecutedhistorygrid[itemId=facultyRequestExecutedHistoryGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestExecutedHistory('REQUEST_EXECUTED_HISTORY', 'facultyRequestExecutedHistoryForm', '#facultyRequestExecutedHistoryGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] requestpendingdecisionform[itemId=facultyRequestExecutedHistoryForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },

            /**
             * Request Pending Decision
             */

            'requestpendingdecisiongrid[itemId=facultyRequestPendingDecisionGrid]': {
            	render: function(grid) {
//          		var grid = button.up("#facultyTrackRequest").up().down("#facultyPoratalTrackRequestGrid");
            		this.loadGridStore('#facultyRequestPendingDecisionGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_DECISION);
            		var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_REQUEST_PENDING_DESCISION_PERMISSIONS());	
            		} else if (portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS());
            		}
            	}
            },
            'findfacultyportalrequestform':{
            	render: function(form){
            		//form.down('#request_id').setVisible(false);
            		form.down('#assigneeCombo').setVisible(false);
            		this.loadRequestPanel(form);
            	}
            },
            'findfacultyportalrequestform button[itemId=findButtonId]': {
                click : function(button){
                	var grid = button.up("#facultyTrackRequest").up().down("#facultyPoratalTrackRequestGrid");
                	var form = button.up().up();
                	this.loadTrackRequestGrid('#facultyPoratalTrackRequestGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_DECISION,form);
                	this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_PENDING_DESCISION_PERMISSIONS());
        		}
            },
            
            'findfacultyportalrequestform button[itemId=findButtonId]': {
                click : function(button){
                	this.findRequestsByCriteria(button);
        		}
            },
            
            'facultyrequesthistorysearchform button[itemId=findButtonId]': {
                click : function(button){
                	this.findRequestHistoryByCriteria(button);
        		}
            },
            
            'findfacultyportalrequestform button[itemId=clearSearch]': {
                click : function(button){
                	this.resetCustomForm(button);
        		}
            },
            
            'facultyrequesthistorysearchform button[itemId=clearSearch]': {
                click : function(button){
                	this.resetCustomForm(button);
        		}
            },
            
            'requestpendingdecisiongrid[itemId=facultyRequestPendingDecisionGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestPendingDecision('REQUEST_PENDING_DECISION', 'facultyRequestPendingDecisionForm', '#facultyRequestPendingDecisionGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] requestpendingdecisionform[itemId=facultyRequestPendingDecisionForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },
            /**
             * Request Pending Action
             */

            'requestpendingactiongrid[itemId=facultyRequestPendingActionGrid]': {
                render: function(grid) {
                	this.loadGridStore('#facultyRequestPendingActionGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_ACTION);
                	var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 1){
            			this.doAccessControlValidation(grid, this.getFACULTY_PROFILE_REQUEST_PENDING_ACTION_PERMISSIONS());	
            		} else if (portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_REQUEST_REQUEST_PENDING_ACTION());
            		}
                }
            },
            'requestpendingactiongrid[itemId=facultyPoratalPendingActionGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestPendingAction('REQUEST_PENDING_ACTION', 'facultyRequestPendingActionForm', '#facultyPoratalPendingActionGrid');
                }
            },
            'requestpendingactiongrid[itemId=facultyRequestPendingActionGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestPendingAction('REQUEST_PENDING_ACTION', 'facultyRequestPendingActionForm', '#facultyRequestPendingActionGrid');
                }
            },
            'requestpendingactiongrid[itemId=facultyPoratalPendingActionGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestPendingAction('REQUEST_PENDING_ACTION', 'facultyRequestPendingActionForm', '#facultyPoratalPendingActionGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] requestpendingdecisionform[itemId=facultyRequestPendingActionForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },            
            
            'requestsubrequesttypefieldcontainer': {
                beforerender: this.changeServiceRequestStore
            },
            'combo[itemId=requestTypeField]': {
                select: function(combo, records, value) {
                    this.onRequestTypeSelectionDropdown(combo);
                }
            },
            'findfacultyportalrequestform combo[itemId=selectedNameField]': {
                change : function(combo,records,value){
                	  this.onChangeRequesterType(combo);
        		}
            },
            'requestpendingactiongrid':{
            	 afterrender: function(grid) {  
            		 if(portalId = '2'){            			 
            			 this.disableQuickCommentBtnPivilegesToFacultyRequest(grid, this.getFACULTY_REQUEST_REQUEST_PENDING_ACTION());
            		 }
            	 }
            }
        });
    },
    disableQuickCommentBtnPivilegesToFacultyRequest: function (gridReference, permissionsMap) {
        var associatedAcadLocationIds = new Array();
        associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);        
        var quickCommentToFacultyId = gridReference.down('#quickCommentToFacultyRequestId');
        quickCommentToFacultyId.setVisible(false);
        Ext.each(permissionList, function (privilege) {
            if (privilege === 'QUICKCOMMENT') {
                if (!isNullOrEmpty(quickCommentToFacultyId)) {
                	quickCommentToFacultyId.setVisible(true);
                }
            }
        }); 
    },
    changeServiceRequestStore: function(form) {
        var combo = form.down('#requestTypeField');
        var panel = form.up('form');
        if (panel.xtype === 'findrequestform') {
            var store = Ext.create('Academia.store.servicerequest.ServiceRequestCategory');
            combo.bindStore(store);
        } else {
            var store = Ext.create('Academia.store.servicerequest.FacultyServiceRequestCategory');
            combo.bindStore(store);
        }
    },onRequestTypeSelectionDropdown: function(combo) {
        var $this = this;
        var form = combo.up('form');
        var value = combo.getValue();
        var requestSubCategoryField = form.down('#requestSubCategoryField');
        var certificateCategoryField = form.down('#certificateCategoryField');
        var certificateSubCategoryField = form.down('#certificateSubCategoryField');
        var freeFormCategoryField = form.down('#freeFormCategoryField');
        var freeFormSubCategoryField = form.down('#freeFormSubCategoryField');
        requestSubCategoryField.clearValue();
        certificateCategoryField.clearValue();
        certificateSubCategoryField.clearValue();
        freeFormCategoryField.clearValue();
        freeFormSubCategoryField.clearValue();
        switch (value) {
            case 'CERTIFICATE':
                certificateCategoryField.setVisible(true);
                certificateSubCategoryField.setVisible(true);
                requestSubCategoryField.setVisible(false);
                freeFormCategoryField.setVisible(false);
                freeFormSubCategoryField.setVisible(false);
                break;
            case 'FREE_FORM':
                freeFormCategoryField.setVisible(true);
                freeFormSubCategoryField.setVisible(true);
                requestSubCategoryField.setVisible(false);
                certificateCategoryField.setVisible(false);
                certificateSubCategoryField.setVisible(false);
                var store = freeFormCategoryField.getStore();
                store.reload();
                break;
            case 'TRANSFER':
            case 'PERSONAL_DATA_CHANGE':
            case 'EXAM_RELATED':
            default:
                {
                    requestSubCategoryField.setVisible(true);
                    freeFormCategoryField.setVisible(false);
                    freeFormSubCategoryField.setVisible(false);
                    certificateCategoryField.setVisible(false);
                    certificateSubCategoryField.setVisible(false);
                    var store = requestSubCategoryField.getStore();
                     var requestCategory = null;
                    if(value=='DEBARMENT'){
	                    requestCategory="DEBRAMENT_REQUEST";
                     }else if(value=='TERMINATION'){
	                    requestCategory = "TERMINATION_REQUEST";
                         }else{
	                  requestCategory = form.xtype == 'facultyfindrequestform' ? "FACULTY_REQUEST" : "STUDENT_REQUEST"
                  }
                  
                    store.proxy.extraParams = {
                        serviceRequestGroup: value,
                        academyLocationId: $this.getCurrentAcademyLocation(),
                        serviceRequestCategory: requestCategory
                    };
                    store.reload();
                    break;
                }
        }
    },
    onChangeRequesterType:function(combo){
    	var $this = this;
        var form = combo.up('form');
        var value = combo.getValue();
        var student=form.down('#student_id');
        var employee=form.down('#facultyCodeItemId')
        if(value=='STUDENT'){
        	student.setVisible(true);
        	employee.setVisible(false);
        	employee.reset();
        }
        else{
        	student.setVisible(false);
        	employee.setVisible(true);
        	student.reset();
        }
    }
});
