/**
 * @author Swapnil.Patil
 *  Student Progress Report  Controller
 */
Ext.define('Academia.controller.personinfo.student.StudentProgressController', {
	extend: 'Academia.controller.personinfo.common.PersonCommonController',

	stores: ['feeandpayment.managebill.Student','common.AcademyLocationNameSeparated','facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore','enquiry.AcademicBatchStore',
	         'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','enquiry.studentDetail.GenderStore',
	         'student.report.StudentProgressReportGridStore','program.ProgramCategoryStore','student.report.StudentProgressPieChartStore',
	         'reports.admission.AdmissionStatisticsByLocations', 'Academia.store.common.GenderTypeStore','Academia.store.student.report.StudentStatusStore'],

	         views: ['personinfo.student.StudentProgressStructure','personinfo.student.StudentProgressSearchForm',
	                 'personinfo.student.StudentProgressGrid','personinfo.student.StudentProgressPieChart',
	                 'reports.common.PieChartAdvanceReport'],

	                 alias: "widget.studentprogresscontroller",

	                 refs: [
	                        {
	                        	ref: 'studentprogressstructure',
	                        	selector: 'studentprogressstructure',
	                        },
	                        {
	                        	ref: 'studentprogresssearchform',
	                        	selector: 'studentprogresssearchform',
	                        },
	                        {
	                        	ref: 'studentprogressgrid',
	                        	selector: 'studentprogressgrid',
	                        },
	                        {
	                        	ref: 'studentPieChartId',
	                        	selector: 'piechartadvancereport[itemId=studentPieChartId]'
	                        },
	                        {
	                        	ref: 'studentprogresspiechart',
	                        	selector: 'studentprogresspiechart'
	                        }
	                        
	                        ],
	                        config: {
	                        	STUDENT_PROGRESS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PROGRESS_PRIVILEGES'),

	                        },
	                        init: function(application) {
	                        	this.control({
	                        		'studentprogressstructure':{
	                        			render:function(structure){
	                        				this.doAccessControlValidation(structure,this.getSTUDENT_PROGRESS_PERMISSIONS());
	                        			},
	                        			afterrender:function(structure)
	                        			{
	                        				var grid=structure.down('studentprogressgrid');
	                          				 this.getGridHeaderFreeze(grid,structure,true);

	                        			}
	                        		}/*,
	                        		'studentprogresspiechart':{
	                        			change : function(obj, record) {
	                        			  this.loadStudentProgressPieChart();
	                        			}
	                        		}*/,
									  'studentprogresssearchform customcombobox[itemId=studentId]' : {
										render : function(obj) {
											var form = this
													.getStudentprogresssearchform()
													.getForm();
											var student = form
													.findField("studentId");
											// var academyLocationIds =
											// this.getAcademyLocationIds();
											var acaloc = [];
											if (form.multiselectAcademyLocation != ""
													&& form.multiselectAcademyLocation != null) {
												for ( var i in form.multiselectAcademyLocation) {
													if (form.multiselectAcademyLocation[i].raw != null
															&& form.multiselectAcademyLocation[i].raw != "") {
														acaloc
																.push(form.multiselectAcademyLocation[i].raw.id);
													}

												}
											}
											student.getStore().getProxy().extraParams = {
												academyLocationIds : acaloc
														.join(),
												allStudent : true
											};
										},
										select : function(obj, record) {
											var $this = this;
											var form = obj.up('form').getForm();
											var studentStatus = form
													.findField('STATUS');
											var status = record[0].data.sequence;
											if (status == 1) {
												studentStatus.setValue(true);
												studentStatus.setReadOnly(true);
											}
											if (status == 0) {
												studentStatus.setValue(false);
												studentStatus.setReadOnly(true);
											}
										}
									},
	                        		'studentprogresssearchform multiselectcombofield#academyLocationIds' : {
	                        			change : function(obj, record) {
	                        				if(record.length>0 && !Ext.isObject(record[0])){
	                        					var $this = this;
	                        					this.getStudentprogresssearchform().down('#searchBtn').setDisabled(true);
	                        					var programCombo = $this.getStudentprogresssearchform().down('#programId');
	                        					var batchComboBox = this.getStudentprogresssearchform().down('customcombobox#batchId');
	                        					var periodComboBox = this.getStudentprogresssearchform().down('customcombobox#periodId');
	                        					programCombo.clearValue();
	                        					programCombo.setDisabled(false);
	                        					batchComboBox.clearValue();
	                        					batchComboBox.setDisabled(true);
	                        					periodComboBox.clearValue();
	                        					periodComboBox.setDisabled(true);
	                        					var programstore = programCombo.getStore();
	                        					programstore.getProxy().extraParams = {
	                        						academyLocationIds : record.join()
	                        					};
	                        					programstore.load();

	                        					var studentCombo = $this.getStudentprogresssearchform().down('#studentId');
	                        					studentCombo.clearValue();
	                        					studentCombo.setDisabled(false);
	                        					var studentstore = studentCombo.getStore();
	                        					studentstore.getProxy().extraParams = {
	                        						academyLocationIds : record.join(),
	                        						allStudent:true
	                        					};
	                        					studentstore.load();
	                        					this.getStudentprogresssearchform().down('#searchBtn').setDisabled(true);

	                        				}
	                        			}
	                        		},
	                        		'studentprogresssearchform customcombobox#programId' : {
	                        			select : function(obj, record) {
	                        				var programId = record[0].get("id");
	                        				var batchComboBox = this.getStudentprogresssearchform().down('customcombobox#batchId');
	                        				var periodComboBox = this.getStudentprogresssearchform().down('customcombobox#periodId');
	                        				this.getStudentprogresssearchform().down('#searchBtn').setDisabled(true);
	                        				batchComboBox.clearValue();
	                        				batchComboBox.setDisabled(false);
	                        				periodComboBox.clearValue();
	                        				periodComboBox.setDisabled(true);
	                        				var batchStore = batchComboBox.getStore();
	                        				batchStore.getProxy().extraParams = {
	                        					id: programId
	                        				};
	                        				batchStore.load();

	                        			}
	                        		},
	                        		'studentprogresssearchform customcombobox#batchId' : {
	                        			select : function(obj, record) {
	                        				var batch_Id = record[0].get("id");
	                        				this.getStudentprogresssearchform().down('#searchBtn').setDisabled(true);

	                        				var periodComboBox = this.getStudentprogresssearchform().down('customcombobox#periodId');
	                        				periodComboBox.clearValue();
	                        				periodComboBox.setDisabled(false);

	                        				var periodStore = periodComboBox.getStore();
	                        				periodStore.getProxy().extraParams = {
	                        					id: batch_Id

	                        				};
	                        				periodStore.load();

	                        			}
	                        		},
	                        		'studentprogresssearchform customcombobox#periodId' : {
	                        			select : function(obj, record) {
	                        				this.getStudentprogresssearchform().down('#searchBtn').setDisabled(false);
	                        			}
	                        		},
	                        		'studentprogresssearchform button[itemId=resetBtn]' : {
	                        			click : function(){
	                        				var $this = this;
	                        				$this.getStudentprogresssearchform().getForm().reset();
	                        				$this.getStudentprogresssearchform().down('#programId').setDisabled(true);
	                        				$this.getStudentprogresssearchform().down('#batchId').setDisabled(true);
	                        				$this.getStudentprogresssearchform().down('#periodId').setDisabled(true);
	                        				$this.getStudentprogresssearchform().down('#status').setReadOnly(false);
	                        				$this.getStudentprogresssearchform().down('#searchBtn').setDisabled(true);
	                        			}
	                        		},

	                        		'studentprogresssearchform button[itemId=searchBtn]' : {
	                        			click :function(){ 
	                        				 this.loadProgressGrid();
	                        				 this.loadStudentProgressPieChart();
	                        			}
	                        			},

	                        	});
	                        },

	                        loadProgressGrid:function(){
	                        	var $this = this;
	                        	var progressForm = $this.getStudentprogresssearchform();
	                        	var grid = $this.getStudentprogressgrid();
	                        	var form = progressForm.getForm();
	                        	var values = form.getValues();
	                        	var academyLocationId  = values.academyLocationIds;
	                        	var acadmyIds=new Array();
	                        	for(var i in academyLocationId){
	                        		acadmyIds[i]=academyLocationId[i].data.id;
	                        	}
	                        	var status =values.STATUS;
	                        	var checkStatus = null;
	                        	if(status){
	                        		checkStatus='true';
	                        	}
	                        	else{
	                        		checkStatus='false';
	                        	}


	                        	var gridStore = grid.getStore();
	                        	gridStore.getProxy().extraParams = {
	                        		academyLocationIds:acadmyIds.join(),
	                        		studentId:values.studentId,
	                        		status:checkStatus,
	                        		programId:values.programId,
	                        		batchId:values.batchId,
	                        		periodId:values.periodId,
	                        		age:values.age,
	                        		gender:values.gender
	                        	};
	                        	$this.resetPageSetting(grid.getStore());
	                        	gridStore.reload();
	                        	grid.getStore().load();
	                        	grid.config.searchFilterForm = $this.getStudentprogresssearchform();
	                        },

	                        /**
	                         *  Get Json for form submission
	                         */
	                        getJsonSubmitData: function(form) {
	                        	var this$ = this;
	                        	var jsonFormFieldData = new Object();
	                        	var formData = form.getValues();
	                        	jsonFormFieldData = Ext.encode(formData);
	                        	return jsonFormFieldData;
	                        },

	                        loadStudentProgressPieChart: function() {
	                        	var this$ = this;
	                        	var progressForm = this$.getStudentprogresssearchform();
	                        	progressForm.down('#searchBtn').setDisabled(true);
	                        	var studentPieChart = this.getStudentprogresspiechart();
	                        	var chartName=this.getStudentPieChartId();
	                        	var form = progressForm.getForm();
	                        	var values = form.getValues();
	                        	var academyLocationId  = values.academyLocationIds;
	                        	var acadmyIds=new Array();
	                        	for(var i in academyLocationId){
	                        		acadmyIds[i]=academyLocationId[i].data.id;
	                        	}
	                        	var status =values.STATUS;
	                        	var checkStatus = null;
	                        	if(status){
	                        		checkStatus='true';
	                        	}
	                        	else{
	                        		checkStatus='false';
	                        	}
	                        	var studentPieExport = studentPieChart.down('#studentPieExtraBtns');
	                        	//  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                        	Ext.Ajax.request({
	                        		type: 'rest',
	                        		url: SERVERURL.STUDENT_BMI_COUNT,
	                        		method: 'POST',
	                        		headers: {
	                        			'Content-Type': 'application/json'
	                        		},
	                        		jsonData: {
	                        			"academyLocationIds":acadmyIds,
	                        			"studentId":values.studentId,
	                        			 "status"  :checkStatus,
	                        			"programId":values.programId,
	                        			"batchId":values.batchId,
	                        			"periodId":values.periodId,
	                        			"age":values.age,
	                        			"genderCSMId":values.gender
	                        		},
	                        		success: function(response) {
	                        			progressForm.down('#searchBtn').setDisabled(false);
	                        			if (!isNullOrEmpty(response.responseText)) {
	                        				data = Ext.decode(response.responseText);
	                        				//chartName.getStore().loadData(data);
	                        				this$.loadDisableChartOnSelection(data,chartName);
	                        				this$.addExportToPngForDashboard(studentPieExport.menu,chartName);
	                        				if(data.length > 0){
	                        					studentPieExport.setVisible(true);
	                        				}else{
	                        					studentPieExport.setVisible(false);
	                        				}
	                        			}
	                        		}
	                        	});
	                        },
	                        loadDisableChartOnSelection: function(data, form) {

	                        	var isAllZero = true;
	                        	var counts = new Array();
	                        	Ext.each(data, function(value) {
	                        		if (!isNullOrEmpty(value.count)) {
	                        			counts.push(value.count);
	                        		}
	                        	});
	                        	Ext.each(counts, function(value) {
	                        		if (value != 0) {
	                        			isAllZero = false;
	                        			return false;
	                        		}
	                        	});

	                        	if (isAllZero) {
	                        		form.nextSibling().setVisible(true);
	                        		if (form) {
	                        			form.setVisible(false);
	                        		}
	                        	} else {
	                        		form.setVisible(true);
	                        		if (form.nextSibling()) {
	                        			form.nextSibling().setVisible(false);
	                        		}
	                        		form.getStore().loadData(data);
	                        	}
	                        },
	                        getAcademyLocationIds: function(){
	                        	var form =this.getStudentprogresssearchform().getForm();
	                          	var values = form.getValues();
	                          	var aL = values.academyLocation;
	                          	var mAL = values.multiselectAcademyLocation;

	                          	var alArray=[];
	                          	var mALArray=[];

	                          	if(aL !=undefined && aL.length > 0 && aL!=""){
	                          		for(var i in aL){
	                          			if(Ext.isObject(aL[0])){
	                          				alArray.push(aL[i].get("id"));
	                          			}else{
	                          				alArray.push(aL[i]);
	                          			}
	                          		}
	                          		academyLocation= alArray.join();

	                          	}else if(mAL !=undefined && mAL.length > 0 && mAL!=""){
	                          		for(var i in mAL){
	                          			if(Ext.isObject(mAL[0])){
	                          				mALArray.push(mAL[i].get("id"));
	                          			}else{
	                          				mALArray.push(mAL[i]);
	                          			}
	                          		}
	                          		academyLocation= mALArray.join();
	                          	}else{
	                          		academyLocation = this.getCurrentAcademyLocation();
	                          	}
	                          	return academyLocation;
	                          	}	                        
});