/**
 *	This controller is used for student request action
 *	@author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.student.StudentRequestActionController', {
    extend: 'Academia.controller.personinfo.common.PersonRequestActionController',

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personRequestPendingDecisionForm',
        selector: 'requestpendingdecisionform[itemId=studentRequestPendingDecisionForm]'
    }, {
        ref: 'personRequestRaisedHistoryForm',
        selector: 'requestraisedhistoryform[itemId=studentRequestRaisedHistoryForm]'
    }],
    config: {
    	STUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REQUEST_RAISED_HISTORY_PRIVILEGES'),
    	STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES'),
    },
    init: function(application) {
        this.control({
            /**
             * Request Raised History
             */'requestraisedhistorygrid[itemId=studentRequestRaisedHistoryGrid]': {
            	 render: function(grid) {
            		 this.loadGridStore('#studentRequestRaisedHistoryGrid', SERVERURL.PERSON_SERVICE_REQUEST_RAISED);
            		 if(portalId == 2){
            			 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS());
            		 }else if(portalId == 3){
            			 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS());
            		 }else{
            			 this.doAccessControlValidation(grid, this.getSTUDENT_REQUEST_RAISED_HISTORY_PERMISSIONS());
            		 }

            	 }
            },
            'requestraisedhistorygrid[itemId=studentRequestRaisedHistoryGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestRaisedHistory('REQUEST_RAISED_HISTORY', 'studentRequestRaisedHistoryForm', '#studentRequestRaisedHistoryGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] requestraisedhistoryform[itemId=studentRequestRaisedHistoryForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },

            /**
             * Request Pending Decision
             */

            'requestpendingdecisiongrid[itemId=studentRequestPendingDecisionGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#studentRequestPendingDecisionGrid', SERVERURL.PERSON_SERVICE_REQUEST_PENDING_DECISION);
            		if(portalId == 7){
            			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS());
            		}else if(portalId == 2){
            			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS());
            		}else if(portalId == 3){
            			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_REQUEST_PENDING_DESCISION_PERMISSIONS());
            		}

            		
            	}
            },
            'requestpendingdecisiongrid[itemId=studentRequestPendingDecisionGrid] button[itemId=btnView]': {
                click: function() {
                    this.viewRequestPendingDecision('REQUEST_PENDING_DECISION', 'studentRequestPendingDecisionForm', '#studentRequestPendingDecisionGrid');
                }
            },
            'personcommonwindow[itemId=personCommonWindow] requestpendingdecisionform[itemId=studentRequestPendingDecisionForm] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            }
        });
    }
});
