/**
 * @author Ravi Choudhary
 * 
 */
Ext.define('Academia.controller.placement.recruitmentStage.PlacementRecruitmentStageController', {
	extend: 'Academia.controller.base.BaseController',
	// un-comment the model code if required.
	//models : [''],
	stores : ['placement.recruitmentStage.PlacementRecruitmentStageGridStore',
	          'placement.placementcampus.PlacementCampusStore',
	          'placement.placementjobapplication.PlacementJobApplicationGetStudentGridStore',
	          'placement.placementjobapplication.PlacementJobApplicationROStore',
	          'placement.placementjobapplication.PlacementLocationStore',
	          'placement.placementjobapplication.PlacementJobApplicationTitleStore',
	          'placement.placementjobapplication.PlacementJobApplicationStageStatusStore',
	          'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore',
	          'messaging.StaticDocumentAttachmentGridStore'
	          ],
	          views : ['placement.recruitmentStage.PlacementRecruitmentStageStructure',
	                   'placement.recruitmentStage.PlacementRecruitmentStageFilters',
	                   'placement.recruitmentStage.PlacementRecruitmentStageGrid',
	                   'placement.recruitmentStage.PlacementRecruitementEnterMarksWindow',
	                   /*'messaging.sendmessage.SendMessageWindow'*/
	                   'placement.recruitmentStage.PlacementRecruitmentSendMessages','placement.recruitmentStage.PlacementRecruitmentStaticDocumentAttachmentGrid'],
//	                   alias : 'widget.academylocationpurposecontroller',
	                   config:{
	                	   PLACEMENT_RECRUITMENT_STAGE_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PLACEMENT_RECRUITMENT_STAGE_PRIVILEGES')	
	                   },
	                   refs : [
	                           {
	                        	   ref : 'placementrecruitmentstagestructure',
	                        	   selector : 'placementrecruitmentstagestructure'
	                           },{
	                        	   ref : 'placementrecruitmentstagefilters',
	                        	   selector : 'placementrecruitmentstagefilters'
	                           },{
	                        	   ref : 'placementrecruitmentstagegrid',
	                        	   selector : 'placementrecruitmentstagegrid[itemId=placementrecruitmentstagegridId]'
	                           },{
	                        	   ref : 'placementrecruitemententermarkswindow',
	                        	   selector : 'placementrecruitemententermarkswindow'
	                           },/*{
	                        	   ref :'sendMessageWindow',
	                        	   selector : 'sendmessagewindow[itemId=placementRecruitmentSendMsgID]'
	                           }*/{
	                        	   ref :'placementrecruitmentsendmessages',
	                        	   selector : 'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID]'
	                           },{
	                        	   ref :'placementrecruitmentDocumentMessageAttachmentGrid',
	                        	   selector : 'placementrecruitmentstaticdocumentattachmentgrid[itemId=placementrecruitmentStaticDocumentAttachmentGridMessage]'
	                           },{
	                        	   ref: 'contentPanel',
	                        	   selector: 'contentPanel'
	                           }],
	                           init : function() {
	                        	   this.control({
	                        		   'placementrecruitmentstagefilters button[itemId=searchBtn]': {
	                        			   click: this.loadPlacementRecruitmentStageGrid
	                        		   },
	                        		   'placementrecruitmentstagefilters button[itemId=resetBtn]': {
	                        			   click: this.resetPlacementRecruitmentStageFilters
	                        		   },
	                        		   'placementrecruitmentstagegrid button[itemId=sendMessage]':{
	                        			   click: this.openPlacementRecruitmentSendMessage
	                        		   },
	                        		   'placementrecruitmentstagefilters customcombobox[itemId=placementcampusItemId]':{
	                        			   select:function(obj,rec){
	                        				   var data=rec[0].data.id;  
	                        				   var filterForm=obj.up('form');
	                        				   var recruitingOrganization=filterForm.down('#recruitingOrganization');
	                        				   recruitingOrganization.reset();
	                        				   recruitingOrganization.getStore().getProxy().extraParams={
	                        					   placementCampusId:data
	                        				   };
	                        				   recruitingOrganization.getStore().load();

	                        				   var jobTitleField=filterForm.down('#jobtitle');
	                        				   jobTitleField.setDisabled(false);
	                        				   jobTitleField.reset();
	                        				   jobTitleField.getStore().getProxy().extraParams={
	                        					   placementCampusRecruitingOrgId:data
	                        				   };
	                        				   jobTitleField.getStore().load();
	                        			   }
	                        		   },
	                        		   'placementrecruitmentstagefilters customcombobox[itemId=recruitingOrganization]':{
	                        			   select:function(obj,rec){
		            	        				var data=rec[0].data.id;  
	                        				    var filterForm=obj.up('form');
		            	        				var jobTitleField=filterForm.down('#jobtitle');
		            	        				jobTitleField.setDisabled(false);
		            	        				jobTitleField.reset();
		            	        				jobTitleField.getStore().getProxy().extraParams={
		            	        					placementCampusRecruitingOrgId:data
		            	        				};
		            	        				jobTitleField.getStore().load();
	                        			   }
	                        		   },
	                        		   'placementrecruitmentstagefilters customcombobox[itemId=jobtitle]':{
	                        			   select:function(obj,rec){
	                        				    var jobId=rec[0].data.id;  
	                        				    var filterForm=obj.up('form');
	                        				    var selectionStage=filterForm.down('#selectionStage');
			     	                        	var store = selectionStage.getStore();
		            	        				store.getProxy().extraParams = {
		            	        					placementJobId: jobId
			     	                        	   };
		            	        				selectionStage.setDisabled(false);
		            	        				store.load();
	                        			   }
	                        		   },
	      							  
	      							  'placementrecruitmentstagegrid ':{
	      								  render:function(grid){
	      									  this.doAccessControlValidation(grid, this.getPLACEMENT_RECRUITMENT_STAGE_PERMISSION());
	      									  this.placementRecruitmentStageButtonPivileges(grid,this.getPLACEMENT_RECRUITMENT_STAGE_PERMISSION());
	      								  },
	      								  select:function(obj, record,rowIndex, e){
	      									  this.enableDisableEnterMarksBtn();
	      									  this.enableDisablePromoteStudentBtn();
	      									  
	      								  },
	      								  deselect:function(obj, record, rowIndex, e){
	      									  this.enableDisableEnterMarksBtn();
	      									  this.enableDisablePromoteStudentBtn();
	      								  }
	      							  },
	      							  
	      							  'placementrecruitmentstagegrid button[itemId=enterMarks]':{
	      								  click:function() {
	      									  this.openEnterMarksWindow();
	      								  }
	      							  },

	      							  'placementrecruitemententermarkswindow button[itemId=submitBtn]':{
	      								  click:function(){
	      									  var this$ = this;
	      									  this.saveEnterMarksForm();
	      								  }
	      							  },

	      							  'placementrecruitemententermarkswindow button[itemId=cancelBtn]':{
	      								  click:function(){
	      									  this.closeEnterMarksPopupWindow();
	      								  }
	      							  },
	      							  'placementrecruitmentstagegrid button[itemId=promoteStudent]':{
	      								  click:function() {
	      									  this.promoteStudent();
	      								  }
	      							  },
	      							  'placementrecruitmentstagegrid button[itemId=calculateRank]':{
	      								  click:function() {
	      									  this.calculateRank();
	      								  }
	      							  },
	      							/*'sendmessagewindow button[itemId=adhocMsgSubmitBtn]':{
	                        			   click: function(button){
	                        				    var grid = this.getPlacementrecruitmentstagegrid();
	                       	        			this.sendPlaceMessageRecuitment(button,grid);
	                        			   }
	                        		   },
	                        		   
	                        		   'sendmessagewindow[itemId=placementRecruitmentSendMsgID] combo#selectTemplate': {
	                       	        	render: function(combo) {
	                       	        		var store = combo.getStore();
	                       	        		var msgRecipientTypeId = combo.up('window').down('#msgRecipientTypeItemId').getValue();
	                       	        		 store.on('beforeload', function(store, operation) {
	                       	                     store.proxy.extraParams = {
	                       	                    		 msgRecipientTypeId :msgRecipientTypeId
	                       	                     };
	                       	                 });
	                           			},
	                           			select :function(combo,records){
	                           				var msgCategoryId = combo.up('window').down('#msgCategoryId');
	                           				var msgSubCategoryId = combo.up('window').down('#msgSubCategoryId');
	                           				msgCategoryId.setValue(records[0].data.msgCategoryId);
	                           				msgSubCategoryId.setValue(records[0].data.msgSubCategoryId);
	                           			}
	                       	        },*/
	                       	        'placementrecruitemententermarkswindow numberfield[itemId=marksObtained]':{
	                       	        	change: function(button){
	                       	        		var form = this.getPlacementrecruitemententermarkswindow();
	                       	        		var f1 = form.down('form');
	                       	        		if(f1.isValid()) {
	                       	        			form.down("#submitBtn").setDisabled(false);
	                       	        		} else {
	                       	        			form.down("#submitBtn").setDisabled(true);
	                       	        		}
	                       	        	}
	                       	        },
	                       	        /*START :- added for adhoc messaging*/
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID] radiogroup[itemId=messageType]':{
	                       	        	change : function(val,nV,oV){
	                       	        		this.selectPlacementRecruitmentSectionMessageType(val,nV,oV);
	                       	        	}
	                       	        },
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID] customcombobox[itemId=msgTempletId]':{
	                       	        	select : function(obj,rec){
	                       	        		this.selectPlacementRecruitmentMessageTemp(obj,rec);
	                       	        	}
	                       	        },
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID] button[itemId=adhocMsgSubmitBtn]':{
	                       	        	click: function(obj) {
	                       	        		var grid = this.getPlacementrecruitmentstagegrid();
	                       	        		var placementSendMessage = this.getPlacementrecruitmentsendmessages();
	                       	        		var formPnl = obj.up('form');
	                       	        		var isMySelfChecked = false;
	                       	        		var fldValues = formPnl.getForm().getFieldValues();
	                       	        		isMySelfChecked = fldValues.recieverType;
	                       	        		var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
	                       	        		placementSendMessage.placementSendMessage(obj,grid,isMySelfChecked,currentlyLoggedInUserId);
	                       	        	}
	                       	        },
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID]  filefield[itemId=staticUploadFileField]': {
	                       	        	change: function(fileField, value, eOpts){
	                       	        		var this$ = this;
	                       	        		this$.uploadPlacementRecruitmentStaticDocumentFileMessage(fileField, value, eOpts);
	                       	        	}
	                       	        },
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID]': {
	                       	        	render: function(grid){
	                       	        		var this$ = this;
	                       	        		var docGrid = grid.down('#placementrecruitmentStaticDocumentAttachmentGridMessage');
	                       	        		docGrid.getStore().removeAll();
	                       	        		docGrid.getStore().sync();
	                       	        		var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
	                      	        		this$.disableRadioGroupAndOtherPivileges(grid, this$.getPLACEMENT_RECRUITMENT_STAGE_PERMISSION(), itemIdPrivilegeNameArray);
	                       	        	}
	                       	        }, 
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID] radiogroup#sendingPriority': {
	                       	        	change: function( radio, newValue, oldValue, eOpts) {
	                       	        		this.loadPlacementRecruitmentScheduleField(radio, newValue, oldValue);
	                       	        	}
	                       	        },
	                       	        'placementrecruitmentstaticdocumentattachmentgrid[itemId=placementrecruitmentStaticDocumentAttachmentGridMessage] actioncolumn': {
	                       	        	click : function(view, rowIndex, colIndex, item, e, record, row){
	                       	        		this.deletePlacementRecruitmentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
	                       	        	}
	                       	        },
	                       	        /*V2D-13247*/
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID] textarea[itemId=smsDiscription]':{
	                       	        	change : function(val,nV,oV){
	                       	        		var placementRecruitmentsendmessages = this.getPlacementrecruitmentsendmessages();
	                       	        		var smsTextField = placementRecruitmentsendmessages.down('#smsDiscription');
	                       	        		var smsTextFieldDiscription = placementRecruitmentsendmessages.down('#smsDiscriptionNotice');
	                       	        		var maxLength = localStorage.getItem('maxLength');
	                       	        		var newValue = maxLength - smsTextField.getValue().length;
	                       	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	                       	        	}
	                       	        },
	                       	        'placementrecruitmentsendmessages[itemId=placementRecruitmentSendMsgID] textarea[itemId=pushNotificationDiscription]':{
	                       	        	change : function(val,nV,oV){
	                       	        		var placementRecruitmentsendmessages = this.getPlacementrecruitmentsendmessages();
	                       	        		var pushTextField = placementRecruitmentsendmessages.down('#pushNotificationDiscription');
	                       	        		var pushTextFieldDiscription = placementRecruitmentsendmessages.down('#pushNotificationDiscriptionNotice');
	                       	        		var maxLength = 1000;
	                       	        		var newValue = maxLength - pushTextField.getValue().length;
	                       	        		pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
	                       	        	}
	                       	        },
	                       	        /*END :- added for adhoc messaging*/
	                       	     
	                       	  'placementrecruitmentstagestructure' :  {
	             				 afterrender : function(structure){
	             					 var $this = this;
	             					 structure.body.on('scroll', function(e, target) {
	             		   				  var pcstructure = structure.down("placementrecruitmentstagegrid");
	             		   				  var academyLocationId = $this.getCurrentAcademyLocation();
	             		   				  var grid = null;
	             		   				  
	             		   				  if(!pcstructure.isHidden()){
	             		   					  grid = pcstructure;
	             		   				  }
	             		   				  $this.getMultipleGridHeaderFreeze(grid,structure,true);
	             						 });
	             				 }
	             			}

	                        	   });
	                           },
	                           /**
	                            * This method is used to send message
	                            */
	                           /*sendPlaceMessageRecuitment : function(button,grid){
	                       		baseController = Academia.app.getController('Academia.controller.base.BaseController');
	                       		var formData = button.up('form').getValues();
	                       		var recipientIds = this.getReceipientId(grid);

	                       		*//**
	                       		 * The below changes were done for Applicant Adhoc message
	                       		 *//*
	                       		var typeId;
	                       		if(formData.msgRecipientTypeId == 10){
	                       			typeId = 32;
	                       		} else {
	                       			typeId = formData.msgRecipientTypeId;
	                       		}
	                       		
	                       		var json = {
	                       				id: null, 
	                       			    status: null, 
	                       			    msgTemplateConfigId: null, 
	                       			    sendingPriority: formData.sendingPriority, 
	                       			    msgCategoryId:formData.msgCategoryId, 
	                       			    msgSubCategoryId: formData.msgSubCategoryId, 
	                       			    messageId: formData.messageId, 
	                       			    displayCode: formData.displayCode, 
	                       			    wsMsgEventRecipientConfigs: [ 
	                       			        { 
	                       			            msgRecipientTypeId: typeId, 
	                       			            msgTemplateConfigId:formData.msgTemplateConfigId, 
	                       			            selectiveRecipientIds:recipientIds 
	                       			        } 
	                       			    ], 
	                       			    wsAdhocRecipients: null, 
	                       			    approverId: null, 
	                       			    approvalRequired: false, 
	                       			    reviewStatusCode: "APPROVED" 

	                       		};
	                       		if(formData.sendingPriority==="SCHEDULE"){
	                    			if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
	                        			var dateString="";
	                        			dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
	                        			json.msgDueDate=dateString;
	                        		}else{
	                        			json.msgDueDate= null;
	                        		}
	                    		}else if(formData.sendingPriority==="IMMEDIATE"){
	                    			var now = new Date();
	                    			var dateString = Ext.Date.format(now,'Y-m-d h:i A');
	                    			json.msgDueDate=dateString;
	                    		}else{
	                    			json.msgDueDate= null;
	                    		}
	                    		
	                    		var academyLocation=baseController.getCurrentAcademyLocation();
	                        	if(!isNullOrEmpty(academyLocation)){
	                        		json.academyLocationId=academyLocation;
	                        	}
	                        	
	                        	var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
	                        	if(!isEmpty(currentlyLoggedInUser)){
	                        		json.authorId=currentlyLoggedInUser.id;
	                        		json.authorName=currentlyLoggedInUser.value;
	                        	}
	                            jsonDataEncode = Ext.encode(json);
	                    		Ext.Ajax.request({
	                                type: 'rest',
	                                url: SERVERURL.ADOC_MESSAGEING_CREATE,
	                                jsonData: jsonDataEncode,
	                                method: 'POST',
	                                success: function(form, action) {
	                                    grid.getStore().reload();
	                                    grid.getSelectionModel().deselectAll(true);
	                                    button.up('window').close();
	                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
	                                }

	                            });
	                           },	
	                           

	                       	*//**
	                       	 * This method is used to get Ids 
	                       	 *//*
	                         getReceipientId : function(grid){
	                       		var records = grid.getSelectionModel().getSelection();
	                       		var ids = new Array();
	                       		
	                       		if(grid.itemId === 'StudentSearchResultGrid'){
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].raw.ADMISSION_ID);
	                       			}
	                       		}else if(grid.itemId === 'facultySearchResultGrid' ||grid.itemId === 'applicationsListGrid',grid.itemId ==='trackenquirygrid'){
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].raw.ID);
	                       			}
	                       		}else if(grid.itemId === 'userSearchresultgrid'){
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].raw.USER_ID);
	                       			}
	                       		}else{
	                       			for(var i = 0 ; i<records.length;i++){
	                       				ids.push(records[i].data.admissionId);
	                       			}
	                       		}
	                       		return ids;
	                       	},
	                           addSendMessage:function(){
	           	                	var grid = this.getPlacementrecruitmentstagegrid();
	               	            	if (grid.getSelectionModel().getCount() > 0) {
	               	            		var this$ = this;
//	               	            		Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
	               	                	var window = this$.getSendMessageWindow();
	               	                	if(!window){
	               	                		window = Ext.widget('sendmessagewindow',{
	               	                			itemId:'placementRecruitmentSendMsgID'
	               	                		});
	               	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.STUDENT);
	               	                	}
	               	                	window.show();
	               	            	} else {
	               	            		showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	               	            	}  
	                           },*/
	                           loadPlacementRecruitmentStageGrid:function(){
	                        	   var $this=this;
	                        	   var grid = $this.getPlacementrecruitmentstagegrid();	                        	   
	                        	   var filterForm = $this.getPlacementrecruitmentstagefilters();
	                        	   var values = filterForm.getValues();
	                        	   var store = grid.getStore();
	                        	   store.getProxy().extraParams = {
	                        		   placementCampusId:values.placementcampus,
	                        		   academyLocationId:values.recruitingOrganization,
	                        		   jobTitleId:values.jobtitle,
	                        		   selectionStageId:values.selectionStage
	                        	   }
	                        	   store.load();
	                        	   /*pdf & excel report header filter*/
	                           	   grid.config.searchFilterForm = $this.getPlacementrecruitmentstagefilters();
	                           },
	                           resetPlacementRecruitmentStageFilters :function(){
	                        	   var $this=this;
	                        	   var filter = $this.getPlacementrecruitmentstagefilters().getForm();
	                        	   filter.reset();
	                        	   var filterForm = $this.getPlacementrecruitmentstagefilters();
	                        	   var recruitingOrganization=filterForm.down('#recruitingOrganization');
	                        	   recruitingOrganization.reset();

	                        	   var recruitingOrganizationStore = recruitingOrganization.getStore();
	                        	   recruitingOrganizationStore.getProxy().extraParams={
	                        		   placementCampusId:null
	                        	   };
	                        	   recruitingOrganizationStore.load();

	                        	   var jobTitleField=filterForm.down('#jobtitle');
	                        	   jobTitleField.reset();
	                        	   jobTitleField.getStore().getProxy().extraParams={
	                        		   placementCampusRecruitingOrgId:null
	                        	   };
	                        	   jobTitleField.getStore().load();

	                        	   var selectionStageField = $this.getPlacementrecruitmentstagefilters().down('#selectionStage');
						    			selectionStageField.disable(true);
	                           },
	                           
	                           addPlacementJobApplicationRecord:function(){
	                        	   var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                        	   var structure = Ext.widget('placementjobapplicationform');
	                        	   var tabName = getPlacementTranslation('APPLY_FOR_JOB');
	                        	   /**
	                        	    * This is to remove tab from content panel and open same tab again
	                        	    */
	                        	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                        	   var getTab=getcontroller.getTab(tabName);
	                        	   if(getTab!=null){
	                        		   contentPanel.remove(getTab, true);
	                        	   }
	                        	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);		
	                           },
	                           createJson: function(){
	                        	   // Create required json to Save
	                        	   var json= "";
	                        	   return json;	
	                           },
	                            
					    	
					    	placementRecruitmentStageButtonPivileges: function(gridReference,permissionsMap) {
					    		var associatedAcadLocationIds = new Array();
								associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
						    	buttonsToolBar = gridReference.query('toolbar')[0];
						    	
						    	var enterMarksBtn = buttonsToolBar.query('#enterMarks')[0];
						    	enterMarksBtn.setVisible(false);
						    	
						    	var promoteStudentBtn = buttonsToolBar.query('#promoteStudent')[0];
						    	promoteStudentBtn.setVisible(false);
						    	
						    	var calculateRankBtn = buttonsToolBar.query('#calculateRank')[0];
						    	calculateRankBtn.setVisible(false);
						    	
						    	var sendMessageBtn = buttonsToolBar.query('#sendMessage')[0];
						    	sendMessageBtn.setVisible(false);
						    	
						    	Ext.each(permissionList, function(privilege) {
						    		if (privilege === 'ENTERMARKS') {
						        		if(!isNullOrEmpty(enterMarksBtn)){
						        			enterMarksBtn.setVisible(true);
						        		}        		
						        	}
						    		if (privilege === 'PROMOTESTUDENT') {
						        		if(!isNullOrEmpty(promoteStudentBtn)){
						        			promoteStudentBtn.setVisible(true);
						        		}        		
						        	}
						    		if (privilege === 'CALCULATERANK') {
						        		if(!isNullOrEmpty(calculateRankBtn)){
						        			calculateRankBtn.setVisible(true);
						        		}        		
						        	}
						    		if (privilege === 'SENDMESSAGE') {
						        		if(!isNullOrEmpty(sendMessageBtn)){
						        			sendMessageBtn.setVisible(true);
						        		}        		
						        	}
						    	});
					    	},
					    	
					    	openEnterMarksWindow:function(){

					    		var this$ = this;
					    		var grid = this.getPlacementrecruitmentstagegrid();
					    		
                        		if(grid.getSelectionModel().getCount()>0){
                        			var record = grid.getSelectionModel().getSelection()[0];
                            		var stageId = record.get("selectionProcessStageId");
                            		var stageMarksId = record.get("placementJobApplicationStageMarksId");
                            		var jobApplicationstageId = record.get("placementJobApplicationStageId");
                            		
                            		var submitUrl = SERVERURL.PLACEMENTJOB_APPLICATION_STAGE_EVALPARAM_GET+'?selectionProcessStageId='
    			    	            +stageId;
                            		if(!isNullOrEmpty(stageMarksId)) {
                            			submitUrl = submitUrl+'&placementJobApplicationStageMarksId='+stageMarksId;
                            		}
                            		if(!isNullOrEmpty(jobApplicationstageId)) {
                            			submitUrl = submitUrl+'&placementJobApplicationStageId='+jobApplicationstageId;
                            		}
                            		
					    			var formWindow = this$.getPlacementrecruitemententermarkswindow();
					    			if (!formWindow) {
					    				Ext.widget('placementrecruitemententermarkswindow');
					    				formWindow = this$.getPlacementrecruitemententermarkswindow();
					    			}
					    			Ext.Ajax.request({
					    	            type: 'rest',
					    	            url: submitUrl,
					    	            method: 'GET',
					    	            async:false,
					    	            success: function(response, action) {
					    	            	var data = Ext.decode(response.responseText);
							    			this$.loadEnterMarkForm(data, formWindow);
					    	            }
					    	        });
					    			
					    		}else{
					    			showWarningMessage(getPlacementTranslation('RECRUITEMENT_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					    		}
					    	},

					    	promoteStudent:function(){

					    		var grid = this.getPlacementrecruitmentstagegrid();
					    		if(grid.getSelectionModel().getCount()>0){
					    			showConfirmMessage(getPlacementTranslation('RECRUITEMENT_STAGE'), getPlacementTranslation('ARE_YOU_SURE_WANT_TO_PROMOTE_STUDENTS'), function(btn, text) {
					    				if (btn == 'yes') {
					    					var dataList = new Array();
					    					var record = grid.getSelectionModel().getSelection();
					    					for(var i = 0; i< record.length;i++){
							        			dataList.push(record[i].data.placementJobApplicationStageId);
							        		}
					    					var url = SERVERURL.PLACEMENT_JOB_APPLICATION_PROMOTE_STUDENT+'?placementJobAppicationStageIds='+dataList.join();
								            Ext.Ajax.request({
								                type: 'rest',
								                url: url,
								                method: 'GET',
								                success: function(form, action) {
								                    Ext.getBody().unmask();
								                    showSuccessMessage(getPlacementTranslation('RECRUITEMENT_STAGE_MARKS'), getPlacementTranslation('RECRUITMENT_STAGE_PROMOTE_STUDENT_SUCCESS'));
								                    grid.getStore().load();
								                }
								            });
					    				}
					    			});
					    		}else{
					    			showWarningMessage(getPlacementTranslation('RECRUITEMENT_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					    		}
					    	},
					    	enableDisableEnterMarksBtn : function() {

					    		var recruitmentStageGrid=this.getPlacementrecruitmentstagegrid();
					    		var enterMarksBtn = recruitmentStageGrid.down('#enterMarks');
					    		if (recruitmentStageGrid.getSelectionModel().getCount() > 1) {
					    			enterMarksBtn.disable();
					    		} else {
					    			enterMarksBtn.enable();
					    		}
					    	},
					    	
					    	enableDisablePromoteStudentBtn : function() {
					    		var recruitmentStageGrid=this.getPlacementrecruitmentstagegrid();
					    		var promoteStudentBtn = recruitmentStageGrid.down('#promoteStudent');
					    		if (recruitmentStageGrid.getSelectionModel().getCount() > 0) {
					    			var record = recruitmentStageGrid.getSelectionModel().getSelection();
					    			for(var i=0;i<record.length;i++) {
					    				if(record[i].data.status == 'SELECTED') {
					    					promoteStudentBtn.disable();
					    					break;
					    				} else {
					    					promoteStudentBtn.enable();
					    				}	
					    			}
					    		} else {
					    			promoteStudentBtn.enable();
					    		}
					    	},
					    	
					    	saveEnterMarksForm: function() {
					            var formValues = this.getPlacementrecruitemententermarkswindow();
					            var this$ = this;
					            var mainObjArray = this$.createJsonForEnterMarks();
					            var grid = this.getPlacementrecruitmentstagegrid();
					            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					            var url = SERVERURL.PLACEMENT_JOB_APPLICATION_MARKENTRY_SELECTION_STAGE;
					            Ext.Ajax.request({
					                type: 'rest',
					                url: url,
					                jsonData: mainObjArray,
					                method: 'POST',
					                success: function(form, action) {
					                    Ext.getBody().unmask();
					                    this$.closeEnterMarksPopupWindow();
					                    showSuccessMessage(getPlacementTranslation('RECRUITEMENT_STAGE_MARKS'), getPlacementTranslation('RECRUITMENT_STAGE_ENTER_MARKS_SUCCESS'));
					                    grid.getStore().load();
					                }
					            });
					        },
					    	
					    	//Load enter mark form on grid render by PATH_FIND_BY_SELECTION_PROCESS_STAGE
					        loadEnterMarkForm: function(stageEvalParams,formWindow) {
					            var this$ = this;
					            var grid = this.getPlacementrecruitmentstagegrid();
					            var record = grid.getSelectionModel().getSelection()[0];
					            var jobApplicationstageId = record.get("placementJobApplicationStageId");
					            
					            var form = this$.getPlacementrecruitemententermarkswindow();
					            
					            var stageEvalParamsObject = stageEvalParams;
					            var formItems = [];
					            
					            //var markTypeFieldName = 'marksObtained';//(evaluationTypeValue == 'MARK') ? 'marksObtained' : 'obtainedGrade';

					            Ext.each(stageEvalParamsObject, function(obj) {

					            	// Add the records to the formItems array.
					            	var field = {
					            			xtype: 'form',
					            			plugins : "formlabelrequired",
					            			layout: 'hbox',
					            			name: obj.id + "_" + obj.evaluationParameter,
					            			cls: 'panelNoSpace',
					            			defaults: {
					            				labelAlign: 'top',
					            				width: 226,
					            				padding: '10'
					            			},
					            			items: [{
					            				xtype: 'hidden',
					            				name: 'id'
					            			}, {
					            				xtype: 'hidden',
					            				name: 'version'
					            			}, {
					                            xtype: 'hidden',
					                            name: 'jobApplicationstageId',
					                            value: jobApplicationstageId,
					                        }, {
					                        	xtype: 'numberfield',
					            				hidden: true,
					            				readOnly: true,
					            				name: 'weightage',
					            				value: obj.weightage
					                        }, {
					            				xtype: 'nestedTextField',
					            				hidden: true,
					            				readOnly: true,
					            				name: 'selectionStageEvalParamWeightage',
					            				value: obj.id
					            			}, {
					            				xtype: 'numberfield',
					            				fieldLabel: getPlacementTranslation('MARKS'),
					            				name: 'marksObtained',
					            				itemId: 'marksObtained',
					            				validateOnBlur: true,
					            				maxValue:obj.maxMarks,
					            				value:obj.marksObtained
					            			}, {
					            				xtype: 'textfield',
					            				fieldLabel: getAdmissionTranslation('MAXIMUM_MARKS'),
					            				name: 'maxMarks',
					            				itemId: 'maxMarks',
					            				readOnly: true,
					            				value: obj.maxMarks
					            			}]
					            	};
					            	formItems.push(field);
					            });
					            
					            var buttonField = {
					                xtype: 'fieldcontainer',
					                width: '100%',
					                style:{
					                	marginLeft:'8px !important'
					                },
					                items: [{
					                    xtype: 'button',
					                    action: 'Submit',
					                    text: getCommonTranslation('SUBMIT'),
					                    ui: 'CustomBtnSubmit',
					                    itemId:'submitBtn',
					                    scale: CONSTANTS.BUTTONSIZE,
					                    formBind: true,
					                    //disabled: true
					                }, {
					                    xtype: 'button',
					                    text: getCommonTranslation('CANCEL'),
					                    action: 'Cancel',
					                    itemId:'cancelBtn',
					                    ui: 'CustomBtnCancel',
					                    scale: CONSTANTS.BUTTONSIZE
					                }]
					            };
					            formItems.push(buttonField);
					            Ext.suspendLayouts();
					            form.removeAll();
					            form.add(formItems);
					            Ext.resumeLayouts(true);
					            formWindow.show();
					        },
					        
					        createJsonForEnterMarks : function() {
					        	
					        	var this$ = this;
					        	var form = this$.getPlacementrecruitemententermarkswindow();//.down('form').getForm().getValues();
					        	var size = form.items.length;
					        	var mainObjArray = new Array();
					        	Ext.each(form.items.items, function(dform) {
					        		if(dform.xtype == 'form') {
					        			var formValues = dform.getForm().getValues();
					        			var mainObj = new Object();
					        			mainObj.placementJobApplicationStageId = formValues.jobApplicationstageId;
					        			mainObj.slctnStageEvalParamWeightageId = formValues.selectionStageEvalParamWeightage.id;
					        			mainObj.marksObtained = formValues.marksObtained;
					        			mainObj.maxMarks = formValues.maxMarks;
					        			mainObj.weightage = formValues.weightage;
					        			mainObjArray.push(mainObj);
					        		}
					        	});
					        	return Ext.encode(mainObjArray);
					        },
					        
					        closeEnterMarksPopupWindow: function() {
					            this.getPlacementrecruitemententermarkswindow().close();
					        },
					        
					        calculateRank : function() {
					        	
					        	var grid = this.getPlacementrecruitmentstagegrid();
					        	var record = grid.getSelectionModel().getSelection();
					        	var dataList = new Array();
					        	if(grid.getSelectionModel().getCount()>0){
					        		for(var i = 0; i< record.length;i++){
					        			dataList.push(record[i].data.selectionStageId);
					        		}
					        		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						            var url = SERVERURL.PLACEMENT_JOB_APPLICATION_CALCULATE_RANK+'?selectionStageIdS='+dataList.join();
						            Ext.Ajax.request({
						                type: 'rest',
						                url: url,
						                method: 'GET',
						                success: function(form, action) {
						                    Ext.getBody().unmask();
						                    showSuccessMessage(getPlacementTranslation('RECRUITEMENT_STAGE_MARKS'), getPlacementTranslation('RECRUITMENT_STAGE_RANK_CALCULATED_SUCCESS'));
						                    grid.getStore().load();
						                }
						            });
					    		}else{
					    			showWarningMessage(getPlacementTranslation('RECRUITEMENT_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					    		}
					        
					        },
					        /*Start :- added for adhoc messsaging*/
					        openPlacementRecruitmentSendMessage:function(obj){

					        	var grid = this.getPlacementrecruitmentstagegrid();
					        	//var gridMSG = this.getStaticDocumentAttachmentGrid();
					        	if(grid.getSelectionModel().getCount()>0) {

					        		var $this=this;
					        		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					        		var structure = Ext.widget('placementrecruitmentsendmessages',{
					        			itemId:'placementRecruitmentSendMsgID'
					        		});
					        		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
					        		/**
					        		 * This is to remove tab from content panel and open same tab again
					        		 */
					        		var getcontroller=this.getController('menu.CoreERPNavigationController');
					        		var getTab=getcontroller.getTab(tabName);
					        		if(getTab!=null){
					        			contentPanel.remove(getTab, true);
					        		}
					        		var formWindowTab = $this.getPlacementrecruitmentsendmessages();
					        		formWindowTab.down("#selectTemplate").allowBlank=true;
					        		formWindowTab.down("#selectTemplate").setVisible(false);
					        		formWindowTab.down("#messageName").allowBlank=true;   
					        		formWindowTab.down("#messageName").setVisible(false);
					        		var templateStore = formWindowTab.down('#selectTemplate').getStore();
					        		templateStore.getProxy().extraParams={
					        			msgRecipientTypeId:2
					        		};
					        		templateStore.load();

					        		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					        		Ext.Ajax.request({
					        			method : "GET",
					        			type : 'rest',
					        			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=PlacementRecruitmentTemplatebe539740-692d-4ae1-bc17-338c4002874d',
					        			headers : {
					        				'Content-Type' : 'application/json'
					        			},
					        			success : function(form,action) {
					        				var data = Ext.JSON.decode(form.responseText);
					        				formWindowTab.down("#id").setValue(data.id);
					        				formWindowTab.down("#code").setValue(data.code);
					        				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
					        				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
					        				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
					        				Ext.getBody().unmask();

					        				//grid.getStore().reload();
					        				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
					        			}

					        		});
					        		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);

					        	} else {
					        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					        	}
					        },
					       
					        selectPlacementRecruitmentSectionMessageType : function(val,nV,oV){

					        	var $this =  this;
					        	var formWin = $this.getPlacementrecruitmentsendmessages();

					        	//var value = nV.1;
					        	if(nV.messageType==2){
					        		formWin.down("#messageId").hide();
					        		formWin.down("#selectTemplate").allowBlank=true;
					        		formWin.down("#selectTemplate").setVisible(false);     		 
					        		formWin.down("#messageName").allowBlank=true;   
					        		formWin.down("#messageName").setVisible(false);
					        		formWin.down("#msgTempletId").setVisible(true);
					        		formWin.down("#msgTempletId").allowBlank=false;
					        		formWin.down("#msgTempletId").reset();
					        		formWin.down("#subject").setVisible(true);
					        		formWin.down("#subject").allowBlank=false;
					        		formWin.down("#subject").reset();
					        		formWin.down("#discriptionId").setVisible(true);
					        		formWin.down("#discriptionId").reset();
					        		formWin.down('#smsDiscription').reset();
					        		formWin.down('#smsDiscription').hide();
					        		formWin.down('#smsDiscriptionNotice').hide();
					        		formWin.down('#pushNotificationDiscription').hide();
					        		formWin.down('#pushNotificationDiscriptionNotice').hide();
					        		formWin.down('#fldSendToContainer').show();
					        	}else{
					        		formWin.down("#msgTempletId").allowBlank=true;
					        		formWin.down("#msgTempletId").setVisible(false);     		
					        		formWin.down("#messageId").setVisible(true);
					        		formWin.down("#selectTemplate").setVisible(true);     		
					        		formWin.down("#messageName").setVisible(true);
					        		formWin.down("#messageName").reset();
					        		formWin.down("#subject").allowBlank=true;
					        		formWin.down("#subject").setVisible(false);
					        		formWin.down("#discriptionId").setVisible(false);
					        		formWin.down("#messageName").allowBlank=false;  
					        		formWin.down("#selectTemplate").allowBlank=false;
					        		formWin.down("#selectTemplate").reset();
					        		formWin.down("#placementrecruitmentDocumentMessageAttachmentGrid").setVisible(false);
					        		formWin.down("#staticUploadFileField").setVisible(false);
					        		formWin.down('#smsDiscription').reset();
					        		formWin.down('#smsDiscription').hide();
					        		formWin.down('#smsDiscriptionNotice').hide();
					        		formWin.down('#pushNotificationDiscription').hide();
					        		formWin.down('#pushNotificationDiscriptionNotice').hide();
					        		var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
					        		formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
					        		formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
					        		formWin.down('#fldSendToContainer').hide();
					        	}
					        },
					        selectPlacementRecruitmentMessageTemp: function(obj,rec){
					        	var $this =  this;
					        	var formWin = $this.getPlacementrecruitmentsendmessages();
					        	var subject = formWin.down('#subject');
					        	var smsDiscription = formWin.down('#smsDiscription');
					        	var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
					        	var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
					        	var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
					        	if(rec[0].data.value == "SMS")
					        	{
					        		formWin.down("#subject").allowBlank=true;
					        		formWin.down("#subject").hide();
					        		formWin.down("#staticUploadFileField").hide();
					        		formWin.down("#placementrecruitmentDocumentMessageAttachmentGrid").hide();
					        		formWin.down('#discriptionId').reset();
					        		formWin.down('#discriptionId').hide();	       		 
					        		subject.reset();
					        		smsDiscription.show();
					        		smsDiscriptionNotice.show();
					        		pushNotificationDiscription.hide();
					        		pushNotificationDiscriptionNotice.hide();
					        		pushNotificationDiscription.reset();
					        		formWin.getForm().checkValidity();
					        	}else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION_ONLY" || rec[0].data.value == "Push Notification Only"){
					        		formWin.down('#discriptionId').reset();
					        		formWin.down('#smsDiscription').reset();
					        		formWin.down('#smsDiscription').hide();
					        		formWin.down('#smsDiscriptionNotice').hide();
					        		formWin.down("#staticUploadFileField").hide();
					        		// formWin.down("#staticDocumentMessageAttachmentGrid").show();
					        		formWin.down("#placementrecruitmentDocumentMessageAttachmentGrid").hide();
					        		subject.show();
					        		subject.reset();
					        		this.setAllowBlank(subject,false);
					        		//formWin.down("#subject").allowBlank=false;
					        		formWin.down('#discriptionId').show();
					        		pushNotificationDiscription.hide();
					        		pushNotificationDiscriptionNotice.hide();
					        		pushNotificationDiscription.reset();
					        		formWin.getForm().checkValidity();
					        	}
					        	/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
					        		subject.show();
					        		formWin.down("#staticUploadFileField").hide();
					        		this.setAllowBlank(subject,false);
					        		formWin.down("#placementrecruitmentDocumentMessageAttachmentGrid").hide();
					        		formWin.down('#discriptionId').reset();
					        		formWin.down('#discriptionId').hide();
					        		subject.reset();
					        		smsDiscription.reset();
					        		smsDiscription.hide();
					        		smsDiscriptionNotice.hide();
					        		pushNotificationDiscription.reset();
					        		pushNotificationDiscription.show();
					        		pushNotificationDiscriptionNotice.show();
					        		pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
					        		formWin.getForm().checkValidity();
					        		//formWin.down('#smsDiscription')
					        	}*/
					        	else
					        	{
					        		formWin.down('#discriptionId').reset();
					        		formWin.down('#smsDiscription').reset();
					        		formWin.down('#smsDiscription').hide();
					        		formWin.down('#smsDiscriptionNotice').hide();
					        		formWin.down("#staticUploadFileField").show();
					        		// formWin.down("#staticDocumentMessageAttachmentGrid").show();
					        		formWin.down("#placementrecruitmentDocumentMessageAttachmentGrid").show()
					        		subject.show();
					        		subject.reset();
					        		this.setAllowBlank(subject,false);
					        		//formWin.down("#subject").allowBlank=false;
					        		formWin.down('#discriptionId').show();
					        		pushNotificationDiscription.hide();
					        		pushNotificationDiscriptionNotice.hide();
					        		pushNotificationDiscription.reset();
					        		formWin.getForm().checkValidity();
					        	}
					        },
					        /**
					         * upload static document file for Student
					         */
					        uploadPlacementRecruitmentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
					        	var this$ = this;
					        	var setupForm = fileField.up('placementrecruitmentsendmessages');
					        	var grid = setupForm.down('#placementrecruitmentStaticDocumentAttachmentGridMessage');
					        	fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
					        	fileField.setRawValue(fileUploadPath);
					        	var file = fileField.fileInputEl.dom.files[0];
					        	if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
					        		if(!isNullOrEmpty(fileUploadPath)){
					        			var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
					        			if (this$.isValidFileExtensionForMessaging(extension)) {
					        				var entityId = 'placementRecruitment';
					        				var module = 'messaging';
					        				var entityType = 'template';
					        				var documentType = 'DOCUMENT';
					        				var isTransient = true;
					        				var this$ = this;
					        				this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
					        					if(success){
					        						var path = Ext.JSON.decode(action.response.responseText).path;
					        						var user = this$.getCurrentlyLoggedInUser();
					        						var store = grid.getStore();
					        						var documentStatus = "SUBMITTED";
					        						var documentType = null;
					        						if(!isNullOrEmpty(path)){
					        							store.add({
					        								id: '',
					        								name: fileUploadPath,
					        								path: path ,
					        								createdBy : {
					        									id :user.id,
					        									value : user.value,
					        									code : user.code
					        								},
					        								status : documentStatus,
					        								documentType : documentType,
					        								templateConfigDocId: '',
					        								submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

					        							});
					        							this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
					        							showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
					        						}

					        						fileField.reset();
					        					}

					        				}, isTransient);
					        			}else{
					        				fileField.reset();
					        				showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					        			}
					        		}
					        	}else{
					        		fileField.reset();
					        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					        	}
					        },

					        /**
					         * Add value to grid
					         */
					        loadGridWithFileNameMessage:function(grid,value,store){
					        	grid.bindStore(store);
					        },
					        /**
					         * Remove entry from grid
					         */
					        deletePlacementRecruitmentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
					        	var grid = view.up('#placementrecruitmentStaticDocumentAttachmentGridMessage');
					        	var panel = this.getContentPanel().getActiveTab();
					        	var tabTitle = panel.title;
					        	var store = grid.getStore();
					        	var templateConfigDocId = record.get('templateConfigDocId');
					        	var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
					        	if(!(tabTitle == viewTitle)){
					        		if(!isNullOrEmpty(templateConfigDocId)){
					        			showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
					        				if (btn == 'yes') {
					        					Ext.Ajax.request({
					        						type: 'rest',
					        						url: SERVERURL.STATIC_DOC_DELETE,
					        						method: 'DELETE',
					        						params: {
					        							templateConfigDocId : templateConfigDocId
					        						},
					        						headers: {
					        							'Content-Type': 'application/json'
					        						},
					        						success: function(form, action) {
					        							store.remove(record);
					        							showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
					        						}
					        					});
					        				}
					        			});

					        		}else{
					        			store.remove(record);
					        			showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
					        		}
					        	}else{
					        		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
					        	}

					        },
					        /**
					         * save document file. It's external call method
					         * @param entityId : person id, It's mandatory. 
					         * @param module : module name, for student module 'student', It's mandatory.
					         * @param entityType : entity type, It's mandatory.
					         * @param documentType : document type, It's mandatory.
					         * @param isTransient : true or false (send json back to module controller or not)
					         * @param callBackFunction : callback function return in module controller. It's mandatory.
					         */
					        saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
					        	var submitUrl = '';
					        	var templateTab = this.getContentPanel();
					        	var formWin =  this.getPlacementrecruitmentsendmessages();
					        	var form = formWin.down('#msgDetailsForm');
					        	var id = form.down('#document_hidden_field');
					        	if (isNullOrEmpty(id.getSubmitValue())) {
					        		submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
					        	}
					        	var data = new Object();
					        	if(!isNullOrEmpty(entityId)){
					        		data.entityId = entityId;
					        	}else{
					        		data.entityId = null;
					        	}
					        	if(!isNullOrEmpty(module)){
					        		data.module = module;
					        	}else{
					        		data.module = null;
					        	}
					        	if(!isNullOrEmpty(entityType)){
					        		data.entityType = entityType;
					        	}else{
					        		data.entityType = null;
					        	}
					        	form.getForm().setValues(data);
					        	form.getForm().submit({
					        		method : 'POST',
					        		url : submitUrl,
					        		success : function(form, action){
					        			callBackFunction(true, action, isTransient);

					        		}
					        	});
					        }, 
					        /**
					         * This method is to enable schedule field
					         */
					        loadPlacementRecruitmentScheduleField : function(radio,newValue, oldValue){
					        	var adhocMessageForm = radio.up('form');
					        	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
					        	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
					        	var radioValue = radio.getValue().sendingPriority;

					        	if(radioValue=='IMMEDIATE'){
					        		scheduleDateField.setVisible(false);
					        		scheduleDateField.setDisabled(true);
					        		scheduleTimeField.setVisible(false);
					        		scheduleTimeField.setDisabled(true);    		
					        	}
					        	else if(radioValue=='SCHEDULE'){
					        		scheduleDateField.setVisible(true);
					        		scheduleDateField.setDisabled(false);
					        		scheduleTimeField.setVisible(true);
					        		scheduleTimeField.setDisabled(false);
					        	}
					        },
					        /*End added adhoc messaging*/ 
		});

