/**
 * @author Dharmendra.Prajapati
 */
Ext.define('Academia.controller.portal.ApplicantPortalController', {
	extend: 'Academia.controller.base.BaseController',
	views: ['admission.applications.applicantProfileBase.ApplicantProfile'],
	refs: [{
		ref: 'contentPanel',
		selector: 'contentpanel'
	}],
	init: function(application) {
		this.control({
			'applicantPortal': {
				afterrender: this.testAppliacantPortal 
			}
		});
	},
	/**
	 * @author Dharmendra.Prajapati
	 */

	testAppliacantPortal : function(tb){
		var $this=this;
		/*var programBatchSeatTypeConfigId=0;
		var userInfo = Academia.model.authentication.UserInfoModel;
		$this.applyConfigToPersonTab(tb);
		if(tb.contentXtype=='feeplangrid'){
			 programBatchSeatTypeConfigId  = $this.getProgramBatchSeatTypeConfig(userInfo);
		}
		tb.setPersonInfo(contentPanel.getPersonInfo());
		tb.setUserId(userInfo.get("userId"));
		tb.setPersonId(userInfo.get("personId"));
		tb.setAdmissionId(null);
		tb.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
		tb.insert(0,{
			xtype: tb.contentXtype,
			itemId: tb.contentXtypeItemId,
			personType:'FACULTY'
		});
		var that = this;
		setTimeout(function(){
			var contentPanel = that.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			contentPanel.items.findBy(function(tab) {
				if(tab!=undefined){
					if(tab.title == 'Portal'){
						contentPanel.remove(tab,true);
					}
				}
			});
		}, 20);

		tb.items.items[0].setTitle(false);
		tb.items.items[0].closable=false;
		
		if(tb.items.items[0].viewType=='gridview'){
			tb.items.items[0].setTitle(tb.title);
		}*/
		console.log('Got here');
	},
	loadApplicantProfile:function(){
		this$=this;
		var data;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var applicantId = userInfo.get("externalUserId");
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.FIND_ASSOCOATED_APPLICATION_ID+'?externalUserId='+applicantId,
			method: 'GET',
			async: false,
			success: function(res, action) {
				var id = Ext.decode(res.responseText);
				Ext.Ajax.request({
					type: 'rest',
					url: "rest/application/findApplicationWithPersonDetail?id="+id,
					method: 'GET',
					async: false,
					success: function(res, action) {
						 data = Ext.decode(res.responseText);
        				 if( !isNullOrEmpty(data.editApplicationAlertMessage) && data.editApplicationAlertMessage != "NA" ){
//        					Bug : V2D-90266
//            				showWarningMessage(getCommonTranslation('ALERT'),data.editApplicationAlertMessage);
            			 }
					}
				});
			}
		});
		return data;
	},
	
	loadPanellinkForApplicant: function(applicantProfile, applicantLinkPanelObject) {
		
			var this$ = this;
			var persondetailslinkpanel = applicantProfile.down('persondetailslinkpanel');
		
			var permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'PERSONAL_INFORMATION');
			var i=permissionMap.length-1;
			var p = applicantLinkPanelObject.PERSONAL_INFORMATION;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#PERSONAL_INFORMATION');
				this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				i--;
			}
			
			permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'APPLICATION_AND_ADMISSION');
			i=permissionMap.length-1;
			
			p = applicantLinkPanelObject.APPLICATION_AND_ADMISSION;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#APPLICATION_AND_ADMISSION');
				this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				i--;
			}
			
			permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'FINANCIAL');
			i=permissionMap.length-1;
			
			p = applicantLinkPanelObject.FINANCIAL;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#FINANCIAL');
				this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				i--;
			}
				
			permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'GENERAL');
			i=permissionMap.length-1;
			p = applicantLinkPanelObject.GENERAL;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#GENERAL');
				this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				i--;
			}
			
			permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'HISTORY');
			i=permissionMap.length-1;
			p = applicantLinkPanelObject.HISTORY;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#HISTORY');
				if(links != undefined){
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				}
				i--;
			}
			permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'APPOINTMENT_FOLLOWUP');
			i=permissionMap.length-1;
			p = applicantLinkPanelObject.APPOINTMENT_FOLLOWUP;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#APPOINTMENT_FOLLOWUP');
				this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				i--;
			}
			permissionMap = this$.buildLinkDetailsMapObj(applicantProfile, applicantLinkPanelObject, 'DOCUMENT_HISTORY');
			i=permissionMap.length-1;
			p = applicantLinkPanelObject.DOCUMENT_HISTORY;
			while(i>=0) {
				links = p[i];
				var detailsLink = persondetailslinkpanel.down('#DOCUMENT_HISTORY');
				if(links != undefined){
					this$.hideLinksByprivileges(detailsLink,permissionMap.get(links.tabPanelTitle), i, applicantLinkPanelObject);
				}
				i--;
			}
			
	},
	
	hideLinksByprivileges: function(detailsLink, privilegesMap, i, applicantLinkPanelObject) {
    	
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);
    	
		var APPLICATION_AND_ADMISSION = detailsLink;
    	
		var store = APPLICATION_AND_ADMISSION.items.items[0].getStore();
		var flag = true;
		Ext.each(permissionList, function(privilege) {
    		if (privilege == 'VIEW') {
    			 flag=false;
        	}
    	});
		
		if(flag){
			var rec = store.getAt(i);
			if (rec) {
				store.remove(rec);
			}
		}
		if(store.getCount() == 0){
			detailsLink.setVisible(false);
		}
		return flag;
    },
    
    buildLinkDetailsMapObj: function(applicantProfile, applicantLinkPanelObject, linkPanelId) {
    	var persondetailslinkpanel = applicantProfile.down('persondetailslinkpanel');
		
    	var applicationPersonalController  = this.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
    	var applicationDetailsAndRefController  = this.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
    	var admissionMidTermDetailsController  = this.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');
    	var applicantPastHistoryController  = this.getController('Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController');
    	var applicantPaymentController = this.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
    	var applicantDocumentController = this.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
    	var applicantServiceController = this.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
    	var sgApplicantAppointmentController = this.getController('Academia.controller.sgappointment.sgappointment.SGApplicantAppointmentController');
    	var applicantfollowUpController = this.getController('Academia.controller.admission.applications.applicationFollowUp.ApplicationFollowUpDetailController');
    	var applicantProfileBaseController = this.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
    	var permissionMap = new Ext.util.HashMap();
		
    	var arrayVar = new Array();
    	if(linkPanelId=='PERSONAL_INFORMATION') {
	    	permissionMap.add('STUDENT_PERSONAL_DETAILS',applicationPersonalController.getAPPLICANT_PERSONAL_INFORMATION_PERMISSIONS());
	    	permissionMap.add('ADDRESSES',applicationPersonalController.getAPPLICANT_ADDRESS_PERMISSIONS());
	    	permissionMap.add('PARENTS_GUARDIANS',applicationPersonalController.getAPPLICANT_PARENTS_GUARDIANS_PERMISSIONS());
	    	permissionMap.add('FEE_PAYERS',applicationPersonalController.getAPPLICANT_FEE_PAYER_DETAILS_PERMISSIONS());
	    	permissionMap.add('SIBLING',applicationPersonalController.getAPPLICANT_SIBLINGS_PERMISSIONS());
	    	permissionMap.add('IDENTITY_DETAILS',applicationPersonalController.getAPPLICANT_IDENTITY_DETAILS_PERMISSIONS());
	    	permissionMap.add('OTHER_INFORMATION',applicationPersonalController.getAPPLICANT_OTHER_INFORMATION_DETAILS_PERMISSIONS());
	    	permissionMap.add('PASSPORT',applicationPersonalController.getAPPLICANT_PASSPORT_PERMISSIONS());
	    	permissionMap.add('PERMIT',applicationPersonalController.getAPPLICANT_PERMIT_DETAIL_PERMISSION());
	    	permissionMap.add('VISA',applicationPersonalController.getAPPLICANT_VISA_PERMISSIONS());
	    	permissionMap.add('INSURANCE',applicationPersonalController.getAPPLICANT_INSURANCE_DETAILS_PERMISSIONS());
	    	permissionMap.add('NATIONAL_SERVICE',applicationPersonalController.getAPPLICANT_NATIONAL_SERVICES_PERMISSIONS());

	    	
    	} else if(linkPanelId=='APPLICATION_AND_ADMISSION') {
    		permissionMap.add('APPLICATION_DETAILS',applicationDetailsAndRefController.getAPPLICANT_DETAILS_PERMISSIONS());
    		permissionMap.add('REFERENCES',applicationDetailsAndRefController.getAPPLICANT_REFERENCES_PERMISSIONS());
    		permissionMap.add('ADMISSION_DETAILS',admissionMidTermDetailsController.getAPPLICATIONS_ADMISSION_DETAILS_PERMISSIONS());
    		//permissionMap.add('MID_TERM_ADMISSION',admissionMidTermDetailsController.getAPPLICATIONS_MIDTERM_ADMISSION_DETAILS_PERMISSIONS());
    		permissionMap.add('CHANGE_APPLICATION_PROGRAM',applicationDetailsAndRefController.getAPPLICANT_CHANGE_APPLICATION_PROGRAM_PERMISSIONS());
    		permissionMap.add('CONDITIONS_FOR_ADMISSION',applicationDetailsAndRefController.getAPPLICANT_CONDITIONS_FOR_ADMISSION_PERMISSIONS());
    		permissionMap.add('PROGRAM_WISE_CONDITIONS_FOR_ADMISSION',applicantProfileBaseController.getAPPLICANT_APPLICATION_PW_CONDITIONS_REVIEW_DETAILS_PERMISSIONS());
    		permissionMap.add('REVIEW_DETAILS',applicantProfileBaseController.getAPPLICANT_APPLICATION_REVIEW_DETAILS_PERMISSIONS());
    		permissionMap.add('CONDITIONS_REVIEW_DETAILS',applicantProfileBaseController.getAPPLICANT_APPLICATION_CONDITIONS_REVIEW_DETAILS_PERMISSIONS());
    		permissionMap.add('ELIGIBILITY_DETAILS',applicantProfileBaseController.getAPPLICATIONS_ELIGIBILITY_DETAILS_PERMISSIONS());
    		permissionMap.add('APPLICATIONS_CHECK_LIST_DETAILS',applicantProfileBaseController.getAPPLICATIONS_CHECK_LIST_DETAILS_PERMISSIONS());
    		permissionMap.add('APPLICATION_AND_ADMISSION_COMMENTS',applicantProfileBaseController.getAPPLICATION_AND_ADMISSION_COMMENTS_PERMISSIONS());
    		permissionMap.add('SALESFORCE_ADMISSION_DETAILS',applicantProfileBaseController.getSALESFORCE_ADMISSION_DETAILS_PERMISSIONS());
    		permissionMap.add('DOCUMENTS_AND_NOTES',applicantProfileBaseController.getAPPLICANT_DOCUMENTS_AND_NOTES_PERMISSIONS());
    		permissionMap.add('APPLICANT_TRANSFER_CREDITS',applicantProfileBaseController.getAPPLICANT_TRANSFER_CREDITS_PRIVILEGES());
    	} else if(linkPanelId=='FINANCIAL') {
    		permissionMap.add('PRE_ADMISSION_PAYMENTS',applicantPaymentController.getAPPLICANT_PAYMENT_PERMISSIONS());
    		permissionMap.add('PRE_ADMISSION_REFUNDS',applicantPaymentController.getAPPLICANT_REFUNDS_PERMISSIONS());
    		permissionMap.add('PRE_ADMISSION_FEE_PLANS',applicantPaymentController.getAPPLICANT_FEEPLAN_PERMISSIONS());
    		permissionMap.add('ONLINE_PAYMENT',applicantPastHistoryController.getAPPLICANT_ONLINE_PAYMENT_PERMISSIONS());
    		permissionMap.add('RECEIPTS',applicantPaymentController.getAPPLICATION_RECEIPT_PERMISSIONS());
    		permissionMap.add('NSFAS_BURSARY_DETAIL',applicantPaymentController.getAPPLICATIONS_NSFAS_PERMISSIONS());
    		
    	} else if(linkPanelId=='GENERAL') {
//    		permissionMap.add('DOCUMENTS',applicantDocumentController.getAPPLICANT_DOCUMENTS_PERMISSIONS());
    		permissionMap.add('SERVICE_OPT_IN',applicantServiceController.getAPPLICATION_SERVICEOPTIN_PERMISSIONS());
    		permissionMap.add('COMMUNITIES_OPT_IN',applicantServiceController.getAPPLICATION_COMMUNITIESOPTIN_PERMISSIONS());
    		//permissionMap.add('CHEKLIST_ITEMS',applicantServiceController.getAPPLICATION_CHECKlISTITEMS_PERMISSIONS());
    		permissionMap.add('HOSTEL_PERSONAL_REQUIREMENTS',applicationPersonalController.getAPPLICANT_HOSTEL_PERSONAL_REQUIREMENTS_PERMISSIONS());
    		
    	} else if(linkPanelId=='HISTORY') {
    		permissionMap.add('EDUCATION',applicantPastHistoryController.getAPPLICANT_EDUCATION_PERMISSIONS());
    		permissionMap.add('WORK_EXPERIENCE',applicantPastHistoryController.getAPPLICANT_WORK_EXPERIENCE_PERMISSIONS());
    		permissionMap.add('MEDICAL_HISTORY',applicantPastHistoryController.getAPPLICANT_MEDICAL_PERMISSIONS());
    		permissionMap.add('VACCINATION',applicantPastHistoryController.getAPPLICANT_VACCINATION_PERMISSIONS());
    		permissionMap.add('EXTRA_CURRICULUM',applicantPastHistoryController.getAPPLICANT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS());
    		permissionMap.add('COMPETITIVE_EXAM',applicantPastHistoryController.getAPPLICANT_COMPETITIVE_EXAM_PERMISSIONS());
    		permissionMap.add('MD_MEDICAL_DETAILS',applicantPastHistoryController.getAPPLICANT_MEDICAL_DETAIL_PERMISSIONS());
    		permissionMap.add('CHURCH_INFORMATION_DETAILS',applicantPastHistoryController.getAPPLICANT_CHURCH_INFORMATION_PERMISSIONS());
    		permissionMap.add('APPLICANT_DETAILS_FORM',applicantPastHistoryController.getAPPLICANT_DETAIL_FORM_PERMISSIONS());
    		permissionMap.add('COMMUNICATION_HISTORY',applicantPastHistoryController.getAPPLICANT_COMMUNICATION_HISTORY_PERMISSIONS());
    		permissionMap.add('NON_ACADEMIC_ACHIEVEMENTS',applicantPastHistoryController.getAPPLICANT_NON_ACADEMIC_ACHIEVEMENTS_PERMISSIONS());
    		permissionMap.add('SOCIO_ECONOMIC_INFORMATION',applicantPastHistoryController.getAPPLICANT_SOCIO_ECONOMIC_INFORMATION_PERMISSIONS());
    		permissionMap.add('POST_SCHOOL_STUDIES',applicantPastHistoryController.getAPPLICANT_POST_SCHOOL_STUDIES_PERMISSIONS());
    		permissionMap.add('EDUCATION_DETAILS',applicantPastHistoryController.getAPPLICANT_EDUCATION_HISTORY_PERMISSIONS());
    		permissionMap.add('LANGUAGE_INFORMATION',applicantPastHistoryController.getAPPLICANT_LANGUAGE_INFORMATION_PERMISSIONS());
    		permissionMap.add('HEALTH_INFORMATION',applicantPastHistoryController.getAPPLICANT_HEALTH_INFORMATION_PERMISSIONS());
    		
    	}  else if(linkPanelId=='APPOINTMENT_FOLLOWUP') {
    		var portalId = this.getCurrentLoggedPortalId();
    		if (portalId == 1) {
    			permissionMap.add('MANAGE_APPOINTMENT', sgApplicantAppointmentController.getAPPLICANT_MANAGE_APPOINTMENT_PERMISSIONS());
    			permissionMap.add('MANAGE_FOLLOW_UP', applicantfollowUpController.getFOLLOWUP_DETAIL_APPLICANT_PROFILE_PERMISSIONS());
    		}else if (portalId == 6)  {
    			permissionMap.add('MANAGE_APPOINTMENT',sgApplicantAppointmentController.getAPPLICANT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS());
    		}
    	}else if(linkPanelId=='DOCUMENT_HISTORY') {
    		permissionMap.add('DOCUMENTS',applicantDocumentController.getAPPLICANT_DOCUMENTS_PERMISSIONS());
    		permissionMap.add('AD_HOC_DOCUMENTS',applicantDocumentController.getAD_HOC_APPLICANT_DOCUMENTS_PERMISSIONS());
    		/*var portalId = this.getCurrentLoggedPortalId();
    		if (portalId == 1) {
    			permissionMap.add('DOC_ONLINE_DOCUMENTS', applicantProfileBaseController.getAPPLICANT_ONLINE_DOCUMENTS_PERMISSIONS());
    			permissionMap.add('DOC_PHYSICAL_DOCUMENTS', applicantProfileBaseController.getAPPLICANT_PHYSICAL_DOCUMENTS_PERMISSIONS());
    		}else if (portalId == 6)  {
    			permissionMap.add('MANAGE_APPOINTMENT',applicantProfileBaseController.getAPPLICANT_PORTAL_MANAGE_APPOINTMENT_PERMISSIONS());
    		}*/
    	}
    	
    	return permissionMap;
    }
});
