Ext.define('Academia.controller.program.CatalogueContentController', {
	 extend: 'Academia.controller.base.BaseController',
	 stores: [
		 'program.programDetails.programBatches.CatalogueContentGridStore',
		 'common.CatalogueContent','common.MultiLanguageStore',
		 'program.programDetails.programBatches.ProgramDocumentStore',
		 'program.ProgramDocumentFileTypeStore',
		 'program.ProgramCatalogueDocumentStore'
	 ],
	 models: [
		 'common.IdValueCodeDataModel'
	 ],
	 views: [
		 'baselayout.contentarea.ContentPanel',
		 'program.programDetails.CatalogueContentTabStructure',
		 'program.programDetails.programBatches.CatalogueContentGrid',
		 'program.CatalogueContentAddEditWindow',
		 'program.programDetails.programBatches.ProgramDocumentGrid',
	 ],
	 
	 config: {
		 CATALOGUE_CONTENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CATALOGUE_CONTENT_PRIVILEGES'),
	 },
	 
	 refs: [{
		 ref: 'contentPanel',
		 selector: 'contentPanel'
	 },{
		 ref: 'cataloguecontenttabstructure',
		 selector: 'cataloguecontenttabstructure'
	 },{
    	 ref: 'cataloguecontentgrid',
    	 selector: 'cataloguecontentgrid'
     },{
    	 ref: 'cataloguecontentaddeditwindow',
    	 selector: 'cataloguecontentaddeditwindow'
     }, {
    	 ref : 'programdocumentgrid',
    	 selector : 'programdocumentgrid'
     }],
	 
	 init: function(application) {
		 this.control({
			 'cataloguecontentgrid':{
				 afterrender : function(grid){
					 var me = this;
					 var gridStore = grid.getStore();
					 var structure = grid.up('cataloguecontenttabstructure')
					 var permissionsMap = new Ext.util.HashMap();
             	     permissionsMap =this.getCATALOGUE_CONTENT_PRIVILEGES();
             	     var associatedAcadLocationIds = new Array();
                  	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
              		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                  	var addBtn = grid.down('#btnAdd');
                  	var editBtn = grid.down('#btnEdit');
                  	var viewBtn = grid.down('#btnView');
                  	var deleteBtn = grid.down('#btnDelete');
                  	var exportToExcelBtn = grid.down('#btnExportToExcel');
                  	var exportToPDFBtn = grid.down('#btnExportToPDF');
                  	
                  	addBtn.setVisible(false);
                  	editBtn.setVisible(false);
                  	viewBtn.setVisible(false);
                  	deleteBtn.setVisible(false);
                  	exportToExcelBtn.setVisible(false);
                  	exportToPDFBtn.setVisible(false);
                  	
                  	Ext.each(permissionList, function(privilege) {
                  		if (privilege === 'CREATE') {
                  			if(!isNullOrEmpty(addBtn)){
                  				addBtn.setVisible(true);
                  			}
                      	}else if(privilege === 'UPDATE') {
                      		if(!isNullOrEmpty(editBtn)){
                      			editBtn.setVisible(true);
                      		}	
                      	}else if(privilege === 'VIEW') {
                      		if(!isNullOrEmpty(viewBtn)){
                      			viewBtn.setVisible(true);
                      		}
                      	}else if(privilege === 'DELETE') {
                      		if(!isNullOrEmpty(deleteBtn)){
                      			deleteBtn.setVisible(true);
                      		}	
                      	}else if(privilege === 'EXPORT') {
                      		if(!isNullOrEmpty(exportToExcelBtn) && !isNullOrEmpty(exportToPDFBtn)){
                      			exportToExcelBtn.setVisible(true);
                      		
                  				exportToPDFBtn.setVisible(true);
                  			}
                      	} 
                  	});
                  
                  	gridStore.getProxy().extraParams = {
                		 programId:structure.programId
					 };
					 
					 gridStore.load();
				 }
			 },
			 
			 'cataloguecontentgrid button[itemId=btnAdd]':{
				 click: function(btn){
					 var me = this;
					 var catalogueWindow = me.getCataloguecontentaddeditwindow();
					 var catalogueContentTabStructure = btn.up('cataloguecontenttabstructure');
					 
					 var programId = catalogueContentTabStructure.programId;
					 var programCode = catalogueContentTabStructure.programCode;
					 var programName = catalogueContentTabStructure.programName;

					 if (!catalogueWindow) {
						 Ext.widget('cataloguecontentaddeditwindow',{
							 programCodeOrName: programCode+"/"+programName,
							 catalogueContentId: '',
							 programId:programId
						 });
						 catalogueWindow = me.getCataloguecontentaddeditwindow();
					 }
					 var url = SERVERURL.SAQA_ID_FIND_BY_PROGRAM_ID;
					 Ext.Ajax.request({
						   type : 'rest',
						   url : url,
						   params : {
							   id : programId
						   },
						   method : 'GET',
						   success : function(response) {
							   var data = response.responseText;
							   catalogueWindow.saqaId = data;
							   catalogueWindow.show();
						   }
					 });
					 
				 }
			 },
			 'cataloguecontentgrid button[itemId=btnEdit]':{
				 click: function(btn){
					 var me = this;
					 var grid = btn.up('grid');
					 
					 var record = grid.getSelectionModel().getSelection();
					 
					 if(record.length == 1){
						 var catalogueWindow = me.getCataloguecontentaddeditwindow();
						 if (!catalogueWindow) {
							 Ext.widget('cataloguecontentaddeditwindow',{
								 catalogueContentId: record[0].data.id,
								 record:record[0],
								 programId:record[0].data.programId
							 });
							 catalogueWindow = me.getCataloguecontentaddeditwindow();
						 }
						 var url = SERVERURL.SAQA_ID_FIND_BY_PROGRAM_ID;
						 Ext.Ajax.request({
							   type : 'rest',
							   url : url,
							   params : {
								   id : record[0].data.programId
							   },
							   method : 'GET',
							   success : function(response) {
								   var data = response.responseText;
								   catalogueWindow.saqaId = data;
								   catalogueWindow.show();
							   }
						 });
					 }
					 else{
						 showWarningMessage(getCommonTranslation('CATALOGUE_CONTENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 }
			 },
			 'cataloguecontentgrid button[itemId=btnView]':{
				 click: function(btn){
					 var me = this;
					 var grid = btn.up('grid');
					 
					 var record = grid.getSelectionModel().getSelection();
					 
					 if(record.length == 1){
						 var catalogueWindow = me.getCataloguecontentaddeditwindow();
						 if (!catalogueWindow) {
							 Ext.widget('cataloguecontentaddeditwindow',{
								 catalogueContentId: record[0].data.id,
								 record:record[0],
								 programId:record[0].data.programId,
								 viewOnly: true
							 });
							 catalogueWindow = me.getCataloguecontentaddeditwindow();
						 }
						 var url = SERVERURL.SAQA_ID_FIND_BY_PROGRAM_ID;
						 Ext.Ajax.request({
							   type : 'rest',
							   url : url,
							   params : {
								   id : record[0].data.programId
							   },
							   method : 'GET',
							   success : function(response) {
								   var data = response.responseText;
								   catalogueWindow.saqaId = data;
								   catalogueWindow.show();
							   }
						 });
					 }
					 else{
						 showWarningMessage(getCommonTranslation('CATALOGUE_CONTENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 }
			 },
			 'cataloguecontentgrid button[itemId=btnDelete]':{
				 click: function(btn){
					 var me = this;
					 var grid = btn.up('grid');
					 
					 var record = grid.getSelectionModel().getSelection();
					 
					 if(record.length == 1){

						 showConfirmMessage(getCommonTranslation('CATALOGUE_CONTENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								 function(btn, text) {
									 if (btn == 'yes'){
										 Ext.Ajax.request({
											 method: "DELETE",
											 type: 'rest',
											 url: SERVERURL.PROGRAM_CATALOGUE_DELETE+'?id='+record[0].data.id,
											 headers: {
												 'Content-Type': 'application/json'
											 },
											 params: {
												 id: record[0].data.id
											 },
											 success: function(form, action) {
												 if(form.responseText == "DEPENDENT_RECORD_EXISTS"){
													 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DEPENDENCY_EXISTS'));
												 }else{
													 showSuccessMessage(getCommonTranslation('CATALOGUE_CONTENT'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
													 grid.store.reload();
												 }
											 }
										 });
									 }
						 });
					 }
					 else{
						 showWarningMessage(getCommonTranslation('CATALOGUE_CONTENT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				}
			 },
			
			 'cataloguecontentaddeditwindow':{
				 afterrender: function(win){
					 var me = this;
					 var winForm = win.down('form');
					 var saqaId = win.saqaId;
					 
					 if(!isNullOrEmpty(win.programCodeOrName)){
						 win.down('#programCodeOrNameField').setValue(win.programCodeOrName);
						 win.down('#saqaId').setValue(saqaId);
						 win.down('#saqaId').setReadOnly(true);
						 win.down('#contentFieldCK').setVisible(true);
						 win.down('#contentFieldTA').setVisible(false);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 
						 win.down('programdocumentgrid').getStore().removeAll();
						 winForm.isValid();
						 winForm.getForm().clearInvalid();
					 }
					 else if(!isNullOrEmpty(win.catalogueContentId) && isNullOrEmpty(win.viewOnly)){
						 win.down('#programCodeOrNameField').setValue(win.record.data.programCodeOrName);
						 win.down('#contentTypeField').store.load({
							 callback: function(){
								 win.down('#contentTypeField').setValue(win.record.data.catalogueContentId)
							 }
						 });
						 win.down('radiogroup').setValue({'fieldTypeField': win.record.data.whetherHtml == true ? 'html' : 'text'});
						 
						 if(win.record.data.whetherHtml == true){
							 win.down('#contentFieldCK').setValue(win.record.data.content);
						 }
						 else{
							 win.down('#contentFieldTA').setValue(win.record.data.content);
						 }
						  win.down('#durationItemId').setValue(win.record.data.duration);
						 win.down('#presentationLanguageItemId').store.load({
							 callback: function(){
								 win.down('#presentationLanguageItemId').setValue(win.record.data.presentationLanguageId);
							}
						  });
						 win.down('#videoURLItemId').setValue(win.record.data.videoURL);
						 win.down('#publishInCatalogueItemId').setValue(win.record.data.publishInCatalogue);
						 win.down('#saqaId').setValue(saqaId);
						 win.down('#saqaId').setReadOnly(true);
						 
						 var store = me.getStore('program.ProgramCatalogueDocumentStore');
            			 store.getProxy().extraParams = {
            				 programCatalogueId :win.catalogueContentId
            			 };
            			 me.resetPageSetting(store);
            			 store.load();
						 
						 winForm.isValid();
						 winForm.getForm().clearInvalid();
					 }
					 else if(!isNullOrEmpty(win.catalogueContentId) && !isNullOrEmpty(win.viewOnly)){
						 win.down('#programCodeOrNameField').setValue(win.record.data.programCodeOrName);
						 win.down('#contentTypeField').store.load({
							 callback: function(){
								 win.down('#presentationLanguageItemId').setValue(win.record.data.presentationLanguageId);
								 win.down('#presentationLanguageItemId').setReadOnly(true);
							 }
						 });
						 win.down('radiogroup').setValue({'fieldTypeField': win.record.data.whetherHtml == true ? 'html' : 'text'});
						 win.down('radiogroup').setReadOnly(true);
						 
						 if(win.record.data.whetherHtml == true){
							 win.down('#contentFieldCK').setValue(win.record.data.content);
							 win.down('#contentFieldCK').maskOnDisable = true;
							 win.down('#contentFieldCK').setDisabled(true);
						 }
						 else{
							 win.down('#contentFieldTA').setValue(win.record.data.content);
							 win.down('#contentFieldTA').setReadOnly(true);
						 }
						 win.down('#durationItemId').setValue(win.record.data.duration);
						 win.down('#durationItemId').setReadOnly(true);
						 win.down('#presentationLanguageItemId').store.load({
							 callback: function(){
								 win.down('#contentTypeField').setValue(win.record.data.catalogueContentId);
								 win.down('#contentTypeField').setReadOnly(true);
							 }
						 });
						 win.down('#videoURLItemId').setValue(win.record.data.videoURL);
						 win.down('#videoURLItemId').setReadOnly(true);
						 win.down('#publishInCatalogueItemId').setValue(win.record.data.publishInCatalogue);
						 win.down('#publishInCatalogueItemId').setReadOnly(true);
						 win.down('#saqaId').setValue(saqaId);
						 win.down('#saqaId').setReadOnly(true);
						 win.down('#fieldOfStudyItemId').setReadOnly(true);
						 
						 var store = me.getStore('program.ProgramCatalogueDocumentStore');
            			 store.getProxy().extraParams = {
            				 programCatalogueId : win.catalogueContentId
            			 };
            			 win.down('#editProgramDocumentFileType').setDisabled(true);
            			 win.down('#uploadProgramItemId').setDisabled(true);
            			 me.resetPageSetting(store);
            			 store.load();
            			 
            			 var docGrid = win.down('programdocumentgrid');
            			 docGrid.down('#btnDelete').setDisabled(true);
            			 winForm.isValid();
						 winForm.getForm().clearInvalid();
						 
						 win.down('#btnSubmit').setVisible(false);
					 }
				 }
			 },
			 'cataloguecontentaddeditwindow radiogroup[itemId=fieldTypeField]':{
				 change: function(radiogroup){
					 var me = this;
					 var win = radiogroup.up('cataloguecontentaddeditwindow');
					 var winForm = radiogroup.up('form');
					 var contentTypeField = win.down('#contentTypeField');
					 var contentCKField = win.down('#contentFieldCK');
					 var contentTextareaField = win.down('#contentFieldTA');
					 
					 var radioGroupVal = radiogroup.getValue();
					 
					 var contentTypeFieldValue = contentTypeField.getValue();
					 if(radioGroupVal.fieldTypeField == "html"){
						 contentCKField.setVisible(true);
						 contentTextareaField.setVisible(false);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 
						 var contentFieldValue = contentCKField.getValue();
					 }
					 else{
						 contentCKField.setVisible(false);
						 contentTextareaField.setVisible(true);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 
						 var contentFieldValue = contentTextareaField.getValue();
					 }
					 winForm.isValid();
					 winForm.getForm().clearInvalid();
					 
					 setTimeout(function(){
						 if(isNullOrEmpty(contentTypeFieldValue) || isNullOrEmpty(contentFieldValue)){
							 win.down('#btnSubmit').setDisabled(true);
						 }
						 else{
							 win.down('#btnSubmit').setDisabled(false);
						 }
					 },300);
				 }
			 },
			 'cataloguecontentaddeditwindow customcombobox[itemId=contentTypeField]':{
				 change:function(field){
					 var me = this;
					 var win = field.up('cataloguecontentaddeditwindow');
					 var winForm = field.up('form');
					 var contentTypeField = win.down('#contentTypeField');
					 var contentCKField = win.down('#contentFieldCK');
					 var contentTextareaField = win.down('#contentFieldTA');
					 var radiogroup = winForm.down('#fieldTypeField');
					 
					 var radioGroupVal = radiogroup.getValue();
					 
					 var contentTypeFieldValue = contentTypeField.getValue();
					 if(radioGroupVal.fieldTypeField == "html"){
						 contentCKField.setVisible(true);
						 contentTextareaField.setVisible(false);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 
						 var contentFieldValue = contentCKField.getValue();
					 }
					 else{
						 contentCKField.setVisible(false);
						 contentTextareaField.setVisible(true);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 
						 var contentFieldValue = contentTextareaField.getValue();
					 }
					 winForm.isValid();
					 winForm.getForm().clearInvalid();
					 
					 setTimeout(function(){
						 if(isNullOrEmpty(contentTypeFieldValue) || isNullOrEmpty(contentFieldValue)){
							 win.down('#btnSubmit').setDisabled(true);
						 }
						 else{
							 win.down('#btnSubmit').setDisabled(false);
						 }
					 },300);
				 }
			 },
			 'cataloguecontentaddeditwindow textarea[itemId=contentFieldTA]':{
				 change:function(field){
					 var me = this;
					 var win = field.up('cataloguecontentaddeditwindow');
					 var winForm = field.up('form');
					 var contentTypeField = win.down('#contentTypeField');
					 var contentCKField = win.down('#contentFieldCK');
					 var contentTextareaField = win.down('#contentFieldTA');
					 var radiogroup = winForm.down('#fieldTypeField');
					 
					 var radioGroupVal = radiogroup.getValue();
					 
					 var contentTypeFieldValue = contentTypeField.getValue();
					 if(radioGroupVal.fieldTypeField == "html"){
						 contentCKField.setVisible(true);
						 contentTextareaField.setVisible(false);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 
						 var contentFieldValue = contentCKField.getValue();
					 }
					 else{
						 contentCKField.setVisible(false);
						 contentTextareaField.setVisible(true);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 
						 var contentFieldValue = contentTextareaField.getValue();
					 }
					 winForm.isValid();
					 winForm.getForm().clearInvalid();
					 
					 setTimeout(function(){
						 if(isNullOrEmpty(contentTypeFieldValue) || isNullOrEmpty(contentFieldValue)){
							 win.down('#btnSubmit').setDisabled(true);
						 }
						 else{
							 win.down('#btnSubmit').setDisabled(false);
						 }
					 },300);
				 }
			 },
			 'cataloguecontentaddeditwindow ckeditor[itemId=contentFieldCK]':{
				 change:function(field){
					 var me = this;
					 var win = field.up('cataloguecontentaddeditwindow');
					 var winForm = field.up('form');
					 var contentTypeField = win.down('#contentTypeField');
					 var contentCKField = win.down('#contentFieldCK');
					 var contentTextareaField = win.down('#contentFieldTA');
					 var radiogroup = winForm.down('#fieldTypeField');
					 
					 var radioGroupVal = radiogroup.getValue();
					 
					 var contentTypeFieldValue = contentTypeField.getValue();
					 if(radioGroupVal.fieldTypeField == "html"){
						 contentCKField.setVisible(true);
						 contentTextareaField.setVisible(false);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 
						 var contentFieldValue = contentCKField.getValue();
					 }
					 else{
						 contentCKField.setVisible(false);
						 contentTextareaField.setVisible(true);
						 
						 me.setAllowBlank(win.down('#contentFieldCK'),true);
						 me.setAllowBlank(win.down('#contentFieldCK'),false);
						 
						 var contentFieldValue = contentTextareaField.getValue();
					 }
					 winForm.isValid();
					 winForm.getForm().clearInvalid();
					 
					 setTimeout(function(){
						 if(isNullOrEmpty(contentTypeFieldValue) || isNullOrEmpty(contentFieldValue)){
							 win.down('#btnSubmit').setDisabled(true);
						 }
						 else{
							 win.down('#btnSubmit').setDisabled(false);
						 }
					 },300);
				 }
			 },
			 
			 'cataloguecontentaddeditwindow combo#editProgramDocumentFileType': {
				 select: function(obj, record) {
					 var fileTypeId = record[0].get("id");
					 if(!isNullOrEmpty(fileTypeId)) {
						 obj.nextSibling().setDisabled(false)
					 }
				 }
			 },
			 
			 'cataloguecontentaddeditwindow button#uploadProgramItemId' : {
			   click : function() {
				   this.getDocumentController().showDocumentFormWindow('cataloguecontentaddeditwindow','DOCUMENT');
			   }
		   },
		   
		   'programdocumentgrid' : {
			   cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
				   var $this = this;
				   var documentGrid = $this.getProgramdocumentgrid();
				   var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

				   if (columnName == "documentName") {
					   if (e.target.tagName == 'A') {
						   var documentId = record.data.ecrptydocumentId;
						   if (!isNullOrEmpty(documentId)) {
							   $this.getDocumentController().downloadDocumentFile(documentId);
						   }
					   }
				   }
			   }
		   },
		   'documentformwindow[itemId=cataloguecontentaddeditwindow] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : 
		   {
			   click : function(obj) {
				   var $this = this;
				   var winForm = obj.up('form');
				  
				   var cataloguewindow = $this.getCataloguecontentaddeditwindow();
				   var fileType = cataloguewindow.down('#editProgramDocumentFileType').getValue();
				
				   var form = winForm.getForm();
				   var values = form.getValues();
				  
				   var isTransient = true;
				   var module = 'programs';
				   var entityId;
				   var entityType = 'programs';

				   $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT',
						   function(success, response, isCallBackTransient) {
							   var documentModel = new Academia.model.program.programDetails.programBatches.ProgramDocumentModel();
							   documentModel.set("documentName",response.name);
							   documentModel.set("path",response.path);
							   documentModel.set("type",response.type);
							   documentModel.set("documentName",response.name);
							   documentModel.set("fileType",fileType);
							   documentModel.set("createdBy",$this.getIdValueJson(
											   response.createdBy.id,
											   response.createdBy.value));
							   var programDocGrid = $this.getProgramdocumentgrid();
							  
							   var store = programDocGrid.getStore();
							   store.add(documentModel);
							   if (programDocGrid.isHidden() && store.data.items.length > 0) {
								   programDocGrid.setVisible(true);
							   }
							   $this.getDocumentController().closeDocumentFormWindow();
						   }, isTransient);
			   }
		   },
		   'documentformwindow[itemId=cataloguecontentaddeditwindow] simpledocumentform[itemId=simpleDocumentForm] filefield[itemId=uploadFileField]': {
			   change: function(fileField, value, eOpts) {
				   if (!isNullOrEmpty(value)) {
					   var $this = this;
					   var cataloguewindow = $this.getCataloguecontentaddeditwindow();
					   var fileType = cataloguewindow.down('#editProgramDocumentFileType').getValue();
					   
					   var winForm = fileField.up('form');
					   var form = winForm.getForm();
    				   var values = form.getValues();
    				  
					   value = value.replace('C:\\fakepath\\', '');
					   var newValue = value.replace(/ +/g, " ").split(' ').join('_');
					   fileField.setRawValue(newValue);
					   var form = fileField.up().up();
					   var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
					   if(fileType == 'IMAGE') {
						   if ($this.isValidProgramImageExtension(extension)) {
							   var file = fileField.fileInputEl.dom.files[0];
							   if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
								   fileField.reset();
								   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
								   return;
							   }
						   } else {
							   fileField.reset();
							   form.down('#documentFormSubmitButtonId').setDisabled(true);
							   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
							   return;
						   }
					   } else if(fileType == 'BURSARYINFORMATION' || fileType == 'ADMISSIONREQUIREMENT' || fileType == 'SELECTIONCRITERIA' || fileType == 'PROGRAMSTRUCTURE'
						   || fileType == 'FEESSTRUCTURE') {
						   if ($this.isValidProgramFileExtension(extension)) {
							   var file = fileField.fileInputEl.dom.files[0];
							   if (file.size / 1048576 > CONSTANTS.UPLOAD_PROGRAM_FILE_SIZE_LIMIT) {
								   fileField.reset();
								   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('PROGRAM_FILE_SIZE_ERROR_MSG'));
								   return;
							   }
						   } else {
							   fileField.reset();
							   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
							   return;
						   }
					   }else if(fileType == 'BROCHURE') {
						   if ($this.isValidBrochureFileExtension(extension)) {
							   var file = fileField.fileInputEl.dom.files[0];
							   if (file.size / 1048576 > CONSTANTS.UPLOAD_PROGRAM_FILE_SIZE_LIMIT) {
								   fileField.reset();
								   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('PROGRAM_FILE_SIZE_ERROR_MSG'));
								   return;
							   }
						   } else {
							   fileField.reset();
							   showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
							   return;
						   }
					   }
				   }
			   }
		   },
		   
			 'cataloguecontentaddeditwindow button[itemId=btnSubmit]':{
				 click: function(btn){
					 var me = this;
					 var this$ = this;
					 var win = btn.up('cataloguecontentaddeditwindow');
					 var winForm = btn.up('form');
					 
					 var contentTypeField = win.down('#contentTypeField');
					 var contentCKField = win.down('#contentFieldCK');
					 var contentTextareaField = win.down('#contentFieldTA');
					 var radiogroup = winForm.down('#fieldTypeField');

					 var catalogueContentId = win.catalogueContentId;
					 var programId = win.programId;
					 var contentTypeFieldValue = contentTypeField.getValue();
					 var radioGroupVal = radiogroup.getValue();
					 
					 if(radioGroupVal.fieldTypeField == "html"){
						 var contentFieldValue = contentCKField.getValue();
					 }
					 else{
						 var contentFieldValue = contentTextareaField.getValue();
					 }
					var duration = win.down('#durationItemId').getValue();
					var presentationLanguage = win.down('#presentationLanguageItemId').getValue();
					//var fieldOfStudy = win.down('#fieldOfStudyItemId').getValue();
					 
					var videoURL = win.down('#videoURLItemId').getValue();
					var publishInCatalogue = win.down('#publishInCatalogueItemId').getValue();
					var saqaId = win.down('#saqaId').getValue();
					
					var docStore = this.getStore( 'program.ProgramCatalogueDocumentStore');
               	    var docArray = [];
                	 
					 if(isNullOrEmpty(catalogueContentId)){
						 var url = SERVERURL.PROGRAM_CATALOGUE_SAVE;
						 if (docStore.data.items != null  && docStore.data.items.length > 0) {
	               		      Ext.each(docStore.data.items, function(val) {
	               			  var newData = {
	               					 "name" : val.data.documentName,
	               					 "path" : val.data.path,
	               					 "type" : val.data.type,
	               					 "createdBy" : this$.getIdValueJson(
	               							 val.data.createdBy.id,
	               							 val.data.createdBy.value)
	               			   };
	               			   var programDoc = {
	               					 "document" : newData,
	               					 "fileType" :val.data.fileType
	               			  }
	               			  docArray.push(programDoc);
	               		  });
	               	     }
						 var ajaxParams = {
								 "id": null,
								 "program":{
									 "id": programId
								 },
								 "catalogueContent":{
									 "id": contentTypeFieldValue
								 },
								 "whetherHtml": (radioGroupVal.fieldTypeField == "html") ? true : false,
								 "content": contentFieldValue,
								 
								 "duration": duration,
								 "presentationLanguageId": presentationLanguage,
								 "videoURL": videoURL,
								 "publishInCatalogue": publishInCatalogue,
								 "saqaId": saqaId,
								 "programDocuments":docArray
						 };
					 }
					 else{
						 var url = SERVERURL.PROGRAM_CATALOGUE_UPDATE;
						 if (docStore.data.items != null  && docStore.data.items.length > 0) {
	               		      Ext.each(docStore.data.items, function(val) {
	               			  var newData = {
	               					 "id" : val.data.documentId,
	               					 "name" : val.data.documentName,
	               					 "path" : val.data.path,
	               					 "type" : "DOCUMENT",
	               					 "createdBy" : this$.getIdValueJson(
	               							 val.data.createdBy.id,
	               							 val.data.createdBy.value)
	               			   };
	               			   var programDoc = {
	               					 "id" : val.data.id,
	               					 "document" : newData,
	               					 "fileType" :val.data.fileType
	               			  }
	               			  docArray.push(programDoc);
	               		  });
	               	     }
						 var ajaxParams = {
								 "id": catalogueContentId,
								 "program":{
									 "id": programId
								 },
								 "catalogueContent":{
									 "id": contentTypeFieldValue
								 },
								 "whetherHtml": (radioGroupVal.fieldTypeField == "html") ? true : false,
								"content": contentFieldValue,
								 "duration": duration,
								 "presentationLanguageId": presentationLanguage,
								 "videoURL": videoURL,
								 "publishInCatalogue": publishInCatalogue,
								 "saqaId": saqaId,
								 "programDocuments":docArray
						 };
					 }
					 
					 Ext.Ajax.request({
	                		url: url,
	                		method: 'POST',
	                		async: false,
	                		jsonData: ajaxParams,
	                		success: function(response) {
	                			if(response.responseText != "DUPLICATE_ENTRY"){
		                			win.close();
		                			me.getCataloguecontentgrid().getStore().load();
        	 						showSuccessMessage(getCommonTranslation('CATALOGUE_CONTENT'),getCommonTranslation('SUCCESS'));
        	 						me.getCataloguecontentgrid().getSelectionModel().deselectAll();
	                			}
	                			else{
	       						 	showWarningMessage(getCommonTranslation('CATALOGUE_CONTENT'), getFeeAndPaymentCommonTranslation('DUPLICATE_RECORDS'));
	                			}
	                		}
					 });
				 }
			 },
			 'cataloguecontentaddeditwindow button[itemId=btnCancel]':{
				 click: function(btn){
					 btn.up('window').close();
				 }
			 }
		 });
	 },
	 isValidProgramImageExtension: function(extension) {
			if (!isNullOrEmpty(extension)) {
				extension = extension.toLowerCase();
				if (extension == "jpg" || extension == "jpeg" || extension == "png") {
					return true;
				}
			}
			return false;

		},
		isValidProgramFileExtension: function(extension) {
			if (!isNullOrEmpty(extension)) {
				extension = extension.toLowerCase();
				if (extension == "png"
					|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
						|| extension == "doc" || extension == "docx" 
							|| extension == "pptx") {
					return true;
				}
			}
			return false;
		},
		isValidBrochureFileExtension: function(extension) {
			if (!isNullOrEmpty(extension)) {
				extension = extension.toLowerCase();
				if (extension == "pdf" || extension == "doc" || extension == "docx" 
					|| extension == "pptx") {
					return true;
				}
			}
			return false;
		},
	 
	 getIdValueJson: function(id, value,code) {
      	 if (id) return {
      		 id: id,
      		 value: value,
      		 code: code
      	 };
       },
	 
	 getDocumentController : function() {
		 var this$ = this;
		 return this$.getController('Academia.controller.document.DocumentController');
	 }
});