Ext.define('Academia.controller.program.PathwaysController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [
		'program.ProgramSortedSequenceWiseStore',
		'program.programbatchdetail.BatchStore',
		'Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch',
		'program.programDetails.programBatches.pathwaysConfig.PathwaysConfigCsmDataStore',
		'program.SpecializationEnrollmentGridStore','program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionGridStore','program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionMajorListGridStore',
		'program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionMinorListGridStore','program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionSpecialisationListGridStore',
		'program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionTrackListGridStore','program.programDetails.programBatches.pathwaysConfig.PathwaysSelectionConcentrationListGridStore',
		'coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore',
		'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
		'enquiry.AcademicBatchStore',
		'pathways.PathwaysEnrollmentGridStore',
		'pathways.PathwaysEnrollmentRemarkGridStore','course.coursespecialization.SpecializationCourseGroupCoursesStore',
		'program.programDetails.programBatches.pathwaysConfig.PathwaysFilterStore','course.coursespecialization.CourseSpecializationCourseGroup'
		],
		model: [],
		views: [
			'program.programDetails.pathwaysEnrollment.PathwaysEnrollmentStructure',
			'program.programDetails.pathwaysEnrollment.PathwaysEnrollmentFilter',
			'program.programDetails.pathwaysEnrollment.PathwaysEnrollmentGrid',
			'program.programDetails.pathwaysEnrollment.PathwaysApproveRejectWindow',
			'coursetransaction.pathwaysselection.StudentPathwaysSelectionStructure','coursetransaction.pathwaysselection.StudentPathwaysSelectionSearch',
			'coursetransaction.pathwaysselection.StudentPathwaysSelectionGrid','coursetransaction.pathwaysselection.StudentPathwaysSelectionMinorListGrid',
			'coursetransaction.pathwaysselection.StudentPathwaysSelectionSpecialisationListGrid','coursetransaction.pathwaysselection.StudentPathwaysSelectionMajorListGrid',
			'coursetransaction.pathwaysselection.StudentPathwaysSelectionTrackListGrid','coursetransaction.pathwaysselection.StudentPathwaysSelectionConcentrationListGrid',
//			'program.SpecializationDetails',
			'program.StudentPathwayEnrollmentFilter',
			'baselayout.contentarea.ContentPanel','course.CourseLinkDetails','course.coursespecialization.CourseAssociatedToSpecailizationCourseGroups',
			'program.programDetails.pathwaysEnrollment.PathwaysEnrollmentRemarkWindow','course.coursespecialization.CourseSpecializationCourseGroupGrid',
			'program.programDetails.pathwaysEnrollment.PathwaysEnrollmentRemarkGrid','course.coursespecialization.CourseSpecializationCourseGroup'
			],
			config: {
			},
			refs: [{
				ref: 'pathwaysEnrollmentStructure',
				selector: 'pathwaysEnrollmentStructure'
			},{
				ref: 'pathwaysEnrollmentFilter',
				selector: 'pathwaysEnrollmentFilter'
			},{
				ref: 'pathwaysEnrollmentGrid',
				selector: 'pathwaysEnrollmentGrid'
			},{
				ref: 'pathwaysApproveRejectWindow',
				selector: 'pathwaysApproveRejectWindow'
			},{
				ref:'studentpathwaysselectionstructure',
				selector:'studentpathwaysselectionstructure'
			},{
				ref:'studentpathwaysselectionsearch',
				selector:'studentpathwaysselectionsearch'
			},{
				ref:'studentpathwaysselectiongrid',
				selector:'studentpathwaysselectiongrid'
			},{
				ref:'studentpathwaysselectionminorlistgrid',
				selector:'studentpathwaysselectionminorlistgrid'
			},{
				ref:'studentpathwaysselectionspecialisationlistgrid',
				selector:'studentpathwaysselectionspecialisationlistgrid'
			},{
				ref:'studentpathwaysselectionmajorlistgrid',
				selector:'studentpathwaysselectionmajorlistgrid'
			},{
				ref:'studentpathwaysselectiontracklistgrid',
				selector:'studentpathwaysselectiontracklistgrid'
			},{
				ref:'studentpathwaysselectionconcentrationlistgrid',
				selector:'studentpathwaysselectionconcentrationlistgrid'
			},{
				ref:'StudentPathwaysSelectionStructure',
				selector:'StudentPathwaysSelectionStructure'
			},{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref:'coursespecializationcoursegroup',
				selector:'coursespecializationcoursegroup'
			}],
			init: function(application) {
				this.studentBatchId;
				this.studentAdmissionId;
				this.PATHWAY_GRID_MAP = {
					    Major: 'stdPathwaysSelectionMajorListGridId',
					    Minor: 'stdPathwaysSelectionMinorListGridId',
					    Track: 'studentpathwaysselectiontracklistgrid',
					    Specialization: 'stdPathwaySelectionSpecialisationListGridId',
					    Concentration: 'studentpathwaysselectionconcentrationlistgrid'
				};
				this.control({
					'pathwaysEnrollmentStructure' : {
						afterrender : function(obj, record) {}
					},
					'pathwaysEnrollmentFilter button[itemId=btnSearch]' : {
						click : this.searchPathwaysGridRecord
					},
					'pathwaysEnrollmentFilter button[itemId=btnReset]' : {
						click : function(){
							var form = this.getPathwaysEnrollmentFilter();

							form.getForm().reset();
						}
					},
					'pathwaysEnrollmentGrid button[itemId=enrollPathwaysRejectBtn]' : {
						click : this.openApproveRejectWindow
					},
					'pathwaysEnrollmentGrid button[itemId=enrollPathwaysBtn]' : {
						click : this.openEnrollPathwaysTab
					},
					'pathwaysEnrollmentGrid button[itemId=enrollPathwaysApproveBtn]' : {
						click : this.openApproveRejectWindow
					},

					'pathwaysApproveRejectWindow button[itemId=rejectBtn]' : {
						click : this.saveRejectApprove
					},
					'pathwaysApproveRejectWindow button[itemId=submitBtn]' : {
						click : this.saveRejectApprove
					},
					'pathwaysEnrollmentGrid' : {
						cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
							var $this = this;
							pathwaysGrid = $this.getPathwaysEnrollmentGrid(),
							columnName = pathwaysGrid.columnManager.columns[cellIndex].dataIndex;
                            
							status = record.get('status'),
                            enrollPathwaysRejectBtn = pathwaysGrid.down('#enrollPathwaysRejectBtn'),
                            enrollPathwaysApproveBtn = pathwaysGrid.down('#enrollPathwaysApproveBtn');

							if (status === 'Approved' || status === 'Rejected' || status == null) {
								enrollPathwaysRejectBtn.setDisabled(true);
								enrollPathwaysApproveBtn.setDisabled(true);
							} else {
								enrollPathwaysRejectBtn.setDisabled(false);
								enrollPathwaysApproveBtn.setDisabled(false);
							}
  
							if (columnName == "remarkNumber") {
								if (e.target.tagName == 'A') {
									var pathwaysEnrollmentRemarkWindow = Ext.widget('pathwaysEnrollmentRemarkWindow'),
									remarkStore = pathwaysEnrollmentRemarkWindow.down('grid').getStore();

									remarkStore.getProxy().extraParams = {
										id: pathwaysGrid.getSelectionModel().getSelection()[0].data.id
									};

									remarkStore.load();
									pathwaysEnrollmentRemarkWindow.show();
								}
							}
							
							var studentListController = this$.getController('Academia.controller.personinfo.student.StudentListController');
							var personCommonController = this$.getController('Academia.controller.personinfo.common.PersonCommonController');  

							if(columnName=="studentCode"){
								if(e.target.tagName=='A'){

									var tabTitle = record.get('studentCode');
									var personId = record.raw.personId;
									var userId = record.get('studentId');
									var admissionId = record.get('admissionId');
									var programBatchSeatTypeConfigId = record.raw.progBatchSeatConfigId;
									personCommonController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
								}
							}
						}
					},
					
					'pathwaysEnrollmentFilter customcombobox#programId' : {
						change : function(obj, record) {
							var form = this.getPathwaysEnrollmentFilter();
							var programfilter=form.down("#programId");
							if((programfilter.value)>0){
								form.down("#batchId").clearValue();
								form.down("#batchId").setDisabled(false);
								form.down("#batchId").reset();
								var batchStore = form.down('#batchId').getStore();
								batchStore.getProxy().extraParams = {
									id:record,
									isActive : true
								};
								batchStore.load();
							}
						}
					},
					'pathwaysEnrollmentFilter customcombobox#batchId' : {
						change : function(obj, record) {
							var form = this.getPathwaysEnrollmentFilter();
							var programfilter=form.down("#batchId");
							if((programfilter.value)>0){
								form.down("#period").clearValue();
								form.down("#pathways").clearValue();
								form.down("#period").setDisabled(false);
								form.down("#pathways").setDisabled(false);
								form.down("#period").reset();
								form.down("#pathways").reset();
								var periodStore = form.down('#period').getStore();
								var pathwaysStore = form.down('#pathways').getStore();
								periodStore.getProxy().extraParams = {
									batchId: record
								};
								pathwaysStore.getProxy().extraParams = {
									batchId: record
								};
								pathwaysStore.load();
								periodStore.load();
							}
						}
					},
					
					'pathwaysEnrollmentFilter radiogroup[itemId=requestFor]': {
						change: function(obj, record) {
							var this$ = this;
							form = this.getPathwaysEnrollmentFilter(),
							requestGroup = form.down('#requestFor'),
							requestValue = requestGroup.getValue();
						}
					},

					'studentpathwaysselectionsearch':{
						afterrender : function(){
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId==3){
								this.setAcademyProgramBatchDetails();
							}
						}
					},
					'studentpathwaysselectionsearch button[itemId=resetBtn]':{
						click : function(){
							/*var form = this.getStudentpathwaysselectionsearch();
                           form.getForm().reset();*/
							this.setAcademyProgramBatchDetails();
						}
					},
					'studentpathwaysselectionsearch button[itemId=searchBtn]':{
						click : function(){
							var $this=this,grid = this.getStudentpathwaysselectiongrid(),
							store = grid.getStore();
							store.getProxy().extraParams = {
								batchId : $this.studentBatchId,
								admissionId : $this.studentAdmissionId,
							};
							this.resetPathwaysChildGrid();
							store.load();
						}
					},
					'studentpathwaysselectiongrid button[itemId=resetBtn]':{
                    	click : function(){
                    		this.resetPathwaysChildGrid();
                    	}
					},
                    'studentpathwaysselectiongrid button[itemId=submitBtn]':{
                    	click : function(){
                    		this.submitPathwaysSelection();
                    	}
					},
					'studentpathwaysselectiongrid':{
						afterrender:function(grid){
							var $this=this;
							Ext.defer(function() {
								grid.down('#totalRecordDisplayField') && grid.down('#totalRecordDisplayField').setVisible(false);
							}, 200, this);
							var portalId = this.getCurrentLoggedPortalId();
							if(portalId==1){
								var store = grid.getStore(),
								data = $this.getPathwaysEnrollmentGrid().getSelectionModel().getSelection()[0].data,
								specializationDetails = $this.getStudentpathwaysselectionstructure().down('studentPathwayEnrollmentFilter');

								specializationDetails.down('#programName').setValue(data.programCodeName);
								specializationDetails.down('#periodIdItemId').setValue(data.periodName);
								specializationDetails.down('#batchName').setValue(data.batchName);
								specializationDetails.batchId = data.batchId;
								specializationDetails.admissionId = data.admissionId;
								specializationDetails.admissionCode = data.AdmissionCode;
								store.getProxy().extraParams = {
									batchId: data.batchId,
									admissionId: data.admissionId,
									id:data.id
								};
								store.load();
							}
						},
						
						selectionchange: function(grid, selections) {
							var $this=this;
							var pathwaysPrintName;
							if (!selections.length) return;

							var rec = selections[0],admissionId,batchId,
							grid = this.getStudentpathwaysselectiongrid(),
							portalId = this.getCurrentLoggedPortalId(),
							children = rec.get('wSProgramBatchPathwaysChild') || [],
							rule = this.buildRuleFromJson(children),
							container = grid.up('studentpathwaysselectionstructure'),
							specializationdetails = $this.getStudentpathwaysselectionstructure().down('studentPathwayEnrollmentFilter'),
							store = grid.getStore(),
							submitButton = grid.up().down('#submitBtn'),
							hasEmptyStatus   = false,
							allAssignedOrApproved = false,
							hasRejectedRow  = false
							hasAssignedOrApproved=false;

							

							store.each(function (r) {
								var status = r.get('status');
								if (status === 'Approved' || status === 'Assigned') {
									hasAssignedOrApproved = true;
									return false;
								}
							});

							submitButton.setDisabled(true);


							if (!hasAssignedOrApproved) {
								var selectedStatus = rec.get('status');

								if (selectedStatus === 'Rejected') {
									submitButton.setDisabled(true);
								}
								else if (isNullOrEmpty(selectedStatus)) {
									submitButton.setDisabled(false);
								}
							}


							if(portalId==1){
								portalId = portalId;
								batchId = specializationdetails.batchId;
								admissionId = specializationdetails.admissionId;
								pathwaysPrintName = selections[0].data.pathwaysPrintName;
							}else{
								portalId = portalId;
								batchId = $this.studentBatchId;
								admissionId = $this.studentAdmissionId;
								pathwaysPrintName = selections[0].data.pathwaysPrintName;
							}
							
							var PATHWAY_GRID_MAP = $this.PATHWAY_GRID_MAP;

							Ext.Object.each(PATHWAY_GRID_MAP, function(type, gridId) {
								var grid = container.down('#' + gridId);
								if (!grid) return;
								
								var selModel = grid.getSelectionModel(),
						        store    = grid.getStore();

								if (rule[type]) {
									grid.show();
									if (selModel && store && store.getCount() > 0) {
										selModel.deselectAll();
									}
									var store = grid.getStore();
									store.getProxy().extraParams = {
										pathwaysCsmType:type,
										batchId : batchId,
										admissionId : admissionId,
										pathwaysPrintName : pathwaysPrintName,
										portalId : portalId
									};
									store.load();
								} else {
									if (selModel && store && store.getCount() > 0) {
										selModel.deselectAll();
									}
									grid.hide();
								}
							});
						},
					},
					'studentpathwaysselectionmajorlistgrid,studentpathwaysselectionminorlistgrid,studentpathwaysselectionspecialisationlistgrid,studentpathwaysselectiontracklistgrid,studentpathwaysselectionconcentrationlistgrid': {
					    afterrender: function (grid) {
					    	grid.getView().getEl().setStyle('overflow-x', 'hidden');
					    },
					    cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					    	 var $this=this;
					    	 if (!grid.headerCt) return;
					    	 var column = grid.headerCt.getHeaderAtIndex(cellIndex);
					    	 if (!column || !column.dataIndex) return;
					    	 var columnName = column.dataIndex;
							 if(columnName=='noOfAssociatedCourseGroups' &&  record.data.noOfAssociatedCourseGroups > 0){

								 var store=$this.getStore('course.coursespecialization.CourseSpecializationCourseGroup');
								 var submitURL=SERVERURL.FIND_ASSOCIATED_SPECIALIZED_COURSE_GROUP;
								 store.getProxy().api.read=submitURL;
								 store.getProxy().extraParams = {
									 specializationId: record.data.specializationId
								 };
								 store.load();
								 var formWindow = $this.getCoursespecializationcoursegroup();
								 if (!formWindow) {
									 formWindow = Ext.widget('coursespecializationcoursegroup',{
										 itemId:'specializationcoursegroupItemId'
									 });
								 }
								 formWindow.setTitle(getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED'));
								 formWindow.down('#courseGroup').setValue(record.data.specializationName);
								 formWindow.show();
								 var courseGroupGrid = formWindow.down('#coursespecializationcoursegroupgrid');
								 courseGroupGrid.setVisible(true);
								 var courseGroupCoursesGrid = formWindow.down('#courseassociatedtospecailizationcoursegroups');
								 courseGroupCoursesGrid.setVisible(false);
							 }
							 if(columnName == 'noofAssociatedCourses' &&  record.data.noofAssociatedCourses > 0){ 

								 var store = $this.getStore('course.coursespecialization.SpecializationCourseGroupCoursesStore'),
								 courseGrpIds = record.data.courseGroupIds,
								 courseGroups=[],
								 courseGroupsIds,batchId,admissionId,
								 specializationdetails = $this.getStudentpathwaysselectionstructure().down('studentPathwayEnrollmentFilter');
								 if(courseGrpIds != undefined && courseGrpIds.length > 0){
									 for(var i in courseGrpIds){
										 courseGroups.push(courseGrpIds[i]);
									 }
									 courseGroupsIds = courseGroups.join();
								 }
								 if(portalId==1){
									 batchId = specializationdetails.batchId;
									 admissionId = specializationdetails.admissionId
								 }else{
									 batchId= $this.studentBatchId
									 admissionId=$this.studentAdmissionId
								 }
								 store.getProxy().extraParams = {
									 courseGroupIds : courseGroupsIds,
									 batchId : batchId,
									 admissionId:admissionId
								 };
								 $this.resetPageSetting(store);
								 store.load();
								 var formWindow = $this.getCoursespecializationcoursegroup();
								 if (!formWindow) {
									 formWindow = Ext.widget('coursespecializationcoursegroup',{
										 itemId:'specializationcoursegroupItemId'
									 });
								 }
								 formWindow.setTitle(getProgramandcourseTranslation('COURSES_ASSOCIATED'));
								 formWindow.down('#courseGroup').setValue(record.data.specializationName);
								 formWindow.show();
								 var courseGroupGrid = formWindow.down('#coursespecializationcoursegroupgrid');
								 courseGroupGrid.setVisible(false);
								 var courseGroupCoursesGrid = formWindow.down('#courseassociatedtospecailizationcoursegroups');
								 courseGroupCoursesGrid.setVisible(true);
								 courseGroupCoursesGrid.columns[2].setVisible(false);
							 }
					    }
					}
				});
			},

			openApproveRejectWindow: function (btn) {
				var me = this,
				reqType = btn.itemId,
				isReject = (reqType === 'enrollPathwaysRejectBtn'),
				approveRejectWin = me.getPathwaysApproveRejectWindow(),
				title = isReject ? getCommonTranslation('REJECTION_REMARKS') : getCommonTranslation('APPROVE_REMARKS'),
						pathwaysGrid = me.getPathwaysEnrollmentGrid(),
						selectedData = pathwaysGrid.getSelectionModel().getSelection().length ? pathwaysGrid.getSelectionModel().getSelection()[0].data : null;

						if(!selectedData) return

						if (!approveRejectWin) {
							approveRejectWin = Ext.widget('pathwaysApproveRejectWindow',{
								data : selectedData
							});
						}

						approveRejectWin.setTitle(title);

						var submitBtn      = approveRejectWin.down('#submitBtn'),
						rejectBtn      = approveRejectWin.down('#rejectBtn'),
						commentApprove = approveRejectWin.down('#commentApprove'),
						commentReject  = approveRejectWin.down('#commentReject');

						if (isReject) {
							submitBtn.hide();
							commentApprove.hide();

							rejectBtn.show();
							commentReject.show();
						} else {
							rejectBtn.hide();
							commentReject.hide();

							submitBtn.show();
							commentApprove.show();
						}

						approveRejectWin.show();
			},
			searchPathwaysGridRecord: function (btn) {
				var me = this,
				portalId = me.getCurrentLoggedPortalId(),
				pathwaysEnrollmentFilter = me.getPathwaysEnrollmentFilter(),
				pathwaysEnrollmentGrid = me.getPathwaysEnrollmentGrid(),
				formValues = pathwaysEnrollmentFilter.getForm().getValues(),
				batchId = pathwaysEnrollmentFilter.down('#batchId').getValue(),
				pathwaysEnrollmentGridStore = pathwaysEnrollmentGrid.getStore();

				formValues.batchId = batchId;

				pathwaysEnrollmentGridStore.proxy.extraParams = {
						batchId: formValues.batchId,
						requestFor: formValues.requestFor,
						periodId: formValues.period,
						admissionId: formValues.studentNameSearch,
						pathwaysPrintName: formValues.pathways,
						status: formValues.status,
						portalId:portalId
				};	

				pathwaysEnrollmentGridStore.load();
			},

			setAcademyProgramBatchDetails:function(){
				var me = this,
				currentALId = me.getCurrentAcademyLocation(),
				form = me.getStudentpathwaysselectionsearch(),
				pathwaySelectionGrid = this.getStudentpathwaysselectiongrid(),
				studentALField = form.down("#studentAcademyLocation"),
				studentProgramField = form.down("#studentProgramId"),
				studentBatchField = form.down("#studentBatchId"),
				studentALStore = studentALField.getStore(),
				studentProgramStore = studentProgramField.getStore(),
				studentBatchStore = studentBatchField.getStore(),
				searchBtn = form.down('#searchBtn'),
				portalInfo = me.getCurrentlyLoggedInUserInfoForPortal(),
				admissionDetails=portalInfo.admissionDetails,
				admissionIds = Ext.Array.pluck(admissionDetails,'id').join();

				studentALStore.getProxy().extraParams = {
					admissionIds:admissionIds
				};
				studentBatchField.reset();
				studentBatchField.setDisabled(true);
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				studentALStore.load({
					callback: function(records, operation, success) {
						if (success) {
							if(records.length > 0){
								studentALField.setValue(currentALId);
								var user=me.getCurrentlyLoggedInUser();
								studentProgramStore.getProxy().extraParams = {
									studentId:user.id,
									academyLocationId: currentALId,
									onlyCurrentRecords: true
								};
								studentProgramStore.load({
									callback: function(records, operation, success) {
										if (success) {
											var admissionId = studentProgramStore.findRecord('programId',records[0].data.programId).data.admissionId;
											me.studentAdmissionId=admissionId;
											studentBatchStore.getProxy().extraParams.admissionId = admissionId;
											if(records.length > 0){
												if(records.length == 1){
													studentProgramField.setValue(records[0].data.programId);
													studentBatchStore.getProxy().extraParams.programId = records[0].data.programId;
													studentBatchStore.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length == 1){
																	studentBatchField.setValue(records[0].data.id);
																	var store = pathwaySelectionGrid.getStore();
																	me.studentBatchId = records[0].data.id;
																	store.getProxy().extraParams = {
																		batchId:records[0].data.id,
																		admissionId:admissionId
																	};
																	store.load({
																		callback:function(){
																			Ext.getBody().unmask();
																			searchBtn.setDisabled(false);
																		}
																	});
																}
																studentBatchField.setDisabled(false);
															}
														}
													});
												}
											}
										}
									}
								});
							}
						}
					}
				});
			},

			openEnrollPathwaysTab: function() {
				var me = this,
				contentpanel = me.getContentPanel(),
				studentPathwaysSelectionStructure = Ext.widget('studentpathwaysselectionstructure');

				studentPathwaysSelectionStructure.down('studentpathwaysselectionsearch').setVisible(false);
				studentPathwaysSelectionStructure.down('studentPathwayEnrollmentFilter').setVisible(true);

				var tabName = getCommonTranslation('PATHWAYS_SELECTION');
				openTab(contentpanel, tabName, studentPathwaysSelectionStructure, CONSTANTS.MENU_COLOR_THREE);

			},

			saveRejectApprove: function(btn){
				var me = this,
				formValues = btn.up('form').getForm().getValues(),
				selectedValue = btn.up('window').data,
				remarkApproveReject, json;

				if(btn.itemId == 'submitBtn'){
					remarkApproveReject = formValues.commentApprove;
					json = {
							admissionId: selectedValue.admissionId,
							approveBy: null,
							approvedDateString: null,
							autoApprove: false,
							batchId: selectedValue.batchId,
							id: selectedValue.id,
							programBatchSpecialId: selectedValue.programBatchSpecialId,
							requestDate: null,
							retainEnrollments: false,
							specializationCode: null,
							specializationId: null,
							status: null,
							remark: remarkApproveReject,
							selectedPathwaysName:selectedValue.patwaysName
					};
				}else{
					remarkApproveReject = formValues.commentReject;
					json = {
							admissionId: selectedValue.admissionId,
							approveBy: null,
							approvedDateString: null,
							autoApprove: false,
							batchId: selectedValue.batchId,
							id: selectedValue.id,
							programBatchSpecialId: selectedValue.programBatchSpecialId,
							requestDate: null,
							retainEnrollments: false,
							specializationCode: null,
							specializationId: null,
							status: "Rejected",
							remark: remarkApproveReject,
							selectedPathwaysName:selectedValue.patwaysName
					};
				}

				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');   	
				Ext.Ajax.request({
					type: 'rest',
					url:SERVERURL.PATH_SUBMIT_SELECTED_PATHWAYS,
					jsonData: [json],
					method: 'POST',
					success: function(response) {
						me.getPathwaysEnrollmentGrid().getStore().load();
						btn.up('window').close();
						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
						Ext.getBody().unmask();
					},
					failure:function(){
						Ext.getBody().unmask();
					}
				});
			},
			
			/*this function is used to find count of pathways from json because child grid has not count*/
			buildRuleFromJson: function(children) {
			    var rule = {};

			    Ext.Array.each(children, function(child) {
			    	var type = child.pathwaysPrintName,
			            count = child.groupCount;

			        if (type && count > 0) {
			            rule[type] = count;
			            /*to handle ignore case*/
			            rule[type.toLowerCase()] = count; 
			            rule[Ext.String.capitalize(type)] = count;
			        }
			    }, this);

			    return rule;
			},
			submitPathwaysSelection:function(){
				var  container = this.getStudentpathwaysselectionstructure(),json,$this=this,
			    pathwayGrid = container.down('#stdPathwaysSelectionGridId'),
			    data = [],
			    pathwayRec = pathwayGrid.getSelectionModel().getSelection()[0];

				if (!pathwayRec) {
			    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
			        return false;
			    }
				
				if (!this.validatePathwaySelection()) {
					return; 
				}
				
				var PATHWAY_GRID_MAP = $this.PATHWAY_GRID_MAP,
				isPortalOne = this.getCurrentLoggedPortalId() == 1,
				specializationdetails = null;

				if (isPortalOne) {
					specializationdetails =
						$this.getStudentpathwaysselectionstructure().down('studentPathwayEnrollmentFilter');
				}


				
				Ext.Object.each(PATHWAY_GRID_MAP, function(type, gridId) {
			        var grid = container.down('#' + gridId);

			        if (!grid || grid.isHidden()) return;

			        Ext.Array.each(
			            grid.getSelectionModel().getSelection(),
			            function(rec) {
			            	var id = null;
                            if(rec && !isNullOrEmpty(rec.raw.requestId)){
                                id = rec.raw.requestId;
                            }
			                data.push({
			                	id:id,
			                    batchId: isPortalOne ? specializationdetails.batchId : $this.studentBatchId,
			        	        admissionId: isPortalOne ? specializationdetails.admissionId : $this.studentAdmissionId,
			        	        admissionCode: isPortalOne ? specializationdetails.admissionCode : rec.get('admissionCode'),
								courseGroupIds:rec.get('courseGroupIds'),
								programBatchSpecialId: rec.get('id'),
								selectedPathwaysName:pathwayRec.get('pathwaysPrintName')
			                });
			            }
			        );
			    });
				if(data.length < 1 && pathwayRec.get('pathwaysPrintName')==" No Secondary Field of Study "){
					var id = null;
                    if(pathwayRec && !isNullOrEmpty(pathwayRec.raw.requestId)){
                        id = pathwayRec.raw.requestId;
                    }
					data.push({
						id:id,
	                    batchId: isPortalOne ? specializationdetails.batchId : $this.studentBatchId,
	        	        admissionId: isPortalOne ? specializationdetails.admissionId : $this.studentAdmissionId,
	        	        admissionCode: isPortalOne ? specializationdetails.admissionCode : pathwayRec.get('admissionCode'),
						courseGroupIds:null,
						programBatchSpecialId: null,
						selectedPathwaysName:pathwayRec.get('pathwaysPrintName')
	                });
				}
				json=Ext.encode(data);
				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');   	
				Ext.Ajax.request({
					type: 'rest',
					url:SERVERURL.PATH_SUBMIT_SELECTED_PATHWAYS,
					jsonData: json,
					method: 'POST',
					success: function(response) {
						$this.resetPathwaysChildGrid();
						pathwayGrid.getStore().reload();
						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
						Ext.getBody().unmask();
					},
					failure:function(){
						Ext.getBody().unmask();
					}
				});
			},
			validatePathwaySelection: function() {
				var  container = this.getStudentpathwaysselectionstructure(),$this=this,
			    pathwayGrid = container.down('#stdPathwaysSelectionGridId'),
			    pathwayRec  = pathwayGrid.getSelectionModel().getSelection()[0],

				children = pathwayRec.get('wSProgramBatchPathwaysChild') || [],
				rule = this.buildRuleFromJson(children),
			    PATHWAY_GRID_MAP = $this.PATHWAY_GRID_MAP;

			    for (var type in rule) {
			        var grid = container.down('#' + PATHWAY_GRID_MAP[type]);

			        if (!grid || grid.isHidden()) continue;

			        var selectedCount = grid.getSelectionModel().getSelection().length,
			            requiredCount = rule[type];

			        if (selectedCount !== requiredCount) {
			        	showNotificationMessage(getCommonTranslation('ALERT'), 
				                'Invalid Selection,Please select exactly ' + requiredCount + ' ' + type +'. You have selected ' + selectedCount + '.');
			            return false;
			        }
			    }
			    return true;
			},
			resetPathwaysChildGrid:function(){
				var grid = this.getStudentpathwaysselectiongrid(),$this=this,
				container = grid.up('studentpathwaysselectionstructure');
				var PATHWAY_GRID_MAP = $this.PATHWAY_GRID_MAP;
				
				if(grid && grid.getStore().getCount() > 0){
					grid.getSelectionModel().deselectAll();
				}
				
				Ext.Object.each(PATHWAY_GRID_MAP, function(type, gridId) {
					var specGrid = container.down('#' + gridId);
					
					if (specGrid) {
						var selModel = specGrid.getSelectionModel(),
						store    = specGrid.getStore();

						if (selModel && store && store.getCount() > 0) {
							selModel.deselectAll();
						}
						specGrid.hide();
					}
				});
			}
});