/**
 * @author Sandeep.Ladvikar
 * 
 * Role Controller
 * */

Ext.define('Academia.controller.securitysetup.Role', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['securitysetup.Roles', 'securitysetup.AccessPrivilege', 'securitysetup.PortalStore', 'securitysetup.ModuleStore', 'securitysetup.SubModuleStore', 'securitysetup.CompareRoleGridStore','securitysetup.ActiveRolesStore','standardMaster.MultiFactorAuthenticationStore'],
    models: ['securitysetup.Role', 'securitysetup.UpdateRoleGridModel', 'securitysetup.RolePrivilegeGridModel'],
    views: ['securitysetup.RoleGrid', 'securitysetup.RoleDetails', 'securitysetup.RolePrivilegeGrid', 'securitysetup.RoleBasicDetails', 'securitysetup.CompareRoleGrid'
            ,'securitysetup.RoleGridPanel', 'userandrole.role.RoleNameWin'],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'rolegrid',
        selector: 'rolegrid'
    },{
        ref: 'compareRoleGrid',
        selector: 'comparerole'
    },{
    	ref:'rolePrivilege',
    	selector:'roleprivilege'
    },{
    	ref:'rolenamewin',
    	selector:'rolenamewin'
    },{
    	ref:'rolebasicdetails',
    	selector:'rolebasicdetails'
    }],
    config: {
    	ROLE_MANAGEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ROLE_MANAGEMENT_PRIVILEGES'),
    	portals:null
    },
    init: function() {
    	this.getSecuritysetupAccessPrivilegeStore().addListener('filterchange',this.toggleGrantAllButton,this);
        this.control({
            'rolegrid button#btnAdd': {
                click: function() {
                    var menuController = Academia.app.getController('menu.CoreERPNavigationController');
                    menuController.addTab(getCommonTranslation('ADD_ROLE'), 'roledetails',CONSTANTS.MENU_COLOR_ONE);
                    viewMode=false;
                    this.removePlaceHolder();
                }
            },
            'rolegrid button#btnEdit': {
                click: function(button, e, eOpts, id) {
                	viewMode=false;
                    this.editRole(id);
                }
            },
            'rolegrid button#btnView': {
                click: this.viewRole
            },
            'rolegrid button#btnSearch': {
                click: this.searchRole
            },
            'rolegrid button#btnDelete': {
                click: this.deleteRole
            },
            'rolegrid #btnCompareRole': {
                click: this.compareRoles
            },
            'rolegrid #btnCopyCreateRole': {
                click: this.openRoleNameWindow
            },
            'rolenamewin #submitButtonId': {
                click: this.copyAndCreateRole
            },
            'rolenamewin #cancelButtonId': {
                click: function() {
                	var rolenameWindow = this.getRolenamewin();
                	rolenameWindow.close();
                }
            },
            'rolegrid button#resetBtnRoleGrid': {
            	click: function(button) {
            		var grid = this.getRolegrid();
            		grid.down('#searchRoleId').reset();
            		var store = grid.getStore();
            		store.getProxy().extraParams = {
            			roleId: null
            		};   
            		store.removeAll();
            		store.load();
            	}
            },
            'roledetails':{
            	afterrender : this.setGridHeaderFreez 
            },
            'roleprivilege #btnSavePrivilege ': {
                click: function() {
                    this.editRolePrivilege();
                }
            },
            'roleprivilege #btnGrantAllPrivilege': {
                click: this.grantAll
            },
            
            'roleprivilege checkcolumn': {
                checkchange: function(column, rowIndex, checked, eOpts ){
                	this.toggleRevokeButton(column,checked);  
                	if(viewMode){
                		var totalItems =column.up().up().getStore().data.items;
                    	totalItems[rowIndex].set(column.dataIndex,!checked);
                	}
                }
            },
           /* 'roleprivilege':{
            	render:this.toggleGrantAllButton
            },*/
            
            'roleprivilege #btnRevokeAllPrivilege': {
                click: this.revokeAll
            },

            'rolegrid': {
                render: function(grid) {
                	grid.getSelectionModel().deselectAll();
                	var userId = this.getCurrentlyLoggedInUser().id;
                	var lockUserRole = grid.down('#lockUserRole');
                	var UnlockUserRole = grid.down('#UnlockUserRole');
                    this.getStore('securitysetup.Roles').load();    
                    this.searchRole();
                    this.doAccessControlValidation(grid, this.getROLE_MANAGEMENT_PERMISSIONS());
                    this.disableMoreActionPivileges(grid,this.getROLE_MANAGEMENT_PERMISSIONS());
                    if(userId==1){
                    	lockUserRole.setVisible(true);
                    	UnlockUserRole.setVisible(true);
                    	lockUserRole.setDisabled(true);
                    	UnlockUserRole.setDisabled(true);
                    }
                },
               close:function(grid) {
            	   this.clearSearch();
                },
                select: function(rowSelect){
                	var grid = this.getRolegrid();
                	var selectedRows = rowSelect.getSelection();
                	var lockUserRole = grid.down('#lockUserRole');
                	var UnlockUserRole = grid.down('#UnlockUserRole');
                    if(rowSelect.getSelection().length > 1){
                    	grid.down('#btnView').setDisabled(true);
                    	grid.down('#btnDelete').setDisabled(true);
                    	grid.down('#btnEdit').setDisabled(true);
                    	grid.down('#btnCopyCreateRole').setDisabled(true);
                    }else if(rowSelect.getSelection().length <= 1){
                    	grid.down('#btnView').setDisabled(false);
                    	grid.down('#btnDelete').setDisabled(false);
                    	grid.down('#btnEdit').setDisabled(false);
                    	grid.down('#btnCopyCreateRole').setDisabled(false);
                    }
                    var islocked = 0;
                    var isUnLocked = 0;
                    for(var i=0;i<selectedRows.length;i++){
                    	if(selectedRows[i].data.isLocked == true){
                    		islocked++;
                    	}else if(selectedRows[i].data.isLocked == false){
                    		isUnLocked++;
                    	}
                    }
                    if(islocked == selectedRows.length){
                    	UnlockUserRole.setDisabled(false);
                    }else if(isUnLocked == selectedRows.length){
                    	lockUserRole.setDisabled(false);
                    }else {
                    	UnlockUserRole.setDisabled(true);
                    	lockUserRole.setDisabled(true);
                    }
                  },
                deselect: function(rowSelect){
                	var grid = this.getRolegrid();
                	var selectedRows = rowSelect.getSelection();
                	var lockUserRole = grid.down('#lockUserRole');
                	var UnlockUserRole = grid.down('#UnlockUserRole');
                	if(rowSelect.getSelection().length > 1){
                    	grid.down('#btnView').setDisabled(true);
                    	grid.down('#btnDelete').setDisabled(true);
                    	grid.down('#btnEdit').setDisabled(true);
                    	grid.down('#btnCopyCreateRole').setDisabled(true);
                    }else if(rowSelect.getSelection().length <= 1){
                    	grid.down('#btnView').setDisabled(false);
                    	grid.down('#btnDelete').setDisabled(false);
                    	grid.down('#btnEdit').setDisabled(false);
                    	grid.down('#btnCopyCreateRole').setDisabled(false);
                    }
                	 var islocked = 0;
                     var isUnLocked = 0;
                     for(var i=0;i<selectedRows.length;i++){
                     	if(selectedRows[i].data.isLocked == true){
                     		islocked++;
                     	}else if(selectedRows[i].data.isLocked == false){
                     		isUnLocked++;
                     	}
                     }
                     
                     if(islocked ==0){
                    	 UnlockUserRole.setDisabled(true);
                     }else if(islocked == selectedRows.length){
                     	UnlockUserRole.setDisabled(false);
                     }
                     if(isUnLocked ==0){
                    	 lockUserRole.setDisabled(true);
                     }else if(isUnLocked == selectedRows.length){
                     	lockUserRole.setDisabled(false);
                     }
                }

            },          
            'roleprivilege #comboPortal': {            	
                select: function(combo, records, eOpts) {
                    this.loadPortalCombo(combo, records);
                }             
            },
            'roleprivilege #comboModule': {
                select: function(combo, records, eOpts) {
                    this.loadModuleCombo(combo, records);
                    combo.up().up().down('#btnSearchRolePrivilege').setDisabled(false);
                }
            },
            'roleprivilege #comboSubModule': {
                select: function(combo, records, eOpts) {
                    this.loadSubModuleCombo(combo, records);
                }
            },
            'roleprivilege #btnResetPrivilege': {
                click: function(button) {
                    this.resetFilter(button);
                }
            },
            'roleprivilege #btnSearchRolePrivilege':{
            	click:this.searchRolePrivleges
            },            
            'rolebasicdetails button[action=save]': {
                click: this.saveRole
            },
            'rolebasicdetails button[action=cancel]': {
                click: this.cancelUpdateUser
            },
            'rolebasicdetails checkbox[itemId=studentMobAppItemId]': {
            	change: function(field, newValue, oldValue, eOpts) {
                    var me = this;
                    var form = me.getRolebasicdetails();
                    if(newValue == false){
                    	showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('STUDENT_MOBILE_APP_UNCHECK_MSG'), function(btn, text) {
                    		if (btn == 'yes') {
                    		}
                    		else{
                    			field.setValue(true);
                    		}
                    	});
                    }
                }
            },
            'rolebasicdetails checkbox[itemId=parentMobAppItemId]': {
            	change: function(field, newValue, oldValue, eOpts) {
                    var me = this;
                    var form = me.getRolebasicdetails();
                    if(newValue == false){
                    	showConfirmMessage(getCommonTranslation('ALERT'), getCommonTranslation('PARENT_MOBILE_APP_UNCHECK_MSG'), function(btn, text) {
                    		if (btn == 'yes') {
                    		}
                    		else{
                    			field.setValue(true);
                    		}
                    	});
                    }
                }
            },
            'rolegrid #searchRoleId':{
            	 select: function(combo, records, eOpts) {
                     this.loadSearchRole(combo, records);
                 }
            },
            'rolegrid #lockUserRole': {
                click:function(){
                	this.lockUnlockConfirmationWindow('lockUserRole');
                }
            },
            'rolegrid #UnlockUserRole': {
                click: function(){
                	this.lockUnlockConfirmationWindow('UnlockUserRole');
                }
            },
        });
    },

    /**
     * This method is use to select all checkboxes of granted privilege column in role privilege grid
     * */
    grantAll: function() {
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        //var grid = this.getRoleprivilegegrid();
        var store = rolePrivilegeGrid.getStore();
        var revokeButton = rolePrivilegeGrid.down('#btnRevokeAllPrivilege');
        var grantButton = rolePrivilegeGrid.down('#btnGrantAllPrivilege');
        store.suspendEvents();   
        store.each(function(rec) {
        	 rec.set('granted', true);
        });          
        store.resumeEvents();
        rolePrivilegeGrid.getView().refresh();
        revokeButton.setDisabled(false);
        grantButton.setDisabled(true);
    },

    /**
     * This method is use to unselect all checkboxes of granted privilege column in role privilege grid
     * */
    revokeAll: function() {
//        var grid = this.getRoleprivilegegrid();
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        var store = rolePrivilegeGrid.getStore();
        var revokeButton = rolePrivilegeGrid.down('#btnRevokeAllPrivilege');
        var grantButton = rolePrivilegeGrid.down('#btnGrantAllPrivilege');
        store.suspendEvents();
        store.each(function(rec) {           
            rec.set('granted', false); 
            rec.set('whetherOverrideAllowed', false);
        });
        store.resumeEvents();
        rolePrivilegeGrid.getView().refresh();
        revokeButton.setDisabled(true);
        grantButton.setDisabled(false);
    },
    
    toggleRevokeButton:function(column,checked) {
    	var grid = column.up('grid');
    	var store = grid.getStore();    	
    	var revokeButton = grid.down('#btnRevokeAllPrivilege');
    	var grantButton = grid.down('#btnGrantAllPrivilege');
    	if(checked) {
    		revokeButton.setDisabled(false);
    	} else {
    		store.each(function(rec) {
    			if(rec.get('granted') == true) {
    				revokeButton.setDisabled(false);
    				return false;
    			} else {
    				revokeButton.setDisabled(true);
    				grantButton.setDisabled(false);
    			}
    		});
    	}    	
    },
    
    toggleGrantAllButton:function(store) {
//    	var grid = this.getRoleprivilegegrid();
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
    	var revokeButton = rolePrivilegeGrid.down('#btnRevokeAllPrivilege');
    	var grantButton = rolePrivilegeGrid.down('#btnGrantAllPrivilege');
    	/*if(checked) {
    		revokeButton.setDisabled(false);
    	} else {*/
    	
    	if(store){
    		var count = store.getCount();
    		if(count> 0){
    			var isAllChecked=false;
    			store.each(function(rec) {
        			if(rec.get('granted') == false) {
        				isAllChecked=false;
        				return false;
        			} else {
        				isAllChecked=true;    				
        			}
        		});
    			if(isAllChecked){
        			revokeButton.setDisabled(false);
    				grantButton.setDisabled(true);
        		} else {
        			revokeButton.setDisabled(true);
    				grantButton.setDisabled(false);
        		}
    		}else{
    			revokeButton.setDisabled(true);
				grantButton.setDisabled(true);
    		}
    	}
    	
    		
    		
    //	}    	
    },

    /**
     * This method is use to load the module combo box store and filter the grid according to selected portal
     * 
     * */
    loadPortalCombo: function(combo, records) {
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        //var store = rolePrivilegeGrid.getStore();
        //store.clearFilter();
        var moduleCombo = rolePrivilegeGrid.down('#comboModule');
//        var moduleCombo = Ext.ComponentQuery.query('roleprivilege #comboModule')[0];
        moduleCombo.clearValue();
        var subModuleCombo = rolePrivilegeGrid.down('#comboSubModule');
//        var subModuleCombo = Ext.ComponentQuery.query('roleprivilege #comboSubModule')[0];
        subModuleCombo.clearValue();
        subModuleCombo.setDisabled(true);
     //   store.filterGrid(records[0].get('portalName'), "portal");
        var id = records[0].get('id');
        var moduleStore = moduleCombo.getStore();
        moduleStore.getProxy().extraParams = {
            portalId: id
        };
        moduleStore.load();
        moduleCombo.setDisabled(false);
    },

    /**
     * This method is use to load the Submodule combo box store and filter the grid according to selected module
     * 
     * */
    loadModuleCombo: function(combo, records) {
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        var subModuleCombo = rolePrivilegeGrid.down('#comboSubModule');
//        var subModuleCombo = Ext.ComponentQuery.query(' roleprivilege #comboSubModule')[0];
        var id = records[0].get('id');
      //  store.removeFilter("moduleId");
        var subModuleStore = subModuleCombo.getStore();
        subModuleCombo.clearValue();
        if (id != 0) {
         //   store.filterGrid(records[0].get('moduleName'), "module");
            subModuleStore.getProxy().extraParams = {
                moduleId: id
            };
            subModuleStore.load();
            subModuleCombo.setDisabled(false);
        }else{
        	subModuleCombo.setDisabled(true);
        }
    },

    /**
     * This method is use to  filter the grid according to selected sub module
     * 
     * */
    loadSubModuleCombo: function(combo, records) {       
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        var store = rolePrivilegeGrid.getStore();
        var id = records[0].get('id');
      //  store.removeFilter("subModuleId");
        if (id != 0) {
          //  store.filterGrid(records[0].get('moduleName'), "subModule");
        }
    },

    /**
     * This method is use to  reset  the selected filters for grid 
     * 
     * */
    resetFilter: function(button) {
    	var grid = button.up();
    	grid.down("#comboPortal").clearValue();
        var moduleCombo = grid.down("#comboModule");
        moduleCombo.clearValue();
        moduleCombo.setDisabled(true);
        var subModuleCombo = grid.down("#comboSubModule");
        subModuleCombo.clearValue();
        subModuleCombo.setDisabled(true);
     	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        var store = rolePrivilegeGrid.getStore();
        store.clearFilter();
        grid.down("#btnSearchRolePrivilege").setDisabled(true);
    },

    searchRolePrivleges:function(button) {
    	 var this$=this;
         var roleManagementTab = this$.getContentPanel().getActiveTab();
         var privilegeGrid = roleManagementTab.down('roleprivilege');
//    	var privilegeGrid = this$.getRoleprivilegegrid();
        var store = privilegeGrid.getStore();
        var count = store.getCount();
        store.clearFilter();
        if(count ==0) {
        	var id= privilegeGrid.up('panel').down('form').down('hidden[id]').getValue();
            store.getProxy().extraParams = {
                id: id
            };
            store.reload({
    			callback:function(){
    				var totalRecord = privilegeGrid.getStore().getCount();
    				privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
    			}
    		});
        }     
        var portalCombo = privilegeGrid.down('#comboPortal');
       store.filterGrid(portalCombo.getValue(), "portal");
       var moduleCombo = privilegeGrid.down('#comboModule');        
        if(!isNullOrEmpty(moduleCombo.getRawValue())) {
        	 if(moduleCombo.getRawValue() !==getCommonTranslation('ALL_MODULES')){
                 store.filterGrid(moduleCombo.getRawValue(), "module");
                 setTimeout(function(){
                     var totalRecord = privilegeGrid.getStore().getCount();
                     privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
                    },1200);
                 privilegeGrid.down('#btnGrantAllPrivilege').setDisabled(false);
             }   
        }
        
        var subModuleCombo = privilegeGrid.down('#comboSubModule');
        if(!isNullOrEmpty(subModuleCombo.getRawValue())) {
        	store.filterGrid(subModuleCombo.getRawValue(), "subModule");
        	setTimeout(function(){
                var totalRecord = privilegeGrid.getStore().getCount();
                privilegeGrid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+totalRecord);
               },1200);
        	privilegeGrid.down('#btnGrantAllPrivilege').setDisabled(false);
        }
        button.up('grid').down('#btnGrantAllPrivilege').setDisabled(false);
    },
    
    
    /**
     * This method is use to  search the role
     * 
     * */
    searchRole: function(button) {
        var grid = this.getRolegrid();
        var searchText = grid.down('#searchRoleId').value;//grid.down('textfield[name=searchRole]').value;
        var store = grid.getStore();
        var paginationBar = grid.down('#roleGridPagination');
        store.getProxy().extraParams = {
        	roleId: searchText
        };
        store.reload({
        	callback:function(){
        		/*if(store.count()==0) {
        			showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'),getCommonTranslation('NO_RECORDS_FOUND'));        			
        			paginationBar.setVisible(false);
        		} else {
        			if(paginationBar) {
        				paginationBar.setVisible(true);
        			}        			
        		}*/
        		//paginationBar.moveFirst();
        	}
        });
    },

    /**
     * This method is use to  clear the search the role. This is private method used internally.
     * 
     * */
    clearSearch: function() {
        var grid = this.getRolegrid();
        grid.down('textfield').reset();
        this.searchRole();
    },

    /**
     * This method is use to save the newly created  role and also updated role
     *  
     */
    saveRole: function() {
        var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var roleBasicDetailForm = roleManagementTab.down('rolebasicdetails');
        var form =roleBasicDetailForm.getForm();
        var id = form.findField("id").getSubmitValue();
        if(!isNullOrEmpty(id)){
        	var version = form.getRecord().getData().version;
        	}
        var values = form.getValues();
        var submitUrl = '';
        var role = new Academia.model.securitysetup.Role(values);
        var portal = role.get('portals');
        var portals = new Array(); 
        var isEdit = false;
        
        if (!Ext.isArray(portal)) {  	
            portals.push(portal);
            role.set('portals', portals);
        }
    
        role.set('version',version);
        role.set('multiFactorAuth',form.findField('mfa').getSubmitValue());
        
        var restrictedIPs = form.findField('restrictedIPs').getValue();
        role.set('restrictedIPs', restrictedIPs);
        
        var isConcurrentLoginAllow = form.findField('isConcurrentLoginAllow').getValue();
        role.set('isConcurrentLoginAllow', isConcurrentLoginAllow);
        
        var data = Ext.encode(role.data);
        if (id == "" || id == null) {
            submitUrl = SERVERURL.ROLE_SAVE;
        } else {
            submitUrl = SERVERURL.ROLE_UPDATE;
            if (!Ext.isArray(portal)) {
            	portals.pop();
            	portals.push(portal.id);
            } else {
            	Ext.each(portal,function(object){
            		portals.push(object.id);
            	});
            }           
            isEdit=true;
            
        }
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
       

        Ext.Ajax.request({
            type: 'rest',
            method: 'POST',
            jsonData: data,
            url: submitUrl,
            success: function(response) {
            	Ext.getBody().unmask();
            	showSuccessMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('SAVEDSUCCESSFULLY'));
                var gridStore = this$.getRolegrid().getStore();

                if (response.responseText == "") {
               	
                 var roleManagementTab = this$.getContentPanel().getActiveTab();
                 var privilegeGrid = roleManagementTab.down('roleprivilege');
                    var privilegeStore = privilegeGrid.getStore();
                    privilegeStore.clearFilter();
                    privilegeStore.getProxy().extraParams = {
                        id: id
                    };
                    privilegeStore.reload();
                    if(isEdit) {
                    	this$.loadPortalStore(portals);
                    }
                } else {
                    this$.clearForm();
                    this$.closeFormTab();
                    this$.clearSearch();
                    gridStore.reload();
                }
                if(!isNullOrEmpty(id)){
                   this$.loadEditForm(id,false);
                }
            }
        });
        
        
    },

    /**
     * This method is use to clear the form.
     *  
     */
    clearForm: function() {
        var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var roleBasicDetailForm = roleManagementTab.down('rolebasicdetails');
        var form =roleBasicDetailForm.getForm();
        form.reset();
        this.closeFormTab();
    },

    /**
     * This method is use to view the role selected
     *  
     */
    viewRole: function() {
    	viewMode = true;
        this.editRole('', true);
        var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var roleBasicDetailForm = roleManagementTab.down('rolebasicdetails');
        var form =roleBasicDetailForm.getForm();
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var privilegeGrid = roleManagementTab.down('roleprivilege');
//        var grid = this.getRoleprivilegegrid(); 
        if (form) {
        	  toggleReadOnlyFormItems(form,true);
        	  roleBasicDetailForm.down('#btnSaveRoleId').setVisible(false);
//            form.down('#btnSaveRoleId').setVisible(false);
          //  form.down('#btnCancelSaveRoleId').setVisible(false);
            privilegeGrid.down('#btnSavePrivilege').setVisible(false);
            privilegeGrid.down('#btnGrantAllPrivilege').setVisible(false);
            privilegeGrid.down('#btnRevokeAllPrivilege').setVisible(false);
        }
    },

    /**
     * This method is use to close the open tab.This is private method used internally 
     *  
     */
    closeFormTab: function() {
        var menuController = Academia.app.getController('menu.CoreERPNavigationController');
        var roleTab = menuController.getTab('Add Role');
        if (roleTab) {
            roleTab.close();
        }
    },

    loadPortalStore:function(params) {
        var this$=this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var privilegeGrid = roleManagementTab.down('roleprivilege');
//    	 var privilegeGrid = this.getRoleprivilegegrid();
         var combo =  privilegeGrid.down('#comboPortal');
    	combo.getStore().load({
    		params:{
    			portalIds:params
    		}
    	});
    },
    
    /**
     * This method is use to delete the selected role
     *  
     */
    deleteRole: function() {
        var grid = this.getRolegrid();

        if (grid.getSelectionModel().getCount() == 1) {
        	 var record = grid.getSelectionModel().getSelection()[0];
        	  if (record.get("whetherDeletable")) {
            showConfirmMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {     
                	var id = record.get("id");
                        Ext.Ajax.request({
                            method: "POST",
                            type: 'rest',
                            url: SERVERURL.ROLE_DELETE,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            params: {
                                id: id
                            },
                            success: function(form, action) {
                                grid.getStore().reload();
                                showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('ROLE_DELETED_SUCCESFULLY'));
                            }
                        });
                    }
                });
            }  else {
            	showErrorMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('ROLE_CAN_NOT_DELETE'));
            }
        } else if (grid.getSelectionModel().getCount() < 1) {
            showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        } else {
            showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        }
    },

    loadEditForm: function(recordId, isView){
         var this$=this;
    	 var id;
    	 var grid = this.getRolegrid();
    	 var record = grid.getSelectionModel().getSelection()[0];
         if (recordId) {
             id = recordId;
         } else {
             id = record.get("id");
         }
    	 Ext.Ajax.request({
    		 
             type: 'rest',
             method: 'GET',
             url: SERVERURL.ROLE_FIND_BY_ID,
             async:false,
             params: {
                 id: id
             },
             success: function(response) {
                 var data = Ext.decode(response.responseText);
            	 this$.editViewRolePanel(data,isView);
             }
         });
    },
    editViewRolePanel: function(data,isView){
    	 var this$=this;
    	 var menuController = Academia.app.getController('menu.CoreERPNavigationController');
    	 if (isView) {
    		 var getTab = menuController.getTab(getCommonTranslation('VIEW_ROLE'));
    		 if (getTab != null) {
    			 this$.getContentPanel().remove(getTab, true);
    		 }
             menuController.addTab(getCommonTranslation('VIEW_ROLE'), 'roledetails',CONSTANTS.MENU_COLOR_ONE);
    	 } else {
    		 var getTab = menuController.getTab(getCommonTranslation('EDIT_ROLE'));
    		 if (getTab != null) {
    			 this$.getContentPanel().remove(getTab, true);
    		 }
    		 menuController.addTab(getCommonTranslation('EDIT_ROLE'), 'roledetails',CONSTANTS.MENU_COLOR_ONE);
    	 }
         var roleManagementTab = this$.getContentPanel().getActiveTab();
         var privilegeGrid = roleManagementTab.down('roleprivilege');
         var role = new Academia.model.securitysetup.Role(data);
         privilegeGrid.setVisible(true);
         var roleManagementTab = this$.getContentPanel().getActiveTab();
         var formRole = roleManagementTab.down('rolebasicdetails');
         var form =formRole.getForm();
         formRole.down('#resetButtonId').setVisible(false);
         
         if(role.data.serialNumber == "Parent"){
        	 formRole.down('#parentPortalItemId').setVisible(true);
        	 formRole.down('#parentMobAppItemId').setVisible(true);
        	 formRole.down('#studentMobAppItemId').setVisible(false);
         }
         else if(role.data.serialNumber == "1"){
        	 formRole.down('#studentMobAppItemId').setVisible(true);
        	 formRole.down('#parentPortalItemId').setVisible(false);
        	 formRole.down('#parentMobAppItemId').setVisible(false);
         }
         else{
        	 formRole.down('#studentMobAppItemId').setVisible(false);
        	 formRole.down('#parentPortalItemId').setVisible(false);
        	 formRole.down('#parentMobAppItemId').setVisible(false);
         }
         this$.setPortals(role.data.portals);
         this$.setIdFromNestedObject(role.data.portals);
         form.loadRecord(role);
         
        // form.findField('serialNumber').setReadOnly(true);  V2D-356658
         form.findField('mfa').getStore().load();
         form.findField('mfa').setValue(data.multiFactorAuth);
         form.findField('restrictedIPs').setValue(data.restrictedIPs);
         form.findField('isConcurrentLoginAllow').setValue(data.isConcurrentLoginAllow);
         
         var store = privilegeGrid.getStore();
         store.clearFilter();
         store.removeAll();
         
         privilegeGrid.down('#btnGrantAllPrivilege').setDisabled(true);
         privilegeGrid.down('#btnSearchRolePrivilege').setDisabled(true);
         this$.loadPortalStore(this$.getPortals());
         this$.removePlaceHolder();  
    },
    /**
     * This method is use to open the selected role in the form in editable mode
     *  
     */
    editRole: function(recordId, isView) {
//        var this$ = this;
        var grid = this.getRolegrid();

        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            if (record.get('whetherEditable') || isView || 
                   	(! isNullOrEmpty(recordId) && record.data.id != recordId)) {
//                var menuController = Academia.app.getController('menu.CoreERPNavigationController');
               
                var id;
                if (recordId) {
                    id = recordId;
                } else {
                    id = record.get("id");
                }
                this.loadEditForm(id, isView);
              /*
                Ext.Ajax.request({
                    type: 'rest',
                    method: 'GET',
                    url: SERVERURL.ROLE_FIND_BY_ID,
                    async:false,
                    params: {
                        id: id
                    },
                    success: function(response) {
                    	 if (isView) {
                             menuController.addTab(getCommonTranslation('VIEW_ROLE'), 'roledetails');
                         } else {
                             menuController.addTab(getCommonTranslation('EDIT_ROLE'), 'roledetails');
                         }
                        var reponse = Ext.decode(response.responseText);
                        var role = new Academia.model.securitysetup.Role(reponse);
                        this$.getRoleprivilegegrid().setVisible(true);
                        var formRole = this$.getRoleBasicDetailsForm();
                        var form = formRole.getForm();
                        formRole.down('#resetButtonId').setVisible(false);
                        this$.setPortals(role.data.portals);
                        this$.setIdFromNestedObject(role.data.portals);
                        form.loadRecord(role);
                        form.findField('serialNumber').setReadOnly(true);
                       var privilegeGrid = this$.getRoleprivilegegrid();
                        var store = privilegeGrid.getStore();
                        store.clearFilter();
                        store.removeAll();
                        privilegeGrid.down('#btnGrantAllPrivilege').setDisabled(true);
                        privilegeGrid.down('#btnSearchRolePrivilege').setDisabled(true);
                           store.getProxy().extraParams = {
                            id: id
                        };
                        store.reload();
                        this$.loadPortalStore(this$.getPortals());                    	
                    }
                });*/
            } else {
            	showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('ROLE_CAN_NOT_EDIT'));
            }
        } else if (grid.getSelectionModel().getCount() < 1) {
            showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        } else {
            showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
        }
    },

    setIdFromNestedObject: function(objectArray) {
        for (var i = 0; i < objectArray.length; i++) {
            objectArray[i] = objectArray[i]["id"];
        };
    },

    /**
     * This method is use to edit the role privileges from the role privilege grid.
     *  
     */
    editRolePrivilege: function() {
    	var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var rolePrivilegeGrid = roleManagementTab.down('roleprivilege');
        var records = rolePrivilegeGrid.getStore().getUpdatedRecords();
        var grid = this.getRolegrid();
        var record = grid.getSelectionModel().getSelection()[0];
        var id = record.get("id");
        
        if(records.length > 0) {        	
        var rolePrivileges = new Array();
        Ext.each(records, function(obj) {
            rolePrivileges.push(obj.data);
        });
        var updateRoleGridModel = new Academia.model.securitysetup.UpdateRoleGridModel();
        updateRoleGridModel.set("roleId", id);
        updateRoleGridModel.set("rolePrivileges", rolePrivileges);
        for(var i = 0 ; i < updateRoleGridModel.data.rolePrivileges.length;i++){
        	 delete updateRoleGridModel.data.rolePrivileges[i].featureName;
        }
        recordsToUpdate = Ext.encode(updateRoleGridModel.data);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
      
        Ext.Ajax.request({
            type: 'rest',
            method: 'post',
            url: SERVERURL.ROLE_UPDATE_ROLE_PRIVILEGE,
            jsonData: recordsToUpdate,
            success: function() {
            	  Ext.getBody().unmask();
            	 showSuccessMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('SUCCESS'));
                var store = rolePrivilegeGrid.getStore();
                //store.commitChanges();
                store.reload();
            }
        });
        }
    },

    /**
     * This method is use to compare roles.
     *  
     */
    compareRoles: function() {
    	var this$= this;
        var roleGrid = this.getRolegrid();
        var records = roleGrid.getSelectionModel().getSelection();
        if (records.length > 1 && records.length <= 5) {
            var ids = new Array();
            var names = new Array();
            Ext.each(records, function(record) {
                ids.push(record.data.id);
                names.push(record.data.roleName);
            });
            
            
            var compareGridStore = this.getStore('securitysetup.CompareRoleGridStore');
            var columnModel = compareGridStore.model;
            var fields = columnModel.getFields();
            fields = this.loadColumnModelAndHeader(fields, names);
            var params = {
                roleIds: ids
            };
            var store = this.createGridStore(fields, SERVERURL.ROLE_FIND_ROLE_TO_COMPARE, params);
            store.load({
            	callback: function(record,operaion,success){
            		if(record.length == 0){
            			showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('ROLE_CANNOT_COMPARE'));
            			compareRoleTab.close();
            		}else{
            			var menuController = Academia.app.getController('menu.CoreERPNavigationController');
            			menuController.addTab('Compare Roles', 'comparerole',CONSTANTS.MENU_COLOR_ONE);
            			var compareGrid = this$.getCompareRoleGrid();
            			this$.createGrid(compareGrid, fields, store);
            		}
            	} 
            });
            
        } else if (records.length > 5) {
            showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('MAX_ROLE_SELECT_COMPARE'));
        } else {
            showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('MIN_ROLE_SELECT_COMPARE'));
        }
    },

    /**
     * This method is use to add new fields in the column model for comparing roles. Private method used internally.
     *  
     */
    loadColumnModelAndHeader: function(columnModels, names) {
        var newFields = [];
        Ext.each(columnModels, function(columnModel) {
            newFields.push(columnModel);
        });
        Ext.each(names, function(name) {
            newFields.push(new Ext.data.Field({
                name: name
            }));
        });
        return newFields;
    },

    /**
     * This method is use to create the grid  for comparing roles. Private method used internally.
     *  
     */
    createGrid: function(grid, columnModels, store) {
        grid.getSelectionModel().deselectAll(true);
        var columns = [];
        Ext.each(columnModels, function(columnModel) {
            if (columnModel.name != 'id') {
                columns.push(Ext.create('Ext.grid.column.Column', {
                    text: columnModel.name,
                    dataIndex: columnModel.name,
                    flex: 0.4,
                    renderer: function(value) {
                    	if(value == null || value =='') {
                    		return getCommonTranslation('NOT_GRANTED') ;
                    	} else {
                    		 return getCommonTranslation(value);
                    	}                       
                    }
                }));
            }
        });
        Ext.suspendLayouts();
        grid.reconfigure(store, columns);
        Ext.resumeLayouts(true);
    },

    /**
     * This method is use to store for comparing roles. Private method used internally.
     *  
     */
    createGridStore: function(fields, url, params) {
        var store = Ext.create('Ext.data.Store', {
            fields: fields,
            autoSync: true,
            proxy: {
                type: 'rest',
                api: {
                    read: SERVERURL.ROLE_FIND_ROLE_TO_COMPARE
                },
                reader: {
                    type: 'json'
                },
                extraParams: params
            }
        });
        return store;
    },

    /**
     * This method is use to create copy of the selected role
     *  
     */
    
    openRoleNameWindow : function () {
    	var $this = this;
    	var grid = $this.getRolegrid();
    	if (grid.getSelectionModel().getCount() == 1) {
    		var rolenameWindow = $this.getRolenamewin();
    		if (!rolenameWindow) {
    			Ext.widget('rolenamewin');
    			rolenameWindow = $this.getRolenamewin();
    		}
    		rolenameWindow.show();
    	}
    	else {
    		showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
    	}
    },    
    
    copyAndCreateRole: function() {
        var this$ = this;
        var rolenameWindow = this$.getRolenamewin();
        var roleName = rolenameWindow.down('#roleNameItemId').getValue();
        this$.applyWindowMask(); 
        Ext.Ajax.request({
            type: 'rest',
            method: 'GET',
            url: SERVERURL.PATH_FIND_BY_ROLE_NAME,
            params: {
                roleName:roleName
            },
            success: function(response) {
                var responseValue = Ext.decode(response.responseText);
                if(responseValue == true) {
                	this$.hideWindowMask();
                	showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('ROLE_NAME_NOT_UNIQUE'));
                } else {
                	   var grid = this$.getRolegrid();
                       if (grid.getSelectionModel().getCount() == 1) {
                           var record = grid.getSelectionModel().getSelection()[0];
                           if (!record.get("whetherDeleted")) {
                               var id = record.get("id");
                               Ext.Ajax.timeout= 90000;
                               Ext.Ajax.request({
                                   type: 'rest',
                                   method: 'GET',
                                   url: SERVERURL.ROLE_COPY_CREATE,
                                   params: {
                                       id: id,
                                       roleName:roleName
                                   },
                                   success: function(response) {
                                       var id = Ext.decode(response.responseText);
                                       this$.editRole(id);
                                       rolenameWindow.close();
                                       this$.hideWindowMask();
                                   }
                               });
                           } else {
                               showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('ROLE_CAN_NOT_COPY'));
                           }
                       } else {
                           showWarningMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
                           rolenameWindow.close();
                           this$.hideWindowMask();
                       }
                }
            }
        });
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getRolegrid();
   		var roleMoreAction = grid.down("#spBtnMoreActions");//itemId of split button
   		var rolesearch = grid.down('#btnSearch');//itemId of search button
   		var roleReset = grid.down('#resetBtnRoleGrid');
   		var lockUserRole = grid.down('#lockUserRole');
    	var UnlockUserRole = grid.down('#UnlockUserRole');
   		
   		roleMoreAction.setVisible(false);
   		rolesearch.setVisible(false);
   		roleReset.setVisible(false);
   		lockUserRole.setVisible(false);
   		UnlockUserRole.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(roleMoreAction)){
           			roleMoreAction.setVisible(true);//enable more action button
           		}        		
           	}else if(privilege === 'SEARCH'){
           		if(!isNullOrEmpty(rolesearch)){
           			rolesearch.setVisible(true);//enable search button
           		} 
           	}else if(privilege === 'RESET'){
           		if(!isNullOrEmpty(roleReset)){
           			roleReset.setVisible(true);//enable reset button
           		} 
           	}else if(privilege === 'LOCK_USER_ROLE'){
           		if(!isNullOrEmpty(lockUserRole)){
           			lockUserRole.setVisible(true);//enable lock user role link
           		} 
           	}else if(privilege === 'UNLOCK_USER_ROLE'){
           		if(!isNullOrEmpty(UnlockUserRole)){
           			UnlockUserRole.setVisible(true);//enable unlock user role link
           		} 
           	}
       	});
       },
       /**
   	 * This method is used to cancel update user record form.
   	 * 
   	 */
   	cancelUpdateUser: function() {
        var this$ = this;
        var roleManagementTab = this$.getContentPanel().getActiveTab();
        var roleBasicDetailForm = roleManagementTab.down('rolebasicdetails');
        var form =roleBasicDetailForm.getForm();
   		var tab = form.up('panel');
   		this.closeTab(tab);
       },
       setGridHeaderFreez : function(structure){
    	   var $this = this;
    	   var grid = this.getRolePrivilege();
    	   structure.body.on('scroll', function(e, target) {
    		   var gridTitle = grid.dockedItems.items[0];
    		   var gridBttns = grid.dockedItems.items[1];
    		   var gridHeader = grid.dockedItems.items[2];

    		   var structurePosition = structure.getPosition()[1];
    		   var freeze = grid.getPosition()[1];

    		   if(freeze <= structurePosition){
    			   $this.addGridFreezCSSForWithOutTabRolesScreen(gridTitle,gridBttns,gridHeader);
    		   }else{
    			   $this.removeGridFreezCSSForWithOutTabRolesScreen(gridTitle,gridBttns,gridHeader);
    		   }
    	   });
       },
       loadSearchRole: function(combo, records){
    	   var grid = this.getRolegrid();
           var searchVal = combo.getValue();
           var store = grid.getStore();           
           store.getProxy().extraParams = {
        	   roleId: searchVal
           };          
           this.resetGridSetting(grid);
           store.load();
       },
       lockUnlockConfirmationWindow: function(role){
    	   var grid = this.getRolegrid();
    	   var records = grid.getSelectionModel().getSelection();
    	   var id = [];
    	   var isLocked =false;
    	   var confirmMsg;
    	   var json= new Object;
    	   for(var i=0;i<records.length;i++){
    		   id.push(records[i].data.id);
    	   }
    	   var rolesIds  = id.join(',');
    	   if(role == 'lockUserRole'){
    		   isLocked=true;
    		   confirmMsg = getCommonTranslation('LOCK_SELECTED_USER');
    	   }else{
    		   confirmMsg = getCommonTranslation('UNLOCK_SELECTED_USER');
    	   }
    	   json ={
    			 "rolesIds":rolesIds,
    			 "isLocked":isLocked
    	   };
    	   if (grid.getSelectionModel().getCount() > 0) {
    		   Ext.MessageBox.confirm({
      		     title:getCommonTranslation('ALERT'),
      		     cls: 'warningMessageBox commonMsgBoxCls',
      		     msg: confirmMsg,
      		     buttons: Ext.Msg.YESNO,
      		     icon: Ext.Msg.WARNING,
      		     buttonText : {
      		    	 yes : getCommonTranslation('SAVE'),
      		    	 no : getCommonTranslation('CANCEL')
      		     },
      		     callback: function(btn,text){
           			if (btn == 'yes') {
           			    var submitData = Ext.encode(json);
           				Ext.Ajax.request({
           				 method : "POST",
           				 type : 'rest',
           				 url: SERVERURL.PATH_SAVE_LOCK_UNLOCK_STATUS,
           				jsonData: submitData,
           				 headers : {
           					 'Content-Type' : 'application/json'
           				 },
           				 success: function(response) {
           					showSuccessMessage(getCommonTranslation('ROLE_MSG_TITLE'), getCommonTranslation('SUCCESS'));
           					grid.getStore().load();
           					grid.getSelectionModel().deselectAll();
           				 }
           			 });
           			}
           		}
      		});
    	   }else{
  			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
   		   }
       },
       addGridFreezCSSForWithOutTabRolesScreen : function(gridTitle,gridBttns,gridHeader){
    	   gridTitle.removeCls('x-docked');
    	   gridBttns.removeCls('x-docked');
    	   gridHeader.removeCls('x-docked');
    	   gridTitle.addCls('sticky-header-active-title-withouttab-roles-screen');
    	   gridBttns.addCls('sticky-header-active-buttons-withouttab-roles-screen');
    	   gridHeader.addCls('sticky-header-active-columns-withouttab-roles-screen');
       },
       removeGridFreezCSSForWithOutTabRolesScreen : function(gridTitle,gridBttns,gridHeader){
    	   gridTitle.removeCls('sticky-header-active-title-withouttab-roles-screen');
    	   gridBttns.removeCls('sticky-header-active-buttons-withouttab-roles-screen');
    	   gridHeader.removeCls('sticky-header-active-columns-withouttab-roles-screen');
    	   gridTitle.addCls('x-docked');
    	   gridBttns.addCls('x-docked');
    	   gridHeader.addCls('x-docked');
       },
       removePlaceHolder:function(){
	            var rolebasicdetailsform=this.getRolebasicdetails();
                      Ext.Ajax.request({
                         type: 'rest',
                         url: SERVERURL.FIND_BY_ENTITY_ID,                             
                         method: 'GET',
                         params: {
                             entityId: 16
                         },
                         success: function(response,form, action) {
                             if(!isNullOrEmpty(response.responseText)){
                                 var responseObject =  Ext.JSON.decode(response.responseText);                                  
                                 if(!isEmpty(responseObject)){
                                     var serialNumber = rolebasicdetailsform.down("#serialNumber");
                                     if(responseObject.whetherManualId){
                                         serialNumber.setReadOnly(false);
										 serialNumber.emptyText=' ';
									     serialNumber.allowBlank=false;
										 serialNumber.labelSeparator +='<span class="required" style="color:red"> *</span>';
										 serialNumber.setFieldLabel(serialNumber.fieldLabel);
										 serialNumber.applyEmptyText();
                                     }else{
										 serialNumber.setReadOnly(true);
									     serialNumber.allowBlank=true;
										 serialNumber.emptyText= getCommonTranslation('ID_AUTOGENERATE');
										 serialNumber.applyEmptyText();
	
                                    }
                                 }
                             }                                                     
                         }                
                     });
    
}
});