/**
 * @author Pritam.Patil
 * This is used for tables dashboard controller 
 */
Ext.define('Academia.controller.setup.dashboard.LicenseDetailsReportController', {
	extend: 'Academia.controller.base.BaseController',

	views: ['setup.dashboard.LicenseDetailsReportStructure', 'setup.dashboard.LicenseDetailsReportGrid','setup.dashboard.AlumniLicenseDetailsReportGrid'],

	stores: ['messaging.LicenseDetailsReportStore','setup.dashboard.AlumniLicenseDetailsReportStore'],
	refs: [{
		ref: 'licensedetailsreportgrid',
		selector: 'licensedetailsreportgrid'
	},{
		ref: 'licensedetailsreportstructure',
		selector: 'licensedetailsreportstructure'
	},{
		ref: 'alumnilicensedetailsreportgrid',
		selector: 'alumnilicensedetailsreportgrid'
	}],
	 config: {
	    	LICENSE_DETAILS_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LICENSE_DETAILS_REPORT_PRIVILEGES'),
	 },
	init: function(application) {
		this.control({
			'licensedetailsreportgrid': {
				render: function(grid){
					var structure =this.getLicensedetailsreportstructure();
					var grid = structure.down('#licensedetailsreportgridId')
					grid.getStore().load();
				},
				afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getLICENSE_DETAILS_REPORT_PERMISSIONS());
    				},1500);
    			}
			},
			'licensedetailsreportstructure':{
				render: function(structure){
	 				 this.disableLicenseDetailsReportTabByPriviledge(structure, this.getLICENSE_DETAILS_REPORT_PERMISSIONS());
	 			  }
			},
			'alumnilicensedetailsreportgrid': {
				render: function(grid){
					var structure =this.getLicensedetailsreportstructure();
					var grid = structure.down('#alumnilicensedetailsreportgridId')
					grid.getStore().load();
				}/*,
				afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getLICENSE_DETAILS_REPORT_PERMISSIONS());
    				},1500);
    			}*/
			}
		});
	},
	disableLicenseDetailsReportTabByPriviledge: function(structure,permissionsMap) {
	   	 var associatedAcadLocationIds = new Array();
		   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		   	 var StudentLicenseTab=false;
		   	 var AlumniLicenseTab=false;
		   	 for (var i = 0; i < permissionList.length; i++) {
		   		 if (permissionList[i] === "STUDENT_LICENSE_DETAILS") {
		   			StudentLicenseTab=true;
		   		 }
		   		 if (permissionList[i] === "ALUMNI_LICENSE_DETAILS") {
		   			AlumniLicenseTab=true;
			   	 }
		   	 }
		   	 this.showLicenceDetailTab(StudentLicenseTab,AlumniLicenseTab, structure);
		    
	   },
	   showLicenceDetailTab: function(StudentLicenseTab,AlumniLicenseTab,structure){

		   var panelItem = new Array();
		   var $this = this;
		   var newcont=structure.items.items.length;
		   var insertPosition=newcont+1;
		   var itemsArray = [];
		   
		   if(StudentLicenseTab){
			   itemsArray.push({
				   xtype:'panel',
				   title:getCommonTranslation('STUDENT_LICENSE_DETAILS'),
				   items : [{
					   xtype: 'licensedetailsreportgrid',
					   itemId: 'licensedetailsreportgridId',
				   }]
			   });
		   }
		   
		   if(AlumniLicenseTab){
			   itemsArray.push({
					xtype:'panel',
					title:getCommonTranslation('ALUMNI_LICENSE_DETAILS'),
					items : [{
						xtype: 'alumnilicensedetailsreportgrid',
						itemId: 'alumnilicensedetailsreportgridId',
					}]
				});
		   }
		   
		   if(!StudentLicenseTab && !AlumniLicenseTab){
			   itemsArray.push({
				   xtype:'panel',
				   title:getCommonTranslation('STUDENT_LICENSE_DETAILS'),
				   items : [{
					   xtype: 'licensedetailsreportgrid',
					   itemId: 'licensedetailsreportgridId',
				   }]
			   });
		   }
		   
		   panelItem.push({
			   xtype:'tabpanel',
			   plain: true,
			   style:{overflow:'hidden !important',marginLeft:'0!important'},
			   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
			   frame: false,
			   border:false,
			   items:itemsArray
		   });
		   
		   structure.insert(insertPosition,panelItem);
	   },
});