/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.controller.sgappointment.sgappointment.SGAppointmentController', {
	extend : 'Academia.controller.personinfo.common.PersonCommonController',
	// un-comment the model code if required.
	//models : [''],
	stores : ['feeandpayment.managebill.Student','sgappointment.sgappointment.SGAppointmentGridStore','common.CountryStore','sgappointment.sgappointment.SGVisitorCategoryStore',
	          'hostel.roomallocation.UserSmartSearchByUserType','sgappointment.sgappointment.SGAppointeeNameStore','sgappointment.sgappointment.SGAppointmentFlagIdStore',
	          'sgappointment.sgappointment.SGBookingIDStore','coursetransaction.sectionmanagement.FacultyIdValueSmartSearch','sgappointment.sgappointment.SGParentGuardianStore',
	          'enquiry.EnquiryCodeSearchStore','sgappointment.sgappointment.SGReasonForVisitStore','sgappointment.sgappointment.SGVisitStatus','coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
	          'admission.applications.applicantProfileBase.ApplicantSmartSearchStore','enquiry.EnqIntermediateType'],
	          views : ['sgappointment.sgappointment.SGAppointmentTabStructure','sgappointment.sgappointment.SGAppointmentStructure','sgappointment.sgappointment.SGAppointmentFilter','sgappointment.sgappointment.SGAppointmentGrid',
	                   'sgappointment.sgappointment.SGAppointmentForm','sgappointment.sgappointment.SGReasonToMeetGridWin','servicerequest.eventcalendar.ViewCalendarWin',
	                   'personinfo.common.course.ScheduleDetails','baselayout.contentarea.ContentPanel','sgappointment.sgappointment.SGAppointmentDetailGrid',
	                   'sgappointment.sgappointment.SGStudentAppointmentDetailFormStructure'],
	                   config:{
	                	   APPOINTMENT_MANAGE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPOINTMENT_MANAGE_PRIVILEGES')

	                   },	         
	                   refs : [
	                           {
	                        	   ref : 'sgappointmentstructure',
	                        	   selector : 'sgappointmentstructure'
	                           },{
	                        	   ref : 'sgappointmentfilter',
	                        	   selector : 'sgappointmentfilter'
	                           },{
	                        	   ref: 'sgappointmentgrid',
	                        	   selector: 'sgappointmentgrid'
	                           },{
	                        	   ref: 'contentPanel',
	                        	   selector: 'contentPanel'
	                           },{
	                        	   ref: 'sgappointmentform',
	                        	   selector: 'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId]'
	                           },{
	                        	   ref: 'sgreasontomeetgridwin',
	                        	   selector: 'sgreasontomeetgridwin'
	                           },{
	                        	   ref : 'sgappointmenttabstructure',
	                        	   selector : 'sgappointmenttabstructure'
	                           },{
	                        	   ref : 'viewcalendarwin',
	                        	   selector : 'viewcalendarwin' 
	                           },{
	                        	   ref : 'scheduledetails',
	                        	   selector : 'scheduledetails'
	                           },{
	                        	   ref: 'sgappointmentdetailgrid',
	                        	   selector: 'sgappointmentdetailgrid'
	                           },{

	                        	   ref: 'sgstudentappointmentdetailformstructure',
	                        	   selector: 'sgstudentappointmentdetailformstructure'
	                           
	                           }],
	                           init : function() {
	                        	   this.control({
	                        		   'sgappointmentfilter button[itemId=searchBtn]': {
	                        			   click: this.loadSGAppointmentGrid
	                        		   },
	                        		   'sgappointmentfilter button[itemId=resetBtn]': {
	                        			   click: function(){
	                        				   var $this=this;
	        	                        	   var filter = $this.getSgappointmentfilter();
	                        				   this.resetSGAppointment(filter);
	                        			   }
	                        		   },
	                        		   'sgappointmentgrid button[itemId=btnDelete]':{
	                        			   click: this.deleteSGAppointmentRecord
	                        		   },
	                        		   'sgappointmentgrid button[itemId=btnAdd]':{
	                        			   click: function(){
	                        				   this.addSGAppointmentRecord('ADD');  
	                        				   this.setEntrybyValuebydefault();
	                        				   this.setVisitStatusByDefault();
                                               this.removePlaceHolder();
	                        				   var form=this.getSgappointmentform();
	                        				   var countryCodeField=form.down("#cellCountryCode");
	        	                        	   var mobileField = form.down("#mobileNo");
	        	                        	  this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);

	                        			   }

	                        		   },
	                        		   'sgappointmentgrid button[itemId=btnEdit]':{
	                        			   click : function(obj, record) {
	                        				   var $this=this;
	                        				   var grid = $this.getSgappointmentgrid();
	                        				   if (grid.getSelectionModel().getCount() > 0) {
	                        					   var record=grid.getSelectionModel().getSelection()[0];
	                        					   if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment == true){
	                        						   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("RESCHEDULE_APPOINTMENT_CANT_BE_EDITED"));
	                        						   return;
	                        					   }else{
	                        						   this.editAppointmentRecord(
	                        								   obj, record); 
	                        					   }
	                        				   }
	                        			   }
	                        		   },
	                        		   'sgappointmentgrid button[itemId=btnView]':{
	                        			   click: this.viewSGAppointmentRecord
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] displayfield[itemId=pathId]':{
	                        			   afterrender: function(fld){
	                        				   fld.el.on("click", function(){
		                        				   var documentId= Ext.getCmp(this.id).documentId;
		                        				   if(!isNullOrEmpty(documentId)){
		                                               Ext.Ajax.request({
		                                                   type: 'rest',
		                                                   url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
		                                                   method: 'GET',
		                                                   callback : function(opt, success, response){
		                                                       if(response.responseText == 'true') {
		                                                           var csvForm = Ext.create('Ext.form.Panel'); 
		                                                           csvForm.getForm().submit({
		                                                               target: '_blank',
		                                                               method:'GET',
		                                                               params :{
		                                                                   access_token : Ext.Ajax.defaultHeaders.access_token
		                                                               },
		                                                               headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		                                                               url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
		                                                               standardSubmit :true
		                                                           });
		                                                       } else {
		                                                           showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
		                                                       }
		                                                   }
		                                               });
		                                           }
		                        				   
		                        				   
		                        			   });
	                        			   }
	                        		   },
	                        		   'sgappointmentform':{
	                        			   render: function(form){
	                        				   var countryCodeField=form.down("#cellCountryCode");
	                        				   var store = countryCodeField.getStore();
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] button[itemId=submitBtn]':{
	                        			   click: this.saveSGAppointmentRecord
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] button[itemId=viewCalendar]':{
	                        			   click : this.openViewCalendarWin
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo[itemId=personToMeetId]':{
	                        			   render: function(obj){
	                        				   var store = obj.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   academyLocationIds:this.getCurrentAcademyLocation()
	                        				   };
	                        				   store.load();
	                        				   var sgForm=this.getSgappointmentform();
	                        				   var userId=this.getCurrentlyLoggedInUser();
	                        				   var personToMeetId = sgForm.down("#personToMeetId");
	                        				   personToMeetId.store.load({
	                        					   callback : function(operation,success) {
	                        						   if (success) {
	                        							   personToMeetId.setValue(userId.id);
	                       			    				}
	                       			    			} 
	                       			    		});
	                        			   },
	                        			   select:function(obj,record){
	                        				   var sgForm=this.getSgappointmentform();
	                        				   sgForm.down('#viewCalendar').setDisabled(false);
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo[itemId=personToMeetFilterItemId]':{
	                        			   render: function(obj){
	                        				   var store = obj.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   academyLocationIds:this.getCurrentAcademyLocation()
	                        				   };
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo[itemId=entryById]':{
	                        			   render: function(obj){
	                        				   var store = obj.getStore();
	                        				   store.getProxy().extraParams = {
	                        					   academyLocationIds:this.getCurrentAcademyLocation()
	                        				   };
	                        				   store.load();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] customcombobox[itemId=viewStatusID]': {
	                        			   select : function(obj, record){
	                        				   var sgForm=this.getSgappointmentform();
	                        				   var recVal = record[0].data.value;
	                        				   var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
	                        				   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                        				   var chkRescheduleAppointment = sgForm.down('#chkRescheduleAppointment');
	                        				   var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                        				   if(recVal == "Rescheduled"){
	                        					   rescheduleAppointmentFld.setVisible(true);
	                        					   this.setAllowBlank(rescheduleAppointmentDateId,false);
	                        					   rescheduleAppointmentDateId.reset();
	                        					   chkRescheduleAppointment.setValue(true);
	                        				   }
	                        				   else{
	                        					   rescheduleAppointmentFld.setVisible(false);
	                        					   this.setAllowBlank(rescheduleAppointmentDateId,true);
	                        					   rescheduleAppointmentDateId.reset();
	                        				   }
	                        				   rescheduleAppointmentTimeId.reset();
	                        				   sgForm.getForm().checkValidity();
	                        			   }
	                                   },
	                                   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] checkboxfield[itemId=chkRescheduleAppointment]': {
	                                	   change : function(cmp, currentValue, oldValue, eOpts){
	                                		   var sgForm=this.getSgappointmentform();
	                                		   var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
	                                		   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                                		   var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                                		   if (currentValue == true) {
	                                			   dateTimeRescheduleAppointmentItemId.setVisible(true);
	                                			   this.setAllowBlank(rescheduleAppointmentDateId,false);
	                                			   rescheduleAppointmentDateId.reset();
	                                		   }
	                                		   else{
	                                			   dateTimeRescheduleAppointmentItemId.setVisible(false);
	                                			   this.setAllowBlank(rescheduleAppointmentDateId,true);
	                                			   rescheduleAppointmentDateId.reset();
	                                		   }
	                                		   rescheduleAppointmentTimeId.reset();
	                                		   sgForm.getForm().checkValidity();
	                                	   }
	                                   },
	                        		   'sgappointmentgrid' : {
	                        			   cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	                        				   if (e.target.tagName == 'A') {
	                        					   this.getReasonToMeetGridWindow(grid,record);
	                        				   }
	                        				   var followUpBtn = this.getSgappointmentgrid().down('#followUpDetailBtnId');
	                        				   if(!isNullOrEmpty(record.data.student)){
	                        					   followUpBtn.setDisabled(false);
	                        				   }else{
	                        					   followUpBtn.setDisabled(true);
	                        				   }
	                        			   }
	                        		   },
	                        		   'sgappointmentstructure ': {
	                        			   render: function(grid){
	                        				   this.doAccessControlValidation(grid, this.getAPPOINTMENT_MANAGE_PERMISSIONS());
	                        			   }
	                        		   },
	                        		   'sgappointmentstructure  sgappointmentgrid': {
	                        			   render: function(grid){
	                        				   this.doAccessControlValidation(grid, this.getAPPOINTMENT_MANAGE_PERMISSIONS());
	                        				   var associatedAcadLocationIds = new Array();
	                        				   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                        				   permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPOINTMENT_MANAGE_PERMISSIONS());
	                        				   if(permissionList && permissionList.indexOf('FOLLOW_UP_DETAILS')!=-1){
	                        					   grid.down('#followUpDetailBtnId').setVisible(true);
	                        				   }
	                        			   },
	                        			   afterrender:function(grid){
	                        					var me = this;
	                        					setTimeout(function(){
	                        						me.addDataGridConfigButton(grid,me.getAPPOINTMENT_MANAGE_PERMISSIONS());
	                        					},1500);
	                        				 }
	                        		   },
	                        		 
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#visitorCategoryID' : {
	                        			   select : function(obj,record){
		                                       var this$ = this;
	                        				   var sgForm=this.getSgappointmentform();
	                        				   var parentNameField=sgForm.getForm().findField('appointeeNameParent');
	                        				   var appointeeNameField=sgForm.getForm().findField('appointeeName');
	                        				   var leadId = sgForm.getForm().findField('leadId');
	                        				   var facAppointmentId = sgForm.getForm().findField('facAppointmentId');
	                        				   var studentNameField= sgForm.getForm().findField('studentId');
	                        				   var applicantNameField = sgForm.down('#applicantNameId');
	                        				   var mobileField = sgForm.down("#mobileNo").reset();
	                        				   var countryCodeField=sgForm.down("#cellCountryCode").reset();
	                        				   var emailId = sgForm.down("#appointeeEmailItemId").reset();
	                        				   var academyLocationId = sgForm.down("#academyLocationId");
	                        				   var programId = sgForm.down("#programId");
	                        				   var batchId = sgForm.down("#batchId");
	                        				   var seatTypeId = sgForm.down("#seatTypeId");

	                        				   if(record[0].data.id==1){
	                        					   parentNameField.setVisible(true);
	                        					   parentNameField.allowBlank = false;
	                        					   appointeeNameField.setVisible(false);
	                        					   appointeeNameField.allowBlank = true;
	                        					   appointeeNameField.reset();
	                        					   leadId.setVisible(false);
	                        					   leadId.allowBlank = true;
	                        					   leadId.reset();
	                        					   facAppointmentId.setVisible(false);
	                        					   facAppointmentId.allowBlank = true;
	                        					   facAppointmentId.reset();
	                        					   studentNameField.setVisible(false);
	                        					   studentNameField.allowBlank = true;
	                        					   studentNameField.reset();
	                        					   applicantNameField.setVisible(false);
	                        					   applicantNameField.allowBlank = true;
	                        					   applicantNameField.reset();
												   if (parentNameField.getValue() == null) {
													   academyLocationId.setDisabled(true);
													   programId.setDisabled(true);
													   batchId.setDisabled(true);
													   batchId.setDisabled(true);
												   }
	                        					   academyLocationId.reset();
	                        					   programId.reset();
	                        					   batchId.reset();
	                        					   batchId.reset();
                                                   this$.loadDFRForManageAppointment(academyLocationId);
	                        				   }else if(record[0].data.id==2){
	                        					   appointeeNameField.setVisible(false);
	                        					   appointeeNameField.allowBlank = true;
	                        					   appointeeNameField.reset();
	                        					   parentNameField.setVisible(false);
	                        					   parentNameField.allowBlank = true;
	                        					   parentNameField.reset();
	                        					   leadId.setVisible(true);
	                        					   leadId.allowBlank = false;
	                        					   facAppointmentId.setVisible(false);
	                        					   facAppointmentId.allowBlank = true;
	                        					   facAppointmentId.reset();
	                        					   studentNameField.setVisible(false);
	                        					   studentNameField.allowBlank = true;
	                        					   studentNameField.reset();
	                        					   applicantNameField.setVisible(false);
	                        					   applicantNameField.allowBlank = true;
	                        					   applicantNameField.reset();
	                        					   if (leadId.getValue() == null) {
													   academyLocationId.setDisabled(true);
													   programId.setDisabled(true);
													   batchId.setDisabled(true);
													   batchId.setDisabled(true);
												   }
	                        					   academyLocationId.reset();
	                        					   programId.reset();
	                        					   batchId.reset();
	                        					   seatTypeId.reset();
	                        					   this$.loadDFRForManageAppointment(academyLocationId);
	                        				   }else if(record[0].data.id==3){
	                        					   studentNameField.setVisible(true);
	                        					   studentNameField.allowBlank = false;
	                        					   appointeeNameField.setVisible(false);
	                        					   appointeeNameField.allowBlank = true;
	                        					   appointeeNameField.reset();
	                        					   parentNameField.setVisible(false);
	                        					   parentNameField.allowBlank = true;
	                        					   parentNameField.reset();
	                        					   leadId.setVisible(false);
	                        					   leadId.allowBlank = true;
	                        					   leadId.reset();
	                        					   facAppointmentId.setVisible(false);
	                        					   facAppointmentId.allowBlank = true;
	                        					   facAppointmentId.reset();
	                        					   applicantNameField.setVisible(false);
	                        					   applicantNameField.allowBlank = true;
	                        					   applicantNameField.reset();
	                        					   if (studentNameField.getValue() == null) {
													   academyLocationId.setDisabled(true);
													   programId.setDisabled(true);
													   batchId.setDisabled(true);
													   batchId.setDisabled(true);
												   }
	                        					   academyLocationId.reset();
	                        					   programId.reset();
	                        					   batchId.reset();
	                        					   seatTypeId.reset();
	                        					   this$.loadDFRForManageAppointment(academyLocationId);
	                        				   }else if(record[0].data.id==4){
	                        					   facAppointmentId.setVisible(true);
	                        					   appointeeNameField.setVisible(false);
	                        					   parentNameField.setVisible(false);	                        					   	                        					   
	                        					   leadId.setVisible(false);
	                        					   leadId.allowBlank = true;
	                        					   appointeeNameField.allowBlank = true;
	                        					   parentNameField.allowBlank = true;
	                        					   facAppointmentId.allowBlank = false;
	                        					   studentNameField.setVisible(false);
	                        					   studentNameField.allowBlank = true;
	                        					   applicantNameField.setVisible(false);
	                        					   applicantNameField.allowBlank = true;
	                        					   academyLocationId.setVisible(false);
	                        					   programId.setVisible(false);
	                        					   batchId.setVisible(false);
	                        					   seatTypeId.setVisible(false);
	                        				   }else if(record[0].data.id==5){
	                        					   applicantNameField.setVisible(true);
	                        					   applicantNameField.allowBlank = false;
	                        					   facAppointmentId.setVisible(false);
	                        					   facAppointmentId.allowBlank = true;
	                        					   facAppointmentId.reset();
	                        					   appointeeNameField.setVisible(false);
	                        					   appointeeNameField.allowBlank = true;
	                        					   appointeeNameField.reset();
	                        					   parentNameField.setVisible(false);
	                        					   parentNameField.allowBlank = true;	
	                        					   parentNameField.reset();                        					   	                        					   
	                        					   leadId.setVisible(false);
	                        					   leadId.allowBlank = true;
	                        					   leadId.reset();
	                        					   studentNameField.setVisible(false);
	                        					   studentNameField.allowBlank = true;
	                        					   studentNameField.reset();
	                        					   if (applicantNameField.getValue() == null) {
													   academyLocationId.setDisabled(true);
													   programId.setDisabled(true);
													   batchId.setDisabled(true);
													   batchId.setDisabled(true);
												   }
	                        					   academyLocationId.reset();
	                        					   programId.reset();
	                        					   batchId.reset();
	                        					   seatTypeId.reset();
	        			    	 	               this$.loadDFRForManageAppointment(academyLocationId);
	                        				   }else if(record[0].data.id==6){
	                        					   appointeeNameField.setVisible(true);
	                        					   appointeeNameField.allowBlank = false;
	                        					   parentNameField.setVisible(false);
	                        					   parentNameField.allowBlank = true;
	                        					   
	                        					   leadId.setVisible(false);
	                        					   leadId.allowBlank = true;
	                        					   facAppointmentId.setVisible(false);
	                        					   facAppointmentId.allowBlank = true;
	                        					   studentNameField.setVisible(false);
	                        					   studentNameField.allowBlank = true;
	                        					   applicantNameField.setVisible(false);
	                        					   applicantNameField.allowBlank = true;
	                        					   sgForm.down("#cellCountryCode").setEditable(true);
	                        					   var countryCodeFieldArray = ["#cellCountryCode"]
	                        					   this.setDefaultCountryCode(sgForm, countryCodeFieldArray);
	                        					   academyLocationId.setVisible(false);
	                        					   programId.setVisible(false);
	                        					   batchId.setVisible(false);
	                        					   seatTypeId.setVisible(false);
	                        				   }else{
	                        					   appointeeNameField.setVisible(true);
	                        					   appointeeNameField.allowBlank = false;
	                        					   parentNameField.setVisible(false);
	                        					   parentNameField.allowBlank = true;
	                        					   
	                        					   leadId.setVisible(false);
	                        					   leadId.allowBlank = true;
	                        					   facAppointmentId.setVisible(false);
	                        					   facAppointmentId.allowBlank = true;
	                        					   studentNameField.setVisible(false);
	                        					   studentNameField.allowBlank = true;
	                        					   applicantNameField.setVisible(false);
	                        					   applicantNameField.allowBlank = true;
	                        					   academyLocationId.setVisible(false);
	                        					   programId.setVisible(false);
	                        					   batchId.setVisible(false);
	                        					   seatTypeId.setVisible(false);
	                        				   }
	                        				  var visitCatId = record[0].data.id;
	                        				   var reasonForVisitID = sgForm.down("#reasonForVisitID");
	                        				   var reasonForVisitStore=reasonForVisitID.getStore();
	                        				    reasonForVisitStore.getProxy().extraParams = {
	                                 			  id : visitCatId,
	                                 		   };
	                        				   reasonForVisitStore.load();
	                        			   }
	                        		   },
									   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] customcombobox#academyLocationId': {
										   select: function(obj, record) {
											   var this$ = this;
											   var academyLocationField = obj.up('form').down('#academyLocationId');
											   var programComboField = obj.up('form').down('#programId');
											   var batchCombo = obj.up("form").down("#batchId");
											   var seatCombo = obj.up('form').down('#seatTypeId');
											   programComboField.reset();
											   programComboField.setDisabled(false);
											   seatCombo.reset();
											   seatCombo.setDisabled(true);
											   seatCombo.allowBlank = true;
											   batchCombo.reset();
											   batchCombo.setDisabled(true);
											   batchCombo.allowBlank = true;
											   var alValue = academyLocationField.getValue();
											   var visitorId = obj.up('form').down('#visitorCategoryID').getValue();
											   if (visitorId == 5) {
												   var applicationId = obj.up('form').down('#applicantNameId').getValue();
												   programComboField.getStore().getProxy().extraParams = {
													   academyLocationId: alValue,
													   enquiryStudentDetailId: null,
													   applicationId: applicationId
												   }
											   }else if(visitorId == 2){
												   var leadId = obj.up('form').down('#leadId').getValue();
												   var submitUrl = SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL;
												   Ext.Ajax.request({
													   type: 'rest',
													   url: submitUrl,
													   params: {
														   id: leadId,
													   },
													   method: 'GET',
													   async: false,
													   success: function(frm, action) {
														   var data = Ext.JSON.decode(frm.responseText);
														   
														   programComboField.getStore().getProxy().extraParams = {
															   academyLocationId: alValue,
															   enquiryStudentDetailId: data.id,
															   applicationId: null
														   }
													   }
												   });
											   } else if (visitorId == 3) {
												   var studentId = obj.up('form').down('#studentItemId').getValue();
												   programComboField.getStore().getProxy().extraParams = {
													   academyLocationId: alValue,
													   enquiryStudentDetailId: null,
													   applicationId: null,
													   studentId: studentId
												   }
											   } else if (visitorId == 1) {
												   var id = obj.up('form').down("#appointeeNameParentId").getValue();
												   Ext.Ajax.request({
													   method: "GET",
													   type: 'rest',
													   url: SERVERURL.PATH_FIND_PARENT_PERSON_ID,
													   params: {
														   relatedPersonId: id,
													   },
													   headers: {
														   'Content-Type': 'application/json'
													   },
													   success: function(response, action) {
														   var personId = response.responseText ? parseInt(response.responseText) : null;
														   programComboField.getStore().getProxy().extraParams = {
															   academyLocationId: alValue,
															   enquiryStudentDetailId: null,
															   applicationId: null,
															   studentId: personId
														   }
													   }
												   });
											   }
											   this$.loadDFRForManageAppointment(academyLocationField);
											   programComboField.getStore().load();
										   }
									   },   
									   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] customcombobox#programId': {
										   select: function(obj, record) {
											   var this$ = this;
											   var programId = record[0].get("id");
											   var batchCombo = obj.up('form').down('#batchId');
											   var seatCombo = obj.up('form').down('#seatTypeId');
											   batchCombo.reset();
											   batchCombo.setDisabled(false);
											   seatCombo.reset();
											   seatCombo.setDisabled(true);
											   seatCombo.allowBlank = true;
											   var academyLocationId = obj.up('form').down("#academyLocationId");
											   this$.loadDFRForManageAppointment(academyLocationId);
											   var visitorId = obj.up('form').down('#visitorCategoryID').getValue();
											   if (visitorId == 5) {
												   var applicationId = obj.up('form').down('#applicantNameId').getValue();
												   batchCombo.getStore().getProxy().extraParams = {
													   programId: programId,
													   enquiryStudentDetailId: null,
													   applicationId: applicationId
												   }
											   } else if (visitorId == 2) {
												 var leadId = obj.up('form').down('#leadId').getValue();
												   var submitUrl = SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL;
												   Ext.Ajax.request({
													   type: 'rest',
													   url: submitUrl,
													   params: {
														   id: leadId,
													   },
													   method: 'GET',
													   async: false,
													   success: function(frm, action) {
														   var data = Ext.JSON.decode(frm.responseText);
														   
														   batchCombo.getStore().getProxy().extraParams = {
															   programId: programId,
															   enquiryStudentDetailId: data.id,
															   applicationId: null
														   }
													   }
												   });
											   } else if (visitorId == 3) {
												  var studentId = obj.up('form').down('#studentItemId').getValue();
												   batchCombo.getStore().getProxy().extraParams = {
													   programId: programId,
													   enquiryStudentDetailId: null,
													   applicationId: null,
													   studentId: studentId
												   }
											   }else if (visitorId == 1) {
												   var id = obj.up('form').down("#appointeeNameParentId").getValue();
												   Ext.Ajax.request({
													   method: "GET",
													   type: 'rest',
													   url: SERVERURL.PATH_FIND_PARENT_PERSON_ID,
													   params: {
														   relatedPersonId: id,
													   },
													   headers: {
														   'Content-Type': 'application/json'
													   },
													   success: function(response, action) {
														   var personId = response.responseText ? parseInt(response.responseText) : null;
														   batchCombo.getStore().getProxy().extraParams = {
															   programId: programId,
															   enquiryStudentDetailId: null,
															   applicationId: null,
															   studentId: personId
												   }
													   }
												   });
											   }
											   batchCombo.getStore().load();
											   obj.up('form').isValid();
										   }
									   },
									   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] customcombobox#batchId': {
										   select: function(obj, record) {
											   var this$ = this;
											   var batchId = record[0].get("id");
											   var seatCombo = obj.up('form').down('#seatTypeId');
											   seatCombo.reset();
											   seatCombo.setDisabled(false);
											   var academyLocationId = obj.up('form').down("#academyLocationId");
											   this$.loadDFRForManageAppointment(academyLocationId);
											   var visitorId = obj.up('form').down('#visitorCategoryID').getValue();
											   if (visitorId == 5) {
												   var applicationId = obj.up('form').down('#applicantNameId').getValue();
												   seatCombo.getStore().getProxy().extraParams = {
													   batchId: batchId,
													   enquiryStudentDetailId: null,
													   applicationId: applicationId
												   }
											   } else if (visitorId == 2) {
												 var leadId = obj.up('form').down('#leadId').getValue();
												   var submitUrl = SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL;
												   Ext.Ajax.request({
													   type: 'rest',
													   url: submitUrl,
													   params: {
														   id: leadId,
													   },
													   method: 'GET',
													   async: false,
													   success: function(frm, action) {
														   var data = Ext.JSON.decode(frm.responseText);
														   
														   seatCombo.getStore().getProxy().extraParams = {
															   batchId: batchId,
															   enquiryStudentDetailId: data.id,
															   applicationId: null
														   }
													   }
												   });
											   } else if (visitorId == 3) {
												   var studentId = obj.up('form').down('#studentItemId').getValue();
												   seatCombo.getStore().getProxy().extraParams = {
													   batchId: batchId,
													   enquiryStudentDetailId: null,
													   applicationId: null,
													   studentId: studentId
												   }
											   }else if (visitorId == 1) {
												   var id = obj.up('form').down("#appointeeNameParentId").getValue();
												   Ext.Ajax.request({
													   method: "GET",
													   type: 'rest',
													   url: SERVERURL.PATH_FIND_PARENT_PERSON_ID,
													   params: {
														   relatedPersonId: id,
													   },
													   headers: {
														   'Content-Type': 'application/json'
													   },
													   success: function(response, action) {
														   var personId = response.responseText ? parseInt(response.responseText) : null;
														   seatCombo.getStore().getProxy().extraParams = {
															   batchId: batchId,
															   enquiryStudentDetailId: null,
															   applicationId: null,
															   studentId: personId
														   }
													   }
												   });
											   }
											   seatCombo.getStore().load();
											   obj.up('form').isValid();
										   }
									   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#appointeeNameParentId' : {
	                        			   select : function(obj,record){
	                        				   this.getParentDetails();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#studentItemId' : {
	                        			   select : function(obj,record){
	                        				   this.getStudentDetails();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] textfield[itemId=bookingId]' : {
	                        			   blur : function(response) {
	                        				   this.checkUniquenessForBookingId(response);
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] button[itemId=resetBtnForm]': {
	                        			   click: function(){
	                        				   var $this=this;
	                        				   var form = $this.getSgappointmentform();
	                        				   var visitTimeIdfield=form.getForm().findField('visitTime');
	                        				   var expectedOutTimefield=form.getForm().findField('expectedOutTime');
	                        				   
	                        				   visitTimeIdfield.setMaxValue(null);
	                        				   visitTimeIdfield.setMinValue(null);
	                        				   expectedOutTimefield.setMaxValue(null);
	                        				   expectedOutTimefield.setMinValue(null);
	                        				   this.resetSGAppointment(form);
	                        				   this.setEntrybyValuebydefault();	         
	                        				   this.setVisitStatusByDefault();
	                        				   form.getForm().findField('bookingDate').setValue(new Date());
	                        				   var userId=this.getCurrentlyLoggedInUser();
	                        				   var personToMeetId = form.down("#personToMeetId");
	                        				   personToMeetId.store.load({
	                       			    		callback : function(operation,success) {
	                       			    			if (success) {
	                       			    				personToMeetId.setValue(userId.id);
	                       			    			}
	                       			    		} 
	                       			    	});
	                        			   }
	                        		   },
	                        		   'scheduledetails radiogroup[itemId=viewCalendarId]': {
	                        			   change: function(obj,rec) {
	                        				   if(rec.isViewCalendar){
	                        					   this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA);	
	                        				   }else{
	                        					   this.sendCalendarEventsRequest('FACULTY', '#personViewCalendar', SERVERURL.FACULTY_EVENT_DETAILS);
	                        				   }
	                        			   }
	                        		   }, 
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#facAppointmentId' : {
	                        			   select : function(obj,record){
	                        				   this.getfacultyInfoDetails();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#leadId' : {
	                        			   select : function(obj,record){
	                        				   this.getLeadInfoDetails();
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#applicantNameId' : {
	                        			   select : function(obj,record){
	                        				   this.getApplicantInfoDetails();
	                        			   }
	                        		   },
	      	                		 'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#reasonForVisitID': {
	    	                			 select: function(obj,record) {
	    	                				 this.setExpectedOutTime(obj,record);
	    	                			 }
	    	                		 },
	      	                		 'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] timefield[itemId=visitTimeId]': {
	    	                			 change: function(obj,record) {
	    	                				 this.setExpectedOutTime(obj,record);
	    	                			 }
	    	                		 },
	    	                		 'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] customcombobox[itemId=cellCountryCode]': {
	    	                 			select: function(rowModel, record){
	    	                 				var this$ = this;
	    	                             	var personProfile = this$.getContentPanelActiveTab();
	    	                             	var form = personProfile.down('#SGAppointmentRecordFormMainItemId');
	    	                             	var countryCodeField = form.down("#cellCountryCode");
	    	                              	var mobileField = form.down("#mobileNo");
	    	                              	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	    	                 			}
	    	                 		},
	    	                 		'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] numberfield[itemId=mobileNo]': {
	    	                 			change: function(record){
	    	                 				var this$ = this;
	    	                             	var personProfile = this$.getContentPanelActiveTab();
	    	                             	var form = personProfile.down('#SGAppointmentRecordFormMainItemId');
	    	                                 var mobileField = form.down("#mobileNo");
	    	                             	mobileField.isValid();
	    	                     			form.getForm().checkValidity();
	    	                             }
	    	                 		},
	    	                 		
	    	                 		'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] filefield[itemId=documentUploadFile]' : {
	    	                			change: function(DocFile, value, eOpts) {
	    	                				value = value.replace('C:\\fakepath\\', '');
	    	                				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	    	                				DocFile.setRawValue(newValue);
	    	                				var file = DocFile.fileInputEl.dom.files[0];
	    	                				var form = DocFile.up().up();
	    	                				 var documentUploadFile = form.down('#documentUploadFile');
	    	                                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	    	                                    if (!isNullOrEmpty(extension)) { 
    	                                            if (!((extension == "png" || extension == "jpeg" || extension == "jpg" || extension == "pdf" ||  extension == "xlsx" || extension == "docx" || extension == "pptx") && (file.size / 1024) <= 10000)) {
    	                                            	DocFile.reset();
    	                                                showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation('UPLOAD_IMAGE_SIGNATURE')); 
    	                                            }
    	                                            var documentUploadFile = form.down('#documentUploadFile');
    	                                            documentUploadFile.setVisible(true);
    	                                           // docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
    	                                        } 
	    	                                    else {
	    	                                        if ($this.isValidFileExtension(extension)) {
	    	                                            if (file.size / 1024 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT_FOR_STUDENT_DOCUMENT) {
	    	                                            	documentUploadFile.setVisible(false);
	    	                                            	DocFile.reset();
	    	                                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_EXTENDED_ERROR_MSG'));
	    	                                            } else {
	    	                                                var form = DocFile.up().up();
	    	                                                var documentUploadFile = form.down('#documentUploadFile');
	    	                                                documentUploadFile.setVisible(true);
	    	                                                var docDetails = form.down('#docDetails');
	    	                                                docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
	    	                                            }
	    	                                        } else {
	    	                                        	documentUploadFile.setVisible(false);
	    	                                        	DocFile.reset();
	    	                                            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
	    	                                        }
	    	                                    }
	    	                                    
	    	                			}
	    	                		},
	    	                 		
	    	                 		
	    	                 		/*'SGAppointmentForm[itemId=documentUpload] filefield[itemId=uploadFileField]': {
	    	                            change: function(fileField, value, eOpts) {
	    	                                if (!isNullOrEmpty(value)) {
	    	                                    var $this = this;
	    	                                    value = value.replace('C:\\fakepath\\', '');
	    	                                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	    	                                    fileField.setRawValue(newValue);
	    	                                    var file = fileField.fileInputEl.dom.files[0];
	    	                                    var form = fileField.up().up();
	    	                                    var fileInfoContainer = form.down('#fileInfoContainer');
	    	                                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	    	                                    var docDetails = form.down('#docDetails');
	    	                                    var docType = form.down('#documentTypeCombo');
	    	                                    if (docType.getRawValue() == 'Signature') {
	    	                                        if (!isNullOrEmpty(extension)) { 
	    	                                            if (!((extension == "png" || extension == "jpeg" || extension == "jpg") && (file.size / 1024) <= 50)) {
	    	                                                fileField.reset();
	    	                                                showWarningMessage(getCommonTranslation("ALERT"), getPersonModuleTranslation('SIGNATURE_IMAGE_ALERT_MESSAGE'));
	    	                                            }
	    	                                            var fileInfoContainer = form.down('#fileInfoContainer');
	    	                                            fileInfoContainer.setVisible(true);
	    	                                            docDetails.setValue(getPersonModuleTranslation('SIGNATURE_IMAGE_FIELD_MESSAGE'));
	    	                                        }
	    	                                    } else {
	    	                                        if ($this.isValidFileExtension(extension)) {
	    	                                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT_FOR_STUDENT_DOCUMENT) {
	    	                                                fileInfoContainer.setVisible(false);
	    	                                                fileField.reset();
	    	                                                showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_EXTENDED_ERROR_MSG'));
	    	                                            } else {
	    	                                                var form = fileField.up().up();
	    	                                                var fileInfoContainer = form.down('#fileInfoContainer');
	    	                                                fileInfoContainer.setVisible(true);
	    	                                                var docDetails = form.down('#docDetails');
	    	                                                docDetails.setValue("Type: " + extension + " Size: " + (file.size / 1024).toFixed(2) + ' KBs');
	    	                                            }
	    	                                        } else {
	    	                                            fileInfoContainer.setVisible(false);
	    	                                            fileField.reset();
	    	                                            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
	    	                                        }
	    	                                    }
	    	                                }
	    	                            }
	    	                        },*/
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		
	    	                 		'sgstudentappointmentdetailformstructure':{
	    	                 			render:function(structure){
	    	                				var $this = this
	    	                				structure.body.on('click', function() {
	    	                					var form = structure.down('sgappointmentform');
	    	                					$this.hideInvalidIconFromField(form);
	    	                			       });
	    	                			}
	    	                 		},
	    	                 		 'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] combo#reasonForVisitID' : {
	                        			   select : function(obj,record){
	                        				   var userGroupName = record[0].get("code");
	                   	        		    this.enableOrDisableAdditionalReason(userGroupName);
	                        			   }
	                        		   },
	                        		   'sgappointmentform[itemId=SGAppointmentRecordFormMainItemId] datefield[itemId=appointmentId]': {
	    	                			 change: function(obj,record) {
	    	                				 var sgForm=this.getSgappointmentform();
	    	                				 var isAppointeeItemId=sgForm.down("#isAppointeeItemId");
	    	                				 var currentDate = Ext.Date.format(new Date() ,'Y-m-d');
	    	                				 var appointmentDate = Ext.Date.format(record ,'Y-m-d');
	    	                				 if(obj.itemId == 'appointmentId'){
	    	                					 if(currentDate>appointmentDate){
	    	                						 isAppointeeItemId.setValue({isAppointee:false});
	    	                					 }else{
	    	                						 isAppointeeItemId.setValue({isAppointee:true});
	    	                					 }
	    	                				 }
	    	                			 }
	    	                		 },
                                     'sgappointmentgrid button[itemId=followUpDetailBtnId]':{
                                    	 click:function(btn){
                                    		 var $this=this;
                                    		 var grid = this.getSgappointmentgrid();
                                    		 var studentListController = this.getController('Academia.controller.personinfo.student.StudentListController');
                                    		 this.getController('Academia.controller.personinfo.student.StudentPersonalController'); //used for render of studentprofile
                                    		 var record = grid.getSelectionModel().getSelection();
                                    		 if(!isNullOrEmpty(record)){
                                    			 var tabTitle = record[0].data.student.code;
                                    			 var personId = record[0].data.personId;
                                    			 var userId = record[0].data.userId;
                                    			 var admissionId = record[0].data.admissionId;
                                    			 var programBatchSeatTypeConfigId =  record[0].data.programBatchSeatConfigId;
                                    		 }
                                    		 
                                    		 this.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
                                    		 var studentProfile = this.getTabReferenceByTabTitle(tabTitle);
                                    		studentProfile.appointmentId= record[0].data.id
                                    		 var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
                                    		 if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
                                    			 var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
                                    			 studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
                                    		 }
                                    		 
                                    		 Ext.defer(function(){
                                    			 if(!isEmpty(studentLinkPanelObject)){
                                        			 var personalDetailObject=studentLinkPanelObject.APPOINTMENT[1];    	
                                        			 $this.addPersonTabPanel('STUDENT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);
                                        		 }
                                    		 },2000);
                                    	 }
                                     },
                                     "sgappointmentform[itemId=SGAppointmentRecordFormMainItemId]":{
                                    	 afterrender:function(cmp){
                                    		 cmp.down('#flagRadioFld').setVisible(false);
                                    	 }
                                     }
	                        	   });
	                           },
	                           openViewCalendarWin:function(){
	                        	   var $this =this;
	                        	  /* var formWindow = $this.getScheduledetails();
	                        	   if (!formWindow) {
	                        		   Ext.widget('scheduledetails');
	                        		   formWindow = $this.getScheduledetails();
	                        	   }
	                        	   formWindow.show();*/
	                        	   var contentpanel = this.getContentPanel();
	    	                	   var scheduledetails = Ext.widget('scheduledetails');
	    	                	   var tabName = getServiceRequestTranslation('VIEW_CALENDAR');
	    	                	   var personToMeetId = null;

	    	                	   /**
	    	                	    * This is to remove tab from content panel and open same tab again
	    	                	    */
	    	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	    	                	   var getTab=getcontroller.getTab(tabName);
	    	                	   if(getTab!=null){
	    	                		   contentPanel.remove(getTab, true);
	    	                	   }
	    	                	   openTab(contentpanel, tabName, scheduledetails,contentpanel.activeTab.menuColorCls);	
	                        	   //var sgForm=$this.getSgappointmentform();
								    var sgForm= Ext.ComponentQuery.query('sgappointmentform')[0];
								   
	                        	   //var personToMeetId=sgForm.down("#personToMeetId").getValue();
	                        	   var id=sgForm.down("#id").getValue();
	                        	  
	                        	   var appointmentDateId=sgForm.down("#appointmentId").getValue();
	                        	   if(isNullOrEmpty(id)){
	                             	   personToMeetId=sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
	                        	   }else{
	                        		  var facultyName= sgForm.down("#personToMeetId").getRawValue();
	                        		  var records=sgForm.down("#personToMeetId").getStore().data.items;
	                        		  for(var i in sgForm.down("#personToMeetId").getStore().data.items){
		                					 if(records[i].data.valueCode==facultyName){
		                						 personToMeetId=records[i].data.id;
		                					 }
	                					 }
	                        	   }
	                        	  
	                        	   var personProfile = this.getContentPanelActiveTab();
	                               var calendar = personProfile.down('#personViewCalendar');
	                               var params = new Object();
	                               calendar.eventStore.getProxy().actionMethods.read = 'GET';
	                               params.facultyId = personToMeetId;
	                               calendar.eventStore.removeAll();
	                               calendar.eventStore.getProxy().url = SERVERURL.RESOURCE_BOOKING_GET_FACULTY_CALENDAR_DATA;
	                               calendar.eventStore.getProxy().extraParams = params;
	                               calendar.eventStore.load();
	                           },
	                           setEntrybyValuebydefault : function() {
	                        	   var userId=this.getCurrentlyLoggedInUser();
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var entryByField = sgForm.down("#entryById");
	                        	   entryByField.store.load({
	                        		   callback : function(operation,success) {
	                        			   if (success) {
	                        				   entryByField.setValue(userId.id);
	                        			   }
	                        		   } 
	                        	   });
	                           },
	                           setVisitStatusByDefault: function(){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var viewStatusID = sgForm.down("#viewStatusID");
	                    		   var viewStatusIDStore = viewStatusID.getStore();
	                    		   viewStatusID.setReadOnly(true);
	                    		   viewStatusIDStore.load({
	                    			   callback:function(records,operation,success){
	                    				   var rec = viewStatusIDStore.findRecord('code','Booked');
	                    				   if(!isNullOrEmpty(rec)){
	                    					   var idVal = rec.get('id');
	                    					   viewStatusID.setValue(idVal);
	                    				   }
	                    			   }
	                    		   });  
	                    		  
	                    		   sgForm.down("#appointmentId").setValue(new Date());
	                           },
	                           checkUniquenessForBookingId : function(response) {
	                        	   var $this = this;
	                        	   var grid = $this.getSgappointmentgrid();
	                        	   var sgForm=$this.getSgappointmentform();
	                        	   var bookingId=sgForm.down("#bookingId").getValue();
	                        	   Ext.Ajax.request({
	                        		   method : "GET",
	                        		   type : 'rest',
	                        		   url : SERVERURL.SG_CHECK_BOOKING_ID,
	                        		   params : {
	                        			   bookingId : bookingId,
	                        		   },
	                        		   headers : {
	                        			   'Content-Type' : 'application/json'
	                        		   },
	                        		   success : function(resp, action) {
	                        			   var flag= resp.responseText;
	                        			   if (flag=="false") {
	                        				   if (grid.getSelectionModel().getCount() > 0) {
		                        				   /*howWarningMessage(
		                        						   getCommonTranslation('ALERT'),
		                        						   getServiceRequestTranslation('BOOKING_ID_ALLREADY_EXIST'));
	                        				  */ } else{
	                        				   showWarningMessage(
	                        						   getCommonTranslation('ALERT'),
	                        						   getServiceRequestTranslation('BOOKING_ID_ALLREADY_EXIST'));
	                        				   sgForm.down("#bookingId").reset();
	  	                					 }

	                        			   }
	                        		   }
	                        	   });
	                           },
	                           getParentDetails : function(){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var id=sgForm.down("#appointeeNameParentId").getValue();
	                        	   var mobileField = sgForm.down("#mobileNo");
	                        	   var countryCodeField=sgForm.down("#cellCountryCode");
	                               this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

	                        	   var emailId = sgForm.down("#appointeeEmailItemId");
	                        	   Ext.Ajax
	                        	   .request({
	                        		   method : "GET",
	                        		   type : 'rest',
	                        		   url : SERVERURL.SG_PARENT_GUARDIAN_DETAILS,
	                        		   params : {
	                        			   id : id,
	                        		   },
	                        		   headers : {
	                        			   'Content-Type' : 'application/json'
	                        		   },
	                        		   success : function(response, action) {
	                        			   var data=Ext.decode(response.responseText);
	                        			   if(Ext.isDefined(data[0])){
	                        				   countryCodeField.setValue(data[0].code);
	                        				   mobileField.setValue(data[0].mobileNo);
	                        				   emailId.setValue(data[0].emailId); 
	                        			   }
	                        		   }
	                        	   });
	                        	    Ext.Ajax
	                        	   .request({
	                        		   method : "GET",
	                        		   type : 'rest',
	                        		   url : SERVERURL.PATH_FIND_PARENT_PERSON_ID,
	                        		   params : {
	                        			   relatedPersonId : id,
	                        		   },
	                        		   headers : {
	                        			   'Content-Type' : 'application/json'
	                        		   },
	                        		   success : function(response, action) {
	                        			  var userId = response.responseText ? parseInt(response.responseText) : null;
										   if (id != null) {
											   var academyLocation = sgForm.down("#academyLocationId");
											   academyLocation.setDisabled(false);
											   var store = academyLocation.getStore();
											   store.getProxy().extraParams = {
												   enquiryStudentDetailId: null,
												   applicationId: null,
												   studentId: userId
											   };
											   store.load();
										   } else {
											   academyLocation.setDisabled(true);
										   }
	                        		   }
	                        	   });
	                           },
	                           getStudentDetails : function(){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var id=sgForm.down("#studentItemId").getValue();
	                        	   var mobileField = sgForm.down("#mobileNo");
	                        	   var countryCodeField=sgForm.down("#cellCountryCode");
	                        	   var emailId = sgForm.down("#appointeeEmailItemId");
	              				 this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

	                        	   Ext.Ajax
	                        	   .request({
	                        		   method : "GET",
	                        		   type : 'rest',
	                        		   url : SERVERURL.FIND_STUDENT_PERSONAL_INFORMATION_DETAILS,
	                        		   params : {
	                        			   id : id,
	                        		   },
	                        		   headers : {
	                        			   'Content-Type' : 'application/json'
	                        		   },
	                        		   success : function(response, action) {
	                        			   var data=Ext.decode(response.responseText);
	                        			   countryCodeField.setValue(data.mobileCountryCode);
	                        			   mobileField.setValue(data.mobileNumber);
	                        			   emailId.setValue(data.emailId);
	                        			   countryCodeField.setReadOnly(true);
	                        			   mobileField.setReadOnly(true);
	                        			   emailId.setReadOnly(true);
										   if (id != null) {
											   var academyLocation = sgForm.down("#academyLocationId");
											   academyLocation.setDisabled(false);
											   var store = academyLocation.getStore();
											   store.getProxy().extraParams = {
												   enquiryStudentDetailId: null,
												   applicationId: null,
												   studentId: id
											   };
											   store.load();
										   } else {
											   academyLocation.setDisabled(true);
										   }
									   }
	                        	   });
	                           },

	                           getReasonToMeetGridWindow : function(grid,record){
	                        	   var frmWin = this.getSgreasontomeetgridwin();
	                        	   if(!frmWin){
	                        		   Ext.widget('sgreasontomeetgridwin');
	                        		   frmWin = this.getSgreasontomeetgridwin();
	                        	   }
	                        	   frmWin.show();
	                        	   var resonField=frmWin.down('#reasonMeetItemId')
	                        	   resonField.setValue(record.data.reasonToVisit);
	                           },
	                           loadSGAppointmentGrid:function(){
	                        	   var $this=this;
	                        	   var grid = $this.getSgappointmentgrid();
	                        	   var sgFilter=this.getSgappointmentfilter();
	                        	   var sgFilterValues=sgFilter.getValues();
	                        	   var personMeetRawValue=sgFilter.down('#personToMeetFilterItemId').getRawValue();
	                        	   var store=grid.getStore();
	                        	   store.getProxy().extraParams = {
	                        		   bookingID:sgFilterValues.bookingID,
	                        		   appointeeName:sgFilterValues.appointeeName,
	                        		   personTomeet:personMeetRawValue,
	                        		   appointmentFromDate:sgFilterValues.appointmentFromDate,
	                        		   appointmentToDate:sgFilterValues.appointmentToDate,
	                        		   academyLocationIds:this.getCurrentAcademyLocation()
	                        	   };
	                        	   $this.resetPageSetting(store);
	                        	   store.load();
	                        	   grid.config.searchFilterForm = sgFilter;

	                           }, 
	                           resetSGAppointment:function(form){
	                        	   form.getForm().reset();
	                        	   var visitTimeField = form.down('#visitTimeId');
	                        	   var outTimeField = form.down('#outTimeId');
	                        	   visitTimeField.setMinValue(false);
	                        	   outTimeField.setMinValue(false);
	                        	   visitTimeField.setMaxValue(false);
	                        	   outTimeField.setMaxValue(false);
	                        	   
	                           },
	                           deleteSGAppointmentRecord:function(){
	                        	   var $this=this;
	                        	   var grid = $this.getSgappointmentgrid();
	                        	   if (grid.getSelectionModel().getCount() > 0) {
	                        		   showConfirmMessage(getServiceRequestTranslation('SG_APPOINTMENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                        			   if (btn == 'yes') {
	                        				   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                        				   var records = grid.getSelectionModel().getSelection();
	                        				   var id = records[0].get("id");
	                        				   Ext.Ajax.request({
	                        					   method : "DELETE",
	                        					   type : 'rest',
	                        					   url : SERVERURL.SG_APPOINTMENT_DELETE+'?id='+ id,
	                        					   headers : {
	                        						   'Content-Type' : 'application/json'
	                        					   },
	                        					   success : function(form,action) {
	                        						   Ext.getBody().unmask();
	                        						   showSuccessMessage(getServiceRequestTranslation('SG_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_DELETE_SUCCESS_MSG'));
	                        						  // $this.resetPageSetting(store);
	                        						   grid.getStore().reload();
	                        						   grid.getSelectionModel().deselectAll();
	                        					   }

	                        				   });
	                        			   }
	                        		   });
	                        	   }else {
	                        		   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                        	   }
	                           },
	                           addSGAppointmentRecord:function(openView, submitPortal){
	                        	   $this = this;
	                        	   var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
	                        	   var structure = Ext.widget('sgappointmentform', {
	                        		   itemId : 'SGAppointmentRecordFormMainItemId'
	                        	   });
	                        	   var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
	                        	   /**
	                        	    * This is to remove tab from content panel and open same tab again
	                        	    */
	                        	   var getcontroller=$this.getController('menu.CoreERPNavigationController');
	                        	   var getTab=getcontroller.getTab(tabName);
	                        	   if(getTab!=null){
	                        		   contentPanel.remove(getTab, true);
	                        	   }
	                        	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
	                        	   var sgForm = $this.getSgappointmentform();
	                        	   sgForm.down("#academyLocationId").setVisible(false);
	                        	   sgForm.down("#academyLocationId").setDisabled(true);
	                        	   sgForm.down("#programId").setVisible(false);
	                        	   sgForm.down("#batchId").setVisible(false);
	                        	   sgForm.down("#seatTypeId").setVisible(false);
	                        	   if(openView == 'ADD'){
	                        		   var portalId = $this.getCurrentLoggedPortalId();
	                        		   var submitPortalData = sgForm.down("#submitPortalId");
	                        		   submitPortalData.setValue(portalId);
	                        		   submitPortalData.resetOriginalValue();
	                        		   sgForm.down('#viewCalendar').setDisabled(true);
	                        		   var reasonForVisitID = sgForm.down("#reasonForVisitID");
	                        		   var reasonForVisitStore=reasonForVisitID.getStore();
	                        		   var visitCatId=null;
	                        		   reasonForVisitStore.getProxy().extraParams = {
	                             			  id : visitCatId,
	                             		   };
                   				        reasonForVisitStore.load();
                   			   
	                        	   }
	                           },
	                           editAppointmentRecord:function(){

	                        	   var $this=this;
	                        	   var grid = $this.getSgappointmentgrid();
	                        	   if (grid.getSelectionModel().getCount() > 0) {
	                        		   
	                        		   var record=grid.getSelectionModel().getSelection()[0];
	                        		   this.addSGAppointmentRecord();
	                        		   var sgForm=this.getSgappointmentform();
	                        		   var dataModel=new Academia.model.sgappointment.sgappointment.SGAppointmentModel(record.data);
	                        		   sgForm.loadRecord(dataModel);
	                        		   if(record.raw.document && record.raw.document.path!='file'){
	                                       sgForm.down("#pathId").documentId = record.raw.document.encryptedDocId;
	                                       sgForm.down("#pathId").setValue('<a href="#">' + record.raw.document.path + '</a>');
	                                       }else{
	                                         sgForm.down("#pathId").documentId = null;
	                                          sgForm.down("#pathId").setValue(null);
	                                      }
	                        		   sgForm.down("#visitTimeId").setValue(timeRender(record.data.visitTime));
	                        		   sgForm.down("#outTimeId").setValue(timeRender(record.data.expectedOutTime));
	                        		   sgForm.down("#bookingDateId").setValue(dateRender(record.data.bookingDate));
	                        		   sgForm.down("#appointmentId").setValue(dateRender(record.data.appointmentDate));
	                        		   
	                        		   var isAppointeeItemId =  sgForm.down("#isAppointeeItemId");
	                        		   isAppointeeItemId.setValue({isAppointee:record.data.isAppointeeAppointment});

	                        		   var personToMeetId = sgForm.down("#personToMeetId");
	      	                		   personToMeetId.setFieldStyle('color:black');
									   
	                        		   var visitorCategory=sgForm.down("#visitorCategoryID");
	                        		   if(record.data.visitorCategory != null){
	                        			   visitorCategory.store.load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
	                        						   visitorCategory.setValue(record.data.visitorCategory.id);
	                        					   }
	                        				   }
	                        			   });
	                        		   }
	                        		   if (!isNullOrEmpty(record.data.application) || !isNullOrEmpty(record.data.student) ||
	                        		   !isNullOrEmpty(record.data.enquiry) || !isNullOrEmpty(record.data.person)) {
		                                  $this.loadDFRForManageAppointment(academyLocationId);
	                                   }
	                                   var academyLocationId = sgForm.down("#academyLocationId");
									   var programId = sgForm.down("#programId");
									   var batchId = sgForm.down("#batchId");
									   var seatTypeId = sgForm.down("#seatTypeId");
									   
	                        		   var entryByField = sgForm.down("#entryById");
	                        		   var entryByNameItem = sgForm.down("#entryByNameItemId");
	                        		  // entryByField.setReadOnly(true);
	                        		   if(record.data.submitPortalId == 1){
	                        			   entryByNameItem.setVisible(false);
	                        			   entryByField.setVisible(true);
	                        			   $this.setAllowBlank(entryByField,true);
	                        			   if(record.data.entryBy != null){
	                        				   entryByField.store.getProxy().extraParam = {
	                        					   academyLocationIds:this.getCurrentAcademyLocation()
	                        				   }
	                        				   entryByField.store.load({
	                        					   callback : function(records,operation,success) {
	                        						   if (success) {
	                        							   entryByField.setValue(record.data.entryBy.id);
	                        						   }
	                        					   }
	                        				   });
	                        			   }	                        			   
	                        		   }else{
	                        			   entryByNameItem.setVisible(true);
	                        			   entryByNameItem.setReadOnly(true);
	                        			   entryByField.setVisible(false);
	                        			   $this.setAllowBlank(entryByField,true);
	                        			   entryByNameItem.setValue(record.data.appointeeName);  
	                        		   }
	                        		   
	                        		   var personToMeetId = sgForm.down("#personToMeetId");
	                        		   if(record.data.personToMeet != null){
	                        			   personToMeetId.store.getProxy().extraParam = {
	                        				   academyLocationIds:this.getCurrentAcademyLocation()
	                        			   }
	                        			   personToMeetId.store.load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
	                        						   //personToMeetId.setRawValue(record.data.personToMeet);
	                        						   if(!isNullOrEmpty(record.data.personToMeetId)){
	                        							   personToMeetId.setValue(record.data.personToMeetId.id);
	                        						   }
	                        					   }
	                        				   }
	                        			   });
	                        		   }
	                        		   var appointeeNameField=sgForm.getForm().findField('appointeeName');
	                        		   var leadNameField=sgForm.down("#leadId");
	                        		   var parentGuardian=sgForm.down("#appointeeNameParentId");
	                        		   var empNameField = sgForm.down('#facAppointmentId');
	                        		   var studentNameField=sgForm.down("#studentItemId");
	                        		   var applicantNameField = sgForm.down('#applicantNameId');
	                        		   if(record.data.visitorCategory.id == 1){
	                        			   leadNameField.allowBlank = true;
	                        			   parentGuardian.store.load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
	                        						   parentGuardian.setValue(record.data.person.id);
	                        					   }
	                        				   }
	                        			   });
	                        			   parentGuardian.setVisible(true);
	                        			   appointeeNameField.setVisible(false);
	                        			   appointeeNameField.allowBlank = true;
	                        			   studentNameField.setVisible(false);
	                        			   studentNameField.allowBlank = true;
	                        			   empNameField.setVisible(false);
	                        			   empNameField.setReadOnly(true);
	                        			   empNameField.allowBlank = true;
	                        			   applicantNameField.setVisible(false);
	                        			   applicantNameField.setReadOnly(false);
	                        			   applicantNameField.allowBlank = true;

										   Ext.Ajax.request({
											   method: "GET",
											   type: 'rest',
											   url: SERVERURL.PATH_FIND_PARENT_PERSON_ID,
											   params: {
												   relatedPersonId: record.data.person.id,
											   },
											   headers: {
												   'Content-Type': 'application/json'
											   },
											   success: function(response, action) {
												   var personId = response.responseText ? parseInt(response.responseText) : null;
												   academyLocationId.getStore().getProxy().extraParams = {
													   enquiryStudentDetailId: null,
													   applicationId: null,
													   studentId: personId
												   }
												   if (record.data.academyLocation != null) {
													   academyLocationId.setDisabled(false);
													   programId.setDisabled(false);
													   academyLocationId.store.load({
														   callback: function(recordss, operation, success) {
															   if (success) {
																   for (i in recordss) {
																	   if (recordss[i].data.id == record.data.academyLocation.id) {
																		   academyLocationId.setValue(recordss[i].data.id);
																	   }
																   }
															   }
														   }
													   });

													   programId.getStore().getProxy().extraParams = {
														   academyLocationId: record.data.academyLocation.id,
														   enquiryStudentDetailId: null,
														   applicationId: null,
														   studentId: personId
													   }
													   if (record.data.program != null) {
														   batchId.setDisabled(false);
														   programId.getStore().load({
															   callback: function(recordss, operation, success) {
																   if (success) {
																	   for (i in recordss) {
																		   if (recordss[i].data.id == record.data.program.id) {
																			   programId.setValue(recordss[i].data.id);
																		   }
																	   }
																   }
															   }
														   });

														   batchId.getStore().getProxy().extraParams = {
															   programId: record.data.program.id,
															   enquiryStudentDetailId: null,
															   applicationId: null,
															   studentId: personId
														   }
														   if (record.data.batch != null) {
															   seatTypeId.setDisabled(false);
															   batchId.getStore().load({
																   callback: function(recordss, operation, success) {
																	   if (success) {
																		   for (i in recordss) {
																			   if (recordss[i].data.id == record.data.batch.id) {
																				   batchId.setValue(recordss[i].data.id);
																			   }
																		   }
																	   }
																   }
															   });
															   seatTypeId.getStore().getProxy().extraParams = {
																   batchId: record.data.batch.id,
																   enquiryStudentDetailId: null,
																   applicationId: null,
																   studentId: personId
															   }
															   if (record.data.progBatchSeatConfig != null) {
																   seatTypeId.getStore().load({
																	   callback: function(recordss, operation, success) {
																		   if (success) {
																			   for (i in recordss) {
																				   if (recordss[i].data.id == record.data.progBatchSeatConfig.id) {
																					   seatTypeId.setValue(recordss[i].data.id);
																				   }
																			   }
																		   }
																	   }
																   });
															   }
														   } else {
															   seatTypeId.setDisabled(true);
															   seatTypeId.allowBlank = true;
														   }
													   } else {
														   batchId.setDisabled(true);
														   batchId.allowBlank = true;
														   seatTypeId.setDisabled(true);
														   seatTypeId.allowBlank = true;
													   }
												   } else {
													   programId.setDisabled(true);
													   programId.allowBlank = true;
													   batchId.setDisabled(true);
													   batchId.allowBlank = true;
													   seatTypeId.setDisabled(true);
													   seatTypeId.allowBlank = true;
												   }
											   }
										   });
	                        		   }else if(record.data.visitorCategory.id == 2){
										   leadNameField.store.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   leadNameField.setValue(record.data.enquiry.id);
												   }
											   }
										   });
										   leadNameField.setVisible(true);
										   leadNameField.setReadOnly(true);
										   appointeeNameField.setVisible(false);
										   appointeeNameField.allowBlank = true;
										   parentGuardian.setVisible(false);
										   parentGuardian.allowBlank = true;
										   studentNameField.setVisible(false);
										   studentNameField.allowBlank = true;
										   visitorCategory.setReadOnly(true);
										   empNameField.setVisible(false);
										   empNameField.setReadOnly(true);
										   empNameField.allowBlank = true;
										   applicantNameField.setVisible(false);
										   applicantNameField.setReadOnly(false);
										   applicantNameField.allowBlank = true;

										   var submitUrl = SERVERURL.ENQUIRY_DETAIL_FIND_BY_ID;
										   Ext.Ajax.request({
											   type: 'rest',
											   url: submitUrl,
											   params: {
												   id: record.data.enquiry.id,
											   },
											   method: 'GET',
											   async: false,
											   success: function(frm, action) {
												   var data = Ext.JSON.decode(frm.responseText);
												   if (data.enquiryType.code == "Corporate" || data.enquiryType.value == "Corporate" ||
													   data.enquiryType.code == "Counselling" || data.enquiryType.value == "Counselling") {
													   academyLocationId.setVisible(false);
													   programId.setVisible(false);
													   batchId.setVisible(false);
													   seatTypeId.setVisible(false);
													   academyLocationId.allowBlank = true;
													   programId.allowBlank = true;
													   batchId.allowBlank = true;
													   seatTypeId.allowBlank = true;
												   } else {
													   var submitUrl = SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL;
													   Ext.Ajax.request({
														   type: 'rest',
														   url: submitUrl,
														   params: {
															   id: record.data.enquiry.id,
														   },
														   method: 'GET',
														   async: false,
														   success: function(frm, action) {
															   var res = Ext.JSON.decode(frm.responseText);
															   var enquiryStudentDetailId = res.id;
															   academyLocationId.getStore().getProxy().extraParams = {
																   enquiryStudentDetailId: enquiryStudentDetailId,
																   applicationId: null
															   }
															   if (record.data.academyLocation != null) {
																   academyLocationId.setDisabled(false);
																   programId.setDisabled(false);
																   academyLocationId.store.load({
																	   callback: function(records, operation, success) {
																		   var matchedId = null;
																		   for (var i in records) {
																			   if (records[i].data.id == record.data.academyLocation.id) {
																				   matchedId = records[i].data.id;
																				   break;
																			   }
																		   }
																		   if (matchedId != null) {
																			   academyLocationId.setValue(records[i].data.id);
																		   } else {
																			   academyLocationId.setValue(null);
																			   programId.setDisabled(true);
																			   programId.allowBlank = true;
																			   batchId.setDisabled(true);
																			   batchId.allowBlank = true;
																			   seatTypeId.setDisabled(true);
																			   seatTypeId.allowBlank = true;
																		   }
																	   }
																   });

																   programId.getStore().getProxy().extraParams = {
																	   academyLocationId: record.data.academyLocation.id,
																	   enquiryStudentDetailId: enquiryStudentDetailId,
																	   applicationId: null
																   }
																   if (record.data.program != null) {
																	   batchId.setDisabled(false);
																	   programId.getStore().load({
																		   callback: function(records, operation, success) {
																			   var matchedId = null;
																			   for (var i in records) {
																				   if (records[i].data.id == record.data.program.id) {
																					   matchedId = records[i].data.id;
																					   break;
																				   }
																			   }
																			   if (matchedId != null) {
																				   programId.setValue(records[i].data.id);
																			   } else {
																				   programId.setValue(null);
																				   batchId.setDisabled(true);
																				   batchId.allowBlank = true;
																				   seatTypeId.setDisabled(true);
																				   seatTypeId.allowBlank = true;
																			   }
																		   }
																	   });

																	   batchId.getStore().getProxy().extraParams = {
																		   programId: record.data.program.id,
																		   enquiryStudentDetailId: enquiryStudentDetailId,
																		   applicationId: null
																	   }
																	   if (record.data.batch != null) {
																		   seatTypeId.setDisabled(false);
																		   batchId.getStore().load({
																			   callback: function(records, operation, success) {
																				   var matchedId = null;
																				   for (var i in records) {
																					   if (records[i].data.id == record.data.batch.id) {
																						   matchedId = records[i].data.id;
																						   break;
																					   }
																				   }
																				   if (matchedId != null) {
																					   batchId.setValue(records[i].data.id);
																				   } else {
																					   batchId.setValue(null);
																					   seatTypeId.setDisabled(true);
																					   seatTypeId.allowBlank = true;
																				   }
																			   }
																		   });
																		   seatTypeId.getStore().getProxy().extraParams = {
																			   batchId: record.data.batch.id,
																			   enquiryStudentDetailId: enquiryStudentDetailId,
																			   applicationId: null
																		   }
																		   if (record.data.progBatchSeatConfig != null) {
																			   seatTypeId.getStore().load({
																				   callback: function(records, operation, success) {
																					   var matchedId = null;
																					   for (var i in records) {
																						   if (records[i].data.id == record.data.progBatchSeatConfig.id) {
																							   matchedId = records[i].data.id;
																							   break;
																						   }
																					   }
																					   if (matchedId != null) {
																						   seatTypeId.setValue(records[i].data.id);
																					   } else {
																						   seatTypeId.setValue(null);
																					   }
																				   }
																			   });
																		   }
																	   } else {
																		   seatTypeId.setDisabled(true);
																		   seatTypeId.allowBlank = true;
																	   }
																   } else {
																	   batchId.setDisabled(true);
																	   batchId.allowBlank = true;
																	   seatTypeId.setDisabled(true);
																	   seatTypeId.allowBlank = true;
																   }
															   } else {
																   programId.setDisabled(true);
																   programId.allowBlank = true;
																   batchId.setDisabled(true);
																   batchId.allowBlank = true;
																   seatTypeId.setDisabled(true);
																   seatTypeId.allowBlank = true;
															   }
														   }
													   });
												   }
											   }
										   });
	                        		   }else if(record.data.visitorCategory.id == 3){
	                        			   studentNameField.getStore().getProxy().extraParams = {
	                        				   studentNameOrCode : record.data.student.code,
	                              		   };
	                        			   studentNameField.store.load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
													   for (i in records) {
														   if (records[i].data.id == record.data.student.id) {
															   studentNameField.setValue(records[i].data.id);
														   }
													   }
	                        					   }
	                        				   }
	                        			   });
	                        			   studentNameField.setVisible(true);
	                        			   studentNameField.allowBlank = false;
	                        			   studentNameField.setReadOnly(true);
	                        			   leadNameField.setVisible(false);
	                        			   leadNameField.setReadOnly(true);
	                        			   leadNameField.allowBlank = true;
	                        			   appointeeNameField.setVisible(false);
	                        			   appointeeNameField.allowBlank = true;
	                        			   parentGuardian.setVisible(false);
	                        			   parentGuardian.allowBlank = true;
	                        			   visitorCategory.setReadOnly(true);
	                        			   empNameField.setVisible(false);
	                        			   empNameField.setReadOnly(true);
	                        			   empNameField.allowBlank = true;
	                        			   applicantNameField.setVisible(false);
	                        			   applicantNameField.setReadOnly(false);
	                        			   applicantNameField.allowBlank = true;
	                        			   
										   academyLocationId.getStore().getProxy().extraParams = {
											   enquiryStudentDetailId: null,
											   applicationId: null,
											   studentId: record.data.student.id
										   }
										   if (record.data.academyLocation != null) {
											   academyLocationId.setDisabled(false);
											   programId.setDisabled(false);
											   academyLocationId.store.load({
												   callback: function(recordss, operation, success) {
													   if (success) {
														   for (i in recordss) {
															   if (recordss[i].data.id == record.data.academyLocation.id) {
																   academyLocationId.setValue(recordss[i].data.id);
															   }
														   }
													   }
												   }
											   });

											   programId.getStore().getProxy().extraParams = {
												   academyLocationId: record.data.academyLocation.id,
												   enquiryStudentDetailId: null,
												   applicationId: null,
												   studentId: record.data.student.id
											   }
											   if (record.data.program != null) {
												   batchId.setDisabled(false);
												   programId.getStore().load({
													   callback: function(recordss, operation, success) {
														   if (success) {
															   for (i in recordss) {
																   if (recordss[i].data.id == record.data.program.id) {
																	   programId.setValue(recordss[i].data.id);
																   }
															   }
														   }
													   }
												   });

												   batchId.getStore().getProxy().extraParams = {
													   programId: record.data.program.id,
													   enquiryStudentDetailId: null,
													   applicationId: null,
													   studentId: record.data.student.id
												   }
												   if (record.data.batch != null) {
													   seatTypeId.setDisabled(false);
													   batchId.getStore().load({
														   callback: function(recordss, operation, success) {
															   if (success) {
																   for (i in recordss) {
																	   if (recordss[i].data.id == record.data.batch.id) {
																		   batchId.setValue(recordss[i].data.id);
																	   }
																   }
															   }
														   }
													   });
													   seatTypeId.getStore().getProxy().extraParams = {
														   batchId: record.data.batch.id,
														   enquiryStudentDetailId: null,
														   applicationId: null,
														   studentId: record.data.student.id
													   }
													   if (record.data.progBatchSeatConfig != null) {
														   seatTypeId.getStore().load({
															   callback: function(recordss, operation, success) {
																   if (success) {
																	   for (i in recordss) {
																		   if (recordss[i].data.id == record.data.progBatchSeatConfig.id) {
																			   seatTypeId.setValue(recordss[i].data.id);
																		   }
																	   }
																   }
															   }
														   });
													   }
												   } else {
													   seatTypeId.setDisabled(true);
													   seatTypeId.allowBlank = true;
												   }
											   } else {
												   batchId.setDisabled(true);
												   batchId.allowBlank = true;
												   seatTypeId.setDisabled(true);
												   seatTypeId.allowBlank = true;
											   }
										   } else {
											   programId.setDisabled(true);
											   programId.allowBlank = true;
											   batchId.setDisabled(true);
											   batchId.allowBlank = true;
											   seatTypeId.setDisabled(true);
											   seatTypeId.allowBlank = true;
										   }
	                        		   }else if(record.data.visitorCategory.id == 4){
	                        			   empNameField.getStore().load({
	                    				   callback : function(records,operation,success) {
	                    					   if (success) {
	                    						   empNameField.setValue(record.data.staff.id);
	                    					   }
	                    				   }
	                    			   });
	                        			   empNameField.setVisible(true);
	                        			   empNameField.setReadOnly(true);
	                        			   leadNameField.setVisible(false);
	                        			   leadNameField.setReadOnly(false);
	                        			   leadNameField.allowBlank = true;
	                        			   appointeeNameField.setVisible(false);
	                        			   appointeeNameField.allowBlank = true;
	                        			   parentGuardian.setVisible(false);
	                        			   parentGuardian.allowBlank = true;
	                        			   studentNameField.setVisible(false);
	                        			   studentNameField.allowBlank = true;
	                        			   visitorCategory.setReadOnly(true);
	                        			   applicantNameField.setVisible(false);
	                        			   applicantNameField.allowBlank = true;
	                        		   }else if(record.data.visitorCategory.id == 5){
	                        			   applicantNameField.getStore().getProxy().extraParams = {
	                        				   codeOrName : record.data.application.code,
	                              		   };
	                        			   applicantNameField.getStore().load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
	                        						   applicantNameField.setValue(record.data.application.id);
	                        					   }
	                        				   }
	                        			   });
	                        			   applicantNameField.setVisible(true);
	                        			   applicantNameField.setReadOnly(true);
	                        			   applicantNameField.allowBlank = false;
	                        			   
	                        			   empNameField.setVisible(false);
	                        			   empNameField.setReadOnly(false);
	                        			   empNameField.allowBlank = true;
	                        			   leadNameField.setVisible(false);
	                        			   leadNameField.setReadOnly(false);
	                        			   leadNameField.allowBlank = true;
	                        			   appointeeNameField.setVisible(false);
	                        			   appointeeNameField.allowBlank = true;
	                        			   parentGuardian.setVisible(false);
	                        			   parentGuardian.allowBlank = true;
	                        			   studentNameField.setVisible(false);
	                        			   studentNameField.allowBlank = true;
	                        			   visitorCategory.setReadOnly(true);
	                        			   
										   academyLocationId.getStore().getProxy().extraParams = {
											   enquiryStudentDetailId: null,
											   applicationId: record.data.application.id
										   }

										   if (record.data.academyLocation != null) {
											   academyLocationId.setDisabled(false);
											   programId.setDisabled(false);
											   academyLocationId.store.load({
												   callback: function(recordss, operation, success) {
													   if (success) {
														   var matchedId = null;
														   for (i in recordss) {
															   if (recordss[i].data.id == record.data.academyLocation.id) {
																   matchedId = recordss[i].data.id;
																   break;
															   }
														   }
														   if (matchedId != null) {
															   academyLocationId.setValue(recordss[i].data.id);
														   } else {
															   academyLocationId.setValue(null);
															   programId.setDisabled(true);
															   programId.allowBlank = true;
															   batchId.setDisabled(true);
															   batchId.allowBlank = true;
															   seatTypeId.setDisabled(true);
															   seatTypeId.allowBlank = true;
														   }
													   }
												   }
											   });

											   programId.getStore().getProxy().extraParams = {
												   academyLocationId: record.data.academyLocation.id,
												   enquiryStudentDetailId: null,
												   applicationId: record.data.application.id
											   }
											   if (record.data.program != null) {
												   batchId.setDisabled(false);
												   programId.getStore().load({
													   callback: function(recordss, operation, success) {
														   if (success) {
															   var matchedId = null;
															   for (i in recordss) {
																   if (recordss[i].data.id == record.data.program.id) {
																	   matchedId = recordss[i].data.id;
																	   break;
																   }
															   }
															   if (matchedId != null) {
																   programId.setValue(recordss[i].data.id);
															   } else {
																   programId.setValue(null);
																   batchId.setDisabled(true);
																   batchId.allowBlank = true;
																   seatTypeId.setDisabled(true);
																   seatTypeId.allowBlank = true;
															   }
														   }
													   }
												   });

												   batchId.getStore().getProxy().extraParams = {
													   programId: record.data.program.id,
													   enquiryStudentDetailId: null,
													   applicationId: record.data.application.id
												   }
												   if (record.data.batch != null) {
													   seatTypeId.setDisabled(false);
													   batchId.getStore().load({
														   callback: function(recordss, operation, success) {
															   if (success) {
																   var matchedId = null;
																   for (i in recordss) {
																	   if (recordss[i].data.id == record.data.batch.id) {
																		   matchedId = recordss[i].data.id;
																		   break;
																	   }
																   }
																   if (matchedId != null) {
																	   batchId.setValue(recordss[i].data.id);
																   } else {
																	   batchId.setValue(null);
																	   seatTypeId.setDisabled(true);
																	   seatTypeId.allowBlank = true;
																   }
															   }
														   }
													   });
													   seatTypeId.getStore().getProxy().extraParams = {
														   batchId: record.data.batch.id,
														   enquiryStudentDetailId: null,
														   applicationId: record.data.application.id
													   }
													   if (record.data.progBatchSeatConfig != null) {
														   seatTypeId.getStore().load({
															   callback: function(recordss, operation, success) {
																   if (success) {
																	   var matchedId = null;
																	   for (i in recordss) {
																		   if (recordss[i].data.id == record.data.progBatchSeatConfig.id) {
																			   matchedId = recordss[i].data.id;
																			   break;
																		   }
																	   }
																	   if (matchedId != null) {
																		   seatTypeId.setValue(recordss[i].data.id);
																	   } else {
																		   seatTypeId.setValue(null);
																	   }
																   }
															   }
														   });
													   }
												   } else {
													   seatTypeId.setDisabled(true);
													   seatTypeId.allowBlank = true;
												   }
											   } else {
												   batchId.setDisabled(true);
												   batchId.allowBlank = true;
												   seatTypeId.setDisabled(true);
												   seatTypeId.allowBlank = true;
											   }
										   } else {
											   programId.setDisabled(true);
											   programId.allowBlank = true;
											   batchId.setDisabled(true);
											   batchId.allowBlank = true;
											   seatTypeId.setDisabled(true);
											   seatTypeId.allowBlank = true;
										   }

	                        		   }else if(record.data.visitorCategory.id == 6){
	                        			   parentGuardian.allowBlank = true;
	                        			   leadNameField.allowBlank = true;
	                        			   visitorCategory.setReadOnly(false);
	                        			   studentNameField.setVisible(false);
	                        			   studentNameField.allowBlank = true;
	                        			   empNameField.setVisible(false);
	                        			   empNameField.setReadOnly(true);
	                        			   empNameField.allowBlank = true;
	                        			   applicantNameField.setReadOnly(true);
	                        			   applicantNameField.allowBlank = true;
	                        			   applicantNameField.setVisible(false);
	                        			   sgForm.down("#cellCountryCode").setEditable(true);

	                        		   } else{
	                        			   parentGuardian.allowBlank = true;
	                        			   leadNameField.allowBlank = true;
	                        			   //visitorCatedowngory.setReadOnly(false);
	                        			   studentNameField.setVisible(false);
	                        			   studentNameField.allowBlank = true;
	                        			   empNameField.setVisible(false);
	                        			   empNameField.setReadOnly(true);
	                        			   empNameField.allowBlank = true;
	                        			   applicantNameField.setReadOnly(true);
	                        			   applicantNameField.allowBlank = true;
	                        			   applicantNameField.setVisible(false);

	                        		   }
	                        		   
	                        		   var mobileField = sgForm.down("#mobileNo");
	                        		   var countryCodeField=sgForm.down("#cellCountryCode");
	                        		   var str=record.data.appointeeContactNo;
	                        		   this.setMaximumMinimumDigitsForMobileNoValidation(sgForm, countryCodeField, mobileField, null);
	                        		   var spiltMobileNo;
	                        		   if(str!=null){
	                        			   spiltMobileNo =str.split("-");
	                        		   }
	                        		   if(record.data.appointeeContactNo != null){
	                        			   if(spiltMobileNo.length == 2){
	                        				   countryCodeField.setValue(spiltMobileNo[0]);
	                        				   mobileField.setValue(spiltMobileNo[1]);
	                        			   }

	                        		   }
	                        		   
	                        		  /*added for visit status and reason to visit*/
	                        		   var visitStatusCombo=sgForm.down("#viewStatusID");
	                        		   var reasonForVisitCombo=sgForm.down("#reasonForVisitID");
	                        		   var visitCatId = record.data.visitorCategory.id;
                    				   var reasonForVisitStore=reasonForVisitCombo.getStore();
                    				    reasonForVisitStore.getProxy().extraParams = {
                             			  id : visitCatId,
                             		   };
                    				  if(record.data.sgReasonForVisit != null){
	                        			   var userGroupName = record.data.sgReasonForVisit.code;
	                   	        		    this.enableOrDisableAdditionalReason(userGroupName);
	                        			   reasonForVisitCombo.store.load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
	                        						   for(i in records){
	                       	    						if(records[i].data.id==record.data.sgReasonForVisit.id){
	                       	    							reasonForVisitCombo.setValue(records[i].data.id);
	                       	    							}
	                       	    						
	                       	    					}
	                        						   
	                        					   }
	                        				   }
	                        			   });
	                        		   }

	                        		   if(record.data.sgVisitStatus != null){
	                        			   visitStatusCombo.store.load({
	                        				   callback : function(records,operation,success) {
	                        					   if (success) {
	                        						   visitStatusCombo.setValue(record.data.sgVisitStatus.id);
	                        					   }
	                        				   }
	                        			   });
	                        		   }
	                        		   
	                        		   sgForm.down('#resetBtnForm').setVisible(false);
	                        		   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                        		   var rescheduleAppointmentTimeId = sgForm.down('#rescheduleAppointmentTimeId');
	                        		   this.setAllowBlank(rescheduleAppointmentDateId,true);
	                        		   if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Completed"){
                        				   sgForm.down('#submitBtn').setVisible(false);
                        				   var appointmentId = sgForm.down('#appointmentId');
                        				   var reasonForVisitID = sgForm.down('#reasonForVisitID');
                        				   var personToMeetId = sgForm.down('#personToMeetId');
                        				   var visitTimeId = sgForm.down('#visitTimeId');
                        				   var outTimeId = sgForm.down('#outTimeId');
                        				   var cellCountryCode = sgForm.down('#cellCountryCode');
                        				   var viewStatusID = sgForm.down('#viewStatusID');
                        				   var emailId = sgForm.down('#appointeeEmailItemId');
                        				   var mobileNoId = sgForm.down('#mobileNo');
                        				   var remarkId = sgForm.down('#reasonToVisitItemId');
                        				   appointmentId.clearInvalid();
	    	                        	   //sgForm = sgForm.getForm();
	    	                        	   appointmentId.setReadOnly(true);
	    	                        	   reasonForVisitID.setReadOnly(true);
	    	                        	   personTodownMeetId.setReadOnly(true);
	    	                        	   visitTimeId.setReadOnly(true);
	    	                        	   outTimeId.setReadOnly(true);
	    	                        	   viewStatusID.setReadOnly(true);
	    	                        	   cellCountryCode.setReadOnly(true);
	    	                        	   emailId.setReadOnly(true);
	    	                        	   mobileNoId.setReadOnly(true);
	    	                        	   remarkId.setReadOnly(true);
	    	                        	   //toggleReadOnlyFormItems(sgForm, true);
	    	                        	  }
	                        		   else if(!isNullOrEmpty(record.data.sgVisitStatus) && record.data.sgVisitStatus.code == "Rescheduled"){
	                        			   var dateTimeRescheduleAppointmentItemId = sgForm.down('#dateTimeRescheduleAppointmentItemId');
	                        			   var rescheduleAppointmentFld = sgForm.down('#rescheduleAppointmentFld');
	                        			   if(!isNullOrEmpty(record.data.isRescheduleAppointment) && record.data.isRescheduleAppointment){
	                        				   dateTimeRescheduleAppointmentItemId.setVisible(true);
	                        				   var rescheduleAppointmentDateId = sgForm.down('#rescheduleAppointmentDateId');
	                        				   rescheduleAppointmentDateId.setValue(dateRender(record.data.rescheduleDate));
	                        				   if(!isNullOrEmpty(record.data.rescheduleTime)){
	                        					   sgForm.down("#rescheduleAppointmentTimeId").setValue(timeRender(record.data.rescheduleTime));
	                        				   }
	                        			   }
	                        			   else{
	                        				   dateTimeRescheduleAppointmentItemId.setVisible(false);
	                        				   rescheduleAppointmentDateId.reset();
	                        				   rescheduleAppointmentTimeId.reset();
	                        			   }
	                        			   rescheduleAppointmentFld.setVisible(true);
	                        		   }
	                        		   else{
	                        			   rescheduleAppointmentDateId.reset();
	                     				   rescheduleAppointmentTimeId.reset();
	                        		   }
	                        		   
	                        		   var enqIntermediateStage = sgForm.down("#enqIntermediateStage");
	                        		   // var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
	                        		   if (record.data.enqIntermediateType != null) {
	                        			   enqIntermediateStage.store.load({
	                        				   callback: function(records, operation, success) {
	                        					   if (success) {
	                        						   enqIntermediateStage.setValue(record.data.enqIntermediateType.id);
	                        					   }
	                        				   }
	                        			   });
	                        		   }
	                        		 this.removePlaceHolder();  
	                        	   }else {
	                        		   showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("PLEASE_SELECT_RECORD"));
	                        	   }

	                           },
	                           viewSGAppointmentRecord:function(){
	                        	   this.editAppointmentRecord();
	                        	   var sgForm=this.getSgappointmentform();
	                        	   sgForm.down('#submitBtn').setVisible(false);
	                        	   sgForm.down('#resetBtnForm').setVisible(false);
	                        	   sgForm = sgForm.getForm();
	                        	   toggleReadOnlyFormItems(sgForm, true);


	                           },
	                           getDocumentController : function() {
	                          		var this$ = this;
	                          		return this$.getController('Academia.controller.document.DocumentController');
	                          	},
	                           saveSGAppointmentRecord: function(){
	                        	   // Create required json to Save
	                        	   var $this = this;
	                        	   var portalId = $this.getCurrentLoggedPortalId();
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var academyLocationId = sgForm.down("#academyLocationId");
								   var programId = sgForm.down("#programId");
								   var batchId = sgForm.down("#batchId");
								   var seatTypeId = sgForm.down("#seatTypeId");
								   /*if (!academyLocationId.isVisible()) {
									   academyLocationId.reset();
								   }*/
								   if (!programId.isVisible()) {
									   programId.reset();
								   }
								   if (!batchId.isVisible()) {
									   batchId.reset();
								   }
								   if (!seatTypeId.isVisible()) {
									   seatTypeId.reset();
								   }
	                        	   var parentStore=sgForm.down("#appointeeNameParentId").getStore();
	                        	   var sgFormValues=sgForm.getValues();
	                        	   var submitUrl,isUpdate = false;
	                        	   var contentPanel = this.getContentPanel();
	                        	   var tabName = getServiceRequestTranslation('SG_APPOINTMENT');
	                        	   var grid = this.getSgappointmentgrid();
	                        	   var sgDetailGrid = $this.getSgappointmentdetailgrid();
	                        	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                        	   var submitPortalData = sgForm.down("#submitPortalId").getValue();
	                        	   var getTab=getcontroller.getTab(tabName);
	                        	   if (isNullOrEmpty(sgFormValues.id)) {
	                        		   submitUrl = SERVERURL.SG_APPOINTMENT_SAVE;
	                        		   isUpdate = false;
	                        	   } else {
	                        		   submitUrl =SERVERURL.SG_APPOINTMENT_UPDATE;
	                        		   isUpdate = true;
	                        	   }
	                        	   var visitorCategory={
	                        			   id:sgFormValues.visitorCategory
	                        	   };
	                        	  /* var entryBy={
	                        			   id:sgFormValues.entryBy
	                        	   };*/
	                        	   var entryBy;
	                        	   if(submitPortalData == 1){
	                        		   if(isNullOrEmpty(sgFormValues.entryBy)){
	                        			   var userId=this.getCurrentlyLoggedInUser();
	                        			   entryBy = {
	                        					   id: userId.id
	                        			   };
	                        		   } else{
	                        			   entryBy = {
	                        					   id: sgFormValues.entryBy
	                        			   };
	                        		   }
	                        	   }
	                        	   var appointeeName;
	                        	  
	                        	   if(sgFormValues.visitorCategory==1){
	                        		   var str=sgForm.down('#appointeeNameParentId').getRawValue();
		                			   var appointee=str.split("-");
		                			   appointeeName=appointee[0];
	                        	   }else if(sgFormValues.visitorCategory==2){                        		   
	                        		   var str=sgForm.down('#leadId').getRawValue();
	                        		   appointeeName=str;
	                        	   } else if (sgFormValues.visitorCategory == 3) {
	                                   var str = sgForm.down('#studentItemId').getRawValue();
	                                   appointeeName = str;
	                               }else if(sgFormValues.visitorCategory==4){                        		   
	                        		   var str=sgForm.down('#facAppointmentId').getRawValue();
	                        		   appointeeName=str;
	                               }else if(sgFormValues.visitorCategory==5){                        		   
	                            	   var str=sgForm.down('#applicantNameId').getRawValue();
	                            	   appointeeName=str;
	                               } else{
	                        		   appointeeName=sgFormValues.appointeeName;	                        		  
	                        	   }
	                        	   var personId={
	                        			   id:sgFormValues.appointeeNameParent	   
	                        	   };
	                        	   var enquiryId={
	                        			   id:sgFormValues.leadId	   
	                        	   };
	                        	   var visitStatusId={
	                        			   id:sgFormValues.viewStatusID	   
	                        	   };
	                        	   var reasonForVisitId={
	                        			   id:sgFormValues.reasonForVisitID	   
	                        	   };
	                        	   var student = {
	                        			   id: sgFormValues.studentId
	                        	   };
	                        	   var staffId={
	                        			   id:sgFormValues.facAppointmentId	   
	                        	   };
	                        	   var application={
	                        			   id:sgFormValues.applicantNameId	   
	                        	   };
								   var currentAlId = this.getCurrentAcademyLocation()
								   if(!isNullOrEmpty(sgFormValues.academyLocation)){
									currentAlId = sgFormValues.academyLocation
								   }
								   var academyLocationId = {
									   id: currentAlId
								   };
								   var programId = {
									   id: sgFormValues.program
								   };
								   var batchId = {
									   id: sgFormValues.batch
								   };
								   var seatTypeId = {
									   id: sgFormValues.seatType
								   };
	                        	   var appointmentFormData=new Academia.model.sgappointment.sgappointment.SGAppointmentModel();
	                        	   var chkRescheduleAppointment = sgForm.getForm().findField('isRescheduleAppointment');
	                        	   if(chkRescheduleAppointment.getValue()){
	                        		   appointmentFormData.set("isRescheduleAppointment",chkRescheduleAppointment.getValue());
		                        	   appointmentFormData.set("rescheduleDate",sgFormValues.rescheduleDate);
		                        	   if(!isNullOrEmpty(sgFormValues.rescheduleTime)){
		                        		   appointmentFormData.set("rescheduleTime",sgFormValues.rescheduleTime); 
		                        	   }else{
		                        		   delete appointmentFormData.data.rescheduleTime;
		                        	   }
	                        	   }
	                        	   appointmentFormData.set("id",sgFormValues.id);
	                        	   appointmentFormData.set("visitorCategory",visitorCategory);
	                        	   appointmentFormData.set("bookingId",sgFormValues.bookingId);
	                        	   appointmentFormData.set("appointeeName",appointeeName);
	                        	   appointmentFormData.set("additionalReasonToVisit",sgFormValues.additionalReasonToVisit);
								   appointmentFormData.set("program", programId);
								   appointmentFormData.set("batch", batchId);
								   appointmentFormData.set("progBatchSeatConfig", seatTypeId);
								   appointmentFormData.set("academyLocation", academyLocationId);
	                        	   var countryCode=sgFormValues.mobileCountryCode;
	                        	   var mobileNo=sgFormValues.appointeeContactNo;
	                        	   var mobileNoWithCode;
	                        	   if(isNullOrEmpty(countryCode) && isNullOrEmpty(mobileNo) ){
	                        		   mobileNoWithCode=null;
	                        	   }else{
	                        		   mobileNoWithCode=countryCode +'-'+ mobileNo;
	                        	   }
	                        	   appointmentFormData.set("appointeeContactNo",mobileNoWithCode);
	                        	   appointmentFormData.set("bookingDate",sgFormValues.bookingDate);
	                        	   appointmentFormData.set("appointmentDate",sgFormValues.appointmentDate);
	                        	   appointmentFormData.set("appointeeEmailId",sgFormValues.appointeeEmailId);
	                        	   var persontoMeetValue=sgForm.getForm().findField('personToMeet').getRawValue();
	                        	   appointmentFormData.set("personToMeet",persontoMeetValue);
	                        	   appointmentFormData.set("visitTime",sgFormValues.visitTime);
	                        	   appointmentFormData.set("expectedOutTime",sgFormValues.expectedOutTime);
	                        	   appointmentFormData.set("reasonToVisit",sgFormValues.reasonToVisit);
	                        	   appointmentFormData.set("entryBy",entryBy);
	                        	   appointmentFormData.set("isAppointeeAppointment",sgFormValues.isAppointee);
	                        	   
	                        	   var enquiryStageId = null;
	                         	   var enquiryStageRawValue = null;
	                        	   
	                        	   var enqIntermediateStage = sgForm.getForm().findField('enqIntermediateStage');
	                        	   if( !isNullOrEmpty(enqIntermediateStage.getValue()) ){
	                        		   var enqIntermediateStageJsonObj = {
	                        				   id:enqIntermediateStage.getValue()  
	                        		   };
	                        		   enquiryStageId = enqIntermediateStage.getValue();
	                         		   enquiryStageRawValue = enqIntermediateStage.getRawValue();
	                        		   appointmentFormData.set("enqIntermediateType",enqIntermediateStageJsonObj);
	                        	   }else{
	                        	   	appointmentFormData.set("enqIntermediateType",null); 
	                        	   }
	                        	   delete appointmentFormData.data.enqIntermediateStage;
		  		                   if(isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
		  		                	  delete appointmentFormData.data.enqIntermediateType;
		  		                   }
	                        	   
                        		   var submitPortalData = sgForm.down("#submitPortalId").getValue();
                        		   if(!isNullOrEmpty(submitPortalData)){
                        			   appointmentFormData.set("submitPortalId", submitPortalData);
                        		   }
	                        	   if(!isNullOrEmpty(visitStatusId.id)){
	                        		   appointmentFormData.set("sgVisitStatus",visitStatusId);   
	                        	   }else{
	                        		   appointmentFormData.set("sgVisitStatus",null); 
	                        	   }
	                        	   if(!isNullOrEmpty(reasonForVisitId.id)){
	                        		   appointmentFormData.set("sgReasonForVisit",reasonForVisitId);   
	                        	   }else{
	                        		   appointmentFormData.set("sgReasonForVisit",null); 
	                        	   }	   
	                        	   appointmentFormData.set("customData",sgFormValues.customData);
	                        	  
	                        	   if(sgFormValues.visitorCategory==1){//base category
	                        		   appointmentFormData.set("person",personId);
	                        		   delete appointmentFormData.data.enquiry;
	                        		   delete appointmentFormData.data.staff;
	                        		   delete appointmentFormData.data.student;
	                        		   delete appointmentFormData.data.application;
	                        	   }else if(sgFormValues.visitorCategory==2){
	                        		   appointmentFormData.set("enquiry",enquiryId);
	                        		   delete appointmentFormData.data.person;
	                        		   delete appointmentFormData.data.staff;
	                        		   delete appointmentFormData.data.student;
	                        		   delete appointmentFormData.data.application;
	                        	   } else if (sgFormValues.visitorCategory == 3) {
	                                   appointmentFormData.set("student", student);
	                                   delete appointmentFormData.data.person;
	                                   delete appointmentFormData.data.enquiry;
	                                   delete appointmentFormData.data.staff;
	                                   delete appointmentFormData.data.application;
	                               }else if(sgFormValues.visitorCategory==4){
	                        		   appointmentFormData.set("staff",staffId);
	                        		   delete appointmentFormData.data.person;
	                        		   delete appointmentFormData.data.enquiry;
	                        		   delete appointmentFormData.data.student;
	                        		   delete appointmentFormData.data.application;
	                               }else if(sgFormValues.visitorCategory==5){
	                            	   appointmentFormData.set("application",application);
	                            	   delete appointmentFormData.data.person;
	                            	   delete appointmentFormData.data.enquiry;
	                            	   delete appointmentFormData.data.student;
	                            	   delete appointmentFormData.data.staff;
	                               }else{
	                        		   delete appointmentFormData.data.person;
	                        		   delete appointmentFormData.data.enquiry;
	                        		   delete appointmentFormData.data.staff;
	                        		   delete appointmentFormData.data.student;
	                        		   delete appointmentFormData.data.application;
	                        	   }
								   if (Ext.isDefined(appointmentFormData.data.entryByName)) {
									   delete appointmentFormData.data.entryByName;
								   }
								   if (Ext.isDefined(appointmentFormData.data.personToMeetId)) {
									   delete appointmentFormData.data.personToMeetId;
								   }
								   if (isNullOrEmpty(appointmentFormData.data.enqIntermediateType)) {
									   delete appointmentFormData.data.enqIntermediateType;
								   }
								   if (isNullOrEmpty(appointmentFormData.data.enqIntermediateStage)) {
									   delete appointmentFormData.data.enqIntermediateStage;
								   }
								   if (isNullOrEmpty(appointmentFormData.data.academyLocation.id)) {
									   delete appointmentFormData.data.academyLocation;
								   }
								   if (isNullOrEmpty(appointmentFormData.data.program.id)) {
									   delete appointmentFormData.data.program;
								   }
								   if (isNullOrEmpty(appointmentFormData.data.batch.id)) {
									   delete appointmentFormData.data.batch;
								   }
								   if (isNullOrEmpty(appointmentFormData.data.progBatchSeatConfig.id)) {
									   delete appointmentFormData.data.progBatchSeatConfig;
								   }
	                        	   
	      	                	 //////////////////////////////////////////////////////////////////////
	      	                	var dataUpload = new Object();
	      	                	
	      	                	dataUpload.entityId = null;
	      	                	dataUpload.module = 'SGAPPOINTMENT';
	      	                	dataUpload.entityType = 'DOCUMENT';
	      	                	var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
	      	                	 
	      	                	var imageField=sgForm.down('#documentUploadFile');
	      	                	if(!isNullOrEmpty(imageField.getValue())){
	      	                		
	      	                		sgForm.getForm().submit({
		      	                		method: 'POST',
		      	                		async:false,
		      	                		url: uplaodUrl,
		      	                		success: function(form1, action) {
		      	                			var responseData = Ext.decode(action.response.responseText);
		      	                			var path = responseData.path;
		      	                			
		      	                			 var formDataTemp = new Object();
		      	                			formDataTemp.type ='NEW_DOCUMENT';
		      	                			formDataTemp.name = path;
		      	                			formDataTemp.documentName=path;
		      	              			
		      	                			$this.getDocumentController().saveDocumentFormValue(false, 'NEW_DOCUMENT', false, formDataTemp, path, function(success, response, isCallBackTransient){
		      	                				if(success){
		      	                				  var documentId = Ext.decode(response.responseText);
		      	                				   var saveJson = new Object();
		      	                				   var document = new Object();
		      	                				   document.id = documentId;
		      	                				   
		      	                				   appointmentFormData.set("documentId",documentId);
		      	                				   
		      	                				 var formData = Ext.encode(appointmentFormData.data);
		      	                        	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		      	                        	   Ext.Ajax.request({
		      	                        		   type : 'rest',
		      	                        		   url : submitUrl,
		      	                        		   jsonData : formData,
		      	                        		   method : 'POST',
		      	                        		   success : function(frm, action) {
		      	                        			   Ext.getBody().unmask();
		      	                        			   sgForm.getForm().reset();
		      	                        			   if (isUpdate) {
		      	                        				   showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
		      	                        				   if(getTab!=null){
		      	                        					   contentPanel.remove(getTab, true);
		      	                        				   }
		      	                        				  // this.resetPageSetting(store);
		      	                        				   if(grid!=undefined){
		      	                        					   grid.getStore().reload();		                        				  
		      		                        				   grid.getSelectionModel().deselectAll();
		      	                        				   }else if(sgDetailGrid!=undefined){
		      	                        					   sgDetailGrid.getStore().load();
		      	                        					   sgDetailGrid.getSelectionModel().deselectAll();
		      	                        				   }
		      	                        				   if(sgFormValues.visitorCategory==2){
		      	                         					   if( !isNullOrEmpty(enquiryStageId) && !isNullOrEmpty(enquiryStageRawValue) ){
		      	                         						   if( !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStage')) && !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStageId')) ){
		      	                         							  Ext.getCmp('enqtab_intermediateStage').setValue(enquiryStageRawValue);
		      	                        							   Ext.getCmp('enqtab_intermediateStageId').setValue(enquiryStageId);
		      	                         						   }
		      	                         					   }
		      	                         				   }
		      	                        				  
		      	                        			   }else{
		      	                        				   showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
		      	                        				   if(getTab!=null){
		      	                        					   contentPanel.remove(getTab, true);
		      	                        				   }
		      	                        				   //this.resetPageSetting(store);
		      	                        				   			//grid.getStore().reload();
		      	                        				   //this.setEntrybyValuebydefault();
		      	                        				   if(grid!=undefined){
		      	                        					   grid.getStore().reload();		                        				  
		      		                        				   grid.getSelectionModel().deselectAll();
		      	                        				   }else if(sgDetailGrid!=undefined){
		      	                        					   sgDetailGrid.getStore().load();
		      	                        					   sgDetailGrid.getSelectionModel().deselectAll();
		      	                        				   }
		      	                        				   if(sgFormValues.visitorCategory==2){
		      	                         					   if( !isNullOrEmpty(enquiryStageId) && !isNullOrEmpty(enquiryStageRawValue) ){
		      	                         						   if( !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStage')) && !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStageId')) ){
		      	                         							  Ext.getCmp('enqtab_intermediateStage').setValue(enquiryStageRawValue);
		      	                        							   Ext.getCmp('enqtab_intermediateStageId').setValue(enquiryStageId);
		      	                         						   }
		      	                         					   }
		      	                         				   }
		      	                        			   }
		      	                        			   
		      	                        			   var manageAppointmentTabName = getMegaMenuTranslation('TS_MANAGE_APPOINTMENTS');
		      	                        			   var getManageAppointmentTab = getcontroller.getTab(manageAppointmentTabName);
		      	                        			   if (getManageAppointmentTab != null) {
		      	                        				   contentPanel.setActiveTab(getManageAppointmentTab);
		      	                        			   }
		      	                        		   }
		      	                        	   });
		      	                		
		      	                				}
		      	                			});
		      	                		}
		      	                	});
	      	                		
	      	                	}else{
	      	                		var formData = Ext.encode(appointmentFormData.data);
	      	                		 Ext.Ajax.request({
    	                        		   type : 'rest',
    	                        		   url : submitUrl,
    	                        		   jsonData : formData,
    	                        		   method : 'POST',
    	                        		   success : function(frm, action) {
    	                        			   Ext.getBody().unmask();
    	                        			   sgForm.getForm().reset();
    	                        			   if (isUpdate) {
    	                        				   showSuccessMessage(getServiceRequestTranslation('SG_UPDATE_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_UPDATED_SUCCESSFULLY'));
    	                        				   if(getTab!=null){
    	                        					   contentPanel.remove(getTab, true);
    	                        				   }
    	                        				  // this.resetPageSetting(store);
    	                        				   if(grid!=undefined){
    	                        					   grid.getStore().reload();		                        				  
    		                        				   grid.getSelectionModel().deselectAll();
    	                        				   }else if(sgDetailGrid!=undefined){
    	                        					   sgDetailGrid.getStore().load();
    	                        					   sgDetailGrid.getSelectionModel().deselectAll();
    	                        				   }
    	                        				   if(sgFormValues.visitorCategory==2){
    	                         					   if( !isNullOrEmpty(enquiryStageId) && !isNullOrEmpty(enquiryStageRawValue) ){
    	                         						   if( !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStage')) && !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStageId')) ){
    	                         							  Ext.getCmp('enqtab_intermediateStage').setValue(enquiryStageRawValue);
    	                        							   Ext.getCmp('enqtab_intermediateStageId').setValue(enquiryStageId);
    	                         						   }
    	                         					   }
    	                         				   }
    	                        				  
    	                        			   }else{
    	                        				   showSuccessMessage(getServiceRequestTranslation('SG_ADD_APPOINTMENT'), getServiceRequestTranslation('SG_APPOINTMENT_CREATED_SUCCESSFULLY'));
    	                        				   if(getTab!=null){
    	                        					   contentPanel.remove(getTab, true);
    	                        				   }
    	                        				   //this.resetPageSetting(store);
    	                        				   			//grid.getStore().reload();
    	                        				   //this.setEntrybyValuebydefault();
    	                        				   if(grid!=undefined){
    	                        					   grid.getStore().reload();		                        				  
    		                        				   grid.getSelectionModel().deselectAll();
    	                        				   }else if(sgDetailGrid!=undefined){
    	                        					   sgDetailGrid.getStore().load();
    	                        					   sgDetailGrid.getSelectionModel().deselectAll();
    	                        				   }
    	                        				   if(sgFormValues.visitorCategory==2){
    	                         					   if( !isNullOrEmpty(enquiryStageId) && !isNullOrEmpty(enquiryStageRawValue) ){
    	                         						   if( !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStage')) && !isNullOrEmpty(Ext.getCmp('enqtab_intermediateStageId')) ){
    	                         							  Ext.getCmp('enqtab_intermediateStage').setValue(enquiryStageRawValue);
    	                        							   Ext.getCmp('enqtab_intermediateStageId').setValue(enquiryStageId);
    	                         						   }
    	                         					   }
    	                         				   }
    	                        			   }
    	                        			   
    	                        			   var manageAppointmentTabName = getMegaMenuTranslation('TS_MANAGE_APPOINTMENTS');
    	                        			   var getManageAppointmentTab = getcontroller.getTab(manageAppointmentTabName);
    	                        			   if (getManageAppointmentTab != null) {
    	                        				   contentPanel.setActiveTab(getManageAppointmentTab);
    	                        			   }
    	                        		   }
    	                        	   });
	      	                	}
	      	                	 
	                           },
	                           
	                           sendCalendarEventsRequest: function(personId, calenderItemId, submitURL) {
	                               var this$ = this;
	                               var sgForm=this$.getSgappointmentform();
	                               if (!isNullOrEmpty(sgForm) && Ext.isDefined(sgForm)) {
	                            	   var id=sgForm.down("#id").getValue();
		                               var personToMeetId = null;
		                        	   var appointmentDateId=sgForm.down("#appointmentId").getValue();
		                        	   if(isNullOrEmpty(id)){
		                             	   personToMeetId=sgForm.down("#personToMeetId").getStore().data.items[0].data.id;
		                        	   }else{
		                        		  var facultyName= sgForm.down("#personToMeetId").getRawValue();
		                        		  var records=sgForm.down("#personToMeetId").getStore().data.items;
		                        		  for(var i in sgForm.down("#personToMeetId").getStore().data.items){
			                					 if(records[i].data.valueCode==facultyName){
			                						 personToMeetId=records[i].data.id;
			                					 }
		                					 }
		                        	   }
		                               var personProfile = this.getContentPanelActiveTab();
		                               var calendar = personProfile.down(calenderItemId);
		                               var params = new Object();
		                               calendar.eventStore.getProxy().actionMethods.read = 'GET';
		                               	params.facultyId = personToMeetId;
		                               calendar.eventStore.removeAll();
		                               calendar.eventStore.getProxy().url = submitURL;
		                               calendar.eventStore.getProxy().extraParams = params;
		                               calendar.eventStore.load();
	                               }
	                           },
	                           
	                           getfacultyInfoDetails : function(){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var staffId=sgForm.down("#facAppointmentId").getValue();
	                        	   var mobileField = sgForm.down("#mobileNo");
	                        	   var countryCodeField=sgForm.down("#cellCountryCode");
		              			   this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);
                                   var emailId = sgForm.down("#appointeeEmailItemId");
	        					   var submitUrl = SERVERURL.SG_PATH_FIND_STAFF_INFO_BY_USERID;
	        					   Ext.Ajax.request({
	    				    		   type : 'rest',
	    				    		   url : submitUrl,
	    				    		   params: {
	    				    			   userId: staffId,
	    				               },
	    				    		  /// jsonData : formData,
	    				    		   method : 'GET',
	    				    		   async: false,
	    				    		   success : function(frm, action) {
	    				    			   var data = Ext.JSON.decode(frm.responseText);
	                        			   countryCodeField.setValue(data.mobileCountryCode);
	                        			   mobileField.setValue(data.mobileNumber);
	                        			   emailId.setValue(data.emailId);
	                        			   countryCodeField.setReadOnly(true);
	                        			   mobileField.setReadOnly(true);
	                        			   emailId.setReadOnly(true);
	    				    		   }
	    				    	   });
	                           },
	                           
	                           getLeadInfoDetails : function(){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var leadId=sgForm.down("#leadId").getValue();
	                        	   var mobileField = sgForm.down("#mobileNo");
	                        	   var countryCodeField=sgForm.down("#cellCountryCode");
	                        	   var emailId = sgForm.down("#appointeeEmailItemId");
	        					   var submitUrl = SERVERURL.ENQUIRY_DETAIL_FIND_BY_ID;
	        					   Ext.Ajax.request({
	    				    		   type : 'rest',
	    				    		   url : submitUrl,
	    				    		   params: {
	    				    			   id: leadId,
	    				               },
	    				    		  /// jsonData : formData,
	    				    		   method : 'GET',
	    				    		   async: false,
	    				    		   success : function(frm, action) {
	    				    			   var data = Ext.JSON.decode(frm.responseText);
	                        			   countryCodeField.setValue(data.phoneCountryCode);
	                        			   mobileField.setValue(data.phoneNo);
	                        			   emailId.setValue(data.primaryeEmailId);
	                        			   countryCodeField.setReadOnly(true);
	                        			   mobileField.setReadOnly(true);
	                        			   emailId.setReadOnly(true);
										   if (data.enquiryType.code=="Corporate" || data.enquiryType.value=="Corporate" ||
										       data.enquiryType.code=="Counselling" || data.enquiryType.value=="Counselling") {
											   sgForm.down('#academyLocationId').setVisible(false);
											   sgForm.down('#programId').setVisible(false);
											   sgForm.down('#batchId').setVisible(false);
											   sgForm.down('#seatTypeId').setVisible(false);
											   sgForm.down('#academyLocationId').allowBlank = true;
											   sgForm.down('#programId').allowBlank = true;
											   sgForm.down('#batchId').allowBlank = true;
											   sgForm.down('#seatTypeId').allowBlank = true;
										   } else {
											   if (leadId != null) {
												   var submitUrl = SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL;
												   Ext.Ajax.request({
													   type: 'rest',
													   url: submitUrl,
													   params: {
														   id: leadId,
													   },
													   method: 'GET',
													   async: false,
													   success: function(frm, action) {
														   var res = Ext.JSON.decode(frm.responseText);
														   var academyLocation = sgForm.down("#academyLocationId");
														   academyLocation.setDisabled(false);
														   academyLocation.getStore().getProxy().extraParams = {
															   enquiryStudentDetailId: res.id,
															   applicationId: null
														   };
														   academyLocation.getStore().load();
													   }
												   });
											   } else {
												   academyLocation.setDisabled(true);
											   }
										   }
	    				    		   }
	    				    	   });
	                           },
	                           enableOrDisableAdditionalReason:function(userGroupName) {
	                           	
	                        	   var form = this.getActiveTabfromContentPanel().down('sgappointmentform');
	                        	   
	                           	if(userGroupName == 'Other'){
	                       	    	
	                       	    	form.down('#additionalReasonToVisitItemId').setDisabled(false);
	                       	    	form.down('#additionalReasonToVisitItemId').allowBlank = false;
	                       	    } 
	                           	else{ form.down('#additionalReasonToVisitItemId').setDisabled(true);
                       	    	form.down('#additionalReasonToVisitItemId').allowBlank = true;
                       	    	form.down('#additionalReasonToVisitItemId').reset();
	                           	}
	                           		
	                           	
	                           	var valid = form.isValid();
	                           	if(!valid) {
	                           		form.down('#submitBtn').setDisabled(true);
	                           	}
	                           },
	                           
	                           getApplicantInfoDetails : function(){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var applicantId=sgForm.down("#applicantNameId").getValue();
	                        	   var mobileField = sgForm.down("#mobileNo");
	                        	   var countryCodeField=sgForm.down("#cellCountryCode");
	                        	   var emailId = sgForm.down("#appointeeEmailItemId");
		              			   this.setMaximumMinimumDigitsForMobileNoValidation(sgForm,countryCodeField,mobileField,null);

	                        	   //'rest/applicantPerson/
	        					   var submitUrl = SERVERURL.APPLICANT_PERSONAL_INFORMATION_BY_ID;
	        					   Ext.Ajax.request({
	    				    		   type : 'rest',
	    				    		   url : submitUrl,
	    				    		   params: {
	    				    			   id: applicantId,
	    				               },
	    				    		  /// jsonData : formData,
	    				    		   method : 'GET',
	    				    		   async: false,
	    				    		   success : function(frm, action) {
	    				    			   var data = Ext.JSON.decode(frm.responseText);
	                        			   countryCodeField.setValue(data.person.mobileCountryCode);
	                        			   mobileField.setValue(data.person.mobileNumber);
	                        			   emailId.setValue(data.person.emailId);
	                        			   countryCodeField.setReadOnly(true);
	                        			   mobileField.setReadOnly(true);
	                        			   emailId.setReadOnly(true);
	    				    		   }
	    				    	   });
								   if (applicantId != null) {
									   var academyLocation = sgForm.down("#academyLocationId");
									   academyLocation.setDisabled(false);
									   var store = academyLocation.getStore();
									   store.getProxy().extraParams = {
										   enquiryStudentDetailId: null,
										   applicationId: applicantId
									   };
									   store.load();
								   } else {
									   academyLocation.setDisabled(true);
								   }
	                           },
	                           setExpectedOutTime : function(obj,record){
	                        	   var sgForm=this.getSgappointmentform();
	                        	   var visitTimeValue='';
	                        	   if(obj.itemId == 'visitTimeId'){
	                        		   var visitTimeValue=record;
	                        		   var id=sgForm.down("#reasonForVisitID").getValue();
	                        	   }else{
	                        		   visitTimeValue=sgForm.down("#visitTimeId").getValue();
	                        		   var id = record[0].get("id");
	                        	   }
	                        	   var visitTimeIdfield=sgForm.getForm().findField('visitTime');
	                        	   var expectedOutTimefield=sgForm.getForm().findField('expectedOutTime');
	                        	   expectedOutTimefield.reset();
	                        	   if(!isNullOrEmpty(id)){
	                        		   var submitUrl = SERVERURL.PATH_SG_REASON_FOR_VISIT_TIME;
	                        		   Ext.Ajax.request({
	                        			   type : 'rest',
	                        			   url : submitUrl,
	                        			   params: {
	                        				   id: id,
	                        			   },
	                        			   method : 'GET',
	                        			   async: false,
	                        			   success : function(data, action) {
	                        				   var data=Ext.decode(data.responseText);
	                        				   if(data.length>0){
	                        					   if(!isNullOrEmpty(visitTimeValue)){
	                        						   if(data[0].code!="0" && data[0].code!="00" || data[0].value!="0" && data[0].value!="00" ){
	                        							   var expTimeDuration='';
	                        							   var expTime =  parseInt(data[0].code)+(parseInt(data[0].value)/60);
	                        							   expTimeDuration = visitTimeValue.getTime() + (expTime*60*60*1000);
	                        							   var expTimeDurationRender = timeRender(expTimeDuration);
	                        							   expectedOutTimefield.setValue(expTimeDurationRender);
	                        						   }else{
	      	                							 expectedOutTimefield.reset();
	    	                							 visitTimeIdfield.setMaxValue(null);
	    	                							 visitTimeIdfield.setMinValue(null);
	    	                						 }
	                        					   }
	                        				   }
	                        			   }
	                        		   });   
	                        	   }
	                           },
                removePlaceHolder:function(){
	            var sgappointmentform=this.getSgappointmentform();
                      Ext.Ajax.request({
                         type: 'rest',
                         url: SERVERURL.FIND_BY_ENTITY_ID,                             
                         method: 'GET',
                         params: {
                             entityId: 31
                         },
                         success: function(response,form, action) {
                             if(!isNullOrEmpty(response.responseText)){
                                 var responseObject =  Ext.JSON.decode(response.responseText);                                  
                                 if(!isEmpty(responseObject)){
                                     var bookingId = sgappointmentform.down("#bookingId");
                                     if(responseObject.whetherManualId && bookingId){
                                         bookingId.setReadOnly(false);
										 bookingId.emptyText=' ';
									     bookingId.allowBlank=false;
										 bookingId.labelSeparator +='<span class="required" style="color:red"> *</span>';
										 bookingId.setFieldLabel(bookingId.fieldLabel);
										 bookingId.applyEmptyText();
                                     }else{
										 bookingId.setReadOnly(true);
										 bookingId.setFieldLabel(bookingId.getFieldLabel().split(':')[0]+':');
									     bookingId.allowBlank=true;
										 bookingId.emptyText= getCommonTranslation('ID_AUTOGENERATE');
										 bookingId.applyEmptyText();
	
                                    }
                                 }
                             }                                                     
                         }                
                     });
    
} ,
                    loadDFRForManageAppointment: function(academyLocationId) {
	                      var $this = this;
	                      var form = $this.getSgappointmentform();
	                      var academyLocationId = form.down("#academyLocationId");
	              		  var programId = form.down("#programId");
	              		  var batchId = form.down("#batchId");
	              		  var seatTypeId = form.down("#seatTypeId");

	                      Ext.Ajax.request({
	                          method: 'GET',
	                          async: false,
	                          url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                          params: {
	                              academyLocationId: this.getCurrentAcademyLocation(),
	                              languageCode: 'en'
	                          },
	                          success: function(response) {
	                              //var response = Ext.decode(res.responseText);
	                              var json = JSON.parse(response.responseText);
	                              var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
									  fieldInfo.set("formFieldsInfo", json);
	                              if (!isNullOrEmpty(json)) {
		                             if (!isNullOrEmpty(json.sgappointmentform)) {
	                                  var records = json.sgappointmentform;
	                                  for (i in records) {
	                                      var fieldConfig = records[i];
	                                      
	                                        if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'academyLocationId') {
	                                          if (fieldConfig.isMandatory) {
	                                          	academyLocationId.allowBlank = false;
	                                          }else{
	                                          	academyLocationId.allowBlank = true;
	                                          }
	                                          if (fieldConfig.isVisible) {
	                                          	academyLocationId.setVisible(true);
	                                          }else{
	                                          	academyLocationId.setVisible(false);
	                                          	academyLocationId.reset();
	                                          	programId.setVisible(false);
	                                          	programId.reset();
	                                          	batchId.setVisible(false);
	                                          	batchId.reset();
	                                          	seatTypeId.setVisible(false);
	                                          	seatTypeId.reset();
	                                          }
	                                         }
	                                         if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'programId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	programId.allowBlank = false;
	                                              }else{
	                                              	programId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	programId.setVisible(true);
	                                              }else{
	                                              	programId.setVisible(false);
	                                              	programId.reset();
	                                              	batchId.setVisible(false);
	                                              	batchId.reset();
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                        }
	                                       	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'batchId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	batchId.allowBlank = false;
	                                              }else{
	                                              	batchId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	batchId.setVisible(true);
	                                              }else{
	                                              	batchId.setVisible(false);
	                                              	batchId.reset();
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                        }
	                                       	if (fieldConfig.formFieldInputType == 'customcombobox' && fieldConfig.formFieldId == 'seatTypeId') {
	                                              if (fieldConfig.isMandatory) {
	                                              	seatTypeId.allowBlank = false;
	                                              }else{
	                                              	seatTypeId.allowBlank = true;
	                                              }
	                                              if (fieldConfig.isVisible) {
	                                              	seatTypeId.setVisible(true);
	                                              }else{
	                                              	seatTypeId.setVisible(false);
	                                              	seatTypeId.reset();
	                                              }
	                                       }
	                                  }
									  } else {
										  academyLocationId.setVisible(false);
										  academyLocationId.reset();
										  programId.setVisible(false);
										  programId.reset();
										  batchId.setVisible(false);
										  batchId.reset();
										  seatTypeId.setVisible(false);
										  seatTypeId.reset();
									  }
								  }
	                          }
	                      });
	                  }
});

