Ext.define('Academia.controller.standardMaster.StandardMaster', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['standardMaster.StandardMasterStore','standardMaster.OSMAllPaymentGateWayStore'],
    views: ['standardMaster.StandardMasterScreen', 'standardMaster.ParentFormWindow',
            'standardMaster.ChildFormWindow','standardMaster.StdMasterParentGrid','standardMaster.ActivePaymentGateWayWin'],
    models: ['gradeMaster.MarksRangeMasterModel'],
    alias: "widget.standardMasterController",

    refs: [{
        ref: 'standardMaster',
        selector: 'standardMaster'
    }, {
        ref: 'parentFormWindow',
        selector: 'parentFormWindow'
    }, {
        ref: 'childFormWindow',
        selector: 'childFormWindow'
    }, {
        ref: 'stdMasterParentGrid',
        selector: 'standardMaster #stdMasterParentGrid'
    }, {
        ref: 'stdMasterChildGrid',
        selector: 'standardMaster #stdMasterChildGrid'
    }, {
        ref: 'stdMasterParentForm',
        selector: 'parentFormWindow form[itemId=stdMasterParentForm]'
    }, {
        ref: 'stdMasterChildForm',
        selector: 'childFormWindow form[itemId=stdMasterChildForm]'
    }, {
    	ref: 'verticalNavigationMenu',
    	selector: 'verticalNavigationMenu'
    },{
    	ref:'activepaymentgatewaywin',
    	selector:'activepaymentgatewaywin'
    },{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }

],
    config: {
    	STANDARD_MASTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STANDARD_MASTER_PRIVILEGES')
    },
    init: function(application) {
        this.control({

            'standardMaster #stdMasterParentGrid  button[itemId=btnAdd]': {
                click: function() {
                    this.showParentWindow("ADD");
                }
            },
          /*  'standardMaster': {
            	afterrender : function(panel) {
                	var filterCodeValue = this.getfilterCodeValue(panel);
                	var param={filterCode : filterCodeValue};
                	this.loadStandardMasterStore(combo,param);
                },
            },*/
            'standardMaster #stdMasterParentGrid  checkboxfield[itemId=useAsDropdownCheckbox]': {
            	change: function(combo) {
            		var this$ = this;
                    var stdMasterParentGrid = this.getStdMasterParentGrid();
                    var submitUrl;
                    var successMessge,	parentTableId=this.getParentTableId();
                    var parentTableData = this.getParentTableId();

            		var submitUrl = SERVERURL.PATH_SAVE_CHECKBOX;

     	            Ext.Ajax.request({
     	         		type : 'rest',
     	            	url : submitUrl+ '?whetherDropdownCheckbox='+combo.value,
     	            	method : 'POST',
     	            success: function(form, action) {
     	            	this$.hideWindowMask();
     	            	this$.closeParentWindow();
     	            	stdMasterParentGrid.getSelectionModel().deselectAll(true);
     	                showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
     					stdMasterParentGrid.getStore().reload();
     	            },
     	            failure: function(form, action) {
     	            	this$.hideWindowMask();
     	            	 if(this$.getStdMasterParentForm().itemId=='stdMasterChildForm'){
     	            		this$.getStdMasterParentForm().down('#formSubmitButtonId').setDisabled(false);
     	               }else{
     	            	  this$.getStdMasterParentForm().up('form').down('#formSubmitButtonId').setDisabled(false);
     	               }


     	            	var resp = Ext.decode(form.responseText);

     	            }
     	            });
     		}
            },
            'standardMaster #stdMasterParentGrid  button[itemId=btnEdit]': {
                click: function() {
                    this.parentEditBtnClick();
                }
            },
            'standardMaster #stdMasterParentGrid  button[itemId=btnView]': {
                click: function() {
                    this.viewParentFormWindow();
                }
            },
            'standardMaster #stdMasterParentGrid  button[itemId=btnDelete]': {
                click: function() {
                	 var pGrid = this.getStdMasterParentGrid();
                	 var parentTableId = this.getParentTableId();
                	 if(Ext.isObject(parentTableId) == true) {
                		 parentTableId = parentTableId.parentTableId;
                	 }
                	 this.deleteButtonClick(pGrid,parentTableId,'PARENT');
                }
            },

            'standardMaster #stdMasterChildGrid  button[itemId=btnAdd]': {
                click: function() {
                    this.showChildWindow("ADD");
                }
            },
            'standardMaster #stdMasterChildGrid  button[itemId=btnEdit]': {
                click: function() {
                    this.childEditBtnClick();
                }
            },
            'standardMaster #stdMasterChildGrid  button[itemId=btnView]': {
                click: function() {
                    this.viewChildFormWindow();
                }
            },
            'standardMaster #stdMasterChildGrid  button[itemId=btnDelete]': {
                click: function() {
                    var grid = this.getStdMasterChildGrid();
                    var childTableId = this.getChildTableId();
                    this.deleteButtonClick(grid,childTableId, 'CHILD');
                }
            },

            /*'standardMaster #stdMasterParentGrid':{
            	render: function(grid) {
                    this.doAccessControlValidation(grid, this.getSTANDARD_MASTER_PERMISSIONS());
                }
            },*/

            'standardMaster groupingcombobox[itemId=standardMasterComboField]': {
            	boxready : function(combo) {
                	var filterCodeValue = this.getfilterCodeValue(combo.up('standardMaster'));
                	var param={filterCode : filterCodeValue};
                	this.loadStandardMasterStore(combo,param);
                },
                change: function(combo,nV) {
                	var pGrid = this.getStdMasterParentGrid();
                	if(combo.getRawValue() == getTranslation('BANK_DRAWN_ON_MASTER')){
                        pGrid.down('#useAsDropdownCheckbox').setVisible(true);

                        var submitUrl = SERVERURL.PATH_CHECKBOX_SELECTED;
         				Ext.Ajax.request({
         	         		type : 'rest',
         	            	url : submitUrl,
         	            	method : 'GET',
         	            success: function(form, action) {
         	            	if(form.responseText=='true'){
         	            	  pGrid.down('#useAsDropdownCheckbox').setValue(true);
         	               }else{
         	            	  pGrid.down('#useAsDropdownCheckbox').setValue(false);
         	               }
         	            }
         	            });
                	}else{
                		pGrid.down('#useAsDropdownCheckbox').setVisible(false);
                	}
                	var filterCodeValue = this.getfilterCodeValue();
                	var param={filterCode : filterCodeValue};

                	if(nV!=null && nV != undefined && nV.length >= 3){
                		param.masterName=nV;
                	}
                	this.loadStandardMasterStore(combo,param);
                	/** this code is added for this bug start V2D-357373 **/
                	  var pGrid = this.getStdMasterParentGrid();
                        pGrid.down('#btnAdd').setDisabled(false);
                        pGrid.down('#btnEdit').setDisabled(false);
                        pGrid.down('#btnView').setDisabled(false);
						if(combo.getRawValue() == getTranslation('MONTHLY_REPORT_MASTER_OSM')){
						pGrid.down('#btnAdd').setDisabled(true);
						pGrid.down('#btnDelete').setDisabled(true);
						}
               		/** end **/
                },
            	select: function(combo, records) {
            		var parentResponseData = null,this$=this;
            		var parentTableId = null;
            		var childTableId = null, childResponseData = null;
            		var pGrid = this.getStdMasterParentGrid();
					pGrid.setTitle(getCommonTranslation('STD_MASTER_GRID'));
            		var standardMaster = this.getContentPanel().activeTab;
            		var exportPdfBtn = pGrid.down('#btnExportToPDF');
            		var exportExcelBtn = pGrid.down('#btnExportToExcel');
            		var associatedAcadLocationIds = new Array();
            		var permissionMap=this.getSTANDARD_MASTER_PERMISSIONS();
            		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
            		parentTableId = records[0].get("id");
            		this.setParentTableId(parentTableId);


            		if(combo.getDisplayValue()==getTranslation('STANDARD_PAYMENT_GATEWAY')){
            			standardMaster.down('#activePaymentGatewayCombo').reset();
            			standardMaster.down('#activePaymentGatewayCombo').setVisible(true);
            			standardMaster.down('#paymentGatewayConfig').setVisible(true);
            			this$.getStdMasterParentGrid().setVisible(false);
            			this$.getStdMasterChildGrid().setVisible(false);
            		}else{
            			standardMaster.down('#activePaymentGatewayCombo').setVisible(false);
            			standardMaster.down('#paymentGatewayConfig').setVisible(false);
            			// Make parent HBOX visible
            			this$.getStdMasterParentGrid().setVisible(true);
            		}
            		//Get grid data
            		parentResponseData = this$.getGridMetaData(parentTableId);
            		this$.setParentResponseData(parentResponseData);

            		//Reconfigure parentHBOX
            		this$.reconfigureParentGrid(parentTableId, parentResponseData);

            		//Check for parent child relation
            		if (parentResponseData.whetherParent && (parentResponseData.tableName!="standard_payment_gateway")) {
            			//Make child HBOX visible
            			this$.getStdMasterChildGrid().setVisible(true);

            			childTableId = parentResponseData.childMaster;
            			this.setChildTableId(childTableId);
            			childResponseData = this$.getGridMetaData(childTableId);

            			this.setChildResponseData(childResponseData);
            			this$.reconfigureChildGrid(childTableId, parentTableId, childResponseData);
            		} else {
            			this$.getStdMasterChildGrid().setVisible(false);
            		}

            		parentResponseData = this.getGridMetaData(parentTableId);
            		exportPdfBtn.setVisible(false);
            		exportExcelBtn.setVisible(false);

            		if(parentResponseData.masterName == 'ADMISSION_INACTIVE_REASON' || parentResponseData.masterName=='student_result_report'
            			|| parentResponseData.masterName=='student_assessment_report' || parentResponseData.masterName=='MULTIPLE_REASON_REQUIRED'
            			||parentResponseData.masterName=='BYPASS_PROGRESSION_ELIGIBILITY_RULES' ||parentResponseData.masterName=='WHATSAPP_CONFIGURATION' 
            			|| parentResponseData.masterName=='student_mark_remark_entry' || parentResponseData.masterName=='MODIFY_APPLICATION_STATUS'){
            			pGrid.down('#btnAdd').setVisible(false);
            			pGrid.down('#btnDelete').setVisible(false);
            		}
            		else{
            			pGrid.down('#btnAdd').setVisible(true);
            			pGrid.down('#btnDelete').setVisible(true);
            		}


            		if(parentResponseData.masterName == 'CHANGE_ENROLLMENT_MASTER' ){
            			pGrid.down('#btnAdd').setVisible(false);
            			pGrid.down('#btnDelete').setVisible(false);
            			pGrid.down('#btnView').setVisible(false);
            		}

            		if(parentResponseData.masterName == 'FEE_HEADS'){
            			Ext.each(permissionList, function(privilege) {
            				if (privilege == 'Export') {

            					pGrid.setTitle(getCommonTranslation('FEE_HEAD'))
            					exportPdfBtn.setVisible(true);
            					exportExcelBtn.setVisible(true);
            				}
            			});
            		}
					if (parentResponseData.masterName == 'SOUTH_AFRICAN_VALIDATION') {
						Ext.each(permissionList, function(privilege) {
							if (privilege == 'Export') {
								exportPdfBtn.setVisible(true);
								exportExcelBtn.setVisible(true);
							}
						});
					}
            	}
            },
            'standardMaster customcombobox[itemId=activePaymentGatewayCombo]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            		store.on('beforeload',function() {
            			store.getProxy().extraParams = {
            				isActive: true,
            			};
            		}, this);
            	},
            	select: function(combo, records) {
            		var parentResponseData = null,this$=this;
            		var parentTableId = null;
            		var childTableId = null, childResponseData = null;
            		var pGrid = this.getStdMasterParentGrid();
            		var standardMaster = this.getStandardMaster();
            		var exportPdfBtn = pGrid.down('#btnExportToPDF');
            		var exportExcelBtn = pGrid.down('#btnExportToExcel');
            		var parentTableId = standardMaster.down('#standardMasterComboField').getValue();
            		var childTableId = records[0].get("code");
            		activePayGatewayComboCode = childTableId;
            		//set parent grid data
            		this.setParentTableId(activePayGatewayComboCode);
            		var parentResponseData = this.getGridMetaData(activePayGatewayComboCode);
            		this.setParentResponseData(parentResponseData);

            		/*//set child grid data
            		this.setChildTableId(childTableId);
            		var childResponseData = this.getGridMetaData(childTableId);
            		this.setChildResponseData(childResponseData);*/

        			this.getStdMasterParentGrid().setVisible(true);
        			this$.reconfigureParentGrid(activePayGatewayComboCode, parentResponseData);

        			/*childTableId = parentResponseData.childMaster;
        			this.setChildTableId(childTableId);
        			childResponseData = this$.getGridMetaData(childTableId);*/
            		exportPdfBtn.setVisible(false);
            		exportExcelBtn.setVisible(false);
            	}
            },
            'activepaymentgatewaywin button[itemId=submitBtn]':{
            	click: function() {
            		this.saveActivePaymentGateway();
            	}
            },
            'activepaymentgatewaywin grid[itemId=paymentGatewayGridId]':{
            	afterrender:function(grid){
            	  grid.getHeader().remove(0);
            	}
            },
            'standardMaster displayfield[itemId=paymentGatewayConfig]':{
            	render: function(component) {
            		var $this = this;
            		var activepaymentgatewaywin = this.getActivepaymentgatewaywin();
            		component.getEl().on('click', function(e) {
            			if (e.target.tagName == "DIV") {
            				if (!activepaymentgatewaywin) {
            					Ext.widget('activepaymentgatewaywin');
            					activepaymentgatewaywin = $this.getActivepaymentgatewaywin();
            				}
            				activepaymentgatewaywin.show();
            				var grid = activepaymentgatewaywin.down('#paymentGatewayGridId');
            				//To get All Payment Gateway
            				grid.store.getProxy().extraParams = {

            				};
            				grid.store.suspendEvent('beforeload');
            				grid.store.load({
            				    callback: function(records, operation, success) {
            				        grid.store.resumeEvent('beforeload');
            				    }
            				});
            			}
            		});
            	},
            },
            //Listener for Parent master grid
            'standardMaster #stdMasterParentGrid ': {
                //On row select
                selectionchange: function(model, records) {
                	var standardScreen = this.getActiveTabfromContentPanel();
                	var pGrid = standardScreen.down('#stdMasterParentGrid');
                	var osmValue = standardScreen.down('#standardMasterComboField');
                	if(records.length>0) {
                	var record = records[records.length-1];
                    var parentRecordId = record.get("id");
                    // If parent child relation load child grid

                    this.setParentRecordId(parentRecordId);
                    var parentResponseData=this.getParentResponseData();
                    if (parentResponseData.whetherParent) {
                        var grid = this.getStdMasterChildGrid();
                    	var parentTableId=this.getParentTableId();
                    	var parentTableData = this.getParentTableId();
                    	if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'mobile_platform_detail') {
                    		parentTableId = parentTableData.parentTableId;
                    	}
                    	if(parentResponseData.tableName == "exam_board_master") {
	                    	if(record.get('equivalentExamBoardId.id')!=undefined && record.data.markingType!=undefined && !isNullOrEmpty(record.data.markingType)){
	                    		if(!isNullOrEmpty(record.get('equivalentExamBoardId.id')) && (record.data.markingType=="GRADE" || record.data.markingType=="Grade"))
	                    			grid.setVisible(true);
		                        else
		                        	grid.setVisible(false);
	                    	}
		                    else
		                    	grid.setVisible(false);
			            }
                        this.updateChildGrid(grid, parentTableId, parentRecordId);
                        grid.down('#nextButtonPaging').removeCls('paginationMarginCls');
                    	grid.down('#lastButton').removeCls('paginationMarginCls');
                    }
                    }
                	else {
                		var parentResponseData=this.getParentResponseData();
                        if (parentResponseData.whetherParent) {
                            var grid = this.getStdMasterChildGrid();
                        	if(parentResponseData.tableName == "exam_board_master") {
    		                	grid.setVisible(false);
    	                    }
                        	grid.getStore().removeAll();
                        	grid.down('#pageSizeCombo').reset();
                        	grid.down('#pagingDisplayField').reset();
                        	grid.down('#pagingDisplayField').setValue('');
                        	grid.down('#nextButtonPaging').addCls('paginationMarginCls');
                        	grid.down('#lastButton').addCls('paginationMarginCls');
    			        }
                    }
                	/*This code addded for V2D-345590*/
                  	  var structure = pGrid.up('standardMaster');
                  	  structure.scrollBy(0,0.5);
                  	  structure.scrollBy(0,-0.5);
                       if(records.length>1)
                		   {
                         pGrid.down('#btnEdit').setDisabled(true);
                         pGrid.down('#btnAdd').setDisabled(true);
                         pGrid.down('#btnView').setDisabled(true);
                		   }
                	  else {
                		  if(records.length==1) {
                              pGrid.down('#btnAdd').setDisabled(true);
                			      }
                		  else{
                              pGrid.down('#btnAdd').setDisabled(false);
                		       }
                		  pGrid.down('#btnEdit').setDisabled(false);
                          pGrid.down('#btnView').setDisabled(false);
                		}
 					if(Ext.isDefined(record) && Ext.isDefined(record.raw.summary_display_column) && Ext.isDefined(record.raw.gridDisplayColumn)){
						pGrid.down('#btnAdd').setDisabled(true);
						pGrid.down('#btnDelete').setDisabled(true);
                	}else{
							pGrid.down('#btnDelete').setDisabled(false);
						}
 					 if(osmValue.getDisplayValue()==getTranslation('STANDARD_PAYMENT_GATEWAY')){
                     	pGrid.down('#btnDelete').setDisabled(true);
                         // Enable delete button only if one record is selected
                         if (records.length === 1) {
                         	pGrid.down('#btnDelete').setDisabled(false);
                         } else {
                         	pGrid.down('#btnDelete').setDisabled(true);
                         }
                     }
                },

            },

            //Listener for Child master grid
            'standardMaster #stdMasterChildGrid': {
                reconfigure: function(grid, eOpts) {
                    var pGrid = this.getStdMasterParentGrid();
                    var store = pGrid.getStore();
                    if (store.isLoading()) {
                        store.on("load", function() {
                           //V2D-345926// pGrid.getSelectionModel().select(0);
                        });
                    }
                    //this.doAccessControlValidation(grid, this.getSTANDARD_MASTER_PERMISSIONS());
                }
            },
            'standardMaster #stdMasterChildGrid': {
                selectionchange: function(model, records) {
                    var pGrid = this.getStdMasterChildGrid();

                	if(records.length>1)
         		   {
                  pGrid.down('#btnEdit').setDisabled(true);
                  pGrid.down('#btnAdd').setDisabled(true);
                  pGrid.down('#btnView').setDisabled(true);
         		   }
         	  else {
         		  if(records.length==1) {
                       pGrid.down('#btnAdd').setDisabled(true);
         			      }
         		  else{
                       pGrid.down('#btnAdd').setDisabled(false);
         		       }
         		  pGrid.down('#btnEdit').setDisabled(false);
                   pGrid.down('#btnView').setDisabled(false);
         		}
            }
            },
            // Master Form submit button click
            'parentFormWindow button[action=Submit]': {
                click: function(model, records) {
                    this.saveUpdateMaterData();
                }
            },
            // Child Form submit button click
            'childFormWindow button[action=Submit]': {
                click: function(model, records) {
                    var parentRecordId=this.getParentRecordId();
                    this.saveUpdateChildMaterData(parentRecordId);
                }
            },

            'parentFormWindow button[action=Cancle]': {
                click: function(model, records) {
                    this.closeParentWindow();
                }
            },
            'childFormWindow button[action=Cancle]': {
                click: function(model, records) {
                    this.closeChildWindow();
                }
            },
            'parentFormWindow form[itemId=stdMasterParentForm] checkboxfield': {
            	change: function (checkbox, newValue, oldValue, eOpts) {

            		var form = checkbox.up('form');
            		// Ensure this is only for the "isMaskingNeeded" checkbox
            		if (form && checkbox.name === 'isMaskingNeeded') {

            			var maskingPatternField = form.query('field')[3]; // Assuming 4th field is maskingPattern

            			if (newValue === true) {
            		                if (maskingPatternField) {
            		                    form.remove(maskingPatternField, true);
            		                }
            		                var combo = Ext.create('Ext.form.ComboBox', {
            		                    xtype: 'nestedJsonCombo',
            		                    name: 'maskingPattern',
            		                    fieldLabel: getCommonTranslation('MASKING_PATTERN') + ':<span style="color:red;">*</span>',
            		                    labelSeparator: '',
            		                    labelAlign: 'top',
            		                    allowBlank: false,
            		                    editable: false,
            		                    forceSelection: true,
            		                    queryMode: 'local',
            		                    displayField: 'value',
            		                    valueField: 'code',
            		                    store: Ext.create('Ext.data.Store', {
            		                        fields: ['id', 'code', 'value'],
            		                        proxy: {
            		                            type: 'ajax',
            		                            url: SERVERURL.PATH_PICKLIST_MASKING_PATTERN_ENUM,
            		                            reader: {
            		                                type: 'json'
            		                            }
            		                        },
            		                        autoLoad: true
            		                    })
            		                });
            		                // Insert at same index where original field was
            		                form.insert(3, combo);
            		                form.isValid();
            			} else {
            				maskingPatternField.reset();
            				maskingPatternField.setVisible(false);
            				maskingPatternField.allowBlank=true;
            				maskingPatternField.setFieldLabel('');
            				maskingPatternField.labelSeparator = '';
            				maskingPatternField.setFieldLabel(getCommonTranslation('MASKING_PATTERN')+ ':<span class="required" style="color:red"> *</span>');
            				form.isValid();
            			}
            		}
            	}
            },
            'parentFormWindow form[itemId=stdMasterParentForm] customcombobox[action=Combobox]':{
            	change: function(combo) {
            		if(combo.name=="equivalentExamBoardId.id"){
            			var form = combo.up('form');
            			var markingType = form.getForm().findField('markingType');
            			var assessmentLevelRequired = form.getForm().findField('assessmentLevelRequired');
            			markingType.setVisible(true);
            			assessmentLevelRequired.setVisible(true);
            		}
            		if(combo.name=="examBoardType.id"){
            			var responseData=this.getParentResponseData();
            			var items = responseData.standardMasterItems;
            			var finalresponse = null;
            			if(items.length>0){
            				for(var i in items){
            					if(items[i].dbFieldName=="equivalentSubjectId")
            						finalresponse=items[i];
            				}
            			}
            			if(finalresponse!=null){
	            			var form = combo.up('form');
	            			var subject = form.getForm().findField('equivalentSubjectId.id');
	            			var examBoardTypeValue = null;
	            			if(combo!=undefined && combo.getValue()!=undefined){
	            				examBoardTypeValue = combo.getValue();
	            			}
	            			var subjectStore = subject.getStore();
	            			var url = SERVERURL.FIND_ALL_SUBJECTS_BY_EQUIVALENT_EXAM_BOARD_ID;
	            		       var  extraParam={
	            		        		id:examBoardTypeValue
	            		        };
	            		        var store = this.createSimpleStore(['id', 'value'], url,extraParam);
	            		        subject.bindStore(store);
	            		        store.load();
	            		        store.commitChanges();
            			}
            		}
            	},
            	select: function(combo) {
            		if(combo.name=="equivalentExamBoardId.id"){
            			var form = combo.up('form');
            			var markingType = form.getForm().findField('markingType');
            			var assessmentLevelRequired = form.getForm().findField('assessmentLevelRequired');
            			markingType.setVisible(true);
            			assessmentLevelRequired.setVisible(true);
            		}
            		if(combo.name=="examBoardType.id"){
            			var responseData=this.getParentResponseData();
            			var items = responseData.standardMasterItems;
            			var finalresponse = null;
            			if(items.length>0){
            				for(var i in items){
            					if(items[i].dbFieldName=="equivalentSubjectId")
            						finalresponse=items[i];
            				}
            			}
            			if(finalresponse!=null){
	            			var form = combo.up('form');
	            			var subject = form.getForm().findField('equivalentSubjectId.id');
	            			var examBoardTypeValue = null;
	            			if(combo!=undefined && combo.getValue()!=undefined){
	            				examBoardTypeValue = combo.getValue();
	            			}
	            			var subjectStore = subject.getStore();
	            			var url = SERVERURL.FIND_ALL_SUBJECTS_BY_EQUIVALENT_EXAM_BOARD_ID;
	            		    var  extraParam={
	            		    		id:examBoardTypeValue
	            		    };
	            		    var flag=0;
	            		    var store = this.createSimpleStore(['id', 'value'], url,extraParam);
	            		    if(subject.getValue()!=undefined && subject.getValue()!=null) {
		            		    store.load({
			                    	callback:function(records,response,success){
			                    		for(var i in records){
			                    			if(records[i].data.id==subject.getValue()){
			                    				flag=1;
			                    				break;
			           						}
			           					}
			                    		if(flag==0){
			                    			subject.reset();
			                    		}
			                    	}
		                    	});
	            		    }
	            		    else {
	            		    	store.load();
	            		    }
	            		    store.commitChanges();
            			}
            		}
            		if(combo.name=="country.id"){
            			var form = combo.up('form');
            			var coutryRegion = form.getForm().findField('countryRegion.id');
            			coutryRegion.reset();
            			var coutryRegionStore = coutryRegion.getStore();
            			var url = SERVERURL.PATH_FIND_COUNTRY_REGION_BY_COUNTRYID;
            		    var  extraParam={
            		    		countryId:combo.getValue()
            		    };
            		    var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            		    coutryRegion.bindStore(store);
            		    store.load();
            		    store.commitChanges();
            		}
            	}
            },
            'childFormWindow form[itemId=stdMasterChildForm] customcombobox[action=Combobox]':{
            	select: function(combo) {
            		if(combo.name=="academyLocationId.id"){
            			var form = combo.up('form');
            			var program = form.getForm().findField('programId.id');
            			if(!isNullOrEmpty(program)){
            				var batch = form.getForm().findField('batchId.id');
                			program.reset();
                			batch.reset();
                			program.setDisabled(false);
                			batch.setDisabled(true);
                			var academyLocationValue = null;
                			if(combo!=undefined && combo.getValue()!=undefined){
                				academyLocationValue = combo.getValue();
                			}
                			var url = SERVERURL.PROGRAMS_FIND_BY_ACADMY_LOCATION_ID;
                			var  extraParam={
                					academyLocationId:academyLocationValue
                			};
                			var store = this.createSimpleStore(['id', 'value'], url,extraParam);
                			program.bindStore(store);
                			store.load();
                			store.commitChanges();
            			}
            		}
            		if(combo.name=="programId.id"){
            			var form = combo.up('form');
            			var batch = form.getForm().findField('batchId.id');
            			if(!isNullOrEmpty(batch)){
            			batch.reset();
            			batch.setDisabled(false);
            			var programValue = null;
            			if(combo!=undefined && combo.getValue()!=undefined){
            				programValue = combo.getValue();
            			}
            			var url = SERVERURL.BATCH_FINDALL;
            			var  extraParam={
            					id:programValue
            			};
            			var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            			batch.bindStore(store);
            			store.load();
            			store.commitChanges();
            			}
            		}
            	}
            }
        });
    },

    loadStandardMasterStore : function(combo,param){
    	var searchText = "";
    	if(param.masterName){
    		 if(!isNullOrEmpty(param.masterName)){
    			 searchText = param.masterName;
    		 }
    		 delete param['masterName'];
    	}

        var store = Ext.create('Academia.store.standardMaster.StandardMasterStore');
        store.load({
        	params:param,
           scope:this,
              callback: function(records,option,success){
                     for(var i=0; i< records.length; i++){
                             var record = records[i];
                             if(isNullOrEmpty(record.get("code"))){
                               record.set("code",getTranslation('OTHER'));
                             }else{
                               record.set("code",getTranslation(record.get('code')));
                             }
                             record.set("value",getTranslation(record.get('value')));
                      }

        	   store.clearFilter(true);
        	   if(!isNullOrEmpty(searchText)){
        		   //store.filter('translatedValue', searchText);
        		   store.filter({
        			   property: 'translatedValue',
        			   value: searchText,
        			   anyMatch: true,
        			   caseSensitive: false
        		   });
        	   }
                      store.commitChanges();
                      combo.bindStore(store);
           }
        });

    },

    closeParentWindow:function(){
    	this.getParentFormWindow().close();
    },
    closeChildWindow: function(){
    	this.getChildFormWindow().close();
    },

    showParentWindow: function(mode) {
    	 var responseData=this.getParentResponseData();
        var parentFormWindow = this.getParentFormWindow();
        if (!parentFormWindow) {
            this.reconfigureParentForm(responseData,mode);
            parentFormWindow = this.getParentFormWindow();
        }
        var stdMasterForm=parentFormWindow.down('#stdMasterParentForm').getForm();
        if(stdMasterForm && stdMasterForm.findField('categoryName')){
        	parentFormWindow.down('#stdMasterParentForm').getForm().findField('categoryName').maxLength=512;
        }
        if(responseData.tableName=="exam_board_master") {
        	form = parentFormWindow.down('#stdMasterParentForm').getForm();
        }
 		if(responseData.tableName=="monthly_report_master_osm" && mode == 'ADD') {
        	showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
    					getCommonTranslation(getCommonTranslation('Contact with the support team to add a new master')));
			return;
        }
        if(responseData.tableName=="document_status") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[4];
        	checkbox.setValue(true);
        }
        if(responseData.tableName=="learning_allowances_csm") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[2];
        	checkbox.setValue(true);
        }
        if(responseData.tableName=="program_completion_award_type_csm") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[3];
        	checkbox.setValue(true);
        }
        if(responseData.tableName=="government_sponsor_csm") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[3];
        	checkbox.setValue(true);
        }
        if(responseData.tableName=="subjects") {
        	parentFormWindow.down('#stdMasterParentForm').getForm().findField('isActive').setValue(true);
        }
        if(responseData.tableName=="admission_condition") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[3];
        	var isEnableAutomation = parentFormWindow.down('#stdMasterParentForm').items.items[4];
        	isEnableAutomation.addClass('academicTermCBCls');
        	checkbox.setValue(true);
        	var conditionText = parentFormWindow.down('#stdMasterParentForm').items.items[5];
        	conditionText.setHeight(100);
        }
        if(responseData.tableName=="pending_offer_letter_csm") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[3];
        	checkbox.setValue(true);
        }
		
		if (responseData.tableName == "enquiry_form_setup_default_al" && mode == "ADD") {
			var grid = this.getStdMasterParentGrid();
			var count = grid.getStore().getCount();
			if (count > 0) {
				showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('Academy Location Already Mapped'));
			}else{
				parentFormWindow.show();	
			}
		}else{
			parentFormWindow.show();
		}
        if(responseData.masterName == 'FEE_HEADS') {
        	this.getVerticalNavigationMenu().collapse();
        	var checkboxes = parentFormWindow.query('checkboxfield');
        	for(var i=0; i<checkboxes.length;i++) {
        		checkboxes[i].setWidth(300);
        	}
        }

        if(responseData.tableName == 'academic_term') {
        	var checkboxes = parentFormWindow.query('checkboxfield');
        	for(var i=0; i<checkboxes.length;i++) {
        		checkboxes[i].addClass('academicTermCBCls');
        	}
        }
		if (responseData.tableName == "south_african_nationalid_validation") {
			var checkboxes = parentFormWindow.query('checkboxfield');
			for (var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].addClass('academicTermCBCls');
			}
		}
        if(responseData.tableName=="identity_type") {
        	var checkbox = parentFormWindow.down('#stdMasterParentForm').items.items[2];
        	var maskingPattern = parentFormWindow.down('#stdMasterParentForm').items.items[3];
        	if (checkbox && checkbox.boxLabel) {
        	        var el = checkbox.el;
        	        if (el) {
        	        	 var labelEl = el.down('.x-form-cb-label');
        	             if (labelEl) {
        	                 labelEl.setStyle({
        	                     display: 'inline-block',
        	                     'padding-left': '2px',
        	                     'vertical-align': 'middle'
        	                 });
        	             }
        	             el.setStyle('white-space', 'nowrap');
        	        }
        	        checkbox.setMargin('23 0 0 0');
        	        checkbox.doComponentLayout();
        	}

        	if(checkbox.getValue()==true){
        		maskingPattern.setVisible(true);
        	}else{
        		maskingPattern.setVisible(false);
        	}
        }
    },

    showChildWindow: function(mode) {
        var childFormWindow = this.getChildFormWindow();
        if (!childFormWindow) {
            this.reconfigureChildForm(mode);
            childFormWindow = this.getChildFormWindow();
        }
        this.changeSubTopicForm(childFormWindow);
        childFormWindow.show();
    },


    parentEditBtnClick: function() {

        var grid = this.getStdMasterParentGrid();
        var responseData=this.getParentResponseData()
        var responseData=this.getParentResponseData();
        if (grid.getSelectionModel().getCount() > 0) {
            this.showParentWindow("EDIT");
            var form = this.getStdMasterParentForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
                form.loadRecord(records[0]);
                if(responseData.tableName == "pending_offer_letter_csm" && !isNullOrEmpty(records[0].data.pendingOfferActive)){

                	var value = form.getForm().findField('value');
	                var code = form.getForm().findField('code');
	                var sequenceNo = form.getForm().findField('sequenceNo');
                	Ext.Ajax.request({
                		type: 'rest',
                		url: SERVERURL.PATH_FIND_PENDING_OFFER_BY_CODE_VALUE,
                		params:{
                  	       		id:records[0].data.id,
                  	    },
                		method: 'GET',
                		success: function(res, action) {
                			var response = Ext.decode(res.responseText);
                			if(response == 0){
                				value.setReadOnly(false);
                                code.setReadOnly(false);
                                sequenceNo.setReadOnly(false);
                			}else{
                				value.setReadOnly(true);
                                code.setReadOnly(true);
                                sequenceNo.setReadOnly(true);
                			}
                		}
                	});
                }
if(responseData.tableName == "change_enrollment_master_csm" && !isNullOrEmpty(records[0].data)){

		var isConfigure = form.getForm().findField("isConfigure");
		var isCurrentAcademicTerm = form.getForm().findField('isCurrentAcademicTerm');
		if(records[0].data.isConfigure=="Yes"){
			isConfigure.setValue(true);
		}else{
			isConfigure.setValue(false);
		}

		if(records[0].data.isCurrentAcademicTerm=="Yes"){
			isCurrentAcademicTerm.setValue(true);
		}else{
			isCurrentAcademicTerm.setValue(false);
		}
                	/*Ext.Ajax.request({
                		type: 'rest',
                		url: SERVERURL.PATH_FIND_PENDING_OFFER_BY_CODE_VALUE,
                		params:{
                  	       		id:records[0].data.id,
                  	    },
                		method: 'GET',
                		success: function(res, action) {
                			var response = Ext.decode(res.responseText);
                			if(response == 0){
                				value.setReadOnly(false);
                                code.setReadOnly(false);
                                sequenceNo.setReadOnly(false);
                			}else{
                				value.setReadOnly(true);
                                code.setReadOnly(true);
                                sequenceNo.setReadOnly(true);
                			}
                		}
                	});*/
                }

                if(records[0].data.promotionEligibilityRules =='Bypass Promotion Rules' || records[0].data.promotionEligibilityRules =='Bypass Passout Rules'){
                	 var promotionEligibilityRules=form.getForm().findField('promotionEligibilityRules');
                	 promotionEligibilityRules.setReadOnly(true);
                }
                if(responseData.tableName == "learning_allowances_csm" && !isNullOrEmpty(records[0].data.activeStatus)){

                	var value = form.getForm().findField('value');
                	Ext.Ajax.request({
                		type: 'rest',
                		url: SERVERURL.PATH_FIND_LA_BY_CODE_VALUE,
                		params:{
                  	       		learningAllowancesCSMId:records[0].data.id,
                  	    },
                		method: 'GET',
                		success: function(res, action) {
                			var response = Ext.decode(res.responseText);
                			if(response == 0){
                				value.setReadOnly(false);
                			}else{
                				value.setReadOnly(true);
                			}
                		}
                	});
                }
                if(responseData.tableName == "program_completion_award_type_csm" && !isNullOrEmpty(records[0].data.activeStatus)){

		                    var value = form.getForm().findField('value');
		                    var code = form.getForm().findField('code');
		                    var sequenceNo = form.getForm().findField('sequenceNo');
		                    Ext.Ajax.request({
		                        type: 'rest',
		                        url: SERVERURL.PATH_FIND_PC_BY_CODE_VALUE,
		                        params:{
		                        	programCompletionAwardTypeCSMId:records[0].data.id,
		                          },
		                        method: 'GET',
		                        success: function(res, action) {
		                            var response = Ext.decode(res.responseText);
		                            if(response == 0){
		                                value.setReadOnly(false);
		                                code.setReadOnly(false);
		                                sequenceNo.setReadOnly(false);
		                            }else{
		                                value.setReadOnly(true);
		                                sequenceNo.setReadOnly(true);
		                                code.setReadOnly(true);
		                            }
		                        }
		                    });
		           }

                if(responseData.masterName == "CHANGE_ENROLLMENT_MASTER"){

                    var from = form.getForm().findField("changeEnrollmentMasterFrom");
                    var to = form.getForm().findField('changeEnrollmentMasterTo');

                    if(!isNullOrEmpty(from) && Ext.isDefined(from)){
                    	from.setReadOnly(true);
                    }

                    if(!isNullOrEmpty(to) && Ext.isDefined(to)){
                    	to.setReadOnly(true);
                    }
                    /*Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_FIND_PC_BY_CODE_VALUE,
                        params:{
                        	programCompletionAwardTypeCSMId:records[0].data.id,
                          },
                        method: 'GET',
                        success: function(res, action) {
                            var response = Ext.decode(res.responseText);
                            if(response == 0){
                                value.setReadOnly(false);
                                code.setReadOnly(false);
                                sequenceNo.setReadOnly(false);
                            }else{
                                value.setReadOnly(true);
                                sequenceNo.setReadOnly(true);
                                code.setReadOnly(true);
                            }
                        }
                    });*/
           }

if(responseData.tableName == "government_sponsor_csm" && !isNullOrEmpty(records[0].data.governmentSponsorActive)){

                    var value = form.getForm().findField('value');
                    var code = form.getForm().findField('code');
                    var sequenceNo = form.getForm().findField('sequenceNo');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_FIND_GS_PERSON_BY_CODE_VALUE,
                        params:{
                        	governmentSponsorCSMId:records[0].data.id,
                          },
                        method: 'GET',
                        success: function(res, action) {
                            var response = Ext.decode(res.responseText);
                            if(response == 0){
                                value.setReadOnly(false);
                                code.setReadOnly(false);
                                sequenceNo.setReadOnly(false);
                            }else{
                                value.setReadOnly(true);
                                sequenceNo.setReadOnly(true);
                                code.setReadOnly(true);
                            }
                        }
                    });
           }


                if(responseData.tableName == "admission_condition" && !isNullOrEmpty(records[0].data.isActive)){

                	var value = form.getForm().findField('value');
                	var code = form.getForm().findField('code');
                	var offerType = form.getForm().findField('offerType');
                	var conditionText = form.getForm().findField('conditionText');
                	Ext.Ajax.request({
                		type: 'rest',
                		url: SERVERURL.PATH_FIND_ADM_CON_BY_CODE_VALUE,
                		params:{
                			admissionConditionId:records[0].data.id,
                  	    },
                		method: 'GET',
                		success: function(res, action) {
                			var response = Ext.decode(res.responseText);
                			if(response == 0){
                				value.setReadOnly(false);
                				code.setReadOnly(false);
                				offerType.setReadOnly(false);
                				conditionText.setReadOnly(false);
                			}else{
                				value.setReadOnly(true);
                				code.setReadOnly(true);
                				offerType.setReadOnly(true);
                				conditionText.setReadOnly(true);
                			}
                		}
                	});
                }if(responseData.tableName == "identity_type"){
                	if(records[0].data.isMaskingNeeded==true){
                		form.getForm().findField('isMaskingNeeded').setReadOnly(true);
                    	form.getForm().findField('maskingPattern').getStore().load({
                    	        callback: function() {
                    	        	form.getForm().findField('maskingPattern').setValue(records[0].data.maskingPattern); // or .code if object
                    	        	form.getForm().findField('maskingPattern').setReadOnly(true);
                    	        }
                    	    });
                	}else{
                    	form.getForm().findField('isMaskingNeeded').setReadOnly(false);
                    	form.getForm().findField('maskingPattern').setReadOnly(false);
                    }
                }

                if(!isNullOrEmpty(form.getForm().findField('conditionText')) && Ext.isDefined(form.getForm().findField('conditionText'))){
                	form.getForm().findField('conditionText').setValue(records[0].raw.fullConditionText);
                }
                if(!isNullOrEmpty(form.getForm().findField('isResultPublish')) && Ext.isDefined(form.getForm().findField('isResultPublish'))){
                		form.down('#isResultPublish').setValue({isResultPublish: records[0].get('isResultPublish')});
                	}
                if(!isNullOrEmpty(form.getForm().findField('employeeLanguage')) && Ext.isDefined(form.getForm().findField('employeeLanguage'))){
                	var  employeeLanguage= form.getForm().findField('employeeLanguage');
                	if(employeeLanguage.getValue()==0){
                		employeeLanguage.setValue("");
                	}
            	}
                if(!isNullOrEmpty(form.getForm().findField('role-id')) && Ext.isDefined(form.getForm().findField('role-id'))) {
                	var roles = form.getForm().findField('role-id');
                	var rolesStore = roles.getStore();
                	var vals = [];
                	rolesStore.load({
                		callback: function() {
                			for(var i = 0; i < records[0].data.academicTopicRoles.length; i++) {
                        		var rec = rolesStore.findRecord('id', records[0].data.academicTopicRoles[i].id);
                        		if(rec) {
                        			vals.push(rec);
                        		}
                        	}
                        	roles.select(vals);
                		}
                	});
                }
                if(!isNullOrEmpty(form.getForm().findField('academyLocation-id')) && Ext.isDefined(form.getForm().findField('academyLocation-id'))) {
                	var academyLocation = form.getForm().findField('academyLocation-id');
                	var academyLocationStore = academyLocation.getStore();
                	var vals = [];
                	academyLocationStore.load({
                		callback: function() {
                			for(var i = 0; i < records[0].data.academyLocation.length; i++) {
                        		var rec = academyLocationStore.findRecord('id', records[0].data.academyLocation[i].id);
                        		if(rec) {
                        			vals.push(rec);
                        		}
                        	}
                			academyLocation.select(vals);
                		}
                	});
                }
               
                 if(!isNullOrEmpty(form.getForm().findField('programGroupFinance-id')) && Ext.isDefined(form.getForm().findField('programGroupFinance-id'))) {
                	var programGroupFinance = form.getForm().findField('programGroupFinance-id');
                	var programGroupFinanceStore = programGroupFinance.getStore();
                	var vals = [];
                	programGroupFinanceStore.load({
                		callback: function() {
                			for(var i = 0; i < records[0].data.programGroupFinance.length; i++) {
                        		var rec = programGroupFinanceStore.findRecord('id', records[0].data.programGroupFinance[i].id);
                        		if(rec) {
                        			vals.push(rec);
                        		}
                        	}
                			programGroupFinance.select(vals);
                		}
                	});
                } 

                if(!isNullOrEmpty(form.getForm().findField('courseCESMRole-id')) && Ext.isDefined(form.getForm().findField('courseCESMRole-id'))) {
                	var courseCESMRole = form.getForm().findField('courseCESMRole-id');
                	var courseCESMRoleStore = courseCESMRole.getStore();
                	var vals = [];
                	courseCESMRoleStore.load({
                		callback: function() {
                			for(var i = 0; i < records[0].data.courseCESMRole.length; i++) {
                        		var rec = courseCESMRoleStore.findRecord('id', records[0].data.courseCESMRole[i].id);
                        		if(rec) {
                        			vals.push(rec);
                        		}
                        	}
                			courseCESMRole.select(vals);
                		}
                	});
                }

				var isColumnVisible = form.getForm().findField('isVisible');
				if(!isNullOrEmpty(isColumnVisible)) {
					isColumnVisible.getStore().load({
						callback: function() {
							if(records[0].get('isVisible')==true){
								isColumnVisible.setValue("Visible");
							}else{
								isColumnVisible.setValue("Hide");
							}

						}
					});
				}


                }
        } else {
        	showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    childEditBtnClick: function() {

        var grid = this.getStdMasterChildGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            this.showChildWindow("EDIT");
            var form = this.getStdMasterChildForm();
            var records = grid.getSelectionModel().getSelection();
            if (records != undefined && records != "" && records != null) {
                form.loadRecord(records[0]);
                var cb = form.down('checkbox[name=visibility]');
                if(cb) {
                	cb.setValue(records[0].get('visibility'));
                }
                if(!isNullOrEmpty(form.getForm().findField('isResultPublish')) && Ext.isDefined(form.getForm().findField('isResultPublish'))){
                	form.down('#isResultPublish').setValue({isResultPublish: records[0].get('isResultPublish')});
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    viewParentFormWindow:function(){
    	var me = this;
    	this.parentEditBtnClick();
    	setTimeout(function(){
    		var form = me.getStdMasterParentForm();
    		if(form){
    			if(form.itemId=='stdMasterChildForm'){
    				form.down('#formSubmitButtonId').setVisible(false);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
	               }

    			form=form.getForm();
    			toggleReadOnlyFormItems(form,true);
    		}
    	},300);
    },
    viewChildFormWindow:function(){
    	this.childEditBtnClick();
    	 var form = this.getStdMasterChildForm();
    	 if(form){
    		 if(form.itemId=='stdMasterChildForm'){
 				form.down('#formSubmitButtonId').setVisible(false);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
	               }
    		form=form.getForm();
    		toggleReadOnlyFormItems(form,true);
    	 }
    },

    deleteButtonClick: function(grid,tableId,gridType) {
         if (grid.getSelectionModel().getCount() > 0) {
             var records = grid.getSelectionModel().getSelection()[0];
             if (records != undefined && records != "" && records != null) {
            	 this.deleteMasterData(grid, tableId, records.index, gridType);
             }
         } else {
        	 showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
    },
    /**
     * Dynamically create master grid and form from table id and table meta data.
     *
     * @param parentTableId
     *             Unique identifier for the standard master.
     * @param responseData
     *             Meta data for columns and store model.
     */
    reconfigureParentGrid: function(parentTableId, responseData) {

        var this$ = this;
        var columnModel = [];
        var columnHeader = [];
        var columnMetaData = responseData.standardMasterItems;
        var parentGrid = this.getStdMasterParentGrid();

        if(responseData.masterName == "EXAM_BOARD_MASTER" && responseData.tableName == "exam_board_master") {
         	var newColumnMetaData = [];
         	for(i = 0; i < columnMetaData.length ; i++) {
         		newColumnMetaData[i] = columnMetaData[i];
         		if(i>1 && i<6) {
         		  newColumnMetaData[i].diaplayOrder = i+2;
         		}
         		if(i == 6) {
         		 newColumnMetaData[i].diaplayOrder = 3;
         		}
         	}
           newColumnMetaData.sort(function(a, b){return a.diaplayOrder - b.diaplayOrder});
              // Load header for grid and model fields.
            this$.loadColumnModelAndHeader(columnModel, columnHeader, newColumnMetaData);
         }
         else {
               // Load header for grid and model fields.
         	 this$.loadColumnModelAndHeader(columnModel, columnHeader, columnMetaData);
         }

        // Add delete action column in grid.
//        columnHeader.push(this$.getDeleteActionColumn(parentGrid, parentTableId));\
        this$.createGrid(parentGrid, columnModel, columnHeader, parentTableId);
    },

    reconfigureParentForm: function(responseData,mode) {
        var columnMetaData = responseData.standardMasterItems;
        var form = this.getStdMasterParentForm();
        if (!form) {
        	parentFormWindow= Ext.widget('parentFormWindow');
            form = this.getStdMasterParentForm();
        }
        this.createForm(form, columnMetaData,mode);
    },


    /**
     * Dynamically create child master grid and form from table id and table meta data.
     *
     * @param childTableId
     *             Unique identifier for the standard master.
     * @param parentTableId
     *             Unique identifier for the parent standard master.
     * @param responseData
     *             Meta data for columns and store model.
     */
    reconfigureChildGrid: function(childTableId, parentTableId, responseData) {
        var this$ = this;
        var columnModel = [];
        var columnHeader = [];
        var columnMetaData = responseData.standardMasterItems;
        var grid = this$.getStdMasterChildGrid();

        //Load header for grid and model fields.
        this$.loadColumnModelAndHeader(columnModel, columnHeader, columnMetaData);
        grid.config.masterName = responseData.masterName;

        // Add delete action column in grid.
//        columnHeader.push(this$.getDeleteActionColumn(grid, childTableId));
        this$.createChildGrid(grid, columnModel, columnHeader, parentTableId);
    },

    reconfigureChildForm: function(mode) {
    	var responseData=this.getChildResponseData();
        var columnMetaData = responseData.standardMasterItems;
        var form = this.getStdMasterChildForm();

        if (!form) {
            Ext.widget('childFormWindow');
            form = this.getStdMasterChildForm();
        }
        this.createForm(form, columnMetaData,mode);
        if(columnMetaData.length>0) {
        	masterName = columnMetaData[0].standardMaster.value;
        }
        if(mode=="ADD" && (masterName=="PROGRAM_SUBJECT_MAPPING")) {
        	var parentGrid = this.getStdMasterParentGrid();
        	var selectedRecord = parentGrid.getSelectionModel().getSelection()[0];
        	var subjectTypeSelected = selectedRecord.data["subjectType.id"];
        	var childForm = this.getStdMasterChildForm();
        	var getChildForm = childForm.getForm();
        	var subjectType = getChildForm.findField('subjectType.id');
        	subjectType.getStore().load({
        		callback:function(records,response,success){
            		for(var i in records){
            			if(records[i].data.id==subjectTypeSelected){
            				subjectType.setValue(records[i].data.id);
   						}
   					}
            	}
        	})
        }
        if(mode=="EDIT" && (masterName=="DOCUMENT_MASTER_TYPE")) {
        	var parentGrid = this.getStdMasterChildGrid();
        	var selectedRecord = parentGrid.getSelectionModel().getSelection()[0];
        	var fileTypeSelected = selectedRecord.data["fileType.id"];
        	var childForm = this.getStdMasterChildForm();
        	var getChildForm = childForm.getForm();
        	var fileType = getChildForm.findField('fileType');
        	fileType.getStore().load({
        		callback:function(records,response,success){
            		for(var i in records){
            			if(records[i].data.id==fileTypeSelected){
            				fileType.setValue(records[i].data.id);
   						}
   					}
            	}
        	})
        }
    },


    /**
     *  This method loads header for grid and model fields of store.
     *
     * @param columnModel
     *             Array in which model for store will be added.
     * @param columnHeader
     *             Array in which header for grid will be added.
     * @param columnMetaData
     *             Meta data for columns and store model.
     */
    loadColumnModelAndHeader: function(columnModel, columnHeader, columnMetaData) {
        var this$ = this;
        Ext.each(columnMetaData, function(obj) {
            var fieldName = obj.dbFieldName;
            if (obj.whetherForeignKey) {
                fieldName = obj.dbFieldName + "." + obj.fkDisplayField;
                columnModel.push({
                    name: obj.dbFieldName + ".id"
                });
            }
            if (obj.type == 'Date') {
                columnModel.push({
                    name: fieldName,
                    type: obj.type,
                    dateFormat: CONSTANTS.DATE_FORMAT
                });
                // add the records to the array
                columnHeader.push({
                    header: this$.getFieldLabel(obj.fieldLabel),
                    flex: 1,
                    //maxWidth:150,
                    dataIndex: fieldName,
                    renderer: function(date) {
                        return dateRender(date);
                    }
                });
            } else {
					if(fieldName!='costCenters'){
						if(fieldName != 'role') {
							columnModel.push({
								name: fieldName,
								type: obj.type
							});
						}
						else {
							columnModel.push({
								name: 'academicTopicRoles',
								type: obj.type
							});
							columnModel.push({
								name: fieldName,
								type: obj.type,
								sortable: false,
								convert: function(v, record) {
									return record.get('academicTopicRoles').length;
								}
							});
						}
	                // add the records to the array
						/*if(fieldName == "progressionStatus"){
							columnHeader.push({
			                    header: this$.getFieldLabel(obj.fieldLabel),
			                    flex: 1,
								sortable: false,
			                    //maxWidth:150,
			                    dataIndex: fieldName,
			                   
			                });	
						}*/ if(fieldName == "role"){
							columnHeader.push({
			                    header: this$.getFieldLabel(obj.fieldLabel),
			                    flex: 1,
								sortable: false,
			                    //maxWidth:150,
			                    dataIndex: fieldName,

			                });
						}
						else{
							if(fieldName == "progressionStatus"){
								columnHeader.push({
				                    header: this$.getFieldLabel(obj.fieldLabel),
				                    flex: 1,
				                    //maxWidth:150,
				                    dataIndex: fieldName,
				                    renderer: function(val){
				                    	if(val == "Pass_Out"){
				                    		return "Pass Out";
				                    	}
				                    	return val;
				                    }
				                });
							}
							else if(fieldName == "academyLocation"){
								columnHeader.push({
				                    header: this$.getFieldLabel(obj.fieldLabel),
				                    flex: 1,
				                    dataIndex: fieldName,
				                    renderer: function(val){
				                    	if(!isNullOrEmpty(val)){
				                    		return Ext.Array.pluck(val,'value').join();
				                    	}
				                    	return val;
				                    }
				                });
							}
							else if(fieldName == "programGroupFinance"){
								columnHeader.push({
				                    header: this$.getFieldLabel(obj.fieldLabel),
				                    flex: 1,
				                    dataIndex: fieldName,
				                    renderer: function(val){
				                    	if(!isNullOrEmpty(val)){
				                    		return Ext.Array.pluck(val,'value').join();
				                    	}
				                    	return val;
				                    }
				                });
							}
							else if(fieldName == "courseCESMRole"){
								columnHeader.push({
				                    header: this$.getFieldLabel(obj.fieldLabel),
				                    flex: 1,
				                    dataIndex: fieldName,
				                    renderer: function(val){
				                    	if(!isNullOrEmpty(val)){
				                    		return Ext.Array.pluck(val,'value').join();
				                    	}
				                    	return val;
				                    }
				                });
						} else if (fieldName == "relavantToFormType") {
							columnHeader.push({
								header: this$.getFieldLabel(obj.fieldLabel),
								flex: 1,
								dataIndex: fieldName,
								renderer: function(val) {
									if (!isNullOrEmpty(val)) {
										if(val=="APPLICATION"){
											return "Application";	
										}else if(val=="ONLINE_ENQUIRY_FORM"){
										return "Online Enquiry Form";	
									}else if(val=="ONLINE_SINGUP_FORM"){
										return "Online Sign Form";	
									}else if(val=="IMPORT_BULK_APPLICATION"){
										return "Import Bulk Application";	
							   		}else if(val=="DIRECT_ADMISSION"){
										return "Direct Admission";	
								  }else if (val=="IMPORT_BULK_ADMISSION"){
										return "Import Bulk Admission";
									}else {
									return "";
									}
								}
								}
							});
							}else if (fieldName == "activeStatus") {
								columnHeader.push({
									header: 'Status',
									flex: 1,
									dataIndex: fieldName,
									renderer: function(val) {
										if (val) {
											return "Active";
										}else{
											return "Inactive";
										}
									}
								});
								}
							else {
			                columnHeader.push({
			                    header: this$.getFieldLabel(obj.fieldLabel),
			                    flex: 1,
			                    //maxWidth:150,
			                    dataIndex: fieldName
			                });
							}
						}
					}

            }
        });

        columnModel.push({
            name: 'version'
        });
    },

    /**
     *  This method used to save or update master.
     *  Check for id, if is is null call save else call update
     *
     * @param parentTableId
     *              Unique identifier for the standard master.
     */
    saveUpdateMaterData: function() {
    	var this$ = this;
        var form = this.getStdMasterParentForm();
        /* Disable button to overcome duplicate submit */
        if(form.itemId=='stdMasterChildForm'){
			form.down('#formSubmitButtonId').setVisible(false);
           }else{
        	   form.up('form').down('#formSubmitButtonId').setVisible(false);
           }

        var stdMasterParentGrid = this.getStdMasterParentGrid();
        var submitUrl;
        var successMessge,	parentTableId=this.getParentTableId();
        var parentTableData = this.getParentTableId();

        // Get form data in string form.
        var values = form.getValues();

        if(values['role-id']){
        	if(Ext.isArray(values['role-id'])){
	    	var 	emptyArry=[];
	    	values['role-id'].forEach(function(rec){
	    			if(rec){
	    				emptyArry.push(rec.data.id);
	    			}
	    		});
	    	var roleIds =emptyArry.join();
	    	delete values['role-id']
	    	}

        }

        if(values['academyLocation-id']){
        	if(Ext.isArray(values['academyLocation-id'])){
	    	var 	emptyArry=[];
	    	values['academyLocation-id'].forEach(function(rec){
	    			if(rec){
	    				emptyArry.push(rec.data.id);
	    			}
	    		});
	    	var academyLocationIds =emptyArry.join();
	    	delete values['academyLocation-id']
	    	}

        }
        
         if(values['programGroupFinance-id']){
        	if(Ext.isArray(values['programGroupFinance-id'])){
	    	var 	emptyArry=[];
	    	values['programGroupFinance-id'].forEach(function(rec){
	    			if(rec){
	    				emptyArry.push(rec.data.id);
	    			}
	    		});
	    	var programGroupFinanceIds =emptyArry.join();
	    	delete values['programGroupFinance-id']
	    	}

        }

        if(values['courseCESMRole-id']){
        	if(Ext.isArray(values['courseCESMRole-id'])){
	    	var 	emptyArry=[];
	    	values['courseCESMRole-id'].forEach(function(rec){
	    			if(rec){
	    				emptyArry.push(rec.data.id);
	    			}
	    		});
	    	var courseCESMRoleIds =emptyArry.join();
	    	delete values['courseCESMRole-id']
	    	}

        }
//      if(values['role-id']){
//    	if(Ext.isArray(values['role-id'])){
//    	var academicTopicRoles=[];
//    	var 	emptyArry=[];
//    	values['role-id'].forEach(function(rec){
//    			if(rec){
//    				var obj = {};
//    				obj.id = rec.data.id;
//    				emptyArry.push(rec.data.id);
//    				academicTopicRoles.push(obj)
//    			}
//    		});
//     	delete values['role-id']
//     	var roleIds =emptyArry.join();
//
//
//    	}
//
//    }



        values=this.changeValueIntoEnumAcademicTopic(values);
        values=this.changeValueIntoEnumdublinDescriptor(values);
        values=this.changeValueProgramLearningOutcome(values);
        values=this.changeValueGeneralEducationCategory(values);
        var validationCheck = false;

        if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'country') {
    		parentTableId = parentTableData.parentTableId;
    		if(parseInt(values.maximumDigit) < parseInt(values.minimumDigit)) {
    			validationCheck = true;
    			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
    					getCommonTranslation(getCommonTranslation('STANDARD_MASTER_MINIMUM_MAXIMUM_DIGIT_MOBILE_CHECK')));
    			if(form.itemId=='stdMasterChildForm'){
    				form.down('#formSubmitButtonId').setVisible(true);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(true);
	               }
    		}
    		if(parseInt(values.phMaxDigit) < parseInt(values.phMinDigit)) {
    			validationCheck = true;
    			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
    					getCommonTranslation(getCommonTranslation('STANDARD_MASTER_MINIMUM_MAXIMUM_DIGIT_PHONE_CHECK')));
    			if(form.itemId=='stdMasterChildForm'){
    				form.down('#formSubmitButtonId').setVisible(true);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(true);
	               }
    		}
    	} else if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'mobile_platform_detail') {
    		parentTableId = parentTableData.parentTableId;
    		Ext.Ajax.request({
	            type: 'rest',
				method : 'POST',
				async:false,
	            url: SERVERURL.PATH_SET_PLATFORM_AS_ACTIVE,
	            params: {
					   platform : values.platform
				   },
				   headers: {
					   'Content-Type': 'application/json'
				   },
	            success: function(response) {

	            }
	        });
    	}

        if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'marks_range_bracket') {
        	parentTableId = parentTableData.parentTableId;

        	var maxValue = parseInt(values.marksRangeTo);
        	var minValue = parseInt(values.marksRangeFrom);
        	var validateMarksRangeTo =false;
        	var validateMarksRangeFrom =false;

        	if (maxValue != null) {
        		if (minValue < maxValue) {
        			validateMarksRangeFrom=true;
        		} else {
        			validationCheck = true;
        			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
        					getCommonTranslation(getCommonTranslation('LESS_THAN_MAX_VALUE')));
        			if(form.itemId=='stdMasterChildForm'){
        				form.down('#formSubmitButtonId').setVisible(false);
    	               }else{
    	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
    	               }
        		}
        	} else {
        		return true;
        	}

	   		 if (minValue != null) {
	   			 if (maxValue > minValue) {
	   				validateMarksRangeTo=true;
	   			 } else {
	   				 validationCheck = true;
	   				showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
	    					getCommonTranslation(getCommonTranslation('MORE_THAN_MIN_VALUE')));
	   				if(form.itemId=='stdMasterChildForm'){
	    				form.down('#formSubmitButtonId').setVisible(false);
		               }else{
		            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
		               }
	   			 }
	   		 } else {
	   			 return true;
	   		 }


	   		if(validateMarksRangeFrom  && validateMarksRangeTo){
	   			var marksRangeModel = new Academia.model.gradeMaster.MarksRangeMasterModel();
		   		marksRangeModel.set("id", values.id);
		   		marksRangeModel.set("marksRangeFrom", parseFloat(values.marksRangeFrom));
		   		marksRangeModel.set("marksRangeTo", parseFloat(values.marksRangeTo));
		   		marksRangeModel.set("bracketName", values.bracketName);
				var submitUrl;
				if (values.id == null || values.id == "") {
					submitUrl = SERVERURL.PATH_SAVE_RANGE_VALIDATION;
				} else {
					submitUrl = SERVERURL.PATH_UPDATE_RANGE_VALIDATION;
				}

				var formData = Ext.encode(marksRangeModel.data);
		   		Ext.Ajax.request({
		            type: 'rest',
		            jsonData : formData,
					method : 'POST',
					async:false,
		            url: submitUrl,
		            success: function(response) {
		            	if(response.responseText==getExaminationTranslation('MARKS_RANGE_UNIQUE')){
		            		validationCheck = true;
		            		showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
		            				getCommonTranslation(getExaminationTranslation('MARKS_RANGE_IS_NOT_UNIQUE')));
		            		if(form.itemId=='stdMasterChildForm'){
		        				form.down('#formSubmitButtonId').setVisible(false);
		    	               }else{
		    	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
		    	               }
		            	}else if(response.responseText==getExaminationTranslation('INPUT_DATA_IS_NOT_UNIQUE')){
		            		validationCheck = true;
		            		showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
		            				getCommonTranslation(getExaminationTranslation('MARKS_RANGE_IS_NOT_UNIQUE')));
		            		if(form.itemId=='stdMasterChildForm'){
		        				form.down('#formSubmitButtonId').setVisible(false);
		    	               }else{
		    	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
		    	               }
		            	}else if(response.responseText==getCommonTranslation('BRACKET_NOT_UNIQUE')){
		            		validationCheck = true;
		            		showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
		            				getCommonTranslation(getExaminationTranslation('BRACKET_IS_NOT_UNIQUE')));
		            		if(form.itemId=='stdMasterChildForm'){
		        				form.down('#formSubmitButtonId').setVisible(false);
		    	               }else{
		    	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
		    	               }
		            	}

		            },
		            failure: function(form, action) {
		            	if(form.itemId=='stdMasterChildForm'){
		    				form.down('#formSubmitButtonId').setVisible(false);
			               }else{
			            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
			               }
		            }
		        });
	   		}

        }

        /*Code added for age group changes*/
        if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'age_group') {
    		parentTableId = parentTableData.parentTableId;
    		if(parseInt(values.toYear) == parseInt(values.fromYear) && parseInt(values.toMonth) == parseInt(values.fromMonth)) {
    			validationCheck = true;
    			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
    					getCommonTranslation(getCommonTranslation('THE_FROM_AGE_TO_AGE_NOT_SAME_MSG')));
    			if(form.itemId=='stdMasterChildForm'){
    				form.down('#formSubmitButtonId').setVisible(false);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
	               }
    		}

    		if(parseInt(values.fromYear) > parseInt(values.toYear)) {
    			validationCheck = true;
    			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
    					getCommonTranslation(getCommonTranslation('THE_TO_AGE_NOT_LESS_THEN_FROM_AGE_MSG')));
    			if(form.itemId=='stdMasterChildForm'){
    				form.down('#formSubmitButtonId').setVisible(false);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
	               }
    		}

    		if(parseInt(values.fromYear) == parseInt(values.toYear)) {
    			if(parseInt(values.fromMonth) > parseInt(values.toMonth)){
    				validationCheck = true;
        			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
        					getCommonTranslation(getCommonTranslation('THE_TO_AGE_NOT_LESS_THEN_FROM_AGE_MSG')));
        			if(form.itemId=='stdMasterChildForm'){
        				form.down('#formSubmitButtonId').setVisible(false);
    	               }else{
    	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
    	               }
    			}
    		}
    	}
        if(Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'sg_reason_for_visit') {
        	parentTableId = parentTableData.parentTableId;
        	if(values.reasonForVisit=="other"||values.reasonForVisit=="OTHER" ||values.reasonForVisit=="Other") {
    			validationCheck = true;
    			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
    					getCommonTranslation(getCommonTranslation('DUPLICATE_RECORD_CONDITION')));
    			if(form.itemId=='stdMasterChildForm'){
    				form.down('#formSubmitButtonId').setVisible(false);
	               }else{
	            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
	               }
    		}
    	}

        if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'hostel_waiting_list_type_csm') {
    		parentTableId = parentTableData.parentTableId;
	        	if(form.down('datefield[name=startDate]').getValue() > form.down('datefield[name=endDate]').getValue()) {
	        		validationCheck = true;
	        		showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('STANDARD_MASTER_START_TILL_DATE'));
	        		if(form.itemId=='stdMasterChildForm'){
	    				form.down('#formSubmitButtonId').setVisible(false);
		               }else{
		            	   form.up('form').down('#formSubmitButtonId').setVisible(false);
		               }
				}
        }
        if(this$.getStandardMaster().down('#standardMasterComboField').getDisplayValue().indexOf("Cost Center")!=-1 || this$.getStandardMaster().down('#standardMasterComboField').getDisplayValue()==getTranslation("COST_CENTRE")){
			validationCheck=true;
			var costCentreIds =[];
			if(Ext.isDefined(values['costCenters.id'])){
			Ext.each(values['costCenters.id'], function(value) {
				if(typeof value=='object'){
					costCentreIds.push(value.data.id);
				}else{
				costCentreIds.push(value);
				}
			})
			}else{
				if(Ext.isDefined(stdMasterParentGrid.getSelectionModel().selected.items[0]))
				if(stdMasterParentGrid.getSelectionModel().selected.items[0].raw.controlAccounts!=null){
					var costCenId= stdMasterParentGrid.getSelectionModel().selected.items[0].raw.controlAccounts.id
				costCentreIds.push(costCenId);
				}
				}

			var wsFeeHeadTemp=null;
			if(!isNullOrEmpty(values.feeHead)){
				if(!isNullOrEmpty(values.feeHead.id)){
					wsFeeHeadTemp={
				   			"id":values.feeHead.id
				   			};
				}
			}

			var submitData= {
					id:values.id,
					code:values.code,
					value:values.value,
					description:values.description,
					isControlAccount: values.isControlAccount?values.isControlAccount:false,
					controlAccountIds: costCentreIds.join(),
					wsFeeHead:wsFeeHeadTemp,
					entity:values.entity,
					fundType:values.fundType,
					fundSource:values.fundSource,
					transactionId:values.transactionId,
					future1:values.future1,
					future2:values.future2,
					intercomp:values.intercomp,
					parentControlAccountId:values.controlAccount?values.controlAccount.id:''

			};
	          var submitUrl = SERVERURL.PATH_COST_CENTER_SAVE_UPDATE;
	          if(values.id){
	        	  successMessge = getCommonTranslation('RECORD_UPDATE_SUCCESS');
	          }else{
	        	  successMessge = getCommonTranslation('RECORD_ADD_SUCCESS');
	          }
				this$.applyWindowMask();
	            Ext.Ajax.request({
	         		type : 'rest',
	            	url : submitUrl,
	            	jsonData : Ext.encode(submitData),
	            	method : 'POST',

	            success: function(form, action) {
	            	this$.hideWindowMask();
	            	this$.closeParentWindow();
	            	stdMasterParentGrid.getSelectionModel().deselectAll(true);
	            	stdMasterParentGrid.down('#btnAdd').setDisabled(false);
	                showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
					stdMasterParentGrid.getStore().reload();
	            },
	            failure: function(form, action) {
	            	this$.hideWindowMask();
	            	if(this$.getStdMasterParentForm().itemId=='stdMasterChildForm'){
	            		this$.getStdMasterParentForm().down('#formSubmitButtonId').setDisabled(false);
		               }else{
		            	   this$.getStdMasterParentForm().up('form').down('#formSubmitButtonId').setDisabled(false);
		               }

	            	var resp = Ext.decode(form.responseText);

	            }
	            });
		}
        if(validationCheck != true){
	        this.deleteEmptyFields(values);
	        if(values.isExamFee == 'false'){
	        	values.isExamFee = null;
	        }
	        var formData = Ext.encode(values);
	        /*if(parentTableId == 86){
	        	var charLimit = values.charLimit;
	        	var saveAcademyLocId = values.academyLocation.id;
	        	var currentAcademyLocId = this.getCurrentAcademyLocation();
	        	if(!isNullOrEmpty(charLimit)){
	        		localStorage.setItem('maxLength',charLimit);
	        	}
	        }*/
	        // Check for id, if is is null call save else call update.
	        if (form.getForm().findField('id').getSubmitValue() == null || form.getForm().findField('id').getSubmitValue() == "") {
	            submitUrl = SERVERURL.STANDARD_MASTERS_SAVE;
	            if(this$.getParentResponseData().masterName=='LESSON_PLAN_ASSESSMENT_LEARNING_OUTCOME'){
	            	successMessge = 'Record Saved successfully'
     		    }else{
     		    	 successMessge =  getCommonTranslation('RECORD_ADD_SUCCESS');
     		    }

	            if(parentTableId == 86){
	            	var charLimit = values.charLimit;
	            	if(!isNullOrEmpty(charLimit)){
	            		localStorage.setItem('maxLength',charLimit);
	            	}
	            }
	        } else {
	            submitUrl = SERVERURL.STANDARD_MASTERS_UPDATE;
	            if(this$.getParentResponseData().masterName=='LESSON_PLAN_ASSESSMENT_LEARNING_OUTCOME'){
	            	successMessge = 'Record updated successfully'
     		    }else if(this$.getParentResponseData().masterName=='student_result_report' || this$.getParentResponseData().masterName=='student_assessment_report'){
	            	successMessge = 'Item visibility is changed successfully'
     		    }else{
     		    	successMessge = getCommonTranslation('RECORD_UPDATE_SUCCESS');
     		    }

	            if(parentTableId == 86){
	            	var charLimit = values.charLimit;
	            	if(!isNullOrEmpty(charLimit)){
	            		localStorage.setItem('maxLength',charLimit);
	            	}
	            }
	        }
			if(this$.getParentResponseData().masterName=='FLAG_COLOR'){
	            	var chars = values;
					var specialChars= /[`!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?~]/;
					if(specialChars.test(chars.code) || specialChars.test(chars.value)){
						showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('Special char not allowed'));
						if(form.itemId=='stdMasterChildForm'){
							form.down('#formSubmitButtonId').setDisabled(false);
			               }else{
			            	   form.up('form').down('#formSubmitButtonId').setDisabled(false);
			               }
						return false;
					}else{
						if(form.itemId=='stdMasterChildForm'){
							form.down('#formSubmitButtonId').setDisabled(false);
			               }else{
			            	   form.up('form').down('#formSubmitButtonId').setDisabled(false);
			               }
						}
		     }
			if(this$.getParentResponseData().masterName=='student_result_report'){
				var Form=this.getStdMasterParentForm();
				if(values.isVisible=='Visible'||values.isVisible=='VISIBLE'){
					values.isVisible=true;
				}else{
					values.isVisible=false;
				}
				var newValue=values;
				formData = Ext.encode(newValue);

		     }

			if(this$.getParentResponseData().masterName=='BYPASS_PROGRESSION_ELIGIBILITY_RULES'){
				var Form=this.getStdMasterParentForm();
				if(values.status=='TRUE'){
					values.status='True';
				}else{
					values.status='False';
				}
				var newValue=values;
				formData = Ext.encode(newValue);

		     }

			if(this$.getParentResponseData().masterName=='MANAGE_SECTION_CAMPUSCODE'){
				var Form=this.getStdMasterParentForm();
				if(values.code=='true'){
					values.code=true;
				}else{
					values.code=false;
				}
				var newValue=values;
				formData = Ext.encode(newValue);

		     }

              if(this$.getParentResponseData().masterName=='student_assessment_report' || this$.getParentResponseData().masterName=='student_mark_remark_entry'){
				var Form=this.getStdMasterParentForm();
				if(values.isVisible=='Visible'||values.isVisible=='VISIBLE'){
					values.isVisible=true;
				}else{
					values.isVisible=false;
				}
				var newValue=values;
				formData = Ext.encode(newValue);

		     }
	        this$.applyWindowMask();
	        var parentResponseData=this$.getParentResponseData();
	        if(parentResponseData.masterName === 'IDENTITY_TYPE'){
	        	var form=this.getStdMasterParentForm();
		        var isReadOnly = form.getForm().findField('isMaskingNeeded').readOnly;
		        var isCheckedNow = values.isMaskingNeeded === 'true';
		        //var showConfirmation = false;
	            if (submitUrl==='rest/standardMaster/create' && isCheckedNow) {
	            	 Ext.MessageBox.confirm(
	     	                getCommonTranslation('IDENTITY_TYPE'),
	     	                getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_MASK_ID'),
	     	                function (btn) {
	     	                    if (btn === 'yes') {
	     	                        submitFormData();
	     	                    }else{
	     	                        //Ext.getBody().unmask();
	     	                        this$.hideWindowMask();
	     	                    }
	     	                }
	     	            );
	            } else if (submitUrl==='rest/standardMaster/update') {
	            	if(isReadOnly){
	            		submitFormData();
	            	}else if(!isCheckedNow && !isReadOnly){
	            		submitFormData();
	            	}else if(isCheckedNow && !isReadOnly){
	            		 Ext.MessageBox.confirm(
	         	                getCommonTranslation('IDENTITY_TYPE'),
	         	                getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_MASK_ID'),
	         	                function (btn) {
	         	                    if (btn === 'yes') {
	         	                        submitFormData();
	         	                    }else{
	         	                        //Ext.getBody().unmask();
	         	                        this$.hideWindowMask();
	         	                    }
	         	                }
	         	            );
	            	}
	           } else{
	        	   submitFormData();
	           }
	        }else{
		        	Ext.Ajax.request({
			            type: 'rest',
			            method: 'POST',
			            url: submitUrl,
			            params: {
			                formData: formData,
			                parentTableId: parentTableId,
			                roleIds:roleIds,
			                academyLocationIds: academyLocationIds,
			                courseCESMRoleIds:courseCESMRoleIds,
			                programGroupFinanceIds: programGroupFinanceIds,
			            },
			            headers: {
			                'Content-Type': 'application/json'
			            },

			            success: function(form, action) {
			            	this$.hideWindowMask();
			            	this$.closeParentWindow();
			            	stdMasterParentGrid.getSelectionModel().deselectAll(true);
			            	stdMasterParentGrid.down('#btnAdd').setDisabled(false);
			            	if(parentResponseData.masterName=='ACADEMIC_TOPICS'){
			            		this$.changeAcademicTopicGridValue();
			            	}else{
			            		stdMasterParentGrid.getStore().reload();
			            	}
			                if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'country') {
			            		var academyLocationController = Academia.app.getController('Academia.controller.organization.academylocations.AcademyLocationController');
			            		academyLocationController.getDefaultCountryCode();
			            	}
			                showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
			            },
			            failure: function(form, action) {
			            	this$.hideWindowMask();
			            	if(this$.getStdMasterParentForm().itemId=='stdMasterChildForm'){
			            		this$.getStdMasterParentForm().down('#formSubmitButtonId').setDisabled(false);
				               }else{
				            	   this$.getStdMasterParentForm().up('form').down('#formSubmitButtonId').setDisabled(false);
				               }
			            	this$.getStdMasterParentForm().up('form').down('#formSubmitButtonId').setDisabled(false);
			            	var resp = Ext.decode(form.responseText);
			            	if(!isNullOrEmpty(resp) && resp.length>0){
			            		var keyName = Ext.decode(form.responseText)[0].key;
			            		if(parentResponseData.id==187 && keyName=="obe_correlation_level_mapping_reference"){
			            			showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
			            					getCommonTranslation(getErrorTranslation('cannot_delete_awardee_as_already_used')));
		            			}
			            		if(keyName == "age_group_already_exist"){
			            			showErrorMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
			            					getCommonTranslation(getCommonTranslation('AGE_GROUP_ALREADY_EXIST')));
			            		}
			            	}

			            }
			        });
		    }
	        function submitFormData() {
	            Ext.Ajax.request({
	                type: 'rest',
	                method: 'POST',
	                url: submitUrl,
	                params: {
	                    formData: formData,
	                    parentTableId: parentTableId,
	                    roleIds: roleIds,
	                    academyLocationIds: academyLocationIds,
	                    courseCESMRoleIds: courseCESMRoleIds
	                },
	                headers: {
	                    'Content-Type': 'application/json'
	                },

	                success: function (form, action) {
	                    this$.hideWindowMask();
	                    this$.closeParentWindow();
	                    stdMasterParentGrid.getSelectionModel().deselectAll(true);
	                    stdMasterParentGrid.down('#btnAdd').setDisabled(false);
	                    stdMasterParentGrid.getStore().reload();

	                    showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
	                },

	                failure: function (form, action) {
	                	this$.hideWindowMask();
		            	this$.getStdMasterParentForm().up('form').down('#formSubmitButtonId').setDisabled(false);
	                }
	            });
	        }
	    }
    },

    /**
     *  This method used to save or update child master.
     *  Check for id, if is is null call save else call update.
     *
     * @param parentRecordId
     *              Unique identifier of parent record for the child standard master.
     */
    saveUpdateChildMaterData: function( parentRecordId) {
        var this$ = this, parentTableId=this.getParentTableId();
        var parentTableData = this.getParentTableId();
    	if( Ext.isObject(parentTableData) &&  parentTableData.parentResponseData.tableName == 'mobile_platform_detail') {
    		parentTableId = parentTableData.parentTableId;
    	}
     // Get form data in string form.
        var form = this$.getStdMasterChildForm();
        /* Disable button to overcome duplicate submit */
        if(form.itemId=='stdMasterChildForm'){
        	 form.down('#formSubmitButtonId').setDisabled(true);
        }else{
        	 form.up('form').down('#formSubmitButtonId').setDisabled(true);
        }


        var grid = this$.getStdMasterChildGrid();
        var submitUrl;
        var successMessge;

        var values = form.getValues();

        this.deleteEmptyFields(values);
        var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='ACADEMIC_TOPICS'){
    		if(isNullOrEmpty(values.showInMarksheet)){
        	values.showInMarksheet=false;
        }
    	}
    	if(parentResponseData.masterName=='PLACEMENT_DOCUMENT_MASTER'){
    		values.fileType={
					"id":values.fileType
			}
        }
        var formData = Ext.encode(values);


        if (form.getForm().findField('id').getSubmitValue() == null || form.getForm().findField('id').getSubmitValue() == "") {
            submitUrl = SERVERURL.STANDARD_MASTERS_CHILD_SAVE;
            successMessge =  getCommonTranslation('RECORD_ADD_SUCCESS');
        } else {
            submitUrl = SERVERURL.STANDARD_MASTERS_CHILD_UPDATE;
            successMessge = getCommonTranslation('RECORD_UPDATE_SUCCESS');
        }
        var isProceed = true;
        var masterNameTable = grid.config.masterName;
        if(masterNameTable == 'ACADEMY_YEAR_TENURE'){
        	if(form.down('datefield[name=startDate]').getValue() > form.down('datefield[name=tillDate]').getValue()) {
				showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('STANDARD_MASTER_START_TILL_DATE'));
				 if(form.itemId=='stdMasterChildForm'){
		        	 form.down('#formSubmitButtonId').setDisabled(true);
		        }else{
		        	 form.up('form').down('#formSubmitButtonId').setDisabled(true);
		        }
				isProceed = false;
			}
        }

		if (masterNameTable == 'CITY_PINCODE') {
			if (form.getForm().findField('id').getSubmitValue() == null || form.getForm().findField('id').getSubmitValue() == "") {
				submitUrl = SERVERURL.PATH_CITY_PINCODE_SAVE;
			} else {
				submitUrl = SERVERURL.PATH_CITY_PINCODE_UPDATE;
			}
		}

        if(isProceed){
        	this$.applyWindowMask();
        	Ext.Ajax.request({
        		type: 'rest',
        		method: 'POST',
        		url: submitUrl,
        		params: {
        			formData: formData,
        			parentTableId: parentTableId,
        			parentRecordId: parentRecordId
        		},
        		headers: {
        			'Content-Type': 'application/json'
        		},
        		success: function(form, action) {
        			grid.getStore().reload();
        			this$.hideWindowMask();
        			this$.closeChildWindow();
        			grid.getSelectionModel().deselectAll(true);
        			if(form.responseText=='Only Code Update'){
        				showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('Only Sequence Updated Successfully'));
        			}else{
        				showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), successMessge);
        			}
        		},
        		failure: function(form, action) {
        			this$.hideWindowMask();
        			if(form!=null && form!=undefined && form.responseText=='[{"key":"Dependency exists unable to update","messageParams":[]}]'){
        					showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('Dependency exists unable to update Code'));
        			}
        			 if(this$.getStdMasterChildForm().itemId=='stdMasterChildForm'){
        				 this$.getStdMasterChildForm().down('#formSubmitButtonId').setDisabled(false);
        	        }else{
        	        	this$.getStdMasterChildForm().up('form').down('#formSubmitButtonId').setDisabled(false);
        	        }

        		}
        	});
        }
    },

    /**
     * Fetches the standard master data by id from the server.
     *
     * @param id
     *            Unique identifier for the standard master.
     * @return data
     *            Standard master data.
     */
    getGridMetaData: function(id) {
        var data = null;
        Ext.Ajax.request({
            async: false,
            method: 'get',
            url: SERVERURL.STANDARD_MASTERS + id,
            success: function(response) {
                data = Ext.JSON.decode(response.responseText);
            }
        });
        return data;
    },

    /**
     * Create grid by dynamic columnModel, columnHeader and master table id .
     *
     * @param grid
     *          Reference object of grid.
     * @param columnModel
     *          Array for store model fields.
     * @param columnHeader
     *          Array of header of grid.
     * @param masterId
     *         Unique identifier for the standard master.
     */
    createGrid: function(grid, columnModel, columnHeader, masterId) {

		if(this.getParentResponseData().masterName=='student_result_report' || this.getParentResponseData().masterName=='student_assessment_report' 
		|| this.getParentResponseData().masterName=='MULTIPLE_REASON_REQUIRED' || this.getParentResponseData().masterName=='WHATSAPP_CONFIGURATION'
		|| this.getParentResponseData().masterName=='MODIFY_APPLICATION_STATUS'){
			grid.down('#btnAdd').setVisible(false);
			grid.down('#btnDelete').setVisible(false);
		}else{
			grid.down('#btnAdd').setVisible(true);
			grid.down('#btnDelete').setVisible(true);
		}
        grid.getSelectionModel().deselectAll(true);

        var url = SERVERURL.STANDARD_MASTERS_GRIDDATA;
        var params = {
            id: masterId
        };


        var store = this.createGridStore(columnModel, url, params);
        store.load();
        Ext.suspendLayouts();
		if(this.getParentResponseData().masterName=='student_result_report'){
			columnHeader[1].renderer = function(val) {
				if(val) {
					return 'Visible';
				}
				return 'Hide';
			}
		}
		if(this.getParentResponseData().masterName=='student_assessment_report' || this.getParentResponseData().masterName=='student_mark_remark_entry'){
			columnHeader[1].renderer = function(val) {
				if(val) {
					return 'Visible';
				}
				return 'Hide';
			}
		}
		if(this.getParentResponseData().masterName=='MODIFY_APPLICATION_STATUS'){
			columnHeader[1].renderer = function(val) {
				if(val) {
					return 'Yes';
				}else{
					return 'No';
				}
			}
		}
        grid.reconfigure(store, columnHeader);
        Ext.resumeLayouts(true);
        //Rebind store to grid
        grid.down('custompagingtoolbar').bindStore(store);
        this.changeAcademicTopicGridValue();
        this.changeEnrollmentValue();
        this.changeDublinStatus();
        this.changeProgramLearningOutcomeStatus();
        this.changeGeneralEducationCategoryStatus();
    },


    /**
     * Create child grid by dynamic columnModel, columnHeader and parent master table id.
     *
     * @param grid
     *          Reference object of grid.
     * @param columnModel
     *          Array for store model fields.
     * @param columnHeader
     *          Array of header of grid.
     * @param parentTableId
     *         Unique identifier for the parent standard master.
     */
    createChildGrid: function(grid, columnModel, columnHeader, parentTableId) {
        grid.getSelectionModel().deselectAll(true);
        var url = SERVERURL.STANDARD_MASTERS_CHILD_GRIDDATA;
        var params = {
            parentTableId: parentTableId
        };
        var store = this.createGridStore(columnModel, url, params);
        Ext.suspendLayouts();
        grid.reconfigure(store, columnHeader);
        Ext.resumeLayouts(true);
        grid.down('custompagingtoolbar').bindStore(store);
    },

    /**
     * Updates child grid parent master table id and parent master record id.
     *
     * @param grid
     *          Reference object of grid.
     * @param parentTableId
     *         Unique identifier for the parent standard master.
     * @param parentRecId
     *         Unique identifier for the parent standard master record.
     */
    updateChildGrid: function(grid, parentTableId, parentRecId) {
        grid.getSelectionModel().deselectAll(true);
        var store = grid.getStore();
        store.getProxy().extraParams = {
            parentTableId: parentTableId,
            parentRecId: parentRecId
        };
        store.reload({
            callback: function(records, operation, success) {
                if (success) {
                    grid.getSelectionModel().select(0, true);
                }
            }
        });
        //Rebind store to grid
        grid.down('custompagingtoolbar').bindStore(store);
    },


    /**
     * Create dynamic form by column meta data.
     *
     * @param form
     *          Reference object of form.
     * @param responseData
     *             Meta data for columns and store model.
     */
    createForm: function(form, responseData,mode) {
        var this$ = this;
        var formItems = [];
        var itemsArray = [];
        var itemCount=0;
        var masterName = null;
        if(responseData.length>0) {
        	masterName = responseData[0].standardMaster.value;
        		if(masterName == "DOCUMENT_STATUS" && responseData[0].restrictNote != true){
            		responseData.push({dbFieldName: "whetherRestrictUpdateDocument",
            			diaplayOrder: 4,
            			emunType: null,
            			fieldLabel: "THIS_CHECK_FOR_APPLICANT_STUDENT_PARENT",
            			fkDisplayField: null,
            			fkFieldName: null,
            			fkTable: null,
            			code: "General Setup",
            			displayOtherLanguage: null,
            			value: "DOCUMENT_STATUS",
            			type: "displayfield"
            		});
            		responseData[0].restrictNote =true;

            		var lastRecord=responseData[responseData.length-1];
            		var secondLastRecord=responseData[responseData.length-2];

            		//var newResponseData=responseData;

            		/*newResponseData[newResponseData.length-3]=lastRecord;
            		newResponseData[newResponseData.length-2]=secondLastRecord;

            		responseData = newResponseData;*/
            	}
        }
        var tempVar = 0;
        Ext.each(responseData, function(obj) {
            // Add the records to the formItems array.
        	var field;

            if (obj.type == 'Date') {
                field=this$.getDateField(obj);
            } else if (obj.type == 'Boolean') {
                field=this$.getCheckboxField(obj,mode);
            } else if (obj.type == 'Number') {
                field=this$.getNumberField(obj);
            } else if (obj.type == 'Double') {
                field=this$.getDoubleField(obj);
            }else if(obj.type == 'multiselectcombofield'){
				field =this$.getMultiselectcombofield(obj,mode);
			} else if (obj.whetherForeignKey == true) {
                field=this$.getComboBox(obj,mode);
            } else if (obj.type == 'Enum') {
                field=this$.getEnumDropDown(obj);
            } else if (obj.type == 'RadioGroup') {
                field=this$.getRadioButtonField(obj);
            } else if (obj.type == 'TextArea') {
                field=this$.getfield('textareafield', obj);
            } else if(obj.type == 'displayfield'){
            	field =this$.getDisplayFieldOnlyForDocumentStatus(obj);
            }else field=this$.getTextField(obj);

            if (obj.fieldLabel == 'CONDITION_TEXT') {
            	field=this$.getfieldMax('textareafield', obj);
            }

            if (obj.fieldLabel == 'FILE_TYPE') {
                field=this$.getFileTypeDropDown(obj);
            }

            if(obj.whetherReadOnly && mode=='EDIT'){
            	field.readOnly=true;
            }
            if (!isNullOrEmpty(obj.validationType)) {
            	field.vtype=obj.validationType;
            }
            if (!isNullOrEmpty(obj.maxLength)) {
            	field.maxLength=obj.maxLength;
            }
            if (!isNullOrEmpty(obj.minLength)) {
            	field.minLength=obj.minLength;
            }
            if(masterName=="EXAM_BOARD_MASTER" && obj.fieldLabel=="MARKING_TYPE") {
            	field.hidden=true;
            }
            if(masterName=="EXAM_BOARD_MASTER" && obj.fieldLabel=="ASSESSMENT_LEVEL_REQUIRED") {
            	field.hidden=true;
            }
            if(masterName=="CONVERSION_MASTER" && obj.fieldLabel=="ASSESSMENT_LEVEL") {
            	field.hidden=true;
            }
            if(mode=="ADD" && (masterName=="PROGRAM_SUBJECT_MAPPING" && obj.fieldLabel=="PROGRAM" || masterName=="PROGRAM_SUBJECT_MAPPING" && obj.fieldLabel=="BATCH")) {
            	field.disabled=true;
            }

            if(masterName == 'FEE_HEADS' && responseData.length > 1 && tempVar == 0) {
            	tempVar = 1;
            	if(responseData[0].type != responseData[1].type) {
            		itemCount = 1;
            		if(itemCount==1){
                    	itemCount=0;
                    	itemsArray.push(field);
                    	var fieldcontainer=this$.createFieldcontainer(itemsArray);
                    	itemsArray=[];
                    	formItems.push(field);
                    }else{
                    	itemsArray.push(field);
                    	formItems.push(field);
                    	itemCount++;
                    }
            	}
            	else {
            		if(itemCount==1){
                    	itemCount=0;
                    	itemsArray.push(field);
                    	var fieldcontainer=this$.createFieldcontainer(itemsArray);
                    	itemsArray=[];
                    	formItems.push(field);
                    }else{
                    	itemsArray.push(field);
                    	formItems.push(field);
                    	itemCount++;
                    }
            	}
            }

            else if(itemCount==1){
            	itemCount=0;
            	itemsArray.push(field);
            	var fieldcontainer=this$.createFieldcontainer(itemsArray);
            	itemsArray=[];
            	formItems.push(field);
            }else{
            	itemsArray.push(field);
            	formItems.push(field);
            	itemCount++;
            }

        });

       /* if(itemsArray.length>0){
        	var fieldcontainer=this$.createFieldcontainer(itemsArray);
        	itemsArray=[];
        	formItems.push(fieldcontainer);
        }
*/
        // Add the hidden field for id to the formItems array.
        formItems.push({
            xtype: 'hidden',
            name: 'id'
        });

     // Add the hidden field for id to the formItems array.
        formItems.push({
            xtype: 'hidden',
            name: 'version'
        });

        form.removeAll();

        try{
        	if(formItems[0].xtype == "fieldcontainer" && formItems[0].items[1].name == "showOnApplicantPortal"){
        		formItems[0].layout = {
        			type:'vbox'
        		};
        	}
        }
        catch(e){
        	//--
        }

        form.add(formItems);
        if(form.itemId == 'stdMasterChildForm'){
        	form.add(this$.createButtons());
        }else{
        	form.up('form').add(this$.createButtons());
        }

        if(masterName && masterName == 'READMISSION_REASON_CHILD_CSM') {
        	form.down('customcombobox[name=documentType]').on('change', function(cmp, val) {
        		var cb = form.down('checkbox[name=visibility]');
        		if(val == 'Mandatory') {
        			cb.setValue(true);
        			cb.setReadOnly(true);
        		}
        		else {
        			if(mode != 'EDIT') {
        				cb.setValue(false);
        			}
        			cb.setReadOnly(false);
        		}
        	})
        }
		if(masterName && masterName == 'QUICK_POLL'){
			form.down('numberfield[name=numberOfDays]').setValue(0);
		}
    },

    createFieldcontainer: function(itemArray) {
    	/* field =  {
    				xtype : 'fieldcontainer',
    				width: 'auto',
    		        defaults: {
    		            labelAlign: 'top',
    		            width: 226
    		        },
    		        layout: {
    		            type: 'hbox'
    		        },
    		        items:itemArray
    	 };*/
    	  return itemArray;
    },
    createButtons: function() {
	   var field =  {
			xtype : 'fieldcontainer',
			width : '100%',
//			cls : 'windowBtnPos',
			items : [{
			    xtype: 'button',
	            action: 'Submit',
	            itemId: 'formSubmitButtonId',
	            text: getCommonTranslation('SUBMIT'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true,
	            disabled: true
	        },{
	        	xtype: 'button',
	            text: getCommonTranslation('CANCEL'),
	            action: 'Cancle',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		};
	   return field;
    },

    /**
     * This function create dynamic store with pagination of size 30 by column model and url.
     *
     * @param columnModel
     *          Column model contains array of fields.
     * @param url
     *          URL for reading data.
     */
    createGridStore: function(columnModel, url, params) {
        var store = Ext.create('Ext.data.Store', {
            fields: columnModel,

            autoDestroy: true,
            autoLoad: false,

            remoteFilter: true,
            remoteSort: true,
            sortOnLoad: true,
            pageSize: CONSTANTS.DEFAULT_PAGESIZE,

            extraParams: params,

            proxy: {
                type: 'rest',
                api: {
                    read: url
                },
                reader: {
                    type: 'json',
                    root: 'rows',
                    totalProperty: 'records'
                },
                extraParams: params
            }
        });
        return store;
    },

    /**
     * This function create dynamic store by column model and url.
     *
     * @param columnModel
     *          Column model contains array of fields.
     * @param url
     *          URL for reading data.
     */
    createSimpleStore: function(columnModel, url,extraParam) {
        var store = Ext.create('Ext.data.Store', {
            fields: columnModel,
            proxy: {
                type: 'rest',
                api: {
                    read: url
                },
                reader: {
                    type: 'json'
	            },
	            extraParams:extraParam
            }
        });
        return store;
    },

    /**
     * This function create delete record from database and update store .
     *
     * @param grid
     *          Reference object of grid.
     * @param parentTableId
     *         Unique identifier for the parent standard master.
     * @param rowIndex
     *         Row number for record which is to be delete.
     */
    deleteMasterData: function(grid, parentId, rowIndex, gridType) {
        var msgTitle = '';
        var $this=this;
        var parentResponseData=$this.getParentResponseData();
        var stdMasterParentGrid=$this.getStdMasterParentGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection();

        	//var rec = grid.getStore().getAt(rowIndex);
        	//var recId = rec.get("id");

        	var recIdList = [];
    		for(var i in records) {
    			recIdList.push(records[i].get("id"));
    		}
    		var recId = recIdList.join(',');
        	//var recId = records[0].get("id");
        	var standardMaster = this.getStandardMaster();
        	if(standardMaster){
        		var standardMasterComboField = standardMaster.down('#standardMasterComboField');
        		msgTitle = standardMasterComboField.getRawValue();
        		if(gridType == 'CHILD'){
        			msgTitle = getCommonTranslation('STANDARD_MASTER_CHILD_RECORD');
        		}
        	}
        	showConfirmMessage( msgTitle, getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
        		if (btn == 'yes') {
        			Ext.Ajax.request({
        				method: "DELETE",
        				type: 'rest',
        				url:SERVERURL.STANDARD_MASTERS_DELETE,
        				params: {
        					parentTableId: parentId,
        					recordId: null,
        					recordList: recId
        				},
        				success: function(response) {
							if(parentResponseData.id==265){
 	                        showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('Record Deleted successfully'));
 	            		    }else if(parentResponseData.masterName=='LESSON_PLAN_ASSESSMENT_LEARNING_OUTCOME'){
 	            		    	showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('Record Deleted successfully'));
 	            		    }
							else{
        					showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getCommonTranslation('SUCCESS'));}
        					grid.getSelectionModel().deselectAll(true);
        					grid.down('#btnAdd').setDisabled(false);
        					if(parentResponseData.masterName=='ACADEMIC_TOPICS'){
        						$this.changeAcademicTopicGridValue();
        					}else{
        						grid.getStore().reload();
        					}
        					if($this.getStdMasterChildGrid() && $this.getStdMasterChildGrid().isVisible()){
            					grid.getSelectionModel().select(0, true);
        					}

        				},
        				failure: function(form, action) {
        					grid.getStore().reload();
        					/* for OBE functionality purpose we need to warning pop-up instead of error */
         					if(parentResponseData.id==187){
 	            			/*showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),
 	            					getCommonTranslation(getErrorTranslation('cannot_delete_awardee_as_already_used')));*/
 	            		    }
         					if(parentResponseData.masterName == "blooms_taxonomy_level" && Ext.decode(form.responseText)[0].key == 'False_Blooms_Check') {
         						showWarningMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'), getExaminationTranslation('DEPENDENCIES_EXISTS_BLOOM'));
         					}

        				}
        			});

        		}
        	});
        }
     },


    /**
     * This function create form field by field type and column meta data object.
     * Set	grow : true,
     * Set	growMax :300,
     * Set	growMin :100
     *
     * @param xtype
     *          Xtype for form field.
     * @param obj
     *         Column meta data object.
     */
    getfield: function(xtype, obj) {
        var field;
    	if(xtype == 'checkboxfield') {
    		if(obj.dbFieldName == 'isActive' && obj.fieldLabel =='IS_ACTIVE_CSM' && obj.wheherNullable == false){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					 style: {
    			                marginTop: '27px',
    			            },
    					listeners: {
    						afterrender: function(cb) {
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}else if(obj.dbFieldName == 'activeStatus' && obj.fieldLabel == 'ACTIVE_STATUS' && obj.diaplayOrder == 4){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					style: {
    						 marginTop: '27px',
    					},
    					listeners: {
    						afterrender: function(cb) {
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}else if(obj.dbFieldName == 'governmentSponsorActive' && obj.fieldLabel == 'GOVERNMENT_SPONSOR_ACTIVE' && obj.diaplayOrder == 4){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					style: {
    						 marginTop: '27px',
    					},
    					listeners: {
    						afterrender: function(cb) {
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}else if(obj.dbFieldName == 'studentTransferActive' && obj.fieldLabel == 'ACTIVE' && obj.diaplayOrder == 3){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					listeners: {
    						afterrender: function(cb) {
    							cb.getEl().setStyle({marginTop: '27px'})
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}else if(obj.dbFieldName == 'programTransferActive' && obj.fieldLabel == 'ACTIVE' && obj.diaplayOrder == 3){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					listeners: {
    						afterrender: function(cb) {
    							cb.getEl().setStyle({marginTop: '27px'})
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}else if(obj.dbFieldName == 'withdrawalFromActiveProgram' && obj.fieldLabel == 'ACTIVE' && obj.diaplayOrder == 3){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					listeners: {
    						afterrender: function(cb) {
    							cb.getEl().setStyle({marginTop: '27px'})
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}else if(obj.dbFieldName == 'pendingOfferActive' && obj.fieldLabel =='ACTIVE_STATUS' && obj.wheherNullable == false){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					 style: {
    			                marginTop: '27px',
    			            },
    					listeners: {
    						afterrender: function(cb) {
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}
    		else if(obj.standardMaster && obj.standardMaster.value=='COST_CENTRE'){
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					listeners: {
    						afterrender: function(cb) {
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						},
    						change: function(cb) {
    								if(cb.getValue()){
    									cb.up('form').getForm().findField('controlAccount.id').setVisible(false);
    									cb.up('form').getForm().findField('controlAccount.id').setDisabled(true)
    								}else{
    									cb.up('form').getForm().findField('controlAccount.id').setVisible(true);
    									cb.up('form').getForm().findField('controlAccount.id').setDisabled(false)
    								}

    						}
    					}
    	    		}
    		}
    		else{
    			field = {
    					xtype: xtype,
    					boxLabel: this.getFieldLabel(obj.fieldLabel),
    					name: obj.dbFieldName,
    					grow: true,
    					growMax: 300,
    					allowBlank: obj.wheherNullable,
    					growMin: 100,
    					listeners: {
    						afterrender: function(cb) {
    							Ext.defer(function() {
    								var newWidth = cb.up('window').getWidth();
    								cb.up('window').setWidth(newWidth+1);
    							}, 100);
    						}
    					}
    	    		}
    		}

    	}
    	else {
    		field = {
				xtype: xtype,
				fieldLabel: this.getFieldLabel(obj.fieldLabel),
				name: obj.dbFieldName,
				grow: true,
				growMax: 300,
				allowBlank: obj.wheherNullable,
				growMin: 100
    		}
    	}
        if(obj.fieldLabel == 'FLAG_COLOR_NAME' || obj.fieldLabel == 'FLAG_COLOR_CODE') {
        	Ext.apply(field, {
        		maskRe:/[A-Za-z0-9\s]/,
        		listeners: {
        			render: function (field) {
                        field.getEl().on('paste', function () {
                            this.type = 'onpaste';
                        }, field);
                    },
                    change: function (field) {
                        if (field.type == 'onpaste' && field.maskRe) {
                            field.type = null;
                            var regex = new RegExp(field.maskRe.toString().replace('/[', '[^').replace(']/', ']').replace('[^^', '['), 'g');
                            field.setValue(field.getValue().replace(regex, ''));
                        }
                    }
        		}
        	});
        }
        return field;
    },
    getfieldMax: function(xtype, obj) {
        var field = {
            xtype: xtype,
            fieldLabel: this.getFieldLabel(obj.fieldLabel),
            name: obj.dbFieldName,
            grow: true,
            growMax: 300,
            allowBlank: obj.wheherNullable,
            growMin: 100,
            width: 420,
            height: 200,
            style: {
                marginBottom: '30px',
            },
        };
        return field;
    },

    /**
     * This function create form text field by column meta data object.
     * Uses getfield() function.
     *
     * @param obj
     *         Column meta data object.
     */
    getTextField: function(obj) {
        var field = this.getfield('textfield', obj);
//        if(obj.dbFieldName === 'email'){
//        	field.vtype ='email';
//        	return field;
//        }
     // field.vtype = 'NospaceAsInput';
//        field.vtype = 'allowSlashAndHyphen';
      if(obj.standardMaster.value === 'MOBILE_APPLICATION_FEEDBACK' && (obj.dbFieldName === 'emailAddress')){
      	field.vtype ='email';
         }
		if(obj.standardMaster.value === 'BANK_DRAWN_CHILD' && (obj.dbFieldName === 'branch_name')){
      		field.vtype ='alphanumspace';
         }
      if(obj.standardMaster.value === 'FACULTY_TYPE' && (obj.dbFieldName === 'code' || obj.dbFieldName === 'value')){
    	  field.maxLength = 100;
           }
		   if(obj.standardMaster.value === 'COMPONENT_TYPE' && (obj.dbFieldName === 'abbreviation' || obj.dbFieldName === 'componentType')){
		       	  field.maxLength = 255;
		              }

           if (obj.standardMaster.value === 'COUNTRY' && (obj.dbFieldName === 'countryNameOtherLanguage'||obj.dbFieldName === 'countryName')) {
    	  obj.maxLength = 50;
      }
           if(obj.standardMaster.value === 'FLAG_COLOR') {
        	   obj.maxLength = 100;
           }
        return field;
    },

    /**
     * This function create form number field by column meta data object.
     * Uses getfield() function.
     *
     * @param obj
     *         Column meta data object.
     */
    getNumberField: function(obj) {
        var field = this.getfield('numberfield', obj);
        field.hideTrigger = true;
        field.minValue = 0;
//        if(obj.dbFieldName === 'phone'){
//        	field.maxLength = 10;
//        	field.setMaxLength = true;
//        	return field;
//        }


        if (obj.standardMaster.value === 'COUNTRY' && (obj.dbFieldName === 'maximumDigit' || obj.dbFieldName === 'minimumDigit')) {
        	field.maxLength = 2;
        	field.maxValue = 15;
        	field.minValue = 1;
        	field.setMaxLength = true;
        	if ( obj.dbFieldName === 'minimumDigit') {
        		field.minLength = 1;
            	field.minValue = 1;
			}
        }
        if (obj.standardMaster.value === 'COUNTRY' && (obj.dbFieldName === 'phMaxDigit' || obj.dbFieldName === 'phMinDigit')) {
        	if ( obj.dbFieldName === 'phMaxDigit') {
        		obj.maxLength = 2;
        		obj.minValue = 18;
        		obj.setMaxLength = true;
			}
        	if ( obj.dbFieldName === 'phMinDigit') {
        		obj.minLength = 1;
			}
        }
        if (obj.standardMaster.value === 'COUNTRY' && (obj.dbFieldName === 'sequence')) {
        	field.minValue = 1;
        }

        if(obj.standardMaster.value === 'AGE_GROUP' && (obj.dbFieldName === 'fromYear' || obj.dbFieldName === 'toYear')){
        	field.maxLength = 2;
        	field.setMaxLength = true;
        }

        if(obj.standardMaster.value === 'AGE_GROUP' && (obj.dbFieldName === 'toMonth' || obj.dbFieldName === 'fromMonth')){
        	field.maxLength = 2;
        	field.maxValue = 12;
        	field.setMaxLength = true;
        }
        if(obj.standardMaster.value === 'REMARK_USER_TYPE' && (obj.dbFieldName === 'sequence')){
       	 field.allowDecimals=false;

        }
        if(obj.standardMaster.value === 'BANK_DRAWN_CHILD' && (obj.dbFieldName === 'sequence')){
          	 field.maxValue=999999999;
           }
        if(obj.standardMaster.value === 'DISCOUNT_TYPE_PERCENTAGE' && (obj.dbFieldName === 'percentValue')){
        	field.maxValue = 100;
            field.maxLength = 5;
            field.allowDecimals= true;
        	field.decimalPrecision=2;

       }if(obj.standardMaster.value === 'PLACEMENT_SALARY_RANGE' && (obj.dbFieldName === 'rangeFrom'|| obj.dbFieldName === 'rangeTo')){
        	field.maxLength = 8;
        	//field.maxValue = 8;
        	field.setMaxLength = true;
        }
       if(obj.standardMaster.value === 'OBE_CORRELATION_LEVEL' && obj.dbFieldName === 'levelPercentage'){
    	   field.maxValue = 100;
    	   field.maxLength = 3;
       }if(obj.standardMaster.value === 'INTAKE_YEAR' && (obj.dbFieldName === 'sequence')){
    	   field.maxLength = 4;
    	   //field.maxValue = 8;
    	   field.setMaxLength = true;
       }
       if (obj.standardMaster.value === 'DOCUMENT_MASTER_TYPE' && (obj.dbFieldName === 'size')) {
    	   field.maxLength = 9;
       }
       if (obj.standardMaster.value === 'EXAM_BOARD_MASTER' && (obj.dbFieldName === 'maximumSubject' || obj.dbFieldName === 'minimumSubject')) {
        	field.maxLength = 4;
        	field.maxValue = 1000;
        	field.setMaxLength = true;
        	field.minLength = 0;
            field.minValue = 0;
            field.allowDecimals=false;
        }
		if (obj.standardMaster.value === 'QUICK_POLL' && obj.dbFieldName === 'numberOfDays') {
		        	field.maxLength = 3;
		        	field.maxValue = 365;
		        	field.minValue = 0;
		}
          if (obj.standardMaster.value === 'DROP_DOWN' && (obj.dbFieldName === 'sequence')) {
       	field.minValue = 1;
       }
       return field;
    },

    getDoubleField: function(obj) {
        var field = this.getfield('numberfield', obj);
        field.hideTrigger = true;
        field.minValue = 0;
        field.decimalPrecision=2,
        field.maxLength=100,
        field.mouseWheelEnabled =false,
        field.allowExponential=false,
        field.allowDecimals=true;

        if (obj.standardMaster.value === 'MARKS_RANGE_BRACKET' && (obj.dbFieldName === 'marksRangeTo'
        	|| obj.dbFieldName === 'marksRangeFrom')) {
        	field.maxLength = 100;
        	field.maxValue = 100;
        	field.setMaxLength = true;
        }
        return field;
    },
    getDisplayFieldOnlyForDocumentStatus :function(obj){
    	var field = this.getfield('displayfield', obj);
    	field.cls='displayfieldClsForDoc',
    	field.labelSeparator  = "";
             return field;
    },
    getEnumDropDown: function(obj) {
        var url = SERVERURL.STANDARD_MASTERS_ENUM_PICKLIST;
        var  extraParam={
        		enumType:obj.emunType
         };
         var store = this.createSimpleStore(['id', 'value','code'], url,extraParam);
         store.load();
         var fieldName = this.getFieldLabel(obj.fieldLabel);
         var field = {
             xtype: 'customcombobox',
             name: obj.dbFieldName,
             store: store,
             displayField: 'value',
             valueField: 'code',
             editable: false,
             fieldLabel: fieldName,
             allowBlank: obj.wheherNullable,
             grow: true,
             growMax: 300,
             growMin: 100
         };
         return field;
    },
    getFileTypeDropDown: function(obj) {
        var url = SERVERURL.FILE_MANAGEMENT_FIND_ALL_FILE_TYPE;
       /* var  extraParam={
        		enumType:obj.emunType
         };*/
         var store = this.createSimpleStore(['id', 'value','code'], url);
         store.load();
         var fieldName = this.getFieldLabel(obj.fieldLabel);
         var field = {
             xtype: 'customcombobox',
             name: obj.dbFieldName,
             store: store,
             displayField: 'value',
             valueField: 'id',
             editable: false,
             fieldLabel: fieldName,
             allowBlank: obj.wheherNullable,
             grow: true,
             growMax: 300,
             growMin: 100
         };
         return field;
    },

    /**
     * This function create form date field by column meta data object.
     * Uses getfield() function.
     * Set date format to d-m-Y
     *
     * @param obj
     *         Column meta data object.
     */
    getDateField: function(obj) {
        var field = this.getfield('datefield', obj);
        field.format = CONSTANTS.DATE_FORMAT;
        //--field.submitFormat = CONSTANTS.SUBMIT_DATE_FORMAT;
        field.submitFormat = CONSTANTS.NEW_SUBMIT_DATE_FORMAT;
        field.listeners = {
			render: function(field) {
				return dateFormatRender(field);
			}
		}
        return field;
    },

    /**
     * This function create form checkbox field by column meta data object.
     * Uses getfield() function.
     * Set value type to true/false
     *
     * @param obj
     *         Column meta data object.
     */
    getCheckboxField: function(obj,mode) {
	if(obj.standardMaster.value=="COST_CENTRE" && mode == 'EDIT'){
		var parentGrid = this.getStdMasterParentGrid();
    	var selectedData = parentGrid.getSelectionModel().getSelection()[0].data;
		var controlAccountId=null;
		if(parentGrid.getSelectionModel().selected.items[0].raw.controlAccounts!=null){
			controlAccountId=parentGrid.getSelectionModel().getSelection()[0].raw.controlAccounts.id
		}

		if(obj.dbFieldName == "isControlAccount" && controlAccountId!=null){
			var field = this.getfield('checkboxfield', obj);
	        field.labelAlign = 'left';
	        field.inputValue = 'true';
	        field.uncheckedValue = 'false';
	        field.allowBlank = 'true';
			field.readOnly=true;
	        field.cls = 'csmCheckBoxLabelCls';
	        return field;
		}else{
		var field = this.getfield('checkboxfield', obj);
        field.labelAlign = 'left';
        field.inputValue = 'true';
        field.uncheckedValue = 'false';
        field.allowBlank = 'true';
        field.readOnly=true;
        field.cls = 'csmCheckBoxLabelCls';
        return field;
		}

	}
	else if(obj.standardMaster.value=="PROGRESSION_STATUS" && obj.dbFieldName == "allowCommunication") {
		var field = this.getfield('checkboxfield', obj);
        field.labelAlign = 'left';
        field.inputValue = 'true';
        field.uncheckedValue = 'false';
        field.allowBlank = 'true';
        field.cls = 'csmCheckBoxLabelCls';
        field.margin = '25 0 0 0';
        return field;
	}else if(obj.standardMaster.value=="COST_CENTRE"){
		 var field = this.getfield('checkboxfield', obj);
	        field.labelAlign = 'left';
	        field.inputValue = 'true';
	        field.uncheckedValue = 'false';
	        field.allowBlank = 'true';
	        field.cls = 'csmCheckBoxLabelCls';
	        return field;
	}
	else{
		 var field = this.getfield('checkboxfield', obj);
        field.labelAlign = 'left';
        field.inputValue = 'true';
        field.uncheckedValue = 'false';
        field.allowBlank = 'true';
        field.cls = 'csmCheckBoxLabelCls';
        return field;
	}
    },

 getMultiselectcombofield: function(obj,mode) {
    	if(obj.standardMaster.value=="COST_CENTRE" && mode == 'EDIT'){
    		var parentGrid = this.getStdMasterParentGrid();
    		var selectedData = parentGrid.getSelectionModel().getSelection()[0].data;
    		if(obj.dbFieldName == "costCenters" && selectedData.isControlAccount){
    			var url = SERVERURL.PATH_FIND_ALL_COST_CENTER;
     	       var  extraParam={
     	        		controlAccountId:null
     	        };
     	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);


 		var fieldName = this.getFieldLabel(obj.fieldLabel);
        var field = {
            xtype: 'multiselectcombofield',
            store: store,
            action: 'Combobox',
            displayField: 'value',
            valueField: 'id',
            fieldLabel: fieldName,
            allowBlank: obj.wheherNullable,
            name: obj.dbFieldName + ".id", //+"."+obj.fkDisplayField,
            grow: true,
            maxLength: 100000,
            growMax: 300,
            growMin: 100,
			forceSelection:true,
			autoloadStore: false,
			cls:'multiBrandCampusCls',
			listeners: {
				afterrender: function(cmb){
					var cmbStore = cmb.getStore();
					cmbStore.load({
						callback: function(){
							var cmbStoreSelected = cmb.getStore();
							cmbStoreSelected.getProxy().extraParams ={
								controlAccountId:selectedData.id
							};
							cmbStoreSelected.load({
								callback:function(){
								var cmbValue = Ext.Array.pluck(Ext.Array.pluck(cmbStoreSelected.data.items,'data'),'id');
								cmbStoreSelected.getProxy().extraParams ={
								controlAccountId:null
							};
							cmb.setValue(cmbValue);
								}
							})
						}
					})
				}
			}
        };
        return field;
    	}
       }else if(obj.standardMaster.value=="ACADEMIC_TOPICS"){
    	   if(obj.dbFieldName == "role" ){

   			var url = SERVERURL.ROLE_FIND_ALL_ACTIVE_ROLE;
//    	       var  extraParam={
//    	        		controlAccountId:null
//    	        };
    	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);


		var fieldName = this.getFieldLabel(obj.fieldLabel);
       var field = {
           xtype: 'multiselectcombofield',
           cls:'multiBrandCampusCls',
           store: store,
           action: 'Combobox',
           displayField: 'value',
           valueField: 'id',
           fieldLabel: fieldName,
           allowBlank: obj.wheherNullable,
           name: obj.dbFieldName + "-id", //+"."+obj.fkDisplayField,
            grow: true,
            growMax: 300,
            growMin: 100,
			forceSelection:true,
			autoloadStore: false,
			queryParam: "roleName",
			cls:'ProgramCourseMultiselectField',
			style:{
				'paddingBottom':'5px'
			},
//			listeners: {
//				afterrender: function(cmb){
//					var cmbStore = cmb.getStore();
//					cmbStore.load({
//						callback: function(){
//							var cmbStoreSelected = cmb.getStore();
//							cmbStoreSelected.getProxy().extraParams ={
//								controlAccountId:selectedData.id
//							};
//							cmbStoreSelected.load({
//								callback:function(){
//								var cmbValue = Ext.Array.pluck(Ext.Array.pluck(cmbStoreSelected.data.items,'data'),'id');
//								cmbStoreSelected.getProxy().extraParams ={
//								controlAccountId:null
//							};
//							cmb.setValue(cmbValue);
//								}
//							})
//						}
//					})
//				}
//			}
       };
       return field;

    	   }
       }
       else if(obj.standardMaster.value=="DEBARMENT_REASONS"){
    	   if(obj.dbFieldName == "academyLocation" ){

   			var url = SERVERURL.FIND_ACADEMY_LOCATION_BY_NAME;
    	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);


		var fieldName = this.getFieldLabel(obj.fieldLabel);
       var field = {
           xtype: 'multiselectcombofield',
           cls:'multiBrandCampusCls',
           store: store,
           action: 'Combobox',
           displayField: 'value',
           emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
           triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
           valueField: 'id',
           fieldLabel: fieldName,
           allowBlank: obj.wheherNullable,
           queryParam:'name',
           width:240,
          // queryMode: 'local',
           name: obj.dbFieldName + "-id", //+"."+obj.fkDisplayField,
            grow: true,
            growMax: 300,
            growMin: 100,
            forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		enableKeyEvents  : 'true',
			cls:'ProgramCourseMultiselectField',
			style:{
				'paddingBottom':'5px'
			},listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
       };
       return field;

    	   }
       }
       
       else if(obj.standardMaster.value=="PROGRAM_COMPLETION_AWARD_TYPE"){
    	   if(obj.dbFieldName == "programGroupFinance" ){

   			var url = SERVERURL.PROGRAM_CATEGORY_BY_NAME_DROPDOWN;
    	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);


		var fieldName = this.getFieldLabel(obj.fieldLabel);
        var field = {
           xtype: 'multiselectcombofield',
           cls:'multiBrandCampusCls',
           store: store,
           action: 'Combobox',
           displayField: 'value',
           emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
           triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
           valueField: 'id',
           fieldLabel: fieldName,
           allowBlank: obj.wheherNullable,
           queryParam:'name',
           width:240,
          // queryMode: 'local',
           name: obj.dbFieldName + "-id", //+"."+obj.fkDisplayField,
            grow: true,
            growMax: 300,
            growMin: 100,
            forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		enableKeyEvents  : 'true',
			cls:'ProgramCourseMultiselectField',
			style:{
				'paddingBottom':'5px'
			},listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
       };
       return field;

    	   }
       }
       
       
       else if(obj.standardMaster.value=="TERMINATION_REASONS"){
    	   if(obj.dbFieldName == "academyLocation" ){

   			var url = SERVERURL.FIND_ACADEMY_LOCATION_BY_NAME;
    	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);


		var fieldName = this.getFieldLabel(obj.fieldLabel);
       var field = {
           xtype: 'multiselectcombofield',
           cls:'multiBrandCampusCls',
           store: store,
           action: 'Combobox',
           displayField: 'value',
           emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
           triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
           valueField: 'id',
           fieldLabel: fieldName,
           width:240,
           allowBlank: obj.wheherNullable,
           queryParam:'name',
          // queryMode: 'local',
           name: obj.dbFieldName + "-id", //+"."+obj.fkDisplayField,
            forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		enableKeyEvents  : 'true',
			cls:'ProgramCourseMultiselectField',
			style:{
				'paddingBottom':'5px'
			},listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
       };
       return field;

    	   }
       }
       else if(obj.standardMaster.value=="COURSE_CESM_CODE"){
    	   if(obj.dbFieldName == "courseCESMRole" ){

   			var url = SERVERURL.ROLE_FIND_ALL_ACTIVE_ROLE;
    	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);


		var fieldName = this.getFieldLabel(obj.fieldLabel);
       var field = {
           xtype: 'multiselectcombofield',
           cls:'multiBrandCampusCls',
           store: store,
           action: 'Combobox',
           displayField: 'value',
          // emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
           triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
           valueField: 'id',
           fieldLabel: fieldName,
           allowBlank: obj.wheherNullable,
           queryParam:'roleName',
           width:240,
          // queryMode: 'local',
           name: obj.dbFieldName + "-id", //+"."+obj.fkDisplayField,
            grow: true,
            growMax: 300,
            growMin: 100,
            forceSelection:true,
    		typeAhead:true,
    		editable: false,
					minChars: 3,
					enableKeyEvents: 'true',
					cls: 'ProgramCourseMultiselectField',
					style: {
						'paddingBottom': '5px'
					}, listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
								'{value}' +
								'</div>';
						}
					}
				};
				return field;

			}
		}else if (obj.standardMaster.value == "QUICK_POLL") {
			if (obj.dbFieldName == "academyLocation") {

				var url = SERVERURL.FIND_ACADEMY_LOCATION_BY_NAME;
				var store = this.createSimpleStore(['id', 'value'], url, extraParam);


				var fieldName = this.getFieldLabel(obj.fieldLabel);
				var field = {
					xtype: 'multiselectcombofield',
					cls: 'multiBrandCampusCls',
					store: store,
					action: 'Combobox',
					itemId: 'quickPollAL',
					displayField: 'value',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					valueField: 'id',
					fieldLabel: fieldName,
					width: 240,
					allowBlank: obj.wheherNullable,
					queryParam: 'name',
					// queryMode: 'local',
					name: obj.dbFieldName + "-id", //+"."+obj.fkDisplayField,
					forceSelection: true,
					typeAhead: true,
					minChars: 3,
					enableKeyEvents: 'true',
					cls: 'ProgramCourseMultiselectField',
					style: {
						'paddingBottom': '5px'
					}, listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
       };
       return field;

    	   }
       }
    },

    /**
     * This function create form combobox field by column meta data object.
     * User createSimpleStore() to load data in combobox.
     * Set editable to false
     * Override getSubmitData() function to set custom submit value as,
     * 	name :{id:value}
     *
     * @param obj
     *         Column meta data object.
     */
    getComboBox: function(obj,mode) {
    	if(obj.standardMaster.value=="PROGRAM_SUBJECT_MAPPING" && mode == 'EDIT'){
    		var childGrid = this.getStdMasterChildGrid();
    		var selectedData = childGrid.getSelectionModel().getSelection()[0].data;
    		if(obj.dbFieldName == "academyLocationId" || obj.dbFieldName == "subjectType"){
    			var url = SERVERURL.STANDARD_MASTERS_DROPDOWN;
     	       var  extraParam={
     	        		parentTableId:obj.fkTable ,
     	        		columnName:obj.fkDisplayField
     	        };
     	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);
     	        store.load();
    		}
    		if(obj.dbFieldName == "programId"){
    			var AlId = selectedData["academyLocationId.id"];
    			var url = SERVERURL.PROGRAMS_FIND_BY_ACADMY_LOCATION_ID;
    			var  extraParam={
    					academyLocationId:AlId
    			};
    			var store = this.createSimpleStore(['id', 'value'], url,extraParam);
    			store.load();
    			store.commitChanges();
    		}
    		if(obj.dbFieldName == "batchId"){
    			var programId = selectedData["programId.id"];
    			var url = SERVERURL.BATCH_FINDALL;
    			var  extraParam={
    					id:programId
    			};
    			var store = this.createSimpleStore(['id', 'value'], url,extraParam);
    			store.load();
    			store.commitChanges();
    		}
    	}else if(obj.standardMaster.value=="ENQ_DEFAULT_USER" && obj.dbFieldName == "defaultUser") {
    		var url = SERVERURL.PATH_FIND_DEFAULT_USER_FOR_ENQUIRY;
 	        var store = this.createSimpleStore(['id', 'value'], url,null);
 	        store.load();
    	}else if(obj.standardMaster.value=="COUNTRY" && obj.dbFieldName == "countryType") {
            var url = SERVERURL.COUNTRY_TYPE_DROP_DOWN;
            var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            store.load();
    	}else if(obj.standardMaster.value=="NATIONALITIES" && obj.dbFieldName == "countryType") {
            var url = SERVERURL.COUNTRY_TYPE_DROP_DOWN;
            var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            store.load();
    	}else if(obj.standardMaster.value=="COST_CENTRE" && obj.dbFieldName == "feeHead") {
    		if(mode == 'EDIT'){
                var childGrid = this.getStdMasterParentGrid();
                var selectedData = childGrid.getSelectionModel().getSelection()[0].data;
                var  extraParam={
                        costCenterId:selectedData.id
                };
            }
            var url = SERVERURL.PATH_FIND_ALL_DISCOUNT_FEEHEADS_FOR_COSTCENTER;
            var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            store.load();
    	}else if(obj.standardMaster.value=="CITY" && (obj.dbFieldName == "countryRegion")){
    		var url = SERVERURL.PATH_FIND_COUNTRY_REGION_BY_COUNTRYID;
 	       var  extraParam={
 	    		  countryId:null
 	        };
 	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);
 	        store.load();
    	}else if(obj.standardMaster.value=="COST_CENTRE" && obj.dbFieldName == "controlAccount") {
    		var url = SERVERURL.PATH_FIND_ALL_IS_CONTROL_ACCOUNT_COST_CENTER ;
            var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            store.load();
    	}
    	else if(obj.standardMaster.value=="CONVERSION_MASTER" && obj.dbFieldName == "academyLocation") {
    		var url = SERVERURL.ACADEMY_LOCATION_FIND_ALL;
            var store = this.createSimpleStore(['id', 'value'], url,extraParam);
            store.load();
    	}
    	else{
    		   var url = SERVERURL.STANDARD_MASTERS_DROPDOWN;
    	       var  extraParam={
    	        		parentTableId:obj.fkTable ,
    	        		columnName:obj.fkDisplayField
    	        };
    	        var store = this.createSimpleStore(['id', 'value'], url,extraParam);
    	        store.load();
    	}
        var fieldName = this.getFieldLabel(obj.fieldLabel);
        var field = {
            xtype: 'customcombobox',
            store: store,
            action: 'Combobox',
            displayField: 'value',
            valueField: 'id',
            editable: false,
            fieldLabel: fieldName,
            allowBlank: obj.wheherNullable,
            name: obj.dbFieldName + ".id", //+"."+obj.fkDisplayField,
            grow: true,
            growMax: 300,
            growMin: 100,
            // Override method for submity value to submit nested json value
            getSubmitData: function() {
                var this$ = this,
                    data = null,
                    value;
                if (!this$.disabled && this$.submitValue) {
                    value = this$.getValue();
                    if (this$.store.items == 'undefined')
                    	this$.store.load(['id', 'value'], url);
                    if (value && value !== null) {
                    	var customValue = "{\"id\":" + value + "}";
                        value = Ext.decode(customValue);
                        data = {};
                        data[obj.dbFieldName] = value;
                    }
                }
                return data;
            }
        };
        return field;
    },

    /**
     * This function create form Radio field by column meta data object.
     * Uses getfield() function.
     * Set value type to true/false
     *
     * @param obj
     *         Column meta data object.
     */
    getRadioButtonField: function(obj) {
        var field ={
				xtype : 'fieldcontainer',
				layout : {
					type : 'vbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'radiogroup',
					itemId:'isResultPublish',
					//name:'isResultPublish',
					fieldLabel : getExaminationTranslation('RESULT_PUBLISH'),
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					items : [{
						boxLabel : getExaminationTranslation('YES'),
						name : 'isResultPublish',
						inputValue : true,
						checked : true
					}, {
						boxLabel : getExaminationTranslation('NO'),
						name : 'isResultPublish',
						inputValue : false,
					} ]
				}]
			}
		 return field;
    },

    /*
     * For addeing deleter button in each row
     */
    getDeleteActionColumn: function(grid, parentTableId) {
        var this$ = this;
        var field = {
            xtype: 'actioncolumn',
            flex: 1,
            header: this.getFieldLabel('DELETE'),
            icon: 'resources/images/close-btn.png',
            tooltip: this.getFieldLabel('DELETE'),
            handler: function(grid, rowIndex, colIndex) {
                this$.deleteMasterData(grid, parentTableId, rowIndex);
            }
        };
        return field;
    },

    getFieldLabel: function(field) {
        return getCommonTranslation(field);
    },

    getStdMasterParentGrid : function(combo) {
    	return this.getActiveTabfromContentPanel().down('#stdMasterParentGrid');
    },

    getStdMasterChildGrid : function(combo) {
    	return this.getActiveTabfromContentPanel().down('#stdMasterChildGrid');
    },
    getfilterCodeValue: function(panel) {
    	if(!panel)
    		panel=this.getActiveTabfromContentPanel();
    	return panel.searchConfigCode;
    },

    getParentResponseData : function(){
    	return 	this.getActiveTabfromContentPanel().parentResponseData;;
    },
    setParentResponseData : function(parentResponseData){
    	this.getActiveTabfromContentPanel().parentResponseData=parentResponseData;
    },

    getParentTableId : function(){
    	var parentData = this.getActiveTabfromContentPanel();
    	if(parentData.parentResponseData.tableName == 'country' ||
    			parentData.parentResponseData.tableName == 'marks_range_bracket' || parentData.parentResponseData.tableName == 'age_group' || parentData.parentResponseData.tableName == 'mobile_platform_detail'
    				|| parentData.parentResponseData.tableName == 'sg_reason_for_visit' || parentData.parentResponseData.tableName == 'hostel_waiting_list_type_csm'){
    		return 	this.getActiveTabfromContentPanel();
    	}else {
    		return 	this.getActiveTabfromContentPanel().parentTableId;
    	}
    },
    setParentTableId : function(parentTableId){
    	this.getActiveTabfromContentPanel().parentTableId=parentTableId;
    },

    getChildTableId : function(){
    	return 	this.getActiveTabfromContentPanel().childTableId;;
    },
    setChildTableId : function(childTableId){
    	this.getActiveTabfromContentPanel().childTableId=childTableId;
    },
    getParentRecordId : function(){
    	return 	this.getActiveTabfromContentPanel().parentRecordId;;
    },
   setParentRecordId : function(parentRecordId){
    	this.getActiveTabfromContentPanel().parentRecordId=parentRecordId;
    },

    getChildResponseData : function(){
    	return 	this.getActiveTabfromContentPanel().childResponseData;;
    },
    setChildResponseData : function(childResponseData){
    	this.getActiveTabfromContentPanel().childResponseData=childResponseData;
    },

    changeAcademicTopicGridValue:function(){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='ACADEMIC_TOPICS'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
    						obj.data.categoryTopicKey = obj.data.categoryTopic;
							if (obj.data.categoryTopic == 'GENERAL_COMMENT') {
								obj.data.categoryTopic = 'General Comment';
							} else if (obj.data.categoryTopic == 'MARKSHEET_TOPIC') {
								obj.data.categoryTopic = 'Marksheet Topic';
							} else if (obj.data.categoryTopic == 'PRE_ENROLLED_PERIOD_DOCUMENTS') {
								obj.data.categoryTopic = 'Pre-Enrolled Period Documents';
							}

    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    	if(parentResponseData.masterName=='EXAM_BOARD_MASTER'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
    						obj.data.markingType = obj.data.markingType;
    						if(obj.data.markingType=='GRADE'){
    							obj.data.markingType='Grade';
    						}else{
    							if(obj.data.markingType=='MARKS'){
    								obj.data.markingType='Marks';
    							}
    						}
    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    	if(parentResponseData.masterName=='SUBJECT'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
    						obj.data.isMandatory = obj.data.isMandatory;
    						if(obj.data.isMandatory=='YES'){
    							obj.data.isMandatory='Yes';
    						}else{
    							if(obj.data.isMandatory=='NO'){
    								obj.data.isMandatory='No';
    							}
    						}
    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    },

    changeEnrollmentValue:function(){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='CHANGE_ENROLLMENT_MASTER'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
							if (obj.data.isConfigure==true) {
								obj.data.isConfigure = "Yes";
							}if (obj.data.isConfigure==false) {
								obj.data.isConfigure = "No";
							}if (obj.data.isCurrentAcademicTerm==true) {
								obj.data.isCurrentAcademicTerm="Yes";
							}if (obj.data.isCurrentAcademicTerm==false) {
								obj.data.isCurrentAcademicTerm="No";
							}

    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    },

    changeDublinStatus:function(){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='DUBLIN_DESCRIPTORS'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
							if (obj.data.dublinDescriptorsActiveInactiveEnum=="ACTIVE") {
								obj.data.dublinDescriptorsActiveInactiveEnum = "Active";
							}else{
								if(obj.data.dublinDescriptorsActiveInactiveEnum=="INACTIVE")
									obj.data.dublinDescriptorsActiveInactiveEnum = "Inactive";
							}

    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    },

    changeProgramLearningOutcomeStatus:function(){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='PROGRAM_LEARNING_OUTCOME'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
							if (obj.data.status=="ACTIVE") {
								obj.data.status = "Active";
							}else{
								if(obj.data.status=="INACTIVE")
									obj.data.status = "Inactive";
							}

    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    },
    changeGeneralEducationCategoryStatus:function(){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='GENERAL_EDUCATION_CATEGORY'){
    		var stdMasterParentGrid = this.getStdMasterParentGrid();
    		var store=stdMasterParentGrid.getStore();
    		store.load({
    			callback: function(rec, operation, success) {
    				if (success) {
    					rec.forEach(function(obj){
							if (obj.data.status=="ACTIVE") {
								obj.data.status = "Active";
							}else{
								if(obj.data.status=="INACTIVE")
									obj.data.status = "Inactive";
							}

    					});
    					store.commitChanges();
    					stdMasterParentGrid.bindStore(store);
    					stdMasterParentGrid.getView().refresh();
    				}
    			}
    		});
    	}
    },

    changeSubTopicForm:function(childFormWindow){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='ACADEMIC_TOPICS'){
    		var parentGrid = this.getStdMasterParentGrid();
    		var model=parentGrid.getSelectionModel().getSelection()[0].data;
    		if(model.categoryTopicKey=='GENERAL_COMMENT'){
    			var itemValue=childFormWindow.items.items[0];
    			var form=itemValue.getForm();
    			form.findField('showInMarksheet').setDisabled(true);
    		}
    	}
    	if(parentResponseData.masterName=='EXAM_BOARD_MASTER'){
    		var parentGrid = this.getStdMasterParentGrid();
    		var count = parentGrid.getSelectionModel().getCount();
    		if(count>0){
    			var model=parentGrid.getSelectionModel().getSelection()[count-1].data;
    			if(model.assessmentLevelRequired==true){
    				var itemValue=childFormWindow.items.items[0];
    				var form=itemValue.getForm();
    				form.findField('assessmentLevel').setVisible(true);
    				form.findField('assessmentLevel').allowBlank=false;
    			}
    		}
    	}
    },
    saveActivePaymentGateway:function(){
    	var win = this.getActivepaymentgatewaywin();
    	//var standardMaster = this.getStandardMaster();
    	var standardMaster = this.getActiveTabfromContentPanel();
    	var pGrid = standardMaster.down('#stdMasterParentGrid');
    	var grid = win.down('#paymentGatewayGridId');
    	pGrid.setVisible(false);
    	var activePayCombo =  standardMaster.down('#activePaymentGatewayCombo');
    	activePayCombo.reset();
    	var data = grid.store.data.items;
    	if(data.length>0){
    		var submitData=[];
    		var json= new Object;
    		data.forEach(function(obj){
    			json = {
    					"id": obj.data.id,
    					"code": obj.data.code,
    					"value": obj.data.value,
    					"activeStatus": obj.data.activeStatus?true:false,
    			}
    			submitData.push(json);
    		});
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	Ext.Ajax.request({
    			type : 'rest',
    			url : SERVERURL.PATH_UPDATE_PAYMENT_GATEWAY,
    			jsonData : Ext.encode(submitData),
    			method : 'POST',
    			success : function(frm, action) {
    				showSuccessMessage(getCommonTranslation('STANDARD_MASTER_MSG_BOX_TITLE'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
    				Ext.getBody().unmask();
    				activePayCombo.getStore().load();
    				win.close();
    			}
    		});
    	}
    },
    changeValueIntoEnumAcademicTopic:function(values){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='ACADEMIC_TOPICS'){
    		if(values.categoryTopic=='General Comment' || values.categoryTopic=='GENERAL_COMMENT'){
    			values.categoryTopic='GENERAL_COMMENT';
    		}else if(values.categoryTopic=='Marksheet Topic' || values.categoryTopic=='MARKSHEET_TOPIC'){
    				values.categoryTopic='MARKSHEET_TOPIC';
    		}else if(values.categoryTopic=='Pre-Enrolled Period Documents' || values.categoryTopic=='PRE_ENROLLED_PERIOD_DOCUMENTS'){
	                 values.categoryTopic='PRE_ENROLLED_PERIOD_DOCUMENTS';
              }

    	}
    	if(parentResponseData.masterName=='EXAM_BOARD_MASTER'){
    		if(values.markingType=='Grade' || values.markingType=='GRADE'){
    			values.markingType='GRADE';
    		}else{
    			if(values.markingType=='Marks' || values.markingType=='MARKS'){
    				values.markingType='MARKS';
    			}
    		}
    	}
    	if(parentResponseData.masterName=='SUBJECT'){
    		if(values.isMandatory=='Yes' || values.isMandatory=='YES'){
    			values.isMandatory='YES';
    		}else{
    			if(values.isMandatory=='No' || values.isMandatory=='NO'){
    				values.isMandatory='NO';
    			}
    		}
    	}
    	return values;
    },
    changeValueIntoEnumdublinDescriptor:function(values){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='DUBLIN_DESCRIPTORS'){
    		if(values.dublinDescriptorsActiveInactiveEnum=='Active' || values.status=='ACTIVE'){
    			values.dublinDescriptorsActiveInactiveEnum='ACTIVE';
    		}else if(values.dublinDescriptorsActiveInactiveEnum=='Inactive' || values.status=='INACTIVE'){
    			values.dublinDescriptorsActiveInactiveEnum='INACTIVE';
    		}

    	}
    	return values;
    },
    changeValueProgramLearningOutcome:function(values){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='PROGRAM_LEARNING_OUTCOME'){
    		if(values.status=='Active' || values.status=='ACTIVE'){
    			values.status='ACTIVE';
    		}else if(values.status=='Inactive' || values.status=='INACTIVE'){
    			values.status='INACTIVE';
    		}

    	}
    	return values;
    },
    changeValueGeneralEducationCategory:function(values){
    	var parentResponseData=this.getParentResponseData();
    	if(parentResponseData.masterName=='GENERAL_EDUCATION_CATEGORY'){
    		if(values.status=='Active' || values.status=='ACTIVE'){
    			values.status='ACTIVE';
    		}else if(values.status=='Inactive' || values.status=='INACTIVE'){
    			values.status='INACTIVE';
    		}

    	}
    	return values;
    }
});
