/**
 * @author Deepika Parmar
 */
Ext.define('Academia.controller.student.feeregistrationreset.StudentFeeRegistrationResetController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['student.report.StudentFeesRegistrationReportModel'],
	stores: ['student.report.StudentFeesRegistrationReportGridStore','program.ProgramCategoryStore','Academia.store.common.AssignedProgramGroupStore','Academia.store.common.ProgramForBillStoreFeePayment',
		'Academia.store.student.report.ReRegistrationStatusStore','student.report.StudentFeesRegistrationReportGridStore','student.report.StudentFeesRegistrationResetGridStore'],
	views: ['student.studentFeePayerReport.StudentFeeRegistrationResetTabStructure','student.studentFeePayerReport.StudentFeeRegistrationResetStructure',
		'student.studentFeePayerReport.StudentFeeRegistrationResetForm','student.studentFeePayerReport.StudentFeesRegistrationReportGrid','student.studentFeePayerReport.StudentFeeRegistrationResetGrid'],
	config : {
		STUDENT_FEE_REGISTRATION_RESET_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEE_REGISTRATION_RESET_PRIVILEGES'),


	},
	refs: [
		{
        	ref : 'studentfeeregistrationresetstructure',
        	selector : 'studentfeeregistrationresetstructure'
        },{
        	ref : 'studentfeeregistrationresettabstructure',
        	selector : 'studentfeeregistrationresettabstructure'
        },{
        	ref : 'studentfeeregistrationresetform',
        	selector : 'studentfeeregistrationresetform'
        },{
        	ref : 'studentfeeregistrationresetgrid',
        	selector : 'studentfeeregistrationresetgrid'
        }
		
	],

	init: function(application) {
		this.control({
			'studentfeeregistrationresetform multiselectcombofield[itemId=multiselectAcademyId]':{
    			afterrender:function(obj, record){
    				var $this = this;
    				var academyLocationId = this.getCurrentAcademyLocation();
    				obj.getStore().load({
    					callback: function(record){
    						obj.setValue(academyLocationId);
    					}
    				});
    				
    			},
    				change: function(obj){
    					var $this = this;
    				var studentfeeregistrationresetform=$this.getStudentfeeregistrationresetform();
        			var intakeYear= studentfeeregistrationresetform.down('#intakeYear');
    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    				if (academyIds != null && academyIds != '') {
    					this.fnChangeAcademyLocationEvent();
					}
    			}
    		},
    		'studentfeeregistrationresetform customcombobox[itemId=program]': {
    			afterrender : function(combo){
    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    				var store = combo.getStore();
    				store.getProxy().extraParams = {
    					academyLocationIds:academyIds
    				};
    			},
    			select: function(programCombo, records, eOpts) {
    				var this$ = this;
    				var stuFeeRegistrationResetForm=this.getStudentfeeregistrationresetform();
    				var batchCombo = stuFeeRegistrationResetForm.down('#batch');
    				batchCombo.setDisabled(false)
    				this$.loadDependentComboForFeesRegitration(batchCombo, programCombo.getValue(), 'id');

    				/*  Code For Reloading Students */	        				
    				var studentIdNameCombo = stuFeeRegistrationResetForm.down('#studentIdName');
    				
    				var studentIdNameStore = studentIdNameCombo.getStore();
    				       				var filter = $this.getStudentfeeregistrationresetform().getForm();
    				    	        	var formValue = filter.getValues();
    				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    				    				if (academyIds != null && academyIds != '') {
    				    					studentIdNameStore.getProxy().extraParams = {
    				          					academyLocationIds: academyIds/*,
    				    		        		intakeYear : formValue.intakeYear,
    				    		        		programCategoryId : formValue.programCategory,
    				    		        		programCategoryId : programCategoryIds,
    				    		        		programGroupId : formValue.programGroupId,
    				    		        		programId : formValue.program, 
    				    		        		batchId : formValue.batch,*/
    				          				 };
    				    					studentIdNameStore.load();						
    				    				}
    				    				else{
    				    					var academyLocationId=this.getCurrentAcademyLocation();
    				    					studentIdNameStore.getProxy().extraParams = {
    				          					 academyLocationIds: academyLocationId
    				          				 };
    				    					studentIdNameStore.load();
    				    				}
    			
    			}

    		},
    		'studentfeeregistrationresetform customcombobox[itemId=intakeYear]': {
    			select: function(programCombo, records, eOpts) {
/*  Code For Reloading Students */
    				var $this =this;
    				var stuFeeRegistrationResetForm=$this.getStudentfeeregistrationresetform();
    				//var studentFeesRegistrationGrid=$this.getStudentfeesregistrationreportgrid();
    				//var exportButton= studentFeesRegistrationGrid.down('#exportReportItemId');
    				//exportButton.setDisabled(false);
    				var studentIdNameCombo = stuFeeRegistrationResetForm.down('#studentIdName');
    				var studentIdNameStore = studentIdNameCombo.getStore();
    				       				var filter = $this.getStudentfeeregistrationresetform().getForm();
    				    	        	var formValue = filter.getValues();
    				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    				    				if (academyIds != null && academyIds != '') {
    				    					studentIdNameStore.getProxy().extraParams = {
    				          					academyLocationIds: academyIds/*,
    				    		        		intakeYear : formValue.intakeYear,
    				    		        		programCategoryId : formValue.programCategory, 
    				    		        		programCategoryId : programCategoryIds, 
    				    		        		programGroupId : formValue.programGroupId,
    				    		        		programId : formValue.program, 
    				    		        		batchId : formValue.batch,*/
    				          				 };
    				    											
    				    				}
    				    				else{
    				    					var academyLocationId=this.getCurrentAcademyLocation();
    				    					studentIdNameStore.getProxy().extraParams = {
    				          					 academyLocationIds: academyLocationId
    				          				 };
    				    					
    				    				}
    			}

    		},
    		'studentfeeregistrationresetform customcombobox[itemId=batch]': {
	        	
    			select: function(batchCombo, records, eOpts) {
    				var this$ = this;
    				var stuFeeRegistrationResetForm=$this.getStudentfeeregistrationresetform();
    				var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');
 
    				var studentIdNameStore = studentIdNameCombo.getStore();
    				       				var filter = $this.getStudentfeeregistrationresetform().getForm();
    				    	        	var formValue = filter.getValues();
    				    				var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    				    				if (academyIds != null && academyIds != '') {
    				    					studentIdNameStore.getProxy().extraParams = {
    				          					academyLocationIds: academyIds/*,
    				    		        		intakeYear : formValue.intakeYear,
    				    		        		programCategoryId : formValue.programCategory, 
    				    		        		programCategoryId : programCategoryIds,
    				    		        		programGroupId : formValue.programGroupId,
    				    		        		programId : formValue.program, 
    				    		        		batchId : formValue.batch,*/
    				          				 };
    				    					studentIdNameStore.load();						
    				    				}
    				    				else{
    				    					var academyLocationId=this.getCurrentAcademyLocation();
    				    					studentIdNameStore.getProxy().extraParams = {
    				          					 academyLocationIds: academyLocationId
    				          				 };
    				    					studentIdNameStore.load();
    				    				}
    			
//    				var basicStudentSearchForm=this.getStudentfeepayerreportfilter();
//    				var sectionCombo = basicStudentSearchForm.down('#section');
//    				this$.loadDependentCombo(sectionCombo, batchCombo.getValue(), 'batchIds');
    			}
    		},
    		'studentfeeregistrationresetform button[itemId=btnSearch]': {
    			click: this.loadStudentFeeRegistrationReportGrid
    		},
    		'studentfeeregistrationresetform button[itemId=btnReset]': {
    			click: this.resetStudentFeesRegistrationReport
    		},
    		'studentfeeregistrationresetgrid button[itemId=resetRegistrationBtn]':{
				 click:this.doResetRegistration
			 },


		});
	},
	fnChangeAcademyLocationEvent: function(){
    	 $this = this;
			var academyIds = $this.getSelectedAcademyIdsForFeesRegistration();
			if (academyIds == null || academyIds == '') {
				academyIds = $this.getCurrentAcademyLocation();
		}
			var feeRegistrationResetForm=$this.getStudentfeeregistrationresetform();
			var intakeYearCombo = feeRegistrationResetForm.down('#intakeYear');
			var batchCombo = feeRegistrationResetForm.down('#batch');
			var programCombo = feeRegistrationResetForm.down('#program');
			var studentIdNameCombo = feeRegistrationResetForm.down('#studentIdName');
			
			var intakeYearStore = intakeYearCombo.getStore();
			var batchComboStore = batchCombo.getStore();
			var programComboStore=programCombo.getStore();
			
			intakeYearCombo.clearValue();
			batchCombo.clearValue();
			programCombo.clearValue();
			studentIdNameCombo.clearValue();
			
			
			intakeYearStore.getProxy().extraParams = {
				academyLocationIds:academyIds
			};
			
			programComboStore.getProxy().extraParams = {
				academyLocationIds:academyIds
			};
			
			batchComboStore.getProxy().extraParams = {
			academyLocationIds:academyIds
		};
			intakeYearStore.load();
			programComboStore.load();	
			batchComboStore.load();
			
			
    			var studentIdNameStore = studentIdNameCombo.getStore();
			var filter = $this.getStudentfeeregistrationresetform().getForm();
    	var formValue = filter.getValues();
		var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
		if (academyIds != null && academyIds != '') {
			studentIdNameStore.getProxy().extraParams = {
					academyLocationIds: academyIds,
        		intakeYear : formValue.intakeYear,
        		programCategoryId : formValue.programCategory, 
        		programGroupId : formValue.programGroupId,
        		programId : formValue.program, 
        		batchId : formValue.batch,
				 };
			studentIdNameStore.load();						
		}
		else{
			var academyLocationId=this.getCurrentAcademyLocation();
			studentIdNameStore.getProxy().extraParams = {
					 academyLocationIds: academyLocationId
				 };
			studentIdNameStore.load();
		}
    			
			
     },
     getSelectedAcademyIdsForFeesRegistration:function(){
    	 $this = this;
    	 var multiselectAcademyIdField = $this.getStudentfeeregistrationresetform().down('#multiselectAcademyId');
     	var academyIdsArray = multiselectAcademyIdField.getValue();
     	var academyIds;
     	var academyIdsTempArray = [];
     	if (academyIdsArray == null && academyIdsArray == undefined) {
     		academyIdsArray = $this.getCurrentAcademyLocation();
		}
     	if(typeof academyIdsArray[0]!="object"){
			academyIdsTempArray.push(academyIdsArray);
    	}
    	else {
    		Ext.each(academyIdsArray,function(currentAcademyId){
    			academyIdsTempArray.push(currentAcademyId.data.id);
    		});
    		
    	}
     	academyIds = academyIdsTempArray.join(',');
     	return academyIds;
     },
     loadDependentComboForFeesRegitration: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
     	var this$ = this;
     	this$.resetOtherDropdownsOfFeesRegistration(dependentCombo);
         dependentCombo.store.removeAll();
         var store = dependentCombo.getStore();
         var id = comboValue;
         if(!isNullOrEmpty(id)){
         	var url = store.getProxy().proxyConfig.api.read;
             if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                 url = url.concat('?' + parameter + '=' + id);
             } else {
                 url = url.concat('?' + parameter + '=' + id);
                 url = url.concat('&' + extraParameter + '=' + extraParamValue);
             }
             store.getProxy().api.read = url;
             store.reload();
         }
     },
     resetOtherDropdownsOfFeesRegistration: function(combo) {
     	$this = this;
         switch (combo.name) {
         case 'batch':
         	$this.clearCombo(combo, false);
         	//var basicStudentSearchForm=$this.getStudentfeeregistrationreport();
//				var sectionCombo = basicStudentSearchForm.down('#section');
//				$this.clearCombo(sectionCombo, true);
             break;
         case 'section':
//         	$this.clearCombo(combo, false);
             break;
         }
     },
     clearCombo: function(combo, isDisabled) {
         combo.clearValue();
         combo.store.removeAll();
         combo.setDisabled(isDisabled);
     },	       
     resetStudentFeesRegistrationReport:function(){
    	 var $this=this;
    	 var form = this.getStudentfeeregistrationresetform();

    	 var multiselectAcademyId = form.down('#multiselectAcademyId');
    	 var intakeYear = form.down('#intakeYear');
    	 var program = form.down('#program');
    	 var batch = form.down('#batch');
    	 var studentIdName = form.down('#studentIdName');

    	 //multiselectAcademyId.reset();
    	 intakeYear.reset();
    	 program.reset();
    	 batch.reset();
    	 studentIdName.reset();
    	 batch.setDisabled(true);
    	 // reload form again after reset 
    	 var academyLocationId = this.getCurrentAcademyLocation();
    	 multiselectAcademyId.getStore().load({
    		 callback: function(record){
    			 multiselectAcademyId.select(academyLocationId);
    		 }
    	 });


    	 var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    	 /*  Code For Reloading Students */
    	 var stuFeeRegistrationReport=$this.getStudentfeeregistrationresetform();
    	 var studentIdNameCombo = stuFeeRegistrationReport.down('#studentIdName');


    	 var programStore = program.getStore();
    	 programStore.getProxy().extraParams={
    		 academyLocationIds: academyLocationId
    	 };
    	 programStore.load();
    	 
    	 var intakeYearStore = intakeYear.getStore();
    	 intakeYearStore.getProxy().extraParams={
    		 academyLocationIds: academyLocationId
    	 };
    	 intakeYearStore.load();


    	 var studentIdNameStore = studentIdNameCombo.getStore();
    	 var filter = $this.getStudentfeeregistrationresetform().getForm();
    	 var formValue = filter.getValues();
    	 var academyIds = this.getSelectedAcademyIdsForFeesRegistration();
    	 if (academyIds != null && academyIds != '') {
    		 studentIdNameStore.getProxy().extraParams = {
    			 academyLocationIds: academyIds/*,
		    		        		intakeYear : formValue.intakeYear,
		    		        		programCategoryId : formValue.programCategory, 
		    		        		programCategoryId : programCategoryIds,
		    		        		programGroupId : formValue.programGroupId,
		    		        		programId : formValue.program, 
		    		        		batchId : formValue.batch,*/
    		 };
    		 studentIdNameStore.load();						
    	 }
    	 else{
    		 var academyLocationId=this.getCurrentAcademyLocation();
    		 studentIdNameStore.getProxy().extraParams = {
    			 academyLocationIds: academyLocationId
    		 };
    		 studentIdNameStore.load();
    	 }			

     },
     loadStudentFeeRegistrationReportGrid:function(){
     	var $this=this;
     	var grid = $this.getStudentfeeregistrationresetgrid();
     	var form = $this.getStudentfeeregistrationresetform();
     	var filter = form.getForm();
     	var formValue = filter.getValues();
     	form.down('#btnSearch').setDisabled(true);
     	var multiselectAcademyIdField = $this.getStudentfeeregistrationresetform().down('#multiselectAcademyId');
     	var academyIdsArray = multiselectAcademyIdField.getValue();
     	var academyIds;
     	
     	if(typeof academyIdsArray[0]!="object"){
     		var academyIds = academyIdsArray;
     	}
     	else {
     		var academyIdsTempArray = [];
     		Ext.each(academyIdsArray,function(currentAcademyId){
     			academyIdsTempArray.push(currentAcademyId.data.id);
     		});
     		var academyIds = academyIdsTempArray.join(',');
     	}
     	if(!grid.isHidden())
     	{
     		var store = grid.getStore();
	        	store.getProxy().extraParams = {
	        		multiselectAcademyIds : academyIds,
	        		intakeYear : formValue.intakeYear,
	        		//programCategoryId : formValue.programCategory,
	        		programId : formValue.program, 
	        		batchId : formValue.batch,
	        		studentIdName : formValue.studentIdName,
	        	}
     	}else{
     		var store = gridAL.getStore();
	        	store.getProxy().extraParams = {
	        		multiselectAcademyIds : academyIds,
	        		intakeYear : formValue.intakeYear
	        	}
     		
     	}	
     	$this.resetPageSetting(store);
     	store.load({
			callback: function(record){
				form.down('#btnSearch').setDisabled(false);
			}
		});
     },
     
     doResetRegistration:function(){
      	
    	  var grid = this.getStudentfeeregistrationresetgrid();
          var grdStore = grid.getStore();

          if (grid.getSelectionModel().getCount() > 0) {
       	   showConfirmMessage(getCommonTranslation('RESET_REGISTRATION_PROCESS'),getCommonTranslation('Do you want to reset the Fee registration process'), function(btn, text) {
                  if (btn == 'yes') {
                      var records = grid.getSelectionModel().getSelection();
                      //var id = records[0].get("id");
                      var id = records[0].get("studentId");
                      Ext.Ajax.request({
                          method: "DELETE",
                          type: 'rest',
                          url: SERVERURL.DELETE_REGISTRATION_PROCESS+'?id='+id,
                          headers: {
                              'Content-Type': 'application/json'
                          },
                          success: function(form, action) {
                              grdStore.reload();
                              showSuccessMessage(getCommonTranslation('RESET_REGISTRATION_PROCESS'),getCommonTranslation('Registration Reset successfully'));
                          }
                      });
                  }
              });
          } else {
              showWarningMessage(getCommonTranslation('RESET_REGISTRATION_PROCESS'),getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
          } 
      },


});
