/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.controller.transport.reports.TransportDuesReportController', {
	//extend: 'Academia.controller.base.BaseController',
	extend: 'Academia.controller.base.BaseController',
	//models: [],
	stores: ['transport.reports.TransportDuesReportStore','feeandpayment.managebill.Student','transport.serviceRoute.TransportDuesServiceRouteName',
	         'feeandpayment.ProgramSmartSearchStore','program.programbatchdetail.BatchByProgramIdSSStore',
	         'program.programbatchdetail.PeriodByBatchIdSSStore','transport.reports.TransportDuesStudentDetailsStore','attendance.SectionAndFacultyByPeriodID'],
	         
	views: ['transport.reports.TransportDuesReportStructure','transport.reports.TransportDuesReportFilter',
	        'transport.reports.TransportDuesReportGrid'],
    config: {
    		TRANSPORT_DUES_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TRANSPORT_DUES_REPORT_PRIVILEGES')  ,		  
    },
    requires:['Academia.controller.personinfo.student.StudentListController','Academia.controller.personinfo.common.PersonCommonController'],
	 refs: [{
		 ref : 'transportduesreportfilter',
		 selector : 'transportduesreportfilter' 
	 },{
		 ref : 'transportduesreportstructure',
		 selector : 'transportduesreportstructure' 
	 },{
		 ref :'transportduesreportgrid',
		 selector : 'transportduesreportgrid'
	 }],
	 
	 init: function(application) {
		 this.control({
			  'transportduesreportstructure':{
	    			afterrender : function(structure){
	    			  var $this = this;
	    			  var result;
			    	  var grid;
			    	  var academyLocationId = $this.getCurrentAcademyLocation();
			    	  Ext.Ajax.request({
			    		  method: "GET",
			    		  type: 'rest',
			    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_USER_ACCESSIBLE_ACAD_LOC,
			    		  params:{
			    			  academyLocationId:academyLocationId
			    		  },
			    		  success: function(response) {
			    			  if(response){
			    				  result=response.responseText;	
			    			  }
			    	    		  structure.down("transportduesreportgrid").setVisible(true);
			    	    		  grid=structure.down("transportduesreportgrid");
			    	    		  if(result=="false"){
			    	 				 var gridColumns=grid.columns;
			    	 				 var length = gridColumns.length;
			    	 				 if(length!=null && length!=""){
			    	 					 for(var i=0; i<length; i++){
			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='currencyConvertedFee' || gridColumns[i].dataIndex=='currencyConvertedPaid'){
			    	 							 gridColumns[i].setVisible(false);
			    	 						 }
			    	 					 }
			    	 				 }
			    	 			  }else{
			    	 				 var gridColumns=grid.columns;
			    	 				 var length = gridColumns.length;
			    	 				 if(length!=null && length!=""){
			    	 					 for(var i=0; i<length; i++){
			    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='currencyConvertedFee' || gridColumns[i].dataIndex=='currencyConvertedPaid'){
			    	 							 gridColumns[i].setVisible(true);
			    	 						 }
			    	 					 }
			    	 				 }
			    	    	  }
			    		  }
			    	  });
	    			  var searchForm = structure.items.items[0];
	    			   structure.body.on('scroll', function(e, target) {
	    				  var pcstructure = structure.down("#transportduesreportgrid");
	    				  var academyLocationId = $this.getCurrentAcademyLocation();
	    				  var grid = null;
	    				//  var checkCurrency =null;
	    				  
	    				  if(!pcstructure.isHidden()){
	    					  grid = pcstructure;
	    				  }
	    				  $this.getMultipleGridHeaderFreeze(grid,structure);
					 });
	    				  
	    			}  
	    		  },
	    		 
			 'transportduesreportfilter':{
				 render : function() {
					 
					 var transportduesreportfilter = this.getTransportduesreportfilter();
					 
					 var academyLocationId = this.getCurrentAcademyLocation();
					 
					 var programCombo = transportduesreportfilter.down('#program_transportDcombo');
					 var programStore = programCombo.getStore();
					 programStore.getProxy().extraParams = {
						 academyLocationId: academyLocationId
					 };
					 transportduesreportfilter.down('#batch_transportDcombo').setDisabled(true);
					 transportduesreportfilter.down('#period_transportDcombo').setDisabled(true);
					 Ext.Ajax.request({
							url: SERVERURL.FIND_ALL_TERMINOLOGY,
							method: 'GET',
							async: false,
							params: {
								id: academyLocationId
							},
							success: function(response) {
								var responseData = response.responseText;
								var wheatherSchool;
								if(responseData=='SCHOOL'){
									transportduesreportfilter.down('#period_transportDcombo').setVisible(false);
								}
							}
						});
				 }
			 },
			 
			 'transportduesreportfilter customcombobox[itemId=program_transportDcombo]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
	    				/*var transportduesreportfilter = this.getTransportduesreportfilter();
	    				
	    				var programId = newValue[0].data.id;
	    				var batchNameCombo = transportduesreportfilter.down('#batch_transportDcombo');
	    				batchNameCombo.reset();
	    				batchNameCombo.clearValue();
	    				
	    				var periodNameCombo = transportduesreportfilter.down('#period_transportDcombo');
	    				periodNameCombo.reset();
	    				periodNameCombo.clearValue();
	    				
	    				var sectionNameCombo = transportduesreportfilter.down('#section_transportDcombo');
	    				sectionNameCombo.reset();
	    				sectionNameCombo.clearValue();
	    			
	    			
	    				
	    				var batchNameStore = batchNameCombo.getStore();
	    				batchNameStore.getProxy().extraParams = {
	    					programId: programId
	    				};
	    				batchNameStore.load();
	    				transportduesreportfilter.down('#batch_transportDcombo').setDisabled(false);
	    				transportduesreportfilter.down('#period_transportDcombo').setDisabled(true);
	    		
				 //here i am changing some code Ramkrishna yadav
	    				
	    				
	    				
	    				var sectionNameStore = sectionNameCombo.getStore();
	    				sectionNameStore.getProxy().extraParams = {
	    					programId: programId
	    				//	batchId: batchId
	    					
	    				};
	    				batchNameStore.load();
	    				sectionNameStore.load();
	    				
	    				transportduesreportfilter.down('#batch_transportDcombo').setDisabled(false);
	    				transportduesreportfilter.down('#period_transportDcombo').setDisabled(true);
	    				transportduesreportfilter.down('#section_transportDcombo').setDisabled(false);*/
	    			
	    		       //===============================================
	    		    	   

	    		    	    var transportduesreportfilter = this.getTransportduesreportfilter();
	    				    var programId = newValue[0].data.id;
						 	var form = combo.up('form');
							var batchComboBox = form.down('combo#batch_transportDcombo');
							var periodField=form.down('combo#period_transportDcombo');
							batchComboBox.clearValue();
							var batchStore = batchComboBox.getStore();	 							
							batchComboBox.reset();
							batchComboBox.getStore().getProxy().extraParams.programId = programId;
							periodField.reset();
							batchComboBox.setDisabled(false);
							//---
							 var sectionComboBox = form.down('combo#section_transportDcombo');
							 var store = sectionComboBox.getStore();
							 store.getProxy().extraParams.periodId = '';
							 store.load();
							 //---
							
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								periodField.hide();
							}
							batchComboBox.getStore().load({
								callback: function(records, operation, success) {
									if (success) {
										var batchId = 0;
										if(records.length == 1){
											batchId = records[0].data.id;
											periodField.enable();
										}else{
											for(var i=0,j=0; i<records.length; i++){
												if(records[i].data.isCurrentPeriodOfProgram){
													if(j==0){
														batchId = records[i].data.id;
														j++;
													} else {
														batchId = 0;
														return;
													}
												}
											}
											periodField.setDisabled(true);
											sectionComboBox.setDisabled(true);
										}
										if(batchId > 0){
											batchComboBox.setValue(batchId);	
											
											//periodField.reset();
											var storePeriod = periodField.getStore();
											storePeriod.getProxy().extraParams.id = batchId;

											storePeriod.load({
												callback: function(records, operation, success) {
													var sectionComboBox = form.down('combo#section_transportDcombo');
													if (success) {
														if(records.length==0){
															if(wheatherSchool) {
																showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
															}
														}else if(records.length == 1){
															periodField.setValue(records[0].data.id);
															// set section combo and enable
															var period_Id = records[0].data.id;

															
															sectionComboBox.clearValue();
															sectionComboBox.setDisabled(false);
															var store = sectionComboBox.getStore();
															store.getProxy().extraParams.periodId = period_Id;
															store.load({
																callback: function(records, operation, success) {
																	if (success) {
																		if(records.length == 1){
																			sectionComboBox.setValue(records[0].data.sectionId);
																		}
																	}
																}
															});

														}
														else{
															sectionComboBox.setDisabled(true);
															sectionComboBox.clearValue();
														}
													}
												}	 										
											});
										}
									}
								}
							});
						
	    				
				 
				 }
			 },
			 
			 'transportduesreportfilter customcombobox#period_transportDcombo' : {
				 select : function(obj, record) {
					 var period_Id = record[0].get("id");
					 var form = obj.up('form');

					 var sectionComboBox = form.down('combo#section_transportDcombo');
					 sectionComboBox.clearValue();
					 sectionComboBox.setDisabled(false);
					 var store = sectionComboBox.getStore();
					 store.getProxy().extraParams.periodId = period_Id;
					 store.load({
						 callback: function(records, operation, success) {
							 if (success) {
								 if(records.length == 1){
									 sectionComboBox.setValue(records[0].data.sectionId);
								 }
							 }
						 }
					 });

				 }
			 },
			 
			 'transportduesreportfilter customcombobox[itemId=serviceRoute]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
	    				var transportduesreportfilter = this.getTransportduesreportfilter();
	    				
	    				var serviceRouteId = newValue[0].data.id;
	    				var studentCombo = transportduesreportfilter.down('#STUDENT_ID');
	    				
	    				studentCombo.reset();
	    				
	    				var studentStore = studentCombo.getStore();
	    				studentStore.getProxy().extraParams = {
	    					serviceRouteId: serviceRouteId
	    				};
	    				
	    			}
			 },
			 
			 'transportduesreportfilter customcombobox[itemId=batch_transportDcombo]': {
				 select: function(combo,newValue, oldValue, eOpts){
	    				
	    				var transportduesreportfilter = this.getTransportduesreportfilter();
	    				
	    				var batchId = newValue[0].data.id;
	    				var periodNameCombo = transportduesreportfilter.down('#period_transportDcombo');
	    				var sectionComboBox = transportduesreportfilter.down('combo#section_transportDcombo');
	    				periodNameCombo.reset();
	    				periodNameCombo.clearValue();
	    				
	    				periodNameCombo.setDisabled(false);
	    				var periodNameStore = periodNameCombo.getStore();
	    				periodNameStore.getProxy().extraParams = {
	    					id: batchId
	    				};
	    				periodNameStore.load({
	    					callback: function(records, operation, success) {
	    							    						
	    						var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								
	    						if (success) {
	    							
	    							if(wheatherSchool){
	    								if(records.length==0){
		    								sectionComboBox.clearValue();
											sectionComboBox.setDisabled(false);
		    							}
		    							else if(records.length == 1){
											 periodNameCombo.setValue(records[0].data.id);
											 sectionComboBox.clearValue();
											 sectionComboBox.setDisabled(false);
										 }
										 else if(records.length>1){
											 sectionComboBox.clearValue();
											 sectionComboBox.setDisabled(false);
										 }
	    								if(!isNullOrEmpty(records) && !isNullOrEmpty(records[0])) {
	    									sectionComboBox.getStore().getProxy().extraParams = {
												periodId: records[0].data.id,
											};
		    								sectionComboBox.getStore().load({
		    									 callback: function(records, operation, success) {
		    										 if (success) {
		    											 if(records.length == 1){
		    												 sectionComboBox.setValue(records[0].data.sectionId);
		    											 }
		    										 }
		    									 }
		    								 });
	    								} else {
	    									sectionComboBox.getStore().removeAll();
	    									 sectionComboBox.clearValue();
	    								}
	    							}
	    							else{
	    								if(records.length==0){
		    								sectionComboBox.clearValue();
											sectionComboBox.setDisabled(true);
		    							}
		    							else if(records.length == 1){
											 periodNameCombo.setValue(records[0].data.id);
											 sectionComboBox.clearValue();
											 sectionComboBox.setDisabled(false);
										 }
										 else if(records.length>1){
											 sectionComboBox.clearValue();
											 sectionComboBox.setDisabled(true);
										 }
	    							}
								 }
	    					}
	    				});
	    				//transportduesreportfilter.down('#period_transportDcombo').setDisabled(false);
	    			}
			 },
			 'transportduesreportfilter button[itemId=searchBtn]': {
				 click: function() {
					 
					 var $this = this;
					 var transportduesreportfilter = this.getTransportduesreportfilter();
					 var form = transportduesreportfilter.getForm();
					 
					 var formValues = form.getValues();
					 
					 var transportduesreportgrid = this.getTransportduesreportgrid();
					 var transportStore = transportduesreportgrid.getStore();
					 
					 var programId;
					 var batchId;
					 var periodId;
					 var studentId;
					 var serviceRouteId;
					 var sectionId;
					 
					 if(!isNullOrEmpty(formValues.PROGRAM_ID)) {
						 
						 programId = formValues.PROGRAM_ID;
						 
					 } if(!isNullOrEmpty(formValues.BATCH_ID)) {
						 
						 batchId = formValues.BATCH_ID;
						 
					 } if(!isNullOrEmpty(formValues.PERIOD_ID)) {
						 
						 periodId = formValues.PERIOD_ID;
						 
					 } if(!isNullOrEmpty(formValues.serviceRoute)) {
						 
						 serviceRouteId = formValues.serviceRoute;
						 
					 } if(!isNullOrEmpty(formValues.STUDENT_ID)) {
						 
						 studentId = formValues.STUDENT_ID;
					 } 
					 if(!isNullOrEmpty(formValues.SECTION_ID)) {

						 sectionId = formValues.SECTION_ID;
					 } 
					 
					 
					 transportStore.getProxy().extraParams = {
							 serviceRouteId:serviceRouteId,
							 programId:programId,
							 batchId:batchId,
							 periodId:periodId,
							 studentId:studentId,
							 sectionId:sectionId
					 }
					 
					 transportStore.load({
						 callback: function(record, operation, success) {
								 if (record.length > 0) {
									$this.toggleGridSummaryRow(transportduesreportgrid,true);
								 }else{
									$this.toggleGridSummaryRow(transportduesreportgrid,false);
								 }
							 }
					});
					 transportduesreportgrid.config.searchFilterForm = transportduesreportfilter;
				 }
			 },
			 
			 'transportduesreportfilter button[itemId=resetBtn]': {
				 click: function() {
					 var transportduesreportfilter = this.getTransportduesreportfilter();
					 transportduesreportfilter.getForm().reset();
					 transportduesreportfilter.down('#batch_transportDcombo').setDisabled(true);
	    			 transportduesreportfilter.down('#period_transportDcombo').setDisabled(true);
	    			 transportduesreportfilter.down('#section_transportDcombo').setDisabled(true);
				 }
			 },
			 
			 'transportduesreportgrid':{   
				 beforerender : function(grid) {

					 var alinfomodel = Academia.model.authentication.ALInfoModel;
					 var whetherSchool = alinfomodel.get('wheatherSchool');

					 var result = grid.columns.filter(function (obj) {
						 return obj.dataIndex === "programPeriodName";
					 })[0];
					 if (whetherSchool) {

						 var resIndex = result.getIndex();
						 if(resIndex != -1){
							 grid.columnManager.columns[resIndex].destroy();
							 grid.columns[resIndex].destroy();
							 grid.getView().refresh();
						 }
					 } else {
						 result.hide();
					 }
				 },
				 afterrender : function(grid) {

					 this.doAccessControlValidation(grid, this.getTRANSPORT_DUES_REPORT_PERMISSIONS());

					 var alinfomodel = Academia.model.authentication.ALInfoModel;
					 var whetherSchool = alinfomodel.get('wheatherSchool');

					 if (!whetherSchool) {
						 var cmbPeriod =  grid.down('[dataIndex=programPeriodName]');
						 cmbPeriod.hide();
					 }
				 },
				 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   var this$ = this;
				   var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
				   
				  
				   var studentListController = this$.getController('Academia.controller.personinfo.student.StudentListController');
				   var personCommonController = this$.getController('Academia.controller.personinfo.common.PersonCommonController');
				   
				   
			        
				   if(columnName=="studentId"){
  					   if(e.target.tagName=='A'){
  						   
  						var tabTitle = record.get('studentId');
  			            var personId = record.get('personId');
  			            var userId = record.get('userId');
  			            var admissionId = record.get('admissionId');
  			            var programBatchSeatTypeConfigId = record.get('PROGRAM_BATCH_SEAT_CONFIG_ID');
  			            personCommonController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
  					   }
  				   }
  				   /*var studentProfile = this.getTabReferenceByTabTitle(tabTitle);
  				   var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');

  				   if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
  					   var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
  					   studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
  				   }*/
  			   },
			 }
		 });
	 },
	 
	 resetAndDisabledByField : function(value) {
	    	
	    	var transportduesreportfilter = this.getTransportduesreportfilter();
	    	
	    	var programCombo = transportduesreportfilter.down('#program_infirmarycombo');
	    	var batchCombo = transportduesreportfilter.down('#batch_infirmarycombo');
	    	var periodCombo = transportduesreportfilter.down('#period_infirmarycombo');
	    	
	    	if(value == 'PROGRAM') {

	    		this.resetAndDisabled(periodCombo);

	    	} else if(value == 'BATCH') {
	    		this.resetAndDisabled(sectionCombo);
	    	} else if(value == 'ALL') { 
	    		this.resetAndDisabled(programCombo);
	    		this.resetAndDisabled(batchCombo);
	    		this.resetAndDisabled(periodCombo);
	    		this.resetAndDisabled(sectionCombo);
	    		this.resetAndDisabled(employeeUserCombo);
	    	}
	    },
	 
	   	resetFilter : function(obj){
	   		var form = obj.up('form').getForm();
	   		form.getFields().each(function(field) {
	   			if(field.name != 'detailFor' && field.name != 'detailView') {
	   				form.reset();
	   			}
	   		});
	   	}
});
