Ext.define('Academia.store.common.RelationshipStore', {
    extend: 'Ext.data.Store',
    fields: ['name', {
    		name:'value',
    		convert: function(value, rec){
    			 if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
    				 return rec.get('displayValue');
    			 }else{
    				 return value;
    			 }
		    },
    	},'displayValue','permissionKey'],
    data: [{
    	name: 'BROTHER',
        value: getPersonModuleTranslation('BROTHER'),
        displayValue: getPersonModuleTranslation('BROTHER')
    }, {
    	name: 'SISTER',
        value: getPersonModuleTranslation('SISTER'),
        displayValue: getPersonModuleTranslation('SISTER')
    }, {
    	name: 'FATHER',
        value: getPersonModuleTranslation('FATHER'),
        displayValue: getPersonModuleTranslation('PARENT_GUARDIAN1')
    }, {
    	name: 'MOTHER',
        value: getPersonModuleTranslation('MOTHER'),
        displayValue: getPersonModuleTranslation('PARENT_GUARDIAN2')
    }, {
    	name: 'GUARDIAN',
        value: getPersonModuleTranslation('GUARDIAN'),
        displayValue: getPersonModuleTranslation('PARENT_GUARDIAN3')
    }, {
    	name: 'LOCAL_GUARDIAN',
        value: getPersonModuleTranslation('LOCAL_GUARDIAN'),
        displayValue: getPersonModuleTranslation('LOCAL_GUARDIAN')
    }, {
    	name: 'VISITOR1',
        value: getPersonModuleTranslation('VISITOR1'),
        displayValue: getPersonModuleTranslation('VISITOR1'),
        permissionKey:'RELATIONSHIP_VISITOR1'
    }, {
    	name: 'VISITOR2',
        value: getPersonModuleTranslation('VISITOR2'),
        displayValue: getPersonModuleTranslation('VISITOR2'),
        permissionKey:'RELATIONSHIP_VISITOR2'
    }, {
    	name: 'VISITOR3',
        value: getPersonModuleTranslation('VISITOR3'),
        displayValue: getPersonModuleTranslation('VISITOR3'),
        permissionKey:'RELATIONSHIP_VISITOR3'
    }, {
    	name: 'VISITOR4',
        value: getPersonModuleTranslation('VISITOR4'),
        displayValue: getPersonModuleTranslation('VISITOR4'),
        permissionKey:'RELATIONSHIP_VISITOR4'
    }],
    listeners:{
    	load: function(store){
    		if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
    			var rec = store.findRecord('name','VISITOR1');
    			if(rec)
    				store.remove(rec);
    			var rec = store.findRecord('name','VISITOR2');
    			if(rec)
    				store.remove(rec);
    			var rec = store.findRecord('name','VISITOR3');
    			if(rec)
    				store.remove(rec);
    			var rec = store.findRecord('name','VISITOR4');
    			if(rec)
    				store.remove(rec);
    		}
    		
    		//V2D-411000
    		/*try{
        		if(portalId == 3 && Ext.isDefined(Ext.ComponentQuery.query('personcommonwindow')[0])){
        			var mainWin = Ext.ComponentQuery.query('personcommonwindow')[0];
        			var winForm = mainWin.down('form');
        			if(winForm.xtype=="parentguardianform" && winForm.itemId=="studentParentGuardianForm"){
        				var parentForm = winForm.getForm();
        				var parentId = parentForm.findField('id').getValue();
        				if(isNullOrEmpty(parentId)){
        					var rec = store.findRecord('name','FATHER');
        	    			if(rec)
        	    				store.remove(rec);
        	    			var rec = store.findRecord('name','MOTHER');
        	    			if(rec)
        	    				store.remove(rec);
        	    			var rec = store.findRecord('name','GUARDIAN');
        	    			if(rec)
        	    				store.remove(rec);
        	    			var rec = store.findRecord('name','LOCAL_GUARDIAN');
        	    			if(rec)
        	    				store.remove(rec);
        				}
        			}
        		}
    		}
    		catch(e){
    			console.log('');
    		}*/
    	}
    }
}); 