/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.facilitiesresources.managegallery.MapAlbumStore', {
    extend: 'Ext.data.Store',
    fields: [
        { name:'id', type:'string' },
        { name:'code', type:'string' },
        { name:'value', type:'string' },
        { name:'sequence', type:'string' },
        { 
        	name:'isShared', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(rec.get('sequence'))){
        			try{
            			return (rec.get('sequence')==1) ? true : false;
        			}
        			catch(e){
            			return false;
        			}
        		}else{
        			return false;
        		}
        	}
        }
    ],
    autoLoad: false,
    remoteSort: false,
    proxy: {
        type: 'rest',
        method: 'GET',
        api: {
            read: SERVERURL.PATH_FIND_ALL_PROGRAM_BATCH_LIST
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }
});
