/**
 * @author Varsha Gour
 */
Ext.define('Academia.store.messaging.CommunicationHistoryMobileStore', {
	extend : 'Ext.data.Store',
	model: 'Academia.model.messaging.CommunicationHistoryContactModel',
	autoLoad : false,
	sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('mobileNumber');
	        var value2 = o2.get('mobileNumber');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
	proxy : {
        type: 'rest',
        api: {
            read: SERVERURL.PATH_FIND_PERSON_CONTACT_DETAIL_BY_PERSON_ID
        },
        reader: {
            type: 'json',            
        }
    }
});
