/**
 * @author Sachin.Bangar
 * Address Type Store
 */

Ext.define('Academia.store.servicerequest.personaldatachangerequest.AddressTypeStore',{
	extend : 'Ext.data.Store',
	model : 'Academia.model.organization.AddressType',
	autoLoad : false,	
	proxy : {
		type : 'rest',
		api : {
			read : SERVERURL.ADDRESS_TYPE_COMBO_STORE + '?addressCategory=PERSON'
		},
		reader : {
			type : 'json'
		}
	},
    listeners: {
        load: {
            element: 'el',
            fn: function(store, records, successful, eOpts) {
                for (var count = 0; count < records.length; count++) {
                    records[count].set('displayValue', getPersonModuleTranslation(records[count].get("addressTypeName")));
                }
                store.commitChanges();
            }
        }
    }
});