/**
 * 
 */
Ext.define('Academia.store.student.report.StudentHealthInformationReportStore', {
	extend : 'Ext.data.Store',
	fields: [
    	'medicalConditions',
    	{
    		name: 'medicalConditionsVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'medicalConditions' )) && record.get( 'medicalConditions' ).length){
    	    		return Ext.Array.pluck(record.get( 'medicalConditions' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	}, 
    	'medication',
    	{
    		name: 'medicationVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'medication' )) && record.get( 'medication' ).length){
    	    		return Ext.Array.pluck(record.get( 'medication' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	},
    	
    	'allergies', 
    	{
    		name: 'allergiesVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'allergies' )) && record.get( 'allergies' ).length){
    	    		return Ext.Array.pluck(record.get( 'allergies' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	},
    	
    	'learningDifficulties',
    	{
    		name: 'learningDifficultiesVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'learningDifficulties' )) && record.get( 'learningDifficulties' ).length){
    	    		return Ext.Array.pluck(record.get( 'learningDifficulties' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	},
    	'medicalConditionOther',
    	'medicationOther', 
    	'allergiesOther',
    	'learningDifficultiesOther',
    	'studentHealthDocument',
    	'studentHealthDocumentUrl',
    	'programName','batchName','academyLocation','studentId','periodName','academicTerm','studentHealthId'
    ],
	autoLoad : false,
	proxy : {
		type : 'rest',
		method: 'GET',
		api:{
			read:SERVERURL.PATH_FIND_ALL_HEALTH_INFORMATION_REPORT
		},
		reader: {
			type: 'json',
			root: 'rows',
			totalProperty: 'records'
		}
	}
});
