	Ext.define('Academia.utilities.gridExporter',{});

	function createTableHeader(renderTo,sourceTableBody){
		
		/*var baseController=Academia.app.getController('base.BaseController');
   	    var loggedInUser=baseController.getCurrentlyLoggedInUser();
        var generatedBy="Generated By:"+loggedInUser.value;
        var poweredBy="Powered By:Academia ERP";
        var onDate="On:"+Ext.Date.format(new Date(),'d/m/Y');*/
		
		
		if($('#' + renderTo).find('colgroup').length != 0){
			var headerElements = $('#' + renderTo).find('.x-column-header');
			if(headerElements){
				var tableHeader = buildTableHeader(headerElements,renderTo);
				var tableElement = $('#' + renderTo).find('table');
				if(tableElement){
					/*var footer="<footer  id='Academia_V2_Footer' style='visibility:hidden;'>" +							
						"<div><span style='margin-left: 100px;'>Page </span><span class='pageCounter'></span><span>/</span><span class='totalPages'></span></div>"+
						"<div><span>"+generatedBy+"</span></div>"+							
						"<div><span>"+onDate+"</span></div>"+							
						"<div><span>"+poweredBy+"</span></div>"+														
						"</footer>";
					//$(footer).insertAfter(sourceTableBody.find('table'));
					var header="<header  id='Academia_V2_Header_Title' style='visibility:hidden;'>"+
								"<p><span style='font-size:24px'><span style='font-family:arial,helvetica,sans-serif'>KLU</span></span></p>"+
								"<p><span style='font-size:16px'><span style='font-family:arial,helvetica,sans-serif'>K L University,</span></span></p>"+
								"<header>";
					$(header).insertBefore(sourceTableBody.find('table'));*/
					$(tableHeader).insertBefore(sourceTableBody.find('tbody'));
				}
			}
		}
		return sourceTableBody;
	}
		
	function buildTableHeader(headers,renderTo){
		var headerElement ="<thead id='ERP_HEADER_NAMES' style='visibility:hidden; height:0px ;white-space: nowrap;width: 250px;overflow: hidden;text-overflow: ellipsis;'><tr>";
		var ColGroupElement ="<colgroup id='ERP_COLUMN_GROUP' style='visibility:hidden; height:0px'>";
		var colWidths = calculateColGroupWidth(renderTo);
		
		//--Adding Serial No. Header
		if(!Ext.getCmp(renderTo).removeSerialColumn){
			headerElement +="<th style='white-space: nowrap;'>"+getCommonTranslation('SERIAL_NO')+"</th>";
			ColGroupElement +="<col width='1%'>";
			
		}
		
		for(var i=0;i<headers.length;i++){
			if(headers[i].style.display!=="none" && !isNullOrEmpty(colWidths[i])){
				var innerHTML=$("#"+headers[i].id+"-textEl")[0].innerHTML;
				headerElement += "<th style='white-space: nowrap;'>" + innerHTML+ "</th>";
			 	ColGroupElement += "<col width='" + colWidths[i] + "%'>";	
			}			 
		}
		headerElement += "</tr></thead>";
		ColGroupElement +="</colgroup>";
		
		return ColGroupElement + headerElement;
	}

	function calculateColGroupWidth(renderTo){
		var headerElements = $('#' + renderTo).find('.x-column-header');
		var colElements = $('#' + renderTo).find('col');
		//var tableElement = $('#' + renderTo).find('table');
		var colWidths =[], totalWidth=0, width=0;
		if(headerElements){
			for(var i=0;i<headerElements.length;i++){
				if(renderTo.indexOf("holidaydetailscalendargrid")!=-1 && (headerElements[i].textContent==getServiceRequestTranslation('EMM_ADD') || headerElements[i].textContent==getServiceRequestTranslation('EMM_DELETE'))){
					//--
				}
				else{
					width = $(headerElements[i]).width();				
					 colWidths.push(width);
					 totalWidth += width;
				}
			}
			if(totalWidth >0 ){
				for(var i=0;i<colWidths.length && i<colElements.length;i++){
					//$(colElements[i]).width(((colWidths[i] * 100) / totalWidth)+"%");
					colWidths[i] = ((colWidths[i] * 100) / totalWidth);	
				}					
			}
		}
		return colWidths;
	}
	
	
	function hideUnnecessaryElements(renderTo){
		$('#' + renderTo).find('.x-box-inner').attr('id','bypassme'); 
	}
	
	function transformExtJsGrid(renderTo,sourceTableBody){
		sourceTableBody=createTableHeader(renderTo,sourceTableBody);
		return sourceTableBody;
	}
	
	function getImageSizeFromBase64(imgData){
		var i = new Image(); 
		i.onload = function(){
			if((i.width/i.height) > 3.5 && i.width > 250){
				return true;
			}
			else{
				return false;
			}
		};

		i.src = imgData;
		
		return i.onload;
	}
	
	function exportToPDF(renderTo,myMask,title,imageExtension,imageData,displayName, headerCount, grid){ 
		// source can be HTML-formatted string, or a reference
		// to an actual DOM element from which the text will be scraped.
		
		//var universityName=Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getRawValue();
		
		if((!isNullOrEmpty(grid) && !isNullOrEmpty(grid.config.searchFilterForm)) || !isNullOrEmpty(grid.config.htmlFilter)){
			
			/***************Start Code added for show filter data on PDF Export Report **************/
			var universityAddress=""; //Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getRawValue();
	        title=isNullOrEmpty(title)?getCommonTranslation("EXPORT_LIST"):title;
			var sourceTableBody = $('#' + renderTo +'-body');
			sourceTableBody=transformExtJsGrid(renderTo,sourceTableBody);
			
			//var sourceTableBody = $('#Academia_V2_Footer');
			
			//var headerElements = $('#' + renderTo).find('.x-column-header-text');
			var pdf =null;
			/*if(headerElements){
				headerCount=headerElements.length;
			}*/							
			var pdfOrientation = {};
			var widthFilter = 350;
			if(headerCount > 6){
				pdfOrientation = {
				         orientation: 'l',
				         unit: 'pt',
				         format: 'a4',
				         compress: true,
				         fontSize: 8,
				         lineHeight: 1,
				         autoSize: true,
				         printHeaders: false
				     };
				pdf = new jsPDF(pdfOrientation, '', '', '');
				var imgData ="data:image/"+imageExtension+";base64,"+imageData;
				var isImageBigger = getImageSizeFromBase64(imgData);
				
				if(!isImageBigger){
				pdf.addImage(imgData, imageExtension, 700 , 30, 100, 70);				  //left, top, width, height
				}
				else{
					pdf.addImage(imgData, imageExtension, 650 , 30, 150, 40);
				}
				
				pdf.setFontSize(12);
				pdf.setFontType("bold");
				var newTitle = "Report Name: "+title; 
				pdf.text(20, 150, newTitle);
				
				widthFilter = 500;
			}if(headerCount <= 5 && grid.xtype == "examconcessiongrid"){
				pdfOrientation = {
				         orientation: 'l',
				         unit: 'pt',
				         format: 'a4',
				         compress: true,
				         fontSize: 8,
				         lineHeight: 1,
				         autoSize: true,
				         printHeaders: false
				     };
				pdf = new jsPDF(pdfOrientation, '', '', '');
				var imgData ="data:image/"+imageExtension+";base64,"+imageData;
				var isImageBigger = getImageSizeFromBase64(imgData);
				
				if(!isImageBigger){
				pdf.addImage(imgData, imageExtension, 700 , 30, 100, 70);				  //left, top, width, height
				}
				else{
					pdf.addImage(imgData, imageExtension, 650 , 30, 150, 40);
				}
				
				pdf.setFontSize(12);
				pdf.setFontType("bold");
				var newTitle = "Report Name: "+title; 
				pdf.text(20, 115, newTitle);
				
				widthFilter = 500;
			}else{
				pdfOrientation = {
				         orientation: 'p',
				         unit: 'pt',
				         format: 'a4',
				         compress: true,
				         fontSize: 8,
				         lineHeight: 1,
				         autoSize: true,
				         printHeaders: false
				     };
				pdf = new jsPDF(pdfOrientation, '', '', '');
				var imgData ="data:image/"+imageExtension+";base64,"+imageData;
				
				
				var isImageBigger = getImageSizeFromBase64(imgData);
				
				if(!isImageBigger){
				pdf.addImage(imgData, imageExtension, 450 , 30, 100, 70); //left, top, width, height
				}
				else{
					pdf.addImage(imgData, imageExtension, 400 , 30, 150, 40);
				}
				
				pdf.setFontSize(12);
				pdf.setFontType("bold");
				var newTitle = "Report Name: "+title; 
				if(title.length>50){
					pdf.text(20, 115, newTitle);
				}
				else{
					pdf.text(20, 115, newTitle);	
				}
			}
		
			//pdf = new jsPDF('p', 'pt', 'a4');
		
			/* Adding Logo and Header String */
			//var imgData ='data:image/png;base64,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';
			try{
				if(!isNullOrEmpty(Ext.getCmp(renderTo).studentId) && !isNullOrEmpty(Ext.getCmp(renderTo).studentName)){
					pdf.setFontSize(13);
					pdf.setTextColor('#ff0000');
					pdf.setFontType("normal");
					pdf.text(20, 75, Ext.getCmp(renderTo).studentId + " / " + Ext.getCmp(renderTo).studentName);
					pdf.setTextColor('#000000');
				}
			}
			catch(e){}

			pdf.setFontSize(12);
			pdf.setFontType("bold");		
			pdf.text(20, 60, displayName);
			
			pdf.setFontSize(12);
			pdf.setFontType("normal");		
			pdf.text(500, 60, universityAddress);
			
			/*pdf.setFontSize(12);
			pdf.setFontType("bold");			
			pdf.text(250, 110, title);*/		
			
			pdf.setFontSize(10);
			pdf.setFontType("normal");		

			if(!isNullOrEmpty(grid.config.searchFilterForm)){
				var form = grid.config.searchFilterForm.getForm();
				if(!isNullOrEmpty(form)){
					var htmlFilter = '';
					var htmlFilterExcelstr = '';
					grid.config.htmlFilter = null;
					form.getFields().each(function(field) {
						if(field.isVisible()){
							if(field.xtype=='statusCombo'|| field.xtype=='groupingcombobox' || field.xtype=='textfield' || field.xtype=='textarea' || field.xtype=='checkboxfield' ||  
									field.xtype=='datefield' || field.xtype=='numberfield' || field.xtype=='textareafield'||field.xtype=='timefield'
										|| field.xtype=='customcombobox' || field.xtype=='nestedJsonCombo' || field.xtype=='combo'
											|| field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='multiselectfield'|| field.xtype=='livesearchcombo'){

								if(field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='multiselectfield'){
									if(!isNullOrEmpty(field.valueModels) && field.valueModels.length>0){
										var fieldLabel = field.getFieldLabel();
										
										if(!isNullOrEmpty(field.el) && !isNullOrEmpty(field.el.dom)){
											var innerItems = field.el.dom.getElementsByClassName('x-boxselect-item');
											if(innerItems.length>0){
												var str = '';
												for (var i = 0; i < innerItems.length; i++) { 
										            str = str + innerItems[i].title + ', ';
										        }
												str = str.replace(/,\s*$/, "");
												htmlFilter = htmlFilter + '<div style="margin-top:10px;">'+fieldLabel+' : ' + str + '</div>';
												
												htmlFilterExcelstr += '<Row ss:AutoFitHeight="1"><Cell ss:MergeAcross="2">' +
				                                '<Data ss:Type="String">' + fieldLabel+' : ' + str + '</Data>' +
				                                '</Cell></Row>';
											}
										}
									}
								}
								else{
									var fieldLabel = field.getFieldLabel();
									var rawValue = field.getRawValue();
									if(!isNullOrEmpty(fieldLabel) && !isNullOrEmpty(rawValue)){
										htmlFilter = htmlFilter + '<div style="margin-top:10px;">'+fieldLabel+' : ' + rawValue + '</div>';	
										
										htmlFilterExcelstr += '<Row ss:AutoFitHeight="1"><Cell ss:MergeAcross="2">' +
		                                '<Data ss:Type="String">' + fieldLabel+' : ' + rawValue + '</Data>' +
		                                '</Cell></Row>';
									}
									else if(!isNullOrEmpty(field.boxLabel)){
										if(field.getValue()){
											fieldLabel = field.boxLabel;
											htmlFilter = htmlFilter + '<div style="margin-top:10px;">'+fieldLabel+' : ' + rawValue + '</div>';	
											
											htmlFilterExcelstr += '<Row ss:AutoFitHeight="1"><Cell ss:MergeAcross="2">' +
			                                '<Data ss:Type="String">' + fieldLabel+' : ' + rawValue + '</Data>' +
			                                '</Cell></Row>';
										}
									}
								}
							}
						}
					});
					
					if(!isNullOrEmpty(htmlFilter)){
						grid.config.htmlFilter = htmlFilter;
						grid.config.htmlFilterExcel = htmlFilterExcelstr;
						grid.config.searchFilterForm = null;
						pdf.fromHTML(htmlFilter,20,130,{
							'width': widthFilter
						});
					}
				}
			}
			else if(!isNullOrEmpty(grid.config.htmlFilter)){
				pdf.fromHTML(grid.config.htmlFilter,20,130,{
					'width': widthFilter
				});
			}

			var baseController=Academia.app.getController('base.BaseController');
	   	    var loggedInUser=baseController.getCurrentlyLoggedInUser();
			
			var footerdata=new Array();
			footerdata.push(getCommonTranslation("FOOTER_GENERATED_BY")+loggedInUser.value);
			footerdata.push(getCommonTranslation("FOOTER_POWERED_BY")+getCommonTranslation("FOOTER_ACADEMIA_ERP"));
			footerdata.push(getCommonTranslation("FOOTER_ON")+dateRender(new Date())+" "+timeRender(new Date()));	        				
			
			var tableElement = $('#' + renderTo +'-body').find('table');
			var data = pdf.tableToJson(tableElement[0].id,Ext.getCmp(renderTo));
			if(!isNullOrEmpty(grid.config.htmlFilter)){
				//code end for adjusting text in fields(concept capital to small)
				var divCount = (grid.config.htmlFilter.split('div').length-1)/2;
				//counting rows here
				var divs = grid.config.htmlFilter.match(/<div([^\<]*?)<\/div>/g);
				for(i in divs){
				var divText = jQuery(divs[i]).text();
				var divTextLen = divText.length;
				var rows = Math.ceil(divTextLen/90);
				 divCount = divCount + rows - 1;
				}
				if(divCount>10){
					if(divCount<20){
						var footergenrated = '<div style="font-size:13px">Page -: 1</div>'+'<div style="font-size:13px">'+footerdata[0]+'</div>'+'<div style="font-size:13px">'+footerdata[1]+'</div>'+'<div style="font-size:13px">'+footerdata[2]+'</div>';
						pdf.fromHTML(footergenrated,20,460)	
					}
					pdf.addPage();
					var tableHeight = 130;
					var pageNo = 2;
				}else{
					var tableHeight = (divCount*18)+170;
					var pageNo = 1;
				}
			}
			// END of counting rows
			
			if(!isNullOrEmpty(grid.config.htmlFilter)){
				height = pdf.drawTable(data, {
					xstart : 20,
					ystart : 70,
					tablestart : tableHeight,					
					marginright :10,
					xOffset : 1,
					yOffset : 10,
					footerHeight:100,
					footerData:footerdata
				},pageNo);
			}
			else{
				height = pdf.drawTable(data, {
					xstart : 20,
					ystart : 70,
					tablestart : 125,					
					marginright :10,
					xOffset : 1,
					yOffset : 10,
					footerHeight:100,
					footerData:footerdata
				},pageNo);
			}
					
			
			setTimeout(function() {					  
				  pdf.save(title+'.pdf');
				  $("#ERP_HEADER_NAMES").remove();
				  $("#ERP_COLUMN_GROUP").remove();
				  //$("#Academia_V2_Header_Title").remove();
				  //$("#Academia_V2_Footer").remove();
				  myMask.hide();
			},1000);		
			return true;
			
			/***************End Code added for show filter data on PDF Export Report **************/
		}
		else{

			// source can be HTML-formatted string, or a reference
			// to an actual DOM element from which the text will be scraped.

			//var universityName=Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getRawValue();

			var universityAddress=""; //Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getRawValue();
			title=isNullOrEmpty(title)?getCommonTranslation("EXPORT_LIST"):title;
			var sourceTableBody = $('#' + renderTo +'-body');
			sourceTableBody=transformExtJsGrid(renderTo,sourceTableBody);

			//var sourceTableBody = $('#Academia_V2_Footer');

			//var headerElements = $('#' + renderTo).find('.x-column-header-text');
			var pdf =null;
			/*if(headerElements){
				headerCount=headerElements.length;
			}*/							
			var pdfOrientation = {};
			if(headerCount > 6){
				pdfOrientation = {
						orientation: 'l',
						unit: 'pt',
						format: 'a4',
						compress: true,
						fontSize: 8,
						lineHeight: 1,
						autoSize: true,
						printHeaders: false
				};
				pdf = new jsPDF(pdfOrientation, '', '', '');
				var imgData ="data:image/"+imageExtension+";base64,"+imageData;

				var isImageBigger = getImageSizeFromBase64(imgData);
				
				if(!isImageBigger){
					pdf.addImage(imgData, imageExtension, 700, 30, 100, 70);				  //left, top, width, height
				}
				else{
					pdf.addImage(imgData, imageExtension, 650, 30, 150, 40);
				}
				
				pdf.setFontSize(12);
				pdf.setFontType("bold");
				var newTitle = "Report Name: "+title; 
				if(grid.xtype == 'viewactualaccountstatementgrid'||grid.xtype == 'viewstudentactualaccountstatementgrid'){
                    pdf.text(20, 115, newTitle);
                }else{
                    pdf.text(350, 115, newTitle);
                }
			}else{
				pdfOrientation = {
						orientation: 'p',
						unit: 'pt',
						format: 'a4',
						compress: true,
						fontSize: 8,
						lineHeight: 1,
						autoSize: true,
						printHeaders: false
				};
				pdf = new jsPDF(pdfOrientation, '', '', '');
				var imgData ="data:image/"+imageExtension+";base64,"+imageData;
				
				var isImageBigger = getImageSizeFromBase64(imgData);
				
				if(!isImageBigger){
					pdf.addImage(imgData, imageExtension, 450, 30, 100, 70);				  //left, top, width, height
				}
				else{
					pdf.addImage(imgData, imageExtension, 400, 30, 150, 40);
				}
				
				pdf.setFontSize(12);
				pdf.setFontType("bold");

				var gridXtype = Ext.getCmp(renderTo).xtype;
				if(!isNullOrEmpty(grid)){
					var gridXtypeForAll = grid.xtype;
				}

				var newTitle = "Report Name: "+title; 
				if(title.length>47){
					pdf.text(50, 115, newTitle);
				}
				else if(gridXtype == 'programoutcomeindirectattainmentgrid' || gridXtypeForAll == 'programoutcomeindirectattainmentgrid' || gridXtype == 'examinationremarkplangrid'){
					pdf.text(150, 115, newTitle);
				}
				else{
					pdf.text(200, 115, newTitle);
				}
			}

			//pdf = new jsPDF('p', 'pt', 'a4');

			/* Adding Logo and Header String */
			//var imgData ='data:image/png;base64,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';
			try{
				if(!isNullOrEmpty(Ext.getCmp(renderTo).itemId == 'facultyEducationHistoryGrid')){
					pdf.setFontSize(13);
					pdf.setTextColor('#ff0000');
					pdf.setFontType("normal");
					//pdf.text(20, 75, displayName);
					pdf.setTextColor('#000000');
				}
				if(!isNullOrEmpty(Ext.getCmp(renderTo).studentId) && !isNullOrEmpty(Ext.getCmp(renderTo).studentName)){
					pdf.setFontSize(13);
					pdf.setTextColor('#ff0000');
					pdf.setFontType("normal");
					pdf.text(20, 75, Ext.getCmp(renderTo).studentId + " / " + Ext.getCmp(renderTo).studentName);
					pdf.setTextColor('#000000');
				}
			}
			catch(e){}

			pdf.setFontSize(12);
			pdf.setFontType("bold");		
			pdf.text(20, 60, displayName);

			pdf.setFontSize(12);
			pdf.setFontType("normal");		
			pdf.text(500, 60, universityAddress);

			/*pdf.setFontSize(12);
			pdf.setFontType("bold");			
			pdf.text(250, 110, title);*/		

			pdf.setFontSize(10);
			pdf.setFontType("normal");		

			var baseController=Academia.app.getController('base.BaseController');
			var loggedInUser=baseController.getCurrentlyLoggedInUser();

			var footerdata=new Array();
			footerdata.push(getCommonTranslation("FOOTER_GENERATED_BY")+loggedInUser.value);
			footerdata.push(getCommonTranslation("FOOTER_POWERED_BY")+getCommonTranslation("FOOTER_ACADEMIA_ERP"));
			footerdata.push(getCommonTranslation("FOOTER_ON")+dateRender(new Date())+" "+timeRender(new Date()));	        				

			var tableElement = $('#' + renderTo +'-body').find('table');
			data = pdf.tableToJson(tableElement[0].id,Ext.getCmp(renderTo));
			//code for adjusting text in fields(concept capital to small)
			/*
			 * code commented for issue for field url entry 
			 */
			/*tempArr = [];
			data.forEach(function(obj){

				var datastring = JSON.stringify(obj);
				var newString = ""
				for (var i = 0, len = datastring.length; i < len; i++) {
					var fleg = true;

					if(datastring[i] == "," && datastring[i-1] != '"' && datastring[i+1] != '"'){
						fleg = false;
					}
					if(fleg){
						newString  = newString + datastring[i];
					}
					//console.log(newString);
				}
				datastring = newString;
				datastring = datastring.replace(/{/g, "").replace(/}/g, "").replace(/"/g, "");
				datastring = datastring.split(',');
				tempArrInner = [];
				datastring.forEach(function(dt){
					dt = dt.split(':');
					var leftString = dt[0];
					var rightString = "";
					var regexTest = (/^[^a-z-0-9]*$/).test(dt[1]);
					if(regexTest){
						stringSplit = dt[1].split(' ');
						stringSplit.forEach(function(str){
							tempString = str.charAt(0).toUpperCase() + str.slice(1).toLowerCase();
							rightString  = rightString + ' ' +tempString;
						});
						rightString = rightString.trim();
					} else {
						rightString = dt[1];
					}
					tempArrInner[leftString] = rightString;
				});
				tempArr.push(tempArrInner);

			});*/
			//code end for adjusting text in fields(concept capital to small)
			height = pdf.drawTable(data, {
				xstart : 20,
				ystart : 70,
				tablestart : 125,					
				marginright :10,
				xOffset : 1,
				yOffset : 10,
				footerHeight:100,
				footerData:footerdata
			});

			//pdf.text(50, height + 20, 'hi world');
			// we support special element handlers. Register them with jQuery-style 
			// ID selector for either ID or node name. ("#iAmID", "div", "span" etc.)
			// There is no support for any other type of selectors 
			// (class, of compound) at this time.
			/*var specialElementHandlers = {
				// element with id of "bypass" - jQuery style selector
				'defaultHandler': function(element, renderer){
					var _element = $(element);
					console.log(_element);
					if(_element.hasClass('x-column-header-inner') 
						|| _element.hasClass('x-box-inner') 
						|| _element.is('th') 
						){
						// true = "handled elsewhere, bypass text extraction"
						return true;
					}
				}
			};

			var margins = {
			  top: 130,
			  bottom: 20,
			  left: 20,
			  width: 800
			};*/

			// all coords and widths are in jsPDF instance's declared units
			// 'inches' in this case
			/*pdf.fromHTML(		
				null
				//sourceTableBody[0] // HTML string or DOM elem ref.
				, margins.left // x coord
				, margins.top // y coord
				, {
					'width': 1500 // max width of content on PDF
					//printHeaders: true
					, 'elementHandlers': specialElementHandlers
				},
				function (dispose) {
				  // dispose: object with X, Y of the last line add to the PDF 
				  //          this allow the insertion of new lines after html			 
				  setTimeout(function() {					  
					  pdf.save(title+'.pdf');
					  $("#Academia_V2_Header_Names").remove();
					  $("#Academia_V2_Header_Title").remove();
					  $("#Academia_V2_Footer").remove();
					  myMask.hide();
					},1000);
				},
				margins
			)*/

			setTimeout(function() {					  
				pdf.save(title+'.pdf');
				$("#ERP_HEADER_NAMES").remove();
				$("#ERP_COLUMN_GROUP").remove();
				//$("#Academia_V2_Header_Title").remove();
				//$("#Academia_V2_Footer").remove();
				myMask.hide();
			},1000);		
			return true;
		}
	}